package Magrathea::API::Abbreviation;

use strict;
use warnings;
use 5.10.0;

use parent qw{ Exporter };
use Text::Autoformat;
use Data::Dumper;

our @EXPORT_OK = qw{ abbreviate };

sub abbreviate($)
{
    my $check = shift;
    my $wanted = autoformat $check, {
        case => 'highlight'
    };
    $wanted =~ s/\s*$//;
    study $wanted;
    while (<DATA>) {
        chomp;
        s/#.*//;
        next if /^$/;
        my ($key, $val) = split /\t/;
        $wanted =~ s/\b$key\b/$val./g;
    }
    $wanted =~ s/\band\b/&/g;
    $wanted =~ s/\.\.$/./;
    return $wanted;
}




__DATA__
Academy	Acad
Anaesthetist	Anaesthst
Accessories	Acces
Analytical	Analyt
Accommodation	Accom
And	&
Account	Acct
Animal	Anml
Accountancy	Acctcy
Antiques	Antiq
Accountant	Acctnt
Apartments	Apts
Accumulators	Accumlrs
Apparatus	Appar
Actuary	Acty
Appliances	Appl
Acupuncture	Acupunc
Appointments	Appts
Adding	Addg
Architect	Archt
Addressing	Addsg
Architectural	Archtl
Adjutant	Ajd
Artificial	Artif
Administration	Admin
Artist	Art
Advertisement	Advt
Asbestos	Asb
Advertising	Advtg
Asphalt	Asph
Advocate	Advc
Assessor	Assr
Aeronautical	Aero
Assistant	Asst
Agency	Agcy
Associated	Assoc
Agents	Agt
Association	Assn
Agricultural	Agric
Assurance	Assnce
Agriculture	Agric
Auction	Auct
Aircraft	Aircft
Auctioneer	Auctnr
Alderman	Ald
Automatic	Autmtc
Aluminium	Almnm
Automobile	Auto
Amusements	Amsnts
Baker	Bkr
Book	Bk
Bakery	Bkry
Booking	Bkg
Bank	Bnk
Bookmaker	Bkmkr
Banker	Bnkr
Bottler	Botlr
Banking	Bnkg
Branch	Bch
Barber	Barb
Brass	Brss
Barracks	Brks
Breakdown	Brkdn
Barrel	Brl
Breaker	Break
Barrister-at-Law	Barrstr
Breeder(s)	Brdr(s)
Basket	Bskt
Brewer	Brew
Bearings	Brngs
Broker	Brok
Beater	Beatr
Bronze	Brnz
Billposter	Bilpstr
Builder	Bldr
Binder	Bndr
Building	Bldg
Blacksmith	Blksmth
Bureau	Bur
Blockmaker	Blckmkr
Business	Bsns
Board	Bd
Butcher	Btchr
Boarding	Bdg
Butter	Bttr
Boatbuilder	Btbldr
Button	Bttn
Boiler	Blr
Cabinet	Cabt
Clothier	Clothr
Cafeteria	Cfteria
Clothing	Clothg
Calculating	Calc
Coach	Cch
Canteen	Cantn
Collector	Collr
Caravan	Crvn
College	Coll
Cardboard	Cdbrd
Commercial	Comml
Carpenter	Cpntr
Commission	Commn
Carpet	Crpt
Commissioned	CD
Carriage	Carrge
Commissioner	Commr
Carrier	Carr
Company	Co
Cartage	Ctge
Component	Compnt
Carter	Cartr
Computer	Cmptr
Cartwright	Crtwrt
Conditioning	Cond
Caterer	Caterer
Confectioner	Confec
Catering	Catrng
Conference	Conf
Certified	Cert
Constructional	Constr
Chandler	Chdlr
Constructor	Constr
Chartered	Chrtd
Consultant	Conslt
Chartered Accountant	Chrtd Acctnt
Consulting	Consltg
Chemical	Chem
Continental Foods	Contl Fds
Chemist	Chemst
Contractor	Contr
Chief	Chf
Controller	Contrlr
Children's	Chldns
Convalescent	Convalct
Chimney Sweep	Chim Swp
Convent	Cnvt
Chiropodist	Chrpdst
Co-operative	Co-op
Chiropodist (State Registered)	Chrpdst (SR)
Copper	Cop
Chiropractor	Chiroprctr
Corporation	Corpn
Chocolate	Choc
Cosmetic	Cosm
Church	Ch
Costumier	Costum
Cigarette	Ciggte
Cotton	Cottn
Cinematograph	Cinemat
Council	Ccl
Civil	Civ
County	Co
Classified	Classfd
Court	Ct
Cleaners	Clnrs
Cycle	Cyc
Cleaning	Clng
Dairyman	Dairymn
Dispensory	Dispnsy
Dancing	Dncg
Distiller	Dstlr
Dealer	Dlr
Distillery	Dstly
Decorator	Dectr
Distribution	Distrib
Delivery	Dlvry
Distributor	Distrib
Demolition	Demol
District	Dist
Dental	Dent
Division	Div
Dentist	Dent
Doctor	Dr
Department	Dept
Do-it-yourself	D-I-Y
Deputy	Dep
Domestic	Dom
Designer	Desnr
Draper	Drpr
Detective	Detec
Draughtsman	Drghtsmn
Development	Dvlpmt
Dresser	Drsr
Diamond	Diamd
Dressmaker	Drsmkr
Director	Dir
Driving	Drvg
Discount	Dscnt
Drysalter	Drysltr
Dispensing	Dispng
Duplicating	Dup
Economical	Econ
Enquiry	Enq
Electric	Elec
Entertainments	Entrtnmts
Electrical	Elec
Equipment	Eqpt
Electrician	Elecn
Establishment	Estab
Electronic	Elecn
Estate	Est
Embroider	Embrdr
Examination	Exam
Employers	Emplyrs
Excavation	Excv
Employment	Emplymt
Export	Exp
Enamellers	Enamlrs
Exporter	Exptr
Engineer	Eng
Exporters	Exptrs
Engineering	Engng
Extension	Extn
Engraver	Engrvr
Fabricator	Fabctr
Footwear	Footwr
Factor	Fctr
Foreign	Fgn
Factory	Fcty
Forwarding	Fwrdg
Farmer	Frmr
Founder	Fndr
Fashion(s)	Fash(s)
Foundry	Fndy
Federation	Fed
Freezer	Frzr
Financier	Financr
Freight	Frght
Finisher	Fnshr
Frozen Food	Frzn Fd
Firewood	Firewd
Fruit	Frt
Fishmonger	Fishmgr
Fruiterer	Frtr
Fitter	Ftr
Funeral Director	Funrl Dir
Fittings	Ftngs
Furnished Rooms	Furn Rms
Flesher	Flshr
Furnisher	Furn
Flight	Flt
Furnishings	Furn
Floor Coverings	Flr Cvrngs
Furniture	Furn
Florist	Flor
Furrier	Furr
Gallery	Gall
Goods	Gds
Garage	Gar
Govenor	Gov
Garden	Gdn
Government	Govt
Gardener	Gdnr
Greengrocer	Grngrcr
General	Gen
Grocer	Grcr
Gentlemen's	Gents
Group	Gp
Girls	Grls
Grower	Grwr
Glass	Glss
Gynaelcologist	Gynaecol
Glazier	Glaz
Haberdasher	Hbdshr
Horticultural	Hortl
Hairdresser	Hrdrsr
Hosier	Hosr
Hairdressing	Hrdsg
Hosiery	Hosry
Hardware	Hdwre
Hospital	Hosp
Haulage	Hlge
Hostel	Hstl
Hauliers	Hlrs
Hotel	Htl
Head	Hd
House	Ho
Headquarters	Hdqrs
Household	Hsehld
Heating	Htg
Housing	Hsng
Hire Purchase	H.P
Hydraulic	Hydr
Hypermarket	Hypmkt
Ice Cream	Ice Cr
Installation	Instl
Implements	Implmts
Institute	Inst
Import	Impt
Institution	Instn
Importer	Imptr
Instructor	Instr
Importing	Imptg
Instrument	Instmt
Incorporated	Inc
Insurance	Ins
Industrial	Indust
Interior	Int
Infants	Inf
International	Internat
Infirmary	Infmy
Investment	Invest
Inspector	Insp
Iron	Irn
Jeweller	Jwlr
Journalist	Journ
Jewellery	Jwly
Junior	Jun
Joiner	Joinr
Justice of the Peace	J.P
Kitchen	Kitch
Knitwear	Knitwr
Knitting	Kntg
Laboratory	Lab
Lighter	Lightr
Launderer	Laund
Lighterage	Lightge
Laundrette	Laund
Lighting	Ltg
Laundry	Laund
Limited	Ltd
Lawyer	Lwyr
Linoleum	Lino
Leader	Ldr
Lithographer	Lthgphr
Leather	Lthr
Lithographic	Lthgphc
Library	Lib
Lithography	Lthgphy
Licensed	Licsd
Locomotive	Loco
Machine	Mach
Mercantile	Merc
Machinery	Mach
Merchandise	Merch
Mail Order	Mail Ord
Merchant	Mrcnt
Maintenance	Maintce
Metal	Mtl
Maker	Mkr
Metallurgist	Metallgst
Making	Mkg
Midwife	Midwfe
Management	Mngmt
Miller	Milr
Manager	Mgr
Milliner	Milnr
Mantles	Mntls
Millinery	Milny
Manufacturer	Mfr
Mineral	Min
Manufacturing	Mfg
Mixed	Mxd
Margarine	Margn
Modern	Mod
Market	Mkt
Monger	Mgr
Marketing	Mktg
Monumentall	Monmt
Mason	Masn
Mortgage	Mortg
Materials	Matls
Motor	Mtr
Mechanic	Mech
Municipal	Mun
Medical	Med
Museum	Musm
Medicine	Med
Music	Mus
Members	Mbrs
Musician	Musn
Menswear	Menswr
Mutual	Mutl
National	Nat
Novelties	Novlts
Neckwear	Nckwr
Nurse	Nrse
Needlework	Ndlwk
Nurseries	Nrsries
News	Nws
Nursery	Nrsry
Newsagent	Nwsagt
Nursing	Nrsg
Newspaper	Nwsppr
Obstetrician	Obstet
Operator	Opr
Occupational	Occpnl
Opthalmic	Ophthal
Off Licence	Off Lic
Optical	Optcl
Office	Off
Optician	Optcn
Officer	Offr
Ornamental	Ornmtl
Offices	Offs
Orthopaedic	Orthpdc
Operatic	Oprtc
Osteopath	Osteo
Operating	Optg
Outfitter	Outftr
Operation	Oprtn
Overseas	O/Seas
Packer	Pckr
Pottery	Pottry 
Painter	Pntr
Poulterer	Poultr
Painting	Pntg
Poultry	Poultr
Paper	Ppr
Practitioner	Pract
Parlour	Plr
Preparation	Prep
Parsonage	Prsnge
Presbytery	Prsbyty
Passenger	Pass
President	Pres
Patent	Pat
Primary	Primy
Pathology	Pathlgy
Printer	Prntr
Patternmaker	Ptrnmkr
Printing	Prntg
Pawnbroker	Pwnbrkr
Private	Prvt
Perfumer	Pfumr
Product	Prod
Permanent	Perm
Products	Prod
Pharmaceutical	Pharm
Professional	Profssnl
Photocopying	Photocpyg
Professor	Prof
Photographer	Photog
Property	Prpty
Photographic	Photog
Proprietor	Prop
Physician	Physn
Provision	Provn
Physiotherapist	Physthpst
Psychiatrist	Psychtr
Pianist	Pnst
Psychoanalyst	Psychan
Pianoforte	Piano
Psychologist	Psychol
Pilot	Plt
Public	Pblc
Plasterer	Plstr
Public Limited Company	plc
Plastering	Plstr
Publication	Pubn
Plastic	Plstc
Publicity	Pubcty
Plater	Platr
Publisher	Pubr
Plumber	Plmbr
Publishing	Pubg
Plumbing	Plmbg
Purchasing	Purch
Polisher	Polshr
Purveyor	Purvr
Quantity	Qty
Quarters	Qrs
Radiation	Radtn
Removing	Remov
Radiator	Radtr
Repairers	Rprs
Railway	Rly
Repairs	Rprs
Reception	Recptn
Repository	Repos
Reconditioned	Recond
Representatives	Reps
Recruitment	Recrutmt
Requisites	Reqs
Refiners	Refin
Research	Resch
Refreshments	Refresh
Residence	Res
Refrigeration	Refrig
Residents	Resdts
Regimental	Regtl
Restaurant	Rstnt
Regional	Regnl
Retail	Ret
Registered	Regd
Retailer	Retlr
Registrar	Regr
Roofing	Rfg
Registration	Regstrn
Rooms	Rms
Registry	Regy
Rubber	Rubr
Removals	Remov
Salesman	Slsmn
Specialist	Spclst
Salon	Sal
Saloon	Sal
Spinners	Spinrs
Sanitary	San
Spirits	Spir
Sawmill	Swmil
Sports	Spts
Scaffolding	Scffdg
Sprayers	Spray
Scenery	Sceny
Squadron	Sqn
School	Sch
Stables	Stabs
Scientific	Sci
Stamp	Stp
Sculptor	Sclptr
State Registered Nurse	S.R.N
Second Hand	Sec Hd
Station	Stn
Secondary	Sec
Stationer	Stnr
Secretary	Secy
Stationery	Stny
Sellers	Sellrs
Statistician	Statsn
Senior	Sen
Statistics	Stats
Service	Serv
Stevedores	Stevdrs
Sheet	Sht
Stock	Stk
Shipping	Shpg
Stockholder	Stkhldr
Shopfitter	Shopftr
Stockist	Stkst
Shorthand	Shthd
Storage	Strge
Showroom	Shwrm
Structural	Structl
Sign	Sgn
Sundries	Sunds
Silver	Silv
Superintendent	Supt
Silversmith	Silvsmth
Supermarket	Supmkt
Slater	Slatr
Supervisor	Supvr
Slaughterer	Slgtr
Supplies	Supps
Smallholder	Smlher
Surgeon	Surg
Society	Soc
Surgical	Surg
Solicitor	Solr
Surveyor	Survyr
Spares	Sprs
Sweets	Swts
Special	Spl
Tailor	Tlr
Ticket	Tkt
Tailoring	Tlrg
Timber	Timb
Teacher	Tchr
Tinplate	Tinpl
Technical	Tech
Tobacconist	Tbcnst
Technician	Tech
Tourist	Tour
Telecommunications	Telecom
Trading	Trdg
Telegraph	Teleg
Translator	Transl
Telephone	Tele
Transport	Transp
Television	TV
Travel	Trvl
Textile	Txtl
Typewriter	Typw
Theatre	Theat
Typewriting	Typwrg
Theatrical	Theat
Typsetters	Typstrs
Thermometer	Thermtr
Undertaker	Undtkr
Unfurnished	Unfurn
Underwriter	Undwtr
Upholsterer	Uphol
Valuer	Val
Veterinary Surgeon	Vet Surg
Vegetable	Veg
Violinist	Vlnst
Vehicle	Vhcle
Visitor	Vstr
Vendor	Vdr
Vocalist	Voclst
Ventilating	Ventlg
Voluntary	Vol
Wallpaper	Wlppr
Wholesale	Whsle
Ware	Wre
Wholesaler	Whslr
Warehouse	Wreho
Window	Wndw
Watch	Wtch
Women's	Wmns
Watchmakers	Wtchmkrs
Woodworkers	Wdwkrs
Weaver	Weav
Workers	Wkrs
Welder	Wldr
Works	Wks
Welding	Wldg
Workshops	Wkshps
Wharf	Whf
Worsted	Wrstd
Wharfingers	Whfgrs
Wrecker	Wrckr
Wheelwright	Whlwrt
Writer	Wtr
Yard	Yd
Zinc	Zn

# vim: set ts=35 :
