# $Id: Repeat_Unit.pm 10525 2006-09-26 22:03:22Z sendu $
#
# bioperl module for Bio::LiveSeq::Repeat_Unit
#
# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>
#
# Copyright Joseph Insana
#
# You may distribute this module under the same terms as perl itself
#
# POD documentation - main docs before the code

=head1 NAME

Bio::LiveSeq::Repeat_Unit - Repeat_Unit class for LiveSeq

=head1 SYNOPSIS

  # documentation needed

=head1 DESCRIPTION

Class for REPEAT_UNIT objects. They consist of a beginlabel, an endlabel (both
referring to a LiveSeq DNA object) and a strand.
The strand could be 1 (forward strand, default), -1 (reverse strand).

=head1 AUTHOR - Joseph A.L. Insana

Email:  Insana@ebi.ac.uk, jinsana@gmx.net

=head1 APPENDIX

The rest of the documentation details each of the object
methods. Internal methods are usually preceded with a _

=cut

# Let the code begin...

package Bio::LiveSeq::Repeat_Unit;

use strict;
use base qw(Bio::LiveSeq::Repeat_Region);

=head2 new

  Title   : new
  Usage   : $intron1=Bio::LiveSeq::Repeat_Unit->new(-seq => $objref,
					      -start => $startlabel,
					      -end => $endlabel, -strand => 1);

  Function: generates a new Bio::LiveSeq::Repeat_Unit
  Returns : reference to a new object of class Repeat_Unit
  Errorcode -1
  Args    : two labels and an integer

=cut

1;
