#!perl -T
use 5.006;

use strict;
use warnings;

use Statistics::Covid::Datum::IO;
use Statistics::Covid::Analysis::Plot;
use Test::More;
use File::Basename;
use File::Spec;

my $dirname = dirname(__FILE__);

my $num_tests = 0;

my $configfile = 't/example-config.json';
my $io = Statistics::Covid::Datum::IO->new({
	'config-file' => $configfile,
	'debug' => 0,
}) or die "Statistics::Covid::Datum::IO() failed.";
if( ! $io->db_connect() ){ die "failed to connect to db" }

my $objs = $io->db_select({
	conditions => {belongsto=>'UK', name=>{'like' => 'Ha%'}}
});
ok(defined($objs)&&(scalar(@$objs)>0), "db_select() called."); $num_tests++;

my $outfile = 'chartclicker.png';
my $ret = Statistics::Covid::Analysis::Plot::plot_with_chartclicker({
	'datum-objs' => $objs,
	'outfile' => $outfile,
	'Y' => 'confirmed',
	'GroupBy' => ['name']
});
ok(defined($ret), "Statistics::Covid::Analysis::Plot::plot_with_chartclicker() called"); $num_tests++;
ok(-f $outfile, "output image '$outfile'."); $num_tests++;

$outfile = 'gd.png';
$ret = Statistics::Covid::Analysis::Plot::plot_with_gd({
	'datum-objs' => $objs,
	'outfile' => $outfile,
});
ok(defined($ret), "Statistics::Covid::Analysis::Plot::plot_with_gd() called"); $num_tests++;
ok(-f $outfile, "output image '$outfile'."); $num_tests++;

#Statistics::Covid::Analysis::Plot::testplot(); exit(0);
#my $plot = Statistics::Covid::Analysis::Plot::plot({
#	'datum-objs' => $objs,
#	'outfile' => 'aa.jpg'
#});
#ok(defined($plot), "Statistics::Covid::Analysis::Plot::plot() called"); $num_tests++;

done_testing($num_tests);
