use Test::More;

use Data::Bvec qw( set_bit bit2str );

POD: {
    my $vec = "";  # empty vector

    set_bit $vec, 1, 1; # 01000000
    set_bit $vec, 2, 1; # 01100000
    set_bit $vec, 3;    # 01110000
    set_bit $vec, 1, 0; # 00110000

is( bit2str( $vec ), '00110000', 'set_bit POD' );

}

{

    my $vec = "";
    my @tvals;

    @tvals = qw( 
        10000000
        11000000
        11100000
        11110000
        11111000
        11111100
        11111110
        11111111
    );
    for( 0 .. 7 ) {
        set_bit $vec, $_;
        is( bit2str( $vec ), $tvals[ $_ ], "set_bit( \$vec, $_ )" );
    }
    @tvals = qw( 
        01111111
        00111111
        00011111
        00001111
        00000111
        00000011
        00000001
        00000000
    );
    for( 0 .. 7 ) {
        set_bit $vec, $_, 0;
        is( bit2str( $vec ), $tvals[ $_ ], "set_bit( \$vec, $_, 0 )" );
    }

}

{

    my $vec = "";
    my @tvals;

    @tvals = qw( 
        10000000
        10010000
        10010010
        1001001001000000
        1001001001001000
        1001001001001001
        100100100100100100100000
        100100100100100100100100
        10010010010010010010010010000000
        10010010010010010010010010010000
        10010010010010010010010010010010
        1001001001001001001001001001001001000000
        1001001001001001001001001001001001001000
        1001001001001001001001001001001001001001
    );# 0----+----1----+----2----+----3----+----
    for( 0 .. 13 ) {
        my $i = $_ * 3;
        set_bit $vec, $i, 1;
        is( bit2str( $vec ), $tvals[ $_ ], "set_bit( \$vec, $i, 1 )" );
    }
    @tvals = qw( 
        0001001001001001001001001001001001001001
        0000001001001001001001001001001001001001
        0000000001001001001001001001001001001001
        0000000000001001001001001001001001001001
        0000000000000001001001001001001001001001
        0000000000000000001001001001001001001001
        0000000000000000000001001001001001001001
        0000000000000000000000001001001001001001
        0000000000000000000000000001001001001001
        0000000000000000000000000000001001001001
        0000000000000000000000000000000001001001
        0000000000000000000000000000000000001001
        0000000000000000000000000000000000000001
        0000000000000000000000000000000000000000
    );
    for( 0 .. 13 ) {
        my $i = $_ * 3;
        set_bit $vec, $i, 0;
        is( bit2str( $vec ), $tvals[ $_ ], "set_bit( \$vec, $i, 0 )" );
    }
}

use Test::More tests => 45;
