package Venus::Undef;

use 5.014;

use strict;
use warnings;

use Moo;

extends 'Venus::Kind::Value';

no overloading;

# BUILDERS

sub build_self {
  my ($self, $data) = @_;

  $self->{value} = undef;

  return $self;
}

# METHODS

sub default {
  return undef;
}

1;



=head1 NAME

Venus::Undef - Undef Class

=cut

=head1 ABSTRACT

Undef Class for Perl 5

=cut

=head1 SYNOPSIS

  package main;

  use Venus::Undef;

  my $undef = Venus::Undef->new;

  # $undef->defined;

=cut

=head1 DESCRIPTION

This package provides methods for manipulating undef data.

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Venus::Kind::Value>

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 default

  default() (Undef)

The default method returns the default value, i.e. C<undef>.

I<Since C<0.01>>

=over 4

=item default example 1

  # given: synopsis;

  my $default = $undef->default;

  # undef

=back

=cut

=head1 AUTHORS

Cpanery, C<cpanery@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2021, Cpanery

Read the L<"license"|https://github.com/cpanery/venus/blob/master/LICENSE> file.

=cut