#!/usr/bin/perl
#
# Data-Rlist.t
#
# Before `make install' is performed this script should be runnable with `make
# test'. After `make install' it should work as `perl Data-Rlist.t'
#
# $Writestamp: 2007-12-07 19:26:22 eh2sper$
# $Compile: perl -M'constant standalone => 1' Data-Rlist.t$

use warnings;
use strict;
use constant file_IO => 2;
use constant quote_and_escape => 19;
use constant beyond_the_means => 9;
use Test;
BEGIN { plan tests => 3 + file_IO + quote_and_escape + beyond_the_means, todo => [ ] };
BEGIN { unshift @INC, '../lib' if $constant::declared{'main::standalone'} }

use Data::Rlist;

use Env qw/HOME/;

ok(eval { require Data::Rlist; });
ok($Data::Rlist::VERSION =~ /^\d+\.\d+$/);
ok(1);							# module loaded OK

########################
# Split/parse quoted, deep-comparison.
#
if (quote_and_escape) {
	my($i);
	use Data::Rlist qw/:strings deep_compare/;

	ok(is_value($_)) foreach qw/0 foo 3.14/;

	ok(quote(undef) eq '""');
	ok(quote(0) eq quote("0"));		   # ...dto
	ok(quote('"0"') eq qq'"\\"0\\""'); # ...but this is different
	ok(quote("'0'") eq qq("\\'0\\'"));
	ok(escape("\\") eq "\\\\\\374");	# \\\374
	ok(unescape("\\\\\\374") eq "\\");

	ok(exists Data::Rlist::read_string('5')->{5});
	ok(exists Data::Rlist::read_string(42)->{"42"});

	sub split_and_list($) { print $i++, " '$_'\n" foreach split_quoted(shift) }
	sub parse_and_list($) { print $i++, " '$_'\n" foreach parse_quoted(shift) }

	ok($#{[split_quoted(q'"\n')]} == -1);
	ok($#{[split_quoted(q'foo"bar')]} == -1);
	ok($#{[parse_quoted(q'foo"bar')]} == -1); # defect quoted input shall return the empty list

	ok(!deep_compare([split_quoted("   foo ")], ['', 'foo', '']));
	ok(!deep_compare([split_quoted("fee fie foo")], ['fee', 'fie', 'foo']));
	ok(!deep_compare(parse_quoted('"fee fie foo"'), 1));

	ok(!Data::Rlist::deep_compare(undef, undef) &&
	    Data::Rlist::deep_compare(undef, 1));

	ok(quote(undef) eq '""' &&
	   quote("") eq '""' &&
	   quote('') eq '""' &&
	   quote(0) eq '"0"' && # Quoting scalar 0 is the same as...
	   quote("0") eq '"0"' && # ...quoting "0", because quote() converts them
                              # to strings. Therefore a scalar hosting "0" is
                              # NOT implicited quoted when compiled, because it
                              # looks like a number.
	   1);
}

#########################
# Construction, file I/O.
#
if (file_IO) {
	my $thing;
	my $obj1 = new Data::Rlist(-input => $constant::declared{'main::standalone'} ? 'test1.rls' : 't/test1.rls');
	my $obj2 = new Data::Rlist(-input => $constant::declared{'main::standalone'} ? 'test2.rls' : 't/test1.rls');
	my $test1file = $obj1->read;
	my $test2file = $obj2->read;
	#$Data::Rlist::DEBUG = 1;
	ok(defined $test1file);
	ok(defined $test2file);
}

#########################
# If we made it this far, we're ok.
#
# The rest will be "What You Ever Wanted to Know about Perl . . . But Were
# Afraid to Ask."  Like, is 42... really true? Is (undef) false?  Why is ".0"
# true?  What is the meaning of light? Is my home still there when I'm not at
# home?
#
if (beyond_the_means) {
	my @x;
	ok((@x = (undef)) && (@x = (undef, undef)));

	ok(!(@x = ()));
	ok(!"" && !'' && !.0 && !0. && !"0" && !.0);
	ok(0.==.0);					# Yet another lexical gimmick.
	ok(!.0 && ".0"); # Perl thinks this is true. Isn't this inconsistent with
                     # IEEE 754? IMHO, considering that ok(0.==.0), shouldn't
                     # it ok(!.0 && !".0")?  I'm relieved to see, however, that
                     # ok("0.").
	ok($#{[Cogito => ergo => 'sum']} == 2);
	ok(42);
	ok(QED=>);

	ok("\n\n\n" =~ /\n.+\n$/s);
}

#########################

### Local Variables:
### buffer-file-coding-system: iso-latin-1
### End:
