package main;
use Evo::Base -strict;
use Promises6 'deferred';
use Test::More;
use Promises6::Util ':const';

my $bldr     = Promises6::Builder->singleton;
my $deferred = $bldr->deferred;

my $thenable = Thenable->new;
$deferred->resolve($thenable);
is $deferred->state, FULFILLED;
$deferred->resolve($thenable);
is $deferred->state, FULFILLED;
is $bldr->resolver->thenables($deferred)->{$thenable}, 2;

done_testing;


# thenables thet eventually cause circular recursion
{

  package Thenable;
  use Evo::Base -base;
  sub then { $_[1]->('ok') }

}

