
use Config;
use Devel::CheckLib;

my $use_system_ffi = check_lib(lib => "ffi", header => "ffi.h");

sub MY::postamble {
  if ($^O eq 'MSWin32') {
    return "\t$^X -MAlien::MSYS=msys_run -Minc::MSYSConfigure -e \"configure(); msys_run 'make'\"\n\n";
  }

  return if $use_system_ffi;

  return <<'MAKE_LIBFFI';
$(MYEXTLIB):
	cd xs/libffi && ./configure MAKEINFO=true --disable-builddir --with-pic && $(MAKE)

.NOTPARALLEL:

MAKE_LIBFFI
}

# This Makefile.PL for FFI-Raw was generated by
# inc::MakeMaker <self>.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl bindings to the portable FFI library (libffi)",
  "AUTHOR" => "Alessandro Ghedini <alexbio\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckLib" => 0,
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "FFI-Raw",
  "EXE_FILES" => [],
  "INC" => "-I. -Ixs -Ixs/libffi/include",
  "LICENSE" => "perl",
  "MYEXTLIB" => "xs/libffi/.libs/libffi.a",
  "NAME" => "FFI::Raw",
  "OBJECT" => "\$(O_FILES) xs/libffi/.libs/libffi.a",
  "PREREQ_PM" => {
    "XSLoader" => 0,
    "overload" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::CBuilder" => 0,
    "File::Spec" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Math::BigInt" => 0,
    "POSIX" => 0,
    "Test::More" => 0,
    "Text::ParseWords" => 0,
    "base" => 0,
    "bigint" => 0,
    "lib" => 0
  },
  "VERSION" => "0.26",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my @libs;

if ($^O eq 'MSWin32' && $Config{cc} =~ /cl(\.exe)?$/) {
  for (@WriteMakefileArgs{'MYEXTLIB','OBJECT'}) {
    s/libffi.a/libffi.lib/;
  }

  $WriteMakefileArgs{CCFLAGS}   = "$Config{ccflags} -DFFI_BUILDING",
  $WriteMakefileArgs{LDDLFLAGS} = "$Config{lddlflags} psapi.lib";

} elsif ($^O =~ /^(MSWin32|cygwin)$/) {
  push @libs, '-L/usr/lib/w32api' if ($^O eq 'cygwin');
  push @libs, '-lpsapi';
}

if ($^O eq 'openbsd' && !$Config{usethreads}) {
  $WriteMakefileArgs{MYEXTLIB} .= ' /usr/lib/libpthread.a';
}

if ($use_system_ffi) {
  $WriteMakefileArgs{OBJECT} = '$(O_FILES)';
  push @libs, '-lffi';
  delete $WriteMakefileArgs{MYEXTLIB};
}

$WriteMakefileArgs{LIBS} = "@libs" if @libs;



unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ( $^O eq 'MSWin32' ) {
	$WriteMakefileArgs{PREREQ_PM}{'Alien::MSYS'} = '0';
}

WriteMakefile(%WriteMakefileArgs);



