package JIRA::API::JiraExpressionEvalContextBean 0.01;
# DO NOT EDIT! This is an autogenerated file.
use 5.020;
use Moo 2;
use experimental 'signatures';
use Types::Standard qw(Str Bool Num Int Object ArrayRef);
use MooX::TypeTiny;

=head1 NAME

JIRA::API::JiraExpressionEvalContextBean -

=head1 SYNOPSIS

  my $obj = JIRA::API::JiraExpressionEvalContextBean->new();
  ...

=cut

sub as_hash( $self ) {
    return { $self->%* }
}

=head1 PROPERTIES

=head2 C<< board >>

The ID of the board that is available under the `board` variable when evaluating the expression.

=cut

has 'board' => (
    is       => 'ro',
    isa      => Int,
);

=head2 C<< custom >>

Custom context variables and their types. These variable types are available for use in a custom context:

 *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.
 *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.
 *  `json`: A JSON object containing custom content.
 *  `list`: A JSON list of `user`, `issue`, or `json` variable types.

=cut

has 'custom' => (
    is       => 'ro',
    isa      => ArrayRef[Object],
);

=head2 C<< customerRequest >>

The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.

=cut

has 'customerRequest' => (
    is       => 'ro',
    isa      => Int,
);

=head2 C<< issue >>

The issue that is available under the `issue` variable when evaluating the expression.

=cut

has 'issue' => (
    is       => 'ro',
);

=head2 C<< issues >>

The collection of issues that is available under the `issues` variable when evaluating the expression.

=cut

has 'issues' => (
    is       => 'ro',
);

=head2 C<< project >>

The project that is available under the `project` variable when evaluating the expression.

=cut

has 'project' => (
    is       => 'ro',
);

=head2 C<< serviceDesk >>

The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.

=cut

has 'serviceDesk' => (
    is       => 'ro',
    isa      => Int,
);

=head2 C<< sprint >>

The ID of the sprint that is available under the `sprint` variable when evaluating the expression.

=cut

has 'sprint' => (
    is       => 'ro',
    isa      => Int,
);


1;
