// This may look like C code, but it is really -*- C++ -*-
//
// Copyright 1993 by Peter Bentley <pete@tecc.co.uk>
//
// Permission to use, copy, modify, distribute, and sell this software and its
// documentation for any purpose is hereby granted without fee, provided that
// the above copyright notice appear in all copies and that both that
// copyright notice and this permission notice appear in supporting
// documentation, and that the name of Peter Bentley not be used in
// advertising or publicity pertaining to distribution of the software without
// specific, written prior permission.  Peter Bentley makes no representations
// about the suitability of this software for any purpose.  It is provided
// "as is" without express or implied warranty.
//
// PETER BENTLEY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
// INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
// EVENT SHALL PETER BENTLEY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.
//
// Pstring.h - a couple of inline C++ string functions that I find useful
//
// $Id: pstring.h,v 1.1 1993/09/02 12:33:58 pete Exp pete $
//


// Inline version of strdup that uses C++ new/delete

inline char *strpdup(const char *s) {
	if (s == NULL) return NULL;
	char *n = new char[strlen(s) + 1];
	if (n != NULL) strcpy(n, s);
	return n;
}

// C++ (NULL pointer safe) strncpy()
inline char *strpncpy(char *dest, const char *src, int n) {
	if (src == NULL) {
		dest[0] = '\0';
	}
	else {
		strncpy(dest, src, n);
		dest[n] = '\0';
	}
	return dest;
}

#ifndef strerror		// C'mon Borland. Why don't you have a strerror()?
extern char *sys_errlist[];
#define strerror(n) (sys_errlist[n])
#endif

