'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: tclvars.n,v 1.1.2.3 1999/03/25 22:03:45 redman Exp $
'\" 
.so man.macros
.TH tclvars n 8.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tclvars \- Variables used by Tcl
.BE

.SH DESCRIPTION
.PP
The following global variables are created and managed automatically
by the Tcl library.  Except where noted below, these variables should
normally be treated as read-only by application-specific code and by users.
.TP
\fBenv\fR
This variable is maintained by Tcl as an array
whose elements are the environment variables for the process.
Reading an element will return the value of the corresponding
environment variable.
Setting an element of the array will modify the corresponding
environment variable or create a new one if it doesn't already
exist.
Unsetting an element of \fBenv\fR will remove the corresponding
environment variable.
Changes to the \fBenv\fR array will affect the environment
passed to children by commands like \fBexec\fR.
If the entire \fBenv\fR array is unset then Tcl will stop
monitoring \fBenv\fR accesses and will not update environment
variables.
.RS
.VS 8.0 
Under Windows, the environment variables PATH and COMSPEC in any
capitalization are converted automatically to upper case.  For instance, the
PATH variable could be exported by the operating system as ``path'',
``Path'', ``PaTh'', etc., causing otherwise simple Tcl code to have to
support many special cases.  All other environment variables inherited by
Tcl are left unmodified.
.VE
.RE
.RS
On the Macintosh, the environment variable is constructed by Tcl as no
global environment variable exists.  The environment variables that
are created for Tcl include:
.TP
\fBLOGIN\fR
This holds the Chooser name of the Macintosh.
.TP
\fBUSER\fR
This also holds the Chooser name of the Macintosh.
.TP
\fBSYS_FOLDER\fR
The path to the system directory.
.TP
\fBAPPLE_M_FOLDER\fR
The path to the Apple Menu directory.
.TP
\fBCP_FOLDER\fR
The path to the control panels directory.
.TP
\fBDESK_FOLDER\fR
The path to the desk top directory.
.TP
\fBEXT_FOLDER\fR
The path to the system extensions directory.
.TP
\fBPREF_FOLDER\fR
The path to the preferences directory.
.TP
\fBPRINT_MON_FOLDER\fR
The path to the print monitor directory.
.TP
\fBSHARED_TRASH_FOLDER\fR
The path to the network trash directory.
.TP
\fBTRASH_FOLDER\fR
The path to the trash directory.
.TP
\fBSTART_UP_FOLDER\fR
The path to the start up directory.
.TP
\fBPWD\fR
The path to the application's default directory.
.PP
You can also create your own environment variables for the Macintosh.
A file named  \fITcl Environment Variables\fR may be placed in the
preferences folder in the Mac system folder.  Each line of this file
should be of the form \fIVAR_NAME=var_data\fR.
.PP
The last alternative is to place environment variables in a 'STR#' 
resource named \fITcl Environment Variables\fR of the application.  This
is considered a little more ``Mac like'' than a Unix style Environment
Variable file.  Each entry in the 'STR#' resource has the same format
as above.  The source code file \fItclMacEnv.c\fR contains the
implementation of the env mechanisms.  This file contains many
#define's that allow customization of the env mechanisms to fit your
applications needs.
.RE
.TP
\fBerrorCode\fR
After an error has occurred, this variable will be set to hold
additional information about the error in a form that is easy
to process with programs.
\fBerrorCode\fR consists of a Tcl list with one or more elements.
The first element of the list identifies a general class of
errors, and determines the format of the rest of the list.
The following formats for \fBerrorCode\fR are used by the
Tcl core; individual applications may define additional formats.
.RS
.TP
\fBARITH\fI code msg\fR
This format is used when an arithmetic error occurs (e.g. an attempt
to divide by zero in the \fBexpr\fR command).
\fICode\fR identifies the precise error and \fImsg\fR provides a
human-readable description of the error.  \fICode\fR will be either
DIVZERO (for an attempt to divide by zero),
DOMAIN (if an argument is outside the domain of a function, such as acos(\-3)),
IOVERFLOW (for integer overflow),
OVERFLOW (for a floating-point overflow),
or UNKNOWN (if the cause of the error cannot be determined).
.TP
\fBCHILDKILLED\fI pid sigName msg\fR
This format is used when a child process has been killed because of
a signal.  The second element of \fBerrorCode\fR will be the
process's identifier (in decimal).
The third element will be the symbolic name of the signal that caused
the process to terminate; it will be one of the names from the
include file signal.h, such as \fBSIGPIPE\fR.
The fourth element will be a short human-readable message
describing the signal, such as ``write on pipe with no readers''
for \fBSIGPIPE\fR.
.TP
\fBCHILDSTATUS\fI pid code\fR
This format is used when a child process has exited with a non-zero
exit status.  The second element of \fBerrorCode\fR will be the
process's identifier (in decimal) and the third element will be the exit
code returned by the process (also in decimal).
.TP
\fBCHILDSUSP\fI pid sigName msg\fR
This format is used when a child process has been suspended because
of a signal.
The second element of \fBerrorCode\fR will be the process's identifier,
in decimal.
The third element will be the symbolic name of the signal that caused
the process to suspend; this will be one of the names from the
include file signal.h, such as \fBSIGTTIN\fR.
The fourth element will be a short human-readable message
describing the signal, such as ``background tty read''
for \fBSIGTTIN\fR.
.TP
\fBNONE\fR
This format is used for errors where no additional information is
available for an error besides the message returned with the
error.  In these cases \fBerrorCode\fR will consist of a list
containing a single element whose contents are \fBNONE\fR.
.TP
\fBPOSIX \fIerrName msg\fR
If the first element of \fBerrorCode\fR is \fBPOSIX\fR, then
the error occurred during a POSIX kernel call.
The second element of the list will contain the symbolic name
of the error that occurred, such as \fBENOENT\fR; this will
be one of the values defined in the include file errno.h.
The third element of the list will be a human-readable
message corresponding to \fIerrName\fR, such as
``no such file or directory'' for the \fBENOENT\fR case.
.PP
To set \fBerrorCode\fR, applications should use library
procedures such as \fBTcl_SetErrorCode\fR and \fBTcl_PosixError\fR,
or they may invoke the \fBerror\fR command.
If one of these methods hasn't been used, then the Tcl
interpreter will reset the variable to \fBNONE\fR after
the next error.
.RE
.TP
\fBerrorInfo\fR
After an error has occurred, this string will contain one or more lines
identifying the Tcl commands and procedures that were being executed
when the most recent error occurred.
Its contents take the form of a stack trace showing the various
nested Tcl commands that had been invoked at the time of the error.
.TP
\fBtcl_library\fR
This variable holds the name of a directory containing the
system library of Tcl scripts, such as those used for auto-loading.
The value of this variable is returned by the \fBinfo library\fR command.
See the \fBlibrary\fR manual entry for details of the facilities 
provided by the Tcl script library.
Normally each application or package will have its own application-specific
script library in addition to the Tcl script library;
each application should set a global variable with a name like
\fB$\fIapp\fB_library\fR (where \fIapp\fR is the application's name)
to hold the network file name for that application's library directory.
The initial value of \fBtcl_library\fR is set when an interpreter
is created by searching several different directories until one is
found that contains an appropriate Tcl startup script.
If the \fBTCL_LIBRARY\fR environment variable exists, then
the directory it names is checked first.
If \fBTCL_LIBRARY\fR isn't set or doesn't refer to an appropriate
directory, then Tcl checks several other directories based on a
compiled-in default location, the location of the binary containing
the application, and the current working directory.
.TP
\fBtcl_patchLevel\fR
When an interpreter is created Tcl initializes this variable to
hold a string giving the current patch level for Tcl, such as
\fB7.3p2\fR for Tcl 7.3 with the first two official patches, or
\fB7.4b4\fR for the fourth beta release of Tcl 7.4.
The value of this variable is returned by the \fBinfo patchlevel\fR
command.
.VS 8.0 br
.TP
\fBtcl_pkgPath\fR
This variable holds a list of directories indicating where packages are
normally installed.  It typically contains either one or two entries; 
if it contains two entries, the first is normally a directory for
platform-dependent packages (e.g., shared library binaries) and the
second is normally a directory for platform-independent packages (e.g.,
script files). Typically a package is installed as a subdirectory of one
of the entries in \fB$tcl_pkgPath\fR. The directories in
\fB$tcl_pkgPath\fR are included by default in the \fBauto_path\fR
variable, so they and their immediate subdirectories are automatically
searched for packages during \fBpackage require\fR commands.  Note:
\fBtcl_pkgPath\fR it not intended to be modified by the application.
Its value is added to \fBauto_path\fR at startup; changes to
\fBtcl_pkgPath\fR are not reflected in \fBauto_path\fR.  If you
want Tcl to search additional directories for packages you should add
the names of those directories to \fBauto_path\fR, not \fBtcl_pkgPath\fR.
.VE
.TP
\fBtcl_platform\fR
This is an associative array whose elements contain information about
the platform on which the application is running, such as the name of
the operating system, its current release number, and the machine's
instruction set.  The elements listed below will always
be defined, but they may have empty strings as values if Tcl couldn't
retrieve any relevant information.  In addition, extensions
and applications may add additional values to the array.  The
predefined elements are:
.RS
.VS
.TP
\fBbyteOrder\fR
The native byte order of this machine: either \fBlittleEndian\fR or
\fBbigEndian\fR. 
.VE
.TP
\fBmachine\fR
The instruction set executed by this machine, such as
\fBintel\fR, \fBPPC\fR, \fB68k\fR, or \fBsun4m\fR.  On UNIX machines, this
is the value returned by \fBuname -m\fR.
.TP
\fBos\fR 
The name of the operating system running on this machine,
such as \fBWindows 95\fR, \fBWindows NT\fR, \fBMacOS\fR, or \fBSunOS\fR.
On UNIX machines, this is the value returned by \fBuname -s\fR.
On Windows 95 and Windows 98, the value returned will be \fBWindows
95\fR to provide better backwards compatibility to Windows 95; to
distinguish between the two, check the \fBosVersion\fR.
.TP
\fBosVersion\fR
The version number for the operating system running on this machine.
On UNIX machines, this is the value returned by \fBuname -r\fR.  On
Windows 95, the version will be 4.0; on Windows 98, the version will
be 4.10.
.TP
\fBplatform\fR
Either \fBwindows\fR, \fBmacintosh\fR, or \fBunix\fR.  This identifies the
general operating environment of the machine.
.TP
\fBuser\fR
Either \fBwindows\fR, \fBmacintosh\fR, or \fBunix\fR.  This identifies the
current user based on the login information available on the platform.
This comes from the USER or LOGNAME environment variable on Unix,
and the value from GetUserName on Windows and Macintosh.
.RE
.TP
\fBtcl_precision\fR
.VS
This variable controls the number of digits to generate
when converting floating-point values to strings.  It defaults
to 12.
17 digits is ``perfect'' for IEEE floating-point in that it allows
double-precision values to be converted to strings and back to
binary with no loss of information.  However, using 17 digits prevents
any rounding, which produces longer, less intuitive results.  For example,
\fBexpr 1.4\fR returns 1.3999999999999999 with \fBtcl_precision\fR
set to 17, vs. 1.4 if \fBtcl_precision\fR is 12.
.RS
All interpreters in a process share a single \fBtcl_precision\fR value:
changing it in one interpreter will affect all other interpreters as
well.  However, safe interpreters are not allowed to modify the
variable.
.RE
.VE
.TP
\fBtcl_rcFileName\fR
This variable is used during initialization to indicate the name of a
user-specific startup file.  If it is set by application-specific
initialization, then the Tcl startup code will check for the existence
of this file and \fBsource\fR it if it exists.  For example, for \fBwish\fR
the variable is set to \fB~/.wishrc\fR for Unix and \fB~/wishrc.tcl\fR
for Windows.
.TP
\fBtcl_rcRsrcName\fR
This variable is only used on Macintosh systems.  The variable is used
during initialization to indicate the name of a user-specific
\fBTEXT\fR resource located in the application or extension resource
forks.  If it is set by application-specific initialization, then the
Tcl startup code will check for the existence of this resource and
\fBsource\fR it if it exists.  For example, the Macintosh \fBwish\fR
application has the variable is set to \fBtclshrc\fR.
.TP
\fBtcl_traceCompile\fR
The value of this variable can be set to control
how much tracing information
is displayed during bytecode compilation.
By default, tcl_traceCompile is zero and no information is displayed.
Setting tcl_traceCompile to 1 generates a one line summary in stdout
whenever a procedure or top level command is compiled.
Setting it to 2 generates a detailed listing in stdout of the
bytecode instructions emitted during every compilation.
This variable is useful in
tracking down suspected problems with the Tcl compiler.
It is also occasionally useful when converting
existing code to use Tcl8.0.
.TP
\fBtcl_traceExec\fR
The value of this variable can be set to control
how much tracing information
is displayed during bytecode execution.
By default, tcl_traceExec is zero and no information is displayed.
Setting tcl_traceExec to 1 generates a one line trace in stdout
on each call to a Tcl procedure.
Setting it to 2 generates a line of output
whenever any Tcl command is invoked
that contains the name of the command and its arguments.
Setting it to 3 produces a detailed trace showing the result of
executing each bytecode instruction.
Note that when tcl_traceExec is 2 or 3,
commands such as set and incr
that have been entirely replaced by a sequence
of bytecode instructions are not shown.
Setting this variable is useful in
tracking down suspected problems with the bytecode compiler
and interpreter.
It is also occasionally useful when converting
code to use Tcl8.0.
.TP
\fBtcl_version\fR
When an interpreter is created Tcl initializes this variable to
hold the version number for this version of Tcl in the form \fIx.y\fR.
Changes to \fIx\fR represent major changes with probable
incompatibilities and changes to \fIy\fR represent small enhancements and
bug fixes that retain backward compatibility.
The value of this variable is returned by the \fBinfo tclversion\fR
command.

.SH KEYWORDS
arithmetic, bytecode, compiler, error, environment, POSIX, precision, subprocess, variables
