extern "C"{
#include <tk.h>
#include <tcl.h>
}

//
//	Class name : Tcl_Object
//
//	Description : Baseclass for all objects that shall have a
//                    tcl interpreter which in turn will read and
//                    execute a tcl-file, e.g. describing the
//                    graphical interface for this class.
//
//      Author      : Stephan Herrmann (stephan@cs.tu-berlin.de)


// Macro for embedding a C++ member function into a plain C-function:

#define _CMD_Embedding(c_class_type,c_func,member_func)		  \
int c_func (ClientData clientData,Tcl_Interp *interp,		  \
	    int argc,char *argv[]){				  \
	    if(interp==NULL);                                     \
	    ((c_class_type *)clientData)->result=0;               \
	    ((c_class_type *)clientData)->set_args(argc,argv);    \
	    ((c_class_type *)clientData)->member_func();          \
	    return(((c_class_type *)clientData)->result);         \
}

// This needs to be called chaining the args of main() to tcl:

void set_gargs (int argc, char *argv[]);

static int main_loop_active = 0;

#define NON_MODAL 0
#define WAITING 1
#define MODAL 2

//
// The actual class-defintion:
//

class Tcl_Object {

public:
	Tcl_Object ();

virtual	~Tcl_Object();

// this will execute the associated tcl script:
        void execute();

	int result;            // store the result a C++ func shall pass to tcl

        int mode;
  
        void set_mode(int m);

        void close();

	void set_args(int c, char ** v){
	  argc=c;argv=v;
	};

protected:

// attributs:
	Tcl_Interp *interp;     /* Interpreter for this object. */
	Tk_Window w;	        /* The main window for this object. */
	char *window_name;
	char *display;
        int argc;               // store the args passed from tcl to C++
        char ** argv;

// routines:

// Install 'proc' as a tcl-command under the name 'tcl_name':
	void CreateCommand (char *tcl_name, Tcl_CmdProc proc);
	
// The next four are just for convenience simplifying the data transfer
// to and from tcl:
	int   Tcl_GetIntVar (char *name);

	char *Tcl_GetStrVar (char *name);

        void  Tcl_SetIntVar (char *name, int wert);

        void  Tcl_SetStrVar (char *name, char *wert);
	 
// Init: needs to be called by the constructors of all descendents!
	void  init_interp();

// Redefine this in every derived class to specify the filename of
// the tcl file to be executed.
	virtual char *get_filename();

// You may redefine this in order to set different window names
// depending on your class and/or instance :
	virtual char *get_window_name();
	
}; // class Tcl_Object





