proc xgpl_FunctionPad { } {
  global Xgpl Desktop
  set w .xpglf
  catch {destroy $w}
  toplevel $w
  wm title $w "Xgnuplot Function Scratch Pad"
  wm iconname $w "Xgnuplot Function Scratch Pad"
  pack [frame $w.bar -relief flat] -side top -fill x -padx 2 -pady 2
  pack [button $w.bar.dismiss -relief raised -borderwidth 1 -width 8\
               -text Dismiss -command xgpl_FunctionPadExit] \
        -side left -anchor w
  pack [button $w.bar.save -relief raised -borderwidth 1 -width 8\
               -text Save -command "Desktop_Save Xgpl"] \
        -side left -anchor w
  pack [button $w.bar.apply -relief raised -borderwidth 1 -width 8\
               -text Apply -command "xgpl_FunctionPadApply"] \
        -side left -anchor w
  pack [frame $w.func -relief groove -borderwidth 1] \
        -side top -fill x -padx 4 -pady 4 -expand 1
  pack [scrollbar $w.func.scroll -width 3m -command "$w.func.text yview" \
        -relief sunken -borderwidth 2] -side right -fill y
  pack [text $w.func.text -relief sunken -borderwidth 2 \
        -setgrid 1 -yscroll "$w.func.scroll set"] \
        -side top -fill both -expand 1
  $w.func.text insert 0.0 $Xgpl(funcs)
}

proc xgpl_FunctionPadExit { } {
  global Xgpl Desktop
  set w .xpglf
  set Xgpl(funcs) [$w.func.text get 0.0 end]
  destroy $w
}

proc xgpl_FunctionPadApply { } {
  global Xgpl Desktop
  set w .xpglf
  if [winfo exists $w] then {
    set Xgpl(funcs) [$w.func.text get 0.0 end]
  }
  xgpl_Send $Xgpl(funcs)
}
