/*
 * main.c
 *
 * jwh@cs.bham.ac.uk
 * Commodore wibble
 *
 * I have fiddled with the output to make it a bit nicer and easier for my
 * check program to get the results.
 *
 */
#include "copyright.h"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#ifdef hpux
#include <time.h>
#else hpux
#include <sys/time.h>
#endif hpux
#ifndef hpux
#include <sys/wait.h>
#endif hpux
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

jmp_buf env;

main(argc, argv)
int argc;
char **argv;
{
    int intrupt();
    int team, s_type;
    int pno;
    char *host = NULL;
    int usage = 0;
    int err = 0;
    char *name, *ptr, *cp, *rindex();
    char buf[80];
    struct passwd *pwent, *getpwuid();
    int passive=0;
    char *defaultsFile=NULL;

	if( argc < 2 )
	{
		fprintf( stderr, "Usage:  %s <server name> [<port> 2592 ]\n", 
				argv[ 0 ] );
		exit(-1);
	}

	if( argc == 3 )
		xtrekPort=atoi( argv[ 2 ] );
	else
		xtrekPort=2592;
	
	serverName = argv[ 1 ];
	callServer(xtrekPort, serverName);
	openmem();
    findslot();
	getallplayers();
	playerlist();
}

getallplayers()
{
	while(( player_messages_count() < MAXPLAYER ) )
	{
		readFromServer();
	}
}

findslot()
{
    int oldcount= -1;

    /* Wait for some kind of indication about in/not in */
    while (queuePos == -1 )
	{
		socketPause();
		if (isServerDead()) 
		{
			printf("Augh!  Ghostbusted!\n");
			exit(0);
		}	
		readFromServer();
		if (me!=NULL )
		{
			/* We are in! */
			return(me->p_no);
		}	
    }
	printf("Queue with %d people ahead of us.\n", queuePos );
	exit( -1 );
}


static char *classes[NUM_TYPES] = {
	"SC", "DD", "CA", "BB", "AS", "SB", "GA", " "
};

playerlist()
{
  int i, robot=0, play =0, teams[9];
  register struct player *j;

  teams[0]=0;    /* Independent */
  teams[FED]=0;
  teams[ROM]=0;
  teams[KLI]=0;
  teams[ORI]=0;
  
  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
    if (j->p_status == PALIVE)
      play++;
  if (play!=0)
  {
    play = 0;

      printf("<>==========================================================================<>\n");
  printf("  Type    Rank        Name             Login       Machine\n");
  printf("<>==========================================================================<>\n");

    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
      if (j->p_status == PALIVE)
      {
	printf("  %c%c: %s  %-11.11s %-16.16s %-11.11s %s\n",
	       teamlet[j->p_team],
	       shipnos[j->p_no],
	       classes[j->p_ship.s_type],
	       ranks[j->p_stats.st_rank].name,
	       j->p_name, 
	       j->p_login, j->p_monitor );
	/* ok we have a valid slot, check if it is a robot */
	if ((strstr(j->p_login,"Robot")!=NULL)
	    && (strstr(j->p_monitor,"Nowhere")!=NULL))
	{
	  /* Robot! */
	  robot++;
	}
	else
	{
	  teams[j->p_team]++;
	  play++;
	}
      }
    }
    printf("<>==========================================================================<>\n");
    printf("  Feds: %d   Roms: %d   Kli: %d   Ori: %d   Ind: %d   Players: %d  Robots: %d\n",
	 teams[FED], teams[ROM], teams[KLI], teams[ORI], teams[0], play, robot);
    printf("<>==========================================================================<>\n");
  }
  else
  {
    printf("Nobody is currently playing this server\n");
  }
}
