/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * otd - Open Track Daemon
 *
 */

#define MAINPROGRAM

#include <stdio.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otd[] =
    "$RCSfile: otd.c,v $ $Revision: 1.1.5.2 $ $Date: 1993/09/28 16:09:01 $";
#endif

int cmdNotedataBuildServer();
extern int otServerExit();

int main(argc,argv)
int argc;
char **argv;
{
    OTErr errCode = OT_SUCCESS;
    char *args;
    char *cp1;
    Tcl_Interp *interp;
    char logFile[NAMELEN];

    if ( errCode = otInitialInit(&argc, argv) ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "otInitialInit: %s\n", cp1);
	exit(1);
    }

    /*
     * Disabling 'exec' makes it impossible to do the validation required
     * by DME at the moment.  Ditto for 'open'.
     *
     * (void)Tcl_DeleteCommand(otCB->cb_pcb->pcb_interp, "open");
     * (void)Tcl_DeleteCommand(otCB->cb_pcb->pcb_interp, "exec");
     */
    (void)Tcl_CreateCommand(otCB->cb_pcb->pcb_interp, "serverExit",
	otServerExit, (ClientData)"serverExit", (Tcl_CmdDeleteProc *)0);

    (void)Tcl_CreateCommand(otCB->cb_pcb->pcb_interp, "notedataBuild",
	cmdNotedataBuildServer, (ClientData)"notedataBuild", 
	(Tcl_CmdDeleteProc *)0);
		    
    /* Open up the log file */

    sprintf(logFile, "%s/serverV3.log", BASE);
    sprintf(otCB->cb_pcb->pcb_logPid, "%ld", (long) getpid());

    if ((otCB->cb_pcb->pcb_efp = fopen(logFile, "a")) == NULL)    {
	fprintf(stderr,"can't append to log file (%s)\n", logFile);
	exit(1);
    }
    chmod(logFile, 0666);

    logWarn("========================= started connection");

    otCB->cb_pcb->pcb_imTheServer = TRUE;
    (void)chdir(BASE);

    otMakeServer();

}

