
// Simple test case for the objectify program.  Two objects are defined -- Foo,
// which has a few slots and methods, and Bar, which is a widget that doesn't
// do anything.  objectify will read this file and produce a file called
// test_objects.cc

extern "C" {
#include "tcl.h"
#include "tk.h"
#include "tkInt.h"
}

// This file is required to be able to interpret the TCL_ macros correctly for
// C++.

#include "objectify.h"

struct TCL_OBJECT("foo", Foo, object, "This is a foo object.  It has no \
particular value in life.") {
    Foo(Tcl_Interp* interp) { }
    ~Foo() { }

    TCL_SLOT1(INT, int, i, "-i", "17", NULL, "number",
	      "A random integer value");
    TCL_SLOT1(DOUBLE, double, f, "-f", "13.31", NULL, "float value",
	      "A random floating-point value");
    
    TCL_METHOD("printall", PrintAllCmd, 0, 0, "", "Print some useful things") {
	char buf[64];
	sprintf(buf, "-i %d -f %f diff %f", i, f, d);
	Tcl_AppendResult(interp, buf, 0);
	return (TCL_OK);
    }
    TCL_METHOD("echo", EchoCmd, 0, -1, "word ...", "Print arguments");
 
    int AfterConfigure(Tcl_Interp* interp);
    int BeforeDelete(Tcl_Interp* interp) { printf("before delete foo\n"); return (TCL_OK); }
    
    float d;
};

struct TCL_OBJECT("bar", Bar, widget, "This is a bar widget") {
    Bar(Tcl_Interp* interp, Tk_Window win) {
	tkwin = win;
	bgBorder = NULL;
	bgColor = NULL;
	cursor = NULL;
	redraw_pending = 0;
    }
    ~Bar() { }
    
    TCL_SLOT1(BORDER, Tk_3DBorder, bgBorder, "-bg", "black", NULL,
	      "color", "Color of the border");
    TCL_SLOT1(COLOR,  XColor*, bgColor, NULL, NULL, NULL, "", "");
    TCL_SLOT(RELIEF, int, relief, "-relief", "relief", "Relief", "flat", 0,
	     NULL, "relief-value", "The relief to use for the object");
    TCL_SLOT1(PIXELS, int, borderwidth, "-bw", "0", NULL, "pixels",
	      "Width of the border");
    TCL_SLOT1(PIXELS, int, height, "-height", "100", NULL, "pixels",
	      "Height of the window");
    TCL_SLOT1(PIXELS, int, width, "-width", "100", NULL, "pixels",
	      "Width of the window");
    TCL_SLOT(ACTIVE_CURSOR, Cursor, cursor, "-cursor", "cursor", "Cursor",
	     NULL, TK_CONFIG_NULL_OK, NULL, "cursor spec",
	     "Cursor to use in the window");
    
    int AfterConfigure(Tcl_Interp* interp);
    int BeforeDelete(Tcl_Interp* interp) { printf("before delete bar\n"); return (TCL_OK); }
    
    friend static void DisplayBar(ClientData cl);
    
    Tk_Window tkwin;
    int redraw_pending;

    void Draw();
};

// Here are some samples of inheritance and automatic parsing of
// arguments.

// Define some random types for later use.
struct Fruitcake { int f; };
struct Frogs { int f; };

class TCL_OBJECT("parent", Parent, object, "") {
  public:
    Parent(Tcl_Interp* interp) { }
    ~Parent() { }
    
    TCL_SLOT2(int, p, "17", "");
    
    TCL_METHOD("pmethod", PmethodCmd, 0, 0, "", "") {
	Tcl_AppendResult(interp, "parent method", 0);
	return (TCL_OK);
    }
    
    // This method takes 3 args: a fruitcake pointer, an int, and a frog.
    // It sets the appropriate fields in the structure.
    TCL_METHOD1("method1", Method1Cmd(Fruitcake* ff, Tcl_Interp* interp,
					  int a, Frogs fr), "", "") {
	fruitcake = ff;
	frogs = fr;
	fred = a;
	return (TCL_OK);
    }
    
    // This method takes no arguments and returns the values from method1.
    TCL_METHOD1("method2", Method2Cmd(Tcl_Interp* interp), "", "") {
	char buf[128];
	sprintf(buf, "0x%x %d %d", (int) fruitcake, frogs.f, fred);
	Tcl_AppendResult(interp, buf, 0);
	return (TCL_OK);
    }
    
    int AfterConfigure(Tcl_Interp* interp) {
	printf("parent configure\n");
	return (TCL_OK);
    }
    int BeforeDelete(Tcl_Interp* interp) {
	printf("parent delete\n");
	return (TCL_OK);
    }
    
    Fruitcake* fruitcake;
    Frogs frogs;
    int fred;
};

class TCL_OBJECT("child", Child, object(Parent), "") : public Parent {
  public:
    Child(Tcl_Interp* interp) : Parent(interp) { }
    ~Child() { }
    
    TCL_SLOT1(INT, int, c, "-c", "13", NULL, "", "");
    
    TCL_METHOD("cmethod", CmethodCmd, 0, 0, "", "") {
	Tcl_AppendResult(interp, "child method", 0);
	return (TCL_OK);
    }
    
    int AfterConfigure(Tcl_Interp* interp) {
	printf("child configure\n");
	return (TCL_OK);
    }
    int BeforeDelete(Tcl_Interp* interp) {
	printf("child delete\n");
	return (TCL_OK);
    }
};
