#
# mxedit.core --
#	The procedures here are thin layers over the core mxedit
#	widget functions that are implemented in C.  These procedures
#	relie on the global variable mxedit to contain the TK pathname
#	of the editor widget.
#
# Copyright (c) 1992-3 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

# mxBind --
#	This is what users should use to bind keystrokes to the edit window
#	See also the mxMenuBind procedure that is used to bind
#	keystrokes to menu entries.

proc mxBind { args } {
    global mxedit
    eval {bind $mxedit} $args
}

# mxCaret --
#	mxCaret mark - this positions the insert caret
#	mxCaret display [block|caret] - change caret appearance
proc mxCaret { args } {
    global mxedit mxMarkActive
    eval {$mxedit caret} $args
    set mxMarkActive 0
}

# mxCaretMove --
#	Layer on mxCaret that understands overloading caret movement
#	with extending the selection (emacs emulation)
#
proc mxCaretMove { mark } {
    global mxMarkActive
    global mxedit
    $mxedit caret $mark
    if {$mxMarkActive} {
	$mxedit selection f_adjust $mark
    }
}


# mxClean --
#	Mark the file as clean - but don't really write out its contents

proc mxClean { args } {
    global mxedit
    eval {$mxedit clean} $args
}

# mxColumn --
#	Return the column corresponding to the left edge of the
#          character at the position indicated by mark.

proc mxColumn { args } {
    global mxedit
    eval {$mxedit column} $args
}

# mxControl --
#	mxControl option string
#	options:
#		backslash -- replace non-printing chars with escape sequences
#		binding -- returns a binding syntax for a string (broken)
#		make -- folds ascii down to control

proc mxControl { args } {
    global mxedit
    eval {$mxedit control} $args
}

# mxDelete --
#	mxDelete mark1 [mxMark2 [noviewchange]]
#	Delete the specified region

proc mxDelete { args } {
    global mxedit
    eval {$mxedit delete} $args
}

# mxBatchDelete --
#	batchDelete uses the ! syntax to batch up a history log entry.
#	This means that many deletes in a row are undone as one operation.

proc mxBatchDelete { args } {
    global mxedit
    eval {$mxedit ! delete} $args
}

# mxExtract --
#	mxExtract mark1 [mxMark2]
#	Return all the characters between two marks

proc mxExtract { args } {
    global mxedit
    eval {$mxedit extract} $args
}

# mxHistory --
#	remember actions for the puposes of redo

proc mxHistory { args } {
    global mxedit
    eval {$mxedit history} $args
}

# mxGridsize --
#	Return a gridsize as determined from the font metrics.  Used
#	in conjuction with the "wm grid" command:
#	eval "wm grid . $baseWidth $baseHeight [mxGridsize]

proc mxGridsize { args } {
    global mxedit
    eval {$mxedit gridsize} $args
}

# mxIndent --
#	mxIndent mark1 mark2 [+|-] amount

proc mxIndent { args } {
    global mxedit
    eval {$mxedit indent} $args
}

# mxInsert --
#	mxInsert bytes [mxMark]
#	Defaults to inserting at the caret

proc mxInsert { bytes args } {
    global mxedit
    eval {$mxedit insert $bytes} $args
}

# mxBatchInsert --
#	Use the ! syntax to batch up insertions

proc mxBatchInsert { bytes args } {
    global mxedit
    eval {$mxedit ! insert $bytes} $args
}

# mxMark --
#	mxMark src op args
#	Returns a position marker of the form lines.chars
#	See the man page for details

proc mxMark { args } {
    global mxedit
    eval {$mxedit mark} $args
}

# mxNewline --
#	Insert a newline character and do auto indentation
proc mxNewline {  } {
    global mxedit
    $mxedit newline
}

# mxQuote --
#	Quote (insert) the next character, ignoring its binding.

proc mxQuote {  } {
    global mxedit
    $mxedit quote
}

# mxRead --
#	Read in the contents of a file
#	I cannot get {rename read unixRead} to work, hence readf

proc mxRead { args } {
    global mxedit
    eval {$mxedit read} $args
}

# mxReplace --
#	mxReplace [option args]
#          mxReplace range start stop [pattern string]
#          mxReplace selection string
#	Replace the selection with a string,
#	or do a replace	within a range
#	If there are no options, then the widget reaches out
#	for the value of mxReplaceString

proc mxReplace { args } {
    global mxedit
    catch {
	 global mxFind mxReplaceString
	 set mxReplaceString [$mxFind.replace.entry get]
    }
    set cmd [concat "$mxedit replace " $args]
    if [catch $cmd msg] {
	mxFeedback "$msg"
    }
}

# mxSearch --
#	mxSearch [forward|backward] target
#	if there is no target specified, then the widget reaches
#	out for the mxSearchString variable

proc mxSearch { args } {
    global mxedit
    catch {
	 global mxFind mxSearchString
	 set mxSearchString [$mxFind.target.entry get]
    }
    set cmd [concat "$mxedit search " $args]
    if [catch $cmd msg] {
	mxFeedback "$msg"
    }
}

# mxSee --
#	mxSee mark [[top|center|bottom]
#	Adjust the view so the mark is visible

proc mxSee { args } {
    global mxedit
    eval {$mxedit see} $args
}

# mxSelection --
#	mxSelection clear - clear this window's selection
#	mxSelection here - returns 1 if selection is in this window
#	mxSelection set mark1 [mxMark2]

proc mxSelection { args } {
    global mxedit
    eval {$mxedit selection} $args
}

# mxTaginfo --
#	Returns information from a tags file.

proc mxTaginfo { args } {
    global mxedit
    eval {$mxedit taginfo} $args
}

# mxWritten --
#	Raises an error if the file is dirty.

proc mxWritten { args } {
    global mxedit
    eval {$mxedit written} $args
}


