# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc useredit_create {w win} \
{
	global PASSWD_ENTRIES
	global HOME_DIR_LIST
	global SHELL_LIST
	global UID_HOOKS
	global group_text

	global BACKGROUND_COLOR_ADD_EDIT
	frame $w.useredit -relief flat -border 5 -background $BACKGROUND_COLOR_ADD_EDIT

	frame $w.useredit.entry
	frame $w.useredit.info

	entry $w.useredit.entry.username -relief sunken -width 20
	button $w.useredit.entry.password -relief sunken -width 20 -anchor w -command "useredit_passwd_create $w"
	entry $w.useredit.entry.uid -relief sunken -width 20
	button $w.useredit.entry.gid -relief sunken -width 20 -anchor w -command "useredit_group_create $w"
	entry $w.useredit.entry.gcos_field1 -relief sunken -width 20
	entry $w.useredit.entry.gcos_field2 -relief sunken -width 20
	entry $w.useredit.entry.gcos_field3 -relief sunken -width 20
	entry $w.useredit.entry.gcos_field4 -relief sunken -width 20
	entry $w.useredit.entry.home_dir -relief sunken -width 20
	entry $w.useredit.entry.login_shell -relief sunken -width 20

	pack append $w.useredit.entry \
		$w.useredit.entry.username {top pady 2 fill} \
		$w.useredit.entry.password {top pady 2 fill} \
		$w.useredit.entry.uid {top pady 2 fill} \
		$w.useredit.entry.gid {top pady 2 fill} \
		$w.useredit.entry.gcos_field1 {top pady 2 fill} \
		$w.useredit.entry.gcos_field2 {top pady 2 fill} \
		$w.useredit.entry.gcos_field3 {top pady 2 fill} \
		$w.useredit.entry.gcos_field4 {top pady 2 fill} \
		$w.useredit.entry.home_dir {top pady 2 fill} \
		$w.useredit.entry.login_shell {top pady 2 fill}

	frame $w.useredit.info.username
	label $w.useredit.info.username.label -text "Username:" -anchor e -relief flat
	menubutton $w.useredit.info.username.menu -bitmap @menu -menu $w.useredit.info.username.menu.m -relief raised
	menu $w.useredit.info.username.menu.m
	$w.useredit.info.username.menu.m add command -label "Verify Uniqueness" -command "useredit_verify_username $w {$win}"
	pack append $w.useredit.info.username $w.useredit.info.username.label {left expand fillx} $w.useredit.info.username.menu {left}

	frame $w.useredit.info.password
	label $w.useredit.info.password.label -text "Password:" -anchor e -relief flat
	if [llength $PASSWD_ENTRIES]>0 \
	{
		menubutton $w.useredit.info.password.menu -bitmap @menu -menu $w.useredit.info.password.menu.m -relief raised
		menu $w.useredit.info.password.menu.m
		foreach passwd_entry $PASSWD_ENTRIES \
		{
			$w.useredit.info.password.menu.m add command -label $passwd_entry -command "useredit_set_passwd $w {$passwd_entry}"
		}
		pack append $w.useredit.info.password $w.useredit.info.password.label {left expand fillx} $w.useredit.info.password.menu {left}
	} else \
	{
		label $w.useredit.info.password.space -bitmap @space
		pack append $w.useredit.info.password $w.useredit.info.password.label {left expand fillx} $w.useredit.info.password.space {left}
	}

	frame $w.useredit.info.uid
	label $w.useredit.info.uid.label -text "UID:" -anchor e -relief flat
	if [llength $UID_HOOKS]>0 \
	{
		menubutton $w.useredit.info.uid.menu -bitmap @menu -menu $w.useredit.info.uid.menu.m -relief raised
		menu $w.useredit.info.uid.menu.m
		foreach uid_hook $UID_HOOKS \
		{
			$w.useredit.info.uid.menu.m add command -label $uid_hook -command "useredit_apply_uid_hook $w {$win} $uid_hook"
		}
		pack append $w.useredit.info.uid $w.useredit.info.uid.label {left expand fillx} $w.useredit.info.uid.menu {left}
	} else \
	{
		label $w.useredit.info.uid.space -bitmap @space
		pack append $w.useredit.info.uid $w.useredit.info.uid.label {left expand fillx} $w.useredit.info.uid.space {left}
	}

	frame $w.useredit.info.gid
	label $w.useredit.info.gid.label -text "GID:" -anchor e -relief flat
	label $w.useredit.info.gid.space -bitmap @space
	pack append $w.useredit.info.gid $w.useredit.info.gid.label {left expand fillx} $w.useredit.info.gid.space {left}

	frame $w.useredit.info.gcos_field1
	label $w.useredit.info.gcos_field1.label -text "Real Name:" -anchor e -relief flat
	label $w.useredit.info.gcos_field1.space -bitmap @space
	pack append $w.useredit.info.gcos_field1 $w.useredit.info.gcos_field1.label {left expand fillx} $w.useredit.info.gcos_field1.space {left}

	frame $w.useredit.info.gcos_field2
	label $w.useredit.info.gcos_field2.label -text "Office:" -anchor e -relief flat
	label $w.useredit.info.gcos_field2.space -bitmap @space
	pack append $w.useredit.info.gcos_field2 $w.useredit.info.gcos_field2.label {left expand fillx} $w.useredit.info.gcos_field2.space {left}

	frame $w.useredit.info.gcos_field3
	label $w.useredit.info.gcos_field3.label -text "Office Phone:" -anchor e -relief flat
	label $w.useredit.info.gcos_field3.space -bitmap @space
	pack append $w.useredit.info.gcos_field3 $w.useredit.info.gcos_field3.label {left expand fillx} $w.useredit.info.gcos_field3.space {left}

	frame $w.useredit.info.gcos_field4
	label $w.useredit.info.gcos_field4.label -text "Home Phone:" -anchor e -relief flat
	label $w.useredit.info.gcos_field4.space -bitmap @space
	pack append $w.useredit.info.gcos_field4 $w.useredit.info.gcos_field4.label {left expand fillx} $w.useredit.info.gcos_field4.space {left}

	frame $w.useredit.info.home_dir
	label $w.useredit.info.home_dir.label -text "Home Directory:" -anchor e -relief flat
	if [llength $HOME_DIR_LIST]>0 \
	{
		menubutton $w.useredit.info.home_dir.menu -bitmap @menu -menu $w.useredit.info.home_dir.menu.m -relief raised
		menu $w.useredit.info.home_dir.menu.m
		foreach home_dir $HOME_DIR_LIST \
		{
			$w.useredit.info.home_dir.menu.m add command -label "$home_dir/USERNAME" -command "useredit_set_home_dir $w $home_dir"
		}
		pack append $w.useredit.info.home_dir $w.useredit.info.home_dir.label {left expand fillx} $w.useredit.info.home_dir.menu {left}
	} else \
	{
		label $w.useredit.info.home_dir.space -bitmap @space
		pack append $w.useredit.info.home_dir $w.useredit.info.home_dir.label {left expand fillx} $w.useredit.info.home_dir.space {left}
	}

	frame $w.useredit.info.login_shell
	label $w.useredit.info.login_shell.label -text "Login Shell:" -anchor e -relief flat
	if [llength $SHELL_LIST]>0 \
	{
		menubutton $w.useredit.info.login_shell.menu -bitmap @menu -menu $w.useredit.info.login_shell.menu.m -relief raised
		menu $w.useredit.info.login_shell.menu.m
		foreach login_shell $SHELL_LIST \
		{
			$w.useredit.info.login_shell.menu.m add command -label "$login_shell" -command "useredit_set_login_shell $w $login_shell"
		}
		pack append $w.useredit.info.login_shell $w.useredit.info.login_shell.label {left expand fillx} $w.useredit.info.login_shell.menu {left}
	} else \
	{
		label $w.useredit.info.login_shell.space -bitmap @space
		pack append $w.useredit.info.login_shell $w.useredit.info.login_shell.label {left expand fillx} $w.useredit.info.login_shell.space {left}
	}

	pack append $w.useredit.info \
		$w.useredit.info.username {top expand fill} \
		$w.useredit.info.password {top expand fill} \
		$w.useredit.info.uid {top expand fill} \
		$w.useredit.info.gid {top expand fill} \
		$w.useredit.info.gcos_field1 {top expand fill} \
		$w.useredit.info.gcos_field2 {top expand fill} \
		$w.useredit.info.gcos_field3 {top expand fill} \
		$w.useredit.info.gcos_field4 {top expand fill} \
		$w.useredit.info.home_dir {top expand fill} \
		$w.useredit.info.login_shell {top expand fill}

	pack append $w.useredit $w.useredit.info {left expand fill} $w.useredit.entry {right expand fill}

	bind.entry_lowercase \
		$w.useredit.entry.username
	bind.entry_numeric \
		$w.useredit.entry.uid
	bind.entry \
		$w.useredit.entry.gcos_field1 \
		$w.useredit.entry.gcos_field2 \
		$w.useredit.entry.gcos_field3 \
		$w.useredit.entry.gcos_field4 \
		$w.useredit.entry.home_dir \
		$w.useredit.entry.login_shell

	$w.useredit.entry.username icursor end
	focus $w.useredit.entry.username
	$w.useredit.entry.username select from end

	bind $w.useredit.entry.username <Return> "$w.useredit.entry.uid icursor end; focus $w.useredit.entry.uid; $w.useredit.entry.uid select from end"
	bind $w.useredit.entry.username <Tab> "$w.useredit.entry.uid icursor end; focus $w.useredit.entry.uid; $w.useredit.entry.uid select from end"

	bind $w.useredit.entry.uid <Return> "$w.useredit.entry.gcos_field1 icursor end; focus $w.useredit.entry.gcos_field1; $w.useredit.entry.gcos_field1 select from end"
	bind $w.useredit.entry.uid <Tab> "$w.useredit.entry.gcos_field1 icursor end; focus $w.useredit.entry.gcos_field1; $w.useredit.entry.gcos_field1 select from end"

	bind $w.useredit.entry.gcos_field1 <Return> "$w.useredit.entry.gcos_field2 icursor end; focus $w.useredit.entry.gcos_field2; $w.useredit.entry.gcos_field2 select from end"
	bind $w.useredit.entry.gcos_field1 <Tab> "$w.useredit.entry.gcos_field2 icursor end; focus $w.useredit.entry.gcos_field2; $w.useredit.entry.gcos_field2 select from end"

	bind $w.useredit.entry.gcos_field2 <Return> "$w.useredit.entry.gcos_field3 icursor end; focus $w.useredit.entry.gcos_field3; $w.useredit.entry.gcos_field3 select from end"
	bind $w.useredit.entry.gcos_field2 <Tab> "$w.useredit.entry.gcos_field3 icursor end; focus $w.useredit.entry.gcos_field3; $w.useredit.entry.gcos_field3 select from end"

	bind $w.useredit.entry.gcos_field3 <Return> "$w.useredit.entry.gcos_field4 icursor end; focus $w.useredit.entry.gcos_field4; $w.useredit.entry.gcos_field4 select from end"
	bind $w.useredit.entry.gcos_field3 <Tab> "$w.useredit.entry.gcos_field4 icursor end; focus $w.useredit.entry.gcos_field4; $w.useredit.entry.gcos_field4 select from end"

	bind $w.useredit.entry.gcos_field4 <Return> "$w.useredit.entry.home_dir icursor end; focus $w.useredit.entry.home_dir; $w.useredit.entry.home_dir select from end"
	bind $w.useredit.entry.gcos_field4 <Tab> "$w.useredit.entry.home_dir icursor end; focus $w.useredit.entry.home_dir; $w.useredit.entry.home_dir select from end"

	bind $w.useredit.entry.home_dir <Return> "$w.useredit.entry.login_shell icursor end; focus $w.useredit.entry.login_shell; $w.useredit.entry.login_shell select from end"
	bind $w.useredit.entry.home_dir <Tab> "$w.useredit.entry.login_shell icursor end; focus $w.useredit.entry.login_shell; $w.useredit.entry.login_shell select from end"

	bind $w.useredit.entry.login_shell <Return> "$w.useredit.entry.username icursor end; focus $w.useredit.entry.username; $w.useredit.entry.username select from end"
	bind $w.useredit.entry.login_shell <Tab> "$w.useredit.entry.username icursor end; focus $w.useredit.entry.username; $w.useredit.entry.username select from end"
}

proc useredit_init {w username password uid gid gcos_field home_dir login_shell} \
{
	global group_text
	upvar #0 tmp_passwd($w) tmp_passwd
	upvar #0 tmp_gid($w) tmp_gid
	upvar #0 tmp_gid_list($w) tmp_gid_list
	$w.useredit.entry.username insert 0 $username
	$w.useredit.entry.password config -text $password
	set tmp_passwd $password
	$w.useredit.entry.uid insert 0 $uid
	$w.useredit.entry.gid config -text [group_get_groupname_gid_translate $group_text $gid]
	set tmp_gid $gid
	set tmp_gid_list [lunion $gid [group_get_gid_list $group_text $username]]
	$w.useredit.entry.gcos_field1 insert 0 [passwd_decompress_gcos_field [passwd_get_gcos_field1_gcos $gcos_field] $username]
	$w.useredit.entry.gcos_field2 insert 0 [passwd_decompress_gcos_field [passwd_get_gcos_field2_gcos $gcos_field] $username]
	$w.useredit.entry.gcos_field3 insert 0 [passwd_decompress_gcos_field [passwd_get_gcos_field3_gcos $gcos_field] $username]
	$w.useredit.entry.gcos_field4 insert 0 [passwd_decompress_gcos_field [passwd_get_gcos_field4_gcos $gcos_field] $username]
	$w.useredit.entry.home_dir insert 0 $home_dir
	$w.useredit.entry.login_shell insert 0 $login_shell
}

proc useredit_apply {w win} \
{
	global group_text
	set username [$w.useredit.entry.username get]
	upvar #0 tmp_gid_list($w) tmp_gid_list
	set group_text [group_add_user [group_remove_user $group_text $username] $username $tmp_gid_list]
}

proc useredit_get_user_entry { w } \
{
	upvar #0 tmp_gid($w) tmp_gid
	global group_text

	return \
		 [pad_space [$w.useredit.entry.username get] 9 2 \
		][pad_space [$w.useredit.entry.gcos_field1 get] 25 2 \
		][pad_space [group_translate $group_text $tmp_gid] 10 2 \
		][pad_space [file tail [$w.useredit.entry.login_shell get]] 8 0]
}

proc useredit_get_passwd_entry { w } \
{
	upvar #0 tmp_passwd($w) tmp_passwd
	upvar #0 tmp_gid($w) tmp_gid
	global group_text

	if {[$w.useredit.entry.username get] == {}} {return -1}
	if {[$w.useredit.entry.uid get] == {}} {return -1}

	return [passwd_construct \
		[$w.useredit.entry.username get] \
		$tmp_passwd \
		[$w.useredit.entry.uid get] \
		$tmp_gid \
		[passwd_compress_gcos_field "[$w.useredit.entry.gcos_field1 get
						],[$w.useredit.entry.gcos_field2 get
						],[$w.useredit.entry.gcos_field3 get
						],[$w.useredit.entry.gcos_field4 get]" \
					[$w.useredit.entry.username get] ] \
		[$w.useredit.entry.home_dir get] \
		[$w.useredit.entry.login_shell get] ]
}

proc useredit_apply_uid_hook {w win uid_hook} \
{
	set tmp_uid [eval "$uid_hook {[useredit_get_passwd_entry $w]} $w {$win}"]
	if {$tmp_uid != -1} \
	{
		$w.useredit.entry.uid delete 0 end
		$w.useredit.entry.uid insert 0 $tmp_uid
	}
}

proc useredit_set_home_dir {w dir} \
{
	$w.useredit.entry.home_dir delete 0 end
	$w.useredit.entry.home_dir insert 0 "$dir/[$w.useredit.entry.username get]"
}

proc useredit_set_login_shell {w shell} \
{
	$w.useredit.entry.login_shell delete 0 end
	$w.useredit.entry.login_shell insert 0 "$shell"
}

proc useredit_set_passwd {w passwd_entry} \
{
	upvar #0 tmp_passwd($w) tmp_passwd
	$w.useredit.entry.password config -text "$passwd_entry"
	set tmp_passwd $passwd_entry
}

proc useredit_verify_username {w win} \
{
	upvar #0 tmp_passwd_text([expr "{$win} == {} ? {.} : {$win}"]) tmp_passwd_text
	set skip [userlist_tag_find $win $w]
	set username [$w.useredit.entry.username get]
	set i 0
	if {[string compare [string range $w 0 3] {.add}] == 0} {set skip -1}
	foreach passwd_entry $tmp_passwd_text \
	{
		if {$i != $skip} \
		{
			if {[string compare $username [passwd_get_username [file_to_normal $passwd_entry]]] == 0} \
			{
				$w.useredit.entry.username delete 0 end
				$w.useredit.entry.username insert 0 "USERNAME IN USE."
				break
			}
		}
		incr i
	}
}
