# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc passwd_lock {} \
{
	global PASSWD_LOCK_DIR
	return [catch {exec mkdir $PASSWD_LOCK_DIR}]
}

proc passwd_global_lock {} \
{
	global GLOBAL_PASSWD_LOCK_DIR
	if {$GLOBAL_PASSWD_LOCK_DIR == {}} {return 0}
	return [catch {exec mkdir $GLOBAL_PASSWD_LOCK_DIR}]
}

proc passwd_unlock {} \
{
	global PASSWD_LOCK_DIR
	catch {exec rmdir $PASSWD_LOCK_DIR}
}

proc passwd_global_unlock {} \
{
	global GLOBAL_PASSWD_LOCK_DIR
	catch {exec rmdir $GLOBAL_PASSWD_LOCK_DIR}
}

proc passwd_init { passwd_file_name } \
{
	set passwd_file [open $passwd_file_name r]
	set passwd_text [file_to_list [read $passwd_file nonewline]]
	close $passwd_file
	return $passwd_text
}

proc passwd_write_to_file {passwd_text passwd_file_name} \
{
	set passwd_file [open $passwd_file_name w]
	foreach passwd_entry $passwd_text \
	{
		puts $passwd_file [file_to_normal $passwd_entry]
	}
	close $passwd_file
}

proc passwd_get_username {passwd_entry} \
{
	return [file_get_element $passwd_entry 0]
}

proc passwd_get_password {passwd_entry} \
{
	return [file_get_element $passwd_entry 1]
}

proc passwd_get_uid {passwd_entry} \
{
	return [file_get_element $passwd_entry 2]
}

proc passwd_get_gid {passwd_entry} \
{
	return [file_get_element $passwd_entry 3]
}

proc passwd_get_gcos_field {passwd_entry} \
{
	return [file_get_element $passwd_entry 4]
}

proc passwd_get_gcos_field_element {gcos_field element} \
{
	set gcos_field [file_to_list $gcos_field]
	set gcos_field [lindex [split $gcos_field {,}] $element]
	return [file_to_normal $gcos_field]
}

proc passwd_get_gcos_field1_passwd {passwd_entry} \
{
	set gcos_field [passwd_get_gcos_field $passwd_entry]
	return [passwd_get_gcos_field_element $gcos_field 0]
}
proc passwd_get_gcos_field1_gcos {gcos_field} \
{
	return [passwd_get_gcos_field_element $gcos_field 0]
}

proc passwd_get_gcos_field2_passwd {passwd_entry} \
{
	set gcos_field [passwd_get_gcos_field $passwd_entry]
	return [passwd_get_gcos_field_element $gcos_field 1]
}
proc passwd_get_gcos_field2_gcos {gcos_field} \
{
	return [passwd_get_gcos_field_element $gcos_field 1]
}

proc passwd_get_gcos_field3_passwd {passwd_entry} \
{
	set gcos_field [passwd_get_gcos_field $passwd_entry]
	return [passwd_get_gcos_field_element $gcos_field 2]
}
proc passwd_get_gcos_field3_gcos {gcos_field} \
{
	return [passwd_get_gcos_field_element $gcos_field 2]
}

proc passwd_get_gcos_field4_passwd {passwd_entry} \
{
	set gcos_field [passwd_get_gcos_field $passwd_entry]
	return [passwd_get_gcos_field_element $gcos_field 3]
}
proc passwd_get_gcos_field4_gcos {gcos_field} \
{
	return [passwd_get_gcos_field_element $gcos_field 3]
}

proc passwd_compress_gcos_field {gcos_field username} \
{
	regsub -all [capitalize $username] $gcos_field {&} gcos_field
	return $gcos_field
}

proc passwd_decompress_gcos_field {gcos_field username} \
{
	regsub -all {&} $gcos_field [capitalize $username] gcos_field
	return $gcos_field
}

proc passwd_get_realname {passwd_entry} \
{
	set entry [passwd_get_gcos_field $passwd_entry]
	return [passwd_get_realname_gcos $entry [passwd_get_username $passwd_entry]]
}

proc passwd_get_realname_gcos {entry username} \
{
	set entry [file_to_list $entry]
	set entry [lindex [split $entry {,}] 0]
	set entry [file_to_normal $entry]
	return [passwd_decompress_gcos_field $entry $username]
}

proc passwd_get_home_dir {passwd_entry} \
{
	return [file_get_element $passwd_entry 5]
}

proc passwd_get_login_shell {passwd_entry} \
{
	return [file_get_element $passwd_entry 6]
}

proc passwd_construct {username password uid gid gcos_field \
		       home_dir login_shell} \
{
	return $username:$password:$uid:$gid:$gcos_field:$home_dir:$login_shell
}

proc passwd_crypt_internal {passwd salt} \
{
	return [exec perl -e "print crypt(\"$passwd\",\"$salt\"),\"\\n\";"]
}

proc passwd_crypt {passwd} \
{
	set valid_chars "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
	set salt [string index $valid_chars [rand 64]][string index $valid_chars [rand 64]]
	set passwd [passwd_crypt_internal $passwd $salt]
	return $passwd
}
