#!perl
use warnings; use strict;
use Test::More tests => 25;
use Test::Exception;
use Test::Builder;
use version;
use Try::Tiny;

use lib '.';
use t::Elive::StandardV2;

use Elive::StandardV2::Session;
use Elive::Util;

our $t = Test::Builder->new;
our $class = 'Elive::StandardV2::Session';

our $connection;

SKIP: {

    my $skippable = 25;

    my %result = t::Elive::StandardV2->test_connection();
    my $auth = $result{auth};

   skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    try {require Elive::StandardV2::Connection} catch {die $_};

    my $connection_class = $result{class};
    $connection = $connection_class->connect(@$auth);
    Elive::StandardV2->connection($connection);

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    my %session_data = (
	sessionName => 'test session, generated by t/soap-session.t',
	creatorId => $connection->user,
	startTime =>  $session_start . '000',
	endTime => $session_end . '000',
	openChair => 1,
	mustBeSupervised => 0,
	permissionsOn => 1,
	chairList => [$connection->user],
	groupingList => [qw(mechanics sewing)],
    );

    my $session = $class->insert(\%session_data);

    isa_ok($session, $class, 'session');
    ok(my $session_id = $session->sessionId, 'Insert returned session id');

    diag "session-id: $session_id";

    foreach (keys %session_data) {
	#
	# returned record doesn't contain password
	is_deeply($session->$_, $session_data{$_}, "session $_ as expected");
    }

    my %update_data = (
	chairNotes => 'test moderator notes. Here are some entities: & > <',
	nonChairNotes => 'test user notes; some more entities: &gt;',
	raiseHandOnEnter => 1,
	maxTalkers => 3,
	recordingModeType => 2,
	);

    $session->update(\%update_data);

    $session = undef;

    my $sessions;

    ok ($sessions = Elive::StandardV2::Session->list(filter => {sessionId => $session_id}),
	'List of session');
  
    is(scalar @$sessions, 1, 'list returns unique session');

    is( try {$sessions->[0]->sessionId}, $session_id, 'listed sessionId as expected');
    $sessions = undef;

    ok ($session = Elive::StandardV2::Session->retrieve([$session_id]),
	'Refetch of session');

    foreach (keys %update_data) {
	#
	# returned record doesn't contain password
	is($session->$_, $update_data{$_}, "session update $_ as expected");
    }

    my $session_url;
    lives_ok(sub {$session_url = $session->session_url(userId => 'bob', displayName => 'Robert')}, 'Can generate session Url for some user');
    diag "session url: $session_url";

    my $attendances;

    dies_ok(sub {$attendances = $session->attendance('')}, 'session attendance sans date - dies');

    my $today = $session_start - 7200;
    lives_ok(sub {$attendances = $session->attendance($today . '000')}, 'session attendance with date - lives');

    lives_ok(sub {$session->delete},'session deletion - lives');

    my $deleted_session;
    try {$deleted_session = Elive::StandardV2::Session->retrieve([$session_id])};

    ok($@ || !$deleted_session, "can't retrieve deleted session");
}

Elive::StandardV2->disconnect;

