use ExtUtils::MakeMaker;

my $defines = $Config::Config{nvsize} > 8 ? '-DNV_IS_LONG_DOUBLE' : '';

#Data::Float is handy for testing, but won't work with powerpc 'long double' builds.
my $prereq =  $Config::Config{nvsize} > 8 && $Config::Config{osvers} =~ /powerpc/i
                    ? {}
                    : {'Data::Float' => '0.012'};

my %options = %{
{
  'NAME' => 'Math::NV',
  'VERSION_FROM' => 'NV.pm',
  'PREREQ_PM' => $prereq,
  'LIBS' => [
    '-lm'
  ],
  'INC' => '',
  'DEFINE' => $defines,
}
};
WriteMakefile(%options);

# Remove the Makefile dependency. Causes problems on a few systems.
sub MY::makefile { '' }
