use Unicode::Collate::CJK::Korean;
+{
   locale_version => 1.08,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v7.0.0
F967      ; [.3776.0021.0002.4E0D][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.3776.0032.0002.4E26][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.376F.0021.0002.4E32][.37F5.0020.0002][.3860.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.3781.0021.0002.4E38][.37F6.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.3772.0021.0002.4E39][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.3774.0021.0002.4E82][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.3774.0021.0002.4E86][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.3774.0021.0002.4EAE][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.3778.0021.0002.4EC0][.3801.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.3774.0021.0002.4EE4][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.3774.0021.0002.4F86][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.3774.0021.0002.4F8B][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.3775.0021.0002.4FAE][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.3775.0021.0002.4FAE][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.377F.0023.0002.4FBB][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.3780.0021.0002.4FBF][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.3776.0022.0002.5002][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.3774.0022.0002.502B][.37FE.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.3776.0022.0002.5099][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.3778.0023.0002.50CF][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.3774.0022.0002.50DA][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.3778.0023.0002.50E7][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.3778.0023.0002.50E7][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.377A.0021.0002.5140][.37F5.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.377D.0021.0002.5145][.37FA.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.3775.0021.0002.514D][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.3775.0021.0002.514D][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.3771.0022.0002.5167][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.377B.0024.0002.5168][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.3774.0023.0002.5169][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.3774.0021.0002.516D][.37FE.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.376F.0026.0002.5177][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.376F.0024.0002.5180][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.377B.0021.0002.518D][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.3775.0022.0002.5192][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.3775.0022.0002.5195][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.377A.0023.0002.5197][.37F9.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.377A.003B.0002.51A4][.37FB.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.3772.0022.0002.51AC][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.3774.0021.0002.51B7][.37EE.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.3774.0024.0002.51C9][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.3774.0021.0002.51CC][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.3774.0021.0002.51DC][.37FF.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.3781.0022.0002.51DE][.3800.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.377A.0023.0002.5203][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.377B.0021.0002.5207][.37F1.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.377B.0021.0002.5207][.37F1.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.3774.0022.0002.5217][.37F3.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.3774.0022.0002.5229][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.377B.0022.0002.523A][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.376F.0021.0002.523B][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.3781.0021.0002.5272][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.3778.002D.0002.5277][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.3774.0021.0002.5289][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.3774.0021.0002.529B][.37F3.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.3774.0023.0002.52A3][.37F3.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.377A.0024.0002.52C7][.37F9.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.377A.0024.0002.52C7][.37F9.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.3775.0023.0002.52C9][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.3775.0023.0002.52C9][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.3774.0021.0002.52D2][.37FF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.3774.0021.0002.52DE][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.376F.0023.0002.52E4][.37FF.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.376F.0023.0002.52E4][.37FF.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.3774.0023.0002.52F5][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.377B.0022.0002.52FA][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.377B.0022.0002.52FA][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.3780.0022.0002.5305][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.3776.0021.0002.5317][.37FA.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.3776.0021.0002.5317][.37FA.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.3771.0021.0002.533F][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.3781.0021.0002.5349][.37FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.3776.0025.0002.5351][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.3776.0025.0002.5351][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.3776.0022.0002.535A][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.377B.0022.0002.5373][.37FF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.3774.0022.0002.5375][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.377B.0021.0002.537D][.37FF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.376F.0028.0002.537F][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.376F.0028.0002.537F][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.376F.0028.0002.537F][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.377D.0022.0002.53C3][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.376F.0022.0002.53CA][.37FF.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.3778.005E.0002.53DF][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.376F.002A.0002.53E5][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.376F.0021.0002.53EB][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.377B.0022.0002.53F1][.3801.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.3774.0024.0002.540F][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.3774.0021.0002.541D][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.3781.0021.0002.5438][.37FF.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.3774.0024.0002.5442][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.377B.0026.0002.5448][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.377B.0028.0002.5468][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.377A.0031.0002.54A2][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.377A.0025.0002.54BD][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.3772.0021.0002.5510][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.376F.0022.0002.5553][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.3781.0024.0002.5563][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.3778.0024.0002.5584][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.3778.0024.0002.5584][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.3774.0021.0002.5587][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.3781.0022.0002.5599][.37FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.3781.0022.0002.5599][.37FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.376F.0022.0002.559D][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.376F.0022.0002.559D][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.3770.0021.0002.55AB][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.377A.0022.0002.55E2][.37F5.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.377F.0022.0002.5606][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.377F.0022.0002.5606][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.376F.0026.0002.5668][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.3776.0023.0002.5674][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.3774.0023.0002.56F9][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.3772.0024.0002.5716][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.3781.0024.0002.578B][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.3778.0021.0002.57CE][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.3778.0021.0002.57F4][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.3776.0023.0002.5831][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.3776.0033.0002.5840][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.377D.0022.0002.585A][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.377D.0022.0002.585A][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.3778.0021.0002.585E][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.3775.0021.0002.58A8][.37FA.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.3776.0024.0002.58B3][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.3774.0021.0002.58D8][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.3774.0021.0002.58DF][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.3776.0032.0002.5906][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.3772.0021.0002.591A][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.3775.0021.0002.5922][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.377A.0024.0002.5944][.37F1.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.3771.0023.0002.5948][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.376F.0024.0002.5951][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.3776.0025.0002.5954][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.3778.0030.0002.5962][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.3771.0021.0002.5973][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.3781.0026.0002.59EC][.3800.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.377A.002C.0002.5A1B][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.377F.0030.0002.5A27][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.3776.0027.0002.5A62][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.3776.002B.0002.5A66][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.377A.0025.0002.5AB5][.3801.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.377A.0041.0002.5B08][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.377B.003C.0002.5B28][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.3774.0029.0002.5B3E][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.3774.0029.0002.5B3E][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.3772.0021.0002.5B85][.37EE.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.377A.0029.0002.5BC3][.37FB.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.377D.003B.0002.5BD8][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.3771.0021.0002.5BE7][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.3771.0021.0002.5BE7][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.3771.0021.0002.5BE7][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.3774.0023.0002.5BEE][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.3771.0021.0002.5C3F][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.3772.0028.0002.5C60][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.3774.0023.0002.5C62][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.377D.0021.0002.5C64][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.3774.0026.0002.5C65][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.3778.002A.0002.5CC0][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.3774.0023.0002.5D19][.37FE.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.3774.0021.0002.5D50][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.3774.0025.0002.5DBA][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.3778.0021.0002.5DE1][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.3778.0027.0002.5DE2][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.3778.0022.0002.5DFD][.37F5.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.3778.0029.0002.5E28][.37F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.3775.0025.0002.5E3D][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.3771.0021.0002.5E74][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.3772.002B.0002.5EA6][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.3776.0052.0002.5EB3][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.3778.0025.0002.5EB6][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.3774.0021.0002.5EC9][.37F3.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.3774.0021.0002.5ECA][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.3774.0021.0002.5ECA][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.376F.0021.0002.5ED3][.37F6.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.3774.0025.0002.5EEC][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.3774.0022.0002.5F04][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.3772.004B.0002.5F22][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.3772.004B.0002.5F22][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.3781.0025.0002.5F62][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.377D.0025.0002.5F69][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.377B.0027.0002.5F6B][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.3774.0021.0002.5F8B][.37FE.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.3776.0026.0002.5FA9][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.377A.0043.0002.5FAD][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.377A.002A.0002.5FCD][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.377B.0026.0002.5FD7][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.3771.0021.0002.5FF5][.37F3.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.3771.0024.0002.6012][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.3774.0026.0002.601C][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.377A.0042.0002.6081][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.3781.0026.0002.6094][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.3781.0026.0002.6094][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.3772.0022.0002.60C7][.37F5.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.3775.002D.0002.60D8][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.377A.0025.0002.60E1][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.377A.002E.0002.6108][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.3774.0022.0002.6144][.37FE.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.377B.002A.0002.6148][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.3781.0027.0002.614C][.37F6.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.3781.0027.0002.614C][.37F6.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.377A.0047.0002.6160][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.376F.0028.0002.6168][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.3774.0031.0002.617A][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.377B.0022.0002.618E][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.377B.0022.0002.618E][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.377B.0022.0002.618E][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.3774.0021.0002.6190][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.3776.0028.0002.61A4][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.377D.0030.0002.61AF][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.3781.0021.0002.61B2][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.3775.0025.0002.61DE][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.377B.0022.0002.61F2][.3801.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.377B.0022.0002.61F2][.3801.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.377B.0022.0002.61F2][.3801.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.3774.0022.0002.61F6][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.3774.0022.0002.61F6][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.3774.0022.0002.6200][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.3778.0026.0002.6210][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.3774.0022.0002.622E][.37FE.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.3772.0029.0002.6234][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.3780.002B.0002.62B1][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.3774.0021.0002.62C9][.37ED.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.3771.0024.0002.62CF][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.377D.0026.0002.62D3][.37F1.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.3776.0022.0002.62D4][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.3778.0022.0002.62FE][.37FF.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.3775.0027.0002.633D][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.377A.0027.0002.6350][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.3778.0039.0002.6368][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.3771.0024.0002.637B][.37F3.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.3778.0029.0002.6383][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.3774.0021.0002.63A0][.37EF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.377A.0025.0002.63A9][.37F1.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.377A.0030.0002.63C4][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.3778.0030.0002.641C][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.377B.0025.0002.6422][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.3775.0021.0002.6469][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.3771.0022.0002.649A][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.3781.0029.0002.649D][.37FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.3774.0023.0002.64C4][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.3775.0025.0002.654F][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.3775.0025.0002.654F][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.377A.0030.0002.6556][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.376F.0030.0002.656C][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.3778.0032.0002.6578][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.3774.0025.0002.6599][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.3774.0028.0002.65C5][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.376F.0035.0002.65E3][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.377A.0024.0002.6613][.37F3.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.377B.0026.0002.6649][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.377D.0022.0002.6674][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.377D.0022.0002.6674][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.3781.002A.0002.6688][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.3778.002B.0002.6691][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.3778.002B.0002.6691][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.3780.0022.0002.66B4][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.3774.0022.0002.66C6][.37F3.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.376F.0033.0002.66F4][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.3778.002D.0002.66F8][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.377D.0023.0002.6700][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.3774.0022.0002.6717][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.3774.0022.0002.6717][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.3774.0022.0002.6717][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.3775.0025.0002.671B][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.3775.0025.0002.671B][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.3774.0028.0002.674E][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.3780.0025.0002.6753][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.377B.002E.0002.6756][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.376F.0038.0002.675E][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.3771.0021.0002.677B][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.3774.0021.0002.6797][.3801.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.3774.0023.0002.67F3][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.3774.0023.0002.6817][.37FE.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.3774.0025.0002.6881][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.3775.0027.0002.6885][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.3775.0027.0002.6885][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.3774.0029.0002.68A8][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.3778.0062.0002.6942][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.376F.002A.0002.69EA][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.377A.0028.0002.6A02][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.377A.0028.0002.6A02][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.377A.0028.0002.6A02][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.3774.0024.0002.6A13][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.3774.0024.0002.6AD3][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.377B.0021.0002.6ADB][.37FF.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.3774.0023.0002.6B04][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.377D.0028.0002.6B21][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.3781.0025.0002.6B54][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.3778.0023.0002.6B72][.37F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.3774.0023.0002.6B77][.37F3.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.3774.0023.0002.6BAE][.37F3.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.3778.0023.0002.6BBA][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.3778.0023.0002.6BBA][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.3778.0023.0002.6BBA][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.3776.0025.0002.6C4E][.37F1.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.377D.0024.0002.6C88][.3801.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.377A.002B.0002.6CBF][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.3780.0024.0002.6CCC][.3801.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.3771.0022.0002.6CE5][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.3774.0021.0002.6D1B][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.3772.002A.0002.6D1E][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.3780.0029.0002.6D3E][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.3774.0025.0002.6D41][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.3774.0025.0002.6D41][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.3774.0025.0002.6D41][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.3781.002E.0002.6D69][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.3774.0023.0002.6D6A][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.3781.002A.0002.6D77][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.3781.002A.0002.6D77][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.377D.0025.0002.6D78][.3801.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.377A.0022.0002.6D85][.37F3.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.3774.0022.0002.6DCB][.3801.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.3774.0025.0002.6DDA][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.3774.0024.0002.6DEA][.37FE.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.377A.0026.0002.6DF9][.37F1.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.377B.002C.0002.6E1A][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.3781.002B.0002.6E2F][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.377A.002B.0002.6E6E][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.3774.0026.0002.6E9C][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.3771.0022.0002.6EBA][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.377B.002B.0002.6ECB][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.377B.002B.0002.6ECB][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.3781.0022.0002.6ED1][.37F6.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.3774.0026.0002.6F0F][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.3781.0026.0002.6F22][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.3781.0026.0002.6F22][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.3774.0024.0002.6F23][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.377B.0033.0002.6F6E][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.3776.003C.0002.6FC6][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.3774.0025.0002.6FEB][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.3774.002A.0002.6FFE][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.377A.002D.0002.701B][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.377B.003D.0002.701E][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.377B.003D.0002.701E][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.3781.002D.0002.7070][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.377B.002B.0002.707D][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.377B.002C.0002.7099][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.377F.0028.0002.70AD][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.3774.0025.0002.70C8][.37F3.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.3774.0022.0002.70D9][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.3774.0025.0002.7149][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.377B.002D.0002.716E][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.377B.002D.0002.716E][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.3774.0026.0002.71CE][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.3774.0023.0002.71D0][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.3774.0027.0002.7210][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.3774.0026.0002.721B][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.377D.0036.0002.7228][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.377B.0028.0002.7235][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.377B.0028.0002.7235][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.3774.0023.0002.7262][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.3778.0030.0002.7280][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.3776.0027.0002.72AF][.37F1.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.3778.0035.0002.72C0][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.3774.0024.0002.72FC][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.377B.002E.0002.732A][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.377B.002E.0002.732A][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.3774.0021.0002.7375][.37F3.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.3772.0023.0002.737A][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.3778.0021.0002.7387][.37F5.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.3778.0021.0002.7387][.37F5.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.377A.0025.0002.738B][.37F6.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.3774.0027.0002.73B2][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.3774.0023.0002.73DE][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.3774.002D.0002.7406][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.3774.0028.0002.7409][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.377F.002B.0002.7422][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.377A.003D.0002.745C][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.3781.002D.0002.7469][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.377B.0057.0002.7471][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.377B.0057.0002.7471][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.3774.0026.0002.7489][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.3774.0024.0002.7498][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.376F.003A.0002.74CA][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.3774.002A.0002.7559][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.3774.0022.0002.7565][.37EF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.377A.002C.0002.7570][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.377A.002C.0002.7570][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.3774.002F.0002.75E2][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.377A.0059.0002.7610][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.377A.0023.0002.761F][.37F5.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.3774.0027.0002.7642][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.3774.0023.0002.7669][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.377A.0022.0002.76CA][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.377A.0022.0002.76CA][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.3778.002B.0002.76DB][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.3774.0028.0002.76E7][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.377B.0021.0002.76F4][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.377B.0021.0002.76F4][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.3778.002C.0002.7701][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.377B.0033.0002.771E][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.377D.0023.0002.7740][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.377B.0034.0002.778B][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.3774.002C.0002.786B][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.3774.0021.0002.788C][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.3774.0021.0002.788C][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.3776.0038.0002.7891][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.3774.0024.0002.78CA][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.3776.0032.0002.78FB][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.3774.002B.0002.792A][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.3778.0046.0002.793E][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.376F.004C.0002.7948][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.377B.0035.0002.7949][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.377A.0032.0002.7950][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.377B.0039.0002.7956][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.377B.0039.0002.7956][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.377D.0023.0002.795D][.37FA.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.3778.002C.0002.795E][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.3778.0037.0002.7965][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.3774.0022.0002.797F][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.3781.0027.0002.798D][.37F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.377B.0044.0002.798E][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.3776.0028.0002.798F][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.3776.0028.0002.798F][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.3774.0023.0002.79AE][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.3771.0023.0002.79CA][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.377D.0024.0002.79EB][.37FA.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.3774.0023.0002.7A1C][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.376F.0025.0002.7A40][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.376F.0025.0002.7A40][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.3772.0022.0002.7A81][.37F5.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.3774.0022.0002.7ACB][.3801.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.3774.0023.0002.7B20][.3801.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.377B.0027.0002.7BC0][.37F1.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.377B.0027.0002.7BC0][.37F1.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.377B.003D.0002.7BC6][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.377D.0026.0002.7BC9][.37FA.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.3774.0025.0002.7C3E][.37F3.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.3774.0026.0002.7C60][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.3774.0024.0002.7C92][.3801.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.377B.0047.0002.7CBE][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.3772.0029.0002.7CD6][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.3774.0029.0002.7CE7][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.376F.004F.0002.7D00][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.3771.0022.0002.7D10][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.3778.0023.0002.7D22][.37EE.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.3774.0028.0002.7D2F][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.377B.0063.0002.7D5B][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.3776.0034.0002.7D63][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.3774.0023.0002.7DA0][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.3774.0024.0002.7DBE][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.377D.0030.0002.7DC7][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.3774.0027.0002.7DF4][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.3774.0027.0002.7DF4][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.3774.0027.0002.7DF4][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.377B.0036.0002.7E09][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.3774.0029.0002.7E37][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.3776.0026.0002.7E41][.37F1.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.3778.0052.0002.7E45][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.3776.0035.0002.7F3E][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.3778.0035.0002.7F72][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.3774.0031.0002.7F79][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.3774.0024.0002.7F85][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.3774.0029.0002.7F9A][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.377A.0036.0002.7FBD][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.376F.005A.0002.7FFA][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.3774.0029.0002.8001][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.377B.0033.0002.8005][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.377B.0033.0002.8005][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.377B.0033.0002.8005][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.3774.002B.0002.8046][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.3774.0028.0002.806F][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.377D.0028.0002.8070][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.3774.0027.0002.807E][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.3774.0022.0002.808B][.37FF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.3771.0023.0002.80AD][.37FA.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.377A.0024.0002.80B2][.37FE.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.3776.003F.0002.813E][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.3774.0022.0002.81D8][.37ED.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.3774.0024.0002.81E8][.3801.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.377D.002A.0002.81ED][.37FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.377A.002E.0002.8201][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.377A.002E.0002.8201][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.3774.002A.0002.826F][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.377A.0037.0002.828B][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.377B.003B.0002.829D][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.3781.0029.0002.82B1][.37F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.3776.0035.0002.82B3][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.377A.0029.0002.82BD][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.377A.0023.0002.82E5][.37EF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.377A.0023.0002.82E5][.37EF.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.376F.003A.0002.82E6][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.377D.002E.0002.831D][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.377A.004C.0002.8323][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.3772.0022.0002.8336][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.3781.0034.0002.8352][.37F6.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.3775.002A.0002.83BD][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.3774.0024.0002.83C9][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.376F.0023.0002.83CA][.37FA.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.376F.0025.0002.83CC][.37FE.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.377D.0029.0002.83DC][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.3781.002A.0002.83EF][.37F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.3774.0025.0002.83F1][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.3774.0025.0002.843D][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.377A.0023.0002.8449][.37F3.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.377B.0034.0002.8457][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.377B.0034.0002.8457][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.3774.0029.0002.84EE][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.3780.002A.0002.84F1][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.3774.002A.0002.84FC][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.377A.0062.0002.8564][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.3774.0028.0002.85CD][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.3774.0025.0002.85FA][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.3774.002A.0002.8606][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.3774.0027.0002.862D][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.3774.0025.0002.863F][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.3781.0023.0002.8650][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.3774.002B.0002.865C][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.3774.002B.0002.865C][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.3781.0025.0002.8667][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.377D.0034.0002.86A9][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.377B.0026.0002.8728][.37F1.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.3774.0026.0002.87BA][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.3774.0023.0002.881F][.37ED.0020.0002][.385B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.3781.0025.0002.884C][.37EE.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.377A.0030.0002.8863][.3800.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.3774.0026.0002.88C2][.37F3.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.3774.0034.0002.88CF][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.3774.0035.0002.88E1][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.3774.0027.0002.88F8][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.376F.0028.0002.8910][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.376F.0034.0002.8941][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.3774.0029.0002.8964][.37ED.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.3776.002D.0002.8986][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.376F.0028.0002.898B][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.3778.0037.0002.8996][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.3778.0037.0002.8996][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.3778.0031.0002.8AA0][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.3778.002B.0002.8AAA][.37F1.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.3778.002B.0002.8AAA][.37F1.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.377B.0046.0002.8ABF][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.377D.0026.0002.8ACB][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.3774.002B.0002.8AD2][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.3774.0021.0002.8AD6][.37F5.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.377A.0046.0002.8AED][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.377A.0046.0002.8AED][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.377B.0030.0002.8AF8][.37F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.377B.0030.0002.8AF8][.37F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.3771.0021.0002.8AFE][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.3771.0021.0002.8AFE][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.377A.0022.0002.8B01][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.377A.0022.0002.8B01][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.376F.002D.0002.8B39][.37FF.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.376F.002D.0002.8B39][.37FF.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.3778.002C.0002.8B58][.3801.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.3772.002A.0002.8B80][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.3776.0023.0002.8B8A][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.3776.0023.0002.8B8A][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.376F.0057.0002.8C48][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.3778.003B.0002.8C55][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.376F.002E.0002.8CAB][.37F6.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.3776.0032.0002.8CC1][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.3774.0025.0002.8CC2][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.376F.0039.0002.8CC8][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.3776.002D.0002.8CD3][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.377B.002B.0002.8D08][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.377B.002B.0002.8D08][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.376F.0039.0002.8D1B][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.376F.0058.0002.8D77][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.3776.0027.0002.8DCB][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.3774.002C.0002.8DEF][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.377D.002D.0002.8ECA][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.3774.002A.0002.8F26][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.3774.0026.0002.8F2A][.37FE.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.3778.004F.0002.8F38][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.3778.004F.0002.8F38][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.3776.002F.0002.8F3B][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.3774.0026.0002.8F62][.37F3.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.377B.003E.0002.8FB0][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.3774.002B.0002.9023][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.377A.0027.0002.9038][.3801.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.377A.0027.0002.9038][.3801.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.377B.0041.0002.9072][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.3774.002B.0002.907C][.37F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.3774.0028.0002.908F][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.3774.0028.0002.90DE][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.3772.0045.0002.90FD][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.3774.0026.0002.916A][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.3774.0024.0002.91B4][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.3774.0036.0002.91CC][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.3774.002D.0002.91CF][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.376F.0021.0002.91D1][.3801.0020.0002][.385A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.3774.002D.0002.9234][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.3776.002F.0002.9238][.37ED.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.3776.0039.0002.927C][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.3781.003F.0002.92D7][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.3774.0025.0002.9304][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.3774.002C.0002.934A][.37F3.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.376F.0033.0002.958B][.37EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.3774.002E.0002.95AD][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.377A.0031.0002.962E][.37F6.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.3774.002D.0002.964B][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.376F.0037.0002.964D][.37ED.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.3774.0026.0002.9675][.37FF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.3774.0023.0002.9678][.37FE.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.377B.004E.0002.967C][.37F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.3774.0021.0002.9686][.37FE.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.3774.0027.0002.96A3][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.3774.0025.0002.96B7][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.3774.0026.0002.96B8][.37F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.3774.0038.0002.96E2][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.3771.0023.0002.96E3][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.3771.0023.0002.96E3][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.3774.002E.0002.96F6][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.3774.0028.0002.96F7][.37F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.377A.0031.0002.9723][.37FA.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.3774.002E.0002.9732][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.3774.002F.0002.9748][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.377B.0054.0002.9756][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.377B.0054.0002.9756][.37F1.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.3780.0034.0002.97E0][.3801.0020.0002][.3852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.3781.0026.0002.97FF][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.3781.0026.0002.97FF][.37EF.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.3774.0030.0002.9818][.37F3.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.3776.002E.0002.983B][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.3776.002E.0002.983B][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.3774.002E.0002.985E][.37FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.376F.005B.0002.98E2][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.3776.0039.0002.98EF][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.3778.005A.0002.98FC][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.376F.0030.0002.9928][.37F6.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.3774.0027.0002.99F1][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.3774.0030.0002.9A6A][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.377B.004C.0002.9B12][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.377B.004C.0002.9B12][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.3774.002F.0002.9B6F][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.3774.0028.0002.9C57][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.3781.0025.0002.9DB4][.37ED.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.3774.0030.0002.9DFA][.37F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.3774.0028.0002.9E1E][.37ED.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.3774.0026.0002.9E7F][.37F5.0020.0002][.384B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.3774.0031.0002.9E97][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.3774.0029.0002.9E9F][.3801.0020.0002][.384E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.3775.0028.0002.9EBB][.37ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.3774.0032.0002.9ECE][.37F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.3776.004A.0002.9F3B][.3801.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.3774.0021.0002.9F8D][.37F9.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.3774.002E.0002.9F8E][.37F5.0020.0002][.385F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.376F.0056.0002.9F9C][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.376F.0056.0002.9F9C][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.376F.0056.0002.9F9C][.37FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
