NAME

    App::ChatWorkDescriber - A describer which watches ChatWork room's
    message, and says more describe if needed

SYNOPSIS

      use App::ChatWorkDescriber;
      my $token = "your secret token";
      my $room_name = "room name to watch, and describe";
    
      my $describer = App::ChatWorkDescriber->new( verbose => 1 );
      $describer->set_api( $token );
      $describer->set_ticker;
      $describer->add_room( $room_name );
      $describer->loop;

DESCRIPTION

    This module posts titled URL when it found blunt messages.

    I do not want to see the message which includes only URL. It has no
    information to wether should I need to see it, or how quickly to see?

    The best solution I think is, ChatWork adds title, and description when
    the message includes only URL.

    But, ChatWork does not. Thus, I wrote this module to describe the URL
    only message.

    The worst point of this module is, make message duplicate. Describing
    message needs to post a new described message, then there exists two
    messages; these are, original message, and new described message. If
    you, and your roommates do not care that, this module keeps you, and
    your roommates mind stable.

