# Generated by default/object.tt
package Paws::AuditManager::Role;
  use Moose;
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest']);
  has RoleType => (is => 'ro', isa => 'Str', request_name => 'roleType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Role

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Role object:

  $service_obj->Method(Att1 => { RoleArn => $value, ..., RoleType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Role object:

  $result = $service_obj->Method(...);
  $result->Att1->RoleArn

=head1 DESCRIPTION

The wrapper that contains the AWS Audit Manager role information of the
current user, such as the role type and IAM Amazon Resource Name (ARN).

=head1 ATTRIBUTES


=head2 RoleArn => Str

The Amazon Resource Name (ARN) of the IAM role.


=head2 RoleType => Str

The type of customer persona.

In C<CreateAssessment>, C<roleType> can only be C<PROCESS_OWNER>.

In C<UpdateSettings>, C<roleType> can only be C<PROCESS_OWNER>.

In C<BatchCreateDelegationByAssessment>, C<roleType> can only be
C<RESOURCE_OWNER>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

