## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Uk v1.1.4;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Uk::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=for stopwords CTAN Ipenburg Uk

=head1 NAME

TeX::Hyphen::Pattern::Uk - class for hyphenation in locale Uk

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 COPYRIGHT

=begin text
title: Hyphenation patterns for Ukrainian
copyright: Copyright (C) 1998-2001 Maksym Polyakov
notice: This file is part of the hyph-utf8 package.
    See http://www.hyphenation.org/tex for more information.
language:
    name: Ukrainian
    tag: uk
version: 2001/05/10
authors:
  -
    name: Maksym Polyakov
    contact: polyama (at) auburn.edu, mpoliak (at) i.com.ua
licence:
    name: LPPL
    url: https://latex-project.org/lppl/
hyphenmins:
    typesetting:
        left: 2
        right: 2
texlive:
    encoding: t2a
    babelname: ukrainian
    use_old_patterns_comment: The old system allows choosing patterns and encodings manually. That mechanism needs to be implemented first in this package, so we still fall back on old system.
    legacy_patterns: ukrhyph.tex
    message: Ukrainian hyphenation patterns
    description: |-
        Hyphenation patterns for Ukrainian in T2A and UTF-8 encodings.
        For 8-bit engines, the 'ukrhyph' package provides a number of
        different pattern sets, as well as different (8-bit) encodings, that
        can be chosen at format-generation time.  The UTF-8 version only
        provides the default pattern set.  A mechanism similar to the one used
        for 8-bit patterns may be implemented in the future.
=end text

=cut

__DATA__
\patterns{
%% break words into syllables (rules60 \S 30);
%% breakpoints between consecutive consonants
%% according to the phonetical principles
2а1 а3а а3е а3і а3о а3у а3ю а3я а3є а3ї
2е1 е3а е3е е3і е3о е3у е3ю е3я е3є е3ї
2и1 и3а и3е и3і и3о и3у и3ю и3я и3є и3ї
2і1 і3а і3е і3и і3о і3у і3ю і3я і3є і3ї
2о1 о3а о3е о3і о3о о3у о3ю о3я о3є о3ї
2у1 у3а у3е у3і у3о у3у у3ю у3я у3є у3ї
2ю1 ю3а ю3е ю3і ю3о ю3у ю3ю ю3я ю3є ю3ї
2я1 я3а я3е я3о я3у я3ю я3я я3є я3ї
2є1 є3у є3ю є3є є3ї
2ї1 ї3е ї3о ї3ю
2б1к 2б1п 2б1с 2б1т 2б1ф 2б1х 2б1ц 2б1ч
2б1ш 2б1щ 2в1б 2в1г 2в1д 2в1ж 2в1з 2в1к
2в1л 2в1м 2в1н 2в1п 2в1р 2в1с 2в1т 2в1ф
2в1х 2в1ц 2в1ч 2в1ш 2в1щ 2в1й 2в'3 2г1к
2г1п 2г1с 2г1т 2г1ф 2г1ц 2г1ч 2г1ш 2д1к
2д1п 2д1с 2д1т 2д1ф 2д1х 2д1ц 2д1ч 2д1ш
2д1щ 2ж1к 2ж1п 2ж1с 2ж1т 2ж1ф 2ж1х 2ж1ц
2ж1ч 2ж1ш 2з1к 2з1п 2з1с 2з1т 2з1ф 2з1х
2з1ц 2з1ч 2з1ш 2з1щ 2к1б 2к1г 2к1д 2к1з
2л1б 2л1в 2л1г 2л1ґ 2л1д 2л1ж 2л1з 2л1к
2л1м 2л1н 2л1п 2л1р 2л1с 2л1т 2л1ф 2л1х
2л1ц 2л1ч 2м1б 2м1в 2м1г 2м1д 2м1ж 2м1з
2м1к 2м1л 2м1н 2м1п 2м1р 2м1с 2м1т 2м1ф
2м1х 2м1ц 2м1ч 2м1ш 2м1щ 2м'3 2н1б 2н1в
2н1г 2н1д 2н1ж 2н1з 2н1к 2н1л 2н1м 2н1п
2н1р 2н1с 2н1т 2н1ф 2н1х 2н1ц 2н1ч 2н1ш
2н1щ 2н'3 2п1б 2п1д 2п1з 2р1б 2р1в 2р1г
2р1ґ 2р1д 2р1ж 2р1з 2р1к 2р1л 2р1м 2р1н
2р1п 2р1с 2р1т 2р1ф 2р1х 2р1ц 2р1ч 2р1ш
2р1щ 2р1й 2р'3 2с1б 2с1г 2с1д 2т1б 2т1г
2т1д 2т1ж 2т1з 2ф1б 2ф1г 2ф1з 2х1г 2х1д
2ц1б 2ц1г 2ц1д 2ц1з 2ч1б 2ч1д 2ч1ж 2ш1б
2ш1г 2й1б 2й1в 2й1г 2й1д 2й1ж 2й1з 2й1к
2й1л 2й1м 2й1н 2й1п 2й1р 2й1с 2й1т 2й1ф
2й1х 2й1ц 2й1ч 2й1ш 2й1щ 2дь1к 2дь1с 2дь1т
2дь1ц 2зь1к 2зь1с 2зь1т 2ль1б 2ль1в 2ль1г 2ль1д
2ль1ж 2ль1з 2ль1к 2ль1м 2ль1н 2ль1п 2ль1р 2ль1с
2ль1т 2ль1ф 2ль1х 2ль1ц 2ль1ч 2ль1ш 2ль1щ 2ль1й
2нь1б 2нь1г 2нь1з 2нь1к 2нь1л 2нь1м 2нь1с 2нь1т
2нь1х 2нь1ц 2нь1ч 2нь1ш 2нь1й 2рь1к 2рь1ц 2сь1б
2сь1д 2ть1б
2к1сп 2к1ст 2к1ськ 2п1сп 2п1ст 2п1ськ 2с1пк 2с1пп
2с1пс 2с1пт 2с1пх 2с1пч 2с1ськ 2с1тк 2с1тп 2с1тс
2с1тсь 2с1тт 2с1тф 2с1тц 2с1шт 2сь1кк 2сь1кс 2сь1кт
2т1ск 2т1сп 2т1ст 2т1ськ 2т1шк 2ф1сп 2ф1ст 2ф1ськ
2ф1шт 2х1ст 2х1ськ 2ц1ст 2ц1шк 2ш1тк 2ш1тсь
% breakpoint between doubled consonants (rules60 \S 30 p. 1)
2б1б 2в1в 2г1г 2ґ1ґ 2д1д 2ж1ж 2з1з 2к1к
2л1л 2м1м 2н1н 2п1п 2р1р 2с1с 2т1т 2ф1ф
2х1х 2ц1ц 2ч1ч 2ш1ш 2щ1щ 2й1й
% ... but in some cases dual hyphenation possible
% ... (rules60 \S 30 p. 1)
3ння 3ття 3ттю 3лля 3ллє 3ллю 3ддя
% don't break dzh dz (rules60 \S 30 p. 2)
д4ж д4з
% don't cut j off previous vovel
% except when j folowed by o (rules60 \S 30 p. 3)
а2й е2й и2й і2й о2й у2й ю2й я2й є2й ї2й 3й6о
% don't cut apostrophe and soft sign off previous letter,
% don't break softsign o (rules60 \S 30 p. 4)
ь6о 6' 6ь
% don't cut off one letter at the beginning
% and the end of the word (rules60 \S 30 p. 5)
% -- this will be done by lefhyphenmin and righthyphenmin
% prevents cutting off series of consecutive consonants
% not forming a syllable at the beginning and the end of word
.б'8 .в'8 .д'8 .з'8 .м'8 .н'8 .п'8 .р'8
.т'8 .ф'8 .ш'8 .бд6 .бр6 .вб6 .вб6'6 .вв6'6
.вг6 .вд6 .вж6 .вз6 .вз6д6 .вк6 .вл6 .вм6
.вм6'6 .вп6 .вп6'6 .вп6х6 .вс6 .вс6т6 .вт6 .вш6к6
.дж6 .дз6 .дл6 .дс6 .зб6 .зв6'6 .зг6 .зд6
.зд6з6 .зл6 .зм6'6 .зс6 .зс6к6 .зс6т6 .зч6 .зш6
.зш6к6 .зґ6 .йш6 .кл6 .кп6 .кс6 .кх6 .кш6
.лк6с6 .лс6 .ль6 .мс6 .мф6 .нб6 .пр6 .пс6
.пх6 .рт6 .ск6 .ск6л6 .сл6 .сп6 .сп6'6 .сп6л6
.сп6х6 .ст6 .сх6 .сх6л6 .тк6 .тр6 .тх6 .ть6
.фл6 .хл6 .ць6 .чх6 .шк6 .шл6 .шп6 .шт6
6бв. 6бз. 6бй. 6бл. 6б6ль. 6бн. 6бр. 6бс.
6б6ст. 6б6с6тв. 6б6с6тр. 6б6с6ьк. 6б6ць. 6вб. 6вв. 6вд.
6в6др. 6в6дь. 6вж. 6вз. 6в6зь. 6вй. 6вк. 6вл.
6в6ль. 6вм. 6вн. 6вп. 6вр. 6вс. 6в6с6тв. 6в6с6ть.
6в6сь. 6в6с6ьк. 6вт. 6вх. 6в6ць. 6вч. 6вш. 6вщ.
6гв. 6гг. 6гд. 6гл. 6г6ль. 6гм. 6гн. 6гр.
6гс. 6г6с6тв. 6г6сь. 6гт. 6дж. 6дз. 6д6зь. 6дл.
6дм. 6дн. 6др. 6д6с6тв. 6д6с6ьк. 6дт. 6дь. 6д6ь6сь.
6жб. 6жв. 6ж6дь. 6ж6сь. 6зв. 6зг. 6зд. 6з6дв.
6з6дн. 6з6дь. 6зк. 6зл. 6зм. 6зн. 6з6нь. 6зр.
6з6сь. 6зь. 6з6ьб. 6з6ьк. 6йб. 6йв. 6йг. 6йд.
6йз. 6йк. 6й6кл. 6йл. 6й6ль. 6йм. 6й6мс. 6йн.
6й6нс. 6йп. 6йр. 6йс. 6й6ст. 6й6с6тв. 6й6с6тр. 6й6сь.
6й6с6ьк. 6йт. 6й6тс. 6йф. 6йх. 6йц. 6йч. 6йш.
6кв. 6кк. 6кл. 6к6ль. 6кр. 6кс. 6к6ст. 6к6сь.
6кт. 6к6тр. 6кх. 6кш. 6лб. 6лг. 6лд. 6лк.
6лл. 6л6ль. 6лм. 6л6мс. 6лн. 6лп. 6лс. 6лт.
6л6хв. 6ль. 6л6ьб. 6л6ьв. 6л6ьг. 6л6ьд. 6л6ь6дс. 6л6ьз.
6л6ьк. 6л6ьм. 6л6ьн. 6л6ьп. 6л6ьс. 6л6ь6ств. 6л6ь6сь. 6л6ь6ськ.
6л6ьт. 6л6ь6тр. 6л6ьф. 6л6ьх. 6л6ьц. 6л6ьч. 6л6ьш. 6л6ьщ.
6мб. 6м6б6ль. 6м6бр. 6мг. 6мж. 6мк. 6мл. 6м6ль.
6мм. 6мн. 6мп. 6мр. 6мс. 6м6с6тв. 6м6сь. 6м6с6ьк.
6мт. 6мф. 6мх. 6мш. 6нв. 6нг. 6н6гл. 6н6г6ль.
6н6гр. 6н6гс. 6нд. 6н6дж. 6н6дз. 6н6дп. 6н6др. 6нж.
6нз. 6нк. 6н6кс. 6н6кт. 6нм. 6нн. 6нр. 6нс.
6н6ск. 6н6ст. 6н6с6тв. 6н6с6тр. 6н6с6ьк. 6н6с6ькй. 6нт. 6н6тк.
6н6тр. 6н6т6ств. 6н6ть. 6нф. 6нх. 6нц. 6н6ць. 6нч.
6нш. 6нь. 6н6ьб. 6н6ьг. 6н6ьк. 6н6ь6сь. 6пд. 6пл.
6пр. 6пс. 6п6с6тв. 6п6сь. 6пт. 6п6тр. 6пф. 6пц.
6рб. 6рв. 6рг. 6рд. 6р6дв. 6р6дж. 6р6дь. 6рж.
6рз. 6р6зн. 6р6зь. 6рк. 6р6кс. 6р6кт. 6рл. 6р6ль.
6р6л6ьз. 6рм. 6рн. 6р6нс. 6р6н6ст. 6р6нь. 6рп. 6рр.
6рс. 6р6ср. 6р6ст. 6р6с6тв. 6р6с6ть. 6р6сь. 6р6с6ьк. 6рт.
6р6тв. 6р6тр. 6р6ть. 6рф. 6рх. 6рц. 6р6ць. 6рч.
6рш. 6рщ. 6р6щ6сь. 6рь. 6с6дп. 6с6д6рп. 6ск. 6сл.
6с6ль. 6см. 6сн. 6сп. 6сс. 6ст. 6с6тв. 6с6тй.
6с6тм. 6с6тр. 6с6т6рь. 6с6ть. 6с6ць. 6сь. 6с6ьб. 6с6ьк.
6с6ьм. 6тв. 6т6вт. 6т6зт. 6тл. 6т6ль. 6тм. 6т6мр.
6тр. 6тс. 6т6с6тв. 6т6с6ьк. 6тт. 6тц. 6тч. 6ть.
6т6ь6сь. 6фм. 6фр. 6ф6с6тв. 6фт. 6ф6ть. 6фф. 6фь.
6хв. 6хм. 6хн. 6хр. 6хт. 6хш. 6ц6тв. 6ць.
6ц6ьк. 6чб. 6чм. 6чн. 6чт. 6шв. 6ш6ль. 6шм.
6шн. 6ш6нл. 6ш6сь. 6шт. 6ш6тв. 6щ6сь.
% don't break prefixes consisting of one syllable (rules60 \S 30 p. 6)
.бе4з'3
.бе4з3
.безу4
.бе5з4о3д
.без5о4соб
.безві4д3
.без3ро4з3
виї4
.ві5д4ом
.ві5д4озв
.ві5д4ун
віду4ч
.ві5д4а
.ві5д4ер
.ві5д4і
.ві4д3
.від'3
.мі4ж3
безві4д3
ові4д3
ді4єві4д3
за4вві4д3
неві4д'3
неві4д3
про4ф3ві4д3
спе4ц3ві4д3
співві4д3
те4х3ві4д3
.пере4д3бач
.пере4д3виб
.пере4д3г
.пере4д3д
.пере4д3м
.пере4д3ост
.пере4д3пла
.пере4д3пок
.пере4д3р
.пере4д3св
.пере4д3умов
.пере4д3усі
.пере4д3фр
.пере4д3ч
.пере4д'3
.пере3
.пона4д3
.пона5д4і
.пона5д4и
.пона5д4я
3п4ре
3п4ри
приї4
3п4ро
3п4рі
.пі5д4о
.пі5д4і
.під'3
.пі4д3
.пі5д4е
.пі5д4и
.пі5д4у
.пі4в3
.спі4в3
.напі4в3
.ро5з4і
.ро5з4е
ро5з4йом
.ро5з4а
.ро4з'3
.ро4з3
.чере4з'3
.чере4з3
оо4б
ооб'3
ооб3м
ооб3ро
об'3
од'3
на4д'3
за5о4р
до5о4р
по5о4р
пере5о4р
пі6д5о4р
бе4з5і4дей
до3в'4є
за3в'4є
зі3в'4є
обі3в'4є
по3в'4є
уі3в'4є
з3в'4я
по3в'4я
від3в'4я
за3в'4я
зі3в'4я
за3ю4ш
на3в'4я
непо3в'4я
об3в'4я
при3в'4я
під3в'4я
у3в'4я
з3м'4я
зі3м'4я
у3м'4я
в3м'4я
но3м'4я
за3м'4я
на3м'4я
об3м'4я
пере3м'4я
по3м'4я
при3м'4я
піді3м'4я
су3м'4я
до3в'4ю
за3в'4ю
зі3в'4ю
на3в'4ю
по3в'4ю
уі3в'4ю
інтер3в'4ю
за3я4ло
коу4роч
зу4роч
наду4роч
позау4роч
поу4роч
приу4роч
на4й3у4бог
нао4р
прио4р
неу4к
% don't break part of root not forming syllable
% (rules60 \S 30 pp. 7, 8, 9)
3в4б4лаг
3в4к4лад
3в4п4лив
3в4п4равн
3в4р4одлив
3в4т4рут
3в4т4руч
3з4б4рой
3з4б4рою
3з4б4роє
3з4в4'яз
3й4ш4л
3м4к4не
3м4к4ну
3м4к4ні
3п4с4ков
3с4к4лад
3с4к4ле
3с4к4лит
3с4к4ло
3с4к4рипт
3с4п4лав
3с4п4лат
3с4п4лач
3с4п4рав
3с4п4ритн
3с4п4рият
3с4п4ромо
3с4т4вор
3с4т4ражд
3с4т4рах
3с4т4риб
3с4т4риж
3с4т4рой
3с4т4рок
3с4т4ром
3с4т4роф
3с4т4роч
3с4т4рою
3с4т4роя
3с4т4роє
3с4т4рої
3с4т4рукт
3с4т4рукц
3с4т4рій
3с4т4ріл
3с4т4річ
3т4к4нен
3т4ь4мар
3т4ь4мяні
3у4п4рав
3блаж
3ближ
3близ
3блиск
3блок
3блоці
3бран
3брати
3брест
3бризк
3британ
3бруд
3в4бив
3в4веден
3в4дал
3в4довз
3в4довол
3в4живан
3в4лад
3в4ласн
3в4лашт
3в4лов
3в4певн
3в4поряд
3в4разлив
3в4рожай
3в4сюд
3в4тіл
3глад
3глиб
3глин
3глоб
3глуз
3глуш
3гляд
3глян
3гнан
3гнил
3гноз
3гнучк
3грав
3град
3грай
3грам
3гран
3грати
3граф
3граш
3граю
3грає
3грес
3грець
3гроб
3грож
3гроз
3громад
3груван
3грунт
3груп
3грів
3гріт
3гріш
3г4ідро
3д4ан
3д4бав
3д4бал
3д4бан
3д4бат
3д4бає
3двиг
3двою
3двоє
3двій
3двір
3двічі
3драж
3дром
3друж
3друк
3дряп
3дріб
3дріма
3жвав
3жміть
3жріть
3з4бага
3з4баланс
3з4був
3з4бут
3зваж
3зван
3звед
3звел
3звест
3звись
3звич
3звищ
3зворуш
3звук
3звуч
3звіт
3з4год
3з4дат
3з4довж
3з4доров
3з4дійсн
3змін
3зйом
3зміш
3знав
3знай
3знак
3знал
3знан
3знат
3знаход
3знач
3знаю
3знає
3зниж
3знім
3зрозум
3зрюв
3зрів
3зріл
3зрін
3з4чеп
3й4ма
3й4менн
3й4мищ
3й4мовірн
3й4му.
3й4муть
3й4міть
3й4шов
3м4нож
3м4ріть
3м4щен
3п4сов
3п4сон
3п4сув
3р4вав
3р4вати
3р4віть
3с4кид
3с4кок
3с4коп
3с4кор
3с4короч
3с4коч
3с4кіль
3с4кіпл
3с4пад
3с4пект
3с4перм
3с4пин
3с4повід
3с4пожив
3с4постер
3с4пі
3с4піть
3с4піш
3с4табіл
3с4тав
3с4тад
3с4таз
3с4тайн
3с4тал
3с4тан
3с4тар
3с4тара
3с4тат
3с4тач
3с4тає
3с4теп
3с4тереж
3с4теріг
3с4тиг
3с4тиж
3с4тисл
3с4титу
3с4товб
3с4той
3с4торон
3с4торін
3с4тосо
3с4тосу
3с4тою
3с4тоян
3с4туп
3с4тяг
3с4тіб
3с4тій
3с4тіль
3с4тір
3с4фер
3с4хил
3с4хов
3с4хід
3т4кан
3х4то
3ш4код
3ш4кол
3ш4кідл
3ш4кіл
3ш4кір
3ш4таб
3ш4туч
3ґрунт
3а4вторит
3а4гент
3а4грес
3а4декват
3а4дитив
3а4зарт
3а4ктив
3а4ктуал
3а4курат
3а4куст
3а4кцепт
3а4кциз
3а4лергі
3а4матор
3а4наліз
3а4натом
3а4парат
3а4пеляц
3а4постол
3а4птеч
3а4ргумен
3а4ромат
3а4соці
3а4спект
3а4тлет
3а4халі
3е4колог
3е4коном
3е4легант
3е4лектр
3е4лемент
3е4моці
3е4мігр
3е4нерг
3е4стакад
3е4стет
3е4тап
3о4б'єдн
3о4б'єкт
3о4береж
3о4бира
3о4борон
3о4бід
3о4біц
3о4даль
3о4дяг
3о4збро
3о4крем
3о4перат
3о4плат
3о4птим
3о4пуст
3о4пуше
3о4пуще
3о4рдинац
3о4ренд
3о4соб
3о4сяжн
3о4холо
3о4хорон
3о4хоч
3о4чисн
3о4чищ
3у4ваг
3у4важ
3у4гав
3у4згод
3у4клад
3у4компл
3у4крупн
3у4люблен
3у4мит
3у4міл
3у4перед
3у4разлив
3у4рбан
3у4рочист
3у4ряд
3у4рядов
3у4спіш
3у4станов
3у4стпіш
3у4сувати
3у4твор
3у4тробн
3я4дерн
3я4зик
3я4кіс
3я4рус
3я4скрав
3є4д3н
3є4дин
3є4писк
3є4рей
3і4зотоп
3і4люстр
3і4мовір
3і4нтенс
3і4нформ
3і4ніціат
3і4снув
3ї4ждж
3ї4зд
3ї4ст
3ї4хав
3ї4хат
.заї4к
.заї4ц
.заї4ч
.наї4д
'ї4в
'ї4з
'ї4д
'ї4ж
'ї4л
'ї4м
'ї4с
'ї4х
аві4а
авої4д
ае4тил
альбі5он
ахої4д
ауді4о
ай4с3берг
бактері4о
ба4с3енер
ба4с3антра
.бе5зе.
бей4сбол
бе5кон
б'4єть
бйор4нс
бі4о3
бо4г3дан
бран4д
брі4дж3порт
без5і4мен
бо4є3гол
бо4є3гот
бо4є3зап
бо4є3здат
бо4є3комп
бо4є3пост
бо4є3прип
бори4с5п
4в3антрац
вер4х3н
ви3й4д
вина3й4д
ви3й4т
вина3й4т
від7зна
ві5д4ен
ві5д4е4о
ві5д4ом
від5о4браж
від5о4браз
во4с5ко
водо5с4ток
водо5з4бір
воль4т3метр
воль4т3ампер
3в'4яз
ге2ть3ман
ге4о
го4с4п5роз
гі4д5ро5мет
4д7зем
дер4ж5а4том
дер4ж5а4дм
дер4ж5бюдж
дер4ж5вид
дер4ж5дум
дер4ж5замов
дер4ж5ком
дер4ж5нафт
дер4ж5реєс
дер4ж3без
дер4ж3резерв
дер4ж5стр
дер4ж5служ
двох4а5том
джен4тль
дисбаланс
ди4с3гарм
ди4с3квал
ди4с3комф
ди4с3конт
ди4с3кред
ди4с3крет
ди4с3крец
ди4с3крим
ди4с3кусі
ди4с3куту
ди4с3лок
ди4с3парит
ди4с3перс
ди4с3петч
ди4с3пле
ди4с3плей
ди4с3пози
ди4с3проп
ди4с3пут
ди4с3тил
ди4с3триб
ди4с3троф
ди4с3функц
ді3й4т
ді3й4д
д4ні3п4р
.дої4в
.дої4л
.дої5ль
дої4д
дої4м
дої4х
дої4ж
дої4ст
до3з4вол
до3з4віл
дорого5в4каз
еу4стр
ео4сві
енерго3з4береж
енерго3з4беріг
ек2с1к
ек2с1п
ек2с1т
ек2с1ц
єв4р3атом
єпі4с5коп
єпи4с5коп
за4п3част
заї4д
заї4ж
заї4з
заї4л
заї4м
заї4х
зе4кономити
3з'4ясо
зна3й4д
зна3й4т
зо4ка
зо4ке
зо4ки
зо4ку
зо4кі
игої4д
ий4ти
іе4тил
і4л3е4тил
ій4ти
інфор4м3аген
йо4сві
каза4х3стан
квої4д
корої4д
квар4т3плат
киї4венер
кон4трре
кон4тр3арг
жко4м5а4том
кому4ненерг
мі4н5е4ко
мі4н5е4нер
мо4к5рий
3м'4якш
3м'4ят
на3б4лиз
на3в4ряд
на3в4ча
на3з4в
на4д7з4в
наї4вс
наї4вш
наї4ж
наї4з
наї4л
наї4м
наї4с
наї4х
на4й3а
на4й3е
на4й3обереж
на4й7о4бер
на4й7о4гид
на4й7о4гол
на4й7о4гряд
на4й7о4пук
на4й7о4хай
на4й3масл
на4й3спри
на4й3якіс
на3в4чен
на3в4чіть
не3в4том
не3д4бан
на3д4бан
не3з4вич
не3з4важ
нео4пал
недої4
неї4ст
на5п4лив
ні4т5рат
оної4д
оо4пал
ео4пал
обі3д4ран
обі3й4д
обі3й4т
об5у4мов
онаї4д
оо4сві
оо4к
оу4стр
оа4том
об4лдер4ж
об4л3а4дмін
переї4д
переї4ж
переї4з
переї4л
переї4с
переї4х
пере5п4лив
пере3й4д
пре4й4с
пере3й4т
перег4ній
перед5о4бід
пере3в4том
пере4д5см
перед5у4мов
під5о4дин
пів5о4с4тр
пі5в4ень
по3б4лизу
по3в4тор
поч4не
поч4ни
поч4ну
поя4в
по3в4чен
по3в4чіть
по3д4роб
по3д4раз
по3д4во
по5ж4ніть
по5з4бав
.пої4
пої4д
прої4
пої4зд
по4с4т5радян
по4с4т5кому
по4с4т3декр
по4с4т3контра
по4с4т3менопауз
по4с4тприват
по4с4т3раді
по4с4т5соці
пос4т3кап
пос4т3ком
пос4т3нат
пос4т3проц
пос4т3соц
пос4т3фікс
при3й4т
про3с4тирад
про4ф3с
полі4т5екон
пор4т3н
пор4т3рет
пор4т3фел
при3й4д
при4нцип
про4ект3н
про3б4лем
про4м3май
пр4о5плат
раді4о
рай3в4но
ро4з5д4во
ро4з5мінний
роз5у4чен
роз5і4мен
роз5вант
роз5вин
роз5вит
ро4з5діл
ро4з5гор
ро4з5вер
ро4з5чеп
ро4з'5єдн
з'4єдн
руко5с4тиск
ро5з4ум
ро4з3гром
ро4з3лив
рмої4д
сан4к4т3
сеї4д
серцеї4д
спе4ц3кур
спе4ц3мон
спе4цпр
спе4ц3с
спор4т3вир
спор4т3зал
спор4т3ком
спор4т3клуб
спор4т3май
спор4т4с3ме
сор4тн
3с4промож
сь4квуг
стат5упр
тор4г3пред
тран4с3
тур4к3мен
цук3ро
у4к4р
укр3а4вт
укр3а4гр
укр3е4кс
укр3і4н4банк
убої4д
чорно3б4рив
цен4т4р3енерг
ясої4д
ви3у4ч
за3у4ч
на3у4ч
недо3у4ч
не3у4ч
під3у4ч
пед3у4чи
пере3у4ч
само3у4ч
вия4в
з'я4в
зая4в
ная4в
уя4в
во4євод
во4єнач
сво4єчас
сво4єкорис
сво4єрід
хво4є3г4риз
гелі4о
ді4о
еті4о
мі4о
і4он
полі4о
соці4о
фізі4о
хімі4о
гоме4о
ді4алог
ді4оген
дея4к
оо4динок
ао4пік
ао4ха
ео4ха
зо6о
ка5нал
оі4зол
міжу4соб
мете4о
абия4к
нія4к
вия4сн
най3я4сн
нея4сн
поя4сн
проя4сн
роз'я4сн
ро5з4ора.
ро5з4о5рам
ро5з4орах
ро5з4ори
ро5з4оро
ро5з4ору
ро5з4оря
ро5з4орю
ро5з4орі
ро6з5о4ри.
розо4ра
розо4ре
розо4реш
розо4рн
напоу4м
неа4би
ео4цін
оо4цін
доу4к
доу4м
ео4бур
ео4голош
ео4зор
бальне4о
не4оліт
не4омальт
не4оклас
не4окомун
не4оландш
не4олог
не4олібер
не4онац
не4офіт
нею4н
нея4к
нея4рок
но4к3а4ут
пі5в4оні
піво4с
пале4о
па4н3о4тець
.пе4ом.
д3у4сім
п4о5бере
ао4хот
ое4ко
ео4хот
ео4щад
ао4щад
оо4чищ
поя4с
роз'я4р
те4одоліт
те4олог
те4ософ
оо4біг
оу4сун
оу4ком
пів3о4вал
а3у4дар
о3у4дар
з3у4дар
в3у4дар
контр3у4дар
о3о4кисл
и3о4кисл
ень7о4кисл
е3о4кисл
х3о4кисл
и3і4стор
о3і4стор
і3і4стор
а3і4стор
я3і4стор
е3і4стор
наді4стор
най3і4стор
пів3і4стор
перед3і4стор
пост3і4стор
ар4т3афіш
ар4т3взвод
ар4т3десант
ар4т3кафе
ар4т3майс
ар4т3медіа
ар4т3мейс
ар4т3мін
ар4т3о4бстр
ар4т3о4дин
ар4т3о4збр
ар4т3під
ар4т3рин
ар4т3у4стан
ар4т3факт
ар4т3хім
ар4т3центр
наді4стот
найі4стот
еі4стот
оі4стот
ау4т3екол
оо4чист
з3а4кт
оа4кт
еа4кт
гіпер3а4кт
найа4кт
піва4кт
ао4браз
ео4браз
оо4браз
граф3о4браз
най3о4браз
супер3о4браз
ар4т3мейст
баге4р3мейст
бале4т3мейст
бран4д3мейст
ва4ль4д3мейст
ве4ль4т3мейст
го4ф3мейст
гро4с3мейст
декре4т3мейст
до4к3мейст
капе4ль3мейст
кварти4р3мейст
конце4р4т3мейст
кра4н3мейст
полі4ц3мейст
по4ш4т3мейст
фо4р4с4т3мейст
хо4р3мейст
шапі4т3мейст
шта4л3мейст
єге4р3мейст
иа4варі
яа4варі
оа4варі
еа4варі
беза4варі
між3а4варі
над3а4варі
пост3а4варі
напів3а4варі
перед3а4варі
супер3а4варі
аа4дрес
еа4дрес
оа4дрес
іа4дрес
без3а4дрес
ае4фект
ее4фект
ое4фект
най3е4фект
супер3е4фект
ое4місі
ие4місі
яе4місі
ее4місі
безе4місі
гіпер3е4місі
еу4бог
й3у4бог
ий4ня
зай4ня
здій4ня
най4ня
обій4ня
перей4ня
підій4ня
прий4м
пій4м
дій4ма
вий4м
най4ма
зай4м
д4о3й4м
обой4м
прой4м
обій4м
перей4м
безу4гл
безу4пин
бло4к3пост
.блі4ц3ана
.блі4ц3криг
.блі4ц3опит
.блі4ц3торг
.блі4ц3тур
.блі4ц3і4спит
о3а4наліз
бак3а4наліз
ц3а4наліз
ген3а4наліз
з3а4наліз
м3а4наліз
нт3а4наліз
між3а4наліз
полі3а4наліз
ре3а4наліз
оу4год
ау4год
еу4год
пів3у4год
роз3у4год
гос4п3у4год
ео4пис
оо4пис
ао4пис
бо4р4т3мех
бо4р4т3о4пер
бо4р4т3про
бо4р4т3рад
бо4р4т3і4нж
оа4каці
оу4с
оо4держ
оа4на
біблі4о
.на3в4ч
.ви3в4ч
.до3в4ч
.за3в4ч
.по3в4ч
.при3в4ч
ана3в4ч
ена3в4ч
мона3в4ч
жона3в4ч
іона3в4ч
ови3в4ч
еви3в4ч
едо3в4ч
оза3в4ч
по3в4ча
.ом4рі
е3м4рій
.ви3м4р
.віді3м4р
.зав3м4р
.за3м4р
.зі3м4р
.на3м4р
.пере3м4р
.по3м4р
.при3м4р
.роз3м4р
.ум4ри
.ум4рі
.ум4ру
.ум4ре
во4станнє
най3о4станн
перед3о4станн
ие4стет
ое4стет
ее4стет
й3е4стет
пан3е4стет
пар3е4стет
оо4ктан
іо4ктан
оо4плачув
ео4плачув
перед3о4пла
виу4ди
о3в4каз
е3в4каз
% Additional patterns with hyphen/dash: a hack to prevent breaking after hyphen, but not before.
8-7
--8
.а-8
.б-8
.в-8
.г-8
.ґ-8
.д-8
.е-8
.є-8
.ж-8
.з-8
.и-8
.і-8
.ї-8
.й-8
.к-8
.л-8
.м-8
.н-8
.о-8
.п-8
.р-8
.с-8
.т-8
.у-8
.ф-8
.х-8
.ц-8
.ч-8
.ш-8
.щ-8
.ь-8
.ю-8
.я-8
.'-8
-а8а8
8а8а-
-а8б8
8а8б-
-а8в8
8а8в-
-а8г8
8а8г-
-а8ґ8
8а8ґ-
-а8д8
8а8д-
-а8е8
8а8е-
-а8є8
8а8є-
-а8ж8
8а8ж-
-а8з8
8а8з-
-а8и8
8а8и-
-а8і8
8а8і-
-а8ї8
8а8ї-
-а8й8
8а8й-
-а8к8
8а8к-
-а8л8
8а8л-
-а8м8
8а8м-
-а8н8
8а8н-
-а8о8
8а8о-
-а8п8
8а8п-
-а8р8
8а8р-
-а8с8
8а8с-
-а8т8
8а8т-
-а8у8
8а8у-
-а8ф8
8а8ф-
-а8х8
8а8х-
-а8ц8
8а8ц-
-а8ч8
8а8ч-
-а8ш8
8а8ш-
-а8щ8
8а8щ-
-а8ь8
8а8ь-
-а8ю8
8а8ю-
-а8я8
8а8я-
-а8'8
8а8'-
-б8а8
8б8а-
-б8б8
8б8б-
-б8в8
8б8в-
-б8г8
8б8г-
-б8ґ8
8б8ґ-
-б8д8
8б8д-
-б8е8
8б8е-
-б8є8
8б8є-
-б8ж8
8б8ж-
-б8з8
8б8з-
-б8и8
8б8и-
-б8і8
8б8і-
-б8ї8
8б8ї-
-б8й8
8б8й-
-б8к8
8б8к-
-б8л8
8б8л-
-б8м8
8б8м-
-б8н8
8б8н-
-б8о8
8б8о-
-б8п8
8б8п-
-б8р8
8б8р-
-б8с8
8б8с-
-б8т8
8б8т-
-б8у8
8б8у-
-б8ф8
8б8ф-
-б8х8
8б8х-
-б8ц8
8б8ц-
-б8ч8
8б8ч-
-б8ш8
8б8ш-
-б8щ8
8б8щ-
-б8ь8
8б8ь-
-б8ю8
8б8ю-
-б8я8
8б8я-
-б8'8
8б8'-
-в8а8
8в8а-
-в8б8
8в8б-
-в8в8
8в8в-
-в8г8
8в8г-
-в8ґ8
8в8ґ-
-в8д8
8в8д-
-в8е8
8в8е-
-в8є8
8в8є-
-в8ж8
8в8ж-
-в8з8
8в8з-
-в8и8
8в8и-
-в8і8
8в8і-
-в8ї8
8в8ї-
-в8й8
8в8й-
-в8к8
8в8к-
-в8л8
8в8л-
-в8м8
8в8м-
-в8н8
8в8н-
-в8о8
8в8о-
-в8п8
8в8п-
-в8р8
8в8р-
-в8с8
8в8с-
-в8т8
8в8т-
-в8у8
8в8у-
-в8ф8
8в8ф-
-в8х8
8в8х-
-в8ц8
8в8ц-
-в8ч8
8в8ч-
-в8ш8
8в8ш-
-в8щ8
8в8щ-
-в8ь8
8в8ь-
-в8ю8
8в8ю-
-в8я8
8в8я-
-в8'8
8в8'-
-г8а8
8г8а-
-г8б8
8г8б-
-г8в8
8г8в-
-г8г8
8г8г-
-г8ґ8
8г8ґ-
-г8д8
8г8д-
-г8е8
8г8е-
-г8є8
8г8є-
-г8ж8
8г8ж-
-г8з8
8г8з-
-г8и8
8г8и-
-г8і8
8г8і-
-г8ї8
8г8ї-
-г8й8
8г8й-
-г8к8
8г8к-
-г8л8
8г8л-
-г8м8
8г8м-
-г8н8
8г8н-
-г8о8
8г8о-
-г8п8
8г8п-
-г8р8
8г8р-
-г8с8
8г8с-
-г8т8
8г8т-
-г8у8
8г8у-
-г8ф8
8г8ф-
-г8х8
8г8х-
-г8ц8
8г8ц-
-г8ч8
8г8ч-
-г8ш8
8г8ш-
-г8щ8
8г8щ-
-г8ь8
8г8ь-
-г8ю8
8г8ю-
-г8я8
8г8я-
-г8'8
8г8'-
-ґ8а8
8ґ8а-
-ґ8б8
8ґ8б-
-ґ8в8
8ґ8в-
-ґ8г8
8ґ8г-
-ґ8ґ8
8ґ8ґ-
-ґ8д8
8ґ8д-
-ґ8е8
8ґ8е-
-ґ8є8
8ґ8є-
-ґ8ж8
8ґ8ж-
-ґ8з8
8ґ8з-
-ґ8и8
8ґ8и-
-ґ8і8
8ґ8і-
-ґ8ї8
8ґ8ї-
-ґ8й8
8ґ8й-
-ґ8к8
8ґ8к-
-ґ8л8
8ґ8л-
-ґ8м8
8ґ8м-
-ґ8н8
8ґ8н-
-ґ8о8
8ґ8о-
-ґ8п8
8ґ8п-
-ґ8р8
8ґ8р-
-ґ8с8
8ґ8с-
-ґ8т8
8ґ8т-
-ґ8у8
8ґ8у-
-ґ8ф8
8ґ8ф-
-ґ8х8
8ґ8х-
-ґ8ц8
8ґ8ц-
-ґ8ч8
8ґ8ч-
-ґ8ш8
8ґ8ш-
-ґ8щ8
8ґ8щ-
-ґ8ь8
8ґ8ь-
-ґ8ю8
8ґ8ю-
-ґ8я8
8ґ8я-
-ґ8'8
8ґ8'-
-д8а8
8д8а-
-д8б8
8д8б-
-д8в8
8д8в-
-д8г8
8д8г-
-д8ґ8
8д8ґ-
-д8д8
8д8д-
-д8е8
8д8е-
-д8є8
8д8є-
-д8ж8
8д8ж-
-д8з8
8д8з-
-д8и8
8д8и-
-д8і8
8д8і-
-д8ї8
8д8ї-
-д8й8
8д8й-
-д8к8
8д8к-
-д8л8
8д8л-
-д8м8
8д8м-
-д8н8
8д8н-
-д8о8
8д8о-
-д8п8
8д8п-
-д8р8
8д8р-
-д8с8
8д8с-
-д8т8
8д8т-
-д8у8
8д8у-
-д8ф8
8д8ф-
-д8х8
8д8х-
-д8ц8
8д8ц-
-д8ч8
8д8ч-
-д8ш8
8д8ш-
-д8щ8
8д8щ-
-д8ь8
8д8ь-
-д8ю8
8д8ю-
-д8я8
8д8я-
-д8'8
8д8'-
-е8а8
8е8а-
-е8б8
8е8б-
-е8в8
8е8в-
-е8г8
8е8г-
-е8ґ8
8е8ґ-
-е8д8
8е8д-
-е8е8
8е8е-
-е8є8
8е8є-
-е8ж8
8е8ж-
-е8з8
8е8з-
-е8и8
8е8и-
-е8і8
8е8і-
-е8ї8
8е8ї-
-е8й8
8е8й-
-е8к8
8е8к-
-е8л8
8е8л-
-е8м8
8е8м-
-е8н8
8е8н-
-е8о8
8е8о-
-е8п8
8е8п-
-е8р8
8е8р-
-е8с8
8е8с-
-е8т8
8е8т-
-е8у8
8е8у-
-е8ф8
8е8ф-
-е8х8
8е8х-
-е8ц8
8е8ц-
-е8ч8
8е8ч-
-е8ш8
8е8ш-
-е8щ8
8е8щ-
-е8ь8
8е8ь-
-е8ю8
8е8ю-
-е8я8
8е8я-
-е8'8
8е8'-
-є8а8
8є8а-
-є8б8
8є8б-
-є8в8
8є8в-
-є8г8
8є8г-
-є8ґ8
8є8ґ-
-є8д8
8є8д-
-є8е8
8є8е-
-є8є8
8є8є-
-є8ж8
8є8ж-
-є8з8
8є8з-
-є8и8
8є8и-
-є8і8
8є8і-
-є8ї8
8є8ї-
-є8й8
8є8й-
-є8к8
8є8к-
-є8л8
8є8л-
-є8м8
8є8м-
-є8н8
8є8н-
-є8о8
8є8о-
-є8п8
8є8п-
-є8р8
8є8р-
-є8с8
8є8с-
-є8т8
8є8т-
-є8у8
8є8у-
-є8ф8
8є8ф-
-є8х8
8є8х-
-є8ц8
8є8ц-
-є8ч8
8є8ч-
-є8ш8
8є8ш-
-є8щ8
8є8щ-
-є8ь8
8є8ь-
-є8ю8
8є8ю-
-є8я8
8є8я-
-є8'8
8є8'-
-ж8а8
8ж8а-
-ж8б8
8ж8б-
-ж8в8
8ж8в-
-ж8г8
8ж8г-
-ж8ґ8
8ж8ґ-
-ж8д8
8ж8д-
-ж8е8
8ж8е-
-ж8є8
8ж8є-
-ж8ж8
8ж8ж-
-ж8з8
8ж8з-
-ж8и8
8ж8и-
-ж8і8
8ж8і-
-ж8ї8
8ж8ї-
-ж8й8
8ж8й-
-ж8к8
8ж8к-
-ж8л8
8ж8л-
-ж8м8
8ж8м-
-ж8н8
8ж8н-
-ж8о8
8ж8о-
-ж8п8
8ж8п-
-ж8р8
8ж8р-
-ж8с8
8ж8с-
-ж8т8
8ж8т-
-ж8у8
8ж8у-
-ж8ф8
8ж8ф-
-ж8х8
8ж8х-
-ж8ц8
8ж8ц-
-ж8ч8
8ж8ч-
-ж8ш8
8ж8ш-
-ж8щ8
8ж8щ-
-ж8ь8
8ж8ь-
-ж8ю8
8ж8ю-
-ж8я8
8ж8я-
-ж8'8
8ж8'-
-з8а8
8з8а-
-з8б8
8з8б-
-з8в8
8з8в-
-з8г8
8з8г-
-з8ґ8
8з8ґ-
-з8д8
8з8д-
-з8е8
8з8е-
-з8є8
8з8є-
-з8ж8
8з8ж-
-з8з8
8з8з-
-з8и8
8з8и-
-з8і8
8з8і-
-з8ї8
8з8ї-
-з8й8
8з8й-
-з8к8
8з8к-
-з8л8
8з8л-
-з8м8
8з8м-
-з8н8
8з8н-
-з8о8
8з8о-
-з8п8
8з8п-
-з8р8
8з8р-
-з8с8
8з8с-
-з8т8
8з8т-
-з8у8
8з8у-
-з8ф8
8з8ф-
-з8х8
8з8х-
-з8ц8
8з8ц-
-з8ч8
8з8ч-
-з8ш8
8з8ш-
-з8щ8
8з8щ-
-з8ь8
8з8ь-
-з8ю8
8з8ю-
-з8я8
8з8я-
-з8'8
8з8'-
-и8а8
8и8а-
-и8б8
8и8б-
-и8в8
8и8в-
-и8г8
8и8г-
-и8ґ8
8и8ґ-
-и8д8
8и8д-
-и8е8
8и8е-
-и8є8
8и8є-
-и8ж8
8и8ж-
-и8з8
8и8з-
-и8и8
8и8и-
-и8і8
8и8і-
-и8ї8
8и8ї-
-и8й8
8и8й-
-и8к8
8и8к-
-и8л8
8и8л-
-и8м8
8и8м-
-и8н8
8и8н-
-и8о8
8и8о-
-и8п8
8и8п-
-и8р8
8и8р-
-и8с8
8и8с-
-и8т8
8и8т-
-и8у8
8и8у-
-и8ф8
8и8ф-
-и8х8
8и8х-
-и8ц8
8и8ц-
-и8ч8
8и8ч-
-и8ш8
8и8ш-
-и8щ8
8и8щ-
-и8ь8
8и8ь-
-и8ю8
8и8ю-
-и8я8
8и8я-
-и8'8
8и8'-
-і8а8
8і8а-
-і8б8
8і8б-
-і8в8
8і8в-
-і8г8
8і8г-
-і8ґ8
8і8ґ-
-і8д8
8і8д-
-і8е8
8і8е-
-і8є8
8і8є-
-і8ж8
8і8ж-
-і8з8
8і8з-
-і8и8
8і8и-
-і8і8
8і8і-
-і8ї8
8і8ї-
-і8й8
8і8й-
-і8к8
8і8к-
-і8л8
8і8л-
-і8м8
8і8м-
-і8н8
8і8н-
-і8о8
8і8о-
-і8п8
8і8п-
-і8р8
8і8р-
-і8с8
8і8с-
-і8т8
8і8т-
-і8у8
8і8у-
-і8ф8
8і8ф-
-і8х8
8і8х-
-і8ц8
8і8ц-
-і8ч8
8і8ч-
-і8ш8
8і8ш-
-і8щ8
8і8щ-
-і8ь8
8і8ь-
-і8ю8
8і8ю-
-і8я8
8і8я-
-і8'8
8і8'-
-ї8а8
8ї8а-
-ї8б8
8ї8б-
-ї8в8
8ї8в-
-ї8г8
8ї8г-
-ї8ґ8
8ї8ґ-
-ї8д8
8ї8д-
-ї8е8
8ї8е-
-ї8є8
8ї8є-
-ї8ж8
8ї8ж-
-ї8з8
8ї8з-
-ї8и8
8ї8и-
-ї8і8
8ї8і-
-ї8ї8
8ї8ї-
-ї8й8
8ї8й-
-ї8к8
8ї8к-
-ї8л8
8ї8л-
-ї8м8
8ї8м-
-ї8н8
8ї8н-
-ї8о8
8ї8о-
-ї8п8
8ї8п-
-ї8р8
8ї8р-
-ї8с8
8ї8с-
-ї8т8
8ї8т-
-ї8у8
8ї8у-
-ї8ф8
8ї8ф-
-ї8х8
8ї8х-
-ї8ц8
8ї8ц-
-ї8ч8
8ї8ч-
-ї8ш8
8ї8ш-
-ї8щ8
8ї8щ-
-ї8ь8
8ї8ь-
-ї8ю8
8ї8ю-
-ї8я8
8ї8я-
-ї8'8
8ї8'-
-й8а8
8й8а-
-й8б8
8й8б-
-й8в8
8й8в-
-й8г8
8й8г-
-й8ґ8
8й8ґ-
-й8д8
8й8д-
-й8е8
8й8е-
-й8є8
8й8є-
-й8ж8
8й8ж-
-й8з8
8й8з-
-й8и8
8й8и-
-й8і8
8й8і-
-й8ї8
8й8ї-
-й8й8
8й8й-
-й8к8
8й8к-
-й8л8
8й8л-
-й8м8
8й8м-
-й8н8
8й8н-
-й8о8
8й8о-
-й8п8
8й8п-
-й8р8
8й8р-
-й8с8
8й8с-
-й8т8
8й8т-
-й8у8
8й8у-
-й8ф8
8й8ф-
-й8х8
8й8х-
-й8ц8
8й8ц-
-й8ч8
8й8ч-
-й8ш8
8й8ш-
-й8щ8
8й8щ-
-й8ь8
8й8ь-
-й8ю8
8й8ю-
-й8я8
8й8я-
-й8'8
8й8'-
-к8а8
8к8а-
-к8б8
8к8б-
-к8в8
8к8в-
-к8г8
8к8г-
-к8ґ8
8к8ґ-
-к8д8
8к8д-
-к8е8
8к8е-
-к8є8
8к8є-
-к8ж8
8к8ж-
-к8з8
8к8з-
-к8и8
8к8и-
-к8і8
8к8і-
-к8ї8
8к8ї-
-к8й8
8к8й-
-к8к8
8к8к-
-к8л8
8к8л-
-к8м8
8к8м-
-к8н8
8к8н-
-к8о8
8к8о-
-к8п8
8к8п-
-к8р8
8к8р-
-к8с8
8к8с-
-к8т8
8к8т-
-к8у8
8к8у-
-к8ф8
8к8ф-
-к8х8
8к8х-
-к8ц8
8к8ц-
-к8ч8
8к8ч-
-к8ш8
8к8ш-
-к8щ8
8к8щ-
-к8ь8
8к8ь-
-к8ю8
8к8ю-
-к8я8
8к8я-
-к8'8
8к8'-
-л8а8
8л8а-
-л8б8
8л8б-
-л8в8
8л8в-
-л8г8
8л8г-
-л8ґ8
8л8ґ-
-л8д8
8л8д-
-л8е8
8л8е-
-л8є8
8л8є-
-л8ж8
8л8ж-
-л8з8
8л8з-
-л8и8
8л8и-
-л8і8
8л8і-
-л8ї8
8л8ї-
-л8й8
8л8й-
-л8к8
8л8к-
-л8л8
8л8л-
-л8м8
8л8м-
-л8н8
8л8н-
-л8о8
8л8о-
-л8п8
8л8п-
-л8р8
8л8р-
-л8с8
8л8с-
-л8т8
8л8т-
-л8у8
8л8у-
-л8ф8
8л8ф-
-л8х8
8л8х-
-л8ц8
8л8ц-
-л8ч8
8л8ч-
-л8ш8
8л8ш-
-л8щ8
8л8щ-
-л8ь8
8л8ь-
-л8ю8
8л8ю-
-л8я8
8л8я-
-л8'8
8л8'-
-м8а8
8м8а-
-м8б8
8м8б-
-м8в8
8м8в-
-м8г8
8м8г-
-м8ґ8
8м8ґ-
-м8д8
8м8д-
-м8е8
8м8е-
-м8є8
8м8є-
-м8ж8
8м8ж-
-м8з8
8м8з-
-м8и8
8м8и-
-м8і8
8м8і-
-м8ї8
8м8ї-
-м8й8
8м8й-
-м8к8
8м8к-
-м8л8
8м8л-
-м8м8
8м8м-
-м8н8
8м8н-
-м8о8
8м8о-
-м8п8
8м8п-
-м8р8
8м8р-
-м8с8
8м8с-
-м8т8
8м8т-
-м8у8
8м8у-
-м8ф8
8м8ф-
-м8х8
8м8х-
-м8ц8
8м8ц-
-м8ч8
8м8ч-
-м8ш8
8м8ш-
-м8щ8
8м8щ-
-м8ь8
8м8ь-
-м8ю8
8м8ю-
-м8я8
8м8я-
-м8'8
8м8'-
-н8а8
8н8а-
-н8б8
8н8б-
-н8в8
8н8в-
-н8г8
8н8г-
-н8ґ8
8н8ґ-
-н8д8
8н8д-
-н8е8
8н8е-
-н8є8
8н8є-
-н8ж8
8н8ж-
-н8з8
8н8з-
-н8и8
8н8и-
-н8і8
8н8і-
-н8ї8
8н8ї-
-н8й8
8н8й-
-н8к8
8н8к-
-н8л8
8н8л-
-н8м8
8н8м-
-н8н8
8н8н-
-н8о8
8н8о-
-н8п8
8н8п-
-н8р8
8н8р-
-н8с8
8н8с-
-н8т8
8н8т-
-н8у8
8н8у-
-н8ф8
8н8ф-
-н8х8
8н8х-
-н8ц8
8н8ц-
-н8ч8
8н8ч-
-н8ш8
8н8ш-
-н8щ8
8н8щ-
-н8ь8
8н8ь-
-н8ю8
8н8ю-
-н8я8
8н8я-
-н8'8
8н8'-
-о8а8
8о8а-
-о8б8
8о8б-
-о8в8
8о8в-
-о8г8
8о8г-
-о8ґ8
8о8ґ-
-о8д8
8о8д-
-о8е8
8о8е-
-о8є8
8о8є-
-о8ж8
8о8ж-
-о8з8
8о8з-
-о8и8
8о8и-
-о8і8
8о8і-
-о8ї8
8о8ї-
-о8й8
8о8й-
-о8к8
8о8к-
-о8л8
8о8л-
-о8м8
8о8м-
-о8н8
8о8н-
-о8о8
8о8о-
-о8п8
8о8п-
-о8р8
8о8р-
-о8с8
8о8с-
-о8т8
8о8т-
-о8у8
8о8у-
-о8ф8
8о8ф-
-о8х8
8о8х-
-о8ц8
8о8ц-
-о8ч8
8о8ч-
-о8ш8
8о8ш-
-о8щ8
8о8щ-
-о8ь8
8о8ь-
-о8ю8
8о8ю-
-о8я8
8о8я-
-о8'8
8о8'-
-п8а8
8п8а-
-п8б8
8п8б-
-п8в8
8п8в-
-п8г8
8п8г-
-п8ґ8
8п8ґ-
-п8д8
8п8д-
-п8е8
8п8е-
-п8є8
8п8є-
-п8ж8
8п8ж-
-п8з8
8п8з-
-п8и8
8п8и-
-п8і8
8п8і-
-п8ї8
8п8ї-
-п8й8
8п8й-
-п8к8
8п8к-
-п8л8
8п8л-
-п8м8
8п8м-
-п8н8
8п8н-
-п8о8
8п8о-
-п8п8
8п8п-
-п8р8
8п8р-
-п8с8
8п8с-
-п8т8
8п8т-
-п8у8
8п8у-
-п8ф8
8п8ф-
-п8х8
8п8х-
-п8ц8
8п8ц-
-п8ч8
8п8ч-
-п8ш8
8п8ш-
-п8щ8
8п8щ-
-п8ь8
8п8ь-
-п8ю8
8п8ю-
-п8я8
8п8я-
-п8'8
8п8'-
-р8а8
8р8а-
-р8б8
8р8б-
-р8в8
8р8в-
-р8г8
8р8г-
-р8ґ8
8р8ґ-
-р8д8
8р8д-
-р8е8
8р8е-
-р8є8
8р8є-
-р8ж8
8р8ж-
-р8з8
8р8з-
-р8и8
8р8и-
-р8і8
8р8і-
-р8ї8
8р8ї-
-р8й8
8р8й-
-р8к8
8р8к-
-р8л8
8р8л-
-р8м8
8р8м-
-р8н8
8р8н-
-р8о8
8р8о-
-р8п8
8р8п-
-р8р8
8р8р-
-р8с8
8р8с-
-р8т8
8р8т-
-р8у8
8р8у-
-р8ф8
8р8ф-
-р8х8
8р8х-
-р8ц8
8р8ц-
-р8ч8
8р8ч-
-р8ш8
8р8ш-
-р8щ8
8р8щ-
-р8ь8
8р8ь-
-р8ю8
8р8ю-
-р8я8
8р8я-
-р8'8
8р8'-
-с8а8
8с8а-
-с8б8
8с8б-
-с8в8
8с8в-
-с8г8
8с8г-
-с8ґ8
8с8ґ-
-с8д8
8с8д-
-с8е8
8с8е-
-с8є8
8с8є-
-с8ж8
8с8ж-
-с8з8
8с8з-
-с8и8
8с8и-
-с8і8
8с8і-
-с8ї8
8с8ї-
-с8й8
8с8й-
-с8к8
8с8к-
-с8л8
8с8л-
-с8м8
8с8м-
-с8н8
8с8н-
-с8о8
8с8о-
-с8п8
8с8п-
-с8р8
8с8р-
-с8с8
8с8с-
-с8т8
8с8т-
-с8у8
8с8у-
-с8ф8
8с8ф-
-с8х8
8с8х-
-с8ц8
8с8ц-
-с8ч8
8с8ч-
-с8ш8
8с8ш-
-с8щ8
8с8щ-
-с8ь8
8с8ь-
-с8ю8
8с8ю-
-с8я8
8с8я-
-с8'8
8с8'-
-т8а8
8т8а-
-т8б8
8т8б-
-т8в8
8т8в-
-т8г8
8т8г-
-т8ґ8
8т8ґ-
-т8д8
8т8д-
-т8е8
8т8е-
-т8є8
8т8є-
-т8ж8
8т8ж-
-т8з8
8т8з-
-т8и8
8т8и-
-т8і8
8т8і-
-т8ї8
8т8ї-
-т8й8
8т8й-
-т8к8
8т8к-
-т8л8
8т8л-
-т8м8
8т8м-
-т8н8
8т8н-
-т8о8
8т8о-
-т8п8
8т8п-
-т8р8
8т8р-
-т8с8
8т8с-
-т8т8
8т8т-
-т8у8
8т8у-
-т8ф8
8т8ф-
-т8х8
8т8х-
-т8ц8
8т8ц-
-т8ч8
8т8ч-
-т8ш8
8т8ш-
-т8щ8
8т8щ-
-т8ь8
8т8ь-
-т8ю8
8т8ю-
-т8я8
8т8я-
-т8'8
8т8'-
-у8а8
8у8а-
-у8б8
8у8б-
-у8в8
8у8в-
-у8г8
8у8г-
-у8ґ8
8у8ґ-
-у8д8
8у8д-
-у8е8
8у8е-
-у8є8
8у8є-
-у8ж8
8у8ж-
-у8з8
8у8з-
-у8и8
8у8и-
-у8і8
8у8і-
-у8ї8
8у8ї-
-у8й8
8у8й-
-у8к8
8у8к-
-у8л8
8у8л-
-у8м8
8у8м-
-у8н8
8у8н-
-у8о8
8у8о-
-у8п8
8у8п-
-у8р8
8у8р-
-у8с8
8у8с-
-у8т8
8у8т-
-у8у8
8у8у-
-у8ф8
8у8ф-
-у8х8
8у8х-
-у8ц8
8у8ц-
-у8ч8
8у8ч-
-у8ш8
8у8ш-
-у8щ8
8у8щ-
-у8ь8
8у8ь-
-у8ю8
8у8ю-
-у8я8
8у8я-
-у8'8
8у8'-
-ф8а8
8ф8а-
-ф8б8
8ф8б-
-ф8в8
8ф8в-
-ф8г8
8ф8г-
-ф8ґ8
8ф8ґ-
-ф8д8
8ф8д-
-ф8е8
8ф8е-
-ф8є8
8ф8є-
-ф8ж8
8ф8ж-
-ф8з8
8ф8з-
-ф8и8
8ф8и-
-ф8і8
8ф8і-
-ф8ї8
8ф8ї-
-ф8й8
8ф8й-
-ф8к8
8ф8к-
-ф8л8
8ф8л-
-ф8м8
8ф8м-
-ф8н8
8ф8н-
-ф8о8
8ф8о-
-ф8п8
8ф8п-
-ф8р8
8ф8р-
-ф8с8
8ф8с-
-ф8т8
8ф8т-
-ф8у8
8ф8у-
-ф8ф8
8ф8ф-
-ф8х8
8ф8х-
-ф8ц8
8ф8ц-
-ф8ч8
8ф8ч-
-ф8ш8
8ф8ш-
-ф8щ8
8ф8щ-
-ф8ь8
8ф8ь-
-ф8ю8
8ф8ю-
-ф8я8
8ф8я-
-ф8'8
8ф8'-
-х8а8
8х8а-
-х8б8
8х8б-
-х8в8
8х8в-
-х8г8
8х8г-
-х8ґ8
8х8ґ-
-х8д8
8х8д-
-х8е8
8х8е-
-х8є8
8х8є-
-х8ж8
8х8ж-
-х8з8
8х8з-
-х8и8
8х8и-
-х8і8
8х8і-
-х8ї8
8х8ї-
-х8й8
8х8й-
-х8к8
8х8к-
-х8л8
8х8л-
-х8м8
8х8м-
-х8н8
8х8н-
-х8о8
8х8о-
-х8п8
8х8п-
-х8р8
8х8р-
-х8с8
8х8с-
-х8т8
8х8т-
-х8у8
8х8у-
-х8ф8
8х8ф-
-х8х8
8х8х-
-х8ц8
8х8ц-
-х8ч8
8х8ч-
-х8ш8
8х8ш-
-х8щ8
8х8щ-
-х8ь8
8х8ь-
-х8ю8
8х8ю-
-х8я8
8х8я-
-х8'8
8х8'-
-ц8а8
8ц8а-
-ц8б8
8ц8б-
-ц8в8
8ц8в-
-ц8г8
8ц8г-
-ц8ґ8
8ц8ґ-
-ц8д8
8ц8д-
-ц8е8
8ц8е-
-ц8є8
8ц8є-
-ц8ж8
8ц8ж-
-ц8з8
8ц8з-
-ц8и8
8ц8и-
-ц8і8
8ц8і-
-ц8ї8
8ц8ї-
-ц8й8
8ц8й-
-ц8к8
8ц8к-
-ц8л8
8ц8л-
-ц8м8
8ц8м-
-ц8н8
8ц8н-
-ц8о8
8ц8о-
-ц8п8
8ц8п-
-ц8р8
8ц8р-
-ц8с8
8ц8с-
-ц8т8
8ц8т-
-ц8у8
8ц8у-
-ц8ф8
8ц8ф-
-ц8х8
8ц8х-
-ц8ц8
8ц8ц-
-ц8ч8
8ц8ч-
-ц8ш8
8ц8ш-
-ц8щ8
8ц8щ-
-ц8ь8
8ц8ь-
-ц8ю8
8ц8ю-
-ц8я8
8ц8я-
-ц8'8
8ц8'-
-ч8а8
8ч8а-
-ч8б8
8ч8б-
-ч8в8
8ч8в-
-ч8г8
8ч8г-
-ч8ґ8
8ч8ґ-
-ч8д8
8ч8д-
-ч8е8
8ч8е-
-ч8є8
8ч8є-
-ч8ж8
8ч8ж-
-ч8з8
8ч8з-
-ч8и8
8ч8и-
-ч8і8
8ч8і-
-ч8ї8
8ч8ї-
-ч8й8
8ч8й-
-ч8к8
8ч8к-
-ч8л8
8ч8л-
-ч8м8
8ч8м-
-ч8н8
8ч8н-
-ч8о8
8ч8о-
-ч8п8
8ч8п-
-ч8р8
8ч8р-
-ч8с8
8ч8с-
-ч8т8
8ч8т-
-ч8у8
8ч8у-
-ч8ф8
8ч8ф-
-ч8х8
8ч8х-
-ч8ц8
8ч8ц-
-ч8ч8
8ч8ч-
-ч8ш8
8ч8ш-
-ч8щ8
8ч8щ-
-ч8ь8
8ч8ь-
-ч8ю8
8ч8ю-
-ч8я8
8ч8я-
-ч8'8
8ч8'-
-ш8а8
8ш8а-
-ш8б8
8ш8б-
-ш8в8
8ш8в-
-ш8г8
8ш8г-
-ш8ґ8
8ш8ґ-
-ш8д8
8ш8д-
-ш8е8
8ш8е-
-ш8є8
8ш8є-
-ш8ж8
8ш8ж-
-ш8з8
8ш8з-
-ш8и8
8ш8и-
-ш8і8
8ш8і-
-ш8ї8
8ш8ї-
-ш8й8
8ш8й-
-ш8к8
8ш8к-
-ш8л8
8ш8л-
-ш8м8
8ш8м-
-ш8н8
8ш8н-
-ш8о8
8ш8о-
-ш8п8
8ш8п-
-ш8р8
8ш8р-
-ш8с8
8ш8с-
-ш8т8
8ш8т-
-ш8у8
8ш8у-
-ш8ф8
8ш8ф-
-ш8х8
8ш8х-
-ш8ц8
8ш8ц-
-ш8ч8
8ш8ч-
-ш8ш8
8ш8ш-
-ш8щ8
8ш8щ-
-ш8ь8
8ш8ь-
-ш8ю8
8ш8ю-
-ш8я8
8ш8я-
-ш8'8
8ш8'-
-щ8а8
8щ8а-
-щ8б8
8щ8б-
-щ8в8
8щ8в-
-щ8г8
8щ8г-
-щ8ґ8
8щ8ґ-
-щ8д8
8щ8д-
-щ8е8
8щ8е-
-щ8є8
8щ8є-
-щ8ж8
8щ8ж-
-щ8з8
8щ8з-
-щ8и8
8щ8и-
-щ8і8
8щ8і-
-щ8ї8
8щ8ї-
-щ8й8
8щ8й-
-щ8к8
8щ8к-
-щ8л8
8щ8л-
-щ8м8
8щ8м-
-щ8н8
8щ8н-
-щ8о8
8щ8о-
-щ8п8
8щ8п-
-щ8р8
8щ8р-
-щ8с8
8щ8с-
-щ8т8
8щ8т-
-щ8у8
8щ8у-
-щ8ф8
8щ8ф-
-щ8х8
8щ8х-
-щ8ц8
8щ8ц-
-щ8ч8
8щ8ч-
-щ8ш8
8щ8ш-
-щ8щ8
8щ8щ-
-щ8ь8
8щ8ь-
-щ8ю8
8щ8ю-
-щ8я8
8щ8я-
-щ8'8
8щ8'-
-ь8а8
8ь8а-
-ь8б8
8ь8б-
-ь8в8
8ь8в-
-ь8г8
8ь8г-
-ь8ґ8
8ь8ґ-
-ь8д8
8ь8д-
-ь8е8
8ь8е-
-ь8є8
8ь8є-
-ь8ж8
8ь8ж-
-ь8з8
8ь8з-
-ь8и8
8ь8и-
-ь8і8
8ь8і-
-ь8ї8
8ь8ї-
-ь8й8
8ь8й-
-ь8к8
8ь8к-
-ь8л8
8ь8л-
-ь8м8
8ь8м-
-ь8н8
8ь8н-
-ь8о8
8ь8о-
-ь8п8
8ь8п-
-ь8р8
8ь8р-
-ь8с8
8ь8с-
-ь8т8
8ь8т-
-ь8у8
8ь8у-
-ь8ф8
8ь8ф-
-ь8х8
8ь8х-
-ь8ц8
8ь8ц-
-ь8ч8
8ь8ч-
-ь8ш8
8ь8ш-
-ь8щ8
8ь8щ-
-ь8ь8
8ь8ь-
-ь8ю8
8ь8ю-
-ь8я8
8ь8я-
-ь8'8
8ь8'-
-ю8а8
8ю8а-
-ю8б8
8ю8б-
-ю8в8
8ю8в-
-ю8г8
8ю8г-
-ю8ґ8
8ю8ґ-
-ю8д8
8ю8д-
-ю8е8
8ю8е-
-ю8є8
8ю8є-
-ю8ж8
8ю8ж-
-ю8з8
8ю8з-
-ю8и8
8ю8и-
-ю8і8
8ю8і-
-ю8ї8
8ю8ї-
-ю8й8
8ю8й-
-ю8к8
8ю8к-
-ю8л8
8ю8л-
-ю8м8
8ю8м-
-ю8н8
8ю8н-
-ю8о8
8ю8о-
-ю8п8
8ю8п-
-ю8р8
8ю8р-
-ю8с8
8ю8с-
-ю8т8
8ю8т-
-ю8у8
8ю8у-
-ю8ф8
8ю8ф-
-ю8х8
8ю8х-
-ю8ц8
8ю8ц-
-ю8ч8
8ю8ч-
-ю8ш8
8ю8ш-
-ю8щ8
8ю8щ-
-ю8ь8
8ю8ь-
-ю8ю8
8ю8ю-
-ю8я8
8ю8я-
-ю8'8
8ю8'-
-я8а8
8я8а-
-я8б8
8я8б-
-я8в8
8я8в-
-я8г8
8я8г-
-я8ґ8
8я8ґ-
-я8д8
8я8д-
-я8е8
8я8е-
-я8є8
8я8є-
-я8ж8
8я8ж-
-я8з8
8я8з-
-я8и8
8я8и-
-я8і8
8я8і-
-я8ї8
8я8ї-
-я8й8
8я8й-
-я8к8
8я8к-
-я8л8
8я8л-
-я8м8
8я8м-
-я8н8
8я8н-
-я8о8
8я8о-
-я8п8
8я8п-
-я8р8
8я8р-
-я8с8
8я8с-
-я8т8
8я8т-
-я8у8
8я8у-
-я8ф8
8я8ф-
-я8х8
8я8х-
-я8ц8
8я8ц-
-я8ч8
8я8ч-
-я8ш8
8я8ш-
-я8щ8
8я8щ-
-я8ь8
8я8ь-
-я8ю8
8я8ю-
-я8я8
8я8я-
-я8'8
8я8'-
-'8а8
8'8а-
-'8б8
8'8б-
-'8в8
8'8в-
-'8г8
8'8г-
-'8ґ8
8'8ґ-
-'8д8
8'8д-
-'8е8
8'8е-
-'8є8
8'8є-
-'8ж8
8'8ж-
-'8з8
8'8з-
-'8и8
8'8и-
-'8і8
8'8і-
-'8ї8
8'8ї-
-'8й8
8'8й-
-'8к8
8'8к-
-'8л8
8'8л-
-'8м8
8'8м-
-'8н8
8'8н-
-'8о8
8'8о-
-'8п8
8'8п-
-'8р8
8'8р-
-'8с8
8'8с-
-'8т8
8'8т-
-'8у8
8'8у-
-'8ф8
8'8ф-
-'8х8
8'8х-
-'8ц8
8'8ц-
-'8ч8
8'8ч-
-'8ш8
8'8ш-
-'8щ8
8'8щ-
-'8ь8
8'8ь-
-'8ю8
8'8ю-
-'8я8
8'8я-
-'8'8
8'8'-
}

