use strict;
use warnings;

my $foo;

use Test::More;
use Symbol::Rename( is => \$foo );

$foo->('a', 'a', "Can remove a symbol and put it into a scalar");

sub exception(&) {
    my $code = shift;
    my $ok = eval { $code->(); 1 };
    return $ok ? undef : $@;
}

like(
    exception { Symbol::Rename->import( 'is_deeply' => {} ) },
    qr/'HASH' references cannot be used as a renaming destination for '&main::is_deeply'/,
    "Only Scalar refs work"
);

done_testing;
