use strict;
use warnings;
use utf8;

package SDK::SoundCloud::OAuth2Token;

use Data::Dumper;

use Moo::Role;
use namespace::clean;

use MooseX::Params::Validate;

requires 'client_id';

has 'path' => (
    is => 'ro',
    default => sub {
        return '/oauth2/token';
    }
);

sub get_token {
    my ($self, %params) = validated_hash(
        \@_,
        client_secret => { isa => 'Str' },
        redirect_uri => { isa => 'Str' },
        code => { isa => 'Str' },
        grant_type => {
            isa => 'Str',
            default => 'authorization_code' #refresh_token, password, client_credentials, oauth1_token
        }
    );

    $params{client_id} = $self->client_id;

    my $response = 
        $self->req({ 
            method => 'POST', 
            path => $self->path,
            data => \%params,
    });

    $self->token($response->{access_token});

    return $response;
}

1;
