# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170052;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"818568", "津和野",
"811536", "厚岸",
"812678", "佐久",
"819682", "山鹿",
"81423", "国分寺",
"811733", "五所川原",
"819735", "日田",
"8182941", "広島",
"8186697", "倉敷",
"81740", "今津",
"812976", "竜ケ崎",
"811877", "大曲",
"817704", "敦賀",
"818877", "嶺北",
"815735", "恵那",
"81724", "岸和田貝塚",
"815993", "鳥羽",
"817672", "羽咋",
"818479", "東城",
"819942", "大根占",
"815987", "三瀬谷",
"81126", "岩見沢",
"8186994", "岡山瀬戸",
"812542", "新発田",
"817616", "小松",
"81142", "伊達",
"812617", "大町",
"819576", "島原",
"817459", "大和榛原",
"818957", "御荘",
"8147957", "八日市場",
"811957", "岩手",
"812856", "真岡",
"812372", "村山",
"811652", "士別",
"812894", "宇都宮",
"818652", "倉敷",
"8125485", "津川",
"812587", "長岡",
"812796", "渋川",
"811465", "静内",
"81245", "福島",
"81939", "北九州",
"81984", "小林",
"812472", "石川",
"811365", "倶知安",
"818242", "東広島",
"81235", "鶴岡",
"819553", "伊万里",
"811934", "釜石",
"811555", "帯広",
"81167", "富良野",
"818555", "江津",
"818365", "宇部",
"817736", "舞鶴",
"81949", "直方",
"81260", "阿南町",
"81549", "静岡",
"818803", "土佐中村",
"819805", "名護",
"818293", "廿日市",
"815756", "郡上八幡",
"812873", "大田原",
"815363", "新城",
"81584", "大垣",
"817903", "福崎",
"81485", "熊谷",
"812645", "木曾福島",
"8188096", "土佐清水",
"81832", "下関",
"818664", "高梁",
"812574", "柏崎",
"819974", "屋久島",
"81963", "熊本",
"81765", "魚津",
"815585", "下田",
"814282", "青梅",
"812659", "伊那",
"81596", "伊勢",
"8198293", "延岡",
"812236", "仙台",
"81281", "宇都宮",
"811583", "紋別",
"812835", "佐野",
"812416", "田島",
"815974", "尾鷲",
"81563", "西尾",
"818583", "倉吉",
"818549", "石見大田",
"818597", "根雨",
"811549", "釧路",
"817908", "播磨山崎",
"814797", "八日市場",
"817473", "五条",
"8186993", "備前",
"81828", "広島",
"818298", "廿日市",
"818808", "土佐清水",
"815368", "設楽",
"812878", "烏山",
"817356", "串本",
"819558", "唐津",
"8165", "大阪",
"81273", "高崎",
"812567", "巻",
"818677", "新見",
"818972", "新居浜",
"811972", "水沢",
"818588", "郡家",
"811588", "興部",
"819967", "出水",
"819662", "人吉",
"814704", "館山",
"817714", "亀岡",
"812419", "田島",
"81424", "武蔵野三鷹",
"811453", "早来",
"811546", "釧路",
"8183768", "下関",
"818546", "掛合",
"817952", "西脇",
"818792", "三本松",
"819932", "指宿",
"814755", "東金",
"81925", "福岡",
"81723", "堺",
"815745", "美濃加茂",
"811852", "男鹿",
"812694", "中野",
"818376", "美祢",
"812239", "仙台",
"812656", "伊那",
"811376", "八雲",
"81229", "古川",
"812246", "大河原",
"81280", "古河",
"815998", "阿児",
"812979", "竜ケ崎",
"815565", "鰍沢青柳",
"81952", "佐賀",
"81964", "松橋",
"81797", "西宮",
"8198294", "延岡",
"818476", "府中",
"811539", "根室標津",
"812230", "仙台",
"811864", "大館",
"81998", "鹿児島",
"81564", "岡崎",
"8199343", "鹿児島",
"81465", "小田原",
"81552", "甲府",
"819722", "佐伯",
"811353", "余市",
"812673", "小諸",
"811563", "本別",
"8188092", "窪川",
"818563", "益田",
"817964", "豊岡",
"811738", "鰺ケ沢",
"81779", "大野",
"812859", "小山",
"817456", "大和高田",
"812965", "下館",
"811232", "千歳",
"818944", "八幡浜",
"811944", "岩泉",
"817494", "彦根",
"812747", "富岡",
"81983", "高鍋",
"818385", "萩",
"818514", "海士",
"812799", "長野原",
"815397", "浜松",
"81292", "水戸",
"818267", "千代田",
"81583", "岐阜",
"812782", "沼田",
"818684", "津山",
"818512", "西郷",
"815769", "荘川",
"8199331", "鹿児島",
"811647", "羽幌",
"811527", "美幌",
"815733", "恵那",
"815995", "阿児",
"811234", "千歳",
"818942", "八幡浜",
"814229", "武蔵野三鷹",
"811942", "岩泉",
"817492", "彦根",
"811987", "遠野",
"817366", "岩出",
"811735", "五所川原",
"8163", "大阪",
"818682", "津山",
"819733", "日田",
"8186998", "岡山瀬戸",
"812557", "新井",
"812784", "沼田",
"819957", "加治木",
"8161", "大阪",
"818388", "田万川",
"81542", "静岡",
"818837", "阿波池田",
"811463", "浦河",
"812936", "水戸",
"812968", "笠間",
"818463", "竹原",
"81839", "山口",
"819826", "日向",
"817962", "豊岡",
"81926", "福岡",
"81427", "相模原",
"81942", "久留米",
"811862", "鹿角",
"815957", "上野",
"819724", "佐伯",
"818295", "廿日市",
"819803", "名護",
"818805", "土佐中村",
"81493", "東松山",
"81567", "津島",
"812875", "大田原",
"817727", "峰山",
"817905", "福崎",
"812643", "木曾福島",
"8125481", "村上",
"81932", "北九州",
"819664", "人吉",
"814702", "館山",
"817712", "亀岡",
"811854", "男鹿",
"812692", "中野",
"81532", "豊橋",
"818206", "柳井",
"812997", "潮来",
"81184", "本荘",
"81466", "藤沢",
"818896", "須崎",
"818553", "浜田",
"817954", "西脇",
"818794", "三本松",
"818363", "宇部",
"811363", "倶知安",
"819934", "指宿",
"819555", "唐津",
"811553", "帯広",
"817996", "津名",
"8112397", "栗山",
"811756", "野辺地",
"81849", "福山",
"817466", "十津川",
"814220", "国分寺",
"812955", "常陸大宮",
"81196", "盛岡",
"81896", "伊予三島",
"818690", "岡山",
"8164", "大阪",
"8186999", "岡山瀬戸",
"818585", "倉吉",
"811585", "遠軽",
"812833", "宇都宮",
"819597", "福江",
"819786", "杵築",
"818974", "新居浜",
"81863", "玉野",
"815583", "下田",
"818391", "小郡",
"8111", "札幌",
"811974", "水沢",
"8198290", "延岡",
"81488", "浦和",
"814758", "東金",
"814770", "市川",
"815748", "美濃白川",
"811336", "石狩",
"811558", "広尾",
"818558", "川本",
"818368", "宇部",
"818847", "牟岐",
"81727", "池田",
"819677", "矢部",
"819972", "種子島",
"8198299", "日向",
"817947", "三木",
"814284", "立川",
"8153961", "天竜",
"812551", "上越",
"812648", "長野",
"815972", "尾鷲",
"817687", "能都",
"812930", "水戸",
"81928", "福岡",
"817475", "下市",
"819808", "八重山",
"818244", "三次",
"811932", "釜石",
"81559", "沼津",
"815743", "美濃加茂",
"81825", "広島",
"81125", "滝川",
"814753", "茂原",
"811637", "北見枝幸",
"81277", "桐生",
"815588", "修善寺大仁",
"812474", "石川",
"812838", "佐野",
"818662", "高梁",
"81222", "仙台",
"812572", "柏崎",
"811455", "鵡川",
"81246", "いわき",
"812387", "長井",
"819743", "三重",
"819789", "杵築",
"819546", "鹿島",
"812914", "鉾田",
"814776", "船橋",
"817486", "水口",
"81898", "今治",
"81587", "一宮",
"812487", "須賀川",
"818565", "益田",
"81236", "山形",
"812675", "佐久",
"812544", "新発田",
"819738", "玖珠",
"815738", "中津川",
"815766", "下呂",
"815563", "鰍沢青柳",
"81987", "日南",
"81852", "松江",
"81486", "浦和",
"81864", "倉敷",
"818696", "備前",
"812374", "村山",
"811654", "名寄",
"818654", "鴨方",
"812892", "宇都宮",
"8153974", "天竜",
"814226", "武蔵野三鷹",
"81766", "高岡",
"81494", "秩父",
"814996", "八丈島",
"819684", "山鹿",
"812963", "下館",
"81793", "姫路",
"817674", "羽咋",
"8198298", "日向",
"81468", "横須賀",
"819944", "鹿屋",
"819232", "前原",
"812939", "水戸",
"817915", "相生",
"818383", "萩",
"81183", "湯沢",
"818397", "小郡",
"817702", "敦賀",
"811397", "奥尻",
"81742", "奈良",
"8183766", "下関",
"811378", "今金",
"817724", "宮津",
"812658", "伊那",
"818378", "下関",
"812911", "鉾田",
"819962", "川内",
"81726", "茨木",
"812233", "岩沼",
"819667", "水俣",
"8124196", "柳津",
"814298", "飯能",
"812956", "常陸大宮",
"811857", "能代",
"817465", "吉野",
"818548", "石見大田",
"811548", "弟子屈",
"812994", "石岡",
"811586", "中湧別",
"819937", "加世田",
"812413", "喜多方",
"818797", "土庄",
"818586", "倉吉",
"817957", "丹波柏原",
"819785", "豊後高田",
"818895", "須崎",
"818205", "柳井",
"819556", "唐津",
"814792", "銚子",
"819594", "有川",
"81276", "太田",
"817995", "洲本",
"817733", "福知山",
"818672", "福渡",
"818806", "宿毛",
"81124", "芦別",
"815753", "関",
"818296", "広島",
"812562", "三条",
"811977", "北上",
"812876", "黒磯",
"818977", "伯方",
"815366", "設楽",
"817906", "播磨山崎",
"812742", "藤岡",
"819825", "日向",
"817613", "小松",
"814281", "相模原",
"811524", "網走",
"811644", "留萌",
"81586", "一宮",
"819573", "諫早",
"811237", "栗山",
"811984", "花巻",
"812853", "小山",
"81986", "都城",
"815392", "浜松",
"812793", "渋川",
"812935", "水戸",
"812554", "上越",
"817458", "大和榛原",
"819438", "田主丸",
"8145", "横浜",
"812787", "沼田",
"81487", "浦和",
"818262", "加計",
"81262", "長野",
"81568", "春日井",
"817365", "和歌山橋本",
"819954", "加治木",
"811533", "根室",
"811736", "五所川原",
"812679", "佐久",
"818834", "鴨島",
"818478", "東城",
"812973", "水海道",
"81551", "韮崎",
"8188090", "窪川",
"815996", "阿児",
"81594", "桑名",
"812248", "大河原",
"81495", "本庄",
"819727", "臼杵",
"815954", "上野",
"819433", "八女",
"812917", "水戸",
"812798", "長野原",
"817453", "大和高田",
"812612", "大町",
"812858", "真岡",
"812484", "白河",
"817916", "竜野",
"818290", "広島",
"8188099", "土佐清水",
"812547", "村上",
"812582", "長岡",
"8112395", "栗山",
"819578", "島原",
"811952", "二戸",
"818952", "宇和島",
"817618", "加賀",
"818657", "笠岡",
"81823", "呉",
"812377", "寒河江",
"812243", "白石",
"815765", "下呂",
"818695", "岡山瀬戸",
"815999", "津",
"81728", "寝屋川",
"814225", "武蔵野三鷹",
"819687", "玉名",
"818473", "甲山",
"812978", "竜ケ崎",
"8186691", "倉敷",
"817677", "七尾",
"81572", "多治見",
"817485", "八日市",
"814775", "船橋",
"81927", "福岡",
"815982", "松阪",
"819947", "志布志",
"811566", "十勝清水",
"812676", "佐久",
"811538", "根室標津",
"811356", "岩内",
"81426", "八王子",
"811394", "松前",
"818872", "室戸",
"812418", "会津山口",
"81432", "千葉",
"81885", "小松島",
"81566", "刈谷",
"818844", "阿南",
"81550", "御殿場",
"81179", "三戸",
"819674", "熊本一の宮",
"811589", "興部",
"811456", "門別富川",
"811543", "釧路",
"814287", "青梅",
"818543", "安来",
"817944", "加古川",
"81467", "藤沢",
"81282", "栃木",
"818592", "米子",
"812238", "仙台",
"817684", "輪島",
"81593", "四日市",
"81950", "平戸",
"818373", "長門",
"812653", "飯田",
"818299", "広島",
"818247", "庄原",
"817476", "下市",
"811634", "浜頓別",
"812879", "烏山",
"815758", "郡上八幡",
"8175", "京都",
"812477", "三春",
"817353", "新宮",
"81988", "那覇",
"8167", "大阪",
"8188098", "土佐清水",
"81253", "新潟",
"817738", "舞鶴",
"8128798", "大田原",
"812384", "米沢",
"819208", "対馬佐賀",
"817463", "吉野",
"81243", "二本松",
"81739", "田辺",
"812415", "柳津",
"811937", "宮古",
"812836", "佐野",
"811632", "天塩",
"819783", "豊後高田",
"812382", "米沢",
"815586", "下田",
"812235", "仙台",
"812577", "六日町",
"818667", "井原",
"819672", "熊本一の宮",
"819806", "沖縄宮古",
"815755", "関",
"81924", "福岡",
"819977", "瀬戸内",
"817942", "加古川",
"81940", "宗像",
"812646", "長野",
"818842", "阿南",
"8186992", "備前",
"818203", "柳井",
"818893", "佐川",
"819205", "厳原",
"815977", "熊野",
"818366", "宇部",
"818556", "江津",
"811556", "帯広",
"811366", "寿都",
"817993", "洲本",
"818594", "米子",
"817735", "福知山",
"81425", "立川",
"811753", "むつ",
"817682", "輪島",
"81464", "厚木",
"812855", "小山",
"81565", "豊田",
"81886", "徳島",
"811466", "えりも",
"818466", "木江",
"812795", "渋川",
"812933", "高萩",
"819823", "延岡",
"817615", "小松",
"811392", "木古内",
"818874", "安芸",
"817707", "小浜",
"811874", "角館",
"814998", "小笠原",
"8198296", "日向",
"81930", "行橋",
"819575", "諫早",
"81965", "八代",
"81763", "福野",
"815984", "松阪",
"818698", "備前",
"812482", "白河",
"814228", "武蔵野三鷹",
"812975", "水海道",
"815768", "下呂",
"815736", "中津川",
"8188093", "窪川",
"812614", "大町",
"814701", "鴨川",
"81233", "新庄",
"811535", "厚岸",
"811954", "二戸",
"818954", "宇和島",
"817363", "和歌山橋本",
"812897", "鹿沼",
"812584", "長岡",
"817488", "水口",
"818832", "鴨島",
"818360", "小郡",
"81471", "柏",
"819952", "大口",
"819828", "高千穂",
"81923", "福岡",
"81725", "和泉",
"812938", "水戸",
"811867", "鷹巣",
"817455", "大和高田",
"819435", "八女",
"815952", "上野",
"812571", "六日町",
"812640", "長野",
"817967", "八鹿",
"817483", "八日市",
"811522", "斜里",
"811642", "石狩深川",
"81827", "岩国",
"817497", "長浜",
"811947", "久慈",
"81220", "迫",
"818947", "宇和",
"817368", "岩出",
"8144", "川崎",
"812744", "藤岡",
"81244", "原町",
"815394", "浜松",
"815763", "下呂",
"812552", "上越",
"8186996", "岡山瀬戸",
"812245", "大河原",
"815566", "身延",
"818264", "安芸吉田",
"812830", "宇都宮",
"81439", "木更津",
"811982", "花巻",
"818693", "邑久",
"818475", "府中",
"818687", "美作",
"814223", "武蔵野三鷹",
"81172", "弘前",
"814794", "銚子",
"819592", "大瀬戸",
"815746", "美濃加茂",
"814756", "東金",
"815589", "修善寺大仁",
"811375", "八雲",
"81166", "旭川",
"81484", "川口",
"812655", "飯田",
"8188094", "窪川",
"81585", "揖斐川",
"818375", "美祢",
"819913", "硫黄島",
"81985", "宮崎",
"819788", "国東",
"81893", "大洲",
"818674", "久世",
"812839", "佐野",
"8198292", "延岡",
"812564", "三条",
"819746", "竹田",
"81979", "中津",
"817468", "上北山",
"818545", "木次",
"811545", "釧路",
"819543", "武雄",
"81234", "酒田",
"811333", "当別",
"819964", "川内",
"8112391", "夕張",
"81188", "秋田",
"81888", "高知",
"817355", "新宮",
"817998", "津名",
"817717", "園部",
"814707", "大原",
"811559", "帯広",
"81798", "西宮",
"818369", "宇部",
"818559", "川本",
"817722", "宮津",
"81463", "平塚",
"818208", "久賀",
"81764", "富山",
"819809", "八重山",
"81531", "田原",
"8125487", "津川",
"812697", "飯山",
"812649", "長野",
"8147955", "八日市場",
"812992", "石岡",
"818263", "加計",
"812618", "大町",
"81476", "成田",
"81546", "静岡",
"815764", "下呂",
"812792", "渋川",
"815393", "浜松",
"812376", "寒河江",
"811656", "美深",
"818656", "笠岡",
"814224", "武蔵野三鷹",
"81977", "別府",
"8199347", "鹿児島",
"818694", "岡山",
"812852", "小山",
"81922", "福岡",
"81577", "高山",
"819572", "諫早",
"81778", "武生",
"817484", "八日市",
"812588", "長岡",
"8125486", "津川",
"812789", "前橋",
"812546", "村上",
"81259", "佐渡",
"811395", "江差",
"8112398", "栗山",
"817612", "小松",
"817917", "竜野",
"81946", "甘木",
"818958", "御荘",
"812743", "藤岡",
"811958", "岩手",
"819946", "鹿屋",
"817676", "七尾",
"812972", "水海道",
"818567", "津和野",
"812485", "白河",
"811357", "岩内",
"812677", "佐久",
"811567", "十勝清水",
"815988", "三瀬谷",
"81228", "築館",
"817950", "三田",
"814994", "三宅",
"811878", "大曲",
"819686", "玉名",
"818878", "嶺北",
"811532", "根室",
"811635", "浜頓別",
"81192", "大船渡",
"812412", "喜多方",
"81892", "久万",
"817238", "寝屋川",
"8162", "大阪",
"812232", "岩沼",
"818598", "根雨",
"819963", "川内",
"814286", "相模原",
"8153962", "天竜",
"811457", "門別富川",
"8186997", "岡山瀬戸",
"817959", "三田",
"812385", "米沢",
"818845", "丹生谷",
"8112399", "栗山",
"817945", "加古川",
"819544", "武雄",
"818673", "福渡",
"812563", "三条",
"81936", "北九州",
"815752", "関",
"819675", "熊本一の宮",
"81555", "吉田",
"81462", "厚木",
"817685", "輪島",
"817732", "福知山",
"818246", "三次",
"812780", "前橋",
"814793", "銚子",
"812476", "三春",
"8188095", "土佐清水",
"818204", "柳井",
"818372", "長門",
"812652", "飯田",
"818894", "須崎",
"811372", "鹿部",
"811856", "能代",
"812957", "大子",
"814289", "青梅",
"817994", "洲本",
"818593", "米子",
"811754", "むつ",
"819595", "有川",
"817956", "三田",
"818587", "郡家",
"818796", "土庄",
"81174", "蟹田",
"819936", "加世田",
"81845", "因島",
"811587", "中湧別",
"819968", "出水",
"811542", "釧路",
"818542", "安来",
"81226", "気仙沼",
"819666", "水俣",
"8125482", "村上",
"81242", "会津若松",
"8112390", "夕張",
"819940", "志布志",
"815367", "設楽",
"818976", "新居浜",
"81478", "佐原",
"817725", "宮津",
"812877", "黒磯",
"81548", "榛原",
"811976", "北上",
"818297", "廿日市",
"818249", "東広島",
"818807", "宿毛",
"817352", "新宮",
"817907", "播磨山崎",
"814798", "八日市場",
"812995", "石岡",
"81776", "福井",
"817464", "吉野",
"812568", "巻",
"8198297", "日向",
"818678", "新見",
"819784", "豊後高田",
"81948", "飯塚",
"819557", "唐津",
"81762", "金沢",
"811953", "二戸",
"812748", "富岡",
"819955", "加治木",
"817364", "和歌山橋本",
"818953", "宇和島",
"812549", "津川",
"818240", "東広島",
"812786", "沼田",
"818835", "脇町",
"81938", "北九州",
"812583", "長岡",
"81737", "湯浅",
"81538", "磐田",
"812613", "大町",
"811236", "千歳",
"815955", "上野",
"818268", "千代田",
"819432", "八女",
"817452", "大和高田",
"815398", "浜松",
"818873", "安芸",
"811873", "角館",
"819824", "延岡",
"814280", "立川",
"815983", "松阪",
"819726", "臼杵",
"811645", "留萌",
"811525", "網走",
"815997", "阿児",
"811737", "鰺ケ沢",
"818472", "甲山",
"819949", "大根占",
"812242", "白石",
"81835", "防府",
"81482", "川口",
"812934", "高萩",
"812555", "糸魚川",
"81822", "広島",
"818838", "阿波池田",
"811866", "鷹巣",
"812967", "笠間",
"811393", "松前",
"8188091", "窪川",
"8169", "大阪",
"819822", "延岡",
"812745", "藤岡",
"817966", "八鹿",
"818387", "田万川",
"81225", "石巻",
"815958", "亀山",
"818265", "安芸吉田",
"812244", "白石",
"8152", "名古屋",
"812932", "高萩",
"815395", "浜松",
"81270", "伊勢崎",
"818474", "府中",
"81877", "丸亀",
"81177", "青森",
"811648", "焼尻",
"8112394", "夕張",
"811528", "美幌",
"811551", "十勝池田",
"818686", "津山",
"817362", "和歌山橋本",
"812899", "鹿沼",
"81775", "大津",
"818946", "宇和",
"81899", "松山",
"81199", "盛岡",
"811946", "久慈",
"81744", "大和高田",
"817496", "長浜",
"819434", "八女",
"812570", "小出",
"818660", "岡山瀬戸",
"817454", "大和高田",
"812558", "新井",
"812483", "白河",
"8186552", "倉敷",
"81734", "和歌山",
"819598", "福江",
"817354", "新宮",
"81561", "瀬戸",
"819965", "川内",
"81592", "津",
"8186698", "倉敷",
"819747", "竹田",
"81958", "長崎",
"812383", "米沢",
"811939", "宮古",
"814757", "東金",
"819782", "豊後高田",
"815747", "美濃白川",
"8178", "神戸",
"81992", "鹿児島",
"812579", "小出",
"818669", "総社",
"812890", "宇都宮",
"81433", "千葉",
"817992", "洲本",
"817683", "輪島",
"819979", "徳之島",
"811752", "むつ",
"81929", "福岡",
"814795", "銚子",
"818202", "柳井",
"818374", "長門",
"817728", "峰山",
"818892", "佐川",
"812654", "飯田",
"811374", "森",
"81252", "新潟",
"812696", "飯山",
"814706", "大原",
"817716", "園部",
"818843", "阿南",
"81298", "土浦",
"812998", "潮来",
"818493", "尾道",
"811544", "釧路",
"818544", "木次",
"817943", "加古川",
"8126177", "長野",
"812565", "三条",
"819673", "熊本一の宮",
"815979", "熊野",
"818675", "久世",
"81545", "富士",
"815587", "修善寺大仁",
"819542", "武雄",
"8112393", "夕張",
"815754", "関",
"81721", "富田林",
"818666", "井原",
"81420", "所沢",
"811638", "利尻礼文",
"81489", "草加",
"812576", "十日町",
"819912", "中之島",
"819204", "郷ノ浦",
"812388", "長井",
"818680", "岡山",
"819593", "大瀬戸",
"817734", "福知山",
"818595", "米子",
"812837", "佐野",
"81743", "奈良",
"811936", "宮古",
"817948", "三木",
"814709", "鴨川",
"812993", "石岡",
"819678", "矢部",
"8153977", "天竜",
"818848", "牟岐",
"811367", "寿都",
"811557", "十勝池田",
"81848", "尾道",
"818557", "川本",
"818367", "宇部",
"812414", "柳津",
"817723", "宮津",
"819976", "名瀬",
"817960", "八鹿",
"819807", "沖縄宮古",
"817688", "能都",
"812234", "仙台",
"811332", "当別",
"812647", "長野",
"812974", "水海道",
"81263", "松本",
"817706", "小浜",
"815953", "上野",
"81581", "高富",
"812615", "大町",
"814700", "鴨川",
"814992", "伊豆大島",
"818398", "小郡",
"811398", "熊石",
"811869", "大館",
"818955", "宇和島",
"811534", "中標津",
"811955", "二戸",
"819953", "大口",
"817969", "浜坂",
"81138", "函館",
"818467", "木江",
"812585", "長岡",
"818833", "鴨島",
"8182942", "広島",
"812896", "鹿沼",
"81284", "足利",
"814222", "武蔵野三鷹",
"818949", "宇和",
"819737", "玖珠",
"812488", "須賀川",
"812854", "小山",
"818692", "邑久",
"811983", "花巻",
"8183767", "下関",
"81249", "郡山",
"81935", "北九州",
"812553", "上越",
"815762", "下呂",
"812794", "渋川",
"81956", "佐世保",
"81434", "千葉",
"8147950", "八日市場",
"811875", "角館",
"818875", "土佐山田",
"81535", "浜松",
"817614", "小松",
"815985", "松阪",
"819574", "諫早",
"818689", "岡山",
"815737", "中津川",
"811523", "斜里",
"814772", "市川",
"817482", "八日市",
"8124197", "柳津",
"811643", "石狩深川",
"81989", "那覇",
"817715", "亀岡",
"814705", "館山",
"817357", "串本",
"817902", "福崎",
"8198291", "延岡",
"812872", "大田原",
"81944", "瀬高",
"81975", "大分",
"815362", "新城",
"818676", "久世",
"818802", "窪川",
"818292", "広島",
"819744", "三重",
"812566", "三条",
"812580", "十日町",
"815744", "美濃加茂",
"814754", "茂原",
"819552", "伊万里",
"818243", "東広島",
"814796", "八日市場",
"81474", "船橋",
"81544", "富士宮",
"811978", "北上",
"812473", "石川",
"818978", "伯方",
"812695", "中野",
"817239", "寝屋川",
"819668", "水俣",
"811582", "紋別",
"818582", "倉吉",
"811377", "八雲",
"812657", "伊那",
"818377", "下関",
"8112392", "夕張",
"819966", "出水",
"8125480", "村上",
"819938", "加世田",
"818798", "土庄",
"817958", "丹波柏原",
"818547", "掛合",
"81878", "高松",
"814283", "青梅",
"81178", "八戸",
"811547", "白糠",
"814297", "飯能",
"811858", "能代",
"819943", "鹿屋",
"817495", "長浜",
"811945", "久慈",
"818945", "八幡浜",
"812964", "下館",
"815992", "鳥羽",
"817673", "羽咋",
"81853", "出雲",
"818384", "萩",
"817230", "寝屋川",
"819728", "臼杵",
"814240", "国分寺",
"818879", "室戸",
"812247", "大河原",
"819683", "山鹿",
"818477", "東城",
"818685", "津山",
"811732", "五所川原",
"81729", "八尾",
"815564", "鰍沢青柳",
"81460", "小田原",
"818266", "千代田",
"811238", "栗山",
"81534", "浜松",
"815396", "浜松",
"81182", "横手",
"811653", "士別",
"812373", "村山",
"8182943", "広島",
"812619", "大町",
"81792", "姫路",
"812788", "前橋",
"812913", "鉾田",
"811865", "大館",
"817457", "大和高田",
"81557", "伊東",
"819437", "田主丸",
"812543", "新発田",
"81934", "北九州",
"812589", "長岡",
"817965", "豊岡",
"812746", "富岡",
"818876", "土佐山田",
"819688", "玉名",
"811876", "大曲",
"812977", "竜ケ崎",
"811562", "本別",
"812672", "小諸",
"811352", "余市",
"818562", "益田",
"819723", "佐伯",
"815986", "松阪",
"81240", "磐城富岡",
"81969", "天草",
"812895", "宇都宮",
"81569", "半田",
"811537", "中標津",
"819948", "志布志",
"81176", "十和田",
"8182920", "廿日市",
"817678", "七尾",
"811464", "静内",
"818464", "竹原",
"819734", "日田",
"812857", "真岡",
"811956", "岩手",
"818956", "宇和島",
"81774", "宇治",
"812783", "沼田",
"812797", "渋川",
"812586", "長岡",
"8125488", "津川",
"817617", "加賀",
"811541", "弟子屈",
"812560", "糸魚川",
"8112396", "栗山",
"811658", "上川",
"817705", "小浜",
"812378", "寒河江",
"814291", "飯能",
"815399", "天竜",
"817912", "相生",
"819577", "島原",
"81473", "市川",
"812616", "大町",
"811233", "千歳",
"81543", "静岡",
"815734", "恵那",
"815584", "下田",
"812478", "三春",
"818973", "新居浜",
"811973", "水沢",
"819975", "名瀬",
"815757", "郡上八幡",
"81533", "豊橋",
"818248", "庄原",
"8125489", "津川",
"81933", "北九州",
"817472", "五条",
"817737", "舞鶴",
"81492", "川越",
"812569", "巻",
"818679", "新見",
"812834", "宇都宮",
"814288", "青梅",
"81191", "一関",
"811853", "男鹿",
"819969", "中甑",
"81162", "稚内",
"818596", "米子",
"81862", "岡山",
"818364", "宇部",
"818793", "三本松",
"812417", "会津山口",
"81480", "久喜",
"817953", "西脇",
"818554", "浜田",
"811554", "帯広",
"811935", "釜石",
"819933", "指宿",
"81429", "所沢",
"811364", "倶知安",
"8153960", "天竜",
"819804", "名護",
"8186553", "倉敷",
"811452", "早来",
"812237", "仙台",
"812575", "十日町",
"819663", "人吉",
"818665", "高梁",
"812644", "木曾福島",
"817686", "能都",
"818362", "宇部",
"818552", "浜田",
"811552", "帯広",
"811362", "倶知安",
"818245", "三次",
"812475", "石川",
"81272", "前橋",
"819978", "徳之島",
"812693", "中野",
"817713", "亀岡",
"818846", "丹生谷",
"814703", "館山",
"812999", "潮来",
"815978", "熊野",
"812642", "木曾福島",
"811337", "石狩",
"81227", "仙台",
"81144", "苫小牧",
"81875", "観音寺",
"817946", "三木",
"819676", "高森",
"819802", "南大東",
"811454", "鵡川",
"811938", "宮古",
"81722", "堺",
"814285", "相模原",
"8168", "大阪",
"819547", "鹿島",
"815582", "下田",
"819599", "大瀬戸",
"812386", "長井",
"8125483", "村上",
"812578", "六日町",
"817474", "五条",
"811636", "北見枝幸",
"812550", "安塚",
"818668", "井原",
"81578", "神岡",
"812832", "佐野",
"81438", "木更津",
"815767", "下呂",
"819732", "日田",
"814227", "武蔵野三鷹",
"818683", "津山",
"81553", "山梨",
"819685", "玉名",
"818697", "備前",
"818943", "八幡浜",
"819945", "鹿屋",
"817493", "彦根",
"811943", "岩泉",
"817675", "七尾",
"814777", "船橋",
"817487", "水口",
"81288", "今市",
"815732", "恵那",
"812898", "鹿沼",
"817914", "相生",
"812486", "須賀川",
"812559", "安塚",
"811863", "鹿角",
"81134", "小樽",
"811396", "江差",
"81582", "岐阜",
"812545", "村上",
"81834", "徳山",
"812674", "小諸",
"811564", "上士幌",
"811354", "余市",
"818564", "益田",
"817963", "豊岡",
"811462", "浦河",
"818462", "竹原",
"81857", "鳥取",
"818655", "鴨方",
"811655", "名寄",
"81266", "諏訪",
"81157", "北見",
"815959", "亀山",
"812375", "村山",
"8198295", "日向",
"81250", "新津",
"812893", "宇都宮",
"817367", "岩出",
"811986", "遠野",
"81547", "島田",
"815562", "鰍沢青柳",
"817498", "長浜",
"818948", "宇和",
"812489", "須賀川",
"812556", "糸魚川",
"8125484", "村上",
"8186995", "岡山瀬戸",
"818688", "美作",
"81947", "田川",
"819725", "佐伯",
"811526", "網走",
"811646", "羽幌",
"817703", "敦賀",
"8166", "大阪",
"818382", "萩",
"817940", "加古川",
"818490", "尾道",
"819827", "高千穂",
"815956", "上野",
"819233", "前原",
"811235", "夕張",
"812962", "下館",
"815994", "阿児",
"811734", "五所川原",
"813", "東京",
"81143", "室蘭",
"817968", "浜坂",
"8188097", "土佐清水",
"819956", "加治木",
"812785", "沼田",
"811868", "鷹巣",
"812937", "水戸",
"818836", "脇町",
"818207", "久賀",
"812996", "潮来",
"81294", "常陸太田",
"8199345", "鹿児島",
"81833", "下松",
"811757", "野辺地",
"817949", "加古川",
"817718", "園部",
"817997", "津名",
"814708", "大原",
"811584", "遠軽",
"818584", "倉吉",
"819679", "高森",
"815973", "尾鷲",
"811975", "水沢",
"817726", "峰山",
"819973", "種子島",
"818975", "新居浜",
"812698", "飯山",
"81268", "上田",
"814771", "市川",
"812874", "大田原",
"811639", "利尻礼文",
"818804", "土佐中村",
"81562", "尾張横須賀",
"81436", "市原",
"818294", "廿日市",
"819742", "三重",
"81554", "大月",
"81591", "津",
"818663", "総社",
"81937", "北九州",
"812573", "柏崎",
"8153963", "天竜",
"819665", "人吉",
"817904", "福崎",
"81537", "掛川",
"81738", "御坊",
"811855", "能代",
"81286", "宇都宮",
"819787", "国東",
"815742", "美濃加茂",
"819596", "福江",
"81962", "熊本",
"814752", "茂原",
"811933", "釜石",
"819935", "加世田",
"819554", "伊万里",
"818795", "三本松",
"817955", "三田",
"812389", "米沢",};
$areanames{en} = {"81762", "Kanazawa\,\ Ishikawa",
"812246", "Ogawara\,\ Miyagi",
"815998", "Ago\,\ Mie",
"81280", "Koga\,\ Ibaraki",
"819955", "Kajiki\,\ Kagoshima",
"812748", "Tomioka\,\ Gunma",
"811953", "Ninohe\,\ Iwate",
"818953", "Uwajima\,\ Ehime",
"812549", "Tsugawa\,\ Niigata",
"81952", "Saga\,\ Saga",
"812786", "Numata\,\ Gunma",
"818240", "Higashi\-ku\,\ Hiroshima",
"81797", "Nishinomiya\,\ Hyogo",
"818835", "Mima\,\ Tokushima",
"81938", "Kitakyushu\,\ Fukuoka",
"812583", "Nagaoka\,\ Niigata",
"8198294", "Nobeoka\,\ Miyazaki",
"818476", "Fuchu\,\ Hiroshima",
"812230", "Sendai\,\ Miyagi",
"81538", "Iwata\,\ Shizuoka",
"81737", "Yuasa\,\ Wakayama",
"81998", "Kagoshima\,\ Kagoshima",
"811864", "Odate\,\ Akita",
"8199343", "Kagoshima\,\ Kagoshima",
"81564", "Okazaki\,\ Aichi",
"819722", "Saiki\,\ Oita",
"81465", "Odawara\,\ Kanagawa",
"81552", "Kofu\,\ Yamanashi",
"812673", "Komoro\,\ Nagano",
"811563", "Honbetsu\,\ Hokkaido",
"811353", "Yoichi\,\ Hokkaido",
"812613", "Omachi\,\ Nagano",
"811236", "Chitose\,\ Hokkaido",
"817964", "Toyooka\,\ Hyogo",
"818563", "Masuda\,\ Shimane",
"8153966", "Hamamatsu\,\ Shizuoka",
"819432", "Yame\,\ Fukuoka",
"815398", "Hamamatsu\,\ Shizuoka",
"817452", "Yamatotakada\,\ Nara",
"812859", "Oyama\,\ Tochigi",
"81779", "Ono\,\ Gifu",
"818873", "Aki\,\ Kochi",
"811873", "Kakunodate\,\ Akita",
"812965", "Shimodate\,\ Ibaraki",
"817456", "Yamatotakada\,\ Nara",
"8153978", "Hamamatsu\,\ Shizuoka",
"818944", "Yawatahama\,\ Ehime",
"814280", "Tachikawa\,\ Tokyo",
"811232", "Chitose\,\ Hokkaido",
"819824", "Nobeoka\,\ Miyazaki",
"817494", "Hikone\,\ Shiga",
"811944", "Iwaizumi\,\ Iwate",
"81983", "Takanabe\,\ Miyazaki",
"812747", "Tomioka\,\ Gunma",
"812799", "Naganohara\,\ Gunma",
"815983", "Matsusaka\,\ Mie",
"819726", "Usuki\,\ Oita",
"818514", "Ama\,\ Shimane",
"818385", "Hagi\,\ Yamaguchi",
"811645", "Rumoi\,\ Hokkaido",
"815997", "Ago\,\ Mie",
"811525", "Abashiri\,\ Hokkaido",
"81292", "Mito\,\ Ibaraki",
"812782", "Numata\,\ Gunma",
"81583", "Gifu\,\ Gifu",
"8153965", "Hamamatsu\,\ Shizuoka",
"81482", "Kawaguchi\,\ Saitama",
"818684", "Tsuyama\,\ Okayama",
"81835", "Hofu\,\ Yamaguchi",
"812242", "Shiroishi\,\ Miyagi",
"812934", "Takahagi\,\ Ibaraki",
"812555", "Itoigawa\,\ Niigata",
"814797", "Yokaichiba\,\ Chiba",
"818372", "Nagato\,\ Yamaguchi",
"818204", "Yanai\,\ Yamaguchi",
"811372", "Shikabe\,\ Hokkaido",
"812652", "Iida\,\ Nagano",
"818894", "Susaki\,\ Kochi",
"812957", "Daigo\,\ Ibaraki",
"811856", "Noshiro\,\ Akita",
"81828", "Hiroshima\,\ Hiroshima",
"8186993", "Bizen\,\ Okayama",
"818298", "Hatsukaichi\,\ Hiroshima",
"818593", "Yonago\,\ Tottori",
"817994", "Sumoto\,\ Hyogo",
"814289", "Ome\,\ Tokyo",
"811754", "Mutsu\,\ Aomori",
"818808", "Tosashimizu\,\ Kochi",
"818796", "Tonosho\,\ Kagawa",
"818587", "Koge\,\ Tottori",
"815368", "Shitara\,\ Aichi",
"817956", "Sanda\,\ Hyogo",
"819968", "Izumi\,\ Kagoshima",
"81845", "Innoshima\,\ Hiroshima",
"811587", "Nakayubetsu\,\ Hokkaido",
"812878", "Nasukarasuyama\,\ Tochigi",
"819936", "Kaseda\,\ Kagoshima",
"81174", "Kanita\,\ Aomori",
"811542", "Kushiro\,\ Hokkaido",
"817356", "Kushimoto\,\ Wakayama",
"81226", "Kesennuma\,\ Miyagi",
"819558", "Karatsu\,\ Saga",
"818542", "Yasugi\,\ Shimane",
"81273", "Takasaki\,\ Gunma",
"8165", "Osaka\,\ Osaka",
"8125482", "Murakami\,\ Niigata",
"819666", "Minamata\,\ Kumamoto",
"818677", "Niimi\,\ Okayama",
"8153979", "Hamamatsu\,\ Shizuoka",
"81242", "Aizuwakamatsu\,\ Fukushima",
"818972", "Niihama\,\ Ehime",
"811972", "Mizusawa\,\ Iwate",
"819940", "Shibushi\,\ Kagoshima",
"8112390", "Yubari\,\ Hokkaido",
"818588", "Koge\,\ Tottori",
"818976", "Niihama\,\ Ehime",
"815367", "Shitara\,\ Aichi",
"819967", "Izumi\,\ Kagoshima",
"811976", "Kitakami\,\ Iwate",
"812877", "Kuroiso\,\ Tochigi",
"81548", "Haibara\,\ Shizuoka",
"817725", "Miyazu\,\ Kyoto",
"81478", "Sawara\,\ Chiba",
"811588", "Okoppe\,\ Hokkaido",
"817714", "Kameoka\,\ Kyoto",
"818297", "Hatsukaichi\,\ Hiroshima",
"814704", "Tateyama\,\ Chiba",
"819662", "Hitoyoshi\,\ Kumamoto",
"818807", "Sukumo\,\ Kochi",
"818249", "Higashi\-ku\,\ Hiroshima",
"812419", "Tajima\,\ Fukushima",
"811453", "Hayakita\,\ Hokkaido",
"8183768", "Shimonoseki\,\ Yamaguchi",
"814798", "Yokaichiba\,\ Chiba",
"811546", "Kushiro\,\ Hokkaido",
"817352", "Shingu\,\ Fukuoka",
"818546", "Kakeya\,\ Shimane",
"817952", "Nishiwaki\,\ Hyogo",
"812995", "Ishioka\,\ Ibaraki",
"81776", "Fukui\,\ Fukui",
"819932", "Ibusuki\,\ Kagoshima",
"81925", "Fukuoka\,\ Fukuoka",
"814755", "Togane\,\ Chiba",
"817464", "Yoshino\,\ Nara",
"81723", "Sakai\,\ Osaka",
"815745", "Minokamo\,\ Gifu",
"818678", "Niimi\,\ Okayama",
"8198297", "Hyuga\,\ Miyazaki",
"811852", "Oga\,\ Akita",
"812694", "Nakano\,\ Nagano",
"819784", "Bungotakada\,\ Oita",
"8126170", "Omachi\,\ Nagano",
"812239", "Sendai\,\ Miyagi",
"81948", "Iizuka\,\ Fukuoka",
"818376", "Mine\,\ Yamaguchi",
"811376", "Yakumo\,\ Hokkaido",
"812656", "Ina\,\ Nagano",
"819557", "Karatsu\,\ Saga",
"8126179", "Omachi\,\ Nagano",
"811635", "Hamatonbetsu\,\ Hokkaido",
"81192", "Ofunato\,\ Iwate",
"812412", "Kitakata\,\ Fukushima",
"81892", "Kumakogen\,\ Ehime",
"81984", "Kobayashi\,\ Miyazaki",
"812472", "Ishikawa\,\ Fukushima",
"81167", "Furano\,\ Hokkaido",
"811934", "Kamaishi\,\ Iwate",
"811555", "Obihiro\,\ Hokkaido",
"819553", "Imari\,\ Saga",
"81235", "Tsuruoka\,\ Yamagata",
"818242", "Higashi\-ku\,\ Hiroshima",
"811365", "Kutchan\,\ Hokkaido",
"818365", "Ube\,\ Yamaguchi",
"817238", "Neyagawa\,\ Osaka",
"818555", "Gotsu\,\ Shimane",
"8162", "Osaka\,\ Osaka",
"81949", "Nogata\,\ Fukuoka",
"81260", "Anan\,\ Nagano",
"817736", "Maizuru\,\ Kyoto",
"81549", "Shizuoka\,\ Shizuoka",
"819805", "Nago\,\ Okinawa",
"818293", "Hatsukaichi\,\ Hiroshima",
"812232", "Iwanuma\,\ Miyagi",
"819963", "Satsumasendai\,\ Kagoshima",
"812873", "Otawara\,\ Tochigi",
"815363", "Shinshiro\,\ Aichi",
"81584", "Ogaki\,\ Gifu",
"81832", "Shimonoseki\,\ Yamaguchi",
"814286", "Sagamihara\,\ Kanagawa",
"8188096", "Tosashimizu\,\ Kochi",
"81485", "Kumagaya\,\ Saitama",
"817903", "Fukusaki\,\ Hyogo",
"8186997", "Seto\,\ Okayama",
"818664", "Takahashi\,\ Okayama",
"812574", "Kashiwazaki\,\ Niigata",
"812385", "Yonezawa\,\ Yamagata",
"817959", "Sanda\,\ Hyogo",
"81963", "Kumamoto\,\ Kumamoto",
"8112399", "Kuriyama\,\ Hokkaido",
"819974", "Yakushima\,\ Kagoshima",
"814282", "Ome\,\ Tokyo",
"81765", "Uozu\,\ Toyama",
"815585", "Shimoda\,\ Shizuoka",
"8153970", "Hamamatsu\,\ Shizuoka",
"817945", "Kakogawa\,\ Hyogo",
"819544", "Takeo\,\ Saga",
"8198293", "Nobeoka\,\ Miyazaki",
"81596", "Ise\,\ Mie",
"812659", "Ina\,\ Nagano",
"812236", "Sendai\,\ Miyagi",
"815752", "Sekigahara\,\ Gifu",
"81936", "Kitakyushu\,\ Fukuoka",
"812563", "Sanjo\,\ Niigata",
"817685", "Wajima\,\ Ishikawa",
"81555", "Fujiyoshida\,\ Yamanashi",
"81462", "Atsugi\,\ Kanagawa",
"81281", "Utsunomiya\,\ Tochigi",
"817732", "Fukuchiyama\,\ Kyoto",
"812780", "Maebashi\,\ Gunma",
"818246", "Miyoshi\,\ Hiroshima",
"814793", "Choshi\,\ Chiba",
"812835", "Sano\,\ Tochigi",
"811583", "Monbetsu\,\ Hokkaido",
"818583", "Kurayoshi\,\ Tottori",
"8188095", "Tosashimizu\,\ Kochi",
"81563", "Nishio\,\ Aichi",
"815974", "Owase\,\ Mie",
"812416", "Tajima\,\ Fukushima",
"812476", "Miharu\,\ Fukushima",
"811549", "Kushiro\,\ Hokkaido",
"818568", "Tsuwano\,\ Shimane",
"818263", "Kake\,\ Hiroshima",
"81546", "Shizuoka\,\ Shizuoka",
"812678", "Saku\,\ Nagano",
"81476", "Narita\,\ Chiba",
"811536", "Akkeshi\,\ Hokkaido",
"812618", "Omachi\,\ Nagano",
"815393", "Hamamatsu\,\ Shizuoka",
"819682", "Yamaga\,\ Kumamoto",
"815764", "Gero\,\ Gifu",
"812792", "Shibukawa\,\ Gunma",
"819735", "Hita\,\ Oita",
"811733", "Goshogawara\,\ Aomori",
"81423", "Kokubunji\,\ Tokyo",
"811656", "Bifuka\,\ Hokkaido",
"812376", "Sagae\,\ Yamagata",
"818656", "Kasaoka\,\ Okayama",
"8182941", "Hiroshima\,\ Hiroshima",
"81977", "Beppu\,\ Oita",
"812852", "Oyama\,\ Tochigi",
"818694", "Okayama\,\ Okayama",
"8199347", "Kagoshima\,\ Kagoshima",
"8186697", "Kurashiki\,\ Okayama",
"81740", "Imazu\,\ Shiga",
"819572", "Isahaya\,\ Nagasaki",
"81778", "Takefu\,\ Fukui",
"81577", "Takayama\,\ Gifu",
"81922", "Fukuoka\,\ Fukuoka",
"812588", "Nagaoka\,\ Niigata",
"811877", "Omagari\,\ Akita",
"817704", "Tsuruga\,\ Fukui",
"817484", "Yokaichi\,\ Shiga",
"812789", "Maebashi\,\ Gunma",
"8125486", "Tsugawa\,\ Niigata",
"815993", "Toba\,\ Mie",
"815735", "Ena\,\ Gifu",
"8112398", "Kuriyama\,\ Hokkaido",
"817612", "Komatsu\,\ Ishikawa",
"811395", "Esashi\,\ Hokkaido",
"81259", "Sado\,\ Niigata",
"817672", "Hakui\,\ Ishikawa",
"812546", "Murakami\,\ Niigata",
"818958", "Misho\,\ Ehime",
"81946", "Amagi\,\ Fukuoka",
"818479", "Tojo\,\ Hiroshima",
"811958", "Iwate\,\ Iwate",
"812743", "Fujioka\,\ Gunma",
"819946", "Kanoya\,\ Kagoshima",
"8186994", "Seto\,\ Okayama",
"81126", "Iwamizawa\,\ Hokkaido",
"817616", "Komatsu\,\ Ishikawa",
"817676", "Nanao\,\ Ishikawa",
"812542", "Shibata\,\ Niigata",
"81142", "Date\,\ Hokkaido",
"812485", "Shirakawa\,\ Fukushima",
"818567", "Tsuwano\,\ Shimane",
"812677", "Saku\,\ Nagano",
"819576", "Shimabara\,\ Nagasaki",
"811357", "Iwanai\,\ Hokkaido",
"818957", "Misho\,\ Ehime",
"8147957", "Yokaichiba\,\ Chiba",
"812856", "Mooka\,\ Tochigi",
"817950", "Sanda\,\ Hyogo",
"811957", "Iwate\,\ Iwate",
"811652", "Shibetsu\,\ Hokkaido",
"812372", "Murayama\,\ Yamagata",
"818652", "Kurashiki\,\ Okayama",
"812894", "Utsunomiya\,\ Tochigi",
"819686", "Tamana\,\ Kumamoto",
"812796", "Shibukawa\,\ Gunma",
"811878", "Omagari\,\ Akita",
"812587", "Nagaoka\,\ Niigata",
"8125485", "Tsugawa\,\ Niigata",
"81245", "Fukushima\,\ Fukushima",
"811465", "Shizunai\,\ Hokkaido",
"81939", "Kitakyushu\,\ Fukuoka",
"8126178", "Omachi\,\ Nagano",
"811532", "Nemuro\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"817706", "Obama\,\ Fukui",
"817486", "Minakuchi\,\ Shiga",
"812914", "Hokota\,\ Ibaraki",
"81263", "Matsumoto\,\ Nagano",
"81898", "Imabari\,\ Ehime",
"818565", "Masuda\,\ Shimane",
"812487", "Sukagawa\,\ Fukushima",
"81587", "Ichinomiya\,\ Aichi",
"812675", "Saku\,\ Nagano",
"81236", "Yamagata\,\ Yamagata",
"812615", "Omachi\,\ Nagano",
"819738", "Kusu\,\ Oita",
"814700", "Kamogawa\,\ Chiba",
"812544", "Shibata\,\ Niigata",
"815766", "Gero\,\ Gifu",
"815738", "Nakatsugawa\,\ Gifu",
"818398", "Ogori\,\ Yamaguchi",
"811398", "Kumaishi\,\ Hokkaido",
"818955", "Uwajima\,\ Ehime",
"811869", "Odate\,\ Akita",
"81987", "Nichinan\,\ Miyazaki",
"819953", "Okuchi\,\ Kagoshima",
"811534", "Nakashibetsu\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"81486", "Urawa\,\ Saitama",
"81852", "Matsue\,\ Shimane",
"81864", "Kurashiki\,\ Okayama",
"818696", "Bizen\,\ Okayama",
"811654", "Nayoro\,\ Hokkaido",
"812585", "Nagaoka\,\ Niigata",
"818467", "Mima\,\ Tokushima",
"812374", "Murayama\,\ Yamagata",
"817969", "Hamasaka\,\ Hyogo",
"81138", "Hakodate\,\ Hokkaido",
"8182942", "Hiroshima\,\ Hiroshima",
"818833", "Kamojima\,\ Tokushima",
"812892", "Utsunomiya\,\ Tochigi",
"818654", "Kamogata\,\ Okayama",
"819737", "Kusu\,\ Oita",
"818949", "Uwajima\,\ Ehime",
"81284", "Ashikaga\,\ Tochigi",
"812896", "Kanuma\,\ Tochigi",
"812488", "Sukagawa\,\ Fukushima",
"81766", "Takaoka\,\ Toyama",
"811983", "Hanamaki\,\ Iwate",
"812854", "Oyama\,\ Tochigi",
"818692", "Oku\,\ Okayama",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81249", "Koriyama\,\ Fukushima",
"81956", "Sasebo\,\ Nagasaki",
"819684", "Yamaga\,\ Kumamoto",
"815762", "Gero\,\ Gifu",
"812794", "Shibukawa\,\ Gunma",
"81935", "Kitakyushu\,\ Fukuoka",
"812553", "Joetsu\,\ Niigata",
"81494", "Chichibu\,\ Saitama",
"811875", "Kakunodate\,\ Akita",
"812963", "Shimodate\,\ Ibaraki",
"8147950", "Yokaichiba\,\ Chiba",
"81434", "Chiba\,\ Chiba",
"8198298", "Hyuga\,\ Miyazaki",
"817614", "Komatsu\,\ Ishikawa",
"81535", "Hamamatsu\,\ Shizuoka",
"817674", "Hakui\,\ Ishikawa",
"81793", "Himeji\,\ Hyogo",
"819944", "Kanoya\,\ Kagoshima",
"81468", "Yokosuka\,\ Kanagawa",
"819232", "Maebaru\,\ Fukuoka",
"815985", "Matsusaka\,\ Mie",
"818383", "Hagi\,\ Yamaguchi",
"817915", "Aioi\,\ Hyogo",
"812939", "Mito\,\ Ibaraki",
"819574", "Isahaya\,\ Nagasaki",
"818689", "Okayama\,\ Okayama",
"81183", "Yuzawa\,\ Akita",
"8124197", "Yanaizu\,\ Fukushima",
"817702", "Tsuruga\,\ Fukui",
"814772", "Ichikawa\,\ Chiba",
"817482", "Yokaichi\,\ Shiga",
"811523", "Shari\,\ Hokkaido",
"815737", "Nakatsugawa\,\ Gifu",
"818397", "Ogori\,\ Yamaguchi",
"811397", "Okushiri\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"811336", "Ishikari\,\ Hokkaido",
"811558", "Hiroo\,\ Hokkaido",
"818368", "Ube\,\ Yamaguchi",
"818558", "Kawamoto\,\ Shimane",
"819542", "Takeo\,\ Saga",
"8112393", "Yubari\,\ Hokkaido",
"815754", "Sekigahara\,\ Gifu",
"81420", "Tokorozawa\,\ Saitama",
"81727", "Ikeda\,\ Osaka",
"818666", "Ibara\,\ Okayama",
"81721", "Tondabayashi\,\ Osaka",
"812576", "Tokamachi\,\ Niigata",
"81489", "Soka\,\ Saitama",
"817947", "Miki\,\ Hyogo",
"8198299", "Hyuga\,\ Miyazaki",
"814284", "Tachikawa\,\ Tokyo",
"812551", "Joetsu\,\ Niigata",
"815972", "Owase\,\ Mie",
"812648", "Nagano\,\ Nagano",
"812930", "Mito\,\ Ibaraki",
"817687", "Noto\,\ Ishikawa",
"817475", "Shimonoseki\,\ Yamaguchi",
"818680", "Okayama\,\ Okayama",
"812388", "Nagai\,\ Yamagata",
"81928", "Fukuoka\,\ Fukuoka",
"819593", "Oseto\,\ Nagasaki",
"819808", "Yaeyama\ District\,\ Okinawa",
"818595", "Yonago\,\ Tottori",
"817734", "Fukuchiyama\,\ Kyoto",
"811936", "Miyako\,\ Iwate",
"81743", "Nara\,\ Nara",
"812837", "Sano\,\ Tochigi",
"81559", "Numazu\,\ Shizuoka",
"8126173", "Omachi\,\ Nagano",
"811932", "Kamaishi\,\ Iwate",
"817948", "Miki\,\ Hyogo",
"818244", "Miyoshi\,\ Hiroshima",
"812993", "Ishioka\,\ Ibaraki",
"814709", "Kamogawa\,\ Chiba",
"81825", "Hiroshima\,\ Hiroshima",
"815743", "Minokamo\,\ Gifu",
"814753", "Mobara\,\ Chiba",
"81125", "Takikawa\,\ Hokkaido",
"81277", "Kiryu\,\ Gunma",
"81848", "Onomichi\,\ Hiroshima",
"811367", "Suttsu\,\ Hokkaido",
"812414", "Yanaizu\,\ Fukushima",
"818367", "Ube\,\ Yamaguchi",
"812474", "Ishikawa\,\ Fukushima",
"818557", "Kawamoto\,\ Shimane",
"812838", "Sano\,\ Tochigi",
"819976", "Naze\,\ Kagoshima",
"817723", "Miyazu\,\ Kyoto",
"818662", "Takahashi\,\ Okayama",
"812572", "Kashiwazaki\,\ Niigata",
"81222", "Sendai\,\ Miyagi",
"81246", "Iwaki\,\ Fukushima",
"817688", "Noto\,\ Ishikawa",
"811455", "Mukawa\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"819743", "Mie\,\ Oita",
"812387", "Nagai\,\ Yamagata",
"811332", "Tobetsu\,\ Hokkaido",
"819789", "Kitsuki\,\ Oita",
"819546", "Kashima\,\ Saga",
"812647", "Nagano\,\ Nagano",
"81734", "Wakayama\,\ Wakayama",
"819803", "Nago\,\ Okinawa",
"818295", "Hatsukaichi\,\ Hiroshima",
"8186552", "Kurashiki\,\ Okayama",
"819598", "Fukue\,\ Nagasaki",
"81493", "Higashimatsuyama\,\ Saitama",
"81567", "Tsushima\,\ Aichi",
"817354", "Shingu\,\ Fukuoka",
"81561", "Seto\,\ Aichi",
"819965", "Satsumasendai\,\ Kagoshima",
"812875", "Otawara\,\ Tochigi",
"81592", "Tsu\,\ Mie",
"817905", "Fukusaki\,\ Hyogo",
"81932", "Kitakyushu\,\ Fukuoka",
"8186698", "Kurashiki\,\ Okayama",
"8125481", "Murakami\,\ Niigata",
"817712", "Kameoka\,\ Kyoto",
"81958", "Nagasaki\,\ Nagasaki",
"814702", "Tateyama\,\ Chiba",
"812383", "Yonezawa\,\ Yamagata",
"819747", "Taketa\,\ Oita",
"819664", "Hitoyoshi\,\ Kumamoto",
"811939", "Miyako\,\ Iwate",
"814757", "Togane\,\ Chiba",
"811854", "Oga\,\ Akita",
"819782", "Bungotakada\,\ Oita",
"812692", "Nakano\,\ Nagano",
"81184", "Yurihonjo\,\ Akita",
"81466", "Fujisawa\,\ Kanagawa",
"818206", "Yanai\,\ Yamaguchi",
"812997", "Itako\,\ Ibaraki",
"8178", "Kobe\,\ Hyogo",
"81532", "Toyohashi\,\ Aichi",
"81992", "Kagoshima\,\ Kagoshima",
"818896", "Susaki\,\ Kochi",
"818363", "Ube\,\ Yamaguchi",
"818553", "Hamada\,\ Shimane",
"817954", "Nishiwaki\,\ Hyogo",
"811553", "Obihiro\,\ Hokkaido",
"819555", "Karatsu\,\ Saga",
"819934", "Ibusuki\,\ Kagoshima",
"818669", "Soja\,\ Okayama",
"811363", "Kutchan\,\ Hokkaido",
"817996", "Tsuna\,\ Hyogo",
"812890", "Utsunomiya\,\ Tochigi",
"81849", "Fukuyama\,\ Hiroshima",
"811756", "Noheji\,\ Aomori",
"81433", "Chiba\,\ Chiba",
"8112397", "Kuriyama\,\ Hokkaido",
"817992", "Sumoto\,\ Hyogo",
"81196", "Morioka\,\ Iwate",
"814220", "Kokubunji\,\ Tokyo",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"817466", "Totsukawa\,\ Nara",
"811752", "Mutsu\,\ Aomori",
"819979", "Tokunoshima\,\ Kagoshima",
"817683", "Wajima\,\ Ishikawa",
"81896", "Iyomishima\,\ Ehime",
"814795", "Choshi\,\ Chiba",
"818690", "Okayama\,\ Okayama",
"81929", "Fukuoka\,\ Fukuoka",
"8186999", "Seto\,\ Okayama",
"8164", "Osaka\,\ Osaka",
"818585", "Kurayoshi\,\ Tottori",
"818374", "Nagato\,\ Yamaguchi",
"818202", "Yanai\,\ Yamaguchi",
"811374", "Mori\,\ Hokkaido",
"812833", "Utsunomiya\,\ Tochigi",
"818892", "Sakawa\,\ Kochi",
"812654", "Iida\,\ Nagano",
"811585", "Engaru\,\ Hokkaido",
"81252", "Niigata\,\ Niigata",
"819786", "Kitsuki\,\ Oita",
"812696", "Iiyama\,\ Nagano",
"819597", "Fukue\,\ Nagasaki",
"818843", "Anan\,\ Tokushima",
"817716", "Sonobe\,\ Kyoto",
"815583", "Shimoda\,\ Shizuoka",
"81863", "Tamano\,\ Okayama",
"818974", "Niihama\,\ Ehime",
"8198290", "Nobeoka\,\ Miyazaki",
"811974", "Mizusawa\,\ Iwate",
"8111", "Sapporo\,\ Hokkaido",
"81298", "Tsuchiura\,\ Ibaraki",
"818391", "Ogori\,\ Yamaguchi",
"811544", "Kushiro\,\ Hokkaido",
"81488", "Urawa\,\ Saitama",
"818493", "Onomichi\,\ Hiroshima",
"812998", "Itako\,\ Ibaraki",
"818544", "Kisuki\,\ Shimane",
"817943", "Kakogawa\,\ Hyogo",
"815979", "Kumano\,\ Mie",
"8153973", "Hamamatsu\,\ Shizuoka",
"812565", "Sanjo\,\ Niigata",
"814758", "Togane\,\ Chiba",
"814770", "Ichikawa\,\ Chiba",
"818675", "Kuse\,\ Okayama",
"815769", "Shokawa\,\ Gifu",
"8126174", "Omachi\,\ Nagano",
"818512", "Nishigo\,\ Fukushima",
"81822", "Hiroshima\,\ Hiroshima",
"8199331", "Kagoshima\,\ Kagoshima",
"812967", "Kasama\,\ Ibaraki",
"811866", "Takanosu\,\ Akita",
"811647", "Haboro\,\ Hokkaido",
"8169", "Osaka\,\ Osaka",
"811393", "Matsumae\,\ Hokkaido",
"815995", "Ago\,\ Mie",
"815733", "Ena\,\ Gifu",
"811527", "Bihoro\,\ Hokkaido",
"818942", "Yawatahama\,\ Ehime",
"812745", "Fujioka\,\ Gunma",
"819822", "Nobeoka\,\ Miyazaki",
"811234", "Chitose\,\ Hokkaido",
"817492", "Hikone\,\ Shiga",
"811942", "Iwaizumi\,\ Iwate",
"818387", "Tamagawa\,\ Yamaguchi",
"81225", "Ishinomaki\,\ Miyagi",
"811987", "Tono\,\ Iwate",
"817366", "Iwade\,\ Wakayama",
"815958", "Kameyama\,\ Mie",
"819733", "Hita\,\ Oita",
"8163", "Osaka\,\ Osaka",
"818682", "Tsuyama\,\ Okayama",
"8152", "Nagoya\,\ Aichi",
"811735", "Goshogawara\,\ Aomori",
"812244", "Shiroishi\,\ Miyagi",
"815395", "Hamamatsu\,\ Shizuoka",
"812932", "Takahagi\,\ Ibaraki",
"81270", "Isesaki\,\ Gunma",
"8186998", "Seto\,\ Okayama",
"818474", "Fuchu\,\ Hiroshima",
"81877", "Marugame\,\ Kagawa",
"81177", "Aomori\,\ Aomori",
"812784", "Numata\,\ Gunma",
"819957", "Kajiki\,\ Kagoshima",
"818388", "Tamagawa\,\ Yamaguchi",
"8161", "Osaka\,\ Osaka",
"811528", "Bihoro\,\ Hokkaido",
"81542", "Shizuoka\,\ Shizuoka",
"8112394", "Yubari\,\ Hokkaido",
"818686", "Tsuyama\,\ Okayama",
"811463", "Urakawa\,\ Hokkaido",
"818463", "Takehara\,\ Hiroshima",
"812968", "Kasama\,\ Ibaraki",
"812936", "Mito\,\ Ibaraki",
"81839", "Yamaguchi\,\ Yamaguchi",
"818946", "Uwajima\,\ Ehime",
"81899", "Matsuyama\,\ Ehime",
"812899", "Kanuma\,\ Tochigi",
"81775", "Otsu\,\ Shiga",
"819826", "Hyuga\,\ Miyazaki",
"817496", "Nagahama\,\ Shiga",
"81744", "Yamatotakada\,\ Nara",
"811946", "Kuji\,\ Iwate",
"817962", "Toyooka\,\ Hyogo",
"81199", "Morioka\,\ Iwate",
"819434", "Yame\,\ Fukuoka",
"81926", "Fukuoka\,\ Fukuoka",
"818660", "Seto\,\ Okayama",
"817454", "Yamatotakada\,\ Nara",
"81942", "Kurume\,\ Fukuoka",
"81427", "Sagamihara\,\ Kanagawa",
"811862", "Kazuno\,\ Akita",
"819724", "Saiki\,\ Oita",
"812483", "Shirakawa\,\ Fukushima",
"81885", "Komatsushima\,\ Tokushima",
"818973", "Niihama\,\ Ehime",
"81566", "Kariya\,\ Aichi",
"812478", "Miharu\,\ Fukushima",
"815584", "Shimoda\,\ Shizuoka",
"81432", "Chiba\,\ Chiba",
"819975", "Naze\,\ Kagoshima",
"811973", "Mizusawa\,\ Iwate",
"818844", "Anan\,\ Tokushima",
"81550", "Gotenba\,\ Shizuoka",
"81179", "Sannohe\,\ Aomori",
"8153972", "Hamamatsu\,\ Shizuoka",
"81533", "Toyohashi\,\ Aichi",
"811589", "Okoppe\,\ Hokkaido",
"814287", "Ome\,\ Tokyo",
"811543", "Kushiro\,\ Hokkaido",
"8125489", "Tsugawa\,\ Niigata",
"818543", "Yasugi\,\ Shimane",
"818248", "Shobara\,\ Hiroshima",
"817944", "Kakogawa\,\ Hyogo",
"81467", "Fujisawa\,\ Kanagawa",
"81282", "Tochigi\,\ Tochigi",
"81933", "Kitakyushu\,\ Fukuoka",
"812238", "Sendai\,\ Miyagi",
"818592", "Yonago\,\ Tottori",
"81593", "Yokkaichi\,\ Mie",
"817684", "Wajima\,\ Ishikawa",
"817737", "Maizuru\,\ Kyoto",
"81950", "Hirado\,\ Nagasaki",
"818373", "Nagato\,\ Yamaguchi",
"81492", "Kawagoe\,\ Saitama",
"812653", "Iida\,\ Nagano",
"812834", "Utsunomiya\,\ Tochigi",
"818679", "Niimi\,\ Okayama",
"818299", "Hiroshima\,\ Hiroshima",
"814288", "Ome\,\ Tokyo",
"818247", "Shobara\,\ Hiroshima",
"811634", "Hamatonbetsu\,\ Hokkaido",
"811853", "Oga\,\ Akita",
"817476", "Shimonoseki\,\ Yamaguchi",
"81191", "Ichinoseki\,\ Iwate",
"812879", "Nasukarasuyama\,\ Tochigi",
"818596", "Yonago\,\ Tottori",
"81162", "Wakkanai\,\ Hokkaido",
"81862", "Okayama\,\ Okayama",
"8175", "Kyoto\,\ Kyoto",
"812477", "Miharu\,\ Fukushima",
"818554", "Hamada\,\ Shimane",
"817953", "Nishiwaki\,\ Hyogo",
"81480", "Kuki\,\ Saitama",
"818364", "Ube\,\ Yamaguchi",
"811364", "Kutchan\,\ Hokkaido",
"81429", "Tokorozawa\,\ Saitama",
"819933", "Ibusuki\,\ Kagoshima",
"811554", "Obihiro\,\ Hokkaido",
"811935", "Kamaishi\,\ Iwate",
"817353", "Shingu\,\ Fukuoka",
"81253", "Niigata\,\ Niigata",
"8188098", "Tosashimizu\,\ Kochi",
"8167", "Osaka\,\ Osaka",
"81988", "Naha\,\ Okinawa",
"817738", "Maizuru\,\ Kyoto",
"819804", "Nago\,\ Okinawa",
"811452", "Hayakita\,\ Hokkaido",
"8128798", "Otawara\,\ Tochigi",
"8186553", "Kurashiki\,\ Okayama",
"819663", "Hitoyoshi\,\ Kumamoto",
"812384", "Yonezawa\,\ Yamagata",
"812575", "Tokamachi\,\ Niigata",
"812237", "Sendai\,\ Miyagi",
"818665", "Takahashi\,\ Okayama",
"819433", "Yame\,\ Fukuoka",
"817453", "Yamatotakada\,\ Nara",
"819688", "Tamana\,\ Kumamoto",
"811876", "Omagari\,\ Akita",
"812798", "Naganohara\,\ Gunma",
"812917", "Mito\,\ Ibaraki",
"812612", "Omachi\,\ Nagano",
"811352", "Yoichi\,\ Hokkaido",
"812672", "Komoro\,\ Nagano",
"811562", "Honbetsu\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"812858", "Mooka\,\ Tochigi",
"812484", "Shirakawa\,\ Fukushima",
"815986", "Matsusaka\,\ Mie",
"819723", "Saiki\,\ Oita",
"81969", "Amakusa\,\ Kumamoto",
"812547", "Murakami\,\ Niigata",
"8188099", "Tosashimizu\,\ Kochi",
"818290", "Hiroshima\,\ Hiroshima",
"812895", "Utsunomiya\,\ Tochigi",
"8112395", "Kuriyama\,\ Hokkaido",
"81569", "Handa\,\ Aichi",
"812582", "Nagaoka\,\ Niigata",
"811537", "Nakashibetsu\,\ Hokkaido",
"819578", "Shimabara\,\ Nagasaki",
"8126176", "Omachi\,\ Nagano",
"811952", "Ninohe\,\ Iwate",
"8182920", "Hatsukaichi\,\ Hiroshima",
"81176", "Towada\,\ Aomori",
"818952", "Uwajima\,\ Ehime",
"819948", "Shibushi\,\ Kagoshima",
"81823", "Kure\,\ Hiroshima",
"811464", "Shizunai\,\ Hokkaido",
"818657", "Kasaoka\,\ Okayama",
"817678", "Nanao\,\ Ishikawa",
"817618", "Kaga\,\ Ishikawa",
"812377", "Sagae\,\ Yamagata",
"818464", "Takehara\,\ Hiroshima",
"812243", "Shiroishi\,\ Miyagi",
"819734", "Hita\,\ Oita",
"815765", "Gero\,\ Gifu",
"811956", "Iwate\,\ Iwate",
"812857", "Mooka\,\ Tochigi",
"81774", "Uji\,\ Kyoto",
"818956", "Uwajima\,\ Ehime",
"818695", "Seto\,\ Okayama",
"812783", "Numata\,\ Gunma",
"815999", "Tsu\,\ Mie",
"81728", "Neyagawa\,\ Osaka",
"812586", "Nagaoka\,\ Niigata",
"812797", "Shibukawa\,\ Gunma",
"819687", "Tamana\,\ Kumamoto",
"8186691", "Kurashiki\,\ Okayama",
"817677", "Nanao\,\ Ishikawa",
"812560", "Itoigawa\,\ Niigata",
"811541", "Teshikaga\,\ Hokkaido",
"817617", "Kaga\,\ Ishikawa",
"8125488", "Tsugawa\,\ Niigata",
"812378", "Sagae\,\ Yamagata",
"81927", "Fukuoka\,\ Fukuoka",
"817485", "Yokaichi\,\ Shiga",
"817705", "Obama\,\ Fukui",
"814775", "Funabashi\,\ Chiba",
"8112396", "Kuriyama\,\ Hokkaido",
"811658", "Kamikawa\,\ Hokkaido",
"81572", "Tajimi\,\ Gifu",
"814291", "Hanno\,\ Saitama",
"8126175", "Omachi\,\ Nagano",
"817912", "Aioi\,\ Hyogo",
"819947", "Shibushi\,\ Kagoshima",
"815982", "Matsusaka\,\ Mie",
"81543", "Shizuoka\,\ Shizuoka",
"812616", "Omachi\,\ Nagano",
"811356", "Iwanai\,\ Hokkaido",
"81473", "Ichikawa\,\ Chiba",
"811233", "Chitose\,\ Hokkaido",
"819577", "Shimabara\,\ Nagasaki",
"812676", "Saku\,\ Nagano",
"818872", "Muroto\,\ Kochi",
"811394", "Matsumae\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"815734", "Ena\,\ Gifu",
"811945", "Kuji\,\ Iwate",
"817495", "Nagahama\,\ Shiga",
"819943", "Kanoya\,\ Kagoshima",
"819825", "Hyuga\,\ Miyazaki",
"812742", "Fujioka\,\ Gunma",
"818945", "Yawatahama\,\ Ehime",
"812964", "Shimodate\,\ Ibaraki",
"815992", "Toba\,\ Mie",
"81853", "Izumo\,\ Shimane",
"817673", "Hakui\,\ Ishikawa",
"814281", "Sagamihara\,\ Kanagawa",
"817613", "Komatsu\,\ Ishikawa",
"811524", "Abashiri\,\ Hokkaido",
"8153976", "Hamamatsu\,\ Shizuoka",
"811644", "Rumoi\,\ Hokkaido",
"818384", "Hagi\,\ Yamaguchi",
"81586", "Ichinomiya\,\ Aichi",
"811237", "Kuriyama\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"819573", "Isahaya\,\ Nagasaki",
"814240", "Kokubunji\,\ Tokyo",
"819728", "Usuki\,\ Oita",
"81986", "Miyakonojo\,\ Miyazaki",
"818879", "Muroto\,\ Kochi",
"812853", "Oyama\,\ Tochigi",
"811984", "Hanamaki\,\ Iwate",
"812247", "Ogawara\,\ Miyagi",
"818477", "Tojo\,\ Hiroshima",
"812554", "Joetsu\,\ Niigata",
"812935", "Mito\,\ Ibaraki",
"812793", "Shibukawa\,\ Gunma",
"819683", "Yamaga\,\ Kumamoto",
"815392", "Hamamatsu\,\ Shizuoka",
"8145", "Yokohama\,\ Kanagawa",
"819438", "Tanushimaru\,\ Fukuoka",
"811732", "Goshogawara\,\ Aomori",
"818685", "Tsuyama\,\ Okayama",
"818262", "Kake\,\ Hiroshima",
"81487", "Urawa\,\ Saitama",
"812787", "Numata\,\ Gunma",
"81262", "Nagano\,\ Nagano",
"81729", "Yao\,\ Osaka",
"81568", "Kasugai\,\ Aichi",
"81460", "Odawara\,\ Kanagawa",
"811533", "Nemuro\,\ Hokkaido",
"811238", "Kuriyama\,\ Hokkaido",
"819954", "Kajiki\,\ Kagoshima",
"81182", "Yokote\,\ Akita",
"81534", "Hamamatsu\,\ Shizuoka",
"811736", "Goshogawara\,\ Aomori",
"8182943", "Hiroshima\,\ Hiroshima",
"812373", "Murayama\,\ Yamagata",
"811653", "Shibetsu\,\ Hokkaido",
"818834", "Kamojima\,\ Tokushima",
"812619", "Omachi\,\ Nagano",
"812679", "Saku\,\ Nagano",
"8153975", "Hamamatsu\,\ Shizuoka",
"81792", "Himeji\,\ Hyogo",
"812788", "Maebashi\,\ Gunma",
"817457", "Yamatotakada\,\ Nara",
"818478", "Tojo\,\ Hiroshima",
"8153968", "Hamamatsu\,\ Shizuoka",
"811865", "Odate\,\ Akita",
"812913", "Hokota\,\ Ibaraki",
"81551", "Nirasaki\,\ Yamanashi",
"819437", "Tanushimaru\,\ Fukuoka",
"81557", "Ito\,\ Shizuoka",
"81594", "Kuwana\,\ Mie",
"815996", "Ago\,\ Mie",
"81934", "Kitakyushu\,\ Fukuoka",
"812248", "Ogawara\,\ Miyagi",
"81495", "Honjo\,\ Saitama",
"812543", "Shibata\,\ Niigata",
"817965", "Toyooka\,\ Hyogo",
"812589", "Nagaoka\,\ Niigata",
"819727", "Usuki\,\ Oita",
"812746", "Tomioka\,\ Gunma",
"81989", "Naha\,\ Okinawa",
"814705", "Tateyama\,\ Chiba",
"81742", "Nara\,\ Nara",
"817715", "Kameoka\,\ Kyoto",
"812658", "Ina\,\ Nagano",
"817724", "Miyazu\,\ Kyoto",
"811378", "Imakane\,\ Hokkaido",
"8183766", "Shimonoseki\,\ Yamaguchi",
"817902", "Fukusaki\,\ Hyogo",
"817357", "Kushimoto\,\ Wakayama",
"818378", "Shimonoseki\,\ Yamaguchi",
"812872", "Otawara\,\ Tochigi",
"81944", "Setaka\,\ Fukuoka",
"8198291", "Nobeoka\,\ Miyazaki",
"819962", "Satsumasendai\,\ Kagoshima",
"812911", "Hokota\,\ Ibaraki",
"815362", "Shinshiro\,\ Aichi",
"81975", "Oita\,\ Oita",
"8153969", "Hamamatsu\,\ Shizuoka",
"81726", "Ibaraki\,\ Osaka",
"818676", "Kuse\,\ Okayama",
"812566", "Sanjo\,\ Niigata",
"819667", "Minamata\,\ Kumamoto",
"819744", "Mie\,\ Oita",
"812233", "Iwanuma\,\ Miyagi",
"818292", "Hiroshima\,\ Hiroshima",
"8124196", "Yanaizu\,\ Fukushima",
"812580", "Tokamachi\,\ Niigata",
"815744", "Minokamo\,\ Gifu",
"811857", "Noshiro\,\ Akita",
"817465", "Yoshino\,\ Nara",
"814754", "Mobara\,\ Chiba",
"814298", "Hanno\,\ Saitama",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"818243", "Higashi\-ku\,\ Hiroshima",
"819552", "Imari\,\ Saga",
"812994", "Ishioka\,\ Ibaraki",
"81544", "Fujinomiya\,\ Shizuoka",
"8126172", "Omachi\,\ Nagano",
"811548", "Teshikaga\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"81474", "Funabashi\,\ Chiba",
"819937", "Kaseda\,\ Kagoshima",
"811586", "Nakayubetsu\,\ Hokkaido",
"811978", "Kitakami\,\ Iwate",
"818978", "Hakata\,\ Ehime",
"812473", "Ishikawa\,\ Fukushima",
"818586", "Kurayoshi\,\ Tottori",
"812413", "Kitakata\,\ Fukushima",
"818797", "Tonosho\,\ Kagawa",
"812695", "Nakano\,\ Nagano",
"819785", "Bungotakada\,\ Oita",
"817239", "Neyagawa\,\ Osaka",
"819668", "Minamata\,\ Kumamoto",
"811582", "Monbetsu\,\ Hokkaido",
"818895", "Susaki\,\ Kochi",
"818205", "Yanai\,\ Yamaguchi",
"818582", "Kurayoshi\,\ Tottori",
"819556", "Karatsu\,\ Saga",
"812657", "Ina\,\ Nagano",
"811377", "Yakumo\,\ Hokkaido",
"818377", "Shimonoseki\,\ Yamaguchi",
"814792", "Choshi\,\ Chiba",
"81276", "Ota\,\ Gunma",
"817733", "Fukuchiyama\,\ Kyoto",
"817995", "Sumoto\,\ Hyogo",
"81124", "Ashibetsu\,\ Hokkaido",
"818806", "Sukumo\,\ Kochi",
"812562", "Sanjo\,\ Niigata",
"8112392", "Yubari\,\ Hokkaido",
"818296", "Hiroshima\,\ Hiroshima",
"815753", "Sekigahara\,\ Gifu",
"819938", "Kaseda\,\ Kagoshima",
"812876", "Kuroiso\,\ Tochigi",
"811977", "Kitakami\,\ Iwate",
"819966", "Izumi\,\ Kagoshima",
"8125480", "Murakami\,\ Niigata",
"815366", "Shitara\,\ Aichi",
"818977", "Hakata\,\ Ehime",
"818798", "Tonosho\,\ Kagawa",
"81878", "Takamatsu\,\ Kagawa",
"818547", "Kakeya\,\ Shimane",
"811547", "Shiranuka\,\ Hokkaido",
"81178", "Hachinohe\,\ Aomori",
"814283", "Ome\,\ Tokyo",
"811858", "Noshiro\,\ Akita",
"814297", "Hanno\,\ Saitama",
"8199345", "Kagoshima\,\ Kagoshima",
"812996", "Itako\,\ Ibaraki",
"81294", "Hitachiota\,\ Ibaraki",
"814794", "Choshi\,\ Chiba",
"8126171", "Omachi\,\ Nagano",
"815746", "Minokamo\,\ Gifu",
"81833", "Kudamatsu\,\ Yamaguchi",
"819592", "Oseto\,\ Nagasaki",
"814756", "Togane\,\ Chiba",
"817949", "Kakogawa\,\ Hyogo",
"811757", "Noheji\,\ Aomori",
"817997", "Tsuna\,\ Hyogo",
"817718", "Sonobe\,\ Kyoto",
"811584", "Engaru\,\ Hokkaido",
"812655", "Iida\,\ Nagano",
"81166", "Asahikawa\,\ Hokkaido",
"81484", "Kawaguchi\,\ Saitama",
"811375", "Yakumo\,\ Hokkaido",
"818375", "Mine\,\ Yamaguchi",
"81585", "Ibigawa\,\ Gifu",
"815973", "Owase\,\ Mie",
"818584", "Kurayoshi\,\ Tottori",
"819679", "Takamori\,\ Kumamoto",
"81985", "Miyazaki\,\ Miyazaki",
"811975", "Mizusawa\,\ Iwate",
"818975", "Niihama\,\ Ehime",
"819788", "Kunisaki\,\ Oita",
"812698", "Iiyama\,\ Nagano",
"812839", "Sano\,\ Tochigi",
"818674", "Kuse\,\ Okayama",
"81893", "Ozu\,\ Ehime",
"819746", "Taketa\,\ Oita",
"81979", "Nakatsu\,\ Oita",
"817468", "Kamikitayama\,\ Nara",
"81268", "Ueda\,\ Nagano",
"812564", "Sanjo\,\ Niigata",
"8198292", "Nobeoka\,\ Miyazaki",
"818545", "Kisuki\,\ Shimane",
"814771", "Ichikawa\,\ Chiba",
"819543", "Takeo\,\ Saga",
"81234", "Sakata\,\ Yamagata",
"811545", "Kushiro\,\ Hokkaido",
"812874", "Otawara\,\ Tochigi",
"81188", "Akita\,\ Akita",
"8112391", "Yubari\,\ Hokkaido",
"819964", "Satsumasendai\,\ Kagoshima",
"811333", "Tobetsu\,\ Hokkaido",
"817355", "Shingu\,\ Fukuoka",
"81888", "Kochi\,\ Kochi",
"81436", "Ichihara\,\ Chiba",
"81554", "Otsuki\,\ Yamanashi",
"819742", "Mie\,\ Oita",
"817717", "Sonobe\,\ Kyoto",
"818294", "Hatsukaichi\,\ Hiroshima",
"817998", "Tsuna\,\ Hyogo",
"818663", "Soja\,\ Okayama",
"81798", "Nishinomiya\,\ Hyogo",
"81591", "Tsu\,\ Mie",
"811559", "Obihiro\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"818559", "Kawamoto\,\ Shimane",
"818369", "Ube\,\ Yamaguchi",
"812573", "Kashiwazaki\,\ Niigata",
"81937", "Kitakyushu\,\ Fukuoka",
"817722", "Miyazu\,\ Kyoto",
"817904", "Fukusaki\,\ Hyogo",
"81463", "Hiratsuka\,\ Kanagawa",
"81764", "Toyama\,\ Toyama",
"819809", "Yaeyama\ District\,\ Okinawa",
"81738", "Gobo\,\ Wakayama",
"81537", "Kakegawa\,\ Shizuoka",
"8125487", "Tsugawa\,\ Niigata",
"81531", "Tahara\,\ Aichi",
"81286", "Utsunomiya\,\ Tochigi",
"811855", "Noshiro\,\ Akita",
"819596", "Fukue\,\ Nagasaki",
"815742", "Minokamo\,\ Gifu",
"819787", "Kunisaki\,\ Oita",
"812697", "Iiyama\,\ Nagano",
"812649", "Nagano\,\ Nagano",
"814752", "Mobara\,\ Chiba",
"81962", "Kumamoto\,\ Kumamoto",
"819554", "Imari\,\ Saga",
"819935", "Kaseda\,\ Kagoshima",
"811933", "Kamaishi\,\ Iwate",
"8147955", "Yokaichiba\,\ Chiba",
"812992", "Ishioka\,\ Ibaraki",
"812389", "Yonezawa\,\ Yamagata",
"817955", "Sanda\,\ Hyogo",
"812893", "Utsunomiya\,\ Tochigi",
"818832", "Kamojima\,\ Tokushima",
"817367", "Iwade\,\ Wakayama",
"81547", "Shimada\,\ Shizuoka",
"81471", "Kashiwa\,\ Chiba",
"811986", "Tono\,\ Iwate",
"818360", "Ogori\,\ Yamaguchi",
"817498", "Nagahama\,\ Shiga",
"819828", "Takachiho\,\ Miyazaki",
"819952", "Okuchi\,\ Kagoshima",
"818948", "Uwajima\,\ Ehime",
"81923", "Fukuoka\,\ Fukuoka",
"812556", "Itoigawa\,\ Niigata",
"812489", "Sukagawa\,\ Fukushima",
"8125484", "Murakami\,\ Niigata",
"81725", "Izumi\,\ Osaka",
"817455", "Yamatotakada\,\ Nara",
"811867", "Takanosu\,\ Akita",
"812938", "Mito\,\ Ibaraki",
"8186995", "Seto\,\ Okayama",
"819435", "Yame\,\ Fukuoka",
"818688", "Mimasaka\,\ Okayama",
"812640", "Nagano\,\ Nagano",
"812571", "Muika\,\ Niigata",
"81947", "Tagawa\,\ Fukuoka",
"819725", "Saiki\,\ Oita",
"811526", "Abashiri\,\ Hokkaido",
"811646", "Haboro\,\ Hokkaido",
"811522", "Shari\,\ Hokkaido",
"817483", "Yokaichi\,\ Shiga",
"817703", "Tsuruga\,\ Fukui",
"81827", "Iwakuni\,\ Yamaguchi",
"817940", "Kakogawa\,\ Hyogo",
"818382", "Hagi\,\ Yamaguchi",
"8166", "Osaka\,\ Osaka",
"811947", "Kuji\,\ Iwate",
"817497", "Nagahama\,\ Shiga",
"819827", "Takachiho\,\ Miyazaki",
"818490", "Onomichi\,\ Hiroshima",
"818947", "Uwajima\,\ Ehime",
"817368", "Iwade\,\ Wakayama",
"811235", "Yubari\,\ Hokkaido",
"812744", "Fujioka\,\ Gunma",
"8144", "Kawasaki\,\ Kanagawa",
"819233", "Maebaru\,\ Fukuoka",
"81244", "Hobara\,\ Fukushima",
"812962", "Shimodate\,\ Ibaraki",
"815994", "Ago\,\ Mie",
"8186996", "Seto\,\ Okayama",
"812552", "Joetsu\,\ Niigata",
"815763", "Gero\,\ Gifu",
"815394", "Hamamatsu\,\ Shizuoka",
"811734", "Goshogawara\,\ Aomori",
"812245", "Ogawara\,\ Miyagi",
"81143", "Muroran\,\ Hokkaido",
"817968", "Hamasaka\,\ Hyogo",
"812830", "Utsunomiya\,\ Tochigi",
"815566", "Minobu\,\ Yamanashi",
"813", "Tokyo",
"819956", "Kajiki\,\ Kagoshima",
"8188097", "Tosashimizu\,\ Kochi",
"81439", "Kisarazu\,\ Chiba",
"812785", "Numata\,\ Gunma",
"818693", "Oku\,\ Okayama",
"811982", "Hanamaki\,\ Iwate",
"812937", "Mito\,\ Ibaraki",
"811868", "Takanosu\,\ Akita",
"818475", "Fuchu\,\ Hiroshima",
"818836", "Mima\,\ Tokushima",
"81172", "Hirosaki\,\ Aomori",
"818687", "Mimasaka\,\ Okayama",
"812855", "Oyama\,\ Tochigi",
"81464", "Atsugi\,\ Kanagawa",
"81886", "Tokushima\,\ Tokushima",
"81565", "Toyota\,\ Aichi",
"81438", "Kisarazu\,\ Chiba",
"815767", "Gero\,\ Gifu",
"811466", "Erimo\,\ Hokkaido",
"818683", "Tsuyama\,\ Okayama",
"8153964", "Hamamatsu\,\ Shizuoka",
"81553", "Yamanashi\,\ Yamanashi",
"819732", "Hita\,\ Oita",
"812933", "Takahagi\,\ Ibaraki",
"819685", "Tamana\,\ Kumamoto",
"812795", "Shibukawa\,\ Gunma",
"818466", "Mima\,\ Tokushima",
"818697", "Bizen\,\ Okayama",
"819823", "Nobeoka\,\ Miyazaki",
"818943", "Yawatahama\,\ Ehime",
"811943", "Iwaizumi\,\ Iwate",
"817493", "Hikone\,\ Shiga",
"819945", "Kanoya\,\ Kagoshima",
"818874", "Aki\,\ Kochi",
"817675", "Nanao\,\ Ishikawa",
"811392", "Kikonai\,\ Hokkaido",
"817615", "Komatsu\,\ Ishikawa",
"814998", "Ogasawara\,\ Tokyo",
"815732", "Ena\,\ Gifu",
"81288", "Imabari\,\ Ehime",
"817487", "Minakuchi\,\ Shiga",
"817707", "Obama\,\ Fukui",
"814777", "Funabashi\,\ Chiba",
"811874", "Kakunodate\,\ Akita",
"812898", "Kanuma\,\ Tochigi",
"81930", "Yukuhashi\,\ Fukuoka",
"8198296", "Hyuga\,\ Miyazaki",
"81965", "Yatsushiro\,\ Kumamoto",
"819575", "Isahaya\,\ Nagasaki",
"812486", "Sukagawa\,\ Fukushima",
"812559", "Yasuzuka\,\ Niigata",
"817914", "Aioi\,\ Hyogo",
"81763", "Fukuno\,\ Toyama",
"815984", "Matsusaka\,\ Mie",
"818698", "Bizen\,\ Okayama",
"812482", "Shirakawa\,\ Fukushima",
"811863", "Kazuno\,\ Akita",
"812545", "Murakami\,\ Niigata",
"81582", "Gifu\,\ Gifu",
"81134", "Otaru\,\ Hokkaido",
"811396", "Esashi\,\ Hokkaido",
"81834", "Tokuyama\,\ Yamaguchi",
"815736", "Nakatsugawa\,\ Gifu",
"815768", "Gero\,\ Gifu",
"811354", "Yoichi\,\ Hokkaido",
"812614", "Omachi\,\ Nagano",
"814701", "Kamogawa\,\ Chiba",
"812674", "Komoro\,\ Nagano",
"811564", "Kamishihoro\,\ Hokkaido",
"817963", "Toyooka\,\ Hyogo",
"818564", "Masuda\,\ Shimane",
"811954", "Ninohe\,\ Iwate",
"811535", "Akkeshi\,\ Hokkaido",
"81233", "Shinjo\,\ Yamagata",
"818954", "Uwajima\,\ Ehime",
"811462", "Urakawa\,\ Hokkaido",
"812897", "Kanuma\,\ Tochigi",
"818462", "Takehara\,\ Hiroshima",
"818655", "Kamogata\,\ Okayama",
"81857", "Tottori\,\ Tottori",
"8198295", "Hyuga\,\ Miyazaki",
"815959", "Kameyama\,\ Mie",
"812375", "Murayama\,\ Yamagata",
"817488", "Minakuchi\,\ Shiga",
"81157", "Kitami\,\ Hokkaido",
"81266", "Suwa\,\ Nagano",
"812584", "Nagaoka\,\ Niigata",
"811655", "Nayoro\,\ Hokkaido",
"81250", "Niitsu\,\ Niigata",
"817463", "Yoshino\,\ Nara",
"817686", "Noto\,\ Ishikawa",
"81243", "Nihonmatsu\,\ Fukushima",
"818552", "Hamada\,\ Shimane",
"818362", "Ube\,\ Yamaguchi",
"818245", "Miyoshi\,\ Hiroshima",
"81739", "Tanabe\,\ Wakayama",
"811362", "Kutchan\,\ Hokkaido",
"811552", "Obihiro\,\ Hokkaido",
"81272", "Maebashi\,\ Gunma",
"812475", "Ishikawa\,\ Fukushima",
"812415", "Yanaizu\,\ Fukushima",
"812836", "Sano\,\ Tochigi",
"819978", "Tokunoshima\,\ Kagoshima",
"811937", "Miyako\,\ Iwate",
"811632", "Teshio\,\ Hokkaido",
"819783", "Bungotakada\,\ Oita",
"812693", "Nakano\,\ Nagano",
"812999", "Itako\,\ Ibaraki",
"814703", "Tateyama\,\ Chiba",
"812382", "Yonezawa\,\ Yamagata",
"817713", "Kameoka\,\ Kyoto",
"815586", "Shimoda\,\ Shizuoka",
"815978", "Kumano\,\ Mie",
"81227", "Sendai\,\ Miyagi",
"811337", "Ishikari\,\ Hokkaido",
"8153971", "Hamamatsu\,\ Shizuoka",
"817946", "Miki\,\ Hyogo",
"81875", "Kan\'onji\,\ Kagawa",
"81144", "Tomakomai\,\ Hokkaido",
"812577", "Muika\,\ Niigata",
"812235", "Sendai\,\ Miyagi",
"819802", "Minamidaito\,\ Okinawa",
"819676", "Takamori\,\ Kumamoto",
"811454", "Mukawa\,\ Hokkaido",
"818667", "Ibara\,\ Okayama",
"815755", "Sekigahara\,\ Gifu",
"81924", "Fukuoka\,\ Fukuoka",
"817942", "Kakogawa\,\ Hyogo",
"819977", "Setouchi\,\ Kagoshima",
"811938", "Miyako\,\ Iwate",
"81940", "Munakata\,\ Fukuoka",
"812646", "Nagano\,\ Nagano",
"815582", "Shimoda\,\ Shizuoka",
"819547", "Kashima\,\ Saga",
"81722", "Sakai\,\ Osaka",
"8168", "Osaka\,\ Osaka",
"814285", "Sagamihara\,\ Kanagawa",
"819599", "Oseto\,\ Nagasaki",
"812386", "Nagai\,\ Yamagata",
"818842", "Anan\,\ Tokushima",
"8125483", "Murakami\,\ Niigata",
"8186992", "Bizen\,\ Okayama",
"812578", "Muika\,\ Niigata",
"8153967", "Hamamatsu\,\ Shizuoka",
"818668", "Ibara\,\ Okayama",
"812550", "Yasuzuka\,\ Niigata",
"818203", "Yanai\,\ Yamaguchi",
"818893", "Sakawa\,\ Kochi",
"812832", "Sano\,\ Tochigi",
"81578", "Kamioka\,\ Akita",
"818556", "Gotsu\,\ Shimane",
"818366", "Ube\,\ Yamaguchi",
"815977", "Kumano\,\ Mie",
"811366", "Suttsu\,\ Hokkaido",
"811556", "Obihiro\,\ Hokkaido",
"817735", "Fukuchiyama\,\ Kyoto",
"818594", "Yonago\,\ Tottori",
"817993", "Sumoto\,\ Hyogo",
"817682", "Wajima\,\ Ishikawa",
"811753", "Mutsu\,\ Aomori",
"81425", "Tachikawa\,\ Tokyo",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;