# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230113181715;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"436247", "Großgmain",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"437751", "Sankt\ Martin\ im\ Innkreis",
"433327", "Sankt\ Michael\ im\ Burgenland",
"436477", "Sankt\ Michael\ im\ Lungau",
"435557", "Sankt\ Gallenkirch",
"437218", "Großtraberg",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"432617", "Draßmarkt",
"434253", "Sankt\ Jakob\ im\ Rosental",
"4318", "Wien",
"4315", "Wien",
"434266", "Straßburg",
"437254", "Großraming",
"432686", "Draßburg",
"436227", "Sankt\ Gilgen",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"433386", "Großsteinbach",
"433632", "Sankt\ Gallen",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"434825", "Großkirchheim",
"432647", "Krumbach\,\ Niederösterreich",
"435678", "Weißenbach\ am\ Lech",
"434286", "Weißbriach",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"434783", "Reißeck",
"436277", "Sankt\ Pantaleon",
"437566", "Rosenau\ am\ Hengstpaß",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"435449", "Fließ",
"435352", "Sankt\ Johann\ in\ Tirol",
"435279", "Sankt\ Jodok\ am\ Brenner",
"433575", "Sankt\ Johann\ am\ Tauern",
"436215", "Straßwalchen",
"4312", "Wien",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"434264", "Klein\ Sankt\ Paul",
"433834", "Wald\ am\ Schoberpaß",
"432618", "Markt\ Sankt\ Martin",
"436412", "Sankt\ Johann\ im\ Pongau",
"432268", "Großmugl",
"433464", "Groß\ Sankt\ Florian",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432823", "Großglobnitz",
"437717", "Sankt\ Aegidi",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"437477", "Sankt\ Peter\ in\ der\ Au",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"4317", "Wien",
"4313", "Wien",
"4314", "Wien",
"432719", "Droß",
"432857", "Bad\ Großpertholz",
"433469", "Sankt\ Oswald\ im\ Freiland",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"434877", "Prägraten\ am\ Großvenediger",
"432642", "Aspangberg\-Sankt\ Peter",
"432249", "Groß\-Enzersdorf",
"432263", "Großrußbach",
"436565", "Neukirchen\ am\ Großvenediger",
"432812", "Groß\ Gerungs",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"437219", "Vorderweißenbach",
"433585", "Sankt\ Lambrecht",
"437954", "Sankt\ Georgen\ am\ Walde",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"436276", "Nußdorf\ am\ Haunsberg",
"437224", "Sankt\ Florian",
"433868", "Tragöß",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"432815", "Großschönau",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"432822", "Zwettl\-Niederösterreich",
"434879", "Sankt\ Veit\ in\ Defereggen",
"432756", "Sankt\ Leonhard\ am\ Forst",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"435245", "Hinterriß",
"433537", "Sankt\ Georgen\ ob\ Murau",
"436241", "Sankt\ Koloman",
"433684", "Sankt\ Martin\ am\ Grimming",
"4319", "Wien",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"434785", "Außerfragant",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"432742", "Sankt\ Pölten",
"434843", "Außervillgraten",
"434876", "Kals\ am\ Großglockner",
"433158", "Sankt\ Anna\ am\ Aigen",
"432955", "Großweikersdorf",
"4316", "Wien",
"432556", "Großkrut",
"437956", "Unterweißenbach",
"436414", "Großarl",
"433362", "Großpetersdorf",
"432847", "Groß\-Siegharts",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432233", "Preßbaum",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"437435", "Sankt\ Valentin",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"437565", "Sankt\ Pankraz",
"432242", "Sankt\ Andrä\-Wördern",
"433119", "Sankt\ Marein\ bei\ Graz",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434358", "Sankt\ Andrä",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"432674", "Weißenbach\ an\ der\ Triesting",
"432629", "Warth\,\ Niederösterreich",};
$areanames{en} = {"432620", "Willendorf",
"433516", "Kleinlobming",
"432637", "Grünbach\ am\ Schneeberg",
"432145", "Prellenkirchen",
"436244", "Golling\ an\ der\ Salzach",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"432914", "Japons",
"433155", "Fehring",
"432242", "St\.\ Andrä\-Wördern",
"432259", "Münchendorf",
"432641", "Kirchberg\ am\ Wechsel",
"434262", "Treibach",
"433633", "Landl",
"433324", "Strem",
"432736", "Paudorf",
"432682", "Eisenstadt",
"436137", "Strobl",
"437565", "St\.\ Pankraz",
"432233", "Pressbaum",
"437735", "Gaspoltshofen",
"432725", "Frankenfels",
"436474", "Tamsweg",
"437223", "Enns",
"434846", "Abfaltersbach",
"434873", "St\.\ Jakob\ in\ Defereggen",
"432772", "Neulengbach",
"437238", "Mauthausen",
"433144", "Köflach",
"436458", "Hüttau",
"433170", "Fischbach",
"432649", "Mönichkirchen",
"435578", "Höchst",
"433185", "Preding",
"435554", "Sonntag",
"432289", "Matzen",
"437435", "St\.\ Valentin",
"432769", "Türnitz",
"432853", "Schrems",
"434224", "Pischeldorf",
"433362", "Grosspetersdorf",
"432847", "Gross\-Siegharts",
"435635", "Elmen",
"433462", "Deutschlandsberg",
"437947", "Kefermarkt",
"437953", "Liebenau",
"432160", "Jois",
"435234", "Axams",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"434271", "Steuerberg",
"433576", "Bretstein",
"432958", "Maissau",
"434352", "Wolfsberg",
"433857", "Neuberg\ an\ der\ Mürz",
"433832", "Kraubath\ an\ der\ Mur",
"435518", "Mellau",
"434782", "Obervellach",
"437588", "Ried\ im\ Traunkreis",
"433532", "Murau",
"433587", "Schönberg\-Lachtal",
"432988", "Neupölla",
"432712", "Aggsbach",
"434279", "Sirnitz",
"436414", "Grossarl",
"432629", "Warth\,\ Lower\ Austria",
"432784", "Perschling",
"433680", "Donnersbachwald",
"433171", "Gasen",
"435263", "Silz",
"437276", "Peuerbach",
"437243", "Marchtrenk",
"432745", "Pyhra",
"437257", "Grünburg",
"434826", "Mörtschach",
"432688", "Steinbrunn",
"433622", "Bad\ Aussee",
"432248", "Markgrafneusiedl",
"433355", "Stadtschlaining",
"433124", "Gratkorn",
"433455", "Arnfels",
"437683", "Frankenburg\ am\ Hausruck",
"434714", "Dellach\ im\ Drautal",
"434268", "Friesach",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"432621", "Sieggraben",
"436452", "Radstadt",
"437746", "Friedburg",
"432275", "Atzenbrugg",
"433179", "Passail",
"432754", "Loosdorf",
"433385", "Ilz",
"432674", "Weissenbach\ an\ der\ Triesting",
"437473", "Blindenmarkt",
"436224", "Hintersee",
"435525", "Nenzing",
"432172", "Frauenkirchen",
"437287", "Peilstein\ im\ Mühlviertel",
"435572", "Dornbirn",
"433615", "Trieben",
"435447", "Flirsch",
"435353", "Waidring",
"435673", "Ehrwald",
"434255", "Arnoldstein",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"437767", "Eggerding",
"435286", "Ginzling",
"437216", "Helfenberg",
"432949", "Niederfladnitz",
"435331", "Brandenberg",
"432952", "Hollabrunn",
"434358", "St\.\ Andrä",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"436219", "Obertrum\ am\ See",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"437666", "Attersee",
"435512", "Egg",
"435256", "Untergurgl",
"432665", "Prein\ an\ der\ Rax",
"437582", "Kirchdorf\ an\ der\ Krems",
"437413", "Marbach\ an\ der\ Donau",
"434285", "Tröpolach",
"432614", "Kleinwarasdorf",
"433119", "St\.\ Marein\ bei\ Graz",
"437713", "Schardenberg",
"432215", "Probstdorf",
"435339", "Wildschönau",
"432527", "Wulzeshofen",
"434244", "Bad\ Bleiberg",
"432264", "Rückersdorf\,\ Harmannsdorf",
"432827", "Schönbach",
"432982", "Horn",
"432718", "Lichtenau\ im\ Waldviertel",
"435676", "Jungholz",
"432764", "Hainfeld",
"435477", "Tösens",
"435356", "Kitzbühel",
"436462", "Bischofshofen",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"437213", "Bad\ Leonfelden",
"435283", "Kaltenbach",
"434229", "Krumpendorf\ am\ Wörther\ See",
"434785", "Ausserfragant",
"433535", "Krakaudorf",
"435239", "Kühtai",
"436543", "Taxenbach",
"437663", "Steinbach\ am\ Attersee",
"434355", "Gemmersdorf",
"435253", "Längenfeld",
"432610", "Horitschon",
"434221", "Gallizien",
"437617", "Traunkirchen",
"437416", "Wieselburg",
"433465", "Pölfing\-Brunn",
"437716", "Münzkirchen",
"434258", "Gummern",
"435632", "Stanzach",
"433618", "Hohentauern",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437267", "Mönchdorf",
"434274", "Velden\ am\ Wörther\ See",
"432534", "Niedersulz",
"434240", "Bad\ Kleinkirchheim",
"437432", "Strengberg",
"436471", "Tweng",
"433182", "Wildon",
"433141", "Hirschegg",
"435266", "Ötztal\-Bahnhof",
"433684", "St\.\ Martin\ am\ Grimming",
"432254", "Ebreichsdorf",
"434823", "Tresdorf\,\ Rangersdorf",
"433329", "Jennersdorf",
"437273", "Aschach\ an\ der\ Donau",
"4319", "Vienna",
"437246", "Gunskirchen",
"435417", "Roppen",
"433137", "Söding",
"434710", "Oberdrauburg",
"437732", "Haag\ am\ Hausruck",
"437487", "Gresten",
"432278", "Absdorf",
"432722", "Kirchberg\ an\ der\ Pielach",
"432685", "Rust",
"434768", "Kleblach\-Lind",
"434214", "Brückl",
"437562", "Windischgarsten",
"436241", "St\.\ Koloman",
"433474", "Deutsch\ Goritz",
"436479", "Muhr",
"432748", "Kilb",
"433149", "Geistthal",
"434265", "Weitensfeld\ im\ Gurktal",
"437757", "Gurten",
"432245", "Wolkersdorf\ im\ Weinviertel",
"433152", "Feldbach",
"437743", "Maria\ Schmolln",
"433358", "Litzelsdorf",
"437476", "Aschbach\-Markt",
"437357", "Kleinreifling",
"437443", "Ybbsitz",
"432644", "Grimmenstein",
"432284", "Oberweiden",
"432142", "Gattendorf",
"435559", "Brand",
"436468", "Werfen",
"432985", "Gars\ am\ Kamp",
"432556", "Grosskrut",
"432212", "Orth\ an\ der\ Donau",
"432877", "Grainbrunn",
"432577", "Asparn\ an\ der\ Zaya",
"434237", "Miklauzhof",
"434220", "Köttmannsdorf",
"432856", "Weitra",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"437956", "Unterweissenbach",
"432164", "Rohrau",
"435230", "Sellrain",
"434282", "Hermagor",
"432944", "Haugsdorf",
"433573", "Fohnsdorf",
"432662", "Gloggnitz",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"435515", "Au",
"433846", "Kalwang",
"436214", "Henndorf\ am\ Wallersee",
"432955", "Grossweikersdorf",
"432619", "Lackendorf",
"43512", "Innsbruck",
"435334", "Westendorf",
"4316", "Vienna",
"433114", "Markt\ Hartmannsdorf",
"432269", "Niederfellabrunn",
"434252", "Wernberg",
"433612", "Liezen",
"435575", "Langen\ bei\ Bregenz",
"436240", "Krispl",
"436274", "Lamprechtshausen",
"432175", "Apetlon",
"432624", "Ebenfurth",
"433513", "Bischoffeld",
"435522", "Feldkirch",
"433382", "Fürstenfeld",
"433337", "Vorau",
"433636", "Wildalpen",
"436221", "Koppl",
"432272", "Tulln\ an\ der\ Donau",
"432728", "Wienerbruck",
"436455", "Untertauern",
"437723", "Altheim",
"437235", "Gallneukirchen",
"432733", "Schönberg\ am\ Kamp",
"434843", "Ausservillgraten",
"433452", "Leibnitz",
"434876", "Kals\ am\ Grossglockner",
"432236", "Mödling",
"433158", "St\.\ Anna\ am\ Aigen",
"432863", "Eggern",
"436470", "Atzmannsdorf",
"437226", "Wilhering",
"433352", "Oberwart",
"434762", "Spittal\ an\ der\ Drau",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"433174", "Birkfeld",
"432742", "St\.\ Pölten",
"436229", "Hof\ bei\ Salzburg",
"433867", "Pernegg\ an\ der\ Mur",
"435550", "Thüringen",
"435225", "Fulpmes",
"435517", "Riezlern",
"437587", "Wartberg\ an\ der\ Krems",
"435272", "Steinach\ am\ Brenner",
"432522", "Laa\ an\ der\ Thaya",
"433588", "Katsch\ an\ der\ Mur",
"436416", "Lend",
"432822", "Zwettl\,\ Lower\ Austria",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"434235", "Bleiburg",
"432575", "Ladendorf",
"432875", "Grafenschlag",
"435333", "Söll",
"437719", "Taufkirchen\ an\ der\ Pram",
"434226", "St\.\ Margareten\ im\ Rosental",
"435359", "Hochfilzen",
"435442", "Landeck",
"437762", "Raab",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"436213", "Oberhofen\ am\ Irrsee",
"437948", "Hirschbach\ im\ Mühlkreis",
"433574", "Pusterwald",
"432943", "Obritz",
"437711", "Suben",
"433858", "Mitterdorf\ im\ Mürztal",
"432163", "Petronell\-Carnuntum",
"435236", "Gries\ im\ Sellrain",
"432957", "Hohenwarth",
"432815", "Grossschönau",
"433146", "Modriach",
"433173", "Ratten",
"433335", "Pöllau",
"432230", "Schwadorf",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432864", "Kautzen",
"436476", "St\.\ Margarethen\ im\ Lungau",
"436457", "Flachau",
"435212", "Seefeld\ in\ Tirol",
"435556", "Schruns",
"432177", "Podersdorf\ am\ See",
"437282", "Neufelden",
"435577", "Lustenau",
"436562", "Mittersill",
"437479", "Ardagger",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432638", "Winzendorf\-Muthmannsdorf",
"433865", "Kindberg",
"432916", "Riegersburg\,\ Hardegg",
"432623", "Pottendorf",
"433514", "Seckau",
"436246", "Grödig",
"434855", "Assling",
"437724", "Mauerkirchen",
"432734", "Langenlois",
"43662", "Salzburg",
"437471", "Neustadtl\ an\ der\ Donau",
"436432", "Bad\ Hofgastein",
"437249", "Bad\ Schallerbach",
"437252", "Steyr",
"433326", "Stegersbach",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"435278", "Navis",
"433537", "St\.\ Georgen\ ob\ Murau",
"432616", "Lockenhaus",
"435254", "Sölden",
"434273", "Reifnitz",
"432533", "Neusiedl\ an\ der\ Zaya",
"435475", "Feichten",
"434246", "Radenthein",
"432266", "Stockerau",
"435375", "Kössen",
"434732", "Gmünd\ in\ Kärnten",
"433582", "Scheifling",
"433882", "Mariazell",
"432717", "Unter\-Meisling",
"432828", "Rappottenstein",
"435284", "Gerlos",
"432859", "Brand\-Nagelberg",
"435448", "Pettneu\ am\ Arlberg",
"437214", "Reichenthal",
"433467", "Schwanberg",
"432842", "Waidhofen\ an\ der\ Thaya",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"437265", "Pabneukirchen",
"433849", "Vordernberg",
"436544", "Rauris",
"434357", "St\.\ Paul\ im\ Lavanttal",
"433852", "Mürzzuschlag",
"435245", "Hinterriss",
"437664", "Weyregg\ am\ Attersee",
"437942", "Freistadt",
"437615", "Scharnstein",
"437744", "Munderfing",
"432756", "St\.\ Leonhard\ am\ Forst",
"433473", "Straden",
"432239", "Breitenfurt\ bei\ Wien",
"437485", "Gaming",
"437229", "Traun",
"434213", "Launsdorf",
"433135", "Kalsdorf\ bei\ Graz",
"434879", "St\.\ Veit\ in\ Defereggen",
"432283", "Angern\ an\ der\ March",
"432643", "Lichtenegg",
"433631", "Unterlaussa",
"436226", "Fuschl\ am\ See",
"437288", "Ulrichsberg",
"437444", "Opponitz",
"437675", "Ampflwang\ im\ Hausruckwald",
"433683", "Donnersbach",
"436235", "Thalgau",
"437355", "Weyer",
"432632", "Pernitz",
"432231", "Purkersdorf",
"432786", "Oberwölbling",
"437221", "Hörsching",
"433126", "Frohnleiten",
"437258", "Bad\ Hall",
"432687", "Siegendorf",
"436132", "Bad\ Ischl",
"434716", "Lesachtal",
"437274", "Alkoven",
"437240", "Sipbachzell",
"432247", "Deutsch\-Wagram",
"437755", "Mettmach",
"434824", "Heiligenblut",
"432253", "Oberwaltersdorf",
"434267", "Metnitz",
"432753", "Gansbach",
"434767", "Rothenthurn",
"437255", "Losenstein",
"432747", "Ober\-Grafendorf",
"437758", "Obernberg\ am\ Inn",
"433457", "Gleinstätten",
"434852", "Lienz",
"433476", "Bad\ Radkersburg",
"433357", "Pinkafeld",
"432286", "Obersiebenbrunn",
"432731", "Idolsberg",
"436223", "Anthering",
"437474", "Euratsfeld",
"433862", "Bruck\ an\ der\ Mur",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432673", "Altenmarkt\ an\ der\ Triesting",
"436565", "Neukirchen\ am\ Grossvenediger",
"433387", "Söchau",
"433686", "Haus",
"435264", "Mieming",
"432783", "Traismauer",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"437684", "Frankenmarkt",
"434713", "Techendorf",
"437729", "Neukirchen\ an\ der\ Enknach",
"432739", "Tiefenfucha",
"435418", "Schönwies",
"432256", "Leobersdorf",
"433332", "Hartberg",
"432277", "Zwentendorf",
"432812", "Gross\ Gerungs",
"437488", "Steinakirchen\ am\ Forst",
"437244", "Sattledt",
"432613", "Deutschkreutz",
"435248", "Steinberg\ am\ Rofan",
"437414", "Weins\-Isperdorf",
"437618", "Neukirchen\,\ Altmünster",
"437765", "Lambrechten",
"432263", "Grossrussbach",
"434257", "Fürnitz",
"434276", "Feldkirchen\ in\ Kärnten",
"432536", "Drösing",
"436588", "Lofer",
"433571", "Möderbrugg",
"435445", "Kappl",
"433617", "Gaishorn\ am\ See",
"434243", "Bodensdorf",
"437268", "Grein",
"437714", "Esternberg",
"432872", "Ottenschlag",
"43316", "Graz",
"435280", "Hochfügen",
"432572", "Mistelbach",
"434232", "Völkermarkt",
"435674", "Bichlbach",
"432766", "Kleinzell",
"432825", "Göpfritz\ an\ der\ Wild",
"432525", "Gnadendorf",
"435354", "Fieberbrunn",
"435275", "Trins",
"433579", "Pöls",
"432667", "Schwarzau\ im\ Gebirge",
"433143", "Krottendorf",
"437752", "Ried\ im\ Innkreis",
"433176", "Stubenberg",
"434858", "Nikolsdorf",
"433157", "Kapfenstein",
"434874", "Virgen",
"436135", "Bad\ Goisern",
"432234", "Gramatneusiedl",
"437224", "St\.\ Florian",
"436473", "Mariapfarr",
"433868", "Tragöss",
"432147", "Zurndorf",
"432635", "Neunkirchen",
"435553", "Raggal",
"436232", "Mondsee",
"437672", "Vöcklabruck",
"432913", "Hötzelsdorf",
"436243", "Abtenau",
"436276", "Nussdorf\ am\ Haunsberg",
"432626", "Mattersburg",
"435412", "Imst",
"433132", "Kumberg",
"433338", "Lafnitz",
"437482", "Scheibbs",
"433634", "Hieflau",
"433323", "Eberau",
"437279", "Haibach\ ob\ der\ Donau",
"435583", "Lech",
"437612", "Gmunden",
"437211", "Reichenau\ im\ Mühlkreis",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"433855", "Krieglach",
"435242", "Schwaz",
"437262", "Perg",
"436413", "Wagrain",
"436541", "Saalbach",
"435336", "Alpbach",
"432845", "Weikertschlag\ an\ der\ Thaya",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"433116", "Kirchbach\ in\ Steiermark",
"437219", "Vorderweissenbach",
"433885", "Greith",
"432554", "Stützenhofen",
"436467", "Mühlbach\ am\ Hochkönig",
"434735", "Kremsbrücke",
"434223", "Maria\ Saal",
"435289", "Häusling",
"433585", "St\.\ Lambrecht",
"432854", "Kirchberg\ am\ Walde",
"435372", "Kufstein",
"432878", "Traunstein",
"435472", "Prutz",
"434238", "Eisenkappel\-Vellach",
"436549", "Piesendorf",
"433844", "Kammern\ im\ Liesingtal",
"436216", "Neumarkt\ am\ Wallersee",
"4346", "Klagenfurt",
"432166", "Parndorf",
"437954", "St\.\ Georgen\ am\ Walde",
"432946", "Pulkau",
"433688", "Tauplitz",
"432622", "Wiener\ Neustadt",
"437231", "Herzogsdorf",
"436272", "Oberndorf\ bei\ Salzburg",
"43732", "Linz",
"435524", "Satteins",
"436225", "Eugendorf",
"432274", "Sieghartskirchen",
"436433", "Dorfgastein",
"437247", "Kematen\ am\ Innbach",
"432755", "Mank",
"437253", "Wolfern",
"437486", "Lunz\ am\ See",
"432258", "Alland",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433136", "Dobl",
"433354", "Bernstein",
"437239", "Lichtenberg",
"434715", "Kötschach\-Mauthen",
"433454", "Leutschach",
"433125", "Übelbach",
"432744", "Kasten\ bei\ Böheimkirchen",
"433172", "Weiz",
"437676", "Ottnang\ am\ Hausruck",
"436563", "Uttendorf",
"437477", "St\.\ Peter\ in\ der\ Au",
"432288", "Auersthal",
"432648", "Hochneukirchen",
"435213", "Scharnitz",
"437283", "Sarleinsbach",
"435579", "Alberschwende",
"435443", "Galtür",
"434245", "Feistritz\ an\ der\ Drau",
"435357", "Kirchberg\ in\ Tirol",
"435476", "Serfaus",
"435677", "Vils",
"437763", "Kopfing\ im\ Innkreis",
"432265", "Hausleiten",
"435376", "Thiersee",
"433460", "Soboth",
"432214", "Kopfstetten",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"432942", "Retz",
"432615", "Lutzmannsburg",
"434284", "Kirchbach",
"432162", "Bruck\ an\ der\ Leitha",
"432959", "Sitzendorf\ an\ der\ Schmida",
"436212", "Seekirchen\ am\ Wallersee",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432664", "Semmering",
"435519", "Schröcken",
"435246", "Achenkirch",
"435273", "Matrei\ am\ Brenner",
"437616", "Grünau\ im\ Almtal",
"433112", "Gleisdorf",
"432951", "Guntersdorf",
"432538", "Velm\-Götzendorf",
"434278", "Gnesau",
"435332", "Wörgl",
"437717", "St\.\ Aegidi",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"433614", "Rottenmann",
"432823", "Grossglobnitz",
"434254", "Faak\ am\ See",
"437266", "Bad\ Kreuzen",
"432989", "Brunn\ an\ der\ Wild",
"432633", "Markt\ Piesting",
"433184", "Wolfsberg\ im\ Schwarzautal",
"437434", "Haag",
"433682", "Stainach",
"432628", "Felixdorf",
"436278", "Ostermiething",
"432816", "Karlstift",
"432249", "Gross\-Enzersdorf",
"434269", "Flattnitz",
"433336", "Waldbach",
"433637", "Gams\ bei\ Hieflau",
"432252", "Baden",
"433145", "Edelschrott",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"436475", "Ramingstein",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"436133", "Ebensee",
"432689", "Hornstein",
"437230", "Altenberg\ bei\ Linz",
"432237", "Gaaden",
"437227", "Neuhofen\ an\ der\ Krems",
"433472", "Mureck",
"437564", "Hinterstoder",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"434877", "Prägraten\ am\ Grossvenediger",
"434212", "St\.\ Veit\ an\ der\ Glan",
"435585", "Dalaas",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"432642", "Aspangberg\-St\.\ Peter",
"432915", "Drosendorf\-Zissersdorf",
"433866", "Breitenau\ am\ Hochlantsch",
"432144", "Deutsch\ Jahrndorf",
"432282", "Gänserndorf",
"436245", "Hallein",
"432762", "Lilienfeld",
"436415", "Schwarzach\ im\ Pongau",
"434236", "Eberndorf",
"432576", "Ernstbrunn",
"432857", "Bad\ Grosspertholz",
"432557", "Bernhardsthal",
"433469", "St\.\ Oswald\ im\ Freiland",
"432843", "Dobersberg",
"432876", "Els",
"437943", "Windhaag\ bei\ Freistadt",
"432711", "Dürnstein",
"435226", "Neustift\ im\ Stubaital",
"433847", "Trofaiach",
"432948", "Weitersfeld",
"434359", "Reichenfels",
"432168", "Mannersdorf\ am\ Leithagebirge",
"433853", "Spital\ am\ Semmering",
"435510", "Damüls",
"433461", "Trahütten",
"4317", "Vienna",
"434225", "Grafenstein",
"433583", "Unzmarkt",
"434733", "Malta",
"4313", "Vienna",
"435634", "Elbigenalp",
"433883", "Terz",
"432719", "Dross",
"4314", "Vienna",
"433118", "Sinabelkirchen",
"432532", "Zistersdorf",
"434272", "Pörtschach\ am\ Wörther\ See",
"435338", "Kundl",
"434228", "Feistritz\ im\ Rosental",
"435335", "Hopfgarten\ im\ Brixental",
"432846", "Raabs\ an\ der\ Thaya",
"432873", "Kottes",
"433115", "Studenzen",
"434233", "Griffen",
"432573", "Wilfersdorf",
"435223", "Hall\ in\ Tirol",
"432954", "Göllersdorf",
"437946", "Gutau",
"4312", "Vienna",
"433577", "Zeltweg",
"435238", "Zirl",
"433856", "Veitsch",
"433611", "Johnsbach",
"437584", "Molln",
"436215", "Strasswalchen",
"435514", "Bezau",
"432165", "Hainburg\ a\.d\.\ Donau",
"432612", "Oberpullendorf",
"432945", "Zellerndorf",
"436418", "Kleinarl",
"433886", "Weichselboden",
"433586", "Mühlen",
"434736", "Innerkrems",
"432262", "Korneuburg",
"432984", "Eggenburg",
"434242", "Villach",
"433619", "Oppenberg",
"432782", "Herzogenburg",
"432636", "Puchberg\ am\ Schneeberg",
"432741", "Flinsbach",
"436484", "Lessach",
"434761", "Stockenboi",
"433175", "Anger",
"433333", "Sebersdorf",
"433624", "Pichl\-Kainisch",
"432279", "Kirchberg\ am\ Wagram",
"432813", "Arbesbach",
"436136", "Gosau",
"434712", "Greifenburg",
"433328", "Kukmirn",
"437727", "Ach",
"434847", "Obertilliach",
"433148", "Kainach\ bei\ Voitsberg",
"436454", "Mandling",
"433359", "Loipersdorf\-Kitzladen",
"437234", "Ottensheim",
"434853", "Ainet",
"432752", "Melk",
"434769", "Möllbrücke",
"432749", "Prinzersdorf",
"436478", "Zederhaus",
"433150", "Paldau",
"432271", "Ried\ am\ Riederberg",
"433863", "Turnau",
"435558", "Gaschurn",
"432672", "Berndorf",
"435574", "Bregenz",
"432625", "Bad\ Sauerbrunn",
"432174", "Wallern\ im\ Burgenland",
"437766", "Andorf",
"435373", "Ebbs",
"435446", "St\.\ Anton\ am\ Arlberg",
"432535", "Hohenau\ an\ der\ March",
"434275", "Ebene\ Reichenau",
"435473", "Nauders",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"433464", "Gross\ St\.\ Florian",
"433364", "Hannersdorf",
"435287", "Tux",
"435232", "Kematen\ in\ Tirol",
"434354", "Preitenegg",
"436547", "Kaprun",
"437667", "St\.\ Georgen\ im\ Attergau",
"432618", "Markt\ St\.\ Martin",
"435243", "Maurach",
"435276", "Gschnitz",
"433534", "Stadl\ an\ der\ Mur",
"437613", "Laakirchen",
"434784", "Mallnitz",
"433834", "Wald\ am\ Schoberpass",
"436461", "Dienten\ am\ Hochkönig",
"432268", "Grossmugl",
"432714", "Rossatz",
"434248", "Treffen",
"436583", "Leogang",
"436412", "St\.\ Johann\ im\ Pongau",
"432826", "Rastenfeld",
"432765", "Kaumberg",
"437263", "Bad\ Zell",
"432526", "Stronsdorf",
"436242", "Russbach\ am\ Pass\ Gschütt",
"432285", "Marchegg",
"432912", "Geras",
"433151", "Gnas",
"432645", "Wiesmath",
"434718", "Dellach",
"437256", "Ternberg",
"434264", "Klein\ St\.\ Paul",
"433322", "Güssing",
"437277", "Waizenkirchen",
"435582", "Klösterle",
"432244", "Langenzersdorf",
"434215", "Liebenfels",
"433133", "Nestelbach",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"432684", "Schützen\ am\ Gebirge",
"437483", "Oberndorf\ an\ der\ Melk",
"433475", "Hürth",
"432758", "Pöggstall",
"436472", "Mauterndorf",
"437753", "Eberschwang",
"433142", "Voitsberg",
"432255", "Deutsch\ Brodersdorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"432774", "Innermanzing",
"433159", "Bad\ Gleichenberg",
"437353", "Gaflenz",
"436233", "Oberwang",
"433685", "Gröbming",
"437673", "Schwanenstadt",
"436566", "Bramberg\ am\ Wildkogel",
"437286", "Lembach\ im\ Mühlkreis",
"436228", "Faistenau",
"435552", "Bludenz",
"432841", "Vitis",
"433833", "Traboch",
"433533", "Turrach",
"437614", "Vorchdorf",
"434783", "Reisseck",
"435244", "Jenbach",
"437665", "Unterach\ am\ Attersee",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"434277", "Glanegg",
"433616", "Selzthal",
"434256", "Nötsch\ im\ Gailtal",
"437264", "Windhaag\ bei\ Perg",
"437718", "Waldkirchen\ am\ Wesen",
"435285", "Mayrhofen",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"437941", "Neumarkt\ im\ Mühlkreis",
"432713", "Spitz",
"437215", "Hellmonsödt",
"435358", "Ellmau",
"433363", "Rechnitz",
"432852", "Gmünd",
"432849", "Schwarzenau",
"433463", "Stainz",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"435678", "Weissenbach\ am\ Lech",
"432552", "Poysdorf",
"435474", "Pfunds",
"435374", "Walchsee",
"432767", "Hohenberg",
"435255", "Umhausen",
"433842", "Leoben",
"434353", "Prebl",
"432666", "Reichenau",
"433859", "Mürzsteg",
"437949", "Rainbach\ im\ Mühlkreis",
"434286", "Weissbriach",
"433581", "Oberwölz",
"437952", "Weitersfelden",
"432746", "Wilhelmsburg",
"432773", "Eichgraben",
"434766", "Millstatt",
"437754", "Waldzell",
"434825", "Grosskirchheim",
"433356", "Markt\ Allhau",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432232", "Fischamend",
"434872", "Huben",
"433456", "Fresing",
"432631", "Pöttsching",
"436131", "Obertraun",
"432287", "Strasshof\ an\ der\ Nordbahn",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"437478", "Oed\-Oehling",
"432647", "Krumbach\,\ Lower\ Austria",
"437674", "Attnang\-Puchheim",
"436234", "Zell\ am\ Moos",
"433386", "Grosssteinbach",
"433687", "Schladming",
"435526", "Laterns",
"437445", "Hollenstein\ an\ der\ Ybbs",
"432639", "Bad\ Fischau",
"437248", "Grieskirchen",
"437484", "Göstling\ an\ der\ Ybbs",
"435414", "Wenns",
"433134", "Heiligenkreuz\ am\ Waasen",
"432683", "Purbach\ am\ Neusiedler\ See",
"432276", "Reidling",
"432243", "Klosterneuburg",
"437745", "Lochen",
"434263", "Hüttenberg",
"432257", "Klausen\-Leopoldsdorf",
"433632", "St\.\ Gallen",
"437250", "Maria\ Neustift",
"437412", "Ybbs\ an\ der\ Donau",
"435513", "Hittisau",
"435441", "See",
"437583", "Kremsmünster",
"433575", "St\.\ Johann\ am\ Tauern",
"435279", "St\.\ Jodok\ am\ Brenner",
"432829", "Schweiggers",
"432983", "Sigmundsherberg",
"433117", "Eggersdorf\ bei\ Graz",
"437712", "Schärding",
"435337", "Brixlegg",
"432574", "Gaweinstal",
"434234", "Ruden",
"436466", "Werfenweng",
"432874", "Martinsberg",
"435352", "St\.\ Johann\ in\ Tirol",
"432858", "Moorbad\ Harbach",
"435449", "Fliess",
"435672", "Reutte",
"436217", "Mattsee",
"432947", "Theras",
"433848", "Eisenerz",
"435224", "Wattens",
"432953", "Nappersdorf",
"432167", "Neusiedl\ am\ See",
"437228", "Kematen\ an\ der\ Krems",
"432238", "Kaltenleutgeben",
"433177", "Puch\ bei\ Weiz",
"437233", "Feldkirchen\ an\ der\ Donau",
"432735", "Hadersdorf\ am\ Kamp",
"437566", "Rosenau\ am\ Hengstpass",
"436453", "Filzmoos",
"432146", "Nickelsdorf",
"432173", "Gols",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"437289", "Rohrbach\ in\ Oberösterreich",
"435573", "Hörbranz",
"437251", "Schiedlberg",
"433864", "St\.\ Marein\ im\ Mürztal",
"437472", "Amstetten",
"435262", "Telfs",
"436483", "Göriach",
"432627", "Pitten",
"432630", "Ternitz",
"436277", "St\.\ Pantaleon",
"432865", "Litschau",
"432726", "Puchenstuben",
"437281", "Aigen\ im\ Mühlkreis",
"437736", "Pram",
"433638", "Palfau",
"437682", "Vöcklamarkt",
"437242", "Wels",
"432814", "Langschlag",
"437259", "Sierning",
"433334", "Kaindorf",
"433623", "Bad\ Mitterndorf",
"433147", "Salla",
"433635", "Radmer",
"434848", "Kartitsch",
"437759", "Antiesenhofen",
"433153", "Riegersburg",
"437742", "Mattighofen",
"437563", "Spital\ am\ Pyhrn",
"436456", "Obertauern",
"437236", "Pregarten",
"436477", "St\.\ Michael\ im\ Lungau",
"435576", "Hohenems",
"432143", "Kittsee",
"432176", "Tadten",
"435557", "St\.\ Gallenkirch",
"437442", "Waidhofen\ an\ der\ Ybbs",
"437751", "St\.\ Martin\ im\ Innkreis",
"436247", "Grossgmain",
"437433", "Wallsee",
"432634", "Gutenstein",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"434875", "Matrei\ in\ Osttirol",
"436134", "Hallstatt",
"432723", "Rabenstein\ an\ der\ Pielach",
"437225", "Hargelsberg",
"437489", "Purgstall\ an\ der\ Erlauf",
"432235", "Maria\-Lanzendorf",
"437733", "Neumarkt\ im\ Hausruckkreis",
"434822", "Winklern",
"433327", "St\.\ Michael\ im\ Burgenland",
"432738", "Fels\ am\ Wagram",
"437272", "Eferding",
"437728", "Schwand\ im\ Innkreis",
"437955", "Königswiesen",
"437619", "Kirchham",
"437586", "Pettenbach",
"435252", "Oetz",
"435516", "Doren",
"433845", "Mautern\ in\ Steiermark",
"437269", "Baumgartenberg",
"432986", "Irnfritz",
"436417", "Hüttschlag",
"435633", "Hägerau",
"432555", "Herrnbaumgarten",
"433884", "Wegscheid",
"432855", "Waldenstein",
"433584", "Neumarkt\ in\ Steiermark",
"434734", "Rennweg",
"436589", "Unken",
"432844", "Karlstein\ an\ der\ Thaya",
"437212", "Zwettl\ an\ der\ Rodl",
"436463", "Annaberg\-Lungötz",
"434230", "Globasnitz",
"435282", "Zell\ am\ Ziller",
"434227", "Ferlach",
"437662", "Seewalchen\ am\ Attersee",
"436542", "Zell\ am\ See",
"433854", "Langenwang",
"437261", "Schönau\ im\ Mühlkreis",
"433578", "Obdach",
"432956", "Ziersdorf",
"437944", "Sandl",
"437750", "Andrichsfurt",
"432757", "Pöchlarn",
"437245", "Lambach",
"432743", "Böheimkirchen",
"433453", "Ehrenhausen",
"434842", "Sillian",
"433353", "Oberschützen",
"432862", "Heidenreichstein",
"437748", "Eggelsberg",
"437284", "Oberkappel",
"437448", "Kematen\ an\ der\ Ybbs",
"435214", "Leutasch",
"436227", "St\.\ Gilgen",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"435265", "Nassereith",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"436564", "Krimml",
"435523", "Götzis",
"4318", "Vienna",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433383", "Burgau",
"4315", "Vienna",
"433512", "Knittelfeld",
"433127", "Peggau",
"434717", "Steinfeld",
"432686", "Drassburg",
"437480", "Langau\,\ Gaming",
"432732", "Krems\ an\ der\ Donau",
"437278", "Neukirchen\ am\ Walde",
"437722", "Braunau\ am\ Inn",
"437254", "Grossraming",
"434266", "Strassburg",
"433339", "Friedberg",
"432273", "Tulbing",
"433861", "Aflenz",
"432246", "Gerasdorf\ bei\ Wien",
"436434", "Bad\ Gastein",
"433536", "St\.\ Peter\ am\ Kammersberg",
"434231", "Mittertrixen",
"432617", "Drassmarkt",
"435274", "Gries\ am\ Brenner",
"432267", "Sierndorf",
"434253", "St\.\ Jakob\ im\ Rosental",
"432824", "Allentsteig",
"437260", "Waldhausen",
"435675", "Tannheim",
"435355", "Jochberg",
"434247", "Afritz",
"432524", "Kautendorf",
"433613", "Admont",
"432716", "Gföhl",
"433466", "Eibiswald",
"432213", "Lassee",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"433366", "Kohfidisch",
"437218", "Grosstraberg",
"437764", "Riedau",
"435288", "Fügen",
"435444", "Ischgl",
"434356", "Lavamünd",
"432663", "Schottwien",
"433572", "Judenburg",
"434283", "St\.\ Stefan\ im\ Gailtal",
"436548", "Niedernsill",
"437415", "Altenmarkt\,\ Yspertal",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;