# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220305001839;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '96',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              10|
              2[0-57-9]
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1[1-9]|
            26|
            [3-9]|
            (?:
              10|
              2[0-57-9]
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '16[08]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            85[23](?:
              100|
              95
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            26|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              [046]|
              1[01459]|
              2[0-489]|
              5(?:
                0|
                [23](?:
                  [02-8]|
                  1[1-9]|
                  9[0-46-9]
                )
              )|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]
            )|
            (?:
              1|
              58|
              85[23]10
            )[1-9]|
            (?:
              10|
              2[0-57-9]
            )(?:
              [0-8]|
              9[0-47-9]
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              4|
              80
            )0
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            10[0-79]|
            2(?:
              [02-57-9]|
              1[1-79]
            )|
            (?:
              10|
              21
            )8(?:
              0[1-9]|
              [1-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            3(?:
              [3-59]|
              7[02-68]
            )|
            4(?:
              [26-8]|
              3[3-9]|
              5[2-9]
            )|
            5(?:
              3[03-9]|
              [468]|
              7[028]|
              9[2-46-9]
            )|
            6|
            7(?:
              [0-247]|
              3[04-9]|
              5[0-4689]|
              6[2368]
            )|
            8(?:
              [1-358]|
              9[1-7]
            )|
            9(?:
              [013479]|
              5[1-5]
            )|
            (?:
              [34]1|
              55|
              79|
              87
            )[02-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '80',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[3-578]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '1[3-9]',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'geographic' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'mobile' => '
          1740[0-5]\\d{6}|
          1(?:
            [38]\\d|
            4[57]|
            5[0-35-9]|
            6[25-7]|
            7[0-35-8]|
            9[0135-9]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          400\\d{7}|
          950\\d{7,8}|
          (?:
            10|
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[47-9]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[36-8]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'toll_free' => '
          (?:
            (?:
              10|
              21
            )8|
            8
          )00\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{zh} = {"861362878", "云南省楚雄彝族自治州",
"861365679", "浙江省台州市",
"861300351", "江苏省徐州市",
"86138243", "广东省深圳市",
"861571838", "广东省广州市",
"861897549", "湖南省邵阳市",
"861458324", "江西省九江市",
"861879197", "陕西省宝鸡市",
"861345906", "福建省莆田市",
"861454347", "山东省烟台市",
"861829526", "宁夏石嘴山市",
"861705367", "浙江省杭州市",
"861596032", "福建省龙岩市",
"861330253", "广东省珠海市",
"861521542", "山东省青岛市",
"861774018", "四川省成都市",
"861875892", "浙江省金华市",
"861824987", "黑龙江省伊春市",
"86158474", "内蒙古乌兰察布市",
"861334653", "广东省韶关市",
"861882479", "广东省湛江市",
"86186563", "安徽省宣城市",
"86158268", "湖北省孝感市",
"861597673", "广东省河源市",
"861328283", "浙江省杭州市",
"861557771", "广西来宾市",
"861776798", "吉林省松原市",
"861880681", "浙江省杭州市",
"861865008", "福建省福州市",
"861538995", "新疆吐鲁番地区",
"861516805", "浙江省舟山市",
"86189458", "黑龙江省鸡西市",
"86135423", "广东省茂名市",
"861586531", "山东省济南市",
"86181328", "安徽省阜阳市",
"861814990", "新疆乌鲁木齐市",
"861857530", "广东省梅州市",
"861829783", "安徽省马鞍山市",
"861397280", "湖北省黄石市",
"861332097", "四川省凉山彝族自治州",
"861336147", "山东省聊城市",
"861375466", "山东省滨州市",
"861459090", "广东省韶关市",
"861325661", "山东省聊城市",
"861536751", "湖南省永州市",
"861835784", "浙江省温州市",
"861705553", "安徽省合肥市",
"861550543", "山东省滨州市",
"861350008", "广东省汕尾市",
"861515449", "山东省潍坊市",
"861346954", "宁夏固原市",
"861804066", "湖北省十堰市",
"861569939", "新疆伊犁哈萨克自治州",
"861534817", "四川省成都市",
"861780294", "陕西省商洛市",
"861894443", "江苏省南通市",
"861570927", "陕西省宝鸡市",
"861818931", "甘肃省兰州市",
"861820948", "甘肃省天水市",
"861315840", "四川省甘孜藏族自治州",
"861700946", "江苏省苏州市",
"861322299", "江苏省苏州市",
"861850638", "山东省烟台市",
"861325011", "广东省佛山市",
"861332713", "内蒙古阿拉善盟",
"861393426", "山西省大同市",
"861530858", "贵州省六盘水市",
"861858344", "四川省资阳市",
"861894837", "广东省揭阳市",
"86151302", "河北省保定市",
"861889970", "广东省汕尾市",
"86152180", "广东省梅州市",
"861377792", "浙江省金华市",
"861840930", "甘肃省临夏回族自治州",
"861528888", "山东省东营市",
"861843415", "山西省吕梁市",
"861394588", "黑龙江省伊春市",
"861705274", "北京市",
"861313288", "广西贵港市",
"861358109", "山东省临沂市",
"861819010", "四川省巴中市",
"861882307", "广东省江门市",
"861347129", "广西桂林市",
"86136500", "广东省东莞市",
"861330574", "浙江省宁波市",
"861562430", "山东省日照市",
"861315277", "山西省临汾市",
"86150379", "河南省洛阳市",
"861365422", "辽宁省鞍山市",
"861364740", "湖南省岳阳市",
"861348372", "河北省衡水市",
"861390547", "山东省济宁市",
"861852737", "湖北省黄冈市",
"861708801", "四川省成都市",
"861770891", "西藏拉萨市",
"861510733", "湖南省株洲市",
"861571879", "云南省昆明市",
"861365638", "山东省聊城市",
"86183621", "江苏省南通市",
"861553531", "山西省阳泉市",
"861337884", "云南省昆明市",
"861877143", "湖北省随州市",
"861362680", "浙江省宁波市",
"861816626", "湖南省常德市",
"861373935", "甘肃省金昌市",
"861570819", "四川省内江市",
"861560871", "云南省昆明市",
"861313647", "浙江省台州市",
"861880825", "四川省遂宁市",
"861556588", "河南省漯河市",
"861882438", "广东省茂名市",
"861379305", "山东省聊城市",
"861890705", "江西省宜春市",
"861317075", "云南省大理白族自治州",
"86139374", "河南省许昌市",
"861598979", "广东省珠海市",
"861370410", "辽宁省铁岭市",
"861817740", "广西梧州市",
"861826296", "江苏省常州市",
"86155156", "河南省郑州市",
"86189519", "江苏省南京市",
"861365957", "西藏日喀则地区",
"861336938", "甘肃省天水市",
"861880576", "浙江省台州市",
"861894229", "江西省鹰潭市",
"86152445", "山东省烟台市",
"861515403", "山东省威海市",
"861845266", "江苏省扬州市",
"861305900", "黑龙江省哈尔滨市",
"861319711", "湖北省荆门市",
"861813529", "山西省大同市",
"861896373", "安徽省池州市",
"861333981", "湖北省襄樊市",
"861859098", "陕西省铜川市",
"861530359", "山西省运城市",
"861317041", "湖南省长沙市",
"861890629", "江苏省南通市",
"86170899", "广东省珠海市",
"86177090", "四川省绵阳市",
"861828077", "四川省绵阳市",
"861327178", "河南省南阳市",
"861361905", "四川省南充市",
"86133823", "江苏省南通市",
"861771969", "陕西省安康市",
"861846459", "山东省威海市",
"861453739", "湖南省常德市",
"861537362", "河北省张家口市",
"861531432", "山东省东营市",
"861364728", "湖北省武汉市",
"861505658", "安徽省合肥市",
"861570318", "河北省衡水市",
"861502859", "河北省秦皇岛市",
"861519067", "江苏省徐州市",
"861772986", "四川省南充市",
"861807098", "广西玉林市",
"861803634", "江苏省盐城市",
"861587801", "广西玉林市",
"86183973", "湖南省常德市",
"861813564", "河南省洛阳市",
"861850957", "宁夏银川市",
"861512953", "陕西省咸阳市",
"86135491", "广东省梅州市",
"861363203", "广东省潮州市",
"861894264", "河北省石家庄市",
"861521991", "广东省茂名市",
"86181582", "浙江省宁波市",
"861818211", "湖南省长沙市",
"861890664", "浙江省温州市",
"861340559", "江苏省镇江市",
"861511351", "广东省汕尾市",
"861362338", "河北省衡水市",
"861347562", "山东省淄博市",
"861571378", "河南省开封市",
"861581297", "广东省韶关市",
"861339779", "广西北海市",
"861357959", "新疆博尔塔拉蒙古自治州",
"86158538", "山东省泰安市",
"861780321", "河北省石家庄市",
"861821249", "贵州省铜仁地区",
"86159704", "江西省南昌市",
"861873893", "河南省平顶山市",
"861323265", "广东省湛江市",
"861311597", "福建省宁德市",
"861315828", "贵州省六盘水市",
"861454473", "陕西省渭南市",
"861348832", "陕西省西安市",
"86935", "甘肃省武威市",
"861339738", "湖南省娄底市",
"861519617", "四川省凉山彝族自治州",
"861571339", "河北省邢台市",
"8613980", "四川省成都市",
"861372311", "河南省信阳市",
"861362379", "河南省洛阳市",
"861577469", "黑龙江省双鸭山市",
"861301733", "湖南省株洲市",
"861570452", "黑龙江省齐齐哈尔市",
"86177852", "贵州省遵义市",
"861507015", "江西省赣州市",
"861519187", "陕西省宝鸡市",
"861316911", "广东省湛江市",
"861396572", "安徽省阜阳市",
"861533590", "湖北省随州市",
"86130709", "广东省东莞市",
"861800936", "甘肃省张掖市",
"861399795", "湖北省武汉市",
"861870395", "河南省漯河市",
"861359292", "广东省揭阳市",
"861358143", "湖北省襄樊市",
"861318356", "四川省广元市",
"861304921", "广东省云浮市",
"861322361", "山西省朔州市",
"86186472", "内蒙古包头市",
"86135909", "广东省中山市",
"861815083", "福建省福州市",
"861328996", "新疆巴音郭楞蒙古自治州",
"861336979", "青海省海西蒙古族藏族自治州",
"861838602", "贵州省铜仁地区",
"86133549", "云南省昆明市",
"861535415", "河北省唐山市",
"861841433", "内蒙古乌兰察布市",
"861889413", "甘肃省平凉市",
"861302534", "广东省汕头市",
"861327810", "吉林省长春市",
"861476518", "河北省石家庄市",
"861470553", "安徽省芜湖市",
"861559015", "吉林省白城市",
"86139135", "江苏省苏州市",
"86151875", "云南省保山市",
"861335135", "黑龙江省绥化市",
"861709540", "江苏省徐州市",
"861894377", "吉林省辽源市",
"861529190", "陕西省西安市",
"861321963", "四川省自贡市",
"861890472", "内蒙古包头市",
"861573092", "甘肃省陇南市",
"861309959", "宁夏银川市",
"861700768", "广东省茂名市",
"861554572", "黑龙江省鸡西市",
"861820766", "广东省云浮市",
"861591756", "广东省湛江市",
"861450630", "黑龙江省佳木斯市",
"86157329", "河北省邢台市",
"86183693", "山东省临沂市",
"861338365", "河北省秦皇岛市",
"861830916", "陕西省汉中市",
"861372233", "河北省张家口市",
"861874826", "内蒙古包头市",
"86152280", "四川省达州市",
"86132670", "广东省深圳市",
"861373437", "山东省临沂市",
"861539567", "安徽省亳州市",
"861820801", "西藏拉萨市",
"861535328", "陕西省延安市",
"861309718", "江西省景德镇市",
"861707912", "浙江省宁波市",
"86136792", "陕西省西安市",
"86156895", "山东省德州市",
"861373308", "安徽省宿州市",
"861524005", "安徽省安庆市",
"86145902", "广东省深圳市",
"861478710", "云南省昆明市",
"861526306", "山东省泰安市",
"861335382", "河南省开封市",
"861307048", "新疆哈密地区",
"861393484", "山西省朔州市",
"861330773", "广西桂林市",
"861808147", "四川省雅安市",
"861459402", "云南省红河哈尼族彝族自治州",
"861476031", "福建省三明市",
"861768883", "广东省深圳市",
"86181492", "陕西省西安市",
"861535237", "甘肃省武威市",
"861573687", "河南省开封市",
"861510534", "山东省德州市",
"861768741", "广西南宁市",
"861559503", "宁夏吴忠市",
"861786980", "云南省昆明市",
"861538856", "山西省晋城市",
"861335448", "山东省枣庄市",
"861337826", "四川省泸州市",
"86180691", "浙江省宁波市",
"861523167", "河北省沧州市",
"861572879", "广东省深圳市",
"861829908", "新疆石河子市",
"861532640", "吉林省长春市",
"861567844", "广西玉林市",
"861364857", "贵州省毕节地区",
"861536271", "广东省中山市",
"86150519", "江苏省常州市",
"861816114", "四川省广安市",
"861520886", "云南省怒江傈僳族自治州",
"86187673", "浙江省嘉兴市",
"861881438", "广东省梅州市",
"861587137", "湖北省武汉市",
"861347421", "陕西省宝鸡市",
"861808218", "江苏省盐城市",
"861589646", "江苏省无锡市",
"861319285", "广东省韶关市",
"861332514", "山东省烟台市",
"861500629", "江苏省南通市",
"861896945", "浙江省衢州市",
"861881622", "江苏省淮安市",
"861347201", "河北省邯郸市",
"861767127", "湖北省宜昌市",
"861361680", "浙江省舟山市",
"861539353", "甘肃省武威市",
"861337541", "山东省济南市",
"86176802", "湖南省长沙市",
"861522542", "河南省洛阳市",
"861880419", "辽宁省辽阳市",
"861501412", "广东省深圳市",
"861308012", "河南省濮阳市",
"86185771", "广西南宁市",
"861705754", "海南省海口市",
"861550744", "湖南省张家界市",
"861533289", "内蒙古巴彦淖尔市",
"86138143", "江苏省盐城市",
"861572838", "广东省阳江市",
"861361878", "云南省楚雄彝族自治州",
"861864862", "内蒙古包头市",
"86138736", "湖南省常德市",
"861334394", "河南省周口市",
"861895148", "江苏省盐城市",
"86130821", "河北省邯郸市",
"861804089", "新疆伊犁哈萨克自治州",
"861305821", "广东省韶关市",
"86158017", "上海市",
"86132990", "陕西省西安市",
"861859242", "陕西省安康市",
"861458386", "福建省龙岩市",
"861808657", "湖北省黄冈市",
"861551406", "河南省鹤壁市",
"861366853", "贵州省安顺市",
"861360818", "四川省成都市",
"861310859", "云南省普洱市",
"861858193", "四川省自贡市",
"86184552", "安徽省蚌埠市",
"861305546", "福建省泉州市",
"861587766", "陕西省延安市",
"86183544", "山东省临沂市",
"861306918", "吉林省吉林市",
"861523087", "河北省承德市",
"861881479", "黑龙江省大庆市",
"86132333", "山西省长治市",
"861500472", "内蒙古包头市",
"861300953", "内蒙古乌兰察布市",
"861835726", "浙江省湖州市",
"861538497", "新疆阿克苏地区",
"861331097", "陕西省西安市",
"86187993", "新疆和田地区",
"861380234", "广东省湛江市",
"86187330", "河北省沧州市",
"861561554", "山东省泰安市",
"861311705", "湖北省荆门市",
"861856921", "湖南省张家界市",
"861370345", "河南省南阳市",
"861899745", "青海省果洛藏族自治州",
"861457011", "山东省临沂市",
"861897015", "江西省鹰潭市",
"861589156", "陕西省延安市",
"86139565", "安徽省安庆市",
"861598305", "四川省遂宁市",
"861308474", "内蒙古乌兰察布市",
"861321299", "黑龙江省佳木斯市",
"861566617", "山东省济宁市",
"861863361", "河北省廊坊市",
"861833184", "河北省衡水市",
"861817496", "广西百色市",
"861811547", "江苏省南京市",
"861331851", "广东省茂名市",
"861399507", "宁夏银川市",
"861577161", "陕西省榆林市",
"861312597", "黑龙江省鸡西市",
"861859673", "福建省泉州市",
"861310358", "山西省吕梁市",
"861370371", "河南省郑州市",
"861360319", "河北省邢台市",
"861899771", "新疆伊犁哈萨克自治州",
"86186746", "湖南省永州市",
"861569805", "山东省淄博市",
"861785851", "浙江省绍兴市",
"861453617", "江苏省扬州市",
"86170703", "广东省广州市",
"861815890", "安徽省阜阳市",
"861820789", "广西北海市",
"861379218", "山东省淄博市",
"861560933", "甘肃省平凉市",
"86156710", "湖北省宜昌市",
"861872776", "湖北省咸宁市",
"861459775", "新疆昌吉回族自治州",
"86138857", "贵州省毕节地区",
"861832047", "广东省梅州市",
"861780923", "陕西省渭南市",
"861361379", "河南省洛阳市",
"861559549", "宁夏中卫市",
"8613862", "江苏省苏州市",
"861823878", "河南省新乡市",
"861302733", "湖南省株洲市",
"861587948", "江西省景德镇市",
"861339259", "广东省中山市",
"861301534", "山西省太原市",
"861874992", "河南省濮阳市",
"861886095", "江苏省南京市",
"861843237", "河北省沧州市",
"861507549", "河北省承德市",
"861708920", "广东省茂名市",
"861327431", "吉林省长春市",
"861527111", "湖北省襄樊市",
"861379147", "山东省菏泽市",
"861807673", "广西柳州市",
"861477722", "广西柳州市",
"861329057", "河北省邯郸市",
"861325538", "山东省泰安市",
"861866660", "广东省惠州市",
"861572054", "安徽省淮南市",
"861527681", "新疆克孜勒苏柯尔克孜自治州",
"861808938", "甘肃省兰州市",
"861895120", "江苏省常州市",
"861333735", "湖南省郴州市",
"861334401", "重庆市",
"861868731", "云南省昆明市",
"861332682", "广东省江门市",
"86134332", "广东省佛山市",
"861803346", "广东省东莞市",
"861850561", "安徽省淮北市",
"861306327", "安徽省安庆市",
"861330885", "云南省昆明市",
"861813697", "江苏省苏州市",
"861839510", "宁夏银川市",
"861318134", "山东省济宁市",
"86155256", "山西省忻州市",
"861454105", "安徽省马鞍山市",
"861310074", "湖北省黄冈市",
"86152912", "陕西省榆林市",
"86189379", "河南省洛阳市",
"8613532", "广东省东莞市",
"86182553", "安徽省芜湖市",
"861317790", "江西省新余市",
"861829062", "新疆乌鲁木齐市",
"861550392", "河南省鹤壁市",
"861816512", "陕西省榆林市",
"861561642", "湖南省常德市",
"861337575", "浙江省绍兴市",
"861879474", "甘肃省定西市",
"861335420", "辽宁省沈阳市",
"86137871", "湖南省长沙市",
"861532432", "河北省唐山市",
"861850455", "黑龙江省绥化市",
"861306602", "山东省济南市",
"861518414", "辽宁省铁岭市",
"861325579", "浙江省金华市",
"86182926", "陕西省汉中市",
"861818873", "广东省佛山市",
"861890597", "福建省龙岩市",
"861345540", "山东省德州市",
"8615790", "天津市",
"861813763", "河南省驻马店市",
"861334742", "陕西省西安市",
"861892358", "广东省汕尾市",
"861869626", "湖北省鄂州市",
"861532628", "辽宁省盘锦市",
"861362905", "四川省南充市",
"861591276", "云南省玉溪市",
"861510132", "甘肃省兰州市",
"861508050", "福建省南平市",
"861504837", "内蒙古赤峰市",
"861518072", "贵州省贵阳市",
"861334006", "江西省吉安市",
"861311472", "广西柳州市",
"861814468", "广东省珠海市",
"861380914", "陕西省咸阳市",
"861778590", "贵州省黔南布依族苗族自治州",
"861361227", "广东省江门市",
"861365561", "安徽省淮南市",
"861880852", "贵州省遵义市",
"861501859", "广东省湛江市",
"861361407", "辽宁省营口市",
"861529863", "江苏省连云港市",
"861823680", "河南省许昌市",
"861760557", "安徽省宿州市",
"861572378", "广西河池市",
"861361338", "河北省秦皇岛市",
"861379657", "黑龙江省绥化市",
"8618889", "海南省海口市",
"861530727", "湖北省襄樊市",
"861302385", "福建省莆田市",
"861772924", "陕西省安康市",
"861327036", "江苏省徐州市",
"86137550", "湖南省长沙市",
"861522991", "陕西省咸阳市",
"861356555", "新疆石河子市",
"86176375", "河南省平顶山市",
"861535864", "江苏省南通市",
"861314317", "广东省佛山市",
"861535340", "陕西省商洛市",
"861576951", "宁夏银川市",
"861310412", "辽宁省鞍山市",
"86137785", "四川省自贡市",
"86139663", "安徽省合肥市",
"861848580", "贵州省毕节地区",
"861453821", "四川省雅安市",
"861327715", "湖北省咸宁市",
"861340793", "江西省上饶市",
"861580346", "山西省太原市",
"86152779", "广西玉林市",
"861847019", "江西省赣州市",
"861812522", "广东省中山市",
"861319120", "山西省忻州市",
"861533131", "云南省昆明市",
"861890323", "河北省张家口市",
"861864956", "山西省晋城市",
"861379723", "湖北省咸宁市",
"861841996", "甘肃省天水市",
"861596543", "山东省滨州市",
"861850833", "四川省乐山市",
"861351684", "浙江省金华市",
"861570942", "甘肃省金昌市",
"86159192", "广东省珠海市",
"861568498", "湖南省邵阳市",
"861361098", "辽宁省鞍山市",
"861808671", "江苏省苏州市",
"861398902", "西藏日喀则地区",
"86177412", "辽宁省鞍山市",
"861452732", "湖南省湘潭市",
"86138228", "广东省汕头市",
"861327396", "河南省驻马店市",
"86159648", "山东省临沂市",
"861775299", "河北省石家庄市",
"861551434", "河南省周口市",
"861528683", "河南省郑州市",
"861886841", "浙江省杭州市",
"861317956", "江苏省宿迁市",
"861329045", "河北省唐山市",
"861557840", "广西梧州市",
"861454607", "青海省海西蒙古族藏族自治州",
"86147098", "四川省成都市",
"861330817", "四川省成都市",
"861886783", "浙江省丽水市",
"86155463", "黑龙江省哈尔滨市",
"861313479", "内蒙古锡林郭勒盟",
"861825121", "江苏省常州市",
"86183485", "黑龙江省哈尔滨市",
"861338509", "福建省三明市",
"861378944", "内蒙古乌兰察布市",
"861597680", "广东省湛江市",
"861509840", "山东省聊城市",
"861379586", "四川省雅安市",
"861380426", "辽宁省大连市",
"861554008", "内蒙古呼伦贝尔市",
"861454322", "内蒙古包头市",
"861819804", "甘肃省陇南市",
"861865174", "江苏省盐城市",
"861821832", "广东省云浮市",
"861558172", "山西省忻州市",
"86135448", "广东省东莞市",
"861450427", "辽宁省盘锦市",
"861800493", "辽宁省抚顺市",
"861871548", "安徽省滁州市",
"86155023", "重庆市",
"861763508", "山西省晋城市",
"861571196", "广东省深圳市",
"861576659", "广东省惠州市",
"861599499", "广东省潮州市",
"861597839", "河南省信阳市",
"861772416", "广东省肇庆市",
"861590904", "新疆喀什地区",
"861767709", "广西北海市",
"861590588", "浙江省丽水市",
"86137154", "广东省佛山市",
"861856705", "河南省焦作市",
"861316481", "福建省福州市",
"861313622", "浙江省嘉兴市",
"861760545", "山东省烟台市",
"861853841", "河南省郑州市",
"861776867", "江苏省镇江市",
"861330964", "安徽省淮南市",
"861313438", "吉林省松原市",
"861530143", "江苏省泰州市",
"861362673", "浙江省嘉兴市",
"861571633", "河南省安阳市",
"861826970", "安徽省安庆市",
"861876244", "江苏省苏州市",
"861598569", "贵州省六盘水市",
"861847624", "广东省广州市",
"861312323", "福建省宁德市",
"861356547", "新疆伊犁哈萨克自治州",
"861365447", "吉林省长春市",
"861313307", "山西省临汾市",
"861516631", "山东省威海市",
"861470799", "江西省萍乡市",
"861539475", "内蒙古通辽市",
"861334858", "福建省南平市",
"861376923", "云南省大理白族自治州",
"861363372", "河南省安阳市",
"861390522", "江苏省徐州市",
"86152494", "内蒙古呼伦贝尔市",
"86151258", "云南省楚雄彝族自治州",
"861331240", "贵州省安顺市",
"861709934", "浙江省嘉兴市",
"861538962", "陕西省渭南市",
"861339294", "广东省中山市",
"861878882", "安徽省六安市",
"86184405", "新疆乌鲁木齐市",
"861304597", "福建省厦门市",
"861536257", "广东省汕头市",
"861810581", "浙江省杭州市",
"861340017", "河北省沧州市",
"86159577", "浙江省温州市",
"861453685", "陕西省渭南市",
"861364871", "云南省昆明市",
"861594547", "黑龙江省牡丹江市",
"861893681", "江苏省泰州市",
"861787501", "广东省湛江市",
"861471528", "广东省惠州市",
"861560740", "湖南省岳阳市",
"861535985", "福建省泉州市",
"861889983", "广东省韶关市",
"86189600", "福建省漳州市",
"861380021", "上海市",
"861513247", "河北省石家庄市",
"861847669", "广东省深圳市",
"861896638", "浙江省宁波市",
"861569568", "安徽省六安市",
"861817871", "广西桂林市",
"861572099", "江西省抚州市",
"861576149", "贵州省六盘水市",
"861850447", "吉林省吉林市",
"861534574", "浙江省宁波市",
"861328847", "广东省广州市",
"861527989", "江西省宜春市",
"861318106", "山东省聊城市",
"861809944", "新疆阿克苏地区",
"861331337", "河北省沧州市",
"861889296", "新疆乌鲁木齐市",
"861560728", "湖北省十堰市",
"861878449", "四川省内江市",
"861471540", "广东省茂名市",
"861813974", "甘肃省武威市",
"86181914", "陕西省西安市",
"861334359", "湖北省十堰市",
"861366435", "吉林省通化市",
"861302928", "辽宁省葫芦岛市",
"86180317", "河北省沧州市",
"861575931", "福建省宁德市",
"861780738", "湖南省娄底市",
"861303810", "四川省自贡市",
"86185885", "广东省广州市",
"861820312", "河北省保定市",
"861896957", "浙江省丽水市",
"861502982", "陕西省榆林市",
"861832290", "江西省宜春市",
"861880720", "湖北省宜昌市",
"861365373", "河南省新乡市",
"861362242", "广东省汕尾市",
"861303139", "新疆克拉玛依市",
"861360782", "广西柳州市",
"861331408", "辽宁省丹东市",
"861339321", "河北省石家庄市",
"861338543", "山东省滨州市",
"861566685", "山东省聊城市",
"861309403", "新疆伊犁哈萨克自治州",
"861865995", "福建省南平市",
"861458797", "湖南省长沙市",
"861399762", "湖北省荆州市",
"861858765", "广西南宁市",
"861860535", "山东省烟台市",
"861392676", "广东省汕头市",
"861357403", "湖南省岳阳市",
"861880966", "宁夏吴忠市",
"861700897", "广东省惠州市",
"86158839", "四川省广元市",
"86155197", "贵州省毕节地区",
"861329476", "内蒙古赤峰市",
"861760571", "浙江省杭州市",
"861776234", "湖北省武汉市",
"861808723", "云南省昆明市",
"861561599", "山东省临沂市",
"861896380", "新疆乌鲁木齐市",
"861350995", "广东省佛山市",
"861539441", "福建省福州市",
"861568784", "云南省楚雄彝族自治州",
"861771579", "四川省巴中市",
"861369619", "四川省德阳市",
"861857944", "广西桂林市",
"861323292", "广东省江门市",
"861850373", "河南省新乡市",
"86187259", "重庆市",
"861458663", "湖南省邵阳市",
"86182655", "山东省聊城市",
"861518892", "河北省邯郸市",
"861840544", "山东省德州市",
"861811461", "江苏省苏州市",
"86187431", "吉林省长春市",
"861899757", "新疆伊犁哈萨克自治州",
"861477850", "广东省河源市",
"861370357", "山西省临汾市",
"861512409", "辽宁省朝阳市",
"861336569", "安徽省合肥市",
"8614588", "广东省广州市",
"861523665", "河南省洛阳市",
"861516700", "浙江省绍兴市",
"861368390", "河南省南阳市",
"861478429", "河南省周口市",
"86181965", "安徽省芜湖市",
"861830424", "辽宁省葫芦岛市",
"86155572", "浙江省湖州市",
"861319217", "广东省汕头市",
"861806744", "浙江省宁波市",
"861450952", "江苏省连云港市",
"861364331", "河北省石家庄市",
"86170947", "内蒙古呼和浩特市",
"861554962", "湖北省孝感市",
"861771538", "江苏省苏州市",
"861531823", "山东省临沂市",
"861336524", "江苏省泰州市",
"861780779", "广西北海市",
"86183140", "云南省红河哈尼族彝族自治州",
"861350572", "浙江省湖州市",
"861370980", "辽宁省鞍山市",
"861526874", "浙江省湖州市",
"86189861", "湖北省武汉市",
"861830469", "黑龙江省双鸭山市",
"861566546", "安徽省安庆市",
"861557828", "广西南宁市",
"861478464", "黑龙江省七台河市",
"861820458", "黑龙江省伊春市",
"861539046", "四川省乐山市",
"861854794", "内蒙古鄂尔多斯市",
"861301506", "内蒙古包头市",
"861893576", "新疆伊犁哈萨克自治州",
"861818717", "云南省文山壮族苗族自治州",
"861597338", "湖南省衡阳市",
"861860326", "河北省石家庄市",
"86189818", "四川省成都市",
"861346444", "辽宁省朝阳市",
"861454480", "湖北省十堰市",
"861342946", "浙江省绍兴市",
"86182436", "吉林省白城市",
"86180292", "广东省佛山市",
"861857191", "湖北省仙桃市",
"861303178", "山东省淄博市",
"861537716", "湖北省咸宁市",
"861329071", "福建省漳州市",
"861370563", "安徽省宣城市",
"861597407", "湖南省永州市",
"861351512", "江苏省南京市",
"861781719", "广东省揭阳市",
"86137369", "浙江省温州市",
"861390089", "西藏昌都地区",
"861500921", "陕西省延安市",
"861850945", "甘肃省金昌市",
"861458505", "河南省南阳市",
"861563451", "山东省济宁市",
"861847686", "广东省深圳市",
"861459688", "新疆石河子市",
"861598723", "云南省楚雄彝族自治州",
"861572633", "山东省日照市",
"861314534", "山东省德州市",
"861361673", "浙江省嘉兴市",
"861823242", "河北省承德市",
"86135390", "广东省东莞市",
"86147362", "广西河池市",
"86135933", "山西省晋城市",
"86137254", "广东省广州市",
"861559087", "黑龙江省哈尔滨市",
"86187315", "河北省唐山市",
"861534773", "广西桂林市",
"861459118", "广西桂林市",
"861532300", "广东省汕尾市",
"86139982", "辽宁省沈阳市",
"861868917", "西藏阿里地区",
"861867534", "广东省中山市",
"861552550", "山西省晋城市",
"861559736", "青海省玉树藏族自治州",
"861366658", "浙江省舟山市",
"861360613", "江苏省苏州市",
"861300264", "浙江省衢州市",
"861373287", "吉林省通化市",
"861335637", "山东省枣庄市",
"861304629", "广东省茂名市",
"86186614", "山东省青岛市",
"86151781", "安徽省阜阳市",
"86159317", "河北省沧州市",
"861539977", "湖南省常德市",
"861315251", "广西南宁市",
"861599944", "新疆乌鲁木齐市",
"861330780", "广西防城港市",
"86151158", "湖南省娄底市",
"861889381", "甘肃省兰州市",
"861893419", "广东省云浮市",
"861459247", "四川省攀枝花市",
"861855613", "江苏省扬州市",
"861533478", "内蒙古巴彦淖尔市",
"861526646", "山东省潍坊市",
"861309651", "山西省运城市",
"861778131", "四川省甘孜藏族自治州",
"861318043", "河北省保定市",
"861378499", "河北省保定市",
"861300409", "安徽省蚌埠市",
"861560857", "贵州省毕节地区",
"861508262", "四川省宜宾市",
"861519685", "四川省达州市",
"861577916", "江西省吉安市",
"861561280", "河北省衡水市",
"86130733", "江苏省苏州市",
"86130146", "河南省郑州市",
"86150806", "湖南省常德市",
"861839463", "甘肃省陇南市",
"861388632", "湖北省鄂州市",
"861585465", "山东省威海市",
"861519546", "江苏省徐州市",
"861314450", "黑龙江省哈尔滨市",
"861357141", "陕西省铜川市",
"861507167", "湖北省黄冈市",
"86150818", "河北省石家庄市",
"861760669", "广东省东莞市",
"861304472", "河南省洛阳市",
"861526585", "山东省聊城市",
"861807338", "湖南省长沙市",
"861801468", "江苏省盐城市",
"861333689", "浙江省宁波市",
"861514859", "内蒙古呼伦贝尔市",
"861370605", "福建省莆田市",
"861308695", "贵州省黔东南苗族侗族自治州",
"86150861", "贵州省黔南布依族苗族自治州",
"861576702", "广东省广州市",
"861811522", "江苏省宿迁市",
"861518984", "江苏省南京市",
"861769505", "宁夏中卫市",
"861598645", "广东省梅州市",
"861585551", "安徽省合肥市",
"8614731", "四川省成都市",
"861884810", "内蒙古呼伦贝尔市",
"86138690", "山东省威海市",
"861530394", "河南省周口市",
"861476286", "江苏省连云港市",
"86138417", "辽宁省营口市",
"86159292", "陕西省咸阳市",
"861773962", "河南省信阳市",
"861539103", "内蒙古包头市",
"861301317", "安徽省安庆市",
"861807407", "浙江省嘉兴市",
"861354744", "四川省南充市",
"861379569", "四川省达州市",
"86187527", "江苏省扬州市",
"861771661", "贵州省六盘水市",
"861533439", "云南省昆明市",
"861846494", "山东省临沂市",
"86138128", "江苏省苏州市",
"861588348", "四川省凉山彝族自治州",
"861760624", "山东省威海市",
"86186665", "广东省佛山市",
"861310982", "辽宁省大连市",
"861569700", "云南省昭通市",
"861580634", "山东省莱芜市",
"861360063", "浙江省绍兴市",
"861599191", "陕西省延安市",
"861770476", "内蒙古赤峰市",
"861843600", "河南省周口市",
"861332877", "福建省厦门市",
"861707849", "云南省文山壮族苗族自治州",
"861872548", "云南省曲靖市",
"86159525", "江苏省扬州市",
"861576046", "四川省达州市",
"861373158", "河北省邢台市",
"861771416", "江苏省徐州市",
"861309141", "黑龙江省大庆市",
"861523503", "山西省忻州市",
"861560496", "辽宁省锦州市",
"861899828", "广东省茂名市",
"861815316", "贵州省铜仁地区",
"861521699", "广东省江门市",
"861837425", "湖南省娄底市",
"861889708", "青海省西宁市",
"861820635", "山东省聊城市",
"861868340", "四川省德阳市",
"861768247", "浙江省绍兴市",
"861338392", "河南省鹤壁市",
"861380484", "黑龙江省大兴安岭地区",
"861336155", "山东省潍坊市",
"861477747", "广西钦州市",
"861511229", "广东省深圳市",
"86711", "湖北省鄂州市",
"861807110", "湖北省武汉市",
"86151046", "黑龙江省哈尔滨市",
"861311800", "四川省宜宾市",
"861370764", "河南省三门峡市",
"861853062", "河南省安阳市",
"86134678", "湖南省郴州市",
"86130787", "云南省昆明市",
"861300443", "江苏省常州市",
"861390066", "浙江省杭州市",
"861364933", "甘肃省平凉市",
"86183595", "福建省泉州市",
"861350856", "贵州省铜仁地区",
"861510940", "甘肃省甘南藏族自治州",
"861809499", "新疆克孜勒苏柯尔克孜自治州",
"861533807", "广东省广州市",
"861336723", "湖北省荆门市",
"861590493", "辽宁省盘锦市",
"86130058", "广东省江门市",
"861532823", "四川省绵阳市",
"861818678", "湖北省神农架林区",
"861303036", "河南省三门峡市",
"861800904", "四川省凉山彝族自治州",
"861588320", "四川省资阳市",
"861524998", "安徽省滁州市",
"861478121", "四川省雅安市",
"861452133", "河北省秦皇岛市",
"86155312", "河北省保定市",
"86181010", "北京市",
"861775963", "福建省泉州市",
"861847571", "广东省佛山市",
"861309175", "黑龙江省大兴安岭地区",
"861479017", "安徽省宣城市",
"861500323", "河北省张家口市",
"861529668", "山西省吕梁市",
"861899329", "甘肃省兰州市",
"861370729", "湖北省孝感市",
"861707348", "河北省唐山市",
"861386268", "江苏省常州市",
"861886612", "山东省济南市",
"861530401", "辽宁省沈阳市",
"861812186", "四川省成都市",
"861582791", "湖北省咸宁市",
"86183240", "新疆昌吉回族自治州",
"86177363", "河北省张家口市",
"861829095", "新疆吐鲁番地区",
"861395660", "安徽省宣城市",
"861321774", "广西梧州市",
"861846301", "山东省威海市",
"861454355", "山东省威海市",
"861534621", "河南省信阳市",
"861369086", "广东省梅州市",
"861336586", "湖南省永州市",
"861840743", "湖南省湘西土家族苗族自治州",
"86138896", "辽宁省大连市",
"861361721", "湖北省黄石市",
"861859680", "福建省三明市",
"861341946", "四川省巴中市",
"86180648", "云南省昆明市",
"861506679", "山东省青岛市",
"861843487", "山西省运城市",
"861390555", "安徽省马鞍山市",
"861530742", "湖南省常德市",
"861301928", "吉林省辽源市",
"861825243", "江苏省徐州市",
"861576475", "内蒙古通辽市",
"861339923", "陕西省渭南市",
"861306488", "江苏省扬州市",
"86180577", "浙江省温州市",
"86139210", "江苏省常州市",
"86158612", "江苏省连云港市",
"861459330", "四川省宜宾市",
"861802990", "广东省中山市",
"861568960", "山东省临沂市",
"861823673", "河南省三门峡市",
"861325924", "陕西省宝鸡市",
"861831290", "浙江省温州市",
"861506638", "山东省烟台市",
"861361242", "广东省揭阳市",
"86156844", "山东省潍坊市",
"861503681", "河南省周口市",
"861804547", "黑龙江省哈尔滨市",
"861501982", "广东省惠州市",
"861313655", "浙江省台州市",
"86150600", "福建省福州市",
"861380798", "江西省景德镇市",
"861367756", "新疆石河子市",
"861510317", "河北省沧州市",
"861865497", "山东省临沂市",
"861539149", "云南省曲靖市",
"861393867", "河南省平顶山市",
"86155297", "陕西省榆林市",
"861818880", "广东省广州市",
"861561627", "湖南省湘潭市",
"861313516", "湖南省益阳市",
"861840625", "辽宁省盘锦市",
"861369481", "江西省九江市",
"861850971", "青海省西宁市",
"861338744", "湖南省张家界市",
"861800588", "浙江省杭州市",
"861479667", "江西省萍乡市",
"861811089", "安徽省亳州市",
"861452696", "陕西省汉中市",
"861333370", "河南省商丘市",
"861334727", "湖南省益阳市",
"861479793", "江西省上饶市",
"861306342", "安徽省六安市",
"861708312", "河北省保定市",
"861335958", "黑龙江省鹤岗市",
"861381529", "江苏省苏州市",
"861325969", "宁夏中卫市",
"86152584", "浙江省温州市",
"861511377", "广东省揭阳市",
"861390616", "江苏省无锡市",
"861818639", "湖北省黄石市",
"861322254", "湖南省邵阳市",
"861853182", "河北省廊坊市",
"861346999", "湖北省武汉市",
"861780259", "江苏省盐城市",
"861337965", "贵州省毕节地区",
"86134547", "浙江省宁波市",
"861762511", "江苏省镇江市",
"861362581", "浙江省杭州市",
"861508237", "四川省攀枝花市",
"861553630", "山西省太原市",
"86147029", "陕西省西安市",
"861361844", "湖南省衡阳市",
"861367430", "吉林省长春市",
"861887118", "湖北省武汉市",
"861839842", "四川省遂宁市",
"861560904", "四川省阿坝藏族羌族自治州",
"861835147", "江苏省淮安市",
"861818491", "西藏拉萨市",
"861308382", "河南省新乡市",
"861550778", "广西河池市",
"861569499", "河北省邯郸市",
"86151487", "内蒙古通辽市",
"861336784", "广西贺州市",
"861532884", "四川省宜宾市",
"861814430", "四川省乐山市",
"861523317", "河北省沧州市",
"861531541", "山东省济南市",
"861826661", "山东省青岛市",
"861353480", "广东省江门市",
"861345812", "四川省攀枝花市",
"861875259", "江苏省徐州市",
"861567110", "湖北省孝感市",
"861816840", "江苏省南京市",
"861580477", "内蒙古鄂尔多斯市",
"861359358", "山西省运城市",
"86156648", "陕西省西安市",
"86155558", "安徽省阜阳市",
"861573367", "河北省廊坊市",
"861342943", "浙江省嘉兴市",
"861471494", "广东省佛山市",
"861866679", "广东省肇庆市",
"86156192", "陕西省西安市",
"861537713", "湖北省黄冈市",
"861887247", "湖北省武汉市",
"861593649", "河南省安阳市",
"861598498", "四川省凉山彝族自治州",
"861370566", "安徽省池州市",
"861331035", "内蒙古通辽市",
"861335662", "山东省东营市",
"861538435", "广东省珠海市",
"861588761", "云南省西双版纳傣族自治州",
"861351251", "江苏省南京市",
"86147996", "新疆巴音郭楞蒙古自治州",
"861376892", "广西桂林市",
"861582915", "陕西省渭南市",
"86153819", "浙江省宁波市",
"861341341", "广东省汕头市",
"86138299", "广东省惠州市",
"861339508", "福建省福州市",
"861510549", "山东省临沂市",
"861539043", "四川省成都市",
"861301503", "内蒙古乌兰察布市",
"861308448", "四川省绵阳市",
"861893573", "新疆昌吉回族自治州",
"861303699", "广西北海市",
"861860323", "河北省张家口市",
"86186600", "山东省烟台市",
"86177579", "浙江省金华市",
"861367554", "安徽省淮南市",
"861325560", "山东省东营市",
"86157341", "辽宁省大连市",
"86180844", "贵州省黔南布依族苗族自治州",
"861855522", "安徽省铜陵市",
"861590740", "湖南省张家界市",
"861365376", "河南省信阳市",
"861346590", "山东省济南市",
"861772970", "河南省濮阳市",
"861338546", "山东省东营市",
"861866638", "广东省佛山市",
"861309406", "新疆伊犁哈萨克自治州",
"861380249", "广东省肇庆市",
"861835657", "安徽省芜湖市",
"861882998", "广东省东莞市",
"861586630", "山东省威海市",
"861318103", "山东省滨州市",
"861338821", "四川省达州市",
"861893254", "河北省石家庄市",
"861562990", "湖北省黄石市",
"861537851", "四川省凉山彝族自治州",
"861889293", "新疆塔城地区",
"861857631", "广东省清远市",
"861814554", "黑龙江省绥化市",
"861535295", "青海省海西蒙古族藏族自治州",
"861888142", "四川省内江市",
"861335012", "四川省资阳市",
"861394871", "内蒙古呼和浩特市",
"86156577", "浙江省温州市",
"861831605", "广东省汕头市",
"861300790", "宁夏石嘴山市",
"861595602", "安徽省宿州市",
"861809631", "四川省广元市",
"86158743", "湖南省湘西土家族苗族自治州",
"861819561", "青海省西宁市",
"861452354", "河南省周口市",
"861550739", "湖南省邵阳市",
"86158136", "广东省佛山市",
"861840490", "山西省大同市",
"861850376", "河南省信阳市",
"861801302", "江苏省南京市",
"861393372", "河北省邢台市",
"861880580", "浙江省舟山市",
"861335474", "内蒙古兴安盟",
"861388793", "云南省西双版纳傣族自治州",
"861360522", "江苏省徐州市",
"86180735", "湖南省郴州市",
"86182310", "河北省邯郸市",
"861458666", "湖南省郴州市",
"861370055", "山西省晋中市",
"861879420", "甘肃省兰州市",
"861773937", "河南省濮阳市",
"861536390", "广东省茂名市",
"861310020", "湖南省岳阳市",
"86152346", "山西省晋城市",
"861560588", "浙江省杭州市",
"861388667", "湖北省宜昌市",
"861815231", "宁夏银川市",
"861453509", "山东省日照市",
"861777261", "河北省邢台市",
"861880963", "宁夏吴忠市",
"861802599", "广东省佛山市",
"861392673", "广东省茂名市",
"861587195", "湖北省咸宁市",
"861357406", "湖南省湘潭市",
"861529952", "新疆喀什地区",
"861329473", "内蒙古乌海市",
"861872817", "四川省雅安市",
"861808726", "云南省昆明市",
"861301549", "山西省大同市",
"861709641", "山东省济南市",
"861471788", "山西省长治市",
"861312326", "福建省宁德市",
"86155419", "辽宁省沈阳市",
"861322419", "辽宁省辽阳市",
"861310048", "广西河池市",
"861813635", "江苏省徐州市",
"861376926", "云南省楚雄彝族自治州",
"861508917", "广东省珠海市",
"861450531", "辽宁省营口市",
"861355800", "广西防城港市",
"861583331", "河北省石家庄市",
"86151272", "河北省保定市",
"861890535", "山东省烟台市",
"861321681", "浙江省杭州市",
"861529207", "湖南省益阳市",
"861323982", "新疆阿克苏地区",
"861369762", "山东省烟台市",
"86147870", "云南省昭通市",
"861321111", "广东省清远市",
"861879448", "甘肃省临夏回族自治州",
"861586388", "山东省临沂市",
"861571636", "河南省焦作市",
"861362676", "浙江省嘉兴市",
"861530146", "江苏省南通市",
"861372204", "内蒙古呼和浩特市",
"861589901", "新疆巴音郭楞蒙古自治州",
"861529427", "甘肃省定西市",
"861884033", "陕西省渭南市",
"86186806", "广东省东莞市",
"861860800", "四川省成都市",
"861835938", "福建省宁德市",
"86170843", "吉林省长春市",
"861801280", "江苏省镇江市",
"861889986", "广东省梅州市",
"86139619", "江苏省盐城市",
"861343751", "广东省汕尾市",
"861800857", "贵州省毕节地区",
"861766648", "广东省中山市",
"861533954", "贵州省黔西南布依族苗族自治州",
"861390782", "广西柳州市",
"86130481", "广东省江门市",
"861586442", "山东省菏泽市",
"861555264", "山东省德州市",
"861533691", "浙江省金华市",
"861590728", "湖北省十堰市",
"861336498", "新疆石河子市",
"861853037", "河南省三门峡市",
"861800091", "广东省茂名市",
"861394845", "内蒙古通辽市",
"861780072", "青海省海东地区",
"86151433", "吉林省延边朝鲜族自治州",
"861831729", "河南省焦作市",
"861381948", "浙江省杭州市",
"86147551", "安徽省合肥市",
"86136110", "北京市",
"861832980", "陕西省延安市",
"861708195", "福建省莆田市",
"861568122", "四川省绵阳市",
"861572860", "广东省云浮市",
"86150209", "山东省临沂市",
"861528545", "贵州省黔西南布依族苗族自治州",
"861366962", "广西柳州市",
"861556331", "山东省日照市",
"861567407", "湖南省郴州市",
"861773148", "河北省唐山市",
"861881460", "黑龙江省黑河市",
"861327393", "河南省濮阳市",
"861340315", "河北省唐山市",
"861308200", "河北省邢台市",
"861397276", "湖北省黄石市",
"861528686", "河南省驻马店市",
"86183649", "山东省滨州市",
"861312535", "江西省吉安市",
"861308420", "河南省新乡市",
"861835979", "福建省福州市",
"861453543", "江苏省泰州市",
"861553388", "河北省唐山市",
"861314167", "江苏省南京市",
"861317953", "江苏省常州市",
"861857700", "广西防城港市",
"861517472", "内蒙古乌海市",
"861300862", "云南省楚雄彝族自治州",
"861521787", "广东省珠海市",
"86188194", "广东省广州市",
"861565025", "山东省潍坊市",
"86186861", "内蒙古包头市",
"861340796", "江西省吉安市",
"861393832", "河南省濮阳市",
"861823360", "河北省廊坊市",
"861580343", "山西省太原市",
"861804818", "四川省绵阳市",
"8613430", "广东省深圳市",
"861823844", "河南省南阳市",
"86186818", "陕西省西安市",
"861867167", "湖北省十堰市",
"861841993", "甘肃省定西市",
"861890326", "河北省廊坊市",
"861864953", "山西省长治市",
"861379726", "湖北省荆州市",
"861850836", "四川省甘孜藏族自治州",
"861596546", "山东省东营市",
"861394331", "吉林省四平市",
"861508340", "河南省南阳市",
"861886037", "河南省郑州市",
"861843295", "河北省秦皇岛市",
"861839489", "甘肃省白银市",
"861354821", "四川省攀枝花市",
"861816828", "江苏省扬州市",
"861800496", "辽宁省锦州市",
"861571193", "广东省广州市",
"861318149", "山东省临沂市",
"861814642", "新疆乌鲁木齐市",
"861707761", "云南省昆明市",
"861772413", "广东省茂名市",
"861869757", "安徽省宿州市",
"861333797", "江苏省淮安市",
"861886786", "浙江省宁波市",
"861359859", "河南省信阳市",
"861313005", "辽宁省鞍山市",
"861809700", "青海省海北藏族自治州",
"861815911", "福建省莆田市",
"861379583", "四川省宜宾市",
"86150665", "山东省德州市",
"861332362", "河南省安阳市",
"861553442", "山西省晋中市",
"861380423", "辽宁省抚顺市",
"861535050", "河北省邯郸市",
"861517014", "江西省新余市",
"861823676", "河南省郑州市",
"861505995", "福建省南平市",
"861300041", "广东省广州市",
"861894895", "广东省江门市",
"861590857", "贵州省毕节地区",
"861771970", "陕西省汉中市",
"861315684", "山东省菏泽市",
"861596900", "云南省昭通市",
"861821867", "广东省广州市",
"861881998", "广东省惠州市",
"861550067", "青海省海东地区",
"86130591", "广东省广州市",
"861554658", "黑龙江省鹤岗市",
"86182851", "贵州省贵阳市",
"861777104", "湖北省襄樊市",
"861806115", "江苏省扬州市",
"86177319", "河北省邢台市",
"861315114", "江苏省扬州市",
"861458119", "安徽省阜阳市",
"86156317", "河北省沧州市",
"861309284", "四川省广安市",
"861825246", "江苏省南通市",
"86137573", "浙江省嘉兴市",
"861830802", "西藏日喀则地区",
"861454268", "西藏拉萨市",
"861339926", "陕西省汉中市",
"861348484", "陕西省榆林市",
"86189614", "江苏省常州市",
"861770910", "陕西省西安市",
"861458689", "湖南省岳阳市",
"861813458", "安徽省淮北市",
"861863419", "河北省保定市",
"861800728", "湖北省十堰市",
"861395945", "福建省龙岩市",
"861569944", "新疆喀什地区",
"861576009", "四川省宜宾市",
"861334587", "浙江省温州市",
"861340428", "江苏省无锡市",
"861479796", "江西省吉安市",
"86176205", "广东省东莞市",
"861452767", "广西柳州市",
"861327542", "山东省青岛市",
"861356170", "山东省莱芜市",
"86182570", "浙江省金华市",
"861339760", "湖南省长沙市",
"861898917", "四川省达州市",
"86185681", "河南省洛阳市",
"861880361", "河南省平顶山市",
"861340632", "山东省枣庄市",
"861324775", "江西省宜春市",
"861390613", "江苏省苏州市",
"861808784", "云南省昆明市",
"861870877", "云南省玉溪市",
"861453392", "内蒙古阿拉善盟",
"861342835", "广东省佛山市",
"861330548", "山东省泰安市",
"861471949", "甘肃省酒泉市",
"861367753", "新疆石河子市",
"861801599", "江苏省镇江市",
"861580592", "福建省厦门市",
"861351771", "广西南宁市",
"861344232", "江苏省苏州市",
"861871817", "广东省惠州市",
"861313513", "湖南省株洲市",
"861810098", "西藏拉萨市",
"86187856", "贵州省铜仁地区",
"861500535", "山东省烟台市",
"86134403", "上海市",
"861316762", "安徽省滁州市",
"861512862", "河北省承德市",
"861373997", "内蒙古包头市",
"86152607", "福建省泉州市",
"861452693", "陕西省渭南市",
"861590496", "辽宁省大连市",
"861532826", "四川省巴中市",
"861869828", "辽宁省辽阳市",
"861303033", "河南省濮阳市",
"861377879", "四川省巴中市",
"861337640", "山东省济南市",
"861452136", "河北省沧州市",
"861361581", "浙江省杭州市",
"861566744", "陕西省宝鸡市",
"861577470", "内蒙古呼伦贝尔市",
"861830483", "内蒙古阿拉善盟",
"861554148", "辽宁省葫芦岛市",
"861301704", "贵州省六盘水市",
"861565052", "山东省日照市",
"86131009", "黑龙江省哈尔滨市",
"861814811", "四川省南充市",
"86153632", "广东省韶关市",
"86187783", "广西桂林市",
"861318475", "河北省邢台市",
"861370589", "浙江省金华市",
"861599700", "青海省海北藏族自治州",
"861505572", "安徽省宿州市",
"861538937", "陕西省渭南市",
"861769830", "河南省安阳市",
"861515550", "安徽省宣城市",
"861537514", "安徽省巢湖市",
"86184042", "辽宁省朝阳市",
"861390063", "山东省济南市",
"861300446", "江苏省泰州市",
"861532541", "浙江省衢州市",
"861816757", "新疆伊犁哈萨克自治州",
"861364936", "甘肃省张掖市",
"861350853", "贵州省安顺市",
"861325708", "江西省南昌市",
"861356818", "四川省达州市",
"861860921", "陕西省延安市",
"861580975", "青海省果洛藏族自治州",
"861840746", "湖南省永州市",
"861321852", "江苏省盐城市",
"861336583", "湖南省湘西土家族苗族自治州",
"86130072", "江西省南昌市",
"861520330", "河北省邯郸市",
"86132780", "吉林省四平市",
"861571792", "江西省九江市",
"861888709", "云南省西双版纳傣族自治州",
"861323894", "辽宁省锦州市",
"861341943", "四川省乐山市",
"861898829", "云南省昆明市",
"861858339", "四川省成都市",
"861821914", "广东省深圳市",
"861874640", "黑龙江省七台河市",
"86156292", "湖北省恩施土家族苗族自治州",
"861806821", "江苏省宿迁市",
"861554217", "辽宁省沈阳市",
"861500326", "河北省廊坊市",
"861347314", "河北省承德市",
"861303527", "湖北省十堰市",
"861770347", "山西省临汾市",
"86188381", "河南省郑州市",
"861820974", "青海省海南藏族自治州",
"861812183", "四川省成都市",
"86135837", "山东省济宁市",
"861871929", "广东省阳江市",
"86138199", "浙江省金华市",
"861776832", "江苏省无锡市",
"861329105", "江苏省徐州市",
"861311535", "黑龙江省佳木斯市",
"861301665", "广东省汕头市",
"861476283", "江苏省镇江市",
"861886769", "浙江省嘉兴市",
"861539106", "内蒙古巴彦淖尔市",
"861819679", "安徽省马鞍山市",
"861580941", "甘肃省天水市",
"86158501", "江苏省苏州市",
"861808498", "四川省达州市",
"861803649", "江苏省常州市",
"861839466", "甘肃省兰州市",
"861782662", "江苏省泰州市",
"861855066", "江苏省盐城市",
"861518321", "四川省资阳市",
"861519543", "江苏省盐城市",
"861870337", "河北省沧州市",
"861399737", "青海省海西蒙古族藏族自治州",
"861826538", "山东省泰安市",
"861387297", "湖北省武汉市",
"861778954", "甘肃省平凉市",
"861869329", "甘肃省兰州市",
"861327991", "新疆乌鲁木齐市",
"861365660", "浙江省嘉兴市",
"861372081", "福建省福州市",
"861805279", "江苏省宿迁市",
"861537682", "山东省淄博市",
"861576043", "四川省绵阳市",
"861572193", "陕西省渭南市",
"861840968", "宁夏固原市",
"861324402", "吉林省吉林市",
"861560493", "辽宁省抚顺市",
"861815313", "贵州省安顺市",
"86151597", "福建省泉州市",
"861523506", "山西省朔州市",
"861324222", "广东省中山市",
"861520688", "山东省滨州市",
"861869364", "甘肃省张掖市",
"861532575", "浙江省绍兴市",
"861839181", "陕西省咸阳市",
"861322825", "四川省南充市",
"861850660", "广东省汕尾市",
"861348798", "湖南省邵阳市",
"861363914", "贵州省贵阳市",
"861335197", "黑龙江省鸡西市",
"861453744", "湖南省张家界市",
"861318441", "浙江省杭州市",
"861511041", "山西省太原市",
"861320438", "吉林省松原市",
"861343271", "广东省清远市",
"861360066", "浙江省温州市",
"861528669", "贵州省六盘水市",
"861337628", "江苏省常州市",
"861538658", "四川省泸州市",
"861770473", "内蒙古乌海市",
"861521810", "广东省梅州市",
"86183762", "广西柳州市",
"86159735", "湖南省郴州市",
"861472788", "陕西省渭南市",
"861559733", "青海省黄南藏族自治州",
"861470248", "辽宁省大连市",
"861321419", "辽宁省辽阳市",
"861360616", "江苏省无锡市",
"86184879", "云南省西双版纳傣族自治州",
"861889969", "新疆巴音郭楞蒙古自治州",
"861521139", "湖南省衡阳市",
"861847683", "广东省湛江市",
"861857568", "广东省深圳市",
"861368777", "广西钦州市",
"861555101", "安徽省滁州市",
"861361676", "浙江省台州市",
"861320479", "内蒙古锡林郭勒盟",
"861598726", "云南省临沧市",
"861572636", "山东省潍坊市",
"861475730", "浙江省宁波市",
"861340440", "吉林省白城市",
"861341909", "四川省达州市",
"861322681", "广东省汕头市",
"861330520", "江苏省徐州市",
"86151172", "甘肃省兰州市",
"861351745", "湖南省怀化市",
"861524157", "辽宁省丹东市",
"861866455", "广东省深圳市",
"861847113", "湖北省十堰市",
"86187650", "山东省菏泽市",
"861855555", "安徽省马鞍山市",
"861399481", "山西省吕梁市",
"861520870", "云南省昭通市",
"861782012", "广东省中山市",
"861855616", "江苏省徐州市",
"861526643", "山东省日照市",
"861532992", "贵州省遵义市",
"86145490", "湖北省荆州市",
"86137462", "黑龙江省齐齐哈尔市",
"861360461", "黑龙江省齐齐哈尔市",
"861391242", "江苏省南通市",
"861705220", "云南省昆明市",
"861809568", "安徽省宿州市",
"86187737", "湖南省益阳市",
"861577913", "江西省上饶市",
"86132653", "广东省广州市",
"861802280", "广东省茂名市",
"861800740", "湖南省常德市",
"861308135", "辽宁省本溪市",
"86136210", "北京市",
"861831980", "广东省韶关市",
"861805238", "江苏省淮安市",
"861301015", "山东省淄博市",
"861777502", "安徽省六安市",
"86137040", "辽宁省沈阳市",
"861360555", "安徽省马鞍山市",
"861571860", "贵州省贵阳市",
"861510704", "江西省抚州市",
"861889924", "新疆阿克苏地区",
"86137022", "广东省江门市",
"861836200", "江苏省镇江市",
"861834054", "辽宁省葫芦岛市",
"861308637", "四川省南充市",
"86147957", "广西南宁市",
"861787600", "广东省中山市",
"861380372", "河南省安阳市",
"861593309", "河北省邢台市",
"861893580", "新疆塔城地区",
"861470615", "江苏省无锡市",
"861301736", "湖南省常德市",
"861811170", "四川省成都市",
"861599939", "新疆克拉玛依市",
"861800933", "甘肃省平凉市",
"861323412", "辽宁省鞍山市",
"861803194", "河北省石家庄市",
"86182335", "河北省秦皇岛市",
"86180710", "湖北省武汉市",
"861321720", "湖北省襄樊市",
"861364904", "四川省泸州市",
"86150133", "广东省广州市",
"86150746", "湖南省永州市",
"861889661", "江苏省连云港市",
"861301087", "甘肃省兰州市",
"861592554", "云南省昭通市",
"86186458", "黑龙江省伊春市",
"861816771", "新疆阿克苏地区",
"861873896", "河南省开封市",
"86188702", "江西省九江市",
"861783545", "山西省长治市",
"861822798", "四川省广安市",
"861322989", "河北省邢台市",
"861454476", "陕西省汉中市",
"861884991", "云南省怒江傈僳族自治州",
"861314549", "山东省临沂市",
"86189563", "安徽省宣城市",
"861321966", "四川省自贡市",
"86155946", "陕西省西安市",
"861857805", "广东省韶关市",
"861506660", "山东省德州市",
"861516530", "山东省菏泽市",
"861535262", "新疆乌鲁木齐市",
"861559940", "贵州省黔南布依族苗族自治州",
"86177878", "云南省楚雄彝族自治州",
"861831831", "广东省东莞市",
"861363021", "陕西省西安市",
"861820763", "广东省清远市",
"861591753", "广东省肇庆市",
"86178640", "山东省菏泽市",
"861358146", "湖北省孝感市",
"861839827", "四川省雅安市",
"861318353", "四川省巴中市",
"86156623", "山东省威海市",
"86137995", "福建省泉州市",
"861867549", "广东省揭阳市",
"861820697", "云南省大理白族自治州",
"861304384", "辽宁省铁岭市",
"861880254", "广东省茂名市",
"861815086", "福建省宁德市",
"861459368", "贵州省黔东南苗族侗族自治州",
"861328993", "新疆石河子市",
"86185910", "陕西省咸阳市",
"861774925", "陕西省汉中市",
"861835122", "江苏省常州市",
"861841436", "内蒙古鄂尔多斯市",
"861889416", "甘肃省张掖市",
"861566032", "新疆阿克苏地区",
"861373462", "青海省海东地区",
"86178622", "山东省临沂市",
"861591125", "云南省文山壮族苗族自治州",
"861708564", "安徽省六安市",
"861470556", "安徽省安庆市",
"861590871", "云南省昆明市",
"861329480", "内蒙古呼和浩特市",
"86136374", "湖南省长沙市",
"86155859", "贵州省黔西南布依族苗族自治州",
"861580649", "山东省潍坊市",
"86189287", "广东省广州市",
"861879958", "新疆和田地区",
"861819971", "新疆克孜勒苏柯尔克孜自治州",
"861860705", "江西省宜春市",
"861826293", "江苏省宿迁市",
"861778999", "西藏拉萨市",
"86153561", "浙江省杭州市",
"861333324", "河北省保定市",
"861707834", "云南省昭通市",
"861709494", "浙江省金华市",
"861880573", "浙江省嘉兴市",
"86139500", "福建省厦门市",
"861845263", "江苏省南通市",
"861450190", "山西省运城市",
"861515406", "山东省枣庄市",
"86153518", "江苏省连云港市",
"861352329", "河南省许昌市",
"861896376", "安徽省六安市",
"861360547", "山东省济宁市",
"861327699", "福建省福州市",
"861381458", "江苏省苏州市",
"861355705", "广西玉林市",
"861815481", "新疆乌鲁木齐市",
"86137675", "江西省宜春市",
"861888127", "四川省广元市",
"861771381", "四川省南充市",
"86152689", "甘肃省庆阳市",
"861889011", "湖南省郴州市",
"861780508", "江苏省常州市",
"861319497", "四川省成都市",
"861317837", "福建省漳州市",
"861301167", "山东省潍坊市",
"861870851", "贵州省贵阳市",
"861810878", "云南省楚雄彝族自治州",
"86185477", "内蒙古鄂尔多斯市",
"861364588", "浙江省丽水市",
"861866447", "广东省中山市",
"861524145", "辽宁省大连市",
"861855547", "安徽省宿州市",
"861351757", "广西钦州市",
"8615995", "江苏省苏州市",
"861772983", "四川省成都市",
"861323358", "山西省吕梁市",
"86158728", "湖北省咸宁市",
"861760389", "河南省濮阳市",
"861831345", "云南省文山壮族苗族自治州",
"861354739", "四川省自贡市",
"861533444", "云南省曲靖市",
"861352364", "河南省南阳市",
"861595342", "山东省德州市",
"861528961", "广西柳州市",
"861864837", "内蒙古鄂尔多斯市",
"861839919", "新疆阿克苏地区",
"861512956", "陕西省西安市",
"861313998", "新疆喀什地区",
"861363206", "广东省江门市",
"861860664", "浙江省温州市",
"861332395", "河南省漯河市",
"861859360", "福建省漳州市",
"861520090", "湖南省长沙市",
"86153231", "广东省清远市",
"861527774", "广西梧州市",
"861350435", "吉林省四平市",
"861568147", "四川省达州市",
"861556728", "吉林省松原市",
"861389710", "青海省海北藏族自治州",
"861830311", "河北省石家庄市",
"861554285", "辽宁省营口市",
"861317264", "广东省肇庆市",
"861353910", "广东省河源市",
"861392338", "广东省珠海市",
"861550685", "广西百色市",
"861343188", "广东省惠州市",
"861332716", "内蒙古赤峰市",
"861393423", "山西省太原市",
"861524171", "辽宁省铁岭市",
"861818154", "四川省乐山市",
"861804613", "福建省三明市",
"861581987", "广东省惠州市",
"861572604", "山东省菏泽市",
"861529388", "甘肃省临夏回族自治州",
"861843262", "河北省保定市",
"86135019", "上海市",
"86134251", "广东省深圳市",
"861775419", "安徽省合肥市",
"861338778", "广西河池市",
"861861358", "山西省吕梁市",
"861323859", "贵州省黔西南布依族苗族自治州",
"861816623", "湖南省怀化市",
"861384808", "内蒙古呼伦贝尔市",
"861317409", "江苏省南京市",
"861590845", "四川省内江市",
"861568218", "四川省南充市",
"861705065", "江苏省南京市",
"861760888", "云南省丽江市",
"86150187", "广东省广州市",
"86186519", "江苏省常州市",
"86170828", "四川省成都市",
"861801430", "江苏省常州市",
"861378805", "广西玉林市",
"861302692", "广西柳州市",
"861888210", "四川省资阳市",
"861810379", "河南省洛阳市",
"86156691", "浙江省宁波市",
"861510736", "湖南省常德市",
"861334656", "广东省肇庆市",
"861539134", "云南省昆明市",
"861359982", "福建省宁德市",
"861860472", "内蒙古包头市",
"861379570", "四川省资阳市",
"86145323", "浙江省杭州市",
"861570690", "云南省西双版纳傣族自治州",
"861508600", "贵州省贵阳市",
"861597676", "广东省汕尾市",
"861328286", "浙江省台州市",
"861845444", "山东省淄博市",
"861529701", "青海省西宁市",
"861338739", "湖南省邵阳市",
"861568657", "陕西省铜川市",
"861810407", "辽宁省营口市",
"861871885", "广东省阳江市",
"86189472", "内蒙古包头市",
"861345903", "福建省厦门市",
"861829523", "宁夏吴忠市",
"861810338", "河北省衡水市",
"86183386", "河南省信阳市",
"86183877", "云南省普洱市",
"861330256", "广东省佛山市",
"86157398", "新疆巴音郭楞蒙古自治州",
"861760670", "浙江省衢州市",
"861367302", "河南省濮阳市",
"861522004", "广东省广州市",
"861705615", "山东省济南市",
"861770355", "山西省长治市",
"861339414", "辽宁省本溪市",
"861321748", "湖南省长沙市",
"861705556", "辽宁省沈阳市",
"861550546", "山东省东营市",
"861894446", "江苏省扬州市",
"861804063", "湖北省荆州市",
"861369795", "江西省宜春市",
"861308958", "黑龙江省鸡西市",
"861533263", "陕西省榆林市",
"861339072", "江苏省盐城市",
"86184318", "河北省衡水市",
"861366572", "浙江省湖州市",
"861806187", "江苏省常州市",
"861707374", "河南省许昌市",
"861700943", "江苏省徐州市",
"861306052", "广东省潮州市",
"861479950", "新疆阿克苏地区",
"86156704", "河南省新乡市",
"861839239", "陕西省西安市",
"861471641", "广东省广州市",
"861829786", "安徽省六安市",
"86130625", "江苏省南京市",
"861590331", "河北省石家庄市",
"861334515", "山东省烟台市",
"861375463", "山东省威海市",
"861567242", "湖北省荆州市",
"861550821", "四川省达州市",
"861452502", "山东省济南市",
"861340950", "宁夏银川市",
"86136514", "广东省深圳市",
"861378939", "湖南省衡阳市",
"861309434", "云南省红河哈尼族彝族自治州",
"861515284", "江苏省宿迁市",
"861876278", "江苏省扬州市",
"861802642", "广东省广州市",
"861530587", "浙江省温州市",
"861818876", "广东省惠州市",
"861813766", "河南省郑州市",
"861869623", "湖北省襄樊市",
"861350658", "浙江省金华市",
"86151991", "新疆乌鲁木齐市",
"861509684", "云南省昭通市",
"861351329", "河北省邢台市",
"861803343", "广东省深圳市",
"861327527", "江苏省南通市",
"861319995", "新疆吐鲁番地区",
"861308719", "内蒙古鄂尔多斯市",
"861398030", "四川省南充市",
"861394857", "内蒙古鄂尔多斯市",
"861571765", "河北省廊坊市",
"861509114", "陕西省宝鸡市",
"861329355", "山西省长治市",
"861857219", "湖北省武汉市",
"861597844", "河南省郑州市",
"861363484", "黑龙江省齐齐哈尔市",
"861304535", "黑龙江省鸡西市",
"861585650", "安徽省合肥市",
"861340387", "河南省周口市",
"861302167", "山东省青岛市",
"861880774", "广西梧州市",
"861327033", "江苏省徐州市",
"861557684", "湖南省益阳市",
"861887090", "江西省新余市",
"861382458", "广东省梅州市",
"861521715", "广东省珠海市",
"861848419", "贵州省安顺市",
"861842031", "广东省湛江市",
"861359894", "河南省驻马店市",
"861520775", "广西玉林市",
"861591273", "云南省文山壮族苗族自治州",
"861705332", "广东省深圳市",
"861589272", "四川省眉山市",
"861351364", "山西省太原市",
"861828909", "西藏日喀则地区",
"861334003", "江西省上饶市",
"861534548", "山东省日照市",
"861563634", "黑龙江省鸡西市",
"861351840", "四川省眉山市",
"861867665", "广东省深圳市",
"86159895", "广东省深圳市",
"861305509", "湖南省益阳市",
"86139792", "江西省九江市",
"861813920", "新疆伊犁哈萨克自治州",
"861550900", "新疆昌吉回族自治州",
"861529866", "江苏省淮安市",
"861551449", "河南省驻马店市",
"861862859", "陕西省咸阳市",
"861865658", "安徽省芜湖市",
"861812818", "广东省韶关市",
"861303542", "安徽省六安市",
"861512895", "河北省保定市",
"861560936", "甘肃省张掖市",
"861770322", "河北省保定市",
"861309550", "安徽省滁州市",
"861802152", "江苏省南京市",
"861812170", "江苏省泰州市",
"861319572", "青海省海西蒙古族藏族自治州",
"861774427", "四川省达州市",
"86136565", "浙江省台州市",
"86151671", "浙江省杭州市",
"861709949", "浙江省嘉兴市",
"86131281", "广东省东莞市",
"861336007", "广东省深圳市",
"861537240", "浙江省杭州市",
"861369507", "福建省南平市",
"861780926", "陕西省汉中市",
"861580565", "安徽省合肥市",
"861815069", "福建省漳州市",
"861893361", "广东省梅州市",
"861302736", "湖南省常德市",
"86188245", "广东省东莞市",
"861800331", "河北省石家庄市",
"861853397", "河北省唐山市",
"861470872", "云南省大理白族自治州",
"861770607", "福建省泉州市",
"86151409", "辽宁省辽阳市",
"861321989", "四川省德阳市",
"861859676", "福建省福州市",
"861350148", "广东省广州市",
"861472675", "四川省资阳市",
"861589609", "江苏省宿迁市",
"861820564", "安徽省六安市",
"861869745", "内蒙古乌海市",
"861322720", "湖北省咸宁市",
"861336570", "安徽省滁州市",
"861580451", "黑龙江省哈尔滨市",
"861302087", "河北省张家口市",
"861892265", "广东省云浮市",
"861807676", "广西桂林市",
"861328391", "河南省焦作市",
"861354187", "四川省广安市",
"861390818", "四川省成都市",
"86185065", "浙江省宁波市",
"861533999", "山东省青岛市",
"861876239", "江苏省盐城市",
"861508985", "广东省韶关市",
"861815024", "福建省漳州市",
"86184434", "吉林省四平市",
"861378978", "内蒙古巴彦淖尔市",
"861337300", "河北省邯郸市",
"861318694", "浙江省台州市",
"861354617", "山西省临汾市",
"861452898", "云南省昆明市",
"861830470", "内蒙古呼伦贝尔市",
"861558520", "贵州省遵义市",
"86188590", "福建省龙岩市",
"861384975", "河南省信阳市",
"861865148", "江苏省盐城市",
"861780760", "广东省中山市",
"86137627", "湖南省岳阳市",
"861324330", "河南省信阳市",
"861820529", "江苏省镇江市",
"861894862", "广东省东莞市",
"861770480", "内蒙古呼和浩特市",
"861558548", "吉林省白山市",
"861551403", "河南省开封市",
"861366856", "贵州省铜仁地区",
"861458383", "福建省漳州市",
"861858196", "四川省成都市",
"861829769", "安徽省黄山市",
"861874282", "新疆喀什地区",
"861305543", "福建省厦门市",
"86151556", "安徽省安庆市",
"861587763", "陕西省安康市",
"861334049", "福建省莆田市",
"861840578", "浙江省丽水市",
"86187408", "辽宁省阜新市",
"861347537", "山东省济宁市",
"861569530", "青海省海北藏族自治州",
"861300956", "内蒙古包头市",
"861887255", "湖北省襄樊市",
"861865120", "江苏省常州市",
"861536030", "广东省阳江市",
"861862412", "辽宁省鞍山市",
"861801125", "四川省达州市",
"861328404", "黑龙江省绥化市",
"861893299", "河北省邢台市",
"861388165", "四川省巴中市",
"861324247", "河北省邢台市",
"861532965", "贵州省黔东南苗族侗族自治州",
"861806778", "浙江省温州市",
"86151923", "山东省烟台市",
"861878434", "四川省内江市",
"861337282", "辽宁省沈阳市",
"861835155", "江苏省盐城市",
"861589153", "陕西省渭南市",
"86159710", "湖北省襄樊市",
"86184578", "浙江省丽水市",
"861593194", "河北省保定市",
"861829724", "青海省海南藏族自治州",
"861809939", "新疆阿克苏地区",
"861452399", "西藏拉萨市",
"861827159", "湖北省十堰市",
"861803309", "广东省深圳市",
"861338067", "广东省惠州市",
"86133708", "山东省青岛市",
"861817493", "广西河池市",
"861877049", "江西省赣州市",
"8615701", "北京市",
"861526848", "浙江省绍兴市",
"861700341", "湖北省武汉市",
"861835723", "浙江省嘉兴市",
"861589725", "青海省海南藏族自治州",
"86130997", "青海省西宁市",
"861390319", "河北省邢台市",
"861869771", "河南省信阳市",
"861513869", "河南省郑州市",
"861476270", "江苏省泰州市",
"86152002", "湖南省岳阳市",
"861319174", "河北省唐山市",
"861477184", "湖北省黄石市",
"86189746", "湖南省永州市",
"86189133", "江苏省南京市",
"861338258", "江苏省泰州市",
"861303144", "河北省石家庄市",
"861313460", "山西省忻州市",
"861537228", "浙江省丽水市",
"861366497", "广东省阳江市",
"861351828", "四川省南充市",
"861534520", "江苏省淮安市",
"861324870", "浙江省宁波市",
"861526303", "山东省青岛市",
"86183825", "四川省遂宁市",
"861330776", "广西百色市",
"86182411", "辽宁省大连市",
"861331395", "福建省莆田市",
"861768886", "广东省广州市",
"861809978", "新疆克孜勒苏柯尔克孜自治州",
"861569454", "黑龙江省佳木斯市",
"861346439", "辽宁省营口市",
"861339865", "河北省秦皇岛市",
"861813948", "新疆和田地区",
"861524479", "黑龙江省佳木斯市",
"86133716", "北京市",
"86182028", "四川省成都市",
"861830913", "陕西省渭南市",
"861372236", "河北省承德市",
"861865937", "福建省宁德市",
"861582987", "陕西省宝鸡市",
"861571604", "福建省龙岩市",
"861874823", "内蒙古兴安盟",
"861520741", "湖南省株洲市",
"861819447", "甘肃省陇南市",
"861820082", "广东省河源市",
"861875294", "江苏省镇江市",
"861454519", "湖南省永州市",
"861520883", "云南省临沧市",
"861700835", "浙江省嘉兴市",
"861589643", "江苏省淮安市",
"861840539", "山东省临沂市",
"86130677", "浙江省杭州市",
"86134788", "辽宁省沈阳市",
"861846214", "山东省济宁市",
"86150287", "河北省沧州市",
"861591642", "广东省阳江市",
"861586925", "浙江省金华市",
"861805488", "福建省三明市",
"861471459", "广东省东莞市",
"86134151", "广东省汕头市",
"861780892", "西藏日喀则地区",
"861812319", "四川省达州市",
"861470332", "河北省保定市",
"861800871", "云南省昆明市",
"861539356", "甘肃省金昌市",
"861894790", "内蒙古锡林郭勒盟",
"861847670", "广东省河源市",
"861575199", "甘肃省金昌市",
"861860597", "福建省龙岩市",
"861337823", "四川省巴中市",
"861538853", "山西省阳泉市",
"861821484", "安徽省蚌埠市",
"861872621", "安徽省滁州市",
"861374088", "云南省昆明市",
"86187416", "辽宁省锦州市",
"86186379", "河南省洛阳市",
"861303654", "四川省泸州市",
"86157062", "江苏省苏州市",
"861867704", "广西防城港市",
"861303991", "黑龙江省大兴安岭地区",
"861301692", "江苏省连云港市",
"86138526", "江苏省泰州市",
"861807581", "湖南省永州市",
"861823365", "河北省沧州市",
"861362032", "广东省佛山市",
"861571072", "广东省广州市",
"861377923", "新疆巴音郭楞蒙古自治州",
"861521464", "黑龙江省七台河市",
"861565020", "山东省临沂市",
"861836130", "江苏省扬州市",
"86151935", "甘肃省金昌市",
"861890454", "黑龙江省佳木斯市",
"861881551", "安徽省合肥市",
"861315588", "江西省抚州市",
"86136223", "广东省深圳市",
"861554554", "黑龙江省哈尔滨市",
"861329915", "陕西省安康市",
"86157127", "山东省青岛市",
"861321349", "河南省濮阳市",
"861863848", "河南省洛阳市",
"861357547", "浙江省杭州市",
"861351496", "安徽省合肥市",
"86152999", "新疆石河子市",
"861505468", "山东省菏泽市",
"86157021", "上海市",
"861534304", "湖南省衡阳市",
"861815837", "浙江省金华市",
"861340310", "河北省邯郸市",
"861319756", "广西百色市",
"861881465", "黑龙江省黑河市",
"861308425", "河南省漯河市",
"861819132", "陕西省西安市",
"861388698", "湖北省武汉市",
"861312530", "江西省上饶市",
"861383449", "山西省忻州市",
"861857705", "广西防城港市",
"861479471", "内蒙古呼和浩特市",
"861822898", "四川省泸州市",
"861897202", "湖北省宜昌市",
"861577149", "内蒙古锡林郭勒盟",
"861390677", "浙江省温州市",
"861882967", "陕西省宝鸡市",
"861527059", "江西省九江市",
"861816871", "江苏省苏州市",
"86189125", "江苏省盐城市",
"861338338", "河北省衡水市",
"86189700", "江西省南昌市",
"861570474", "内蒙古乌兰察布市",
"861396554", "安徽省马鞍山市",
"861859392", "广西桂林市",
"861313000", "辽宁省大连市",
"861809705", "青海省海东地区",
"861330644", "山东省济南市",
"861786501", "山东省菏泽市",
"861450529", "吉林省辽源市",
"861780636", "山东省潍坊市",
"861508345", "河南省信阳市",
"861843290", "河北省邯郸市",
"86184498", "新疆乌鲁木齐市",
"861583329", "河北省邢台市",
"861571414", "辽宁省本溪市",
"861530510", "江苏省盐城市",
"861772194", "四川省南充市",
"861769909", "新疆博尔塔拉蒙古自治州",
"86152466", "黑龙江省哈尔滨市",
"861763339", "河北省邯郸市",
"861705173", "云南省昆明市",
"861510376", "河南省信阳市",
"861309547", "安徽省淮南市",
"861871873", "广东省佛山市",
"861338407", "河南省南阳市",
"861317166", "河北省张家口市",
"861564226", "辽宁省朝阳市",
"861472712", "浙江省杭州市",
"861313577", "湖北省荆州市",
"861810739", "湖南省邵阳市",
"861316956", "广东省惠州市",
"861345366", "山西省临汾市",
"861864737", "内蒙古呼和浩特市",
"861524212", "辽宁省鞍山市",
"861890530", "山东省菏泽市",
"861354839", "四川省阿坝藏族羌族自治州",
"861317086", "江西省南昌市",
"861887841", "广西柳州市",
"861365549", "山东省临沂市",
"861338379", "河南省洛阳市",
"861861759", "河北省邯郸市",
"861326396", "江西省吉安市",
"861351857", "贵州省毕节地区",
"861778023", "四川省德阳市",
"861573398", "河北省唐山市",
"861810778", "广西河池市",
"861870751", "广东省韶关市",
"86185487", "内蒙古鄂尔多斯市",
"861563924", "河南省鹤壁市",
"861537618", "山东省济南市",
"86147349", "广东省广州市",
"861317737", "湖北省鄂州市",
"86152679", "浙江省金华市",
"861520612", "江苏省常州市",
"861333946", "黑龙江省黑河市",
"86157275", "江西省宜春市",
"861355805", "广西玉林市",
"861312454", "黑龙江省佳木斯市",
"86183833", "四川省乐山市",
"861831487", "浙江省杭州市",
"861813630", "江苏省宿迁市",
"861394840", "内蒙古呼伦贝尔市",
"86188869", "贵州省黔西南布依族苗族自治州",
"861875099", "福建省南平市",
"861815443", "湖北省武汉市",
"861850549", "山东省临沂市",
"86138502", "福建省莆田市",
"861591711", "广东省茂名市",
"861551613", "河南省濮阳市",
"861554273", "辽宁省鞍山市",
"861771343", "四川省自贡市",
"861458909", "广东省韶关市",
"861869933", "新疆石河子市",
"861330154", "江苏省苏州市",
"861832985", "陕西省榆林市",
"861385222", "江苏省徐州市",
"861528540", "贵州省铜仁地区",
"861708190", "福建省厦门市",
"861572865", "广东省中山市",
"861304499", "江西省萍乡市",
"861539236", "福建省龙岩市",
"861585288", "江苏省扬州市",
"86189277", "广东省佛山市",
"861860805", "四川省资阳市",
"861862602", "江苏省徐州市",
"861801285", "江苏省南通市",
"86147005", "北京市",
"861340947", "河南省平顶山市",
"861318311", "河南省新乡市",
"861590771", "广西南宁市",
"86181558", "安徽省阜阳市",
"861893306", "广东省潮州市",
"861301376", "江苏省苏州市",
"861358244", "河北省张家口市",
"861586635", "山东省烟台市",
"861354227", "广东省韶关市",
"861380732", "湖南省湘潭市",
"861328582", "浙江省湖州市",
"861535290", "青海省西宁市",
"86145028", "内蒙古呼和浩特市",
"861880156", "江苏省苏州市",
"86150071", "湖北省武汉市",
"861300795", "宁夏固原市",
"861899936", "新疆昌吉回族自治州",
"861831600", "广东省云浮市",
"861760788", "广西南宁市",
"861857472", "湖南省衡阳市",
"861517700", "广西北海市",
"861325565", "山东省威海市",
"861373490", "四川省眉山市",
"861354338", "广东省茂名市",
"86150177", "广东省佛山市",
"861396642", "安徽省安庆市",
"861342666", "江西省鹰潭市",
"861330552", "安徽省蚌埠市",
"861521243", "安徽省合肥市",
"861590745", "湖南省怀化市",
"861826634", "山东省莱芜市",
"861813388", "河北省张家口市",
"861804141", "辽宁省本溪市",
"861809014", "四川省甘孜藏族自治州",
"861528528", "贵州省黔东南苗族侗族自治州",
"861327558", "安徽省阜阳市",
"861573899", "河南省平顶山市",
"861337569", "山东省临沂市",
"861577103", "湖北省武汉市",
"861323759", "江西省萍乡市",
"861350627", "江苏省南通市",
"861470907", "新疆博尔塔拉蒙古自治州",
"861338878", "云南省楚雄彝族自治州",
"861341119", "广东省广州市",
"861314198", "江苏省泰州市",
"861813442", "河南省洛阳市",
"861310025", "湖南省长沙市",
"861477391", "湖南省邵阳市",
"861809472", "浙江省湖州市",
"861558304", "四川省南充市",
"861383403", "山西省阳泉市",
"861390959", "宁夏银川市",
"86157559", "安徽省黄山市",
"861787831", "广西梧州市",
"861332816", "江苏省常州市",
"861705252", "天津市",
"861596407", "山东省滨州市",
"861587190", "湖北省武汉市",
"861567821", "广西来宾市",
"861368851", "贵州省贵阳市",
"861847903", "江西省上饶市",
"861520584", "浙江省宁波市",
"861865627", "安徽省蚌埠市",
"861596338", "山东省德州市",
"861347444", "陕西省榆林市",
"861840495", "山西省长治市",
"861770417", "辽宁省营口市",
"86188917", "陕西省宝鸡市",
"861880585", "浙江省绍兴市",
"861534096", "山西省运城市",
"861337524", "江苏省盐城市",
"861879425", "甘肃省定西市",
"861536395", "广东省珠海市",
"861452426", "辽宁省锦州市",
"861370050", "山西省太原市",
"861538554", "安徽省淮南市",
"861874569", "黑龙江省哈尔滨市",
"861342411", "广东省广州市",
"861348039", "广东省汕尾市",
"861803296", "河北省邢台市",
"861830353", "山西省阳泉市",
"861550721", "湖北省荆州市",
"861809629", "四川省自贡市",
"861353485", "广东省茂名市",
"861346972", "湖北省恩施土家族苗族自治州",
"861305844", "广东省揭阳市",
"86185272", "湖北省恩施土家族苗族自治州",
"861816845", "江苏省徐州市",
"86136719", "上海市",
"861880646", "山东省潍坊市",
"861894163", "辽宁省沈阳市",
"861363104", "广东省潮州市",
"861553635", "山西省晋中市",
"861520908", "新疆克孜勒苏柯尔克孜自治州",
"861815229", "甘肃省庆阳市",
"861478527", "贵州省铜仁地区",
"861367435", "吉林省通化市",
"861863349", "河北省石家庄市",
"861815409", "安徽省六安市",
"861321848", "江苏省南京市",
"861458943", "广东省清远市",
"861850503", "福建省龙岩市",
"861368713", "湖北省黄冈市",
"86153195", "陕西省延安市",
"861336467", "吉林省松原市",
"861513523", "山西省大同市",
"86182755", "贵州省遵义市",
"861326004", "内蒙古呼和浩特市",
"86188470", "内蒙古呼伦贝尔市",
"861582910", "陕西省西安市",
"86183376", "河南省信阳市",
"86183887", "云南省昭通市",
"861338680", "辽宁省盘锦市",
"86189482", "广东省惠州市",
"861338839", "四川省宜宾市",
"861815264", "湖南省岳阳市",
"861830567", "安徽省亳州市",
"861773753", "河南省周口市",
"861857629", "广东省潮州市",
"861356223", "山东省枣庄市",
"861538430", "广东省阳江市",
"861331030", "内蒙古鄂尔多斯市",
"861320650", "黑龙江省齐齐哈尔市",
"861862918", "陕西省榆林市",
"861539916", "陕西省汉中市",
"861812718", "广东省云浮市",
"861475735", "浙江省嘉兴市",
"861340445", "吉林省松原市",
"861367148", "广东省湛江市",
"861383994", "河南省驻马店市",
"861855550", "安徽省合肥市",
"86138790", "江西省新余市",
"861866450", "广东省广州市",
"861330525", "江苏省扬州市",
"861351740", "湖南省长沙市",
"861319276", "广东省清远市",
"861887584", "浙江省温州市",
"861806227", "湖北省黄石市",
"861520875", "云南省保山市",
"861554811", "内蒙古包头市",
"86184322", "河北省承德市",
"861399953", "新疆石河子市",
"86132189", "江苏省扬州市",
"861535589", "浙江省金华市",
"861593296", "江西省抚州市",
"861317024", "安徽省安庆市",
"861311454", "黑龙江省佳木斯市",
"861392258", "广东省韶关市",
"861586458", "山东省潍坊市",
"861824071", "河南省周口市",
"861580413", "辽宁省抚顺市",
"861521815", "广东省阳江市",
"861880874", "云南省曲靖市",
"86182391", "河南省焦作市",
"861707533", "山东省烟台市",
"861356141", "山东省潍坊市",
"861504083", "辽宁省抚顺市",
"861595982", "福建省三明市",
"861301010", "北京市",
"861804882", "四川省南充市",
"86189071", "湖北省武汉市",
"861879452", "甘肃省临夏回族自治州",
"86137931", "山东省济南市",
"86436", "吉林省白城市",
"861597744", "广西桂林市",
"861831985", "广东省惠州市",
"861760949", "甘肃省白银市",
"861896692", "陕西省西安市",
"86177507", "福建省泉州市",
"861360550", "安徽省滁州市",
"861571865", "贵州省黔东南苗族侗族自治州",
"861810617", "江苏省无锡市",
"861836205", "江苏省南京市",
"86187396", "河南省驻马店市",
"861308819", "四川省南充市",
"861775272", "湖南省常德市",
"861861327", "四川省资阳市",
"861772343", "四川省广元市",
"861378597", "河北省邢台市",
"86153388", "广东省深圳市",
"861579716", "湖北省随州市",
"861518339", "四川省乐山市",
"861317069", "云南省德宏傣族景颇族自治州",
"861811677", "四川省广元市",
"861705225", "浙江省杭州市",
"861893517", "山西省吕梁市",
"861813866", "广东省江门市",
"86186765", "广东省佛山市",
"861863901", "河南省郑州市",
"861310052", "广西柳州市",
"861800745", "湖南省怀化市",
"861308130", "辽宁省抚顺市",
"861802285", "广东省广州市",
"861553312", "河北省保定市",
"861317619", "山东省济宁市",
"861330336", "河北省廊坊市",
"86157227", "江苏省常州市",
"86136123", "广东省汕头市",
"861780344", "山西省晋城市",
"86150482", "内蒙古兴安盟",
"861533537", "山东省济宁市",
"861379467", "广东省韶关市",
"86189592", "福建省厦门市",
"861780860", "贵州省毕节地区",
"861572072", "江苏省南通市",
"861317189", "河北省石家庄市",
"861479179", "陕西省咸阳市",
"861452798", "新疆克孜勒苏柯尔克孜自治州",
"861816213", "江西省上饶市",
"86170812", "天津市",
"861373968", "河北省邢台市",
"861301660", "广东省佛山市",
"861311530", "黑龙江省哈尔滨市",
"861871211", "安徽省宿州市",
"861825033", "福建省福州市",
"861810067", "江苏省苏州市",
"861552063", "四川省宜宾市",
"861532570", "浙江省衢州市",
"861590251", "贵州省贵阳市",
"861360434", "吉林省四平市",
"861323918", "陕西省延安市",
"861308927", "吉林省通化市",
"861322820", "四川省成都市",
"861576916", "陕西省汉中市",
"861850665", "广东省汕尾市",
"861363399", "河南省南阳市",
"86131414", "北京市",
"861821898", "广东省湛江市",
"861829368", "甘肃省天水市",
"861527646", "新疆巴音郭楞蒙古自治州",
"861470772", "广西柳州市",
"861586312", "山东省德州市",
"861804223", "浙江省嘉兴市",
"861337671", "广东省湛江市",
"861806379", "福建省龙岩市",
"861471712", "甘肃省武威市",
"861560684", "浙江省宁波市",
"861594994", "山东省枣庄市",
"861594651", "黑龙江省齐齐哈尔市",
"86131271", "山东省济南市",
"86151681", "浙江省宁波市",
"861572414", "广东省茂名市",
"861771194", "西藏林芝地区",
"86186714", "湖北省黄石市",
"861454297", "辽宁省阜新市",
"861380696", "福建省三明市",
"861599705", "青海省海东地区",
"861305581", "福建省泉州市",
"861318470", "河北省邯郸市",
"861888287", "四川省凉山彝族自治州",
"861560512", "江苏省连云港市",
"86150700", "江西省南昌市",
"861323279", "广东省河源市",
"861771592", "江苏省盐城市",
"861459523", "云南省玉溪市",
"861458341", "江西省抚州市",
"861769835", "河南省周口市",
"861515555", "安徽省马鞍山市",
"861365704", "江西省抚州市",
"86157334", "河北省邯郸市",
"861308452", "河北省沧州市",
"861479947", "新疆喀什地区",
"861809597", "新疆昌吉回族自治州",
"86150125", "广东省深圳市",
"861507638", "河北省保定市",
"861815101", "江苏省南京市",
"861869871", "辽宁省大连市",
"861517568", "河北省廊坊市",
"861325649", "山东省滨州市",
"861322848", "四川省乐山市",
"861384983", "河南省三门峡市",
"86138815", "四川省凉山彝族自治州",
"861333077", "四川省南充市",
"861819733", "青海省海东地区",
"861829824", "安徽省马鞍山市",
"861561572", "山东省青岛市",
"861359342", "山西省吕梁市",
"861337645", "山东省烟台市",
"861760903", "新疆和田地区",
"861830951", "宁夏银川市",
"861577475", "内蒙古通辽市",
"861880334", "河北省承德市",
"86137320", "浙江省温州市",
"861806878", "江苏省常州市",
"861459786", "新疆乌鲁木齐市",
"861850704", "江西省南昌市",
"86990", "新疆克拉玛依市",
"861367937", "甘肃省酒泉市",
"861581910", "广东省汕尾市",
"861329100", "江苏省徐州市",
"861860978", "青海省西宁市",
"86183516", "江苏省苏州市",
"861500454", "黑龙江省哈尔滨市",
"86156635", "黑龙江省哈尔滨市",
"861535022", "江西省九江市",
"861580970", "青海省海北藏族自治州",
"861559422", "陕西省榆林市",
"861700383", "河南省信阳市",
"861705772", "山西省太原市",
"861520335", "河北省秦皇岛市",
"86155900", "吉林省长春市",
"861528906", "西藏那曲地区",
"861811959", "安徽省宿州市",
"861559638", "陕西省商洛市",
"861472683", "四川省广安市",
"861515616", "安徽省淮北市",
"861775153", "江苏省盐城市",
"861363898", "西藏拉萨市",
"861562856", "西藏那曲地区",
"861829869", "甘肃省白银市",
"861816933", "湖南省长沙市",
"861773430", "河北省邯郸市",
"861879927", "新疆石河子市",
"861860939", "甘肃省陇南市",
"86139546", "山东省东营市",
"861529948", "新疆乌鲁木齐市",
"861840997", "新疆阿克苏地区",
"861395940", "福建省宁德市",
"86395", "河南省漯河市",
"861898831", "云南省临沧市",
"861770915", "陕西省安康市",
"861858321", "四川省内江市",
"861337723", "广西柳州市",
"861771975", "陕西省渭南市",
"861894890", "广东省河源市",
"861505990", "福建省龙岩市",
"861780792", "江西省九江市",
"861768523", "贵州省安顺市",
"861315493", "陕西省安康市",
"86185948", "重庆市",
"86136097", "广东省广州市",
"861335168", "黑龙江省哈尔滨市",
"861800771", "广西南宁市",
"86183508", "福建省三明市",
"861325159", "黑龙江省大庆市",
"861596905", "云南省德宏傣族景颇族自治州",
"861806110", "江苏省徐州市",
"861343877", "四川省南充市",
"861871931", "广东省佛山市",
"861348767", "湖南省益阳市",
"86150277", "河北省石家庄市",
"86130687", "广东省深圳市",
"861520783", "广西桂林市",
"861835282", "江苏省连云港市",
"861345888", "四川省内江市",
"861331816", "广东省梅州市",
"86156456", "黑龙江省哈尔滨市",
"861551782", "河南省开封市",
"861768037", "湖南省益阳市",
"861589111", "陕西省延安市",
"86182284", "四川省资阳市",
"861451", "北京市",
"861500530", "山东省菏泽市",
"861355939", "福建省莆田市",
"861337586", "浙江省台州市",
"861452484", "内蒙古乌兰察布市",
"861568150", "四川省资阳市",
"861887182", "湖北省恩施土家族苗族自治州",
"861354905", "西藏昌都地区",
"861457056", "新疆伊犁哈萨克自治州",
"861593560", "山西省晋城市",
"861341411", "广东省广州市",
"861339765", "湖南省怀化市",
"861356175", "山东省泰安市",
"861323327", "山西省晋城市",
"861324770", "江西省南昌市",
"861477993", "江西省赣州市",
"861330876", "云南省文山壮族苗族自治州",
"861807543", "安徽省亳州市",
"861342830", "广东省汕头市",
"861520526", "江苏省泰州市",
"861308318", "安徽省安庆市",
"861374012", "北京市",
"861301198", "河北省沧州市",
"861871880", "广东省湛江市",
"861768397", "湖北省恩施土家族苗族自治州",
"861362543", "山东省滨州市",
"861705180", "北京市",
"861860631", "山东省威海市",
"861338242", "江苏省无锡市",
"86176951", "宁夏银川市",
"86137421", "广东省广州市",
"86156263", "广东省阳江市",
"861330304", "河北省石家庄市",
"86188568", "安徽省阜阳市",
"861855226", "江苏省南京市",
"86153144", "山东省潍坊市",
"861770350", "山西省忻州市",
"861705610", "江苏省南京市",
"861760675", "浙江省绍兴市",
"861309522", "云南省临沧市",
"861802120", "江苏省镇江市",
"861870257", "江西省抚州市",
"861572892", "西藏日喀则地区",
"861350554", "安徽省淮南市",
"861376792", "江西省景德镇市",
"861325194", "浙江省嘉兴市",
"86130535", "山东省烟台市",
"861805412", "甘肃省酒泉市",
"861570695", "云南省玉溪市",
"861508605", "贵州省遵义市",
"86181859", "贵州省黔西南布依族苗族自治州",
"861379575", "四川省遂宁市",
"861537813", "四川省乐山市",
"861474127", "辽宁省抚顺市",
"861870068", "陕西省铜川市",
"86137018", "上海市",
"861774948", "河南省商丘市",
"861478144", "四川省广元市",
"861538302", "河北省保定市",
"861479955", "新疆喀什地区",
"86132066", "黑龙江省哈尔滨市",
"861816740", "新疆巴音郭楞蒙古自治州",
"861450974", "新疆哈密地区",
"861837012", "江西省九江市",
"861589989", "广东省深圳市",
"861883530", "山西省阳泉市",
"861812449", "广东省惠州市",
"861334510", "山东省济南市",
"861323593", "福建省宁德市",
"861700016", "广东省广州市",
"861530244", "广东省佛山市",
"861515547", "安徽省宿州市",
"861532784", "湖北省武汉市",
"86183721", "湖北省武汉市",
"861827983", "江西省吉安市",
"861336884", "云南省昆明市",
"861538627", "湖南省怀化市",
"861550878", "云南省楚雄彝族自治州",
"861337657", "广东省肇庆市",
"86151477", "内蒙古鄂尔多斯市",
"861563538", "山西省太原市",
"861811141", "四川省凉山彝族自治州",
"861867376", "湖南省常德市",
"861369790", "江西省赣州市",
"861357522", "湖南省常德市",
"861558552", "吉林省白城市",
"861839742", "湖南省衡阳市",
"861302804", "山西省大同市",
"861361744", "湖南省张家界市",
"861364626", "江苏省南通市",
"861783528", "山西省吕梁市",
"861824268", "辽宁省营口市",
"861880094", "四川省遂宁市",
"861550680", "广西南宁市",
"861539161", "湖北省黄冈市",
"86147686", "山东省潍坊市",
"861831237", "广东省河源市",
"861535976", "福建省福州市",
"86152847", "四川省巴中市",
"861340922", "河南省新乡市",
"861824891", "江苏省淮安市",
"861332390", "河南省平顶山市",
"861865273", "江苏省镇江市",
"861453676", "陕西省延安市",
"861350430", "吉林省长春市",
"861520095", "湖南省永州市",
"861859365", "福建省莆田市",
"861824057", "河南省南阳市",
"861700666", "山东省聊城市",
"86155399", "河南省南阳市",
"861554280", "辽宁省丹东市",
"861590329", "河北省邢台市",
"861389715", "青海省果洛藏族自治州",
"861820668", "广东省茂名市",
"861567778", "广西钦州市",
"861591658", "广东省佛山市",
"861831328", "云南省普洱市",
"861839401", "甘肃省兰州市",
"861896549", "福建省南平市",
"861550839", "四川省广元市",
"861353915", "广东省梅州市",
"861378800", "广西防城港市",
"86137006", "云南省昆明市",
"861801435", "江苏省南通市",
"861888215", "四川省眉山市",
"86156587", "浙江省温州市",
"861354673", "山西省晋中市",
"861862488", "河南省安阳市",
"861377259", "陕西省咸阳市",
"86151910", "陕西省西安市",
"861370262", "广东省佛山市",
"861899493", "江苏省徐州市",
"861847812", "湖南省常德市",
"861523561", "山西省晋城市",
"861870618", "江苏省无锡市",
"861822693", "安徽省芜湖市",
"861338721", "湖北省襄樊市",
"861811651", "四川省攀枝花市",
"861339636", "山东省潍坊市",
"861390449", "吉林省白山市",
"861374662", "黑龙江省绥化市",
"861700411", "辽宁省大连市",
"861811994", "安徽省马鞍山市",
"861337147", "山东省聊城市",
"861813952", "新疆伊犁哈萨克自治州",
"861313814", "广东省珠海市",
"86180119", "广东省广州市",
"861397174", "湖北省黄冈市",
"861590840", "四川省遂宁市",
"86181946", "青海省海东地区",
"861705060", "江苏省苏州市",
"861587531", "广东省广州市",
"861775901", "福建省莆田市",
"861580708", "江西省景德镇市",
"861572760", "江西省吉安市",
"86130609", "广东省广州市",
"861558644", "湖北省十堰市",
"861819928", "新疆昌吉回族自治州",
"86180355", "山西省长治市",
"861376344", "黑龙江省哈尔滨市",
"861317911", "吉林省长春市",
"86137493", "河南省新乡市",
"861831829", "广东省茂名市",
"861840674", "广西玉林市",
"861306292", "江苏省镇江市",
"861450195", "山西省朔州市",
"861576469", "黑龙江省鹤岗市",
"861590828", "四川省达州市",
"861867836", "山东省德州市",
"861869496", "江苏省常州市",
"861534552", "安徽省蚌埠市",
"861329485", "内蒙古通辽市",
"861874979", "河南省焦作市",
"86145043", "辽宁省大连市",
"861550407", "辽宁省营口市",
"861390882", "云南省德宏傣族景颇族自治州",
"861800757", "广东省佛山市",
"861554302", "吉林省吉林市",
"861321643", "浙江省丽水市",
"861813427", "河北省沧州市",
"861343851", "四川省自贡市",
"861860700", "江西省南昌市",
"861356959", "河南省平顶山市",
"86186307", "河北省沧州市",
"861566676", "山东省泰安市",
"86183793", "江西省上饶市",
"861760151", "江苏省无锡市",
"861524140", "辽宁省本溪市",
"86147880", "云南省西双版纳傣族自治州",
"861893646", "江苏省扬州市",
"86184441", "吉林省松原市",
"861361392", "河南省鹤壁市",
"861369862", "山东省济南市",
"861831340", "云南省玉溪市",
"861350642", "山东省青岛市",
"861839394", "甘肃省武威市",
"861363354", "山西省晋中市",
"86151282", "河北省保定市",
"86131672", "上海市",
"861340457", "吉林省松原市",
"861831864", "广东省清远市",
"861599921", "新疆阿克苏地区",
"861354242", "广东省云浮市",
"86182490", "黑龙江省哈尔滨市",
"861572926", "河南省濮阳市",
"86182617", "江苏省苏州市",
"861355700", "广西防城港市",
"861815953", "福建省漳州市",
"861337979", "新疆乌鲁木齐市",
"861591937", "广东省惠州市",
"861396302", "山东省聊城市",
"861810546", "山东省东营市",
"861708531", "山东省济南市",
"861321725", "湖北省黄冈市",
"861865152", "江苏省盐城市",
"861831917", "广东省茂名市",
"861324908", "广东省深圳市",
"861840462", "黑龙江省七台河市",
"861783540", "山西省晋中市",
"861333897", "江苏省徐州市",
"861776133", "四川省成都市",
"861316041", "江苏省扬州市",
"861365736", "湖南省常德市",
"861893585", "新疆伊犁哈萨克自治州",
"861787605", "广东省肇庆市",
"861321153", "广西桂林市",
"86159791", "江西省南昌市",
"861338673", "辽宁省葫芦岛市",
"861869091", "新疆博尔塔拉蒙古自治州",
"861816728", "浙江省温州市",
"861333051", "云南省昆明市",
"861470610", "江苏省镇江市",
"861309169", "黑龙江省大庆市",
"86178532", "山东省青岛市",
"861803413", "河北省张家口市",
"861571508", "福建省莆田市",
"861320932", "甘肃省定西市",
"861337938", "陕西省宝鸡市",
"861511890", "广东省揭阳市",
"861354721", "四川省乐山市",
"86156533", "山东省淄博市",
"86188238", "广东省深圳市",
"861830977", "青海省海西蒙古族藏族自治州",
"861811175", "四川省阿坝藏族羌族自治州",
"861870902", "新疆哈密地区",
"861808992", "西藏日喀则地区",
"861850736", "湖南省常德市",
"861550379", "河南省洛阳市",
"861760641", "山东省济南市",
"861346562", "山东省烟台市",
"861363078", "吉林省松原市",
"861774920", "陕西省榆林市",
"861351933", "甘肃省平凉市",
"861880306", "河北省廊坊市",
"861350152", "广东省广州市",
"861325592", "河南省郑州市",
"861591120", "云南省大理白族自治州",
"861857800", "广东省江门市",
"861300762", "河南省郑州市",
"861516535", "山东省烟台市",
"861506665", "山东省济南市",
"861596721", "浙江省湖州市",
"861330491", "辽宁省朝阳市",
"861802148", "江苏省镇江市",
"861556623", "辽宁省沈阳市",
"861559945", "贵州省黔东南苗族侗族自治州",
"861502596", "甘肃省陇南市",
"861303558", "贵州省安顺市",
"86908", "新疆克孜勒苏柯尔克孜自治州",
"861863609", "山西省晋中市",
"861508729", "云南省大理白族自治州",
"861861593", "山东省烟台市",
"861551319", "山西省忻州市",
"861528934", "陕西省西安市",
"861352331", "河南省安阳市",
"861316862", "广东省惠州市",
"86187357", "山西省临汾市",
"861478393", "河南省濮阳市",
"861310596", "福建省宁德市",
"861519676", "四川省南充市",
"861568823", "湖南省邵阳市",
"861367853", "贵州省安顺市",
"861878616", "贵州省遵义市",
"861503646", "河南省三门峡市",
"861534525", "江苏省扬州市",
"861808884", "广东省中山市",
"861539469", "江苏省盐城市",
"861870777", "广西钦州市",
"861377738", "浙江省杭州市",
"861779932", "新疆乌鲁木齐市",
"86170724", "辽宁省沈阳市",
"861324875", "浙江省温州市",
"86138636", "山东省潍坊市",
"861350811", "四川省绵阳市",
"861339860", "河北省保定市",
"86182580", "浙江省绍兴市",
"861552170", "广东省广州市",
"861331390", "福建省南平市",
"861339344", "山西省晋中市",
"861707042", "浙江省湖州市",
"861452867", "青海省海西蒙古族藏族自治州",
"861884558", "黑龙江省哈尔滨市",
"861882492", "广东省广州市",
"861800828", "四川省德阳市",
"861390141", "江苏省盐城市",
"86159355", "山西省长治市",
"861866928", "云南省德宏傣族景颇族自治州",
"861774801", "四川省广安市",
"861567187", "湖北省恩施土家族苗族自治州",
"861861488", "内蒙古巴彦淖尔市",
"86137583", "浙江省嘉兴市",
"861830702", "江西省九江市",
"86151425", "辽宁省沈阳市",
"861700830", "江苏省南通市",
"861834738", "内蒙古通辽市",
"861857921", "江西省九江市",
"861315936", "福建省三明市",
"861586920", "浙江省丽水市",
"861359918", "福建省宁德市",
"86151065", "山东省烟台市",
"861876394", "山东省德州市",
"861365692", "福建省龙岩市",
"861812651", "广东省深圳市",
"861539204", "福建省厦门市",
"86186822", "广东省深圳市",
"861369446", "吉林省白城市",
"861847675", "广东省汕尾市",
"86145310", "浙江省杭州市",
"861894795", "内蒙古呼和浩特市",
"861457194", "浙江省绍兴市",
"861590757", "广东省佛山市",
"861594718", "内蒙古包头市",
"86156163", "湖南省株洲市",
"861567258", "湖北省荆州市",
"86137267", "广东省广州市",
"861776732", "浙江省宁波市",
"861801120", "四川省内江市",
"861388160", "四川省雅安市",
"86188371", "河南省郑州市",
"861306048", "陕西省宝鸡市",
"861598992", "广东省东莞市",
"861361543", "山东省滨州市",
"86185991", "新疆乌鲁木齐市",
"861532960", "贵州省贵阳市",
"861308942", "吉林省长春市",
"86136692", "陕西省西安市",
"861821136", "广东省汕尾市",
"861596098", "福建省南平市",
"861770485", "内蒙古鄂尔多斯市",
"861898729", "云南省昆明市",
"861872639", "安徽省合肥市",
"861567067", "河南省南阳市",
"86138455", "黑龙江省绥化市",
"861760812", "四川省攀枝花市",
"861534336", "湖南省常德市",
"861323794", "江西省抚州市",
"861888809", "江苏省徐州市",
"86132770", "湖北省武汉市",
"861865125", "江苏省连云港市",
"861887250", "湖北省宜昌市",
"861536035", "广东省云浮市",
"861479457", "黑龙江省大兴安岭地区",
"861569535", "青海省果洛藏族自治州",
"861532583", "浙江省嘉兴市",
"861834779", "内蒙古通辽市",
"861321752", "广东省惠州市",
"861840846", "宁夏固原市",
"861811449", "江苏省南京市",
"861390651", "浙江省杭州市",
"861325808", "山东省潍坊市",
"861350753", "福建省龙岩市",
"861322609", "广东省中山市",
"861393133", "河北省张家口市",
"861555619", "安徽省蚌埠市",
"861390994", "新疆昌吉回族自治州",
"861589720", "青海省海北藏族自治州",
"861399409", "山西省忻州市",
"861816857", "江苏省苏州市",
"861336541", "山东省济南市",
"861555189", "安徽省阜阳市",
"861476275", "江苏省苏州市",
"861313465", "山西省长治市",
"86187773", "广西桂林市",
"861787563", "广东省东莞市",
"861341981", "河南省三门峡市",
"861835150", "江苏省无锡市",
"861354098", "四川省泸州市",
"861898764", "云南省文山壮族苗族自治州",
"861537271", "浙江省衢州市",
"861827381", "湖南省娄底市",
"86151014", "甘肃省白银市",
"86835", "四川省雅安市",
"861362744", "湖南省张家界市",
"86180791", "江西省南昌市",
"861500944", "甘肃省金昌市",
"861822078", "陕西省汉中市",
"861817684", "广西钦州市",
"861367711", "湖北省鄂州市",
"861313551", "安徽省合肥市",
"861833847", "河南省濮阳市",
"861300163", "山东省威海市",
"861869728", "青海省海东地区",
"861309461", "浙江省绍兴市",
"86182348", "山西省吕梁市",
"861476241", "江苏省淮安市",
"861860568", "安徽省阜阳市",
"861523679", "河南省焦作市",
"861453844", "四川省巴中市",
"861535047", "江西省上饶市",
"861472670", "四川省泸州市",
"861575776", "浙江省温州市",
"861322725", "湖北省宜昌市",
"861869740", "内蒙古包头市",
"861587018", "贵州省铜仁地区",
"861339792", "江西省九江市",
"86177774", "广西梧州市",
"861842029", "广东省湛江市",
"86130165", "江苏省盐城市",
"861336575", "安徽省安庆市",
"861847151", "湖北省恩施土家族苗族自治州",
"861525249", "江苏省南京市",
"861309555", "安徽省马鞍山市",
"861512890", "河北省邯郸市",
"861804677", "江西省赣州市",
"861801217", "江苏省连云港市",
"86137537", "山西省临汾市",
"861589748", "湖南省永州市",
"861812175", "江苏省徐州市",
"861537245", "浙江省舟山市",
"861508357", "江西省赣州市",
"861364512", "江苏省连云港市",
"861886824", "浙江省湖州市",
"861572508", "山东省滨州市",
"861357616", "江西省宜春市",
"861343514", "广东省韶关市",
"861580560", "安徽省合肥市",
"861830475", "内蒙古通辽市",
"861473637", "广西梧州市",
"861458601", "湖北省恩施土家族苗族自治州",
"861378921", "湖南省永州市",
"861876742", "浙江省台州市",
"861309186", "黑龙江省哈尔滨市",
"861825144", "江苏省盐城市",
"861558525", "贵州省黔东南苗族侗族自治州",
"861345113", "湖北省武汉市",
"861395132", "江苏省南通市",
"861518633", "贵州省六盘水市",
"861508563", "贵州省遵义市",
"861780765", "广东省深圳市",
"861384970", "河南省南阳市",
"861309616", "四川省资阳市",
"861366468", "黑龙江省鹤岗市",
"861324335", "河南省许昌市",
"861819506", "宁夏固原市",
"861359327", "山西省长治市",
"861892260", "广东省清远市",
"861563661", "黑龙江省绥化市",
"861304454", "福建省泉州市",
"861325309", "河南省濮阳市",
"861351331", "河北省石家庄市",
"861839143", "陕西省渭南市",
"861595412", "山东省济南市",
"861508980", "广东省江门市",
"861533314", "河北省承德市",
"861326787", "广东省湛江市",
"861899588", "湖北省宜昌市",
"861777206", "广西钦州市",
"86183809", "四川省泸州市",
"861479922", "新疆阿克苏地区",
"861318483", "广东省揭阳市",
"861337305", "河北省唐山市",
"861835628", "安徽省铜陵市",
"861890499", "辽宁省辽阳市",
"86185923", "陕西省渭南市",
"861311944", "甘肃省兰州市",
"861319990", "新疆克拉玛依市",
"861531498", "浙江省金华市",
"861338098", "广东省江门市",
"861324783", "江西省上饶市",
"861899904", "新疆吐鲁番地区",
"861571760", "河北省石家庄市",
"861398035", "四川省攀枝花市",
"861554599", "黑龙江省哈尔滨市",
"861323342", "山西省大同市",
"86156610", "内蒙古呼和浩特市",
"861329350", "山西省忻州市",
"86152253", "河南省信阳市",
"861340955", "宁夏中卫市",
"86158824", "四川省成都市",
"86159119", "云南省曲靖市",
"86186646", "广东省广州市",
"861800364", "黑龙江省哈尔滨市",
"86185556", "安徽省安庆市",
"861847641", "广东省茂名市",
"861309066", "内蒙古锡林郭勒盟",
"861381442", "江苏省徐州市",
"861820531", "山东省济南市",
"861336992", "新疆伊犁哈萨克自治州",
"861811403", "江苏省南京市",
"861866940", "山东省青岛市",
"861518196", "四川省泸州市",
"86152300", "河北省邯郸市",
"861362392", "河南省鹤壁市",
"861534876", "云南省文山壮族苗族自治州",
"861572984", "四川省自贡市",
"861520770", "广西北海市",
"86151182", "广东省东莞市",
"861867660", "广东省云浮市",
"861351845", "四川省宜宾市",
"861523422", "山西省大同市",
"861888843", "广西桂林市",
"861853869", "河南省平顶山市",
"861813925", "新疆石河子市",
"861308591", "甘肃省临夏回族自治州",
"861846961", "云南省临沧市",
"861329987", "青海省海西蒙古族藏族自治州",
"861396599", "安徽省滁州市",
"861550905", "新疆和田地区",
"861558336", "四川省达州市",
"861368877", "云南省丽江市",
"861361509", "福建省漳州市",
"861598541", "贵州省黔南布依族苗族自治州",
"861839653", "福建省福州市",
"861380044", "吉林省通化市",
"861800329", "河北省邢台市",
"861304530", "黑龙江省牡丹江市",
"861760459", "黑龙江省大庆市",
"861887095", "江西省宜春市",
"861506549", "山东省临沂市",
"86180723", "浙江省金华市",
"861571926", "陕西省汉中市",
"861521710", "广东省东莞市",
"861452234", "浙江省杭州市",
"861323488", "内蒙古巴彦淖尔市",
"86135873", "浙江省绍兴市",
"861592937", "陕西省咸阳市",
"861889346", "甘肃省兰州市",
"861807032", "江西省上饶市",
"861593538", "山西省阳泉市",
"861708427", "云南省普洱市",
"861321156", "广西玉林市",
"861326699", "广东省深圳市",
"861868357", "四川省成都市",
"861331777", "广西钦州市",
"861803416", "河北省廊坊市",
"861760934", "甘肃省庆阳市",
"861315871", "四川省巴中市",
"861589299", "四川省达州市",
"861372659", "广东省韶关市",
"86133351", "山东省济南市",
"86188453", "黑龙江省牡丹江市",
"861507010", "江西省鹰潭市",
"861342868", "广东省深圳市",
"861310488", "广东省广州市",
"861399790", "湖北省荆门市",
"861870390", "河南省焦作市",
"861508589", "贵州省黔西南布依族苗族自治州",
"861533595", "湖北省咸宁市",
"86151000", "河北省邯郸市",
"861853402", "山西省朔州市",
"861774697", "河南省驻马店市",
"861510422", "辽宁省朝阳市",
"86137916", "山东省潍坊市",
"86183475", "内蒙古通辽市",
"861323260", "广东省河源市",
"861318469", "江西省吉安市",
"861510638", "山东省烟台市",
"861528641", "贵州省铜仁地区",
"861500568", "安徽省阜阳市",
"861390406", "辽宁省锦州市",
"861812001", "江苏省无锡市",
"861365733", "湖南省株洲市",
"861853222", "河北省保定市",
"861776136", "四川省成都市",
"861529195", "陕西省铜川市",
"86158190", "广东省汕尾市",
"861709545", "江苏省苏州市",
"861335130", "黑龙江省哈尔滨市",
"861586082", "福建省福州市",
"861816588", "广东省云浮市",
"861886741", "湖南省长沙市",
"8614758", "广东省广州市",
"86132911", "江苏省苏州市",
"861556626", "辽宁省鞍山市",
"861452832", "四川省内江市",
"86138084", "湖南省长沙市",
"861502593", "甘肃省平凉市",
"86139248", "广东省佛山市",
"861354581", "湖北省荆州市",
"861801962", "江苏省盐城市",
"861580969", "宁夏固原市",
"861306108", "山东省聊城市",
"86158628", "江苏省南通市",
"861813531", "山西省吕梁市",
"861861596", "山东省烟台市",
"861450635", "黑龙江省绥化市",
"86132968", "浙江省宁波市",
"861850733", "湖南省株洲市",
"861890631", "山东省威海市",
"861332618", "浙江省湖州市",
"861773468", "陕西省渭南市",
"861335819", "江苏省常州市",
"861868563", "贵州省遵义市",
"861351936", "甘肃省张掖市",
"86152789", "广西北海市",
"861588988", "广东省中山市",
"861314447", "广东省汕尾市",
"861880303", "河北省张家口市",
"86159263", "湖北省武汉市",
"861559010", "吉林省松原市",
"861318424", "浙江省杭州市",
"861310342", "山西省大同市",
"861327815", "吉林省通化市",
"86183206", "广东省茂名市",
"861535410", "河北省邯郸市",
"861372149", "河南省焦作市",
"861530611", "江苏省常州市",
"861328747", "山东省潍坊市",
"861360449", "吉林省白山市",
"861817771", "广西南宁市",
"861322059", "山东省济南市",
"861321646", "浙江省绍兴市",
"861390001", "辽宁省沈阳市",
"861361900", "四川省内江市",
"861324724", "湖北省咸宁市",
"861332068", "四川省资阳市",
"861560364", "黑龙江省哈尔滨市",
"86150646", "山东省潍坊市",
"86183261", "安徽省合肥市",
"861301957", "内蒙古鄂尔多斯市",
"86180497", "上海市",
"861332257", "西藏阿里地区",
"861880848", "四川省巴中市",
"861364771", "广西南宁市",
"861811284", "江苏省镇江市",
"86159587", "浙江省温州市",
"86180610", "江苏省泰州市",
"861829688", "江西省赣州市",
"861816904", "宁夏石嘴山市",
"861528151", "四川省阿坝藏族羌族自治州",
"861867833", "山东省滨州市",
"86145304", "天津市",
"861533972", "甘肃省定西市",
"861869493", "江苏省苏州市",
"86131658", "浙江省温州市",
"861572923", "河南省商丘市",
"861334758", "广西贺州市",
"861573907", "新疆乌鲁木齐市",
"861324769", "广东省广州市",
"861815956", "福建省漳州市",
"861780339", "河北省邢台市",
"861302561", "广东省湛江市",
"861839049", "湖南省郴州市",
"86156723", "湖北省恩施土家族苗族自治州",
"861810543", "山东省滨州市",
"861855449", "山东省烟台市",
"86137908", "广东省汕头市",
"861879168", "陕西省渭南市",
"861889941", "新疆克孜勒苏柯尔克孜自治州",
"861566673", "山东省聊城市",
"861319599", "甘肃省金昌市",
"861893643", "江苏省南通市",
"861776767", "新疆巴音郭楞蒙古自治州",
"861853741", "河南省焦作市",
"861579408", "广东省深圳市",
"861571321", "河北省石家庄市",
"86914", "陕西省商洛市",
"861554990", "湖北省咸宁市",
"86155328", "河北省沧州市",
"861345019", "广东省肇庆市",
"861829247", "陕西省宝鸡市",
"861586529", "山东省济南市",
"861865276", "江苏省扬州市",
"861453673", "陕西省安康市",
"86152314", "河北省承德市",
"861366302", "河南省洛阳市",
"861840935", "甘肃省武威市",
"861300024", "上海市",
"861880349", "山西省朔州市",
"861700663", "山东省烟台市",
"861564959", "河南省驻马店市",
"861843410", "山西省晋城市",
"861355191", "四川省南充市",
"861529974", "新疆博尔塔拉蒙古自治州",
"861320551", "安徽省合肥市",
"861471961", "甘肃省武威市",
"86135925", "河南省郑州市",
"861700797", "江西省赣州市",
"861596676", "山东省临沂市",
"861473662", "云南省大理白族自治州",
"861535973", "福建省福州市",
"86183531", "山东省济南市",
"861335452", "黑龙江省齐齐哈尔市",
"861889975", "广东省广州市",
"861569921", "新疆乌鲁木齐市",
"861338581", "浙江省杭州市",
"861339633", "山东省日照市",
"861362685", "浙江省绍兴市",
"861300069", "广西南宁市",
"861301202", "河北省沧州市",
"861893272", "河北省石家庄市",
"861880820", "四川省眉山市",
"861894911", "安徽省滁州市",
"861373930", "甘肃省临夏回族自治州",
"861586564", "山东省烟台市",
"86130725", "江苏省南京市",
"861360882", "云南省大理白族自治州",
"861311568", "黑龙江省鹤岗市",
"861317070", "云南省曲靖市",
"861306982", "黑龙江省牡丹江市",
"861379300", "山东省菏泽市",
"861890700", "江西省南昌市",
"861310794", "福建省福州市",
"86157049", "内蒙古鄂尔多斯市",
"86150840", "辽宁省鞍山市",
"861817745", "广西贺州市",
"861370415", "辽宁省丹东市",
"86153954", "安徽省淮南市",
"86185875", "广西南宁市",
"861301422", "宁夏吴忠市",
"861807187", "湖北省咸宁市",
"861819015", "四川省遂宁市",
"861780838", "四川省德阳市",
"861325634", "山东省莱芜市",
"861562435", "山东省潍坊市",
"861354676", "山西省忻州市",
"861560828", "四川省广安市",
"861899496", "江苏省宿迁市",
"861818964", "甘肃省张掖市",
"861364745", "湖南省怀化市",
"861315331", "山东省威海市",
"861822696", "安徽省池州市",
"861864070", "辽宁省辽阳市",
"861332902", "安徽省蚌埠市",
"861808282", "新疆和田地区",
"86152365", "河南省安阳市",
"861787589", "广东省东莞市",
"861592962", "陕西省西安市",
"861301679", "江苏省南通市",
"861537816", "四川省雅安市",
"861893609", "江苏省苏州市",
"861355944", "福建省福州市",
"86180808", "四川省成都市",
"861357782", "云南省楚雄彝族自治州",
"861308168", "山东省潍坊市",
"861889592", "云南省保山市",
"861538990", "新疆阿勒泰地区",
"861818817", "贵州省毕节地区",
"861581268", "广东省潮州市",
"861375359", "山西省吕梁市",
"861534931", "甘肃省兰州市",
"861579877", "云南省玉溪市",
"861362546", "山东省东营市",
"861363732", "湖南省湘潭市",
"861300189", "河北省石家庄市",
"861575172", "江苏省盐城市",
"861532524", "浙江省绍兴市",
"861581891", "广东省茂名市",
"86180163", "上海市",
"861335318", "吉林省辽源市",
"861509728", "甘肃省天水市",
"861764064", "辽宁省葫芦岛市",
"861473012", "河北省保定市",
"86156791", "江西省南昌市",
"861860944", "甘肃省兰州市",
"8613816", "上海市",
"86159533", "山东省淄博市",
"861806844", "江苏省苏州市",
"861364623", "江苏省苏州市",
"861315845", "四川省绵阳市",
"861558211", "山西省太原市",
"86155582", "浙江省宁波市",
"861516800", "浙江省丽水市",
"861397285", "湖北省咸宁市",
"861895152", "江苏省宿迁市",
"861814995", "新疆吐鲁番地区",
"861510957", "宁夏银川市",
"861899857", "广东省肇庆市",
"861323596", "福建省漳州市",
"861700013", "北京市",
"861524492", "四川省遂宁市",
"861576598", "黑龙江省大庆市",
"861827986", "江西省景德镇市",
"861520397", "河南省信阳市",
"861459095", "广东省茂名市",
"861309782", "广西贵港市",
"86189840", "贵州省贵阳市",
"861337570", "浙江省衢州市",
"86150307", "河北省沧州市",
"861500700", "江西省南昌市",
"861302957", "内蒙古鄂尔多斯市",
"861850450", "黑龙江省哈尔滨市",
"86152438", "湖南省娄底市",
"86183427", "辽宁省盘锦市",
"861898022", "四川省自贡市",
"861335425", "辽宁省鞍山市",
"861330639", "山东省青岛市",
"861345545", "山东省菏泽市",
"86189822", "四川省成都市",
"861811406", "江苏省无锡市",
"861528459", "云南省楚雄彝族自治州",
"861362900", "四川省内江市",
"86183118", "贵州省铜仁地区",
"861519242", "山东省济宁市",
"861322646", "广东省江门市",
"861327429", "辽宁省葫芦岛市",
"861518193", "四川省遂宁市",
"861538468", "陕西省商洛市",
"861331068", "山东省枣庄市",
"861532671", "内蒙古呼和浩特市",
"861360141", "江苏省盐城市",
"861334239", "辽宁省葫芦岛市",
"861330880", "云南省昆明市",
"861846389", "山东省临沂市",
"861324786", "江西省南昌市",
"861810744", "湖南省张家界市",
"861839515", "宁夏中卫市",
"861377414", "湖北省随州市",
"86151771", "广西南宁市",
"861505642", "安徽省六安市",
"861317795", "江西省宜春市",
"86156355", "山西省长治市",
"861896928", "浙江省湖州市",
"861530489", "黑龙江省大庆市",
"861871304", "河北省廊坊市",
"861454100", "安徽省淮北市",
"86183067", "安徽省阜阳市",
"861839656", "福建省南平市",
"861311631", "贵州省贵阳市",
"861709669", "浙江省杭州市",
"86137727", "陕西省渭南市",
"861305407", "湖南省岳阳市",
"861369377", "河南省南阳市",
"861551547", "河南省濮阳市",
"861313932", "甘肃省定西市",
"861571923", "陕西省渭南市",
"861358919", "山东省潍坊市",
"861321334", "河南省周口市",
"861512189", "宁夏中卫市",
"861327464", "黑龙江省七台河市",
"861356550", "新疆博尔塔拉蒙古自治州",
"861891342", "江苏省镇江市",
"861535345", "陕西省安康市",
"861889343", "甘肃省庆阳市",
"861508055", "福建省三明市",
"861534873", "云南省红河哈尼族彝族自治州",
"86139972", "青海省西宁市",
"86157654", "黑龙江省佳木斯市",
"861877239", "湖北省黄冈市",
"861380399", "河南省郑州市",
"861888846", "广西百色市",
"861848517", "贵州省遵义市",
"861319627", "吉林省四平市",
"86184186", "甘肃省兰州市",
"861855141", "江苏省南京市",
"861823685", "河南省焦作市",
"861383434", "山西省临汾市",
"861558333", "四川省达州市",
"861834414", "广东省深圳市",
"86138980", "辽宁省鞍山市",
"861856219", "山东省烟台市",
"86180533", "山东省淄博市",
"861850534", "山东省德州市",
"861868764", "云南省迪庆藏族自治州",
"861889808", "西藏那曲地区",
"86155492", "湖北省恩施土家族苗族自治州",
"861523198", "河北省保定市",
"861459770", "新疆克拉玛依市",
"861370328", "河北省保定市",
"861318161", "山东省烟台市",
"861536877", "云南省玉溪市",
"861332777", "江苏省镇江市",
"86158545", "山东省烟台市",
"861364251", "广东省梅州市",
"861372046", "陕西省榆林市",
"861357613", "江西省南昌市",
"861399041", "四川省阿坝藏族羌族自治州",
"861823821", "河南省开封市",
"861867945", "江西省南昌市",
"861360651", "浙江省杭州市",
"861575773", "浙江省杭州市",
"861360994", "新疆昌吉回族自治州",
"861817251", "广西梧州市",
"861877278", "湖北省十堰市",
"861569800", "山东省济南市",
"861815895", "安徽省合肥市",
"861580986", "辽宁省葫芦岛市",
"861354844", "四川省绵阳市",
"86159808", "福建省厦门市",
"86139148", "江苏省徐州市",
"861880901", "新疆塔城地区",
"861820427", "辽宁省盘锦市",
"861539598", "福建省三明市",
"86139692", "山东省德州市",
"861566098", "河南省南阳市",
"861330678", "浙江省丽水市",
"861839146", "陕西省汉中市",
"86158290", "陕西省西安市",
"861333730", "湖南省岳阳市",
"861895125", "江苏省连云港市",
"861777203", "广西柳州市",
"861327672", "浙江省宁波市",
"861866665", "广东省河源市",
"861365534", "山东省德州市",
"861511086", "山西省阳泉市",
"861318486", "广东省汕尾市",
"86133810", "北京市",
"861576802", "广东省清远市",
"861556114", "内蒙古鄂尔多斯市",
"861309183", "黑龙江省牡丹江市",
"861514759", "内蒙古通辽市",
"861345116", "湖北省荆门市",
"861597258", "湖北省十堰市",
"861508566", "贵州省黔东南苗族侗族自治州",
"861322585", "安徽省合肥市",
"861591008", "山东省济南市",
"861518636", "贵州省黔西南布依族苗族自治州",
"861309613", "四川省南充市",
"861389542", "宁夏石嘴山市",
"861886090", "江苏省苏州市",
"861819503", "宁夏吴忠市",
"861830009", "广东省东莞市",
"861334278", "广东省潮州市",
"861831262", "广东省茂名市",
"861504231", "辽宁省盘锦市",
"861821133", "广东省广州市",
"861833031", "河北省唐山市",
"861389144", "陕西省渭南市",
"861593661", "河南省漯河市",
"861820952", "宁夏石嘴山市",
"861320814", "四川省阿坝藏族羌族自治州",
"86138397", "河南省信阳市",
"861858414", "四川省绵阳市",
"861534333", "湖南省株洲市",
"861556512", "河南省开封市",
"861810392", "河南省鹤壁市",
"861836088", "江苏省苏州市",
"861840843", "宁夏吴忠市",
"8614749", "广东省广州市",
"861532586", "浙江省台州市",
"861582057", "广东省珠海市",
"861889309", "甘肃省天水市",
"861531524", "山东省潍坊市",
"861453098", "山西省长治市",
"861347439", "陕西省榆林市",
"86181256", "广东省佛山市",
"861582891", "四川省巴中市",
"86180263", "广东省广州市",
"861500631", "山东省威海市",
"86188089", "海南省海口市",
"861510561", "安徽省淮北市",
"861361546", "山东省东营市",
"861369837", "四川省眉山市",
"861334919", "安徽省合肥市",
"86134030", "湖北省恩施土家族苗族自治州",
"861370829", "四川省宜宾市",
"861856978", "湖南省怀化市",
"861897010", "江西省赣州市",
"861866704", "浙江省杭州市",
"861358239", "河北省保定市",
"861898589", "贵州省毕节地区",
"861598300", "四川省泸州市",
"861584767", "内蒙古呼和浩特市",
"861813668", "江苏省南京市",
"861593416", "山西省晋城市",
"861374958", "河南省平顶山市",
"861314971", "辽宁省营口市",
"861533707", "甘肃省甘南藏族自治州",
"861300166", "山东省青岛市",
"861350756", "福建省三明市",
"861521558", "安徽省阜阳市",
"861826649", "山东省滨州市",
"861890568", "安徽省亳州市",
"8618565", "广东省广州市",
"861370864", "云南省大理白族自治州",
"861311700", "湖北省孝感市",
"86134688", "陕西省西安市",
"86130777", "广西南宁市",
"861476029", "福建省龙岩市",
"861370340", "河南省平顶山市",
"861477847", "广东省中山市",
"861899740", "青海省海北藏族自治州",
"861787566", "广东省潮州市",
"861478715", "云南省保山市",
"861524000", "安徽省滁州市",
"861450312", "河北省保定市",
"861807778", "广西南宁市",
"861572294", "江苏省淮安市",
"861568541", "贵州省贵阳市",
"861300737", "湖南省益阳市",
"861353791", "广东省云浮市",
"861454417", "福建省漳州市",
"861535371", "陕西省西安市",
"861358278", "河北省廊坊市",
"86152574", "浙江省宁波市",
"861856939", "湖南省永州市",
"861370917", "陕西省宝鸡市",
"861346537", "山东省济宁市",
"861338360", "河北省秦皇岛市",
"86130353", "湖北省武汉市",
"86131366", "黑龙江省哈尔滨市",
"861478396", "河南省驻马店市",
"861338844", "浙江省舟山市",
"86135697", "河南省信阳市",
"861809384", "甘肃省酒泉市",
"861863059", "河北省衡水市",
"861310593", "福建省宁德市",
"86135410", "四川省成都市",
"861519673", "四川省内江市",
"861367856", "贵州省铜仁地区",
"861568826", "湖南省永州市",
"861583512", "山西省太原市",
"861503643", "河南省周口市",
"861878613", "贵州省贵阳市",
"861345571", "山东省东营市",
"861320967", "宁夏中卫市",
"861380898", "山东省青岛市",
"86130200", "北京市",
"861315933", "福建省莆田市",
"86177011", "北京市",
"861319280", "广东省惠州市",
"861840308", "河北省衡水市",
"861302422", "浙江省嘉兴市",
"861476184", "江苏省扬州市",
"861361685", "浙江省绍兴市",
"861896940", "浙江省宁波市",
"861369443", "吉林省延边朝鲜族自治州",
"861380261", "广东省江门市",
"861312568", "辽宁省辽阳市",
"861871491", "安徽省宿州市",
"861876049", "福建省漳州市",
"86153892", "陕西省西安市",
"861883978", "河南省郑州市",
"861869904", "新疆克拉玛依市",
"861786985", "云南省西双版纳傣族自治州",
"861860499", "辽宁省辽阳市",
"86133608", "广东省惠州市",
"861536337", "广东省潮州市",
"86136958", "浙江省温州市",
"861331902", "新疆哈密地区",
"86159610", "江苏省泰州市",
"86180587", "浙江省杭州市",
"861347478", "内蒙古鄂尔多斯市",
"861502488", "内蒙古巴彦淖尔市",
"861532645", "吉林省通化市",
"861577532", "四川省成都市",
"861471557", "广东省佛山市",
"861336282", "浙江省舟山市",
"861840437", "吉林省辽源市",
"861708388", "河南省郑州市",
"86187962", "江苏省徐州市",
"861306074", "广东省梅州市",
"861580579", "浙江省金华市",
"861801572", "四川省泸州市",
"861534717", "湖北省黄冈市",
"861310327", "河北省沧州市",
"86131400", "河南省郑州市",
"861850506", "福建省莆田市",
"861368716", "湖北省荆州市",
"861846712", "青海省海西蒙古族藏族自治州",
"861458946", "广东省中山市",
"861513526", "山西省吕梁市",
"861314422", "广东省江门市",
"861332751", "山西省太原市",
"861536851", "云南省文山壮族苗族自治州",
"86147915", "陕西省安康市",
"861587889", "广西柳州市",
"861867638", "广东省深圳市",
"861700369", "广东省惠州市",
"861830356", "山西省晋城市",
"861867202", "湖北省黄石市",
"861513841", "河南省南阳市",
"861569597", "福建省龙岩市",
"861477855", "广东省梅州市",
"861360677", "浙江省温州市",
"861786917", "云南省红河哈尼族彝族自治州",
"861523660", "河南省新乡市",
"861867422", "湖北省孝感市",
"86186700", "湖南省长沙市",
"861328241", "浙江省杭州市",
"861339054", "辽宁省大连市",
"861368395", "河南省漯河市",
"861880643", "山东省淄博市",
"861366554", "安徽省六安市",
"861800512", "江苏省连云港市",
"861472669", "四川省甘孜藏族自治州",
"861516705", "浙江省衢州市",
"861829741", "安徽省安庆市",
"86138611", "江苏省常州市",
"861454485", "湖北省宜昌市",
"861776898", "江苏省徐州市",
"861773756", "河南省平顶山市",
"86147776", "广西百色市",
"861334061", "四川省巴中市",
"861356226", "山东省东营市",
"861768908", "西藏拉萨市",
"861539913", "陕西省渭南市",
"861826194", "江苏省南京市",
"86158484", "内蒙古乌兰察布市",
"86180635", "山东省聊城市",
"861518604", "贵州省铜仁地区",
"861306412", "江西省南昌市",
"861860454", "黑龙江省佳木斯市",
"861822044", "陕西省商洛市",
"861550581", "浙江省杭州市",
"861500978", "青海省西宁市",
"861532218", "广东省云浮市",
"861333909", "安徽省黄山市",
"861700324", "河北省唐山市",
"861329028", "山东省德州市",
"861893848", "广东省茂名市",
"861303121", "新疆哈密地区",
"861339339", "河北省沧州市",
"861827011", "江西省鹰潭市",
"861571738", "湖南省娄底市",
"861566878", "辽宁省葫芦岛市",
"86139223", "广东省广州市",
"861894481", "江苏省泰州市",
"861362778", "广西河池市",
"86139384", "河南省郑州市",
"86182902", "重庆市",
"861829402", "甘肃省定西市",
"861811434", "江苏省宿迁市",
"861352588", "河南省三门峡市",
"861342663", "江西省上饶市",
"86186277", "湖北省武汉市",
"861521246", "安徽省黄山市",
"861302971", "黑龙江省哈尔滨市",
"861306358", "江苏省南通市",
"861560771", "广西南宁市",
"86147964", "江西省抚州市",
"861880725", "湖北省黄冈市",
"861832295", "江西省抚州市",
"861337784", "湖北省咸宁市",
"861577106", "湖北省荆门市",
"861865990", "福建省泉州市",
"861566680", "山东省滨州市",
"861827661", "广西钦州市",
"861364364", "山西省朔州市",
"861893303", "广东省云浮市",
"861532657", "黑龙江省佳木斯市",
"861301373", "江苏省扬州市",
"861708701", "广西南宁市",
"861770791", "江西省南昌市",
"861362739", "湖南省邵阳市",
"861571779", "广西北海市",
"861339378", "河南省平顶山市",
"861471545", "广东省揭阳市",
"861366430", "吉林省长春市",
"861880153", "江苏省无锡市",
"861331271", "云南省临沧市",
"861334611", "浙江省台州市",
"86150389", "河南省许昌市",
"861303815", "四川省资阳市",
"861500939", "甘肃省陇南市",
"861899933", "新疆石河子市",
"861520724", "湖北省咸宁市",
"861760528", "江苏省扬州市",
"861453227", "浙江省金华市",
"861802497", "广东省肇庆市",
"861896385", "新疆巴音郭楞蒙古自治州",
"861350990", "广东省湛江市",
"861775059", "福建省厦门市",
"86181023", "重庆市",
"861505599", "安徽省黄山市",
"861874784", "内蒙古通辽市",
"861818172", "四川省遂宁市",
"861580538", "山东省泰安市",
"861534093", "山西省吕梁市",
"861478431", "河南省许昌市",
"861452423", "辽宁省沈阳市",
"861810032", "河南省郑州市",
"86155343", "山西省吕梁市",
"861803293", "河北省石家庄市",
"861808150", "四川省达州市",
"861858760", "广西防城港市",
"861310279", "河北省衡水市",
"861533562", "内蒙古兴安盟",
"861872644", "安徽省蚌埠市",
"86152170", "广东省深圳市",
"861894737", "内蒙古鄂尔多斯市",
"861584502", "黑龙江省哈尔滨市",
"861453338", "浙江省衢州市",
"861860530", "山东省菏泽市",
"861383406", "山西省晋城市",
"861364329", "河北省邢台市",
"861520769", "广东省东莞市",
"86135368", "广东省汕头市",
"861332813", "江苏省扬州市",
"861530758", "广东省肇庆市",
"861847906", "江西省上饶市",
"86156748", "湖南省长沙市",
"861705511", "浙江省宁波市",
"861361067", "山西省临汾市",
"861591497", "广东省清远市",
"861897198", "湖北省鄂州市",
"861339879", "云南省普洱市",
"861459062", "广东省肇庆市",
"861586974", "湖南省株洲市",
"861539470", "内蒙古呼伦贝尔市",
"861311978", "青海省西宁市",
"861814962", "福建省漳州市",
"861555070", "山东省济宁市",
"86145926", "重庆市",
"861333943", "黑龙江省牡丹江市",
"861533164", "云南省丽江市",
"86181572", "浙江省湖州市",
"861345363", "山西省晋城市",
"861856700", "河南省开封市",
"86132517", "吉林省长春市",
"861316953", "广东省东莞市",
"861310918", "陕西省汉中市",
"86155965", "陕西省榆林市",
"861566227", "吉林省延边朝鲜族自治州",
"861587701", "广西桂林市",
"861760540", "山东省菏泽市",
"861317083", "江西省宜春市",
"861326393", "江西省上饶市",
"861301447", "江西省宜春市",
"861852409", "辽宁省葫芦岛市",
"861508047", "福建省福州市",
"861367962", "四川省乐山市",
"861358061", "广东省肇庆市",
"861551461", "河南省周口市",
"861322517", "江苏省淮安市",
"861306859", "广东省河源市",
"861778026", "四川省广安市",
"861788804", "西藏拉萨市",
"861566407", "河南省安阳市",
"861560745", "湖南省怀化市",
"861539233", "福建省宁德市",
"861453839", "四川省广元市",
"861588418", "四川省泸州市",
"86180509", "福建省泉州市",
"861503901", "河南省开封市",
"861470511", "江苏省盐城市",
"861889451", "甘肃省金昌市",
"86150765", "河北省唐山市",
"861535980", "福建省莆田市",
"86188166", "上海市",
"861372567", "广东省河源市",
"861517191", "湖北省宜昌市",
"861319811", "四川省广安市",
"86137449", "吉林省长春市",
"861331245", "贵州省铜仁地区",
"86139291", "广东省佛山市",
"861815446", "湖北省孝感市",
"861551616", "河南省郑州市",
"861771346", "四川省广元市",
"861554276", "辽宁省盘锦市",
"861380078", "广西钦州市",
"861532938", "贵州省六盘水市",
"861869936", "新疆昌吉回族自治州",
"861504069", "辽宁省本溪市",
"861564882", "内蒙古赤峰市",
"861453680", "陕西省西安市",
"861471571", "广东省惠州市",
"861887037", "江西省景德镇市",
"861595048", "江苏省南京市",
"86132325", "广东省中山市",
"86188813", "四川省乐山市",
"861319753", "广西贺州市",
"861373142", "河北省承德市",
"861321094", "山东省烟台市",
"861874498", "贵州省黔西南布依族苗族自治州",
"861872552", "安徽省蚌埠市",
"861557845", "广西崇左市",
"861458768", "广东省潮州市",
"861582071", "广东省惠州市",
"861329040", "河北省邯郸市",
"861330931", "甘肃省兰州市",
"861506534", "山东省德州市",
"861377926", "新疆昌吉回族自治州",
"861327710", "湖北省襄樊市",
"861848585", "贵州省六盘水市",
"861884672", "黑龙江省鸡西市",
"861881212", "河北省保定市",
"861532979", "贵州省黔西南布依族苗族自治州",
"861319125", "山西省长治市",
"861808432", "贵州省黔东南苗族侗族自治州",
"861380039", "河南省焦作市",
"861553974", "河南省洛阳市",
"861305098", "辽宁省葫芦岛市",
"861452249", "浙江省舟山市",
"86177938", "甘肃省天水市",
"861808628", "湖北省荆门市",
"861351493", "安徽省阜阳市",
"861589774", "湖北省孝感市",
"86150714", "湖北省武汉市",
"861320492", "湖南省怀化市",
"861858892", "广东省广州市",
"86159981", "辽宁省沈阳市",
"861311939", "甘肃省庆阳市",
"861324397", "辽宁省葫芦岛市",
"861709961", "浙江省舟山市",
"861512911", "陕西省延安市",
"861800684", "浙江省宁波市",
"861705176", "辽宁省大连市",
"861510373", "河南省新乡市",
"861815041", "福建省漳州市",
"861317163", "河北省张家口市",
"861339838", "四川省绵阳市",
"861893349", "广东省潮州市",
"861348732", "湖南省湘潭市",
"861871876", "广东省阳江市",
"861314957", "黑龙江省齐齐哈尔市",
"86181197", "安徽省六安市",
"861380354", "江西省南昌市",
"861597685", "广东省深圳市",
"861533084", "辽宁省鞍山市",
"861552089", "四川省南充市",
"861509845", "山东省烟台市",
"861780633", "山东省日照市",
"861370731", "湖南省长沙市",
"86187444", "吉林省四平市",
"861831295", "浙江省宁波市",
"861357818", "云南省普洱市",
"861568965", "山东省日照市",
"861315496", "四川省眉山市",
"861768526", "贵州省黔南布依族苗族自治州",
"861817757", "广西贵港市",
"861859821", "广东省潮州市",
"861569014", "河北省廊坊市",
"861303672", "湖南省邵阳市",
"861530239", "广东省广州市",
"86159509", "江苏省苏州市",
"861891238", "江苏省无锡市",
"861351588", "浙江省宁波市",
"861319642", "江苏省无锡市",
"861520786", "广西百色市",
"86153732", "河北省廊坊市",
"861313650", "浙江省湖州市",
"861893901", "河南省洛阳市",
"861301971", "黑龙江省哈尔滨市",
"861397217", "湖北省武汉市",
"861576470", "内蒙古呼伦贝尔市",
"861341797", "广东省云浮市",
"861816936", "湖南省常德市",
"861858984", "广西梧州市",
"86130504", "辽宁省锦州市",
"861845026", "福建省厦门市",
"861390550", "安徽省滁州市",
"861300911", "吉林省长春市",
"861565982", "福建省厦门市",
"861882932", "陕西省榆林市",
"861567744", "广西贺州市",
"86439", "吉林省白山市",
"86186071", "湖北省武汉市",
"86135850", "江苏省无锡市",
"861304700", "广东省潮州市",
"861376879", "广西玉林市",
"861572779", "江西省萍乡市",
"861361739", "湖南省邵阳市",
"861559198", "陕西省商洛市",
"861459335", "四川省内江市",
"861802995", "广东省揭阳市",
"86132038", "河南省郑州市",
"861337726", "广西百色市",
"861362258", "广东省汕头市",
"861815862", "浙江省台州市",
"861457053", "新疆喀什地区",
"861801497", "江苏省扬州市",
"861807546", "安徽省宿州市",
"861477996", "江西省赣州市",
"861330873", "云南省红河哈尼族彝族自治州",
"861819167", "陕西省西安市",
"861346314", "河北省承德市",
"861520523", "江苏省淮安市",
"861337960", "贵州省遵义市",
"861505627", "安徽省宣城市",
"861331813", "广东省梅州市",
"861840620", "辽宁省本溪市",
"86188536", "山东省潍坊市",
"861818885", "广东省深圳市",
"861309818", "陕西省铜川市",
"861362067", "山西省吕梁市",
"861820701", "江西省鹰潭市",
"86132680", "广东省广州市",
"86152270", "河北省保定市",
"861569472", "内蒙古包头市",
"861333375", "河南省平顶山市",
"861337583", "浙江省嘉兴市",
"861590684", "浙江省宁波市",
"861315857", "四川省内江市",
"861588325", "四川省内江市",
"861362617", "江苏省徐州市",
"861384986", "河南省许昌市",
"861819736", "青海省海北藏族自治州",
"861331751", "湖北省荆门市",
"861868371", "四川省成都市",
"861503349", "河北省唐山市",
"861778562", "贵州省贵阳市",
"861370487", "黑龙江省黑河市",
"861319152", "内蒙古赤峰市",
"861309170", "黑龙江省哈尔滨市",
"861564994", "河南省商丘市",
"861802572", "广东省潮州市",
"861760906", "新疆阿勒泰地区",
"861591174", "云南省昆明市",
"861336150", "山东省东营市",
"861847528", "广东省肇庆市",
"861390434", "吉林省四平市",
"861560251", "广东省茂名市",
"861459526", "云南省文山壮族苗族自治州",
"861776104", "四川省南充市",
"861508976", "广东省潮州市",
"861582519", "云南省红河哈尼族彝族自治州",
"861311805", "四川省资阳市",
"861807115", "湖北省襄樊市",
"861818621", "湖北省武汉市",
"861837448", "湖南省长沙市",
"861510945", "甘肃省金昌市",
"861393399", "河北省张家口市",
"86147060", "四川省成都市",
"861570637", "山东省滨州市",
"861317762", "江西省吉安市",
"861502918", "陕西省西安市",
"861303209", "河北省承德市",
"86152707", "江西省赣州市",
"861700386", "河南省周口市",
"861528903", "西藏山南地区",
"861859685", "福建省厦门市",
"861805048", "福建省漳州市",
"861472686", "四川省广元市",
"861398682", "湖北省宜昌市",
"861894189", "辽宁省葫芦岛市",
"861527272", "湖北省咸宁市",
"861562853", "西藏山南地区",
"861775156", "江苏省盐城市",
"861515613", "安徽省马鞍山市",
"861310759", "青海省西宁市",
"861303429", "浙江省台州市",
"861351904", "甘肃省庆阳市",
"861471624", "广东省佛山市",
"86186592", "福建省厦门市",
"861361778", "广西河池市",
"861598628", "广东省阳江市",
"861459783", "新疆巴音郭楞蒙古自治州",
"861376838", "广西河池市",
"861896534", "福建省三明市",
"861454350", "山东省泰安市",
"861534678", "甘肃省天水市",
"861598432", "四川省眉山市",
"861829090", "新疆阿勒泰地区",
"861304631", "广东省中山市",
"861322094", "山东省烟台市",
"861314561", "安徽省淮北市",
"861377984", "新疆喀什地区",
"861871552", "安徽省蚌埠市",
"861598640", "广东省广州市",
"861769500", "宁夏银川市",
"861376054", "广东省江门市",
"861388471", "山东省潍坊市",
"861873594", "山西省临汾市",
"861530919", "陕西省铜川市",
"861884815", "内蒙古赤峰市",
"861477822", "广东省湛江市",
"861825036", "福建省龙岩市",
"861393898", "河南省南阳市",
"861552066", "四川省资阳市",
"861365317", "河北省沧州市",
"861314455", "黑龙江省绥化市",
"861778129", "四川省南充市",
"861330333", "河北省张家口市",
"861585460", "山东省东营市",
"861526580", "山东省菏泽市",
"861867561", "广东省珠海市",
"861890978", "青海省西宁市",
"861308690", "贵州省安顺市",
"861370600", "福建省南平市",
"86183662", "山东省青岛市",
"86159635", "山东省烟台市",
"8615822", "天津市",
"861470854", "贵州省黔南布依族苗族自治州",
"861804226", "浙江省衢州市",
"861350468", "黑龙江省鸡西市",
"86138356", "山西省晋城市",
"861847540", "广东省阳江市",
"861558639", "湖北省襄樊市",
"861344042", "辽宁省鞍山市",
"861837420", "湖南省益阳市",
"861868345", "四川省凉山彝族自治州",
"861820630", "山东省德州市",
"861802174", "江苏省扬州市",
"861570958", "宁夏银川市",
"861590512", "江苏省连云港市",
"861510971", "青海省西宁市",
"861569705", "云南省昆明市",
"861319554", "安徽省淮南市",
"861778164", "四川省自贡市",
"86187637", "山东省临沂市",
"861576913", "陕西省渭南市",
"86181297", "广东省惠州市",
"86135435", "广东省湛江市",
"861899871", "广东省湛江市",
"861843605", "河南省安阳市",
"861527643", "新疆昌吉回族自治州",
"86145717", "浙江省杭州市",
"861850317", "河北省沧州市",
"86155010", "北京市",
"861840648", "山西省运城市",
"861372694", "广东省湛江市",
"861593293", "江西省上饶市",
"861552555", "山西省晋中市",
"861830532", "山东省青岛市",
"861580416", "辽宁省锦州市",
"86181312", "河北省保定市",
"861530827", "四川省德阳市",
"861558678", "湖北省咸宁市",
"861707536", "山东省潍坊市",
"861803924", "河南省洛阳市",
"861778084", "四川省凉山彝族自治州",
"861529697", "宁夏银川市",
"861316351", "黑龙江省佳木斯市",
"861504086", "辽宁省朝阳市",
"861320577", "浙江省温州市",
"86151326", "河北省廊坊市",
"861458500", "河南省信阳市",
"861850940", "甘肃省临夏回族自治州",
"861302447", "江苏省盐城市",
"861880752", "广东省惠州市",
"861333341", "山西省太原市",
"86159456", "黑龙江省黑河市",
"861319273", "广东省河源市",
"86132886", "广东省广州市",
"861528949", "陕西省咸阳市",
"861532305", "广东省梅州市",
"861399956", "新疆昌吉回族自治州",
"861579713", "湖北省荆门市",
"861309319", "江苏省常州市",
"861519680", "四川省资阳市",
"861334842", "福建省宁德市",
"861813863", "广东省江门市",
"861375401", "内蒙古呼和浩特市",
"861561285", "河北省唐山市",
"861336432", "吉林省吉林市",
"86189389", "广东省深圳市",
"861889159", "陕西省商洛市",
"861890939", "甘肃省陇南市",
"86136546", "黑龙江省哈尔滨市",
"861584898", "内蒙古赤峰市",
"861330785", "广西玉林市",
"861527153", "湖北省宜昌市",
"861524967", "河南省郑州市",
"861536682", "江苏省常州市",
"861868831", "广东省惠州市",
"861533421", "湖北省仙桃市",
"86134015", "江苏省常州市",
"861772346", "四川省攀枝花市",
"861552873", "四川省宜宾市",
"861833419", "贵州省毕节地区",
"861319498", "四川省成都市",
"861317838", "福建省福州市",
"861857441", "湖南省张家界市",
"861364587", "浙江省温州市",
"861308679", "广西北海市",
"861898593", "贵州省六盘水市",
"861810877", "云南省玉溪市",
"861390780", "广西防城港市",
"861301168", "山东省潍坊市",
"861586440", "山东省潍坊市",
"861860802", "四川省成都市",
"86153317", "云南省昆明市",
"861888128", "四川省广元市",
"861381457", "江苏省苏州市",
"861538586", "安徽省芜湖市",
"861801282", "江苏省镇江市",
"86158696", "浙江省温州市",
"861862605", "江苏省无锡市",
"861852414", "辽宁省本溪市",
"861780507", "江苏省常州市",
"861832982", "陕西省榆林市",
"861457026", "江西省吉安市",
"86181856", "贵州省铜仁地区",
"861385225", "江苏省淮安市",
"861325164", "黑龙江省七台河市",
"861572862", "广东省肇庆市",
"861568120", "四川省绵阳市",
"86188447", "吉林省延边朝鲜族自治州",
"861313997", "新疆阿克苏地区",
"861864838", "内蒙古鄂尔多斯市",
"861584689", "黑龙江省大庆市",
"861351758", "广西河池市",
"861520556", "安徽省安庆市",
"861855548", "安徽省宿州市",
"861780070", "青海省海西蒙古族藏族自治州",
"861866448", "广东省汕头市",
"861323357", "山西省临汾市",
"861594773", "内蒙古鄂尔多斯市",
"861520615", "江苏省无锡市",
"861879957", "新疆和田地区",
"861355802", "广西柳州市",
"86152957", "江苏省南京市",
"861700133", "广东省深圳市",
"86170790", "浙江省杭州市",
"861538723", "湖北省黄石市",
"861337753", "广东省梅州市",
"861333234", "辽宁省辽阳市",
"861708073", "湖南省长沙市",
"861881674", "广东省深圳市",
"861348386", "河北省承德市",
"861323563", "湖北省宜昌市",
"861813471", "河南省郑州市",
"861360548", "山东省泰安市",
"861880614", "江苏省常州市",
"861809441", "江苏省常州市",
"86158764", "广东省东莞市",
"861524215", "辽宁省朝阳市",
"861550271", "湖北省襄樊市",
"86131573", "浙江省嘉兴市",
"861369760", "山东省烟台市",
"861323980", "新疆和田地区",
"86132429", "广东省深圳市",
"861334936", "黑龙江省黑河市",
"86178633", "山东省日照市",
"861539191", "安徽省安庆市",
"86147689", "山东省东营市",
"861472715", "浙江省湖州市",
"861814640", "新疆乌鲁木齐市",
"861457201", "四川省成都市",
"861500204", "广东省广州市",
"861824861", "浙江省绍兴市",
"861508342", "河南省南阳市",
"861500424", "辽宁省大连市",
"86156632", "黑龙江省齐齐哈尔市",
"861859395", "广西玉林市",
"861536744", "湖南省张家界市",
"861332844", "福建省漳州市",
"861809702", "青海省海东地区",
"861459367", "贵州省黔东南苗族侗族自治州",
"861327906", "新疆阿克苏地区",
"861535052", "河北省邯郸市",
"86151667", "山东省济宁市",
"861332360", "河南省商丘市",
"861553440", "山西省晋中市",
"861860483", "内蒙古阿拉善盟",
"861839828", "四川省阿坝藏族羌族自治州",
"861562826", "新疆伊犁哈萨克自治州",
"86158976", "湖北省随州市",
"861857046", "湖南省衡阳市",
"861346941", "湖南省益阳市",
"861897205", "湖北省襄樊市",
"861820698", "云南省大理白族自治州",
"861337811", "四川省成都市",
"861700696", "广东省东莞市",
"86155396", "河南省驻马店市",
"861459553", "青海省黄南藏族自治州",
"861300344", "江苏省镇江市",
"861308422", "河南省鹤壁市",
"861857702", "广西防城港市",
"861517470", "内蒙古乌海市",
"86150140", "广东省深圳市",
"861300860", "云南省红河哈尼族彝族自治州",
"861366960", "广西南宁市",
"861308638", "四川省遂宁市",
"861881462", "黑龙江省齐齐哈尔市",
"861317879", "广东省汕头市",
"861809046", "四川省成都市",
"861555633", "安徽省滁州市",
"86136483", "重庆市",
"861308202", "河北省邢台市",
"861325084", "浙江省杭州市",
"86158715", "湖北省宜昌市",
"86138812", "四川省广元市",
"861822797", "四川省广安市",
"861590394", "河南省周口市",
"86181783", "广西桂林市",
"861823362", "河北省廊坊市",
"861362035", "广东省肇庆市",
"861310589", "浙江省金华市",
"861571075", "广东省深圳市",
"861393830", "河南省濮阳市",
"861301088", "广东省深圳市",
"861829854", "甘肃省武威市",
"861335660", "山东省东营市",
"861308957", "黑龙江省鸡西市",
"86182960", "贵州省黔西南布依族苗族自治州",
"861854501", "黑龙江省哈尔滨市",
"86189240", "广东省广州市",
"861806188", "江苏省南京市",
"861376890", "广西桂林市",
"86130606", "广东省广州市",
"861522459", "广西柳州市",
"86189222", "广东省广州市",
"861516043", "福建省泉州市",
"861512193", "宁夏吴忠市",
"861576499", "内蒙古乌兰察布市",
"861803131", "河北省唐山市",
"86157597", "福建省泉州市",
"861321747", "湖南省怀化市",
"861378441", "河北省石家庄市",
"861571041", "陕西省延安市",
"861804253", "浙江省宁波市",
"861776411", "湖北省黄冈市",
"861538671", "山西省朔州市",
"861818284", "黑龙江省佳木斯市",
"86188634", "山东省莱芜市",
"86150485", "内蒙古通辽市",
"86157948", "四川省成都市",
"861319784", "江西省新余市",
"861308380", "河南省新乡市",
"861884934", "河北省承德市",
"86189595", "福建省莆田市",
"861333914", "安徽省合肥市",
"861568658", "陕西省铜川市",
"861810408", "辽宁省大连市",
"861831894", "广东省东莞市",
"861345139", "内蒙古兴安盟",
"861553632", "山西省太原市",
"861367432", "吉林省吉林市",
"861525909", "福建省宁德市",
"861839840", "四川省绵阳市",
"861346975", "湖北省恩施土家族苗族自治州",
"861890486", "黑龙江省大庆市",
"861567112", "湖北省孝感市",
"861882846", "四川省成都市",
"86170815", "江苏省无锡市",
"861816842", "江苏省南京市",
"86145332", "浙江省杭州市",
"861814432", "四川省德阳市",
"861345810", "四川省攀枝花市",
"861810337", "河北省沧州市",
"861396723", "浙江省舟山市",
"861530493", "辽宁省营口市",
"861353482", "广东省江门市",
"861592823", "四川省广元市",
"86184517", "江苏省扬州市",
"861862764", "湖南省常德市",
"861880582", "浙江省湖州市",
"861568217", "四川省南充市",
"861801300", "江苏省南京市",
"861393370", "河北省邢台市",
"861360520", "江苏省徐州市",
"86181737", "湖南省益阳市",
"861879422", "甘肃省兰州市",
"861510088", "河北省邢台市",
"861760887", "云南省迪庆藏族自治州",
"861536392", "广东省茂名市",
"861338777", "广西钦州市",
"861861357", "山西省临汾市",
"861800143", "江苏省泰州市",
"861599149", "陕西省渭南市",
"861378046", "河北省廊坊市",
"861571446", "吉林省白城市",
"861384807", "内蒙古呼伦贝尔市",
"861776016", "四川省内江市",
"861507819", "广西百色市",
"861840492", "山西省大同市",
"861334216", "辽宁省丹东市",
"861705255", "北京市",
"861521641", "山东省济南市",
"86131022", "天津市",
"861869061", "新疆阿勒泰地区",
"861317339", "山东省菏泽市",
"861330616", "江苏省无锡市",
"861529950", "新疆克拉玛依市",
"861311469", "黑龙江省双鸭山市",
"861454806", "广东省东莞市",
"861310022", "湖南省永州市",
"861511344", "广东省河源市",
"861813445", "河南省平顶山市",
"861809475", "浙江省绍兴市",
"861346592", "山东省济南市",
"861829079", "新疆阿克苏地区",
"861568148", "四川省达州市",
"861556727", "吉林省松原市",
"861392337", "广东省珠海市",
"861587073", "江西省赣州市",
"861396645", "安徽省淮南市",
"861857475", "湖南省湘西土家族苗族自治州",
"86184325", "河北省秦皇岛市",
"861325562", "山东省东营市",
"861890081", "广东省湛江市",
"86133210", "北京市",
"861479701", "青海省西宁市",
"861855520", "安徽省滁州市",
"861330555", "安徽省马鞍山市",
"861590742", "湖南省湘西土家族苗族自治州",
"861317054", "云南省西双版纳傣族自治州",
"86170864", "江苏省无锡市",
"861475133", "江苏省连云港市",
"86185334", "河北省唐山市",
"861335010", "四川省自贡市",
"861300792", "宁夏吴忠市",
"86130661", "广东省东莞市",
"861316984", "广东省江门市",
"861595600", "安徽省宿州市",
"861581988", "广东省惠州市",
"861372384", "湖南省衡阳市",
"861586632", "山东省淄博市",
"861804574", "黑龙江省鸡西市",
"861328585", "浙江省绍兴市",
"86130618", "上海市",
"861343187", "广东省惠州市",
"861380735", "湖南省郴州市",
"861888140", "四川省内江市",
"861324220", "广东省中山市",
"861346343", "河北省廊坊市",
"861354618", "山西省临汾市",
"86182752", "贵州省贵阳市",
"861378977", "内蒙古鄂尔多斯市",
"861561541", "山东省济南市",
"861398509", "贵州省黔西南布依族苗族自治州",
"86150595", "福建省泉州市",
"861537680", "山东省淄博市",
"861366784", "广西梧州市",
"861354188", "四川省广安市",
"861390817", "四川省成都市",
"861471715", "甘肃省天水市",
"861324400", "吉林省吉林市",
"86138639", "山东省青岛市",
"861773723", "河南省濮阳市",
"861874273", "新疆哈密地区",
"861871613", "四川省泸州市",
"861865147", "江苏省淮安市",
"861570549", "山东省临沂市",
"861530904", "四川省阿坝藏族羌族自治州",
"86184680", "云南省昆明市",
"861539499", "云南省文山壮族苗族自治州",
"861537839", "四川省南充市",
"861470775", "广西玉林市",
"861500486", "内蒙古赤峰市",
"861452897", "云南省昆明市",
"861331844", "广东省东莞市",
"861340701", "江西省鹰潭市",
"861332581", "浙江省杭州市",
"861850662", "广东省阳江市",
"861705883", "广东省中山市",
"861569043", "河北省保定市",
"861816466", "云南省保山市",
"861369508", "福建省南平市",
"861536543", "江苏省徐州市",
"861878491", "四川省广元市",
"861800401", "辽宁省沈阳市",
"861336008", "广东省深圳市",
"861830323", "河北省邯郸市",
"861454761", "山东省威海市",
"86156819", "四川省绵阳市",
"861774428", "四川省德阳市",
"86150240", "广东省东莞市",
"861365662", "浙江省嘉兴市",
"861572075", "江苏省镇江市",
"861302088", "河北省唐山市",
"861393411", "山西省太原市",
"861853398", "河北省唐山市",
"861770608", "福建省泉州市",
"861782660", "江苏省连云港市",
"861500161", "新疆石河子市",
"861350147", "广东省广州市",
"86153192", "陕西省宝鸡市",
"861768754", "广西梧州市",
"861382457", "广东省梅州市",
"861457084", "江苏省南京市",
"861800742", "湖南省常德市",
"861553315", "河北省唐山市",
"861802282", "广东省茂名市",
"861310055", "广西玉林市",
"861819420", "甘肃省武威市",
"861782010", "广东省佛山市",
"861567851", "广西崇左市",
"861340388", "河南省周口市",
"861532990", "贵州省贵阳市",
"861368821", "四川省泸州市",
"86136521", "天津市",
"861820073", "广东省肇庆市",
"86180208", "福建省三明市",
"861705222", "江苏省南京市",
"861302168", "山东省青岛市",
"861391240", "江苏省南通市",
"861594574", "黑龙江省牡丹江市",
"861368546", "山东省东营市",
"861335376", "河南省信阳市",
"861836202", "江苏省镇江市",
"861857149", "湖北省武汉市",
"861589996", "广东省广州市",
"861812817", "广东省潮州市",
"861865657", "安徽省芜湖市",
"861775275", "湖南省郴州市",
"861804885", "四川省内江市",
"861879455", "甘肃省武威市",
"861348369", "河北省石家庄市",
"861337554", "山东省日照市",
"861452456", "黑龙江省黑河市",
"861370020", "陕西省咸阳市",
"861831982", "广东省潮州市",
"861896695", "陕西省榆林市",
"86186950", "湖北省恩施土家族苗族自治州",
"861595985", "福建省泉州市",
"86183600", "江苏省宿迁市",
"861850474", "内蒙古乌兰察布市",
"861571862", "贵州省遵义市",
"861323764", "江西省南昌市",
"861777500", "安徽省阜阳市",
"861534547", "山东省威海市",
"861328874", "河北省石家庄市",
"861871063", "陕西省渭南市",
"861809149", "陕西省宝鸡市",
"861584666", "黑龙江省绥化市",
"861882674", "广东省茂名市",
"861533606", "甘肃省定西市",
"861390964", "安徽省淮南市",
"861557244", "湖北省恩施土家族苗族自治州",
"86185021", "上海市",
"861787593", "广东省梅州市",
"861521812", "广东省汕尾市",
"861346808", "山东省临沂市",
"861530588", "浙江省台州市",
"861876277", "江苏省扬州市",
"861330522", "江苏省徐州市",
"861365474", "内蒙古乌兰察布市",
"86131313", "河北省张家口市",
"861394858", "内蒙古通辽市",
"861356574", "新疆巴音郭楞蒙古自治州",
"861898794", "云南省普洱市",
"861520872", "云南省大理白族自治州",
"861378103", "河南省三门峡市",
"861829511", "宁夏银川市",
"861303934", "吉林省长春市",
"861323729", "湖北省荆门市",
"86185127", "湖北省武汉市",
"86185461", "黑龙江省哈尔滨市",
"861327528", "江苏省南通市",
"861538569", "安徽省蚌埠市",
"861475732", "浙江省宁波市",
"861340442", "吉林省白城市",
"861340630", "山东省威海市",
"861348291", "河北省沧州市",
"86138505", "福建省漳州市",
"861572446", "辽宁省营口市",
"861524781", "内蒙古巴彦淖尔市",
"861860598", "福建省三明市",
"861560146", "江苏省南通市",
"861453390", "内蒙古阿拉善盟",
"861309491", "江苏省淮安市",
"861887185", "湖北省武汉市",
"861502589", "甘肃省张掖市",
"861347579", "山东省济宁市",
"861327540", "山东省菏泽市",
"861339762", "湖南省永州市",
"861805487", "福建省龙岩市",
"861356172", "山东省莱芜市",
"861374736", "内蒙古乌海市",
"861354902", "西藏日喀则地区",
"86182424", "辽宁省丹东市",
"861316760", "安徽省池州市",
"861709810", "浙江省台州市",
"861512860", "河北省承德市",
"861551785", "河南省平顶山市",
"861580590", "福建省厦门市",
"861344230", "江苏省南通市",
"86972", "青海省海东地区",
"861340889", "云南省临沧市",
"861569009", "河北省承德市",
"861312469", "贵州省黔东南苗族侗族自治州",
"861576944", "甘肃省庆阳市",
"861556034", "内蒙古鄂尔多斯市",
"861862980", "吉林省辽源市",
"861809977", "新疆巴音郭楞蒙古自治州",
"861316926", "广东省揭阳市",
"861589283", "四川省乐山市",
"861813947", "新疆阿克苏地区",
"861345036", "广东省广州市",
"861351827", "四川省德阳市",
"861771972", "陕西省商洛市",
"861366498", "广东省阳江市",
"861596902", "云南省昭通市",
"861780795", "江西省宜春市",
"86139848", "贵州省贵阳市",
"861570503", "内蒙古兴安盟",
"861537379", "河北省邯郸市",
"861770912", "陕西省榆林市",
"861819448", "甘肃省白银市",
"861862563", "河南省濮阳市",
"861563691", "黑龙江省绥化市",
"861870721", "湖北省荆州市",
"86159863", "广东省广州市",
"861830800", "西藏拉萨市",
"86183806", "四川省德阳市",
"861780316", "河北省廊坊市",
"861865938", "福建省宁德市",
"861582988", "陕西省西安市",
"86183818", "四川省达州市",
"86189122", "江苏省南通市",
"861521459", "黑龙江省大庆市",
"861338068", "广东省惠州市",
"861319960", "黑龙江省鹤岗市",
"861776119", "四川省成都市",
"861890469", "黑龙江省双鸭山市",
"861526847", "浙江省绍兴市",
"861470883", "云南省临沧市",
"861579744", "湖北省武汉市",
"86139731", "湖南省长沙市",
"86183861", "贵州省毕节地区",
"861559425", "陕西省渭南市",
"861535025", "江西省上饶市",
"861889023", "湖南省长沙市",
"861380981", "广东省佛山市",
"861321850", "江苏省盐城市",
"861705775", "河南省郑州市",
"861520332", "河北省保定市",
"86189140", "江苏省苏州市",
"861571790", "江西省新余市",
"861865979", "福建省龙岩市",
"86185559", "安徽省淮南市",
"861319583", "甘肃省兰州市",
"861800394", "河南省周口市",
"86186649", "广东省深圳市",
"861537227", "浙江省丽水市",
"86159116", "云南省昆明市",
"861338257", "江苏省泰州市",
"861776830", "江苏省无锡市",
"86187004", "陕西省西安市",
"861564256", "辽宁省朝阳市",
"861803439", "河北省邢台市",
"861576191", "贵州省贵阳市",
"861561575", "山东省烟台市",
"86151932", "甘肃省定西市",
"861337642", "山东省青岛市",
"861343739", "广东省东莞市",
"861890424", "辽宁省本溪市",
"861840577", "浙江省温州市",
"861476303", "山东省烟台市",
"861328334", "河北省张家口市",
"861577472", "内蒙古包头市",
"861347538", "山东省泰安市",
"861565050", "山东省烟台市",
"861335836", "福建省龙岩市",
"861396569", "安徽省合肥市",
"861785844", "浙江省宁波市",
"861846991", "云南省文山壮族苗族自治州",
"861558547", "吉林省白城市",
"861308561", "浙江省嘉兴市",
"861554524", "黑龙江省齐齐哈尔市",
"861853899", "河南省南阳市",
"861806777", "浙江省温州市",
"86184377", "河南省南阳市",
"861324248", "广东省江门市",
"861771595", "江苏省常州市",
"861599702", "青海省海东地区",
"861505570", "安徽省合肥市",
"861881846", "广东省清远市",
"861769832", "河南省安阳市",
"861515552", "安徽省淮北市",
"861308455", "河北省廊坊市",
"861470741", "湖南省长沙市",
"861350979", "山西省运城市",
"861869489", "浙江省金华市",
"861323973", "新疆哈密地区",
"86151185", "广东省东莞市",
"861825624", "安徽省六安市",
"861773938", "河南省商丘市",
"861521494", "新疆和田地区",
"861508279", "四川省南充市",
"861329849", "河南省三门峡市",
"86152996", "新疆昌吉回族自治州",
"86156378", "河南省开封市",
"861813955", "新疆喀什地区",
"861450594", "辽宁省朝阳市",
"861847815", "湖南省益阳市",
"861760429", "辽宁省葫芦岛市",
"861370265", "广东省佛山市",
"86158730", "湖南省岳阳市",
"861839623", "福建省泉州市",
"861800359", "山西省运城市",
"86176126", "湖北省武汉市",
"861872818", "四川省雅安市",
"86155773", "广西桂林市",
"861801432", "江苏省常州市",
"861580439", "吉林省白山市",
"861571956", "宁夏中卫市",
"861302690", "广西防城港市",
"861760209", "广东省东莞市",
"861388668", "湖北省宜昌市",
"861888212", "四川省资阳市",
"861560587", "浙江省温州市",
"861389712", "青海省海东地区",
"86158657", "山东省聊城市",
"861882997", "广东省惠州市",
"86152029", "陕西省西安市",
"861835658", "安徽省芜湖市",
"861353912", "广东省河源市",
"861308833", "四川省宜宾市",
"861866637", "广东省佛山市",
"861890916", "陕西省汉中市",
"86150973", "河北省石家庄市",
"861876251", "江苏省盐城市",
"861533634", "山东省莱芜市",
"861859362", "福建省福州市",
"861520092", "湖南省长沙市",
"861303906", "吉林省白城市",
"861800034", "河北省秦皇岛市",
"861340925", "河南省南阳市",
"861808174", "四川省攀枝花市",
"861760464", "黑龙江省七台河市",
"861843260", "河北省邯郸市",
"861390773", "广西桂林市",
"861350671", "浙江省杭州市",
"861317196", "河北省秦皇岛市",
"86181897", "海南省海口市",
"861309336", "安徽省阜阳市",
"861558555", "吉林省延边朝鲜族自治州",
"861839745", "湖南省常德市",
"861816239", "湖北省宜昌市",
"861339070", "江苏省盐城市",
"861378951", "内蒙古呼和浩特市",
"861366570", "浙江省衢州市",
"861573368", "河北省廊坊市",
"861772084", "福建省莆田市",
"861359357", "山西省运城市",
"861598497", "四川省凉山彝族自治州",
"861317633", "山东省日照市",
"861887248", "湖北省武汉市",
"861339507", "福建省厦门市",
"861567240", "湖北省荆州市",
"86147346", "广东省广州市",
"861825019", "福建省福州市",
"861452500", "山东省济南市",
"861811574", "江苏省徐州市",
"861479952", "新疆阿克苏地区",
"861538305", "河北省唐山市",
"861530936", "甘肃省张掖市",
"861306050", "广东省汕尾市",
"86152676", "浙江省台州市",
"861522949", "陕西省咸阳市",
"86132286", "重庆市",
"861514589", "黑龙江省双鸭山市",
"861835148", "江苏省盐城市",
"861550777", "广西钦州市",
"861593289", "江西省萍乡市",
"861572895", "西藏昌都地区",
"861359980", "福建省宁德市",
"861376795", "江西省南昌市",
"861860470", "内蒙古呼伦贝尔市",
"861805415", "甘肃省武威市",
"861508238", "四川省攀枝花市",
"861842059", "广东省阳江市",
"86130162", "海南省海口市",
"861844724", "内蒙古包头市",
"861379572", "四川省资阳市",
"861887117", "湖北省武汉市",
"861570692", "云南省德宏傣族景颇族自治州",
"861508602", "贵州省贵阳市",
"86137281", "广东省东莞市",
"86155357", "山西省临汾市",
"861563999", "河南省平顶山市",
"861558186", "山西省晋城市",
"861580478", "内蒙古巴彦淖尔市",
"861309525", "云南省大理白族自治州",
"86156083", "重庆市",
"861367300", "河南省驻马店市",
"861760672", "浙江省湖州市",
"861523318", "河北省衡水市",
"86150693", "山东省淄博市",
"861558616", "湖北省荆门市",
"861338245", "江苏省徐州市",
"861322123", "浙江省湖州市",
"861559942", "贵州省黔南布依族苗族自治州",
"861313846", "广东省广州市",
"861535260", "新疆石河子市",
"861883081", "河北省衡水市",
"861762526", "江苏省苏州市",
"861816827", "江苏省扬州市",
"86188660", "山东省德州市",
"861817049", "江西省赣州市",
"861350723", "湖北省黄石市",
"861768799", "江西省萍乡市",
"861886038", "河南省郑州市",
"861528246", "四川省泸州市",
"861818434", "贵州省六盘水市",
"861300765", "河南省焦作市",
"861582536", "宁夏石嘴山市",
"861346451", "辽宁省葫芦岛市",
"861516532", "山东省青岛市",
"861506662", "山东省德州市",
"86152551", "安徽省合肥市",
"86135250", "河南省新乡市",
"861835120", "江苏省常州市",
"861566030", "新疆阿克苏地区",
"861350155", "广东省深圳市",
"861373460", "青海省西宁市",
"861325595", "福建省泉州市",
"861833989", "河南省三门峡市",
"861555378", "山东省枣庄市",
"861313521", "湖南省长沙市",
"861870905", "新疆昌吉回族自治州",
"861808995", "西藏昌都地区",
"861819719", "青海省海东地区",
"861869758", "安徽省宿州市",
"861532756", "湖北省孝感市",
"861333798", "江苏省盐城市",
"861336856", "贵州省铜仁地区",
"861337599", "福建省泉州市",
"861346565", "山东省潍坊市",
"861308373", "河南省新乡市",
"861573869", "河南省许昌市",
"86157556", "安徽省安庆市",
"861553387", "河北省唐山市",
"861840551", "安徽省合肥市",
"861811172", "四川省泸州市",
"861890236", "广东省肇庆市",
"861350586", "浙江省台州市",
"86181408", "新疆乌鲁木齐市",
"861521788", "广东省珠海市",
"86182934", "甘肃省庆阳市",
"861323410", "辽宁省铁岭市",
"861314168", "江苏省南京市",
"861567408", "湖南省郴州市",
"861773147", "河北省唐山市",
"861893582", "新疆阿勒泰地区",
"861787602", "广东省梅州市",
"861380370", "河南省商丘市",
"861320935", "甘肃省武威市",
"861328306", "河南省平顶山市",
"861867168", "湖北省荆州市",
"861556401", "山东省菏泽市",
"861898759", "云南省昆明市",
"86136708", "广东省梅州市",
"861840465", "黑龙江省七台河市",
"86136695", "广东省惠州市",
"861329803", "内蒙古赤峰市",
"861853079", "河南省商丘市",
"861505784", "浙江省金华市",
"861803266", "河北省石家庄市",
"861865155", "江苏省盐城市",
"861573824", "河南省商丘市",
"861321722", "湖北省随州市",
"86138452", "黑龙江省齐齐哈尔市",
"861804817", "四川省绵阳市",
"861534066", "山西省太原市",
"86152870", "云南省昭通市",
"861862371", "河南省郑州市",
"861800858", "贵州省六盘水市",
"861766647", "广东省中山市",
"86151440", "吉林省长春市",
"861361716", "湖北省荆州市",
"86136716", "上海市",
"861354245", "广东省清远市",
"86159352", "山西省大同市",
"861816919", "宁夏固原市",
"861396305", "山东省日照市",
"861835937", "福建省宁德市",
"861531276", "江苏省泰州市",
"861860913", "陕西省渭南市",
"861369865", "山东省青岛市",
"861539454", "福建省福州市",
"86151062", "江苏省苏州市",
"861350645", "山东省烟台市",
"861595340", "山东省德州市",
"861344355", "山东省菏泽市",
"861347986", "江西省萍乡市",
"861588519", "贵州省毕节地区",
"861502976", "陕西省汉中市",
"861361395", "河南省漯河市",
"86156131", "河北省石家庄市",
"86185360", "山西省临汾市",
"86515", "江苏省盐城市",
"86170830", "河北省邯郸市",
"861459799", "新疆乌鲁木齐市",
"861853038", "河南省三门峡市",
"861590727", "湖北省襄樊市",
"861336497", "新疆石河子市",
"861360776", "广西百色市",
"861381947", "浙江省杭州市",
"86181416", "辽宁省锦州市",
"861809951", "新疆伊犁哈萨克自治州",
"86136975", "海南省海口市",
"86183379", "河南省洛阳市",
"861508918", "广东省珠海市",
"861534461", "黑龙江省齐齐哈尔市",
"861471787", "山西省长治市",
"861390885", "云南省昆明市",
"861367823", "四川省绵阳市",
"861329482", "内蒙古兴安盟",
"861310047", "广西贵港市",
"861554305", "吉林省吉林市",
"86138603", "福建省宁德市",
"861569356", "甘肃省金昌市",
"861879447", "甘肃省临夏回族自治州",
"861586387", "山东省临沂市",
"861306295", "江苏省泰州市",
"861450192", "山西省运城市",
"861534555", "安徽省马鞍山市",
"861529428", "甘肃省定西市",
"86150621", "江苏省徐州市",
"861815294", "新疆吐鲁番地区",
"861555339", "山东省日照市",
"861529208", "湖南省益阳市",
"86176898", "海南省海口市",
"861865645", "安徽省合肥市",
"861524620", "黑龙江省绥化市",
"861304486", "湖北省恩施土家族苗族自治州",
"861554218", "辽宁省沈阳市",
"861558169", "湖南省常德市",
"861529796", "江西省吉安市",
"861337280", "辽宁省铁岭市",
"861769249", "河北省邢台市",
"861334904", "安徽省亳州市",
"861336174", "江西省萍乡市",
"86183458", "黑龙江省双鸭山市",
"861588476", "四川省宜宾市",
"861476272", "江苏省淮安市",
"861593266", "河北省石家庄市",
"861309154", "黑龙江省绥化市",
"861313462", "山西省大同市",
"861778634", "湖北省荆州市",
"86132186", "江苏省常州市",
"861834443", "广东省清远市",
"86147607", "湖南省怀化市",
"861772026", "湖北省十堰市",
"861320809", "浙江省宁波市",
"861770348", "山西省运城市",
"86131995", "黑龙江省哈尔滨市",
"861303528", "湖北省十堰市",
"861858409", "四川省成都市",
"861357154", "陕西省渭南市",
"861760815", "四川省绵阳市",
"861454374", "山东省德州市",
"861569532", "青海省海东地区",
"861390253", "广东省珠海市",
"861321755", "广东省汕头市",
"861865122", "江苏省常州市",
"861554147", "辽宁省葫芦岛市",
"861536032", "广东省阳江市",
"861383929", "河南省濮阳市",
"861770482", "内蒙古兴安盟",
"86137758", "江苏省徐州市",
"861869827", "辽宁省辽阳市",
"861308945", "吉林省吉林市",
"861837549", "山东省临沂市",
"861874280", "新疆喀什地区",
"861359729", "广西南宁市",
"86153623", "广东省汕头市",
"861598995", "广东省佛山市",
"861816758", "新疆哈密地区",
"861813896", "广东省江门市",
"861810713", "湖北省黄冈市",
"86178535", "山东省烟台市",
"861858264", "四川省广安市",
"861356817", "四川省达州市",
"861317099", "江西省上饶市",
"861763313", "河北省张家口市",
"861325707", "江西省赣州市",
"861326389", "广西贵港市",
"861776735", "浙江省温州市",
"861862410", "辽宁省铁岭市",
"86137087", "云南省昆明市",
"861354751", "四川省广安市",
"861538938", "陕西省渭南市",
"86156518", "江苏省南京市",
"861780890", "西藏拉萨市",
"861533346", "山西省晋城市",
"861470330", "河北省邯郸市",
"861847672", "广东省湛江市",
"861810851", "贵州省贵阳市",
"861330547", "山东省济宁市",
"861870878", "云南省楚雄彝族自治州",
"861894792", "内蒙古呼和浩特市",
"86156561", "安徽省淮北市",
"861381471", "江苏省南通市",
"861576454", "黑龙江省佳木斯市",
"861363324", "河北省承德市",
"861452768", "广西南宁市",
"86131675", "北京市",
"861390574", "浙江省宁波市",
"861340427", "江苏省无锡市",
"861522494", "河南省驻马店市",
"861591640", "广东省惠州市",
"861772201", "广东省梅州市",
"861898918", "四川省南充市",
"861365695", "福建省宁德市",
"8613540", "四川省成都市",
"861538979", "内蒙古锡林郭勒盟",
"861309644", "四川省德阳市",
"861380411", "辽宁省大连市",
"86133374", "湖北省黄冈市",
"861830705", "江西省宜春市",
"861301690", "江苏省连云港市",
"861572956", "宁夏石嘴山市",
"861373998", "内蒙古呼和浩特市",
"861313674", "黑龙江省哈尔滨市",
"861810097", "青海省西宁市",
"861771129", "四川省成都市",
"861356964", "河南省鹤壁市",
"861871818", "广东省湛江市",
"861554657", "黑龙江省绥化市",
"861707045", "浙江省金华市",
"861357644", "江西省萍乡市",
"861879971", "新疆塔城地区",
"86180352", "山西省大同市",
"861590858", "贵州省六盘水市",
"861534522", "江苏省泰州市",
"861551639", "河南省洛阳市",
"861831859", "广东省湛江市",
"861881997", "广东省梅州市",
"861550068", "青海省海东地区",
"861324872", "浙江省宁波市",
"861821868", "广东省茂名市",
"861779935", "新疆哈密地区",
"861800727", "湖北省襄樊市",
"861813457", "安徽省淮北市",
"861334588", "浙江省温州市",
"861820080", "广东省肇庆市",
"861380666", "浙江省宁波市",
"861454267", "西藏阿里地区",
"861316865", "广东省珠海市",
"861771164", "湖南省衡阳市",
"861812253", "广东省河源市",
"861351489", "内蒙古包头市",
"861805864", "浙江省嘉兴市",
"861453816", "四川省绵阳市",
"861575226", "云南省红河哈尼族彝族自治州",
"861500916", "陕西省汉中市",
"861377229", "陕西省延安市",
"861807035", "江西省赣州市",
"861537721", "湖北省恩施土家族苗族自治州",
"861861371", "河南省郑州市",
"861809567", "安徽省亳州市",
"861887092", "江西省九江市",
"861362716", "湖北省荆州市",
"861452946", "广东省惠州市",
"861879945", "新疆阿克苏地区",
"861377409", "湖北省随州市",
"861399779", "湖北省恩施土家族苗族自治州",
"861870379", "河南省洛阳市",
"861860311", "河北省石家庄市",
"861813922", "新疆伊犁哈萨克自治州",
"861327214", "湖南省株洲市",
"861570736", "湖南省常德市",
"86182688", "浙江省杭州市",
"861550902", "新疆哈密地区",
"861322241", "江苏省镇江市",
"861705330", "广东省广州市",
"861320781", "广西南宁市",
"861830664", "广东省湛江市",
"861362395", "河南省漯河市",
"861589270", "四川省眉山市",
"861805237", "江苏省淮安市",
"861862973", "吉林省松原市",
"861454834", "广东省广州市",
"861351842", "四川省凉山彝族自治州",
"861523425", "山西省太原市",
"861320843", "黑龙江省牡丹江市",
"861381445", "江苏省泰州市",
"86153691", "河北省石家庄市",
"861472787", "陕西省宝鸡市",
"861840814", "四川省广安市",
"861336995", "新疆吐鲁番地区",
"861340952", "宁夏石嘴山市",
"86183519", "江苏省南京市",
"861834409", "广东省湛江市",
"861521903", "广东省韶关市",
"861802640", "广东省广州市",
"861341133", "广东省阳江市",
"86182030", "重庆市",
"861398032", "四川省广安市",
"861524158", "辽宁省丹东市",
"861587893", "广西钦州市",
"861323345", "山西省长治市",
"861829899", "甘肃省嘉峪关市",
"861857567", "广东省深圳市",
"861368778", "广西河池市",
"86139823", "四川省攀枝花市",
"86185858", "贵州省贵阳市",
"861853176", "河北省唐山市",
"861590359", "山西省运城市",
"861830629", "江苏省南通市",
"861355311", "山东省烟台市",
"86186877", "云南省玉溪市",
"861595415", "山东省聊城市",
"861308971", "黑龙江省哈尔滨市",
"86186386", "河南省郑州市",
"861581536", "广东省惠州市",
"861479925", "新疆伊犁哈萨克自治州",
"861369414", "辽宁省丹东市",
"861337302", "河北省保定市",
"86139549", "山东省临沂市",
"861520687", "山东省滨州市",
"861534089", "山西省临汾市",
"861840967", "宁夏中卫市",
"861320437", "吉林省辽源市",
"861350569", "安徽省合肥市",
"861584981", "内蒙古兴安盟",
"861335198", "黑龙江省哈尔滨市",
"861894344", "吉林省通化市",
"861315463", "四川省自贡市",
"861762584", "江苏省徐州市",
"861780762", "广东省河源市",
"861538657", "四川省泸州市",
"861337627", "江苏省常州市",
"861894860", "广东省东莞市",
"861324332", "河南省信阳市",
"861876745", "浙江省温州市",
"861830472", "内蒙古包头市",
"861348797", "湖南省邵阳市",
"861395135", "江苏省徐州市",
"86150544", "山东省潍坊市",
"861558522", "贵州省遵义市",
"861537242", "浙江省杭州市",
"861458203", "安徽省淮北市",
"861554979", "湖北省荆门市",
"861339316", "河北省廊坊市",
"86156459", "黑龙江省大庆市",
"861808497", "四川省宜宾市",
"861556109", "内蒙古包头市",
"861869239", "湖南省常德市",
"861770320", "河北省邯郸市",
"861458423", "河南省安阳市",
"861303540", "安徽省合肥市",
"861830014", "广东省阳江市",
"861309552", "安徽省蚌埠市",
"861802150", "江苏省南京市",
"861812172", "江苏省泰州市",
"861319570", "青海省海西蒙古族藏族自治州",
"861855256", "江苏省扬州市",
"861339795", "江西省宜春市",
"861322722", "湖北省随州市",
"86151398", "河南省三门峡市",
"861336572", "安徽省蚌埠市",
"861350524", "江苏省淮安市",
"86153971", "浙江省杭州市",
"861878644", "贵州省黔东南苗族侗族自治州",
"861470870", "云南省昭通市",
"861338813", "四川省德阳市",
"861477963", "江西省抚州市",
"861387298", "湖北省武汉市",
"86136927", "广东省惠州市",
"861870338", "河北省衡水市",
"861826537", "山东省济宁市",
"861399738", "青海省西宁市",
"861304598", "福建省三明市",
"861452341", "河南省洛阳市",
"861347983", "江西省景德镇市",
"861502973", "陕西省榆林市",
"86152098", "安徽省合肥市",
"861340018", "河北省邢台市",
"861536258", "广东省汕头市",
"861876114", "江苏省宿迁市",
"861877091", "江西省南昌市",
"861575994", "福建省莆田市",
"861360773", "广西桂林市",
"861500311", "河北省石家庄市",
"861316779", "安徽省六安市",
"861569567", "安徽省亳州市",
"861347560", "山东省淄博市",
"86188354", "山西省晋中市",
"861328848", "广东省广州市",
"861310831", "四川省宜宾市",
"861361713", "湖北省黄冈市",
"861850448", "吉林省延边朝鲜族自治州",
"86133792", "陕西省西安市",
"861471527", "广东省揭阳市",
"861594548", "黑龙江省牡丹江市",
"861513248", "河北省石家庄市",
"861860916", "陕西省汉中市",
"86170980", "浙江省杭州市",
"861367541", "山东省济南市",
"861313437", "吉林省辽源市",
"861569353", "甘肃省金昌市",
"861895671", "安徽省阜阳市",
"86147779", "广东省广州市",
"861776868", "江苏省南通市",
"861305902", "黑龙江省哈尔滨市",
"861533975", "甘肃省武威市",
"861590587", "浙江省温州市",
"861362514", "江苏省淮安市",
"861334091", "四川省乐山市",
"861537844", "四川省内江市",
"86183081", "四川省宜宾市",
"86187492", "河南省周口市",
"861537360", "河北省秦皇岛市",
"861814541", "黑龙江省七台河市",
"861570534", "山东省德州市",
"861531430", "山东省东营市",
"861365448", "吉林省延边朝鲜族自治州",
"861367826", "四川省广安市",
"861313308", "山西省吕梁市",
"861356548", "新疆伊犁哈萨克自治州",
"861532811", "四川省绵阳市",
"86159378", "河南省开封市",
"861336711", "湖北省鄂州市",
"86186544", "上海市",
"86181330", "安徽省安庆市",
"861838600", "贵州省铜仁地区",
"861554007", "内蒙古呼伦贝尔市",
"861327812", "吉林省四平市",
"861505524", "安徽省六安市",
"861310345", "山西省长治市",
"86155032", "河北省衡水市",
"861575141", "江苏省镇江市",
"861330818", "四川省成都市",
"861359290", "广东省揭阳市",
"861454608", "青海省海北藏族自治州",
"861336853", "贵州省安顺市",
"861308376", "河南省信阳市",
"86138478", "内蒙古巴彦淖尔市",
"86181993", "新疆和田地区",
"861313843", "广东省汕头市",
"861801965", "江苏省南通市",
"861554570", "黑龙江省鸡西市",
"861762523", "江苏省泰州市",
"861763507", "山西省晋城市",
"861563289", "河北省衡水市",
"861452835", "四川省雅安市",
"861871547", "安徽省池州市",
"861350726", "湖北省荆州市",
"861450632", "黑龙江省佳木斯市",
"86138264", "广东省广州市",
"861770761", "广东省汕尾市",
"861364394", "河南省周口市",
"861319979", "新疆阿勒泰地区",
"861528243", "四川省乐山市",
"861586085", "福建省三明市",
"861529192", "陕西省商洛市",
"861582533", "宁夏吴忠市",
"861709542", "江苏省南京市",
"861573090", "甘肃省甘南藏族自治州",
"86150386", "河南省洛阳市",
"861450428", "辽宁省大连市",
"861890470", "内蒙古呼伦贝尔市",
"861476059", "宁夏银川市",
"861361851", "贵州省贵阳市",
"861853225", "河北省张家口市",
"861597240", "湖北省咸宁市",
"861803263", "河北省廊坊市",
"861313781", "河南省开封市",
"861458484", "山东省青岛市",
"861339911", "陕西省延安市",
"861534063", "山西省忻州市",
"86182884", "云南省曲靖市",
"86135044", "吉林省长春市",
"861510425", "辽宁省铁岭市",
"861531554", "山东省青岛市",
"861857134", "湖北省随州市",
"861570450", "黑龙江省哈尔滨市",
"861396570", "安徽省阜阳市",
"861562150", "山东省日照市",
"861533592", "湖北省襄樊市",
"861890233", "广东省广州市",
"861350583", "浙江省嘉兴市",
"861315489", "内蒙古通辽市",
"861509239", "山东省临沂市",
"861361097", "辽宁省盘锦市",
"86180459", "黑龙江省大庆市",
"861568497", "湖南省永州市",
"861344057", "山东省日照市",
"861786894", "云南省昭通市",
"861348830", "陕西省商洛市",
"861370859", "贵州省黔西南布依族苗族自治州",
"861328303", "河南省濮阳市",
"861520799", "江西省萍乡市",
"861820457", "黑龙江省大庆市",
"861524495", "四川省凉山彝族自治州",
"86139695", "山东省聊城市",
"861557827", "广西崇左市",
"86138534", "山东省德州市",
"861459092", "广东省茂名市",
"861309785", "广西玉林市",
"861556049", "内蒙古通辽市",
"861552199", "广东省河源市",
"86132441", "陕西省延安市",
"861818718", "云南省西双版纳傣族自治州",
"861868759", "云南省保山市",
"86139708", "江西省南昌市",
"861331379", "福建省南平市",
"861533194", "黑龙江省哈尔滨市",
"861530933", "甘肃省平凉市",
"86145929", "重庆市",
"861895155", "江苏省盐城市",
"861814992", "新疆伊犁哈萨克自治州",
"861397282", "湖北省咸宁市",
"86183133", "云南省红河哈尼族彝族自治州",
"86183746", "湖南省永州市",
"861315842", "四川省达州市",
"861844584", "黑龙江省伊春市",
"861330319", "河北省邢台市",
"861317636", "山东省潍坊市",
"86134617", "河南省濮阳市",
"861597408", "湖南省永州市",
"861895723", "浙江省舟山市",
"861473015", "河北省秦皇岛市",
"861303177", "山东省淄博市",
"861363735", "湖南省郴州市",
"861785878", "浙江省嘉兴市",
"861575175", "江苏省扬州市",
"861596030", "福建省龙岩市",
"861558183", "山西省太原市",
"86155495", "湖北省孝感市",
"861521540", "山东省菏泽市",
"861875890", "浙江省金华市",
"86180506", "福建省漳州市",
"86158520", "江苏省徐州市",
"861320674", "黑龙江省哈尔滨市",
"86158542", "山东省青岛市",
"861364221", "广东省汕头市",
"861558613", "湖北省荆州市",
"861899758", "新疆伊犁哈萨克自治州",
"861370358", "山西省太原市",
"861322126", "浙江省金华市",
"861310371", "河南省郑州市",
"86188169", "上海市",
"861501831", "广东省珠海市",
"861817401", "江西省南昌市",
"861357785", "云南省大理白族自治州",
"861889595", "云南省昆明市",
"861592965", "陕西省商洛市",
"861771537", "江苏省苏州市",
"861321184", "云南省昭通市",
"86137446", "吉林省吉林市",
"861319218", "广东省汕头市",
"861576939", "甘肃省兰州市",
"861808285", "新疆阿勒泰地区",
"861364742", "湖南省常德市",
"861328349", "河北省秦皇岛市",
"861700898", "海南省海口市",
"861834790", "内蒙古锡林郭勒盟",
"861348370", "河北省衡水市",
"861839626", "福建省漳州市",
"861332905", "安徽省马鞍山市",
"861453271", "山西省朔州市",
"861819012", "四川省巴中市",
"861458798", "湖南省长沙市",
"861562432", "山东省德州市",
"861557919", "江西省上饶市",
"861700261", "广东省江门市",
"861571953", "宁夏吴忠市",
"861533941", "甘肃省平凉市",
"861365420", "辽宁省大连市",
"861321064", "山东省日照市",
"861785839", "浙江省湖州市",
"86131550", "安徽省滁州市",
"861323976", "新疆和田地区",
"861306985", "黑龙江省七台河市",
"861301425", "宁夏银川市",
"861815984", "福建省南平市",
"861817742", "广西梧州市",
"861370412", "辽宁省鞍山市",
"86180561", "安徽省淮北市",
"861583049", "河北省邢台市",
"861301205", "河北省保定市",
"861882620", "广东省珠海市",
"861893275", "河北省沧州市",
"861362682", "浙江省宁波市",
"86180518", "江苏省苏州市",
"861302927", "辽宁省铁岭市",
"861709991", "广东省珠海市",
"86159131", "广东省广州市",
"861303903", "吉林省四平市",
"861889972", "广东省云浮市",
"861335455", "黑龙江省绥化市",
"861370074", "河南省三门峡市",
"861780737", "湖南省益阳市",
"861565340", "山东省德州市",
"861377790", "浙江省金华市",
"86189825", "四川省遂宁市",
"861528429", "河北省邢台市",
"861331338", "河北省承德市",
"861390776", "广西百色市",
"861327459", "黑龙江省大庆市",
"861317193", "河北省廊坊市",
"861473665", "云南省昭通市",
"861579739", "湖北省武汉市",
"861560727", "湖北省襄樊市",
"861309333", "安徽省铜陵市",
"861331407", "辽宁省营口市",
"86178353", "山西省运城市",
"861335561", "安徽省淮北市",
"861308836", "四川省攀枝花市",
"861366305", "河南省南阳市",
"86156352", "山西省晋中市",
"861840932", "甘肃省定西市",
"861896958", "浙江省丽水市",
"861890913", "陕西省渭南市",
"861819474", "青海省海东地区",
"861803444", "河北省唐山市",
"861573741", "河南省濮阳市",
"861389545", "宁夏吴忠市",
"86145874", "广东省广州市",
"861315466", "四川省自贡市",
"861831265", "广东省梅州市",
"861350784", "广西梧州市",
"861588347", "四川省凉山彝族自治州",
"861576805", "广东省汕尾市",
"86155585", "浙江省台州市",
"861829610", "江西省新余市",
"86183563", "安徽省宣城市",
"86187328", "河北省衡水市",
"861874990", "河南省濮阳市",
"861327675", "浙江省绍兴市",
"861866662", "广东省广州市",
"861889707", "青海省海西蒙古族藏族自治州",
"861581533", "广东省汕头市",
"861895122", "江苏省常州市",
"861768248", "浙江省杭州市",
"861373157", "河北省邢台市",
"861872547", "云南省曲靖市",
"861332878", "福建省厦门市",
"861899827", "广东省揭阳市",
"861477720", "广西柳州市",
"861315181", "江苏省宿迁市",
"86152362", "河南省洛阳市",
"861764059", "辽宁省盘锦市",
"861328901", "新疆和田地区",
"861539939", "陕西省商洛市",
"861815892", "安徽省阜阳市",
"861362851", "贵州省贵阳市",
"861867942", "江西省南昌市",
"861477966", "江西省吉安市",
"861533309", "山西省运城市",
"861338816", "四川省成都市",
"861801467", "江苏省盐城市",
"861777601", "广西南宁市",
"861807337", "湖南省长沙市",
"861507168", "湖北省黄冈市",
"861301318", "安徽省安庆市",
"86188539", "山东省临沂市",
"861339313", "河北省张家口市",
"861458206", "安徽省黄山市",
"861807408", "浙江省嘉兴市",
"86134580", "四川省绵阳市",
"861458426", "河南省新乡市",
"861855253", "江苏省镇江市",
"861821981", "甘肃省兰州市",
"861880850", "贵州省贵阳市",
"86130722", "天津市",
"86150825", "四川省遂宁市",
"861459248", "四川省攀枝花市",
"861570733", "湖南省长沙市",
"861823682", "河南省许昌市",
"861510130", "甘肃省兰州市",
"861564964", "河南省新乡市",
"86180131", "江苏省苏州市",
"861508052", "福建省南平市",
"861539978", "湖南省常德市",
"861862976", "吉林省白山市",
"861311470", "广西防城港市",
"861518070", "贵州省贵阳市",
"86130740", "安徽省安庆市",
"861778592", "贵州省贵阳市",
"861500913", "陕西省渭南市",
"861593444", "山西省运城市",
"861535342", "陕西省铜川市",
"861891345", "江苏省徐州市",
"861310410", "辽宁省铁岭市",
"861315061", "云南省红河哈尼族彝族自治州",
"861533477", "内蒙古鄂尔多斯市",
"861347381", "河北省衡水市",
"861560858", "贵州省六盘水市",
"861313935", "甘肃省武威市",
"861510819", "四川省泸州市",
"861452943", "广东省韶关市",
"861362713", "湖北省武汉市",
"861839512", "宁夏石嘴山市",
"861505645", "安徽省芜湖市",
"861559088", "黑龙江省哈尔滨市",
"861587896", "广西钦州市",
"861589436", "云南省迪庆藏族自治州",
"861476585", "宁夏银川市",
"861361514", "江苏省淮安市",
"861317792", "江西省九江市",
"861459117", "广西桂林市",
"861332680", "广东省江门市",
"861853173", "河北省唐山市",
"861475104", "江苏省常州市",
"861530871", "云南省昆明市",
"861459687", "新疆石河子市",
"861320846", "黑龙江省大庆市",
"861334740", "陕西省西安市",
"861345542", "山东省东营市",
"861536739", "湖南省邵阳市",
"861373288", "吉林省通化市",
"861335638", "山东省烟台市",
"861332839", "福建省南平市",
"86184770", "广西玉林市",
"86159518", "江苏省南京市",
"861366657", "浙江省丽水市",
"861519245", "山东省菏泽市",
"86135922", "河南省周口市",
"861816510", "陕西省西安市",
"861829060", "新疆阿克苏地区",
"861550390", "河南省焦作市",
"861521906", "广东省肇庆市",
"861561640", "湖南省邵阳市",
"861868918", "西藏拉萨市",
"861335422", "辽宁省沈阳市",
"861814884", "广东省云浮市",
"861341136", "广东省珠海市",
"86159561", "安徽省淮北市",
"861360574", "浙江省宁波市",
"861532430", "河北省邯郸市",
"861306600", "山东省济南市",
"861898025", "四川省泸州市",
"861569951", "吉林省吉林市",
"861532642", "吉林省长春市",
"861800587", "浙江省温州市",
"861577535", "四川省遂宁市",
"861780069", "内蒙古呼伦贝尔市",
"861873564", "山西省晋城市",
"861357931", "新疆喀什地区",
"861572953", "宁夏吴忠市",
"861334728", "湖南省娄底市",
"861884949", "河北省邢台市",
"861322064", "山东省日照市",
"861479668", "江西省赣州市",
"861510318", "河北省衡水市",
"861786982", "云南省昆明市",
"861865498", "山东省临沂市",
"861560359", "山西省运城市",
"861505671", "安徽省宿州市",
"86136823", "广东省深圳市",
"861345144", "河北省邯郸市",
"861561628", "湖南省湘潭市",
"861331905", "新疆昌吉回族自治州",
"861393868", "河南省安阳市",
"861867591", "广东省揭阳市",
"861881620", "江苏省无锡市",
"861533343", "山西省太原市",
"861571351", "山西省太原市",
"861361682", "浙江省温州市",
"861511378", "广东省云浮市",
"861363981", "河南省驻马店市",
"861329761", "湖北省荆门市",
"86180378", "河南省郑州市",
"861503241", "河北省唐山市",
"86187582", "浙江省杭州市",
"861302425", "浙江省湖州市",
"861335957", "黑龙江省齐齐哈尔市",
"86188605", "山东省滨州市",
"861707910", "浙江省宁波市",
"86138359", "山西省运城市",
"861583515", "山西省长治市",
"861890311", "河北省石家庄市",
"86188798", "江西省景德镇市",
"861301927", "吉林省吉林市",
"861380663", "浙江省宁波市",
"86134348", "广东省佛山市",
"861453813", "四川省成都市",
"861812256", "广东省茂名市",
"861575223", "云南省曲靖市",
"861306487", "江苏省盐城市",
"861778194", "四川省达州市",
"861309931", "甘肃省甘南藏族自治州",
"861380797", "江西省赣州市",
"861506637", "山东省济宁市",
"861478712", "云南省大理白族自治州",
"861450315", "河北省唐山市",
"861335380", "河南省郑州市",
"861528121", "四川省攀枝花市",
"861459400", "云南省红河哈尼族彝族自治州",
"861303301", "安徽省蚌埠市",
"861327151", "河南省洛阳市",
"861588473", "四川省达州市",
"861593263", "河北省廊坊市",
"861834446", "广东省汕尾市",
"86139927", "陕西省宝鸡市",
"861529667", "山西省临汾市",
"861772023", "湖北省鄂州市",
"861551199", "河北省邢台市",
"861888814", "江苏省苏州市",
"861332379", "河南省洛阳市",
"861707347", "河北省唐山市",
"86159459", "黑龙江省哈尔滨市",
"861304483", "湖北省恩施土家族苗族自治州",
"861530331", "河北省石家庄市",
"861843488", "山西省运城市",
"86151329", "河北省邢台市",
"861529793", "江西省上饶市",
"861318454", "江西省赣州市",
"86137772", "浙江省宁波市",
"861846431", "山东省淄博市",
"861813893", "广东省佛山市",
"861810716", "湖北省荆州市",
"861864860", "内蒙古包头市",
"86186693", "山东省威海市",
"861763316", "河北省廊坊市",
"861301819", "四川省德阳市",
"861321126", "广东省江门市",
"861580954", "宁夏固原市",
"861477748", "广西河池市",
"861522540", "河南省洛阳市",
"86180083", "重庆市",
"861580691", "山东省临沂市",
"861803999", "河南省许昌市",
"861308010", "河南省濮阳市",
"861501410", "广东省深圳市",
"861599134", "陕西省西安市",
"861317344", "山东省临沂市",
"86135659", "新疆乌鲁木齐市",
"861340531", "山东省济南市",
"86185305", "河南省安阳市",
"861322614", "广东省潮州市",
"861479018", "安徽省宣城市",
"861390256", "广东省佛山市",
"861778941", "甘肃省甘南藏族自治州",
"861500470", "内蒙古呼伦贝尔市",
"86189386", "广东省深圳市",
"861810395", "河南省漯河市",
"861327641", "山东省济南市",
"861533808", "广东省广州市",
"861859240", "陕西省榆林市",
"861524997", "安徽省蚌埠市",
"86183472", "内蒙古包头市",
"861820955", "宁夏中卫市",
"861322184", "浙江省嘉兴市",
"861312311", "福建省泉州市",
"861818677", "湖北省神农架林区",
"861517469", "黑龙江省牡丹江市",
"861589269", "四川省雅安市",
"861852738", "湖北省黄冈市",
"861390548", "山东省泰安市",
"861809009", "四川省成都市",
"861365637", "山东省枣庄市",
"861330613", "江苏省苏州市",
"861454803", "广东省清远市",
"861533565", "内蒙古赤峰市",
"861837534", "安徽省芜湖市",
"861882308", "广东省江门市",
"861399760", "湖北省荆州市",
"861584505", "黑龙江省绥化市",
"861315278", "山西省吕梁市",
"86157781", "广西南宁市",
"86137919", "山东省青岛市",
"861882437", "广东省东莞市",
"861556587", "河南省商丘市",
"861304311", "河北省石家庄市",
"861810035", "山西省太原市",
"861862589", "河南省三门峡市",
"861518890", "河北省邯郸市",
"861800146", "江苏省南通市",
"861896382", "新疆石河子市",
"861571443", "吉林省延边朝鲜族自治州",
"861378043", "河北省保定市",
"861313648", "浙江省台州市",
"861776013", "四川省乐山市",
"861318499", "河北省唐山市",
"86132498", "广东省深圳市",
"861527123", "湖北省武汉市",
"861323290", "广东省江门市",
"861334213", "辽宁省抚顺市",
"861894838", "广东省揭阳市",
"86181315", "河北省唐山市",
"861475136", "江苏省徐州市",
"861303812", "四川省乐山市",
"861589224", "四川省自贡市",
"861803954", "河南省郑州市",
"86158383", "河南省郑州市",
"861850637", "山东省枣庄市",
"861530857", "贵州省毕节地区",
"861471542", "广东省清远市",
"861580999", "新疆伊犁哈萨克自治州",
"861880722", "湖北省武汉市",
"861868593", "贵州省遵义市",
"861832292", "江西省宜春市",
"861394587", "黑龙江省伊春市",
"861360780", "广西柳州市",
"861558319", "四川省广元市",
"861521934", "广东省阳江市",
"861362240", "广东省茂名市",
"861780911", "陕西省延安市",
"861366671", "浙江省舟山市",
"861341104", "广东省佛山市",
"861313287", "广西贺州市",
"861587076", "江西省抚州市",
"86183209", "广东省深圳市",
"861820310", "河北省邯郸市",
"861502980", "陕西省西安市",
"861528887", "山东省济南市",
"861829405", "甘肃省平凉市",
"86152786", "广西百色市",
"861332098", "四川省成都市",
"861884641", "黑龙江省哈尔滨市",
"861336148", "山东省青岛市",
"861804256", "浙江省金华市",
"861889084", "新疆巴音郭楞蒙古自治州",
"861306415", "江西省九江市",
"861350570", "浙江省衢州市",
"861815414", "安徽省宣城市",
"861396583", "安徽省安庆市",
"86150649", "山东省临沂市",
"861560394", "河南省周口市",
"861570928", "陕西省西安市",
"861351510", "江苏省南京市",
"861319524", "贵州省黔南布依族苗族自治州",
"861363689", "陕西省咸阳市",
"861534818", "四川省成都市",
"861770374", "河南省许昌市",
"86185767", "广东省深圳市",
"86152853", "贵州省黔南布依族苗族自治州",
"861820947", "甘肃省嘉峪关市",
"86139644", "山东省淄博市",
"8613442", "上海市",
"861454482", "湖北省武汉市",
"861516046", "福建省莆田市",
"861882781", "江西省宜春市",
"861512196", "宁夏石嘴山市",
"861350007", "广东省茂名市",
"861800656", "浙江省台州市",
"86180967", "安徽省阜阳市",
"861774017", "四川省成都市",
"861315239", "陕西省渭南市",
"861509489", "山东省淄博市",
"861890483", "内蒙古阿拉善盟",
"861882843", "四川省泸州市",
"861867425", "湖北省宜昌市",
"861470869", "贵州省安顺市",
"861368392", "河南省南阳市",
"861516702", "浙江省绍兴市",
"861324799", "江西省萍乡市",
"861824988", "黑龙江省伊春市",
"861879198", "陕西省西安市",
"861571837", "广东省揭阳市",
"861362877", "云南省玉溪市",
"861530496", "辽宁省本溪市",
"861477852", "广东省茂名市",
"861592826", "四川省广安市",
"861705368", "广东省深圳市",
"861454348", "山东省潍坊市",
"861302591", "广西南宁市",
"861865007", "福建省福州市",
"861846715", "青海省果洛藏族自治州",
"86138230", "广东省珠海市",
"861776797", "吉林省辽源市",
"861592541", "云南省西双版纳傣族自治州",
"86155444", "河南省驻马店市",
"861778159", "四川省乐山市",
"861314425", "广东省汕头市",
"861319569", "安徽省淮北市",
"86155683", "吉林省吉林市",
"86135273", "重庆市",
"861450950", "江苏省连云港市",
"861458234", "安徽省淮南市",
"86183665", "山东省潍坊市",
"861554960", "湖北省孝感市",
"861801575", "四川省泸州市",
"86159632", "山东省青岛市",
"86132013", "新疆乌鲁木齐市",
"861836804", "浙江省杭州市",
"861327903", "新疆和田地区",
"861509842", "山东省聊城市",
"861534319", "河北省邢台市",
"861860486", "内蒙古赤峰市",
"86132807", "山东省潍坊市",
"861562823", "新疆和田地区",
"861310729", "湖南省邵阳市",
"861303459", "山东省威海市",
"861355161", "四川省广安市",
"861857043", "湖南省湘西土家族苗族自治州",
"861571264", "浙江省嘉兴市",
"861597682", "广东省湛江市",
"861700693", "广东省深圳市",
"86145057", "上海市",
"861334933", "黑龙江省双鸭山市",
"861822411", "四川省巴中市",
"861773784", "河南省郑州市",
"861700767", "广东省茂名市",
"861348735", "湖南省郴州市",
"86186595", "福建省泉州市",
"861454320", "内蒙古呼和浩特市",
"861894378", "吉林省白城市",
"861858895", "广东省深圳市",
"861821830", "广东省清远市",
"861320495", "湖南省永州市",
"86152041", "辽宁省锦州市",
"861558170", "山西省忻州市",
"861705824", "北京市",
"861315827", "贵州省毕节地区",
"861311598", "福建省三明市",
"861872461", "黑龙江省哈尔滨市",
"861331721", "湖北省荆州市",
"861769914", "新疆喀什地区",
"861708471", "内蒙古呼和浩特市",
"861570940", "甘肃省平凉市",
"861599106", "陕西省汉中市",
"86138560", "安徽省合肥市",
"861830384", "河南省安阳市",
"861571409", "辽宁省辽阳市",
"861848582", "贵州省毕节地区",
"86156216", "山东省潍坊市",
"861884675", "黑龙江省哈尔滨市",
"861881215", "河北省唐山市",
"861808435", "贵州省贵阳市",
"86717", "湖北省宜昌市",
"861812520", "广东省中山市",
"861319122", "山西省大同市",
"861872555", "安徽省马鞍山市",
"861459556", "青海省玉树藏族自治州",
"86186240", "辽宁省沈阳市",
"861373145", "河北省石家庄市",
"86180819", "四川省成都市",
"861557842", "广西崇左市",
"861847558", "广东省阳江市",
"861519618", "四川省凉山彝族自治州",
"861822666", "安徽省滁州市",
"861339737", "湖南省益阳市",
"861454849", "广东省深圳市",
"8618971", "湖北省武汉市",
"861818651", "湖北省武汉市",
"861398900", "西藏拉萨市",
"861452730", "湖南省岳阳市",
"861818994", "西藏林芝地区",
"861555636", "安徽省阜阳市",
"861809043", "四川省阿坝藏族羌族自治州",
"861457023", "江西省上饶市",
"861850958", "宁夏银川市",
"86153844", "广东省广州市",
"86155637", "山东省济宁市",
"86137867", "湖南省益阳市",
"861564885", "内蒙古巴彦淖尔市",
"86150950", "山东省聊城市",
"861331242", "贵州省黔东南苗族侗族自治州",
"861520553", "安徽省芜湖市",
"861362408", "辽宁省大连市",
"861519068", "江苏省徐州市",
"861570317", "河北省沧州市",
"861505657", "安徽省合肥市",
"861538960", "陕西省渭南市",
"861869244", "湖南省郴州市",
"861878880", "安徽省宣城市",
"861807097", "广西玉林市",
"86134755", "山东省淄博市",
"861571377", "河南省南阳市",
"861552876", "四川省乐山市",
"861362337", "河北省衡水市",
"861878639", "贵州省黔南布依族苗族自治州",
"8613374", "山西省太原市",
"861898596", "贵州省黔西南布依族苗族自治州",
"861479190", "陕西省铜川市",
"861581298", "广东省韶关市",
"86181159", "江苏省泰州市",
"861560742", "湖南省常德市",
"861538583", "安徽省阜阳市",
"861335971", "黑龙江省哈尔滨市",
"86139437", "吉林省辽源市",
"861328609", "河北省邢台市",
"861367965", "四川省眉山市",
"861826972", "安徽省安庆市",
"86153735", "河北省唐山市",
"861313620", "浙江省嘉兴市",
"861336937", "甘肃省酒泉市",
"861895305", "山东省东营市",
"861365958", "西藏山南地区",
"86155750", "湖南省岳阳市",
"861594776", "内蒙古呼伦贝尔市",
"861339481", "内蒙古呼伦贝尔市",
"861368744", "广东省佛山市",
"861363370", "河南省商丘市",
"861364727", "湖北省宜昌市",
"861390520", "江苏省徐州市",
"861894339", "吉林省松原市",
"861700136", "海南省海口市",
"861459065", "广东省云浮市",
"861337756", "广东省珠海市",
"861859097", "陕西省宝鸡市",
"861538726", "湖北省十堰市",
"861708076", "湖南省岳阳市",
"861828078", "四川省绵阳市",
"861323566", "湖北省十堰市",
"861319586", "甘肃省白银市",
"861887274", "湖北省黄冈市",
"861832020", "广东省惠州市",
"861598435", "四川省乐山市",
"861331098", "陕西省西安市",
"861533649", "山东省滨州市",
"861538498", "新疆喀什地区",
"861373479", "内蒙古赤峰市",
"861318944", "广东省江门市",
"861886610", "山东省济南市",
"861560653", "浙江省杭州市",
"861859682", "福建省三明市",
"861811548", "江苏省苏州市",
"861398685", "湖北省恩施土家族苗族自治州",
"861527275", "湖北省孝感市",
"861365719", "湖北省十堰市",
"861566618", "山东省菏泽市",
"861399508", "宁夏银川市",
"861470886", "云南省怒江傈僳族自治州",
"861800049", "河北省邢台市",
"861380324", "河北省秦皇岛市",
"861535279", "新疆伊犁哈萨克自治州",
"861317765", "江西省抚州市",
"861889026", "湖南省衡阳市",
"86158124", "广东省广州市",
"86159819", "河南省郑州市",
"86132322", "广东省珠海市",
"861361877", "云南省玉溪市",
"861551336", "山西省太原市",
"861319723", "湖北省恩施土家族苗族自治州",
"861572837", "广东省湛江市",
"861301591", "福建省厦门市",
"861510942", "甘肃省甘南藏族自治州",
"861895147", "江苏省淮安市",
"861311802", "四川省泸州市",
"861807112", "湖北省武汉市",
"861853060", "河南省安阳市",
"861380369", "黑龙江省双鸭山市",
"861319155", "内蒙古锡林郭勒盟",
"861476306", "山东省滨州市",
"861523088", "河北省承德市",
"861509181", "陕西省延安市",
"861802575", "广东省汕尾市",
"861306917", "吉林省吉林市",
"861335833", "福建省漳州市",
"861360817", "四川省成都市",
"861808658", "湖北省黄冈市",
"86138130", "江苏省南京市",
"861344071", "湖北省武汉市",
"861368509", "福建省宁德市",
"86186485", "内蒙古通辽市",
"861588322", "四川省资阳市",
"86184189", "重庆市",
"861569475", "内蒙古通辽市",
"861889421", "甘肃省天水市",
"861829907", "新疆石河子市",
"861868794", "云南省普洱市",
"861870581", "浙江省杭州市",
"861364858", "贵州省六盘水市",
"861333372", "河南省安阳市",
"861335447", "山东省聊城市",
"861318191", "山东省淄博市",
"861523168", "河北省承德市",
"861818882", "广东省佛山市",
"861533159", "云南省曲靖市",
"861360964", "广东省广州市",
"861767128", "湖北省荆门市",
"861572443", "辽宁省丹东市",
"861853180", "河北省衡水市",
"861516149", "江苏省南京市",
"861560143", "江苏省泰州市",
"861587138", "湖北省武汉市",
"861815865", "浙江省绍兴市",
"861306340", "安徽省宿州市",
"861881437", "广东省广州市",
"861708310", "河北省邯郸市",
"861808217", "江苏省盐城市",
"861374733", "内蒙古乌海市",
"861309717", "江西省赣州市",
"861535327", "陕西省安康市",
"861539568", "安徽省马鞍山市",
"861373438", "山东省临沂市",
"861564574", "黑龙江省黑河市",
"861802992", "广东省中山市",
"861459332", "四川省宜宾市",
"861816244", "湖北省黄冈市",
"861530740", "湖南省岳阳市",
"86181575", "浙江省绍兴市",
"861780313", "河北省张家口市",
"86189950", "宁夏银川市",
"861565985", "福建省泉州市",
"861882935", "陕西省西安市",
"861303675", "湖南省张家界市",
"861334871", "湖南省长沙市",
"861573688", "河南省开封市",
"861535238", "甘肃省金昌市",
"861316923", "广东省梅州市",
"861501980", "广东省惠州市",
"861589286", "四川省德阳市",
"86155962", "陕西省延安市",
"861319645", "江苏省扬州市",
"861345033", "广东省韶关市",
"861831292", "浙江省温州市",
"861568962", "山东省日照市",
"861361240", "广东省汕头市",
"861373307", "安徽省宿州市",
"86139521", "江苏省徐州市",
"861342104", "广东省梅州市",
"861576631", "广东省肇庆市",
"861808148", "四川省自贡市",
"861307047", "新疆伊犁哈萨克自治州",
"861330782", "广西柳州市",
"861368543", "山东省滨州市",
"861361408", "辽宁省大连市",
"861335373", "河南省新乡市",
"861550816", "四川省绵阳市",
"861760558", "安徽省阜阳市",
"861589993", "广东省东莞市",
"861536685", "江苏省扬州市",
"86133619", "上海市",
"861504838", "内蒙古赤峰市",
"861474714", "内蒙古乌兰察布市",
"861452453", "黑龙江省牡丹江市",
"861810362", "黑龙江省齐齐哈尔市",
"861323589", "浙江省金华市",
"861361228", "广东省江门市",
"861814467", "广东省珠海市",
"86156863", "陕西省商洛市",
"861336435", "吉林省通化市",
"861561282", "河北省衡水市",
"861314318", "广东省佛山市",
"861364359", "山西省运城市",
"861329374", "山西省太原市",
"861361337", "河北省秦皇岛市",
"861572377", "广西钦州市",
"861303641", "四川省自贡市",
"86156108", "河北省衡水市",
"861820076", "广东省惠州市",
"861334845", "福建省漳州市",
"861510591", "福建省莆田市",
"861508260", "四川省宜宾市",
"861530728", "湖北省十堰市",
"861379658", "黑龙江省绥化市",
"86182905", "重庆市",
"861532302", "广东省梅州市",
"861378106", "河南省平顶山市",
"861538784", "江西省赣州市",
"861306328", "安徽省安庆市",
"861843279", "河北省邢台市",
"861813698", "江苏省苏州市",
"861339619", "湖北省恩施土家族苗族自治州",
"861818449", "贵州省遵义市",
"861880755", "广东省深圳市",
"861823240", "河北省承德市",
"861873974", "河南省安阳市",
"861871066", "陕西省汉中市",
"861890598", "福建省三明市",
"861584663", "黑龙江省哈尔滨市",
"861532627", "辽宁省朝阳市",
"861533603", "甘肃省平凉市",
"861892357", "广东省汕尾市",
"861364034", "广东省广州市",
"861787596", "广东省揭阳市",
"861520754", "广东省汕头市",
"86134323", "广东省茂名市",
"861370894", "山东省淄博市",
"861830535", "山东省烟台市",
"861552552", "山西省晋城市",
"861773726", "河南省安阳市",
"861841901", "甘肃省天水市",
"861820471", "内蒙古呼和浩特市",
"861874276", "新疆喀什地区",
"861843238", "河北省衡水市",
"861871616", "四川省宜宾市",
"86134284", "广东省东莞市",
"861843602", "河南省驻马店市",
"861899489", "江苏省扬州市",
"86159967", "江苏省宿迁市",
"861334331", "河北省石家庄市",
"861310980", "辽宁省大连市",
"861822689", "安徽省阜阳市",
"861569702", "云南省大理白族自治州",
"861808937", "甘肃省酒泉市",
"861555344", "山东省烟台市",
"861868342", "四川省成都市",
"861860424", "辽宁省本溪市",
"861346346", "河北省张家口市",
"861317604", "山东省枣庄市",
"861338390", "河南省平顶山市",
"861379148", "山东省菏泽市",
"861327301", "河南省周口市",
"861472654", "四川省内江市",
"861329058", "河北省衡水市",
"861366569", "安徽省合肥市",
"861325537", "山东省济宁市",
"861339069", "江苏省盐城市",
"861472991", "陕西省延安市",
"861453618", "江苏省扬州市",
"861576700", "广东省深圳市",
"861811520", "江苏省连云港市",
"86187965", "江苏省盐城市",
"861871461", "黑龙江省哈尔滨市",
"861312598", "黑龙江省哈尔滨市",
"861388630", "湖北省鄂州市",
"861314452", "黑龙江省齐齐哈尔市",
"861332721", "湖南省长沙市",
"86147912", "陕西省榆林市",
"861304470", "河南省郑州市",
"861310357", "山西省临汾市",
"861572409", "广东省深圳市",
"861773960", "河南省漯河市",
"861832048", "广东省湛江市",
"861816463", "云南省普洱市",
"861569046", "河北省廊坊市",
"861477825", "广东省肇庆市",
"861860469", "黑龙江省双鸭山市",
"861536546", "江苏省连云港市",
"861384954", "河南省平顶山市",
"86139593", "福建省宁德市",
"86182778", "广西河池市",
"861830326", "河北省沧州市",
"861587947", "江西省新余市",
"861823877", "河南省新乡市",
"861871555", "安徽省马鞍山市",
"861339024", "辽宁省沈阳市",
"861379217", "山东省淄博市",
"861884812", "内蒙古包头市",
"861379302", "山东省菏泽市",
"861580537", "山东省济宁市",
"861890702", "江西省九江市",
"861511923", "广东省河源市",
"861317072", "云南省曲靖市",
"861306980", "黑龙江省鸡西市",
"861572189", "云南省昆明市",
"86152776", "广西百色市",
"861560489", "黑龙江省大庆市",
"861301420", "宁夏石嘴山市",
"861364239", "广东省东莞市",
"861802498", "广东省湛江市",
"861562671", "广东省茂名市",
"861572619", "山东省德州市",
"861330141", "江苏省盐城市",
"861301200", "河北省廊坊市",
"861760527", "江苏省宿迁市",
"861453228", "浙江省金华市",
"861893270", "河北省邯郸市",
"861841966", "甘肃省张掖市",
"861880822", "四川省自贡市",
"861373932", "甘肃省定西市",
"861348375", "河北省唐山市",
"861327366", "河北省邢台市",
"861530757", "广东省佛山市",
"86155993", "贵州省毕节地区",
"861528036", "福建省龙岩市",
"861772954", "陕西省延安市",
"861360639", "山东省青岛市",
"861321436", "吉林省白城市",
"861361068", "山西省临汾市",
"861864072", "辽宁省盘锦市",
"86158373", "河南省新乡市",
"861332900", "安徽省滁州市",
"861576921", "陕西省宝鸡市",
"861367570", "浙江省衢州市",
"86176372", "河南省安阳市",
"86155330", "河北省邯郸市",
"861365425", "辽宁省大连市",
"861571481", "内蒙古呼和浩特市",
"861522624", "宁夏固原市",
"861775269", "湖南省娄底市",
"861894738", "内蒙古巴彦淖尔市",
"861453337", "浙江省衢州市",
"86186427", "辽宁省盘锦市",
"86134335", "广东省惠州市",
"861843412", "山西省太原市",
"861306357", "江苏省南通市",
"861899109", "陕西省榆林市",
"86150793", "江西省上饶市",
"86152915", "陕西省安康市",
"86135567", "广东省东莞市",
"861366300", "河南省郑州市",
"861517134", "湖北省黄冈市",
"861352587", "河南省三门峡市",
"861501340", "广东省湛江市",
"861335450", "黑龙江省哈尔滨市",
"861317414", "江苏省徐州市",
"861870744", "湖南省张家界市",
"86157771", "广西南宁市",
"861775404", "安徽省宣城市",
"861522669", "河北省廊坊市",
"861535859", "江苏省镇江市",
"861532658", "黑龙江省鹤岗市",
"861454703", "浙江省嘉兴市",
"861599469", "广西百色市",
"861339377", "河南省平顶山市",
"861473660", "云南省红河哈尼族彝族自治州",
"861312441", "河南省安阳市",
"861800463", "黑龙江省哈尔滨市",
"861768907", "西藏阿里地区",
"86139232", "广东省佛山市",
"86135283", "广东省江门市",
"861884683", "黑龙江省哈尔滨市",
"86155673", "吉林省吉林市",
"861571086", "广东省广州市",
"861396541", "安徽省宣城市",
"861528431", "河北省石家庄市",
"861339409", "福建省龙岩市",
"861333133", "河北省张家口市",
"861330994", "新疆昌吉回族自治州",
"861308549", "湖南省娄底市",
"861473010", "河北省邯郸市",
"861330651", "浙江省杭州市",
"861776897", "江苏省盐城市",
"86158630", "山东省青岛市",
"861579721", "湖北省孝感市",
"861533413", "湖北省黄冈市",
"861524490", "四川省遂宁市",
"861893847", "广东省茂名市",
"861329027", "山东省滨州市",
"861879503", "宁夏吴忠市",
"861334251", "湖南省长沙市",
"861356336", "山东省东营市",
"861566877", "辽宁省锦州市",
"861309780", "广西防城港市",
"861362777", "广西钦州市",
"861571737", "湖南省益阳市",
"861516802", "浙江省丽水市",
"861500977", "青海省海西蒙古族藏族自治州",
"861597271", "湖北省宜昌市",
"861895150", "江苏省无锡市",
"861532217", "广东省云浮市",
"861882743", "湖北省武汉市",
"861592960", "陕西省宝鸡市",
"861889590", "云南省保山市",
"861310328", "河北省衡水市",
"861357780", "云南省楚雄彝族自治州",
"861329533", "山东省淄博市",
"861538992", "新疆哈密地区",
"861816003", "四川省成都市",
"861890441", "吉林省长春市",
"861882881", "四川省阿坝藏族羌族自治州",
"861808280", "新疆昌吉回族自治州",
"861708387", "河南省鹤壁市",
"86158088", "云南省昆明市",
"861554541", "黑龙江省佳木斯市",
"861785821", "浙江省衢州市",
"861534718", "湖北省襄樊市",
"861459173", "内蒙古包头市",
"86152964", "广西南宁市",
"861521545", "山东省烟台市",
"861847699", "广东省深圳市",
"861575170", "江苏省宿迁市",
"861596035", "福建省厦门市",
"861363730", "湖南省岳阳市",
"861554826", "内蒙古乌海市",
"861325263", "吉林省长春市",
"861875895", "浙江省衢州市",
"861335534", "山东省德州市",
"861838729", "云南省楚雄彝族自治州",
"861470724", "湖北省咸宁市",
"861572069", "江苏省无锡市",
"861867637", "广东省深圳市",
"861869146", "陕西省延安市",
"861786918", "云南省文山壮族苗族自治州",
"861360678", "浙江省宁波市",
"861569598", "福建省三明市",
"86158757", "广东省佛山市",
"861780953", "宁夏吴忠市",
"861452830", "四川省泸州市",
"861509006", "河南省新乡市",
"861520511", "江苏省盐城市",
"861801960", "江苏省盐城市",
"861554575", "黑龙江省佳木斯市",
"861705769", "陕西省西安市",
"861314958", "黑龙江省伊春市",
"861454749", "浙江省金华市",
"861374971", "河南省南阳市",
"861339837", "四川省绵阳市",
"861364919", "陕西省铜川市",
"861331546", "河北省石家庄市",
"861335132", "黑龙江省齐齐哈尔市",
"861586080", "福建省福州市",
"861324398", "辽宁省葫芦岛市",
"861843859", "河南省洛阳市",
"861890475", "内蒙古通辽市",
"86182251", "重庆市",
"861561524", "山东省济南市",
"861573095", "甘肃省平凉市",
"861310864", "云南省玉溪市",
"861310340", "山西省大同市",
"861559012", "吉林省松原市",
"861535412", "河北省保定市",
"861593314", "河北省承德市",
"861521571", "浙江省衢州市",
"861359295", "广东省茂名市",
"861500149", "新疆喀什地区",
"861786279", "山东省日照市",
"861452689", "陕西省西安市",
"861311103", "山西省晋中市",
"86155921", "陕西省咸阳市",
"861769136", "陕西省商洛市",
"861331821", "广东省佛山市",
"861507012", "江西省新余市",
"861396575", "安徽省亳州市",
"861570455", "黑龙江省绥化市",
"861874497", "贵州省黔西南布依族苗族自治州",
"861399792", "湖北省荆门市",
"861535074", "河北省张家口市",
"861870392", "河南省鹤壁市",
"861458767", "广东省佛山市",
"86150721", "湖北省孝感市",
"861561569", "山东省临沂市",
"861595047", "江苏省南京市",
"861348835", "陕西省西安市",
"86138703", "江西省上饶市",
"86158836", "四川省德阳市",
"861880996", "新疆巴音郭楞蒙古自治州",
"861529073", "河南省漯河市",
"861323262", "广东省河源市",
"86184555", "安徽省马鞍山市",
"861858316", "四川省绵阳市",
"861305097", "辽宁省葫芦岛市",
"86134174", "广东省深圳市",
"861804644", "福建省莆田市",
"861570561", "安徽省淮北市",
"861808627", "湖北省荆门市",
"861853220", "河北省保定市",
"861310829", "陕西省宝鸡市",
"861853400", "山西省太原市",
"86170857", "江苏省连云港市",
"861809081", "四川省遂宁市",
"861300923", "辽宁省本溪市",
"861510420", "辽宁省朝阳市",
"86187256", "重庆市",
"861336599", "福建省南平市",
"861347565", "山东省潍坊市",
"861328576", "浙江省台州市",
"861515621", "安徽省合肥市",
"86132318", "河北省衡水市",
"861372568", "广东省河源市",
"861811491", "江苏省苏州市",
"861700914", "陕西省西安市",
"861337856", "贵州省铜仁地区",
"861345558", "山东省济宁市",
"861588417", "四川省泸州市",
"86132361", "江苏省泰州市",
"861805976", "福建省福州市",
"861532937", "贵州省毕节地区",
"861554992", "湖北省咸宁市",
"861347451", "陕西省西安市",
"861770734", "湖南省衡阳市",
"861380077", "广西防城港市",
"861887038", "江西省景德镇市",
"861812199", "四川省泸州市",
"861816049", "新疆昌吉回族自治州",
"861822453", "河南省郑州市",
"861500659", "山东省临沂市",
"861539323", "甘肃省定西市",
"861538541", "安徽省安庆市",
"861311977", "青海省海西蒙古族藏族自治州",
"861809486", "新疆吐鲁番地区",
"861531435", "山东省滨州市",
"861897197", "湖北省孝感市",
"861879549", "江苏省苏州市",
"86156892", "山东省潍坊市",
"861839904", "新疆阿克苏地区",
"861591498", "广东省清远市",
"861356876", "四川省雅安市",
"861361902", "四川省自贡市",
"861508048", "福建省福州市",
"861308503", "安徽省六安市",
"861301448", "江西省宜春市",
"861566408", "河南省新乡市",
"86182439", "吉林省白山市",
"861533970", "甘肃省临夏回族自治州",
"861322518", "江苏省连云港市",
"861339443", "吉林省延边朝鲜族自治州",
"861348341", "河北省邯郸市",
"861566228", "吉林省延边朝鲜族自治州",
"861310917", "陕西省宝鸡市",
"86137366", "浙江省台州市",
"861850819", "四川省成都市",
"861304951", "贵州省安顺市",
"861805047", "福建省漳州市",
"861357964", "新疆昌吉回族自治州",
"861304694", "福建省宁德市",
"86184179", "陕西省西安市",
"861590244", "辽宁省朝阳市",
"861328419", "辽宁省辽阳市",
"86189721", "湖北省荆州市",
"86186475", "内蒙古通辽市",
"861873531", "山西省阳泉市",
"861335733", "湖南省株洲市",
"861557143", "湖北省十堰市",
"861318326", "河南省开封市",
"861470523", "江苏省淮安市",
"861502917", "陕西省宝鸡市",
"861897012", "江西省赣州市",
"86139132", "江苏省苏州市",
"861598302", "四川省泸州市",
"861572086", "江苏省常州市",
"861329734", "湖南省衡阳市",
"861311702", "湖北省黄石市",
"86136351", "广西桂林市",
"861309929", "甘肃省临夏回族自治州",
"86151872", "云南省大理白族自治州",
"861577454", "黑龙江省佳木斯市",
"861370342", "河南省商丘市",
"861899742", "青海省海东地区",
"861534677", "甘肃省甘南藏族自治州",
"861520079", "湖南省湘西土家族苗族自治州",
"861594644", "黑龙江省七台河市",
"861598627", "广东省阳江市",
"861376837", "广西南宁市",
"861319823", "四川省广元市",
"861361777", "广西钦州市",
"861780351", "山西省太原市",
"861370488", "黑龙江省哈尔滨市",
"86159144", "广东省广州市",
"861810390", "河南省平顶山市",
"861500475", "内蒙古通辽市",
"861556510", "河南省开封市",
"861879704", "青海省海东地区",
"861390304", "广东省汕头市",
"861470786", "广西南宁市",
"861882544", "广东省佛山市",
"861362618", "江苏省淮安市",
"861365819", "四川省乐山市",
"861315858", "四川省内江市",
"861820950", "宁夏银川市",
"861864865", "内蒙古乌兰察布市",
"861890149", "江苏省常州市",
"861509143", "陕西省渭南市",
"861323501", "福建省漳州市",
"861570638", "山东省烟台市",
"861309964", "云南省昭通市",
"861872001", "江西省宜春市",
"861837447", "湖南省长沙市",
"861847527", "广东省肇庆市",
"861522545", "河南省开封市",
"861803314", "广东省江门市",
"861501415", "广东省广州市",
"861308015", "河南省许昌市",
"861571619", "江苏省无锡市",
"861561671", "湖南省衡阳市",
"86138541", "山东省济南市",
"861478903", "西藏山南地区",
"861870543", "山东省滨州市",
"861801498", "江苏省扬州市",
"861896942", "浙江省宁波市",
"861881625", "江苏省泰州市",
"861760699", "云南省昆明市",
"861505628", "安徽省宣城市",
"861363453", "黑龙江省牡丹江市",
"861326934", "甘肃省张掖市",
"861839493", "甘肃省庆阳市",
"861454504", "湖南省常德市",
"861334771", "江苏省南京市",
"861599486", "广东省江门市",
"861362257", "广东省江门市",
"861319282", "广东省惠州市",
"861302420", "浙江省嘉兴市",
"861530364", "黑龙江省哈尔滨市",
"861577530", "四川省成都市",
"861336280", "浙江省舟山市",
"86186261", "江苏省苏州市",
"861521624", "江西省吉安市",
"861572481", "江苏省扬州市",
"861846464", "山东省潍坊市",
"861379599", "四川省南充市",
"86187048", "内蒙古兴安盟",
"861322436", "吉林省白城市",
"861560611", "江苏省常州市",
"861570679", "浙江省温州市",
"861309817", "陕西省铜川市",
"861362068", "山西省临汾市",
"86158513", "江苏省南通市",
"861331900", "新疆昌吉回族自治州",
"861330449", "吉林省白山市",
"861365927", "陕西省宝鸡市",
"86152420", "辽宁省沈阳市",
"861515253", "江苏省连云港市",
"861327389", "河南省平顶山市",
"861804876", "四川省宜宾市",
"861891237", "江苏省无锡市",
"861595976", "福建省南平市",
"861351587", "浙江省温州市",
"861357817", "云南省普洱市",
"861524002", "安徽省合肥市",
"861450310", "河北省邯郸市",
"861536673", "江苏省泰州市",
"86152442", "山东省青岛市",
"861894259", "湖南省常德市",
"861872406", "江苏省常州市",
"861817758", "广西贵港市",
"861459405", "云南省昭通市",
"861335385", "河南省周口市",
"861560466", "黑龙江省哈尔滨市",
"861836549", "江西省吉安市",
"861707915", "浙江省金华市",
"861869049", "陕西省安康市",
"86153723", "浙江省嘉兴市",
"861818782", "云南省昆明市",
"861846209", "山东省淄博市",
"861572166", "山西省晋城市",
"861559197", "陕西省商洛市",
"861822601", "安徽省宿州市",
"861530329", "河北省石家庄市",
"861583510", "山西省太原市",
"861311441", "湖北省孝感市",
"861338362", "河北省保定市",
"861841989", "甘肃省酒泉市",
"861341798", "广东省云浮市",
"861397218", "湖北省武汉市",
"86152060", "福建省龙岩市",
"861846429", "山东省滨州市",
"861539921", "陕西省宝鸡市",
"861899394", "甘肃省陇南市",
"861370794", "江西省抚州市",
"861356552", "新疆和田地区",
"861308704", "河南省平顶山市",
"86186531", "山东省济南市",
"86151049", "内蒙古呼伦贝尔市",
"861310415", "辽宁省丹东市",
"861857424", "河南省郑州市",
"861891340", "江苏省镇江市",
"861520854", "贵州省黔南布依族苗族自治州",
"861857204", "湖北省随州市",
"861833646", "河南省郑州市",
"86189793", "江西省上饶市",
"861812491", "广东省广州市",
"861313930", "甘肃省临夏回族自治州",
"861509109", "陕西省西安市",
"861390096", "安徽省合肥市",
"861524968", "河南省郑州市",
"86378", "河南省开封市",
"861534959", "宁夏固原市",
"861821453", "云南省临沧市",
"861584897", "内蒙古赤峰市",
"861880855", "贵州省黔东南苗族侗族自治州",
"861538884", "云南省昆明市",
"861375331", "山西省阳泉市",
"861590463", "黑龙江省牡丹江市",
"861809469", "浙江省绍兴市",
"861589029", "河南省三门峡市",
"861854563", "黑龙江省哈尔滨市",
"861510135", "甘肃省金昌市",
"861303683", "广西桂林市",
"861518075", "贵州省遵义市",
"861311475", "广西玉林市",
"861770533", "山东省淄博市",
"861334745", "陕西省渭南市",
"861828914", "西藏林芝地区",
"861530828", "四川省广安市",
"861320578", "浙江省丽水市",
"861519240", "山东省烟台市",
"861362902", "四川省自贡市",
"861529698", "宁夏吴忠市",
"861561645", "湖南省长沙市",
"861337572", "浙江省湖州市",
"861840647", "山西省运城市",
"861829065", "新疆昌吉回族自治州",
"861550395", "河南省漯河市",
"861500702", "江西省九江市",
"861881709", "湖南省常德市",
"861816515", "陕西省西安市",
"861305514", "湖南省湘潭市",
"861850452", "黑龙江省齐齐哈尔市",
"861569483", "河北省廊坊市",
"861532435", "河北省唐山市",
"861898020", "四川省内江市",
"86151305", "河北省唐山市",
"861809424", "江苏省南京市",
"861505640", "安徽省六安市",
"86153604", "广东省广州市",
"86156954", "山东省淄博市",
"861454102", "安徽省蚌埠市",
"861302448", "江苏省盐城市",
"861332685", "广东省东莞市",
"861369633", "山东省日照市",
"861330882", "云南省德宏傣族景颇族自治州",
"861550716", "湖北省荆州市",
"86180244", "广东省东莞市",
"861333732", "湖南省湘潭市",
"861347649", "湖北省孝感市",
"861452411", "辽宁省大连市",
"861458039", "江苏省徐州市",
"861327670", "浙江省宁波市",
"861450179", "山西省晋中市",
"86182151", "甘肃省兰州市",
"861388789", "云南省楚雄彝族自治州",
"86182788", "广西河池市",
"861350467", "黑龙江省大庆市",
"861320539", "山东省临沂市",
"861589614", "江苏省连云港市",
"861332546", "陕西省西安市",
"861869003", "陕西省宝鸡市",
"861564931", "河南省郑州市",
"861705523", "重庆市",
"861389540", "宁夏银川市",
"861886092", "江苏省苏州市",
"8617623", "重庆市",
"861850318", "河北省衡水市",
"861831260", "广东省茂名市",
"861536721", "湖南省湘西土家族苗族自治州",
"861816146", "四川省南充市",
"861390491", "辽宁省朝阳市",
"861576800", "广东省惠州市",
"86188629", "江苏省南通市",
"861341484", "广东省揭阳市",
"861802583", "广东省梅州市",
"861346924", "湖南省岳阳市",
"861561586", "山东省潍坊市",
"861315034", "新疆乌鲁木齐市",
"861804336", "吉林省延边朝鲜族自治州",
"861874995", "河南省驻马店市",
"861376229", "湖南省娄底市",
"861570957", "宁夏银川市",
"861829556", "宁夏固原市",
"861393897", "河南省南阳市",
"861459772", "新疆乌鲁木齐市",
"861458354", "山东省东营市",
"861452666", "江西省吉安市",
"861569802", "山东省枣庄市",
"861890977", "青海省海西蒙古族藏族自治州",
"861334623", "山东省日照市",
"861479763", "青海省海东地区",
"861781733", "广东省东莞市",
"861896591", "福建省福州市",
"86134028", "四川省成都市",
"861315359", "山东省滨州市",
"861365318", "河北省衡水市",
"86134274", "广东省江门市",
"861346969", "宁夏银川市",
"861830944", "甘肃省平凉市",
"86153791", "甘肃省定西市",
"861527283", "湖北省孝感市",
"861398673", "湖北省荆州市",
"861331739", "湖南省邵阳市",
"86159388", "河南省南阳市",
"861568756", "云南省德宏傣族景颇族自治州",
"861321286", "黑龙江省黑河市",
"861367726", "湖北省荆门市",
"861347941", "江西省抚州市",
"861372219", "内蒙古鄂尔多斯市",
"861362271", "广东省佛山市",
"86151767", "河北省承德市",
"861571231", "辽宁省沈阳市",
"861573908", "新疆博尔塔拉蒙古自治州",
"861334757", "广西贵港市",
"861883441", "山西省忻州市",
"861537744", "湖南省张家界市",
"861822943", "湖南省邵阳市",
"861535982", "福建省泉州市",
"861566514", "江苏省扬州市",
"861560239", "广东省广州市",
"861539014", "四川省德阳市",
"861453682", "陕西省西安市",
"861819690", "新疆哈密地区",
"861564880", "内蒙古赤峰市",
"86156732", "湖南省湘潭市",
"861868412", "贵州省黔南布依族苗族自治州",
"86183177", "河南省安阳市",
"861538965", "陕西省宝鸡市",
"861579407", "广东省深圳市",
"861473804", "河南省洛阳市",
"861776768", "新疆乌鲁木齐市",
"861364489", "内蒙古兴安盟",
"86147789", "辽宁省沈阳市",
"86147943", "吉林省长春市",
"861539472", "内蒙古包头市",
"861863993", "河南省濮阳市",
"861339953", "安徽省芜湖市",
"86170970", "广西南宁市",
"861458399", "福建省南平市",
"861555072", "山东省济宁市",
"861872434", "黑龙江省黑河市",
"861390525", "江苏省扬州市",
"86181683", "江苏省无锡市",
"861301958", "内蒙古巴彦淖尔市",
"861363375", "河南省平顶山市",
"861310731", "湖南省长沙市",
"861328748", "山东省潍坊市",
"861459060", "广东省肇庆市",
"86155527", "山东省东营市",
"861361813", "四川省甘孜藏族自治州",
"861375496", "山西省临汾市",
"86158615", "江苏省无锡市",
"861332067", "四川省阿坝藏族羌族自治州",
"861360873", "云南省红河哈尼族彝族自治州",
"861893283", "河北省张家口市",
"861367960", "四川省乐山市",
"861325954", "宁夏固原市",
"861322269", "江苏省扬州市",
"861856702", "河南省开封市",
"86177331", "海南省海口市",
"861880847", "四川省巴中市",
"86872", "云南省大理白族自治州",
"861840516", "江苏省无锡市",
"86155364", "山西省吕梁市",
"861313625", "浙江省舟山市",
"861533296", "内蒙古赤峰市",
"861332258", "西藏拉萨市",
"861478641", "湖南省张家界市",
"861829687", "江西省赣州市",
"861306973", "黑龙江省齐齐哈尔市",
"861780264", "江苏省徐州市",
"861804096", "新疆伊犁哈萨克自治州",
"861760542", "山东省青岛市",
"861306107", "山东省聊城市",
"861347194", "广西玉林市",
"86134310", "广东省广州市",
"861348730", "湖南省岳阳市",
"86152393", "河南省濮阳市",
"861500353", "山西省阳泉市",
"861899359", "甘肃省白银市",
"861539629", "福建省漳州市",
"861867448", "湖南省长沙市",
"861320490", "湖南省郴州市",
"861880433", "吉林省延边朝鲜族自治州",
"861821835", "广东省广州市",
"861858890", "广东省阳江市",
"861454325", "内蒙古赤峰市",
"861558175", "山西省晋中市",
"861816587", "广东省韶关市",
"861588987", "广东省珠海市",
"861314448", "广东省汕尾市",
"86182874", "云南省曲靖市",
"86158796", "江西省吉安市",
"861854831", "内蒙古巴彦淖尔市",
"861534651", "河南省驻马店市",
"861313881", "广东省东莞市",
"861883046", "河北省秦皇岛市",
"861534994", "新疆塔城地区",
"861807902", "江西省鹰潭市",
"861773467", "陕西省商洛市",
"86180195", "安徽省合肥市",
"861332617", "浙江省湖州市",
"861700484", "广东省深圳市",
"861310487", "广东省广州市",
"86150376", "河南省信阳市",
"861373140", "河北省承德市",
"861342867", "广东省深圳市",
"86150887", "浙江省杭州市",
"861872550", "安徽省滁州市",
"861329042", "河北省保定市",
"86183592", "福建省厦门市",
"861708428", "云南省普洱市",
"861309773", "广西桂林市",
"861350826", "四川省达州市",
"861593537", "山西省阳泉市",
"861313743", "河南省许昌市",
"861398905", "西藏昌都地区",
"861452735", "湖南省郴州市",
"861390336", "河北省保定市",
"861331778", "广西河池市",
"86132924", "河北省唐山市",
"861350541", "山东省济南市",
"861303366", "浙江省金华市",
"861375091", "浙江省温州市",
"861570945", "甘肃省金昌市",
"861525663", "安徽省铜陵市",
"861500567", "安徽省阜阳市",
"861510637", "山东省济宁市",
"861336753", "广西桂林市",
"861532853", "四川省遂宁市",
"861327712", "湖北省孝感市",
"861884670", "黑龙江省鸡西市",
"861881210", "河北省邯郸市",
"86176080", "四川省成都市",
"861812525", "广东省肇庆市",
"861560278", "广东省梅州市",
"86155315", "河北省唐山市",
"861808430", "贵州省安顺市",
"861774698", "河南省漯河市",
"861351515", "江苏省泰州市",
"86189516", "江苏省南京市",
"861760991", "新疆乌鲁木齐市",
"86155159", "河南省郑州市",
"861561979", "陕西省汉中市",
"861826266", "江苏省苏州市",
"861760654", "浙江省杭州市",
"861571911", "陕西省延安市",
"861509727", "甘肃省天水市",
"861360333", "河北省沧州市",
"861335317", "吉林省松原市",
"861779746", "青海省海西蒙古族藏族自治州",
"86187297", "陕西省宝鸡市",
"861777016", "江西省鹰潭市",
"861501731", "广东省中山市",
"861899858", "广东省肇庆市",
"86170896", "广东省中山市",
"86135918", "辽宁省朝阳市",
"861815193", "江苏省南京市",
"86159522", "江苏省徐州市",
"861576597", "黑龙江省大庆市",
"861520398", "河南省三门峡市",
"861315006", "甘肃省天水市",
"861324511", "内蒙古呼和浩特市",
"861350575", "浙江省绍兴市",
"861306410", "江西省南昌市",
"86135961", "吉林省长春市",
"861510958", "宁夏银川市",
"861570971", "青海省西宁市",
"861560919", "陕西省铜川市",
"861379554", "四川省眉山市",
"86181637", "湖南省长沙市",
"861771999", "河南省郑州市",
"86130718", "浙江省杭州市",
"861308167", "山东省潍坊市",
"861846710", "青海省海南藏族自治州",
"861314420", "广东省江门市",
"86178787", "广西钦州市",
"861894294", "湖北省武汉市",
"86130761", "广东省河源市",
"861317984", "新疆乌鲁木齐市",
"861479974", "新疆乌鲁木齐市",
"861316054", "广东省阳江市",
"861514829", "内蒙古兴安盟",
"861801570", "四川省自贡市",
"861885703", "浙江省衢州市",
"86181750", "安徽省六安市",
"861450955", "江苏省宿迁市",
"861523662", "河南省新乡市",
"861867420", "湖北省宜昌市",
"861890694", "福建省漳州市",
"86177942", "甘肃省兰州市",
"861800510", "江苏省盐城市",
"861521961", "广东省揭阳市",
"861333044", "云南省昆明市",
"861865575", "安徽省合肥市",
"86136450", "福建省福州市",
"861868859", "广东省湛江市",
"861581267", "广东省潮州市",
"861818818", "贵州省六盘水市",
"861867200", "湖北省黄石市",
"861579878", "云南省楚雄彝族自治州",
"861857236", "湖北省宜昌市",
"861818170", "四川省宜宾市",
"861315221", "陕西省宝鸡市",
"861810030", "河北省石家庄市",
"861808152", "四川省达州市",
"861519713", "湖南省岳阳市",
"86152321", "河北省石家庄市",
"861350992", "广东省茂名市",
"861308736", "湖南省常德市",
"861311567", "黑龙江省大庆市",
"861323295", "广东省清远市",
"861315401", "陕西省榆林市",
"861363341", "山西省太原市",
"861313709", "河南省南阳市",
"861560827", "四川省南充市",
"861390876", "云南省文山壮族苗族自治州",
"861309621", "四川省宜宾市",
"861780837", "四川省阿坝藏族羌族自治州",
"86150833", "河南省南阳市",
"861399765", "湖北省宜昌市",
"861858762", "广西百色市",
"861807188", "湖北省荆州市",
"86130706", "山东省淄博市",
"861533560", "内蒙古呼伦贝尔市",
"861584500", "黑龙江省哈尔滨市",
"861860532", "山东省青岛市",
"861362245", "广东省韶关市",
"861598753", "云南省文山壮族苗族自治州",
"861357621", "江西省九江市",
"861558651", "湖北省黄冈市",
"861360785", "广西玉林市",
"861322391", "河南省焦作市",
"86147365", "云南省昆明市",
"861865992", "福建省泉州市",
"861581374", "广东省深圳市",
"861566682", "山东省青岛市",
"861820315", "河北省唐山市",
"86139985", "辽宁省大连市",
"861312694", "内蒙古鄂尔多斯市",
"86133546", "云南省昆明市",
"861829400", "甘肃省临夏回族自治州",
"86187312", "河北省保定市",
"86135906", "广东省佛山市",
"861502985", "陕西省安康市",
"861366432", "吉林省吉林市",
"861523474", "山西省运城市",
"86189508", "福建省龙岩市",
"861458261", "安徽省马鞍山市",
"86157326", "河北省廊坊市",
"861820796", "江西省吉安市",
"86188734", "湖南省衡阳市",
"861580314", "河北省承德市",
"861700798", "江西省南昌市",
"861311353", "内蒙古鄂尔多斯市",
"861351146", "浙江省台州市",
"861344040", "辽宁省丹东市",
"861477349", "湖南省湘西土家族苗族自治州",
"861390644", "山东省济南市",
"861837422", "湖南省益阳市",
"861584946", "内蒙古包头市",
"861336554", "安徽省淮南市",
"861338395", "河南省漯河市",
"861820632", "山东省枣庄市",
"86183700", "江西省上饶市",
"861303389", "河南省鹤壁市",
"861894923", "安徽省巢湖市",
"86134570", "广西南宁市",
"861860356", "山西省晋城市",
"86183125", "广东省深圳市",
"861566097", "河南省南阳市",
"861330677", "浙江省温州市",
"861539597", "福建省龙岩市",
"861820428", "辽宁省葫芦岛市",
"861338716", "湖北省咸宁市",
"861591007", "山东省德州市",
"86182403", "辽宁省沈阳市",
"86180295", "广东省汕头市",
"861309574", "浙江省宁波市",
"861500951", "宁夏银川市",
"861812154", "江苏省无锡市",
"861310985", "辽宁省沈阳市",
"861590510", "江苏省盐城市",
"861313544", "安徽省马鞍山市",
"861597257", "湖北省十堰市",
"861356304", "山东省聊城市",
"861477820", "广东省梅州市",
"861523197", "河北省保定市",
"861370327", "河北省沧州市",
"86137400", "辽宁省沈阳市",
"86147438", "吉林省松原市",
"861515964", "福建省福州市",
"861315143", "江苏省扬州市",
"86134851", "江苏省南通市",
"861775031", "福建省福州市",
"861536878", "云南省楚雄彝族自治州",
"861332778", "江苏省泰州市",
"86150516", "江苏省苏州市",
"861871550", "安徽省滁州市",
"861478459", "黑龙江省大庆市",
"861769502", "宁夏石嘴山市",
"861598642", "广东省广州市",
"86181962", "新疆巴音郭楞蒙古自治州",
"861830454", "黑龙江省佳木斯市",
"861889807", "西藏阿里地区",
"861308692", "贵州省黔南布依族苗族自治州",
"861370602", "福建省宁德市",
"861877277", "湖北省十堰市",
"861811525", "江苏省徐州市",
"86170074", "湖南省长沙市",
"861576705", "广东省梅州市",
"861388635", "湖北省孝感市",
"861585462", "山东省济宁市",
"861350884", "云南省曲靖市",
"861808811", "云南省西双版纳傣族自治州",
"861573841", "河南省郑州市",
"86180522", "江苏省徐州市",
"861304475", "河南省新乡市",
"861526582", "山东省枣庄市",
"861572231", "青海省西宁市",
"861364611", "江苏省常州市",
"861389934", "新疆哈密地区",
"861341914", "四川省南充市",
"861336430", "吉林省长春市",
"861390154", "江苏省苏州市",
"861821943", "广东省湛江市",
"861534449", "湖南省永州市",
"861305408", "湖南省岳阳市",
"861595566", "安徽省池州市",
"861332739", "湖南省邵阳市",
"861536839", "云南省曲靖市",
"861808753", "云南省昆明市",
"861334364", "河南省驻马店市",
"86138739", "湖南省邵阳市",
"861320746", "湖南省永州市",
"86187023", "重庆市",
"861551548", "河南省濮阳市",
"861508265", "四川省广安市",
"861369378", "河南省开封市",
"861519682", "四川省资阳市",
"861856659", "广东省佛山市",
"861334840", "福建省宁德市",
"861307501", "安徽省亳州市",
"861319628", "吉林省四平市",
"861530771", "广西南宁市",
"861536680", "江苏省常州市",
"861835990", "福建省福州市",
"861367784", "广西梧州市",
"861347343", "河北省石家庄市",
"86182652", "山东省枣庄市",
"861370279", "广东省中山市",
"861321404", "内蒙古兴安盟",
"861319432", "吉林省吉林市",
"861848518", "贵州省遵义市",
"86183277", "湖北省黄冈市",
"86132460", "广东省中山市",
"861362813", "四川省内江市",
"861331067", "山东省青岛市",
"861538467", "陕西省宝鸡市",
"861583244", "河北省保定市",
"861774073", "西藏山南地区",
"861364466", "黑龙江省黑河市",
"861334329", "河北省唐山市",
"861830530", "山东省菏泽市",
"86176984", "河南省郑州市",
"861302958", "内蒙古巴彦淖尔市",
"861503996", "河南省安阳市",
"861321269", "湖南省衡阳市",
"86185882", "广东省深圳市",
"861896927", "浙江省湖州市",
"861570833", "四川省乐山市",
"861850942", "甘肃省定西市",
"86132020", "广东省广州市",
"861458502", "河南省信阳市",
"861511779", "贵州省安顺市",
"861823245", "河北省廊坊市",
"861880750", "广东省江门市",
"861863391", "河北省石家庄市",
"861339351", "山西省太原市",
"861458104", "安徽省亳州市",
"861312567", "辽宁省辽阳市",
"861853185", "河北省廊坊市",
"861337962", "贵州省黔南布依族苗族自治州",
"861330959", "宁夏银川市",
"861380897", "山东省青岛市",
"861306345", "安徽省合肥市",
"861320968", "宁夏银川市",
"861576014", "四川省乐山市",
"861815860", "浙江省台州市",
"861771444", "江苏省苏州市",
"861840307", "河北省沧州市",
"861708315", "河北省唐山市",
"86184402", "新疆乌鲁木齐市",
"861863404", "河北省唐山市",
"86186983", "福建省泉州市",
"86186749", "湖南省岳阳市",
"861476573", "福建省福州市",
"861304046", "新疆阿克苏地区",
"861363943", "山东省济宁市",
"861380051", "江苏省无锡市",
"861569470", "内蒙古呼伦贝尔市",
"861347477", "内蒙古鄂尔多斯市",
"861502487", "内蒙古巴彦淖尔市",
"86139631", "山东省威海市",
"861840438", "吉林省松原市",
"861533381", "河南省郑州市",
"861471558", "广东省河源市",
"861315109", "江苏省南京市",
"861883977", "河南省郑州市",
"86131449", "广东省东莞市",
"861770706", "江西省吉安市",
"861536338", "广东省潮州市",
"861526029", "福建省莆田市",
"861840622", "辽宁省本溪市",
"861777119", "湖北省黄石市",
"861839936", "新疆喀什地区",
"861303670", "湖南省邵阳市",
"861311694", "云南省丽江市",
"861358277", "河北省廊坊市",
"861354716", "四川省广元市",
"861319640", "江苏省无锡市",
"86187572", "浙江省湖州市",
"861313652", "浙江省湖州市",
"861329861", "湖南省常德市",
"861807777", "广西南宁市",
"861361245", "广东省潮州市",
"86180388", "广东省佛山市",
"861556463", "山东省潍坊市",
"86177024", "辽宁省沈阳市",
"86177278", "广东省深圳市",
"861454418", "福建省漳州市",
"861300738", "湖南省娄底市",
"861304702", "广东省阳江市",
"861847654", "广东省深圳市",
"861312353", "广西桂林市",
"861356096", "广东省梅州市",
"86155431", "吉林省长春市",
"861576472", "内蒙古包头市",
"861390552", "安徽省蚌埠市",
"861569233", "山东省淄博市",
"861370918", "陕西省西安市",
"861346538", "山东省泰安市",
"861530745", "湖南省怀化市",
"861565980", "福建省厦门市",
"861882930", "陕西省西安市",
"861383491", "山西省晋城市",
"861477303", "湖南省株洲市",
"861813667", "江苏省南京市",
"861825151", "江苏省宿迁市",
"861300779", "青海省西宁市",
"861850591", "福建省福州市",
"86183482", "河南省焦作市",
"86184653", "宁夏银川市",
"861570373", "河南省新乡市",
"861527270", "湖北省咸宁市",
"861584768", "内蒙古呼和浩特市",
"861398680", "湖北省宜昌市",
"861577944", "江西省鹰潭市",
"861537509", "安徽省阜阳市",
"861533708", "甘肃省白银市",
"861374957", "河南省平顶山市",
"861317760", "江西省吉安市",
"861856977", "湖南省怀化市",
"86155259", "山西省临汾市",
"861572911", "河南省洛阳市",
"861598430", "四川省眉山市",
"861454352", "山东省菏泽市",
"861346579", "山东省济宁市",
"861772999", "安徽省芜湖市",
"861304441", "山西省忻州市",
"861477848", "广东省汕头市",
"861829092", "新疆阿勒泰地区",
"86138598", "福建省莆田市",
"861571313", "河北省张家口市",
"86187197", "甘肃省庆阳市",
"861521557", "安徽省宿州市",
"861301719", "湖南省长沙市",
"861760393", "河南省濮阳市",
"861886615", "山东省济南市",
"861890567", "安徽省亳州市",
"861576629", "广东省惠州市",
"86182929", "陕西省咸阳市",
"861778560", "贵州省贵阳市",
"861476254", "江苏省苏州市",
"861889439", "甘肃省临夏回族自治州",
"861319150", "内蒙古赤峰市",
"86137782", "四川省德阳市",
"861309172", "黑龙江省哈尔滨市",
"861802570", "广东省潮州市",
"861582058", "广东省珠海市",
"861347309", "河北省邢台市",
"861836087", "江苏省苏州市",
"861453851", "甘肃省临夏回族自治州",
"861844741", "内蒙古通辽市",
"86147574", "浙江省杭州市",
"86134043", "吉林省长春市",
"861890353", "山西省阳泉市",
"86177415", "辽宁省丹东市",
"861847144", "湖北省宜昌市",
"861826289", "江苏省南通市",
"861327113", "河南省信阳市",
"86159195", "广东省潮州市",
"861344028", "江苏省盐城市",
"861369838", "四川省乐山市",
"861534403", "内蒙古鄂尔多斯市",
"861317926", "吉林省吉林市",
"861576664", "广东省揭阳市",
"861821909", "广东省阳江市",
"861336152", "山东省东营市",
"861840479", "内蒙古锡林郭勒盟",
"861855931", "福建省厦门市",
"861327683", "浙江省嘉兴市",
"861853065", "河南省南阳市",
"861522961", "陕西省延安市",
"861453097", "山西省长治市",
"861870617", "江苏省无锡市",
"86181396", "新疆乌鲁木齐市",
"861705250", "陕西省西安市",
"861587192", "湖北省武汉市",
"861390873", "云南省红河哈尼族彝族自治州",
"861529955", "新疆哈密地区",
"86137465", "黑龙江省黑河市",
"861813440", "河南省郑州市",
"861556489", "山东省青岛市",
"861803164", "河北省唐山市",
"86185667", "广东省深圳市",
"86139744", "湖南省张家界市",
"861345121", "湖北省荆门市",
"86131931", "重庆市",
"861862487", "河南省洛阳市",
"861809470", "浙江省杭州市",
"861857233", "湖北省恩施土家族苗族自治州",
"861360525", "江苏省扬州市",
"86150749", "湖南省长沙市",
"86150983", "山东省菏泽市",
"861801305", "江苏省苏州市",
"861393375", "河北省张家口市",
"861889954", "新疆伊犁哈萨克自治州",
"861370052", "山西省大同市",
"86177152", "江苏省南京市",
"861519716", "湖南省湘潭市",
"8613910", "北京市",
"861308733", "湖南省株洲市",
"861337148", "山东省青岛市",
"86138257", "广东省东莞市",
"861335015", "四川省内江市",
"861831238", "广东省梅州市",
"86183765", "广西玉林市",
"861369604", "四川省内江市",
"86155783", "广西桂林市",
"86155949", "陕西省西安市",
"861595605", "安徽省合肥市",
"861831602", "广东省韶关市",
"861884961", "云南省西双版纳傣族自治州",
"861824267", "辽宁省营口市",
"861888145", "四川省成都市",
"861380730", "湖南省岳阳市",
"861820793", "江西省上饶市",
"861311356", "内蒙古赤峰市",
"861839331", "甘肃省平凉市",
"861351143", "浙江省台州市",
"861328580", "浙江省舟山市",
"861535292", "青海省海东地区",
"861820667", "广东省惠州市",
"861598756", "云南省德宏傣族景颇族自治州",
"86156388", "河南省郑州市",
"861831327", "云南省普洱市",
"861591657", "广东省佛山市",
"861567777", "广西钦州市",
"861770504", "福建省莆田市",
"86433", "吉林省延边朝鲜族自治州\、珲春市\、延吉市",
"861528144", "四川省宜宾市",
"861857470", "湖南省衡阳市",
"861396640", "安徽省安庆市",
"861824058", "河南省南阳市",
"861594639", "黑龙江省哈尔滨市",
"861586471", "山东省青岛市",
"861330550", "安徽省滁州市",
"86151175", "贵州省毕节地区",
"861855525", "安徽省宣城市",
"861777013", "江西省赣州市",
"86137414", "辽宁省本溪市",
"86132405", "广东省东莞市",
"861886754", "浙江省杭州市",
"861815196", "江苏省苏州市",
"861862731", "湖南省长沙市",
"861315003", "甘肃省陇南市",
"861515548", "安徽省安庆市",
"86188524", "江苏省苏州市",
"861582912", "陕西省榆林市",
"861831279", "广东省肇庆市",
"861802979", "广东省潮州市",
"86137271", "广东省清远市",
"861331032", "内蒙古鄂尔多斯市",
"861335665", "山东省济南市",
"861538432", "广东省珠海市",
"861783527", "山西省吕梁市",
"861376895", "广西柳州市",
"861778969", "甘肃省庆阳市",
"861826263", "江苏省南京市",
"861327669", "江苏省徐州市",
"86133123", "贵州省遵义市",
"861337658", "广东省韶关市",
"861538628", "湖南省怀化市",
"861550877", "云南省玉溪市",
"861360336", "河北省廊坊市",
"861779743", "青海省玉树藏族自治州",
"861563537", "山西省太原市",
"861346970", "湖北省武汉市",
"86132276", "湖北省荆州市",
"86152686", "浙江省金华市",
"861870258", "江西省抚州市",
"861301197", "河北省秦皇岛市",
"861530684", "浙江省宁波市",
"861345815", "四川省遂宁市",
"861781704", "广东省茂名市",
"861768398", "湖北省咸宁市",
"861308385", "河南省安阳市",
"861778924", "陕西省安康市",
"861474128", "辽宁省锦州市",
"861869359", "甘肃省金昌市",
"861333399", "河南省许昌市",
"861709429", "广东省汕头市",
"861774947", "河南省濮阳市",
"861317321", "山东省青岛市",
"861518351", "四川省雅安市",
"861330434", "吉林省四平市",
"861839845", "四川省南充市",
"861352394", "河南省周口市",
"861814671", "江西省南昌市",
"861811211", "江苏省镇江市",
"861885706", "浙江省舟山市",
"861313002", "辽宁省大连市",
"861859390", "广西防城港市",
"86152880", "云南省曲靖市",
"861860951", "宁夏银川市",
"861883043", "河北省承德市",
"861332365", "河南省开封市",
"861553445", "山西省太原市",
"861860694", "福建省福州市",
"861897200", "湖北省宜昌市",
"86156295", "湖北省孝感市",
"86131320", "天津市",
"861317294", "广东省清远市",
"86139450", "黑龙江省哈尔滨市",
"861363077", "吉林省辽源市",
"861898859", "广东省中山市",
"861303557", "贵州省铜仁地区",
"861802147", "江苏省盐城市",
"86134655", "山东省烟台市",
"861839871", "四川省自贡市",
"861500356", "山西省晋城市",
"861814645", "新疆昌吉回族自治州",
"861472710", "浙江省杭州市",
"861880436", "吉林省白城市",
"86135016", "上海市",
"861843292", "河北省保定市",
"861530512", "江苏省连云港市",
"861335704", "浙江省金华市",
"86155737", "湖南省益阳市",
"861871959", "甘肃省陇南市",
"861303363", "浙江省温州市",
"861324907", "广东省深圳市",
"861525666", "安徽省池州市",
"861336756", "广西百色市",
"861333898", "江苏省连云港市",
"861532856", "四川省广安市",
"861819819", "贵州省毕节地区",
"861590919", "陕西省铜川市",
"861571070", "广东省广州市",
"861362030", "广东省佛山市",
"861565022", "山东省临沂市",
"861831918", "广东省佛山市",
"861337937", "陕西省宝鸡市",
"861338514", "贵州省贵阳市",
"861312532", "江西省抚州市",
"861300865", "云南省昆明市",
"86153635", "广东省珠海市",
"861830978", "青海省西宁市",
"86186516", "江苏省南京市",
"861517475", "内蒙古兴安盟",
"861350823", "四川省攀枝花市",
"861309776", "广西百色市",
"861366965", "广西玉林市",
"861571507", "福建省莆田市",
"861340312", "河北省保定市",
"861313746", "河南省周口市",
"861771289", "江苏省南京市",
"861816727", "浙江省湖州市",
"861575461", "黑龙江省哈尔滨市",
"861390333", "河北省秦皇岛市",
"861570660", "广东省汕尾市",
"861585809", "浙江省舟山市",
"861558284", "山西省晋城市",
"861340458", "吉林省松原市",
"861708192", "福建省莆田市",
"861568125", "四川省巴中市",
"861385220", "江苏省扬州市",
"861528542", "贵州省铜仁地区",
"861394842", "内蒙古包头市",
"861780075", "青海省果洛藏族自治州",
"86130221", "上海市",
"861824834", "内蒙古通辽市",
"86186508", "福建省龙岩市",
"861868265", "四川省成都市",
"861390785", "广西玉林市",
"861367723", "湖北省荆门市",
"861586445", "山东省枣庄市",
"861321283", "黑龙江省牡丹江市",
"861830939", "甘肃省陇南市",
"861591938", "广东省惠州市",
"861822946", "湖南省永州市",
"861862600", "江苏省徐州市",
"86183389", "河南省新乡市",
"861593201", "河北省石家庄市",
"861837804", "广西河池市",
"861360876", "云南省德宏傣族景颇族自治州",
"861835599", "安徽省黄山市",
"86135008", "吉林省长春市",
"861779709", "青海省海北藏族自治州",
"861893286", "河北省承德市",
"861590827", "四川省南充市",
"861840513", "江苏省常州市",
"861819927", "新疆昌吉回族自治州",
"861524210", "辽宁省鞍山市",
"861580707", "江西省赣州市",
"861533293", "内蒙古包头市",
"861459899", "广东省广州市",
"861890532", "山东省青岛市",
"861323985", "新疆巴音郭楞蒙古自治州",
"861369765", "山东省青岛市",
"861804093", "新疆和田地区",
"861320544", "山东省烟台市",
"861306976", "黑龙江省佳木斯市",
"861520610", "江苏省镇江市",
"861863996", "河南省驻马店市",
"861339956", "安徽省安庆市",
"861813632", "江苏省宿迁市",
"861550408", "辽宁省大连市",
"861361816", "四川省攀枝花市",
"861315049", "新疆乌鲁木齐市",
"86158350", "山西省忻州市",
"861375493", "山西省大同市",
"861813428", "河北省石家庄市",
"861800758", "广东省肇庆市",
"86189937", "甘肃省酒泉市",
"861510474", "内蒙古乌兰察布市",
"861354851", "湖南省衡阳市",
"861800919", "陕西省铜川市",
"861776835", "江苏省常州市",
"861329102", "江苏省徐州市",
"861571316", "河北省廊坊市",
"861760396", "河南省驻马店市",
"861325807", "山东省潍坊市",
"861816858", "江苏省镇江市",
"86130193", "辽宁省沈阳市",
"861570376", "河南省信阳市",
"861834481", "江苏省镇江市",
"861869727", "青海省海东地区",
"861833848", "河南省濮阳市",
"861870739", "湖南省邵阳市",
"861580972", "青海省海东地区",
"861535020", "江西省九江市",
"861559420", "陕西省榆林市",
"861318014", "河北省秦皇岛市",
"861354097", "四川省泸州市",
"861571795", "江西省宜春市",
"861705770", "福建省福州市",
"86150662", "山东省青岛市",
"861320709", "江西省南昌市",
"86151461", "黑龙江省鸡西市",
"86151127", "广东省东莞市",
"861306047", "陕西省宝鸡市",
"861504984", "内蒙古巴彦淖尔市",
"861507200", "湖北省荆门市",
"861508859", "浙江省温州市",
"861327116", "河南省周口市",
"861318472", "河北省秦皇岛市",
"861560510", "江苏省盐城市",
"861534406", "内蒙古通辽市",
"861317923", "吉林省吉林市",
"861505575", "安徽省芜湖市",
"861771590", "江苏省盐城市",
"861594717", "内蒙古鄂尔多斯市",
"861567257", "湖北省荆州市",
"861364244", "广东省汕尾市",
"861327686", "浙江省台州市",
"861308450", "河北省沧州市",
"861561570", "山东省菏泽市",
"861359340", "山西省吕梁市",
"861351394", "河南省濮阳市",
"861565055", "山东省济宁市",
"861479458", "黑龙江省伊春市",
"861360644", "山东省烟台市",
"861596097", "福建省南平市",
"86151021", "上海市",
"861817244", "广西柳州市",
"861567068", "河南省南阳市",
"861890356", "山西省晋城市",
"861379756", "湖北省襄樊市",
"861500532", "山东省青岛市",
"861881539", "山东省临沂市",
"861363946", "山东省德州市",
"861343721", "湖北省荆州市",
"861866927", "云南省昆明市",
"861861487", "内蒙古鄂尔多斯市",
"86186833", "四川省乐山市",
"861316765", "安徽省阜阳市",
"861567188", "湖北省恩施土家族苗族自治州",
"861512865", "河北省廊坊市",
"861770703", "江西省上饶市",
"861580595", "福建省泉州市",
"861884557", "黑龙江省哈尔滨市",
"861551780", "河南省开封市",
"86138051", "江苏省南京市",
"861800827", "四川省巴中市",
"861318629", "陕西省安康市",
"8613920", "天津市",
"861324772", "江西省九江市",
"861368379", "河南省洛阳市",
"861831759", "河南省新乡市",
"86151406", "辽宁省大连市",
"861335549", "山东省临沂市",
"861375904", "云南省普洱市",
"861453395", "内蒙古乌兰察布市",
"861342832", "广东省汕头市",
"861590758", "广东省肇庆市",
"86170768", "广东省广州市",
"86187558", "安徽省阜阳市",
"86138157", "江苏省宿迁市",
"861327545", "山东省烟台市",
"861834737", "内蒙古通辽市",
"861887180", "湖北省恩施土家族苗族自治州",
"861345429", "浙江省湖州市",
"861593562", "山西省太原市",
"86170711", "北京市",
"86752", "广东省惠州市",
"861304043", "浙江省宁波市",
"861395942", "福建省宁德市",
"861328361", "山西省太原市",
"86188641", "河南省开封市",
"861825934", "福建省南平市",
"861356093", "广东省肇庆市",
"861312356", "广西百色市",
"861773432", "河北省邯郸市",
"861318664", "江苏省淮安市",
"861830805", "西藏昌都地区",
"861569236", "山东省潍坊市",
"861533969", "安徽省合肥市",
"861477306", "湖南省常德市",
"861806112", "江苏省徐州市",
"861839933", "新疆喀什地区",
"861360154", "江苏省苏州市",
"861326494", "湖北省鄂州市",
"861452868", "青海省西宁市",
"86131685", "广东省佛山市",
"86151275", "河北省唐山市",
"861354713", "四川省绵阳市",
"861835280", "江苏省连云港市",
"861583061", "河北省廊坊市",
"861894892", "广东省河源市",
"861803421", "河北省石家庄市",
"861870778", "广西河池市",
"861810751", "广东省韶关市",
"861505992", "福建省龙岩市",
"861452291", "山西省太原市",
"861780790", "江西省新余市",
"861556466", "山东省枣庄市",
"861377737", "浙江省杭州市",
"86130467", "江苏省南通市",
"861326301", "江西省赣州市",
"861367569", "安徽省蚌埠市",
"861368878", "云南省丽江市",
"861775270", "湖南省益阳市",
"86138843", "浙江省丽水市",
"861452324", "河南省许昌市",
"861329988", "青海省西宁市",
"861301012", "北京市",
"86180732", "湖南省长沙市",
"861595980", "福建省三明市",
"861347346", "河北省唐山市",
"861370025", "陕西省安康市",
"861896690", "陕西省西安市",
"861804880", "四川省乐山市",
"861879450", "甘肃省临夏回族自治州",
"861777505", "安徽省合肥市",
"86151559", "安徽省合肥市",
"861360552", "安徽省蚌埠市",
"861323487", "内蒙古巴彦淖尔市",
"86158868", "新疆阿克苏地区",
"861310050", "广西南宁市",
"861592938", "陕西省延安市",
"861821946", "广东省茂名市",
"861553310", "河北省邯郸市",
"861308132", "辽宁省抚顺市",
"861595563", "安徽省宣城市",
"861782015", "广东省河源市",
"861840714", "湖北省黄石市",
"861532995", "贵州省铜仁地区",
"86158811", "四川省成都市",
"861391245", "江苏省无锡市",
"861320743", "湖南省湘西土家族苗族自治州",
"861866452", "广东省广州市",
"861348456", "陕西省咸阳市",
"861855552", "安徽省蚌埠市",
"861351742", "湖南省邵阳市",
"861320881", "云南省西双版纳傣族自治州",
"861473679", "云南省丽江市",
"86182678", "浙江省温州市",
"861570836", "四川省甘孜藏族自治州",
"861835627", "安徽省铜陵市",
"861837198", "湖北省武汉市",
"861338097", "广东省江门市",
"861531497", "浙江省金华市",
"861362816", "四川省攀枝花市",
"861475249", "江苏省宿迁市",
"861893224", "江苏省南通市",
"861537821", "四川省绵阳市",
"861774076", "西藏那曲地区",
"861508074", "湖南省益阳市",
"86189983", "广东省广州市",
"86189749", "湖南省长沙市",
"861893404", "广东省湛江市",
"861364463", "黑龙江省牡丹江市",
"861503993", "河南省周口市",
"861338713", "湖北省十堰市",
"86156195", "陕西省咸阳市",
"861505541", "安徽省淮南市",
"861833349", "河北省邢台市",
"861567902", "江西省鹰潭市",
"861586310", "山东省威海市",
"861470770", "广西防城港市",
"861359328", "山西省长治市",
"861351401", "福建省泉州市",
"86137338", "河南省郑州市",
"861366467", "黑龙江省鸡西市",
"861477094", "江西省宜春市",
"861532572", "浙江省湖州市",
"861568273", "甘肃省武威市",
"861473638", "广西梧州市",
"86153981", "安徽省阜阳市",
"861879534", "宁夏固原市",
"861322822", "四川省成都市",
"86182547", "山东省济宁市",
"861326788", "广东省湛江市",
"861899587", "湖北省宜昌市",
"861324225", "广东省揭阳市",
"86133719", "上海市",
"861323731", "湖南省长沙市",
"861593084", "河北省唐山市",
"861816359", "湖北省咸宁市",
"861537685", "山东省聊城市",
"861395591", "安徽省铜陵市",
"861894926", "安徽省阜阳市",
"861860353", "山西省阳泉市",
"861471710", "甘肃省庆阳市",
"861324405", "吉林省四平市",
"861587017", "贵州省安顺市",
"861390931", "甘肃省兰州市",
"861572070", "江苏省南通市",
"861782665", "江苏省无锡市",
"861860567", "安徽省宿州市",
"861575169", "江苏省连云港市",
"861780862", "贵州省毕节地区",
"861535048", "江西省宜春市",
"86187419", "辽宁省辽阳市",
"861508358", "江西省赣州市",
"861573523", "山西省太原市",
"861572507", "山东省济宁市",
"861315146", "江苏省苏州市",
"861770749", "湖南省邵阳市",
"861772289", "广东省广州市",
"861804678", "江西省景德镇市",
"861801218", "江苏省宿迁市",
"86138529", "江苏省镇江市",
"861311532", "黑龙江省齐齐哈尔市",
"861592979", "陕西省榆林市",
"861301662", "广东省佛山市",
"861329504", "河南省许昌市",
"86186887", "广东省深圳市",
"861816034", "新疆伊犁哈萨克自治州",
"861589747", "湖南省永州市",
"86186376", "河南省信阳市",
"861361390", "河南省新乡市",
"861595345", "山东省济宁市",
"861831342", "云南省玉溪市",
"861350640", "山东省济南市",
"861369860", "山东省济南市",
"86147026", "四川省成都市",
"861857483", "湖南省娄底市",
"861884571", "黑龙江省大兴安岭地区",
"861569469", "云南省德宏傣族景颇族自治州",
"861524142", "辽宁省本溪市",
"861822456", "河南省新乡市",
"861539326", "甘肃省酒泉市",
"861328573", "浙江省嘉兴市",
"861894414", "江苏省南京市",
"861815879", "浙江省金华市",
"861872994", "陕西省榆林市",
"861340948", "河南省平顶山市",
"861337853", "贵州省安顺市",
"861354240", "广东省云浮市",
"861355702", "广西柳州市",
"861585287", "江苏省扬州市",
"861550514", "江苏省苏州市",
"861818555", "贵州省贵阳市",
"861303624", "江西省上饶市",
"86185754", "广东省东莞市",
"86150531", "山东省济南市",
"861805973", "福建省宁德市",
"86157065", "海南省海口市",
"861396300", "山东省聊城市",
"861306290", "江苏省镇江市",
"861308506", "安徽省合肥市",
"861569204", "广东省珠海市",
"86183822", "四川省成都市",
"861344987", "云南省昆明市",
"861471464", "广东省汕头市",
"861573397", "河北省承德市",
"861355046", "四川省巴中市",
"861351858", "贵州省六盘水市",
"861390639", "山东省青岛市",
"861339446", "吉林省白城市",
"861534550", "安徽省滁州市",
"861572762", "江西省吉安市",
"86180954", "宁夏固原市",
"86147999", "新疆伊犁哈萨克自治州",
"861459511", "云南省临沧市",
"861864738", "内蒙古呼和浩特市",
"86189427", "辽宁省盘锦市",
"861569424", "辽宁省本溪市",
"861818186", "四川省泸州市",
"861590489", "内蒙古呼和浩特市",
"86138296", "广东省汕头市",
"861809483", "新疆克拉玛依市",
"861831488", "浙江省杭州市",
"861860702", "江西省九江市",
"861584730", "内蒙古鄂尔多斯市",
"86153816", "浙江省绍兴市",
"861529471", "河南省安阳市",
"861303669", "四川省成都市",
"861390880", "云南省昆明市",
"861810777", "广西钦州市",
"861313539", "湖南省邵阳市",
"861554300", "吉林省长春市",
"861317738", "湖北省鄂州市",
"861356873", "四川省遂宁市",
"861537617", "山东省济南市",
"861829754", "安徽省芜湖市",
"86139810", "四川省德阳市",
"861774922", "陕西省西安市",
"861591122", "云南省大理白族自治州",
"86181773", "广西桂林市",
"861373465", "青海省西宁市",
"861325590", "福建省厦门市",
"86177576", "浙江省台州市",
"861350150", "广东省广州市",
"861874711", "内蒙古呼和浩特市",
"861835125", "江苏省苏州市",
"861566035", "新疆喀什地区",
"861871449", "黑龙江省鸡西市",
"861882968", "陕西省商洛市",
"861303019", "广东省湛江市",
"861870900", "新疆伊犁哈萨克自治州",
"861808990", "西藏拉萨市",
"861390678", "浙江省丽水市",
"861822897", "四川省泸州市",
"861827129", "湖北省宜昌市",
"86153808", "江苏省南京市",
"861769133", "陕西省渭南市",
"861346560", "山东省烟台市",
"861338337", "河北省沧州市",
"861309548", "安徽省铜陵市",
"861509003", "河南省安阳市",
"861535265", "新疆克拉玛依市",
"861479789", "江西省萍乡市",
"861705584", "山东省济南市",
"861317779", "江西省赣州市",
"861313578", "湖北省荆州市",
"861555321", "山东省青岛市",
"861331543", "河北省保定市",
"861338408", "河南省南阳市",
"861520252", "青海省海东地区",
"861527269", "湖北省咸宁市",
"861857802", "广东省江门市",
"861300760", "河南省郑州市",
"861537258", "浙江省杭州市",
"86152005", "湖南省衡阳市",
"861534434", "吉林省通化市",
"861783542", "山西省晋中市",
"861529076", "河南省平顶山市",
"861858313", "四川省宜宾市",
"86155897", "山东省济宁市",
"861840460", "黑龙江省双鸭山市",
"86158139", "广东省肇庆市",
"861357548", "浙江省杭州市",
"861863847", "河南省洛阳市",
"861389949", "新疆克孜勒苏柯尔克孜自治州",
"86158986", "山东省济宁市",
"86131267", "北京市",
"861458696", "山东省莱芜市",
"861300926", "辽宁省抚顺市",
"861865150", "江苏省无锡市",
"861332744", "山西省晋中市",
"86147401", "辽宁省铁岭市",
"861845011", "福建省漳州市",
"861315587", "江西省抚州市",
"861388697", "湖北省武汉市",
"86152349", "山西省朔州市",
"861323415", "辽宁省丹东市",
"861334684", "河南省周口市",
"861513854", "河南省濮阳市",
"861380375", "河南省平顶山市",
"861501501", "广东省江门市",
"861505467", "山东省菏泽市",
"861768511", "贵州省贵阳市",
"861366541", "山东省济南市",
"861320930", "甘肃省临夏回族自治州",
"861339041", "辽宁省盘锦市",
"861815838", "浙江省金华市",
"861470612", "江苏省常州市",
"86534", "山东省德州市",
"861802569", "广东省中山市",
"861328254", "浙江省温州市",
"861880993", "新疆石河子市",
"861334512", "山东省济南市",
"861883532", "山西省阳泉市",
"861567245", "湖北省黄冈市",
"861533416", "湖北省荆州市",
"861879506", "宁夏石嘴山市",
"861452505", "山东省日照市",
"861356333", "山东省日照市",
"861838589", "贵州省铜仁地区",
"861306055", "广东省揭阳市",
"861538300", "河北省石家庄市",
"861470584", "浙江省宁波市",
"861816742", "新疆克拉玛依市",
"86151360", "河南省商丘市",
"86185062", "江苏省苏州市",
"861837010", "江西省九江市",
"861386703", "浙江省衢州市",
"861882746", "湖北省黄冈市",
"861516081", "新疆吐鲁番地区",
"861304356", "福建省龙岩市",
"861369792", "江西省九江市",
"861558550", "吉林省白城市",
"861839740", "湖南省衡阳市",
"861357520", "湖南省常德市",
"861366575", "浙江省湖州市",
"861862917", "陕西省宝鸡市",
"861831794", "江西省抚州市",
"86159050", "福建省泉州市",
"861339075", "江苏省南京市",
"861571083", "广东省深圳市",
"861830568", "安徽省亳州市",
"861820559", "安徽省黄山市",
"861855199", "江苏省泰州市",
"861319884", "四川省宜宾市",
"86150475", "内蒙古通辽市",
"861477874", "广东省中山市",
"86139616", "江苏省无锡市",
"861554823", "内蒙古兴安盟",
"861563314", "河北省承德市",
"86136562", "江苏省苏州市",
"861367305", "河南省安阳市",
"861705612", "浙江省宁波市",
"861770352", "山西省大同市",
"861325266", "吉林省通化市",
"861309520", "云南省昭通市",
"861802122", "江苏省镇江市",
"86186809", "重庆市",
"861871882", "广东省茂名市",
"861338240", "江苏省南京市",
"861705182", "上海市",
"861869143", "陕西省商洛市",
"861780956", "宁夏吴忠市",
"861394919", "河南省信阳市",
"861321847", "江苏省常州市",
"861760431", "吉林省长春市",
"861329536", "山东省潍坊市",
"86188242", "广东省深圳市",
"861816006", "四川省泸州市",
"861580201", "广东省广州市",
"861800061", "河北省石家庄市",
"861580421", "辽宁省朝阳市",
"861520907", "新疆博尔塔拉蒙古自治州",
"861591524", "广东省佛山市",
"861805410", "甘肃省酒泉市",
"861572890", "西藏拉萨市",
"86150206", "山东省聊城市",
"861359985", "福建省莆田市",
"861376790", "江西省景德镇市",
"861860475", "内蒙古通辽市",
"86131537", "山东省济宁市",
"861478528", "贵州省铜仁地区",
"86178548", "山东省泰安市",
"861459176", "内蒙古鄂尔多斯市",
"86134717", "广西钦州市",
"861370260", "广东省佛山市",
"861596408", "山东省临沂市",
"861327363", "河北省廊坊市",
"861321433", "吉林省延边朝鲜族自治州",
"861847810", "湖南省常德市",
"861528033", "福建省宁德市",
"861889444", "甘肃省定西市",
"861800611", "江苏省常州市",
"86170953", "江苏省南通市",
"861378802", "广西柳州市",
"861314197", "湖南省邵阳市",
"861512984", "陕西省渭南市",
"861358114", "山东省泰安市",
"86183646", "山东省潍坊市",
"861302695", "广西玉林市",
"861511926", "广东省河源市",
"861590842", "四川省广元市",
"861479801", "黑龙江省哈尔滨市",
"861705062", "陕西省西安市",
"86153610", "广东省深圳市",
"861847139", "湖北省恩施土家族苗族自治州",
"8618501", "北京市",
"861557049", "湖北省孝感市",
"861596337", "山东省德州市",
"861865628", "安徽省亳州市",
"86139608", "福建省福州市",
"86159892", "广东省广州市",
"86145424", "海南省海口市",
"861841963", "甘肃省平凉市",
"861770418", "辽宁省阜新市",
"86139795", "江西省宜春市",
"861804211", "浙江省温州市",
"861813950", "新疆伊犁哈萨克自治州",
"861816221", "江西省宜春市",
"861570804", "西藏林芝地区",
"861843265", "河北省唐山市",
"861340920", "河南省新乡市",
"861595371", "山东省济宁市",
"861454706", "浙江省台州市",
"861550682", "广西柳州市",
"861379990", "福建省宁德市",
"861800466", "黑龙江省哈尔滨市",
"861354228", "广东省韶关市",
"861351359", "山西省运城市",
"861554282", "辽宁省锦州市",
"861327557", "安徽省宿州市",
"861528527", "贵州省黔东南苗族侗族自治州",
"861350628", "江苏省南通市",
"861338877", "云南省玉溪市",
"861470908", "新疆克孜勒苏柯尔克孜自治州",
"861760787", "广西钦州市",
"861332392", "河南省鹤壁市",
"861354337", "广东省茂名市",
"861350432", "吉林省长春市",
"861813387", "河北省廊坊市",
"861862864", "陕西省汉中市",
"861705526", "湖南省长沙市",
"861872449", "黑龙江省哈尔滨市",
"861829367", "甘肃省天水市",
"861384972", "河南省信阳市",
"861821897", "广东省茂名市",
"861834231", "辽宁省盘锦市",
"861894865", "广东省肇庆市",
"861860149", "江苏省常州市",
"861816143", "四川省达州市",
"861323917", "陕西省宝鸡市",
"861802586", "广东省佛山市",
"861876740", "浙江省台州市",
"861561583", "山东省淄博市",
"86177316", "河北省廊坊市",
"861308928", "吉林省四平市",
"861395130", "江苏省南通市",
"861508982", "广东省江门市",
"861595410", "山东省济南市",
"861801524", "江苏省南通市",
"86176601", "山东省济宁市",
"86130640", "山东省济南市",
"861454298", "辽宁省辽阳市",
"86136804", "广东省江门市",
"861827201", "湖北省武汉市",
"86156144", "河北省保定市",
"861479920", "新疆阿克苏地区",
"861892262", "广东省肇庆市",
"861550851", "贵州省贵阳市",
"861454861", "河南省平顶山市",
"86130622", "福建省龙岩市",
"861869006", "陕西省延安市",
"861332543", "陕西省渭南市",
"861830631", "山东省威海市",
"861705783", "浙江省杭州市",
"86131421", "湖南省长沙市",
"861869742", "内蒙古锡林郭勒盟",
"861880391", "河南省焦作市",
"86131167", "浙江省杭州市",
"861339790", "江西省新余市",
"861334626", "山东省德州市",
"861569081", "河南省周口市",
"861452797", "新疆乌鲁木齐市",
"861331744", "湖南省张家界市",
"861781736", "广东省深圳市",
"86139351", "山西省太原市",
"861479766", "青海省玉树藏族自治州",
"861537739", "湖南省邵阳市",
"861470875", "云南省保山市",
"861355149", "四川省巴中市",
"861527286", "湖北省随州市",
"861472672", "四川省泸州市",
"861379468", "广东省韶关市",
"861533538", "山东省泰安市",
"861810068", "江苏省苏州市",
"861829553", "宁夏吴忠市",
"861364510", "江苏省盐城市",
"861330406", "辽宁省锦州市",
"861580562", "安徽省铜陵市",
"861452663", "江西省上饶市",
"861300984", "黑龙江省哈尔滨市",
"861802155", "江苏省无锡市",
"861512892", "河北省邯郸市",
"861303545", "安徽省滁州市",
"86131061", "浙江省温州市",
"861770325", "河北省唐山市",
"86187859", "贵州省黔西南布依族苗族自治州",
"861319575", "青海省西宁市",
"861858911", "西藏拉萨市",
"861533579", "湖北省随州市",
"861821456", "云南省昆明市",
"861860659", "浙江省宁波市",
"861810618", "江苏省无锡市",
"861378598", "河北省邢台市",
"861590466", "黑龙江省鸡西市",
"861869401", "湖北省恩施土家族苗族自治州",
"861861328", "四川省资阳市",
"861899049", "四川省甘孜藏族自治州",
"861323829", "辽宁省铁岭市",
"861854566", "黑龙江省哈尔滨市",
"861589275", "四川省南充市",
"86131006", "湖北省武汉市",
"861362390", "河南省新乡市",
"861520772", "广西柳州市",
"861867662", "广东省广州市",
"861523420", "山西省大同市",
"861518229", "四川省乐山市",
"861552574", "山西省运城市",
"861303686", "广西南宁市",
"861317259", "广东省潮州市",
"861521712", "广东省东莞市",
"861807030", "江西省上饶市",
"861811678", "四川省广元市",
"861304532", "黑龙江省牡丹江市",
"861581320", "广东省汕尾市",
"861833643", "河南省安阳市",
"861871994", "新疆吐鲁番地区",
"861539384", "云南省曲靖市",
"861390093", "甘肃省临夏回族自治州",
"861323864", "云南省曲靖市",
"861571762", "河北省廊坊市",
"86189261", "广东省广州市",
"861323340", "山西省忻州市",
"861329352", "山西省大同市",
"861806228", "湖北省黄石市",
"86182941", "甘肃省武威市",
"861812717", "广东省潮州市",
"861518264", "四川省自贡市",
"861369636", "山东省潍坊市",
"861330001", "安徽省安庆市",
"86189218", "江苏省盐城市",
"8618217", "上海市",
"861319992", "新疆伊犁哈萨克自治州",
"861367147", "广东省湛江市",
"861590611", "江苏省常州市",
"861550713", "湖北省荆州市",
"861770536", "山东省潍坊市",
"861380909", "江苏省宿迁市",
"861776601", "江苏省泰州市",
"861381440", "江苏省徐州市",
"861551773", "河南省南阳市",
"861368721", "湖北省十堰市",
"861336990", "新疆克拉玛依市",
"861866942", "山东省青岛市",
"86180892", "陕西省西安市",
"86138196", "浙江省台州市",
"861569486", "河北省石家庄市",
"86153587", "江苏省南通市",
"861586457", "山东省潍坊市",
"861768854", "广东省深圳市",
"861802645", "广东省惠州市",
"861392257", "广东省韶关市",
"86150161", "广东省中山市",
"86176860", "山东省烟台市",
"86183307", "河北省沧州市",
"86137672", "江西省九江市",
"861830700", "江西省南昌市",
"86150118", "广东省广州市",
"861882490", "广东省广州市",
"861345887", "四川省内江市",
"861322433", "吉林省延边朝鲜族自治州",
"861768038", "湖南省娄底市",
"861359731", "广西桂林市",
"861870546", "山东省东营市",
"861470335", "河北省秦皇岛市",
"861478906", "西藏那曲地区",
"861570198", "新疆克拉玛依市",
"86138828", "四川省达州市",
"861323328", "山西省晋城市",
"861780895", "西藏昌都地区",
"861308317", "安徽省安庆市",
"861363456", "黑龙江省黑河市",
"861839496", "甘肃省陇南市",
"861802671", "广东省揭阳市",
"861700832", "浙江省杭州市",
"861599483", "广东省深圳市",
"86130959", "浙江省宁波市",
"86150067", "山东省枣庄市",
"861365690", "福建省三明市",
"861591645", "广东省潮州市",
"861586922", "浙江省丽水市",
"861589241", "四川省达州市",
"861560463", "黑龙江省牡丹江市",
"861342249", "广东省汕头市",
"861332509", "山东省临沂市",
"861840998", "新疆喀什地区",
"861322270", "江苏省淮安市",
"861326641", "广东省湛江市",
"861572163", "山西省阳泉市",
"861820085", "广东省东莞市",
"861316860", "广东省惠州市",
"861879928", "新疆石河子市",
"861529947", "新疆乌鲁木齐市",
"861316344", "黑龙江省哈尔滨市",
"86135759", "浙江省金华市",
"86131493", "广东省广州市",
"861348768", "湖南省益阳市",
"861459079", "广东省揭阳市",
"861339862", "河北省保定市",
"861398581", "贵州省黔东南苗族侗族自治州",
"861850690", "福建省福州市",
"861331392", "福建省龙岩市",
"861515256", "江苏省淮安市",
"861343878", "四川省南充市",
"861804873", "四川省达州市",
"861595973", "福建省龙岩市",
"86189531", "山东省济南市",
"861707040", "浙江省湖州市",
"861869394", "甘肃省兰州市",
"861333354", "山西省晋中市",
"86186793", "江西省上饶市",
"861528699", "河南省安阳市",
"861816109", "四川省宜宾市",
"861536676", "江苏省徐州市",
"861775283", "湖南省岳阳市",
"861872403", "江苏省苏州市",
"861779930", "新疆乌鲁木齐市",
"861524881", "内蒙古阿拉善盟",
"861335167", "黑龙江省鸡西市",
"861367938", "甘肃省天水市",
"861884624", "黑龙江省鸡西市",
"861860977", "青海省海西蒙古族藏族自治州",
"86184876", "云南省昭通市",
"861806877", "江苏省常州市",
"86184387", "河南省开封市",
"861319826", "四川省泸州市",
"861559637", "陕西省商洛市",
"861303571", "广东省河源市",
"861335736", "湖南省常德市",
"861857598", "广东省东莞市",
"861363897", "西藏阿里地区",
"861318323", "河南省周口市",
"861319541", "安徽省亳州市",
"861557146", "湖北省荆州市",
"861835152", "江苏省宿迁市",
"86178625", "山东省聊城市",
"86134099", "湖北省黄冈市",
"861337285", "辽宁省鞍山市",
"861470526", "江苏省泰州市",
"861572083", "江苏省无锡市",
"861772439", "广东省肇庆市",
"861809598", "新疆石河子市",
"861768079", "湖南省邵阳市",
"861778011", "四川省泸州市",
"86134553", "山东省淄博市",
"861479948", "新疆喀什地区",
"861388162", "四川省雅安市",
"861598990", "广东省东莞市",
"861509146", "陕西省汉中市",
"861360491", "辽宁省鞍山市",
"86151858", "贵州省铜仁地区",
"861517567", "河北省廊坊市",
"861507637", "河北省承德市",
"861532962", "贵州省遵义市",
"861833609", "河南省新乡市",
"861372191", "山东省济宁市",
"861862415", "辽宁省丹东市",
"861776730", "浙江省宁波市",
"861888288", "四川省凉山彝族自治州",
"86182332", "河北省保定市",
"861801122", "四川省宜宾市",
"861760810", "四川省眉山市",
"861887252", "湖北省宜昌市",
"861321750", "广东省江门市",
"86158569", "安徽省合肥市",
"861308940", "吉林省长春市",
"861470783", "广西桂林市",
"861880269", "广东省东莞市",
"861322847", "陕西省宝鸡市",
"86188698", "云南省大理白族自治州",
"861708559", "安徽省阜阳市",
"861333078", "四川省泸州市",
"86188705", "江西省宜春市",
"861874285", "新疆巴音郭楞蒙古自治州",
"861831231", "广东省揭阳市",
"861319256", "广东省阳江市",
"861899395", "甘肃省白银市",
"861535862", "江苏省镇江市",
"861308705", "河南省平顶山市",
"861370795", "江西省宜春市",
"861310414", "辽宁省本溪市",
"86157071", "海南省海口市",
"861857425", "河南省郑州市",
"861399973", "新疆石河子市",
"861824897", "江苏省宿迁市",
"861520855", "贵州省黔东南苗族侗族自治州",
"861593440", "山西省晋中市",
"861897046", "江西省吉安市",
"861564583", "黑龙江省鹤岗市",
"861857205", "湖北省襄樊市",
"861772922", "陕西省延安市",
"86159396", "河南省驻马店市",
"861539167", "湖北省咸宁市",
"861385241", "江苏省泰州市",
"861880854", "贵州省黔南布依族苗族自治州",
"861839407", "甘肃省临夏回族自治州",
"861538885", "云南省昭通市",
"861370316", "河北省廊坊市",
"861305656", "四川省雅安市",
"861564960", "河南省新乡市",
"861510134", "甘肃省兰州市",
"861380912", "陕西省榆林市",
"861586478", "山东省济南市",
"861518074", "贵州省贵阳市",
"861824051", "河南省信阳市",
"86156683", "山东省济南市",
"861311474", "广西梧州市",
"861334744", "陕西省咸阳市",
"861828915", "西藏昌都地区",
"861523567", "山西省运城市",
"86131121", "广东省揭阳市",
"861367639", "山东省临沂市",
"861338727", "湖北省宜昌市",
"861320366", "湖南省益阳市",
"861561644", "湖南省长沙市",
"861345128", "湖北省随州市",
"861879472", "甘肃省酒泉市",
"861550394", "河南省周口市",
"861829064", "新疆乌鲁木齐市",
"861816514", "陕西省渭南市",
"861305515", "湖南省湘潭市",
"86181732", "湖南省长沙市",
"861360570", "浙江省杭州市",
"861518412", "辽宁省铁岭市",
"86177505", "福建省泉州市",
"861347697", "湖北省荆州市",
"861814880", "广东省中山市",
"861809425", "江苏省苏州市",
"861536936", "河北省石家庄市",
"86139554", "安徽省淮南市",
"861804569", "黑龙江省双鸭山市",
"86186767", "广东省深圳市",
"861814639", "青海省玉树藏族自治州",
"861318132", "山东省济宁市",
"861587537", "广东省汕头市",
"861361510", "江苏省徐州市",
"861310072", "湖北省武汉市",
"861811657", "四川省成都市",
"861475100", "江苏省苏州市",
"861367880", "山东省济南市",
"861332684", "广东省江门市",
"861859463", "福建省漳州市",
"861353119", "广东省汕头市",
"861521709", "广东省东莞市",
"861337141", "山东省东营市",
"861864328", "吉林省延边朝鲜族自治州",
"861479159", "陕西省西安市",
"861572052", "安徽省蚌埠市",
"861368933", "甘肃省平凉市",
"861824456", "河北省沧州市",
"861840699", "云南省德宏傣族景颇族自治州",
"86157225", "江苏省盐城市",
"861589615", "江苏省淮安市",
"861835613", "安徽省合肥市",
"861860637", "山东省枣庄市",
"861768391", "湖北省襄樊市",
"86152629", "江苏省镇江市",
"86184512", "江苏省淮安市",
"86158151", "广东省汕头市",
"861363806", "贵州省黔东南苗族侗族自治州",
"861317328", "山东省滨州市",
"861518358", "四川省达州市",
"861350780", "广西玉林市",
"86145337", "重庆市",
"861858593", "贵州省黔西南布依族苗族自治州",
"861341485", "广东省湛江市",
"861346925", "湖南省岳阳市",
"861811218", "江苏省连云港市",
"861814678", "江西省南昌市",
"861301532", "山西省临汾市",
"861315035", "新疆昌吉回族自治州",
"861874994", "河南省濮阳市",
"86157592", "福建省厦门市",
"861839379", "甘肃省陇南市",
"861529289", "新疆乌鲁木齐市",
"861515541", "安徽省淮南市",
"861458355", "山东省济南市",
"861862738", "湖南省娄底市",
"86189227", "广东省广州市",
"861386689", "安徽省淮北市",
"861887283", "湖北省咸宁市",
"861532550", "浙江省温州市",
"861586439", "山东省聊城市",
"861337651", "广东省揭阳市",
"861385722", "浙江省舟山市",
"861538621", "湖南省株洲市",
"861826893", "浙江省丽水市",
"861399107", "陕西省榆林市",
"861830945", "甘肃省武威市",
"86138496", "河南省商丘市",
"861811147", "四川省宜宾市",
"861821806", "广东省惠州市",
"861833182", "河北省衡水市",
"861518859", "河南省信阳市",
"861317829", "福建省三明市",
"861357965", "新疆哈密地区",
"861590245", "辽宁省丹东市",
"861304695", "福建省宁德市",
"861521743", "广东省汕头市",
"861869851", "浙江省嘉兴市",
"861333891", "江苏省淮安市",
"861813026", "安徽省宣城市",
"86150127", "广东省深圳市",
"86150461", "黑龙江省哈尔滨市",
"861316047", "江苏省南京市",
"86147536", "山东省潍坊市",
"861318450", "江西省景德镇市",
"861508953", "广东省汕尾市",
"861308472", "内蒙古包头市",
"86150418", "辽宁省阜新市",
"861831911", "广东省汕头市",
"861329735", "湖南省郴州市",
"861561552", "山东省青岛市",
"861380232", "广东省揭阳市",
"861354727", "四川省资阳市",
"861830971", "青海省西宁市",
"861577455", "黑龙江省绥化市",
"86156750", "湖南省岳阳市",
"861864829", "内蒙古赤峰市",
"861707867", "云南省楚雄彝族自治州",
"861559149", "陕西省安康市",
"86170888", "广东省汕头市",
"861594645", "黑龙江省齐齐哈尔市",
"861333057", "云南省曲靖市",
"861869097", "新疆乌鲁木齐市",
"861383586", "山西省运城市",
"861575468", "黑龙江省鹤岗市",
"861888810", "江苏省盐城市",
"86138817", "四川省成都市",
"86150021", "上海市",
"861317340", "山东省威海市",
"861500474", "内蒙古乌兰察布市",
"861866913", "云南省临沧市",
"86156637", "黑龙江省哈尔滨市",
"861860958", "宁夏银川市",
"861879705", "青海省海东地区",
"861322610", "广东省潮州市",
"861810919", "陕西省铜川市",
"861390305", "广东省广州市",
"861800813", "四川省自贡市",
"861760647", "山东省东营市",
"861882545", "广东省惠州市",
"861772896", "广东省韶关市",
"861322180", "浙江省杭州市",
"861393803", "河南省漯河市",
"861864864", "内蒙古包头市",
"861596727", "浙江省丽水市",
"861330497", "辽宁省营口市",
"861309965", "云南省普洱市",
"861366776", "广西百色市",
"861397199", "湖北省鄂州市",
"861839878", "四川省广元市",
"861562876", "山东省济南市",
"861352337", "河南省焦作市",
"861334392", "河南省鹤壁市",
"861775173", "江苏省徐州市",
"861848772", "云南省玉溪市",
"861522544", "河南省洛阳市",
"861580950", "宁夏银川市",
"86151662", "山东省东营市",
"861599130", "陕西省渭南市",
"861803315", "广东省肇庆市",
"861705752", "江苏省苏州市",
"861550742", "湖南省娄底市",
"861501414", "广东省深圳市",
"861308014", "河南省漯河市",
"861584803", "内蒙古乌兰察布市",
"861881624", "江苏省徐州市",
"861538773", "江西省九江市",
"861533863", "贵州省安顺市",
"861454505", "湖南省益阳市",
"86152952", "江苏省泰州市",
"86182513", "江苏省南通市",
"861554621", "黑龙江省哈尔滨市",
"861594723", "内蒙古包头市",
"861332512", "山东省济南市",
"86155216", "广东省湛江市",
"861317917", "吉林省白山市",
"861365486", "内蒙古赤峰市",
"86150275", "河北省唐山市",
"861530365", "黑龙江省哈尔滨市",
"8618423", "重庆市",
"861567842", "广西玉林市",
"861873560", "山西省晋城市",
"861343857", "四川省达州市",
"861322060", "山东省莱芜市",
"861816112", "四川省广安市",
"861521625", "江西省抚州市",
"861846465", "山东省东营市",
"861839839", "四川省甘孜藏族自治州",
"861837499", "湖南省长沙市",
"861813421", "河北省邯郸市",
"861325179", "吉林省松原市",
"861800751", "广东省韶关市",
"861345140", "河北省衡水市",
"86136095", "福建省福州市",
"861850486", "内蒙古赤峰市",
"861369976", "广东省深圳市",
"861328886", "广东省东莞市",
"861778190", "四川省广元市",
"861510532", "山东省青岛市",
"861599927", "新疆伊犁哈萨克自治州",
"861340451", "吉林省通化市",
"861760157", "江苏省苏州市",
"861450999", "新疆伊犁哈萨克自治州",
"861308629", "青海省西宁市",
"861867043", "湖南省湘西土家族苗族自治州",
"861594586", "黑龙江省佳木斯市",
"861459404", "云南省红河哈尼族彝族自治州",
"861335384", "河南省周口市",
"86188060", "福建省三明市",
"861396621", "安徽省宣城市",
"861393482", "山西省大同市",
"86185595", "福建省泉州市",
"861707914", "浙江省宁波市",
"861330856", "贵州省铜仁地区",
"861593428", "山西省忻州市",
"86183326", "河北省唐山市",
"861708537", "山东省济宁市",
"86188420", "辽宁省鞍山市",
"86188442", "吉林省吉林市",
"861314043", "河南省焦作市",
"861329383", "山西省阳泉市",
"86137510", "广东省深圳市",
"861593208", "河北省唐山市",
"861591931", "广东省广州市",
"86157125", "河北省保定市",
"861809819", "广东省佛山市",
"861554574", "黑龙江省鸡西市",
"861364390", "河南省新乡市",
"8615900", "上海市",
"861556068", "内蒙古呼伦贝尔市",
"861313363", "江西省九江市",
"861378452", "河北省秦皇岛市",
"86187831", "四川省宜宾市",
"861375581", "江西省赣州市",
"86157700", "新疆阿克苏地区",
"861890474", "内蒙古乌兰察布市",
"861573094", "甘肃省天水市",
"86151937", "甘肃省酒泉市",
"861561525", "山东省聊城市",
"861350929", "广东省广州市",
"861310865", "云南省昆明市",
"861386666", "安徽省合肥市",
"861768993", "福建省漳州市",
"861479451", "黑龙江省哈尔滨市",
"861529266", "新疆和田地区",
"861880511", "江苏省盐城市",
"861302532", "广东省汕头市",
"861593315", "河北省唐山市",
"861303746", "湖南省永州市",
"86184372", "河南省安阳市",
"861359294", "广东省揭阳市",
"86147166", "广东省广州市",
"861319776", "广西百色市",
"861558962", "山东省烟台市",
"861567061", "河南省郑州市",
"861396574", "安徽省阜阳市",
"861857130", "湖北省恩施土家族苗族自治州",
"861818276", "黑龙江省七台河市",
"861570454", "黑龙江省佳木斯市",
"861531550", "山东省青岛市",
"86997", "新疆阿克苏地区",
"861535075", "河北省沧州市",
"86189418", "辽宁省阜新市",
"861341987", "河南省新乡市",
"861348834", "陕西省榆林市",
"861786890", "云南省玉溪市",
"86189461", "黑龙江省哈尔滨市",
"86130320", "河北省保定市",
"861583188", "河北省沧州市",
"86189127", "江苏省苏州市",
"861336547", "山东省济宁市",
"861816851", "江苏省宿迁市",
"861510356", "山西省晋城市",
"861705153", "广东省东莞市",
"861550143", "江苏省徐州市",
"861834488", "江苏省徐州市",
"861367717", "湖北省宜昌市",
"861804645", "福建省泉州市",
"861313557", "安徽省宿州市",
"86189021", "天津市",
"861857819", "广东省清远市",
"861871853", "广东省茂名市",
"861391239", "江苏省无锡市",
"861458480", "山东省青岛市",
"861520996", "新疆巴音郭楞蒙古自治州",
"861827387", "湖南省怀化市",
"86182836", "四川省甘孜藏族自治州",
"861537277", "浙江省舟山市",
"861876839", "浙江省湖州市",
"861347564", "山东省日照市",
"861338359", "山西省运城市",
"861861779", "河北省保定市",
"861802333", "广东省清远市",
"861328368", "山西省大同市",
"861351877", "云南省玉溪市",
"861700915", "陕西省西安市",
"861804586", "黑龙江省双鸭山市",
"861316976", "广东省茂名市",
"86152760", "新疆喀什地区",
"861890662", "浙江省宁波市",
"861334543", "新疆哈密地区",
"861803632", "江苏省盐城市",
"861770735", "湖南省郴州市",
"861813562", "河南省漯河市",
"861876110", "江苏省宿迁市",
"861894262", "河北省石家庄市",
"861452861", "青海省西宁市",
"861452298", "山西省临汾市",
"861870771", "广西南宁市",
"861803428", "河北省衡水市",
"861810758", "广东省肇庆市",
"861367093", "广东省佛山市",
"86189406", "辽宁省锦州市",
"861350817", "四川省自贡市",
"86153463", "河南省驻马店市",
"861575990", "福建省莆田市",
"86158439", "吉林省白山市",
"861774807", "四川省宜宾市",
"861343728", "湖北省武汉市",
"861537840", "四川省凉山彝族自治州",
"861531434", "山东省东营市",
"861567181", "湖北省咸宁市",
"861570530", "山东省菏泽市",
"861347529", "山东省东营市",
"861839905", "新疆阿克苏地区",
"861332626", "山东省德州市",
"86187748", "湖南省长沙市",
"861390147", "江苏省南通市",
"861830833", "四川省泸州市",
"861812657", "广东省肇庆市",
"86147007", "广西河池市",
"861384796", "内蒙古赤峰市",
"861355719", "广西北海市",
"861454663", "广东省江门市",
"861590751", "广东省韶关市",
"86147813", "四川省自贡市",
"861550653", "山东省菏泽市",
"86189275", "广东省广州市",
"861362510", "江苏省常州市",
"86189559", "安徽省黄山市",
"86182373", "河南省新乡市",
"861373246", "浙江省绍兴市",
"86155116", "河北省石家庄市",
"861320888", "云南省丽江市",
"861301356", "山东省东营市",
"861337882", "云南省德宏傣族景颇族自治州",
"861881686", "广东省佛山市",
"861348374", "河北省唐山市",
"86185122", "天津市",
"861850469", "黑龙江省双鸭山市",
"861537828", "四川省达州市",
"861323779", "广西来宾市",
"861820537", "山东省济宁市",
"861535446", "河北省唐山市",
"86188776", "广西百色市",
"86150175", "广东省广州市",
"861594569", "黑龙江省哈尔滨市",
"86135731", "山东省济南市",
"861365424", "辽宁省大连市",
"861321060", "山东省莱芜市",
"861522625", "宁夏中卫市",
"861330572", "浙江省湖州市",
"861847647", "广东省湛江市",
"861705272", "北京市",
"861776849", "江苏省盐城市",
"861308597", "甘肃省天水市",
"861326308", "江西省抚州市",
"861329981", "青海省西宁市",
"861368871", "云南省昆明市",
"861378819", "广西钦州市",
"86180396", "河南省驻马店市",
"861819470", "青海省黄南藏族自治州",
"861366256", "广东省深圳市",
"861882669", "广东省湛江市",
"861803440", "河北省秦皇岛市",
"861517135", "湖北省黄冈市",
"861774439", "四川省凉山彝族自治州",
"861390979", "青海省海西蒙古族藏族自治州",
"861470643", "山东省淄博市",
"86153572", "安徽省安庆市",
"861870745", "湖南省怀化市",
"861317415", "江苏省徐州市",
"861858342", "四川省阿坝藏族羌族自治州",
"861775405", "安徽省滁州市",
"86151983", "云南省大理白族自治州",
"86151749", "内蒙古包头市",
"86137370", "广西南宁市",
"861370070", "河南省商丘市",
"861324847", "浙江省金华市",
"861592931", "陕西省西安市",
"861356569", "新疆阿克苏地区",
"861335326", "吉林省长春市",
"861509716", "甘肃省白银市",
"861318733", "湖南省衡阳市",
"861390938", "甘肃省天水市",
"861346952", "宁夏石嘴山市",
"861780292", "陕西省西安市",
"861347082", "安徽省宿州市",
"861324433", "吉林省延边朝鲜族自治州",
"861844580", "黑龙江省伊春市",
"861835782", "浙江省温州市",
"861309467", "浙江省嘉兴市",
"861705609", "重庆市",
"861877509", "广西玉林市",
"861476247", "江苏省徐州市",
"861830373", "河南省新乡市",
"86134728", "上海市",
"861330995", "新疆吐鲁番地区",
"861535041", "江西省南昌市",
"861831313", "云南省玉溪市",
"861524683", "黑龙江省鹤岗市",
"86153197", "陕西省西安市",
"86138586", "浙江省台州市",
"861585949", "福建省泉州市",
"861337223", "江苏省徐州市",
"861533190", "黑龙江省大庆市",
"861847157", "湖北省武汉市",
"861801211", "江苏省宿迁市",
"861804671", "江西省南昌市",
"86182630", "山东省德州市",
"861303968", "黑龙江省伊春市",
"861882019", "广东省深圳市",
"861805196", "江苏省南京市",
"86131293", "广东省广州市",
"861560816", "四川省雅安市",
"861321180", "云南省保山市",
"861351408", "福建省福州市",
"861359321", "山西省忻州市",
"861378927", "湖南省怀化市",
"861473631", "广西桂林市",
"861458607", "湖北省随州市",
"861577957", "江西省南昌市",
"86182757", "广西南宁市",
"86183885", "云南省曲靖市",
"86137633", "广东省广州市",
"861334509", "山东省临沂市",
"861521544", "山东省德州市",
"861596034", "福建省龙岩市",
"861326781", "广东省梅州市",
"861320670", "黑龙江省黑河市",
"861812979", "广东省河源市",
"861875894", "浙江省金华市",
"861335535", "山东省烟台市",
"861340649", "山东省威海市",
"861395598", "安徽省黄山市",
"861458322", "江西省九江市",
"861470725", "湖北省黄冈市",
"861323738", "湖南省娄底市",
"861563667", "黑龙江省双鸭山市",
"86188964", "云南省普洱市",
"86135848", "江苏省苏州市",
"861874223", "辽宁省锦州市",
"86155108", "天津市",
"861327539", "山东省临沂市",
"861773773", "河南省洛阳市",
"86182088", "云南省昆明市",
"861576736", "广东省惠州市",
"861556902", "新疆和田地区",
"861351337", "河北省石家庄市",
"861779113", "陕西省榆林市",
"861519656", "四川省雅安市",
"861360960", "广东省广州市",
"861458105", "安徽省宣城市",
"861853184", "河北省廊坊市",
"861351851", "贵州省贵阳市",
"861886029", "河南省洛阳市",
"861459518", "云南省德宏傣族景颇族自治州",
"861306344", "安徽省合肥市",
"861576015", "四川省巴中市",
"86130493", "广东省深圳市",
"861771445", "江苏省苏州市",
"861588798", "云南省临沧市",
"86137609", "广东省佛山市",
"861708314", "河北省唐山市",
"861863405", "河北省沧州市",
"86187355", "山西省长治市",
"861847516", "广东省阳江市",
"861868790", "云南省昆明市",
"861360583", "浙江省嘉兴市",
"861338742", "湖南省常德市",
"861552150", "广东省广州市",
"861831481", "浙江省金华市",
"861870757", "广东省佛山市",
"861529478", "河南省周口市",
"861806109", "江苏省南通市",
"861558497", "吉林省辽源市",
"861317731", "湖北省黄石市",
"86137471", "内蒙古呼和浩特市",
"86156032", "河北省保定市",
"861311695", "云南省昆明市",
"86159357", "山西省临汾市",
"861567239", "湖北省咸宁市",
"86151161", "湖南省长沙市",
"86151427", "辽宁省盘锦市",
"86186654", "广东省佛山市",
"86147089", "海南省海口市",
"861361244", "广东省潮州市",
"861325922", "陕西省宝鸡市",
"861531406", "山东省威海市",
"86151118", "重庆市",
"861855960", "福建省漳州市",
"861591717", "广东省潮州市",
"861342100", "广东省梅州市",
"861318317", "河南省濮阳市",
"861340941", "河南省商丘市",
"861875859", "浙江省杭州市",
"861360726", "湖北省荆门市",
"861816240", "湖北省宜昌市",
"861590777", "广西钦州市",
"861847655", "广东省深圳市",
"861564570", "黑龙江省大兴安岭地区",
"86183771", "广西南宁市",
"861530744", "湖南省张家界市",
"861855583", "安徽省马鞍山市",
"86151067", "山东省济宁市",
"861810489", "内蒙古包头市",
"861864487", "吉林省通化市",
"861577945", "江西省萍乡市",
"861380320", "河北省邯郸市",
"86134566", "浙江省台州市",
"861357541", "浙江省温州市",
"86159773", "广西桂林市",
"861845018", "福建省莆田市",
"861881557", "安徽省宿州市",
"86138457", "黑龙江省大兴安岭地区",
"861321772", "广西柳州市",
"861479477", "内蒙古鄂尔多斯市",
"86151106", "山西省晋中市",
"861887270", "湖北省黄冈市",
"861365916", "陕西省汉中市",
"861768518", "贵州省六盘水市",
"861853029", "河南省商丘市",
"861301043", "江苏省扬州市",
"861501508", "广东省韶关市",
"861815831", "浙江省温州市",
"861339048", "辽宁省阜新市",
"861886614", "山东省潍坊市",
"861318940", "广东省江门市",
"861366548", "山东省泰安市",
"861476255", "江苏省苏州市",
"861329689", "浙江省温州市",
"861348806", "陕西省咸阳市",
"861786507", "山东省临沂市",
"861586289", "江苏省扬州市",
"861882961", "陕西省延安市",
"861350773", "广西桂林市",
"861390671", "浙江省杭州市",
"861800902", "四川省凉山彝族自治州",
"861816877", "江苏省徐州市",
"861377759", "浙江省杭州市",
"861860448", "吉林省吉林市",
"861309541", "安徽省阜阳市",
"861847145", "湖北省荆州市",
"861308323", "安徽省黄山市",
"861832069", "广东省广州市",
"861804938", "陕西省宝鸡市",
"861338401", "河南省郑州市",
"861529439", "甘肃省天水市",
"861876098", "云南省丽江市",
"861555328", "山东省聊城市",
"861313571", "湖北省十堰市",
"861572596", "山东省临沂市",
"861576665", "广东省惠州市",
"861850916", "陕西省汉中市",
"861557035", "江西省南昌市",
"861881363", "广东省湛江市",
"861853064", "河南省安阳市",
"861370762", "河南省周口市",
"861555340", "山东省德州市",
"861390645", "山东省烟台市",
"86130167", "江苏省泰州市",
"861336555", "安徽省马鞍山市",
"86519", "江苏省常州市",
"86130421", "上海市",
"861773929", "河南省南阳市",
"861478846", "河南省新乡市",
"861338394", "河南省周口市",
"861380482", "黑龙江省牡丹江市",
"861317600", "山东省济南市",
"861860420", "辽宁省鞍山市",
"861325896", "山东省枣庄市",
"861550727", "湖北省襄樊市",
"86176402", "辽宁省沈阳市",
"861575756", "浙江省台州市",
"861472650", "四川省乐山市",
"861760438", "吉林省松原市",
"861322173", "浙江省舟山市",
"86134236", "广东省广州市",
"861824946", "黑龙江省哈尔滨市",
"861811569", "江苏省苏州市",
"861580632", "山东省枣庄市",
"861800068", "河北省邢台市",
"861580208", "广东省汕头市",
"861760622", "山东省聊城市",
"861454386", "贵州省铜仁地区",
"86181050", "福建省福州市",
"861309575", "浙江省绍兴市",
"861847171", "湖北省宜昌市",
"861580428", "辽宁省朝阳市",
"861310984", "辽宁省大连市",
"861812155", "江苏省苏州市",
"861478521", "贵州省黔南布依族苗族自治州",
"861452533", "山东省淄博市",
"86155352", "山西省晋中市",
"861313545", "安徽省滁州市",
"861356305", "山东省滨州市",
"86137535", "山西省临汾市",
"86130061", "湖北省武汉市",
"861384950", "河南省焦作市",
"861515965", "福建省漳州市",
"861595339", "山东省日照市",
"861846492", "山东省临沂市",
"861814333", "湖南省娄底市",
"861339020", "辽宁省锦州市",
"861830455", "黑龙江省哈尔滨市",
"861530392", "河南省鹤壁市",
"861516088", "新疆乌鲁木齐市",
"861316022", "江苏省镇江市",
"861380348", "山西省吕梁市",
"861811524", "江苏省镇江市",
"861518982", "江苏省南京市",
"861859510", "宁夏石嘴山市",
"86131640", "天津市",
"861576704", "广东省云浮市",
"86153256", "浙江省台州市",
"861388634", "湖北省鄂州市",
"861830561", "安徽省淮北市",
"861350885", "云南省楚雄彝族自治州",
"861367333", "河南省安阳市",
"861304474", "河南省洛阳市",
"861361463", "黑龙江省牡丹江市",
"86139250", "广东省广州市",
"861389935", "新疆哈密地区",
"861341915", "四川省泸州市",
"861816228", "江西省九江市",
"861390155", "江苏省苏州市",
"861329370", "山西省长治市",
"861568183", "四川省广安市",
"86176653", "广东省深圳市",
"861334365", "河南省开封市",
"861595378", "山东省德州市",
"861508264", "四川省宜宾市",
"861354221", "广东省揭阳市",
"861878826", "云南省红河哈尼族彝族自治州",
"861369566", "安徽省池州市",
"861599942", "新疆阿克苏地区",
"86181892", "陕西省西安市",
"861770666", "浙江省温州市",
"861470901", "新疆塔城地区",
"861536493", "山西省太原市",
"861390723", "湖北省黄石市",
"861367785", "广西玉林市",
"861474710", "内蒙古呼和浩特市",
"861840393", "河南省濮阳市",
"861804147", "辽宁省沈阳市",
"861891926", "甘肃省庆阳市",
"861310508", "福建省泉州市",
"861562199", "内蒙古锡林郭勒盟",
"861566049", "山东省威海市",
"861596401", "山东省济南市",
"861761419", "辽宁省辽阳市",
"861368857", "贵州省毕节地区",
"861364030", "广东省广州市",
"861300262", "浙江省舟山市",
"861567827", "广西柳州市",
"861815371", "湖南省益阳市",
"861301009", "北京市",
"861800618", "江苏省无锡市",
"861583245", "河北省保定市",
"861867532", "广东省汕头市",
"861520750", "广东省江门市",
"861508229", "四川省凉山彝族自治州",
"861534856", "贵州省铜仁地区",
"861313686", "黑龙江省牡丹江市",
"861370890", "山东省烟台市",
"86130006", "广东省广州市",
"861477397", "湖南省常德市",
"861322907", "河北省邢台市",
"861323923", "陕西省延安市",
"86139303", "河北省秦皇岛市",
"861593387", "河北省邯郸市",
"86187119", "湖南省邵阳市",
"861390586", "浙江省台州市",
"861342417", "广东省深圳市",
"861865621", "安徽省铜陵市",
"861538780", "江西省新余市",
"861772179", "江苏省徐州市",
"861801678", "福建省宁德市",
"861804218", "浙江省台州市",
"861873970", "河南省安阳市",
"861561491", "河北省邯郸市",
"861823244", "河北省承德市",
"861314532", "山东省青岛市",
"861760479", "内蒙古锡林郭勒盟",
"861808169", "四川省成都市",
"861770411", "辽宁省大连市",
"86170774", "湖南省长沙市",
"861351514", "江苏省盐城市",
"861880398", "河南省三门峡市",
"861319520", "贵州省贵阳市",
"861569088", "河南省郑州市",
"861760655", "浙江省宁波市",
"861770370", "河南省商丘市",
"861554929", "湖北省宜昌市",
"861379461", "广东省佛山市",
"861533531", "山东省济南市",
"86136922", "广东省深圳市",
"861810061", "江苏省南京市",
"861302043", "内蒙古包头市",
"861478462", "黑龙江省齐齐哈尔市",
"861346442", "辽宁省鞍山市",
"861854792", "内蒙古锡林郭勒盟",
"86130537", "山东省济宁市",
"861350574", "浙江省宁波市",
"861394813", "内蒙古通辽市",
"861336522", "江苏省泰州市",
"861889080", "新疆伊犁哈萨克自治州",
"86136940", "吉林省辽源市",
"861858918", "西藏林芝地区",
"8613940", "辽宁省沈阳市",
"861526872", "浙江省湖州市",
"861379555", "四川省自贡市",
"861815410", "安徽省蚌埠市",
"861560390", "河南省郑州市",
"861871217", "安徽省安庆市",
"86170901", "北京市",
"86151206", "海南省海口市",
"861881961", "广东省茂名市",
"861834238", "辽宁省葫芦岛市",
"861894295", "湖北省鄂州市",
"861590257", "贵州省毕节地区",
"861314356", "广东省佛山市",
"861317985", "新疆伊犁哈萨克自治州",
"861354143", "四川省资阳市",
"861479975", "新疆昌吉回族自治州",
"861316055", "广东省清远市",
"861308921", "吉林省辽源市",
"861458230", "安徽省淮南市",
"86186872", "云南省大理白族自治州",
"861806742", "浙江省宁波市",
"861450954", "江苏省连云港市",
"86150360", "河南省郑州市",
"861379186", "山东省潍坊市",
"86178394", "河南省周口市",
"861890695", "福建省漳州市",
"861470349", "山西省运城市",
"861827208", "湖北省鄂州市",
"861830422", "辽宁省葫芦岛市",
"861454291", "辽宁省铁岭市",
"861333045", "云南省德宏傣族景颇族自治州",
"861591639", "广东省惠州市",
"861556813", "吉林省白山市",
"861454868", "河南省驻马店市",
"861840542", "山东省青岛市",
"861337677", "广东省河源市",
"861707426", "浙江省宁波市",
"861550858", "贵州省六盘水市",
"861760516", "江苏省徐州市",
"861830638", "山东省烟台市",
"861571596", "福建省泉州市",
"86132105", "山东省济南市",
"861554817", "内蒙古乌兰察布市",
"861806221", "湖北省黄冈市",
"861501760", "广东省深圳市",
"861530543", "山东省滨州市",
"861519049", "江苏省南京市",
"861568782", "云南省楚雄彝族自治州",
"861831619", "广东省肇庆市",
"861810466", "黑龙江省大庆市",
"861590618", "江苏省无锡市",
"861857942", "广西柳州市",
"861868041", "广东省东莞市",
"86132720", "湖南省长沙市",
"861323294", "广东省江门市",
"861579493", "福建省福州市",
"861776608", "江苏省南京市",
"861705303", "北京市",
"861776232", "湖北省武汉市",
"861598169", "吉林省四平市",
"861356147", "山东省聊城市",
"861368728", "湖北省襄樊市",
"861399764", "湖北省荆州市",
"861453656", "江苏省盐城市",
"861837530", "安徽省芜湖市",
"861824077", "河南省商丘市",
"86188321", "河北省石家庄市",
"861362244", "广东省云浮市",
"861521930", "广东省汕尾市",
"861360784", "广西梧州市",
"861810611", "江苏省常州市",
"861869408", "湖北省宜昌市",
"861532406", "河北省承德市",
"861861321", "四川省成都市",
"861329016", "山东省日照市",
"861316566", "湖北省孝感市",
"861581375", "广东省江门市",
"861341100", "广东省佛山市",
"861378591", "河北省秦皇岛市",
"861820314", "河北省承德市",
"86152734", "湖南省衡阳市",
"861580796", "江西省吉安市",
"86151261", "云南省红河哈尼族彝族自治州",
"861377279", "陕西省铜川市",
"86156585", "浙江省温州市",
"861340343", "山西省太原市",
"861502984", "陕西省榆林市",
"861523475", "山西省运城市",
"861389809", "辽宁省朝阳市",
"861862923", "陕西省渭南市",
"861863907", "河南省安阳市",
"861589220", "四川省自贡市",
"861350253", "广东省梅州市",
"861809942", "新疆伊犁哈萨克自治州",
"861811671", "四川省巴中市",
"86187723", "湖北省黄石市",
"861803950", "河南省郑州市",
"861569168", "陕西省铜川市",
"861580315", "河北省唐山市",
"861813972", "甘肃省武威市",
"86184080", "上海市",
"861769230", "河北省张家口市",
"861870329", "河北省邢台市",
"861898837", "云南省怒江傈僳族自治州",
"861840991", "新疆乌鲁木齐市",
"861589248", "四川省德阳市",
"861808616", "湖北省黄石市",
"861390569", "安徽省合肥市",
"861534572", "浙江省湖州市",
"861326648", "广东省江门市",
"86139150", "江苏省常州市",
"86180357", "山西省临汾市",
"861879921", "新疆克拉玛依市",
"861370083", "河南省商丘市",
"861470303", "河北省唐山市",
"86181954", "宁夏固原市",
"861377918", "新疆哈密地区",
"861537745", "湖南省怀化市",
"861871937", "广东省广州市",
"861343871", "四川省乐山市",
"861566515", "江苏省盐城市",
"861348761", "湖南省邵阳市",
"861539015", "四川省德阳市",
"861398588", "贵州省毕节地区",
"861885013", "福建省福州市",
"86186305", "河北省唐山市",
"86133909", "江苏省南通市",
"86136659", "福建省泉州市",
"86135549", "广东省深圳市",
"861819483", "新疆乌鲁木齐市",
"861709932", "浙江省温州市",
"861582943", "陕西省渭南市",
"861538964", "陕西省宝鸡市",
"861874959", "河南省许昌市",
"861339292", "广东省中山市",
"861473805", "河南省平顶山市",
"861869240", "湖南省长沙市",
"861800777", "广西钦州市",
"861368740", "广东省佛山市",
"861770689", "浙江省金华市",
"861589117", "陕西省榆林市",
"86130583", "广东省湛江市",
"861344372", "湖北省孝感市",
"861872435", "黑龙江省绥化市",
"861390524", "江苏省宿迁市",
"861459436", "西藏那曲地区",
"861363374", "河南省许昌市",
"861566656", "山东省潍坊市",
"861847622", "广东省河源市",
"86933", "甘肃省平凉市",
"861359738", "广西玉林市",
"861476883", "山东省德州市",
"861768031", "湖南省长沙市",
"861330962", "安徽省蚌埠市",
"861778668", "湖北省十堰市",
"861771179", "湖南省邵阳市",
"861802678", "广东省江门市",
"861876242", "江苏省苏州市",
"861325955", "宁夏中卫市",
"861594979", "山东省泰安市",
"86151531", "山东省济南市",
"86182615", "江苏省无锡市",
"861313624", "浙江省嘉兴市",
"86147453", "广东省广州市",
"861337959", "陕西省安康市",
"861780265", "江苏省徐州市",
"861341417", "广东省江门市",
"861773780", "河南省安阳市",
"861360498", "辽宁省阜新市",
"861778018", "四川省达州市",
"861320113", "新疆巴音郭楞蒙古自治州",
"861359779", "湖北省恩施土家族苗族自治州",
"861809591", "新疆阿克苏地区",
"861347195", "广西梧州市",
"86178281", "四川省成都市",
"861479941", "新疆阿克苏地区",
"861336169", "江西省上饶市",
"86182796", "江西省吉安市",
"86158874", "云南省曲靖市",
"861576503", "黑龙江省牡丹江市",
"861372198", "山东省潍坊市",
"861573156", "四川省泸州市",
"861869877", "辽宁省铁岭市",
"861815107", "江苏省苏州市",
"861590902", "新疆哈密地区",
"861819802", "甘肃省定西市",
"861888281", "四川省雅安市",
"861865172", "江苏省连云港市",
"861305587", "福建省厦门市",
"861821834", "广东省广州市",
"861454324", "内蒙古乌海市",
"861847479", "湖南省永州市",
"861458347", "江西省景德镇市",
"86130267", "广东省佛山市",
"861705820", "江苏省苏州市",
"861558174", "山西省晋中市",
"861310926", "陕西省安康市",
"861836800", "浙江省杭州市",
"86188393", "河南省濮阳市",
"86185973", "重庆市",
"861534995", "新疆和田地区",
"861830957", "宁夏银川市",
"861594938", "广西桂林市",
"86134136", "广东省湛江市",
"861338653", "浙江省杭州市",
"861537623", "山东省日照市",
"861520433", "吉林省延边朝鲜族自治州",
"861378942", "内蒙古包头市",
"861333071", "四川省攀枝花市",
"861571260", "浙江省嘉兴市",
"861700485", "广东省深圳市",
"86180773", "广西桂林市",
"861551432", "河南省信阳市",
"861367931", "甘肃省定西市",
"861811586", "江苏省连云港市",
"861801093", "安徽省阜阳市",
"86135823", "河北省石家庄市",
"861897567", "湖南省娄底市",
"861454369", "山东省聊城市",
"861818990", "西藏昌都地区",
"861313019", "辽宁省鞍山市",
"861550359", "山西省运城市",
"861398904", "西藏林芝地区",
"861452734", "湖南省衡阳市",
"861898443", "贵州省六盘水市",
"861769910", "新疆乌鲁木齐市",
"86187791", "江西省南昌市",
"861830380", "河南省安阳市",
"861319548", "安徽省阜阳市",
"861843956", "河南省驻马店市",
"861351682", "浙江省杭州市",
"861570944", "甘肃省兰州市",
"861530509", "福建省泉州市",
"861362463", "黑龙江省牡丹江市",
"861389781", "辽宁省营口市",
"861346889", "陕西省榆林市",
"861351112", "湖南省益阳市",
"861812524", "广东省中山市",
"861858279", "四川省阿坝藏族羌族自治州",
"861588426", "四川省德阳市",
"861364816", "四川省攀枝花市",
"86153156", "山东省菏泽市",
"861560777", "广西钦州市",
"861594570", "黑龙江省大兴安岭地区",
"861770663", "浙江省温州市",
"861536496", "山西省太原市",
"861827667", "广西南宁市",
"861390726", "湖北省恩施土家族苗族自治州",
"861452325", "河南省平顶山市",
"861321079", "山东省济宁市",
"86182868", "贵州省六盘水市",
"861528479", "四川省雅安市",
"861834052", "辽宁省葫芦岛市",
"86150305", "河北省唐山市",
"861337550", "山东省德州市",
"861328870", "广东省云浮市",
"861889922", "新疆阿克苏地区",
"861891923", "甘肃省天水市",
"86182811", "四川省泸州市",
"861777504", "安徽省合肥市",
"861323760", "江西省景德镇市",
"861302977", "黑龙江省双鸭山市",
"861850470", "内蒙古呼伦贝尔市",
"86177359", "山西省运城市",
"861840396", "河南省驻马店市",
"861348849", "陕西省咸阳市",
"86183425", "辽宁省丹东市",
"861510702", "江西省九江市",
"861457080", "江苏省泰州市",
"861768750", "广西南宁市",
"861589799", "湖北省襄樊市",
"861597239", "湖北省咸宁市",
"861334617", "浙江省杭州市",
"861331277", "云南省普洱市",
"861458519", "河南省洛阳市",
"86183065", "山东省临沂市",
"861568186", "四川省自贡市",
"86156357", "山西省临汾市",
"861770797", "江西省赣州市",
"861532651", "黑龙江省七台河市",
"861782014", "广东省湛江市",
"861525861", "浙江省台州市",
"861840715", "湖北省咸宁市",
"861532994", "贵州省六盘水市",
"861312448", "福建省宁德市",
"861391244", "江苏省南通市",
"861878823", "云南省德宏傣族景颇族自治州",
"861369563", "安徽省宣城市",
"861356570", "新疆哈密地区",
"861365470", "内蒙古呼伦贝尔市",
"861898790", "云南省普洱市",
"861478437", "河南省开封市",
"86150049", "内蒙古通辽市",
"861390583", "浙江省嘉兴市",
"861453221", "浙江省宁波市",
"861802491", "广东省佛山市",
"861303930", "吉林省长春市",
"861562678", "广东省汕头市",
"861330148", "江苏省南通市",
"861819469", "青海省果洛藏族自治州",
"861557240", "湖北省恩施土家族苗族自治州",
"861390960", "安徽省滁州市",
"861705517", "浙江省杭州市",
"861361061", "山西省临汾市",
"861882670", "广东省阳江市",
"861568461", "山东省临沂市",
"861893225", "江苏省盐城市",
"861508075", "湖南省湘潭市",
"861576928", "陕西省渭南市",
"861534853", "贵州省安顺市",
"861893405", "广东省茂名市",
"861571488", "内蒙古巴彦淖尔市",
"86138288", "广东省深圳市",
"86158678", "浙江省宁波市",
"861894731", "内蒙古乌海市",
"86187816", "四川省绵阳市",
"861310321", "河北省石家庄市",
"861338049", "广东省汕头市",
"861824943", "黑龙江省双鸭山市",
"861530900", "四川省自贡市",
"861531449", "山东省烟台市",
"861322176", "浙江省丽水市",
"861363912", "贵州省贵阳市",
"861453742", "湖南省常德市",
"861882888", "四川省自贡市",
"861890448", "吉林省松原市",
"86187808", "四川省达州市",
"86158547", "山东省济宁市",
"861361611", "江苏省常州市",
"861536857", "云南省普洱市",
"861332757", "山西省临汾市",
"861586999", "湖南省永州市",
"861477095", "江西省宜春市",
"861454383", "贵州省安顺市",
"861869362", "甘肃省张掖市",
"861331840", "广东省中山市",
"861879535", "宁夏中卫市",
"861452536", "山东省潍坊市",
"861534711", "湖北省武汉市",
"861785828", "浙江省台州市",
"861362489", "内蒙古兴安盟",
"861324224", "广东省中山市",
"861877258", "湖北省荆州市",
"861346863", "陕西省宝鸡市",
"861478843", "河南省洛阳市",
"861366780", "广西柳州市",
"861325893", "山东省菏泽市",
"861593085", "河北省唐山市",
"861537684", "山东省聊城市",
"861569591", "福建省福州市",
"861513847", "河南省郑州市",
"861575753", "浙江省杭州市",
"861360671", "浙江省杭州市",
"861786911", "云南省保山市",
"861370619", "江苏省无锡市",
"861324404", "吉林省吉林市",
"861334067", "四川省达州市",
"86132160", "浙江省温州市",
"861782664", "江苏省常州市",
"861528438", "河北省邯郸市",
"861331329", "河北省唐山市",
"861829747", "安徽省六安市",
"861396548", "安徽省六安市",
"861778952", "甘肃省定西市",
"861579728", "湖北省荆州市",
"861367336", "河南省郑州市",
"861557877", "广西河池市",
"86155378", "河南省开封市",
"861361466", "黑龙江省大庆市",
"861303127", "新疆阿克苏地区",
"86134612", "河南省平顶山市",
"861894487", "江苏省宿迁市",
"861324269", "广东省珠海市",
"861334258", "湖南省娄底市",
"861550587", "浙江省丽水市",
"861814336", "湖南省衡阳市",
"861329505", "福建省泉州市",
"861816035", "新疆伊犁哈萨克自治州",
"86156773", "广西桂林市",
"861597278", "湖北省随州市",
"861800390", "河南省平顶山市",
"86138395", "河南省漯河市",
"861510475", "内蒙古通辽市",
"861582077", "广东省深圳市",
"861776834", "江苏省无锡市",
"86135975", "湖北省黄冈市",
"861365913", "陕西省渭南市",
"861330937", "甘肃省酒泉市",
"86184745", "湖南省怀化市",
"861347312", "河北省保定市",
"861302659", "山东省济南市",
"861301046", "浙江省绍兴市",
"861820972", "青海省海东地区",
"861582500", "云南省临沧市",
"861570568", "安徽省阜阳市",
"861821912", "广东省茂名市",
"861573752", "河南省周口市",
"861318015", "河北省沧州市",
"861579740", "湖北省襄樊市",
"86151809", "湖南省邵阳市",
"861571794", "江西省抚州市",
"861396520", "安徽省铜陵市",
"861323892", "辽宁省葫芦岛市",
"86131149", "天津市",
"861504985", "内蒙古鄂尔多斯市",
"861308326", "安徽省芜湖市",
"861314951", "黑龙江省哈尔滨市",
"861815047", "福建省泉州市",
"861374978", "河南省南阳市",
"861572593", "山东省济宁市",
"861850913", "陕西省渭南市",
"861505574", "安徽省宿州市",
"861537512", "安徽省芜湖市",
"861881366", "广东省湛江市",
"861364245", "广东省汕尾市",
"861709967", "浙江省金华市",
"861512917", "陕西省宝鸡市",
"86135716", "陕西省汉中市",
"861324391", "辽宁省锦州市",
"861566742", "陕西省宝鸡市",
"86130775", "广东省云浮市",
"86186360", "山西省忻州市",
"86516", "江苏省徐州市",
"861890420", "辽宁省鞍山市",
"861348803", "陕西省榆林市",
"861351395", "河南省驻马店市",
"861866081", "山东省济南市",
"861565054", "山东省济宁市",
"861301702", "贵州省黔南布依族苗族自治州",
"861360645", "山东省烟台市",
"861319929", "黑龙江省黑河市",
"861328330", "河北省张家口市",
"861785840", "浙江省杭州市",
"86185825", "四川省成都市",
"861817245", "广西玉林市",
"861350776", "广西百色市",
"861309823", "陕西省商洛市",
"861331828", "广东省中山市",
"861554520", "黑龙江省齐齐哈尔市",
"861557228", "湖北省武汉市",
"861360586", "浙江省台州市",
"86136303", "吉林省松原市",
"861527610", "新疆喀什地区",
"861316764", "安徽省黄山市",
"861512864", "河北省承德市",
"861591491", "广东省梅州市",
"861580594", "福建省厦门市",
"861302149", "河北省石家庄市",
"861576940", "甘肃省临夏回族自治州",
"861779116", "陕西省延安市",
"861519653", "四川省广安市",
"861508041", "福建省泉州市",
"861863079", "河北省廊坊市",
"861301441", "江西省鹰潭市",
"861375905", "云南省玉溪市",
"861322511", "江苏省镇江市",
"861453394", "内蒙古乌兰察布市",
"861551467", "河南省鹤壁市",
"86135708", "广东省深圳市",
"861521539", "山东省临沂市",
"861358067", "广东省云浮市",
"861808782", "云南省昆明市",
"861566401", "河南省商丘市",
"861596049", "福建省宁德市",
"861327544", "山东省德州市",
"861348348", "河北省唐山市",
"861861760", "河北省衡水市",
"861566221", "吉林省长春市",
"861587707", "广西玉林市",
"861847513", "广东省梅州市",
"861304719", "湖北省恩施土家族苗族自治州",
"86187610", "江苏省泰州市",
"861360723", "湖北省鄂州市",
"861809168", "陕西省渭南市",
"861825935", "福建省宁德市",
"861372561", "广东省阳江市",
"861811498", "江苏省徐州市",
"861569942", "新疆阿克苏地区",
"861309282", "四川省南充市",
"861318665", "江苏省淮安市",
"861830804", "西藏林芝地区",
"861503907", "河南省郑州市",
"861348482", "陕西省榆林市",
"861855586", "安徽省六安市",
"861889457", "甘肃省兰州市",
"861777102", "湖北省襄樊市",
"861360155", "江苏省苏州市",
"861326495", "湖北省荆门市",
"86159495", "江西省九江市",
"861347458", "陕西省咸阳市",
"861556030", "内蒙古鄂尔多斯市",
"86180585", "浙江省宁波市",
"86136250", "福建省福州市",
"86152641", "山东省济南市",
"861315112", "江苏省扬州市",
"861471577", "广东省深圳市",
"861319817", "四川省南充市",
"86147371", "河南省郑州市",
"861538548", "安徽省亳州市",
"861531403", "山东省威海市",
"861315682", "山东省枣庄市",
"861370481", "黑龙江省哈尔滨市",
"861780358", "山西省吕梁市",
"861536740", "湖南省岳阳市",
"861332840", "福建省厦门市",
"861334739", "湖南省邵阳市",
"861517012", "江西省新余市",
"861332364", "河南省驻马店市",
"861860695", "福建省泉州市",
"861553444", "山西省晋中市",
"861537626", "山东省滨州市",
"861532449", "安徽省合肥市",
"861317295", "广东省韶关市",
"86151721", "湖北省孝感市",
"861362611", "江苏省扬州市",
"861315851", "四川省南充市",
"861520436", "吉林省白城市",
"861868377", "四川省德阳市",
"861331757", "湖北省宜昌市",
"861323508", "福建省莆田市",
"861818627", "湖北省襄樊市",
"86134839", "河北省邢台市",
"861320116", "新疆阿克苏地区",
"86183477", "内蒙古鄂尔多斯市",
"861300829", "辽宁省阜新市",
"861573153", "四川省成都市",
"861500200", "广东省广州市",
"861814644", "新疆昌吉回族自治州",
"861570631", "山东省威海市",
"861872008", "江西省南昌市",
"861500420", "辽宁省锦州市",
"86187263", "安徽省宿州市",
"861361489", "内蒙古锡林郭勒盟",
"861320686", "黑龙江省牡丹江市",
"861560257", "广东省湛江市",
"861335705", "浙江省金华市",
"861898446", "贵州省毕节地区",
"861332329", "河北省唐山市",
"861304958", "贵州省六盘水市",
"86139922", "陕西省榆林市",
"861843953", "河南省新乡市",
"861873538", "山西省太原市",
"86155518", "安徽省滁州市",
"861362466", "黑龙江省大庆市",
"861590390", "河南省平顶山市",
"86132260", "广东省珠海市",
"861823842", "河南省南阳市",
"861364813", "四川省眉山市",
"86177534", "山东省德州市",
"861588423", "四川省资阳市",
"861829850", "甘肃省临夏回族自治州",
"861300340", "江苏省南京市",
"861338515", "贵州省黔东南苗族侗族自治州",
"861300864", "云南省玉溪市",
"86153859", "安徽省六安市",
"861811583", "江苏省南通市",
"86137777", "浙江省温州市",
"861517474", "内蒙古乌海市",
"861366964", "广西梧州市",
"861801096", "安徽省阜阳市",
"861325080", "浙江省杭州市",
"861566143", "内蒙古赤峰市",
"861510149", "甘肃省甘南藏族自治州",
"861558285", "山西省晋城市",
"861885016", "福建省厦门市",
"861301977", "黑龙江省大庆市",
"861819486", "新疆昌吉回族自治州",
"861568124", "四川省绵阳市",
"86183910", "陕西省咸阳市",
"861325160", "黑龙江省哈尔滨市",
"861582946", "陕西省西安市",
"861370737", "湖南省益阳市",
"861780074", "青海省海东地区",
"861369729", "湖北省宜昌市",
"861824835", "内蒙古通辽市",
"861346190", "河南省鹤壁市",
"861859827", "广东省深圳市",
"861322079", "山东省济宁市",
"861817751", "广西玉林市",
"861808613", "湖北省襄樊市",
"861390784", "广西梧州市",
"861555262", "山东省德州市",
"861586444", "山东省菏泽市",
"861520031", "湖南省岳阳市",
"861311448", "湖北省襄樊市",
"861533952", "贵州省遵义市",
"861856719", "河南省南阳市",
"861370086", "河南省郑州市",
"86159585", "浙江省绍兴市",
"861470306", "河北省保定市",
"86182203", "陕西省渭南市",
"861341791", "广东省珠海市",
"86180495", "陕西省西安市",
"86155506", "山东省威海市",
"861300917", "吉林省吉林市",
"861852410", "辽宁省铁岭市",
"86137353", "浙江省绍兴市",
"861837805", "广西玉林市",
"86170068", "浙江省杭州市",
"861568169", "四川省巴中市",
"861561678", "湖南省益阳市",
"861801491", "江苏省苏州市",
"861593559", "山西省运城市",
"861880610", "江苏省镇江市",
"861505621", "安徽省铜陵市",
"861372202", "内蒙古呼伦贝尔市",
"861815976", "福建省龙岩市",
"86170011", "北京市",
"86182350", "山西省忻州市",
"861334778", "江苏省泰州市",
"861323984", "新疆阿克苏地区",
"861369764", "山东省烟台市",
"861320545", "山东省烟台市",
"86137200", "北京市",
"86187587", "浙江省温州市",
"861572488", "江苏省南京市",
"861459433", "西藏山南地区",
"861868409", "四川省宜宾市",
"861560618", "江苏省无锡市",
"86138751", "湖南省常德市",
"861566653", "山东省淄博市",
"861374805", "内蒙古通辽市",
"861476886", "山东省滨州市",
"861806049", "福建省福州市",
"861519401", "山东省聊城市",
"861802199", "江苏省泰州市",
"861777703", "广西钦州市",
"861881670", "广东省湛江市",
"861820707", "江西省赣州市",
"861333230", "辽宁省营口市",
"861362061", "山西省太原市",
"861530821", "四川省成都市",
"861705306", "上海市",
"861564979", "河南省三门峡市",
"86151793", "江西省上饶市",
"861529691", "宁夏银川市",
"861301149", "河北省邯郸市",
"861529954", "新疆哈密地区",
"861320571", "浙江省杭州市",
"861316357", "黑龙江省绥化市",
"861803165", "河北省秦皇岛市",
"861453653", "江苏省扬州市",
"861511340", "广东省江门市",
"86183282", "四川省资阳市",
"861570700", "江西省抚州市",
"861859239", "陕西省宝鸡市",
"861399589", "湖北省孝感市",
"861360524", "江苏省宿迁市",
"861327881", "湖南省永州市",
"861801304", "江苏省南京市",
"861393374", "河北省邢台市",
"861862760", "湖南省娄底市",
"861889955", "新疆伊犁哈萨克自治州",
"861335472", "内蒙古包头市",
"861855569", "安徽省合肥市",
"861452352", "河南省周口市",
"86135927", "广东省东莞市",
"861530546", "山东省东营市",
"861302441", "江苏省常州市",
"861810463", "黑龙江省大庆市",
"861333347", "山西省临汾市",
"861579496", "福建省厦门市",
"861335014", "四川省泸州市",
"861539928", "陕西省榆林市",
"861862926", "陕西省西安市",
"861317050", "云南省楚雄彝族自治州",
"861369605", "四川省内江市",
"861316980", "广东省江门市",
"86185386", "河南省周口市",
"861595604", "安徽省六安市",
"86185877", "广西南宁市",
"861350256", "广东省揭阳市",
"861893252", "河北省唐山市",
"861804570", "黑龙江省大庆市",
"861372380", "湖南省娄底市",
"861327743", "湖北省黄冈市",
"861888144", "四川省内江市",
"861812498", "广东省中山市",
"86130727", "湖北省武汉市",
"861375407", "内蒙古鄂尔多斯市",
"861814552", "黑龙江省黑河市",
"861524961", "河南省安阳市",
"86147511", "江苏省苏州市",
"861316563", "湖北省十堰市",
"861533427", "湖北省黄石市",
"861532403", "河北省张家口市",
"861868837", "广东省湛江市",
"861329013", "山东省泰安市",
"861360569", "安徽省合肥市",
"861770505", "福建省泉州市",
"861580793", "江西省上饶市",
"861367552", "安徽省蚌埠市",
"861528145", "四川省德阳市",
"86136150", "福建省福州市",
"86177215", "江苏省南京市",
"861340346", "山西省太原市",
"861855524", "安徽省宣城市",
"861301659", "江苏省淮安市",
"861302046", "内蒙古巴彦淖尔市",
"861709551", "江苏省盐城市",
"861886755", "浙江省金华市",
"861861508", "山东省潍坊市",
"861314567", "安徽省亳州市",
"861304637", "广东省珠海市",
"861394816", "内蒙古赤峰市",
"861818280", "黑龙江省哈尔滨市",
"861388477", "山东省枣庄市",
"86187533", "山东省淄博市",
"86152367", "河南省信阳市",
"861335664", "山东省东营市",
"86131249", "广东省湛江市",
"861376894", "广西柳州市",
"861780859", "贵州省黔西南布依族苗族自治州",
"861881389", "广东省肇庆市",
"861365311", "河北省石家庄市",
"861471492", "广东省东莞市",
"861896598", "福建省三明市",
"86186858", "贵州省六盘水市",
"861867567", "广东省清远市",
"86177478", "内蒙古巴彦淖尔市",
"861452418", "辽宁省阜新市",
"86133019", "上海市",
"861882366", "广东省深圳市",
"861511917", "广东省韶关市",
"861318549", "浙江省湖州市",
"861556816", "吉林省辽源市",
"861525706", "浙江省舟山市",
"861336782", "广西柳州市",
"861707423", "浙江省杭州市",
"861532882", "四川省宜宾市",
"861530685", "浙江省绍兴市",
"861760513", "江苏省南通市",
"861564938", "河南省南阳市",
"861781705", "广东省广州市",
"861345814", "四川省广元市",
"861571593", "福建省福州市",
"861333910", "安徽省合肥市",
"861308384", "河南省焦作市",
"861884930", "河北省张家口市",
"861778925", "陕西省商洛市",
"861560902", "四川省德阳市",
"861319780", "江西省鹰潭市",
"861899877", "广东省梅州市",
"861332828", "福建省宁德市",
"861335629", "山东省滨州市",
"861536728", "湖南省娄底市",
"861390498", "辽宁省阜新市",
"861850311", "河北省石家庄市",
"86188686", "浙江省宁波市",
"861361842", "湖南省邵阳市",
"86132530", "河南省安阳市",
"86177264", "四川省成都市",
"861330435", "吉林省四平市",
"861314353", "广东省广州市",
"861831890", "广东省惠州市",
"861354146", "四川省甘孜藏族自治州",
"861839844", "四川省遂宁市",
"861510977", "青海省海西蒙古族藏族自治州",
"861352395", "河南省漯河市",
"861379183", "山东省青岛市",
"861309640", "四川省乐山市",
"861303652", "四川省宜宾市",
"861867702", "广西防城港市",
"861301951", "内蒙古呼伦贝尔市",
"861313670", "黑龙江省大兴安岭地区",
"86184479", "内蒙古呼和浩特市",
"861597489", "云南省昭通市",
"861524019", "安徽省合肥市",
"861530617", "江苏省无锡市",
"861310738", "湖南省娄底市",
"861328741", "山东省日照市",
"861390007", "广东省广州市",
"861817777", "广西钦州市",
"861821482", "安徽省阜阳市",
"86181388", "广东省深圳市",
"861356960", "河南省三门峡市",
"86139432", "吉林省吉林市",
"861376859", "广西南宁市",
"861584806", "内蒙古乌兰察布市",
"861470334", "河北省唐山市",
"861572759", "江西省抚州市",
"861528157", "四川省甘孜藏族自治州",
"861780894", "西藏林芝地区",
"86184601", "江西省宜春市",
"861538776", "江西省吉安市",
"861322899", "西藏拉萨市",
"861533866", "贵州省黔南布依族苗族自治州",
"861390570", "浙江省衢州市",
"861332251", "西藏拉萨市",
"861478648", "湖南省永州市",
"861576450", "黑龙江省哈尔滨市",
"861364777", "广西钦州市",
"861363320", "河北省邯郸市",
"861594726", "内蒙古鄂尔多斯市",
"861846212", "山东省济宁市",
"861591644", "广东省阳江市",
"861365483", "内蒙古阿拉善盟",
"861522490", "河南省驻马店市",
"861330853", "贵州省安顺市",
"861302567", "广东省茂名市",
"861347948", "江西省赣州市",
"86159444", "吉林省四平市",
"861820084", "广东省河源市",
"861875292", "江苏省盐城市",
"861771160", "湖南省岳阳市",
"86139273", "广东省惠州市",
"86137862", "湖南省湘潭市",
"861329386", "山西省运城市",
"86145890", "广东省东莞市",
"86159683", "浙江省嘉兴市",
"861362278", "广东省惠州市",
"861571238", "辽宁省大连市",
"861314046", "河南省开封市",
"86157765", "黑龙江省大庆市",
"861884881", "河南省安阳市",
"86155632", "山东省临沂市",
"861316345", "黑龙江省双鸭山市",
"861805860", "浙江省嘉兴市",
"861883448", "山西省运城市",
"861571602", "福建省三明市",
"861850483", "内蒙古阿拉善盟",
"861569452", "黑龙江省齐齐哈尔市",
"861369973", "广东省广州市",
"861563440", "山东省威海市",
"861328883", "广东省广州市",
"861357640", "江西省景德镇市",
"861869395", "甘肃省陇南市",
"861333355", "山西省长治市",
"86156396", "河南省驻马店市",
"861363849", "湖南省邵阳市",
"861889947", "新疆塔城地区",
"86152978", "江西省赣州市",
"861776761", "新疆阿勒泰地区",
"861853747", "河南省平顶山市",
"861594583", "黑龙江省鹤岗市",
"861867046", "湖南省永州市",
"861571327", "河北省沧州市",
"861319172", "河北省邯郸市",
"861477182", "湖北省咸宁市",
"861529999", "新疆克拉玛依市",
"861303142", "河北省承德市",
"861564671", "山东省济宁市",
"861778630", "湖北省鄂州市",
"861884625", "黑龙江省黑河市",
"861309150", "黑龙江省鹤岗市",
"861708421", "云南省临沧市",
"861331771", "广西南宁市",
"861315877", "四川省眉山市",
"86170938", "重庆市",
"861821803", "广东省东莞市",
"861521746", "广东省广州市",
"861350548", "山东省泰安市",
"861528647", "贵州省六盘水市",
"861813023", "安徽省淮北市",
"861336170", "江西省新余市",
"861359760", "湖北省黄冈市",
"861334900", "安徽省六安市",
"861878432", "四川省内江市",
"861337284", "辽宁省抚顺市",
"86183681", "浙江省杭州市",
"861774691", "河南省南阳市",
"861508956", "广东省阳江市",
"861761299", "陕西省榆林市",
"86184794", "江西省抚州市",
"861829722", "青海省海东地区",
"861593192", "河北省唐山市",
"861598319", "四川省自贡市",
"861894237", "江西省赣州市",
"861354587", "湖北省武汉市",
"86152120", "安徽省滁州市",
"861813537", "山西省太原市",
"861310779", "浙江省温州市",
"861775176", "江苏省南京市",
"861858260", "四川省广安市",
"861366773", "广西桂林市",
"86152142", "辽宁省铁岭市",
"861862414", "辽宁省抚顺市",
"861479606", "广西玉林市",
"86132802", "山东省枣庄市",
"861328402", "黑龙江省齐齐哈尔市",
"86182569", "安徽省合肥市",
"86152698", "山东省泰安市",
"861886747", "湖南省衡阳市",
"861520269", "宁夏银川市",
"861357150", "陕西省渭南市",
"861866916", "云南省昆明市",
"861313888", "广东省深圳市",
"861534658", "河南省郑州市",
"861454370", "山东省济南市",
"861890637", "山东省枣庄市",
"861800816", "四川省绵阳市",
"861874284", "新疆伊犁哈萨克自治州",
"861311719", "湖北省荆州市",
"861772893", "广东省梅州市",
"861877900", "江西省新余市",
"861762580", "江苏省苏州市",
"861894340", "吉林省四平市",
"861363803", "贵州省黔南布依族苗族自治州",
"861894864", "广东省东莞市",
"86184860", "贵州省遵义市",
"861769268", "河北省邢台市",
"86151516", "江苏省苏州市",
"86159637", "山东省济宁市",
"861801525", "江苏省镇江市",
"861368936", "甘肃省张掖市",
"861870512", "江苏省连云港市",
"861846932", "云南省玉溪市",
"861521968", "广东省江门市",
"861318692", "浙江省台州市",
"861531959", "陕西省榆林市",
"861824453", "河北省张家口市",
"861581897", "广东省珠海市",
"86177130", "河北省邯郸市",
"861818811", "贵州省贵阳市",
"861770369", "黑龙江省双鸭山市",
"861579871", "云南省丽江市",
"861569819", "山东省菏泽市",
"861534937", "甘肃省酒泉市",
"86159750", "广东省江门市",
"861505929", "福建省宁德市",
"861313389", "江西省景德镇市",
"861820562", "安徽省铜陵市",
"861571918", "陕西省西安市",
"861878640", "贵州省黔东南苗族侗族自治州",
"861331745", "湖南省怀化市",
"861350520", "江苏省徐州市",
"861760998", "新疆喀什地区",
"861470874", "云南省曲靖市",
"861826896", "浙江省衢州市",
"861501738", "广东省湛江市",
"861899851", "广东省汕尾市",
"86135437", "广东省东莞市",
"86181295", "广东省惠州市",
"861520391", "河南省焦作市",
"86145715", "上海市",
"861300985", "黑龙江省哈尔滨市",
"861802154", "江苏省南京市",
"861887286", "湖北省荆门市",
"86185762", "广东省中山市",
"861303544", "安徽省马鞍山市",
"861830010", "广东省中山市",
"861324518", "内蒙古乌兰察布市",
"861770324", "河北省承德市",
"86187635", "山东省聊城市",
"861510951", "宁夏银川市",
"861319574", "青海省海东地区",
"861570978", "青海省西宁市",
"861322398", "河南省濮阳市",
"861357628", "江西省南昌市",
"86182451", "黑龙江省哈尔滨市",
"861320557", "安徽省宿州市",
"861355197", "四川省广安市",
"861327210", "湖南省株洲市",
"861305653", "四川省广安市",
"861370313", "河北省张家口市",
"861589274", "四川省眉山市",
"861830660", "广东省汕尾市",
"861351362", "山西省太原市",
"861359892", "河南省驻马店市",
"861362919", "陕西省铜川市",
"861705334", "广东省深圳市",
"861452749", "湖南省长沙市",
"861563632", "黑龙江省哈尔滨市",
"861454830", "广东省广州市",
"86176876", "广西南宁市",
"861859181", "陕西省榆林市",
"861552575", "山西省吕梁市",
"861598170", "新疆石河子市",
"861570939", "甘肃省陇南市",
"861319253", "广东省汕尾市",
"861454689", "广东省江门市",
"861569927", "新疆巴音郭楞蒙古自治州",
"861399976", "新疆博尔塔拉蒙古自治州",
"861338587", "浙江省温州市",
"86157389", "河南省驻马店市",
"861564586", "黑龙江省鸡西市",
"861454119", "安徽省黄山市",
"861471967", "甘肃省庆阳市",
"861363482", "黑龙江省齐齐哈尔市",
"861458268", "安徽省芜湖市",
"861871995", "新疆和田地区",
"861557682", "湖南省益阳市",
"861539385", "云南省保山市",
"861778701", "云南省昆明市",
"861700791", "江西省南昌市",
"861344484", "广西梧州市",
"861880772", "广西柳州市",
"861323865", "云南省保山市",
"861315228", "陕西省铜川市",
"861536933", "河北省张家口市",
"861509112", "陕西省榆林市",
"861597842", "河南省郑州市",
"86134168", "广东省东莞市",
"861509682", "云南省昭通市",
"861518265", "四川省广安市",
"861894917", "安徽省宿州市",
"861821849", "广东省广州市",
"861363348", "山西省晋中市",
"86138913", "陕西省渭南市",
"861315408", "陕西省铜川市",
"861550049", "吉林省白山市",
"861705059", "福建省福州市",
"861872497", "云南省大理白族自治州",
"861527173", "湖北省荆州市",
"86158941", "新疆伊犁哈萨克自治州",
"86187456", "黑龙江省黑河市",
"861315337", "山东省淄博市",
"861840810", "四川省成都市",
"861336319", "河北省邢台市",
"86134017", "江苏省盐城市",
"861377260", "陕西省咸阳市",
"861320363", "湖南省常德市",
"86151508", "江苏省扬州市",
"861309628", "四川省德阳市",
"861889179", "陕西省安康市",
"861807181", "湖北省黄冈市",
"861866236", "江苏省扬州市",
"861768855", "广东省深圳市",
"861309432", "云南省楚雄彝族自治州",
"861515282", "江苏省淮安市",
"861802644", "广东省广州市",
"86186021", "上海市",
"861567244", "湖北省黄冈市",
"861831316", "云南省大理白族自治州",
"861524686", "黑龙江省双鸭山市",
"861509097", "湖北省襄樊市",
"861332771", "江苏省南京市",
"861536871", "云南省昆明市",
"86147917", "陕西省宝鸡市",
"861318167", "山东省潍坊市",
"861452504", "山东省济南市",
"861817068", "江西省赣州市",
"861364257", "广东省韶关市",
"861893180", "河北省衡水市",
"861775038", "福建省龙岩市",
"86132234", "河北省石家庄市",
"861844966", "新疆博尔塔拉蒙古自治州",
"861306054", "广东省潮州市",
"861811570", "江苏省淮安市",
"861504829", "内蒙古乌兰察布市",
"861470585", "浙江省绍兴市",
"86177560", "安徽省合肥市",
"86180750", "安徽省六安市",
"861580559", "安徽省黄山市",
"861453359", "辽宁省锦州市",
"861810510", "江苏省盐城市",
"86186418", "辽宁省阜新市",
"861707372", "河南省安阳市",
"861366574", "浙江省湖州市",
"861523532", "山西省阳泉市",
"861831795", "江西省宜春市",
"861339074", "江苏省盐城市",
"861324436", "吉林省白城市",
"861370231", "广东省珠海市",
"861399047", "四川省甘孜藏族自治州",
"861823827", "河南省信阳市",
"861830376", "河南省信阳市",
"86186461", "黑龙江省哈尔滨市",
"861772080", "福建省福州市",
"861319885", "四川省资阳市",
"861360657", "浙江省绍兴市",
"861477875", "广东省广州市",
"861530739", "湖南省邵阳市",
"861573848", "河南省开封市",
"861808818", "云南省德宏傣族景颇族自治州",
"86152242", "山东省聊城市",
"861892259", "广东省韶关市",
"861563315", "河北省唐山市",
"86159962", "江苏省南京市",
"861367304", "河南省安阳市",
"861522002", "广东省广州市",
"86183935", "甘肃省陇南市",
"861339412", "辽宁省鞍山市",
"861886850", "浙江省杭州市",
"861820421", "辽宁省朝阳市",
"861880907", "新疆阿克苏地区",
"861306339", "安徽省亳州市",
"861773776", "河南省南阳市",
"861576733", "广东省清远市",
"861805193", "江苏省无锡市",
"8615600", "北京市",
"861867149", "湖北省黄冈市",
"861560813", "四川省乐山市",
"861358546", "江苏省徐州市",
"861845442", "山东省淄博市",
"861312719", "山东省东营市",
"861844720", "内蒙古锡林郭勒盟",
"861500958", "宁夏银川市",
"861591525", "广东省茂名市",
"861359984", "福建省宁德市",
"86180637", "福建省南平市",
"861539132", "云南省红河哈尼族彝族自治州",
"861860474", "内蒙古乌兰察布市",
"86185950", "宁夏银川市",
"861881683", "广东省广州市",
"861889445", "甘肃省天水市",
"861535443", "河北省保定市",
"861512985", "陕西省宝鸡市",
"861358115", "山东省滨州市",
"86155819", "山西省运城市",
"861302951", "内蒙古呼和浩特市",
"86186275", "湖南省长沙市",
"861302694", "广西梧州市",
"861843409", "山西省晋中市",
"861597181", "湖北省恩施土家族苗族自治州",
"86147470", "内蒙古呼伦贝尔市",
"861373243", "浙江省金华市",
"861521490", "新疆和田地区",
"861571759", "湖南省邵阳市",
"861532677", "内蒙古鄂尔多斯市",
"861360147", "江苏省泰州市",
"861339358", "山西省吕梁市",
"861863398", "河北省唐山市",
"861450590", "辽宁省铁岭市",
"861329369", "山西省朔州市",
"861570805", "西藏昌都地区",
"861800030", "河北省邯郸市",
"861572238", "青海省海西蒙古族藏族自治州",
"861818152", "四川省乐山市",
"861364618", "江苏省无锡市",
"861760460", "黑龙江省哈尔滨市",
"861808170", "四川省攀枝花市",
"861843264", "河北省沧州市",
"861572602", "山东省菏泽市",
"86186406", "辽宁省锦州市",
"861311637", "贵州省六盘水市",
"861305401", "湖南省郴州市",
"861509713", "甘肃省白银市",
"861335323", "吉林省白城市",
"861318736", "湖南省郴州市",
"861551541", "河南省漯河市",
"861369371", "河南省郑州市",
"861565099", "青海省西宁市",
"861319621", "吉林省吉林市",
"861530778", "广西河池市",
"861303709", "山西省吕梁市",
"861855147", "江苏省泰州市",
"861317262", "广东省肇庆市",
"86134538", "山西省吕梁市",
"861310259", "河北省邢台市",
"861366253", "广东省广州市",
"861860662", "浙江省宁波市",
"861470646", "山东省潍坊市",
"861527772", "广西柳州市",
"861862865", "陕西省汉中市",
"861848511", "贵州省贵阳市",
"861533630", "山东省威海市",
"861533442", "云南省怒江傈僳族自治州",
"861352362", "河南省洛阳市",
"861595344", "山东省德州市",
"86180683", "江苏省无锡市",
"861539450", "福建省南平市",
"861562931", "湖北省襄樊市",
"861334546", "新疆石河子市",
"861361919", "陕西省铜川市",
"861863899", "河南省南阳市",
"861339859", "贵州省黔西南布依族苗族自治州",
"861321398", "河南省开封市",
"861329868", "湖南省长沙市",
"861568547", "贵州省毕节地区",
"861300731", "湖南省长沙市",
"861353797", "广东省阳江市",
"861367096", "广东省湛江市",
"861535377", "陕西省咸阳市",
"861454411", "福建省福州市",
"861894415", "江苏省无锡市",
"861802336", "广东省云浮市",
"861872995", "陕西省安康市",
"861347789", "湖北省恩施土家族苗族自治州",
"861804583", "黑龙江省大庆市",
"861306879", "河北省石家庄市",
"861370911", "陕西省西安市",
"861786619", "甘肃省临夏回族自治州",
"861346531", "山东省济南市",
"86155967", "陕西省咸阳市",
"861316973", "广东省清远市",
"86135059", "福建省泉州市",
"861340606", "山东省济南市",
"861550515", "江苏省徐州市",
"861524571", "黑龙江省哈尔滨市",
"861303625", "江西省上饶市",
"861383498", "山西省朔州市",
"86137504", "广东省汕头市",
"861388649", "湖北省黄石市",
"861830836", "四川省广元市",
"861569205", "广东省佛山市",
"861384793", "内蒙古兴安盟",
"861471465", "广东省珠海市",
"86134211", "广东省揭阳市",
"861454666", "广东省深圳市",
"861380267", "广东省珠海市",
"861550656", "山东省菏泽市",
"861871497", "安徽省铜陵市",
"861815290", "新疆克拉玛依市",
"861345577", "山东省滨州市",
"861320961", "宁夏银川市",
"861333322", "河北省保定市",
"86150767", "河北省沧州市",
"86134268", "广东省江门市",
"861807489", "广西河池市",
"861569425", "辽宁省丹东市",
"861707832", "云南省昭通市",
"861709492", "浙江省金华市",
"861380058", "浙江省杭州市",
"86186559", "安徽省黄山市",
"861471551", "广东省珠海市",
"861855979", "福建省厦门市",
"861840431", "吉林省长春市",
"861533388", "河南省周口市",
"8615827", "湖北省武汉市",
"8613868", "浙江省温州市",
"861332623", "山东省日照市",
"861536331", "广东省肇庆市",
"861829755", "安徽省宣城市",
"86187981", "贵州省遵义市",
"861304382", "辽宁省辽阳市",
"861880252", "广东省阳江市",
"861386663", "安徽省安庆市",
"861768996", "福建省泉州市",
"861373464", "青海省海南藏族自治州",
"86151376", "河南省信阳市",
"861708562", "安徽省合肥市",
"861453858", "甘肃省平凉市",
"861582051", "广东省中山市",
"86151887", "河北省保定市",
"861835124", "江苏省宿迁市",
"861566034", "新疆阿克苏地区",
"861504237", "辽宁省抚顺市",
"861303743", "湖南省湘西土家族苗族自治州",
"861808319", "贵州省黔东南苗族侗族自治州",
"86188005", "江苏省无锡市",
"861477783", "广西河池市",
"861887269", "湖北省黄冈市",
"861833037", "河北省秦皇岛市",
"861319773", "广西桂林市",
"861844748", "内蒙古乌兰察布市",
"861593667", "河南省安阳市",
"86147869", "湖南省常德市",
"861588372", "四川省达州市",
"861535264", "新疆和田地区",
"861510567", "安徽省阜阳市",
"861500637", "山东省聊城市",
"861845889", "浙江省杭州市",
"861369831", "四川省内江市",
"861313366", "江西省九江市",
"861823239", "河北省秦皇岛市",
"861587129", "湖北省孝感市",
"861855938", "福建省莆田市",
"861818430", "贵州省毕节地区",
"861522968", "陕西省宝鸡市",
"861582897", "四川省遂宁市",
"86177230", "重庆市",
"861532959", "贵州省黔西南布依族苗族自治州",
"861534435", "吉林省通化市",
"861584761", "内蒙古赤峰市",
"861510353", "山西省阳泉市",
"861705156", "湖南省长沙市",
"861550146", "江苏省苏州市",
"861825158", "江苏省徐州市",
"861373429", "山西省运城市",
"861850598", "福建省三明市",
"861505780", "浙江省金华市",
"861533701", "甘肃省天水市",
"86188349", "山西省朔州市",
"861314977", "辽宁省营口市",
"861871856", "广东省深圳市",
"861832070", "广东省广州市",
"861364902", "四川省自贡市",
"86184358", "山西省吕梁市",
"861573820", "河南省商丘市",
"861520993", "新疆石河子市",
"861332745", "山西省长治市",
"861592552", "云南省昭通市",
"861572918", "河南省南阳市",
"86134799", "江西省赣州市",
"86182139", "云南省昆明市",
"861818273", "黑龙江省大庆市",
"861323414", "辽宁省本溪市",
"861803192", "河北省石家庄市",
"861477841", "广东省东莞市",
"861535229", "甘肃省白银市",
"861304448", "山西省吕梁市",
"861334685", "河南省周口市",
"861513855", "河南省商丘市",
"861380374", "河南省许昌市",
"861502738", "湖北省咸宁市",
"861535409", "河北省邢台市",
"861559009", "吉林省吉林市",
"861375900", "云南省普洱市",
"861895678", "安徽省亳州市",
"861853847", "河南省洛阳市",
"861776861", "江苏省泰州市",
"861367548", "山东省泰安市",
"861356826", "四川省绵阳市",
"861567003", "河南省安阳市",
"86152988", "江苏省苏州市",
"861396336", "山东省东营市",
"861453919", "广东省江门市",
"86156897", "山东省济宁市",
"861887184", "湖北省恩施土家族苗族自治州",
"86833", "四川省乐山市",
"861316487", "福建省厦门市",
"861334098", "四川省成都市",
"861380533", "山东省淄博市",
"861452482", "内蒙古乌海市",
"861319931", "黑龙江省大兴安岭地区",
"861831956", "广东省广州市",
"861535189", "江苏省南通市",
"861514196", "辽宁省葫芦岛市",
"86159673", "浙江省嘉兴市",
"86139283", "广东省惠州市",
"861551784", "河南省平顶山市",
"861313301", "山西省太原市",
"861365441", "吉林省长春市",
"86158424", "辽宁省大连市",
"861356541", "新疆乌鲁木齐市",
"861516637", "山东省济宁市",
"861336718", "湖北省恩施土家族苗族自治州",
"861532818", "四川省成都市",
"861576945", "甘肃省金昌市",
"86170090", "天津市",
"861556035", "内蒙古赤峰市",
"861360150", "江苏省常州市",
"861304591", "福建省福州市",
"86134594", "福建省福州市",
"861552583", "山西省吕梁市",
"861326490", "湖北省宜昌市",
"861452348", "河南省漯河市",
"861340011", "河北省石家庄市",
"861810587", "浙江省温州市",
"861536251", "广东省江门市",
"861364877", "云南省玉溪市",
"861322799", "陕西省榆林市",
"861538876", "云南省曲靖市",
"861877098", "江西省景德镇市",
"861533766", "浙江省台州市",
"861572859", "广东省阳江市",
"861584706", "内蒙古赤峰市",
"861500318", "河北省衡水市",
"861780794", "江西省抚州市",
"861817877", "广西钦州市",
"861539373", "河南省洛阳市",
"86181378", "河南省郑州市",
"861850441", "吉林省长春市",
"861328841", "广东省佛山市",
"861825930", "福建省南平市",
"861310838", "四川省德阳市",
"861787507", "广东省肇庆市",
"861594541", "黑龙江省佳木斯市",
"861893687", "江苏省南京市",
"86133336", "河南省南阳市",
"86155244", "辽宁省沈阳市",
"861308530", "云南省西双版纳傣族自治州",
"861587289", "湖北省荆门市",
"861318660", "江苏省连云港市",
"861380027", "湖北省武汉市",
"86138430", "吉林省长春市",
"861533137", "西藏拉萨市",
"861361858", "贵州省贵阳市",
"861311819", "四川省绵阳市",
"861803893", "广东省韶关市",
"861318010", "河北省承德市",
"861579745", "湖北省武汉市",
"861813999", "甘肃省兰州市",
"861559424", "陕西省渭南市",
"861339918", "陕西省西安市",
"861535024", "江西省九江市",
"861453827", "四川省阿坝藏族羌族自治州",
"861313788", "河南省许昌市",
"861705774", "江西省南昌市",
"861317589", "浙江省台州市",
"861301913", "吉林省长春市",
"86181083", "重庆市",
"86137709", "江苏省南京市",
"861850702", "江西省九江市",
"861510470", "内蒙古呼伦贝尔市",
"861800395", "河南省漯河市",
"861886847", "浙江省金华市",
"861870936", "甘肃省张掖市",
"861846516", "宁夏固原市",
"861332213", "辽宁省抚顺市",
"861881459", "黑龙江省大庆市",
"861500452", "黑龙江省哈尔滨市",
"861887029", "江西省新余市",
"861300973", "黑龙江省齐齐哈尔市",
"86170852", "江苏省苏州市",
"861310879", "云南省普洱市",
"861880332", "河北省保定市",
"861561574", "山东省泰安市",
"861890425", "辽宁省丹东市",
"861514633", "黑龙江省牡丹江市",
"861829822", "安徽省马鞍山市",
"861320906", "新疆阿勒泰地区",
"861328335", "河北省承德市",
"861360640", "山东省济南市",
"86183671", "浙江省杭州市",
"861351390", "河南省濮阳市",
"861823034", "河北省廊坊市",
"861374921", "河南省鹤壁市",
"861817240", "广西南宁市",
"861454601", "青海省西宁市",
"861785845", "浙江省绍兴市",
"86139324", "河北省承德市",
"861827698", "广西河池市",
"861330811", "四川省绵阳市",
"861575148", "江苏省连云港市",
"861554525", "黑龙江省哈尔滨市",
"861825127", "江苏省连云港市",
"861535069", "河北省廊坊市",
"861853433", "山西省长治市",
"86150329", "河北省唐山市",
"861504980", "内蒙古巴彦淖尔市",
"861583035", "河北省秦皇岛市",
"861450201", "河北省邯郸市",
"861770768", "广东省潮州市",
"86183409", "辽宁省辽阳市",
"861859109", "陕西省商洛市",
"861314483", "广东省深圳市",
"86139567", "安徽省阜阳市",
"861771594", "江苏省盐城市",
"86186754", "广东省汕头市",
"861365702", "江西省九江市",
"861308454", "河北省衡水市",
"861364240", "广东省茂名市",
"861450421", "辽宁省朝阳市",
"861572412", "广东省江门市",
"861459123", "广西梧州市",
"861594992", "山东省德州市",
"861364408", "辽宁省大连市",
"861771192", "西藏日喀则地区",
"861364228", "广东省云浮市",
"861811467", "江苏省泰州市",
"861593080", "河北省邯郸市",
"861366785", "广西玉林市",
"861539833", "云南省昭通市",
"861370351", "山西省太原市",
"861305611", "江苏省宿迁市",
"861899751", "新疆阿勒泰地区",
"861859653", "福建省三明市",
"861560682", "浙江省湖州市",
"861471714", "甘肃省天水市",
"861501838", "广东省汕头市",
"861310378", "河南省开封市",
"86158752", "广东省惠州市",
"861337066", "山东省临沂市",
"86138855", "贵州省黔东南苗族侗族自治州",
"861884809", "内蒙古兴安盟",
"861817408", "江西省赣州市",
"861538336", "河北省廊坊市",
"861360628", "江苏省南通市",
"861530905", "四川省内江市",
"861477090", "江西省赣州市",
"861470774", "广西梧州市",
"861838779", "云南省玉溪市",
"861361359", "山西省运城市",
"861331845", "广东省东莞市",
"861319211", "广东省潮州市",
"861364337", "河北省沧州市",
"86156408", "辽宁省大连市",
"861879530", "宁夏银川市",
"861569719", "湖北省十堰市",
"861818711", "云南省昆明市",
"861329500", "福建省泉州市",
"861843619", "河南省南阳市",
"861339279", "广东省佛山市",
"86183556", "安徽省安庆市",
"86139237", "广东省深圳市",
"861816030", "新疆喀什地区",
"861534599", "福建省泉州市",
"861572074", "江苏省南通市",
"861874066", "陕西省汉中市",
"861500927", "陕西省宝鸡市",
"861363703", "安徽省滁州市",
"861780342", "山西省晋城市",
"861892339", "广东省珠海市",
"861857197", "湖北省荆门市",
"861329077", "河南省濮阳市",
"8618601", "北京市",
"861829996", "新疆伊犁哈萨克自治州",
"861709998", "广东省深圳市",
"861768755", "广西玉林市",
"861457085", "江苏省徐州市",
"86135562", "广东省惠州市",
"86147590", "福建省福州市",
"861553314", "河北省承德市",
"861310054", "广西贺州市",
"861575937", "福建省莆田市",
"861840710", "湖北省襄樊市",
"861331331", "河北省石家庄市",
"86159921", "广东省江门市",
"861768123", "安徽省蚌埠市",
"861594575", "黑龙江省牡丹江市",
"861335568", "安徽省亳州市",
"861339327", "河北省沧州市",
"861818853", "贵州省安顺市",
"861325559", "山东省青岛市",
"861452320", "河南省郑州市",
"861775274", "湖南省郴州市",
"861879454", "甘肃省临夏回族自治州",
"861804884", "四川省内江市",
"861337555", "山东省青岛市",
"86178658", "山东省聊城市",
"861597742", "广西桂林市",
"861896694", "陕西省西安市",
"861595984", "福建省三明市",
"861588133", "四川省自贡市",
"861850475", "内蒙古通辽市",
"861332933", "黑龙江省双鸭山市",
"861323765", "江西省宜春市",
"861328875", "广东省潮州市",
"861808959", "四川省攀枝花市",
"861700891", "北京市",
"861366333", "河北省张家口市",
"861310339", "河北省邢台市",
"861880872", "云南省大理白族自治州",
"861882675", "广东省汕头市",
"861453278", "山西省临汾市",
"861760577", "浙江省温州市",
"861893220", "江苏省南通市",
"861390965", "安徽省蚌埠市",
"86156416", "辽宁省锦州市",
"86131722", "广东省江门市",
"861557245", "湖北省襄樊市",
"86151825", "四川省遂宁市",
"861458791", "湖南省张家界市",
"861893400", "广东省湛江市",
"861508070", "湖南省益阳市",
"86157379", "河南省洛阳市",
"86186062", "江苏省苏州市",
"861533948", "甘肃省酒泉市",
"861317022", "安徽省蚌埠市",
"86181131", "四川省成都市",
"861511973", "广东省茂名市",
"861311452", "黑龙江省齐齐哈尔市",
"861700268", "广东省广州市",
"86176886", "广东省东莞市",
"86186422", "辽宁省鞍山市",
"861383992", "河南省驻马店市",
"861365475", "内蒙古通辽市",
"86176377", "河南省南阳市",
"861356575", "新疆巴音郭楞蒙古自治州",
"861568550", "贵州省贵阳市",
"861510913", "陕西省渭南市",
"861898795", "云南省昆明市",
"861452849", "甘肃省陇南市",
"861887582", "浙江省温州市",
"861824666", "黑龙江省鹤岗市",
"861373396", "河南省漯河市",
"861500819", "四川省绵阳市",
"861303935", "吉林省松原市",
"861899813", "广东省惠州市",
"861539447", "福建省厦门市",
"86186440", "黑龙江省哈尔滨市",
"861709460", "浙江省绍兴市",
"86177703", "江西省上饶市",
"861328908", "新疆克孜勒苏柯尔克孜自治州",
"861302913", "吉林省长春市",
"86184738", "湖南省娄底市",
"861815262", "湖南省岳阳市",
"861357147", "陕西省汉中市",
"861362858", "贵州省六盘水市",
"861563896", "河南省南阳市",
"861777608", "广西桂林市",
"861507161", "湖北省十堰市",
"861301311", "安徽省马鞍山市",
"86132620", "河南省南阳市",
"861576833", "广东省汕头市",
"86158960", "江苏省泰州市",
"861807401", "浙江省绍兴市",
"861802776", "广东省茂名市",
"861395106", "江苏省宿迁市",
"861886750", "浙江省杭州市",
"861771667", "贵州省毕节地区",
"861535086", "河北省邢台市",
"861585557", "安徽省宿州市",
"861334673", "河南省平顶山市",
"861882459", "广东省深圳市",
"861818285", "黑龙江省绥化市",
"861778920", "陕西省渭南市",
"861319785", "江西省宜春市",
"861884935", "河北省秦皇岛市",
"861333915", "安徽省巢湖市",
"861530839", "四川省资阳市",
"861534280", "湖北省随州市",
"861599197", "陕西省宝鸡市",
"861850659", "浙江省杭州市",
"861577549", "四川省南充市",
"861522846", "四川省泸州市",
"861831895", "广东省中山市",
"861330430", "吉林省长春市",
"861327620", "江苏省盐城市",
"861352390", "河南省信阳市",
"861305842", "广东省广州市",
"861346974", "湖北省恩施土家族苗族自治州",
"861504729", "内蒙古巴彦淖尔市",
"86152634", "山东省莱芜市",
"861363102", "广东省潮州市",
"861768241", "浙江省温州市",
"861536771", "湖南省益阳市",
"861332871", "福建省漳州市",
"861781700", "广东省佛山市",
"861705573", "河南省郑州市",
"861530680", "浙江省舟山市",
"861309147", "黑龙江省双鸭山市",
"861862765", "湖南省衡阳市",
"861889950", "新疆乌鲁木齐市",
"861559081", "黑龙江省鸡西市",
"861881641", "江西省九江市",
"861313903", "青海省海西蒙古族藏族自治州",
"861562253", "广东省东莞市",
"861337522", "江苏省淮安市",
"861538552", "安徽省蚌埠市",
"861508316", "河南省周口市",
"861347442", "陕西省延安市",
"861303809", "山西省大同市",
"861563457", "山东省潍坊市",
"861530878", "云南省楚雄彝族自治州",
"861558627", "湖北省武汉市",
"861705254", "浙江省温州市",
"8613412", "广东省东莞市",
"861318836", "辽宁省丹东市",
"861890819", "四川省成都市",
"861520582", "浙江省湖州市",
"861898507", "贵州省黔南布依族苗族自治州",
"861335631", "山东省威海市",
"861373281", "吉林省辽源市",
"861531818", "山东省济宁市",
"861511345", "广东省河源市",
"861868911", "西藏拉萨市",
"861813444", "河南省濮阳市",
"861569958", "吉林省延边朝鲜族自治州",
"861832956", "陕西省西安市",
"861558302", "四川省南充市",
"861533789", "广西柳州市",
"861809474", "浙江省宁波市",
"861321799", "江西省萍乡市",
"861821988", "甘肃省天水市",
"861889387", "甘肃省天水市",
"861850149", "江苏省连云港市",
"861571859", "贵州省黔西南布依族苗族自治州",
"861459241", "四川省眉山市",
"861396644", "安徽省安庆市",
"861528140", "四川省宜宾市",
"861857474", "湖南省湘西土家族苗族自治州",
"861708590", "福建省福州市",
"861770500", "福建省福州市",
"861826632", "山东省枣庄市",
"861565923", "福建省泉州市",
"861809012", "四川省甘孜藏族自治州",
"861330554", "安徽省淮南市",
"861539971", "湖南省益阳市",
"861315257", "广西桂林市",
"861317055", "云南省临沧市",
"861369600", "四川省南充市",
"86155144", "河南省周口市",
"861329946", "广西玉林市",
"86135804", "广东省广州市",
"86181561", "安徽省淮北市",
"861316985", "广东省中山市",
"861589079", "河南省安阳市",
"861596510", "山东省济宁市",
"861309657", "山西省忻州市",
"861372385", "湖南省长沙市",
"861358242", "河北省承德市",
"861315068", "云南省昭通市",
"86181518", "江苏省徐州市",
"861804575", "黑龙江省鸡西市",
"861359193", "辽宁省辽阳市",
"861778137", "四川省德阳市",
"861328584", "浙江省宁波市",
"861560851", "贵州省贵阳市",
"861347388", "河北省石家庄市",
"861380734", "湖南省衡阳市",
"86152447", "黑龙江省哈尔滨市",
"861350491", "辽宁省鞍山市",
"861890318", "河北省衡水市",
"8615828", "四川省成都市",
"861837800", "广西柳州市",
"861880556", "安徽省安庆市",
"861582013", "广东省潮州市",
"861852415", "辽宁省丹东市",
"861862604", "江苏省徐州市",
"861330152", "江苏省无锡市",
"861846479", "山东省枣庄市",
"861558280", "山西省吕梁市",
"86184599", "福建省南平市",
"861503687", "河南省平顶山市",
"861309938", "甘肃省张掖市",
"861385224", "江苏省淮安市",
"861325165", "黑龙江省绥化市",
"861331933", "江西省吉安市",
"86182696", "广西玉林市",
"861390467", "黑龙江省牡丹江市",
"861822749", "四川省甘孜藏族自治州",
"861577503", "广东省茂名市",
"861530379", "河南省洛阳市",
"861303308", "安徽省合肥市",
"861528128", "四川省雅安市",
"861327158", "河南省郑州市",
"861830736", "湖南省常德市",
"861346195", "河南省鹤壁市",
"861384893", "内蒙古通辽市",
"861850977", "青海省海西蒙古族藏族自治州",
"861369487", "江西省赣州市",
"86182764", "广西梧州市",
"861520614", "江苏省常州市",
"861389539", "宁夏银川市",
"861479661", "江西省鹰潭市",
"861334721", "湖南省长沙市",
"861357938", "新疆阿克苏地区",
"861512973", "陕西省渭南市",
"86181231", "四川省凉山彝族自治州",
"861779906", "新疆阿勒泰地区",
"861312452", "黑龙江省齐齐哈尔市",
"86187691", "山东省威海市",
"861563922", "河南省鹤壁市",
"861374800", "内蒙古包头市",
"861865491", "山东省烟台市",
"861510311", "河北省石家庄市",
"861505678", "安徽省阜阳市",
"861502879", "河北省衡水市",
"861333235", "辽宁省铁岭市",
"861881675", "广东省东莞市",
"861393861", "河南省开封市",
"861571358", "山西省大同市",
"861511371", "广东省清远市",
"861867598", "广东省湛江市",
"86188957", "安徽省宿州市",
"861816816", "江苏省泰州市",
"861570629", "江苏省南通市",
"861339759", "湖南省邵阳市",
"861762517", "江苏省淮安市",
"861880615", "江苏省无锡市",
"861329768", "湖北省咸宁市",
"861524214", "辽宁省鞍山市",
"861503248", "河北省保定市",
"86180673", "浙江省宁波市",
"861320540", "山东省济南市",
"861340579", "江苏省无锡市",
"86137821", "河南省南阳市",
"861840887", "云南省迪庆藏族自治州",
"861472714", "浙江省杭州市",
"861505639", "安徽省蚌埠市",
"861454453", "江西省上饶市",
"861500205", "广东省深圳市",
"861571412", "辽宁省鞍山市",
"861477741", "广西钦州市",
"861580698", "山东省聊城市",
"861357979", "新疆塔城地区",
"86136759", "福建省泉州市",
"861500425", "辽宁省大连市",
"86186398", "河南省三门峡市",
"861772192", "四川省南充市",
"861335700", "浙江省衢州市",
"861396552", "安徽省黄山市",
"861340538", "山东省泰安市",
"861859394", "广西玉林市",
"861536745", "湖南省怀化市",
"861332845", "福建省漳州市",
"861478127", "四川省攀枝花市",
"861305489", "山东省淄博市",
"861370953", "宁夏吴忠市",
"861570472", "内蒙古包头市",
"861860690", "福建省莆田市",
"861479011", "安徽省滁州市",
"861330642", "山东省青岛市",
"861778948", "甘肃省天水市",
"861847577", "广东省梅州市",
"861317290", "广东省清远市",
"861327648", "山东省青岛市",
"861871756", "陕西省安康市",
"861533801", "广东省东莞市",
"861897204", "湖北省宜昌市",
"86181459", "黑龙江省大庆市",
"861350096", "吉林省四平市",
"861362359", "山西省运城市",
"861312318", "福建省福州市",
"861338510", "贵州省贵阳市",
"861336959", "宁夏银川市",
"861300345", "江苏省镇江市",
"861573966", "新疆哈密地区",
"86139137", "江苏省苏州市",
"86182715", "湖北省黄冈市",
"861470573", "浙江省嘉兴市",
"861846307", "山东省潍坊市",
"861369731", "湖北省荆州市",
"861318376", "四川省南充市",
"861534302", "湖南省湘潭市",
"861530407", "辽宁省丹东市",
"861325085", "浙江省绍兴市",
"861776706", "浙江省杭州市",
"861319873", "四川省达州市",
"861361727", "湖北省宜昌市",
"861477883", "广东省湛江市",
"861353456", "广东省佛山市",
"86132826", "浙江省台州市",
"861554552", "黑龙江省绥化市",
"861303843", "陕西省渭南市",
"861530338", "河北省衡水市",
"861567656", "广西来宾市",
"861591776", "广东省惠州市",
"861521462", "黑龙江省牡丹江市",
"861313949", "甘肃省酒泉市",
"861894357", "吉林省通化市",
"861590395", "河南省漯河市",
"861534627", "河南省鹤壁市",
"861362034", "广东省佛山市",
"86151877", "云南省玉溪市",
"861571074", "广东省广州市",
"861829855", "甘肃省武威市",
"861471513", "广东省深圳市",
"86187971", "青海省西宁市",
"861890452", "黑龙江省齐齐哈尔市",
"861846438", "山东省滨州市",
"86187317", "河北省沧州市",
"86158688", "浙江省杭州市",
"86138278", "广东省河源市",
"861452232", "浙江省湖州市",
"861807034", "江西省上饶市",
"861452608", "江苏省无锡市",
"861534753", "广东省韶关市",
"861380042", "辽宁省朝阳市",
"861871990", "新疆阿勒泰地区",
"861325017", "广东省广州市",
"86145203", "北京市",
"861310196", "江苏省无锡市",
"861539380", "云南省西双版纳傣族自治州",
"861810003", "北京市",
"861839509", "宁夏银川市",
"861344693", "西藏日喀则地区",
"86152729", "湖北省恩施土家族苗族自治州",
"861327215", "湖南省益阳市",
"861859359", "福建省宁德市",
"861340293", "陕西省咸阳市",
"861780918", "陕西省西安市",
"861373139", "河北省秦皇岛市",
"861572982", "四川省攀枝花市",
"861830665", "广东省茂名市",
"861362394", "河南省周口市",
"86138464", "黑龙江省七台河市",
"861552570", "山西省运城市",
"861379223", "山东省德州市",
"861454835", "广东省东莞市",
"861523424", "山西省太原市",
"861335219", "辽宁省锦州市",
"861381444", "江苏省徐州市",
"861700519", "江苏省常州市",
"861852731", "湖北省宜昌市",
"861390541", "山东省济南市",
"861770897", "西藏阿里地区",
"86158030", "重庆市",
"861840815", "四川省广安市",
"861336994", "新疆昌吉回族自治州",
"86156856", "贵州省铜仁地区",
"861882301", "广东省梅州市",
"86159315", "河北省唐山市",
"861315271", "山西省朔州市",
"861589899", "山东省日照市",
"861768850", "广东省江门市",
"861800362", "黑龙江省齐齐哈尔市",
"861348749", "湖南省长沙市",
"861323860", "云南省昭通市",
"86147294", "陕西省西安市",
"861304318", "河北省衡水市",
"861323344", "山西省晋中市",
"861553537", "山西省太原市",
"861311942", "甘肃省兰州市",
"861523469", "山西省长治市",
"861518260", "四川省自贡市",
"861332496", "云南省昭通市",
"861390826", "重庆市",
"861560877", "云南省玉溪市",
"861350336", "河北省保定市",
"861899902", "新疆巴音郭楞蒙古自治州",
"861313641", "浙江省舟山市",
"861595414", "山东省日照市",
"861801520", "江苏省南通市",
"861533312", "河北省保定市",
"86156783", "广西桂林市",
"861479924", "新疆伊犁哈萨克自治州",
"861369415", "辽宁省丹东市",
"861824981", "黑龙江省伊春市",
"86178782", "广西柳州市",
"861879191", "陕西省榆林市",
"861454341", "山东省济南市",
"861302598", "广西梧州市",
"861304452", "福建省漳州市",
"861705361", "江苏省南京市",
"86180431", "吉林省长春市",
"861557777", "广西柳州市",
"861766033", "山东省菏泽市",
"861894345", "吉林省白城市",
"861532613", "辽宁省沈阳市",
"86155388", "河南省洛阳市",
"861762585", "江苏省扬州市",
"861880687", "浙江省温州市",
"861892196", "江苏省苏州市",
"861592548", "云南省临沧市",
"861876744", "浙江省台州市",
"861825142", "江苏省盐城市",
"861586023", "福建省漳州市",
"861585571", "安徽省宿州市",
"86138415", "辽宁省丹东市",
"861395134", "江苏省徐州市",
"861336141", "山东省东营市",
"861884648", "黑龙江省大庆市",
"861332091", "四川省乐山市",
"861325793", "江西省上饶市",
"861560240", "广东省广州市",
"861343512", "广东省韶关市",
"861770456", "黑龙江省黑河市",
"861366880", "山东省济南市",
"861886822", "浙江省湖州市",
"861478743", "云南省曲靖市",
"861830015", "广东省揭阳市",
"861586537", "山东省济宁市",
"861896702", "浙江省衢州市",
"861300980", "黑龙江省哈尔滨市",
"861537936", "甘肃省张掖市",
"861510483", "内蒙古阿拉善盟",
"86181632", "广东省河源市",
"861339794", "江西省抚州市",
"861534811", "四川省自贡市",
"861570921", "陕西省延安市",
"861818937", "甘肃省酒泉市",
"861331740", "湖南省岳阳市",
"861350525", "江苏省扬州市",
"861878645", "贵州省毕节地区",
"861373178", "河北省秦皇岛市",
"861366639", "山东省临沂市",
"861325667", "山东省济南市",
"861882788", "江西省赣州市",
"86159527", "江苏省扬州市",
"861300563", "广东省湛江市",
"861536757", "湖南省怀化市",
"861524906", "陕西省西安市",
"861453842", "四川省甘孜藏族自治州",
"86187292", "陕西省西安市",
"861331728", "湖北省十堰市",
"86897", "西藏阿里地区\、普兰县\、扎达县",
"861817682", "广西钦州市",
"861311591", "福建省福州市",
"861872468", "黑龙江省鹤岗市",
"861500942", "甘肃省兰州市",
"86136008", "福建省福州市",
"861828476", "四川省遂宁市",
"861309723", "江西省景德镇市",
"861350876", "云南省文山壮族苗族自治州",
"861708478", "内蒙古包头市",
"861535313", "陕西省西安市",
"861334905", "安徽省马鞍山市",
"861336175", "江西省宜春市",
"861898762", "云南省文山壮族苗族自治州",
"86130785", "贵州省贵阳市",
"861362742", "湖南省长沙市",
"861780327", "河北省沧州市",
"86150882", "浙江省金华市",
"861348703", "湖北省黄冈市",
"861335939", "甘肃省酒泉市",
"861889796", "江西省吉安市",
"861316917", "广东省茂名市",
"861884620", "黑龙江省齐齐哈尔市",
"861309155", "黑龙江省绥化市",
"861847551", "广东省梅州市",
"861778635", "湖北省武汉市",
"861390992", "新疆乌鲁木齐市",
"861519611", "四川省广元市",
"861372317", "河南省焦作市",
"861453489", "内蒙古呼伦贝尔市",
"861818658", "湖北省随州市",
"861560408", "辽宁省大连市",
"861322553", "安徽省芜湖市",
"861592520", "云南省昆明市",
"861323792", "江西省九江市",
"861357155", "陕西省铜川市",
"861760814", "四川省达州市",
"861454375", "山东省潍坊市",
"861321754", "广东省汕头市",
"861309586", "浙江省湖州市",
"861539679", "江苏省连云港市",
"861355168", "四川省南充市",
"861308944", "吉林省延边朝鲜族自治州",
"861330599", "福建省南平市",
"861319093", "内蒙古赤峰市",
"861322367", "山西省晋城市",
"861379449", "广东省深圳市",
"861508163", "河北省邯郸市",
"861519466", "河南省驻马店市",
"861866043", "山东省济南市",
"861598994", "广东省东莞市",
"861810049", "吉林省长春市",
"861839543", "陕西省渭南市",
"861822418", "四川省雅安市",
"861858265", "四川省绵阳市",
"86393", "河南省濮阳市",
"861776734", "浙江省宁波市",
"86139906", "四川省乐山市",
"861501633", "广东省汕尾市",
"861539202", "福建省厦门市",
"86155522", "山东省烟台市",
"861886996", "浙江省台州市",
"861457192", "浙江省嘉兴市",
"861333987", "湖北省咸宁市",
"86139918", "陕西省西安市",
"86155540", "山东省菏泽市",
"861363325", "河北省唐山市",
"861576455", "黑龙江省绥化市",
"86156650", "黑龙江省绥化市",
"861390575", "浙江省绍兴市",
"86153900", "四川省成都市",
"861522495", "河南省周口市",
"861365951", "西藏拉萨市",
"86180575", "浙江省绍兴市",
"861365694", "福建省宁德市",
"861876392", "山东省德州市",
"861585116", "江苏省宿迁市",
"86185516", "江苏省南京市",
"861339488", "内蒙古兴安盟",
"861306923", "吉林省延边朝鲜族自治州",
"861355088", "四川省泸州市",
"861309645", "四川省德阳市",
"86134290", "浙江省金华市",
"861830704", "江西省抚州市",
"861478709", "云南省临沧市",
"861508083", "湖南省娄底市",
"861313675", "黑龙江省哈尔滨市",
"86159159", "广东省广州市",
"861301483", "广西北海市",
"861818148", "四川省巴中市",
"861576561", "黑龙江省黑河市",
"861317047", "湖南省长沙市",
"861828071", "四川省自贡市",
"861316829", "广东省河源市",
"861356965", "河南省鹤壁市",
"861360823", "四川省成都市",
"861587807", "广西梧州市",
"86177739", "湖南省邵阳市",
"861850694", "福建省福州市",
"861850951", "宁夏银川市",
"861707044", "浙江省台州市",
"861869390", "甘肃省陇南市",
"861333350", "山西省忻州市",
"86131865", "江苏省南通市",
"861339342", "山西省大同市",
"861357645", "江西省萍乡市",
"86151762", "河北省保定市",
"861519061", "江苏省泰州市",
"861367776", "广西百色市",
"861808882", "广东省珠海市",
"861868069", "广东省深圳市",
"861779934", "新疆和田地区",
"861314913", "陕西省渭南市",
"861506149", "江苏省镇江市",
"861511357", "广东省湛江市",
"86134545", "浙江省绍兴市",
"861780279", "湖北省武汉市",
"861895333", "山东省日照市",
"861521997", "广东省阳江市",
"86156737", "湖南省益阳市",
"861316864", "广东省惠州市",
"861771165", "湖南省郴州市",
"86137246", "广东省佛山市",
"861805865", "浙江省绍兴市",
"861316340", "黑龙江省齐齐哈尔市",
"86136016", "上海市",
"861335978", "黑龙江省双鸭山市",
"861530673", "浙江省嘉兴市",
"861705580", "河北省石家庄市",
"861339593", "福建省宁德市",
"861310099", "黑龙江省齐齐哈尔市",
"861370443", "吉林省延边朝鲜族自治州",
"861528932", "陕西省榆林市",
"861305827", "广东省汕头市",
"861301598", "福建省莆田市",
"86188551", "安徽省合肥市",
"861898163", "四川省雅安市",
"861818435", "贵州省六盘水市",
"861300764", "河南省开封市",
"86176911", "陕西省西安市",
"86181819", "四川省成都市",
"86152660", "山东省东营市",
"861829750", "安徽省芜湖市",
"861364713", "湖北省黄冈市",
"861454943", "福建省厦门市",
"861840429", "辽宁省葫芦岛市",
"861509188", "陕西省榆林市",
"86138920", "陕西省咸阳市",
"861350154", "广东省广州市",
"861325594", "福建省厦门市",
"861317976", "江苏省扬州市",
"861808651", "湖北省武汉市",
"861840209", "广东省梅州市",
"861373036", "河北省廊坊市",
"86138942", "吉林省吉林市",
"861344078", "内蒙古巴彦淖尔市",
"861830549", "山东省临沂市",
"861870904", "新疆伊犁哈萨克自治州",
"861819043", "四川省广元市",
"861808994", "西藏林芝地区",
"861534273", "湖北省武汉市",
"861879499", "甘肃省陇南市",
"861346564", "山东省日照市",
"861896659", "陕西省延安市",
"861888246", "四川省绵阳市",
"861598403", "四川省泸州市",
"861562929", "湖北省武汉市",
"86185833", "四川省乐山市",
"861856927", "湖南省益阳市",
"861513850", "河南省濮阳市",
"861334680", "河南省鹤壁市",
"861457017", "山东省日照市",
"861331091", "陕西省延安市",
"861876543", "山东省滨州市",
"861538491", "新疆和田地区",
"86188870", "云南省昭通市",
"861474033", "辽宁省鞍山市",
"861328250", "浙江省绍兴市",
"861320934", "甘肃省庆阳市",
"861570323", "河北省保定市",
"861527220", "湖北省鄂州市",
"861300729", "江西省九江市",
"86183487", "河北省邯郸市",
"861823006", "河北省廊坊市",
"861313459", "黑龙江省大庆市",
"86158934", "河南省平顶山市",
"86187648", "山东省泰安市",
"861863367", "河北省沧州市",
"861576679", "广东省揭阳市",
"861566611", "山东省威海市",
"861331857", "广东省韶关市",
"861811541", "江苏省无锡市",
"861840464", "黑龙江省七台河市",
"861534430", "吉林省长春市",
"861336449", "吉林省白山市",
"861399501", "宁夏银川市",
"861505785", "浙江省丽水市",
"861865154", "江苏省盐城市",
"861827160", "湖北省十堰市",
"861334839", "福建省厦门市",
"861573825", "河南省信阳市",
"861346529", "山东省东营市",
"861558152", "湖南省邵阳市",
"861332740", "山西省太原市",
"861539561", "安徽省淮北市",
"861872990", "陕西省西安市",
"861373431", "山东省日照市",
"861894410", "江苏省南京市",
"861820807", "西藏日喀则地区",
"861315813", "贵州省安顺市",
"86187577", "浙江省温州市",
"861354244", "广东省云浮市",
"861557257", "湖北省荆门市",
"861396304", "山东省日照市",
"861303620", "江西省南昌市",
"861550510", "江苏省淮安市",
"861369864", "山东省济南市",
"861476037", "福建省南平市",
"861539455", "福建省福州市",
"861350644", "山东省淄博市",
"861361394", "河南省周口市",
"861831862", "广东省阳江市",
"861334878", "湖南省娄底市",
"861839392", "甘肃省定西市",
"861363352", "山西省大同市",
"861535231", "甘肃省兰州市",
"861573681", "河南省许昌市",
"861323636", "江苏省镇江市",
"861576638", "广东省湛江市",
"861808141", "四川省成都市",
"861476523", "河北省石家庄市",
"861889428", "甘肃省酒泉市",
"86151950", "江苏省常州市",
"861364851", "贵州省贵阳市",
"86159575", "浙江省绍兴市",
"861870588", "浙江省丽水市",
"861536277", "广东省珠海市",
"861338463", "黑龙江省牡丹江市",
"861390884", "云南省昆明市",
"861768747", "广西钦州市",
"861318198", "山东省东营市",
"861856819", "河南省濮阳市",
"861554304", "吉林省吉林市",
"861767121", "湖北省黄石市",
"861347207", "河北省承德市",
"861569200", "广东省广州市",
"861331496", "福建省泉州市",
"861840672", "广西梧州市",
"861337547", "山东省济宁市",
"861306294", "江苏省镇江市",
"861859727", "青海省海西蒙古族藏族自治州",
"861788916", "西藏那曲地区",
"861534554", "安徽省淮南市",
"861477330", "湖南省株洲市",
"861815295", "新疆吐鲁番地区",
"861344039", "辽宁省锦州市",
"861471460", "广东省东莞市",
"861369829", "四川省南充市",
"861558642", "湖北省恩施土家族苗族自治州",
"861587131", "湖北省孝感市",
"861569420", "辽宁省铁岭市",
"861347427", "陕西省咸阳市",
"861376342", "黑龙江省哈尔滨市",
"861825625", "安徽省六安市",
"861313812", "广东省珠海市",
"861848799", "云南省临沧市",
"86152801", "福建省福州市",
"861397172", "湖北省黄冈市",
"861334379", "河南省洛阳市",
"86130254", "广东省深圳市",
"861521495", "新疆喀什地区",
"86182730", "湖南省岳阳市",
"861774023", "四川省乐山市",
"86180315", "河北省唐山市",
"861502633", "新疆喀什地区",
"861709513", "江苏省无锡市",
"861374664", "黑龙江省绥化市",
"861811992", "安徽省宣城市",
"861813954", "新疆伊犁哈萨克自治州",
"861450595", "辽宁省盘锦市",
"861820439", "吉林省白山市",
"861813691", "江苏省常州市",
"861306321", "安徽省合肥市",
"861850567", "安徽省合肥市",
"861847814", "湖南省常德市",
"86134628", "河南省焦作市",
"861340969", "湖北省黄冈市",
"861370264", "广东省珠海市",
"861365353", "山西省阳泉市",
"861890591", "福建省福州市",
"86183433", "吉林省延边朝鲜族自治州",
"86138331", "河北省石家庄市",
"861876509", "山东省滨州市",
"861327843", "吉林省四平市",
"861509902", "新疆喀什地区",
"861889440", "甘肃省临夏回族自治州",
"861512980", "陕西省西安市",
"86185376", "河南省信阳市",
"861358110", "山东省枣庄市",
"86185887", "广东省广州市",
"86159259", "浙江省金华市",
"861365567", "安徽省阜阳市",
"861598449", "四川省达州市",
"861557902", "江西省新余市",
"861329456", "山西省晋城市",
"861760551", "安徽省合肥市",
"86155195", "贵州省贵阳市",
"861830503", "浙江省衢州市",
"861819009", "四川省德阳市",
"86188469", "黑龙江省双鸭山市",
"861504831", "内蒙古阿拉善盟",
"861533635", "山东省聊城市",
"861558273", "山西省临汾市",
"861454909", "湖北省宜昌市",
"861361221", "广东省珠海市",
"861862860", "陕西省宝鸡市",
"86188029", "陕西省西安市",
"861314311", "广东省珠海市",
"86137733", "江苏省扬州市",
"86183272", "湖北省武汉市",
"861522997", "陕西省宝鸡市",
"861585669", "安徽省淮南市",
"861800035", "河北省唐山市",
"861570800", "西藏拉萨市",
"861576957", "宁夏银川市",
"861340924", "河南省新乡市",
"86182657", "山东省滨州市",
"861760465", "黑龙江省大庆市",
"861808175", "四川省内江市",
"861880092", "四川省遂宁市",
"861303648", "四川省宜宾市",
"861370409", "辽宁省大连市",
"861308499", "广西南宁市",
"861810146", "江苏省南通市",
"861530721", "湖北省荆州市",
"861569382", "甘肃省兰州市",
"861850353", "山西省阳泉市",
"861379651", "黑龙江省伊春市",
"861510598", "福建省厦门市",
"861785857", "浙江省衢州市",
"861506702", "浙江省衢州市",
"861558554", "吉林省白城市",
"861839744", "湖南省常德市",
"861302802", "山西省临汾市",
"861453611", "江苏省无锡市",
"861361742", "湖南省常德市",
"86181967", "安徽省宣城市",
"861519489", "河北省保定市",
"861831790", "江西省新余市",
"86135631", "山东省威海市",
"861577167", "陕西省宝鸡市",
"861772085", "福建省莆田市",
"861536828", "云南省昭通市",
"861332728", "湖南省娄底市",
"861871468", "黑龙江省鹤岗市",
"861882949", "陕西省西安市",
"861470963", "宁夏吴忠市",
"861312591", "黑龙江省哈尔滨市",
"861477870", "广东省佛山市",
"861899777", "新疆博尔塔拉蒙古自治州",
"861370377", "河南省南阳市",
"861319880", "四川省自贡市",
"861309569", "浙江省绍兴市",
"861832041", "广东省广州市",
"861319639", "陕西省汉中市",
"861825743", "浙江省宁波市",
"861530242", "广东省佛山市",
"861321553", "安徽省芜湖市",
"861532782", "湖北省咸宁市",
"861336882", "云南省德宏傣族景颇族自治州",
"8613269", "北京市",
"861811575", "江苏省无锡市",
"861538304", "河北省石家庄市",
"861470580", "浙江省舟山市",
"861877227", "湖北省黄石市",
"86170945", "黑龙江省哈尔滨市",
"861450972", "新疆哈密地区",
"861814256", "四川省绵阳市",
"861843231", "河北省石家庄市",
"861820478", "内蒙古巴彦淖尔市",
"861841908", "甘肃省陇南市",
"861330627", "江苏省南通市",
"861392146", "江苏省南通市",
"861478142", "四川省宜宾市",
"86159431", "吉林省长春市",
"861327437", "吉林省辽源市",
"861893556", "青海省海西蒙古族藏族自治州",
"861357569", "浙江省金华市",
"861572894", "西藏林芝地区",
"861376794", "江西省景德镇市",
"861350552", "安徽省蚌埠市",
"861591520", "广东省佛山市",
"861325192", "浙江省湖州市",
"861453466", "黑龙江省七台河市",
"86151649", "内蒙古锡林郭勒盟",
"861805414", "甘肃省武威市",
"861844725", "内蒙古包头市",
"861334338", "河北省承德市",
"861527687", "新疆塔城地区",
"861563310", "河北省邯郸市",
"861330302", "河北省保定市",
"861309524", "云南省西双版纳傣族自治州",
"86184898", "海南省海口市",
"861379141", "山东省枣庄市",
"861472998", "陕西省西安市",
"861329051", "河北省石家庄市",
"861327308", "河南省三门峡市",
"861338244", "江苏省常州市",
"861506046", "福建省泉州市",
"861306926", "吉林省松原市",
"861577534", "四川省成都市",
"861554678", "广东省潮州市",
"861873565", "山西省运城市",
"86184694", "云南省保山市",
"861530360", "黑龙江省哈尔滨市",
"861521620", "江西省宜春市",
"861819977", "新疆哈密地区",
"861301486", "广西桂林市",
"861508086", "湖南省湘西土家族苗族自治州",
"86183781", "广西南宁市",
"861322065", "山东省临沂市",
"861869902", "新疆克拉玛依市",
"86183158", "山东省德州市",
"861590877", "云南省玉溪市",
"861846460", "山东省潍坊市",
"861345145", "河北省邯郸市",
"861331904", "新疆乌鲁木齐市",
"861360826", "四川省雅安市",
"861875759", "浙江省杭州市",
"861501636", "广东省肇庆市",
"861873451", "山西省长治市",
"861813478", "河南省洛阳市",
"86132486", "浙江省宁波市",
"861809448", "江苏省镇江市",
"861886993", "浙江省金华市",
"861360541", "山东省济南市",
"86156315", "河北省唐山市",
"861550278", "湖北省恩施土家族苗族自治州",
"861454500", "湖南省湘潭市",
"86159856", "贵州省铜仁地区",
"861302424", "浙江省嘉兴市",
"861476182", "江苏省宿迁市",
"861585113", "江苏省盐城市",
"861857448", "湖南省张家界市",
"861707399", "河南省驻马店市",
"86133092", "陕西省西安市",
"86137481", "内蒙古呼和浩特市",
"861317831", "福建省漳州市",
"861319491", "四川省自贡市",
"861583514", "山西省长治市",
"861870857", "贵州省毕节地区",
"861301161", "山东省淄博市",
"861815487", "新疆博尔塔拉蒙古自治州",
"86177843", "重庆市",
"861771387", "四川省广安市",
"861888121", "四川省攀枝花市",
"861812300", "四川省成都市",
"861889017", "湖南省邵阳市",
"861868890", "广东省广州市",
"861338842", "浙江省杭州市",
"861347018", "辽宁省盘锦市",
"861778195", "四川省达州市",
"86157614", "贵州省毕节地区",
"86152605", "福建省漳州市",
"861864831", "内蒙古阿拉善盟",
"861855541", "安徽省合肥市",
"861572292", "江苏省南京市",
"861866441", "广东省中山市",
"861351751", "广西南宁市",
"861302469", "浙江省丽水市",
"861367773", "广西桂林市",
"861450314", "河北省承德市",
"861314916", "陕西省汉中市",
"861889793", "江西省上饶市",
"861370862", "云南省德宏傣族景颇族自治州",
"861329730", "湖南省岳阳市",
"86150932", "河南省郑州市",
"86133571", "浙江省杭州市",
"861577450", "黑龙江省哈尔滨市",
"861308631", "四川省雅安市",
"861594640", "黑龙江省七台河市",
"8613510", "广东省深圳市",
"861888815", "江苏省苏州市",
"861322556", "安徽省安庆市",
"861304690", "福建省莆田市",
"861590240", "辽宁省沈阳市",
"861357960", "新疆昌吉回族自治州",
"86177529", "河北省邯郸市",
"861828473", "四川省泸州市",
"861535316", "陕西省榆林市",
"861309726", "江西省九江市",
"861350873", "云南省红河哈尼族彝族自治州",
"86135744", "湖南省张家界市",
"861318455", "江西省萍乡市",
"861380749", "湖南省长沙市",
"86189667", "陕西省西安市",
"861348706", "湖北省黄冈市",
"86156364", "黑龙江省佳木斯市",
"861301081", "四川省成都市",
"861889667", "江苏省镇江市",
"861866702", "浙江省杭州市",
"861519463", "河南省开封市",
"861866046", "山东省济南市",
"861539198", "安徽省巢湖市",
"861363027", "陕西省汉中市",
"861831837", "广东省云浮市",
"861839546", "陕西省榆林市",
"861309960", "云南省临沧市",
"861457208", "四川省绵阳市",
"861884997", "云南省临沧市",
"861321872", "江苏省泰州市",
"861580955", "宁夏中卫市",
"861824868", "浙江省台州市",
"86133850", "福建省宁德市",
"86130944", "四川省成都市",
"861531522", "山东省淄博市",
"86147626", "江苏省连云港市",
"861599135", "陕西省咸阳市",
"861803310", "广东省江门市",
"861858412", "四川省内江市",
"861331588", "河北省承德市",
"86135835", "山东省烟台市",
"86155732", "湖南省湘潭市",
"861317345", "山东省济宁市",
"861320812", "四川省南充市",
"86152269", "河北省邯郸市",
"861322615", "广东省揭阳市",
"861879700", "青海省西宁市",
"861390300", "广东省广州市",
"861309583", "浙江省丽水市",
"861810394", "河南省周口市",
"86157665", "广东省湛江市",
"861346948", "湖南省娄底市",
"861319096", "内蒙古兴安盟",
"861508166", "河北省廊坊市",
"861820954", "宁夏固原市",
"861322185", "浙江省温州市",
"861828230", "四川省自贡市",
"861820691", "云南省西双版纳傣族自治州",
"861813439", "河北省邢台市",
"86543", "山东省滨州市",
"861882540", "广东省佛山市",
"861389142", "陕西省商洛市",
"861337818", "四川省南充市",
"861766036", "山东省滨州市",
"861389544", "宁夏固原市",
"861785588", "浙江省金华市",
"861532616", "辽宁省大连市",
"861529707", "青海省海西蒙古族藏族自治州",
"861831264", "广东省中山市",
"861892193", "江苏省扬州市",
"861810401", "辽宁省沈阳市",
"861350785", "广西玉林市",
"861556112", "内蒙古鄂尔多斯市",
"861341480", "广东省揭阳市",
"861576804", "广东省湛江市",
"861586026", "福建省福州市",
"861315030", "新疆乌鲁木齐市",
"861551938", "贵州省铜仁地区",
"861346920", "湖南省郴州市",
"861327674", "浙江省宁波市",
"86181216", "江苏省淮安市",
"861805259", "江苏省扬州市",
"861365532", "山东省青岛市",
"861354842", "四川省绵阳市",
"861589610", "江苏省连云港市",
"861831229", "广东省肇庆市",
"86152539", "山东省临沂市",
"861854508", "黑龙江省佳木斯市",
"861806181", "江苏省南通市",
"861337319", "河北省邢台市",
"861300566", "广东省茂名市",
"86151595", "福建省泉州市",
"861803138", "河北省张家口市",
"861831409", "云南省临沧市",
"861830940", "甘肃省临夏回族自治州",
"861524903", "陕西省渭南市",
"861806611", "江苏省南京市",
"861378448", "河北省衡水市",
"861571048", "陕西省西安市",
"8618561", "山东省青岛市",
"861538678", "山西省吕梁市",
"861770453", "黑龙江省牡丹江市",
"861550827", "四川省巴中市",
"861325796", "江西省吉安市",
"861458350", "山东省东营市",
"861478746", "云南省昆明市",
"861850532", "山东省青岛市",
"861390282", "广东省中山市",
"86153010", "北京市",
"861510486", "内蒙古乌兰察布市",
"861537933", "甘肃省武威市",
"861868762", "云南省迪庆藏族自治州",
"861471647", "广东省深圳市",
"861568141", "四川省内江市",
"861830317", "河北省沧州市",
"861383432", "山西省晋城市",
"861819149", "陕西省渭南市",
"861834412", "广东省揭阳市",
"861340296", "陕西省西安市",
"861538880", "云南省西双版纳傣族自治州",
"86150341", "山西省太原市",
"861479708", "青海省西宁市",
"861890088", "广东省广州市",
"861564965", "河南省郑州市",
"86139016", "上海市",
"861764526", "黑龙江省双鸭山市",
"86159737", "湖南省益阳市",
"861379226", "山东省滨州市",
"861338489", "内蒙古呼和浩特市",
"861327462", "黑龙江省哈尔滨市",
"861899390", "甘肃省陇南市",
"861524177", "辽宁省营口市",
"861370790", "江西省新余市",
"861308700", "河南省开封市",
"861321332", "河南省周口市",
"861593445", "山西省运城市",
"861581981", "广东省珠海市",
"861520850", "贵州省贵阳市",
"861891344", "江苏省镇江市",
"861534756", "广东省湛江市",
"861857420", "河南省商丘市",
"861857200", "湖北省黄石市",
"861538639", "湖南省邵阳市",
"861330468", "黑龙江省鹤岗市",
"861313934", "甘肃省庆阳市",
"861310193", "江苏省镇江市",
"861810006", "上海市",
"86135450", "湖北省武汉市",
"861361656", "浙江省宁波市",
"861320459", "黑龙江省大庆市",
"861362049", "广东省惠州市",
"861810742", "湖南省常德市",
"861377412", "湖北省随州市",
"86187735", "湖南省郴州市",
"86177051", "江苏省南京市",
"861505644", "安徽省六安市",
"861809420", "江苏省南京市",
"861871302", "河北省廊坊市",
"861361515", "江苏省盐城市",
"86185662", "广东省深圳市",
"86181208", "福建省福州市",
"861332493", "云南省红河哈尼族彝族自治州",
"861475105", "江苏省常州市",
"861390823", "四川省成都市",
"861350333", "河北省石家庄市",
"861869068", "新疆巴音郭楞蒙古自治州",
"86138252", "广东省深圳市",
"861323099", "河北省邢台市",
"861521648", "山东省青岛市",
"861828910", "西藏拉萨市",
"86136918", "广东省深圳市",
"861474139", "辽宁省辽阳市",
"861519244", "山东省济宁市",
"861550919", "陕西省铜川市",
"861707261", "湖北省咸宁市",
"86159650", "山东省潍坊市",
"861709622", "山东省济宁市",
"861814885", "广东省云浮市",
"861360575", "浙江省绍兴市",
"861577132", "内蒙古乌海市",
"861898024", "四川省泸州市",
"861305510", "湖南省益阳市",
"861878498", "四川省自贡市",
"861800408", "辽宁省大连市",
"861873649", "河南省三门峡市",
"861336001", "广东省广州市",
"861524494", "四川省遂宁市",
"8613520", "北京市",
"861369501", "福建省厦门市",
"861893367", "广东省汕头市",
"861454768", "山东省泰安市",
"861309784", "广西梧州市",
"861825746", "浙江省金华市",
"861593138", "河北省衡水市",
"861321556", "安徽省安庆市",
"861533195", "黑龙江省绥化市",
"86133311", "北京市",
"86188413", "辽宁省抚顺市",
"861895154", "江苏省盐城市",
"861774421", "四川省成都市",
"861806842", "江苏省苏州市",
"86137956", "四川省凉山彝族自治州",
"861865211", "江苏省连云港市",
"86186882", "广东省佛山市",
"861580457", "黑龙江省大兴安岭地区",
"861302081", "河北省保定市",
"861770601", "福建省厦门市",
"861800337", "河北省沧州市",
"861853391", "河北省张家口市",
"861500168", "新疆昌吉回族自治州",
"861470966", "宁夏固原市",
"861393418", "山西省晋中市",
"861844585", "黑龙江省哈尔滨市",
"861764062", "辽宁省葫芦岛市",
"861860942", "甘肃省酒泉市",
"861473014", "河北省石家庄市",
"861330990", "新疆克拉玛依市",
"861363734", "湖南省衡阳市",
"861322872", "江苏省宿迁市",
"861575174", "江苏省苏州市",
"86131606", "广东省珠海市",
"861475347", "山东省青岛市",
"86132951", "江苏省苏州市",
"861335530", "山东省菏泽市",
"861354611", "山西省太原市",
"861320675", "黑龙江省哈尔滨市",
"861532522", "浙江省绍兴市",
"861816618", "湖南省怀化市",
"861561548", "山东省泰安市",
"861470720", "湖北省宜昌市",
"861359378", "湖北省荆门市",
"861354181", "四川省达州市",
"861506043", "福建省福州市",
"861328397", "河南省信阳市",
"861357784", "云南省楚雄彝族自治州",
"861889594", "云南省保山市",
"861814253", "四川省乐山市",
"861592964", "陕西省榆林市",
"86182520", "江苏省南京市",
"861355942", "福建省泉州市",
"861700473", "内蒙古包头市",
"861392143", "江苏省南京市",
"861321185", "云南省昭通市",
"861881540", "广西玉林市",
"861893553", "青海省黄南藏族自治州",
"861453463", "黑龙江省大兴安岭地区",
"861332588", "浙江省宁波市",
"861583097", "河北省石家庄市",
"861340708", "江西省南昌市",
"861808284", "新疆昌吉回族自治州",
"86182542", "山东省青岛市",
"86183258", "安徽省阜阳市",
"861772950", "陕西省西安市",
"861823049", "河北省邢台市",
"861365356", "山西省晋城市",
"86184070", "江西省南昌市",
"861818962", "甘肃省张掖市",
"861332904", "安徽省合肥市",
"861359339", "山西省吕梁市",
"861327846", "吉林省白城市",
"861530581", "浙江省杭州市",
"861522620", "宁夏银川市",
"861321065", "山东省临沂市",
"861325632", "山东省枣庄市",
"861389709", "青海省海西蒙古族藏族自治州",
"861310792", "福建省福州市",
"86156575", "浙江省绍兴市",
"86131661", "上海市",
"861394851", "内蒙古呼和浩特市",
"861306984", "黑龙江省七台河市",
"86185937", "甘肃省酒泉市",
"861301424", "宁夏吴忠市",
"861774026", "四川省德阳市",
"86180650", "福建省福州市",
"861301204", "河北省沧州市",
"861893274", "河北省石家庄市",
"861502636", "新疆阿克苏地区",
"861829518", "宁夏银川市",
"861586562", "山东省烟台市",
"861327521", "江苏省常州市",
"861870740", "湖南省永州市",
"861317410", "江苏省苏州市",
"861335454", "黑龙江省佳木斯市",
"861370075", "河南省平顶山市",
"861842037", "广东省阳江市",
"86180737", "湖南省益阳市",
"861775400", "安徽省淮南市",
"861567858", "广西玉林市",
"861593179", "河北省保定市",
"861340381", "河南省安阳市",
"861368828", "四川省宜宾市",
"861302161", "山东省烟台市",
"861473664", "云南省昭通市",
"861810143", "江苏省泰州市",
"861850356", "山西省晋城市",
"861888209", "四川省凉山彝族自治州",
"86130022", "天津市",
"861568882", "山东省泰安市",
"861319199", "河北省沧州市",
"861830506", "浙江省湖州市",
"861529972", "新疆克孜勒苏柯尔克孜自治州",
"861329453", "山西省阳泉市",
"861366304", "河南省周口市",
"86157109", "河北省秦皇岛市",
"861819475", "青海省玉树藏族自治州",
"861300022", "上海市",
"861558276", "山西省吕梁市",
"861803445", "河北省唐山市",
"861517130", "湖北省孝感市",
"861770730", "湖南省岳阳市",
"86152354", "山西省晋中市",
"861876115", "江苏省常州市",
"861366491", "广东省江门市",
"86137591", "云南省昆明市",
"861323633", "江苏省连云港市",
"861575995", "福建省南平市",
"861773678", "河北省沧州市",
"861520747", "湖南省永州市",
"86188098", "辽宁省沈阳市",
"861819441", "甘肃省张掖市",
"861700910", "陕西省西安市",
"861361049", "广东省中山市",
"861563698", "黑龙江省大庆市",
"861315816", "贵州省黔南布依族苗族自治州",
"861870728", "湖北省十堰市",
"861582981", "陕西省延安市",
"861865931", "福建省漳州市",
"86130573", "江苏省无锡市",
"861318679", "浙江省舟山市",
"861348298", "河北省秦皇岛市",
"86181108", "安徽省宣城市",
"861524788", "内蒙古锡林郭勒盟",
"861816902", "宁夏石嘴山市",
"861788913", "西藏山南地区",
"861800877", "云南省玉溪市",
"86184543", "山东省滨州市",
"861309498", "江苏省镇江市",
"861804150", "辽宁省丹东市",
"861860591", "福建省福州市",
"861533974", "甘肃省庆阳市",
"861811282", "江苏省镇江市",
"861476841", "山东省临沂市",
"86156259", "广东省佛山市",
"861362515", "江苏省淮安市",
"861560362", "黑龙江省齐齐哈尔市",
"861537845", "四川省眉山市",
"861476526", "河南省郑州市",
"861303997", "黑龙江省哈尔滨市",
"861807587", "湖南省衡阳市",
"861570535", "山东省烟台市",
"86180856", "贵州省铜仁地区",
"86181863", "湖北省黄冈市",
"861338466", "黑龙江省哈尔滨市",
"861839900", "新疆和田地区",
"861871599", "河北省张家口市",
"861567359", "湖南省邵阳市",
"861324722", "湖北省恩施土家族苗族自治州",
"861881528", "浙江省宁波市",
"861454946", "福建省泉州市",
"86151140", "四川省成都市",
"861853269", "河北省保定市",
"861364716", "湖北省荆州市",
"86131800", "河北省石家庄市",
"861310860", "云南省红河哈尼族彝族自治州",
"861593310", "河北省邯郸市",
"861787619", "广东省湛江市",
"861347531", "山东省济南市",
"861317973", "江苏省徐州市",
"861318422", "浙江省杭州市",
"861310344", "山西省太原市",
"861373033", "河北省秦皇岛市",
"861846998", "云南省德宏傣族景颇族自治州",
"861534276", "湖北省黄石市",
"861346789", "湖南省张家界市",
"861888243", "四川省广元市",
"861308568", "浙江省绍兴市",
"861598406", "四川省广元市",
"861318638", "陕西省宝鸡市",
"86156431", "吉林省长春市",
"861801964", "江苏省南通市",
"861530676", "浙江省台州市",
"861452834", "四川省乐山市",
"861339596", "福建省漳州市",
"861370446", "吉林省延边朝鲜族自治州",
"861324241", "广东省深圳市",
"861898166", "四川省巴中市",
"861364395", "河南省漯河市",
"861311088", "福建省福州市",
"86184829", "四川省宜宾市",
"861586084", "福建省福州市",
"861518488", "云南省楚雄彝族自治州",
"861384947", "河南省漯河市",
"86181116", "四川省成都市",
"861561520", "山东省菏泽市",
"861470748", "湖南省长沙市",
"86180783", "广西桂林市",
"861338061", "广东省珠海市",
"861804640", "福建省福州市",
"861853224", "河北省保定市",
"86185749", "湖南省益阳市",
"86185983", "重庆市",
"861380988", "广东省深圳市",
"861880799", "江西省萍乡市",
"861458485", "山东省淄博市",
"861474787", "内蒙古呼和浩特市",
"86153965", "福建省泉州市",
"861510424", "辽宁省朝阳市",
"86189932", "甘肃省定西市",
"861531555", "山东省济南市",
"861857135", "湖北省随州市",
"861535070", "河北省廊坊市",
"861576198", "贵州省遵义市",
"861786895", "云南省昭通市",
"861700347", "天津市",
"86158884", "浙江省温州市",
"861876546", "山东省东营市",
"861476335", "山东省东营市",
"861869777", "河南省南阳市",
"861760932", "甘肃省定西市",
"861570326", "河北省廊坊市",
"861474036", "辽宁省朝阳市",
"861359879", "河南省开封市",
"861823003", "河北省张家口市",
"861768126", "安徽省安庆市",
"861818856", "贵州省铜仁地区",
"861367780", "广西柳州市",
"861536684", "江苏省常州市",
"861835651", "安徽省合肥市",
"86472", "内蒙古包头市",
"861320949", "甘肃省白银市",
"86152086", "贵州省遵义市",
"861474715", "内蒙古通辽市",
"861588136", "四川省宜宾市",
"861332936", "黑龙江省黑河市",
"861876258", "江苏省宿迁市",
"861336434", "吉林省四平市",
"861829993", "新疆哈密地区",
"861389930", "新疆吐鲁番地区",
"861341910", "四川省南充市",
"861814780", "内蒙古巴彦淖尔市",
"861394877", "内蒙古鄂尔多斯市",
"861390150", "江苏省常州市",
"861385283", "江苏省宿迁市",
"861329375", "山西省长治市",
"861334360", "河南省商丘市",
"861537857", "四川省巴中市",
"861587999", "江西省景德镇市",
"861350678", "浙江省宁波市",
"861338827", "四川省乐山市",
"861334844", "福建省三明市",
"86156673", "陕西省渭南市",
"86136283", "重庆市",
"861510916", "陕西省汉中市",
"861773931", "河南省周口市",
"861373393", "河南省平顶山市",
"861819567", "青海省玉树藏族自治州",
"861585670", "安徽省宿州市",
"861809637", "四川省成都市",
"861538785", "江西省赣州市",
"861899816", "广东省珠海市",
"861880754", "广东省汕头市",
"861807146", "湖北省孝感市",
"861873975", "河南省周口市",
"86158905", "河南省周口市",
"861366336", "河北省唐山市",
"861337613", "江苏省南通市",
"861872811", "四川省内江市",
"861862879", "吉林省长春市",
"861778082", "四川省内江市",
"861364035", "广东省揭阳市",
"861372692", "广东省湛江市",
"861583240", "河北省承德市",
"861520755", "广东省深圳市",
"86153492", "陕西省西安市",
"861478539", "贵州省黔西南布依族苗族自治州",
"861777267", "河北省沧州市",
"861815237", "宁夏石嘴山市",
"861511976", "广东省清远市",
"861370895", "山东省青岛市",
"861388661", "湖北省荆州市",
"861830534", "山东省德州市",
"861835141", "江苏省南通市",
"861515726", "浙江省台州市",
"861337063", "山东省日照市",
"861584749", "内蒙古赤峰市",
"861538333", "河北省石家庄市",
"861818497", "西藏林芝地区",
"861508231", "四川省甘孜藏族自治州",
"861309570", "浙江省衢州市",
"861395702", "浙江省衢州市",
"861802172", "江苏省扬州市",
"861362587", "浙江省温州市",
"861500690", "山东省日照市",
"861356300", "山东省聊城市",
"861778162", "四川省攀枝花市",
"861313540", "安徽省合肥市",
"861812150", "江苏省无锡市",
"86189754", "湖南省衡阳市",
"861319552", "安徽省蚌埠市",
"861390640", "山东省济南市",
"861459126", "广西贺州市",
"86150398", "河南省三门峡市",
"861555345", "山东省烟台市",
"86131532", "山东省青岛市",
"861860425", "辽宁省丹东市",
"861317605", "山东省菏泽市",
"861477869", "广东省茂名市",
"861338919", "陕西省铜川市",
"861580471", "内蒙古呼和浩特市",
"861336550", "安徽省滁州市",
"861847128", "湖北省荆门市",
"861826667", "山东省泰安市",
"861470852", "贵州省遵义市",
"861537496", "内蒙古通辽市",
"861582689", "湖北省武汉市",
"861531547", "山东省济宁市",
"861539836", "云南省昭通市",
"861523311", "河北省石家庄市",
"861859656", "福建省泉州市",
"861472655", "四川省雅安市",
"86136324", "广东省广州市",
"86158778", "云南省曲靖市",
"861550489", "内蒙古包头市",
"86185067", "浙江省嘉兴市",
"861770943", "甘肃省白银市",
"861351257", "江苏省徐州市",
"861874063", "陕西省渭南市",
"861378958", "内蒙古巴彦淖尔市",
"86145836", "山东省济南市",
"861350880", "云南省昆明市",
"861363706", "安徽省合肥市",
"861573361", "河北省邯郸市",
"861828480", "四川省乐山市",
"861887241", "湖北省荆门市",
"861894589", "黑龙江省伊春市",
"861515960", "福建省福州市",
"861477824", "广东省深圳市",
"861384955", "河南省平顶山市",
"861350639", "山东省青岛市",
"86137625", "湖南省郴州市",
"861377982", "新疆阿克苏地区",
"861830450", "黑龙江省哈尔滨市",
"861871554", "安徽省淮南市",
"861339025", "辽宁省营口市",
"861322092", "山东省烟台市",
"86156330", "河北省石家庄市",
"861341347", "广东省清远市",
"861588693", "新疆石河子市",
"861376052", "广东省江门市",
"861550842", "四川省泸州市",
"861840558", "安徽省阜阳市",
"861896532", "福建省三明市",
"861846513", "宁夏吴忠市",
"861870933", "甘肃省平凉市",
"861332216", "辽宁省丹东市",
"86187710", "湖北省武汉市",
"861887275", "湖北省黄石市",
"861314161", "湖南省湘西土家族苗族自治州",
"861300976", "黑龙江省佳木斯市",
"86131262", "广东省江门市",
"861598434", "四川省眉山市",
"861521781", "广东省惠州市",
"86135608", "广东省东莞市",
"861567401", "湖南省岳阳市",
"861351902", "甘肃省定西市",
"86182124", "贵州省黔东南苗族侗族自治州",
"861556337", "山东省临沂市",
"861471622", "广东省揭阳市",
"86155892", "山东省枣庄市",
"861318945", "广东省湛江市",
"861577940", "江西省九江市",
"861527274", "湖北省咸宁市",
"861398684", "湖北省恩施土家族苗族自治州",
"861867161", "湖北省荆门市",
"861556408", "山东省滨州市",
"861778529", "贵州省铜仁地区",
"861803896", "广东省茂名市",
"861599719", "湖北省襄樊市",
"861380325", "河北省沧州市",
"861317764", "江西省萍乡市",
"861301916", "吉林省吉林市",
"861556228", "山东省济宁市",
"86138316", "河北省廊坊市",
"861853436", "山西省临汾市",
"861847140", "湖北省十堰市",
"861827179", "湖北省鄂州市",
"861883088", "河北省邯郸市",
"86170878", "江苏省徐州市",
"861707767", "云南省玉溪市",
"86133410", "北京市",
"861390628", "江苏省南通市",
"861314486", "广东省东莞市",
"86152741", "湖南省郴州市",
"861576660", "广东省汕头市",
"861864729", "内蒙古乌海市",
"861886031", "河南省许昌市",
"861591172", "云南省昆明市",
"86159408", "辽宁省大连市",
"861535890", "江苏省盐城市",
"861776102", "四川省绵阳市",
"86145088", "上海市",
"861390432", "吉林省长春市",
"861354827", "四川省达州市",
"861815917", "福建省泉州市",
"861514636", "黑龙江省大庆市",
"861319154", "内蒙古通辽市",
"861476250", "江苏省淮安市",
"86132713", "河南省南阳市",
"861338278", "江苏省南京市",
"861320903", "新疆和田地区",
"861802574", "广东省潮州市",
"861564992", "河南省商丘市",
"861590682", "浙江省湖州市",
"861333791", "江苏省无锡市",
"861869751", "安徽省蚌埠市",
"861313528", "湖南省长沙市",
"861512047", "甘肃省临夏回族自治州",
"861317729", "湖北省孝感市",
"861569474", "内蒙古乌兰察布市",
"861583408", "山西省忻州市",
"861596919", "云南省西双版纳傣族自治州",
"861809958", "新疆巴音郭楞蒙古自治州",
"861868795", "云南省丽江市",
"861831953", "广东省湛江市",
"86155050", "安徽省安庆市",
"861514193", "辽宁省辽阳市",
"861508911", "广东省汕头市",
"861709647", "山东省烟台市",
"86189440", "江苏省南京市",
"86183827", "四川省巴中市",
"86152838", "四川省德阳市",
"861360965", "广东省肇庆市",
"86159416", "辽宁省锦州市",
"861356823", "四川省德阳市",
"8613121", "北京市",
"861567006", "河南省鹤壁市",
"861763327", "河北省沧州市",
"861396333", "山东省日照市",
"861458100", "安徽省亳州市",
"861529421", "甘肃省兰州市",
"861589907", "新疆昌吉回族自治州",
"861346312", "河北省保定市",
"861321687", "浙江省丽水市",
"861583337", "河北省沧州市",
"861815864", "浙江省台州市",
"861576010", "四川省乐山市",
"861529201", "湖南省岳阳市",
"86138308", "甘肃省天水市",
"861380536", "山东省潍坊市",
"861863400", "河北省唐山市",
"86189062", "江苏省苏州市",
"861770909", "四川省德阳市",
"861771440", "江苏省南京市",
"861800851", "贵州省贵阳市",
"861539376", "河南省安阳市",
"861862378", "河南省开封市",
"861564575", "黑龙江省鹤岗市",
"861816245", "湖北省黄冈市",
"861858982", "广西柳州市",
"861567742", "广西梧州市",
"861471479", "广东省揭阳市",
"86130675", "浙江省嘉兴市",
"861343757", "广东省茂名市",
"861565984", "福建省三明市",
"861882934", "陕西省西安市",
"861311690", "云南省迪庆藏族自治州",
"86135616", "山东省淄博市",
"861569012", "河北省沧州市",
"861303674", "湖南省邵阳市",
"861552586", "山西省运城市",
"861889559", "安徽省马鞍山市",
"861319644", "江苏省常州市",
"861470419", "辽宁省辽阳市",
"861538873", "云南省红河哈尼族彝族自治州",
"861800097", "广东省湛江市",
"861853031", "河南省濮阳市",
"86156921", "上海市",
"861533763", "浙江省嘉兴市",
"861342105", "广东省潮州市",
"861584703", "内蒙古呼伦贝尔市",
"861308219", "河北省沧州市",
"861361587", "浙江省温州市",
"861370956", "宁夏石嘴山市",
"861836805", "浙江省舟山市",
"861588039", "福建省龙岩市",
"86157563", "四川省成都市",
"861534990", "新疆克拉玛依市",
"86182337", "河北省沧州市",
"861811150", "四川省德阳市",
"861475607", "河北省廊坊市",
"861380352", "江西省南昌市",
"861871753", "陕西省延安市",
"86147955", "广西南宁市",
"861571265", "浙江省台州市",
"861700480", "福建省泉州市",
"861350093", "吉林省白山市",
"861533082", "辽宁省大连市",
"861768029", "湖南省益阳市",
"861347190", "广西玉林市",
"861773785", "河南省许昌市",
"861816751", "新疆阿克苏地区",
"86137548", "山西省太原市",
"861532547", "浙江省湖州市",
"861800682", "浙江省湖州市",
"861581689", "广东省深圳市",
"861454456", "江西省吉安市",
"861348734", "湖南省衡阳市",
"861858894", "广东省广州市",
"861814817", "四川省内江市",
"861320494", "湖南省娄底市",
"861354758", "四川省南充市",
"861538931", "陕西省宝鸡市",
"861477886", "广东省茂名市",
"861807049", "江西省南昌市",
"861553972", "河南省洛阳市",
"861353453", "广东省揭阳市",
"861776703", "浙江省舟山市",
"861319876", "四川省自贡市",
"861769915", "新疆吐鲁番地区",
"86184382", "河南省商丘市",
"861589772", "湖北省孝感市",
"861303846", "陕西省汉中市",
"861591773", "广东省东莞市",
"861567653", "广西百色市",
"86138651", "安徽省安庆市",
"861830385", "河南省开封市",
"861554211", "辽宁省朝阳市",
"861806827", "江苏省无锡市",
"861884674", "黑龙江省鸡西市",
"861860927", "陕西省宝鸡市",
"861881214", "河北省承德市",
"861506532", "山东省青岛市",
"861808434", "贵州省黔东南苗族侗族自治州",
"861582666", "湖北省恩施土家族苗族自治州",
"861471516", "广东省东莞市",
"861872554", "安徽省淮南市",
"861373144", "河北省承德市",
"861321092", "山东省烟台市",
"861470576", "浙江省台州市",
"861573963", "新疆昌吉回族自治州",
"861318373", "四川省凉山彝族自治州",
"861550611", "江苏省宿迁市",
"861770341", "山西省太原市",
"86137997", "福建省厦门市",
"861303521", "湖北省襄樊市",
"861818995", "西藏昌都地区",
"861809719", "青海省海西蒙古族藏族自治州",
"861395659", "安徽省宣城市",
"861539010", "四川省阿坝藏族羌族自治州",
"861568959", "山东省临沂市",
"861566510", "江苏省泰州市",
"861325387", "河南省焦作市",
"861331936", "江西省宜春市",
"861879978", "新疆伊犁哈萨克自治州",
"86189285", "广东省佛山市",
"861564884", "内蒙古赤峰市",
"861300047", "北京市",
"861355819", "广西南宁市",
"861577506", "广东省湛江市",
"861514792", "内蒙古巴彦淖尔市",
"861590851", "贵州省贵阳市",
"861821861", "广东省肇庆市",
"861830733", "湖南省株洲市",
"861473800", "河南省南阳市",
"861869245", "湖南省郴州市",
"861384896", "内蒙古赤峰市",
"86151621", "江苏省徐州市",
"861334581", "浙江省杭州市",
"861582016", "广东省河源市",
"861880553", "安徽省芜湖市",
"861537740", "湖南省岳阳市",
"86150440", "吉林省长春市",
"861868507", "贵州省黔南布依族苗族自治州",
"86185475", "内蒙古通辽市",
"861788802", "西藏日喀则地区",
"861816813", "江苏省连云港市",
"861810858", "贵州省六盘水市",
"861367964", "四川省眉山市",
"861325950", "宁夏银川市",
"861860819", "四川省南充市",
"861870871", "云南省昆明市",
"861381478", "江苏省常州市",
"86137677", "江西省赣州市",
"861452761", "广西南宁市",
"86183302", "河北省保定市",
"86136183", "重庆市",
"861898911", "四川省内江市",
"861780260", "江苏省苏州市",
"86150422", "辽宁省鞍山市",
"861880367", "河南省安阳市",
"861814964", "福建省莆田市",
"861380418", "辽宁省阜新市",
"861586972", "湖南省株洲市",
"861705681", "湖北省黄冈市",
"861368745", "广东省揭阳市",
"86150062", "江苏省苏州市",
"861512976", "陕西省汉中市",
"861779903", "新疆和田地区",
"861533162", "云南省临沧市",
"861373991", "内蒙古呼和浩特市",
"861872430", "黑龙江省牡丹江市",
"861351777", "广西钦州市",
"861459064", "广东省云浮市",
"861395149", "江苏省连云港市",
"86180416", "辽宁省锦州市",
"861871811", "广东省韶关市",
"861323378", "河南省信阳市",
"861318833", "辽宁省阜新市",
"861522437", "山东省滨州市",
"86137380", "浙江省杭州市",
"86151973", "湖南省株洲市",
"861533564", "内蒙古乌兰察布市",
"861872642", "安徽省安庆市",
"861837535", "安徽省安庆市",
"861584504", "黑龙江省哈尔滨市",
"861308939", "吉林省白山市",
"861322687", "广东省深圳市",
"86153582", "江苏省盐城市",
"861538211", "辽宁省沈阳市",
"861874782", "内蒙古巴彦淖尔市",
"861524151", "辽宁省锦州市",
"861399487", "山西省运城市",
"861829269", "陕西省商洛市",
"861562256", "广东省清远市",
"861810034", "山西省太原市",
"861508313", "河南省新乡市",
"86180897", "海南省海口市",
"861555107", "安徽省马鞍山市",
"861368771", "广西南宁市",
"86177296", "重庆市",
"861776749", "新疆阿克苏地区",
"861355318", "山东省济南市",
"861329943", "广西桂林市",
"861518279", "四川省巴中市",
"861523470", "山西省临汾市",
"861520722", "湖北省武汉市",
"861879219", "安徽省合肥市",
"861589225", "四川省广元市",
"861803955", "河南省郑州市",
"861323879", "云南省普洱市",
"861859003", "陕西省宝鸡市",
"861537728", "湖北省随州市",
"861861378", "河南省开封市",
"861343840", "四川省绵阳市",
"861364362", "山西省大同市",
"861359196", "辽宁省葫芦岛市",
"861328769", "山东省潍坊市",
"861360467", "黑龙江省大庆市",
"861580310", "河北省邯郸市",
"861533529", "江苏省苏州市",
"861453510", "山东省济南市",
"861860318", "河北省衡水市",
"861521935", "广东省阳江市",
"861810359", "山西省运城市",
"86184528", "江苏省南京市",
"861581370", "广东省深圳市",
"861341105", "广东省汕尾市",
"861337782", "湖北省十堰市",
"861820999", "新疆伊犁哈萨克自治州",
"861322248", "江苏省泰州市",
"861320788", "广西河池市",
"861565926", "福建省厦门市",
"861829404", "甘肃省平凉市",
"861811432", "江苏省常州市",
"86182383", "河南省濮阳市",
"86188853", "贵州省安顺市",
"861576836", "广东省深圳市",
"861580947", "甘肃省定西市",
"861504589", "黑龙江省大庆市",
"861802773", "广东省韶关市",
"861535083", "河北省衡水市",
"861889085", "新疆博尔塔拉蒙古自治州",
"861518602", "贵州省铜仁地区",
"861826192", "江苏省南京市",
"861860452", "黑龙江省齐齐哈尔市",
"861822042", "陕西省榆林市",
"861306414", "江西省南昌市",
"861334676", "河南省信阳市",
"861779949", "新疆伊犁哈萨克自治州",
"861700322", "河北省保定市",
"861815415", "安徽省滁州市",
"861560395", "河南省漯河市",
"861379550", "四川省眉山市",
"86131162", "云南省昆明市",
"861330276", "广东省揭阳市",
"861327997", "新疆阿克苏地区",
"86183875", "云南省德宏傣族景颇族自治州",
"861319525", "贵州省黔东南苗族侗族自治州",
"861372087", "福建省厦门市",
"861314469", "黑龙江省双鸭山市",
"861770375", "河南省平顶山市",
"861524641", "黑龙江省七台河市",
"861760650", "浙江省杭州市",
"861302916", "吉林省吉林市",
"861518327", "四川省内江市",
"861563893", "河南省郑州市",
"861567109", "湖北省荆门市",
"861387291", "湖北省荆门市",
"861399731", "青海省西宁市",
"861870331", "河北省石家庄市",
"86151693", "山东省淄博市",
"861890690", "福建省福州市",
"861308978", "黑龙江省双鸭山市",
"861867424", "湖北省荆门市",
"86185531", "山东省济南市",
"861366552", "安徽省蚌埠市",
"861333040", "云南省红河哈尼族彝族自治州",
"861806239", "湖北省宜昌市",
"861339052", "辽宁省大连市",
"86138576", "浙江省台州市",
"861320301", "湖南省岳阳市",
"861392359", "广东省汕尾市",
"861384922", "河南省鹤壁市",
"861705576", "黑龙江省大庆市",
"86186329", "河北省邢台市",
"861335191", "黑龙江省哈尔滨市",
"86130627", "上海市",
"861846714", "青海省玉树藏族自治州",
"861318447", "浙江省温州市",
"861314424", "广东省江门市",
"861479970", "新疆乌鲁木齐市",
"861317980", "新疆乌鲁木齐市",
"861306072", "广东省梅州市",
"86189398", "上海市",
"861839187", "陕西省宝鸡市",
"861894290", "湖北省武汉市",
"861458235", "安徽省滁州市",
"861801574", "四川省泸州市",
"861316050", "广东省阳江市",
"86139759", "湖南省邵阳市",
"861331489", "内蒙古呼和浩特市",
"861599704", "青海省海南藏族自治州",
"86158323", "河北省张家口市",
"86182712", "湖北省襄樊市",
"861886748", "湖南省衡阳市",
"861537510", "安徽省巢湖市",
"861769834", "河南省安阳市",
"861515554", "安徽省淮北市",
"861365705", "江西省宜春市",
"861336929", "陕西省延安市",
"861354588", "湖北省武汉市",
"861894238", "江西省鹰潭市",
"86186477", "内蒙古鄂尔多斯市",
"861310166", "黑龙江省哈尔滨市",
"861813538", "山西省太原市",
"861871960", "甘肃省平凉市",
"861785842", "浙江省杭州市",
"861890638", "山东省烟台市",
"861567626", "广西柳州市",
"861562449", "山东省淄博市",
"861554522", "黑龙江省齐齐哈尔市",
"861332611", "浙江省丽水市",
"861773461", "陕西省宝鸡市",
"861787636", "广东省梅州市",
"861588981", "广东省潮州市",
"861829825", "安徽省芜湖市",
"861566740", "陕西省宝鸡市",
"861337644", "山东省济南市",
"861890422", "辽宁省鞍山市",
"861301700", "贵州省铜仁地区",
"861534657", "河南省郑州市",
"861313887", "广东省深圳市",
"861328332", "河北省张家口市",
"861364739", "湖南省邵阳市",
"86189000", "北京市",
"861577474", "内蒙古乌兰察布市",
"861454423", "江苏省常州市",
"861880335", "河北省秦皇岛市",
"861593531", "山西省大同市",
"861347310", "河北省邯郸市",
"861315878", "四川省资阳市",
"86157721", "贵州省遵义市",
"861820970", "青海省海北藏族自治州",
"861840949", "甘肃省兰州市",
"861850705", "江西省宜春市",
"861310481", "广东省云浮市",
"861800392", "河南省鹤壁市",
"861589869", "山东省菏泽市",
"861342861", "广东省东莞市",
"861454203", "河南省郑州市",
"861500455", "黑龙江省绥化市",
"86156859", "贵州省黔西南布依族苗族自治州",
"86135374", "广东省东莞市",
"861573750", "河南省周口市",
"861579742", "湖北省荆州市",
"86181263", "广东省深圳市",
"861396522", "安徽省铜陵市",
"861334813", "江苏省扬州市",
"861323890", "辽宁省朝阳市",
"861370923", "陕西省渭南市",
"861520334", "河北省秦皇岛市",
"861450603", "吉林省松原市",
"861350547", "山东省济宁市",
"861362329", "河北省邢台市",
"861553346", "河北省唐山市",
"861332466", "陕西省商洛市",
"861510631", "山东省威海市",
"861821910", "广东省湛江市",
"861528648", "贵州省六盘水市",
"861500561", "安徽省淮北市",
"861875976", "福建省漳州市",
"861571237", "辽宁省大连市",
"861309280", "四川省凉山彝族自治州",
"861362277", "广东省肇庆市",
"861334751", "广西南宁市",
"861348480", "陕西省西安市",
"861883447", "山西省运城市",
"86131200", "北京市",
"861305933", "广东省云浮市",
"86147698", "山东省德州市",
"861880783", "广西桂林市",
"861592406", "浙江省衢州市",
"861302568", "广东省茂名市",
"861557673", "湖南省衡阳市",
"861770914", "陕西省商洛市",
"861315839", "贵州省黔西南布依族苗族自治州",
"861363473", "内蒙古阿拉善盟",
"861569940", "新疆阿克苏地区",
"861347947", "江西省赣州市",
"86147142", "广东省广州市",
"861771974", "陕西省延安市",
"861339729", "湖北省十堰市",
"861889948", "新疆塔城地区",
"86155623", "山东省济宁市",
"861806493", "四川省遂宁市",
"861579401", "广东省广州市",
"861571328", "河北省衡水市",
"861315680", "山东省东营市",
"861853748", "河南省漯河市",
"861596904", "云南省德宏傣族景颇族自治州",
"861777100", "湖北省襄樊市",
"861556032", "内蒙古鄂尔多斯市",
"86184229", "上海市",
"86186910", "陕西省咸阳市",
"861700734", "湖南省衡阳市",
"861315110", "江苏省扬州市",
"861813579", "河南省郑州市",
"861310737", "湖南省益阳市",
"861530618", "江苏省无锡市",
"861838409", "四川省南充市",
"861325763", "河北省保定市",
"861332061", "四川省巴中市",
"861576942", "甘肃省定西市",
"861809549", "宁夏银川市",
"861590543", "山东省滨州市",
"861817778", "广西钦州市",
"861390008", "贵州省贵阳市",
"861880526", "江苏省泰州市",
"861346793", "湖南省湘潭市",
"861586346", "山东省青岛市",
"861452485", "内蒙古巴彦淖尔市",
"861527612", "新疆喀什地区",
"86185458", "黑龙江省哈尔滨市",
"86139423", "辽宁省抚顺市",
"861310086", "黑龙江省黑河市",
"861880841", "四川省遂宁市",
"861364778", "广西河池市",
"861478647", "湖南省永州市",
"861471746", "江西省赣州市",
"861829681", "江西省景德镇市",
"861354904", "西藏林芝地区",
"861339764", "湖南省长沙市",
"861356174", "山东省莱芜市",
"861528158", "四川省甘孜藏族自治州",
"861344013", "四川省雅安市",
"861890679", "浙江省金华市",
"861300593", "广西柳州市",
"86138674", "浙江省杭州市",
"861808780", "云南省楚雄彝族自治州",
"861571829", "广东省阳江市",
"861560546", "山东省东营市",
"86939", "甘肃省陇南市",
"861820413", "辽宁省抚顺市",
"861303932", "吉林省长春市",
"861872498", "云南省大理白族自治州",
"861475734", "浙江省宁波市",
"861311561", "黑龙江省哈尔滨市",
"861502619", "新疆昌吉回族自治州",
"861340444", "吉林省白城市",
"861363347", "山西省太原市",
"861315407", "陕西省商洛市",
"861894918", "安徽省宿州市",
"861383995", "河南省开封市",
"861565953", "福建省漳州市",
"861365472", "内蒙古包头市",
"861356572", "新疆伊犁哈萨克自治州",
"86155971", "青海省西宁市",
"861330524", "江苏省宿迁市",
"861315227", "陕西省铜川市",
"861450649", "黑龙江省伊春市",
"861898792", "云南省普洱市",
"861887585", "浙江省丽水市",
"861520874", "云南省曲靖市",
"86158391", "河南省焦作市",
"861780831", "四川省宜宾市",
"861705269", "广东省深圳市",
"86155704", "湖北省襄樊市",
"861317025", "安徽省合肥市",
"861311455", "黑龙江省绥化市",
"861889766", "广西钦州市",
"861521814", "广东省阳江市",
"86186282", "四川省成都市",
"861821473", "安徽省合肥市",
"861880875", "云南省保山市",
"861534979", "青海省海西蒙古族藏族自治州",
"861560821", "四川省成都市",
"861840903", "新疆和田地区",
"861557242", "湖北省恩施土家族苗族自治州",
"861309627", "四川省雅安市",
"861315338", "山东省淄博市",
"861882672", "广东省阳江市",
"861390962", "安徽省蚌埠市",
"86150904", "河南省新乡市",
"861337552", "山东省日照市",
"861831984", "广东省东莞市",
"861597745", "广西南宁市",
"861328872", "广东省云浮市",
"861889920", "新疆阿克苏地区",
"86151307", "河北省沧州市",
"86133150", "河北省邯郸市",
"861850472", "内蒙古包头市",
"861571864", "贵州省黔南布依族苗族自治州",
"861510700", "江西省鹰潭市",
"861323762", "江西省九江市",
"861801406", "江苏省扬州市",
"861357627", "江西省南昌市",
"861836204", "江苏省镇江市",
"861594572", "黑龙江省牡丹江市",
"86157793", "江西省上饶市",
"861322397", "河南省濮阳市",
"861319063", "内蒙古乌兰察布市",
"861330569", "安徽省合肥市",
"861834050", "辽宁省葫芦岛市",
"861355198", "四川省甘孜藏族自治州",
"861320558", "安徽省阜阳市",
"861458267", "安徽省芜湖市",
"861398143", "四川省内江市",
"861471968", "甘肃省庆阳市",
"861705224", "内蒙古包头市",
"861554089", "内蒙古包头市",
"861519496", "河北省保定市",
"861569928", "新疆巴音郭楞蒙古自治州",
"861768752", "广西柳州市",
"861457082", "江苏省南京市",
"86139909", "四川省宜宾市",
"861338588", "浙江省丽水市",
"861887156", "湖北省襄樊市",
"861800744", "湖南省张家界市",
"86150771", "广西南宁市",
"861802284", "广东省茂名市",
"861378549", "河北省沧州市",
"861335311", "吉林省长春市",
"861509721", "甘肃省酒泉市",
"861780345", "山西省朔州市",
"861778950", "甘肃省临夏回族自治州",
"861833176", "河北省沧州市",
"861327650", "江苏省淮安市",
"861308486", "陕西省延安市",
"861760997", "新疆阿克苏地区",
"861571917", "陕西省宝鸡市",
"861554169", "辽宁省朝阳市",
"861504759", "内蒙古鄂尔多斯市",
"861324517", "内蒙古乌兰察布市",
"86159156", "广东省揭阳市",
"861570977", "青海省玉树藏族自治州",
"861319183", "河北省秦皇岛市",
"86185519", "江苏省常州市",
"861477173", "湖北省孝感市",
"861809503", "四川省自贡市",
"861890380", "河南省新乡市",
"861379780", "湖北省咸宁市",
"861501737", "广东省湛江市",
"86155691", "新疆喀什地区",
"861319613", "吉林省松原市",
"861769267", "河北省邢台市",
"861360435", "吉林省通化市",
"861331842", "广东省中山市",
"861869360", "甘肃省张掖市",
"86177143", "江苏省南京市",
"86181533", "湖南省永州市",
"861850664", "广东省茂名市",
"86177736", "湖南省常德市",
"861308161", "山东省烟台市",
"861530902", "四川省德阳市",
"861453740", "湖南省岳阳市",
"861363910", "贵州省贵阳市",
"861365629", "江苏省南通市",
"861366782", "广西柳州市",
"861581261", "广东省珠海市",
"861534938", "甘肃省天水市",
"861597623", "广东省惠州市",
"861560685", "浙江省绍兴市",
"86136019", "上海市",
"861594995", "山东省枣庄市",
"861887646", "福建省泉州市",
"861572415", "广东省梅州市",
"861581898", "广东省珠海市",
"86137249", "广东省佛山市",
"861771195", "西藏昌都地区",
"861521967", "广东省云浮市",
"861893250", "河北省唐山市",
"861804572", "黑龙江省七台河市",
"861311638", "贵州省六盘水市",
"861372382", "湖南省衡阳市",
"861358245", "河北省秦皇岛市",
"861301568", "福建省三明市",
"861586634", "山东省莱芜市",
"861339563", "安徽省宣城市",
"861364617", "江苏省无锡市",
"861572237", "青海省海西蒙古族藏族自治州",
"861317052", "云南省楚雄彝族自治州",
"86147220", "天津市",
"861316982", "广东省江门市",
"86131100", "天津市",
"861300794", "宁夏固原市",
"86151840", "辽宁省葫芦岛市",
"861367550", "安徽省滁州市",
"861325564", "山东省威海市",
"861335233", "辽宁省辽阳市",
"86189771", "广西南宁市",
"86186425", "辽宁省丹东市",
"861590744", "湖南省张家界市",
"86181816", "四川省宜宾市",
"861826635", "山东省聊城市",
"861809015", "四川省泸州市",
"861307507", "安徽省亳州市",
"861570046", "四川省广元市",
"861530777", "广西钦州市",
"861584519", "黑龙江省佳木斯市",
"861879469", "甘肃省天水市",
"861555596", "安徽省阜阳市",
"861855148", "江苏省南通市",
"86135565", "广东省肇庆市",
"861310024", "湖南省张家界市",
"861459643", "甘肃省陇南市",
"86152917", "陕西省宝鸡市",
"861511342", "广东省韶关市",
"861550936", "甘肃省张掖市",
"861558305", "四川省阿坝藏族羌族自治州",
"861570702", "江西省九江市",
"86134337", "广东省潮州市",
"861538461", "陕西省延安市",
"861700533", "山东省淄博市",
"861331061", "山东省济南市",
"861520585", "浙江省绍兴市",
"861532678", "内蒙古巴彦淖尔市",
"861360148", "江苏省无锡市",
"861452350", "河南省鹤壁市",
"861347445", "陕西省渭南市",
"86158184", "广东省东莞市",
"861840494", "山西省长治市",
"861339357", "山西省临汾市",
"861818823", "贵州省黔西南布依族苗族自治州",
"861863397", "河北省唐山市",
"861325529", "江苏省南京市",
"861862762", "湖南省娄底市",
"861880584", "浙江省宁波市",
"861335470", "内蒙古呼伦贝尔市",
"861773089", "河南省新乡市",
"861337525", "江苏省盐城市",
"861879424", "甘肃省兰州市",
"861536394", "广东省茂名市",
"861472746", "贵州省黔西南布依族苗族自治州",
"861538555", "安徽省马鞍山市",
"861336780", "广西南宁市",
"861532880", "四川省宜宾市",
"861330671", "浙江省杭州市",
"861566091", "河南省商丘市",
"861539591", "福建省福州市",
"861880908", "新疆克孜勒苏柯尔克孜自治州",
"861353484", "广东省江门市",
"861332489", "广西北海市",
"861305845", "广东省揭阳市",
"86187244", "黑龙江省绥化市",
"861816844", "江苏省连云港市",
"861363105", "广东省清远市",
"861361840", "湖南省岳阳市",
"861553634", "山西省太原市",
"861831892", "广东省惠州市",
"861306229", "福建省莆田市",
"861500957", "宁夏中卫市",
"861304373", "河南省新乡市",
"861506800", "浙江省舟山市",
"86139581", "浙江省杭州市",
"861597251", "湖北省咸宁市",
"861367434", "吉林省四平市",
"861884932", "河北省张家口市",
"861333912", "安徽省铜陵市",
"861855658", "安徽省池州市",
"861520646", "山东省潍坊市",
"861560900", "四川省自贡市",
"861591001", "山东省济宁市",
"861319782", "江西省抚州市",
"861532639", "吉林省松原市",
"861846709", "青海省海西蒙古族藏族自治州",
"861324306", "河南省开封市",
"861818282", "黑龙江省齐齐哈尔市",
"861889801", "西藏拉萨市",
"861459153", "广西河池市",
"86135514", "四川省达州市",
"861370321", "河北省石家庄市",
"861859623", "山东省临沂市",
"861509098", "湖北省鄂州市",
"861364258", "广东省韶关市",
"861775037", "福建省龙岩市",
"861817067", "江西省赣州市",
"861318168", "山东省潍坊市",
"861471490", "广东省深圳市",
"861800509", "福建省南平市",
"861823828", "河南省信阳市",
"861399048", "四川省甘孜藏族自治州",
"861768643", "山东省青岛市",
"861815265", "湖南省常德市",
"861361329", "河北省邢台市",
"861808817", "云南省德宏傣族景颇族自治州",
"86158755", "广东省深圳市",
"861780973", "青海省黄南藏族自治州",
"861573847", "河南省南阳市",
"86138852", "贵州省遵义市",
"861331466", "黑龙江省齐齐哈尔市",
"861337336", "河北省廊坊市",
"86152470", "内蒙古呼伦贝尔市",
"861360658", "浙江省宁波市",
"86181163", "上海市",
"86180156", "江苏省苏州市",
"861877271", "湖北省荆门市",
"861867219", "湖北省武汉市",
"861894759", "内蒙古呼伦贝尔市",
"861775786", "浙江省宁波市",
"861310189", "江苏省南京市",
"861823364", "河北省廊坊市",
"861707383", "河南省商丘市",
"861521465", "黑龙江省七台河市",
"861580863", "云南省昭通市",
"861856971", "湖南省湘西土家族苗族自治州",
"861590392", "河南省鹤壁市",
"861347076", "安徽省阜阳市",
"861502086", "山东省莱芜市",
"861823840", "河南省南阳市",
"861848769", "云南省迪庆藏族自治州",
"861890455", "黑龙江省绥化市",
"861572917", "河南省南阳市",
"861829852", "甘肃省临夏回族自治州",
"861850597", "福建省龙岩市",
"861554555", "黑龙江省绥化市",
"861329914", "陕西省商洛市",
"861825157", "江苏省无锡市",
"861813661", "江苏省扬州市",
"861535339", "陕西省渭南市",
"861374951", "河南省焦作市",
"861314978", "辽宁省锦州市",
"861396616", "安徽省宣城市",
"861868633", "吉林省延边朝鲜族自治州",
"861502737", "湖北省咸宁市",
"861521551", "安徽省合肥市",
"861534305", "湖南省郴州市",
"861890561", "安徽省淮北市",
"861370294", "广东省珠海市",
"861840788", "江西省萍乡市",
"861325082", "浙江省杭州市",
"861569506", "宁夏石嘴山市",
"861881464", "黑龙江省牡丹江市",
"861308424", "河南省开封市",
"86159256", "浙江省杭州市",
"861300342", "江苏省南京市",
"86188999", "上海市",
"86132528", "辽宁省沈阳市",
"861335913", "陕西省渭南市",
"861857704", "广西南宁市",
"861304447", "山西省阳泉市",
"86185379", "河南省洛阳市",
"861379929", "福建省厦门市",
"861459609", "宁夏中卫市",
"861813416", "河北省唐山市",
"861504238", "辽宁省抚顺市",
"861593668", "河南省安阳市",
"861844747", "内蒙古乌兰察布市",
"861833038", "河北省秦皇岛市",
"861767903", "江西省上饶市",
"86176013", "上海市",
"861570475", "内蒙古通辽市",
"861396555", "安徽省阜阳市",
"86513", "江苏省南通市",
"861536742", "湖南省长沙市",
"861809704", "青海省海南藏族自治州",
"861332842", "福建省泉州市",
"861345539", "山东省德州市",
"86188466", "黑龙江省大庆市",
"861330645", "山东省烟台市",
"861517010", "江西省鹰潭市",
"861453857", "甘肃省平凉市",
"861836081", "江苏省无锡市",
"861500422", "辽宁省锦州市",
"861881429", "广东省湛江市",
"861508344", "河南省南阳市",
"861887059", "江西省萍乡市",
"861571415", "辽宁省丹东市",
"861855937", "福建省宁德市",
"861772195", "四川省成都市",
"861582898", "四川省遂宁市",
"861453091", "山西省阳泉市",
"861522967", "陕西省宝鸡市",
"861886989", "云南省保山市",
"861500638", "山东省聊城市",
"861510568", "安徽省阜阳市",
"86184557", "安徽省宿州市",
"861500202", "广东省广州市",
"861881209", "河北省邢台市",
"861308469", "浙江省丽水市",
"861380891", "山东省烟台市",
"861345578", "山东省滨州市",
"861840301", "河北省石家庄市",
"861572829", "广东省珠海市",
"861376729", "江西省新余市",
"861328556", "安徽省安庆市",
"861504279", "辽宁省盘锦市",
"861470993", "新疆石河子市",
"861312561", "辽宁省营口市",
"861337876", "云南省文山壮族苗族自治州",
"861880612", "江苏省常州市",
"86188679", "浙江省金华市",
"861871498", "安徽省六安市",
"861800543", "山东省滨州市",
"861372200", "内蒙古呼伦贝尔市",
"861380268", "广东省佛山市",
"861563925", "河南省郑州市",
"861333232", "辽宁省阜新市",
"86180048", "内蒙古呼和浩特市",
"861881672", "广东省梅州市",
"861330586", "浙江省台州市",
"861380057", "浙江省杭州市",
"861347471", "内蒙古呼和浩特市",
"861354493", "广东省珠海市",
"861533387", "河南省周口市",
"861355804", "广西梧州市",
"861312455", "黑龙江省绥化市",
"86133303", "重庆市",
"86188401", "辽宁省锦州市",
"861807771", "广西钦州市",
"861329867", "湖南省永州市",
"861889789", "广西柳州市",
"861306443", "河南省安阳市",
"861321397", "河南省开封市",
"86136797", "广东省佛山市",
"861853989", "河南省商丘市",
"861868196", "陕西省渭南市",
"861535378", "陕西省咸阳市",
"861368003", "广东省清远市",
"861353798", "广东省阳江市",
"861568548", "贵州省六盘水市",
"861356856", "四川省宜宾市",
"861330155", "江苏省苏州市",
"861832984", "陕西省榆林市",
"861559530", "宁夏银川市",
"86134078", "广西柳州市",
"86151646", "黑龙江省齐齐哈尔市",
"861453496", "内蒙古赤峰市",
"861325162", "黑龙江省齐齐哈尔市",
"861572864", "广东省深圳市",
"861831926", "广东省梅州市",
"861860804", "四川省成都市",
"86135235", "河南省郑州市",
"861852412", "辽宁省鞍山市",
"861383497", "山西省朔州市",
"86181497", "上海市",
"861801284", "江苏省镇江市",
"86181610", "四川省绵阳市",
"861330723", "湖北省黄石市",
"86130658", "浙江省宁波市",
"861555260", "山东省德州市",
"861533950", "贵州省贵阳市",
"86152138", "甘肃省庆阳市",
"86183461", "黑龙江省哈尔滨市",
"861396547", "安徽省六安市",
"861829748", "安徽省宣城市",
"861860376", "河南省信阳市",
"86138363", "黑龙江省牡丹江市",
"861558569", "吉林省通化市",
"861893526", "山西省晋城市",
"861709746", "广东省东莞市",
"861528437", "河北省沧州市",
"861453845", "四川省巴中市",
"861885249", "江苏省无锡市",
"861560739", "湖南省邵阳市",
"861579727", "湖北省黄石市",
"861557878", "广西北海市",
"861776891", "江苏省宿迁市",
"86183418", "辽宁省阜新市",
"861768901", "西藏拉萨市",
"861322724", "湖北省十堰市",
"861820560", "安徽省合肥市",
"861576130", "贵州省黔东南苗族侗族自治州",
"861302939", "辽宁省鞍山市",
"861334068", "四川省资阳市",
"861350522", "江苏省徐州市",
"861878642", "贵州省黔东南苗族侗族自治州",
"861336574", "安徽省合肥市",
"861309554", "安徽省淮南市",
"861500971", "青海省西宁市",
"861550588", "浙江省杭州市",
"861367226", "江西省九江市",
"861830012", "广东省梅州市",
"861568256", "四川省成都市",
"861321786", "广西百色市",
"86132766", "江苏省南京市",
"861597277", "湖北省随州市",
"861532211", "广东省江门市",
"861331239", "贵州省六盘水市",
"861812174", "江苏省泰州市",
"86158348", "吉林省松原市",
"86177896", "甘肃省兰州市",
"861893841", "广东省湛江市",
"861329021", "山东省临沂市",
"861537244", "浙江省杭州市",
"86183021", "上海市",
"861303128", "新疆喀什地区",
"86180297", "广东省清远市",
"861334257", "湖南省益阳市",
"861886825", "浙江省温州市",
"861571731", "湖南省长沙市",
"861894488", "江苏省宿迁市",
"861362771", "广西南宁市",
"861343515", "广东省江门市",
"861576819", "广东省梅州市",
"861566871", "辽宁省盘锦市",
"861830474", "内蒙古乌兰察布市",
"861478479", "内蒙古鄂尔多斯市",
"861708381", "河南省新乡市",
"861825145", "江苏省盐城市",
"861785827", "浙江省台州市",
"86137761", "江苏省苏州市",
"861558524", "贵州省贵阳市",
"86185600", "山东省济南市",
"861894342", "吉林省通化市",
"861837149", "湖北省武汉市",
"8615300", "上海市",
"861762582", "江苏省无锡市",
"861780764", "广东省广州市",
"861536858", "云南省普洱市",
"861533796", "新疆巴音郭楞蒙古自治州",
"861324334", "河南省许昌市",
"86137718", "江苏省苏州市",
"861332758", "山西省吕梁市",
"861530813", "四川省乐山市",
"861890447", "吉林省辽源市",
"861882887", "四川省自贡市",
"861867631", "广东省清远市",
"861514481", "内蒙古通辽市",
"861304455", "福建省泉州市",
"86170920", "广东省广州市",
"861513848", "河南省郑州市",
"861533315", "河北省唐山市",
"861877257", "湖北省荆州市",
"861806216", "湖北省恩施土家族苗族自治州",
"861846930", "云南省玉溪市",
"861870510", "江苏省盐城市",
"861318690", "浙江省台州市",
"86155577", "浙江省温州市",
"861337304", "河北省石家庄市",
"861808773", "云南省普洱市",
"861509680", "云南省怒江傈僳族自治州",
"861562677", "广东省汕头市",
"861330147", "江苏省南通市",
"861329426", "湖北省黄冈市",
"861760521", "江苏省镇江市",
"86155192", "贵州省遵义市",
"861311945", "甘肃省酒泉市",
"86188253", "广东省中山市",
"86156558", "安徽省阜阳市",
"86182824", "四川省眉山市",
"861899905", "新疆和田地区",
"861378736", "湖南省常德市",
"861509110", "陕西省咸阳市",
"861580531", "山东省济南市",
"861586606", "山东省济宁市",
"861398034", "四川省攀枝花市",
"861357273", "陕西省渭南市",
"861597840", "河南省郑州市",
"861478438", "河南省开封市",
"861340691", "山东省枣庄市",
"861370259", "广东省江门市",
"861576927", "陕西省宝鸡市",
"861340954", "宁夏固原市",
"861308916", "吉林省吉林市",
"86135663", "浙江省宁波市",
"861800365", "黑龙江省哈尔滨市",
"86183275", "湖北省襄樊市",
"861877188", "湖北省鄂州市",
"861515280", "江苏省徐州市",
"861453331", "浙江省杭州市",
"861309430", "云南省玉溪市",
"86137706", "江苏省南京市",
"861571487", "内蒙古鄂尔多斯市",
"861530751", "广东省韶关市",
"861379621", "黑龙江省哈尔滨市",
"861840812", "四川省攀枝花市",
"861705518", "北京市",
"861377262", "陕西省咸阳市",
"861556543", "河南省新乡市",
"861830662", "广东省阳江市",
"861351360", "山西省太原市",
"861774053", "湖北省武汉市",
"861359890", "河南省驻马店市",
"861572985", "四川省自贡市",
"86180312", "河北省保定市",
"861351844", "四川省甘孜藏族自治州",
"861454832", "广东省广州市",
"861302978", "黑龙江省佳木斯市",
"861563630", "黑龙江省哈尔滨市",
"861598172", "新疆伊犁哈萨克自治州",
"86132701", "江苏省无锡市",
"86139448", "吉林省长春市",
"861352581", "河南省安阳市",
"861813924", "新疆伊犁哈萨克自治州",
"86159023", "重庆市",
"861535099", "辽宁省辽阳市",
"861306351", "江苏省徐州市",
"861560778", "广西河池市",
"861827668", "广西河池市",
"861327212", "湖南省株洲市",
"861597329", "湖南省邵阳市",
"861550904", "新疆和田地区",
"86159463", "黑龙江省牡丹江市",
"861380045", "黑龙江省哈尔滨市",
"861363480", "黑龙江省哈尔滨市",
"861770798", "江西省景德镇市",
"86183406", "辽宁省营口市",
"861339371", "河南省郑州市",
"861887094", "江西省抚州市",
"861557680", "湖南省益阳市",
"86188300", "河北省邯郸市",
"861880770", "广西防城港市",
"861365323", "河北省张家口市",
"86150326", "河北省石家庄市",
"861312447", "福建省泉州市",
"861334618", "浙江省杭州市",
"861331278", "云南省大理白族自治州",
"86132974", "湖南省长沙市",
"861452235", "浙江省湖州市",
"861313243", "河北省衡水市",
"861348473", "内蒙古鄂尔多斯市",
"861309273", "湖北省黄冈市",
"861582039", "广东省梅州市",
"861771162", "湖南省长沙市",
"861865089", "福建省漳州市",
"861588411", "四川省宜宾市",
"86159572", "浙江省湖州市",
"861330979", "青海省海西蒙古族藏族自治州",
"861476553", "浙江省杭州市",
"861889458", "甘肃省天水市",
"861503908", "河南省郑州市",
"861571600", "福建省三明市",
"861805862", "浙江省嘉兴市",
"861537463", "内蒙古乌海市",
"861817546", "安徽省宿州市",
"861811497", "江苏省徐州市",
"861875290", "江苏省盐城市",
"861534524", "江苏省苏州市",
"861808885", "广东省梅州市",
"861319818", "四川省南充市",
"861369859", "贵州省六盘水市",
"861355836", "广西百色市",
"861337096", "山东省聊城市",
"861538547", "安徽省池州市",
"861324874", "浙江省宁波市",
"861364546", "山东省东营市",
"861331919", "陕西省铜川市",
"861347457", "陕西省延安市",
"861569450", "黑龙江省哈尔滨市",
"861532931", "贵州省贵阳市",
"861380071", "湖北省襄樊市",
"861563442", "山东省威海市",
"861471578", "广东省深圳市",
"861339345", "山西省长治市",
"861357642", "江西省景德镇市",
"861305496", "山东省济宁市",
"861897191", "湖北省十堰市",
"861362623", "江苏省无锡市",
"86145989", "广东省佛山市",
"861821480", "安徽省亳州市",
"861356962", "河南省三门峡市",
"861309642", "四川省乐山市",
"861389513", "宁夏吴忠市",
"861303650", "四川省宜宾市",
"861867700", "广西防城港市",
"861311971", "青海省西宁市",
"861313672", "黑龙江省齐齐哈尔市",
"861450309", "河北省衡水市",
"861310911", "陕西省渭南市",
"861348347", "河北省秦皇岛市",
"861390572", "浙江省湖州市",
"861363322", "河北省保定市",
"861576452", "黑龙江省齐齐哈尔市",
"861874096", "甘肃省庆阳市",
"86185861", "内蒙古包头市",
"861846210", "山东省济宁市",
"861876395", "山东省德州市",
"861587708", "广西玉林市",
"861522492", "河南省驻马店市",
"861534569", "安徽省合肥市",
"861539205", "福建省福州市",
"861505063", "江苏省南通市",
"861860836", "四川省甘孜藏族自治州",
"86185818", "四川省成都市",
"861847674", "广东省深圳市",
"861358068", "广东省云浮市",
"861894794", "内蒙古兴安盟",
"861457195", "浙江省绍兴市",
"861551468", "河南省鹤壁市",
"861380476", "内蒙古赤峰市",
"861328400", "黑龙江省哈尔滨市",
"861562959", "湖北省黄石市",
"861512918", "陕西省西安市",
"861709968", "浙江省宁波市",
"861570353", "山西省阳泉市",
"861505613", "安徽省滁州市",
"861300759", "河南省安阳市",
"861313429", "辽宁省葫芦岛市",
"861858262", "四川省南充市",
"861815048", "福建省泉州市",
"861339831", "四川省资阳市",
"861374977", "河南省南阳市",
"861770484", "内蒙古包头市",
"861331827", "广东省中山市",
"861323795", "江西省宜春市",
"861357152", "陕西省渭南市",
"861865124", "江苏省宿迁市",
"861536034", "广东省阳江市",
"86152371", "河南省郑州市",
"861569534", "青海省海南藏族自治州",
"861454372", "山东省青岛市",
"86135110", "北京市",
"861513349", "河北省石家庄市",
"86156419", "辽宁省辽阳市",
"861390995", "新疆吐鲁番地区",
"861809736", "青海省玉树藏族自治州",
"861595041", "江苏省无锡市",
"861556509", "河南省郑州市",
"861890373", "河南省新乡市",
"861509379", "河南省平顶山市",
"861477180", "湖北省十堰市",
"861319170", "河北省邯郸市",
"86181981", "贵州省贵阳市",
"861874491", "贵州省毕节地区",
"861476274", "江苏省苏州市",
"861330938", "甘肃省天水市",
"861313464", "山西省吕梁市",
"861778632", "湖北省十堰市",
"861303140", "河北省承德市",
"86157376", "河南省信阳市",
"861309152", "黑龙江省黑河市",
"861458761", "广东省韶关市",
"861582078", "广东省深圳市",
"861336172", "江西省九江市",
"861898765", "云南省红河哈尼族彝族自治州",
"861878430", "四川省内江市",
"861471539", "广东省湛江市",
"861334902", "安徽省蚌埠市",
"861593190", "河北省唐山市",
"861829720", "青海省海北藏族自治州",
"861362745", "湖南省怀化市",
"86176889", "广东省深圳市",
"861305091", "辽宁省朝阳市",
"861500945", "甘肃省金昌市",
"861896629", "浙江省温州市",
"86177690", "河北省石家庄市",
"861570567", "安徽省阜阳市",
"861817685", "广西南宁市",
"86177417", "辽宁省营口市",
"861808621", "湖北省恩施土家族苗族自治州",
"86138945", "吉林省通化市",
"86159197", "广东省深圳市",
"861334777", "江苏省镇江市",
"861333320", "河北省邯郸市",
"861558645", "湖北省十堰市",
"861362251", "广东省佛山市",
"86151765", "河北省唐山市",
"861376345", "黑龙江省齐齐哈尔市",
"861335483", "内蒙古阿拉善盟",
"86181509", "福建省泉州市",
"861459303", "四川省自贡市",
"861707830", "云南省昭通市",
"861709490", "浙江省宁波市",
"861840675", "广西玉林市",
"861453933", "广东省佛山市",
"861450194", "山西省运城市",
"861561677", "湖南省益阳市",
"861563866", "河南省平顶山市",
"861815292", "新疆克拉玛依市",
"861568776", "云南省昆明市",
"861329484", "内蒙古通辽市",
"861560617", "江苏省无锡市",
"861309811", "陕西省咸阳市",
"861855853", "福建省三明市",
"861820708", "江西省南昌市",
"86183175", "河南省洛阳市",
"861572487", "江苏省南京市",
"861596936", "云南省丽江市",
"86155525", "山东省济南市",
"86170024", "辽宁省沈阳市",
"861370738", "湖南省娄底市",
"861899338", "甘肃省白银市",
"86153396", "安徽省六安市",
"861333849", "福建省泉州市",
"861859828", "广东省中山市",
"86158490", "内蒙古呼伦贝尔市",
"86187388", "河南省周口市",
"86158617", "江苏省淮安市",
"861533440", "云南省丽江市",
"861352360", "河南省洛阳市",
"86180572", "浙江省湖州市",
"861539452", "福建省福州市",
"861470436", "吉林省白城市",
"861339973", "新疆塔城地区",
"861839395", "甘肃省武威市",
"861363355", "山西省长治市",
"861301978", "黑龙江省齐齐哈尔市",
"861351581", "浙江省杭州市",
"861891231", "江苏省常州市",
"861831865", "广东省清远市",
"861332278", "广东省潮州市",
"861516450", "黑龙江省佳木斯市",
"861306953", "河南省许昌市",
"861300918", "吉林省吉林市",
"861839716", "青海省玉树藏族自治州",
"861813986", "甘肃省平凉市",
"861823623", "河南省漯河市",
"861311447", "湖北省襄樊市",
"861559191", "陕西省铜川市",
"861573822", "河南省商丘市",
"86186681", "浙江省杭州市",
"861832072", "广东省广州市",
"861364900", "四川省内江市",
"861321724", "湖北省荆门市",
"861502911", "陕西省延安市",
"861592550", "云南省昭通市",
"86151714", "湖北省武汉市",
"861805041", "福建省福州市",
"861304957", "贵州省毕节地区",
"861505782", "浙江省金华市",
"861873537", "山西省太原市",
"861370779", "广西北海市",
"861311833", "四川省凉山彝族自治州",
"861500373", "河南省新乡市",
"861893584", "新疆阿克苏地区",
"861787604", "广东省湛江市",
"861890945", "甘肃省武威市",
"861539318", "甘肃省陇南市",
"86139390", "河南省郑州市",
"861361771", "广西南宁市",
"861371719", "广东省东莞市",
"861376831", "广西南宁市",
"861768303", "四川省乐山市",
"861598621", "广东省茂名市",
"861526886", "浙江省台州市",
"86139933", "甘肃省平凉市",
"86135982", "河南省南阳市",
"861803190", "河北省邢台市",
"861811174", "四川省内江市",
"861332239", "辽宁省葫芦岛市",
"861534671", "甘肃省兰州市",
"861531211", "江苏省连云港市",
"861309753", "山西省晋中市",
"861868378", "四川省成都市",
"861514189", "辽宁省铁岭市",
"861331758", "湖北省荆州市",
"861321769", "广东省东莞市",
"86130782", "广东省湛江市",
"861780357", "山西省临汾市",
"861880250", "广东省湛江市",
"861304380", "辽宁省阜新市",
"861708560", "安徽省六安市",
"861836916", "山东省威海市",
"861847521", "广东省梅州市",
"861818432", "贵州省毕节地区",
"861516534", "山东省德州市",
"86155317", "河北省沧州市",
"861506664", "山东省日照市",
"861560258", "广东省江门市",
"861588370", "四川省达州市",
"861818628", "湖北省襄樊市",
"861323507", "福建省莆田市",
"861559944", "贵州省黔南布依族苗族自治州",
"861336773", "广西桂林市",
"861872007", "江西省南昌市",
"861532873", "四川省内江市",
"861853419", "山西省晋中市",
"861528935", "陕西省西安市",
"861837441", "湖南省张家界市",
"861770426", "辽宁省锦州市",
"861350461", "黑龙江省齐齐哈尔市",
"861564937", "河南省南阳市",
"861338936", "甘肃省兰州市",
"861330305", "河北省唐山市",
"861473009", "河北省邢台市",
"861452417", "辽宁省营口市",
"861511918", "广东省韶关市",
"861522000", "广东省广州市",
"861339410", "辽宁省铁岭市",
"861760674", "浙江省宁波市",
"861835520", "安徽省阜阳市",
"861844722", "内蒙古包头市",
"861539130", "云南省楚雄彝族自治州",
"861350555", "安徽省滁州市",
"861325195", "浙江省绍兴市",
"861570694", "云南省玉溪市",
"86181635", "湖北省武汉市",
"86152511", "江苏省盐城市",
"861508604", "贵州省贵阳市",
"86184596", "福建省漳州市",
"861570951", "宁夏银川市",
"861774606", "福建省南平市",
"861379574", "四川省泸州市",
"861510978", "青海省西宁市",
"861384863", "内蒙古包头市",
"861899878", "广东省中山市",
"86187295", "陕西省西安市",
"86152568", "安徽省阜阳市",
"861478145", "四川省广元市",
"861845440", "山东省淄博市",
"86182699", "安徽省阜阳市",
"861390497", "辽宁省营口市",
"861536727", "湖南省郴州市",
"861811572", "江苏省徐州市",
"861479954", "新疆喀什地区",
"861304638", "广东省珠海市",
"861314568", "安徽省亳州市",
"861450975", "新疆和田地区",
"86157516", "江苏省扬州市",
"861843633", "河南省鹤壁市",
"86136883", "四川省成都市",
"861388478", "山东省枣庄市",
"861350616", "江苏省无锡市",
"861705031", "四川省成都市",
"861393891", "河南省许昌市",
"861530245", "广东省广州市",
"86178785", "广西玉林市",
"861569733", "湖南省株洲市",
"861532785", "湖北省武汉市",
"861336885", "云南省昆明市",
"861893182", "河北省衡水市",
"86130400", "河北省唐山市",
"861896597", "福建省龙岩市",
"86187522", "江苏省盐城市",
"861772082", "福建省莆田市",
"861351676", "浙江省台州市",
"861829989", "新疆喀什地区",
"861867568", "广东省茂名市",
"8629", "陕西省西安市\、咸阳市",
"86138412", "辽宁省鞍山市",
"861890971", "青海省西宁市",
"861459349", "四川省凉山彝族自治州",
"861810512", "江苏省连云港市",
"861302805", "山西省晋城市",
"861707370", "河南省商丘市",
"86187540", "山东省菏泽市",
"861523530", "山西省阳泉市",
"861361745", "湖南省怀化市",
"86180023", "重庆市",
"861550493", "辽宁省抚顺市",
"861515599", "安徽省黄山市",
"861534586", "浙江省台州市",
"861880095", "四川省巴中市",
"861375408", "内蒙古巴彦淖尔市",
"861569385", "甘肃省兰州市",
"861812497", "广东省汕头市",
"861539927", "陕西省延安市",
"86182979", "安徽省合肥市",
"86159312", "河北省保定市",
"861800032", "河北省保定市",
"861813293", "河北省邢台市",
"861818150", "四川省乐山市",
"861475706", "浙江省绍兴市",
"861760462", "黑龙江省齐齐哈尔市",
"861808172", "四川省攀枝花市",
"861304679", "江苏省宿迁市",
"861301219", "河北省唐山市",
"861572600", "山东省菏泽市",
"861332919", "安徽省六安市",
"861860660", "浙江省宁波市",
"861527770", "广西柳州市",
"861300279", "山东省临沂市",
"861859364", "福建省厦门市",
"861520094", "湖南省长沙市",
"861533632", "山东省枣庄市",
"861584891", "内蒙古呼和浩特市",
"861389714", "青海省海南藏族自治州",
"86180463", "福建省泉州市",
"86181456", "黑龙江省哈尔滨市",
"861350066", "内蒙古赤峰市",
"86189326", "河北省保定市",
"861588689", "新疆喀什地区",
"861868838", "广东省广州市",
"861317260", "广东省肇庆市",
"861353914", "广东省河源市",
"86157508", "福建省福州市",
"861533428", "湖北省黄石市",
"861390856", "贵州省铜仁地区",
"861840641", "山西省临汾市",
"861342533", "广东省汕头市",
"86139987", "辽宁省盘锦市",
"861801434", "江苏省常州市",
"861478516", "贵州省铜仁地区",
"861534723", "湖北省武汉市",
"861503335", "河北省秦皇岛市",
"861888214", "四川省资阳市",
"861598773", "云南省玉溪市",
"86145236", "重庆市",
"861316358", "黑龙江省绥化市",
"861366319", "河北省邢台市",
"86414", "辽宁省本溪市",
"861310313", "河北省张家口市",
"861859329", "广西桂林市",
"861786923", "云南省德宏傣族景颇族自治州",
"861811995", "安徽省马鞍山市",
"861333348", "山西省运城市",
"86132829", "浙江省金华市",
"861450592", "辽宁省朝阳市",
"861510939", "甘肃省陇南市",
"861313815", "广东省深圳市",
"861397175", "湖北省黄石市",
"861764553", "黑龙江省绥化市",
"861582693", "湖北省武汉市",
"86147524", "江苏省苏州市",
"861825622", "安徽省六安市",
"86151389", "河南省郑州市",
"861521492", "新疆和田地区",
"861822891", "四川省遂宁市",
"861389145", "陕西省渭南市",
"861322182", "浙江省杭州市",
"861529309", "甘肃省张掖市",
"861816878", "江苏省徐州市",
"861338331", "河北省石家庄市",
"861320815", "四川省资阳市",
"861858415", "四川省乐山市",
"86153962", "福建省厦门市",
"861317342", "山东省滨州市",
"86189935", "甘肃省武威市",
"86137075", "海南省海口市",
"86991", "新疆乌鲁木齐市",
"861322612", "广东省潮州市",
"86152089", "海南省海口市",
"861786508", "山东省临沂市",
"861580952", "宁夏石嘴山市",
"861380473", "内蒙古阿拉善盟",
"861531525", "山东省潍坊市",
"861705750", "山东省济南市",
"861550740", "湖南省娄底市",
"861599132", "陕西省安康市",
"861505616", "安徽省淮北市",
"861570356", "山西省晋城市",
"861804937", "陕西省渭南市",
"861860447", "吉林省吉林市",
"86138784", "广西梧州市",
"861555327", "山东省聊城市",
"861876097", "云南省丽江市",
"861848770", "云南省玉溪市",
"861334390", "河南省平顶山市",
"861824693", "黑龙江省大庆市",
"861318452", "江西省赣州市",
"86181831", "重庆市",
"861845017", "福建省莆田市",
"861315581", "江西省南昌市",
"861881558", "安徽省阜阳市",
"861866705", "浙江省温州市",
"861308470", "内蒙古呼伦贝尔市",
"86151700", "江西省南昌市",
"861586649", "山东省烟台市",
"861833180", "河北省衡水市",
"861864488", "吉林省通化市",
"86151125", "广东省深圳市",
"861863841", "河南省商丘市",
"861590739", "湖南省邵阳市",
"861501507", "广东省韶关市",
"861768517", "贵州省毕节地区",
"861505461", "山东省临沂市",
"861809733", "青海省西宁市",
"861890376", "河南省信阳市",
"861888812", "江苏省淮安市",
"861366547", "山东省济宁市",
"861339047", "辽宁省营口市",
"861388691", "湖北省荆门市",
"861561550", "山东省菏泽市",
"861370865", "云南省保山市",
"861380230", "广东省潮州市",
"861384889", "内蒙古赤峰市",
"861479478", "内蒙古巴彦淖尔市",
"861478714", "云南省曲靖市",
"861830719", "湖北省十堰市",
"861572295", "江苏省淮安市",
"861591718", "广东省潮州市",
"86181748", "广西玉林市",
"861355833", "广西桂林市",
"861393480", "山西省大同市",
"861337093", "山东省烟台市",
"861364543", "山东省滨州市",
"861778192", "四川省巴中市",
"861510530", "山东省菏泽市",
"861585281", "江苏省无锡市",
"86178022", "天津市",
"861338845", "浙江省金华市",
"861476556", "浙江省杭州市",
"861318318", "河南省濮阳市",
"86138155", "江苏省盐城市",
"861537466", "内蒙古赤峰市",
"86188574", "浙江省宁波市",
"861817543", "安徽省阜阳市",
"861590778", "广西河池市",
"861874093", "甘肃省定西市",
"861459517", "云南省保山市",
"861814449", "广东省惠州市",
"861332510", "山东省济南市",
"861476185", "江苏省无锡市",
"861361684", "浙江省台州市",
"861860833", "四川省乐山市",
"861505066", "江苏省盐城市",
"861573391", "河北省邢台市",
"861529477", "河南省周口市",
"86159558", "安徽省阜阳市",
"861305493", "山东省临沂市",
"861869905", "新疆乌鲁木齐市",
"861362626", "江苏省镇江市",
"861810771", "广西南宁市",
"861367449", "吉林省白山市",
"861786984", "云南省昆明市",
"861870758", "广东省肇庆市",
"86132226", "江苏省镇江市",
"861558498", "吉林省辽源市",
"861537611", "山东省菏泽市",
"861345142", "河北省邯郸市",
"861389516", "宁夏石嘴山市",
"861567840", "广西玉林市",
"861532644", "吉林省通化市",
"861873562", "山西省晋城市",
"861816110", "四川省宜宾市",
"861322062", "山东省泰安市",
"86131687", "广东省深圳市",
"86151277", "河北省沧州市",
"861879470", "甘肃省酒泉市",
"861519936", "新疆昌吉回族自治州",
"861308913", "吉林省长春市",
"861314191", "江苏省盐城市",
"861360572", "浙江省金华市",
"861518410", "辽宁省铁岭市",
"861322908", "广东省江门市",
"861814882", "广东省珠海市",
"861335424", "辽宁省沈阳市",
"861477398", "湖南省常德市",
"861345544", "山东省菏泽市",
"861310507", "福建省泉州市",
"86130465", "江苏省盐城市",
"861800617", "江苏省无锡市",
"861318819", "辽宁省朝阳市",
"861567828", "广西柳州市",
"861368858", "贵州省六盘水市",
"861556546", "河南省信阳市",
"86130025", "江苏省南京市",
"861475102", "江苏省无锡市",
"861596331", "山东省淄博市",
"861367882", "山东省济南市",
"861808776", "云南省昆明市",
"86188438", "吉林省松原市",
"861329423", "湖北省黄石市",
"861378733", "湖南省株洲市",
"861801677", "福建省宁德市",
"861804217", "浙江省台州市",
"861593388", "河北省邯郸市",
"861810745", "湖南省怀化市",
"861839514", "宁夏固原市",
"861377415", "湖北省襄樊市",
"861318130", "山东省济宁市",
"861586603", "山东省泰安市",
"861317794", "江西省抚州市",
"861342418", "广东省深圳市",
"86157749", "内蒙古赤峰市",
"861310070", "湖北省武汉市",
"861871305", "河北省沧州市",
"861361512", "江苏省徐州市",
"861595377", "山东省德州市",
"861335469", "云南省楚雄彝族自治州",
"861772920", "陕西省延安市",
"861365326", "河北省廊坊市",
"86138319", "河北省邢台市",
"861321335", "河南省许昌市",
"861816227", "江西省九江市",
"861348476", "内蒙古赤峰市",
"861327465", "黑龙江省大庆市",
"861313246", "河北省邢台市",
"861535860", "江苏省镇江市",
"861593442", "山西省晋中市",
"861309276", "湖北省黄石市",
"861535344", "陕西省宝鸡市",
"861564962", "河南省新乡市",
"861508054", "福建省南平市",
"861354331", "广东省深圳市",
"861760781", "广西崇左市",
"861774056", "湖北省襄樊市",
"861804148", "辽宁省沈阳市",
"861813381", "河北省石家庄市",
"861380910", "陕西省咸阳市",
"86156572", "浙江省湖州市",
"861528521", "贵州省遵义市",
"861327551", "安徽省合肥市",
"861338871", "云南省昆明市",
"861823684", "河南省许昌市",
"861383435", "山西省吕梁市",
"861834415", "广东省梅州市",
"861534498", "甘肃省兰州市",
"861568253", "四川省成都市",
"861321783", "广西桂林市",
"861850535", "山东省烟台市",
"861532552", "浙江省温州市",
"861367223", "江西省南昌市",
"861868765", "云南省文山壮族苗族自治州",
"86131633", "湖北省武汉市",
"861516087", "新疆乌鲁木齐市",
"86137293", "广东省揭阳市",
"86156197", "陕西省宝鸡市",
"86130414", "江苏省苏州市",
"861866629", "广东省深圳市",
"861860373", "河南省新乡市",
"861385720", "浙江省舟山市",
"861709743", "广东省深圳市",
"86159419", "辽宁省辽阳市",
"861595409", "山东省青岛市",
"861380347", "山西省运城市",
"86182545", "山东省烟台市",
"861862911", "陕西省延安市",
"861872979", "陕西省铜川市",
"86150681", "浙江省杭州市",
"861815894", "安徽省宣城市",
"86130271", "湖北省武汉市",
"861354845", "四川省巴中市",
"861550728", "湖北省十堰市",
"86184241", "辽宁省鞍山市",
"861895124", "江苏省宿迁市",
"861572050", "安徽省滁州市",
"861866664", "广东省潮州市",
"861365535", "山东省烟台市",
"861580427", "辽宁省盘锦市",
"861520901", "新疆塔城地区",
"861592959", "陕西省汉中市",
"861556115", "内蒙古鄂尔多斯市",
"86135619", "山东省日照市",
"861301530", "山西省太原市",
"861760437", "吉林省辽源市",
"861321841", "江苏省镇江市",
"861533793", "新疆乌鲁木齐市",
"861580207", "广东省汕头市",
"861350782", "广西柳州市",
"86182290", "陕西省西安市",
"861780589", "浙江省金华市",
"861800067", "河北省沧州市",
"861530816", "四川省雅安市",
"861769320", "甘肃省定西市",
"861819472", "青海省海西蒙古族藏族自治州",
"86185665", "广东省东莞市",
"861840934", "甘肃省庆阳市",
"86187732", "湖南省湘潭市",
"86153683", "云南省红河哈尼族彝族自治州",
"861847809", "湖南省郴州市",
"861803442", "河北省秦皇岛市",
"861300025", "江苏省南京市",
"861705270", "浙江省杭州市",
"861350063", "内蒙古通辽市",
"86137467", "黑龙江省伊春市",
"861529975", "新疆博尔塔拉蒙古自治州",
"861390853", "贵州省安顺市",
"861869407", "湖北省武汉市",
"861550496", "辽宁省锦州市",
"861520349", "山西省朔州市",
"861534583", "浙江省嘉兴市",
"86138255", "广东省佛山市",
"861347160", "广西河池市",
"861569167", "陕西省商洛市",
"86188314", "河北省承德市",
"861889974", "广东省东莞市",
"861863908", "河南省安阳市",
"861858340", "四川省雅安市",
"861813296", "河北省邯郸市",
"861874639", "黑龙江省哈尔滨市",
"861320464", "黑龙江省七台河市",
"861475703", "浙江省宁波市",
"861505089", "江苏省镇江市",
"861370072", "河南省安阳市",
"861362684", "浙江省宁波市",
"861812711", "广东省江门市",
"861786926", "云南省丽江市",
"861337880", "云南省昆明市",
"861367141", "广东省潮州市",
"861586565", "山东省淄博市",
"861590617", "江苏省无锡市",
"861537489", "内蒙古锡林郭勒盟",
"861582696", "湖北省黄石市",
"861764556", "黑龙江省黑河市",
"861310795", "福建省莆田市",
"861370414", "辽宁省本溪市",
"861817744", "广西梧州市",
"861324609", "广东省汕头市",
"86151071", "湖北省武汉市",
"861554818", "内蒙古鄂尔多斯市",
"861342536", "广东省肇庆市",
"861534726", "湖北省荆州市",
"861819014", "四川省巴中市",
"861478513", "贵州省安顺市",
"861321062", "山东省泰安市",
"861344383", "广西桂林市",
"861325635", "山东省聊城市",
"861392251", "广东省东莞市",
"861562434", "山东省德州市",
"861330570", "浙江省衢州市",
"861824078", "河南省商丘市",
"861586451", "山东省济南市",
"861818965", "甘肃省兰州市",
"861364744", "湖南省长沙市",
"861598776", "云南省保山市",
"861320429", "辽宁省葫芦岛市",
"861776607", "江苏省南京市",
"861567757", "广西玉林市",
"861368727", "湖北省宜昌市",
"861356148", "山东省聊城市",
"861337639", "山东省青岛市",
"861310316", "河北省廊坊市",
"861323911", "陕西省延安市",
"861590258", "贵州省毕节地区",
"86185209", "广东省佛山市",
"861831259", "广东省茂名市",
"861774603", "福建省宁德市",
"86151592", "福建省厦门市",
"861384866", "内蒙古赤峰市",
"861355945", "福建省福州市",
"861837009", "江西省吉安市",
"86130338", "河南省驻马店市",
"861821891", "广东省阳江市",
"861834237", "辽宁省葫芦岛市",
"861538319", "河北省邢台市",
"861321182", "云南省楚雄彝族自治州",
"861333806", "江苏省南通市",
"861550857", "贵州省毕节地区",
"861337678", "广东省河源市",
"861458320", "江西省九江市",
"861454867", "河南省周口市",
"861830637", "山东省枣庄市",
"861865613", "安徽省合肥市",
"861338933", "甘肃省兰州市",
"861320672", "黑龙江省齐齐哈尔市",
"861532525", "浙江省绍兴市",
"861827207", "湖北省襄樊市",
"861835780", "浙江省温州市",
"86136390", "贵州省贵阳市",
"861844582", "黑龙江省伊春市",
"861764065", "辽宁省鞍山市",
"861351673", "浙江省嘉兴市",
"861803701", "河南省洛阳市",
"861772801", "广东省东莞市",
"861860945", "甘肃省金昌市",
"861880397", "河南省郑州市",
"861806845", "江苏省徐州市",
"861587986", "江西省鹰潭市",
"861780290", "陕西省西安市",
"861346950", "宁夏银川市",
"861452791", "新疆塔城地区",
"861347080", "安徽省阜阳市",
"861569087", "河南省郑州市",
"861315844", "四川省德阳市",
"861533192", "黑龙江省绥化市",
"861843636", "河南省洛阳市",
"861871218", "安徽省安庆市",
"861397284", "湖北省咸宁市",
"86189681", "浙江省杭州市",
"861858917", "西藏阿里地区",
"861814994", "新疆昌吉回族自治州",
"861869379", "甘肃省兰州市",
"861350613", "江苏省苏州市",
"861555759", "浙江省温州市",
"861700749", "湖北省武汉市",
"861569736", "湖南省常德市",
"861805409", "安徽省合肥市",
"86180419", "辽宁省葫芦岛市",
"861518371", "四川省阿坝藏族羌族自治州",
"861459094", "广东省茂名市",
"861897568", "湖南省娄底市",
"861806871", "江苏省徐州市",
"861552599", "山西省长治市",
"86156297", "湖北省荆门市",
"86137193", "广东省广州市",
"861786892", "云南省玉溪市",
"861898879", "广东省深圳市",
"861760935", "甘肃省武威市",
"861768306", "四川省甘孜藏族自治州",
"861893769", "河南省信阳市",
"861558726", "云南省大理白族自治州",
"861531552", "山东省青岛市",
"861526883", "浙江省杭州市",
"861857132", "湖北省恩施土家族苗族自治州",
"861335081", "四川省泸州市",
"861834829", "河南省商丘市",
"861533594", "湖北省咸宁市",
"861870919", "陕西省铜川市",
"861860971", "青海省西宁市",
"861458482", "山东省青岛市",
"86139883", "云南省临沧市",
"861871979", "甘肃省兰州市",
"86135832", "山东省青岛市",
"86155735", "湖南省郴州市",
"861559631", "陕西省渭南市",
"861800739", "湖南省邵阳市",
"86152453", "黑龙江省牡丹江市",
"861769803", "河南省许昌市",
"861319547", "安徽省淮南市",
"861311836", "四川省眉山市",
"861500376", "河南省信阳市",
"8613482", "上海市",
"861363891", "西藏拉萨市",
"86150935", "河南省驻马店市",
"861529194", "陕西省延安市",
"861709544", "江苏省苏州市",
"861378450", "河北省秦皇岛市",
"861305588", "福建省漳州市",
"861458348", "江西省景德镇市",
"861778017", "四川省南充市",
"861360497", "辽宁省营口市",
"861507631", "河北省石家庄市",
"861815108", "江苏省苏州市",
"861328799", "山东省烟台市",
"861336776", "广西百色市",
"861517561", "河北省唐山市",
"861869878", "辽宁省朝阳市",
"861532876", "四川省眉山市",
"861364392", "河南省鹤壁市",
"861372197", "山东省潍坊市",
"861450634", "黑龙江省佳木斯市",
"861322841", "四川省德阳市",
"861526741", "浙江省金华市",
"861309756", "山西省长治市",
"861594937", "广西桂林市",
"861558960", "山东省烟台市",
"861389479", "吉林省长春市",
"861505522", "安徽省六安市",
"86155844", "吉林省长春市",
"861318425", "浙江省温州市",
"861830958", "宁夏银川市",
"861302530", "广东省河源市",
"86153637", "广东省珠海市",
"861327814", "吉林省四平市",
"861820969", "宁夏固原市",
"861345881", "四川省宜宾市",
"861855856", "福建省泉州市",
"861324725", "湖北省荆门市",
"861359737", "广西玉林市",
"861778793", "云南省普洱市",
"861560365", "黑龙江省哈尔滨市",
"861537842", "四川省巴中市",
"861589118", "陕西省延安市",
"861570532", "山东省青岛市",
"861323231", "广东省梅州市",
"861596933", "云南省楚雄彝族自治州",
"861811285", "江苏省盐城市",
"861341418", "广东省江门市",
"861335486", "内蒙古包头市",
"86136987", "云南省昆明市",
"861362512", "江苏省徐州市",
"861459306", "四川省绵阳市",
"86132898", "陕西省西安市",
"861453936", "广东省佛山市",
"861816905", "宁夏中卫市",
"86177768", "海南省海口市",
"86180558", "安徽省阜阳市",
"861778667", "湖北省荆州市",
"861563863", "河南省商丘市",
"861308311", "安徽省马鞍山市",
"861802677", "广东省江门市",
"861568773", "云南省玉溪市",
"861306956", "河南省漯河市",
"861529941", "新疆阿勒泰地区",
"861890660", "浙江省宁波市",
"86186326", "河北省廊坊市",
"861839713", "青海省海东地区",
"861589247", "四川省德阳市",
"861898838", "云南省怒江傈僳族自治州",
"861771920", "河南省郑州市",
"861326647", "河北省邢台市",
"86138579", "浙江省金华市",
"861823626", "河南省信阳市",
"861800778", "广西河池市",
"861575992", "福建省莆田市",
"861335161", "黑龙江省哈尔滨市",
"861398587", "贵州省毕节地区",
"86139756", "湖南省常德市",
"861813560", "河南省驻马店市",
"861339976", "新疆巴音郭楞蒙古自治州",
"861470433", "吉林省延边朝鲜族自治州",
"861871938", "广东省广州市",
"861803630", "江苏省盐城市",
"861894260", "河北省邯郸市",
"86156312", "河北省保定市",
"861876112", "江苏省宿迁市",
"861322095", "山东省聊城市",
"861377985", "新疆昌吉回族自治州",
"861339022", "辽宁省锦州市",
"861376055", "广东省揭阳市",
"86135500", "四川省成都市",
"861530390", "河南省周口市",
"861873595", "山西省临汾市",
"861477176", "湖北省黄冈市",
"861884814", "内蒙古赤峰市",
"86152201", "广东省深圳市",
"861319186", "河北省石家庄市",
"861384952", "河南省焦作市",
"861809506", "四川省自贡市",
"86133922", "广东省佛山市",
"86182594", "福建省厦门市",
"861862737", "湖南省益阳市",
"861846490", "山东省临沂市",
"861354740", "四川省自贡市",
"861319616", "吉林省通化市",
"861399108", "陕西省榆林市",
"861314454", "黑龙江省佳木斯市",
"861550871", "云南省昆明市",
"86147076", "广东省广州市",
"861811148", "四川省宜宾市",
"86132489", "浙江省温州市",
"861833173", "河北省廊坊市",
"861471709", "甘肃省酒泉市",
"861308483", "陕西省榆林市",
"86159859", "福建省泉州市",
"861316020", "江苏省镇江市",
"861518980", "江苏省南京市",
"861470855", "贵州省黔东南苗族侗族自治州",
"861301191", "河北省保定市",
"861597626", "广东省韶关市",
"861860638", "山东省淄博市",
"861592449", "内蒙古通辽市",
"861707369", "河南省南阳市",
"861472652", "四川省乐山市",
"861386249", "江苏省南通市",
"861887643", "福建省厦门市",
"861700352", "山西省大同市",
"861555342", "山东省烟台市",
"861868860", "广东省江门市",
"861394739", "内蒙古锡林郭勒盟",
"86131165", "浙江省台州市",
"861380480", "黑龙江省牡丹江市",
"861860422", "辽宁省鞍山市",
"861868344", "四川省成都市",
"861317602", "山东省济南市",
"861760620", "山东省日照市",
"861802175", "江苏省徐州市",
"861569704", "云南省昆明市",
"86183872", "云南省大理白族自治州",
"861319555", "安徽省马鞍山市",
"8618222", "天津市",
"861778165", "四川省自贡市",
"861811217", "江苏省连云港市",
"861502890", "河北省邢台市",
"861814677", "江西省赣州市",
"861580630", "山东省威海市",
"861774941", "河南省驻马店市",
"861302499", "福建省三明市",
"86189477", "内蒙古鄂尔多斯市",
"861518357", "四川省达州市",
"861317327", "山东省淄博市",
"861853963", "河南省周口市",
"86150182", "广东省揭阳市",
"861867530", "广东省梅州市",
"861520752", "广东省惠州市",
"861345127", "湖北省十堰市",
"861372695", "广东省清远市",
"86157261", "山东省济南市",
"861347698", "湖北省荆州市",
"861317279", "广东省河源市",
"861370892", "山东省济南市",
"86177953", "宁夏吴忠市",
"861889763", "广西柳州市",
"861862481", "河南省南阳市",
"861479289", "安徽省亳州市",
"861552554", "山西省晋城市",
"861821476", "安徽省淮南市",
"861523568", "山西省运城市",
"861870611", "江苏省常州市",
"861860679", "浙江省金华市",
"861840906", "新疆阿勒泰地区",
"861533559", "内蒙古包头市",
"861778085", "四川省凉山彝族自治州",
"861803925", "河南省三门峡市",
"861338728", "湖北省宜昌市",
"861300260", "浙江省嘉兴市",
"861364032", "广东省广州市",
"861516549", "山东省临沂市",
"861820416", "辽宁省锦州市",
"861560543", "山东省滨州市",
"86181723", "广西南宁市",
"861538782", "江西省上饶市",
"861811658", "四川省成都市",
"861873972", "河南省安阳市",
"861810329", "河北省邢台市",
"861314530", "山东省菏泽市",
"861587538", "广东省汕头市",
"861532304", "广东省梅州市",
"861559939", "贵州省黔西南布依族苗族自治州",
"861398146", "四川省达州市",
"861824261", "辽宁省铁岭市",
"861529159", "陕西省西安市",
"861539168", "湖北省十堰市",
"861519493", "河北省邢台市",
"861556778", "吉林省松原市",
"861777791", "广西北海市",
"861561284", "河北省衡水市",
"86189910", "陕西省咸阳市",
"86147629", "江苏省南京市",
"86131114", "河北省唐山市",
"861329372", "山西省大同市",
"861824898", "江苏省宿迁市",
"861887153", "湖北省咸宁市",
"86185563", "安徽省合肥市",
"86159946", "广西钦州市",
"861474712", "内蒙古包头市",
"861586477", "山东省泰安市",
"86153585", "江苏省扬州市",
"861820661", "广东省梅州市",
"861801403", "江苏省苏州市",
"861330784", "广西梧州市",
"861599940", "新疆阿克苏地区",
"861319066", "内蒙古锡林郭勒盟",
"861567771", "广西防城港市",
"861591651", "广东省梅州市",
"861839408", "甘肃省武威市",
"861831321", "云南省西双版纳傣族自治州",
"86185472", "内蒙古包头市",
"861760158", "江苏省苏州市",
"861325920", "陕西省渭南市",
"861831294", "浙江省温州市",
"861568964", "山东省日照市",
"861806496", "四川省成都市",
"861342102", "广东省梅州市",
"861569015", "河北省廊坊市",
"86150425", "辽宁省阜新市",
"861599928", "新疆伊犁哈萨克自治州",
"86183305", "河北省唐山市",
"86136909", "广东省河源市",
"861875973", "福建省三明市",
"86157531", "山东省济南市",
"861858985", "广西玉林市",
"861305936", "广东省肇庆市",
"861567745", "广西贺州市",
"861593207", "河北省保定市",
"861880786", "广西百色市",
"861708538", "山东省济宁市",
"861510191", "甘肃省金昌市",
"861593427", "山西省忻州市",
"861592403", "浙江省舟山市",
"861557676", "湖南省永州市",
"861816242", "湖北省武汉市",
"861363476", "内蒙古赤峰市",
"861802994", "广东省揭阳市",
"861564572", "黑龙江省黑河市",
"861459334", "四川省宜宾市",
"861819921", "新疆巴音郭楞蒙古自治州",
"86152536", "山东省潍坊市",
"861339589", "浙江省金华市",
"86189282", "广东省东莞市",
"86183049", "内蒙古赤峰市",
"861580701", "江西省鹰潭市",
"861568929", "山东省淄博市",
"861317918", "吉林省四平市",
"861471743", "江西省南昌市",
"861367959", "广东省肇庆市",
"861360962", "广东省深圳市",
"861344016", "四川省眉山市",
"861300596", "广西玉林市",
"861346315", "河北省唐山市",
"86188270", "湖北省武汉市",
"861590821", "四川省绵阳市",
"861352379", "河南省洛阳市",
"861325766", "广东省云浮市",
"861814959", "福建省泉州市",
"861818884", "广东省广州市",
"86936", "甘肃省张掖市",
"861590546", "山东省东营市",
"861346796", "湖南省永州市",
"861343858", "四川省泸州市",
"861868792", "云南省普洱市",
"861880523", "江苏省淮安市",
"861459059", "广东省肇庆市",
"861338740", "湖南省岳阳市",
"861333374", "河南省许昌市",
"861586343", "山东省潍坊市",
"861567623", "广西桂林市",
"861590685", "浙江省绍兴市",
"861801449", "江苏省南京市",
"861588324", "四川省资阳市",
"861800900", "四川省凉山彝族自治州",
"861363071", "吉林省通化市",
"861373019", "河北省保定市",
"861760648", "山东省青岛市",
"861787633", "广东省肇庆市",
"86139019", "上海市",
"861564995", "河南省周口市",
"861860957", "宁夏中卫市",
"861591175", "云南省德宏傣族景颇族自治州",
"861390435", "吉林省四平市",
"861776105", "四川省南充市",
"861370760", "河南省许昌市",
"86150014", "新疆和田地区",
"861311804", "四川省资阳市",
"861807114", "湖北省武汉市",
"86145211", "河北省石家庄市",
"861303551", "贵州省遵义市",
"861310163", "黑龙江省牡丹江市",
"861330498", "辽宁省阜新市",
"861596728", "浙江省丽水市",
"861395629", "安徽省滁州市",
"861802141", "江苏省南京市",
"86181791", "江西省南昌市",
"861510944", "甘肃省甘南藏族自治州",
"861839877", "四川省广元市",
"861352338", "河南省周口市",
"861811120", "四川省泸州市",
"861334816", "江苏省常州市",
"861507219", "湖北省鄂州市",
"861450606", "吉林省白山市",
"861324901", "广东省中山市",
"861859684", "福建省福州市",
"861768059", "湖南省常德市",
"861553343", "河北省廊坊市",
"861380322", "河北省廊坊市",
"861316048", "江苏省徐州市",
"861332463", "陕西省安康市",
"861560509", "福建省龙岩市",
"861860380", "河南省新乡市",
"86147952", "广西玉林市",
"861351905", "甘肃省武威市",
"861454426", "江苏省南通市",
"861471625", "广东省广州市",
"861707868", "云南省楚雄彝族自治州",
"861318942", "广东省江门市",
"861571501", "福建省宁德市",
"861323069", "河北省廊坊市",
"861575467", "黑龙江省鸡西市",
"86188707", "江西省赣州市",
"861816721", "浙江省宁波市",
"861333058", "云南省玉溪市",
"861708579", "江苏省淮安市",
"861869098", "新疆乌鲁木齐市",
"861354728", "四川省资阳市",
"861337931", "陕西省延安市",
"861896535", "福建省南平市",
"861321770", "广西防城港市",
"861454206", "河南省新乡市",
"861887272", "湖北省黄冈市",
"861847620", "广东省广州市",
"861884551", "黑龙江省绥化市",
"861800821", "四川省泸州市",
"86157118", "广东省广州市",
"861390148", "江苏省南通市",
"861586975", "湖南省益阳市",
"861324349", "河南省新乡市",
"861477079", "江西省抚州市",
"86130672", "福建省福州市",
"861330583", "浙江省嘉兴市",
"861319089", "内蒙古通辽市",
"86150282", "河北省保定市",
"861368742", "广东省佛山市",
"861343727", "湖北省武汉市",
"861866921", "云南省昆明市",
"861354496", "广东省江门市",
"861774808", "四川省成都市",
"861533165", "云南省普洱市",
"861861481", "内蒙古呼和浩特市",
"861889529", "宁夏银川市",
"861834731", "内蒙古鄂尔多斯市",
"861330960", "安徽省滁州市",
"861815859", "浙江省舟山市",
"861812658", "广东省肇庆市",
"861328553", "安徽省芜湖市",
"861876240", "江苏省南京市",
"861800546", "山东省东营市",
"861470996", "新疆巴音郭楞蒙古自治州",
"86134052", "江苏省苏州市",
"861337873", "云南省红河哈尼族彝族自治州",
"861788805", "西藏昌都地区",
"861560744", "湖南省张家界市",
"861831923", "广东省茂名市",
"86186771", "广西南宁市",
"86189425", "湖南省长沙市",
"86131609", "广东省佛山市",
"861809928", "新疆吐鲁番地区",
"861330726", "湖北省恩施土家族苗族自治州",
"861328367", "山西省吕梁市",
"861534570", "浙江省衢州市",
"861810757", "广东省佛山市",
"861709930", "浙江省台州市",
"861803427", "河北省沧州市",
"861452297", "山西省吕梁市",
"861331244", "贵州省黔东南苗族侗族自治州",
"861306446", "河南省平顶山市",
"861868193", "陕西省榆林市",
"861350818", "四川省宜宾市",
"861339290", "广东省中山市",
"861356853", "四川省资阳市",
"861377731", "浙江省绍兴市",
"861705283", "四川省成都市",
"861368006", "广东省韶关市",
"86131471", "湖北省武汉市",
"861869242", "湖南省湘潭市",
"861376589", "贵州省毕节地区",
"86189065", "浙江省台州市",
"86152166", "上海市",
"861453493", "内蒙古锡林郭勒盟",
"861351839", "四川省广安市",
"861818992", "西藏日喀则地区",
"861583187", "河北省沧州市",
"861336548", "山东省泰安市",
"861569503", "宁夏吴忠市",
"861321095", "山东省聊城市",
"861551430", "河南省濮阳市",
"861557844", "广西南宁市",
"861341988", "河南省新乡市",
"861335916", "陕西省汉中市",
"861897219", "湖北省武汉市",
"861827388", "湖南省岳阳市",
"861506535", "山东省烟台市",
"861537278", "浙江省舟山市",
"86152813", "四川省自贡市",
"861472709", "浙江省绍兴市",
"861347073", "安徽省芜湖市",
"861354091", "四川省乐山市",
"861848584", "贵州省毕节地区",
"861502083", "山东省泰安市",
"861707386", "河南省许昌市",
"861580866", "云南省玉溪市",
"861351110", "湖南省益阳市",
"861319124", "山西省运城市",
"86134890", "福建省福州市",
"861317759", "江西省鹰潭市",
"861367718", "湖北省荆州市",
"861769912", "新疆伊犁哈萨克自治州",
"861834487", "江苏省淮安市",
"861553975", "河南省许昌市",
"861830382", "河南省安阳市",
"861869721", "青海省海东地区",
"861351680", "浙江省杭州市",
"86130992", "甘肃省兰州市",
"861313558", "安徽省阜阳市",
"861589775", "湖北省黄石市",
"861865170", "江苏省连云港市",
"861819800", "甘肃省兰州市",
"861567251", "湖北省宜昌市",
"861594711", "内蒙古呼和浩特市",
"86131265", "北京市",
"861705822", "福建省厦门市",
"861773782", "河南省濮阳市",
"861800685", "浙江省绍兴市",
"86155895", "山东省烟台市",
"86135792", "新疆乌鲁木齐市",
"861306041", "陕西省西安市",
"861556067", "内蒙古呼伦贝尔市",
"861590900", "新疆乌鲁木齐市",
"861596091", "福建省龙岩市",
"861319169", "河北省衡水市",
"861380355", "江西省九江市",
"861813413", "河北省张家口市",
"861597684", "广东省湛江市",
"861301499", "广西南宁市",
"861508099", "湖南省岳阳市",
"861570009", "浙江省杭州市",
"861378940", "内蒙古呼伦贝尔市",
"861571262", "浙江省嘉兴市",
"861533085", "辽宁省抚顺市",
"861767906", "江西省吉安市",
"861836802", "浙江省杭州市",
"861509844", "山东省聊城市",
"86157106", "福建省厦门市",
"86137846", "河北省唐山市",
"861577958", "江西省新余市",
"861378928", "湖南省怀化市",
"861458608", "湖北省随州市",
"861306075", "广东省佛山市",
"861304376", "河南省信阳市",
"861458232", "安徽省淮南市",
"861806740", "浙江省宁波市",
"861520643", "山东省日照市",
"86145017", "山西省临汾市",
"861351407", "福建省福州市",
"861366461", "黑龙江省哈尔滨市",
"86145803", "江苏省南通市",
"861323737", "湖南省益阳市",
"861820579", "浙江省金华市",
"861563668", "黑龙江省双鸭山市",
"861840540", "山东省菏泽市",
"861395597", "安徽省黄山市",
"861351338", "河北省石家庄市",
"861477854", "广东省深圳市",
"86150477", "内蒙古鄂尔多斯市",
"861899581", "湖北省咸宁市",
"861830420", "辽宁省朝阳市",
"861339055", "辽宁省沈阳市",
"861368394", "河南省周口市",
"861355455", "湖北省荆州市",
"861366555", "安徽省马鞍山市",
"861516704", "浙江省绍兴市",
"861860561", "安徽省淮北市",
"861476248", "江苏省盐城市",
"861309468", "浙江省丽水市",
"861768646", "山东省潍坊市",
"861454484", "湖北省武汉市",
"861331463", "黑龙江省牡丹江市",
"861780976", "青海省玉树藏族自治州",
"86182484", "浙江省杭州市",
"861337333", "河北省张家口市",
"86182643", "山东省淄博市",
"861390937", "甘肃省酒泉市",
"861587011", "贵州省遵义市",
"861319522", "贵州省遵义市",
"861775783", "浙江省宁波市",
"86156256", "广东省揭阳市",
"861770372", "河南省安阳市",
"861826195", "江苏省镇江市",
"861537919", "甘肃省平凉市",
"861518605", "贵州省毕节地区",
"86147894", "湖南省株洲市",
"861860455", "黑龙江省绥化市",
"861822045", "陕西省安康市",
"86180859", "贵州省黔西南布依族苗族自治州",
"86187050", "福建省福州市",
"861336520", "江苏省泰州市",
"861847158", "湖北省荆门市",
"861889082", "新疆巴音郭楞蒙古自治州",
"861526870", "浙江省湖州市",
"861459156", "广西北海市",
"861324303", "河南省焦作市",
"861303967", "黑龙江省伊春市",
"861815412", "安徽省合肥市",
"861700325", "河北省石家庄市",
"861589741", "湖南省怀化市",
"861560392", "河南省鹤壁市",
"861859626", "山东省德州市",
"861871569", "安徽省淮南市",
"861478460", "黑龙江省哈尔滨市",
"86188928", "四川省凉山彝族自治州",
"861572501", "山东省威海市",
"86132599", "陕西省西安市",
"861346440", "辽宁省朝阳市",
"861854790", "内蒙古锡林郭勒盟",
"861326479", "湖北省襄樊市",
"861335236", "辽宁省朝阳市",
"861811435", "江苏省苏州市",
"861325789", "广西玉林市",
"861570043", "四川省内江市",
"861521932", "广东省汕尾市",
"861308598", "甘肃省天水市",
"861326307", "江西省赣州市",
"861880724", "湖北省咸宁市",
"861832294", "江西省宜春市",
"86134715", "广西玉林市",
"861337785", "湖北省武汉市",
"861555593", "安徽省宿州市",
"861341102", "广东省佛山市",
"861809940", "新疆伊犁哈萨克自治州",
"861364365", "山西省运城市",
"861803952", "河南省周口市",
"861339566", "安徽省池州市",
"861813970", "甘肃省临夏回族自治州",
"861769232", "河北省张家口市",
"86139797", "江西省赣州市",
"861471544", "广东省东莞市",
"861323481", "内蒙古包头市",
"861587661", "广东省云浮市",
"861303814", "四川省资阳市",
"86181119", "贵州省贵阳市",
"861589222", "四川省自贡市",
"861324848", "浙江省金华市",
"861591223", "云南省丽江市",
"86184826", "四川省广安市",
"861520725", "湖北省黄冈市",
"861350319", "河北省邢台市",
"861568780", "云南省楚雄彝族自治州",
"861835621", "安徽省芜湖市",
"861896384", "新疆阿克苏地区",
"861857940", "广西柳州市",
"861531491", "浙江省嘉兴市",
"861338091", "广东省湛江市",
"861818826", "贵州省六盘水市",
"861874785", "内蒙古通辽市",
"861472743", "贵州省黔南布依族苗族自治州",
"861327000", "江苏省扬州市",
"861880769", "广东省东莞市",
"861501762", "广东省深圳市",
"861320887", "云南省迪庆藏族自治州",
"86185746", "湖南省永州市",
"861872645", "安徽省芜湖市",
"861459646", "甘肃省白银市",
"861837532", "安徽省芜湖市",
"861847648", "广东省深圳市",
"86155710", "湖北省襄樊市",
"861550933", "甘肃省平凉市",
"861327577", "安徽省合肥市",
"861351379", "河南省洛阳市",
"861776230", "湖北省宜昌市",
"861888788", "云南省昆明市",
"861700536", "山东省潍坊市",
"861537827", "四川省宜宾市",
"861388999", "广东省东莞市",
"861820538", "山东省泰安市",
"86189487", "广东省深圳市",
"86150597", "福建省泉州市",
"861779036", "四川省广元市",
"861359351", "山西省临汾市",
"861598491", "四川省德阳市",
"861830942", "甘肃省定西市",
"861707946", "河南省郑州市",
"861569804", "山东省济南市",
"86183882", "云南省昆明市",
"86156343", "山东省威海市",
"86137606", "广东省广州市",
"861378957", "内蒙古鄂尔多斯市",
"861351258", "江苏省盐城市",
"86135763", "江西省上饶市",
"861354329", "广东省深圳市",
"861850530", "山东省菏泽市",
"861868760", "云南省昆明市",
"861341348", "广东省清远市",
"861394839", "内蒙古巴彦淖尔市",
"86136311", "广东省中山市",
"861339501", "福建省厦门市",
"86155748", "湖南省长沙市",
"861459774", "新疆喀什地区",
"861580789", "广西玉林市",
"861458352", "山东省东营市",
"861341482", "广东省揭阳市",
"861556110", "内蒙古呼和浩特市",
"861362588", "浙江省丽水市",
"861301535", "山西省晋城市",
"861887111", "湖北省鄂州市",
"861315032", "新疆乌鲁木齐市",
"861471809", "广东省茂名市",
"861346922", "湖南省郴州市",
"861818498", "西藏日喀则地区",
"861886094", "江苏省南京市",
"861813649", "江苏省南京市",
"861399593", "湖北省黄冈市",
"861590673", "浙江省嘉兴市",
"86147086", "贵州省遵义市",
"861550771", "广西南宁市",
"861826668", "山东省枣庄市",
"861531548", "山东省泰安市",
"861354840", "四川省甘孜藏族自治州",
"861890549", "山东省临沂市",
"861589612", "江苏省连云港市",
"861509543", "甘肃省兰州市",
"861774983", "河北省沧州市",
"861572055", "安徽省马鞍山市",
"86130963", "四川省成都市",
"86132601", "北京市",
"861333734", "湖南省衡阳市",
"861815279", "湖南省娄底市",
"861847127", "湖北省荆州市",
"861591183", "云南省昭通市",
"861365530", "山东省菏泽市",
"861862443", "辽宁省大连市",
"861809638", "四川省成都市",
"861366406", "内蒙古包头市",
"861355506", "黑龙江省鸡西市",
"861819568", "青海省海南藏族自治州",
"86134569", "浙江省杭州市",
"861567871", "广西柳州市",
"861308046", "河北省石家庄市",
"861398463", "贵州省六盘水市",
"861501446", "广东省清远市",
"861330884", "云南省昆明市",
"861810740", "湖南省岳阳市",
"86132666", "广东省深圳市",
"861377410", "湖北省随州市",
"861318135", "山东省德州市",
"861809422", "江苏省南京市",
"86153575", "安徽省宣城市",
"861571589", "浙江省湖州市",
"861454104", "安徽省淮南市",
"861310075", "湖北省随州市",
"86158926", "四川省绵阳市",
"861871300", "河北省廊坊市",
"86180900", "四川省德阳市",
"86151109", "青海省西宁市",
"861879475", "甘肃省兰州市",
"861337574", "浙江省宁波市",
"861452476", "黑龙江省哈尔滨市",
"861815238", "宁夏中卫市",
"861340129", "江苏省扬州市",
"861777268", "河北省沧州市",
"861709620", "山东省临沂市",
"861305512", "湖南省株洲市",
"861560581", "浙江省杭州市",
"861850454", "黑龙江省佳木斯市",
"861518415", "辽宁省营口市",
"861577130", "内蒙古乌海市",
"861335356", "山西省晋城市",
"86188912", "陕西省榆林市",
"86158553", "安徽省宿州市",
"86186258", "河南省安阳市",
"861828912", "西藏日喀则地区",
"861362904", "四川省泸州市",
"861876257", "江苏省连云港市",
"861380915", "陕西省西安市",
"861834410", "广东省揭阳市",
"861312549", "辽宁省大连市",
"861882991", "广东省佛山市",
"861860506", "福建省漳州市",
"861383430", "山西省长治市",
"861538882", "云南省德宏傣族景颇族自治州",
"861301326", "河北省秦皇岛市",
"861866631", "广东省揭阳市",
"861350677", "浙江省温州市",
"861338828", "四川省泸州市",
"861537858", "四川省广安市",
"861857202", "湖北省黄石市",
"86132794", "陕西省西安市",
"861836149", "江苏省宿迁市",
"861772925", "陕西省安康市",
"86185125", "江苏省南京市",
"861889863", "广东省广州市",
"861899392", "甘肃省陇南市",
"861394878", "内蒙古巴彦淖尔市",
"861535865", "江苏省淮安市",
"861356554", "新疆石河子市",
"861370792", "江西省九江市",
"861308702", "河南省商丘市",
"86137661", "吉林省通化市",
"861327460", "黑龙江省哈尔滨市",
"861321330", "河南省周口市",
"861520852", "贵州省遵义市",
"86150172", "广东省汕头市",
"86155831", "四川省宜宾市",
"86177864", "湖北省武汉市",
"861857422", "河南省信阳市",
"861886306", "山东省威海市",
"861338364", "河北省承德市",
"861554403", "河南省安阳市",
"861343758", "广东省茂名市",
"861346896", "陕西省延安市",
"861812302", "四川省成都市",
"861338840", "浙江省衢州市",
"861835931", "福建省龙岩市",
"861818784", "云南省曲靖市",
"861890503", "福建省宁德市",
"86138507", "福建省泉州市",
"861509509", "山东省潍坊市",
"861862377", "河南省南阳市",
"861332656", "广东省茂名市",
"861331049", "贵州省遵义市",
"861325866", "黑龙江省哈尔滨市",
"861766641", "广东省东莞市",
"861572290", "江苏省南京市",
"861336491", "新疆昌吉回族自治州",
"861590721", "湖北省荆州市",
"861524004", "安徽省芜湖市",
"86188280", "四川省成都市",
"861303513", "湖北省武汉市",
"861800098", "广东省江门市",
"861813603", "江苏省徐州市",
"861381941", "浙江省嘉兴市",
"861811599", "江苏省连云港市",
"861393485", "山西省朔州市",
"86134239", "广东省深圳市",
"861471843", "广东省梅州市",
"861885039", "福建省福州市",
"861510535", "山东省烟台市",
"86189272", "广东省佛山市",
"861869900", "新疆克拉玛依市",
"861471781", "山西省太原市",
"861561066", "山东省临沂市",
"861846462", "山东省潍坊市",
"86131591", "福建省漳州市",
"861709648", "山东省潍坊市",
"861802063", "福建省宁德市",
"861310041", "广西南宁市",
"861338329", "河北省石家庄市",
"86177790", "江西省新余市",
"861892446", "广东省肇庆市",
"861880886", "云南省怒江傈僳族自治州",
"86132860", "广东省珠海市",
"861809957", "新疆喀什地区",
"861530362", "黑龙江省齐齐哈尔市",
"861567845", "广西贵港市",
"861521622", "江西省宜春市",
"861816115", "四川省广安市",
"86153259", "浙江省金华市",
"861887576", "河北省邢台市",
"86156914", "陕西省西安市",
"861583338", "河北省邢台市",
"861454502", "湖南省邵阳市",
"861321688", "浙江省丽水市",
"861476180", "江苏省常州市",
"861319284", "广东省惠州市",
"861332515", "山东省烟台市",
"861896944", "浙江省宁波市",
"861361493", "辽宁省抚顺市",
"861763328", "河北省沧州市",
"86189433", "吉林省延边朝鲜族自治州",
"861586381", "山东省烟台市",
"861879441", "甘肃省白银市",
"86185482", "内蒙古兴安盟",
"861589908", "新疆昌吉回族自治州",
"861321870", "江苏省泰州市",
"861341849", "广东省深圳市",
"861898923", "四川省凉山彝族自治州",
"86182111", "北京市",
"861354828", "四川省达州市",
"861803312", "广东省江门市",
"861705755", "广东省深圳市",
"861531520", "山东省淄博市",
"861550745", "湖南省怀化市",
"861883087", "河北省邯郸市",
"861560676", "浙江省台州市",
"861332146", "吉林省白城市",
"861816821", "江苏省徐州市",
"861521479", "浙江省台州市",
"861336096", "广东省梅州市",
"86182168", "贵州省六盘水市",
"861334395", "河南省漯河市",
"861390627", "江苏省南通市",
"861309962", "云南省西双版纳傣族自治州",
"861707768", "云南省玉溪市",
"861313527", "湖南省永州市",
"861512048", "甘肃省临夏回族自治州",
"861536463", "山西省阳泉市",
"861520419", "辽宁省营口市",
"861770696", "福建省漳州市",
"861871823", "广东省揭阳市",
"861510326", "河北省廊坊市",
"861882542", "广东省佛山市",
"861389140", "陕西省商洛市",
"86182017", "上海市",
"861858410", "四川省资阳市",
"861815918", "福建省福州市",
"86182803", "四川省成都市",
"861859936", "新疆巴音郭楞蒙古自治州",
"861583379", "河北省沧州市",
"861879702", "青海省海东地区",
"861390302", "广东省深圳市",
"861338277", "江苏省南京市",
"861802183", "江苏省徐州市",
"861556338", "山东省临沂市",
"861773141", "河北省石家庄市",
"861570469", "黑龙江省双鸭山市",
"861594642", "黑龙江省七台河市",
"86157122", "天津市",
"861380235", "广东省惠州市",
"861553381", "河北省衡水市",
"861329732", "湖南省湘潭市",
"861840557", "安徽省宿州市",
"861561555", "山东省烟台市",
"861370860", "云南省昭通市",
"86147838", "河南省开封市",
"86137800", "浙江省宁波市",
"861311704", "湖北省咸宁市",
"861377973", "新疆喀什地区",
"861577452", "黑龙江省齐齐哈尔市",
"861370344", "河南省漯河市",
"861899744", "青海省海南藏族自治州",
"861897014", "江西省赣州市",
"86187116", "湖南省常德市",
"861598304", "四川省泸州市",
"861556227", "山东省济宁市",
"861350959", "福建省宁德市",
"861804811", "四川省广元市",
"86145484", "广东省广州市",
"861866700", "浙江省杭州市",
"861308475", "内蒙古通辽市",
"861556407", "山东省滨州市",
"861590242", "辽宁省葫芦岛市",
"861304692", "福建省宁德市",
"861561461", "山东省潍坊市",
"861833185", "河北省邯郸市",
"861357962", "新疆昌吉回族自治州",
"86184375", "河南省平顶山市",
"861381477", "江苏省常州市",
"861811280", "江苏省镇江市",
"861450416", "辽宁省锦州市",
"861340421", "江苏省苏州市",
"861880368", "河南省南阳市",
"861572589", "山东省莱芜市",
"861868508", "贵州省黔南布依族苗族自治州",
"861396651", "安徽省亳州市",
"861773403", "河北省张家口市",
"86131481", "上海市",
"861816900", "宁夏银川市",
"861330541", "山东省济南市",
"861810857", "贵州省毕节地区",
"861507629", "河北省保定市",
"861804152", "辽宁省丹东市",
"861308659", "四川省泸州市",
"861329696", "内蒙古鄂尔多斯市",
"86150433", "吉林省延边朝鲜族自治州",
"861520576", "浙江省台州市",
"861351778", "广西河池市",
"861839902", "新疆哈密地区",
"86185592", "福建省厦门市",
"861330826", "重庆市",
"861810091", "陕西省西安市",
"861361904", "四川省泸州市",
"861374916", "河南省开封市",
"861324720", "湖北省黄冈市",
"861323377", "河南省信阳市",
"86151209", "海南省海口市",
"861560360", "黑龙江省哈尔滨市",
"861380417", "辽宁省营口市",
"86186781", "山东省淄博市",
"86188445", "吉林省长春市",
"861300048", "北京市",
"861881991", "广东省汕头市",
"861311549", "黑龙江省大庆市",
"861554651", "黑龙江省哈尔滨市",
"861803635", "江苏省徐州市",
"861770732", "湖南省长沙市",
"861594753", "内蒙古通辽市",
"861813565", "河南省洛阳市",
"861567213", "湖北省十堰市",
"86152955", "江苏省南京市",
"861834831", "河南省商丘市",
"861879977", "新疆伊犁哈萨克自治州",
"861325388", "河南省焦作市",
"861894265", "河北省石家庄市",
"861454261", "西藏拉萨市",
"861890665", "浙江省温州市",
"86150272", "湖北省武汉市",
"86130682", "广东省惠州市",
"861813451", "安徽省合肥市",
"861571566", "安徽省池州市",
"861800721", "湖北省荆州市",
"86136092", "陕西省西安市",
"861559629", "陕西省商洛市",
"861700912", "陕西省榆林市",
"861860928", "陕西省西安市",
"861333533", "陕西省渭南市",
"861804642", "福建省厦门市",
"861308149", "山东省威海市",
"861323264", "广东省河源市",
"861806828", "江苏省无锡市",
"861810496", "辽宁省锦州市",
"861379096", "广东省湛江市",
"861760930", "甘肃省临夏回族自治州",
"861873439", "山西省忻州市",
"86182538", "山东省泰安市",
"861507014", "江西省新余市",
"861359953", "福建省厦门市",
"861535072", "河北省承德市",
"861399794", "湖北省荆门市",
"861870394", "河南省周口市",
"86151665", "山东省聊城市",
"861869821", "辽宁省朝阳市",
"861323409", "辽宁省大连市",
"861316596", "浙江省杭州市",
"861518829", "河南省信阳市",
"861317859", "广东省湛江市",
"86546", "山东省东营市",
"861329133", "江苏省常州市",
"861307953", "宁夏吴忠市",
"861310862", "云南省楚雄彝族自治州",
"861459573", "陕西省安康市",
"86170969", "新疆乌鲁木齐市",
"861361588", "浙江省宁波市",
"861355928", "福建省漳州市",
"861535414", "河北省承德市",
"861475608", "河北省廊坊市",
"861593312", "河北省保定市",
"861302535", "广东省清远市",
"861580766", "广东省云浮市",
"861318420", "浙江省杭州市",
"861559014", "吉林省吉林市",
"861554141", "辽宁省铁岭市",
"86185071", "湖北省武汉市",
"861814818", "四川省雅安市",
"861335134", "黑龙江省佳木斯市",
"861561522", "山东省滨州市",
"861354757", "四川省南充市",
"861869546", "宁夏银川市",
"861532548", "浙江省湖州市",
"861332003", "江西省上饶市",
"861836046", "江苏省南京市",
"86158717", "湖北省武汉市",
"861592613", "湖北省恩施土家族苗族自治州",
"861351739", "湖南省邵阳市",
"861356811", "四川省宜宾市",
"861325701", "江西省鹰潭市",
"861458325", "江西省吉安市",
"861370636", "山东省东营市",
"861522479", "河南省商丘市",
"861470722", "湖北省武汉市",
"861390599", "福建省南平市",
"861800673", "浙江省嘉兴市",
"86157595", "福建省泉州市",
"861840961", "宁夏中卫市",
"861322870", "江苏省宿迁市",
"861308977", "黑龙江省鹤岗市",
"861335532", "山东省青岛市",
"861532520", "浙江省衢州市",
"861520681", "山东省临沂市",
"861839188", "陕西省宝鸡市",
"861562186", "山东省济南市",
"861452519", "山东省潍坊市",
"861885136", "江苏省宿迁市",
"861775883", "黑龙江省佳木斯市",
"86133906", "江苏省扬州市",
"861570486", "内蒙古鄂尔多斯市",
"861348791", "湖南省常德市",
"86182474", "内蒙古兴安盟",
"861318448", "浙江省丽水市",
"861311503", "江苏省南京市",
"861320431", "吉林省长春市",
"861313699", "黑龙江省佳木斯市",
"861872823", "四川省阿坝藏族羌族自治州",
"861355940", "福建省泉州市",
"861337621", "江苏省无锡市",
"861899543", "宁夏固原市",
"861500549", "山东省临沂市",
"861881542", "广西玉林市",
"861538994", "新疆和田地区",
"861516804", "浙江省丽水市",
"861814319", "吉林省白山市",
"86156010", "北京市",
"861580948", "甘肃省陇南市",
"86189597", "福建省泉州市",
"86150487", "内蒙古鄂尔多斯市",
"861808491", "四川省广安市",
"861568678", "陕西省汉中市",
"86157222", "天津市",
"861518328", "四川省内江市",
"861367319", "河北省邢台市",
"861764060", "辽宁省锦州市",
"861835785", "浙江省丽水市",
"861562461", "内蒙古锡林郭勒盟",
"861860940", "甘肃省兰州市",
"86184515", "江苏省徐州市",
"861820606", "福建省厦门市",
"861826531", "山东省济南市",
"861330992", "新疆伊犁哈萨克自治州",
"861773449", "河北省沧州市",
"861346955", "宁夏吴忠市",
"861780295", "陕西省安康市",
"861372088", "福建省厦门市",
"861806840", "江苏省苏州市",
"861327998", "新疆喀什地区",
"86170817", "上海市",
"86187208", "江西省赣州市",
"861861377", "河南省南阳市",
"86182799", "江西省萍乡市",
"861537727", "湖北省十堰市",
"86558", "安徽省阜阳市",
"861332049", "云南省临沧市",
"861809561", "安徽省淮北市",
"861328176", "四川省广安市",
"861360468", "黑龙江省鸡西市",
"861870742", "湖南省永州市",
"861458536", "河南省周口市",
"861317412", "江苏省扬州市",
"86181735", "湖南省郴州市",
"861858345", "四川省资阳市",
"86177502", "福建省福州市",
"861381343", "江苏省盐城市",
"861775402", "安徽省安庆市",
"861320787", "广西钦州市",
"861880869", "湖北省荆门市",
"861322247", "江苏省常州市",
"861805231", "江苏省连云港市",
"861300020", "上海市",
"861517132", "湖北省黄冈市",
"861368489", "江西省萍乡市",
"861860317", "河北省沧州市",
"861843414", "山西省太原市",
"861818726", "云南省德宏傣族景颇族自治州",
"861705275", "上海市",
"86188180", "上海市",
"861812599", "广东省清远市",
"861568880", "山东省德州市",
"861529970", "新疆阿勒泰地区",
"86134139", "广东省揭阳市",
"861586983", "湖南省郴州市",
"8615644", "河南省郑州市",
"861522622", "宁夏石嘴山市",
"861330575", "浙江省绍兴市",
"86159900", "浙江省杭州市",
"861325630", "山东省威海市",
"86133918", "北京市",
"861319406", "福建省泉州市",
"861772952", "陕西省安康市",
"861472781", "陕西省榆林市",
"861761433", "吉林省延边朝鲜族自治州",
"861818960", "甘肃省张掖市",
"861454399", "贵州省黔西南布依族苗族自治州",
"861522438", "山东省滨州市",
"861891446", "江苏省南京市",
"861879149", "陕西省铜川市",
"861362493", "辽宁省沈阳市",
"861337885", "云南省昆明市",
"861555108", "安徽省马鞍山市",
"86184564", "安徽省六安市",
"861586560", "山东省烟台市",
"861373934", "甘肃省庆阳市",
"861523323", "河北省张家口市",
"861355317", "山东省济南市",
"861880824", "四川省达州市",
"86153159", "山东省日照市",
"861310790", "福建省三明市",
"861322688", "广东省汕尾市",
"861379304", "山东省菏泽市",
"861890704", "江西省抚州市",
"861325889", "吉林省白山市",
"861317074", "云南省普洱市",
"861399488", "山西省运城市",
"861336154", "山东省潍坊市",
"861824867", "浙江省台州市",
"861591170", "云南省昆明市",
"861884998", "云南省临沧市",
"861576662", "广东省汕尾市",
"861535892", "江苏省扬州市",
"861370765", "河南省新乡市",
"861568931", "山东省淄博市",
"861390430", "吉林省长春市",
"861363028", "陕西省西安市",
"861847142", "湖北省襄樊市",
"861831838", "广东省清远市",
"861539197", "安徽省巢湖市",
"86159399", "河南省许昌市",
"861760709", "江西省南昌市",
"861457207", "四川省绵阳市",
"861813309", "安徽省阜阳市",
"861590839", "四川省宜宾市",
"861767116", "湖北省襄樊市",
"861807493", "广西南宁市",
"86155723", "湖北省黄冈市",
"861590680", "浙江省舟山市",
"861378373", "河南省新乡市",
"86130394", "新疆乌鲁木齐市",
"861508779", "云南省昭通市",
"861346947", "湖南省娄底市",
"86147798", "江西省上饶市",
"861337817", "四川省广元市",
"861800905", "四川省绵阳市",
"861387206", "湖北省黄石市",
"861476252", "江苏省淮安市",
"861459361", "贵州省黔南布依族苗族自治州",
"861331587", "河北省承德市",
"861309174", "黑龙江省大兴安岭地区",
"861564990", "河南省商丘市",
"86134811", "广西南宁市",
"86138774", "广西梧州市",
"861351900", "甘肃省临夏回族自治州",
"861471620", "广东省佛山市",
"86134868", "浙江省台州市",
"861896530", "福建省三明市",
"861550840", "四川省宜宾市",
"86150556", "安徽省安庆市",
"86151563", "安徽省宣城市",
"861829094", "新疆阿勒泰地区",
"861321775", "广西玉林市",
"861454354", "山东省东营市",
"861782043", "广东省梅州市",
"861889668", "江苏省常州市",
"861391213", "江苏省扬州市",
"861354771", "四川省宜宾市",
"86178537", "山东省济宁市",
"861577942", "江西省九江市",
"86150923", "山东省淄博市",
"861335106", "黑龙江省双鸭山市",
"861822791", "四川省资阳市",
"86138901", "四川省绵阳市",
"861390554", "安徽省淮南市",
"861840669", "广东省中山市",
"861858980", "广西南宁市",
"86151287", "河北省沧州市",
"861815488", "新疆阿勒泰地区",
"861576474", "内蒙古乌兰察布市",
"861381451", "江苏省南京市",
"861567740", "广西梧州市",
"861780501", "江苏省镇江市",
"861889018", "湖南省邵阳市",
"86152626", "江苏省苏州市",
"861857447", "湖南省张家界市",
"861364581", "浙江省杭州市",
"861870858", "贵州省六盘水市",
"861802319", "广东省汕尾市",
"861566626", "山东省威海市",
"861810871", "云南省昆明市",
"861858563", "贵州省毕节地区",
"861325925", "陕西省汉中市",
"861323351", "山西省太原市",
"861895406", "山东省济宁市",
"861816739", "浙江省温州市",
"86147269", "湖南省长沙市",
"861860733", "湖南省株洲市",
"861311692", "云南省德宏傣族景颇族自治州",
"86170039", "河南省郑州市",
"861817581", "湖南省怀化市",
"861569010", "河北省邯郸市",
"861538959", "陕西省榆林市",
"86182612", "江苏省盐城市",
"861313654", "浙江省湖州市",
"861572976", "四川省广元市",
"861313991", "新疆乌鲁木齐市",
"861590878", "云南省楚雄彝族自治州",
"86188584", "浙江省宁波市",
"861831879", "广东省中山市",
"861840624", "辽宁省盘锦市",
"861338745", "湖南省怀化市",
"861819978", "新疆哈密地区",
"86186302", "河北省保定市",
"861576012", "四川省乐山市",
"86133183", "广东省佛山市",
"861550277", "湖北省恩施土家族苗族自治州",
"861863402", "河北省唐山市",
"861771442", "江苏省南京市",
"861845893", "浙江省台州市",
"86157621", "山东省滨州市",
"861395631", "安徽省滁州市",
"861355733", "广西桂林市",
"861537143", "江苏省连云港市",
"86138499", "河南省洛阳市",
"861813477", "河南省商丘市",
"861337964", "贵州省铜仁地区",
"861809447", "江苏省泰州市",
"861458102", "安徽省亳州市",
"861346310", "河北省邯郸市",
"861861351", "山西省太原市",
"861850944", "甘肃省平凉市",
"86147539", "山东省临沂市",
"861338771", "广西南宁市",
"861458504", "河南省信阳市",
"86155791", "江西省南昌市",
"861857373", "湖南省益阳市",
"86178583", "浙江省嘉兴市",
"861333861", "江苏省南京市",
"861314535", "山东省烟台市",
"861829306", "甘肃省定西市",
"861384801", "内蒙古包头市",
"861568211", "四川省成都市",
"86156582", "浙江省宁波市",
"861354623", "山西省晋中市",
"861869258", "湖南省湘西土家族苗族自治州",
"861532256", "广东省汕头市",
"861782009", "广东省阳江市",
"861760881", "云南省怒江傈僳族自治州",
"861372690", "广东省湛江市",
"861867535", "广东省梅州市",
"861583242", "河北省承德市",
"861771889", "广东省惠州市",
"861521647", "山东省东营市",
"861399759", "湖北省荆州市",
"861870359", "山西省运城市",
"861300265", "浙江省金华市",
"861778080", "四川省宜宾市",
"86131380", "广东省梅州市",
"861319434", "吉林省四平市",
"861479707", "青海省海西蒙古族藏族自治州",
"861890087", "广东省佛山市",
"86132102", "山东省青岛市",
"861886646", "山东省潍坊市",
"861772866", "广东省河源市",
"861599945", "新疆乌鲁木齐市",
"861830318", "河北省衡水市",
"86152820", "四川省广元市",
"861851260", "广东省深圳市",
"861378833", "广西桂林市",
"861808876", "黑龙江省佳木斯市",
"861367782", "广西柳州市",
"861803766", "河南省周口市",
"861865403", "安徽省亳州市",
"861813343", "安徽省铜陵市",
"861334362", "河南省焦作市",
"8613711", "广东省广州市",
"861379336", "山东省威海市",
"861318719", "湖南省邵阳市",
"861890736", "湖南省常德市",
"86150991", "新疆乌鲁木齐市",
"861330467", "黑龙江省七台河市",
"861760743", "湖南省湘西土家族苗族自治州",
"861343181", "广东省梅州市",
"861590379", "河南省洛阳市",
"861519684", "四川省资阳市",
"861389932", "新疆吐鲁番地区",
"861341912", "四川省南充市",
"861524178", "辽宁省营口市",
"861373906", "湖南省长沙市",
"861453626", "江苏省泰州市",
"861390152", "江苏省无锡市",
"861377563", "江苏省常州市",
"861585464", "山东省威海市",
"861350882", "云南省大理白族自治州",
"861503368", "河北省沧州市",
"861803137", "河北省张家口市",
"861526584", "山东省聊城市",
"861817676", "广西河池市",
"861321741", "湖南省长沙市",
"861537109", "江苏省无锡市",
"86155604", "内蒙古赤峰市",
"861308951", "黑龙江省鹤岗市",
"86186875", "云南省昆明市",
"861308694", "贵州省黔东南苗族侗族自治州",
"861370604", "福建省宁德市",
"861854507", "黑龙江省大庆市",
"861518985", "江苏省扬州市",
"861364676", "浙江省台州市",
"861769504", "宁夏固原市",
"861598644", "广东省广州市",
"861377980", "新疆阿克苏地区",
"861830452", "黑龙江省齐齐哈尔市",
"861565083", "安徽省宿州市",
"861882033", "广东省东莞市",
"861322090", "山东省威海市",
"861471648", "广东省深圳市",
"861524139", "辽宁省营口市",
"861709781", "浙江省台州市",
"861530395", "河南省漯河市",
"861376050", "广东省江门市",
"861787779", "湖南省长沙市",
"861515962", "福建省福州市",
"861571047", "陕西省宝鸡市",
"861378447", "河北省廊坊市",
"861831339", "云南省普洱市",
"86151472", "内蒙古包头市",
"861538677", "山西省临汾市",
"861846495", "山东省日照市",
"861550828", "四川省巴中市",
"861309572", "浙江省湖州市",
"861802170", "江苏省南通市",
"861395700", "浙江省衢州市",
"861500692", "山东省日照市",
"861760625", "山东省威海市",
"86130281", "四川省成都市",
"86150671", "浙江省杭州市",
"861778160", "四川省雅安市",
"861313542", "安徽省六安市",
"861356302", "山东省聊城市",
"861812152", "江苏省无锡市",
"861319550", "安徽省滁州市",
"861785587", "浙江省金华市",
"861580635", "山东省聊城市",
"861450969", "新疆乌鲁木齐市",
"861529708", "青海省西宁市",
"861709843", "浙江省金华市",
"861327513", "江苏省南通市",
"86150409", "辽宁省葫芦岛市",
"861470850", "贵州省贵阳市",
"86136925", "广东省茂名市",
"86177455", "黑龙江省大庆市",
"86183329", "河北省唐山市",
"861810331", "河北省石家庄市",
"861708346", "山西省长治市",
"861390642", "山东省青岛市",
"861837424", "湖南省益阳市",
"861820634", "山东省莱芜市",
"861336552", "安徽省蚌埠市",
"861321883", "江苏省南通市",
"861380485", "黑龙江省伊春市",
"861313393", "江西省上饶市",
"861806623", "浙江省金华市",
"861368827", "四川省资阳市",
"861567857", "广西贵港市",
"861809945", "新疆巴音郭楞蒙古自治州",
"861343842", "四川省资阳市",
"861364360", "山西省太原市",
"861858729", "云南省德宏傣族景颇族自治州",
"861454136", "河北省廊坊市",
"861813975", "甘肃省张掖市",
"861580312", "河北省保定市",
"861382451", "广东省佛山市",
"861323953", "宁夏吴忠市",
"86151187", "广东省佛山市",
"861366434", "吉林省四平市",
"86130033", "江苏省无锡市",
"861523472", "山西省临汾市",
"861570916", "陕西省汉中市",
"861520720", "湖北省宜昌市",
"861842038", "广东省揭阳市",
"861534826", "四川省达州市",
"861529296", "新疆和田地区",
"861768963", "福建省龙岩市",
"861386696", "安徽省宣城市",
"861811430", "江苏省常州市",
"861362936", "甘肃省张掖市",
"86139336", "河北省秦皇岛市",
"861571976", "青海省西宁市",
"861534541", "山东省临沂市",
"861500736", "湖南省常德市",
"861453512", "山东省济南市",
"861865651", "安徽省马鞍山市",
"861581372", "广东省深圳市",
"861800379", "河南省洛阳市",
"86147169", "广东省广州市",
"861812811", "广东省珠海市",
"861566684", "山东省菏泽市",
"861865994", "福建省泉州市",
"861337780", "湖北省鄂州市",
"86189991", "新疆乌鲁木齐市",
"861872640", "安徽省阜阳市",
"86156492", "河南省郑州市",
"861858764", "广西百色市",
"861860534", "山东省德州市",
"861876271", "江苏省淮安市",
"86839", "四川省广元市",
"861367613", "广东省汕头市",
"86158655", "山东省青岛市",
"861336336", "河北省唐山市",
"861595619", "安徽省宣城市",
"861829517", "宁夏银川市",
"861350994", "广东省广州市",
"861568785", "云南省昆明市",
"861335009", "四川省成都市",
"861857945", "广西南宁市",
"86181895", "甘肃省兰州市",
"861874780", "内蒙古巴彦淖尔市",
"861891956", "四川省成都市",
"86182839", "四川省广元市",
"861520966", "宁夏石嘴山市",
"861814613", "福建省莆田市",
"861840545", "山东省烟台市",
"861569836", "山西省阳泉市",
"861561547", "山东省济宁市",
"861816617", "湖南省怀化市",
"861595069", "江苏省徐州市",
"861384920", "河南省鹤壁市",
"86133324", "辽宁省沈阳市",
"861328398", "河南省三门峡市",
"861390811", "四川省绵阳市",
"861700849", "浙江省杭州市",
"861552658", "吉林省四平市",
"86134350", "广东省韶关市",
"861353696", "广东省肇庆市",
"86189671", "浙江省杭州市",
"861475348", "山东省青岛市",
"861890692", "福建省福州市",
"861523664", "河南省新乡市",
"861366550", "安徽省滁州市",
"861333042", "云南省昭通市",
"861814063", "湖北省黄石市",
"861368919", "陕西省西安市",
"861378971", "内蒙古通辽市",
"861339050", "辽宁省大连市",
"861830425", "辽宁省葫芦岛市",
"861340707", "江西省赣州市",
"861317982", "新疆乌鲁木齐市",
"861306070", "广东省梅州市",
"861452891", "云南省西双版纳傣族自治州",
"861479972", "新疆乌鲁木齐市",
"86157544", "吉林省吉林市",
"861894292", "湖北省武汉市",
"861332587", "浙江省温州市",
"861583098", "河北省石家庄市",
"861806745", "浙江省温州市",
"861459580", "陕西省咸阳市",
"861316052", "广东省阳江市",
"86133567", "山东省潍坊市",
"861777476", "广西百色市",
"86189409", "辽宁省大连市",
"861865141", "江苏省南通市",
"861452268", "浙江省丽水市",
"861336525", "江苏省宿迁市",
"861773959", "河南省周口市",
"861386133", "江苏省苏州市",
"861518600", "贵州省铜仁地区",
"861826190", "江苏省盐城市",
"861860450", "黑龙江省哈尔滨市",
"861822040", "陕西省咸阳市",
"861700320", "河北省邯郸市",
"861526875", "浙江省丽水市",
"861379552", "四川省眉山市",
"86158436", "吉林省白城市",
"861478465", "黑龙江省绥化市",
"861800407", "辽宁省营口市",
"861878497", "四川省自贡市",
"861854795", "内蒙古鄂尔多斯市",
"861593137", "河北省衡水市",
"861893368", "广东省汕头市",
"861346445", "辽宁省锦州市",
"861454767", "山东省济宁市",
"861393417", "山西省临汾市",
"861500167", "新疆昌吉回族自治州",
"861333706", "内蒙古鄂尔多斯市",
"861454693", "广东省东莞市",
"861800338", "河北省衡水市",
"861350141", "广东省汕头市",
"86134203", "广东省中山市",
"86155355", "山西省长治市",
"86137532", "山西省大同市",
"861586413", "山东省济宁市",
"861760652", "浙江省杭州市",
"861580458", "黑龙江省伊春市",
"86155119", "河北省唐山市",
"861380987", "广东省中山市",
"861506530", "山东省菏泽市",
"861327714", "湖北省黄冈市",
"861304549", "黑龙江省大庆市",
"861474788", "内蒙古呼和浩特市",
"86189556", "安徽省安庆市",
"861335043", "四川省眉山市",
"861553970", "河南省洛阳市",
"861589770", "湖北省孝感市",
"861309856", "贵州省铜仁地区",
"861351685", "浙江省杭州市",
"861526841", "浙江省宁波市",
"861532776", "湖北省荆州市",
"861869778", "河南省开封市",
"86135958", "贵州省六盘水市",
"86189923", "陕西省渭南市",
"861336876", "云南省文山壮族苗族自治州",
"86188779", "广西北海市",
"861328899", "广东省茂名市",
"861820346", "山西省晋城市",
"861700348", "山西省太原市",
"861576197", "贵州省遵义市",
"861850499", "内蒙古呼和浩特市",
"861308353", "江苏省徐州市",
"861551435", "河南省郑州市",
"861450986", "新疆阿勒泰地区",
"861321090", "山东省威海市",
"861338251", "江苏省苏州市",
"861329044", "河北省石家庄市",
"861380350", "江西省南昌市",
"86147354", "山西省晋中市",
"861558541", "吉林省通化市",
"861846997", "云南省德宏傣族景颇族自治州",
"861311736", "湖南省常德市",
"861769703", "青海省黄南藏族自治州",
"861533080", "辽宁省沈阳市",
"861318637", "陕西省宝鸡市",
"861597493", "云南省西双版纳傣族自治州",
"86130758", "福建省福州市",
"861308567", "浙江省金华市",
"861700482", "广东省深圳市",
"861378945", "内蒙古通辽市",
"861840571", "浙江省杭州市",
"861810933", "甘肃省平凉市",
"86181710", "湖北省武汉市",
"861882699", "广东省东莞市",
"861881527", "浙江省宁波市",
"861534992", "新疆哈密地区",
"86145290", "广东省广州市",
"86139873", "云南省红河哈尼族彝族自治州",
"86137262", "广东省珠海市",
"861811152", "四川省雅安市",
"861345308", "山西省朔州市",
"86151133", "广东省中山市",
"86130087", "甘肃省兰州市",
"86151746", "黑龙江省齐齐哈尔市",
"861384948", "河南省漯河市",
"861819805", "甘肃省白银市",
"861865175", "江苏省盐城市",
"861311087", "福建省福州市",
"861470747", "湖南省永州市",
"861347192", "广西玉林市",
"861898779", "云南省昆明市",
"861800680", "浙江省绍兴市",
"861806771", "浙江省台州市",
"861598336", "四川省乐山市",
"86136410", "北京市",
"861590905", "新疆昌吉回族自治州",
"861365499", "辽宁省沈阳市",
"86136697", "云南省昆明市",
"86178061", "山东省临沂市",
"861856704", "河南省开封市",
"861397186", "湖北省荆门市",
"861780262", "江苏省徐州市",
"861805481", "福建省厦门市",
"861760544", "山东省德州市",
"861345843", "四川省绵阳市",
"861800878", "云南省楚雄彝族自治州",
"861524787", "内蒙古锡林郭勒盟",
"861330965", "安徽省蚌埠市",
"861348297", "河北省秦皇岛市",
"861788800", "西藏拉萨市",
"861309497", "江苏省镇江市",
"861876245", "江苏省无锡市",
"861325952", "宁夏石嘴山市",
"861847625", "广东省肇庆市",
"86138589", "浙江省金华市",
"861374081", "四川省成都市",
"86186827", "四川省巴中市",
"86184530", "山东省菏泽市",
"861360756", "福建省漳州市",
"861303998", "黑龙江省哈尔滨市",
"861502956", "陕西省汉中市",
"861539474", "内蒙古兴安盟",
"861524036", "江苏省盐城市",
"861586970", "湖南省株洲市",
"861807588", "湖南省衡阳市",
"861872432", "黑龙江省黑河市",
"861844993", "新疆哈密地区",
"861533160", "云南省临沧市",
"861529983", "新疆伊犁哈萨克自治州",
"86153921", "福建省泉州市",
"861709935", "浙江省丽水市",
"861568873", "山东省威海市",
"861351821", "四川省成都市",
"861514790", "内蒙古巴彦淖尔市",
"861473802", "河南省安阳市",
"861339295", "广东省珠海市",
"86136977", "广东省珠海市",
"861539012", "四川省达州市",
"86187352", "山西省大同市",
"861809971", "新疆塔城地区",
"861566512", "江苏省连云港市",
"86132202", "重庆市",
"861868414", "贵州省遵义市",
"861453684", "陕西省西安市",
"861813941", "新疆巴音郭楞蒙古自治州",
"86794", "江西省抚州市",
"861535984", "福建省泉州市",
"861537742", "湖南省常德市",
"861520748", "湖南省长沙市",
"861351546", "山东省东营市",
"861870727", "湖北省襄樊市",
"861563697", "黑龙江省大庆市",
"861534575", "浙江省绍兴市",
"861869739", "河南省许昌市",
"861311534", "黑龙江省佳木斯市",
"861364673", "浙江省嘉兴市",
"861586538", "山东省泰安市",
"861329502", "福建省泉州市",
"86184476", "内蒙古呼和浩特市",
"86155587", "浙江省温州市",
"861301664", "广东省东莞市",
"861565086", "安徽省阜阳市",
"861882036", "广东省肇庆市",
"861816032", "新疆喀什地区",
"861884647", "黑龙江省七台河市",
"861517549", "河北省唐山市",
"86181623", "湖北省武汉市",
"861332858", "福建省三明市",
"861780340", "山西省晋城市",
"861536758", "湖南省怀化市",
"861335659", "广东省江门市",
"861377566", "江苏省泰州市",
"861325668", "山东省济南市",
"861882787", "江西省赣州市",
"861373177", "河北省秦皇岛市",
"861778955", "甘肃省武威市",
"861817673", "广西柳州市",
"861350001", "广东省广州市",
"861818938", "甘肃省酒泉市",
"861820941", "甘肃省甘南藏族自治州",
"861327516", "江苏省徐州市",
"861576719", "广东省湛江市",
"861362871", "云南省西双版纳傣族自治州",
"861571831", "广东省茂名市",
"861593082", "河北省衡水市",
"861560680", "浙江省舟山市",
"86177397", "河南省郑州市",
"861302597", "广西梧州市",
"861709521", "江苏省盐城市",
"861708343", "山西省大同市",
"861572410", "广东省深圳市",
"861888669", "四川省广元市",
"861774011", "四川省广安市",
"86187506", "福建省泉州市",
"861594990", "山东省淄博市",
"861771190", "西藏拉萨市",
"861321886", "江苏省苏州市",
"861869365", "甘肃省武威市",
"861532574", "浙江省宁波市",
"861780829", "四川省广元市",
"861322824", "四川省绵阳市",
"861879532", "宁夏石嘴山市",
"861895449", "山东省聊城市",
"861363915", "贵州省六盘水市",
"861880688", "浙江省丽水市",
"861865001", "福建省厦门市",
"861453745", "湖南省怀化市",
"86130446", "上海市",
"861557778", "广西柳州市",
"861776791", "吉林省吉林市",
"861477092", "江西省赣州市",
"861592547", "云南省临沧市",
"861709846", "浙江省台州市",
"861508072", "湖南省益阳市",
"86138068", "浙江省温州市",
"861893402", "广东省湛江市",
"861317020", "安徽省淮南市",
"861311450", "黑龙江省哈尔滨市",
"86138011", "北京市",
"861880870", "云南省昭通市",
"861511859", "广东省佛山市",
"861893222", "江苏省南通市",
"861365631", "山东省威海市",
"861770898", "西藏拉萨市",
"861350406", "辽宁省锦州市",
"861857376", "湖南省衡阳市",
"86176020", "广东省广州市",
"86187518", "江苏省南京市",
"861553538", "山西省太原市",
"861829303", "甘肃省临夏回族自治州",
"861560878", "云南省楚雄彝族自治州",
"861335149", "黑龙江省大庆市",
"861354626", "山西省吕梁市",
"861351744", "湖南省张家界市",
"86170751", "江苏省南京市",
"86187561", "安徽省淮北市",
"861556581", "河南省濮阳市",
"861866454", "广东省广州市",
"861383990", "河南省驻马店市",
"861882431", "广东省深圳市",
"86138428", "辽宁省大连市",
"861855554", "安徽省淮南市",
"861568552", "贵州省遵义市",
"861532253", "广东省湛江市",
"861304317", "河北省沧州市",
"861359790", "湖北省十堰市",
"861887580", "浙江省温州市",
"861865406", "安徽省安庆市",
"861325018", "广东省汕头市",
"861840712", "湖北省孝感市",
"861813346", "安徽省滁州市",
"861379333", "山东省淄博市",
"861890733", "湖南省株洲市",
"861850631", "山东省威海市",
"861530851", "贵州省贵阳市",
"86131893", "广东省肇庆市",
"861760746", "湖南省永州市",
"86182566", "安徽省池州市",
"861339600", "湖北省荆州市",
"861452607", "江苏省无锡市",
"861373903", "湖南省湘西土家族苗族自治州",
"861453623", "江苏省盐城市",
"861308134", "辽宁省抚顺市",
"86155263", "湖南省益阳市",
"861597740", "广西桂林市",
"861301014", "河北省衡水市",
"861524699", "黑龙江省黑河市",
"861886643", "山东省淄博市",
"861360554", "安徽省淮南市",
"861510705", "江西省宜春市",
"861528881", "山东省潍坊市",
"861889925", "新疆和田地区",
"861772863", "广东省江门市",
"861378836", "广西南宁市",
"861387249", "湖北省宜昌市",
"861452322", "河南省郑州市",
"861834055", "辽宁省朝阳市",
"861780917", "陕西省宝鸡市",
"861808873", "黑龙江省牡丹江市",
"861803763", "河南省周口市",
"861313281", "广西南宁市",
"861505994", "福建省龙岩市",
"861858566", "贵州省黔南布依族苗族自治州",
"861894894", "广东省清远市",
"861570311", "河北省石家庄市",
"861560379", "河南省洛阳市",
"861315685", "山东省青岛市",
"861895403", "山东省东营市",
"861860736", "湖南省常德市",
"861807091", "广西南宁市",
"861514229", "辽宁省朝阳市",
"861777105", "湖北省黄石市",
"861806114", "江苏省徐州市",
"861360152", "江苏省无锡市",
"86151519", "江苏省常州市",
"861587808", "广西梧州市",
"861326492", "湖北省恩施土家族苗族自治州",
"861315115", "江苏省苏州市",
"861572973", "四川省雅安市",
"861868259", "四川省宜宾市",
"861309285", "四川省达州市",
"861318662", "江苏省连云港市",
"861308532", "云南省普洱市",
"861521998", "广东省惠州市",
"861335977", "黑龙江省鹤岗市",
"861348485", "陕西省汉中市",
"861362331", "河北省石家庄市",
"861511358", "广东省湛江市",
"861571371", "河南省郑州市",
"861395944", "福建省宁德市",
"861770399", "河南省许昌市",
"861708309", "河北省石家庄市",
"861510629", "江苏省南通市",
"861569945", "新疆喀什地区",
"861825932", "福建省南平市",
"861566623", "山东省潍坊市",
"861336931", "甘肃省兰州市",
"861845896", "浙江省衢州市",
"861355736", "广西桂林市",
"861375902", "云南省普洱市",
"861324774", "江西省抚州市",
"86188607", "云南省昆明市",
"861537146", "江苏省苏州市",
"861808785", "云南省昆明市",
"861333988", "湖北省咸宁市",
"861342834", "广东省汕头市",
"86158570", "浙江省衢州市",
"861317048", "湖南省长沙市",
"861818147", "四川省巴中市",
"861859091", "陕西省汉中市",
"861355087", "四川省泸州市",
"861500534", "山东省德州市",
"861339487", "内蒙古巴彦淖尔市",
"86159582", "浙江省宁波市",
"861364721", "湖北省武汉市",
"861452480", "内蒙古呼伦贝尔市",
"86180492", "陕西省西安市",
"861842907", "陕西省宝鸡市",
"861378376", "河南省信阳市",
"86139925", "陕西省安康市",
"861817242", "广西南宁市",
"861355167", "四川省乐山市",
"861332359", "宁夏银川市",
"861387203", "湖北省黄冈市",
"861322368", "山西省临汾市",
"861566745", "陕西省汉中市",
"861829820", "安徽省马鞍山市",
"861360642", "山东省青岛市",
"861351392", "河南省濮阳市",
"861830690", "云南省西双版纳傣族自治州",
"861301705", "贵州省黔西南布依族苗族自治州",
"861373949", "四川省成都市",
"861318474", "河北省石家庄市",
"861365700", "江西省南昌市",
"861537515", "安徽省淮南市",
"861364242", "广东省阳江市",
"861822417", "四川省雅安市",
"861504982", "内蒙古巴彦淖尔市",
"861700761", "广东省中山市",
"861767113", "湖北省十堰市",
"86136404", "广东省中山市",
"861807496", "广西梧州市",
"86152381", "河南省南阳市",
"861318012", "河北省秦皇岛市",
"861580974", "青海省海南藏族自治州",
"861782046", "广东省清远市",
"861347796", "湖北省十堰市",
"861391216", "江苏省连云港市",
"861780328", "河北省衡水市",
"861323895", "辽宁省葫芦岛市",
"861872467", "黑龙江省鸡西市",
"86131821", "江苏省盐城市",
"861315821", "贵州省遵义市",
"861335103", "黑龙江省牡丹江市",
"861331727", "湖北省襄樊市",
"861821915", "广东省揭阳市",
"861708477", "内蒙古包头市",
"861347315", "河北省唐山市",
"861880330", "河北省邯郸市",
"861339731", "湖南省长沙市",
"86147213", "四川省成都市",
"86187459", "黑龙江省大庆市",
"861818657", "湖北省荆州市",
"861560407", "辽宁省营口市",
"861372318", "河南省焦作市",
"861820975", "青海省果洛藏族自治州",
"861300859", "陕西省延安市",
"861316918", "广东省茂名市",
"861850700", "江西省南昌市",
"861510472", "内蒙古包头市",
"861500450", "黑龙江省哈尔滨市",
"861390276", "广东省揭阳市",
"861329104", "甘肃省白银市",
"861374802", "内蒙古包头市",
"861563920", "河南省鹤壁市",
"861335441", "山东省淄博市",
"861768748", "广西河池市",
"861318197", "山东省东营市",
"861512859", "河北省承德市",
"861360753", "福建省莆田市",
"861502953", "陕西省渭南市",
"861524033", "江苏省连云港市",
"861829901", "新疆喀什地区",
"861889427", "甘肃省临夏回族自治州",
"861813634", "江苏省宿迁市",
"861536278", "广东省珠海市",
"861870587", "浙江省温州市",
"861312450", "黑龙江省哈尔滨市",
"861844996", "新疆伊犁哈萨克自治州",
"861890534", "山东省德州市",
"861881431", "广东省茂名市",
"86836", "四川省甘孜藏族自治州",
"861320542", "山东省济南市",
"861556360", "山东省潍坊市",
"86145824", "安徽省合肥市",
"861397183", "湖北省荆门市",
"86159492", "江苏省无锡市",
"861347428", "陕西省渭南市",
"861345846", "四川省达州市",
"861808211", "江苏省镇江市",
"86180582", "浙江省宁波市",
"861337548", "山东省泰安市",
"861347208", "河北省承德市",
"86187378", "河南省开封市",
"861372205", "内蒙古通辽市",
"861333749", "湖北省恩施土家族苗族自治州",
"86136336", "黑龙江省哈尔滨市",
"861837802", "广西柳州市",
"861557258", "湖北省荆门市",
"861820808", "西藏昌都地区",
"861535321", "陕西省铜川市",
"861309711", "江西省抚州市",
"861351543", "山东省滨州市",
"86186991", "新疆乌鲁木齐市",
"861533955", "贵州省黔东南苗族侗族自治州",
"861555265", "山东省泰安市",
"861529986", "新疆塔城地区",
"86155808", "湖南省长沙市",
"861568876", "山东省莱芜市",
"861373301", "安徽省六安市",
"861394844", "内蒙古乌兰察布市",
"861576637", "广东省梅州市",
"86135692", "河南省南阳市",
"861558282", "山西省晋城市",
"861330150", "江苏省常州市",
"861707730", "湖南省岳阳市",
"861476038", "福建省南平市",
"861708194", "福建省厦门市",
"861528544", "贵州省铜仁地区",
"861334877", "湖南省益阳市",
"861820343", "山西省阳泉市",
"861534300", "湖南省岳阳市",
"861834589", "黑龙江省伊春市",
"861336873", "云南省红河哈尼族彝族自治州",
"86137454", "黑龙江省佳木斯市",
"861340314", "河北省承德市",
"861308356", "江苏省南通市",
"861450983", "新疆塔城地区",
"861338512", "贵州省遵义市",
"861312534", "江西省吉安市",
"86155816", "湖南省长沙市",
"861457018", "山东省东营市",
"861856928", "湖南省邵阳市",
"861565024", "山东省临沂市",
"861521460", "黑龙江省大庆市",
"861319959", "黑龙江省鹤岗市",
"86150875", "云南省保山市",
"86130772", "湖南省常德市",
"861890450", "黑龙江省哈尔滨市",
"861823845", "河南省周口市",
"861329399", "山西省运城市",
"861331858", "广东省韶关市",
"861335046", "四川省广安市",
"861863368", "河北省衡水市",
"86152194", "广东省深圳市",
"861554550", "黑龙江省绥化市",
"86185822", "四川省南充市",
"861309853", "贵州省安顺市",
"861873999", "河南省开封市",
"86135972", "广西柳州市",
"861571410", "辽宁省铁岭市",
"86184720", "湖北省武汉市",
"861843294", "河北省秦皇岛市",
"861772190", "四川省绵阳市",
"861335702", "浙江省衢州市",
"86187083", "四川省自贡市",
"861572831", "广东省揭阳市",
"861361871", "云南省昆明市",
"861598333", "四川省眉山市",
"86184742", "湖南省长沙市",
"861895141", "江苏省南通市",
"861302629", "江西省宜春市",
"86186409", "辽宁省大连市",
"861305828", "广东省汕头市",
"861301597", "福建省莆田市",
"861360811", "四川省绵阳市",
"861317292", "广东省清远市",
"861769706", "青海省玉树藏族自治州",
"861344077", "内蒙古呼和浩特市",
"861311733", "湖南省株洲市",
"861597496", "云南省保山市",
"861565069", "安徽省宿州市",
"861313004", "辽宁省大连市",
"861396550", "安徽省黄山市",
"861708941", "广东省肇庆市",
"861862895", "四川省成都市",
"861570470", "内蒙古呼伦贝尔市",
"861810936", "甘肃省张掖市",
"861398919", "四川省南充市",
"861860692", "福建省厦门市",
"86186671", "浙江省杭州市",
"861306911", "吉林省长春市",
"861330640", "山东省济南市",
"861517015", "江西省赣州市",
"861509187", "陕西省汉中市",
"861330432", "吉林省长春市",
"86180328", "河北省石家庄市",
"861361845", "湖南省郴州市",
"861302705", "山西省晋中市",
"86177084", "湖南省长沙市",
"861352392", "河南省鹤壁市",
"861334337", "河北省沧州市",
"86139410", "辽宁省铁岭市",
"861778922", "陕西省渭南市",
"861330628", "江苏省南通市",
"861560905", "四川省内江市",
"861777473", "广西梧州市",
"861841907", "甘肃省酒泉市",
"861820477", "内蒙古鄂尔多斯市",
"86139697", "山东省青岛市",
"861331359", "山西省运城市",
"861327438", "吉林省松原市",
"861336785", "广西玉林市",
"861532885", "四川省南充市",
"861569833", "山西省太原市",
"861325531", "山东省济南市",
"861781702", "广东省湛江市",
"861327307", "河南省漯河市",
"861530682", "浙江省湖州市",
"861353693", "广东省汕头市",
"861472997", "陕西省商洛市",
"86134615", "河南省漯河市",
"861351509", "福建省南平市",
"861808931", "甘肃省兰州市",
"861305840", "广东省广州市",
"861527688", "新疆塔城地区",
"86136873", "湖南省长沙市",
"861363100", "广东省潮州市",
"861814066", "湖北省武汉市",
"861896939", "浙江省金华市",
"861815260", "湖南省岳阳市",
"861871467", "黑龙江省鸡西市",
"861536827", "云南省昭通市",
"861332727", "湖南省益阳市",
"861333703", "内蒙古巴彦淖尔市",
"861454696", "广东省湛江市",
"861577168", "陕西省宝鸡市",
"861471495", "广东省汕头市",
"861310351", "山西省太原市",
"8618301", "北京市",
"861899778", "新疆阿勒泰地区",
"86147801", "四川省眉山市",
"861537049", "江苏省南通市",
"861370378", "河南省开封市",
"861331034", "内蒙古鄂尔多斯市",
"861709462", "浙江省衢州市",
"861538434", "广东省珠海市",
"861785858", "浙江省衢州市",
"861586416", "山东省德州市",
"861869032", "新疆乌鲁木齐市",
"861582914", "陕西省咸阳市",
"861379211", "山东省泰安市",
"86186556", "安徽省安庆市",
"861877228", "湖北省黄石市",
"861305329", "安徽省池州市",
"861587941", "江西省吉安市",
"861886752", "浙江省杭州市",
"861823871", "河南省商丘市",
"861529293", "新疆喀什地区",
"861770502", "福建省福州市",
"861708592", "福建省福州市",
"86137740", "湖北省荆门市",
"86151379", "河南省洛阳市",
"861367555", "安徽省黄山市",
"861528142", "四川省宜宾市",
"861768966", "福建省宁德市",
"861386693", "安徽省滁州市",
"861826630", "山东省威海市",
"861809010", "四川省雅安市",
"86187131", "河北省石家庄市",
"861571973", "青海省西宁市",
"861362933", "甘肃省平凉市",
"861500733", "湖南省株洲市",
"861370339", "河北省石家庄市",
"861365568", "安徽省阜阳市",
"861899739", "青海省海西蒙古族藏族自治州",
"861887299", "湖北省随州市",
"861358240", "河北省秦皇岛市",
"861572371", "广西南宁市",
"86134664", "北京市",
"861313396", "江西省吉安市",
"861806626", "浙江省温州市",
"861361331", "河北省石家庄市",
"861303647", "四川省达州市",
"861893255", "河北省秦皇岛市",
"861454133", "河北省秦皇岛市",
"861510597", "福建省厦门市",
"861814555", "黑龙江省绥化市",
"861535294", "青海省海南藏族自治州",
"86147866", "湖南省邵阳市",
"861369602", "四川省南充市",
"861323956", "宁夏石嘴山市",
"861522998", "陕西省商洛市",
"861831604", "广东省肇庆市",
"861570913", "陕西省渭南市",
"861596512", "山东省枣庄市",
"861534823", "四川省南充市",
"861576958", "宁夏银川市",
"861516971", "山东省德州市",
"861347440", "陕西省延安市",
"86188346", "山西省晋城市",
"861452355", "河南省驻马店市",
"861327479", "内蒙古锡林郭勒盟",
"86189827", "四川省泸州市",
"861850568", "安徽省亳州市",
"861889952", "新疆乌鲁木齐市",
"861335475", "内蒙古通辽市",
"861891953", "四川省广安市",
"86134796", "江西省吉安市",
"86183422", "辽宁省大连市",
"861520963", "宁夏吴忠市",
"861370054", "山西省太原市",
"861859740", "福建省三明市",
"86150302", "河北省保定市",
"861538550", "安徽省滁州市",
"861337520", "江苏省淮安市",
"861814616", "福建省龙岩市",
"86183062", "江苏省苏州市",
"861858589", "贵州省安顺市",
"86182743", "湖南省邵阳市",
"861558300", "四川省南充市",
"86182136", "云南省红河哈尼族彝族自治州",
"86158310", "河北省邯郸市",
"861587194", "湖北省咸宁市",
"861367616", "广东省江门市",
"861336333", "河北省衡水市",
"861892351", "广东省潮州市",
"861520580", "浙江省舟山市",
"861532621", "辽宁省丹东市",
"861575147", "江苏省淮安市",
"861860549", "山东省临沂市",
"861536466", "山西省晋城市",
"861770693", "福建省宁德市",
"861871826", "广东省揭阳市",
"861510323", "河北省张家口市",
"861825128", "江苏省淮安市",
"861373459", "黑龙江省大庆市",
"86177356", "山西省晋城市",
"861592522", "云南省昆明市",
"861323790", "江西省新余市",
"861554001", "内蒙古兴安盟",
"861573850", "河南省郑州市",
"861859933", "新疆昌吉回族自治州",
"861887254", "湖北省宜昌市",
"861535259", "新疆塔城地区",
"86135384", "广东省东莞市",
"861898926", "四川省凉山彝族自治州",
"861801124", "四川省达州市",
"861589769", "湖北省孝感市",
"861328405", "黑龙江省绥化市",
"86181648", "贵州省贵阳市",
"861763501", "山西省忻州市",
"861836106", "江苏省盐城市",
"861871541", "安徽省安庆市",
"861332143", "吉林省四平市",
"861560673", "浙江省嘉兴市",
"861388164", "四川省雅安市",
"861336093", "广东省清远市",
"861532964", "贵州省黔南布依族苗族自治州",
"86181192", "新疆石河子市",
"861770767", "广东省揭阳市",
"861313787", "河南省驻马店市",
"861878435", "四川省阿坝藏族羌族自治州",
"86710", "湖北省襄樊市\、襄樊市",
"86150046", "黑龙江省哈尔滨市",
"861453828", "四川省阿坝藏族羌族自治州",
"86147988", "海南省海口市",
"861898760", "云南省文山壮族苗族自治州",
"861339917", "陕西省宝鸡市",
"86139311", "河北省石家庄市",
"861835154", "江苏省盐城市",
"861362740", "湖南省岳阳市",
"861593195", "河北省邢台市",
"861829725", "青海省果洛藏族自治州",
"861501229", "云南省昭通市",
"861817680", "广西钦州市",
"861361857", "贵州省贵阳市",
"861370099", "四川省宜宾市",
"86139368", "黑龙江省大庆市",
"861308009", "吉林省松原市",
"861500940", "甘肃省临夏回族自治州",
"861533138", "四川省成都市",
"861366449", "吉林省白山市",
"861355549", "黑龙江省大庆市",
"86188002", "上海市",
"861568491", "湖南省岳阳市",
"861390990", "新疆克拉玛依市",
"861801169", "四川省南充市",
"861819499", "新疆和田地区",
"86186487", "内蒙古巴彦淖尔市",
"861886848", "浙江省金华市",
"86187819", "四川省成都市",
"86180010", "北京市",
"861319175", "河北省唐山市",
"861477185", "湖北省仙桃市",
"861532929", "贵州省黔西南布依族苗族自治州",
"861884622", "黑龙江省七台河市",
"86159343", "山西省长治市",
"861364680", "浙江省舟山市",
"861303145", "河北省邯郸市",
"86158028", "四川省成都市",
"861877097", "江西省赣州市",
"861808880", "广东省惠州市",
"861303516", "湖北省孝感市",
"861533179", "云南省昭通市",
"861813606", "江苏省苏州市",
"861500317", "河北省沧州市",
"861452347", "河南省焦作市",
"861331394", "福建省福州市",
"861471846", "广东省揭阳市",
"861801089", "安徽省马鞍山市",
"861569455", "黑龙江省绥化市",
"861339864", "河北省保定市",
"86138443", "吉林省延边朝鲜族自治州",
"861364878", "云南省楚雄彝族自治州",
"861869392", "甘肃省陇南市",
"861333352", "山西省大同市",
"861339340", "山西省太原市",
"861810588", "浙江省金华市",
"861886303", "山东省潍坊市",
"861471521", "广东省佛山市",
"86158411", "辽宁省大连市",
"861893688", "江苏省南京市",
"861787508", "广东省汕尾市",
"861346893", "陕西省西安市",
"861571605", "福建省龙岩市",
"861554406", "河南省信阳市",
"861316342", "黑龙江省哈尔滨市",
"861380028", "四川省成都市",
"861890506", "福建省泉州市",
"861817878", "广西钦州市",
"861569561", "安徽省淮北市",
"861332653", "广东省韶关市",
"861875295", "江苏省镇江市",
"861310837", "四川省阿坝藏族羌族自治州",
"861325863", "黑龙江省大庆市",
"861808639", "湖北省孝感市",
"861316488", "福建省厦门市",
"861887573", "河北省邢台市",
"86181577", "浙江省温州市",
"861700834", "浙江省台州市",
"861590581", "浙江省杭州市",
"861876390", "山东省青岛市",
"861311928", "陕西省榆林市",
"861846215", "山东省烟台市",
"861586924", "浙江省丽水市",
"861334097", "四川省凉山彝族自治州",
"861361496", "辽宁省锦州市",
"861320699", "黑龙江省佳木斯市",
"861367547", "山东省济宁市",
"861313431", "吉林省长春市",
"861853848", "河南省洛阳市",
"861539200", "福建省福州市",
"861895677", "安徽省亳州市",
"861339829", "四川省泸州市",
"861457190", "浙江省台州市",
"86176434", "吉林省四平市",
"86189258", "广东省东莞市",
"861829643", "江西省上饶市",
"861561063", "山东省潍坊市",
"861821485", "安徽省宿州市",
"861892443", "广东省河源市",
"861880883", "云南省临沧市",
"861336717", "湖北省宜昌市",
"861802066", "福建省漳州市",
"861532817", "四川省成都市",
"861516638", "山东省烟台市",
"861459419", "云南省普洱市",
"861303655", "四川省泸州市",
"861867705", "广西南宁市",
"86151600", "福建省厦门市",
"8618044", "黑龙江省哈尔滨市",
"86132512", "重庆市",
"86150781", "广西梧州市",
"861452473", "黑龙江省鸡西市",
"861768852", "广东省江门市",
"861700267", "广东省深圳市",
"861515285", "江苏省宿迁市",
"861309435", "云南省保山市",
"861533947", "甘肃省嘉峪关市",
"861800360", "黑龙江省哈尔滨市",
"861335353", "山西省阳泉市",
"86150158", "广东省佛山市",
"861453277", "山西省晋城市",
"86186433", "吉林省延边朝鲜族自治州",
"861760578", "浙江省丽水市",
"861879009", "河南省信阳市",
"861311940", "甘肃省兰州市",
"861867629", "广东省中山市",
"861862446", "辽宁省辽阳市",
"861539448", "福建省厦门市",
"861310409", "黑龙江省大庆市",
"861355503", "黑龙江省双鸭山市",
"861509685", "云南省红河哈尼族彝族自治州",
"861366403", "内蒙古包头市",
"861518262", "四川省自贡市",
"861899900", "新疆巴音郭楞蒙古自治州",
"861501443", "广东省湛江市",
"861398466", "贵州省黔西南布依族苗族自治州",
"861319994", "新疆昌吉回族自治州",
"861308043", "河北省张家口市",
"861364379", "河南省洛阳市",
"861323862", "云南省曲靖市",
"86151806", "江西省九江市",
"861571764", "河北省廊坊市",
"861509115", "陕西省西安市",
"861329354", "山西省晋中市",
"86130919", "浙江省温州市",
"861597845", "河南省驻马店市",
"861363485", "黑龙江省伊春市",
"861304534", "黑龙江省牡丹江市",
"861588909", "西藏拉萨市",
"861871992", "新疆阿勒泰地区",
"861880775", "广西玉林市",
"861557685", "湖南省张家界市",
"861560721", "湖北省荆州市",
"861539382", "云南省西双版纳傣族自治州",
"861889866", "广东省湛江市",
"86135719", "陕西省西安市",
"861709997", "广东省中山市",
"861302921", "辽宁省丹东市",
"861881396", "广东省广州市",
"861452230", "浙江省衢州市",
"86186272", "湖北省荆州市",
"861521714", "广东省东莞市",
"861780731", "湖南省长沙市",
"861575938", "福建省莆田市",
"861572980", "四川省德阳市",
"861359895", "河南省许昌市",
"861520774", "广西梧州市",
"861351365", "山西省临汾市",
"861552572", "山西省运城市",
"861563635", "黑龙江省鸡西市",
"861867664", "广东省云浮市",
"86155981", "内蒙古呼和浩特市",
"861329039", "山东省日照市",
"861339328", "河北省衡水市",
"861331401", "辽宁省沈阳市",
"861335567", "安徽省亳州市",
"861571729", "湖北省孝感市",
"861860503", "福建省三明市",
"861816509", "陕西省西安市",
"861708649", "江苏省苏州市",
"861301323", "河北省石家庄市",
"86159965", "江苏省南通市",
"861512894", "河北省廊坊市",
"86183932", "甘肃省定西市",
"86157649", "内蒙古包头市",
"861300982", "黑龙江省大庆市",
"861896700", "浙江省衢州市",
"861867014", "江西省赣州市",
"86152245", "广西北海市",
"861820451", "黑龙江省哈尔滨市",
"861557821", "广西柳州市",
"861580564", "安徽省六安市",
"861343510", "广东省韶关市",
"861366882", "山东省济南市",
"861560242", "广东省佛山市",
"861886820", "浙江省湖州市",
"861857198", "湖北省荆门市",
"861319141", "内蒙古呼和浩特市",
"861779033", "四川省遂宁市",
"861303171", "山东省济南市",
"861855627", "江苏省宿迁市",
"861453840", "四川省甘孜藏族自治州",
"861329078", "福建省厦门市",
"861472674", "四川省自贡市",
"861707943", "河南省驻马店市",
"861820565", "安徽省合肥市",
"861869744", "内蒙古锡林郭勒盟",
"861331742", "湖南省湘潭市",
"86151818", "四川省达州市",
"86135291", "云南省昆明市",
"861760539", "山东省临沂市",
"861892264", "广东省肇庆市",
"861811468", "江苏省常州市",
"861364227", "广东省云浮市",
"861809198", "陕西省榆林市",
"861509546", "甘肃省定西市",
"861501837", "广东省汕头市",
"861310377", "河南省南阳市",
"861304450", "福建省漳州市",
"861326551", "广东省广州市",
"86151861", "贵州省毕节地区",
"861774986", "河北省秦皇岛市",
"861533310", "河北省邯郸市",
"861508984", "广东省江门市",
"861801522", "江苏省南通市",
"861580529", "江苏省镇江市",
"86187967", "江苏省泰州市",
"861591186", "云南省怒江傈僳族自治州",
"861504859", "内蒙古巴彦淖尔市",
"861318695", "浙江省杭州市",
"861825140", "江苏省连云港市",
"861364338", "河北省石家庄市",
"861384974", "河南省信阳市",
"861360627", "江苏省南通市",
"861817407", "江西省赣州市",
"861771531", "江苏省无锡市",
"861379639", "黑龙江省双鸭山市",
"861399596", "湖北省黄石市",
"861509821", "山东省菏泽市",
"861590676", "浙江省台州市",
"861802089", "福建省龙岩市",
"861860665", "浙江省温州市",
"861332394", "河南省周口市",
"861315258", "广西桂林市",
"861527775", "广西玉林市",
"861350434", "吉林省四平市",
"861862862", "陕西省宝鸡市",
"861821987", "甘肃省酒泉市",
"861889388", "甘肃省庆阳市",
"86158174", "广东省深圳市",
"861557900", "江西省新余市",
"861818723", "云南省曲靖市",
"861554284", "辽宁省锦州市",
"861705029", "江西省南昌市",
"861317265", "广东省珠海市",
"861535779", "安徽省池州市",
"86139092", "陕西省西安市",
"861778138", "四川省德阳市",
"861550684", "广西百色市",
"861880090", "四川省遂宁市",
"861533471", "内蒙古呼和浩特市",
"861315067", "云南省丽江市",
"86147634", "山东省潍坊市",
"861309658", "山西省大同市",
"861869509", "湖北省孝感市",
"86134836", "河北省廊坊市",
"861347387", "河北省石家庄市",
"861818155", "四川省自贡市",
"861458533", "河南省濮阳市",
"861570802", "西藏日喀则地区",
"861381346", "江苏省徐州市",
"861572605", "山东省潍坊市",
"861362496", "辽宁省盘锦市",
"861563458", "山东省潍坊市",
"861811990", "安徽省宣城市",
"861513419", "辽宁省锦州市",
"861523326", "河北省廊坊市",
"86189158", "江苏省常州市",
"861459681", "新疆伊犁哈萨克自治州",
"86135123", "重庆市",
"861530877", "云南省玉溪市",
"861558628", "湖北省武汉市",
"86181317", "河北省沧州市",
"861590844", "四川省巴中市",
"86189781", "广西崇左市",
"861397170", "湖北省黄冈市",
"861313810", "广东省珠海市",
"86180914", "陕西省商洛市",
"861459111", "广西来宾市",
"861503330", "河北省保定市",
"861512982", "陕西省西安市",
"861358112", "山东省枣庄市",
"861378804", "广西梧州市",
"861586986", "湖南省邵阳市",
"861569957", "吉林省长春市",
"861761436", "吉林省白城市",
"861319403", "福建省宁德市",
"861531817", "山东省济宁市",
"861898508", "贵州省黔南布依族苗族自治州",
"861891443", "江苏省泰州市",
"861889442", "甘肃省酒泉市",
"861366651", "浙江省湖州市",
"861509900", "新疆喀什地区",
"861591522", "广东省佛山市",
"861775886", "黑龙江省齐齐哈尔市",
"861325190", "浙江省宁波市",
"861562183", "山东省枣庄市",
"861539135", "云南省昆明市",
"861885133", "江苏省南通市",
"861350550", "安徽省滁州市",
"861588341", "四川省德阳市",
"86435", "吉林省通化市\、梅河口市",
"86139850", "贵州省贵阳市",
"861570483", "内蒙古阿拉善盟",
"861894859", "广东省惠州市",
"861311506", "江苏省无锡市",
"86152480", "内蒙古呼和浩特市",
"861872826", "四川省资阳市",
"861478140", "四川省达州市",
"861845445", "山东省聊城市",
"861899546", "宁夏中卫市",
"861599198", "陕西省西安市",
"861871884", "广东省广州市",
"86145712", "黑龙江省黑河市",
"861872541", "云南省玉溪市",
"861370633", "山东省日照市",
"861309148", "黑龙江省伊春市",
"861800676", "浙江省台州市",
"861899821", "广东省汕头市",
"861705184", "河南省郑州市",
"86181292", "新疆乌鲁木齐市",
"861563312", "河北省保定市",
"861889701", "青海省西宁市",
"86187632", "山东省枣庄市",
"861330300", "河北省邯郸市",
"86155509", "山东省临沂市",
"86185765", "广东省佛山市",
"861522005", "广东省深圳市",
"861770354", "山西省晋中市",
"861339415", "辽宁省丹东市",
"861705614", "四川省成都市",
"861362857", "贵州省毕节地区",
"861357148", "陕西省汉中市",
"861801461", "江苏省连云港市",
"861820603", "福建省莆田市",
"861319882", "四川省南充市",
"861477872", "广东省湛江市",
"861807331", "湖南省株洲市",
"861777607", "广西柳州市",
"861506700", "浙江省衢州市",
"861302800", "山西省运城市",
"861369794", "江西省抚州市",
"861328907", "新疆和田地区",
"86139571", "浙江省杭州市",
"86180965", "安徽省蚌埠市",
"861361740", "湖南省岳阳市",
"861707375", "河南省平顶山市",
"861831792", "江西省九江市",
"86138938", "甘肃省天水市",
"861531929", "陕西省汉中市",
"861470582", "浙江省湖州市",
"861585558", "安徽省阜阳市",
"861536489", "山西省运城市",
"86183667", "山东省济宁市",
"861450970", "新疆哈密地区",
"861334514", "山东省烟台市",
"861802169", "江苏省南通市",
"861771668", "贵州省贵阳市",
"86181525", "宁夏固原市",
"861840389", "黑龙江省哈尔滨市",
"861532780", "湖北省咸宁市",
"861336880", "云南省昆明市",
"861530240", "广东省佛山市",
"861778179", "四川省雅安市",
"861303479", "内蒙古赤峰市",
"861379093", "广东省茂名市",
"861529661", "山西省太原市",
"86145055", "黑龙江省哈尔滨市",
"861319449", "福建省龙岩市",
"861470614", "江苏省常州市",
"861530408", "辽宁省阜新市",
"86155456", "黑龙江省齐齐哈尔市",
"861592461", "云南省红河哈尼族彝族自治州",
"86137814", "河南省商丘市",
"861365939", "甘肃省陇南市",
"86152702", "江西省九江市",
"861846308", "山东省淄博市",
"861334682", "河南省濮阳市",
"861513852", "河南省濮阳市",
"861359956", "福建省漳州市",
"86132805", "山东省临沂市",
"861803195", "河北省秦皇岛市",
"861534628", "河南省鹤壁市",
"861364905", "四川省南充市",
"861894358", "吉林省通化市",
"861846437", "山东省滨州市",
"861558150", "湖南省邵阳市",
"861332742", "山西省大同市",
"861592555", "云南省怒江傈僳族自治州",
"861330282", "广东省中山市",
"861333536", "陕西省汉中市",
"861783544", "山西省晋中市",
"861534432", "吉林省延边朝鲜族自治州",
"86158335", "河北省唐山市",
"861361728", "湖北省武汉市",
"861810493", "辽宁省沈阳市",
"861530337", "河北省沧州市",
"861855599", "安徽省池州市",
"86133008", "上海市",
"861580697", "山东省聊城市",
"861857804", "广东省韶关市",
"861850939", "甘肃省陇南市",
"861840888", "云南省丽江市",
"861332006", "江西省吉安市",
"86891", "西藏拉萨市",
"861705582", "山西省太原市",
"861869543", "宁夏吴忠市",
"86135191", "陕西省西安市",
"861836043", "江苏省常州市",
"861520254", "青海省海东地区",
"861528930", "陕西省咸阳市",
"861592616", "湖北省十堰市",
"861708451", "黑龙江省哈尔滨市",
"86396", "河南省驻马店市",
"861327647", "山东省东营市",
"861360599", "福建省三明市",
"86186948", "浙江省杭州市",
"861316593", "浙江省宁波市",
"861312317", "福建省福州市",
"861524991", "安徽省池州市",
"861329136", "江苏省盐城市",
"861818671", "湖北省武汉市",
"861304385", "辽宁省朝阳市",
"861307956", "宁夏石嘴山市",
"861880255", "广东省江门市",
"861478128", "四川省攀枝花市",
"861829752", "安徽省芜湖市",
"861340537", "山东省济宁市",
"861459576", "陕西省铜川市",
"861774924", "陕西省汉中市",
"861778947", "甘肃省酒泉市",
"861847578", "广东省湛江市",
"861591124", "云南省大理白族自治州",
"861580763", "广东省清远市",
"861708565", "安徽省安庆市",
"861505677", "安徽省阜阳市",
"861329693", "内蒙古包头市",
"861520573", "浙江省嘉兴市",
"861330823", "四川省成都市",
"861374913", "河南省开封市",
"86155635", "山东省聊城市",
"861800581", "浙江省杭州市",
"861850978", "青海省西宁市",
"861369488", "江西省南昌市",
"861357937", "新疆阿克苏地区",
"86137865", "湖南省郴州市",
"861860704", "江西省抚州市",
"86134088", "云南省昭通市",
"861450413", "辽宁省抚顺市",
"861470029", "安徽省宿州市",
"861558640", "湖北省襄樊市",
"86153650", "江苏省南京市",
"861503247", "河北省保定市",
"861847539", "广东省深圳市",
"861333325", "河北省唐山市",
"861569422", "辽宁省鞍山市",
"861707835", "云南省大理白族自治州",
"861709495", "浙江省台州市",
"861376340", "黑龙江省哈尔滨市",
"861335951", "黑龙江省哈尔滨市",
"861569202", "广东省广州市",
"861867597", "广东省广州市",
"861820649", "山东省临沂市",
"861840670", "广西梧州市",
"861773406", "河北省廊坊市",
"861571357", "山西省临汾市",
"861889889", "广东省惠州市",
"861329767", "湖北省咸宁市",
"861477332", "湖南省株洲市",
"861762518", "江苏省连云港市",
"861471462", "广东省东莞市",
"861301921", "吉林省长春市",
"861355704", "广西梧州市",
"86182728", "河南省周口市",
"86186172", "广东省东莞市",
"86133016", "上海市",
"861306481", "江苏省宿迁市",
"861550512", "江苏省淮安市",
"861303622", "江西省鹰潭市",
"861571563", "安徽省宣城市",
"861872992", "陕西省榆林市",
"861894412", "江苏省南京市",
"86139435", "吉林省通化市",
"861890317", "河北省沧州市",
"861506631", "山东省威海市",
"861524144", "辽宁省本溪市",
"86188689", "浙江省宁波市",
"8613564", "上海市",
"861390468", "黑龙江省佳木斯市",
"86134630", "河北省邯郸市",
"861376829", "广西北海市",
"861572729", "湖北省孝感市",
"861327157", "河南省郑州市",
"861303307", "安徽省淮南市",
"861528127", "四川省雅安市",
"861831344", "云南省曲靖市",
"861594756", "内蒙古赤峰市",
"861309937", "甘肃省嘉峪关市",
"861503688", "河南省平顶山市",
"861533445", "云南省曲靖市",
"861352365", "河南省南阳市",
"861831860", "广东省阳江市",
"861380791", "江西省南昌市",
"861839390", "甘肃省临夏回族自治州",
"861363350", "山西省忻州市",
"861331916", "陕西省汉中市",
"861364549", "山东省临沂市",
"86145238", "海南省海口市",
"861566530", "安徽省安庆市",
"861539030", "四川省内江市",
"861520941", "甘肃省甘南藏族自治州",
"861369856", "贵州省毕节地区",
"861830713", "湖北省宜昌市",
"861478045", "四川省绵阳市",
"861337099", "山东省枣庄市",
"861517673", "河北省唐山市",
"861355839", "广西北海市",
"861786520", "山东省济宁市",
"861352638", "河南省驻马店市",
"861590385", "河南省新乡市",
"861584647", "黑龙江省牡丹江市",
"861813748", "河南省商丘市",
"861817549", "安徽省池州市",
"861760348", "山西省吕梁市",
"86151623", "江苏省苏州市",
"861809778", "新疆乌鲁木齐市",
"861886538", "山东省泰安市",
"86185587", "福建省福州市",
"861330976", "青海省玉树藏族自治州",
"861582036", "广东省阳江市",
"861768634", "山东省莱芜市",
"861843491", "山西省运城市",
"861860839", "四川省广元市",
"861475652", "河北省唐山市",
"861760482", "内蒙古兴安盟",
"861857778", "广西南宁市",
"861368567", "安徽省阜阳市",
"86136758", "浙江省杭州市",
"861529848", "江苏省扬州市",
"861350737", "湖南省益阳市",
"861303791", "宁夏石嘴山市",
"861772182", "四川省南充市",
"861874099", "甘肃省武威市",
"861308278", "山东省聊城市",
"861569365", "甘肃省白银市",
"861840897", "西藏阿里地区",
"861534566", "安徽省池州市",
"861875122", "江苏省连云港市",
"861772612", "湖南省湘潭市",
"861806939", "浙江省丽水市",
"861814443", "广东省湛江市",
"861317280", "广东省揭阳市",
"86157506", "内蒙古鄂尔多斯市",
"861872410", "江苏省扬州市",
"861314904", "广东省阳江市",
"861581178", "广东省云浮市",
"861450306", "河北省衡水市",
"86181458", "广东省深圳市",
"861380438", "吉林省松原市",
"861367443", "吉林省松原市",
"861871831", "广东省阳江市",
"861305499", "山东省济宁市",
"86130410", "北京市",
"861860680", "浙江省舟山市",
"861806978", "浙江省杭州市",
"861893162", "河北省邯郸市",
"861700544", "山东省烟台市",
"861865481", "山东省烟台市",
"861336865", "贵州省黔东南苗族侗族自治州",
"861804108", "辽宁省沈阳市",
"86157561", "安徽省淮北市",
"861373324", "河北省承德市",
"861868552", "贵州省六盘水市",
"861587580", "广东省肇庆市",
"861367837", "四川省阿坝藏族羌族自治州",
"861853538", "山西省朔州市",
"86157518", "江苏省南京市",
"861529303", "甘肃省临夏回族自治州",
"861860878", "云南省楚雄彝族自治州",
"861300756", "河南省洛阳市",
"861313426", "辽宁省大连市",
"86180827", "云南省昆明市",
"861580870", "云南省昆明市",
"861816447", "安徽省合肥市",
"861884028", "陕西省西安市",
"86177226", "广东省深圳市",
"861380479", "内蒙古兴安盟",
"861593402", "山西省大同市",
"861801953", "安徽省芜湖市",
"861808072", "四川省遂宁市",
"86135777", "云南省玉溪市",
"861538911", "陕西省延安市",
"86159302", "河北省保定市",
"861839958", "新疆喀什地区",
"861363998", "新疆昌吉回族自治州",
"861814837", "内蒙古鄂尔多斯市",
"86138653", "安徽省宣城市",
"861896626", "浙江省温州市",
"861769935", "新疆昌吉回族自治州",
"861471536", "广东省汕尾市",
"861824699", "黑龙江省双鸭山市",
"861840456", "黑龙江省黑河市",
"861350481", "黑龙江省哈尔滨市",
"861810705", "江西省宜春市",
"861586643", "山东省临沂市",
"861828881", "云南省怒江傈僳族自治州",
"861384883", "内蒙古包头市",
"861809739", "青海省海南藏族自治州",
"861513346", "河北省唐山市",
"861556506", "河南省郑州市",
"861503697", "河南省洛阳市",
"861550631", "山东省威海市",
"86184598", "福建省三明市",
"861590733", "湖南省株洲市",
"861509376", "河南省平顶山市",
"861310547", "山东省济宁市",
"861830851", "贵州省贵阳市",
"861346615", "云南省大理白族自治州",
"861345504", "山东省日照市",
"861811358", "四川省德阳市",
"861323818", "辽宁省鞍山市",
"861345102", "湖北省恩施土家族苗族自治州",
"861708580", "福建省泉州市",
"861304360", "江苏省无锡市",
"861576816", "广东省茂名市",
"861810629", "江苏省南通市",
"861507857", "广西河池市",
"86188851", "贵州省贵阳市",
"861308827", "四川省绵阳市",
"861866623", "广东省阳江市",
"861367229", "江西省赣州市",
"861518218", "四川省成都市",
"861881867", "广东省惠州市",
"861771335", "黑龙江省七台河市",
"861568259", "四川省凉山彝族自治州",
"861321789", "广西贺州市",
"861821998", "甘肃省天水市",
"861889397", "甘肃省酒泉市",
"861815435", "湖北省襄樊市",
"861306434", "四川省内江市",
"861331236", "贵州省黔南布依族苗族自治州",
"861567800", "广西来宾市",
"861302936", "辽宁省鞍山市",
"861372395", "山东省烟台市",
"861359183", "辽宁省大连市",
"861506114", "江苏省常州市",
"861814409", "福建省厦门市",
"861328594", "福建省福州市",
"861326355", "黑龙江省哈尔滨市",
"861558566", "吉林省通化市",
"861893529", "山西省晋城市",
"861475544", "安徽省淮南市",
"86151691", "山东省济南市",
"861709749", "广东省佛山市",
"861594894", "吉林省白城市",
"861870311", "河北省石家庄市",
"861860379", "河南省洛阳市",
"861777551", "四川省广元市",
"861805651", "安徽省合肥市",
"861595403", "山东省威海市",
"861885246", "江苏省无锡市",
"861316995", "广东省佛山市",
"861560736", "湖南省常德市",
"861806219", "湖北省随州市",
"861884040", "陕西省西安市",
"86185533", "山东省淄博市",
"861800534", "山东省德州市",
"86189582", "浙江省宁波市",
"861772908", "陕西省西安市",
"86150492", "内蒙古包头市",
"861535491", "内蒙古包头市",
"861518147", "四川省南充市",
"861831621", "广东省肇庆市",
"861367264", "广东省云浮市",
"861325250", "吉林省松原市",
"861537598", "福建省莆田市",
"861453454", "安徽省合肥市",
"861837146", "湖北省武汉市",
"861378778", "湖南省长沙市",
"861318751", "云南省保山市",
"86158607", "福建省厦门市",
"861780583", "浙江省嘉兴市",
"861533799", "甘肃省兰州市",
"861592953", "陕西省安康市",
"861392472", "广东省潮州市",
"861458215", "安徽省池州市",
"861478476", "内蒙古赤峰市",
"861700142", "江苏省盐城市",
"861893564", "青海省海南藏族自治州",
"861831885", "广东省揭阳市",
"861351561", "安徽省淮北市",
"861339007", "辽宁省鞍山市",
"861599617", "江苏省淮安市",
"861571965", "甘肃省庆阳市",
"861318813", "辽宁省锦州市",
"861352380", "河南省商丘市",
"861319795", "江西省宜春市",
"861308919", "吉林省通化市",
"86187386", "河南省信阳市",
"861803090", "四川省甘孜藏族自治州",
"86187877", "云南省玉溪市",
"861370256", "广东省佛山市",
"86153398", "甘肃省兰州市",
"861599187", "陕西省商洛市",
"861379414", "广东省汕头市",
"861586609", "山东省济宁市",
"86151704", "江西省南昌市",
"861810014", "浙江省宁波市",
"861529820", "四川省南充市",
"861452577", "福建省泉州市",
"861339570", "浙江省衢州市",
"861530690", "福建省南平市",
"861329429", "湖北省鄂州市",
"861863801", "河南省郑州市",
"861355338", "广东省汕头市",
"861805141", "江苏省南通市",
"861378739", "湖南省邵阳市",
"861340750", "江苏省盐城市",
"86155307", "河北省沧州市",
"861550700", "江西省宜春市",
"861810472", "内蒙古包头市",
"861478071", "四川省泸州市",
"861800450", "黑龙江省哈尔滨市",
"861352957", "云南省曲靖市",
"861813720", "河南省焦作市",
"861814377", "甘肃省兰州市",
"86139772", "广西柳州市",
"861580330", "河北省邯郸市",
"861315198", "江苏省徐州市",
"86138780", "广西玉林市",
"861864302", "吉林省通化市",
"861383894", "河南省焦作市",
"861860407", "辽宁省营口市",
"861317627", "山东省德州市",
"86184739", "湖南省邵阳市",
"861520975", "青海省果洛藏族自治州",
"861535096", "辽宁省朝阳市",
"861514089", "辽宁省阜新市",
"861572467", "辽宁省朝阳市",
"861529349", "甘肃省酒泉市",
"86132199", "四川省绵阳市",
"861367377", "河南省南阳市",
"861597326", "湖南省郴州市",
"861860338", "河北省秦皇岛市",
"86137927", "山东省威海市",
"861818295", "云南省保山市",
"861811412", "江苏省泰州市",
"861786548", "山东省泰安市",
"86182381", "河南省南阳市",
"861880974", "青海省海南藏族自治州",
"861700652", "江苏省无锡市",
"861555642", "安徽省六安市",
"861379072", "广东省中山市",
"861329464", "山西省晋城市",
"861769308", "甘肃省天水市",
"861761421", "辽宁省朝阳市",
"861458781", "湖南省永州市",
"861577877", "广西玉林市",
"86157378", "河南省开封市",
"861313484", "内蒙古鄂尔多斯市",
"861538313", "河北省张家口市",
"861590534", "山东省德州市",
"861700881", "广东省广州市",
"8634", "山西省朔州市",
"861774609", "福建省福州市",
"861508211", "四川省资阳市",
"86150582", "浙江省宁波市",
"861473006", "河北省廊坊市",
"861529901", "新疆伊犁哈萨克自治州",
"861338939", "甘肃省陇南市",
"861570587", "浙江省温州市",
"861770429", "辽宁省葫芦岛市",
"86177126", "江苏省苏州市",
"861815658", "安徽省芜湖市",
"861887592", "广东省深圳市",
"861898785", "云南省昭通市",
"861359782", "湖北省随州市",
"861589207", "福建省莆田市",
"861859535", "河南省周口市",
"861858282", "四川省达州市",
"861398532", "贵州省安顺市",
"861459346", "四川省凉山彝族自治州",
"861526442", "山东省潍坊市",
"861829986", "新疆喀什地区",
"861351679", "浙江省金华市",
"861709988", "广东省深圳市",
"861457095", "江苏省南通市",
"861876637", "山东省枣庄市",
"861816945", "湖南省怀化市",
"861804894", "四川省乐山市",
"861520808", "西藏昌都地区",
"86178659", "山东省淄博市",
"861555753", "浙江省绍兴市",
"861595994", "福建省南平市",
"861350619", "江苏省无锡市",
"86156991", "新疆乌鲁木齐市",
"861869373", "甘肃省酒泉市",
"861369995", "新疆乌鲁木齐市",
"861833955", "河南省漯河市",
"861805403", "安徽省宿州市",
"86153185", "山东省临沂市",
"861321948", "四川省绵阳市",
"861770464", "福建省泉州市",
"861537802", "甘肃省临夏回族自治州",
"861350069", "内蒙古呼和浩特市",
"861563368", "河北省石家庄市",
"861588686", "新疆巴音郭楞蒙古自治州",
"861390859", "贵州省黔西南布依族苗族自治州",
"861351638", "山东省潍坊市",
"86155822", "山西省晋中市",
"861318245", "江苏省泰州市",
"861821460", "云南省昆明市",
"861458437", "河南省平顶山市",
"861332916", "安徽省池州市",
"86155840", "吉林省吉林市",
"861376570", "贵州省六盘水市",
"861300276", "山东省莱芜市",
"86180875", "云南省保山市",
"861847803", "湖南省衡阳市",
"861351422", "辽宁省鞍山市",
"861523845", "河南省周口市",
"861590450", "黑龙江省哈尔滨市",
"861874633", "黑龙江省牡丹江市",
"861458308", "江西省新余市",
"86185816", "四川省雅安市",
"861505083", "江苏省徐州市",
"861336414", "辽宁省本溪市",
"861475709", "浙江省台州市",
"861301216", "河北省石家庄市",
"861341930", "四川省广安市",
"861534589", "浙江省金华市",
"861520343", "山西省太原市",
"861815148", "江苏省无锡市",
"861883844", "河南省商丘市",
"861773911", "河南省新乡市",
"861593090", "河北省邯郸市",
"861510936", "甘肃省张掖市",
"861537483", "内蒙古阿拉善盟",
"861870470", "内蒙古呼伦贝尔市",
"861366795", "江西省宜春市",
"86156671", "陕西省咸阳市",
"861336072", "广东省清远市",
"861560692", "福建省厦门市",
"86131565", "安徽省合肥市",
"861350024", "广东省珠海市",
"861771612", "四川省成都市",
"861817015", "江西省鹰潭市",
"861769843", "河南省商丘市",
"861319507", "宁夏吴忠市",
"861859326", "广西柳州市",
"861594982", "山东省泰安市",
"86133627", "浙江省温州市",
"861826037", "江苏省徐州市",
"861865069", "福建省漳州市",
"861771182", "宁夏石嘴山市",
"861320423", "辽宁省鞍山市",
"86130925", "江苏省常州市",
"861337633", "山东省日照市",
"86156409", "辽宁省大连市",
"86134845", "陕西省西安市",
"861595141", "江苏省南通市",
"861366316", "河北省廊坊市",
"861478519", "贵州省黔西南布依族苗族自治州",
"86153754", "安徽省合肥市",
"861815217", "甘肃省白银市",
"861303040", "内蒙古呼伦贝尔市",
"861819745", "青海省玉树藏族自治州",
"861772875", "广东省云浮市",
"861338978", "青海省西宁市",
"861477080", "江西省赣州市",
"861770672", "浙江省湖州市",
"861803775", "河南省商丘市",
"861450517", "吉林省通化市",
"861508931", "广东省惠州市",
"861394940", "河南省开封市",
"861596939", "云南省丽江市",
"86139446", "吉林省吉林市",
"861352561", "河南省濮阳市",
"861869833", "福建省漳州市",
"861805449", "山东省菏泽市",
"861572965", "四川省内江市",
"8614782", "上海市",
"861329121", "江苏省无锡市",
"861303028", "广东省云浮市",
"861351380", "河南省郑州市",
"861346332", "河北省张家口市",
"861390358", "山西省吕梁市",
"861771584", "江苏省扬州市",
"861860905", "新疆伊犁哈萨克自治州",
"861772841", "广东省佛山市",
"861520477", "内蒙古鄂尔多斯市",
"861803741", "河南省驻马店市",
"861568779", "云南省昆明市",
"861563869", "河南省平顶山市",
"86145371", "湖北省武汉市",
"86150328", "河北省石家庄市",
"861363460", "黑龙江省哈尔滨市",
"86183408", "辽宁省大连市",
"861886661", "山东省济南市",
"861583317", "河北省沧州市",
"861813989", "甘肃省定西市",
"861380655", "浙江省温州市",
"861333521", "山东省淄博市",
"861585044", "江苏省镇江市",
"861839719", "青海省黄南藏族自治州",
"861313798", "河南省三门峡市",
"861528761", "云南省临沧市",
"861523871", "河南省焦作市",
"861705807", "重庆市",
"861827247", "湖北省襄樊市",
"861882914", "陕西省商洛市",
"86156556", "安徽省安庆市",
"861351957", "宁夏银川市",
"861377282", "陕西省汉中市",
"861470439", "吉林省白山市",
"861875155", "江苏省无锡市",
"86185610", "山东省烟台市",
"861825045", "福建省福州市",
"861571467", "黑龙江省大兴安岭地区",
"861333846", "福建省厦门市",
"86137708", "江苏省南京市",
"861877168", "湖北省孝感市",
"86132299", "广东省广州市",
"861522915", "陕西省安康市",
"861853011", "河南省开封市",
"86137695", "云南省曲靖市",
"861475625", "河北省邢台市",
"861526889", "浙江省台州市",
"861877088", "江西省上饶市",
"861598414", "四川省宜宾市",
"86137716", "江苏省苏州市",
"861870913", "陕西省渭南市",
"861332236", "辽宁省朝阳市",
"861816971", "广西贵港市",
"861780784", "广西梧州市",
"861343702", "江西省九江市",
"861354978", "湖南省常德市",
"861326480", "湖北省黄冈市",
"861810597", "福建省龙岩市",
"861893763", "河南省郑州市",
"861371716", "广东省东莞市",
"861321920", "四川省遂宁市",
"861364704", "江西省抚州市",
"861898873", "广东省东莞市",
"861800733", "湖南省株洲市",
"86187825", "四川省遂宁市",
"861370776", "广西百色市",
"861390074", "湖南省岳阳市",
"86181379", "河南省洛阳市",
"861526630", "山东省潍坊市",
"861509010", "河南省南阳市",
"86188310", "河北省邯郸市",
"861316497", "浙江省宁波市",
"861334088", "四川省绵阳市",
"861820580", "浙江省舟山市",
"861853416", "山西省临汾市",
"861380145", "江苏省扬州市",
"86183416", "辽宁省锦州市",
"861328793", "山东省菏泽市",
"861390412", "辽宁省鞍山市",
"86137975", "湖北省荆州市",
"861557010", "江西省赣州市",
"86153062", "江苏省苏州市",
"861503162", "河北省廊坊市",
"861596978", "山东省济宁市",
"86152743", "湖南省湘西土家族苗族自治州",
"86152989", "海南省海口市",
"861771908", "河南省三门峡市",
"861773231", "河北省石家庄市",
"861894468", "黑龙江省鹤岗市",
"861389473", "吉林省白山市",
"861589952", "广东省惠州市",
"86153422", "湖北省武汉市",
"861598072", "福建省福州市",
"861803402", "河北省保定市",
"861707545", "福建省泉州市",
"861820963", "宁夏吴忠市",
"861836919", "山东省威海市",
"861527195", "湖北省襄樊市",
"861559740", "青海省海北藏族自治州",
"86177898", "海南省海口市",
"86180302", "福建省厦门市",
"86158346", "吉林省白城市",
"86314", "河北省承德市",
"861869447", "陕西省宝鸡市",
"86159827", "四川省巴中市",
"861328667", "广东省深圳市",
"861568738", "云南省昆明市",
"861452492", "内蒙古包头市",
"861321766", "广东省云浮市",
"861550568", "安徽省阜阳市",
"861514186", "辽宁省铁岭市",
"861454558", "新疆巴音郭楞蒙古自治州",
"861533553", "内蒙古鄂尔多斯市",
"861572884", "广东省深圳市",
"86151648", "内蒙古巴彦淖尔市",
"861325182", "吉林省吉林市",
"861860673", "浙江省嘉兴市",
"86134076", "山东省临沂市",
"861534976", "青海省海东地区",
"861571541", "山东省济南市",
"861827255", "河南省安阳市",
"861527763", "广西玉林市",
"861351945", "甘肃省武威市",
"861705266", "广东省深圳市",
"861380647", "山东省潍坊市",
"861368977", "吉林省白城市",
"861479283", "安徽省阜阳市",
"861889769", "广西钦州市",
"861329887", "吉林省辽源市",
"861317273", "广东省惠州市",
"861450646", "黑龙江省伊春市",
"86184899", "海南省海口市",
"861555280", "山东省泰安市",
"861472988", "陕西省西安市",
"86130656", "浙江省宁波市",
"861879842", "贵州省黔南布依族苗族自治州",
"86131663", "上海市",
"861527697", "新疆塔城地区",
"861560549", "山东省临沂市",
"861875147", "江苏省扬州市",
"861516543", "山东省滨州市",
"861388404", "甘肃省临夏回族自治州",
"861571826", "广东省梅州市",
"861810323", "河北省张家口市",
"861324941", "广东省佛山市",
"861825057", "福建省三明市",
"861829538", "宁夏银川市",
"861592837", "四川省内江市",
"861502616", "新疆昌吉回族自治州",
"861776145", "四川省自贡市",
"861380288", "广东省广州市",
"86150010", "北京市",
"861311844", "四川省泸州市",
"861804358", "吉林省长春市",
"861453191", "山西省晋中市",
"861312581", "吉林省长春市",
"861842017", "广东省茂名市",
"861887159", "湖北省宜昌市",
"86189343", "广东省佛山市",
"861889724", "青海省西宁市",
"861510904", "新疆喀什地区",
"86156487", "内蒙古鄂尔多斯市",
"861519499", "河北省保定市",
"861554086", "内蒙古包头市",
"861517680", "河北省承德市",
"861760608", "福建省三明市",
"861801409", "江苏省镇江市",
"861533367", "山西省临汾市",
"861800940", "甘肃省兰州市",
"86158002", "广东省广州市",
"861342652", "江西省抚州市",
"861330566", "安徽省池州市",
"86176817", "浙江省温州市",
"861836181", "江苏省镇江市",
"861598760", "云南省大理白族自治州",
"861554737", "内蒙古乌海市",
"861532792", "湖北省襄樊市",
"861300468", "浙江省衢州市",
"861378821", "广西南宁市",
"861869561", "福建省福州市",
"861596631", "山东省济南市",
"86188468", "黑龙江省鹤岗市",
"861384870", "内蒙古呼伦贝尔市",
"86133313", "河北省石家庄市",
"861399937", "新疆伊犁哈萨克自治州",
"861593688", "河南省三门峡市",
"86188411", "辽宁省大连市",
"861871605", "河北省唐山市",
"861380157", "江苏省苏州市",
"861338700", "江西省南昌市",
"861308489", "陕西省汉中市",
"861360020", "广东省汕尾市",
"861471703", "甘肃省定西市",
"861869455", "浙江省杭州市",
"861580741", "湖南省怀化市",
"861569392", "甘肃省白银市",
"861554166", "辽宁省朝阳市",
"861510588", "浙江省丽水市",
"861379984", "福建省厦门市",
"86188028", "四川省成都市",
"861522987", "陕西省宝鸡市",
"86130435", "福建省福州市",
"861886969", "云南省迪庆藏族自治州",
"861378546", "河北省廊坊市",
"861393438", "山西省运城市",
"861833179", "河北省沧州市",
"861707557", "安徽省阜阳市",
"861800317", "河北省沧州市",
"861593247", "河北省石家庄市",
"861317554", "浙江省金华市",
"861567705", "广西玉林市",
"861811982", "安徽省淮北市",
"861394733", "内蒙古乌海市",
"861887649", "福建省泉州市",
"861450585", "辽宁省辽阳市",
"861363714", "安徽省安庆市",
"861813681", "江苏省镇江市",
"861453944", "广东省江门市",
"861848789", "云南省西双版纳傣族自治州",
"861804074", "新疆喀什地区",
"861816202", "山东省德州市",
"861386243", "江苏省镇江市",
"861521485", "新疆伊犁哈萨克自治州",
"861707363", "河南省郑州市",
"861580883", "云南省临沧市",
"861592443", "内蒙古赤峰市",
"861897871", "广西玉林市",
"861533274", "内蒙古兴安盟",
"861512990", "陕西省商洛市",
"861302493", "福建省宁德市",
"86159258", "浙江省绍兴市",
"86134629", "河南省商丘市",
"86151577", "浙江省温州市",
"861358690", "浙江省宁波市",
"861375474", "山东省临沂市",
"861583385", "河北省保定市",
"861840768", "广东省潮州市",
"861325062", "广东省惠州市",
"861350231", "广东省河源市",
"861890581", "浙江省杭州市",
"861839420", "甘肃省临夏回族自治州",
"861318188", "山东省威海市",
"861390894", "西藏林芝地区",
"861332424", "辽宁省本溪市",
"861552918", "陕西省宝鸡市",
"861593330", "河北省邯郸市",
"861787639", "广东省云浮市",
"861347511", "山东省威海市",
"861325908", "陕西省渭南市",
"861816957", "宁夏吴忠市",
"861364736", "湖南省常德市",
"861839448", "甘肃省兰州市",
"861567629", "广西柳州市",
"861562446", "山东省日照市",
"861809685", "新疆昌吉回族自治州",
"861538737", "湖南省益阳市",
"861780570", "浙江省衢州市",
"861599900", "新疆巴音郭楞蒙古自治州",
"861373013", "河北省邢台市",
"861870598", "福建省三明市",
"861801443", "江苏省连云港市",
"861355721", "广西南宁市",
"861301904", "黑龙江省双鸭山市",
"861395623", "安徽省马鞍山市",
"861310169", "黑龙江省双鸭山市",
"86180158", "江苏省常州市",
"861452814", "四川省绵阳市",
"86156433", "吉林省延边朝鲜族自治州",
"86131110", "山西省太原市",
"861331486", "内蒙古包头市",
"86180781", "广西南宁市",
"861588557", "贵州省黔南布依族苗族自治州",
"861336926", "陕西省延安市",
"861317152", "河北省唐山市",
"86189914", "陕西省商洛市",
"861518122", "四川省雅安市",
"861362326", "河北省廊坊市",
"861768053", "湖南省郴州市",
"861775920", "福建省厦门市",
"861537311", "河北省石家庄市",
"861360048", "广东省广州市",
"861322458", "黑龙江省大庆市",
"861560503", "福建省三明市",
"861332469", "陕西省铜川市",
"861553349", "河北省唐山市",
"861324592", "内蒙古巴彦淖尔市",
"861872980", "陕西省西安市",
"861820774", "广西梧州市",
"861827090", "江西省新余市",
"861336760", "广西梧州市",
"861852572", "辽宁省葫芦岛市",
"86185981", "广东省广州市",
"861589866", "山东省菏泽市",
"86136682", "四川省成都市",
"86156272", "广东省佛山市",
"861308842", "内蒙古赤峰市",
"861319762", "广西柳州市",
"861857115", "湖北省孝感市",
"861571992", "新疆塔城地区",
"861760912", "陕西省榆林市",
"861580775", "广西玉林市",
"861840946", "甘肃省定西市",
"86145869", "山东省威海市",
"861860721", "湖北省荆州市",
"861529272", "新疆吐鲁番地区",
"861323063", "河北省保定市",
"861839382", "甘肃省庆阳市",
"861520565", "安徽省合肥市",
"861331081", "广东省东莞市",
"861538481", "内蒙古呼和浩特市",
"861569744", "湖南省张家界市",
"861770710", "湖北省武汉市",
"861774901", "陕西省西安市",
"861866828", "浙江省宁波市",
"861339726", "湖北省黄冈市",
"86137593", "云南省临沧市",
"861334690", "河南省驻马店市",
"861323613", "江苏省盐城市",
"861592409", "浙江省衢州市",
"861315836", "贵州省铜仁地区",
"861520451", "黑龙江省哈尔滨市",
"861700930", "甘肃省兰州市",
"861819757", "新疆博尔塔拉蒙古自治州",
"861338631", "山东省威海市",
"861880564", "安徽省六安市",
"861359818", "河南省洛阳市",
"86187649", "山东省临沂市",
"861812894", "广东省河源市",
"861845274", "江苏省无锡市",
"861317642", "山东省滨州市",
"86130571", "江苏省常州市",
"861875979", "福建省漳州市",
"861322312", "河北省邯郸市",
"861771770", "河北省保定市",
"861517407", "辽宁省锦州市",
"861373797", "广西河池市",
"861811108", "四川省眉山市",
"86184541", "山东省济南市",
"861890676", "浙江省台州市",
"861353672", "广东省梅州市",
"861525140", "江苏省无锡市",
"861362535", "山东省烟台市",
"861339583", "浙江省嘉兴市",
"861310089", "黑龙江省大庆市",
"861787678", "广东省阳江市",
"861367953", "广东省清远市",
"861471749", "江西省赣州市",
"861570515", "江苏省连云港市",
"861459053", "广东省深圳市",
"86181861", "湖北省武汉市",
"861773024", "安徽省淮北市",
"86135504", "四川省凉山彝族自治州",
"861880529", "江苏省镇江市",
"861350911", "陕西省延安市",
"861586349", "山东省菏泽市",
"86137059", "福建省福州市",
"861814953", "福建省福州市",
"86181818", "四川省广安市",
"861352373", "河南省新乡市",
"861838406", "四川省南充市",
"86182590", "福建省福州市",
"861813576", "河南省周口市",
"861339960", "安徽省滁州市",
"861325584", "浙江省宁波市",
"861808892", "云南省玉溪市",
"861870802", "西藏日喀则地区",
"861564265", "辽宁省大连市",
"861459606", "宁夏中卫市",
"861872605", "安徽省安庆市",
"861379926", "福建省厦门市",
"861329710", "湖北省恩施土家族苗族自治州",
"861308181", "河北省衡水市",
"86177738", "湖南省娄底市",
"861850684", "浙江省杭州市",
"861396619", "安徽省宣城市",
"861351833", "四川省广元市",
"861802377", "广东省云浮市",
"861869380", "甘肃省天水市",
"861569509", "宁夏中卫市",
"86184703", "江西省上饶市",
"861308611", "江西省上饶市",
"861521987", "广东省潮州市",
"861535336", "陕西省西安市",
"86138555", "安徽省马鞍山市",
"861317753", "江西省新余市",
"861857900", "江西省新余市",
"861586901", "浙江省杭州市",
"861560665", "浙江省温州市",
"861502089", "山东省莱芜市",
"861347079", "安徽省阜阳市",
"861472703", "浙江省宁波市",
"861327040", "江苏省连云港市",
"861471504", "广东省梅州市",
"861599685", "江苏省徐州市",
"861522485", "河南省南阳市",
"861308466", "浙江省金华市",
"861831817", "广东省阳江市",
"861809900", "新疆昌吉回族自治州",
"861881206", "河北省廊坊市",
"861589442", "云南省德宏傣族景颇族自治州",
"861365684", "浙江省宁波市",
"861551279", "河北省沧州市",
"861599115", "陕西省安康市",
"861803330", "广东省阳江市",
"86183856", "贵州省黔南布依族苗族自治州",
"861881426", "广东省湛江市",
"861507845", "广西柳州市",
"861457182", "浙江省温州市",
"861869957", "新疆乌鲁木齐市",
"86139919", "陕西省西安市",
"861333997", "湖北省黄冈市",
"861848920", "西藏拉萨市",
"86159781", "广西南宁市",
"86151317", "河北省沧州市",
"861890844", "湖南省衡阳市",
"861322635", "河北省石家庄市",
"861320832", "四川省内江市",
"861890360", "黑龙江省哈尔滨市",
"861813419", "河北省邢台市",
"861339498", "新疆阿克苏地区",
"861863458", "山西省吕梁市",
"861511990", "广东省云浮市",
"861337838", "四川省雅安市",
"861319163", "河北省承德市",
"861355098", "四川省广安市",
"861778553", "贵州省黔东南苗族侗族自治州",
"861828210", "四川省巴中市",
"861830877", "云南省玉溪市",
"861508093", "湖南省邵阳市",
"861570003", "浙江省衢州市",
"86159158", "广东省广州市",
"861301493", "广西柳州市",
"861370548", "山东省泰安市",
"861373505", "浙江省衢州市",
"861589701", "青海省西宁市",
"86183783", "广西桂林市",
"86157632", "山东省枣庄市",
"861330589", "浙江省金华市",
"861319083", "内蒙古鄂尔多斯市",
"861324343", "河南省郑州市",
"861477073", "江西省南昌市",
"86135862", "浙江省台州市",
"86155765", "湖南省怀化市",
"861551238", "河北省承德市",
"861323782", "广西柳州市",
"861369962", "四川省绵阳市",
"861346400", "辽宁省沈阳市",
"861572541", "山东省济南市",
"861559331", "甘肃省平凉市",
"861831964", "广东省广州市",
"86151292", "陕西省西安市",
"861328559", "安徽省黄山市",
"861815853", "浙江省杭州市",
"861338568", "安徽省六安市",
"861572826", "广东省惠州市",
"861551327", "山西省太原市",
"86182480", "内蒙古赤峰市",
"861582004", "山东省聊城市",
"861337879", "云南省普洱市",
"861504276", "辽宁省盘锦市",
"861377640", "江苏省南京市",
"861598984", "广东省汕头市",
"861535525", "浙江省衢州市",
"861889523", "宁夏吴忠市",
"861537470", "内蒙古呼伦贝尔市",
"861870483", "内蒙古阿拉善盟",
"861471988", "新疆乌鲁木齐市",
"861325875", "吉林省通化市",
"861458287", "福建省莆田市",
"861376960", "云南省文山壮族苗族自治州",
"861801101", "四川省泸州市",
"861360292", "广东省清远市",
"86137483", "内蒙古乌海市",
"861317811", "福建省福州市",
"861763524", "山西省临汾市",
"861831929", "广东省梅州市",
"86136009", "福建省厦门市",
"861312360", "贵州省贵阳市",
"861590928", "陕西省榆林市",
"86177841", "贵州省贵阳市",
"861390982", "辽宁省沈阳市",
"861561075", "山东省威海市",
"861368475", "内蒙古呼和浩特市",
"86150965", "云南省昭通市",
"861376583", "贵州省贵阳市",
"861533754", "江苏省南京市",
"861453499", "内蒙古赤峰市",
"861347038", "辽宁省辽阳市",
"86134760", "湖北省武汉市",
"861519191", "陕西省西安市",
"861889786", "广西柳州市",
"861356859", "四川省宜宾市",
"861853986", "河南省商丘市",
"861505507", "安徽省阜阳市",
"861364692", "福建省龙岩市",
"861868199", "陕西省咸阳市",
"861879466", "甘肃省天水市",
"861584516", "黑龙江省佳木斯市",
"86188335", "河北省秦皇岛市",
"861383412", "山西省大同市",
"861834432", "广东省广州市",
"861898678", "湖北省宜昌市",
"861300990", "黑龙江省大庆市",
"861458620", "湖北省十堰市",
"861570049", "四川省自贡市",
"861337378", "河南省洛阳市",
"86156597", "福建省福州市",
"861555599", "安徽省阜阳市",
"861527162", "湖北省黄冈市",
"861332081", "四川省自贡市",
"86189010", "北京市",
"861325783", "广西来宾市",
"861562790", "广东省汕尾市",
"86150343", "山西省临汾市",
"861320372", "河南省郑州市",
"861509804", "湖北省黄冈市",
"861811894", "江苏省盐城市",
"861452551", "山东省聊城市",
"86130311", "北京市",
"861882798", "江西省景德镇市",
"86719", "湖北省十堰市",
"861772770", "广东省东莞市",
"86182702", "江西省九江市",
"861813852", "广东省佛山市",
"861538189", "浙江省宁波市",
"861561041", "山东省泰安市",
"861368441", "四川省内江市",
"861339784", "广西梧州市",
"861313914", "青海省海南藏族自治州",
"861357260", "陕西省汉中市",
"861861782", "河北省秦皇岛市",
"86177599", "福建省南平市",
"861827222", "湖北省荆州市",
"861517905", "江西省赣州市",
"861773086", "河南省许昌市",
"861572575", "山东省淄博市",
"861361535", "山东省烟台市",
"861880763", "广东省清远市",
"861352971", "云南省楚雄彝族自治州",
"861379892", "广东省东莞市",
"861472749", "贵州省黔西南布依族苗族自治州",
"861814351", "贵州省贵阳市",
"86147696", "云南省文山壮族苗族自治州",
"861375197", "广东省梅州市",
"861350313", "河北省张家口市",
"861824991", "广西河池市",
"861325526", "江苏省南京市",
"861340822", "四川省资阳市",
"861351373", "河南省新乡市",
"861773737", "河南省焦作市",
"861367351", "河南省新乡市",
"861709418", "广东省汕头市",
"861336508", "福建省龙岩市",
"861388993", "广东省佛山市",
"861325841", "四川省南充市",
"861577112", "湖北省孝感市",
"861305530", "福建省莆田市",
"861557804", "广西百色市",
"861880697", "云南省临沧市",
"86155389", "河南省焦作市",
"861550939", "甘肃省陇南市",
"861520649", "山东省临沂市",
"861846042", "江西省萍乡市",
"861771250", "江苏省盐城市",
"861596568", "山东省菏泽市",
"861589889", "山东省滨州市",
"861532636", "吉林省白城市",
"861341544", "广东省中山市",
"861858640", "贵州省遵义市",
"861331424", "辽宁省沈阳市",
"861370520", "江苏省徐州市",
"861306226", "福建省南平市",
"861538024", "江苏省镇江市",
"861709352", "河南省南阳市",
"86183650", "安徽省滁州市",
"861315010", "甘肃省定西市",
"861869422", "河北省石家庄市",
"861770887", "云南省迪庆藏族自治州",
"861556132", "内蒙古包头市",
"861336984", "新疆克孜勒苏柯尔克孜自治州",
"86185635", "山东省聊城市",
"861500581", "浙江省杭州市",
"861365512", "江苏省连云港市",
"861769620", "山西省吕梁市",
"861550978", "青海省西宁市",
"861332486", "广西贵港市",
"86187762", "广西柳州市",
"861560704", "江西省萍乡市",
"861302904", "吉林省辽源市",
"861589630", "江苏省宿迁市",
"86147715", "广东省广州市",
"861820573", "浙江省嘉兴市",
"86137437", "吉林省辽源市",
"861871980", "甘肃省兰州市",
"861803688", "江苏省无锡市",
"861894756", "内蒙古呼伦贝尔市",
"861867216", "湖北省襄樊市",
"861310186", "江苏省宿迁市",
"861851572", "四川省泸州市",
"86133040", "辽宁省沈阳市",
"861531860", "山东省淄博市",
"861539390", "云南省楚雄彝族自治州",
"861344683", "广西百色市",
"861775789", "浙江省舟山市",
"861816561", "广东省珠海市",
"86133022", "广东省广州市",
"861361326", "河北省廊坊市",
"86138279", "广东省韶关市",
"86158689", "浙江省金华市",
"861800506", "福建省泉州市",
"861337339", "河北省邢台市",
"861528058", "福建省三明市",
"861874054", "陕西省商洛市",
"861321458", "黑龙江省伊春市",
"861538069", "江苏省连云港市",
"861331469", "黑龙江省双鸭山市",
"861332161", "广西南宁市",
"861776438", "安徽省蚌埠市",
"861871563", "安徽省宣城市",
"861318777", "云南省曲靖市",
"861572992", "新疆塔城地区",
"861326473", "湖北省武汉市",
"861590317", "河北省沧州市",
"861773481", "河南省郑州市",
"861816455", "浙江省绍兴市",
"86156172", "河南省许昌市",
"86139867", "湖北省宜昌市",
"86183737", "湖南省益阳市",
"861774848", "四川省成都市",
"861846706", "青海省海西蒙古族藏族自治州",
"861324309", "河南省洛阳市",
"861368702", "江西省九江市",
"861850512", "江苏省苏州市",
"861315833", "贵州省安顺市",
"86185748", "湖南省常德市",
"861380998", "新疆克孜勒苏柯尔克孜自治州",
"861557679", "湖南省永州市",
"861767341", "湖南省永州市",
"861880789", "广西北海市",
"861458495", "山东省烟台市",
"861501782", "广东省汕头市",
"861320867", "吉林省辽源市",
"861363479", "内蒙古兴安盟",
"861373411", "山西省临汾市",
"861550530", "山东省菏泽市",
"861454672", "广东省深圳市",
"861896364", "江苏省南京市",
"861305939", "广东省肇庆市",
"861563870", "河南省驻马店市",
"861325724", "湖北省荆门市",
"861815174", "江苏省泰州市",
"86186343", "山西省太原市",
"861786885", "陕西省安康市",
"861883878", "河南省商丘市",
"86153882", "四川省成都市",
"8613262", "上海市",
"861535211", "甘肃省武威市",
"861331802", "广东省湛江市",
"861476017", "福建省泉州市",
"861450272", "内蒙古包头市",
"861365771", "广西南宁市",
"861576618", "广东省梅州市",
"86159487", "吉林省长春市",
"861806499", "四川省甘孜藏族自治州",
"861339723", "湖北省黄石市",
"86145813", "浙江省舟山市",
"861301728", "湖南省长沙市",
"861453700", "湖北省随州市",
"861530942", "甘肃省酒泉市",
"861381361", "江苏省南通市",
"861459056", "广东省佛山市",
"861346799", "湖南省湘西土家族苗族自治州",
"861337765", "广东省佛山市",
"861387431", "湖南省益阳市",
"861782827", "四川省内江市",
"861323555", "湖北省武汉市",
"861889182", "陕西省榆林市",
"861325769", "广东省东莞市",
"861838403", "四川省泸州市",
"861831548", "山东省泰安市",
"861562837", "广东省东莞市",
"861352376", "河南省信阳市",
"861814956", "福建省福州市",
"861813573", "河南省濮阳市",
"861590549", "山东省临沂市",
"861808321", "贵州省铜仁地区",
"861344019", "四川省凉山彝族自治州",
"86184828", "四川省南充市",
"861586094", "福建省泉州市",
"861334927", "安徽省亳州市",
"861370817", "四川省成都市",
"861555990", "云南省昆明市",
"86187485", "贵州省毕节地区",
"861378509", "河北省唐山市",
"861850771", "广西南宁市",
"861338944", "甘肃省兰州市",
"861300599", "广西北海市",
"861890673", "浙江省嘉兴市",
"861323461", "黑龙江省齐齐哈尔市",
"861856110", "山东省烟台市",
"861339586", "浙江省台州市",
"861587111", "湖北省十堰市",
"861367956", "广东省肇庆市",
"861395626", "安徽省黄山市",
"86158912", "陕西省榆林市",
"861528912", "西藏日喀则地区",
"86188553", "安徽省芜湖市",
"86156258", "广东省东莞市",
"86181109", "安徽省合肥市",
"861800704", "江西省抚州市",
"86995", "新疆吐鲁番地区",
"861331483", "内蒙古呼伦贝尔市",
"861454464", "陕西省西安市",
"861336923", "陕西省汉中市",
"861309488", "浙江省嘉兴市",
"861550454", "黑龙江省佳木斯市",
"861860581", "浙江省杭州市",
"861818415", "贵州省黔东南苗族侗族自治州",
"861877130", "湖北省咸宁市",
"861339645", "山东省烟台市",
"86183575", "浙江省绍兴市",
"861509422", "云南省保山市",
"86188926", "浙江省宁波市",
"861571300", "河北省邯郸市",
"861364733", "湖南省株洲市",
"861597705", "广西玉林市",
"861562443", "山东省德州市",
"861777128", "湖北省宜昌市",
"86134698", "湖北省宜昌市",
"861370964", "广东省茂名市",
"861846504", "宁夏固原市",
"861889062", "湖南省湘西土家族苗族自治州",
"861801446", "江苏省南京市",
"861807597", "湖南省益阳市",
"861775697", "安徽省合肥市",
"86134142", "广东省东莞市",
"861836244", "江苏省连云港市",
"861373016", "河北省保定市",
"86134705", "辽宁省抚顺市",
"861457037", "广东省江门市",
"861366481", "内蒙古呼和浩特市",
"861581393", "广东省汕尾市",
"86155700", "江西省赣州市",
"861822655", "安徽省蚌埠市",
"861820852", "贵州省遵义市",
"861899455", "江苏省淮安市",
"861454209", "河南省漯河市",
"861390020", "广东省广州市",
"861363438", "吉林省松原市",
"861459565", "陕西省宝鸡市",
"86138387", "河南省南阳市",
"86138876", "云南省文山壮族苗族自治州",
"861320914", "陕西省商洛市",
"861454429", "江苏省盐城市",
"861334130", "湖南省岳阳市",
"861576068", "四川省达州市",
"8614748", "广东省广州市",
"861840943", "甘肃省白银市",
"86155125", "河北省唐山市",
"861323066", "河北省廊坊市",
"861315447", "四川省德阳市",
"861321974", "四川省眉山市",
"861768056", "湖南省常德市",
"861362323", "河北省张家口市",
"861340404", "四川省达州市",
"861582991", "陕西省西安市",
"861560506", "福建省漳州市",
"861534410", "内蒙古乌海市",
"861838882", "云南省丽江市",
"861566631", "山东省威海市",
"861459451", "陕西省商洛市",
"8618289", "海南省海口市",
"861303350", "江苏省无锡市",
"861522297", "安徽省宿州市",
"861309342", "安徽省六安市",
"861450609", "吉林省白山市",
"861786621", "湖北省武汉市",
"861563688", "黑龙江省鸡西市",
"861313372", "江西省抚州市",
"861340224", "山东省菏泽市",
"861334819", "江苏省常州市",
"861369937", "新疆乌鲁木齐市",
"861471706", "甘肃省兰州市",
"861340391", "河南省焦作市",
"861556087", "内蒙古赤峰市",
"861453631", "江苏省南京市",
"861478607", "贵州省黔西南布依族苗族自治州",
"861554163", "辽宁省锦州市",
"86139682", "浙江省宁波市",
"861800665", "浙江省宁波市",
"861773762", "河南省安阳市",
"861810535", "山东省烟台市",
"861890721", "湖北省荆州市",
"86138670", "浙江省丽水市",
"861378543", "河北省保定市",
"861826250", "江苏省南通市",
"861770558", "安徽省阜阳市",
"861377467", "福建省厦门市",
"86137848", "河北省衡水市",
"861390048", "黑龙江省哈尔滨市",
"861809509", "四川省雅安市",
"861478322", "河南省漯河市",
"861369658", "安徽省阜阳市",
"861319619", "吉林省白山市",
"861533065", "吉林省四平市",
"861893635", "江苏省徐州市",
"861477179", "湖北省十堰市",
"861319189", "河北省承德市",
"861535931", "福建省厦门市",
"861327417", "辽宁省营口市",
"861844972", "新疆巴音郭楞蒙古自治州",
"86159433", "吉林省延边朝鲜族自治州",
"861863974", "河南省平顶山市",
"861889908", "新疆乌鲁木齐市",
"861530591", "福建省福州市",
"861510728", "湖北省十堰市",
"861339671", "浙江省杭州市",
"861302496", "福建省南平市",
"86183259", "安徽省阜阳市",
"861334318", "河北省衡水市",
"861536977", "河北省沧州市",
"861777140", "湖北省黄石市",
"861394736", "内蒙古赤峰市",
"86131204", "北京市",
"861552025", "四川省雅安市",
"861351660", "广东省佛山市",
"861360894", "山东省淄博市",
"861834467", "江苏省苏州市",
"861569900", "新疆阿克苏地区",
"861306994", "黑龙江省鹤岗市",
"861707366", "河南省南阳市",
"861597629", "广东省韶关市",
"861592446", "内蒙古赤峰市",
"861386246", "江苏省镇江市",
"861398659", "湖北省黄石市",
"861527137", "湖北省十堰市",
"861450643", "黑龙江省大庆市",
"86152017", "上海市",
"861319024", "辽宁省丹东市",
"861820419", "辽宁省辽阳市",
"861812048", "湖北省黄石市",
"861571823", "广东省韶关市",
"861516546", "山东省东营市",
"861810326", "河北省廊坊市",
"861502613", "新疆和田地区",
"861562264", "广东省肇庆市",
"861582542", "浙江省温州市",
"861840909", "新疆博尔塔拉蒙古自治州",
"861332598", "浙江省温州市",
"861533556", "内蒙古呼和浩特市",
"861534973", "青海省西宁市",
"86183431", "吉林省长春市",
"86152168", "上海市",
"861312721", "山东省枣庄市",
"861860676", "浙江省台州市",
"861821479", "安徽省池州市",
"86138333", "河北省张家口市",
"861330357", "山西省临汾市",
"861847834", "湖南省岳阳市",
"861781758", "广东省肇庆市",
"861705263", "吉林省长春市",
"86177645", "浙江省杭州市",
"86135370", "广东省东莞市",
"86152111", "湖南省长沙市",
"86138990", "新疆巴音郭楞蒙古自治州",
"861321195", "云南省玉溪市",
"861317276", "广东省河源市",
"861850745", "湖南省怀化市",
"861358130", "湖北省武汉市",
"861479286", "安徽省池州市",
"861878342", "四川省凉山彝族自治州",
"861503312", "河北省保定市",
"861870424", "辽宁省盘锦市",
"861890242", "广东省佛山市",
"861533185", "黑龙江省鹤岗市",
"861320234", "广东省惠州市",
"861328950", "宁夏银川市",
"861562409", "山东省济宁市",
"861330563", "安徽省宣城市",
"861319069", "内蒙古包头市",
"861785802", "浙江省金华市",
"861302857", "陕西省延安市",
"861777650", "广西桂林市",
"861524484", "四川省眉山市",
"86189004", "北京市",
"861301740", "贵州省遵义市",
"86157116", "上海市",
"861533615", "陕西省渭南市",
"86186965", "重庆市",
"86133369", "浙江省温州市",
"861337604", "江苏省镇江市",
"861504811", "内蒙古呼伦贝尔市",
"861309794", "广西梧州市",
"861318390", "四川省广安市",
"861365745", "湖南省怀化市",
"861591790", "广东省汕头市",
"86187140", "河北省保定市",
"861800015", "江苏省宿迁市",
"86137731", "江苏省苏州市",
"861330980", "辽宁省鞍山市",
"861877452", "湖南省张家界市",
"861870469", "黑龙江省双鸭山市",
"861539777", "四川省绵阳市",
"861398149", "四川省达州市",
"861529156", "陕西省商洛市",
"861324634", "广东省佛山市",
"861302091", "浙江省温州市",
"86187122", "安徽省亳州市",
"861554083", "内蒙古兴安盟",
"861860360", "黑龙江省哈尔滨市",
"86181209", "福建省福州市",
"861369435", "吉林省通化市",
"861332483", "广西桂林市",
"86158445", "吉林省通化市",
"861860844", "湖南省张家界市",
"861533332", "河北省保定市",
"86156781", "广西南宁市",
"861700578", "浙江省丽水市",
"861478355", "河南省许昌市",
"861806944", "浙江省杭州市",
"861476594", "重庆市",
"861820576", "浙江省台州市",
"861893458", "江苏省苏州市",
"861315945", "福建省莆田市",
"86155592", "新疆伊犁哈萨克自治州",
"861510857", "贵州省毕节地区",
"861532633", "吉林省延边朝鲜族自治州",
"86134242", "广东省深圳市",
"861766013", "山东省济南市",
"86134220", "广东省广州市",
"861395114", "江苏省泰州市",
"86183315", "河北省唐山市",
"861899957", "新疆伊犁哈萨克自治州",
"86136919", "广东省深圳市",
"861304379", "河南省洛阳市",
"861871566", "安徽省池州市",
"861500721", "湖北省荆州市",
"861573478", "内蒙古巴彦淖尔市",
"861890098", "辽宁省大连市",
"861859629", "山东省烟台市",
"861326476", "湖北省随州市",
"861364534", "山东省德州市",
"861303485", "湖南省怀化市",
"861355844", "广西南宁市",
"86180272", "广东省广州市",
"861459159", "广西北海市",
"861362921", "陕西省延安市",
"861355360", "广东省韶关市",
"861846703", "青海省海北藏族自治州",
"861552052", "四川省广安市",
"861894753", "内蒙古通辽市",
"861807664", "广西南宁市",
"861867213", "湖北省襄樊市",
"861854651", "黑龙江省哈尔滨市",
"861310183", "江苏省徐州市",
"861344686", "云南省昆明市",
"861335278", "广东省惠州市",
"861534831", "湖南省长沙市",
"861372240", "河北省承德市",
"861558371", "四川省内江市",
"861361323", "河北省唐山市",
"861768649", "山东省烟台市",
"861370780", "广西柳州市",
"861322974", "广东省汕尾市",
"861800503", "福建省宁德市",
"861536441", "湖南省湘西土家族苗族自治州",
"861454121", "河北省石家庄市",
"861581991", "广东省江门市",
"861316658", "河北省唐山市",
"861780979", "青海省海西蒙古族藏族自治州",
"861376671", "黑龙江省鹤岗市",
"861776005", "四川省南充市",
"861595550", "安徽省滁州市",
"861807014", "江西省南昌市",
"861894811", "广东省茂名市",
"86181665", "重庆市",
"861570394", "河南省周口市",
"861347772", "湖北省孝感市",
"861325037", "广东省佛山市",
"861329558", "安徽省阜阳市",
"86145201", "北京市",
"861339569", "安徽省合肥市",
"86152538", "山东省泰安市",
"86183527", "江苏省扬州市",
"861806191", "江苏省淮安市",
"861802041", "江苏省常州市",
"861879463", "甘肃省平凉市",
"861780938", "甘肃省天水市",
"861584513", "黑龙江省哈尔滨市",
"861327235", "湖南省郴州市",
"861844707", "内蒙古呼和浩特市",
"861454815", "广东省深圳市",
"861335239", "辽宁省葫芦岛市",
"861809744", "青海省西宁市",
"861325786", "广西玉林市",
"861536702", "湖南省岳阳市",
"861760374", "河南省许昌市",
"861840835", "四川省甘孜藏族自治州",
"861576777", "广东省梅州市",
"861364450", "黑龙江省哈尔滨市",
"861832548", "山东省泰安市",
"861351376", "河南省信阳市",
"86188717", "湖北省宜昌市",
"861333158", "吉林省长春市",
"861869198", "陕西省咸阳市",
"861388996", "广东省汕头市",
"861852711", "湖北省荆州市",
"861700539", "山东省临沂市",
"861304407", "山东省济宁市",
"861857744", "广西梧州市",
"861459649", "甘肃省白银市",
"861877425", "湖南省衡阳市",
"861855982", "福建省厦门市",
"861821145", "广东省河源市",
"861381580", "江苏省扬州市",
"861350795", "江西省宜春市",
"861300302", "安徽省蚌埠市",
"861378392", "河南省鹤壁市",
"861807472", "广西柳州市",
"861304338", "吉林省延边朝鲜族自治州",
"861773083", "河南省信阳市",
"86155177", "河南省焦作市",
"861893312", "广东省揭阳市",
"86139345", "山西省太原市",
"861811020", "安徽省蚌埠市",
"861880766", "广东省云浮市",
"861598294", "四川省德阳市",
"861569821", "山东省威海市",
"861350316", "河北省廊坊市",
"861399962", "新疆巴音郭楞蒙古自治州",
"861325523", "江苏省南通市",
"861818829", "贵州省六盘水市",
"861589190", "云南省文山壮族苗族自治州",
"861300627", "江西省宜春市",
"861506329", "山东省临沂市",
"861815856", "浙江省宁波市",
"861811048", "安徽省六安市",
"86152474", "内蒙古乌兰察布市",
"861539618", "福建省三明市",
"861573807", "河南省南阳市",
"861319737", "湖北省孝感市",
"861572823", "广东省河源市",
"861397351", "湖南省郴州市",
"861598321", "四川省资阳市",
"861800549", "山东省临沂市",
"861561264", "河北省廊坊市",
"861470999", "新疆乌鲁木齐市",
"861504273", "辽宁省营口市",
"861539188", "安徽省宿州市",
"861889526", "宁夏中卫市",
"861534371", "河南省郑州市",
"861824281", "辽宁省辽阳市",
"861354499", "广东省江门市",
"86135510", "四川省成都市",
"861477076", "江西省吉安市",
"861324346", "河南省周口市",
"861319086", "内蒙古巴彦淖尔市",
"861331598", "河北省石家庄市",
"861311721", "湖北省襄樊市",
"86152268", "河北省邢台市",
"86187595", "福建省泉州市",
"861376586", "贵州省毕节地区",
"861300280", "四川省凉山彝族自治州",
"861302740", "湖南省常德市",
"86716", "湖北省荆州市",
"861818328", "四川省成都市",
"861314933", "广东省湛江市",
"861306449", "河南省平顶山市",
"861535785", "安徽省阜阳市",
"861889783", "广西桂林市",
"861398441", "贵州省贵阳市",
"861560940", "甘肃省临夏回族自治州",
"861368009", "广东省韶关市",
"861526531", "山东省济南市",
"861853983", "河南省焦作市",
"861330729", "湖北省孝感市",
"861301091", "吉林省长春市",
"861323522", "江苏省南通市",
"861304680", "广东省汕头市",
"861780657", "广东省茂名市",
"861538762", "四川省南充市",
"86177528", "湖南省长沙市",
"861564358", "吉林省吉林市",
"861560317", "河北省沧州市",
"861815497", "新疆喀什地区",
"861889335", "甘肃省陇南市",
"861535333", "陕西省宝鸡市",
"861317756", "江西省宜春市",
"86158180", "广东省佛山市",
"861771397", "四川省雅安市",
"861838141", "四川省资阳市",
"861380460", "黑龙江省哈尔滨市",
"861868880", "广东省佛山市",
"861829970", "新疆克孜勒苏柯尔克孜自治州",
"861575600", "安徽省铜陵市",
"861580869", "云南省临沧市",
"861707389", "河南省平顶山市",
"86138094", "贵州省贵阳市",
"861398702", "云南省德宏傣族景颇族自治州",
"861304878", "河北省石家庄市",
"861319481", "四川省广安市",
"861472706", "浙江省绍兴市",
"861859705", "青海省果洛藏族自治州",
"86136867", "广东省茂名市",
"861775162", "江苏省泰州市",
"86159172", "广东省中山市",
"861572282", "江苏省泰州市",
"861558345", "四川省凉山彝族自治州",
"861778615", "湖北省黄冈市",
"861570742", "湖南省怀化市",
"86151735", "湖南省郴州市",
"861333620", "山东省菏泽市",
"861536475", "山西省长治市",
"861459603", "宁夏石嘴山市",
"861379923", "福建省泉州市",
"861529334", "甘肃省平凉市",
"861316937", "广东省云浮市",
"861511302", "广东省佛山市",
"861335919", "陕西省铜川市",
"861376645", "江西省上饶市",
"861778185", "四川省广元市",
"861372337", "宁夏银川市",
"861840375", "河南省平顶山市",
"86152799", "江西省萍乡市",
"861523904", "河南省焦作市",
"861351836", "四川省遂宁市",
"861509561", "甘肃省金昌市",
"861519631", "四川省甘孜藏族自治州",
"861327915", "陕西省渭南市",
"86183159", "山东省德州市",
"861767909", "江西省上饶市",
"861524021", "江苏省南京市",
"861590704", "江西省抚州市",
"861539257", "山西省临汾市",
"861315971", "吉林省松原市",
"861760834", "四川省凉山彝族自治州",
"861855108", "江苏省常州市",
"861319166", "河北省保定市",
"861301496", "广西玉林市",
"861580824", "四川省自贡市",
"861508096", "湖南省岳阳市",
"861570006", "浙江省杭州市",
"861566568", "安徽省六安市",
"861539068", "甘肃省张掖市",
"861822438", "四川省广安市",
"861358205", "河北省保定市",
"861308463", "浙江省温州市",
"861881203", "河北省张家口市",
"861378744", "湖南省张家界市",
"86131104", "陕西省西安市",
"86151844", "四川省成都市",
"861358425", "江苏省苏州市",
"861881423", "广东省湛江市",
"86189900", "四川省自贡市",
"86147224", "四川省成都市",
"861373370", "河南省许昌市",
"861362705", "江西省宜春市",
"861334942", "黑龙江省齐齐哈尔市",
"861841950", "甘肃省临夏回族自治州",
"86186328", "河北省衡水市",
"861864990", "福建省漳州市",
"861890680", "浙江省舟山市",
"86137891", "湖南省邵阳市",
"861808779", "云南省玉溪市",
"861500905", "新疆和田地区",
"861862547", "河南省驻马店市",
"861317990", "新疆克拉玛依市",
"861894280", "四川省凉山彝族自治州",
"861354530", "湖北省襄樊市",
"86189399", "上海市",
"861318816", "辽宁省朝阳市",
"861556549", "河南省漯河市",
"86139758", "湖南省长沙市",
"861335181", "黑龙江省哈尔滨市",
"861376218", "湖南省张家界市",
"861876662", "山东省东营市",
"861370253", "广东省中山市",
"861365364", "山西省太原市",
"861528320", "四川省资阳市",
"861519939", "新疆巴音郭楞蒙古自治州",
"861868931", "广东省佛山市",
"861889095", "新疆喀什地区",
"861535093", "辽宁省铁岭市",
"861576751", "广东省梅州市",
"861557833", "广西南宁市",
"861597323", "湖南省湘潭市",
"861560385", "河南省许昌市",
"86176395", "河南省漯河市",
"86184843", "贵州省黔南布依族苗族自治州",
"861774059", "湖北省襄樊市",
"861809032", "四川省内江市",
"861348479", "内蒙古锡林郭勒盟",
"861313249", "河北省邢台市",
"861596530", "山东省菏泽市",
"86181563", "安徽省宣城市",
"861387281", "湖北省十堰市",
"86177766", "广西南宁市",
"86180556", "安徽省安庆市",
"861309279", "湖北省黄石市",
"861815008", "福建省厦门市",
"86132896", "陕西省延安市",
"861779021", "四川省乐山市",
"861372097", "山西省阳泉市",
"861335466", "云南省玉溪市",
"861778117", "四川省成都市",
"861365329", "河北省邢台市",
"861458674", "湖南省娄底市",
"861302933", "辽宁省锦州市",
"861587748", "陕西省西安市",
"861869010", "新疆塔城地区",
"861470954", "宁夏固原市",
"86152612", "江苏省宿迁市",
"861315422", "辽宁省朝阳市",
"861365277", "广东省惠州市",
"861583549", "山西省朔州市",
"861558563", "吉林省松原市",
"861315638", "山东省青岛市",
"861305568", "福建省莆田市",
"861595406", "山东省威海市",
"861560733", "湖南省株洲市",
"861309327", "湖北省随州市",
"861535717", "安徽省六安市",
"861539245", "福建省三明市",
"861320798", "江西省景德镇市",
"861576813", "广东省深圳市",
"861301331", "云南省昆明市",
"861866626", "广东省阳江市",
"861570858", "贵州省六盘水市",
"861826062", "江苏省镇江市",
"861899971", "新疆伊犁哈萨克自治州",
"861309238", "江苏省连云港市",
"86184529", "江苏省南京市",
"86181287", "广东省佛山市",
"861867740", "广西梧州市",
"861337792", "湖北省黄冈市",
"861321564", "安徽省六安市",
"861309602", "四川省眉山市",
"86187621", "江苏省宿迁市",
"861335061", "四川省宜宾市",
"861837143", "湖北省黄石市",
"861808738", "云南省红河哈尼族彝族自治州",
"861780586", "浙江省台州市",
"861333935", "黑龙江省绥化市",
"861530819", "四川省成都市",
"86156302", "河北省保定市",
"861339305", "河北省唐山市",
"861478473", "内蒙古鄂尔多斯市",
"861592956", "陕西省西安市",
"861393998", "河南省安阳市",
"86135165", "广东省佛山市",
"861330410", "辽宁省铁岭市",
"861571640", "河南省信阳市",
"861524914", "陕西省商洛市",
"861331470", "内蒙古呼伦贝尔市",
"861370574", "浙江省宁波市",
"861538070", "江苏省泰州市",
"861895481", "山东省枣庄市",
"861322697", "广东省佛山市",
"86158584", "浙江省宁波市",
"861558357", "四川省乐山市",
"861890878", "云南省楚雄彝族自治州",
"861399497", "山西省运城市",
"861313423", "辽宁省沈阳市",
"861821647", "湖南省娄底市",
"861536567", "江苏省盐城市",
"861787525", "广东省汕头市",
"861312407", "福建省厦门市",
"861300753", "河南省郑州市",
"861569067", "河南省开封市",
"861570359", "山西省运城市",
"861505619", "安徽省淮北市",
"861380005", "辽宁省沈阳市",
"861315380", "山东省聊城市",
"861708748", "湖南省邵阳市",
"861571628", "江苏省南通市",
"86137823", "河南省许昌市",
"861889250", "贵州省安顺市",
"861450848", "江苏省常州市",
"861341578", "广东省肇庆市",
"86132970", "湖北省武汉市",
"861844562", "黑龙江省黑河市",
"861571432", "吉林省吉林市",
"861378032", "河北省保定市",
"861362472", "内蒙古包头市",
"86186582", "浙江省宁波市",
"861304098", "湖北省宜昌市",
"861479031", "安徽省六安市",
"86830", "四川省泸州市",
"86185791", "江西省南昌市",
"861312338", "福建省厦门市",
"861550944", "甘肃省张掖市",
"861529306", "甘肃省白银市",
"861373981", "河北省邢台市",
"861478347", "河南省南阳市",
"861814041", "四川省凉山彝族自治州",
"861819114", "陕西省西安市",
"861338530", "山东省菏泽市",
"861384886", "内蒙古赤峰市",
"861570034", "四川省广安市",
"861346367", "河北省承德市",
"861315957", "吉林省吉林市",
"861539271", "湖北省黄冈市",
"861556503", "河南省商丘市",
"861513343", "河北省廊坊市",
"861590736", "湖南省常德市",
"861821288", "贵州省黔西南布依族苗族自治州",
"86180991", "新疆乌鲁木齐市",
"861509373", "河南省焦作市",
"861379779", "湖北省咸宁市",
"861369711", "湖北省襄樊市",
"861890379", "河南省洛阳市",
"861819684", "新疆喀什地区",
"86182820", "四川省南充市",
"861530318", "河北省衡水市",
"861358942", "山东省滨州市",
"861899945", "新疆阿勒泰地区",
"861896623", "浙江省宁波市",
"861551260", "河北省廊坊市",
"861856721", "河南省鹤壁市",
"861311905", "新疆阿勒泰地区",
"861388750", "云南省文山壮族苗族自治州",
"861471533", "广东省佛山市",
"861512642", "云南省红河哈尼族彝族自治州",
"86187973", "青海省西宁市",
"861840453", "黑龙江省牡丹江市",
"861768194", "浙江省金华市",
"861586646", "山东省烟台市",
"86182842", "四川省德阳市",
"861314728", "湖北省十堰市",
"861334591", "浙江省金华市",
"861890338", "河北省唐山市",
"86134641", "辽宁省铁岭市",
"861303417", "甘肃省平凉市",
"86170924", "辽宁省沈阳市",
"861328428", "辽宁省沈阳市",
"86181472", "内蒙古包头市",
"861332311", "河北省石家庄市",
"861537469", "内蒙古乌兰察布市",
"861821157", "广东省广州市",
"861330973", "青海省黄南藏族自治州",
"861328208", "浙江省衢州市",
"861852435", "辽宁省丹东市",
"861530452", "黑龙江省齐齐哈尔市",
"861337344", "河北省秦皇岛市",
"861898644", "湖北省随州市",
"861582033", "广东省清远市",
"861337860", "广东省东莞市",
"861476559", "湖北省武汉市",
"861534357", "山西省临汾市",
"861830395", "河南省漯河市",
"86185604", "山东省青岛市",
"86156875", "云南省保山市",
"861331913", "陕西省渭南市",
"861554507", "黑龙江省大兴安岭地区",
"861369853", "贵州省毕节地区",
"861824810", "内蒙古呼和浩特市",
"861856242", "山东省济宁市",
"861890407", "辽宁省营口市",
"861528482", "四川省自贡市",
"861830716", "湖北省荆州市",
"861525551", "安徽省马鞍山市",
"861357918", "新疆阿勒泰地区",
"861537424", "江西省上饶市",
"861338454", "黑龙江省佳木斯市",
"86181233", "四川省成都市",
"861389519", "宁夏银川市",
"861700490", "上海市",
"861859921", "新疆乌鲁木齐市",
"861533092", "辽宁省营口市",
"861520634", "山东省莱芜市",
"861450303", "河北省廊坊市",
"861783912", "河南省许昌市",
"861350083", "吉林省白城市",
"861367446", "吉林省白城市",
"861362629", "江苏省南通市",
"861333215", "辽宁省本溪市",
"861301871", "广东省韶关市",
"861893801", "广东省汕头市",
"861510331", "河北省石家庄市",
"861534980", "安徽省安庆市",
"86187693", "山东省日照市",
"861880635", "山东省聊城市",
"861505069", "江苏省无锡市",
"861320484", "内蒙古鄂尔多斯市",
"861882832", "四川省成都市",
"861829708", "青海省海东地区",
"861366911", "陕西省延安市",
"861780671", "广东省深圳市",
"861583503", "山西省晋中市",
"86180671", "浙江省宁波市",
"861800692", "福建省福州市",
"861582527", "云南省昆明市",
"861534563", "安徽省宣城市",
"861768941", "福建省福州市",
"861814446", "广东省江门市",
"861512152", "贵州省毕节地区",
"861333308", "河北省衡水市",
"861858992", "广西南宁市",
"861800736", "湖南省常德市",
"861709861", "浙江省金华市",
"861866684", "广东省茂名市",
"861500379", "河南省洛阳市",
"861881372", "广东省中山市",
"861311839", "四川省乐山市",
"861370773", "广西桂林市",
"861533117", "辽宁省辽阳市",
"86159991", "新疆乌鲁木齐市",
"861565994", "福建省龙岩市",
"86181081", "四川省成都市",
"861310170", "河南省商丘市",
"86147520", "江苏省苏州市",
"861300152", "山东省滨州市",
"861834541", "黑龙江省大庆市",
"861871976", "甘肃省张掖市",
"861533687", "浙江省杭州市",
"861318030", "河北省沧州市",
"861314857", "广东省东莞市",
"861339938", "甘肃省天水市",
"861359124", "辽宁省鞍山市",
"861311110", "山西省忻州市",
"86181187", "广东省深圳市",
"861350762", "河南省平顶山市",
"861368532", "山东省青岛市",
"861332233", "辽宁省辽阳市",
"861870916", "陕西省汉中市",
"861820720", "湖北省宜昌市",
"861322564", "安徽省六安市",
"861311680", "浙江省舟山市",
"861509945", "新疆巴音郭楞蒙古自治州",
"861768309", "四川省广元市",
"861371713", "广东省深圳市",
"861893766", "河南省信阳市",
"861558729", "云南省大理白族自治州",
"86138045", "黑龙江省哈尔滨市",
"861898876", "广东省深圳市",
"861880312", "河北省保定市",
"861775974", "福建省泉州市",
"861787552", "广东省东莞市",
"861513975", "河南省信阳市",
"86183673", "浙江省嘉兴市",
"861804048", "四川省巴中市",
"861389476", "吉林省长春市",
"861823014", "河北省承德市",
"86152839", "四川省广元市",
"861820966", "宁夏吴忠市",
"86135265", "河南省郑州市",
"861700968", "浙江省台州市",
"861516067", "福建省龙岩市",
"861309759", "山西省大同市",
"861868785", "云南省楚雄彝族自治州",
"861390265", "广东省惠州市",
"861893920", "河南省南阳市",
"861321763", "广东省清远市",
"86151895", "江苏省淮安市",
"861514183", "辽宁省阜新市",
"861557945", "江西省宜春市",
"86188655", "山东省烟台市",
"861387004", "江西省鹰潭市",
"861375448", "河北省邯郸市",
"86138309", "甘肃省陇南市",
"861328796", "山东省烟台市",
"861532879", "四川省甘孜藏族自治州",
"861853413", "山西省临汾市",
"861336779", "广西北海市",
"861535678", "浙江省丽水市",
"861572640", "山东省济南市",
"86186492", "天津市",
"861304721", "湖南省长沙市",
"861459477", "陕西省咸阳市",
"861332470", "广西防城港市",
"861560534", "山东省德州市",
"861566219", "吉林省延边朝鲜族自治州",
"861565141", "江苏省南通市",
"861453939", "广东省湛江市",
"86159409", "辽宁省大连市",
"861327485", "内蒙古通辽市",
"86145089", "上海市",
"861887634", "福建省漳州市",
"861361705", "江西省宜春市",
"861386558", "安徽省阜阳市",
"861380513", "江苏省连云港市",
"86187544", "山东省潍坊市",
"861300642", "四川省乐山市",
"861302845", "陕西省汉中市",
"86170879", "江苏省泰州市",
"861459309", "四川省绵阳市",
"861773070", "陕西省渭南市",
"861335489", "内蒙古呼和浩特市",
"861304242", "辽宁省沈阳市",
"86159671", "浙江省杭州市",
"86139281", "广东省中山市",
"861333781", "江苏省南京市",
"861892170", "江苏省泰州市",
"861530425", "辽宁省本溪市",
"861336738", "湖南省娄底市",
"861535639", "浙江省丽水市",
"861532838", "四川省自贡市",
"861861547", "山东省菏泽市",
"861365757", "新疆阿克苏地区",
"861516617", "山东省日照市",
"861760761", "广东省深圳市",
"861855859", "福建省泉州市",
"861564982", "河南省许昌市",
"861339979", "新疆和田地区",
"861340031", "河北省石家庄市",
"86185355", "山西省长治市",
"861880458", "黑龙江省伊春市",
"861348171", "广西防城港市",
"861333843", "福建省福州市",
"861814862", "广东省广州市",
"861311878", "云南省楚雄彝族自治州",
"861500338", "河北省衡水市",
"861772037", "湖北省荆门市",
"861521791", "广东省佛山市",
"861310818", "四川省达州市",
"861850757", "广东省佛山市",
"861823629", "河南省信阳市",
"861593368", "河北省承德市",
"861893137", "河北省石家庄市",
"86183330", "河北省沧州市",
"861398694", "湖北省武汉市",
"861818600", "湖北省黄石市",
"861522040", "广东省东莞市",
"861560450", "黑龙江省哈尔滨市",
"861308510", "湖北省荆州市",
"861788904", "西藏林芝地区",
"861826875", "浙江省绍兴市",
"861306959", "河南省漯河市",
"86188436", "吉林省白城市",
"861330345", "山西省长治市",
"861367862", "山东省德州市",
"861339218", "广东省深圳市",
"861350890", "山东省菏泽市",
"861575917", "福建省南平市",
"861874636", "黑龙江省佳木斯市",
"861813299", "河北省沧州市",
"861553334", "河北省邯郸市",
"861505086", "江苏省镇江市",
"861301213", "河北省邢台市",
"86158779", "云南省昆明市",
"861520346", "山西省太原市",
"861569778", "广西河池市",
"86159923", "广东省潮州市",
"861550499", "辽宁省锦州市",
"861872047", "江西省赣州市",
"861331311", "河北省石家庄市",
"861323547", "湖北省孝感市",
"861840730", "湖南省岳阳市",
"861534764", "广东省潮州市",
"861537161", "江苏省徐州市",
"861389045", "四川省绵阳市",
"861322082", "山东省威海市",
"861845248", "江苏省镇江市",
"861889770", "广西钦州市",
"861330371", "河南省郑州市",
"86132228", "江苏省无锡市",
"861332913", "安徽省宣城市",
"861824431", "四川省眉山市",
"861300273", "山东省烟台市",
"861847806", "湖南省郴州市",
"861598779", "云南省红河哈尼族彝族自治州",
"861320426", "辽宁省本溪市",
"861362597", "福建省泉州市",
"861361629", "江苏省扬州市",
"86139394", "河南省周口市",
"861500680", "山东省莱芜市",
"861310319", "河北省邢台市",
"861452140", "河北省承德市",
"861890905", "四川省内江市",
"861337636", "山东省潍坊市",
"861302871", "甘肃省兰州市",
"861360358", "山西省太原市",
"861366313", "河北省张家口市",
"861787644", "广东省湛江市",
"861885121", "江苏省常州市",
"86181133", "四川省凉山彝族自治州",
"861534729", "湖北省黄石市",
"86177543", "山东省滨州市",
"861342539", "广东省肇庆市",
"86181746", "湖南省永州市",
"861335842", "福建省泉州市",
"861764559", "黑龙江省伊春市",
"861582699", "湖北省鄂州市",
"86151710", "湖北省恩施土家族苗族自治州",
"861537486", "内蒙古锡林郭勒盟",
"861510933", "甘肃省平凉市",
"861834992", "四川省成都市",
"861454710", "浙江省衢州市",
"861364940", "广西南宁市",
"861786929", "云南省迪庆藏族自治州",
"861859323", "广西桂林市",
"861858541", "贵州省贵阳市",
"861881832", "广东省河源市",
"861303915", "吉林省吉林市",
"861855074", "江苏省宿迁市",
"861473003", "河北省张家口市",
"861538795", "江西省宜春市",
"861839474", "甘肃省酒泉市",
"861375420", "浙江省湖州市",
"861361472", "内蒙古包头市",
"861572432", "辽宁省朝阳市",
"861822647", "安徽省安庆市",
"861768808", "广东省湛江市",
"861518007", "江西省鹰潭市",
"861315561", "安徽省淮北市",
"861501818", "广东省珠海市",
"86156827", "甘肃省兰州市",
"861572628", "山东省滨州市",
"861500878", "云南省丽江市",
"861384869", "内蒙古兴安盟",
"86158494", "内蒙古乌兰察布市",
"861533220", "陕西省咸阳市",
"861538316", "河北省廊坊市",
"861333809", "江苏省南通市",
"86170020", "广东省广州市",
"861782061", "广东省佛山市",
"861879510", "宁夏银川市",
"861372112", "安徽省淮南市",
"86170042", "辽宁省大连市",
"861364317", "河北省沧州市",
"861315455", "黑龙江省绥化市",
"861505481", "山东省青岛市",
"861360412", "辽宁省鞍山市",
"861700002", "北京市",
"861778092", "四川省南充市",
"861533400", "湖北省恩施土家族苗族自治州",
"861700746", "湖北省武汉市",
"861555756", "浙江省温州市",
"861818731", "云南省昆明市",
"861869376", "甘肃省嘉峪关市",
"861452650", "江西省鹰潭市",
"861570727", "湖北省恩施土家族苗族自治州",
"861805406", "安徽省阜阳市",
"861569739", "湖南省邵阳市",
"86133550", "山东省临沂市",
"861816010", "四川省攀枝花市",
"861829560", "宁夏银川市",
"861537081", "江苏省南通市",
"861367790", "江西省新余市",
"861458521", "河南省焦作市",
"861459343", "四川省乐山市",
"861843880", "河南省开封市",
"86157352", "山西省大同市",
"86135535", "广东省湛江市",
"861587989", "江西省宜春市",
"861855412", "山东省烟台市",
"861476085", "江苏省连云港市",
"861477955", "江西省宜春市",
"861829983", "新疆巴音郭楞蒙古自治州",
"86183921", "陕西省西安市",
"861814790", "内蒙古锡林郭勒盟",
"861870356", "山西省晋城市",
"861399756", "湖北省荆州市",
"861522057", "广东省惠州市",
"861380814", "四川省攀枝花市",
"861576097", "陕西省宝鸡市",
"861329144", "浙江省宁波市",
"861880952", "宁夏石嘴山市",
"861501959", "广东省汕尾市",
"861700674", "浙江省温州市",
"861358135", "湖北省荆门市",
"861850740", "湖南省岳阳市",
"861321190", "云南省大理白族自治州",
"861771886", "广东省江门市",
"861345761", "广西玉林市",
"861803724", "河南省周口市",
"86159935", "河南省平顶山市",
"861810454", "黑龙江省佳木斯市",
"861782006", "广东省梅州市",
"86135849", "江苏省苏州市",
"86155109", "天津市",
"86182089", "海南省海口市",
"861532259", "广东省汕头市",
"861326791", "广东省惠州市",
"861335143", "黑龙江省牡丹江市",
"861829309", "甘肃省庆阳市",
"861875884", "浙江省宁波市",
"861576851", "广东省深圳市",
"861591795", "广东省揭阳市",
"861330985", "辽宁省大连市",
"861572218", "贵州省遵义市",
"86134729", "河北省唐山市",
"861364638", "山东省聊城市",
"861453629", "江苏省泰州市",
"861800010", "江苏省徐州市",
"861373909", "湖南省长沙市",
"861333544", "陕西省汉中市",
"861311187", "四川省成都市",
"86136400", "广东省韶关市",
"861890739", "湖南省邵阳市",
"861318716", "湖南省衡阳市",
"861379339", "山东省威海市",
"861360327", "河北省沧州市",
"861347092", "安徽省淮北市",
"861590376", "河南省信阳市",
"861364422", "辽宁省鞍山市",
"861387243", "湖北省荆州市",
"861533180", "黑龙江省哈尔滨市",
"861807568", "湖南省娄底市",
"861772869", "广东省湛江市",
"861817638", "广西梧州市",
"861505101", "江苏省宿迁市",
"86181125", "江苏省苏州市",
"861310677", "广东省阳江市",
"861803769", "河南省郑州市",
"861808879", "黑龙江省大庆市",
"861328955", "宁夏中卫市",
"861524693", "黑龙江省伊春市",
"861848531", "贵州省安顺市",
"861533610", "陕西省咸阳市",
"861301745", "贵州省贵阳市",
"861867277", "湖北省武汉市",
"86151831", "四川省宜宾市",
"861777655", "广西南宁市",
"861817422", "湖南省邵阳市",
"861316554", "河北省石家庄市",
"861318395", "四川省资阳市",
"861801070", "安徽省安庆市",
"861813094", "新疆伊犁哈萨克自治州",
"86187937", "甘肃省酒泉市",
"86181700", "江西省南昌市",
"861886649", "山东省滨州市",
"861572657", "山东省烟台市",
"861453472", "黑龙江省哈尔滨市",
"861818107", "四川省南充市",
"861517543", "河北省邯郸市",
"86186023", "重庆市",
"861379378", "山东省济宁市",
"861890778", "广西河池市",
"861317008", "安徽省阜阳市",
"861319351", "河南省安阳市",
"86158574", "浙江省宁波市",
"861893630", "江苏省盐城市",
"86130756", "广东省珠海市",
"861364679", "浙江省金华市",
"861700462", "上海市",
"861308587", "广东省中山市",
"861533060", "吉林省长春市",
"861787776", "湖南省张家界市",
"861555174", "安徽省芜湖市",
"861524136", "辽宁省锦州市",
"861810530", "山东省菏泽市",
"861800660", "浙江省嘉兴市",
"861335653", "广东省湛江市",
"861817679", "广西梧州市",
"861311067", "福建省漳州市",
"86186463", "黑龙江省哈尔滨市",
"86151748", "内蒙古赤峰市",
"861537106", "江苏省无锡市",
"861518467", "黑龙江省双鸭山市",
"861826255", "江苏省镇江市",
"861351665", "广东省惠州市",
"861320261", "广东省肇庆市",
"861573562", "山西省太原市",
"861552020", "四川省巴中市",
"861832644", "安徽省宣城市",
"861337892", "湖南省怀化市",
"861339432", "吉林省吉林市",
"861888663", "四川省成都市",
"86181277", "广东省惠州市",
"86189558", "安徽省阜阳市",
"861829477", "甘肃省甘南藏族自治州",
"861576713", "广东省汕尾市",
"861570758", "广东省肇庆市",
"861510771", "广西南宁市",
"861569905", "新疆昌吉回族自治州",
"861339628", "山东省滨州市",
"861892677", "广东省深圳市",
"861516680", "山东省滨州市",
"861708349", "山西省长治市",
"861380967", "广东省汕头市",
"861314364", "河北省石家庄市",
"861895443", "山东省淄博市",
"861539682", "江苏省徐州市",
"861450966", "新疆克孜勒苏柯尔克孜自治州",
"861780823", "四川省遂宁市",
"861834784", "内蒙古包头市",
"861587848", "广西百色市",
"861855279", "江苏省徐州市",
"86135956", "贵州省铜仁地区",
"861893388", "广东省广州市",
"861454787", "山东省济宁市",
"861566014", "河南省新乡市",
"861510745", "湖南省怀化市",
"86187983", "贵州省毕节地区",
"86187749", "湖南省长沙市",
"861873404", "安徽省亳州市",
"861597700", "广西钦州市",
"861761444", "吉林省四平市",
"861571305", "河北省唐山市",
"861508776", "云南省昭通市",
"86158438", "吉林省松原市",
"861387209", "湖北省黄石市",
"861567191", "湖北省十堰市",
"861501677", "广东省东莞市",
"861332353", "宁夏吴忠市",
"861760706", "江西省吉安市",
"861369811", "四川省达州市",
"861777171", "湖北省宜昌市",
"861767119", "湖北省恩施土家族苗族自治州",
"861556198", "黑龙江省七台河市",
"861500617", "江苏省无锡市",
"861590836", "四川省泸州市",
"861867828", "山东省枣庄市",
"861452647", "江苏省泰州市",
"861373943", "四川省资阳市",
"861339640", "山东省济南市",
"861818410", "贵州省贵阳市",
"861333652", "广东省茂名市",
"861335109", "黑龙江省大庆市",
"861381334", "江苏省淮安市",
"86176024", "辽宁省沈阳市",
"861808054", "四川省成都市",
"861361978", "青海省西宁市",
"861572938", "河南省郑州市",
"861303355", "江苏省淮安市",
"86186572", "浙江省湖州市",
"861351704", "江西省抚州市",
"861822650", "安徽省淮北市",
"861452288", "山西省吕梁市",
"861323434", "吉林省四平市",
"86132980", "内蒙古通辽市",
"861390025", "广东省广州市",
"861899450", "江苏省连云港市",
"861893442", "贵州省安顺市",
"861334135", "湖南省郴州市",
"861708848", "江西省景德镇市",
"861459560", "陕西省渭南市",
"861300853", "陕西省渭南市",
"861332567", "新疆克拉玛依市",
"861317962", "江苏省苏州市",
"861502718", "湖北省恩施土家族苗族自治州",
"861538956", "陕西省延安市",
"861786880", "陕西省西安市",
"86152545", "山东省烟台市",
"861572979", "四川省凉山彝族自治州",
"86180681", "江苏省南通市",
"861560373", "河南省新乡市",
"861454431", "江苏省苏州市",
"861592507", "云南省昭通市",
"861882732", "湖北省咸宁市",
"861514223", "辽宁省鞍山市",
"861858784", "广西柳州市",
"86189419", "辽宁省辽阳市",
"861895409", "山东省济宁市",
"861364957", "宁夏固原市",
"861341997", "河南省信阳市",
"861865041", "福建省莆田市",
"861816736", "浙江省绍兴市",
"861770393", "河南省濮阳市",
"861458490", "山东省淄博市",
"861301771", "浙江省绍兴市",
"861802316", "广东省汕尾市",
"861566629", "山东省滨州市",
"861333142", "吉林省辽源市",
"861840666", "广东省深圳市",
"861550535", "山东省烟台市",
"861868253", "四川省遂宁市",
"861563875", "河南省许昌市",
"861816087", "安徽省滁州市",
"861346511", "山东省威海市",
"861592070", "广东省佛山市",
"861779104", "陕西省渭南市",
"861555995", "云南省曲靖市",
"861350041", "辽宁省朝阳市",
"86134213", "广东省深圳市",
"861808378", "江苏省扬州市",
"86152290", "陕西省西安市",
"86135591", "福建省福州市",
"861880427", "辽宁省盘锦市",
"861820901", "新疆塔城地区",
"86156885", "山东省烟台市",
"861595124", "江苏省宿迁市",
"861337760", "广东省中山市",
"861840411", "辽宁省大连市",
"861566664", "山东省烟台市",
"861872050", "江西省宜春市",
"861323550", "湖北省随州市",
"861329542", "山东省青岛市",
"86139338", "河北省石家庄市",
"86181482", "内蒙古兴安盟",
"861593037", "河北省衡水市",
"861850728", "湖北省十堰市",
"861377498", "山东省菏泽市",
"861831876", "广东省中山市",
"861536470", "山西省忻州市",
"861380551", "安徽省合肥市",
"861589974", "广东省江门市",
"861333625", "山东省聊城市",
"861391454", "江苏省泰州市",
"861558340", "四川省成都市",
"861450989", "新疆昌吉回族自治州",
"861778610", "湖北省武汉市",
"861376640", "江西省宜春市",
"861335394", "河南省周口市",
"861304821", "广东省肇庆市",
"861840370", "河南省商丘市",
"861571657", "河南省信阳市",
"861850496", "内蒙古呼和浩特市",
"861336879", "云南省普洱市",
"861532779", "湖北省荆州市",
"861820349", "山西省朔州市",
"861328896", "广东省茂名市",
"861778180", "四川省内江市",
"86158314", "河北省承德市",
"861327910", "陕西省咸阳市",
"861869167", "陕西省延安市",
"861321863", "江苏省盐城市",
"861330731", "湖南省长沙市",
"861889330", "甘肃省临夏回族自治州",
"861458968", "广东省汕尾市",
"861329393", "山西省忻州市",
"861892718", "广东省云浮市",
"861309859", "贵州省黔西南布依族苗族自治州",
"861829975", "新疆乌鲁木齐市",
"861569407", "四川省泸州市",
"861859700", "青海省海北藏族自治州",
"861576514", "黑龙江省佳木斯市",
"86155665", "辽宁省锦州市",
"861575605", "安徽省淮北市",
"86137835", "河南省郑州市",
"861320104", "新疆吐鲁番地区",
"861878412", "四川省宜宾市",
"861503442", "山西省太原市",
"86157732", "湖南省湘潭市",
"86183683", "浙江省嘉兴市",
"861304546", "黑龙江省鹤岗市",
"861506331", "山东省日照市",
"861898776", "云南省昆明市",
"861302623", "江西省鹰潭市",
"861894217", "湖北省十堰市",
"86134660", "云南省曲靖市",
"861358200", "河北省石家庄市",
"861365496", "辽宁省锦州市",
"8613710", "广东省广州市",
"861598339", "四川省乐山市",
"861315928", "福建省南平市",
"861831644", "广东省深圳市",
"861390052", "江苏省镇江市",
"861358420", "江苏省无锡市",
"861873993", "河南省郑州市",
"861514141", "辽宁省本溪市",
"861503388", "河北省邯郸市",
"861373375", "河南省平顶山市",
"861807700", "广西南宁市",
"861524078", "广西桂林市",
"861350862", "湖北省荆州市",
"861862434", "辽宁省沈阳市",
"86181177", "海南省海口市",
"861398913", "四川省泸州市",
"86132112", "广东省汕头市",
"86153767", "山东省青岛市",
"861882696", "广东省东莞市",
"86137744", "上海市",
"861770542", "山东省青岛市",
"861311739", "湖南省邵阳市",
"861316811", "广东省梅州市",
"86139465", "黑龙江省七台河市",
"861565063", "安徽省宿州市",
"861890617", "江苏省无锡市",
"861377960", "新疆克孜勒苏柯尔克孜自治州",
"861534328", "湖南省娄底市",
"861524039", "江苏省宿迁市",
"861502959", "陕西省安康市",
"861527207", "湖北省咸宁市",
"861821128", "广东省梅州市",
"861598378", "四川省南充市",
"86158365", "河南省许昌市",
"861850857", "贵州省毕节地区",
"861328457", "黑龙江省大兴安岭地区",
"861877448", "湖南省邵阳市",
"861310718", "湖南省娄底市",
"861360759", "福建省漳州市",
"861890067", "江苏省南京市",
"86135481", "四川省成都市",
"861856900", "湖南省株洲市",
"861530637", "山东省枣庄市",
"861512853", "河北省秦皇岛市",
"86181592", "福建省泉州市",
"861529361", "甘肃省张掖市",
"86184603", "江西省赣州市",
"861521891", "广东省佛山市",
"861707641", "山东省济南市",
"861534237", "湖北省黄冈市",
"861470314", "河北省承德市",
"861311778", "广西河池市",
"861330487", "黑龙江省鸡西市",
"861890258", "广东省江门市",
"861846232", "山东省临沂市",
"861805124", "江苏省苏州市",
"86155614", "内蒙古包头市",
"86155209", "四川省乐山市",
"861521268", "安徽省淮南市",
"861397189", "湖北省恩施土家族苗族自治州",
"861802507", "广东省珠海市",
"861351549", "山东省临沂市",
"861327347", "河北省邢台市",
"861781742", "广东省肇庆市",
"861869736", "河南省许昌市",
"86150419", "辽宁省辽阳市",
"861818371", "云南省昆明市",
"861312617", "广东省梅州市",
"861365857", "贵州省毕节地区",
"86139271", "广东省云浮市",
"861333881", "江苏省镇江市",
"86159681", "浙江省杭州市",
"86177080", "四川省成都市",
"86170889", "广东省汕头市",
"861580397", "河南省信阳市",
"861302745", "湖南省株洲市",
"861300285", "四川省达州市",
"861812052", "湖北省恩施土家族苗族自治州",
"861869087", "新疆昌吉回族自治州",
"861582558", "浙江省宁波市",
"861535780", "安徽省淮北市",
"861868621", "内蒙古赤峰市",
"861805169", "江苏省盐城市",
"861853451", "山西省晋城市",
"861560945", "甘肃省金昌市",
"86139414", "辽宁省本溪市",
"861841947", "甘肃省天水市",
"861887293", "湖北省荆州市",
"861859631", "山东省威海市",
"861327230", "湖南省衡阳市",
"861899733", "青海省西宁市",
"861370333", "河北省沧州市",
"861500739", "湖南省邵阳市",
"86182453", "黑龙江省牡丹江市",
"86147615", "江苏省无锡市",
"861342997", "湖北省十堰市",
"861800376", "河南省信阳市",
"86187662", "山东省青岛市",
"861454810", "广东省广州市",
"861529299", "新疆和田地区",
"861362939", "甘肃省陇南市",
"86185735", "湖南省郴州市",
"861770654", "浙江省绍兴市",
"861590010", "广东省汕尾市",
"861705314", "广东省深圳市",
"861571979", "青海省海西蒙古族藏族自治州",
"861561911", "陕西省延安市",
"861386699", "安徽省芜湖市",
"861770991", "新疆乌鲁木齐市",
"861595555", "安徽省马鞍山市",
"861336054", "广东省深圳市",
"861534829", "四川省巴中市",
"861570919", "陕西省铜川市",
"861560971", "青海省西宁市",
"861369554", "安徽省淮南市",
"861774254", "湖南省衡阳市",
"86183750", "贵州省黔南布依族苗族自治州",
"861597568", "广东省阳江市",
"861858726", "云南省昆明市",
"861454139", "河北省邢台市",
"861891959", "青海省海西蒙古族藏族自治州",
"861364561", "安徽省淮北市",
"86185844", "贵州省遵义市",
"861530958", "宁夏银川市",
"861811025", "安徽省芜湖市",
"861768381", "湖北省孝感市",
"861459708", "宁夏固原市",
"861520969", "宁夏银川市",
"86152628", "江苏省南通市",
"861509132", "陕西省西安市",
"86183637", "山东省枣庄市",
"861889870", "广东省东莞市",
"861327473", "内蒙古乌海市",
"86138911", "陕西省延安市",
"861815468", "广西贵港市",
"861771368", "四川省绵阳市",
"861840689", "云南省西双版纳傣族自治州",
"861335006", "四川省成都市",
"861336339", "河北省唐山市",
"86137450", "黑龙江省哈尔滨市",
"86176920", "河北省邯郸市",
"861840830", "四川省凉山彝族自治州",
"861364455", "黑龙江省绥化市",
"861569878", "辽宁省盘锦市",
"86134801", "广东省深圳市",
"86158943", "云南省西双版纳傣族自治州",
"861534340", "山西省太原市",
"861309412", "湖北省襄樊市",
"86180935", "甘肃省武威市",
"861877420", "湖南省株洲市",
"861381585", "江苏省南京市",
"861350790", "江西省新余市",
"861821140", "广东省肇庆市",
"861307001", "新疆巴音郭楞蒙古自治州",
"861309358", "安徽省宿州市",
"861777479", "广西北海市",
"86150558", "安徽省阜阳市",
"861331353", "山西省阳泉市",
"86134866", "浙江省宁波市",
"861347687", "湖北省咸宁市",
"86182602", "江苏省苏州市",
"861770144", "江苏省扬州市",
"861332951", "黑龙江省哈尔滨市",
"861369430", "吉林省长春市",
"861860365", "黑龙江省哈尔滨市",
"861368916", "陕西省汉中市",
"861870532", "山东省青岛市",
"861896933", "浙江省嘉兴市",
"861570827", "四川省巴中市",
"861595066", "江苏省徐州市",
"861478350", "河南省焦作市",
"861569839", "山西省晋中市",
"861534917", "陕西省宝鸡市",
"861835636", "安徽省马鞍山市",
"861346854", "陕西省延安市",
"861351503", "福建省泉州市",
"861353699", "广东省肇庆市",
"861700846", "浙江省绍兴市",
"861315940", "福建省福州市",
"861818831", "四川省巴中市",
"861558237", "山西省临汾市",
"861571938", "甘肃省天水市",
"861320502", "福建省福州市",
"86186312", "河北省保定市",
"861333709", "内蒙古锡林郭勒盟",
"861370785", "广西玉林市",
"861372245", "河北省石家庄市",
"861576682", "广东省惠州市",
"861366351", "山西省太原市",
"861500778", "广西河池市",
"861537043", "江苏省无锡市",
"861824887", "江苏省镇江市",
"861337508", "福建省龙岩市",
"861454178", "浙江省丽水市",
"86156326", "河北省廊坊市",
"861305323", "安徽省宣城市",
"861768708", "云南省楚雄彝族自治州",
"861459381", "贵州省六盘水市",
"861331567", "河北省秦皇岛市",
"861303480", "湖南省娄底市",
"861558328", "四川省资阳市",
"861471834", "广东省河源市",
"861773956", "河南省漯河市",
"861355365", "广东省茂名市",
"861324538", "山东省泰安市",
"861801083", "安徽省宣城市",
"861885036", "福建省福州市",
"86135677", "浙江省温州市",
"86133916", "北京市",
"86187475", "内蒙古通辽市",
"861328471", "内蒙古包头市",
"861850871", "云南省昆明市",
"861824815", "内蒙古包头市",
"861856739", "河南省新乡市",
"861520011", "河北省邯郸市",
"86152594", "福建省泉州市",
"861808633", "湖北省黄石市",
"861885787", "浙江省杭州市",
"861366837", "四川省乐山市",
"861325869", "黑龙江省齐齐哈尔市",
"861331046", "贵州省铜仁地区",
"861332659", "广东省阳江市",
"86137351", "浙江省湖州市",
"861364447", "吉林省吉林市",
"861886309", "山东省滨州市",
"861300937", "辽宁省鞍山市",
"861852430", "辽宁省鞍山市",
"861830390", "河南省焦作市",
"861368424", "四川省达州市",
"861360342", "河南省驻马店市",
"861337865", "广东省深圳市",
"86182201", "陕西省延安市",
"861857581", "广东省肇庆市",
"861346899", "陕西省渭南市",
"861888291", "四川省阿坝藏族羌族自治州",
"861453800", "四川省德阳市",
"861305597", "福建省龙岩市",
"861320693", "黑龙江省黑河市",
"861570061", "四川省成都市",
"861880630", "山东省威海市",
"861319101", "山西省晋中市",
"861372618", "广东省江门市",
"861365871", "云南省昆明市",
"861339823", "四川省乐山市",
"861818357", "云南省曲靖市",
"861845252", "江苏省宿迁市",
"861360488", "黑龙江省哈尔滨市",
"861331702", "江西省九江市",
"861809581", "新疆喀什地区",
"861887579", "河北省沧州市",
"8615222", "天津市",
"861372188", "河南省平顶山市",
"86187206", "江西省宜春市",
"861459413", "云南省西双版纳傣族自治州",
"861535574", "浙江省宁波市",
"86176855", "山东省青岛市",
"861700495", "北京市",
"861560422", "辽宁省鞍山市",
"861561069", "山东省泰安市",
"861333210", "辽宁省鞍山市",
"861368469", "黑龙江省双鸭山市",
"86138753", "湖南省益阳市",
"861780432", "吉林省吉林市",
"861853477", "山西省吕梁市",
"861534985", "安徽省巢湖市",
"861892449", "广东省汕尾市",
"861560638", "山东省德州市",
"861880889", "云南省丽江市",
"861501882", "广东省中山市",
"861338326", "河北省保定市",
"861318362", "四川省乐山市",
"861372257", "河北省秦皇岛市",
"861334719", "内蒙古包头市",
"861517032", "江西省萍乡市",
"861859939", "新疆伊犁哈萨克自治州",
"861583376", "河北省沧州市",
"861853309", "河北省石家庄市",
"861770699", "福建省泉州市",
"86151723", "湖北省武汉市",
"861860543", "山东省滨州市",
"861362631", "山东省威海市",
"861386654", "安徽省宿州市",
"861571671", "河南省开封市",
"861373453", "黑龙江省佳木斯市",
"861573972", "新疆石河子市",
"861538041", "江苏省南京市",
"861510329", "河北省邢台市",
"861331441", "贵州省遵义市",
"861521476", "浙江省台州市",
"861336099", "广东省河源市",
"861560679", "浙江省金华市",
"861570611", "江苏省常州市",
"861332149", "吉林省白山市",
"861707177", "江西省鹰潭市",
"86135997", "福建省泉州市",
"861787520", "广东省惠州市",
"86138377", "河南省南阳市",
"861372068", "陕西省榆林市",
"861381517", "江苏省镇江市",
"861820752", "广东省惠州市",
"861341846", "广东省深圳市",
"861349537", "广西梧州市",
"86180182", "江苏省常州市",
"861535253", "新疆伊犁哈萨克自治州",
"861889255", "贵州省黔南布依族苗族自治州",
"861562481", "内蒙古呼和浩特市",
"86187261", "安徽省安庆市",
"861353144", "广东省佛山市",
"86177512", "江苏省苏州市",
"861591762", "广东省清远市",
"861551265", "河北省衡水市",
"861893952", "河南省郑州市",
"861520661", "山东省淄博市",
"861370093", "四川省乐山市",
"861308003", "吉林省长春市",
"861899940", "新疆乌鲁木齐市",
"86130797", "吉林省吉林市",
"861388755", "云南省红河哈尼族彝族自治州",
"861355543", "黑龙江省佳木斯市",
"861555008", "山东省日照市",
"861366443", "吉林省长春市",
"861539408", "甘肃省张掖市",
"861311900", "新疆昌吉回族自治州",
"86189946", "江苏省泰州市",
"861840981", "新疆伊犁哈萨克自治州",
"861375927", "云南省西双版纳傣族自治州",
"861886477", "河南省焦作市",
"861501223", "云南省丽江市",
"86182266", "安徽省合肥市",
"861479184", "陕西省西安市",
"861350956", "福建省宁德市",
"861317174", "河北省衡水市",
"86183585", "浙江省绍兴市",
"861532923", "贵州省安顺市",
"861314771", "吉林省长春市",
"86159910", "陕西省咸阳市",
"861338535", "山东省烟台市",
"861587153", "湖北省鄂州市",
"861801163", "四川省泸州市",
"861570466", "黑龙江省黑河市",
"861398598", "贵州省黔西南布依族苗族自治州",
"86133908", "江苏省苏州市",
"861829159", "陕西省铜川市",
"861539337", "甘肃省酒泉市",
"86136658", "浙江省金华市",
"861819493", "新疆伊犁哈萨克自治州",
"86135548", "广东省深圳市",
"861580786", "广西百色市",
"861893427", "广东省阳江市",
"861361568", "安徽省阜阳市",
"861310882", "云南省德宏傣族景颇族自治州",
"861864572", "黑龙江省大兴安岭地区",
"86187531", "山东省济南市",
"86180065", "浙江省金华市",
"861375452", "河北省保定市",
"861360794", "江西省抚州市",
"861354326", "广东省深圳市",
"861394836", "内蒙古赤峰市",
"861301277", "山东省日照市",
"861867745", "广西贺州市",
"861378581", "河北省沧州市",
"861893207", "贵州省黔西南布依族苗族自治州",
"861304617", "广东省韶关市",
"861479582", "广西南宁市",
"861317572", "浙江省衢州市",
"861707949", "河南省安阳市",
"86138038", "河南省郑州市",
"861332977", "湖北省荆州市",
"86153305", "重庆市",
"861779039", "四川省广安市",
"86155472", "内蒙古包头市",
"861539240", "福建省南平市",
"861533252", "陕西省汉中市",
"861365331", "河北省石家庄市",
"861580523", "江苏省淮安市",
"861568792", "云南省西双版纳傣族自治州",
"861815276", "湖南省郴州市",
"861571645", "河南省三门峡市",
"861323284", "广东省清远市",
"861787548", "广东省广州市",
"861538075", "江苏省南京市",
"861452438", "辽宁省营口市",
"861855794", "浙江省绍兴市",
"861331475", "内蒙古通辽市",
"861345834", "四川省巴中市",
"861564918", "河南省信阳市",
"861760533", "山东省淄博市",
"861890546", "山东省东营市",
"861452622", "江苏省苏州市",
"861366377", "河南省南阳市",
"861379633", "黑龙江省齐齐哈尔市",
"86184639", "山东省菏泽市",
"861813646", "江苏省扬州市",
"861333930", "黑龙江省哈尔滨市",
"861832491", "安徽省宿州市",
"861890821", "四川省成都市",
"86138680", "浙江省杭州市",
"861300148", "河北省沧州市",
"86182536", "山东省潍坊市",
"861339300", "河北省邯郸市",
"861778772", "云南省玉溪市",
"861519921", "新疆阿克苏地区",
"86139672", "浙江省湖州市",
"861880701", "江西省鹰潭市",
"861330415", "辽宁省丹东市",
"861802762", "广东省江门市",
"861452307", "河南省新乡市",
"861471806", "广东省梅州市",
"861894285", "四川省成都市",
"861335359", "山西省运城市",
"861317995", "新疆吐鲁番地区",
"861329527", "江苏省宿迁市",
"861879003", "河南省焦作市",
"861539877", "云南省玉溪市",
"86151791", "江西省南昌市",
"861507684", "河北省衡水市",
"861528325", "四川省内江市",
"861452479", "黑龙江省哈尔滨市",
"861346398", "河北省石家庄市",
"861340126", "江苏省连云港市",
"861886808", "浙江省衢州市",
"861504711", "内蒙古呼和浩特市",
"861362700", "江西省南昌市",
"861364373", "河南省新乡市",
"861864995", "福建省泉州市",
"861560957", "宁夏中卫市",
"861841955", "甘肃省武威市",
"861571586", "浙江省绍兴市",
"861366409", "内蒙古鄂尔多斯市",
"861392191", "江苏省扬州市",
"861355509", "黑龙江省大兴安岭地区",
"861310403", "黑龙江省齐齐哈尔市",
"861302757", "河南省平顶山市",
"861890685", "浙江省绍兴市",
"861867623", "广东省中山市",
"861500900", "新疆乌鲁木齐市",
"861308049", "河北省保定市",
"861501449", "广东省云浮市",
"861454281", "辽宁省沈阳市",
"861596535", "山东省烟台市",
"86135380", "广东省深圳市",
"861588903", "西藏山南地区",
"861572569", "山东省枣庄市",
"861880388", "河南省商丘市",
"861536598", "江苏省镇江市",
"86139992", "新疆乌鲁木齐市",
"861836146", "江苏省盐城市",
"861763541", "山西省晋中市",
"861569098", "内蒙古包头市",
"861300658", "山东省济南市",
"861386542", "安徽省合肥市",
"861889090", "新疆塔城地区",
"861868817", "广东省珠海市",
"861329033", "山东省济南市",
"861301329", "河北省邢台市",
"861816503", "陕西省渭南市",
"861560380", "河南省新乡市",
"861575107", "江苏省徐州市",
"861312546", "辽宁省大连市",
"861571723", "湖北省黄石市",
"861860509", "福建省龙岩市",
"861313732", "河南省新乡市",
"861579802", "江西省抚州市",
"861554041", "内蒙古乌兰察布市",
"86186156", "山东省济南市",
"861770527", "江苏省扬州市",
"861533225", "陕西省渭南市",
"861303347", "山西省吕梁市",
"861572671", "西藏拉萨市",
"861313696", "黑龙江省鸡西市",
"861361631", "山东省威海市",
"861806326", "山东省潍坊市",
"86147836", "河南省濮阳市",
"861319377", "河南省开封市",
"861500546", "山东省东营市",
"861332441", "吉林省吉林市",
"861315450", "黑龙江省哈尔滨市",
"861879515", "宁夏中卫市",
"861885139", "江苏省宿迁市",
"861562189", "山东省济南市",
"861452516", "山东省潍坊市",
"861534731", "湖南省长沙市",
"861533405", "湖北省宜昌市",
"861894853", "广东省阳江市",
"861570489", "内蒙古鄂尔多斯市",
"86187067", "陕西省西安市",
"86180282", "广东省东莞市",
"861538790", "江西省新余市",
"861356052", "广东省湛江市",
"861537134", "江苏省扬州市",
"861375425", "浙江省丽水市",
"861355744", "广西梧州市",
"861786931", "云南省楚雄彝族自治州",
"861370639", "山东省德州市",
"861522476", "河南省商丘市",
"86135625", "山东省烟台市",
"861369627", "四川省绵阳市",
"861874072", "陕西省榆林市",
"86187118", "湖南省娄底市",
"861390596", "福建省泉州市",
"861824464", "河北省衡水市",
"861476080", "江苏省盐城市",
"861309982", "云南省楚雄彝族自治州",
"86159065", "浙江省宁波市",
"86182166", "贵州省六盘水市",
"861477950", "江西省九江市",
"861883067", "河北省石家庄市",
"861503427", "山西省吕梁市",
"861510757", "广东省佛山市",
"861367316", "河北省石家庄市",
"861773446", "河北省廊坊市",
"861569242", "广东省广州市",
"861528418", "四川省宜宾市",
"861532321", "广东省揭阳市",
"861820609", "福建省厦门市",
"861452655", "江西省宜春市",
"861328138", "四川省德阳市",
"861802163", "江苏省苏州市",
"861310141", "福建省福州市",
"86133727", "重庆市",
"861778173", "四川省广安市",
"861840383", "黑龙江省大庆市",
"861450852", "江苏省扬州市",
"86156771", "广西南宁市",
"86159425", "辽宁省丹东市",
"861860744", "湖南省张家界市",
"861829565", "宁夏中卫市",
"861816015", "四川省成都市",
"861458578", "山东省菏泽市",
"861814316", "吉林省白城市",
"86151355", "山西省长治市",
"861708752", "江西省抚州市",
"861367795", "江西省宜春市",
"861536483", "山西省太原市",
"861509928", "新疆阿克苏地区",
"861705023", "河南省郑州市",
"861522071", "广东省惠州市",
"861389040", "四川省南充市",
"861530382", "河南省郑州市",
"861588494", "四川省广安市",
"861569721", "湖北省荆州市",
"861512148", "贵州省毕节地区",
"861535773", "安徽省马鞍山市",
"861812596", "广东省揭阳市",
"861889775", "广西玉林市",
"861327607", "福建省南平市",
"86182813", "四川省自贡市",
"86138325", "河北省唐山市",
"861837278", "湖北省鄂州市",
"861778907", "西藏拉萨市",
"861880866", "湖北省随州市",
"861841922", "甘肃省兰州市",
"861368486", "江西省吉安市",
"861843621", "河南省许昌市",
"861330237", "广东省云浮市",
"861315534", "安徽省芜湖市",
"861305664", "四川省宜宾市",
"86155187", "河南省商丘市",
"861458539", "河南省漯河市",
"861350895", "山东省淄博市",
"86155081", "四川省南充市",
"861857844", "广东省佛山市",
"861334637", "山东省枣庄市",
"861528352", "四川省雅安市",
"861781727", "广东省茂名市",
"861319264", "广东省云浮市",
"861330328", "河北省秦皇岛市",
"861766051", "山东省威海市",
"861782034", "广东省梅州市",
"861576877", "广东省深圳市",
"861840735", "湖南省郴州市",
"861332046", "云南省文山壮族苗族自治州",
"861328179", "四川省遂宁市",
"861325886", "吉林省白城市",
"861775190", "江苏省淮安市",
"861809844", "安徽省宣城市",
"861332702", "内蒙古兴安盟",
"861478417", "河南省信阳市",
"861364945", "广西玉林市",
"861454715", "浙江省绍兴市",
"861300435", "江苏省镇江市",
"861302828", "辽宁省辽阳市",
"861892141", "江苏省南京市",
"861513413", "辽宁省抚顺市",
"861303910", "吉林省长春市",
"861783504", "山西省忻州市",
"861575831", "云南省楚雄彝族自治州",
"861380492", "辽宁省鞍山市",
"861500685", "山东省东营市",
"861454396", "贵州省铜仁地区",
"861319409", "福建省厦门市",
"86185895", "海南省海口市",
"861773041", "安徽省阜阳市",
"861502882", "河北省衡水市",
"861891449", "江苏省南京市",
"861452145", "河北省秦皇岛市",
"861890900", "四川省自贡市",
"861879146", "陕西省汉中市",
"861370678", "浙江省温州市",
"861867251", "湖北省黄冈市",
"86130019", "北京市",
"861320354", "山西省晋中市",
"861527630", "新疆石河子市",
"861892175", "江苏省徐州市",
"861533772", "上海市",
"86136301", "广东省佛山市",
"861571524", "江苏省宿迁市",
"861530420", "辽宁省铁岭市",
"861816704", "浙江省台州市",
"861520579", "浙江省金华市",
"861329699", "内蒙古巴彦淖尔市",
"861351167", "江苏省常州市",
"861374919", "河南省郑州市",
"861364971", "青海省海东地区",
"861330829", "四川省巴中市",
"86180477", "内蒙古鄂尔多斯市",
"861388241", "四川省巴中市",
"861777647", "广西桂林市",
"861322531", "山东省济南市",
"861534600", "河南省漯河市",
"861820643", "山东省淄博市",
"861301757", "河南省平顶山市",
"861507626", "河北省保定市",
"861340614", "山东省东营市",
"861308656", "四川省宜宾市",
"861327480", "内蒙古呼和浩特市",
"861889883", "广东省深圳市",
"861535885", "江苏省扬州市",
"861847533", "广东省梅州市",
"861470023", "安徽省六安市",
"861450419", "辽宁省辽阳市",
"861361700", "江西省南昌市",
"861328947", "陕西省榆林市",
"861773075", "陕西省汉中市",
"861876088", "云南省迪庆藏族自治州",
"861302840", "陕西省西安市",
"861572586", "山东省东营市",
"861452171", "吉林省四平市",
"861309108", "河北省唐山市",
"861571569", "安徽省合肥市",
"861335727", "湖南省郴州市",
"86132668", "广东省深圳市",
"861554790", "内蒙古巴彦淖尔市",
"861311821", "四川省遂宁市",
"86150859", "贵州省贵阳市",
"86157050", "内蒙古呼伦贝尔市",
"861330864", "湖北省武汉市",
"861818605", "湖北省武汉市",
"861522045", "广东省汕头市",
"861560455", "黑龙江省绥化市",
"861589082", "河南省驻马店市",
"861470537", "山东省济宁市",
"861776967", "浙江省湖州市",
"861330340", "山西省太原市",
"861826870", "浙江省舟山市",
"86177805", "四川省成都市",
"861860392", "河南省鹤壁市",
"861889741", "湖南省益阳市",
"861308515", "湖北省宜昌市",
"86152643", "山东省淄博市",
"861887011", "江西省赣州市",
"861315132", "江苏省淮安市",
"86139854", "贵州省贵阳市",
"86186256", "河南省南阳市",
"861560561", "安徽省淮北市",
"861882044", "广东省湛江市",
"86152484", "内蒙古鄂尔多斯市",
"86147373", "广东省广州市",
"861572723", "湖北省荆州市",
"861376823", "广西桂林市",
"861334958", "黑龙江省鹤岗市",
"861311546", "黑龙江省鸡西市",
"861319837", "四川省凉山彝族自治州",
"861558731", "山东省日照市",
"861365933", "甘肃省白银市",
"861330917", "陕西省宝鸡市",
"861311115", "山西省长治市",
"861776814", "江苏省南京市",
"86150946", "黑龙江省鸡西市",
"861378844", "广西柳州市",
"86151119", "重庆市",
"861302277", "山东省泰安市",
"86183495", "四川省绵阳市",
"861820725", "湖北省黄冈市",
"861889402", "甘肃省兰州市",
"861509940", "新疆伊犁哈萨克自治州",
"861379099", "广东省湛江市",
"861311685", "浙江省绍兴市",
"861898548", "贵州省六盘水市",
"861303473", "内蒙古乌海市",
"861501651", "广东省潮州市",
"861873436", "山西省忻州市",
"861513970", "河南省商丘市",
"861362568", "安徽省阜阳市",
"861501994", "广东省珠海市",
"861319443", "福建省莆田市",
"861821932", "广东省肇庆市",
"861819904", "新疆和田地区",
"861589162", "陕西省汉中市",
"861308146", "山东省聊城市",
"86184812", "四川省凉山彝族自治州",
"861580724", "湖北省咸宁市",
"861777157", "湖北省荆门市",
"861826118", "江苏省常州市",
"861823631", "河南省周口市",
"861810499", "辽宁省辽阳市",
"861760734", "湖南省衡阳市",
"861354384", "广东省中山市",
"861310175", "河南省平顶山市",
"86180910", "陕西省西安市",
"861331977", "新疆巴音郭楞蒙古自治州",
"861318035", "河北省廊坊市",
"861590804", "山东省菏泽市",
"861836049", "江苏省盐城市",
"86137795", "新疆伊犁哈萨克自治州",
"861588788", "云南省玉溪市",
"86137608", "广东省广州市",
"861351736", "湖南省常德市",
"861518541", "贵州省安顺市",
"861520538", "山东省泰安市",
"861512937", "陕西省宝鸡市",
"861572645", "山东省烟台市",
"861376282", "湖南省娄底市",
"861850933", "甘肃省平凉市",
"861332475", "广西贵港市",
"86185710", "湖北省宜昌市",
"86136366", "上海市",
"86159182", "广东省中山市",
"861576228", "山东省青岛市",
"861580769", "广东省东莞市",
"861826247", "江苏省徐州市",
"86155133", "山西省朔州市",
"861558487", "吉林省白城市",
"86155746", "湖南省永州市",
"861316599", "浙江省杭州市",
"861886941", "云南省昭通市",
"861596384", "山东省日照市",
"861360593", "福建省龙岩市",
"861323406", "辽宁省大连市",
"861587752", "陕西省延安市",
"861557940", "江西省上饶市",
"861518826", "河南省信阳市",
"861893925", "河南省郑州市",
"861390260", "广东省东莞市",
"86158170", "广东省广州市",
"861317856", "广东省湛江市",
"861529825", "四川省泸州市",
"861558050", "湖南省湘西土家族苗族自治州",
"861364376", "河南省信阳市",
"861554837", "内蒙古锡林郭勒盟",
"861598344", "四川省凉山彝族自治州",
"861336792", "江西省九江市",
"861590422", "辽宁省阜新市",
"861530695", "福建省泉州市",
"861827062", "江西省宜春市",
"86159000", "广东省中山市",
"861339575", "浙江省绍兴市",
"861571583", "浙江省绍兴市",
"86177479", "内蒙古锡林郭勒盟",
"861830068", "河南省郑州市",
"861551859", "河南省信阳市",
"861867626", "广东省中山市",
"861590638", "山东省烟台市",
"861862449", "辽宁省盘锦市",
"861479241", "安徽省宿州市",
"861310406", "黑龙江省双鸭山市",
"86133018", "上海市",
"861340755", "江苏省宿迁市",
"861398469", "贵州省黔西南布依族苗族自治州",
"86182726", "河南省商丘市",
"861538377", "河北省沧州市",
"861556447", "山东省淄博市",
"861517739", "广西河池市",
"861334012", "江西省九江市",
"861883032", "河北省张家口市",
"86156477", "内蒙古鄂尔多斯市",
"861831880", "广东省河源市",
"861879006", "河南省信阳市",
"861352385", "河南省新乡市",
"861571960", "甘肃省临夏回族自治州",
"861503668", "河南省商丘市",
"86152712", "湖北省咸宁市",
"86133167", "广东省江门市",
"86188323", "河北省张家口市",
"861370304", "广东省中山市",
"86132815", "四川省绵阳市",
"861308394", "浙江省衢州市",
"861319790", "江西省新余市",
"861390488", "黑龙江省佳木斯市",
"861311744", "湖南省张家界市",
"861516581", "山东省聊城市",
"861340123", "江苏省泰州市",
"861534295", "湖北省十堰市",
"861882502", "广东省中山市",
"86135893", "山东省青岛市",
"861329036", "山东省烟台市",
"861816506", "陕西省汉中市",
"861369468", "黑龙江省牡丹江市",
"861708646", "江苏省盐城市",
"861571726", "湖北省恩施土家族苗族自治州",
"861800561", "安徽省淮北市",
"861312543", "辽宁省沈阳市",
"861810631", "山东省威海市",
"86151263", "云南省红河哈尼族彝族自治州",
"861348577", "安徽省滁州市",
"86150256", "重庆市",
"861390342", "山西省大同市",
"861879742", "湖南省株洲市",
"861820334", "河北省衡水市",
"861881399", "广东省广州市",
"861500392", "河南省鹤壁市",
"861471482", "广东省广州市",
"861363967", "河南省南阳市",
"861896588", "福建省莆田市",
"861356238", "山东省日照市",
"861889869", "广东省广州市",
"861329787", "广西钦州市",
"861877012", "江西省鹰潭市",
"86137132", "广东省东莞市",
"861813725", "河南省漯河市",
"86186859", "贵州省黔西南布依族苗族自治州",
"861800455", "黑龙江省绥化市",
"861893531", "山西省阳泉市",
"861588906", "西藏那曲地区",
"861580335", "河北省秦皇岛市",
"86131248", "上海市",
"86187721", "湖北省恩施土家族苗族自治州",
"861520970", "青海省海北藏族自治州",
"861836143", "江苏省泰州市",
"86134086", "四川省成都市",
"861372390", "山东省菏泽市",
"861812488", "广东省阳江市",
"861891284", "江苏省镇江市",
"861351534", "山东省德州市",
"861454542", "新疆昌吉回族自治州",
"86156910", "陕西省咸阳市",
"86151587", "浙江省温州市",
"861705562", "天津市",
"861326350", "黑龙江省哈尔滨市",
"861840868", "宁夏固原市",
"861533511", "江苏省徐州市",
"86139658", "安徽省淮北市",
"86185623", "山东省泰安市",
"861879401", "甘肃省甘南藏族自治州",
"861316990", "广东省深圳市",
"861368598", "福建省龙岩市",
"861580783", "广西桂林市",
"86177794", "江西省抚州市",
"861310001", "山西省太原市",
"861339992", "新疆伊犁哈萨克自治州",
"861304365", "江苏省无锡市",
"861815430", "湖北省武汉市",
"86170903", "北京市",
"861771330", "黑龙江省双鸭山市",
"861858938", "云南省曲靖市",
"861354323", "广东省梅州市",
"861363814", "贵州省铜仁地区",
"861394833", "内蒙古乌海市",
"86186946", "安徽省阜阳市",
"86132864", "广东省汕头市",
"861479722", "山西省太原市",
"861831678", "广东省湛江市",
"861379636", "黑龙江省佳木斯市",
"861813643", "江苏省苏州市",
"861381901", "浙江省衢州市",
"861321427", "辽宁省盘锦市",
"861334662", "河南省商丘市",
"861524044", "江苏省苏州市",
"861590679", "浙江省金华市",
"861399599", "湖北省黄石市",
"861458210", "安徽省铜陵市",
"86155458", "黑龙江省鹤岗市",
"86177666", "陕西省西安市",
"861580841", "四川省南充市",
"861529681", "广西桂林市",
"861471803", "广东省梅州市",
"861815273", "湖南省怀化市",
"86133006", "上海市",
"861580526", "江苏省泰州市",
"861884045", "陕西省西安市",
"861554443", "河南省商丘市",
"861774989", "河北省保定市",
"861812342", "四川省广元市",
"861591189", "云南省临沧市",
"861337259", "浙江省舟山市",
"861330262", "广东省惠州市",
"861760536", "山东省潍坊市",
"861329431", "吉林省长春市",
"861830618", "江苏省无锡市",
"861876942", "山东省烟台市",
"861509549", "甘肃省定西市",
"861890543", "山东省滨州市",
"861517778", "广西南宁市",
"861521473", "浙江省金华市",
"861580875", "云南省昆明市",
"861321952", "四川省宜宾市",
"861836109", "江苏省盐城市",
"861860821", "四川省泸州市",
"861778038", "四川省德阳市",
"861323994", "新疆昌吉回族自治州",
"86178283", "四川省成都市",
"861315167", "江苏省镇江市",
"861898929", "四川省绵阳市",
"86177860", "湖北省武汉市",
"861319862", "四川省眉山市",
"861341843", "广东省佛山市",
"861311392", "广东省中山市",
"861535256", "新疆阿克苏地区",
"861589766", "湖北省孝感市",
"861308742", "云南省迪庆藏族自治州",
"86136672", "湖北省武汉市",
"861821814", "广东省深圳市",
"861336860", "贵州省贵阳市",
"86185971", "青海省西宁市",
"861598792", "云南省昭通市",
"861336344", "山西省太原市",
"861587585", "广东省茂名市",
"86188391", "河南省焦作市",
"861358474", "江苏省南通市",
"861583373", "河北省邢台市",
"861871829", "广东省佛山市",
"861860546", "山东省东营市",
"861536469", "山西省朔州市",
"861470562", "安徽省铜陵市",
"861776932", "湖南省长沙市",
"861373456", "黑龙江省大庆市",
"861572498", "浙江省杭州市",
"86134741", "陕西省西安市",
"861594918", "江苏省淮安市",
"86138936", "甘肃省兰州市",
"861532926", "贵州省铜仁地区",
"861869928", "新疆石河子市",
"861358012", "广东省韶关市",
"86180771", "广西南宁市",
"861502284", "新疆克孜勒苏柯尔克孜自治州",
"861500744", "湖南省张家界市",
"861801166", "四川省乐山市",
"861452714", "湖北省黄石市",
"861521230", "安徽省黄山市",
"861570463", "黑龙江省牡丹江市",
"861313039", "辽宁省本溪市",
"86135821", "河北省石家庄市",
"861355821", "广西南宁市",
"861346610", "云南省曲靖市",
"861819496", "新疆和田地区",
"861308006", "吉林省白城市",
"861370096", "四川省绵阳市",
"861894572", "黑龙江省黑河市",
"86187793", "江西省上饶市",
"861814911", "陕西省西安市",
"861366446", "吉林省白城市",
"861840324", "河北省承德市",
"861355546", "黑龙江省鸡西市",
"861769930", "新疆喀什地区",
"861863427", "山西省晋城市",
"861538837", "四川省遂宁市",
"861771247", "江苏省苏州市",
"861454144", "吉林省四平市",
"861863207", "河北省邢台市",
"86181307", "安徽省阜阳市",
"861536424", "湖南省衡阳市",
"861390794", "江西省抚州市",
"861458127", "安徽省六安市",
"861501226", "云南省昭通市",
"861550472", "内蒙古包头市",
"861810700", "江西省南昌市",
"861871864", "广东省茂名市",
"861350953", "福建省南平市",
"861890509", "福建省南平市",
"861590380", "河南省商丘市",
"861822551", "安徽省合肥市",
"861313078", "辽宁省铁岭市",
"861808636", "湖北省荆州市",
"86185691", "湖南省常德市",
"861373051", "河北省唐山市",
"861818566", "贵州省遵义市",
"861331043", "贵州省安顺市",
"861531508", "山东省临沂市",
"861459661", "新疆喀什地区",
"86189156", "江苏省苏州市",
"861377938", "新疆阿勒泰地区",
"861779732", "青海省黄南藏族自治州",
"861870977", "青海省海西蒙古族藏族自治州",
"861554409", "河南省郑州市",
"86155519", "安徽省亳州市",
"861801086", "安徽省合肥市",
"861471849", "广东省肇庆市",
"861325090", "浙江省嘉兴市",
"861539035", "四川省宜宾市",
"861885033", "福建省厦门市",
"861871917", "广东省中山市",
"861478040", "四川省成都市",
"86136992", "北京市",
"861303519", "湖北省随州市",
"861599098", "山东省东营市",
"861551358", "山西省吕梁市",
"861537567", "安徽省亳州市",
"861512962", "陕西省西安市",
"861813609", "江苏省苏州市",
"861590957", "宁夏固原市",
"861872415", "江苏省盐城市",
"861459416", "云南省迪庆藏族自治州",
"861317285", "广东省汕尾市",
"861308221", "辽宁省朝阳市",
"86130581", "广东省深圳市",
"861881898", "广东省云浮市",
"861847418", "湖南省娄底市",
"861821967", "甘肃省酒泉市",
"861889368", "甘肃省张掖市",
"861805170", "江苏省盐城市",
"861589137", "陕西省商洛市",
"861370491", "辽宁省朝阳市",
"861308401", "安徽省宿州市",
"861359718", "广西柳州市",
"861778079", "四川省宜宾市",
"861769127", "陕西省宝鸡市",
"861860685", "浙江省嘉兴市",
"861338323", "河北省石家庄市",
"861339541", "山东省济南市",
"861802069", "福建省漳州市",
"861830902", "新疆哈密地区",
"861320696", "黑龙江省鸡西市",
"861361499", "辽宁省辽阳市",
"861339826", "四川省泸州市",
"86134838", "河北省沧州市",
"861569360", "甘肃省张掖市",
"86147451", "黑龙江省哈尔滨市",
"861454654", "云南省文山壮族苗族自治州",
"861315087", "内蒙古鄂尔多斯市",
"861569844", "山西省运城市",
"86151533", "山东省淄博市",
"861550664", "山东省烟台市",
"861309292", "陕西省宝鸡市",
"861308143", "山东省潍坊市",
"861333539", "陕西省西安市",
"861830777", "广西钦州市",
"861508964", "广东省茂名市",
"861337738", "广西河池市",
"86184560", "安徽省阜阳市",
"861348492", "陕西省西安市",
"861555148", "安徽省宿州市",
"861700158", "江苏省南京市",
"861320732", "湖南省湘潭市",
"861816928", "湖南省衡阳市",
"861890744", "湖南省张家界市",
"861379344", "山东省日照市",
"86159771", "广西南宁市",
"861811488", "江苏省无锡市",
"861352534", "河南省驻马店市",
"86156425", "辽宁省大连市",
"86151816", "四川省绵阳市",
"861526635", "山东省聊城市",
"861509015", "河南省洛阳市",
"861365936", "甘肃省酒泉市",
"861470421", "辽宁省朝阳市",
"86159904", "浙江省丽水市",
"86183357", "山西省临汾市",
"86181840", "重庆市",
"861324708", "江西省南昌市",
"86156065", "浙江省台州市",
"861359959", "福建省漳州市",
"861326485", "湖北省孝感市",
"861504572", "黑龙江省双鸭山市",
"86181822", "重庆市",
"861886634", "山东省莱芜市",
"861303476", "内蒙古赤峰市",
"861862651", "吉林省吉林市",
"861873433", "山西省阳泉市",
"861319446", "福建省福州市",
"861768538", "贵州省黔南布依族苗族自治州",
"861321925", "四川省广安市",
"861459579", "陕西省咸阳市",
"861307959", "宁夏银川市",
"861580584", "浙江省宁波市",
"861366862", "山东省德州市",
"861559745", "青海省海东地区",
"86131972", "湖北省十堰市",
"861579424", "江苏省南京市",
"861527190", "湖北省武汉市",
"861707540", "福建省厦门市",
"861323403", "辽宁省沈阳市",
"861322427", "辽宁省盘锦市",
"861360596", "福建省三明市",
"861329139", "江苏省扬州市",
"86188184", "广东省肇庆市",
"861317853", "广东省佛山市",
"861518823", "河南省南阳市",
"86930", "甘肃省临夏回族自治州",
"861332009", "江西省萍乡市",
"861380140", "江苏省淮安市",
"861804918", "陕西省西安市",
"861820585", "浙江省绍兴市",
"861592619", "湖北省十堰市",
"861351733", "湖南省株洲市",
"861811342", "四川省乐山市",
"861557015", "江西省新余市",
"86182917", "陕西省宝鸡市",
"861453384", "内蒙古通辽市",
"861808792", "云南省德宏傣族景颇族自治州",
"861870702", "江西省九江市",
"861850936", "甘肃省张掖市",
"861773409", "河北省邢台市",
"861303071", "辽宁省抚顺市",
"861860900", "新疆乌鲁木齐市",
"861820646", "山东省潍坊市",
"861308653", "四川省阿坝藏族羌族自治州",
"861507623", "河北省唐山市",
"861857098", "湖南省怀化市",
"861889886", "广东省湛江市",
"861319041", "辽宁省锦州市",
"861847536", "广东省深圳市",
"861800957", "宁夏银川市",
"861470026", "安徽省宿州市",
"86130491", "广东省佛山市",
"861572583", "山东省泰安市",
"861533854", "贵州省黔东南苗族侗族自治州",
"861459538", "西藏拉萨市",
"861363465", "黑龙江省佳木斯市",
"861867114", "湖北省恩施土家族苗族自治州",
"861394945", "河南省平顶山市",
"86133267", "广东省佛山市",
"861335587", "浙江省温州市",
"861317711", "湖北省恩施土家族苗族自治州",
"861398161", "四川省雅安市",
"861351385", "河南省漯河市",
"861580908", "新疆克孜勒苏柯尔克孜自治州",
"861775701", "浙江省衢州市",
"861363551", "安徽省合肥市",
"861572960", "四川省南充市",
"861875150", "江苏省徐州市",
"86150156", "广东省佛山市",
"861594759", "内蒙古鄂尔多斯市",
"86151163", "湖南省长沙市",
"861517258", "湖北省襄樊市",
"861825040", "福建省泉州市",
"86743", "湖南省湘西土家族苗族自治州",
"861800380", "河南省新乡市",
"861591737", "广东省广州市",
"861773264", "河北省廊坊市",
"861333578", "浙江省绍兴市",
"861355900", "福建省宁德市",
"861475620", "河北省保定市",
"861873847", "河南省驻马店市",
"861508817", "广东省云浮市",
"861318408", "山东省菏泽市",
"861311543", "黑龙江省大庆市",
"86182470", "内蒙古呼伦贝尔市",
"861572726", "湖北省恩施土家族苗族自治州",
"861522910", "陕西省咸阳市",
"861376826", "广西百色市",
"861380650", "浙江省杭州市",
"861571784", "湖北省荆州市",
"86151808", "贵州省贵阳市",
"861517067", "江西省吉安市",
"86131148", "天津市",
"861318337", "河南省信阳市",
"86183773", "广西桂林市",
"86137232", "河南省开封市",
"861815125", "江苏省连云港市",
"861381349", "江苏省徐州市",
"86189256", "广东省揭阳市",
"86176651", "广东省广州市",
"861341935", "四川省雅安市",
"86155379", "河南省洛阳市",
"861306522", "辽宁省铁岭市",
"861557704", "广西来宾市",
"861325741", "湖南省株洲市",
"861568633", "陕西省渭南市",
"861590561", "安徽省淮北市",
"861869506", "湖北省宜昌市",
"861332043", "云南省迪庆藏族自治州",
"861816317", "湖北省孝感市",
"861513661", "河南省商丘市",
"861705026", "湖南省长沙市",
"861503531", "山西省阳泉市",
"861550597", "福建省龙岩市",
"861825028", "福建省泉州市",
"861318240", "江苏省无锡市",
"861328698", "广东省湛江市",
"861535776", "安徽省芜湖市",
"861812593", "广东省湛江市",
"861506588", "山东省淄博市",
"861554101", "辽宁省铁岭市",
"861475648", "河北省衡水市",
"861821465", "云南省保山市",
"861556971", "甘肃省庆阳市",
"861890392", "河南省鹤壁市",
"861880863", "湖北省武汉市",
"861590455", "黑龙江省绥化市",
"861894497", "湖南省永州市",
"861368483", "江西省上饶市",
"861523840", "河南省三门峡市",
"861376575", "贵州省黔南布依族苗族自治州",
"861872917", "陕西省宝鸡市",
"861529852", "江苏省泰州市",
"861502001", "山东省济南市",
"861810568", "安徽省阜阳市",
"861454393", "贵州省安顺市",
"861800638", "山东省滨州市",
"861761439", "吉林省白山市",
"861339884", "云南省昆明市",
"861879143", "陕西省渭南市",
"861772870", "广东省清远市",
"861800422", "辽宁省鞍山市",
"861303045", "内蒙古锡林郭勒盟",
"861819740", "青海省海南藏族自治州",
"861555937", "新疆巴音郭楞蒙古自治州",
"86187809", "四川省广元市",
"861811794", "四川省德阳市",
"861803770", "河南省南阳市",
"861867512", "广东省韶关市",
"86158026", "湖南省长沙市",
"861760352", "山西省晋中市",
"861586989", "湖南省邵阳市",
"861477085", "江西省宜春市",
"861537951", "宁夏银川市",
"861870475", "内蒙古通辽市",
"861366790", "江西省新余市",
"861325883", "吉林省延边朝鲜族自治州",
"861593095", "河北省唐山市",
"861475287", "江苏省扬州市",
"861537694", "山东省菏泽市",
"861509704", "甘肃省金昌市",
"861859454", "福建省莆田市",
"861817010", "江西省赣州市",
"861569581", "浙江省台州市",
"86139301", "河北省石家庄市",
"861394971", "河南省濮阳市",
"861770431", "吉林省长春市",
"861347754", "湖北省荆门市",
"861804238", "浙江省台州市",
"861362499", "辽宁省辽阳市",
"861513416", "辽宁省锦州市",
"86188012", "北京市",
"861523329", "河北省衡水市",
"861802481", "广东省中山市",
"86130423", "重庆市",
"861833387", "河北省唐山市",
"861705201", "安徽省合肥市",
"861522473", "河南省信阳市",
"861304032", "吉林省白山市",
"861559771", "贵州省贵阳市",
"861318877", "山东省烟台市",
"86147986", "重庆市",
"861898780", "云南省楚雄彝族自治州",
"861761478", "内蒙古巴彦淖尔市",
"861800679", "浙江省金华市",
"861313767", "河南省周口市",
"86150048", "内蒙古兴安盟",
"861390593", "福建省宁德市",
"861533079", "吉林省白城市",
"861872829", "四川省资阳市",
"861313693", "黑龙江省黑河市",
"861806323", "山东省济宁市",
"861311509", "江苏省无锡市",
"86158679", "浙江省金华市",
"861571498", "新疆伊犁哈萨克自治州",
"861500543", "山东省滨州市",
"86138289", "广东省汕尾市",
"861801619", "四川省宜宾市",
"861300008", "湖北省武汉市",
"861580612", "江苏省常州市",
"861760418", "辽宁省阜新市",
"861525647", "安徽省阜阳市",
"861899549", "宁夏中卫市",
"861836221", "江苏省苏州市",
"86131056", "浙江省台州市",
"86130063", "湖北省武汉市",
"861775889", "黑龙江省伊春市",
"861452513", "山东省烟台市",
"861894856", "广东省惠州市",
"861361944", "云南省曲靖市",
"861350351", "山西省太原市",
"861802166", "江苏省南通市",
"861778176", "四川省甘孜藏族自治州",
"861839942", "新疆伊犁哈萨克自治州",
"861369990", "新疆吐鲁番地区",
"861840386", "黑龙江省绥化市",
"861833950", "河南省新乡市",
"86177358", "山西省吕梁市",
"86132502", "广东省广州市",
"861814313", "吉林省延边朝鲜族自治州",
"86151497", "内蒙古鄂尔多斯市",
"86182869", "贵州省黔西南布依族苗族自治州",
"86151610", "江苏省泰州市",
"861536486", "山西省晋城市",
"861770787", "广西钦州市",
"861708874", "广东省江门市",
"861532984", "贵州省黔南布依族苗族自治州",
"861859530", "河南省驻马店市",
"861589789", "湖北省黄冈市",
"861457090", "江苏省淮安市",
"861367313", "河北省石家庄市",
"861330501", "福建省福州市",
"861525288", "江苏省宿迁市",
"861773443", "河北省唐山市",
"861816940", "湖南省岳阳市",
"861868548", "贵州省六盘水市",
"861847504", "广东省云浮市",
"861303057", "江西省抚州市",
"861770396", "河南省驻马店市",
"861708306", "河北省石家庄市",
"861700935", "江苏省徐州市",
"86184359", "山西省运城市",
"86153021", "天津市",
"861806597", "福建省龙岩市",
"86134605", "河南省许昌市",
"861802313", "广东省河源市",
"861527018", "江西省九江市",
"861800971", "青海省西宁市",
"861780992", "新疆伊犁哈萨克自治州",
"861868256", "四川省成都市",
"861840663", "广东省佛山市",
"861850588", "浙江省宁波市",
"861390238", "广东省广州市",
"861897277", "湖北省黄石市",
"86188348", "山西省太原市",
"861771775", "河北省唐山市",
"861338472", "内蒙古包头市",
"861538953", "陕西省商洛市",
"861313502", "湖南省湘潭市",
"861520560", "安徽省合肥市",
"861770715", "湖北省咸宁市",
"861840797", "江西省赣州市",
"861560376", "河南省信阳市",
"861303891", "陕西省安康市",
"86182138", "云南省昆明市",
"86153461", "河南省焦作市",
"86153127", "江苏省宿迁市",
"861858569", "贵州省黔南布依族苗族自治州",
"861363577", "湖北省恩施土家族苗族自治州",
"861860739", "湖南省邵阳市",
"861803182", "河北省石家庄市",
"861514226", "辽宁省朝阳市",
"861816733", "浙江省绍兴市",
"861334695", "河南省郑州市",
"861879727", "青海省海西蒙古族藏族自治州",
"861390327", "河北省沧州市",
"861787621", "广东省茂名市",
"861531414", "山东省日照市",
"861351928", "宁夏银川市",
"861471608", "广东省中山市",
"861570510", "江苏省盐城市",
"86185577", "浙江省台州市",
"861365588", "浙江省宁波市",
"861598604", "广东省河源市",
"86156935", "甘肃省武威市",
"861339965", "安徽省巢湖市",
"861809878", "安徽省六安市",
"861304392", "河南省鹤壁市",
"861831873", "广东省中山市",
"861378407", "河北省张家口市",
"861300497", "福建省龙岩市",
"861813848", "广东省佛山市",
"861885144", "江苏省扬州市",
"861321701", "江西省鹰潭市",
"86147811", "四川省乐山市",
"861537149", "江苏省苏州市",
"861556638", "辽宁省铁岭市",
"861355739", "广西南宁市",
"861582887", "四川省遂宁市",
"861865837", "浙江省温州市",
"861530474", "内蒙古乌兰察布市",
"861362530", "山东省菏泽市",
"86147868", "湖南省湘西土家族苗族自治州",
"861525145", "江苏省徐州市",
"861854547", "黑龙江省大兴安岭地区",
"861845899", "浙江省绍兴市",
"861370644", "山东省济南市",
"86155600", "河南省商丘市",
"861760703", "江西省上饶市",
"861830751", "广东省韶关市",
"861383342", "河北省承德市",
"86134269", "广东省肇庆市",
"861807499", "广西梧州市",
"861590833", "四川省广安市",
"861709482", "浙江省宁波市",
"861373946", "四川省成都市",
"861577188", "陕西省商洛市",
"86153275", "湖北省荆门市",
"86187833", "四川省眉山市",
"861871487", "安徽省马鞍山市",
"861880531", "山东省济南市",
"861593335", "河北省秦皇岛市",
"86130987", "重庆市",
"861891434", "江苏省常州市",
"861479747", "山西省运城市",
"861528042", "福建省福州市",
"861365904", "四川省泸州市",
"861508773", "云南省玉溪市",
"861809680", "新疆巴音郭楞蒙古自治州",
"861780575", "浙江省绍兴市",
"861862677", "吉林省白城市",
"861378379", "河南省洛阳市",
"861556679", "辽宁省朝阳市",
"861355778", "广西河池市",
"86186558", "安徽省阜阳市",
"861599905", "新疆博尔塔拉蒙古自治州",
"861332356", "宁夏石嘴山市",
"861533398", "河南省三门峡市",
"861321388", "河南省信阳市",
"861814737", "内蒙古包头市",
"861857110", "湖北省鄂州市",
"861390279", "广东省潮州市",
"861825297", "江苏省镇江市",
"86135787", "吉林省长春市",
"861583422", "山西省吕梁市",
"86189463", "黑龙江省牡丹江市",
"86158300", "河北省邯郸市",
"861300856", "陕西省咸阳市",
"861580770", "广西防城港市",
"861454527", "广西钦州市",
"861709348", "广东省中山市",
"861775925", "福建省福州市",
"861860778", "广西河池市",
"861384841", "内蒙古呼和浩特市",
"861850904", "新疆和田地区",
"861537659", "山东省烟台市",
"861383488", "山西省临汾市",
"861458544", "河南省驻马店市",
"861782049", "广东省中山市",
"861827095", "江西省宜春市",
"861370154", "江苏省苏州市",
"861872985", "陕西省安康市",
"86150312", "河北省保定市",
"861847988", "江西省景德镇市",
"861347799", "湖北省十堰市",
"861592231", "安徽省芜湖市",
"861362454", "黑龙江省佳木斯市",
"861391219", "江苏省泰州市",
"861336765", "广西贵港市",
"861869450", "浙江省嘉兴市",
"861771402", "江苏省常州市",
"861898574", "贵州省安顺市",
"861863442", "山西省晋中市",
"861815302", "河南省鹤壁市",
"861370552", "安徽省蚌埠市",
"861390918", "陕西省西安市",
"861356794", "浙江省宁波市",
"86177745", "湖南省怀化市",
"861552894", "四川省巴中市",
"861596472", "山东省济宁市",
"861809407", "福建省泉州市",
"861834524", "黑龙江省鹤岗市",
"861458142", "浙江省台州市",
"861335656", "广东省江门市",
"861377569", "江苏省泰州市",
"861537103", "江苏省南京市",
"861838547", "贵州省黔南布依族苗族自治州",
"861318851", "辽宁省葫芦岛市",
"861559757", "青海省海南藏族自治州",
"861378878", "广西柳州市",
"861452998", "内蒙古鄂尔多斯市",
"86134539", "山西省运城市",
"861509167", "陕西省西安市",
"861815627", "安徽省阜阳市",
"861817198", "湖北省荆门市",
"86188580", "浙江省宁波市",
"861318097", "吉林省四平市",
"861517546", "河北省邢台市",
"861511497", "陕西省宝鸡市",
"86189572", "浙江省湖州市",
"861882039", "广东省惠州市",
"861565089", "安徽省宿州市",
"86132636", "黑龙江省哈尔滨市",
"861384875", "内蒙古通辽市",
"861801231", "江苏省扬州市",
"861894962", "安徽省马鞍山市",
"861787773", "湖南省怀化市",
"861524133", "辽宁省抚顺市",
"861505862", "浙江省台州市",
"861338705", "江西省宜春市",
"861871600", "河北省秦皇岛市",
"861350377", "河南省南阳市",
"861897828", "广西河池市",
"861895446", "山东省聊城市",
"861512995", "陕西省西安市",
"86131291", "广东省佛山市",
"861709849", "浙江省温州市",
"861450963", "新疆博尔塔拉蒙古自治州",
"861780826", "四川省广安市",
"861583380", "河北省邯郸市",
"86137631", "广东省东莞市",
"861876452", "山东省菏泽市",
"861358695", "浙江省金华市",
"861839425", "甘肃省定西市",
"861476138", "江苏省苏州市",
"861780541", "山东省济南市",
"861888666", "四川省广元市",
"861470972", "青海省海东地区",
"861567700", "广西南宁市",
"861321889", "江苏省南京市",
"861450580", "辽宁省阜新市",
"86153559", "浙江省温州市",
"861576716", "广东省云浮市",
"861597191", "湖北省十堰市",
"861351317", "河北省沧州市",
"861308727", "湖南省益阳市",
"861327519", "江苏省常州市",
"861857407", "河南省新乡市",
"861882354", "广东省揭阳市",
"861304744", "山东省东营市",
"861521480", "新疆乌鲁木齐市",
"861555285", "山东省济南市",
"861354629", "山西省吕梁市",
"861331532", "河北省张家口市",
"86182371", "河南省郑州市",
"861782003", "广东省湛江市",
"861565124", "江苏省宿迁市",
"861857379", "湖南省株洲市",
"861335146", "黑龙江省黑河市",
"86136338", "河南省郑州市",
"861458652", "湖北省荆州市",
"861870353", "山西省阳泉市",
"861399753", "湖北省咸宁市",
"861827250", "河南省鹤壁市",
"861359994", "福建省泉州市",
"86132455", "浙江省宁波市",
"861351940", "甘肃省兰州市",
"861350409", "辽宁省大连市",
"86138770", "广西防城港市",
"861457118", "湖北省荆门市",
"861556957", "新疆喀什地区",
"86139782", "广西柳州市",
"86159885", "浙江省金华市",
"861812918", "新疆克孜勒苏柯尔克孜自治州",
"861473061", "河北省唐山市",
"86135733", "山东省淄博市",
"86135146", "黑龙江省齐齐哈尔市",
"861557087", "湖南省长沙市",
"861771883", "广东省揭阳市",
"86155806", "湖南省怀化市",
"861378839", "广西钦州市",
"861800945", "甘肃省金昌市",
"861387246", "湖北省宜昌市",
"861870567", "安徽省亳州市",
"861346907", "湖南省长沙市",
"861508621", "贵州省黔东南苗族侗族自治州",
"861354664", "山西省晋中市",
"86189197", "安徽省六安市",
"861598765", "云南省文山壮族苗族自治州",
"861524696", "黑龙江省黑河市",
"861509087", "湖北省宜昌市",
"861893190", "河北省秦皇岛市",
"861592911", "陕西省延安市",
"86151981", "四川省成都市",
"861776140", "四川省成都市",
"86187376", "河南省信阳市",
"861783533", "山西省临汾市",
"861882078", "广东省广州市",
"86187887", "贵州省黔西南布依族苗族自治州",
"861318713", "湖南省永州市",
"86186419", "辽宁省辽阳市",
"861813349", "安徽省六安市",
"861394957", "河南省驻马店市",
"861865409", "安徽省宿州市",
"861590373", "河南省新乡市",
"861760749", "湖南省永州市",
"861595782", "浙江省丽水市",
"861350264", "广东省河源市",
"86431", "吉林省长春市",
"861775207", "甘肃省庆阳市",
"861769625", "山西省运城市",
"86170747", "内蒙古呼和浩特市",
"861368913", "陕西省渭南市",
"861310550", "浙江省嘉兴市",
"861814069", "湖北省武汉市",
"861872487", "云南省普洱市",
"861896936", "浙江省金华市",
"861308858", "内蒙古乌兰察布市",
"861595063", "江苏省宿迁市",
"861507828", "广西柳州市",
"861589635", "江苏省镇江市",
"861860617", "江苏省徐州市",
"861520708", "江西省景德镇市",
"861700843", "四川省成都市",
"86136465", "浙江省温州市",
"861351506", "福建省宁德市",
"86134169", "广东省东莞市",
"861771255", "江苏省泰州市",
"86185292", "广东省广州市",
"861807191", "湖北省宜昌市",
"861353178", "广东省中山市",
"861331356", "山西省晋城市",
"861346772", "湖南省株洲市",
"861515292", "江苏省镇江市",
"86136025", "广东省深圳市",
"861301512", "内蒙古呼伦贝尔市",
"861315015", "甘肃省武威市",
"861813901", "新疆昌吉回族自治州",
"861892434", "广东省东莞市",
"861370525", "江苏省扬州市",
"861811238", "江苏省无锡市",
"86181765", "广西玉林市",
"861858645", "贵州省铜仁地区",
"861550921", "陕西省榆林市",
"86151509", "江苏省连云港市",
"861360052", "浙江省杭州市",
"861322442", "吉林省吉林市",
"861305326", "安徽省芜湖市",
"861814024", "四川省成都市",
"86184534", "山东省德州市",
"861599407", "河南省许昌市",
"861816450", "浙江省衢州市",
"861773953", "河南省驻马店市",
"861806472", "浙江省嘉兴市",
"861839452", "甘肃省兰州市",
"861363492", "辽宁省朝阳市",
"86150572", "浙江省台州市",
"861760504", "福建省龙岩市",
"861593908", "河南省商丘市",
"861856744", "河南省信阳市",
"861539395", "云南省大理白族自治州",
"861700781", "广东省汕头市",
"861586419", "山东省德州市",
"861361454", "黑龙江省佳木斯市",
"861454699", "广东省湛江市",
"86183396", "河南省驻马店市",
"86188490", "河北省邯郸市",
"86188617", "江苏省无锡市",
"861338597", "福建省龙岩市",
"861537046", "江苏省南通市",
"86157388", "河南省郑州市",
"861323959", "宁夏银川市",
"861470707", "江西省赣州市",
"861333968", "贵州省六盘水市",
"861310434", "吉林省四平市",
"861831211", "广东省阳江市",
"861511174", "青海省海南藏族自治州",
"861772775", "广东省广州市",
"861839318", "甘肃省天水市",
"861806629", "浙江省温州市",
"861313399", "江西省萍乡市",
"86136414", "广东省深圳市",
"86150197", "广东省汕头市",
"861337321", "河北省石家庄市",
"861517900", "江西省上饶市",
"861858723", "云南省红河哈尼族彝族自治州",
"861538351", "山西省太原市",
"861300995", "黑龙江省鸡西市",
"861899736", "青海省玉树藏族自治州",
"861370336", "河北省保定市",
"86153227", "广东省河源市",
"861458625", "湖北省黄冈市",
"861887296", "湖北省荆州市",
"861339467", "黑龙江省鸡西市",
"861355067", "四川省资阳市",
"861800373", "河南省新乡市",
"861345348", "山西省临汾市",
"86156681", "山东省济宁市",
"861380932", "甘肃省定西市",
"861399152", "陕西省安康市",
"86181714", "湖北省武汉市",
"861768969", "福建省泉州市",
"861562795", "广东省潮州市",
"861393140", "河北省承德市",
"86131123", "广东省珠海市",
"861317658", "山东省淄博市",
"861377671", "江苏省淮安市",
"861859944", "新疆乌鲁木齐市",
"861367619", "广东省江门市",
"861700308", "广东省惠州市",
"861537441", "甘肃省白银市",
"861348551", "安徽省合肥市",
"861860258", "江苏省常州市",
"861587517", "广东省阳江市",
"861361530", "山东省菏泽市",
"86902", "新疆哈密地区",
"861572570", "山东省菏泽市",
"861318112", "山东省威海市",
"861814619", "福建省南平市",
"861332134", "甘肃省临夏回族自治州",
"861348465", "陕西省延安市",
"861327476", "内蒙古赤峰市",
"861768924", "福建省漳州市",
"861526801", "浙江省舟山市",
"861318682", "浙江省温州市",
"861335003", "四川省广元市",
"861599878", "山东省德州市",
"86182568", "安徽省阜阳市",
"86152699", "山东省临沂市",
"861373077", "四川省内江市",
"861317937", "江苏省泰州市",
"861535520", "浙江省嘉兴市",
"861377645", "江苏省宿迁市",
"861332532", "陕西省榆林市",
"861345849", "四川省德阳市",
"861870694", "甘肃省天水市",
"86151635", "山东省聊城市",
"86182511", "江苏省苏州市",
"861810978", "青海省西宁市",
"861870951", "宁夏银川市",
"861537475", "内蒙古通辽市",
"861803783", "河南省驻马店市",
"861313261", "广西南宁市",
"861373500", "浙江省舟山市",
"861844999", "新疆石河子市",
"861874294", "新疆乌鲁木齐市",
"861394561", "黑龙江省大庆市",
"861346405", "辽宁省朝阳市",
"861804342", "吉林省吉林市",
"861705707", "湖南省衡阳市",
"861512856", "河北省承德市",
"861864937", "山西省临汾市",
"861368470", "内蒙古呼伦贝尔市",
"861510512", "江苏省连云港市",
"861590971", "青海省西宁市",
"861561070", "山东省泰安市",
"86157540", "辽宁省大连市",
"861340747", "湖南省株洲市",
"861342287", "广东省深圳市",
"861568879", "山东省滨州市",
"861477192", "湖北省荆州市",
"861529989", "新疆吐鲁番地区",
"861567568", "湖南省郴州市",
"861865101", "江苏省无锡市",
"86189297", "广东省茂名市",
"861887560", "河北省秦皇岛市",
"861376965", "云南省曲靖市",
"86134354", "广东省佛山市",
"861700809", "江苏省盐城市",
"86133320", "天津市",
"861337294", "辽宁省辽阳市",
"861869733", "河南省郑州市",
"86138426", "辽宁省大连市",
"861556561", "河南省焦作市",
"861561507", "山东省聊城市",
"861333002", "江西省九江市",
"861779044", "四川省巴中市",
"86187516", "江苏省徐州市",
"861312365", "贵州省黔东南苗族侗族自治州",
"861857905", "江西省南昌市",
"86151456", "黑龙江省七台河市",
"861329396", "山西省临汾市",
"861884891", "河南省平顶山市",
"86150463", "黑龙江省牡丹江市",
"861335049", "四川省广元市",
"861323677", "辽宁省盘锦市",
"861772222", "广东省深圳市",
"861375168", "广东省揭阳市",
"86187508", "福建省三明市",
"861568838", "新疆伊犁哈萨克自治州",
"861327045", "江苏省南京市",
"861772402", "广东省广州市",
"861831931", "广东省梅州市",
"861560660", "浙江省宁波市",
"861820094", "广东省佛山市",
"861304543", "黑龙江省佳木斯市",
"861564260", "辽宁省鞍山市",
"861839927", "新疆伊犁哈萨克自治州",
"86189312", "河北省保定市",
"86137985", "广东省深圳市",
"861325247", "浙江省台州市",
"861872600", "安徽省马鞍山市",
"861880668", "广东省茂名市",
"861850493", "内蒙古阿拉善盟",
"86150023", "重庆市",
"861385941", "福建省三明市",
"861328893", "河北省保定市",
"861834586", "黑龙江省伊春市",
"86138001", "北京市",
"861308359", "江苏省镇江市",
"861869385", "甘肃省武威市",
"861472912", "陕西省榆林市",
"861882693", "广东省珠海市",
"861810939", "甘肃省陇南市",
"861322630", "广东省惠州市",
"861398916", "四川省达州市",
"861534501", "福建省三明市",
"861890365", "黑龙江省哈尔滨市",
"861583561", "山西省晋城市",
"861769709", "青海省海西蒙古族藏族自治州",
"861828215", "四川省攀枝花市",
"861559329", "甘肃省酒泉市",
"86895", "西藏昌都地区",
"861565066", "安徽省安庆市",
"86131191", "陕西省西安市",
"86184478", "内蒙古呼和浩特市",
"861597499", "云南省玉溪市",
"861475781", "浙江省台州市",
"861852468", "辽宁省阜新市",
"861787574", "广东省深圳市",
"861352317", "河南省商丘市",
"861883392", "河北省石家庄市",
"861599680", "江苏省镇江市",
"861898773", "云南省玉溪市",
"861527531", "山东省济南市",
"861881354", "广东省茂名市",
"861302626", "江西省宜春市",
"861809905", "新疆和田地区",
"861365493", "辽宁省大连市",
"86131097", "青海省西宁市",
"861522480", "河南省平顶山市",
"861501434", "广东省江门市",
"861308034", "山西省运城市",
"861599110", "陕西省延安市",
"861873996", "河南省开封市",
"861803335", "广东省河源市",
"861848925", "西藏昌都地区",
"861300174", "山东省济南市",
"861507840", "广西玉林市",
"861472791", "陕西省延安市",
"86186315", "河北省唐山市",
"861393997", "河南省安阳市",
"86133919", "北京市",
"861454389", "贵州省黔西南布依族苗族自治州",
"86189856", "贵州省遵义市",
"861811566", "江苏省苏州市",
"861366321", "河北省石家庄市",
"861844970", "新疆巴音郭楞蒙古自治州",
"861573451", "黑龙江省哈尔滨市",
"861824949", "黑龙江省鸡西市",
"86145845", "山东省青岛市",
"861338043", "广东省云浮市",
"861586993", "湖南省怀化市",
"861769513", "宁夏吴忠市",
"861808737", "云南省昆明市",
"861539685", "江苏省盐城市",
"861890877", "云南省玉溪市",
"861569902", "新疆哈密地区",
"86153158", "山东省德州市",
"861558358", "四川省乐山市",
"861325899", "山东省聊城市",
"861479094", "安徽省六安市",
"861322698", "广东省佛山市",
"861370613", "江苏省苏州市",
"861575759", "浙江省绍兴市",
"861399498", "山西省运城市",
"861346869", "陕西省汉中市",
"861573565", "山西省太原市",
"861337895", "湖南省怀化市",
"861705634", "内蒙古呼和浩特市",
"861362483", "内蒙古包头市",
"861339435", "吉林省通化市",
"861351662", "广东省佛山市",
"861478849", "河南省新乡市",
"861773926", "河南省鹤壁市",
"861326374", "广西梧州市",
"861335251", "黑龙江省哈尔滨市",
"861830844", "四川省德阳市",
"861566441", "山东省德州市",
"861331323", "河北省保定市",
"861535718", "安徽省六安市",
"861570091", "新疆博尔塔拉蒙古自治州",
"861893471", "广西南宁市",
"861309328", "湖北省随州市",
"861826252", "江苏省南通市",
"861320663", "黑龙江省齐齐哈尔市",
"861301401", "安徽省宿州市",
"861315637", "山东省青岛市",
"861888261", "四川省内江市",
"86187209", "江西省南昌市",
"86187614", "江苏省徐州市",
"861587747", "陕西省汉中市",
"861564831", "内蒙古阿拉善盟",
"86182605", "江苏省南通市",
"86139573", "浙江省嘉兴市",
"861365278", "广东省惠州市",
"861802344", "广东省中山市",
"861773760", "河南省郑州市",
"861327504", "福建省厦门市",
"861700465", "北京市",
"861309237", "江苏省连云港市",
"861588121", "四川省雅安市",
"861332921", "安徽省淮北市",
"8614766", "上海市",
"86134138", "广东省肇庆市",
"861320797", "江西省赣州市",
"861768131", "安徽省芜湖市",
"861453475", "黑龙江省鸡西市",
"861570857", "贵州省毕节地区",
"861334534", "新疆喀什地区",
"861478320", "河南省漯河市",
"861324263", "河北省唐山市",
"861346824", "山东省莱芜市",
"861350414", "辽宁省本溪市",
"861817425", "湖南省怀化市",
"861777652", "广西桂林市",
"86159667", "山东省枣庄市",
"861301742", "贵州省黔东南苗族侗族自治州",
"861348843", "陕西省渭南市",
"861891929", "甘肃省甘南藏族自治州",
"861318392", "四川省自贡市",
"86186364", "山西省吕梁市",
"861890240", "广东省广州市",
"861333171", "吉林省吉林市",
"861328952", "宁夏石嘴山市",
"861321073", "山东省潍坊市",
"861770669", "浙江省宁波市",
"861785800", "浙江省金华市",
"861372098", "山西省运城市",
"861815007", "福建省厦门市",
"86184830", "四川省泸州市",
"861369569", "安徽省合肥市",
"861878829", "云南省昆明市",
"861778118", "四川省内江市",
"861347095", "安徽省马鞍山市",
"861336069", "广东省韶关市",
"861591792", "广东省汕头市",
"861597233", "湖北省孝感市",
"861351474", "内蒙古乌兰察布市",
"861589793", "湖北省黄冈市",
"86180932", "甘肃省定西市",
"861330982", "辽宁省沈阳市",
"861877450", "湖南省邵阳市",
"861458513", "河南省开封市",
"86135121", "上海市",
"861772176", "江苏省徐州市",
"86147612", "江苏省常州市",
"861329571", "浙江省杭州市",
"861808166", "四川省自贡市",
"861760476", "内蒙古赤峰市",
"861520954", "宁夏固原市",
"861582540", "浙江省温州市",
"86185732", "湖南省湘潭市",
"861459131", "广西玉林市",
"861390589", "浙江省金华市",
"86187665", "山东省烟台市",
"86189783", "广西桂林市",
"861336024", "广东省肇庆市",
"861880955", "宁夏中卫市",
"861508226", "四川省凉山彝族自治州",
"861534859", "贵州省黔西南布依族苗族自治州",
"861313689", "黑龙江省牡丹江市",
"861878864", "贵州省遵义市",
"861376217", "湖南省张家界市",
"861878340", "四川省凉山彝族自治州",
"861503310", "河北省邯郸市",
"861358132", "湖北省荆门市",
"861566046", "山东省泰安市",
"861839198", "陕西省咸阳市",
"861562196", "内蒙古赤峰市",
"861862548", "河南省驻马店市",
"86135027", "广东省汕头市",
"861301006", "北京市",
"861348781", "湖南省益阳市",
"861761416", "辽宁省锦州市",
"861502964", "陕西省宝鸡市",
"861374933", "河南省濮阳市",
"86170968", "山东省济南市",
"861361598", "福建省莆田市",
"861302143", "河北省廊坊市",
"861514621", "黑龙江省齐齐哈尔市",
"861357917", "新疆伊犁哈萨克自治州",
"86170911", "北京市",
"86151216", "贵州省铜仁地区",
"861329545", "山东省烟台市",
"861889180", "陕西省咸阳市",
"861582528", "云南省昆明市",
"861856112", "山东省烟台市",
"861886026", "河南省安阳市",
"86181240", "广东省深圳市",
"861304713", "湖北省武汉市",
"861847519", "广东省梅州市",
"861555992", "云南省保山市",
"861519659", "四川省内江市",
"861596043", "福建省泉州市",
"861829707", "青海省海西蒙古族藏族自治州",
"861521533", "山东省淄博市",
"86181222", "广东省广州市",
"861510401", "辽宁省沈阳市",
"861868651", "吉林省长春市",
"861550532", "山东省青岛市",
"861333145", "吉林省通化市",
"861328207", "浙江省衢州市",
"861563872", "河南省洛阳市",
"861534358", "山西省吕梁市",
"861454670", "广东省深圳市",
"861810486", "内蒙古呼和浩特市",
"861324444", "吉林省四平市",
"861875856", "浙江省杭州市",
"861303418", "甘肃省平凉市",
"861360729", "湖北省孝感市",
"861890337", "河北省唐山市",
"861501780", "广东省梅州市",
"861821158", "广东省揭阳市",
"86158362", "河南省周口市",
"861850827", "四川省巴中市",
"861388901", "西藏拉萨市",
"861328427", "辽宁省盘锦市",
"861832461", "黑龙江省哈尔滨市",
"861371721", "广东省肇庆市",
"861890408", "辽宁省大连市",
"861453702", "湖北省宜昌市",
"86184636", "山东省潍坊市",
"861530940", "甘肃省平凉市",
"861399784", "湖北省十堰市",
"861531409", "山东省泰安市",
"86153046", "黑龙江省哈尔滨市",
"86713", "湖北省黄冈市",
"861450270", "内蒙古呼伦贝尔市",
"86182539", "山东省临沂市",
"861554508", "黑龙江省伊春市",
"861805154", "江苏省苏州市",
"861821287", "贵州省六盘水市",
"861853026", "河南省商丘市",
"861302653", "山东省青岛市",
"861867727", "广西来宾市",
"861838639", "贵州省黔西南布依族苗族自治州",
"861334132", "湖南省湘潭市",
"861470634", "山东省莱芜市",
"861317965", "江苏省无锡市",
"861506061", "福建省泉州市",
"86139022", "广东省广州市",
"86139040", "辽宁省沈阳市",
"861478348", "河南省南阳市",
"861820850", "贵州省贵阳市",
"861881981", "广东省广州市",
"861315958", "吉林省松原市",
"861893445", "贵州省黔南布依族苗族自治州",
"861375971", "陕西省咸阳市",
"861365919", "陕西省西安市",
"861346368", "河北省保定市",
"861390022", "广东省肇庆市",
"861318744", "云南省昆明市",
"861303352", "江苏省连云港市",
"861453441", "辽宁省沈阳市",
"861309340", "安徽省合肥市",
"86133867", "辽宁省鞍山市",
"86189737", "湖南省益阳市",
"861454888", "四川省绵阳市",
"861313370", "江西省抚州市",
"861314727", "湖北省襄樊市",
"861868141", "广东省佛山市",
"861530317", "河北省沧州市",
"861519149", "陕西省铜川市",
"86139462", "黑龙江省齐齐哈尔市",
"861838880", "云南省丽江市",
"861304851", "贵州省遵义市",
"861850919", "陕西省铜川市",
"861380521", "江苏省徐州市",
"86189650", "福建省福州市",
"861333655", "广东省茂名市",
"861450847", "江苏省常州市",
"861341577", "广东省肇庆市",
"861832066", "广东省潮州市",
"861569068", "河南省漯河市",
"861377756", "浙江省杭州市",
"861803274", "河北省沧州市",
"861391204", "江苏省徐州市",
"861312408", "福建省厦门市",
"86134371", "湖北省武汉市",
"861821648", "湖南省娄底市",
"861528910", "西藏拉萨市",
"861536568", "江苏省盐城市",
"861572599", "山东省临沂市",
"861571627", "江苏省南通市",
"861529436", "甘肃省天水市",
"861708747", "湖南省邵阳市",
"861534074", "山西省大同市",
"86151208", "海南省海口市",
"861312337", "福建省厦门市",
"861889060", "湖南省娄底市",
"86137832", "河南省平顶山市",
"861348809", "陕西省汉中市",
"86157735", "湖南省郴州市",
"861509420", "云南省保山市",
"86184455", "黑龙江省伊春市",
"861304097", "湖北省宜昌市",
"861475551", "安徽省合肥市",
"861319923", "黑龙江省七台河市",
"861810081", "四川省成都市",
"861571302", "河北省保定市",
"861772038", "湖北省荆门市",
"861311877", "云南省玉溪市",
"861874956", "河南省许昌市",
"861369723", "湖北省荆州市",
"861500337", "河北省沧州市",
"861335771", "江苏省南京市",
"86130008", "广东省广州市",
"861560942", "甘肃省定西市",
"861322073", "山东省潍坊市",
"861812055", "湖北省武汉市",
"86138441", "吉林省长春市",
"861302742", "湖南省长沙市",
"86183343", "浙江省杭州市",
"861300282", "四川省南充市",
"86177260", "天津",
"861880457", "黑龙江省大兴安岭地区",
"86132534", "河南省郑州市",
"861323520", "江苏省南通市",
"86158413", "辽宁省抚顺市",
"861595154", "江苏省盐城市",
"861538760", "四川省南充市",
"861808619", "湖北省荆州市",
"861824494", "广东省广州市",
"861390566", "安徽省池州市",
"861781745", "广东省珠海市",
"861310817", "四川省南充市",
"861856713", "河南省漯河市",
"861893138", "河北省保定市",
"86181485", "广东省深圳市",
"861593367", "河北省承德市",
"861896611", "浙江省台州市",
"861850758", "广东省肇庆市",
"861846235", "山东省菏泽市",
"861508284", "四川省广元市",
"861386557", "安徽省宿州市",
"86182169", "贵州省六盘水市",
"861337956", "陕西省榆林市",
"861700814", "江苏省南通市",
"86152542", "山东省青岛市",
"861771176", "湖南省永州市",
"861380674", "浙江省绍兴市",
"861568163", "四川省雅安市",
"86152520", "江苏省徐州市",
"861594976", "山东省潍坊市",
"861368944", "甘肃省白银市",
"861313411", "辽宁省大连市",
"861516618", "山东省日照市",
"861566659", "山东省泰安市",
"861365758", "新疆阿克苏地区",
"861336737", "湖南省益阳市",
"861861548", "山东省菏泽市",
"861868403", "四川省成都市",
"861532837", "四川省自贡市",
"861802193", "江苏省连云港市",
"861806043", "福建省宁德市",
"861770686", "浙江省台州市",
"861459439", "西藏日喀则地区",
"861593274", "河北省沧州市",
"861532443", "安徽省池州市",
"861516068", "福建省龙岩市",
"861471791", "山西省临汾市",
"86186575", "浙江省绍兴市",
"861804047", "四川省凉山彝族自治州",
"86155937", "甘肃省酒泉市",
"861808024", "四川省绵阳市",
"861700967", "浙江省台州市",
"861770545", "山东省烟台市",
"86150650", "山东省菏泽市",
"861334733", "湖南省株洲市",
"861390055", "安徽省阜阳市",
"861361483", "内蒙古阿拉善盟",
"861459478", "陕西省西安市",
"861350865", "湖北省黄冈市",
"861822620", "安徽省合肥市",
"861310929", "陕西省安康市",
"861830581", "浙江省杭州市",
"861847476", "湖南省永州市",
"861373372", "河南省许昌市",
"861300823", "辽宁省盘锦市",
"861375447", "河北省沧州市",
"861359776", "湖北省恩施土家族苗族自治州",
"861336166", "江西省抚州市",
"861535677", "浙江省温州市",
"861573159", "四川省泸州市",
"861575602", "安徽省铜陵市",
"861398700", "云南省临沧市",
"86139313", "河北省保定市",
"861801344", "江苏省镇江市",
"861588429", "四川省德阳市",
"861364819", "四川省达州市",
"861339937", "甘肃省酒泉市",
"861533688", "浙江省杭州市",
"861314858", "广东省东莞市",
"861858276", "四川省眉山市",
"861878415", "四川省广安市",
"861775160", "江苏省泰州市",
"861332323", "河北省张家口市",
"861380462", "黑龙江省哈尔滨市",
"861333307", "河北省沧州市",
"861808069", "四川省达州市",
"861868882", "广东省深圳市",
"861536631", "江苏省连云港市",
"861302401", "安徽省阜阳市",
"861533118", "辽宁省沈阳市",
"861346886", "陕西省延安市",
"861843959", "河南省驻马店市",
"861829972", "新疆乌鲁木齐市",
"861530506", "福建省漳州市",
"861310964", "陕西省渭南市",
"861550356", "山西省晋城市",
"861454366", "山东省威海市",
"861313016", "辽宁省鞍山市",
"861570740", "湖南省怀化市",
"861572280", "江苏省泰州市",
"86159341", "山西省太原市",
"861336481", "新疆伊犁哈萨克自治州",
"861333622", "山东省聊城市",
"861511300", "广东省佛山市",
"861811589", "江苏省镇江市",
"86150737", "湖南省益阳市",
"86134238", "广东省深圳市",
"861882981", "陕西省延安市",
"861565931", "福建省宁德市",
"861552050", "四川省甘孜藏族自治州",
"861355362", "广东省韶关市",
"861392469", "广东省汕尾市",
"86158098", "辽宁省辽阳市",
"861519441", "河南省洛阳市",
"861570728", "湖北省十堰市",
"861370782", "广西柳州市",
"861372242", "河北省保定市",
"861881383", "广东省梅州市",
"861779013", "四川省德阳市",
"861576685", "广东省湛江市",
"861320505", "福建省泉州市",
"86137204", "陕西省西安市",
"861780853", "贵州省安顺市",
"86132215", "浙江省绍兴市",
"86182354", "山西省晋中市",
"861501817", "广东省珠海市",
"861707429", "浙江省宁波市",
"861822648", "安徽省六安市",
"861586404", "山东省淄博市",
"861591636", "广东省惠州市",
"861768807", "广东省汕尾市",
"861518008", "江西省鹰潭市",
"861392204", "广东省茂名市",
"861318543", "浙江省嘉兴市",
"861571599", "福建省泉州市",
"861770571", "浙江省杭州市",
"86135293", "云南省昆明市",
"861760519", "江苏省常州市",
"861899448", "江苏省镇江市",
"861860362", "黑龙江省齐齐哈尔市",
"86134568", "浙江省杭州市",
"861533330", "河北省邯郸市",
"861470346", "山西省晋城市",
"861330894", "西藏林芝地区",
"861870535", "山东省烟台市",
"861314359", "广东省佛山市",
"861364318", "河北省衡水市",
"86186259", "河南省新乡市",
"861379189", "山东省潍坊市",
"86151108", "山西省朔州市",
"861324999", "广东省佛山市",
"861500877", "云南省玉溪市",
"861771511", "江苏省扬州市",
"861369671", "安徽省宿州市",
"861335623", "山东省日照市",
"861560591", "福建省福州市",
"861886084", "江苏省南京市",
"861453659", "江苏省连云港市",
"861855980", "福建省厦门市",
"86151116", "湖南省永州市",
"861309415", "湖北省孝感市",
"86150783", "广西桂林市",
"861399583", "湖北省鄂州市",
"86150949", "山东省潍坊市",
"861378390", "河南省开封市",
"861300300", "安徽省合肥市",
"861381582", "江苏省扬州市",
"86186431", "吉林省长春市",
"861564973", "河南省濮阳市",
"861364452", "黑龙江省齐齐哈尔市",
"861362598", "福建省泉州市",
"861301143", "河北省唐山市",
"861598166", "吉林省四平市",
"861360357", "山西省临汾市",
"861810469", "黑龙江省双鸭山市",
"861519046", "江苏省南京市",
"861831616", "广东省阳江市",
"861399960", "新疆巴音郭楞蒙古自治州",
"861589192", "云南省文山壮族苗族自治州",
"86181122", "江苏省南通市",
"861316524", "山东省德州市",
"861807470", "广西南宁市",
"86177530", "山东省菏泽市",
"86132264", "广东省广州市",
"861893310", "广东省阳江市",
"861509135", "陕西省咸阳市",
"86131731", "山东省潍坊市",
"861811022", "安徽省蚌埠市",
"86139944", "山西省大同市",
"861872048", "江西省景德镇市",
"861569777", "广西钦州市",
"861347770", "湖北省孝感市",
"861870326", "河北省廊坊市",
"861323548", "湖北省孝感市",
"86180667", "陕西省西安市",
"861595552", "安徽省马鞍山市",
"861575918", "福建省南平市",
"861339217", "广东省深圳市",
"861360980", "辽宁省鞍山市",
"861521734", "广东省广州市",
"86155749", "湖南省长沙市",
"861772854", "广东省江门市",
"861781771", "广东省广州市",
"86155983", "内蒙古包头市",
"861580799", "江西省萍乡市",
"861536700", "湖南省岳阳市",
"861803754", "河南省洛阳市",
"86159932", "河南省周口市",
"861810424", "辽宁省本溪市",
"86136369", "福建省泉州市",
"861845247", "江苏省泰州市",
"861504640", "黑龙江省七台河市",
"861576821", "广东省惠州市",
"861360563", "安徽省宣城市",
"861329019", "山东省菏泽市",
"861532409", "河北省张家口市",
"861316569", "湖北省咸宁市",
"861576067", "四川省达州市",
"861340334", "河北省承德市",
"861559146", "陕西省汉中市",
"861363437", "吉林省辽源市",
"861317541", "浙江省金华市",
"861383589", "山西省运城市",
"861457038", "广东省汕头市",
"861864826", "内蒙古包头市",
"861338532", "山东省青岛市",
"861512640", "云南省红河哈尼族彝族自治州",
"86182086", "贵州省黔西南布依族苗族自治州",
"86135846", "江苏省南通市",
"861522298", "安徽省阜阳市",
"861369938", "新疆乌鲁木齐市",
"861563687", "黑龙江省鸡西市",
"86159185", "广东省广州市",
"861761293", "陕西省渭南市",
"861358940", "山东省滨州市",
"861518856", "河南省信阳市",
"861821809", "广东省中山市",
"861893955", "河南省漯河市",
"861551262", "河北省廊坊市",
"861315448", "四川省德阳市",
"861837091", "江西省萍乡市",
"861317826", "福建省龙岩市",
"861522861", "四川省自贡市",
"861535994", "福建省三明市",
"861326761", "广东省中山市",
"861813029", "安徽省宣城市",
"861535651", "浙江省温州市",
"861388752", "云南省文山壮族苗族自治州",
"861889252", "贵州省安顺市",
"86187081", "四川省成都市",
"861820755", "广东省深圳市",
"86183492", "四川省成都市",
"86134726", "上海市",
"861520263", "宁夏吴忠市",
"861591765", "广东省东莞市",
"861378030", "河北省石家庄市",
"861309487", "浙江省嘉兴市",
"861362470", "内蒙古呼伦贝尔市",
"861530534", "山东省德州市",
"861844560", "黑龙江省黑河市",
"861571430", "吉林省长春市",
"86188905", "湖南省益阳市",
"861501621", "广东省河源市",
"86189897", "浙江省温州市",
"861598313", "四川省宜宾市",
"861778741", "云南省曲靖市",
"861562879", "山东省济南市",
"861572811", "广东省深圳市",
"861315382", "山东省聊城市",
"861366779", "广西北海市",
"861397196", "湖北省孝感市",
"861805491", "福建省南平市",
"861310773", "浙江省杭州市",
"861777127", "湖北省宜昌市",
"861772899", "广东省茂名市",
"861775698", "安徽省合肥市",
"861807598", "湖南省怀化市",
"861311713", "湖北省恩施土家族苗族自治州",
"861573975", "新疆伊犁哈萨克自治州",
"86184815", "四川省凉山彝族自治州",
"861580754", "广东省汕头市",
"861306931", "河南省开封市",
"861517035", "江西省上饶市",
"861318365", "四川省眉山市",
"86186673", "浙江省嘉兴市",
"86138588", "浙江省温州市",
"861452709", "湖北省十堰市",
"861810916", "陕西省汉中市",
"86158247", "河南省商丘市",
"861813184", "河北省衡水市",
"861837496", "湖南省长沙市",
"861562838", "广东省东莞市",
"861839836", "四川省广元市",
"861831547", "山东省济宁市",
"86139627", "江苏省南通市",
"861311851", "贵州省贵阳市",
"861534982", "安徽省安庆市",
"861501885", "广东省珠海市",
"861325176", "吉林省白城市",
"861780435", "吉林省通化市",
"861782828", "四川省内江市",
"86180398", "福建省龙岩市",
"861329961", "广西柳州市",
"861533090", "辽宁省锦州市",
"861524013", "安徽省宣城市",
"861303504", "安徽省芜湖市",
"861783910", "河南省商丘市",
"861700492", "上海市",
"861597483", "云南省昆明市",
"86130759", "福建省福州市",
"861560425", "辽宁省丹东市",
"861880471", "内蒙古呼和浩特市",
"861808231", "江苏省宿迁市",
"861800690", "福建省福州市",
"861845255", "江苏省盐城市",
"861331705", "江西省南昌市",
"861881411", "广东省广州市",
"861365489", "内蒙古锡林郭勒盟",
"861512150", "贵州省毕节地区",
"86159754", "广东省广州市",
"861535141", "四川省达州市",
"861370818", "四川省成都市",
"861357731", "云南省红河哈尼族彝族自治州",
"861334928", "安徽省阜阳市",
"861376853", "广西桂林市",
"861322893", "西藏山南地区",
"861882830", "四川省成都市",
"861571554", "安徽省淮南市",
"861530450", "黑龙江省哈尔滨市",
"86186330", "河北省石家庄市",
"861360345", "河南省郑州市",
"861337862", "广东省佛山市",
"861457079", "江苏省泰州市",
"86155118", "河北省石家庄市",
"861320868", "吉林省辽源市",
"861380997", "新疆和田地区",
"861330859", "贵州省黔西南布依族苗族自治州",
"861309731", "江西省赣州市",
"86184864", "贵州省毕节地区",
"861856240", "山东省济宁市",
"861308626", "青海省西宁市",
"861450996", "新疆巴音郭楞蒙古自治州",
"861576617", "广东省肇庆市",
"861363843", "湖南省株洲市",
"861528480", "四川省自贡市",
"861587241", "湖北省武汉市",
"861594589", "黑龙江省佳木斯市",
"861301727", "湖南省常德市",
"861842925", "陕西省安康市",
"86135959", "贵州省黔西南布依族苗族自治州",
"861328889", "广东省东莞市",
"86188778", "广西河池市",
"86155067", "广西柳州市",
"861883877", "河南省商丘市",
"861379911", "福建省南平市",
"861369979", "广东省深圳市",
"861850489", "内蒙古锡林郭勒盟",
"861324691", "广东省揭阳市",
"861302034", "辽宁省抚顺市",
"861476018", "福建省泉州市",
"861559515", "宁夏中卫市",
"861452743", "湖南省湘西土家族苗族自治州",
"86187133", "河北省张家口市",
"861450283", "内蒙古鄂尔多斯市",
"861362913", "陕西省渭南市",
"86187746", "湖南省永州市",
"861313735", "河南省濮阳市",
"861579805", "江西省萍乡市",
"861809030", "四川省内江市",
"861314401", "广东省中山市",
"861856228", "山东省泰安市",
"861386545", "安徽省六安市",
"861827274", "河南省焦作市",
"861370319", "河北省邢台市",
"861506758", "浙江省金华市",
"861360371", "河南省郑州市",
"861305659", "四川省雅安市",
"861302858", "陕西省延安市",
"861539778", "四川省绵阳市",
"861454113", "安徽省芜湖市",
"861897049", "江西省新余市",
"8615901", "北京市",
"861361311", "河北省石家庄市",
"86185892", "广东省广州市",
"861596532", "山东省青岛市",
"861319259", "广东省阳江市",
"861454683", "广东省深圳市",
"861570933", "甘肃省平凉市",
"861867221", "湖北省黄石市",
"861569751", "广东省韶关市",
"861890682", "浙江省湖州市",
"861389834", "辽宁省抚顺市",
"861812047", "湖北省黄冈市",
"861818759", "云南省文山壮族苗族自治州",
"861705053", "山东省济南市",
"861550043", "吉林省四平市",
"86133446", "山东省德州市",
"861821843", "广东省湛江市",
"861353116", "广东省汕头市",
"861804566", "黑龙江省哈尔滨市",
"861814636", "青海省海西蒙古族藏族自治州",
"861536939", "河北省石家庄市",
"86138322", "河北省保定市",
"861334940", "黑龙江省哈尔滨市",
"861864992", "福建省厦门市",
"861841952", "甘肃省定西市",
"861528322", "四川省资阳市",
"86189408", "辽宁省大连市",
"861876660", "山东省东营市",
"86182741", "湖南省岳阳市",
"861781757", "广东省佛山市",
"861306211", "福建省三明市",
"86132130", "河南省郑州市",
"861317992", "新疆伊犁哈萨克自治州",
"861766021", "山东省青岛市",
"861452881", "云南省文山壮族苗族自治州",
"861894282", "四川省阿坝藏族羌族自治州",
"861332597", "浙江省温州市",
"861354532", "湖北省襄樊市",
"861320369", "湖南省益阳市",
"861336313", "河北省张家口市",
"861330358", "山西省吕梁市",
"861367636", "山东省潍坊市",
"861334317", "河北省沧州市",
"861536978", "河北省沧州市",
"861330412", "辽宁省鞍山市",
"86159062", "江苏省苏州市",
"861802765", "广东省深圳市",
"86189416", "辽宁省锦州市",
"861327418", "辽宁省阜新市",
"861532351", "广东省东莞市",
"861852723", "湖北省荆门市",
"861510727", "湖北省襄樊市",
"861363809", "贵州省黔东南苗族侗族自治州",
"861889907", "新疆乌鲁木齐市",
"86159440", "吉林省长春市",
"861325511", "江苏省无锡市",
"861452625", "江苏省南通市",
"86153827", "广东省中山市",
"86182838", "四川省德阳市",
"861527138", "湖北省十堰市",
"861569813", "山东省泰安市",
"861770363", "黑龙江省七台河市",
"861479156", "陕西省西安市",
"861350984", "广东省东莞市",
"861571642", "河南省开封市",
"861568795", "云南省临沧市",
"861824459", "河北省邢台市",
"86159422", "辽宁省鞍山市",
"861538072", "江苏省泰州市",
"861331472", "内蒙古包头市",
"861840696", "云南省保山市",
"861834468", "江苏省苏州市",
"861573941", "新疆阿克苏地区",
"86147803", "四川省资阳市",
"86186921", "湖南省岳阳市",
"861770557", "安徽省宿州市",
"861533255", "陕西省延安市",
"861556088", "内蒙古通辽市",
"861313383", "江西省南昌市",
"861869012", "新疆塔城地区",
"861586436", "山东省聊城市",
"861317575", "浙江省丽水市",
"861505923", "福建省漳州市",
"861776674", "四川省凉山彝族自治州",
"861315420", "辽宁省铁岭市",
"861478608", "贵州省黔西南布依族苗族自治州",
"861538414", "浙江省绍兴市",
"861843141", "河北省石家庄市",
"861826060", "江苏省镇江市",
"861567081", "河南省驻马店市",
"861375455", "河北省唐山市",
"86136550", "福建省福州市",
"861764531", "黑龙江省牡丹江市",
"86147168", "广东省广州市",
"86180285", "广东省广州市",
"861867742", "广西梧州市",
"861566694", "山东省泰安市",
"861865984", "福建省泉州市",
"861337790", "湖北省荆州市",
"861309600", "四川省自贡市",
"861529286", "新疆乌鲁木齐市",
"861500851", "贵州省贵阳市",
"861839376", "甘肃省白银市",
"861390047", "内蒙古包头市",
"861377468", "福建省厦门市",
"861386686", "安徽省宿州市",
"861864575", "黑龙江省牡丹江市",
"861369657", "安徽省黄山市",
"861558894", "山东省莱芜市",
"861335364", "河南省安阳市",
"861304408", "山东省济宁市",
"861594566", "黑龙江省哈尔滨市",
"861477801", "广东省东莞市",
"861843403", "山西省阳泉市",
"861335840", "福建省三明市",
"861333157", "吉林省白城市",
"861869197", "陕西省咸阳市",
"861832547", "山东省济宁市",
"861881689", "广东省广州市",
"861500682", "山东省莱芜市",
"86158147", "广东省深圳市",
"861576778", "广东省梅州市",
"861365611", "江苏省常州市",
"861559049", "吉林省松原市",
"861452142", "河北省承德市",
"861850466", "黑龙江省哈尔滨市",
"86138013", "北京市",
"861535449", "河北省石家庄市",
"861323776", "广西百色市",
"861301359", "山东省日照市",
"861571753", "湖南省株洲市",
"861329363", "山西省阳泉市",
"861300628", "江西省新余市",
"861881830", "广东省韶关市",
"861380495", "辽宁省大连市",
"861321893", "江苏省宿迁市",
"861373249", "浙江省绍兴市",
"861332705", "内蒙古通辽市",
"861304337", "吉林省延边朝鲜族自治州",
"86183328", "河北省保定市",
"86187563", "安徽省宣城市",
"86152337", "河北省保定市",
"861834990", "四川省成都市",
"861364942", "广西柳州市",
"861454712", "浙江省湖州市",
"86155218", "广东省中山市",
"86131891", "广东省广州市",
"861356566", "新疆喀什地区",
"861776521", "广东省珠海市",
"861335329", "吉林省长春市",
"861509719", "甘肃省陇南市",
"861325038", "广东省佛山市",
"861840732", "湖南省长沙市",
"861329557", "安徽省宿州市",
"86155261", "湖南省怀化市",
"861572554", "山东省烟台市",
"861350892", "山东省聊城市",
"86132560", "山东省日照市",
"861581214", "云南省昆明市",
"861366259", "广东省深圳市",
"861841925", "甘肃省定西市",
"861310253", "河北省秦皇岛市",
"861301034", "江苏省南京市",
"861882666", "广东省佛山市",
"861390976", "青海省玉树藏族自治州",
"861774436", "四川省达州市",
"861844708", "内蒙古通辽市",
"861377990", "福建省漳州市",
"861565093", "青海省海东地区",
"861776846", "江苏省淮安市",
"861780937", "甘肃省酒泉市",
"861322080", "山东省济宁市",
"861378816", "广西百色市",
"861889772", "广西柳州市",
"861530385", "河南省洛阳市",
"861302727", "江西省九江市",
"861303703", "山西省朔州市",
"861829562", "宁夏石嘴山市",
"86134470", "上海市",
"861816012", "四川省广安市",
"86178797", "江西省赣州市",
"861580553", "安徽省芜湖市",
"861708755", "江西省南昌市",
"861367792", "江西省九江市",
"861882016", "广东省深圳市",
"861572273", "江苏省宿迁市",
"861311514", "江苏省连云港市",
"861586518", "山东省东营市",
"86181621", "江西省赣州市",
"861890097", "辽宁省大连市",
"861452652", "江西省九江市",
"861573477", "内蒙古鄂尔多斯市",
"861450855", "江苏省盐城市",
"861585946", "福建省泉州市",
"861877506", "广西桂林市",
"861705606", "广东省东莞市",
"861890851", "贵州省贵阳市",
"861569245", "广东省深圳市",
"861316657", "河北省衡水市",
"861530733", "湖南省株洲市",
"861855410", "山东省烟台市",
"861309985", "云南省大理白族自治州",
"861453353", "辽宁省大连市",
"861310574", "浙江省宁波市",
"861519951", "新疆阿勒泰地区",
"861335277", "广东省惠州市",
"861343191", "广东省珠海市",
"861519694", "四川省遂宁市",
"86139675", "浙江省绍兴市",
"861864884", "广西玉林市",
"861502621", "新疆博尔塔拉蒙古自治州",
"86150416", "辽宁省锦州市",
"861700577", "浙江省温州市",
"861576739", "广东省湛江市",
"861571811", "广东省广州市",
"861874075", "陕西省安康市",
"861327536", "山东省潍坊市",
"861306333", "安徽省合肥市",
"861893457", "江苏省苏州市",
"86147538", "山东省泰安市",
"86137500", "广东省珠海市",
"861356055", "广东省汕尾市",
"861892253", "广东省东莞市",
"86180062", "江苏省苏州市",
"861375422", "浙江省湖州市",
"861340646", "山东省潍坊市",
"861572430", "辽宁省辽阳市",
"861774031", "河北省邯郸市",
"861361470", "内蒙古呼伦贝尔市",
"861879512", "宁夏石嘴山市",
"861899958", "新疆伊犁哈萨克自治州",
"861372110", "安徽省合肥市",
"86153302", "北京市",
"861816474", "云南省红河哈尼族彝族自治州",
"86187287", "四川省巴中市",
"861360410", "辽宁省铁岭市",
"861334506", "山东省东营市",
"861533402", "湖北省荆门市",
"86170886", "云南省昆明市",
"861778090", "四川省南充市",
"861700000", "北京市",
"861365061", "广东省汕尾市",
"861533222", "陕西省渭南市",
"861805199", "江苏省南京市",
"86155475", "内蒙古通辽市",
"861363935", "甘肃省武威市",
"861570871", "云南省昆明市",
"861560819", "四川省成都市",
"861510858", "贵州省六盘水市",
"861587755", "陕西省西安市",
"86150897", "广东省清远市",
"861808313", "贵州省黔南布依族苗族自治州",
"861303749", "湖南省永州市",
"861855107", "江苏省常州市",
"861893922", "河南省南阳市",
"861319779", "广西北海市",
"861595491", "山东省济南市",
"861887263", "湖北省武汉市",
"861770961", "安徽省淮北市",
"861386669", "安徽省宿州市",
"861476531", "辽宁省沈阳市",
"861350926", "广东省清远市",
"86183582", "浙江省宁波市",
"861529269", "新疆和田地区",
"861879114", "陕西省延安市",
"861539258", "山西省吕梁市",
"861510034", "河北省邯郸市",
"861572642", "山东省青岛市",
"861587123", "湖北省随州市",
"861823233", "河北省张家口市",
"861532953", "贵州省安顺市",
"861332472", "广西柳州市",
"861376285", "湖南省邵阳市",
"861809816", "广东省佛山市",
"861539067", "甘肃省张掖市",
"861566567", "安徽省亳州市",
"861525539", "安徽省蚌埠市",
"861822437", "四川省广安市",
"861845883", "浙江省温州市",
"861520999", "新疆伊犁哈萨克自治州",
"861310172", "河南省安阳市",
"861391236", "江苏省无锡市",
"861300150", "山东省淄博市",
"86152383", "河南省郑州市",
"861529404", "甘肃省平凉市",
"86147474", "内蒙古兴安盟",
"861318032", "河北省沧州市",
"861332014", "江西省景德镇市",
"861373423", "山西省长治市",
"861771398", "四川省成都市",
"861858990", "广西崇左市",
"861821935", "广东省深圳市",
"861510359", "山西省运城市",
"861560318", "河北省衡水市",
"861529224", "湖南省株洲市",
"861815498", "新疆伊犁哈萨克自治州",
"861589165", "陕西省咸阳市",
"861881370", "广东省惠州市",
"861857816", "广东省河源市",
"86131823", "江苏省徐州市",
"861311682", "浙江省湖州市",
"861372338", "宁夏银川市",
"86158786", "广西百色市",
"861535403", "河北省张家口市",
"861889405", "甘肃省武威市",
"861534894", "西藏林芝地区",
"86147211", "上海市",
"861347335", "河北省石家庄市",
"861787550", "广东省深圳市",
"861880310", "河北省邯郸市",
"861313981", "新疆博尔塔拉蒙古自治州",
"861818279", "黑龙江省双鸭山市",
"861311112", "山西省大同市",
"861350760", "河南省信阳市",
"861569271", "贵州省贵阳市",
"861820722", "湖北省武汉市",
"861368530", "山东省菏泽市",
"86180185", "上海市",
"861535223", "甘肃省陇南市",
"861316938", "广东省云浮市",
"86134869", "浙江省金华市",
"861814860", "广东省广州市",
"861339853", "贵州省安顺市",
"861818327", "四川省成都市",
"861863893", "河南省郑州市",
"861301858", "广东省湛江市",
"86153875", "湖南省长沙市",
"861361913", "陕西省渭南市",
"86185954", "河南省郑州市",
"861315135", "江苏省盐城市",
"861780658", "广东省湛江市",
"861589085", "河南省南阳市",
"861316979", "广东省茂名市",
"861367344", "河南省周口市",
"861818602", "湖北省黄冈市",
"861786613", "甘肃省兰州市",
"861522042", "广东省东莞市",
"861560452", "黑龙江省齐齐哈尔市",
"861773414", "河北省沧州市",
"861860395", "河南省漯河市",
"861388643", "湖北省黄冈市",
"861308512", "湖北省武汉市",
"861325854", "黑龙江省双鸭山市",
"861367860", "山东省菏泽市",
"861822781", "四川省眉山市",
"86158853", "贵州省六盘水市",
"861876836", "浙江省湖州市",
"861880947", "甘肃省酒泉市",
"861861776", "河北省保定市",
"861338356", "山西省晋城市",
"861347783", "湖北省宜昌市",
"861804589", "黑龙江省双鸭山市",
"861362311", "河北省石家庄市",
"861539187", "安徽省宿州市",
"86159398", "河南省三门峡市",
"861336911", "陕西省咸阳市",
"861300640", "四川省乐山市",
"861807483", "广西桂林市",
"861773072", "陕西省渭南市",
"861342814", "广东省湛江市",
"861384799", "内蒙古兴安盟",
"861573808", "河南省南阳市",
"861319738", "湖北省孝感市",
"861539617", "福建省三明市",
"861811047", "安徽省阜阳市",
"86187472", "内蒙古包头市",
"861355716", "广西百色市",
"86177327", "河北省张家口市",
"861331597", "河北省石家庄市",
"861452544", "山东省济南市",
"861332629", "山东省滨州市",
"861564980", "河南省许昌市",
"86156329", "河北省邢台市",
"861567204", "湖北省恩施土家族苗族自治州",
"861533775", "江西省南昌市",
"861304240", "辽宁省沈阳市",
"861368454", "黑龙江省佳木斯市",
"861892172", "江苏省泰州市",
"861347526", "山东省东营市",
"861353624", "广东省江门市",
"86177564", "安徽省六安市",
"86155531", "山东省济南市",
"861855973", "福建省龙岩市",
"86132230", "河南省郑州市",
"861330265", "广东省惠州市",
"86188424", "辽宁省沈阳市",
"861350321", "河北省石家庄市",
"86184356", "山西省晋城市",
"861876945", "山东省德州市",
"861770366", "黑龙江省哈尔滨市",
"861569816", "山东省青岛市",
"861368939", "甘肃省陇南市",
"861812345", "四川省成都市",
"86137514", "广东省东莞市",
"861884042", "陕西省榆林市",
"861593248", "河北省石家庄市",
"861840693", "云南省保山市",
"86132505", "广东省广州市",
"86189673", "浙江省嘉兴市",
"861840767", "广东省广州市",
"861392470", "广东省珠海市",
"861700140", "江苏省淮安市",
"861329670", "浙江省温州市",
"861857271", "湖北省黄石市",
"861334665", "河南省安阳市",
"861587614", "广东省佛山市",
"861479725", "山西省大同市",
"861308771", "广西南宁市",
"861845824", "浙江省杭州市",
"86182988", "甘肃省庆阳市",
"86186897", "海南省海口市",
"861303861", "云南省丽江市",
"861894541", "黑龙江省佳木斯市",
"861593687", "河南省三门峡市",
"86185244", "辽宁省沈阳市",
"861399938", "新疆伊犁哈萨克自治州",
"861477763", "广西玉林市",
"861887289", "湖北省十堰市",
"861567802", "广西来宾市",
"861380158", "江苏省南京市",
"861529283", "新疆和田地区",
"861345100", "湖北省鄂州市",
"861839373", "甘肃省平凉市",
"86151378", "河南省开封市",
"861300467", "浙江省金华市",
"861373484", "内蒙古呼和浩特市",
"861386683", "安徽省马鞍山市",
"861304362", "江苏省无锡市",
"861339995", "新疆吐鲁番地区",
"861863955", "河南省郑州市",
"86134201", "广东省湛江市",
"861826899", "浙江省衢州市",
"861522988", "陕西省西安市",
"861707558", "安徽省阜阳市",
"861800318", "河北省衡水市",
"861393437", "山西省运城市",
"861475128", "江苏省宿迁市",
"861313386", "江西省萍乡市",
"861586433", "山东省潍坊市",
"861505926", "福建省宁德市",
"861705565", "辽宁省大连市",
"861535284", "内蒙古呼和浩特市",
"861510587", "浙江省温州市",
"861454545", "新疆克拉玛依市",
"861580332", "河北省保定市",
"861864300", "吉林省四平市",
"861564589", "黑龙江省伊春市",
"861454116", "安徽省池州市",
"861320981", "山西省太原市",
"861842018", "广东省肇庆市",
"861804357", "吉林省长春市",
"861500395", "河南省漯河市",
"861570936", "甘肃省张掖市",
"861454686", "广东省深圳市",
"861471485", "广东省广州市",
"861380287", "广东省惠州市",
"861810470", "内蒙古呼伦贝尔市",
"861813722", "河南省开封市",
"861800452", "黑龙江省齐齐哈尔市",
"86130031", "上海市",
"861479643", "江西省上饶市",
"861399979", "新疆阿勒泰地区",
"861522504", "河南省平顶山市",
"861877015", "江西省宜春市",
"861811410", "江苏省无锡市",
"861362916", "陕西省汉中市",
"861452746", "湖南省永州市",
"861390345", "山西省长治市",
"861879745", "湖南省湘西土家族苗族自治州",
"861700650", "江苏省苏州市",
"861555640", "安徽省六安市",
"861537921", "甘肃省平凉市",
"861554738", "内蒙古乌海市",
"861338951", "宁夏银川市",
"861379070", "广东省中山市",
"86151083", "四川省成都市",
"861338694", "福建省漳州市",
"861760607", "福建省福州市",
"861812831", "广东省揭阳市",
"861380648", "山东省淄博市",
"861866239", "江苏省扬州市",
"861860514", "江苏省扬州市",
"86156754", "湖南省衡阳市",
"861316570", "陕西省榆林市",
"861329888", "吉林省长春市",
"861807424", "浙江省宁波市",
"861368978", "吉林省松原市",
"86145220", "浙江省杭州市",
"861334015", "江西省宜春市",
"861883035", "河北省秦皇岛市",
"861336316", "河北省廊坊市",
"861367633", "山东省日照市",
"861352382", "河南省商丘市",
"861875148", "江苏省扬州市",
"861527698", "新疆塔城地区",
"861705056", "北京市",
"861550046", "吉林省白山市",
"861854525", "黑龙江省双鸭山市",
"861825058", "福建省三明市",
"861829537", "宁夏银川市",
"861821846", "广东省广州市",
"861340752", "江苏省徐州市",
"861592838", "四川省巴中市",
"86136627", "广东省东莞市",
"861353113", "广东省湛江市",
"861590425", "辽宁省大连市",
"861814633", "青海省海东地区",
"861336795", "江西省宜春市",
"861804563", "黑龙江省黑河市",
"861529822", "四川省南充市",
"861339572", "浙江省湖州市",
"861530692", "福建省厦门市",
"86153671", "湖南省长沙市",
"861472987", "陕西省榆林市",
"861827065", "江西省九江市",
"861552864", "四川省雅安市",
"861356764", "浙江省丽水市",
"861875120", "江苏省常州市",
"861787677", "广东省梅州市",
"861594729", "内蒙古锡林郭勒盟",
"861772610", "湖南省常德市",
"86186408", "辽宁省大连市",
"861475650", "河北省唐山市",
"861811107", "四川省凉山彝族自治州",
"861830905", "新疆哈密地区",
"861760480", "内蒙古阿拉善盟",
"861843284", "河北省承德市",
"861517408", "辽宁省锦州市",
"861584809", "内蒙古呼伦贝尔市",
"861376856", "广西柳州市",
"861373798", "广西河池市",
"861533869", "贵州省黔西南布依族苗族自治州",
"861538779", "江西省宜春市",
"861322896", "西藏那曲地区",
"861772180", "四川省南充市",
"86147907", "安徽省宿州市",
"861837493", "湖南省岳阳市",
"861839833", "四川省内江市",
"861860682", "浙江省湖州市",
"861452968", "广东省肇庆市",
"861872412", "江苏省徐州市",
"86137235", "广东省东莞市",
"861317282", "广东省揭阳市",
"861597486", "云南省昭通市",
"861524016", "安徽省六安市",
"861308623", "青海省海南藏族自治州",
"861866827", "浙江省宁波市",
"861450993", "新疆石河子市",
"861594764", "内蒙古赤峰市",
"861363846", "湖南省常德市",
"861512965", "陕西省西安市",
"861867049", "湖南省长沙市",
"861533824", "广东省汕头市",
"861868434", "吉林省四平市",
"861323574", "浙江省宁波市",
"861566532", "安徽省安庆市",
"861539032", "四川省遂宁市",
"86153556", "浙江省台州市",
"861779735", "青海省海西蒙古族藏族自治州",
"861329389", "山西省晋城市",
"861314049", "河南省洛阳市",
"861819758", "新疆博尔塔拉蒙古自治州",
"861390371", "河南省郑州市",
"861363521", "福建省宁德市",
"861359817", "河南省洛阳市",
"861597161", "湖北省荆州市",
"861596694", "山东省青岛市",
"861550475", "内蒙古通辽市",
"861524411", "山东省泰安市",
"86139550", "安徽省滁州市",
"861761296", "陕西省宝鸡市",
"861508959", "广东省阳江市",
"861521749", "广东省东莞市",
"861894575", "黑龙江省鹤岗市",
"861337101", "山东省泰安市",
"861317823", "福建省莆田市",
"861518853", "河南省许昌市",
"861322457", "黑龙江省大庆市",
"861360047", "广东省广州市",
"861559143", "陕西省商洛市",
"861359964", "福建省龙岩市",
"861454571", "四川省达州市",
"86189921", "陕西省延安市",
"861334704", "内蒙古呼伦贝尔市",
"86155809", "湖南省长沙市",
"861864823", "内蒙古兴安盟",
"861561604", "湖南省湘潭市",
"861358015", "广东省揭阳市",
"861800819", "四川省达州市",
"861538738", "湖南省娄底市",
"861839447", "甘肃省天水市",
"861870597", "福建省龙岩市",
"861311716", "湖北省咸宁市",
"861470565", "安徽省芜湖市",
"861776935", "湖南省郴州市",
"86139871", "云南省昆明市",
"861893160", "河北省邯郸市",
"861325907", "陕西省渭南市",
"86156422", "辽宁省鞍山市",
"861318187", "山东省威海市",
"861552917", "陕西省宝鸡市",
"86130183", "重庆市",
"861810913", "陕西省渭南市",
"861899474", "江苏省泰州市",
"861866919", "云南省西双版纳傣族自治州",
"861587582", "广东省肇庆市",
"861598795", "云南省丽江市",
"861816958", "宁夏银川市",
"861588558", "贵州省黔南布依族苗族自治州",
"861808070", "四川省遂宁市",
"861311395", "广东省广州市",
"861593400", "山西省忻州市",
"86156062", "江苏省苏州市",
"861319865", "四川省遂宁市",
"861479609", "广西玉林市",
"86187379", "河南省洛阳市",
"861308745", "云南省红河哈尼族彝族自治州",
"861889511", "宁夏银川市",
"861520266", "宁夏石嘴山市",
"861811973", "安徽省蚌埠市",
"86151131", "广东省珠海市",
"861470451", "黑龙江省哈尔滨市",
"861598316", "四川省自贡市",
"861321955", "四川省内江市",
"861580872", "云南省大理白族自治州",
"861775179", "江苏省南京市",
"86186416", "辽宁省锦州市",
"861397193", "湖北省十堰市",
"861593220", "河北省邯郸市",
"86181825", "陕西省西安市",
"861310776", "浙江省温州市",
"861308251", "江苏省常州市",
"861340609", "山东省东营市",
"861786616", "甘肃省庆阳市",
"861590927", "陕西省咸阳市",
"861388646", "湖北省黄石市",
"861802339", "广东省云浮市",
"861861773", "河北省沧州市",
"86134166", "广东省东莞市",
"861338353", "山西省阳泉市",
"861876833", "浙江省嘉兴市",
"861857751", "广西贵港市",
"861306876", "河北省石家庄市",
"861347786", "湖北省宜昌市",
"86188960", "重庆市",
"861811831", "江苏省徐州市",
"861339856", "贵州省铜仁地区",
"861863896", "河南省南阳市",
"861807161", "江苏省南通市",
"861505508", "安徽省淮北市",
"861367099", "广东省湛江市",
"861377280", "陕西省汉中市",
"86151506", "江苏省南京市",
"861361916", "陕西省汉中市",
"861334549", "新疆博尔塔拉蒙古自治州",
"86187458", "黑龙江省哈尔滨市",
"86130237", "浙江省宁波市",
"861859161", "陕西省汉中市",
"861351382", "河南省焦作市",
"861786461", "山东省滨州市",
"861394942", "河南省开封市",
"86182634", "山东省莱芜市",
"861551237", "河北省承德市",
"861855976", "福建省厦门市",
"861347523", "山东省枣庄市",
"861862574", "河南省周口市",
"861363462", "黑龙江省齐齐哈尔市",
"861458288", "福建省莆田市",
"861471987", "新疆乌鲁木齐市",
"861807486", "广西百色市",
"861559401", "甘肃省平凉市",
"861551328", "山西省太原市",
"861338567", "安徽省亳州市",
"861346330", "河北省张家口市",
"861830839", "四川省广元市",
"861535001", "江西省南昌市",
"861550659", "山东省烟台市",
"861837904", "江西省新余市",
"86136995", "江西省南昌市",
"86183399", "河南省郑州市",
"86157623", "山东省日照市",
"861809751", "新疆阿勒泰地区",
"861395611", "安徽省六安市",
"861454669", "广东省深圳市",
"861355713", "广西桂林市",
"861568911", "山东省青岛市",
"861811345", "四川省遂宁市",
"861557012", "江西省赣州市",
"861390410", "辽宁省铁岭市",
"861823236", "河北省秦皇岛市",
"86137374", "广西梧州市",
"861587126", "湖北省孝感市",
"861503160", "河北省廊坊市",
"861808795", "云南省昆明市",
"861870705", "江西省宜春市",
"861869958", "新疆哈密地区",
"861532956", "贵州省铜仁地区",
"861333998", "湖北省武汉市",
"861809813", "广东省潮州市",
"86155721", "湖北省荆州市",
"861355851", "四川省甘孜藏族自治州",
"861850244", "辽宁省铁岭市",
"861313369", "江西省吉安市",
"861820582", "浙江省湖州市",
"861831818", "广东省湛江市",
"861845886", "浙江省杭州市",
"861808316", "贵州省安顺市",
"861840354", "山西省晋中市",
"861355097", "四川省广元市",
"861339497", "新疆阿克苏地区",
"861337837", "四川省凉山彝族自治州",
"861863457", "山西省临汾市",
"861370547", "山东省济宁市",
"861830878", "云南省楚雄彝族自治州",
"861452490", "内蒙古包头市",
"861887266", "湖北省孝感市",
"861536454", "山西省晋中市",
"861768999", "福建省福州市",
"861589950", "广东省惠州市",
"861366865", "山东省烟台市",
"861803400", "河北省邯郸市",
"861350923", "广东省东莞市",
"861598070", "福建省福州市",
"861559006", "吉林省吉林市",
"861343700", "江西省南昌市",
"86134007", "福建省厦门市",
"861535406", "河北省廊坊市",
"861326482", "湖北省黄冈市",
"861504575", "黑龙江省双鸭山市",
"86151518", "江苏省南京市",
"861321922", "四川省遂宁市",
"86134813", "广西桂林市",
"861802378", "广东省云浮市",
"861365244", "广东省深圳市",
"861860851", "贵州省贵阳市",
"861818025", "四川省遂宁市",
"861847607", "广东省湛江市",
"861894884", "广东省韶关市",
"86136675", "新疆巴音郭楞蒙古自治州",
"861313324", "山西省吕梁市",
"861535226", "甘肃省临夏回族自治州",
"861344672", "湖北省襄樊市",
"861391233", "江苏省常州市",
"861770389", "河南省焦作市",
"861320735", "湖南省郴州市",
"861526632", "山东省枣庄市",
"861363674", "陕西省咸阳市",
"861509012", "河南省南阳市",
"861839971", "新疆阿克苏地区",
"861373426", "山西省长治市",
"86138903", "四川省眉山市",
"8618570", "湖南省长沙市",
"861521988", "广东省茂名市",
"861550149", "江苏省苏州市",
"861705159", "湖北省武汉市",
"861871859", "广东省佛山市",
"86150921", "山东省青岛市",
"861857813", "广东省湛江市",
"861348495", "陕西省西安市",
"861830379", "河南省洛阳市",
"861478374", "河南省许昌市",
"86152696", "山东省潍坊市",
"861705603", "广东省广州市",
"861877503", "广西梧州市",
"861530736", "湖南省常德市",
"861321457", "黑龙江省大兴安岭地区",
"861524830", "内蒙古阿拉善盟",
"861528057", "福建省三明市",
"861858280", "四川省达州市",
"861398530", "贵州省安顺市",
"861870664", "山东省滨州市",
"861453356", "辽宁省抚顺市",
"861526440", "山东省菏泽市",
"861504541", "黑龙江省佳木斯市",
"861803687", "江苏省无锡市",
"861324439", "吉林省白山市",
"861874264", "新疆阿克苏地区",
"861844969", "新疆巴音郭楞蒙古自治州",
"861882013", "广东省广州市",
"861580556", "安徽省安庆市",
"861537800", "甘肃省张掖市",
"861313291", "广西南宁市",
"861774847", "四川省达州市",
"861318778", "云南省曲靖市",
"861776437", "安徽省池州市",
"86182447", "湖南省永州市",
"861831319", "云南省大理白族自治州",
"861524689", "黑龙江省双鸭山市",
"861590318", "河北省衡水市",
"861528891", "山东省泰安市",
"861585943", "福建省福州市",
"861839945", "新疆喀什地区",
"861838154", "四川省乐山市",
"861334503", "山东省东营市",
"86130283", "重庆市",
"86150673", "浙江省嘉兴市",
"861770888", "云南省丽江市",
"86138069", "福建省漳州市",
"861811371", "四川省广元市",
"86158957", "江苏省扬州市",
"861358549", "江苏省徐州市",
"861870629", "江苏省南通市",
"861312716", "山东省潍坊市",
"861596567", "山东省菏泽市",
"861580615", "江苏省无锡市",
"861304035", "吉林省通化市",
"861556591", "河南省漯河市",
"86138429", "辽宁省葫芦岛市",
"861810311", "河北省石家庄市",
"861773779", "河南省郑州市",
"861306336", "安徽省芜湖市",
"861359780", "湖北省恩施土家族苗族自治州",
"861327533", "山东省淄博市",
"861887590", "广东省深圳市",
"861550977", "青海省海西蒙古族藏族自治州",
"86187519", "江苏省南京市",
"861820614", "江苏省常州市",
"861892256", "广东省清远市",
"861340643", "山东省烟台市",
"86170936", "河南省郑州市",
"861805880", "浙江省杭州市",
"861571756", "湖南省常德市",
"861375198", "广东省梅州市",
"861833801", "河南省安阳市",
"861594980", "山东省泰安市",
"86178581", "浙江省绍兴市",
"861884861", "贵州省毕节地区",
"861329366", "山西省吕梁市",
"86151459", "黑龙江省大庆市",
"86155793", "江西省上饶市",
"861820064", "广东省东莞市",
"861559394", "甘肃省兰州市",
"86130567", "浙江省宁波市",
"861870472", "内蒙古包头市",
"861593092", "河北省保定市",
"861336070", "广东省湛江市",
"861560690", "福建省厦门市",
"861771610", "四川省成都市",
"861398454", "贵州省遵义市",
"861568231", "四川省泸州市",
"861880698", "云南省怒江傈僳族自治州",
"861303042", "内蒙古呼伦贝尔市",
"86137135", "广东省深圳市",
"861800425", "辽宁省丹东市",
"861776781", "吉林省白山市",
"861760355", "山西省长治市",
"861867515", "广东省东莞市",
"861843406", "山西省临汾市",
"861770670", "浙江省衢州市",
"861477082", "江西省赣州市",
"86152976", "河北省衡水市",
"86156398", "河南省三门峡市",
"861336507", "福建省龙岩市",
"86130324", "辽宁省沈阳市",
"861709417", "广东省珠海市",
"861773738", "河南省驻马店市",
"861323773", "广西桂林市",
"861850463", "黑龙江省七台河市",
"861821462", "云南省昆明市",
"861890395", "河南省漯河市",
"86181877", "云南省玉溪市",
"861310256", "河北省邢台市",
"861376572", "贵州省六盘水市",
"861529855", "江苏省盐城市",
"861470649", "山东省滨州市",
"861558020", "湖南省湘潭市",
"861390973", "青海省黄南藏族自治州",
"861774433", "四川省成都市",
"861590452", "黑龙江省齐齐哈尔市",
"861882663", "广东省清远市",
"861319414", "辽宁省本溪市",
"861898677", "湖北省宜昌市",
"861337377", "河南省洛阳市",
"861776843", "江苏省南通市",
"861565096", "青海省西宁市",
"861551829", "河南省驻马店市",
"861378813", "广西桂林市",
"861303706", "山西省阳泉市",
"861889854", "广东省广州市",
"861346688", "山西省晋中市",
"861356563", "新疆昌吉回族自治州",
"86150993", "新疆乌鲁木齐市",
"861318739", "湖南省邵阳市",
"86157704", "云南省丽江市",
"861882797", "江西省赣州市",
"86152715", "湖北省黄冈市",
"861306525", "辽宁省盘锦市",
"86150330", "河北省邯郸市",
"86132812", "四川省成都市",
"861341932", "四川省攀枝花市",
"861872982", "陕西省榆林市",
"861827092", "江西省九江市",
"8618426", "重庆市",
"861852570", "辽宁省盘锦市",
"861336762", "广西柳州市",
"86182729", "河南省驻马店市",
"861775922", "福建省厦门市",
"861559359", "甘肃省金昌市",
"861324590", "内蒙古鄂尔多斯市",
"861306491", "江苏省淮安市",
"86177476", "内蒙古赤峰市",
"861881324", "广东省中山市",
"861863471", "山西省临汾市",
"861853023", "河南省新乡市",
"861503698", "河南省洛阳市",
"861301049", "福建省宁德市",
"861571990", "新疆昌吉回族自治州",
"861302656", "山东省潍坊市",
"861583425", "山西省朔州市",
"861760910", "陕西省咸阳市",
"861566009", "河南省周口市",
"861380781", "广西南宁市",
"861596441", "山东省菏泽市",
"861328531", "山东省济南市",
"861529270", "新疆和田地区",
"861310548", "山东省泰安市",
"861839380", "甘肃省甘南藏族自治州",
"86188688", "浙江省杭州市",
"861387214", "湖北省黄石市",
"86157317", "河北省沧州市",
"861308840", "内蒙古赤峰市",
"861319760", "广西防城港市",
"861308364", "河南省洛阳市",
"861470941", "甘肃省甘南藏族自治州",
"861800591", "福建省福州市",
"861853537", "山西省朔州市",
"861350779", "广西北海市",
"861329113", "江苏省南通市",
"861367838", "四川省德阳市",
"86138747", "湖南省永州市",
"861780572", "浙江省湖州市",
"861599902", "新疆巴音郭楞蒙古自治州",
"861860877", "云南省玉溪市",
"861581903", "广东省梅州市",
"86184397", "河南省驻马店市",
"86177205", "湖北省武汉市",
"861804107", "辽宁省沈阳市",
"861535434", "河北省秦皇岛市",
"861593332", "河北省保定市",
"861806977", "浙江省杭州市",
"861321445", "吉林省通化市",
"861528045", "福建省泉州市",
"861319926", "黑龙江省伊春市",
"86186856", "贵州省铜仁地区",
"86137982", "广东省深圳市",
"861335114", "黑龙江省七台河市",
"861814838", "内蒙古呼和浩特市",
"861839957", "新疆阿克苏地区",
"86189315", "河北省唐山市",
"861518120", "四川省雅安市",
"861317150", "河北省唐山市",
"861881369", "广东省云浮市",
"86139254", "广东省佛山市",
"861500362", "青海省海东地区",
"861816448", "安徽省合肥市",
"86134089", "云南省红河哈尼族彝族自治州",
"861308329", "安徽省池州市",
"861351719", "湖北省武汉市",
"861377753", "浙江省金华市",
"861383345", "河北省石家庄市",
"861356831", "四川省眉山市",
"861709485", "浙江省杭州市",
"861335684", "山东省德州市",
"861529433", "甘肃省金昌市",
"861884027", "陕西省宝鸡市",
"86131644", "重庆市",
"861840898", "西藏日喀则地区",
"861525142", "江苏省无锡市",
"861576744", "广东省深圳市",
"861353670", "广东省梅州市",
"861371581", "广东省潮州市",
"861308277", "山东省泰安市",
"861886023", "河南省洛阳市",
"861304716", "湖北省宜昌市",
"861399524", "宁夏固原市",
"861368568", "安徽省阜阳市",
"861857777", "广西南宁市",
"86185388", "河南省洛阳市",
"86157525", "云南省红河哈尼族彝族自治州",
"86131483", "浙江省杭州市",
"861596046", "福建省宁德市",
"861350738", "湖南省娄底市",
"861521536", "山东省潍坊市",
"861529847", "江苏省扬州市",
"861304395", "河南省漯河市",
"861339962", "安徽省铜陵市",
"861538294", "广东省汕头市",
"861302146", "河北省邯郸市",
"86150431", "吉林省长春市",
"861360589", "浙江省金华市",
"861581177", "广东省云浮市",
"86189527", "江苏省扬州市",
"861511884", "广东省深圳市",
"861352637", "河南省驻马店市",
"861334692", "河南省三门峡市",
"861803185", "河北省石家庄市",
"861313505", "湖南省郴州市",
"86151632", "山东省枣庄市",
"861338475", "内蒙古通辽市",
"861770712", "湖北省孝感市",
"861317640", "山东省济南市",
"861780995", "新疆吐鲁番地区",
"861886537", "山东省济宁市",
"861810483", "内蒙古阿拉善盟",
"861771772", "河北省邢台市",
"861322310", "河北省邯郸市",
"86133009", "上海市",
"861855589", "安徽省六安市",
"861813747", "河南省郑州市",
"861875853", "浙江省绍兴市",
"861584648", "黑龙江省牡丹江市",
"861700932", "甘肃省兰州市",
"861809777", "新疆阿克苏地区",
"861327861", "云南省保山市",
"861760347", "山西省临汾市",
"861338441", "吉林省吉林市",
"861595785", "浙江省宁波市",
"861309501", "新疆乌鲁木齐市",
"861568619", "陕西省汉中市",
"861317628", "山东省滨州市",
"861860408", "辽宁省大连市",
"861589796", "湖北省襄樊市",
"861819181", "陕西省渭南市",
"861597236", "湖北省黄石市",
"861458516", "河南省洛阳市",
"861568189", "四川省达州市",
"861317432", "吉林省吉林市",
"861814378", "甘肃省兰州市",
"861352958", "云南省曲靖市",
"861786547", "山东省济宁市",
"861598762", "云南省大理白族自治州",
"86180882", "云南省昆明市",
"861348846", "陕西省西安市",
"861840399", "河南省驻马店市",
"861532790", "湖北省襄樊市",
"861367378", "河南省开封市",
"86138939", "甘肃省甘南藏族自治州",
"861572468", "辽宁省抚顺市",
"861800942", "甘肃省白银市",
"861390729", "湖北省孝感市",
"861536499", "山西省运城市",
"861321076", "山东省潍坊市",
"861768954", "西藏林芝地区",
"861342650", "江西省上饶市",
"861860337", "河北省秦皇岛市",
"861508223", "四川省乐山市",
"861599188", "陕西省咸阳市",
"861303734", "湖南省衡阳市",
"861898994", "西藏林芝地区",
"861325180", "吉林省长春市",
"861566043", "山东省济宁市",
"861562193", "内蒙古呼和浩特市",
"861337351", "河北省石家庄市",
"861339008", "辽宁省鞍山市",
"861538321", "河北省石家庄市",
"861510049", "河北省保定市",
"861761413", "辽宁省抚顺市",
"861599618", "江苏省淮安市",
"86153948", "云南省红河哈尼族彝族自治州",
"861772173", "江苏省盐城市",
"861355337", "广东省汕头市",
"86155508", "山东省泰安市",
"861373914", "江苏省南通市",
"861808163", "四川省凉山彝族自治州",
"861760473", "内蒙古乌海市",
"861871894", "广东省梅州市",
"861331535", "河北省秦皇岛市",
"861452578", "福建省泉州市",
"861555282", "山东省泰安市",
"861525544", "安徽省淮南市",
"861879840", "贵州省黔南布依族苗族自治州",
"861518148", "四川省宜宾市",
"861816200", "山东省威海市",
"861321471", "内蒙古呼和浩特市",
"861812729", "广东省云浮市",
"861370616", "江苏省无锡市",
"861528071", "福建省三明市",
"861781114", "宁夏固原市",
"861811980", "安徽省滁州市",
"86155516", "安徽省阜阳市",
"861470975", "青海省西宁市",
"861362486", "内蒙古赤峰市",
"861530704", "江西省抚州市",
"861459691", "新疆吐鲁番地区",
"86189159", "江苏省南京市",
"861772907", "陕西省西安市",
"861781684", "浙江省温州市",
"861773923", "河南省南阳市",
"86186650", "广东省广州市",
"86185540", "山东省烟台市",
"861358692", "浙江省宁波市",
"861876455", "山东省滨州市",
"861568024", "四川省泸州市",
"86183900", "湖南省岳阳市",
"861367054", "广东省汕头市",
"861361424", "辽宁省本溪市",
"861325060", "广东省惠州市",
"861452539", "山东省临沂市",
"861839422", "甘肃省天水市",
"86150575", "浙江省温州市",
"861378777", "湖南省郴州市",
"861811563", "江苏省盐城市",
"861512992", "陕西省渭南市",
"861338046", "广东省潮州市",
"861537597", "福建省莆田市",
"861322179", "浙江省丽水市",
"861531446", "山东省烟台市",
"86185522", "江苏省连云港市",
"861586996", "湖南省永州市",
"861320411", "辽宁省大连市",
"86186737", "湖南省益阳市",
"861814339", "湖南省衡阳市",
"861889398", "甘肃省天水市",
"861384872", "内蒙古包头市",
"861821997", "甘肃省酒泉市",
"861881868", "广东省深圳市",
"861554294", "辽宁省葫芦岛市",
"861812764", "广东省梅州市",
"861518217", "四川省成都市",
"861505865", "浙江省金华市",
"861338702", "江西省九江市",
"861894965", "安徽省淮南市",
"861323817", "辽宁省鞍山市",
"861308828", "四川省自贡市",
"861898141", "四川省内江市",
"861507858", "广西河池市",
"861370461", "黑龙江省齐齐哈尔市",
"861324266", "广东省汕尾市",
"861819061", "四川省南充市",
"861331326", "河北省廊坊市",
"861458145", "浙江省温州市",
"86136022", "广东省广州市",
"861361469", "黑龙江省佳木斯市",
"86131437", "广东省广州市",
"861367339", "河南省郑州市",
"86185295", "广东省深圳市",
"861863445", "山西省长治市",
"861454961", "黑龙江省鸡西市",
"861550694", "福建省南平市",
"861815305", "河南省驻马店市",
"861880080", "四川省遂宁市",
"861771405", "江苏省苏州市",
"861550951", "宁夏银川市",
"86137210", "安徽省合肥市",
"861360022", "广东省肇庆市",
"861596475", "山东省济宁市",
"861370555", "安徽省马鞍山市",
"86181762", "广西南宁市",
"86136040", "辽宁省沈阳市",
"861319508", "宁夏银川市",
"861831613", "广东省阳江市",
"861570904", "新疆博尔塔拉蒙古自治州",
"861519043", "江苏省扬州市",
"861530549", "山东省临沂市",
"861826038", "江苏省连云港市",
"861579499", "福建省厦门市",
"861340820", "四川省泸州市",
"861318685", "浙江省宁波市",
"86182660", "山东省枣庄市",
"861804371", "吉林省长春市",
"861318115", "山东省日照市",
"861379890", "广东省东莞市",
"861305532", "福建省泉州市",
"861577110", "湖北省襄樊市",
"861815218", "甘肃省白银市",
"861502520", "云南省红河哈尼族彝族自治州",
"861399586", "湖北省孝感市",
"861338977", "青海省海西蒙古族藏族自治州",
"861705309", "海南省海口市",
"861564976", "河南省三门峡市",
"861398944", "浙江省金华市",
"86158551", "安徽省合肥市",
"861301146", "河北省秦皇岛市",
"861598163", "吉林省通化市",
"861565154", "江苏省盐城市",
"861527160", "湖北省黄冈市",
"861380935", "甘肃省武威市",
"861458438", "河南省平顶山市",
"861562792", "广东省汕尾市",
"861340349", "山西省朔州市",
"861354659", "山西省运城市",
"861320370", "河南省郑州市",
"861399155", "陕西省安康市",
"861563367", "河北省石家庄市",
"861866611", "广东省珠海市",
"86157648", "内蒙古巴彦淖尔市",
"861834430", "广东省广州市",
"861300992", "黑龙江省绥化市",
"861458622", "湖北省十堰市",
"861383410", "山西省运城市",
"861360566", "安徽省蚌埠市",
"861351637", "山东省枣庄市",
"86132452", "江苏省南京市",
"861815147", "江苏省淮安市",
"861357262", "陕西省汉中市",
"86158870", "云南省昆明市",
"861870323", "河北省张家口市",
"861827220", "湖北省荆州市",
"861861780", "河北省保定市",
"861479901", "新疆石河子市",
"861862929", "陕西省西安市",
"86135706", "广东省珠海市",
"861458307", "江西省新余市",
"861813850", "广东省佛山市",
"861350259", "广东省汕尾市",
"861772772", "广东省东莞市",
"86139785", "广西玉林市",
"86137663", "江西省赣州市",
"86159882", "浙江省绍兴市",
"86135718", "陕西省西安市",
"861709987", "广东省珠海市",
"861881386", "广东省深圳市",
"861779016", "四川省凉山彝族自治州",
"861508141", "河北省石家庄市",
"861876638", "山东省烟台市",
"861839455", "甘肃省武威市",
"861363495", "辽宁省朝阳市",
"861871982", "甘肃省兰州市",
"8618416", "山东省济南市",
"86187600", "福建省龙岩市",
"861780856", "贵州省铜仁地区",
"861851570", "四川省德阳市",
"86156341", "山东省济南市",
"861539392", "云南省德宏傣族景颇族自治州",
"861321947", "四川省德阳市",
"861394819", "内蒙古呼和浩特市",
"861315474", "内蒙古乌兰察布市",
"86136313", "广东省广州市",
"861806475", "浙江省绍兴市",
"861850510", "江苏省无锡市",
"861368700", "江西省南昌市",
"861302049", "内蒙古通辽市",
"861572990", "新疆伊犁哈萨克自治州",
"861301656", "江苏省淮安市",
"861839561", "河北省石家庄市",
"861520807", "西藏那曲地区",
"8617783", "重庆市",
"861381241", "江苏省宿迁市",
"861370522", "江苏省徐州市",
"861858642", "贵州省遵义市",
"861354149", "四川省泸州市",
"861301515", "内蒙古包头市",
"861315012", "甘肃省庆阳市",
"861709350", "河南省南阳市",
"861869420", "河北省保定市",
"861360055", "浙江省嘉兴市",
"861322445", "吉林省通化市",
"86150159", "广东省珠海市",
"861556130", "内蒙古呼和浩特市",
"861771252", "江苏省盐城市",
"861846040", "江西省萍乡市",
"861577878", "广西玉林市",
"86131521", "陕西省西安市",
"861318821", "辽宁省本溪市",
"861769307", "甘肃省酒泉市",
"861346775", "湖南省衡阳市",
"861515295", "江苏省泰州市",
"861335626", "山东省德州市",
"861589632", "江苏省宿迁市",
"861525709", "浙江省嘉兴市",
"861318546", "浙江省湖州市",
"861556819", "吉林省辽源市",
"861591633", "广东省珠海市",
"861589208", "福建省莆田市",
"861854304", "吉林省白城市",
"861815657", "安徽省合肥市",
"861365510", "江苏省盐城市",
"861589428", "云南省玉溪市",
"861769622", "山西省运城市",
"86189575", "浙江省绍兴市",
"86132603", "北京市",
"861333714", "内蒙古兴安盟",
"861570588", "浙江省丽水市",
"861882369", "广东省河源市",
"86139154", "江苏省苏州市",
"861470343", "山西省阳泉市",
"861596977", "山东省德州市",
"861803332", "广东省韶关市",
"861320689", "黑龙江省牡丹江市",
"86155376", "河南省信阳市",
"861361486", "内蒙古赤峰市",
"86155887", "山东省济宁市",
"861457180", "浙江省杭州市",
"86158996", "广东省东莞市",
"861346741", "湖南省怀化市",
"861848922", "西藏日喀则地区",
"86189259", "广东省佛山市",
"861771907", "河南省平顶山市",
"861847473", "湖南省怀化市",
"861336163", "江西省南昌市",
"861316498", "浙江省宁波市",
"861300826", "辽宁省锦州市",
"861359773", "湖北省黄石市",
"861320119", "新疆喀什地区",
"861883395", "河北省唐山市",
"861322471", "内蒙古包头市",
"861589440", "云南省德宏傣族景颇族自治州",
"861536944", "河北省沧州市",
"861809902", "新疆哈密地区",
"861334087", "四川省德阳市",
"861328668", "广东省深圳市",
"861568737", "云南省昆明市",
"861828212", "四川省巴中市",
"861869448", "陕西省安康市",
"861537629", "山东省滨州市",
"861532446", "安徽省滁州市",
"861454557", "新疆伊犁哈萨克自治州",
"861550567", "安徽省亳州市",
"861520439", "吉林省白山市",
"861472915", "陕西省安康市",
"86182801", "四川省成都市",
"861362424", "辽宁省大连市",
"861894467", "黑龙江省鸡西市",
"861890362", "黑龙江省齐齐哈尔市",
"861815938", "福建省莆田市",
"861320830", "四川省泸州市",
"861334736", "湖南省常德市",
"86150315", "河北省唐山市",
"86152730", "湖南省岳阳市",
"861331384", "福建省厦门市",
"861801099", "安徽省阜阳市",
"861882291", "广东省揭阳市",
"861830721", "湖北省襄樊市",
"861510146", "甘肃省甘南藏族自治州",
"861869382", "甘肃省天水市",
"861550353", "山西省阳泉市",
"861313013", "辽宁省本溪市",
"861810598", "福建省三明市",
"861454363", "山东省青岛市",
"86133682", "重庆市",
"86153272", "湖北省武汉市",
"86158029", "陕西省西安市",
"861870800", "西藏拉萨市",
"86187806", "四川省宜宾市",
"861877087", "江西省赣州市",
"861329712", "湖北省荆门市",
"86152657", "山东省济宁市",
"861595931", "福建省宁德市",
"86158469", "黑龙江省大庆市",
"86176255", "江苏省苏州市",
"861327042", "江苏省无锡市",
"861804831", "内蒙古阿拉善盟",
"861772405", "广东省潮州市",
"861537664", "山东省枣庄市",
"861858273", "四川省眉山市",
"861562860", "山东省日照市",
"861868001", "广东省佛山市",
"861857902", "江西省景德镇市",
"86132724", "湖南省长沙市",
"861332326", "河北省廊坊市",
"861898449", "贵州省黔东南苗族侗族自治州",
"861362469", "黑龙江省双鸭山市",
"861530503", "福建省泉州市",
"861772225", "广东省揭阳市",
"861344887", "云南省昆明市",
"861333005", "江西省南昌市",
"861827248", "湖北省武汉市",
"861470309", "河北省廊坊市",
"86139369", "黑龙江省大庆市",
"861370089", "河南省许昌市",
"86156932", "甘肃省定西市",
"861312362", "贵州省遵义市",
"861787651", "广东省茂名市",
"861351958", "宁夏银川市",
"86178390", "河南省商丘市",
"86183004", "山东省临沂市",
"861390563", "安徽省宣城市",
"861313797", "河南省三门峡市",
"861536191", "广东省湛江市",
"86147989", "海南省海口市",
"861376962", "云南省文山壮族苗族自治州",
"86150527", "江苏省宿迁市",
"861856716", "河南省南阳市",
"861705808", "上海市",
"861360290", "广东省韶关市",
"861368631", "山东省威海市",
"861874953", "河南省商丘市",
"861369726", "湖北省荆州市",
"86187818", "四川省达州市",
"861877167", "湖北省孝感市",
"861477195", "湖北省宜昌市",
"861571468", "黑龙江省鹤岗市",
"86138286", "广东省茂名市",
"861582949", "陕西省宝鸡市",
"86158676", "浙江省台州市",
"861303533", "湖北省荆州市",
"861313663", "黑龙江省齐齐哈尔市",
"861322076", "山东省潍坊市",
"861364690", "福建省三明市",
"861568481", "新疆阿克苏地区",
"861885019", "福建省厦门市",
"861539744", "浙江省绍兴市",
"861390980", "辽宁省鞍山市",
"861361081", "辽宁省沈阳市",
"861819489", "新疆昌吉回族自治州",
"861804345", "吉林省四平市",
"861369960", "四川省绵阳市",
"861323780", "广西南宁市",
"861868406", "四川省南充市",
"861521418", "甘肃省白银市",
"861346402", "辽宁省沈阳市",
"861303027", "广东省云浮市",
"861802196", "江苏省连云港市",
"861476889", "山东省滨州市",
"861806046", "福建省莆田市",
"86134602", "河南省郑州市",
"86182866", "贵州省铜仁地区",
"861770683", "浙江省嘉兴市",
"861450518", "吉林省通化市",
"86181649", "新疆乌鲁木齐市",
"861377642", "江苏省扬州市",
"861332535", "陕西省安康市",
"861583318", "河北省衡水市",
"861337953", "陕西省延安市",
"861537472", "内蒙古包头市",
"86170770", "广西南宁市",
"861520478", "内蒙古巴彦淖尔市",
"861771173", "湖南省长沙市",
"861390357", "山西省临汾市",
"861568166", "四川省巴中市",
"861594973", "山东省淄博市",
"86189431", "吉林省长春市",
"861593556", "山西省运城市",
"861521232", "安徽省黄山市",
"861832994", "陕西省西安市",
"861346612", "云南省曲靖市",
"861453486", "内蒙古乌海市",
"861889799", "江西省萍乡市",
"86132843", "河北省保定市",
"861321387", "河南省信阳市",
"861335936", "甘肃省张掖市",
"861358010", "广东省韶关市",
"86153065", "浙江省杭州市",
"861825298", "江苏省苏州市",
"86186357", "山西省临汾市",
"861380743", "湖南省永州市",
"86130659", "浙江省金华市",
"86180305", "四川省成都市",
"861550470", "内蒙古呼伦贝尔市",
"86153425", "湖北省孝感市",
"861810702", "江西省九江市",
"86152811", "四川省绵阳市",
"861860777", "广西钦州市",
"861709347", "广东省深圳市",
"861894570", "黑龙江省大兴安岭地区",
"861454528", "广西河池市",
"861350879", "云南省普洱市",
"861383487", "山西省临汾市",
"861828479", "四川省遂宁市",
"861769932", "新疆和田地区",
"86139727", "湖北省黄冈市",
"861319860", "四川省攀枝花市",
"861891304", "江苏省南京市",
"861593405", "山西省长治市",
"861808075", "四川省广元市",
"861311390", "广东省中山市",
"861319344", "河南省许昌市",
"861594731", "内蒙古呼和浩特市",
"861871488", "安徽省安庆市",
"86136583", "重庆市",
"861324084", "内蒙古呼伦贝尔市",
"861308740", "云南省大理白族自治州",
"861577187", "陕西省宝鸡市",
"861810046", "内蒙古呼和浩特市",
"86135454", "湖北省孝感市",
"861392441", "广东省清远市",
"861321950", "四川省宜宾市",
"861519469", "河南省驻马店市",
"861329641", "山东省济南市",
"861582670", "湖北省恩施土家族苗族自治州",
"861868461", "湖南省常德市",
"861593225", "河北省唐山市",
"861330596", "福建省泉州市",
"86187822", "四川省成都市",
"861862678", "吉林省白城市",
"861539676", "江苏省扬州市",
"861776930", "湖南省岳阳市",
"861533397", "河南省信阳市",
"861470560", "安徽省合肥市",
"861813433", "河北省保定市",
"861379446", "广东省深圳市",
"861355777", "广西钦州市",
"861568101", "四川省德阳市",
"861336862", "贵州省遵义市",
"861893165", "河北省廊坊市",
"861598790", "云南省昭通市",
"861309589", "浙江省金华市",
"86187840", "四川省绵阳市",
"861479748", "山西省运城市",
"861327761", "湖北省随州市",
"861809877", "安徽省六安市",
"861875753", "浙江省绍兴市",
"861869591", "河南省新乡市",
"861813847", "广东省佛山市",
"861333551", "安徽省合肥市",
"861378408", "河北省张家口市",
"861300498", "福建省龙岩市",
"861316826", "广东省潮州市",
"861351927", "宁夏吴忠市",
"861471607", "广东省东莞市",
"861517271", "湖北省鄂州市",
"861805172", "江苏省盐城市",
"861365587", "浙江省温州市",
"861854548", "黑龙江省伊春市",
"861359931", "福建省南平市",
"861569362", "甘肃省白银市",
"861772615", "湖南省衡阳市",
"861585119", "江苏省宿迁市",
"861875125", "江苏省连云港市",
"861760485", "内蒙古兴安盟",
"861830900", "新疆巴音郭楞蒙古自治州",
"861556637", "辽宁省营口市",
"861475655", "河北省衡水市",
"86188547", "山东省济宁市",
"861772185", "四川省德阳市",
"861582888", "四川省遂宁市",
"861865838", "浙江省温州市",
"861886999", "浙江省台州市",
"861453081", "安徽省合肥市",
"861316541", "山东省济南市",
"861390237", "广东省云浮市",
"861850587", "浙江省丽水市",
"861779730", "青海省海东地区",
"861307931", "甘肃省嘉峪关市",
"86186773", "广西桂林市",
"861897278", "湖北省黄石市",
"861806598", "福建省三明市",
"861329151", "浙江省嘉兴市",
"861590382", "河南省商丘市",
"861707393", "河南省濮阳市",
"861303058", "江西省抚州市",
"861506146", "江苏省无锡市",
"861527017", "江西省九江市",
"861780276", "湖北省恩施土家族苗族自治州",
"861810441", "吉林省长春市",
"861367779", "广西北海市",
"86131473", "广东省东莞市",
"861478042", "四川省成都市",
"861302463", "浙江省绍兴市",
"86746", "湖南省永州市",
"861879728", "青海省海南藏族自治州",
"861390328", "河北省衡水市",
"86132529", "辽宁省大连市",
"861868066", "广东省深圳市",
"861512960", "陕西省榆林市",
"861389504", "宁夏固原市",
"861363578", "湖北省襄樊市",
"86185378", "河南省开封市",
"861537219", "浙江省衢州市",
"861576844", "广东省湛江市",
"861840798", "江西省景德镇市",
"861325092", "浙江省湖州市",
"86151244", "吉林省吉林市",
"861370284", "广东省江门市",
"86134626", "河南省南阳市",
"861700655", "山东省潍坊市",
"861555645", "安徽省合肥市",
"86131562", "山东省青岛市",
"861509088", "湖北省宜昌市",
"861390340", "山西省太原市",
"861879740", "湖南省湘潭市",
"861350054", "安徽省宣城市",
"861811415", "江苏省徐州市",
"861335216", "辽宁省丹东市",
"861338483", "内蒙古阿拉善盟",
"861390864", "湖北省武汉市",
"861379075", "广东省惠州市",
"861870568", "安徽省阜阳市",
"861882500", "广东省中山市",
"861373136", "河北省衡水市",
"861859356", "福建省龙岩市",
"861819143", "陕西省渭南市",
"861346908", "湖南省长沙市",
"861538633", "湖南省湘西土家族苗族自治州",
"861394958", "河南省驻马店市",
"861864305", "吉林省白城市",
"86134842", "浙江省宁波市",
"861362043", "广东省湛江市",
"861320453", "黑龙江省牡丹江市",
"861520972", "青海省海东地区",
"861839506", "宁夏固原市",
"861310199", "江苏省南通市",
"86130922", "江苏省泰州市",
"861471480", "广东省云浮市",
"861810475", "内蒙古通辽市",
"861500390", "河南省平顶山市",
"861877010", "江西省鹰潭市",
"861882077", "广东省广州市",
"861390829", "四川省巴中市",
"861332499", "云南省普洱市",
"86155825", "山西省长治市",
"861854520", "黑龙江省齐齐哈尔市",
"861350339", "河北省邢台市",
"86156360", "黑龙江省哈尔滨市",
"861348746", "湖南省永州市",
"861368921", "陕西省延安市",
"861558052", "湖南省湘西土家族苗族自治州",
"861590420", "辽宁省辽阳市",
"861336790", "江西省新余市",
"861827060", "江西省宜春市",
"861566081", "河南省安阳市",
"861539581", "浙江省杭州市",
"861550913", "陕西省渭南市",
"861556958", "新疆喀什地区",
"861457117", "湖北省随州市",
"861319792", "江西省九江市",
"861557088", "湖南省长沙市",
"861812917", "新疆阿克苏地区",
"861589896", "山东省烟台市",
"861474133", "辽宁省沈阳市",
"861883030", "河北省张家口市",
"861323093", "河北省秦皇岛市",
"861334010", "江西省鹰潭市",
"861831882", "广东省惠州市",
"861700516", "江苏省徐州市",
"861571962", "甘肃省定西市",
"861392475", "广东省汕头市",
"86132051", "江苏省苏州市",
"861458212", "安徽省铜陵市",
"861476137", "江苏省苏州市",
"86157610", "贵州省贵阳市",
"861700145", "江苏省扬州市",
"861479720", "山西省太原市",
"861897827", "广西河池市",
"861350378", "河南省开封市",
"86145801", "江苏省苏州市",
"861334660", "河南省商丘市",
"861855501", "安徽省合肥市",
"861892199", "江苏省苏州市",
"861330260", "广东省东莞市",
"861308728", "湖南省邵阳市",
"861351318", "河北省衡水市",
"86758", "广东省肇庆市",
"861880594", "福建省莆田市",
"861595621", "安徽省铜陵市",
"861536384", "广东省佛山市",
"861826274", "江苏省淮安市",
"861876940", "山东省烟台市",
"861857408", "河南省新乡市",
"861812340", "四川省巴中市",
"86132157", "海南省海口市",
"86153182", "山东省威海市",
"861840484", "内蒙古乌兰察布市",
"861359211", "河南省开封市",
"86187646", "山东省潍坊市",
"861805253", "江苏省常州市",
"861858711", "云南省红河哈尼族彝族自治州",
"861337313", "河北省张家口市",
"861344139", "辽宁省锦州市",
"861809408", "福建省泉州市",
"861366636", "山东省潍坊市",
"861761451", "黑龙江省哈尔滨市",
"861378877", "广西柳州市",
"861524909", "陕西省西安市",
"861316992", "广东省深圳市",
"861838548", "贵州省黔南布依族苗族自治州",
"861559758", "青海省海南藏族自治州",
"86189495", "安徽省芜湖市",
"861831223", "广东省梅州市",
"86150585", "浙江省金华市",
"861372392", "山东省德州市",
"861454540", "新疆阿克苏地区",
"861705560", "吉林省长春市",
"86182641", "山东省济南市",
"861390917", "陕西省宝鸡市",
"861326352", "黑龙江省齐齐哈尔市",
"861587031", "贵州省六盘水市",
"861815432", "湖北省武汉市",
"861771332", "黑龙江省齐齐哈尔市",
"861537939", "甘肃省陇南市",
"86184690", "云南省曲靖市",
"861815628", "安徽省铜陵市",
"861509168", "陕西省渭南市",
"861452997", "内蒙古鄂尔多斯市",
"861331944", "江西省九江市",
"861345105", "湖北省黄石市",
"861339990", "新疆克拉玛依市",
"861511498", "陕西省西安市",
"861318098", "吉林省四平市",
"861817197", "湖北省荆门市",
"861770459", "黑龙江省大庆市",
"861772872", "广东省清远市",
"861800420", "辽宁省鞍山市",
"86136421", "天津市",
"86177951", "宁夏银川市",
"861819742", "青海省黄南藏族自治州",
"86139775", "广西玉林市",
"861389703", "青海省黄南藏族自治州",
"861860257", "江苏省常州市",
"861770675", "浙江省绍兴市",
"861524341", "河北省唐山市",
"861803772", "河南省商丘市",
"861760350", "山西省忻州市",
"861867510", "广东省韶关市",
"861823043", "河北省秦皇岛市",
"861317657", "山东省淄博市",
"86153477", "广西柳州市",
"861340966", "湖北省随州市",
"861876506", "山东省烟台市",
"86158880", "浙江省宁波市",
"861700307", "广东省惠州市",
"861870631", "山东省威海市",
"861594985", "山东省潍坊市",
"86136018", "上海市",
"861314510", "江苏省苏州市",
"86137248", "广东省广州市",
"861510244", "辽宁省丹东市",
"861820436", "吉林省白城市",
"86181721", "广西柳州市",
"861771185", "宁夏中卫市",
"861700438", "江苏省苏州市",
"86178697", "云南省昆明市",
"861559919", "贵州省安顺市",
"861334376", "河南省信阳市",
"861366792", "江西省九江市",
"861587518", "广东省阳江市",
"861771615", "四川省成都市",
"861817012", "江西省赣州市",
"861385131", "江苏省盐城市",
"86131132", "广东省东莞市",
"861336075", "广东省茂名市",
"861560695", "福建省厦门市",
"861853444", "山西省晋中市",
"861839317", "甘肃省天水市",
"861308496", "广西玉林市",
"861370406", "辽宁省锦州市",
"861810149", "江苏省常州市",
"861585666", "安徽省滁州市",
"861333967", "贵州省毕节地区",
"86139916", "陕西省渭南市",
"861470708", "江西省景德镇市",
"86183859", "贵州省铜仁地区",
"861370226", "广东省佛山市",
"861324421", "吉林省吉林市",
"861306520", "辽宁省铁岭市",
"861310304", "河北省承德市",
"861337231", "浙江省嘉兴市",
"861890390", "河南省平顶山市",
"86151144", "吉林省白城市",
"861523842", "河南省三门峡市",
"861454906", "湖北省襄樊市",
"86131804", "河北省石家庄市",
"861371744", "广东省东莞市",
"861529850", "江苏省泰州市",
"861598446", "四川省宜宾市",
"861364474", "内蒙古乌兰察布市",
"861888203", "四川省自贡市",
"861329459", "山西省运城市",
"861819006", "四川省德阳市",
"861355068", "四川省资阳市",
"861318242", "江苏省常州市",
"86185518", "江苏省南京市",
"861319193", "河北省沧州市",
"861339468", "黑龙江省鹤岗市",
"861333814", "江苏省扬州市",
"86189585", "浙江省台州市",
"86152203", "广东省东莞市",
"86150495", "内蒙古呼伦贝尔市",
"861599408", "河南省许昌市",
"861309566", "浙江省绍兴市",
"861319636", "陕西省宝鸡市",
"861831651", "广东省中山市",
"861873643", "河南省漯河市",
"861831994", "广东省阳江市",
"861325220", "浙江省湖州市",
"861839940", "新疆阿克苏地区",
"861369992", "新疆吐鲁番地区",
"861833952", "河南省新乡市",
"861882946", "陕西省汉中市",
"861457092", "江苏省连云港市",
"86139908", "四川省南充市",
"861816942", "湖南省长沙市",
"861338598", "福建省三明市",
"861318721", "湖南省长沙市",
"861526445", "山东省潍坊市",
"861859532", "河南省驻马店市",
"861398535", "贵州省毕节地区",
"861858285", "四川省成都市",
"861592923", "陕西省渭南市",
"861519486", "河北省石家庄市",
"861868124", "四川省绵阳市",
"861593907", "河南省商丘市",
"861860618", "江苏省徐州市",
"861391441", "江苏省泰州市",
"861380544", "山东省济南市",
"861507827", "广西柳州市",
"861304030", "吉林省四平市",
"861308857", "内蒙古乌兰察布市",
"861898782", "云南省楚雄彝族自治州",
"861359785", "湖北省十堰市",
"861506049", "福建省泉州市",
"861520707", "江西省赣州市",
"861892304", "广东省梅州市",
"861775208", "甘肃省庆阳市",
"861872488", "云南省普洱市",
"86157587", "云南省文山壮族苗族自治州",
"861568229", "四川省达州市",
"861811237", "江苏省无锡市",
"861453469", "黑龙江省鸡西市",
"861814259", "四川省宜宾市",
"861501491", "广东省珠海市",
"861308091", "陕西省西安市",
"861893559", "青海省海西蒙古族藏族自治州",
"861580610", "江苏省镇江市",
"861357566", "浙江省衢州市",
"861392149", "江苏省南通市",
"861353177", "广东省中山市",
"861805621", "安徽省铜陵市",
"861777521", "安徽省淮南市",
"861830546", "山东省东营市",
"861373039", "河北省邢台市",
"861840206", "广东省湛江市",
"861852467", "辽宁省阜新市",
"861300960", "新疆昌吉回族自治州",
"861452495", "内蒙古通辽市",
"861879496", "甘肃省定西市",
"861896656", "陕西省咸阳市",
"861888249", "四川省绵阳市",
"861598075", "福建省厦门市",
"861853263", "河北省张家口市",
"861803405", "河北省唐山市",
"861768314", "四川省德阳市",
"861589955", "广东省佛山市",
"861366860", "山东省菏泽市",
"861317979", "江苏省扬州市",
"861707542", "福建省漳州市",
"861366344", "山西省晋中市",
"861787613", "广东省湛江市",
"861527192", "湖北省武汉市",
"861840426", "辽宁省盘锦市",
"861807134", "湖北省恩施土家族苗族自治州",
"861390415", "辽宁省丹东市",
"86132257", "安徽省安庆市",
"861811340", "四川省绵阳市",
"86187307", "河北省沧州市",
"86133672", "湖北省武汉市",
"861882768", "湖北省黄石市",
"861870700", "江西省新余市",
"861808790", "云南省普洱市",
"86185459", "黑龙江省大庆市",
"86181793", "江西省上饶市",
"861352318", "河南省焦作市",
"861380142", "江苏省泰州市",
"861829691", "江西省萍乡市",
"861829954", "新疆吐鲁番地区",
"861320730", "湖南省岳阳市",
"861346526", "山东省东营市",
"86147699", "山东省临沂市",
"861561984", "陕西省汉中市",
"86180654", "福建省泉州市",
"861705381", "湖北省武汉市",
"861880793", "江西省上饶市",
"861334836", "福建省龙岩市",
"861555524", "安徽省宣城市",
"861566424", "河南省信阳市",
"861309290", "陕西省宝鸡市",
"861770151", "江苏省无锡市",
"861576676", "广东省揭阳市",
"861832403", "新疆和田地区",
"861568837", "新疆喀什地区",
"861348490", "陕西省西安市",
"861375167", "广东省揭阳市",
"861336446", "吉林省长春市",
"861323678", "辽宁省盘锦市",
"861811829", "江苏省盐城市",
"861504570", "黑龙江省大兴安岭地区",
"861332944", "黑龙江省佳木斯市",
"861343705", "江西省宜春市",
"861823009", "河北省邢台市",
"861359873", "河南省新乡市",
"861300726", "江西省九江市",
"861313456", "黑龙江省黑河市",
"861591294", "云南省楚雄彝族自治州",
"86184074", "湖南省长沙市",
"861588144", "四川省达州市",
"86159305", "河北省唐山市",
"861346841", "山东省淄博市",
"861839928", "新疆伊犁哈萨克自治州",
"86155386", "河南省周口市",
"861880667", "广东省茂名市",
"861325248", "浙江省台州市",
"861337911", "陕西省延安市",
"86155877", "湖北省襄樊市",
"861323639", "江苏省镇江市",
"861310491", "广东省湛江市",
"861475622", "河北省保定市",
"861522912", "陕西省榆林市",
"86156858", "贵州省六盘水市",
"861567567", "湖南省郴州市",
"861875152", "江苏省徐州市",
"861525781", "浙江省丽水市",
"86170780", "四川省成都市",
"861377285", "陕西省延安市",
"861342288", "广东省深圳市",
"861340748", "湖南省娄底市",
"861825042", "福建省泉州市",
"86157533", "山东省淄博市",
"861459314", "四川省达州市",
"861380652", "浙江省杭州市",
"861561508", "山东省烟台市",
"861361043", "广东省惠州市",
"861879091", "河南省漯河市",
"861317938", "江苏省镇江市",
"861810977", "青海省海西蒙古族藏族自治州",
"861331499", "福建省泉州市",
"861584930", "内蒙古乌海市",
"861788919", "西藏拉萨市",
"861346335", "河北省秦皇岛市",
"861599877", "山东省德州市",
"861786550", "山东省济宁市",
"861860902", "新疆哈密地区",
"861318673", "浙江省衢州市",
"861373078", "四川省内江市",
"861369826", "四川省凉山彝族自治州",
"861313051", "辽宁省丹东市",
"86158686", "浙江省台州市",
"861550311", "河北省石家庄市",
"86138276", "广东省阳江市",
"861770641", "浙江省杭州市",
"861705708", "北京市",
"861567353", "湖南省郴州市",
"861864938", "山西省吕梁市",
"861551371", "山西省阳泉市",
"861774241", "陕西省西安市",
"861369541", "山东省济南市",
"861572962", "四川省绵阳市",
"861871593", "河北省承德市",
"861336041", "广东省惠州市",
"861344787", "云南省昆明市",
"861319604", "吉林省长春市",
"861583382", "河北省衡水市",
"861325065", "广东省汕头市",
"861876450", "山东省菏泽市",
"861323931", "甘肃省兰州市",
"861884806", "内蒙古兴安盟",
"861872759", "湖北省荆门市",
"861874024", "辽宁省营口市",
"861538339", "河北省石家庄市",
"861321428", "辽宁省大连市",
"861831677", "广东省东莞市",
"861337069", "山东省淄博市",
"861361356", "山西省晋城市",
"861838776", "云南省玉溪市",
"861830617", "江苏省无锡市",
"861816205", "山东省济宁市",
"861517777", "广西南宁市",
"861521482", "新疆乌鲁木齐市",
"86151388", "河南省焦作市",
"861843461", "山西省晋城市",
"861305424", "黑龙江省齐齐哈尔市",
"861567702", "广西柳州市",
"861811985", "安徽省蚌埠市",
"861470970", "青海省海北藏族自治州",
"861477863", "广东省清远市",
"861338913", "陕西省渭南市",
"86156175", "河南省郑州市",
"861450582", "辽宁省阜新市",
"861458140", "浙江省台州市",
"861892336", "广东省珠海市",
"86186396", "河南省驻马店市",
"861368597", "福建省龙岩市",
"86437", "吉林省辽源市",
"861386641", "安徽省马鞍山市",
"861550483", "内蒙古阿拉善盟",
"861869452", "浙江省嘉兴市",
"861771400", "江苏省常州市",
"861534596", "福建省南平市",
"861863440", "山西省太原市",
"861815300", "河南省商丘市",
"861840867", "宁夏银川市",
"861331454", "黑龙江省佳木斯市",
"861370550", "安徽省滁州市",
"861569395", "甘肃省白银市",
"861874069", "陕西省铜川市",
"861596470", "山东省德州市",
"861812487", "广东省云浮市",
"861348539", "山西省忻州市",
"861858937", "云南省楚雄彝族自治州",
"861873901", "河南省南阳市",
"861843616", "河南省新乡市",
"86187765", "广西玉林市",
"861339276", "广东省佛山市",
"86189683", "浙江省宁波市",
"86185632", "山东省枣庄市",
"861894960", "安徽省马鞍山市",
"861871602", "河北省秦皇岛市",
"861505860", "浙江省台州市",
"86157509", "福建省泉州市",
"86184857", "贵州省毕节地区",
"861569716", "湖北省武汉市",
"86147712", "广东省广州市",
"861390731", "湖南省长沙市",
"861350633", "山东省日照市",
"8618462", "山东省济南市",
"861348578", "安徽省蚌埠市",
"86153681", "云南省昆明市",
"861474044", "辽宁省沈阳市",
"861327374", "河南省许昌市",
"861814321", "西藏拉萨市",
"861320943", "甘肃省白银市",
"861808956", "四川省广元市",
"861876534", "山东省德州市",
"861840914", "陕西省商洛市",
"861325556", "山东省青岛市",
"861377658", "江苏省徐州市",
"861317671", "山东省潍坊市",
"86156227", "广东省广州市",
"861342655", "江西省赣州市",
"861369467", "黑龙江省牡丹江市",
"861587993", "江西省新余市",
"86133414", "吉林省长春市",
"86177229", "广东省惠州市",
"861367321", "河北省石家庄市",
"8613489", "福建省泉州市",
"861595780", "浙江省丽水市",
"861896587", "福建省泉州市",
"861356237", "山东省日照市",
"861329788", "广西河池市",
"861363968", "河南省濮阳市",
"861776142", "四川省达州市",
"861829999", "新疆阿克苏地区",
"861841974", "甘肃省天水市",
"861590637", "山东省枣庄市",
"861830067", "河南省郑州市",
"861373399", "河南省漯河市",
"861500816", "四川省绵阳市",
"861556448", "山东省日照市",
"861538378", "河北省衡水市",
"86188332", "河北省保定市",
"861458650", "湖北省荆州市",
"861554838", "内蒙古赤峰市",
"861370434", "吉林省吉林市",
"8614776", "广东省广州市",
"861331530", "河北省张家口市",
"861879845", "贵州省六盘水市",
"861452846", "甘肃省张掖市",
"861824669", "黑龙江省齐齐哈尔市",
"861386151", "江苏省无锡市",
"86182705", "江西省宜春市",
"86182142", "云南省昭通市",
"861452521", "山东省济宁市",
"86152569", "安徽省合肥市",
"861478533", "贵州省毕节地区",
"86187714", "湖北省襄樊市",
"861390487", "黑龙江省鸡西市",
"86182698", "安徽省六安市",
"861310336", "河北省廊坊市",
"861827252", "河南省鹤壁市",
"861353641", "广东省湛江市",
"861325185", "吉林省通化市",
"861806311", "山东省威海市",
"86182120", "贵州省遵义市",
"861351942", "甘肃省甘南藏族自治州",
"861503667", "河南省商丘市",
"861454934", "江苏省南通市",
"861862873", "吉林省松原市",
"861359717", "广西南宁市",
"861518811", "云南省曲靖市",
"86151522", "江苏省无锡市",
"861304390", "河南省南阳市",
"861769128", "陕西省商洛市",
"861596913", "云南省曲靖市",
"861323211", "广东省云浮市",
"861570512", "江苏省连云港市",
"861590958", "宁夏银川市",
"861514199", "辽宁省葫芦岛市",
"86156334", "河北省唐山市",
"861589138", "陕西省宝鸡市",
"861821968", "甘肃省天水市",
"861881897", "广东省云浮市",
"861847417", "湖南省娄底市",
"861831959", "广东省惠州市",
"861362532", "山东省青岛市",
"861338233", "江苏省淮安市",
"861353675", "广东省河源市",
"861328564", "安徽省六安市",
"86177713", "湖北省黄冈市",
"86181516", "江苏省南京市",
"861315088", "内蒙古鄂尔多斯市",
"86150962", "湖南省怀化市",
"861356829", "四川省甘孜藏族自治州",
"861308331", "安徽省滁州市",
"861396339", "山东省东营市",
"861453916", "广东省惠州市",
"861363746", "湖南省永州市",
"8613764", "上海市",
"861377937", "新疆哈密地区",
"86135865", "浙江省宁波市",
"861780990", "新疆克拉玛依市",
"861317645", "山东省烟台市",
"86155762", "湖南省益阳市",
"861810694", "福建省福州市",
"86157635", "山东省聊城市",
"86136342", "浙江省温州市",
"861344004", "四川省达州市",
"861322315", "河北省唐山市",
"861870978", "青海省西宁市",
"861810951", "宁夏银川市",
"861471473", "广东省阳江市",
"861531507", "山东省临沂市",
"861820391", "河南省焦作市",
"861313077", "辽宁省铁岭市",
"861535461", "吉林省吉林市",
"861533769", "浙江省金华市",
"861322796", "陕西省延安市",
"861538879", "云南省普洱市",
"861328529", "江苏省宿迁市",
"861803180", "河北省衡水市",
"861527559", "山东省临沂市",
"861584709", "内蒙古鄂尔多斯市",
"861835101", "江苏省泰州市",
"861572856", "广东省深圳市",
"861551357", "山西省临汾市",
"861537568", "安徽省芜湖市",
"86189750", "湖南省岳阳市",
"861338470", "内蒙古呼伦贝尔市",
"861520562", "安徽省池州市",
"861313500", "湖南省岳阳市",
"861470413", "辽宁省抚顺市",
"861871918", "广东省惠州市",
"861356864", "四川省攀枝花市",
"861889553", "安徽省阜阳市",
"861760915", "陕西省安康市",
"861583420", "山西省晋城市",
"861310876", "云南省昆明市",
"861571995", "新疆伊犁哈萨克自治州",
"861839385", "甘肃省白银市",
"86137191", "广东省广州市",
"861580772", "广西柳州市",
"861351591", "福建省龙岩市",
"861846519", "宁夏吴忠市",
"861870939", "甘肃省陇南市",
"861308845", "内蒙古包头市",
"861869927", "新疆哈密地区",
"861534260", "湖北省武汉市",
"861857112", "湖北省孝感市",
"861319765", "广西玉林市",
"861881456", "黑龙江省黑河市",
"861863208", "河北省邢台市",
"861889274", "四川省广安市",
"861813996", "甘肃省陇南市",
"861771248", "江苏省苏州市",
"86139881", "云南省西双版纳傣族自治州",
"861458128", "安徽省六安市",
"861317586", "浙江省台州市",
"861852575", "辽宁省葫芦岛市",
"861311816", "四川省绵阳市",
"86152451", "黑龙江省哈尔滨市",
"861538838", "四川省达州市",
"861324595", "内蒙古赤峰市",
"861599713", "湖北省黄石市",
"86137097", "青海省西宁市",
"861559611", "陕西省榆林市",
"861450184", "山西省吕梁市",
"861342171", "广东省湛江市",
"861507181", "湖北省宜昌市",
"861317155", "河北省石家庄市",
"861518125", "四川省攀枝花市",
"86594", "福建省莆田市",
"861340419", "江苏省宿迁市",
"8618817", "上海市",
"861383340", "河北省承德市",
"861827173", "湖北省孝感市",
"86184736", "湖南省常德市",
"861315168", "江苏省镇江市",
"861709480", "浙江省宁波市",
"861778037", "四川省阿坝藏族羌族自治州",
"861809682", "新疆昌吉回族自治州",
"861454214", "河南省信阳市",
"861594917", "江苏省淮安市",
"861521849", "广东省清远市",
"861572497", "浙江省杭州市",
"86138552", "安徽省蚌埠市",
"861535066", "河北省唐山市",
"861317723", "湖北省襄樊市",
"861329494", "云南省昆明市",
"861327834", "吉林省延边朝鲜族自治州",
"86131985", "四川省成都市",
"861528040", "福建省福州市",
"861320909", "新疆博尔塔拉蒙古自治州",
"861477190", "湖北省襄樊市",
"861591738", "广东省广州市",
"861822746", "四川省甘孜藏族自治州",
"86156127", "河北省沧州市",
"861355813", "广西桂林市",
"861530376", "河南省信阳市",
"861874481", "贵州省黔东南苗族侗族自治州",
"861318407", "山东省菏泽市",
"861364695", "福建省宁德市",
"861508818", "广东省云浮市",
"861873848", "河南省驻马店市",
"861333577", "浙江省温州市",
"861830739", "湖南省邵阳市",
"861517257", "湖北省襄樊市",
"861561072", "山东省德州市",
"861892154", "江苏省无锡市",
"861390985", "辽宁省大连市",
"861367923", "陕西省渭南市",
"861846476", "山东省枣庄市",
"86156418", "辽宁省阜新市",
"861368472", "内蒙古包头市",
"86133171", "湖北省武汉市",
"861510510", "江苏省盐城市",
"861314244", "内蒙古包头市",
"861708269", "湖北省武汉市",
"861305081", "辽宁省铁岭市",
"861804829", "内蒙古呼和浩特市",
"86150750", "河北省邯郸市",
"861333000", "江西省九江市",
"861310644", "浙江省绍兴市",
"861773054", "河北省唐山市",
"861880559", "安徽省黄山市",
"861867244", "湖北省恩施土家族苗族自治州",
"861887562", "河北省承德市",
"86156021", "天津市",
"86177129", "江苏省徐州市",
"861320341", "山西省太原市",
"861318338", "河南省驻马店市",
"861360295", "广东省肇庆市",
"861517068", "江西省吉安市",
"861535522", "浙江省嘉兴市",
"861800958", "宁夏银川市",
"86150637", "山东省济宁市",
"861332530", "陕西省咸阳市",
"861560474", "内蒙古乌兰察布市",
"861340576", "江苏省无锡市",
"861459537", "西藏阿里地区",
"861572174", "贵州省毕节地区",
"86155950", "宁夏银川市",
"861567149", "湖北省襄樊市",
"8618600", "北京市",
"861860813", "四川省自贡市",
"861816819", "江苏省宿迁市",
"861857097", "湖南省湘潭市",
"861339756", "湖南省常德市",
"861537631", "山东省日照市",
"861502876", "河北省衡水市",
"861395143", "江苏省扬州市",
"861323785", "广西贵港市",
"861804340", "吉林省四平市",
"861369965", "四川省广安市",
"861580907", "新疆阿克苏地区",
"861520421", "辽宁省朝阳市",
"861857851", "广东省茂名市",
"86178656", "山东省潍坊市",
"861804864", "四川省乐山市",
"86182242", "四川省宜宾市",
"861373502", "浙江省舟山市",
"861779909", "新疆博尔塔拉蒙古自治州",
"861389536", "宁夏石嘴山市",
"861335588", "浙江省温州市",
"861766044", "山东省青岛市",
"861857713", "广西崇左市",
"861322428", "辽宁省大连市",
"861338311", "河北省石家庄市",
"861871759", "陕西省铜川市",
"861335904", "安徽省安庆市",
"861362356", "山西省晋城市",
"861350099", "吉林省吉林市",
"86183558", "安徽省阜阳市",
"861305486", "山东省淄博市",
"861322632", "广东省惠州市",
"861472910", "陕西省延安市",
"861897181", "湖北省咸宁市",
"86145988", "广东省东莞市",
"861320835", "四川省雅安市",
"861588033", "福建省莆田市",
"861821490", "江西省新余市",
"861310154", "黑龙江省黑河市",
"861599112", "陕西省延安市",
"861357976", "新疆石河子市",
"861507842", "广西玉林市",
"861894784", "内蒙古乌兰察布市",
"861457185", "浙江省台州市",
"86156275", "广东省茂名市",
"861883390", "河北省邯郸市",
"861581683", "广东省东莞市",
"861323333", "山西省晋城市",
"861860751", "广东省韶关市",
"861599682", "江苏省镇江市",
"861589445", "云南省西双版纳傣族自治州",
"861505636", "安徽省蚌埠市",
"861522482", "河南省平顶山市",
"861804917", "陕西省宝鸡市",
"861772400", "广东省广州市",
"861816927", "湖南省益阳市",
"861560662", "浙江省宁波市",
"861313946", "甘肃省庆阳市",
"86181833", "四川省乐山市",
"861811487", "江苏省无锡市",
"861865099", "福建省福州市",
"861830778", "广西河池市",
"861776709", "浙江省杭州市",
"861353459", "广东省佛山市",
"861807043", "江西省上饶市",
"861700157", "江苏省苏州市",
"861772220", "广东省广州市",
"861591779", "广东省惠州市",
"861567659", "广西来宾市",
"861337737", "广西钦州市",
"86156406", "辽宁省锦州市",
"861318379", "四川省绵阳市",
"861768537", "贵州省安顺市",
"861355751", "广西南宁市",
"861809713", "青海省黄南藏族自治州",
"861336956", "宁夏石嘴山市",
"861808895", "云南省文山壮族苗族自治州",
"861870805", "西藏昌都地区",
"861564262", "辽宁省朝阳市",
"861324707", "江西省赣州市",
"861573969", "新疆哈密地区",
"86137384", "浙江省宁波市",
"861872602", "安徽省马鞍山市",
"861779943", "新疆石河子市",
"861535089", "河北省秦皇岛市",
"86131631", "天津市",
"861816452", "浙江省湖州市",
"861317524", "浙江省湖州市",
"861368705", "江西省宜春市",
"861850515", "江苏省盐城市",
"861806470", "浙江省湖州市",
"861518554", "贵州省黔南布依族苗族自治州",
"861572995", "新疆伊犁哈萨克自治州",
"86137291", "广东省湛江市",
"861395109", "江苏省宿迁市",
"861802779", "广东省茂名市",
"86139449", "吉林省长春市",
"861563899", "河南省南阳市",
"861864524", "黑龙江省大庆市",
"86150444", "吉林省四平市",
"861868547", "贵州省毕节地区",
"861525287", "江苏省宿迁市",
"86150683", "浙江省嘉兴市",
"861314463", "黑龙江省牡丹江市",
"861770788", "广西河池市",
"861839450", "甘肃省武威市",
"861363490", "辽宁省朝阳市",
"861851575", "四川省德阳市",
"861392353", "广东省揭阳市",
"86184243", "辽宁省营口市",
"861313768", "河南省周口市",
"861378851", "广西南宁市",
"861761477", "内蒙古鄂尔多斯市",
"861318878", "山东省烟台市",
"861365515", "江苏省淮安市",
"86156559", "安徽省黄山市",
"86155649", "山东省临沂市",
"861806233", "湖北省咸宁市",
"861599514", "江苏省扬州市",
"861833388", "河北省唐山市",
"861504726", "内蒙古巴彦淖尔市",
"861301510", "内蒙古呼和浩特市",
"86177557", "安徽省宿州市",
"861391951", "甘肃省平凉市",
"861360050", "浙江省衢州市",
"861322440", "吉林省四平市",
"861869425", "河北省唐山市",
"861340681", "山东省青岛市",
"861530836", "四川省资阳市",
"861846045", "江西省宜春市",
"86132296", "广东省汕头市",
"861525648", "安徽省阜阳市",
"861522849", "四川省德阳市",
"861760417", "辽宁省营口市",
"86130432", "天津市",
"861346770", "湖南省长沙市",
"861515290", "江苏省镇江市",
"861577546", "四川省达州市",
"861571497", "新疆乌鲁木齐市",
"861555938", "新疆昌吉回族自治州",
"861577115", "湖北省荆州市",
"861373104", "河北省邯郸市",
"861308933", "吉林省延边朝鲜族自治州",
"86137719", "江苏省苏州市",
"861533786", "海南省海口市",
"861832959", "陕西省铜川市",
"861890816", "四川省雅安市",
"861318839", "辽宁省丹东市",
"861708391", "河南省焦作市",
"861770301", "广东省江门市",
"861800637", "山东省滨州市",
"861835264", "江苏省南京市",
"861810567", "安徽省阜阳市",
"861804237", "浙江省丽水市",
"861508319", "河南省周口市",
"861303806", "山西省长治市",
"861318680", "浙江省温州市",
"861340825", "四川省遂宁市",
"861587269", "湖北省十堰市",
"86133338", "河南省郑州市",
"861596311", "山东省济南市",
"86178850", "贵州省贵阳市",
"861776743", "新疆和田地区",
"861572572", "山东省淄博市",
"861361532", "山东省青岛市",
"86176036", "黑龙江省哈尔滨市",
"861514491", "内蒙古兴安盟",
"861475288", "江苏省常州市",
"861318110", "山东省威海市",
"861379895", "广东省珠海市",
"861535124", "四川省绵阳市",
"861866034", "山东省枣庄市",
"861882051", "广东省云浮市",
"86183419", "辽宁省辽阳市",
"861328763", "山东省泰安市",
"861323873", "云南省红河哈尼族彝族自治州",
"86151195", "广东省湛江市",
"861533523", "江苏省无锡市",
"861861785", "河北省唐山市",
"861827225", "湖北省宜昌市",
"861517902", "江西省上饶市",
"86152139", "甘肃省定西市",
"861518273", "四川省攀枝花市",
"861329949", "广西柳州市",
"861589076", "河南省安阳市",
"861879213", "安徽省合肥市",
"861813855", "广东省潮州市",
"861475647", "河北省沧州市",
"861380930", "甘肃省白银市",
"861527165", "湖北省黄石市",
"861820993", "新疆石河子市",
"861506587", "山东省淄博市",
"861872918", "陕西省西安市",
"861399150", "陕西省商洛市",
"861320375", "河南省南阳市",
"861393142", "河北省承德市",
"861894498", "湖南省衡阳市",
"861551764", "河南省驻马店市",
"861810353", "山西省阳泉市",
"861383415", "山西省太原市",
"861850146", "江苏省南通市",
"861834435", "广东省惠州市",
"861825027", "福建省泉州市",
"861550598", "福建省三明市",
"861816318", "湖北省孝感市",
"861321796", "江西省吉安市",
"861328697", "广东省湛江市",
"86158349", "吉林省延边朝鲜族自治州",
"861571856", "贵州省铜仁地区",
"861309345", "安徽省合肥市",
"861375928", "云南省西双版纳傣族自治州",
"861813993", "甘肃省庆阳市",
"861301919", "吉林省通化市",
"861313375", "江西省赣州市",
"861502931", "陕西省延安市",
"86186683", "浙江省嘉兴市",
"86138578", "浙江省宁波市",
"861886478", "河南省焦作市",
"861317583", "浙江省舟山市",
"861524051", "江苏省常州市",
"86187177", "上海市",
"861311813", "四川省德阳市",
"86186444", "上海市",
"861580854", "贵州省黔南布依族苗族自治州",
"861360731", "湖南省长沙市",
"861504524", "黑龙江省齐齐哈尔市",
"861838885", "云南省临沧市",
"861539407", "甘肃省张掖市",
"861599716", "湖北省鄂州市",
"861803899", "广东省茂名市",
"861398597", "贵州省黔西南布依族苗族自治州",
"861376811", "广西南宁市",
"861572711", "湖北省鄂州市",
"861310873", "云南省红河哈尼族彝族自治州",
"861459562", "陕西省渭南市",
"86189396", "河南省驻马店市",
"861539338", "甘肃省白银市",
"861317960", "江苏省苏州市",
"861332219", "辽宁省锦州市",
"861822652", "安徽省芜湖市",
"861531231", "江苏省淮安市",
"86131744", "吉林省长春市",
"861899452", "江苏省连云港市",
"86187071", "湖北省武汉市",
"86139931", "甘肃省兰州市",
"86372", "河南省安阳市",
"861365394", "河南省周口市",
"861893440", "贵州省遵义市",
"861300979", "黑龙江省牡丹江市",
"861820855", "贵州省黔东南苗族侗族自治州",
"861881453", "黑龙江省牡丹江市",
"861317726", "湖北省孝感市",
"861535063", "河北省唐山市",
"861889065", "湖南省怀化市",
"861509425", "云南省昭通市",
"861514639", "黑龙江省哈尔滨市",
"861372258", "河北省邯郸市",
"861345891", "四川省广安市",
"86156767", "广西南宁市",
"86135347", "广东省江门市",
"861597702", "广西钦州市",
"861864726", "内蒙古赤峰市",
"861844941", "新疆阿勒泰地区",
"86180559", "安徽省黄山市",
"86177769", "海南省海口市",
"861850394", "河南省周口市",
"861381518", "江苏省镇江市",
"86147594", "福建省莆田市",
"861339642", "山东省青岛市",
"861818412", "贵州省遵义市",
"861470011", "江苏省淮安市",
"86151732", "湖南省湘潭市",
"861333650", "广东省湛江市",
"861528915", "西藏昌都地区",
"861827176", "湖北省孝感市",
"861707178", "江西省鹰潭市",
"861853439", "山西省太原市",
"861314489", "广东省东莞市",
"861372067", "陕西省渭南市",
"861360487", "黑龙江省大兴安岭地区",
"861328789", "山东省淄博市",
"861372187", "河南省平顶山市",
"861380539", "山东省临沂市",
"861567009", "河南省鹤壁市",
"861597441", "湖南省张家界市",
"861305598", "福建省南平市",
"86188151", "浙江省温州市",
"861818358", "云南省曲靖市",
"861372617", "广东省江门市",
"861363743", "湖南省湘西土家族苗族自治州",
"861453913", "广东省广州市",
"861309831", "湖北省荆州市",
"861560637", "山东省枣庄市",
"861853478", "山西省吕梁市",
"861596916", "云南省西双版纳傣族自治州",
"861321594", "福建省厦门市",
"861337762", "广东省河源市",
"861872052", "江西省宜春市",
"861323552", "湖北省武汉市",
"861582571", "浙江省嘉兴市",
"861889185", "陕西省安康市",
"861329540", "山东省菏泽市",
"861598351", "四川省雅安市",
"861882730", "湖北省咸宁市",
"861322793", "陕西省渭南市",
"861335091", "四川省广安市",
"861530945", "甘肃省金昌市",
"861572853", "广东省深圳市",
"861357831", "云南省临沧市",
"861891211", "江苏省镇江市",
"861552589", "山西省运城市",
"861786882", "陕西省榆林市",
"861450275", "内蒙古通辽市",
"861470416", "辽宁省锦州市",
"861889556", "安徽省马鞍山市",
"861300938", "辽宁省鞍山市",
"861333140", "吉林省白城市",
"861364448", "吉林省松原市",
"861890271", "广东省汕头市",
"861592072", "广东省佛山市",
"861471476", "广东省肇庆市",
"861454675", "广东省珠海市",
"86187592", "福建省厦门市",
"861501785", "广东省东莞市",
"861458492", "山东省淄博市",
"861539379", "河南省许昌市",
"861311751", "湖南省长沙市",
"861885788", "浙江省杭州市",
"861366838", "四川省达州市",
"86159227", "重庆市",
"86138647", "山东省东营市",
"86183297", "陕西省西安市",
"861880387", "河南省信阳市",
"861587996", "江西省萍乡市",
"861452781", "新疆乌鲁木齐市",
"861364420", "辽宁省鞍山市",
"861450241", "河北省邢台市",
"861569097", "内蒙古鄂尔多斯市",
"861347090", "安徽省黄山市",
"861340774", "广西南宁市",
"861536597", "江苏省镇江市",
"86180021", "天津市",
"861365742", "湖南省常德市",
"86186750", "广东省江门市",
"861530971", "青海省西宁市",
"861877455", "湖南省怀化市",
"861339554", "安徽省淮南市",
"861800012", "江苏省宿迁市",
"861588139", "四川省宜宾市",
"861533612", "陕西省渭南市",
"861320946", "甘肃省兰州市",
"861817420", "湖南省邵阳市",
"861306574", "浙江省杭州市",
"86180418", "辽宁省阜新市",
"861801072", "安徽省安庆市",
"861808953", "四川省广元市",
"861332939", "黑龙江省大庆市",
"861868818", "广东省珠海市",
"861325553", "山东省烟台市",
"861353934", "广东省佛山市",
"861818859", "贵州省黔西南布依族苗族自治州",
"861533182", "黑龙江省黑河市",
"86131450", "江苏省苏州市",
"861300657", "山东省济南市",
"861768129", "安徽省黄山市",
"86180127", "江苏省苏州市",
"861389734", "青海省海南藏族自治州",
"861705661", "江苏省南京市",
"86180461", "福建省漳州市",
"86139320", "河北省邯郸市",
"861575108", "江苏省徐州市",
"861569851", "山西省晋城市",
"861397294", "湖北省武汉市",
"861454641", "云南省昆明市",
"861814984", "新疆巴音郭楞蒙古自治州",
"861550081", "宁夏银川市",
"861346397", "河北省石家庄市",
"86130339", "河南省周口市",
"861888234", "四川省南充市",
"861821881", "广东省深圳市",
"861880950", "宁夏银川市",
"861478536", "贵州省六盘水市",
"861850742", "湖南省常德市",
"861886807", "浙江省衢州市",
"861878345", "四川省广元市",
"861503315", "河北省唐山市",
"861511979", "广东省清远市",
"861373044", "河北省保定市",
"861321192", "云南省昆明市",
"861801414", "江苏省淮安市",
"861329528", "江苏省宿迁市",
"861310333", "河北省张家口市",
"861366339", "河北省保定市",
"86185208", "广东省深圳市",
"861539878", "云南省楚雄彝族自治州",
"861862876", "吉林省四平市",
"861302758", "河南省焦作市",
"861899819", "广东省珠海市",
"861500813", "四川省自贡市",
"861807149", "湖北省荆州市",
"861582545", "浙江省台州市",
"8615000", "上海市",
"86159334", "河北省保定市",
"861334561", "安徽省淮北市",
"861800474", "内蒙古乌兰察布市",
"86186637", "山东省济南市",
"861452843", "甘肃省白银市",
"861510919", "陕西省铜川市",
"861560958", "宁夏银川市",
"861539839", "云南省昆明市",
"861564917", "河南省信阳市",
"861366378", "河南省开封市",
"861500751", "广东省韶关市",
"861859659", "福建省厦门市",
"861362694", "福建省南平市",
"86180275", "广东省东莞市",
"86138434", "吉林省四平市",
"861362951", "宁夏银川市",
"861459129", "广西贺州市",
"861337890", "湖南省岳阳市",
"861339430", "吉林省长春市",
"861573560", "山西省晋城市",
"861552022", "四川省巴中市",
"861452437", "辽宁省鞍山市",
"861787547", "广东省茂名市",
"86155240", "辽宁省沈阳市",
"861477866", "广东省湛江市",
"861338916", "陕西省汉中市",
"86152513", "江苏省南通市",
"861539110", "内蒙古呼伦贝尔市",
"861452308", "河南省新乡市",
"861884803", "内蒙古通辽市",
"861844975", "新疆伊犁哈萨克自治州",
"861515729", "浙江省台州市",
"861300147", "河北省衡水市",
"861361353", "山西省阳泉市",
"861539680", "江苏省徐州市",
"861357371", "山东省威海市",
"86136881", "四川省成都市",
"861893632", "江苏省盐城市",
"86158442", "吉林省吉林市",
"861365221", "广东省中山市",
"861339273", "广东省东莞市",
"861533062", "吉林省松原市",
"861843613", "河南省商丘市",
"861700460", "黑龙江省哈尔滨市",
"861301278", "山东省聊城市",
"861893208", "贵州省黔西南布依族苗族自治州",
"861304618", "广东省韶关市",
"861323644", "江苏省扬州市",
"861891931", "甘肃省兰州市",
"861453470", "黑龙江省哈尔滨市",
"861893428", "广东省清远市",
"86155595", "福建省泉州市",
"86153326", "陕西省安康市",
"861569713", "湖北省黄冈市",
"86158420", "辽宁省鞍山市",
"861313341", "山西省运城市",
"861459164", "广西崇左市",
"861478325", "河南省焦作市",
"861350636", "山东省东营市",
"861705011", "广东省深圳市",
"861361567", "安徽省阜阳市",
"861892333", "广东省中山市",
"86134245", "广东省中山市",
"861363709", "安徽省合肥市",
"861336351", "山西省太原市",
"86158060", "福建省福州市",
"861325274", "辽宁省抚顺市",
"861550486", "内蒙古赤峰市",
"861332978", "湖北省荆门市",
"861882601", "广东省中山市",
"861534593", "福建省莆田市",
"861800662", "浙江省湖州市",
"861773765", "河南省信阳市",
"861810532", "山东省青岛市",
"86183312", "河北省保定市",
"861565964", "福建省南平市",
"86188251", "广东省广州市",
"861303803", "山西省晋中市",
"861302827", "辽宁省铁岭市",
"861709891", "广东省广州市",
"861776746", "新疆吐鲁番地区",
"861399965", "新疆和田地区",
"861478418", "河南省信阳市",
"861807475", "广西玉林市",
"861398014", "四川省绵阳市",
"861562259", "广东省韶关市",
"861509130", "陕西省渭南市",
"861580511", "江苏省盐城市",
"861309410", "湖北省襄樊市",
"861322594", "福建省福州市",
"861314061", "河南省信阳市",
"861871052", "陕西省榆林市",
"861877422", "湖南省衡阳市",
"861581571", "广东省中山市",
"861350792", "江西省九江市",
"861533783", "湖南省长沙市",
"861378395", "河南省漯河市",
"861300305", "安徽省合肥市",
"861308936", "吉林省白城市",
"86135661", "浙江省温州市",
"86181937", "甘肃省酒泉市",
"86187700", "江西省南昌市",
"861590474", "内蒙古乌兰察布市",
"861821142", "广东省深圳市",
"861890813", "四川省乐山市",
"861840832", "四川省内江市",
"861509819", "山东省潍坊市",
"86187125", "安徽省阜阳市",
"861370677", "浙江省温州市",
"86135618", "山东省威海市",
"861534342", "山西省太原市",
"861778908", "西藏林芝地区",
"861454812", "广东省广州市",
"861820996", "新疆巴音郭楞蒙古自治州",
"861476974", "山东省济南市",
"861837277", "湖北省鄂州市",
"86152836", "四川省宜宾市",
"861590012", "广东省汕尾市",
"861330238", "广东省广州市",
"861565929", "福建省厦门市",
"861536705", "湖南省衡阳市",
"861327232", "湖南省衡阳市",
"861810356", "山西省晋城市",
"861850143", "江苏省常州市",
"861321793", "江西省上饶市",
"86159021", "上海市",
"861327608", "福建省福州市",
"861897244", "湖北省恩施土家族苗族自治州",
"861533841", "广东省佛山市",
"861571853", "贵州省安顺市",
"86177620", "山东省青岛市",
"861359199", "辽宁省葫芦岛市",
"861347775", "湖北省黄石市",
"861328766", "山东省潍坊市",
"861330327", "河北省秦皇岛市",
"861323876", "云南省文山壮族苗族自治州",
"86138306", "甘肃省张掖市",
"861533526", "江苏省苏州市",
"861576878", "广东省惠州市",
"861815884", "安徽省合肥市",
"86159461", "黑龙江省绥化市",
"861776002", "四川省成都市",
"86177198", "河南省郑州市",
"861870454", "黑龙江省佳木斯市",
"861518276", "四川省巴中市",
"861781728", "广东省深圳市",
"861589073", "河南省驻马店市",
"861477701", "广西南宁市",
"861334638", "山东省烟台市",
"861360985", "辽宁省大连市",
"861879216", "安徽省池州市",
"86159418", "辽宁省阜新市",
"861365653", "浙江省温州市",
"86155485", "内蒙古鄂尔多斯市",
"86145086", "江苏省徐州市",
"861510758", "广东省肇庆市",
"861570771", "广西南宁市",
"861503428", "山西省吕梁市",
"8614712", "四川省成都市",
"86159406", "辽宁省锦州市",
"861576680", "广东省汕头市",
"861528417", "四川省宜宾市",
"86183463", "黑龙江省牡丹江市",
"86138361", "黑龙江省哈尔滨市",
"861314466", "黑龙江省鸡西市",
"86170876", "江苏省扬州市",
"861330279", "广东省潮州市",
"861320500", "福建省福州市",
"861883068", "河北省石家庄市",
"861302919", "吉林省通化市",
"86187277", "湖北省恩施土家族苗族自治州",
"86138318", "河北省衡水市",
"861779946", "新疆阿克苏地区",
"861334679", "河南省焦作市",
"861514093", "辽宁省朝阳市",
"86182760", "广西玉林市",
"861509927", "新疆阿克苏地区",
"861458577", "山东省菏泽市",
"861597659", "广东省潮州市",
"861576839", "广东省深圳市",
"861760791", "江西省南昌市",
"861328137", "四川省德阳市",
"86183023", "重庆市",
"861303482", "湖南省娄底市",
"86139685", "浙江省台州市",
"861864784", "内蒙古呼和浩特市",
"86137763", "江苏省苏州市",
"86135606", "广东省中山市",
"861530833", "四川省绵阳市",
"861303348", "山西省太原市",
"861324314", "河南省南阳市",
"861770528", "江苏省镇江市",
"861577543", "四川省泸州市",
"861319378", "河南省开封市",
"861369628", "四川省绵阳市",
"861478352", "河南省焦作市",
"861392356", "广东省揭阳市",
"861705579", "河南省南阳市",
"86157748", "内蒙古赤峰市",
"861479774", "广西梧州市",
"861315942", "福建省福州市",
"861369432", "吉林省吉林市",
"86188439", "吉林省白山市",
"861376273", "湖南省益阳市",
"861806236", "湖北省荆州市",
"861870530", "山东省菏泽市",
"861533335", "河北省秦皇岛市",
"861504723", "内蒙古包头市",
"861361694", "福建省三明市",
"861357973", "新疆伊犁哈萨克自治州",
"861512938", "陕西省延安市",
"861390050", "福建省福州市",
"861361951", "宁夏银川市",
"861350344", "河南省新乡市",
"861358422", "江苏省无锡市",
"861807702", "广西南宁市",
"861828460", "四川省南充市",
"861573381", "河北省保定市",
"861350860", "湖北省宜昌市",
"86135800", "广东省茂名市",
"861534794", "江西省抚州市",
"861339811", "四川省内江市",
"861581686", "广东省深圳市",
"86155122", "河北省保定市",
"861520537", "山东省济宁市",
"861550469", "黑龙江省双鸭山市",
"861505633", "安徽省宣城市",
"861454459", "江西省萍乡市",
"861358202", "河北省石家庄市",
"861362353", "山西省阳泉市",
"861768026", "湖南省衡阳市",
"861377962", "新疆喀什地区",
"861569514", "江苏省扬州市",
"861576227", "山东省青岛市",
"861370959", "宁夏银川市",
"861305483", "山东省莱芜市",
"86159559", "安徽省六安市",
"861308216", "河北省沧州市",
"86152373", "河南省新乡市",
"861845841", "浙江省杭州市",
"861459421", "云南省普洱市",
"861558488", "吉林省白城市",
"861770540", "山东省菏泽市",
"861826248", "江苏省盐城市",
"861588036", "福建省龙岩市",
"861396604", "安徽省蚌埠市",
"861898547", "贵州省黔西南布依族苗族自治州",
"861840372", "河南省安阳市",
"861813224", "河北省邯郸市",
"861778182", "四川省成都市",
"86159093", "重庆市",
"861395656", "安徽省宣城市",
"861809716", "青海省玉树藏族自治州",
"861550204", "广东省深圳市",
"861362567", "安徽省安庆市",
"861327912", "陕西省榆林市",
"861336953", "宁夏吴忠市",
"861536472", "山西省大同市",
"861572285", "江苏省徐州市",
"861558342", "四川省成都市",
"861330918", "陕西省西安市",
"861550424", "辽宁省大连市",
"861778612", "湖北省武汉市",
"861570745", "湖南省怀化市",
"86181983", "贵州省遵义市",
"861376642", "江西省宜春市",
"861302278", "山东省潍坊市",
"861813404", "河北省承德市",
"861470579", "浙江省金华市",
"861511305", "广东省汕头市",
"861398705", "云南省保山市",
"861331978", "新疆阿克苏地区",
"861859702", "青海省海东地区",
"861313943", "甘肃省白银市",
"861775165", "江苏省苏州市",
"861503440", "山西省太原市",
"861878410", "四川省宜宾市",
"861582669", "湖北省恩施土家族苗族自治州",
"861471519", "广东省东莞市",
"861309973", "青海省黄南藏族自治州",
"861585291", "江苏省南京市",
"861807046", "江西省吉安市",
"861477889", "广东省深圳市",
"86136449", "辽宁省大连市",
"861889332", "甘肃省平凉市",
"86134145", "广东省惠州市",
"86134702", "辽宁省朝阳市",
"861319879", "四川省内江市",
"861777158", "湖北省潜江市",
"861826117", "江苏省常州市",
"861303849", "陕西省宝鸡市",
"86150396", "河南省驻马店市",
"861776968", "浙江省湖州市",
"861768201", "安徽省合肥市",
"861470538", "山东省泰安市",
"861501211", "云南省临沧市",
"861582019", "广东省茂名市",
"861538765", "四川省甘孜藏族自治州",
"861588431", "四川省眉山市",
"861309107", "河北省唐山市",
"86183197", "广东省茂名市",
"861824683", "黑龙江省大庆市",
"861781740", "广东省广州市",
"861315591", "江西省上饶市",
"861335728", "湖南省永州市",
"861535782", "安徽省铜陵市",
"861388681", "湖北省十堰市",
"861530373", "河南省新乡市",
"861577509", "广东省揭阳市",
"861537944", "甘肃省白银市",
"861355816", "广西柳州市",
"861822743", "四川省绵阳市",
"861319838", "四川省攀枝花市",
"861835041", "福建省莆田市",
"861384899", "内蒙古赤峰市",
"86180227", "广东省佛山市",
"861334957", "黑龙江省鸡西市",
"861859441", "福建省南平市",
"861568956", "山东省临沂市",
"861812050", "湖北省荆州市",
"861846473", "山东省济宁市",
"861331939", "江西省萍乡市",
"861532911", "贵州省遵义市",
"861395146", "江苏省徐州市",
"861856902", "湖南省衡阳市",
"86132624", "浙江省温州市",
"861351168", "江苏省镇江市",
"86152088", "云南省德宏傣族景颇族自治州",
"861536664", "江苏省淮安市",
"861822881", "四川省广元市",
"861325754", "广东省汕头市",
"861512979", "陕西省咸阳市",
"861389533", "宁夏吴忠市",
"86185863", "贵州省遵义市",
"86152757", "山东省济宁市",
"861846230", "山东省临沂市",
"861340573", "江苏省南通市",
"861334380", "河南省新乡市",
"861328948", "陕西省榆林市",
"861301758", "河南省开封市",
"861777648", "广西南宁市",
"86170990", "贵州省贵阳市",
"861860816", "四川省绵阳市",
"861339753", "湖南省株洲市",
"861339627", "山东省德州市",
"861570757", "广东省佛山市",
"861829478", "甘肃省甘南藏族自治州",
"861504979", "内蒙古乌海市",
"861380968", "广东省中山市",
"861452620", "江苏省苏州市",
"861892678", "广东省深圳市",
"861568790", "云南省西双版纳傣族自治州",
"861805256", "江苏省扬州市",
"861338081", "广东省茂名市",
"861567134", "湖北省襄樊市",
"861339302", "河北省保定市",
"861778770", "云南省玉溪市",
"861384854", "内蒙古鄂尔多斯市",
"86139583", "浙江省宁波市",
"861367414", "辽宁省沈阳市",
"861586029", "福建省福州市",
"861458551", "山东省聊城市",
"861802760", "广东省茂名市",
"861888798", "云南省曲靖市",
"861587847", "广西百色市",
"86157355", "山西省长治市",
"861300524", "广东省汕头市",
"86135532", "广东省河源市",
"861331631", "广东省佛山市",
"861532619", "辽宁省抚顺市",
"861370141", "江苏省苏州市",
"861766039", "山东省枣庄市",
"861898461", "贵州省黔东南苗族侗族自治州",
"8613452", "重庆市",
"861362441", "吉林省长春市",
"861333932", "黑龙江省七台河市",
"861375450", "河北省唐山市",
"861308588", "广东省中山市",
"861830744", "湖南省张家界市",
"861358971", "山东省滨州市",
"861841801", "甘肃省临夏回族自治州",
"861826065", "江苏省扬州市",
"861478749", "云南省昆明市",
"861309605", "四川省乐山市",
"861337795", "湖北省武汉市",
"861510489", "内蒙古呼伦贝尔市",
"86181067", "浙江省温州市",
"86136727", "广东省珠海市",
"861572658", "山东省济宁市",
"861317007", "安徽省宿州市",
"861379377", "山东省济宁市",
"861890777", "广西钦州市",
"861864570", "黑龙江省大兴安岭地区",
"861818108", "四川省南充市",
"861526698", "山东省威海市",
"861325799", "江西省萍乡市",
"861310639", "浙江省丽水市",
"861323491", "黑龙江省大庆市",
"861337316", "河北省廊坊市",
"861300569", "广东省珠海市",
"861366633", "山东省日照市",
"86181118", "贵州省贵阳市",
"861539242", "福建省厦门市",
"861586064", "福建省漳州市",
"861518468", "黑龙江省双鸭山市",
"861533250", "陕西省汉中市",
"861311068", "福建省龙岩市",
"861317570", "浙江省衢州市",
"861831226", "广东省惠州市",
"861806424", "湖北省宜昌市",
"861479580", "广西南宁市",
"86181161", "上海市",
"86181427", "辽宁省盘锦市",
"861472891", "西藏拉萨市",
"86170045", "黑龙江省哈尔滨市",
"86155544", "山东省济宁市",
"861315425", "辽宁省鞍山市",
"86156654", "安徽省合肥市",
"861538636", "湖南省常德市",
"861360328", "河北省保定市",
"861344699", "新疆和田地区",
"861839503", "宁夏吴忠市",
"861810009", "上海市",
"861362046", "广东省珠海市",
"861320456", "黑龙江省黑河市",
"861361659", "浙江省宁波市",
"861885151", "江苏省无锡市",
"861311188", "四川省成都市",
"861534759", "广东省肇庆市",
"861364637", "山东省枣庄市",
"861572217", "贵州省遵义市",
"86181106", "安徽省六安市",
"861313730", "河南省新乡市",
"861579800", "江西省抚州市",
"86189773", "广西桂林市",
"861867278", "湖北省武汉市",
"86132598", "陕西省西安市",
"861335213", "辽宁省抚顺市",
"861764529", "黑龙江省双鸭山市",
"861379229", "山东省滨州市",
"861338486", "内蒙古包头市",
"861817637", "广西梧州市",
"861807567", "湖南省娄底市",
"86180858", "贵州省六盘水市",
"861889092", "新疆伊犁哈萨克自治州",
"861386540", "安徽省芜湖市",
"861373133", "河北省张家口市",
"861370994", "新疆昌吉回族自治州",
"861584539", "黑龙江省七台河市",
"861370651", "浙江省杭州市",
"861305311", "安徽省蚌埠市",
"861859353", "福建省厦门市",
"861560382", "河南省新乡市",
"861340299", "陕西省榆林市",
"861310678", "广东省阳江市",
"861550916", "陕西省汉中市",
"861876665", "山东省泰安市",
"861589893", "山东省潍坊市",
"861522058", "广东省惠州市",
"861323096", "河北省邢台市",
"861474136", "辽宁省营口市",
"861700513", "江苏省南通市",
"861576098", "陕西省延安市",
"86138879", "云南省普洱市",
"861899591", "湖北省宜昌市",
"861500902", "新疆哈密地区",
"861881909", "广东省东莞市",
"861766078", "山东省东营市",
"861368384", "河南省洛阳市",
"861348743", "湖南省湘西土家族苗族自治州",
"861362702", "江西省九江市",
"861334945", "黑龙江省绥化市",
"86151050", "福建省南平市",
"861331700", "江西省南昌市",
"861800695", "福建省漳州市",
"861845250", "江苏省盐城市",
"861473684", "云南省临沧市",
"861880428", "辽宁省大连市",
"861302181", "河北省唐山市",
"861782871", "四川省成都市",
"861512155", "贵州省黔西南布依族苗族自治州",
"861340361", "山西省大同市",
"86185352", "山西省晋中市",
"861453802", "四川省德阳市",
"861808377", "江苏省扬州市",
"861501639", "广东省肇庆市",
"861880632", "山东省枣庄市",
"861473114", "河北省秦皇岛市",
"861882835", "四川省乐山市",
"861812501", "广东省茂名市",
"861850727", "湖北省襄樊市",
"861333212", "辽宁省抚顺市",
"861593038", "河北省衡水市",
"861360829", "四川省宜宾市",
"861875756", "浙江省杭州市",
"861780430", "吉林省长春市",
"861501880", "广东省汕头市",
"861316823", "广东省汕尾市",
"8613521", "北京市",
"861334971", "湖北省武汉市",
"861377497", "山东省菏泽市",
"861596081", "福建省厦门市",
"86133301", "江西省赣州市",
"86188403", "陕西省西安市",
"861306929", "吉林省通化市",
"861301489", "广西柳州市",
"861855864", "福建省三明市",
"86159360", "河南省周口市",
"861508089", "湖南省湘西土家族苗族自治州",
"861597951", "江西省宜春市",
"861560420", "辽宁省鞍山市",
"861533095", "辽宁省铁岭市",
"861398921", "四川省宜宾市",
"861783915", "河南省许昌市",
"861302466", "浙江省金华市",
"861592508", "云南省昭通市",
"861528485", "四川省广元市",
"861530561", "安徽省淮北市",
"861856245", "山东省临沂市",
"861341998", "河南省信阳市",
"861314919", "陕西省铜川市",
"861364958", "宁夏中卫市",
"86139537", "山东省济宁市",
"86183256", "安徽省安庆市",
"861852432", "辽宁省鞍山市",
"861530455", "黑龙江省绥化市",
"861360864", "河南省商丘市",
"861816088", "安徽省合肥市",
"861830392", "河南省鹤壁市",
"861360340", "河南省三门峡市",
"861506143", "江苏省盐城市",
"861454301", "黑龙江省哈尔滨市",
"861707396", "河南省驻马店市",
"861780273", "湖北省荆州市",
"861572937", "河南省郑州市",
"861380746", "湖南省永州市",
"861361977", "青海省海西蒙古族藏族自治州",
"861354161", "四川省内江市",
"861512645", "云南省临沧市",
"86135262", "河南省周口市",
"86147290", "陕西省咸阳市",
"861348709", "湖北省武汉市",
"861893950", "河南省郑州市",
"86151892", "江苏省盐城市",
"861358945", "山东省东营市",
"861899942", "新疆乌鲁木齐市",
"861535319", "陕西省榆林市",
"861309729", "江西省九江市",
"86131608", "广东省广州市",
"861329934", "甘肃省嘉峪关市",
"861311902", "新疆哈密地区",
"861780554", "安徽省淮南市",
"861708847", "江西省新余市",
"861322559", "安徽省黄山市",
"861390501", "福建省福州市",
"86188652", "山东省聊城市",
"861332568", "新疆克拉玛依市",
"861453483", "内蒙古乌海市",
"861360917", "陕西省宝鸡市",
"861452287", "山西省临汾市",
"861335933", "甘肃省平凉市",
"861592984", "陕西省渭南市",
"861319099", "内蒙古呼伦贝尔市",
"861330593", "福建省宁德市",
"861539673", "江苏省盐城市",
"861861491", "河南省三门峡市",
"861813436", "河北省唐山市",
"861501678", "广东省东莞市",
"861573970", "新疆克拉玛依市",
"861508169", "河北省廊坊市",
"86176068", "浙江省宁波市",
"861379443", "广东省广州市",
"861318360", "四川省泸州市",
"861345519", "山东省德州市",
"861309764", "山西省朔州市",
"861893387", "广东省阳江市",
"86133366", "浙江省宁波市",
"861454788", "山东省济宁市",
"861517030", "江西省景德镇市",
"86138460", "黑龙江省鸡西市",
"861318844", "辽宁省铁岭市",
"861820750", "广东省江门市",
"861452648", "江苏省宿迁市",
"861844565", "黑龙江省哈尔滨市",
"861571435", "吉林省通化市",
"861359154", "辽宁省抚顺市",
"861362475", "内蒙古通辽市",
"861591760", "广东省清远市",
"86138020", "天津市",
"861302061", "山东省德州市",
"861879904", "新疆阿勒泰地区",
"861839549", "陕西省西安市",
"861810043", "辽宁省大连市",
"861787522", "广东省河源市",
"861866049", "山东省烟台市",
"861867827", "山东省枣庄市",
"861593079", "河北省沧州市",
"861500618", "江苏省无锡市",
"861556197", "黑龙江省牡丹江市",
"861859951", "福建省南平市",
"861589080", "河南省驻马店市",
"861826872", "浙江省舟山市",
"861453598", "福建省厦门市",
"861537454", "湖北省黄冈市",
"861330342", "山西省大同市",
"861338424", "辽宁省本溪市",
"861367865", "山东省烟台市",
"86181206", "福建省泉州市",
"861860390", "河南省平顶山市",
"861327348", "河北省邢台市",
"861348544", "山西省吕梁市",
"861802508", "广东省珠海市",
"861365858", "贵州省六盘水市",
"861361046", "广东省中山市",
"861476564", "湖北省武汉市",
"861770934", "甘肃省庆阳市",
"861315819", "贵州省黔西南布依族苗族自治州",
"861814865", "广东省佛山市",
"861841948", "甘肃省天水市",
"86155621", "山东省威海市",
"861315130", "江苏省淮安市",
"861580398", "河南省三门峡市",
"86136916", "广东省深圳市",
"861869088", "新疆乌鲁木齐市",
"861582557", "浙江省宁波市",
"861328458", "黑龙江省伊春市",
"86181475", "内蒙古通辽市",
"861338469", "黑龙江省双鸭山市",
"861850858", "贵州省六盘水市",
"861821127", "广东省湛江市",
"861598377", "四川省南充市",
"861530638", "山东省烟台市",
"861567356", "湖南省邵阳市",
"861564985", "河南省郑州市",
"86139018", "上海市",
"861890068", "江苏省南京市",
"861310717", "湖南省益阳市",
"861877447", "湖南省邵阳市",
"861871596", "河北省张家口市",
"86153000", "北京市",
"861304245", "辽宁省大连市",
"861476529", "辽宁省沈阳市",
"861533770", "浙江省舟山市",
"861534327", "湖南省怀化市",
"861538344", "山西省晋中市",
"861530422", "辽宁省朝阳市",
"861527208", "湖北省咸宁市",
"861890257", "广东省湛江市",
"861300645", "四川省德阳市",
"861330488", "黑龙江省双鸭山市",
"861361702", "江西省九江市",
"86510", "江苏省无锡市",
"86180360", "江苏省无锡市",
"861521267", "安徽省淮南市",
"86139421", "辽宁省朝阳市",
"86156872", "云南省大理白族自治州",
"861839704", "青海省海东地区",
"861807694", "西藏林芝地区",
"861302842", "陕西省西安市",
"861318676", "浙江省丽水市",
"861534602", "河南省漯河市",
"861369823", "四川省宜宾市",
"861311777", "广西钦州市",
"861335871", "辽宁省阜新市",
"861534238", "湖北省黄冈市",
"861327482", "内蒙古兴安盟",
"861503387", "河北省邯郸市",
"861376280", "湖南省娄底市",
"861524077", "广西钦州市",
"86158321", "河北省石家庄市",
"861863559", "山西省太原市",
"861339599", "福建省厦门市",
"86183048", "内蒙古兴安盟",
"861530679", "浙江省金华市",
"861898169", "四川省巴中市",
"861894218", "湖北省十堰市",
"861817719", "广西崇左市",
"861370449", "吉林省白山市",
"861534279", "湖北省随州市",
"861830543", "山东省滨州市",
"861332631", "山东省威海市",
"861587750", "陕西省宝鸡市",
"861840203", "广东省佛山市",
"861598409", "四川省广元市",
"861361441", "吉林省长春市",
"861890618", "江苏省无锡市",
"861557942", "江西省上饶市",
"861390262", "广东省惠州市",
"861896653", "陕西省渭南市",
"861555784", "浙江省丽水市",
"861856751", "河南省信阳市",
"861879493", "甘肃省庆阳市",
"861853266", "河北省唐山市",
"86182845", "四川省成都市",
"861454949", "福建省宁德市",
"861364719", "湖北省荆州市",
"861818894", "湖南省郴州市",
"861787616", "广东省阳江市",
"861509942", "新疆伊犁哈萨克自治州",
"861876549", "山东省临沂市",
"861889400", "甘肃省兰州市",
"86157723", "贵州省安顺市",
"861571658", "河南省信阳市",
"861313453", "黑龙江省牡丹江市",
"861880315", "河北省唐山市",
"861787555", "广东省东莞市",
"861513972", "河南省商丘市",
"861359876", "河南省开封市",
"861570329", "河北省邢台市",
"861474039", "辽宁省朝阳市",
"861350765", "河南省漯河市",
"861831284", "广东省梅州市",
"861368535", "山东省烟台市",
"861510181", "甘肃省定西市",
"86182734", "湖南省衡阳市",
"861880796", "江西省吉安市",
"861346523", "山东省威海市",
"861520314", "河北省承德市",
"861345071", "广东省梅州市",
"861334833", "福建省三明市",
"86130250", "浙江省温州市",
"86186585", "浙江省绍兴市",
"861471891", "西藏拉萨市",
"86181261", "广东省深圳市",
"861802984", "广东省肇庆市",
"861300155", "山东省潍坊市",
"861458967", "广东省汕尾市",
"861510611", "江苏省常州市",
"861589160", "陕西省铜川市",
"861821930", "广东省湛江市",
"861576673", "广东省揭阳市",
"861858995", "广西柳州市",
"861569408", "四川省攀枝花市",
"861336443", "吉林省延边朝鲜族自治州",
"861892717", "广东省云浮市",
"861881375", "广东省广州市",
"861470969", "宁夏银川市",
"861882943", "陕西省渭南市",
"861337507", "福建省三明市",
"861824888", "江苏省苏州市",
"861500777", "广西钦州市",
"861569240", "广东省广州市",
"861309980", "云南省红河哈尼族彝族自治州",
"861571937", "甘肃省酒泉市",
"861476082", "江苏省泰州市",
"861855415", "山东省潍坊市",
"861558238", "山西省临汾市",
"86135162", "天津市",
"86147190", "甘肃省临夏回族自治州",
"86156305", "河北省唐山市",
"861519483", "河北省石家庄市",
"861592926", "陕西省渭南市",
"861477952", "江西省九江市",
"86150357", "山西省临汾市",
"861330794", "江西省抚州市",
"861324537", "山东省聊城市",
"861881341", "广东省汕头市",
"861708750", "江西省抚州市",
"861319633", "陕西省渭南市",
"861309563", "浙江省嘉兴市",
"861771274", "江苏省宿迁市",
"861554344", "吉林省四平市",
"861873646", "河南省三门峡市",
"86155693", "新疆阿克苏地区",
"861454177", "浙江省温州市",
"861321559", "安徽省黄山市",
"861558327", "四川省资阳市",
"861768707", "云南省玉溪市",
"861825749", "浙江省金华市",
"861450850", "江苏省扬州市",
"861331568", "河北省秦皇岛市",
"86152615", "江苏省无锡市",
"861315452", "黑龙江省齐齐哈尔市",
"86177141", "江苏省连云港市",
"861372115", "安徽省淮南市",
"86157219", "陕西省西安市",
"861700005", "上海市",
"861778095", "四川省绵阳市",
"861360415", "辽宁省丹东市",
"861309357", "安徽省宿州市",
"861357563", "浙江省舟山市",
"861347688", "湖北省咸宁市",
"861363930", "甘肃省白银市",
"861370882", "云南省丽江市",
"861534918", "陕西省咸阳市",
"861570828", "四川省自贡市",
"861874070", "陕西省西安市",
"86878", "云南省楚雄彝族自治州",
"86139493", "河南省南阳市",
"861538792", "江西省九江市",
"861356050", "广东省湛江市",
"861361475", "内蒙古通辽市",
"861572435", "辽宁省铁岭市",
"861399541", "宁夏银川市",
"861301611", "湖南省郴州市",
"861304271", "湖北省黄冈市",
"86176392", "河南省鹤壁市",
"861502639", "新疆阿克苏地区",
"861380490", "辽宁省沈阳市",
"861881835", "广东省潮州市",
"861771367", "四川省绵阳市",
"861820433", "吉林省延边朝鲜族自治州",
"861303912", "吉林省长春市",
"861576721", "广东省茂名市",
"86158930", "河南省焦作市",
"861815467", "广西玉林市",
"861334373", "河南省新乡市",
"861332700", "内蒙古呼伦贝尔市",
"86158393", "河南省濮阳市",
"861803854", "广东省河源市",
"861774029", "四川省自贡市",
"861459707", "宁夏固原市",
"861834995", "四川省自贡市",
"861530957", "宁夏吴忠市",
"861389706", "青海省海西蒙古族藏族自治州",
"861335845", "福建省南平市",
"861858174", "四川省南充市",
"861823046", "河北省廊坊市",
"861365359", "山西省运城市",
"861340963", "湖北省随州市",
"86184711", "湖北省宜昌市",
"86188874", "云南省曲靖市",
"86152796", "江西省吉安市",
"861327849", "吉林省辽源市",
"861779051", "四川省南充市",
"861890902", "四川省德阳市",
"861502880", "河北省衡水市",
"861569877", "辽宁省盘锦市",
"861359336", "山西省吕梁市",
"861841920", "甘肃省天水市",
"86138924", "陕西省宝鸡市",
"861558279", "山西省吕梁市",
"86183156", "山东省临沂市",
"861322085", "山东省青岛市",
"861598443", "四川省泸州市",
"861774064", "湖北省黄冈市",
"861888206", "四川省凉山彝族自治州",
"861389042", "四川省达州市",
"861830509", "浙江省湖州市",
"861819003", "四川省泸州市",
"861530380", "河南省商丘市",
"861342998", "湖北省武汉市",
"861319196", "河北省廊坊市",
"861593176", "河北省保定市",
"861308493", "广西柳州市",
"86159858", "福建省厦门市",
"861597567", "广东省阳江市",
"861850359", "山西省运城市",
"861585663", "安徽省池州市",
"86150773", "广西桂林市",
"86132488", "浙江省金华市",
"861528350", "四川省雅安市",
"861819716", "青海省海东地区",
"861336859", "贵州省黔西南布依族苗族自治州",
"861532759", "湖北省随州市",
"861840350", "山西省忻州市",
"861833986", "河南省三门峡市",
"861571677", "河南省新乡市",
"861362637", "山东省德州市",
"861452494", "内蒙古包头市",
"861331447", "贵州省毕节地区",
"861337596", "福建省漳州市",
"861573866", "河南省新乡市",
"861538047", "江苏省常州市",
"861372251", "河北省唐山市",
"861598074", "福建省福州市",
"86180983", "安徽省滁州市",
"861803404", "河北省石家庄市",
"861345898", "四川省德阳市",
"861768315", "四川省巴中市",
"861589954", "广东省惠州市",
"861536450", "山西省忻州市",
"861366345", "山西省长治市",
"861582539", "宁夏固原市",
"86155667", "辽宁省葫芦岛市",
"861503164", "河北省保定市",
"861844948", "新疆吐鲁番地区",
"861807135", "湖北省十堰市",
"861381511", "江苏省无锡市",
"861390414", "辽宁省本溪市",
"861528249", "四川省凉山彝族自治州",
"861319973", "新疆喀什地区",
"861476053", "宁夏吴忠市",
"861562487", "内蒙古兴安盟",
"861470018", "江苏省徐州市",
"861707171", "江西省吉安市",
"861563283", "河北省唐山市",
"861570617", "江苏省镇江市",
"861850240", "辽宁省沈阳市",
"86151396", "河南省驻马店市",
"861762529", "江苏省苏州市",
"861313849", "广东省广州市",
"861768796", "江西省吉安市",
"861817046", "江西省吉安市",
"861829955", "新疆阿克苏地区",
"861840987", "新疆昌吉回族自治州",
"861390072", "江西省吉安市",
"861561985", "陕西省延安市",
"861375921", "云南省德宏傣族景颇族自治州",
"861803269", "河北省石家庄市",
"861886471", "河南省安阳市",
"86131554", "安徽省淮南市",
"861555525", "安徽省亳州市",
"861363670", "陕西省西安市",
"861534069", "山西省太原市",
"861566425", "河南省南阳市",
"861502938", "陕西省榆林市",
"861898756", "云南省昆明市",
"861360738", "湖南省娄底市",
"861520667", "山东省淄博市",
"86139027", "广东省汕头市",
"86186388", "河南省洛阳市",
"861853076", "河南省商丘市",
"861370853", "贵州省安顺市",
"861343704", "江西省抚州市",
"861332945", "黑龙江省绥化市",
"86139467", "黑龙江省鹤岗市",
"861572718", "湖北省恩施土家族苗族自治州",
"86134779", "湖北省恩施土家族苗族自治州",
"861376818", "广西河池市",
"861520793", "江西省上饶市",
"861365240", "广东省深圳市",
"861588145", "四川省达州市",
"861591295", "云南省普洱市",
"861364702", "江西省九江市",
"861328309", "河南省驻马店市",
"861539331", "甘肃省平凉市",
"861313320", "山西省忻州市",
"861314777", "吉林省吉林市",
"861894880", "广东省梅州市",
"86133862", "上海市",
"86189732", "湖南省湘潭市",
"861531238", "江苏省泰州市",
"861598412", "四川省宜宾市",
"86153765", "山东省济宁市",
"861780782", "广西柳州市",
"86185783", "广东省佛山市",
"86185949", "广东省广州市",
"861315483", "内蒙古阿拉善盟",
"861890239", "广东省广州市",
"861350589", "浙江省金华市",
"86183509", "福建省南平市",
"861328477", "内蒙古鄂尔多斯市",
"86158367", "河南省驻马店市",
"861850877", "云南省玉溪市",
"861598358", "四川省攀枝花市",
"861316773", "安徽省合肥市",
"861817441", "湖南省长沙市",
"861360779", "广西北海市",
"861588516", "贵州省铜仁地区",
"861502979", "陕西省汉中市",
"861347989", "江西省九江市",
"861891218", "江苏省连云港市",
"861377284", "陕西省汉中市",
"86187681", "浙江省杭州市",
"861459796", "新疆巴音郭楞蒙古自治州",
"861364441", "吉林省长春市",
"86158524", "江苏省徐州市",
"861890278", "广东省梅州市",
"861300931", "辽宁省营口市",
"861882912", "陕西省榆林市",
"861531279", "江苏省泰州市",
"861857587", "广东省佛山市",
"861816916", "宁夏吴忠市",
"861459315", "四川省遂宁市",
"861585042", "江苏省扬州市",
"861520017", "河北省邢台市",
"861366831", "四川省德阳市",
"861885781", "浙江省丽水市",
"861311758", "湖南省娄底市",
"861361719", "湖北省十堰市",
"861862570", "河南省周口市",
"861809587", "新疆阿克苏地区",
"861305591", "福建省福州市",
"861888297", "四川省甘孜藏族自治州",
"861570067", "四川省自贡市",
"861346334", "河北省承德市",
"861597448", "湖南省常德市",
"861771582", "江苏省无锡市",
"861365877", "云南省玉溪市",
"861555336", "山东省滨州市",
"861818351", "云南省昆明市",
"861837900", "江西省新余市",
"861309838", "湖北省鄂州市",
"86181227", "广东省广州市",
"86138530", "山东省菏泽市",
"861853471", "山西省忻州市",
"86182686", "浙江省宁波市",
"861802050", "江苏省无锡市",
"861582578", "浙江省金华市",
"861363389", "河南省洛阳市",
"861580436", "吉林省白城市",
"861821888", "广东省广州市",
"861550088", "宁夏银川市",
"861830512", "江苏省连云港市",
"861770674", "浙江省宁波市",
"861571959", "宁夏银川市",
"861328343", "河北省邯郸市",
"861760426", "辽宁省大连市",
"861329521", "江苏省淮安市",
"86147617", "江苏省苏州市",
"861539871", "云南省昆明市",
"861800356", "山西省晋城市",
"861845901", "福建省福州市",
"861594984", "山东省威海市",
"861392197", "江苏省苏州市",
"86186295", "陕西省西安市",
"861329846", "河南省焦作市",
"861302751", "河南省郑州市",
"86135022", "广东省惠州市",
"861510245", "辽宁省丹东市",
"861454287", "辽宁省营口市",
"86135040", "辽宁省沈阳市",
"861504717", "内蒙古锡林郭勒盟",
"861559390", "甘肃省陇南市",
"86182880", "云南省西双版纳傣族自治州",
"861820060", "广东省清远市",
"861334568", "安徽省亳州市",
"861398450", "贵州省遵义市",
"861350022", "广东省广州市",
"861583043", "河北省保定市",
"861771614", "四川省成都市",
"861560951", "宁夏银川市",
"861508276", "四川省南充市",
"861336074", "广东省茂名市",
"861560694", "福建省福州市",
"861853445", "山西省长治市",
"86138260", "广东省广州市",
"861317199", "河北省沧州市",
"861883842", "河南省漯河市",
"861327453", "黑龙江省牡丹江市",
"861889850", "广东省茂名市",
"861528423", "河北省保定市",
"861309339", "安徽省阜阳市",
"861579733", "湖北省武汉市",
"861452788", "新疆喀什地区",
"861763547", "山西省吕梁市",
"861450248", "河北省石家庄市",
"861303909", "吉林省延边朝鲜族自治州",
"861336412", "辽宁省鞍山市",
"86183635", "山东省聊城市",
"86159662", "山东省聊城市",
"861530978", "青海省西宁市",
"86156516", "江苏省南京市",
"861890919", "陕西省铜川市",
"861310305", "河北省唐山市",
"861554047", "内蒙古呼伦贝尔市",
"86180937", "甘肃省酒泉市",
"861531918", "陕西省宝鸡市",
"861351424", "辽宁省大连市",
"861319410", "辽宁省铁岭市",
"861371745", "广东省佛山市",
"861364475", "内蒙古通辽市",
"861868811", "广东省中山市",
"86186522", "江苏省徐州市",
"861454648", "云南省玉溪市",
"861705668", "北京市",
"861877568", "广西柳州市",
"861575101", "江苏省镇江市",
"861569858", "山西省太原市",
"861530939", "甘肃省陇南市",
"861333815", "江苏省无锡市",
"861874260", "新疆阿克苏地区",
"861365228", "广东省佛山市",
"861891938", "甘肃省天水市",
"861522946", "陕西省汉中市",
"861770462", "福建省福州市",
"861893201", "贵州省贵阳市",
"861304611", "广东省汕尾市",
"861301271", "山东省淄博市",
"86153389", "海南省海口市",
"861595992", "福建省南平市",
"861893421", "广东省湛江市",
"861804892", "四川省泸州市",
"861831995", "广东省中山市",
"861331373", "福建省三明市",
"861705018", "安徽省合肥市",
"861552193", "广东省揭阳市",
"861825016", "福建省福州市",
"861313348", "山西省吕梁市",
"861365408", "辽宁省大连市",
"861346874", "陕西省榆林市",
"861478370", "河南省商丘市",
"861336358", "山西省吕梁市",
"861365337", "河北省沧州市",
"861330313", "河北省张家口市",
"861526444", "山东省潍坊市",
"861882608", "广东省广州市",
"861816236", "湖北省襄樊市",
"861870660", "山东省滨州市",
"861332971", "湖北省武汉市",
"861398534", "贵州省铜仁地区",
"861858284", "四川省达州市",
"861868125", "四川省成都市",
"861850408", "辽宁省大连市",
"861558619", "湖北省荆门市",
"861380545", "山东省烟台市",
"86183456", "黑龙江省鹤岗市",
"861359784", "湖北省随州市",
"86188350", "山西省忻州市",
"861500758", "广东省肇庆市",
"861366371", "河南省郑州市",
"861513428", "辽宁省葫芦岛市",
"861563996", "河南省平顶山市",
"861362958", "宁夏银川市",
"861820610", "江苏省镇江市",
"861892305", "广东省江门市",
"861558189", "山西省吕梁市",
"861842056", "广东省惠州市",
"861576933", "甘肃省平凉市",
"861326324", "甘肃省庆阳市",
"861880707", "江西省赣州市",
"861590532", "山东省青岛市",
"861838150", "四川省乐山市",
"861452301", "河南省商丘市",
"861313482", "内蒙古兴安盟",
"861514586", "黑龙江省鹤岗市",
"861593286", "江西省萍乡市",
"861357378", "山东省济南市",
"861890827", "重庆市",
"861832497", "安徽省安庆市",
"861880972", "青海省海东地区",
"861700654", "江苏省南京市",
"861501979", "广东省中山市",
"861555644", "安徽省滁州市",
"861350055", "安徽省安庆市",
"861811414", "江苏省徐州市",
"861700991", "新疆乌鲁木齐市",
"861778901", "西藏山南地区",
"861338690", "福建省莆田市",
"861843627", "河南省信阳市",
"861329462", "山西省大同市",
"861390865", "湖北省武汉市",
"861379074", "广东省中山市",
"861330231", "广东省深圳市",
"861522077", "广东省江门市",
"861870376", "河南省信阳市",
"861399776", "湖北省恩施土家族苗族自治州",
"861569727", "湖北省宜昌市",
"861327601", "福建省福州市",
"861570739", "湖南省邵阳市",
"861533848", "广东省茂名市",
"861864304", "吉林省白城市",
"861383892", "河南省焦作市",
"861362719", "湖北省襄樊市",
"861576871", "广东省湛江市",
"861452949", "广东省梅州市",
"861510813", "四川省资阳市",
"861810474", "内蒙古乌兰察布市",
"86159937", "河南省焦作市",
"861377226", "陕西省延安市",
"861500919", "陕西省铜川市",
"861522500", "河南省平顶山市",
"861477708", "广西河池市",
"861334631", "山东省威海市",
"861781721", "广东省河源市",
"861892147", "江苏省南通市",
"861709898", "广东省深圳市",
"861829896", "甘肃省嘉峪关市",
"86181021", "天津市",
"861314257", "湖南省邵阳市",
"861590356", "山西省晋城市",
"86147580", "浙江省宁波市",
"86136718", "上海市",
"86155341", "山西省长治市",
"861478411", "河南省商丘市",
"861810012", "浙江省宁波市",
"861811072", "安徽省宿州市",
"861834406", "广东省湛江市",
"86181418", "辽宁省阜新市",
"861358700", "浙江省衢州市",
"861860510", "江苏省无锡市",
"861867257", "湖北省荆州市",
"861314068", "河南省驻马店市",
"86187935", "甘肃省武威市",
"86139075", "海南省海口市",
"861379412", "广东省汕头市",
"861807420", "浙江省宁波市",
"86135313", "广东省佛山市",
"86181127", "江苏省苏州市",
"861705531", "山东省济南市",
"86130450", "山东省青岛市",
"861332833", "福建省漳州市",
"861536733", "湖南省长沙市",
"861310657", "广东省佛山市",
"861392474", "广东省惠州市",
"861342527", "广东省肇庆市",
"861364659", "浙江省金华市",
"861534737", "湖南省益阳市",
"861893562", "青海省海东地区",
"861700144", "江苏省扬州市",
"861303341", "山西省运城市",
"861770521", "江苏省徐州市",
"861361637", "山东省枣庄市",
"861453452", "安徽省合肥市",
"861587610", "广东省佛山市",
"861572677", "西藏拉萨市",
"861350566", "安徽省阜阳市",
"861319371", "河南省驻马店市",
"861332447", "吉林省长春市",
"86157558", "安徽省阜阳市",
"861845820", "浙江省杭州市",
"861786937", "云南省临沧市",
"861534086", "山西省晋城市",
"861880595", "福建省泉州市",
"861369621", "四川省南充市",
"861536385", "广东省惠州市",
"861826275", "江苏省连云港市",
"861367262", "广东省云浮市",
"861581539", "广东省惠州市",
"861800532", "山东省青岛市",
"86136706", "广东省佛山市",
"861840485", "内蒙古通辽市",
"861510751", "广东省韶关市",
"861594892", "吉林省白城市",
"861503421", "山西省大同市",
"861570778", "广西河池市",
"86138613", "江苏省镇江市",
"861533303", "山西省阳泉市",
"861506112", "江苏省常州市",
"861539933", "陕西省渭南市",
"861764053", "辽宁省辽阳市",
"861503201", "河北省邯郸市",
"86181275", "广东省江门市",
"861535280", "内蒙古呼伦贝尔市",
"861883061", "河北省廊坊市",
"861328592", "福建省厦门市",
"861501938", "广东省河源市",
"86145029", "山西省晋中市",
"861884909", "河北省衡水市",
"861869236", "湖南省常德市",
"861855259", "江苏省扬州市",
"861306432", "四川省达州市",
"861373480", "内蒙古包头市",
"861310147", "福建省宁德市",
"861760798", "江西省景德镇市",
"86139221", "广东省广州市",
"861331945", "江西省九江市",
"861345104", "湖北省黄石市",
"861556106", "内蒙古通辽市",
"861554976", "湖北省随州市",
"861339319", "河北省邢台市",
"861772029", "湖北省黄石市",
"86188811", "四川省绵阳市",
"861832995", "陕西省西安市",
"86184774", "广西梧州市",
"861334700", "内蒙古呼伦贝尔市",
"861332373", "河南省新乡市",
"861858406", "四川省成都市",
"861345502", "山东省日照市",
"861359960", "福建省龙岩市",
"861320806", "浙江省宁波市",
"861306640", "广东省江门市",
"861330911", "陕西省延安市",
"861593269", "河北省石家庄市",
"86188868", "贵州省六盘水市",
"861588479", "四川省泸州市",
"861561600", "湖南省长沙市",
"861302271", "山东省淄博市",
"86150732", "湖南省湘潭市",
"861331971", "新疆博尔塔拉蒙古自治州",
"861769246", "河北省秦皇岛市",
"861596690", "山东省青岛市",
"861881232", "云南省普洱市",
"86181559", "安徽省黄山市",
"861585298", "江苏省泰州市",
"861304489", "湖北省荆门市",
"861529799", "江西省萍乡市",
"861823637", "河南省商丘市",
"861777151", "湖北省咸宁市",
"861891305", "江苏省苏州市",
"861361958", "宁夏银川市",
"861512931", "陕西省西安市",
"861593404", "山西省太原市",
"86159983", "辽宁省沈阳市",
"861808074", "四川省广元市",
"861326386", "广西梧州市",
"861319345", "河南省许昌市",
"86155932", "甘肃省定西市",
"861324085", "内蒙古呼伦贝尔市",
"861573388", "河北省衡水市",
"861803993", "河南省三门峡市",
"861339818", "四川省成都市",
"861813899", "广东省江门市",
"861301813", "四川省绵阳市",
"861317096", "江西省吉安市",
"861518547", "贵州省黔南布依族苗族自治州",
"86152678", "浙江省宁波市",
"86132288", "江苏省南通市",
"861886947", "云南省红河哈尼族彝族自治州",
"861383926", "河南省濮阳市",
"861837546", "山东省东营市",
"861700542", "山东省济南市",
"86130744", "广东省肇庆市",
"861845848", "浙江省温州市",
"861373322", "河北省保定市",
"861893164", "河北省廊坊市",
"861826241", "江苏省南通市",
"86147348", "广东省广州市",
"861899470", "江苏省泰州市",
"861459428", "云南省怒江傈僳族自治州",
"861558481", "吉林省通化市",
"861868554", "贵州省遵义市",
"861560353", "山西省阳泉市",
"861364977", "青海省海南藏族自治州",
"861351161", "江苏省苏州市",
"861771126", "四川省阿坝藏族羌族自治州",
"861822888", "四川省巴中市",
"86152547", "山东省济宁市",
"861780063", "内蒙古巴彦淖尔市",
"861538976", "内蒙古赤峰市",
"861314902", "广东省清远市",
"861884943", "河北省张家口市",
"861306150", "山东省聊城市",
"861572959", "宁夏银川市",
"861552860", "四川省南充市",
"861356760", "浙江省丽水市",
"861868273", "四川省成都市",
"86183981", "四川省遂宁市",
"861772614", "湖南省衡阳市",
"861328941", "陕西省咸阳市",
"861452177", "吉林省辽源市",
"861875124", "江苏省连云港市",
"861760484", "内蒙古呼和浩特市",
"861777641", "广西河池市",
"861843280", "河北省邯郸市",
"861388247", "四川省凉山彝族自治州",
"861533349", "山西省朔州市",
"861301751", "河南省焦作市",
"861475654", "河北省唐山市",
"861322537", "山东省济宁市",
"861772184", "四川省成都市",
"861867902", "江西省九江市",
"861864491", "吉林省四平市",
"861501218", "云南省文山壮族苗族自治州",
"861380669", "浙江省温州市",
"861776961", "浙江省嘉兴市",
"861470531", "山东省济南市",
"861768208", "安徽省阜阳市",
"861588438", "四川省乐山市",
"861575229", "云南省红河哈尼族彝族自治州",
"861351486", "内蒙古赤峰市",
"86156376", "河南省信阳市",
"861889747", "湖南省怀化市",
"861453819", "四川省南充市",
"861768632", "山东省枣庄市",
"861335721", "湖南省长沙市",
"861315598", "江西省九江市",
"861311827", "四川省南充市",
"861551636", "河南省洛阳市",
"861560567", "安徽省亳州市",
"861594760", "内蒙古赤峰市",
"861388688", "湖北省随州市",
"86139293", "广东省汕尾市",
"86145870", "广东省广州市",
"861859448", "福建省泉州市",
"861558737", "山东省烟台市",
"861835048", "福建省龙岩市",
"861831856", "广东省韶关市",
"861319831", "四川省达州市",
"861389505", "宁夏吴忠市",
"86176128", "四川省成都市",
"861868430", "吉林省长春市",
"861887017", "江西省鹰潭市",
"861533820", "广东省惠州市",
"86170080", "重庆市",
"861576845", "广东省深圳市",
"861532918", "贵州省六盘水市",
"861370285", "广东省佛山市",
"861323570", "浙江省衢州市",
"861358978", "山东省烟台市",
"861315470", "内蒙古呼伦贝尔市",
"861308581", "广东省珠海市",
"861317525", "浙江省绍兴市",
"86155754", "湖南省衡阳市",
"86180531", "山东省济南市",
"86187065", "山东省潍坊市",
"861368704", "江西省抚州市",
"861850514", "江苏省扬州市",
"861518555", "贵州省黔东南苗族侗族自治州",
"861856239", "山东省东营市",
"861515879", "浙江省衢州市",
"861572651", "山东省聊城市",
"861882320", "广东省深圳市",
"861572994", "新疆吐鲁番地区",
"861319357", "河南省濮阳市",
"86135627", "山东省济宁市",
"861864525", "黑龙江省牡丹江市",
"861323498", "黑龙江省哈尔滨市",
"861518461", "黑龙江省七台河市",
"861311061", "福建省龙岩市",
"861874052", "陕西省榆林市",
"861363683", "陕西省咸阳市",
"861851574", "四川省德阳市",
"861472898", "西藏拉萨市",
"86187425", "辽宁省大连市",
"861829471", "甘肃省陇南市",
"861302902", "吉林省四平市",
"861510777", "广西钦州市",
"861380961", "广东省东莞市",
"861854300", "吉林省长春市",
"861892671", "广东省茂名市",
"861320267", "广东省东莞市",
"861882849", "四川省南充市",
"861890489", "黑龙江省大庆市",
"861315233", "陕西省咸阳市",
"861509483", "山东省日照市",
"861365514", "江苏省连云港市",
"861531488", "浙江省丽水市",
"861560702", "江西省九江市",
"861338088", "广东省中山市",
"861599515", "江苏省盐城市",
"861333710", "内蒙古呼和浩特市",
"86183816", "四川省绵阳市",
"861324793", "江西省上饶市",
"861837187", "湖北省随州市",
"861331422", "辽宁省沈阳市",
"861345136", "内蒙古赤峰市",
"86159161", "广东省佛山市",
"86159427", "辽宁省盘锦市",
"861538022", "江苏省镇江市",
"861525906", "福建省宁德市",
"861336982", "新疆伊犁哈萨克自治州",
"86151357", "山西省临汾市",
"861458558", "山东省日照市",
"86133100", "上海市",
"861869424", "河北省石家庄市",
"86153840", "浙江省杭州市",
"861898468", "贵州省黔西南布依族苗族自治州",
"861846044", "江西省萍乡市",
"86133725", "浙江省杭州市",
"86153822", "辽宁省大连市",
"8613268", "广东省东莞市",
"861370148", "江苏省常州市",
"861341542", "广东省中山市",
"861319563", "安徽省宣城市",
"861773290", "河北省秦皇岛市",
"861778153", "四川省成都市",
"861362448", "吉林省松原市",
"861557802", "广西南宁市",
"86183163", "广东省惠州市",
"861577114", "湖北省荆州市",
"86138327", "河北省沧州市",
"861373105", "河北省保定市",
"86155185", "河南省濮阳市",
"8614742", "四川省成都市",
"861835265", "江苏省南通市",
"861398940", "浙江省金华市",
"861311466", "黑龙江省齐齐哈尔市",
"861454809", "广东省惠州市",
"861330619", "江苏省无锡市",
"861576091", "陕西省榆林市",
"861317336", "山东省东营市",
"861378049", "河北省邢台市",
"861599146", "陕西省汉中市",
"861570900", "新疆博尔塔拉蒙古自治州",
"861571449", "吉林省白山市",
"86138564", "安徽省六安市",
"861326797", "广东省珠海市",
"861899598", "湖北省武汉市",
"861334219", "辽宁省锦州市",
"86183808", "四川省宜宾市",
"861340824", "四川省乐山市",
"861331679", "广东省惠州市",
"861576857", "广东省惠州市",
"861318493", "河北省沧州市",
"861776019", "四川省自贡市",
"861345767", "广西桂林市",
"861379894", "广东省东莞市",
"861528372", "四川省阿坝藏族羌族自治州",
"86151773", "广西桂林市",
"861535125", "四川省绵阳市",
"861313912", "青海省海东地区",
"861360321", "河北省石家庄市",
"861339782", "广西柳州市",
"861861784", "河北省秦皇岛市",
"861580993", "新疆石河子市",
"861827224", "湖北省荆州市",
"861811892", "江苏省无锡市",
"86182349", "山西省朔州市",
"861311181", "四川省甘孜藏族自治州",
"861885158", "江苏省无锡市",
"861813854", "广东省佛山市",
"861867271", "湖北省襄樊市",
"861848537", "贵州省黔南布依族苗族自治州",
"861565150", "江苏省无锡市",
"861527164", "湖北省黄冈市",
"861320374", "河南省郑州市",
"861509802", "湖北省黄冈市",
"861551765", "河南省驻马店市",
"861829076", "新疆石河子市",
"861383414", "山西省太原市",
"86185897", "重庆市",
"861834434", "广东省广州市",
"86134180", "广东省广州市",
"861505107", "江苏省盐城市",
"861370658", "浙江省嘉兴市",
"861305318", "安徽省亳州市",
"86188139", "广东省深圳市",
"861539728", "浙江省嘉兴市",
"861376613", "吉林省白城市",
"861454437", "江苏省宿迁市",
"861530568", "安徽省阜阳市",
"861520559", "安徽省黄山市",
"86180475", "内蒙古通辽市",
"86138234", "广东省佛山市",
"861364694", "福建省宁德市",
"861341991", "河南省南阳市",
"861865047", "福建省福州市",
"861364951", "宁夏银川市",
"861533752", "福建省厦门市",
"861856919", "湖南省张家界市",
"861892155", "江苏省镇江市",
"861390984", "辽宁省大连市",
"861539740", "浙江省温州市",
"861457029", "江西省萍乡市",
"861584686", "黑龙江省黑河市",
"86155422", "辽宁省沈阳市",
"861314245", "内蒙古巴彦淖尔市",
"861538589", "安徽省合肥市",
"86511", "江苏省镇江市",
"861763522", "山西省大同市",
"861312842", "广东省潮州市",
"861310645", "浙江省台州市",
"86155062", "江苏省苏州市",
"861773055", "河北省石家庄市",
"861346517", "山东省德州市",
"861454308", "黑龙江省大庆市",
"861867245", "湖北省恩施土家族苗族自治州",
"861301777", "浙江省嘉兴市",
"861878633", "贵州省遵义市",
"861833416", "贵州省毕节地区",
"861308676", "广西贺州市",
"861360294", "广东省清远市",
"861880421", "辽宁省朝阳市",
"86139640", "山东省济南市",
"861820907", "新疆阿勒泰地区",
"861302188", "河北省石家庄市",
"861560475", "内蒙古通辽市",
"86177013", "北京市",
"861598982", "广东省汕头市",
"861572175", "贵州省毕节地区",
"86177807", "四川省成都市",
"861340368", "山西省忻州市",
"861782878", "四川省南充市",
"861350047", "辽宁省营口市",
"861582002", "山东省青岛市",
"86158242", "浙江省宁波市",
"861812508", "广东省清远市",
"861323784", "广西贺州市",
"861369964", "四川省广安市",
"861334978", "湖北省宜昌市",
"861831962", "广东省惠州市",
"861348389", "河北省承德市",
"861804865", "四川省乐山市",
"861840417", "辽宁省营口市",
"861596088", "福建省龙岩市",
"861597958", "江西省抚州市",
"861398928", "四川省绵阳市",
"861766045", "山东省青岛市",
"861303453", "山东省聊城市",
"861310723", "湖南省湘西土家族苗族自治州",
"861562829", "新疆伊犁哈萨克自治州",
"861335905", "安徽省马鞍山市",
"861567197", "湖北省孝感市",
"861519942", "新疆昌吉回族自治州",
"861700699", "广东省广州市",
"861861498", "河南省郑州市",
"861856827", "河南省信阳市",
"861501671", "广东省深圳市",
"861327909", "新疆阿克苏地区",
"861454781", "山东省济南市",
"861362420", "辽宁省鞍山市",
"861556532", "河南省许昌市",
"861890842", "湖南省邵阳市",
"86183497", "四川省德阳市",
"861534313", "河北省张家口市",
"861320834", "四川省凉山彝族自治州",
"86183610", "江苏省苏州市",
"861347419", "陕西省渭南市",
"86180261", "广东省肇庆市",
"861310155", "黑龙江省绥化市",
"861452641", "江苏省连云港市",
"86131250", "湖北省武汉市",
"861894785", "内蒙古乌兰察布市",
"861457184", "浙江省温州市",
"86180218", "江苏省盐城市",
"861302068", "山东省济宁市",
"861369817", "四川省阿坝藏族羌族自治州",
"861334939", "黑龙江省大庆市",
"861500611", "江苏省常州市",
"861536940", "河北省石家庄市",
"861589444", "云南省德宏傣族景颇族自治州",
"861777177", "湖北省武汉市",
"861365682", "浙江省舟山市",
"86184036", "黑龙江省鸡西市",
"861310586", "浙江省台州市",
"861354168", "四川省自贡市",
"861537660", "山东省烟台市",
"86131303", "辽宁省抚顺市",
"86137797", "新疆阿克苏地区",
"861571403", "辽宁省铁岭市",
"861300093", "辽宁省营口市",
"861895371", "山东省枣庄市",
"861331380", "福建省三明市",
"861850682", "浙江省杭州市",
"861332561", "新疆乌鲁木齐市",
"861317876", "广东省汕头市",
"861809049", "四川省雅安市",
"861390508", "福建省泉州市",
"861808894", "云南省普洱市",
"861870804", "西藏林芝地区",
"861304758", "江苏省宿迁市",
"861882348", "广东省佛山市",
"861850851", "贵州省贵阳市",
"86177322", "河北省保定市",
"861328451", "黑龙江省哈尔滨市",
"86187477", "内蒙古鄂尔多斯市",
"861890061", "江苏省苏州市",
"861312466", "贵州省黔南布依族苗族自治州",
"861533153", "云南省保山市",
"861538290", "广东省汕头市",
"861325582", "浙江省湖州市",
"861530631", "山东省威海市",
"861569006", "河北省秦皇岛市",
"861773022", "安徽省合肥市",
"86159206", "广东省东莞市",
"86183263", "安徽省六安市",
"86135675", "浙江省绍兴市",
"86155285", "四川省绵阳市",
"861527201", "湖北省黄冈市",
"861330481", "黑龙江省哈尔滨市",
"861576740", "广东省茂名市",
"86130616", "上海市",
"861353674", "广东省梅州市",
"861347576", "山东省济宁市",
"861328565", "安徽省合肥市",
"861502586", "甘肃省定西市",
"861374739", "河南省周口市",
"861399520", "宁夏银川市",
"861572449", "辽宁省阜新市",
"861529367", "甘肃省平凉市",
"861803031", "福建省厦门市",
"861521897", "广东省汕头市",
"861335878", "辽宁省丹东市",
"861560149", "江苏省常州市",
"861707647", "山东省济宁市",
"861534231", "湖北省襄樊市",
"861516143", "江苏省扬州市",
"861780319", "河北省邢台市",
"86170805", "江苏省南通市",
"861859958", "福建省莆田市",
"861317644", "山东省济南市",
"861812892", "广东省韶关市",
"86150050", "福建省福州市",
"861344005", "四川省泸州市",
"861333887", "江苏省泰州市",
"861322314", "河北省邯郸市",
"86133777", "广东省东莞市",
"861558911", "山东省临沂市",
"861802501", "广东省阳江市",
"861327341", "河北省石家庄市",
"861818377", "云南省西双版纳傣族自治州",
"861365851", "贵州省贵阳市",
"861880562", "安徽省铜陵市",
"86156721", "湖北省荆州市",
"86134280", "广东省惠州市",
"861868627", "内蒙古通辽市",
"861502723", "湖北省恩施土家族苗族自治州",
"861511880", "广东省珠海市",
"86188239", "广东省汕头市",
"861853457", "山西省太原市",
"861537376", "河北省邯郸市",
"861841941", "甘肃省平凉市",
"861893595", "新疆和田地区",
"861569742", "湖南省常德市",
"861580391", "河南省焦作市",
"861360923", "陕西省渭南市",
"861345039", "广东省广州市",
"86176857", "山东省青岛市",
"861869081", "新疆乌鲁木齐市",
"861356865", "四川省凉山彝族自治州",
"861316929", "广东省揭阳市",
"861571651", "河南省许昌市",
"861803436", "河北省廊坊市",
"861760914", "陕西省商洛市",
"861564259", "辽宁省葫芦岛市",
"861571994", "新疆乌鲁木齐市",
"861881320", "广东省阳江市",
"861533643", "山东省淄博市",
"861839384", "甘肃省白银市",
"861373473", "内蒙古乌海市",
"861593518", "山西省吕梁市",
"861380557", "安徽省宿州市",
"861308844", "内蒙古包头市",
"861865976", "福建省龙岩市",
"861387210", "湖北省黄石市",
"861308360", "河南省郑州市",
"861319764", "广西桂林市",
"861304827", "广东省梅州市",
"86188451", "黑龙江省哈尔滨市",
"86157946", "天津市",
"861535273", "新疆石河子市",
"861889275", "四川省内江市",
"861767100", "湖北省武汉市",
"861345078", "广东省佛山市",
"861820772", "广西柳州市",
"861471898", "西藏拉萨市",
"86187910", "陕西省咸阳市",
"861852574", "辽宁省葫芦岛市",
"861365713", "湖北省黄冈市",
"861330737", "湖南省益阳市",
"861510618", "江苏省无锡市",
"861521456", "黑龙江省黑河市",
"861890466", "黑龙江省哈尔滨市",
"861324594", "内蒙古赤峰市",
"861800043", "河北省保定市",
"86138375", "河南省平顶山市",
"861569401", "四川省成都市",
"861450185", "山西省长治市",
"861514147", "辽宁省铁岭市",
"861317154", "河北省邯郸市",
"86183587", "浙江省温州市",
"861518124", "四川省雅安市",
"861350976", "山西省晋城市",
"861335110", "黑龙江省哈尔滨市",
"86130608", "广东省广州市",
"861301902", "黑龙江省鹤岗市",
"861867751", "广西贵港市",
"86150892", "广东省惠州市",
"861335680", "山东省威海市",
"861452812", "四川省攀枝花市",
"861316817", "广东省云浮市",
"861454215", "河南省南阳市",
"861396566", "安徽省宣城市",
"861332638", "山东省烟台市",
"861335839", "福建省厦门市",
"861853896", "河南省南阳市",
"861368503", "福建省福州市",
"861361448", "吉林省松原市",
"861890611", "江苏省常州市",
"861329495", "云南省昆明市",
"861327835", "吉林省通化市",
"861535430", "河北省邯郸市",
"861390892", "西藏日喀则地区",
"861380363", "黑龙江省齐齐哈尔市",
"861343736", "广东省东莞市",
"861374778", "内蒙古鄂尔多斯市",
"861332422", "辽宁省鞍山市",
"86152941", "甘肃省兰州市",
"861367050", "广东省汕头市",
"861319605", "吉林省辽源市",
"861361420", "辽宁省鞍山市",
"861325064", "广东省汕头市",
"861899483", "江苏省盐城市",
"861568020", "四川省内江市",
"861500489", "内蒙古赤峰市",
"861375472", "山东省临沂市",
"861301257", "山东省烟台市",
"861822683", "安徽省滁州市",
"861535642", "浙江省湖州市",
"861307007", "新疆和田地区",
"861570546", "山东省东营市",
"861874025", "辽宁省营口市",
"861700527", "江苏省宿迁市",
"861537836", "四川省攀枝花市",
"861539496", "云南省普洱市",
"86180118", "广东省广州市",
"861804072", "新疆伊犁哈萨克自治州",
"861570821", "四川省德阳市",
"861816204", "山东省济宁市",
"861398506", "贵州省黔南布依族苗族自治州",
"861534911", "陕西省延安市",
"861301068", "广东省东莞市",
"861781110", "宁夏银川市",
"861533272", "内蒙古包头市",
"861818837", "四川省内江市",
"861366563", "安徽省宣城市",
"86180427", "辽宁省盘锦市",
"86180161", "四川省德阳市",
"861332957", "黑龙江省鸡西市",
"861317552", "浙江省金华市",
"861305425", "黑龙江省绥化市",
"861811984", "安徽省淮北市",
"861363712", "安徽省池州市",
"86153307", "吉林省吉林市",
"861453942", "广东省江门市",
"861781680", "浙江省温州市",
"861530700", "江西省南昌市",
"861824743", "内蒙古乌兰察布市",
"86156793", "江西省上饶市",
"861366357", "山西省临汾市",
"861572403", "广东省佛山市",
"861824881", "江苏省无锡市",
"861550690", "福建省福州市",
"861306300", "福建省漳州市",
"861331455", "黑龙江省绥化市",
"861379982", "福建省漳州市",
"86159531", "山东省济南市",
"861554290", "辽宁省葫芦岛市",
"861812760", "广东省云浮市",
"86155398", "河南省三门峡市",
"861778752", "云南省保山市",
"86158978", "湖北省十堰市",
"861881348", "广东省惠州市",
"861860463", "黑龙江省牡丹江市",
"861816469", "云南省楚雄彝族自治州",
"861332380", "河南省新乡市",
"861331561", "河北省廊坊市",
"861459387", "贵州省黔西南布依族苗族自治州",
"861323583", "浙江省嘉兴市",
"861452459", "黑龙江省大庆市",
"861474045", "辽宁省葫芦岛市",
"861327375", "河南省平顶山市",
"861348366", "河北省石家庄市",
"861561917", "陕西省宝鸡市",
"861840915", "陕西省安康市",
"861876535", "山东省烟台市",
"861770997", "新疆阿克苏地区",
"861859637", "山东省济宁市",
"861335379", "河南省洛阳市",
"861368549", "山东省临沂市",
"861776571", "广东省珠海市",
"861342654", "江西省赣州市",
"861768950", "西藏拉萨市",
"861857146", "湖北省武汉市",
"861589999", "广东省广州市",
"861342991", "湖北省黄冈市",
"861323960", "甘肃省庆阳市",
"861510902", "新疆哈密地区",
"861369780", "山东省临沂市",
"861889722", "青海省海东地区",
"861853922", "河南省鹤壁市",
"861364353", "山西省阳泉市",
"86132344", "吉林省长春市",
"861311842", "四川省资阳市",
"861841975", "甘肃省武威市",
"86183533", "山东省淄博市",
"861560977", "青海省海西蒙古族藏族自治州",
"861304278", "湖北省襄樊市",
"861373910", "江苏省泰州市",
"861323726", "湖北省随州市",
"861301618", "湖南省衡阳市",
"86188569", "安徽省合肥市",
"861388402", "甘肃省临夏回族自治州",
"861399548", "宁夏银川市",
"86158142", "广东省东莞市",
"86158705", "重庆市",
"861576728", "广东省江门市",
"861538566", "安徽省池州市",
"861339613", "湖北省咸宁市",
"861818443", "贵州省毕节地区",
"861811508", "江苏省扬州市",
"861843273", "河北省张家口市",
"86158120", "云南省昆明市",
"861879360", "甘肃省武威市",
"861370435", "吉林省通化市",
"861871890", "广东省广州市",
"86180106", "四川省成都市",
"861364567", "安徽省阜阳市",
"861879844", "贵州省黔南布依族苗族自治州",
"861768387", "湖北省黄石市",
"861525540", "安徽省淮南市",
"86137019", "上海市",
"86130810", "河北省石家庄市",
"861303730", "湖南省岳阳市",
"861584669", "黑龙江省鹤岗市",
"861572882", "广东省揭阳市",
"861898990", "西藏拉萨市",
"861325184", "吉林省四平市",
"861779058", "四川省内江市",
"86181858", "贵州省六盘水市",
"861454935", "江苏省南通市",
"861533609", "甘肃省陇南市",
"861813176", "河北省唐山市",
"861344655", "山东省菏泽市",
"861361695", "福建省三明市",
"861378742", "湖南省湘潭市",
"861350345", "河南省郑州市",
"86185330", "河北省唐山市",
"86170860", "山东省青岛市",
"86181654", "陕西省西安市",
"86156161", "湖南省长沙市",
"861594738", "内蒙古巴彦淖尔市",
"86156427", "辽宁省盘锦市",
"861871481", "安徽省合肥市",
"861830757", "广东省佛山市",
"861534795", "江西省宜春市",
"861392448", "广东省梅州市",
"86188373", "河南省新乡市",
"86133471", "内蒙古呼和浩特市",
"861329648", "山东省青岛市",
"861862671", "吉林省长春市",
"861310726", "湖南省永州市",
"861303456", "山东省威海市",
"861593270", "河北省沧州市",
"861580822", "四川省自贡市",
"861801829", "江苏省泰州市",
"861569515", "江苏省盐城市",
"861811923", "新疆伊犁哈萨克自治州",
"861880537", "山东省济宁市",
"861590702", "江西省九江市",
"86182776", "广西百色市",
"86158894", "广东省深圳市",
"861860489", "内蒙古巴彦淖尔市",
"861534316", "河北省廊坊市",
"861479741", "山西省吕梁市",
"861808020", "四川省内江市",
"86183355", "山西省长治市",
"86177429", "辽宁省葫芦岛市",
"861760832", "四川省内江市",
"861396605", "安徽省蚌埠市",
"86136959", "福建省漳州市",
"861822669", "安徽省宣城市",
"861310960", "陕西省咸阳市",
"861813225", "河北省唐山市",
"861523902", "河南省焦作市",
"861832658", "安徽省马鞍山市",
"861555639", "安徽省阜阳市",
"861317873", "广东省梅州市",
"861550205", "广东省中山市",
"861894525", "黑龙江省大庆市",
"86187771", "广西南宁市",
"861572284", "江苏省镇江市",
"861550425", "辽宁省大连市",
"861459559", "青海省海西蒙古族藏族自治州",
"86131044", "吉林省长春市",
"861570744", "湖南省张家界市",
"861814731", "内蒙古乌海市",
"861813405", "河北省唐山市",
"861529332", "甘肃省平凉市",
"861825291", "江苏省盐城市",
"861511304", "广东省佛山市",
"861398704", "云南省丽江市",
"861809394", "甘肃省甘南藏族自治州",
"86182915", "陕西省安康市",
"861310583", "浙江省嘉兴市",
"861864873", "内蒙古呼和浩特市",
"86187904", "河南省信阳市",
"861775164", "江苏省泰州市",
"861801340", "江苏省无锡市",
"861454521", "广西南宁市",
"861384847", "内蒙古鄂尔多斯市",
"861593433", "山西省阳泉市",
"861300096", "新疆乌鲁木齐市",
"861571406", "辽宁省大连市",
"86180793", "江西省上饶市",
"861800977", "青海省海西蒙古族藏族自治州",
"861538764", "四川省南充市",
"861307938", "甘肃省嘉峪关市",
"861595150", "江苏省无锡市",
"861878636", "贵州省黔南布依族苗族自治州",
"861329158", "浙江省金华市",
"861303051", "江西省景德镇市",
"861555678", "安徽省阜阳市",
"861806591", "福建省福州市",
"861833413", "贵州省安顺市",
"861552879", "四川省成都市",
"861824490", "广东省广州市",
"861898599", "贵州省黔西南布依族苗族自治州",
"861308673", "广西桂林市",
"861810448", "吉林省松原市",
"861537945", "甘肃省金昌市",
"861822019", "陕西省西安市",
"861363571", "湖北省十堰市",
"861390321", "河北省石家庄市",
"861584683", "黑龙江省双鸭山市",
"86185673", "河南省许昌市",
"861840791", "江西省南昌市",
"861337759", "广东省湛江市",
"861538729", "湖北省随州市",
"861327768", "湖北省武汉市",
"861700139", "四川省成都市",
"861378401", "河北省邯郸市",
"861300491", "福建省宁德市",
"861323569", "湖北省襄樊市",
"861333558", "安徽省阜阳市",
"861708079", "湖南省衡阳市",
"861869598", "河南省南阳市",
"861517278", "湖北省随州市",
"86137581", "浙江省杭州市",
"861787627", "广东省梅州市",
"861536665", "江苏省连云港市",
"861594779", "内蒙古通辽市",
"861325755", "河北省石家庄市",
"861508280", "四川省广元市",
"861359938", "福建省福州市",
"861367487", "内蒙古赤峰市",
"86136846", "黑龙江省哈尔滨市",
"861700810", "江苏省盐城市",
"86182964", "江西省抚州市",
"861380670", "浙江省嘉兴市",
"861321707", "江西省赣州市",
"861453088", "安徽省六安市",
"861561262", "河北省廊坊市",
"861316548", "山东省淄博市",
"861368940", "甘肃省天水市",
"861865831", "浙江省台州市",
"86147902", "安徽省六安市",
"861582881", "四川省内江市",
"861565965", "福建省漳州市",
"861599143", "陕西省西安市",
"861598292", "四川省德阳市",
"861800149", "江苏省常州市",
"86185921", "陕西省西安市",
"861532260", "广东省汕头市",
"861399964", "新疆喀什地区",
"861318496", "河北省衡水市",
"861807474", "广西梧州市",
"86159809", "福建省厦门市",
"861316520", "山东省日照市",
"86139149", "江苏省苏州市",
"861398015", "四川省广元市",
"861539588", "浙江省嘉兴市",
"861566088", "河南省商丘市",
"861322595", "福建省泉州市",
"861556951", "新疆吐鲁番地区",
"861855984", "福建省三明市",
"861857742", "广西梧州市",
"861886080", "江苏省宿迁市",
"861473067", "河北省石家庄市",
"861378394", "河南省周口市",
"861300304", "安徽省芜湖市",
"861557081", "湖南省娄底市",
"861590475", "内蒙古通辽市",
"86152251", "河南省郑州市",
"861809006", "四川省成都市",
"86136622", "广东省深圳市",
"861820511", "江苏省盐城市",
"861311463", "黑龙江省牡丹江市",
"861317333", "山东省德州市",
"861772850", "广东省惠州市",
"861587079", "江西省抚州市",
"861476975", "山东省菏泽市",
"861509081", "湖北省荆州市",
"861810420", "辽宁省鞍山市",
"861803750", "河南省郑州市",
"861760372", "河南省安阳市",
"861809742", "青海省西宁市",
"861536704", "湖南省岳阳市",
"86157256", "山东省潍坊市",
"861829073", "新疆石河子市",
"861558316", "四川省广元市",
"861870561", "安徽省淮北市",
"861508627", "贵州省铜仁地区",
"861897245", "湖北省十堰市",
"861346901", "湖南省株洲市",
"861347774", "湖北省黄石市",
"86180721", "浙江省温州市",
"861394951", "河南省安阳市",
"861814600", "福建省宁德市",
"861815885", "安徽省合肥市",
"861580996", "新疆巴音郭楞蒙古自治州",
"861592917", "陕西省延安市",
"861807012", "江西省南昌市",
"861475139", "江苏省徐州市",
"86135871", "浙江省丽水市",
"861870455", "黑龙江省绥化市",
"861570392", "河南省鹤壁市",
"861521730", "广东省广州市",
"861360984", "辽宁省大连市",
"86158760", "广东省中山市",
"861809401", "福建省福州市",
"861512199", "宁夏中卫市",
"861516049", "福建省莆田市",
"861858718", "云南省丽江市",
"861322972", "广东省云浮市",
"861800659", "浙江省台州市",
"861761458", "黑龙江省伊春市",
"861318857", "辽宁省盘锦市",
"861363686", "陕西省延安市",
"861807662", "广西南宁市",
"861355842", "广西柳州市",
"861801237", "江苏省无锡市",
"861509161", "陕西省汉中市",
"861815621", "安徽省铜陵市",
"861364532", "山东省青岛市",
"861804259", "浙江省金华市",
"861511491", "陕西省延安市",
"861318091", "吉林省延边朝鲜族自治州",
"861395112", "江苏省苏州市",
"861345133", "内蒙古赤峰市",
"86183119", "贵州省六盘水市",
"861525903", "福建省龙岩市",
"86151495", "内蒙古鄂尔多斯市",
"861395682", "安徽省阜阳市",
"861324315", "河南省南阳市",
"861350371", "河南省郑州市",
"861855508", "安徽省阜阳市",
"86152439", "湖南省邵阳市",
"861319566", "安徽省池州市",
"861778156", "四川省广元市",
"861351311", "河北省石家庄市",
"86186892", "广东省佛山市",
"861806942", "浙江省杭州市",
"861392200", "广东省阳江市",
"861597197", "湖北省武汉市",
"861586400", "山东省济南市",
"861476592", "重庆市",
"861308721", "湖南省湘潭市",
"861479775", "广西玉林市",
"861592829", "四川省泸州市",
"861595628", "安徽省宣城市",
"861530499", "辽宁省葫芦岛市",
"861780547", "山东省济宁市",
"861509486", "山东省淄博市",
"861315236", "陕西省渭南市",
"861330890", "西藏拉萨市",
"861359218", "河南省平顶山市",
"861860842", "湖南省郴州市",
"861859662", "福建省厦门市",
"861324796", "江西省吉安市",
"861533334", "河北省秦皇岛市",
"861820079", "广东省河源市",
"861551879", "河南省安阳市",
"861324632", "广东省佛山市",
"861538357", "山西省临汾市",
"861340775", "广西河池市",
"861337327", "河北省秦皇岛市",
"861470701", "江西省鹰潭市",
"861351470", "内蒙古呼伦贝尔市",
"861364356", "山西省晋城市",
"86181872", "云南省大理白族自治州",
"861339555", "安徽省马鞍山市",
"861877454", "湖南省张家界市",
"861324428", "吉林省松原市",
"861831217", "广东省河源市",
"861323586", "浙江省台州市",
"86132817", "四川省达州市",
"861337238", "浙江省丽水市",
"861524482", "四川省眉山市",
"86133165", "广东省深圳市",
"861350410", "辽宁省铁岭市",
"861306575", "浙江省绍兴市",
"861707998", "浙江省嘉兴市",
"861309792", "广西贵港市",
"861337602", "江苏省泰州市",
"861550819", "四川省凉山彝族自治州",
"861353935", "广东省潮州市",
"86159721", "湖北省武汉市",
"86156475", "内蒙古通辽市",
"861339461", "黑龙江省哈尔滨市",
"861389735", "青海省西宁市",
"861573531", "山西省阳泉市",
"861397295", "湖北省鄂州市",
"861320232", "广东省惠州市",
"861814985", "新疆阿克苏地区",
"861857143", "湖北省十堰市",
"861348557", "安徽省宿州市",
"861787599", "广东省阳江市",
"86187000", "陕西省咸阳市",
"861878860", "贵州省遵义市",
"86180809", "四川省成都市",
"861888235", "四川省宜宾市",
"861336020", "广东省江门市",
"861524348", "河北省秦皇岛市",
"861538980", "内蒙古呼和浩特市",
"86130562", "江苏省徐州市",
"861503314", "河北省承德市",
"861878344", "四川省凉山彝族自治州",
"861870422", "辽宁省锦州市",
"861373045", "河北省保定市",
"861801415", "江苏省淮安市",
"861871069", "陕西省商洛市",
"861377677", "江苏省徐州市",
"861847832", "湖南省岳阳市",
"861870638", "山东省泰安市",
"861537447", "甘肃省甘南藏族自治州",
"861526807", "浙江省衢州市",
"861323723", "湖北省黄石市",
"861378109", "河南省平顶山市",
"86131922", "广东省珠海市",
"861562262", "广东省肇庆市",
"861582544", "浙江省温州市",
"861538563", "安徽省宣城市",
"861520950", "宁夏银川市",
"861843276", "河北省廊坊市",
"861339616", "湖北省荆门市",
"861818446", "贵州省遵义市",
"861587511", "广东省韶关市",
"861319022", "辽宁省丹东市",
"861800475", "内蒙古通辽市",
"861510390", "甘肃省张掖市",
"861385138", "江苏省宿迁市",
"861306992", "黑龙江省佳木斯市",
"861479090", "安徽省合肥市",
"861860611", "江苏省泰州市",
"861391448", "江苏省南京市",
"86158952", "江苏省徐州市",
"861366566", "安徽省池州市",
"861362695", "福建省南平市",
"861775201", "甘肃省定西市",
"861705630", "江西省南昌市",
"861830840", "四川省德阳市",
"861326370", "广西南宁市",
"86137423", "辽宁省抚顺市",
"86151585", "浙江省温州市",
"861360892", "山东省济南市",
"861872481", "云南省怒江傈僳族自治州",
"86156261", "广东省广州市",
"861346349", "河北省承德市",
"861317211", "广东省东莞市",
"861899486", "江苏省扬州市",
"861813907", "新疆巴音郭楞蒙古自治州",
"861822686", "安徽省阜阳市",
"861550927", "陕西省安康市",
"861501498", "广东省河源市",
"861570543", "山东省滨州市",
"861871619", "四川省宜宾市",
"861308098", "陕西省榆林市",
"861370008", "辽宁省大连市",
"861874279", "新疆伊犁哈萨克自治州",
"861844974", "新疆巴音郭楞蒙古自治州",
"861807197", "湖北省武汉市",
"861773729", "河南省三门峡市",
"861777528", "安徽省芜湖市",
"861805628", "安徽省铜陵市",
"861537833", "四川省眉山市",
"861519168", "陕西省西安市",
"861863972", "河南省许昌市",
"861539493", "云南省曲靖市",
"861855892", "福建省三明市",
"861323645", "江苏省盐城市",
"861327077", "江苏省泰州市",
"861860466", "黑龙江省鸡西市",
"861536549", "江苏省南通市",
"861599401", "河南省平顶山市",
"86183723", "湖北省宜昌市",
"861569049", "河北省邢台市",
"861831658", "广东省肇庆市",
"861346820", "山东省临沂市",
"861459165", "广西崇左市",
"861478324", "河南省漯河市",
"861830329", "河北省沧州市",
"861334530", "新疆塔城地区",
"8613051", "北京市",
"861899161", "陕西省汉中市",
"861572406", "广东省广州市",
"861318728", "湖南省邵阳市",
"86182442", "四川省成都市",
"861338591", "福建省福州市",
"861325275", "辽宁省抚顺市",
"86182420", "辽宁省大连市",
"861773764", "河南省信阳市",
"861327500", "福建省厦门市",
"861802340", "广东省中山市",
"861309344", "安徽省芜湖市",
"861831937", "广东省湛江市",
"861535276", "新疆巴音郭楞蒙古自治州",
"861889029", "湖南省衡阳市",
"861318740", "云南省昆明市",
"861313374", "江西省赣州市",
"861340222", "山东省济南市",
"861301390", "江苏省宿迁市",
"861776113", "四川省乐山市",
"861340402", "四川省广元市",
"861365716", "湖北省荆州市",
"861521453", "黑龙江省牡丹江市",
"861884897", "河南省洛阳市",
"861321972", "四川省乐山市",
"861580855", "贵州省黔东南苗族侗族自治州",
"861770158", "江苏省南京市",
"861470889", "云南省昆明市",
"861800046", "河北省廊坊市",
"861504525", "黑龙江省七台河市",
"861838884", "云南省丽江市",
"861323671", "辽宁省阜新市",
"86134002", "河北省保定市",
"861890463", "黑龙江省哈尔滨市",
"861470630", "山东省济南市",
"861803433", "河北省张家口市",
"86155329", "河北省邢台市",
"861320912", "陕西省榆林市",
"861554980", "湖北省鄂州市",
"861533646", "山东省潍坊市",
"861385947", "福建省南平市",
"86159793", "江西省上饶市",
"861373476", "内蒙古赤峰市",
"861839921", "新疆阿克苏地区",
"861319589", "甘肃省平凉市",
"861865973", "福建省泉州市",
"86156531", "山东省聊城市",
"861346848", "山东省潍坊市",
"861337918", "陕西省西安市",
"861365395", "河南省漯河市",
"861820854", "贵州省黔南布依族苗族自治州",
"861325241", "浙江省宁波市",
"861370962", "广东省茂名市",
"861396563", "安徽省滁州市",
"861857109", "湖北省黄石市",
"861853893", "河南省郑州市",
"861836242", "江苏省扬州市",
"861475787", "浙江省金华市",
"861889064", "湖南省怀化市",
"861846502", "宁夏石嘴山市",
"861368506", "福建省宁德市",
"861534507", "福建省漳州市",
"861476309", "山东省滨州市",
"861509424", "云南省保山市",
"861380366", "黑龙江省佳木斯市",
"861343733", "广东省江门市",
"861804738", "内蒙古鄂尔多斯市",
"861583567", "山西省忻州市",
"861377959", "新疆石河子市",
"861800702", "江西省九江市",
"861850395", "河南省漯河市",
"861550452", "黑龙江省齐齐哈尔市",
"861350973", "山西省太原市",
"861454462", "陕西省西安市",
"86181305", "安徽省安庆市",
"861528914", "西藏林芝地区",
"861551339", "山西省晋城市",
"861352311", "河南省周口市",
"861803270", "河北省沧州市",
"861391200", "江苏省徐州市",
"861527537", "山东省济宁市",
"861534070", "山西省太原市",
"86937", "甘肃省酒泉市",
"861829698", "江西省抚州市",
"861317931", "江苏省常州市",
"861347573", "山东省聊城市",
"86139249", "广东省中山市",
"861502583", "甘肃省定西市",
"86158629", "江苏省镇江市",
"861870957", "宁夏银川市",
"861822571", "安徽省安庆市",
"861586092", "福建省泉州市",
"861770648", "浙江省宁波市",
"861550318", "河北省衡水市",
"861338942", "甘肃省定西市",
"861373071", "四川省绵阳市",
"861516146", "江苏省南京市",
"861531260", "江苏省南通市",
"861313058", "辽宁省营口市",
"86152788", "广西柳州市",
"861705701", "广东省深圳市",
"861502960", "陕西省咸阳市",
"861533156", "云南省玉溪市",
"86130473", "重庆市",
"861312463", "贵州省安顺市",
"861336048", "广东省东莞市",
"861569003", "河北省邯郸市",
"861864931", "山西省太原市",
"861774248", "陕西省渭南市",
"861551378", "山西省晋中市",
"861369548", "山东省泰安市",
"861313267", "广西钦州市",
"861321595", "福建省泉州市",
"86150244", "浙江省杭州市",
"861360760", "河南省信阳市",
"861889184", "陕西省安康市",
"86152151", "重庆市",
"861310498", "广东省茂名市",
"86183791", "江西省南昌市",
"861865107", "江苏省南通市",
"861537373", "河北省衡水市",
"861399780", "湖北省十堰市",
"861530944", "甘肃省庆阳市",
"861819877", "广东省阳江市",
"861815172", "江苏省常州市",
"861590977", "青海省海西蒙古族藏族自治州",
"861450274", "内蒙古乌兰察布市",
"861342281", "广东省中山市",
"861331804", "广东省湛江市",
"86184443", "吉林省长春市",
"861507271", "湖北省孝感市",
"861589289", "四川省德阳市",
"861340741", "湖南省郴州市",
"86130232", "上海市",
"86132496", "广东省广州市",
"861325722", "湖北省随州市",
"861896362", "江苏省南京市",
"861454674", "广东省珠海市",
"861501784", "广东省汕头市",
"861324440", "吉林省长春市",
"861879098", "河南省濮阳市",
"861561501", "山东省威海市",
"861840297", "陕西省渭南市",
"861879407", "甘肃省陇南市",
"861317639", "山东省青岛市",
"861330316", "河北省廊坊市",
"86136121", "天津市",
"86170745", "黑龙江省哈尔滨市",
"861855414", "山东省潍坊市",
"861386648", "安徽省蚌埠市",
"861519690", "四川省遂宁市",
"861864880", "广西南宁市",
"861310570", "浙江省衢州市",
"86186732", "湖南省湘潭市",
"861330795", "江西省宜春市",
"861873908", "河南省洛阳市",
"861522943", "陕西省渭南市",
"86153071", "湖北省武汉市",
"861311510", "江苏省苏州市",
"86189388", "广东省深圳市",
"86131432", "广东省东莞市",
"861771275", "江苏省常州市",
"861554345", "吉林省长春市",
"861310007", "山西省临汾市",
"861505290", "江苏省泰州市",
"861897777", "广西南宁市",
"861390738", "湖南省娄底市",
"86136027", "广东省广州市",
"861331376", "福建省福州市",
"861552196", "广东省河源市",
"861825013", "福建省龙岩市",
"861580847", "四川省宜宾市",
"861576936", "甘肃省白银市",
"861842053", "广东省茂名市",
"861816470", "云南省昭通市",
"861372114", "安徽省淮南市",
"861323938", "甘肃省天水市",
"861700004", "北京市",
"861778094", "四川省广安市",
"861529687", "广西河池市",
"861806452", "福建省三明市",
"861360414", "辽宁省本溪市",
"86130631", "福建省漳州市",
"861514583", "黑龙江省伊春市",
"861321421", "辽宁省朝阳市",
"861586332", "山东省德州市",
"861593283", "江西省宜春市",
"86151444", "吉林省四平市",
"86185527", "江苏省宿迁市",
"861329437", "吉林省辽源市",
"861322129", "浙江省金华市",
"86188615", "江苏省无锡市",
"861563993", "河南省郑州市",
"861839472", "甘肃省定西市",
"861855072", "江苏省宿迁市",
"861843468", "山西省忻州市",
"86131273", "河北省沧州市",
"86151683", "浙江省杭州市",
"861361474", "内蒙古乌兰察布市",
"861572434", "辽宁省铁岭市",
"861329843", "河南省许昌市",
"86134346", "广东省湛江市",
"861812738", "广东省韶关市",
"861538371", "河北省石家庄市",
"861881834", "广东省潮州市",
"86150195", "广东省中山市",
"861556441", "山东省德州市",
"86188796", "江西省吉安市",
"86152874", "云南省曲靖市",
"861323979", "新疆伊犁哈萨克自治州",
"861803855", "广东省梅州市",
"861554831", "内蒙古阿拉善盟",
"861583046", "河北省廊坊市",
"861386158", "江苏省淮安市",
"861508273", "四川省巴中市",
"861834994", "四川省成都市",
"861580433", "吉林省延边朝鲜族自治州",
"861335360", "河南省商丘市",
"861558890", "山东省临沂市",
"861785836", "浙江省湖州市",
"861452528", "山东省东营市",
"861335844", "福建省南平市",
"861858175", "四川省资阳市",
"861516587", "山东省枣庄市",
"861353648", "广东省汕尾市",
"861760423", "辽宁省抚顺市",
"861328346", "河北省秦皇岛市",
"86182393", "河南省濮阳市",
"861800353", "山西省阳泉市",
"861787642", "广东省梅州市",
"861839629", "福建省漳州市",
"861814328", "西藏拉萨市",
"861348571", "安徽省合肥市",
"861584670", "黑龙江省鸡西市",
"861581210", "云南省昆明市",
"861860278", "湖北省黄冈市",
"86135254", "河南省洛阳市",
"861301030", "安徽省合肥市",
"86185315", "河北省唐山市",
"861322084", "山东省威海市",
"861347299", "河北省秦皇岛市",
"861317678", "山东省济宁市",
"861870945", "甘肃省武威市",
"861308839", "四川省乐山市",
"861810637", "山东省枣庄市",
"861800567", "安徽省亳州市",
"86153592", "福建省厦门市",
"861528426", "河北省廊坊市",
"861327456", "黑龙江省绥化市",
"861390779", "广西北海市",
"861893537", "山西省临汾市",
"861534762", "广东省汕尾市",
"861579736", "湖北省咸宁市",
"861367328", "河北省保定市",
"861308110", "河北省石家庄市",
"861553332", "河北省邯郸市",
"861572550", "山东省烟台市",
"861329781", "广西南宁市",
"861363961", "河南省安阳市",
"861504491", "内蒙古鄂尔多斯市",
"861459667", "新疆昌吉回族自治州",
"861367340", "河南省周口市",
"861398692", "湖北省武汉市",
"861860919", "陕西省铜川市",
"861870971", "青海省西宁市",
"861537455", "湖北省黄冈市",
"861338425", "辽宁省丹东市",
"861325850", "黑龙江省牡丹江市",
"861367864", "山东省淄博市",
"861810958", "宁夏银川市",
"861816913", "宁夏吴忠市",
"861788902", "西藏日喀则地区",
"86151637", "山东省济宁市",
"861773410", "河北省邯郸市",
"86136193", "甘肃省兰州市",
"861822557", "安徽省宿州市",
"861348545", "山西省吕梁市",
"861373057", "河北省沧州市",
"861476565", "海南省海口市",
"861535468", "吉林省松原市",
"861770935", "甘肃省武威市",
"861700396", "河南省驻马店市",
"861559068", "吉林省长春市",
"861820398", "河南省三门峡市",
"86189522", "江苏省徐州市",
"861814864", "广东省广州市",
"861809727", "青海省海西蒙古族藏族自治州",
"861835108", "江苏省苏州市",
"861316776", "安徽省宣城市",
"861537561", "安徽省淮北市",
"861588513", "贵州省黔东南苗族侗族自治州",
"861848707", "云南省昆明市",
"86159516", "江苏省南京市",
"861373268", "江苏省宿迁市",
"861459793", "新疆喀什地区",
"861806130", "江苏省南通市",
"861871911", "广东省河源市",
"861452540", "山东省菏泽市",
"861370497", "辽宁省营口市",
"861308407", "安徽省蚌埠市",
"861518818", "云南省玉溪市",
"861367829", "四川省达州市",
"8615736", "重庆市",
"861567200", "湖北省黄石市",
"861769121", "陕西省西安市",
"861564984", "河南省许昌市",
"86189295", "广东省广州市",
"861339547", "山东省济宁市",
"861590951", "宁夏银川市",
"861368450", "黑龙江省哈尔滨市",
"861304244", "辽宁省沈阳市",
"861323218", "广东省茂名市",
"861507257", "湖北省孝感市",
"861538345", "山西省长治市",
"861308227", "辽宁省抚顺市",
"861589131", "陕西省延安市",
"861353620", "广东省江门市",
"861500510", "江苏省盐城市",
"861821961", "甘肃省兰州市",
"861300644", "四川省德阳市",
"861315081", "内蒙古乌兰察布市",
"861393389", "河北省保定市",
"86151750", "河北省邯郸市",
"861839705", "青海省海东地区",
"861807695", "西藏昌都地区",
"861887208", "湖北省孝感市",
"861308338", "安徽省亳州市",
"861342810", "广东省湛江市",
"861887632", "福建省漳州市",
"861555333", "山东省淄博市",
"861342178", "广东省云浮市",
"86180833", "贵州省安顺市",
"861801487", "江苏省苏州市",
"861319976", "新疆和田地区",
"861476056", "宁夏吴忠市",
"86184392", "河南省安阳市",
"861560532", "山东省青岛市",
"861387002", "江西省鹰潭市",
"861563286", "河北省衡水市",
"861860827", "四川省巴中市",
"86138742", "湖南省邵阳市",
"861768793", "江西省上饶市",
"86158845", "四川省成都市",
"861350729", "湖北省孝感市",
"861315161", "江苏省扬州市",
"861817043", "江西省上饶市",
"861819713", "青海省西宁市",
"86182321", "河北省石家庄市",
"861833983", "河南省郑州市",
"861573863", "河南省周口市",
"861555785", "浙江省宁波市",
"861308379", "河南省洛阳市",
"861337593", "福建省宁德市",
"861823012", "河北省保定市",
"861879110", "陕西省延安市",
"861818895", "湖南省郴州市",
"861510030", "河北省邯郸市",
"86137987", "广东省东莞市",
"86159508", "江苏省南通市",
"861370856", "贵州省铜仁地区",
"86187326", "河北省廊坊市",
"861351598", "福建省三明市",
"861880314", "河北省承德市",
"861787554", "广东省韶关市",
"861775972", "福建省龙岩市",
"861355827", "广西钦州市",
"861520796", "江西省吉安市",
"86158734", "湖南省衡阳市",
"861534890", "西藏拉萨市",
"861350764", "河南省驻马店市",
"861831285", "广东省梅州市",
"861359122", "辽宁省鞍山市",
"861581930", "广东省肇庆市",
"861315486", "内蒙古赤峰市",
"861322562", "安徽省铜陵市",
"861368534", "山东省德州市",
"861520315", "河北省唐山市",
"861592600", "湖北省鄂州市",
"861771241", "江苏省南京市",
"861529400", "甘肃省张掖市",
"861458121", "安徽省安庆市",
"861332010", "江西省鹰潭市",
"86157312", "河北省保定市",
"86132039", "河南省焦作市",
"861802985", "广东省潮州市",
"861300154", "山东省潍坊市",
"8613883", "重庆市",
"861529220", "湖南省株洲市",
"861898753", "云南省保山市",
"861814917", "陕西省宝鸡市",
"861858994", "广西桂林市",
"861559618", "陕西省西安市",
"861565992", "福建省福州市",
"86131095", "陕西省西安市",
"861853073", "河南省新乡市",
"861866682", "广东省深圳市",
"861538831", "四川省宜宾市",
"861881374", "广东省汕尾市",
"861800694", "福建省漳州市",
"861473685", "云南省临沧市",
"861800951", "宁夏银川市",
"861890510", "江苏省盐城市",
"861512154", "贵州省毕节地区",
"861864717", "内蒙古鄂尔多斯市",
"86134607", "河南省开封市",
"861320482", "内蒙古兴安盟",
"861473115", "河北省秦皇岛市",
"861303077", "辽宁省盘锦市",
"861882834", "四川省成都市",
"861866851", "浙江省绍兴市",
"861319047", "辽宁省本溪市",
"861317717", "湖北省荆门市",
"861813180", "河北省衡水市",
"861537638", "山东省泰安市",
"86153125", "江苏省常州市",
"861560356", "山西省晋城市",
"861398167", "四川省巴中市",
"861857858", "广东省汕尾市",
"861771123", "四川省达州市",
"861363557", "安徽省宿州市",
"861775707", "浙江省宁波市",
"861520428", "辽宁省盘锦市",
"861537422", "江西省九江市",
"861338452", "黑龙江省齐齐哈尔市",
"861780066", "内蒙古乌兰察布市",
"86183831", "四川省宜宾市",
"861538973", "内蒙古乌海市",
"861335581", "浙江省杭州市",
"861884946", "河北省廊坊市",
"861855865", "福建省三明市",
"861815929", "福建省厦门市",
"86153700", "江苏省苏州市",
"861520632", "山东省枣庄市",
"861533094", "辽宁省辽阳市",
"861783914", "河南省许昌市",
"861303500", "安徽省宿州市",
"861528484", "四川省自贡市",
"861591731", "广东省江门市",
"861809858", "安徽省黄山市",
"861874488", "贵州省铜仁地区",
"861551633", "河南省三门峡市",
"861856244", "山东省济宁市",
"86150522", "江苏省无锡市",
"861873841", "河南省洛阳市",
"861508811", "广东省江门市",
"861826582", "山东省菏泽市",
"861831853", "广东省韶关市",
"86150540", "山东省菏泽市",
"86156937", "甘肃省酒泉市",
"861324950", "河北省邢台市",
"861302030", "辽宁省沈阳市",
"86180516", "江苏省南通市",
"86151962", "四川省绵阳市",
"861305088", "辽宁省盘锦市",
"861530454", "黑龙江省佳木斯市",
"861571550", "安徽省滁州市",
"861337342", "河北省保定市",
"861898642", "湖北省鄂州市",
"861360865", "河南省洛阳市",
"86993", "新疆石河子市",
"86177939", "甘肃省陇南市",
"861351483", "内蒙古阿拉善盟",
"861812259", "广东省惠州市",
"861778517", "贵州省毕节地区",
"861815964", "福建省三明市",
"861517061", "江西省赣州市",
"861320348", "山西省运城市",
"861318331", "河南省南阳市",
"86152652", "山东省青岛市",
"861768192", "浙江省金华市",
"861769243", "河北省张家口市",
"861512644", "云南省红河哈尼族彝族自治州",
"86153277", "湖北省黄冈市",
"86180508", "福建省泉州市",
"861830771", "广西南宁市",
"861358944", "山东省东营市",
"86136221", "天津市",
"861329935", "甘肃省武威市",
"861535990", "福建省龙岩市",
"861780555", "安徽省马鞍山市",
"861340330", "河北省邯郸市",
"861844529", "黑龙江省鸡西市",
"86157023", "重庆市",
"861858403", "四川省绵阳市",
"861332376", "河南省信阳市",
"861819682", "新疆喀什地区",
"861355758", "广西南宁市",
"861320803", "浙江省杭州市",
"86137448", "吉林省长春市",
"861470427", "辽宁省盘锦市",
"861819112", "陕西省西安市",
"861834449", "广东省韶关市",
"861570032", "四川省广安市",
"861592985", "陕西省延安市",
"861397262", "湖北省武汉市",
"861322421", "辽宁省朝阳市",
"861550942", "甘肃省张掖市",
"861338318", "河北省衡水市",
"861383923", "河南省鹤壁市",
"861580750", "广东省江门市",
"861517466", "黑龙江省牡丹江市",
"861837543", "山东省滨州市",
"86139706", "江西省吉安市",
"861309765", "山西省晋城市",
"861813060", "安徽省芜湖市",
"861897188", "湖北省恩施土家族苗族自治州",
"86135785", "吉林省吉林市",
"86155882", "山东省枣庄市",
"861318845", "辽宁省辽阳市",
"861390259", "广东省中山市",
"861326383", "广西桂林市",
"861577840", "广西南宁市",
"861571434", "吉林省四平市",
"861359155", "辽宁省抚顺市",
"861362474", "内蒙古乌兰察布市",
"861530530", "山东省菏泽市",
"861803996", "河南省洛阳市",
"861860758", "广东省肇庆市",
"861879905", "新疆昌吉回族自治州",
"861810719", "湖北省十堰市",
"86183748", "湖南省长沙市",
"861321129", "广东省江门市",
"861301816", "四川省内江市",
"861763319", "河北省邢台市",
"861317093", "江西省上饶市",
"861534083", "山西省长治市",
"861318871", "山东省临沂市",
"861559777", "贵州省黔南布依族苗族自治州",
"861313761", "河南省信阳市",
"861524912", "陕西省榆林市",
"861350980", "广东省东莞市",
"861802487", "广东省河源市",
"861705207", "贵州省贵阳市",
"861833381", "河北省衡水市",
"861370572", "浙江省湖州市",
"861567135", "湖北省荆州市",
"861384855", "内蒙古通辽市",
"861346153", "河南省信阳市",
"861367415", "辽宁省丹东市",
"861391958", "甘肃省庆阳市",
"861300525", "广东省汕尾市",
"86156749", "湖南省长沙市",
"861589478", "新疆昌吉回族自治州",
"861315469", "四川省宜宾市",
"861350563", "安徽省安庆市",
"861340688", "山东省德州市",
"861877191", "湖北省鄂州市",
"861830745", "湖南省怀化市",
"861458429", "河南省新乡市",
"861869233", "湖南省湘潭市",
"861826064", "江苏省镇江市",
"86138476", "内蒙古赤峰市",
"861309604", "四川省绵阳市",
"861337794", "湖北省武汉市",
"861321562", "安徽省铜陵市",
"861865980", "福建省泉州市",
"861566690", "山东省烟台市",
"861350357", "山西省临汾市",
"861556103", "内蒙古呼和浩特市",
"861458209", "安徽省黄山市",
"86185431", "吉林省长春市",
"861554973", "湖北省随州市",
"861330507", "福建省泉州市",
"86150388", "河南省平顶山市",
"861586065", "福建省宁德市",
"861477969", "江西省吉安市",
"861533306", "山西省运城市",
"861338819", "四川省成都市",
"861764056", "辽宁省朝阳市",
"861539936", "陕西省安康市",
"861806425", "湖北省恩施土家族苗族自治州",
"861470952", "宁夏石嘴山市",
"861770781", "广西南宁市",
"861538410", "浙江省嘉兴市",
"861315424", "辽宁省锦州市",
"861776670", "四川省达州市",
"86157572", "浙江省湖州市",
"861325747", "湖南省益阳市",
"861590567", "安徽省亳州市",
"861458672", "湖南省娄底市",
"861510816", "四川省阿坝藏族羌族自治州",
"861377223", "陕西省安康市",
"861320320", "湖南省湘潭市",
"86159887", "浙江省温州市",
"861554107", "辽宁省朝阳市",
"861556977", "甘肃省酒泉市",
"86159376", "河南省信阳市",
"861894491", "湖南省益阳市",
"861872911", "陕西省延安市",
"861862979", "吉林省辽源市",
"861550591", "福建省福州市",
"861513667", "河南省南阳市",
"861816311", "湖北省襄樊市",
"861870373", "河南省新乡市",
"861399773", "湖北省宜昌市",
"861827270", "河南省焦作市",
"861370995", "新疆巴音郭楞蒙古自治州",
"861575041", "内蒙古赤峰市",
"86132457", "江苏省南通市",
"861365362", "山西省大同市",
"861876664", "山东省泰安市",
"861521909", "广东省清远市",
"861834403", "广东省深圳市",
"861555931", "新疆昌吉回族自治州",
"86184068", "云南省楚雄彝族自治州",
"861341139", "广东省珠海市",
"861804321", "吉林省长春市",
"861853698", "山西省忻州市",
"861708398", "河南省三门峡市",
"861770308", "广东省韶关市",
"861320849", "黑龙江省双鸭山市",
"861344157", "山东省日照市",
"861332836", "福建省莆田市",
"861536736", "湖南省常德市",
"861770437", "吉林省辽源市",
"861394977", "河南省三门峡市",
"861389830", "辽宁省抚顺市",
"861829893", "甘肃省金昌市",
"861596318", "山东省聊城市",
"861368385", "河南省洛阳市",
"861590353", "山西省阳泉市",
"861589439", "云南省丽江市",
"861587899", "广西北海市",
"861514498", "内蒙古通辽市",
"861537957", "宁夏吴忠市",
"86187885", "云南省昆明市",
"861569587", "浙江省金华市",
"861334944", "黑龙江省佳木斯市",
"861769209", "河北省衡水市",
"86151673", "浙江省嘉兴市",
"86131283", "广东省揭阳市",
"861894548", "黑龙江省绥化市",
"861399931", "新疆克拉玛依市",
"861813248", "河北省唐山市",
"861380151", "江苏省无锡市",
"861771996", "河南省商丘市",
"861831273", "广东省湛江市",
"861560916", "陕西省汉中市",
"86158354", "山西省晋中市",
"861596637", "山东省滨州市",
"861869567", "福建省厦门市",
"861378827", "广西钦州市",
"861777019", "江西省鹰潭市",
"861471832", "广东省揭阳市",
"861315009", "甘肃省临夏回族自治州",
"861778580", "贵州省贵阳市",
"861522981", "陕西省延安市",
"86145034", "辽宁省沈阳市",
"861779749", "青海省海西蒙古族藏族自治州",
"861576684", "广东省惠州市",
"861815678", "安徽省亳州市",
"861800311", "河北省石家庄市",
"861707551", "安徽省合肥市",
"861320504", "福建省南平市",
"861865237", "江苏省泰州市",
"861826269", "江苏省苏州市",
"86182098", "贵州省遵义市",
"861302395", "福建省漳州市",
"861580747", "湖南省永州市",
"861868856", "广东省中山市",
"861586405", "山东省烟台市",
"861392205", "广东省茂名市",
"86189378", "河南省开封市",
"861479770", "广西防城港市",
"861897877", "广西贵港市",
"861350328", "河北省邢台市",
"861593241", "河北省承德市",
"861862640", "江苏省宿迁市",
"861866271", "江苏省南京市",
"861398660", "湖北省黄石市",
"861330895", "西藏昌都地区",
"861514541", "黑龙江省齐齐哈尔市",
"861870534", "山东省德州市",
"861770142", "江苏省泰州市",
"861350237", "广东省梅州市",
"861890587", "浙江省温州市",
"86153187", "山东省青岛市",
"86132152", "广东省东莞市",
"861857278", "湖北省孝感市",
"86138596", "福建省宁德市",
"861514826", "内蒙古兴安盟",
"861333393", "河南省濮阳市",
"861324310", "河南省漯河市",
"861869353", "甘肃省武威市",
"861595671", "安徽省淮北市",
"861303868", "云南省曲靖市",
"861308778", "广西河池市",
"861709423", "广东省惠州市",
"861886085", "江苏省扬州市",
"86177276", "广东省广州市",
"861380641", "山东省济南市",
"861309414", "湖北省孝感市",
"861556483", "山东省泰安市",
"861322590", "福建省南平市",
"861590470", "内蒙古呼伦贝尔市",
"86180386", "广东省佛山市",
"861368971", "吉林省四平市",
"861329881", "吉林省白山市",
"861854570", "黑龙江省七台河市",
"861313706", "河南省洛阳市",
"861571547", "山东省济宁市",
"861390879", "云南省普洱市",
"8618446", "黑龙江省哈尔滨市",
"861875141", "江苏省连云港市",
"861527691", "新疆哈密地区",
"861308739", "湖南省邵阳市",
"861565960", "福建省泉州市",
"861592831", "四川省德阳市",
"861825051", "福建省莆田市",
"861324947", "广东省东莞市",
"86151993", "新疆喀什地区",
"861316525", "山东省东营市",
"86151330", "河北省邯郸市",
"86189083", "重庆市",
"861857239", "湖北省宜昌市",
"861509134", "陕西省咸阳市",
"861398010", "四川省德阳市",
"86185032", "河北省石家庄市",
"86150459", "黑龙江省大庆市",
"861344128", "江苏省南京市",
"861320988", "山西省晋中市",
"861351149", "浙江省温州市",
"861815880", "安徽省芜湖市",
"861820799", "江西省萍乡市",
"86133625", "浙江省绍兴市",
"861870450", "黑龙江省哈尔滨市",
"861842011", "广东省韶关市",
"861312587", "吉林省辽源市",
"861453197", "山西省晋城市",
"861774252", "湖南省长沙市",
"861369552", "安徽省蚌埠市",
"861521735", "广东省东莞市",
"861336052", "广东省深圳市",
"86131567", "安徽省亳州市",
"861772855", "广东省江门市",
"861476970", "山东省济南市",
"861836187", "江苏省淮安市",
"861474100", "辽宁省铁岭市",
"86152884", "云南省昆明市",
"861554731", "内蒙古包头市",
"861803755", "河南省洛阳市",
"861537928", "甘肃省张掖市",
"861338958", "宁夏银川市",
"861770652", "浙江省杭州市",
"861810425", "辽宁省丹东市",
"861705312", "四川省成都市",
"861812838", "广东省茂名市",
"86139454", "黑龙江省佳木斯市",
"861329743", "湖南省湘西土家族苗族自治州",
"861897240", "湖北省恩施土家族苗族自治州",
"861537940", "甘肃省甘南藏族自治州",
"86182413", "辽宁省抚顺市",
"861774907", "陕西省渭南市",
"861364486", "内蒙古赤峰市",
"861812054", "湖北省仙桃市",
"861560236", "广东省肇庆市",
"861585803", "浙江省温州市",
"861538487", "内蒙古包头市",
"861331087", "广东省深圳市",
"861372216", "内蒙古赤峰市",
"861830933", "甘肃省平凉市",
"86183710", "湖北省襄樊市",
"861595155", "江苏省盐城市",
"861344140", "辽宁省葫芦岛市",
"861520457", "黑龙江省大兴安岭地区",
"861824495", "广东省茂名市",
"861781744", "广东省广州市",
"861331736", "湖南省常德市",
"861879778", "湖南省常德市",
"861390378", "河南省开封市",
"861513080", "河北省沧州市",
"861338637", "山东省枣庄市",
"861597168", "湖北省恩施土家族苗族自治州",
"861321289", "黑龙江省大庆市",
"861568759", "云南省怒江傈僳族自治州",
"861367729", "湖北省武汉市",
"861846234", "山东省临沂市",
"861533299", "内蒙古通辽市",
"861805122", "江苏省苏州市",
"861508285", "四川省达州市",
"861322266", "江苏省扬州市",
"861840519", "江苏省泰州市",
"861700815", "江苏省南通市",
"861517221", "湖北省孝感市",
"861804099", "新疆伊犁哈萨克自治州",
"861779703", "青海省黄南藏族自治州",
"861835593", "安徽省亳州市",
"861517401", "辽宁省本溪市",
"861373791", "广西南宁市",
"861380675", "浙江省绍兴市",
"861470312", "河北省保定市",
"861368945", "甘肃省武威市",
"86134153", "广东省中山市",
"861315043", "新疆和田地区",
"861817161", "湖北省孝感市",
"861775131", "江苏省南通市",
"861515508", "安徽省安庆市",
"86188542", "山东省青岛市",
"86137697", "云南省曲靖市",
"86158169", "广东省佛山市",
"86137410", "辽宁省铁岭市",
"861375499", "山西省临汾市",
"861458396", "福建省南平市",
"861325750", "广东省江门市",
"861536660", "江苏省淮安市",
"86131237", "河南省驻马店市",
"861350917", "陕西省宝鸡市",
"86188520", "江苏省南京市",
"861593275", "河北省邯郸市",
"861538731", "湖南省长沙市",
"861898853", "广东省佛山市",
"86150518", "江苏省南京市",
"861347517", "山东省德州市",
"861569510", "江苏省无锡市",
"861808025", "四川省绵阳市",
"861396600", "安徽省芜湖市",
"86147436", "广东省广州市",
"861816951", "宁夏银川市",
"861883049", "河北省秦皇岛市",
"861770544", "山东省德州市",
"861831642", "广东省阳江市",
"861390054", "山东省济南市",
"861350340", "河南省商丘市",
"861361690", "福建省龙岩市",
"861588551", "贵州省贵阳市",
"861871953", "甘肃省甘南藏族自治州",
"861350864", "湖北省咸宁市",
"861862432", "辽宁省沈阳市",
"861470458", "黑龙江省伊春市",
"861889518", "宁夏银川市",
"861355727", "广西桂林市",
"86151921", "山东省聊城市",
"861534790", "江西省新余市",
"86187827", "四川省巴中市",
"86186352", "山西省晋中市",
"861576512", "黑龙江省佳木斯市",
"86137977", "湖北省襄樊市",
"861590913", "陕西省渭南市",
"861801345", "江苏省泰州市",
"861320102", "新疆昌吉回族自治州",
"861878414", "四川省宜宾市",
"861524418", "山东省济南市",
"861513160", "河北省唐山市",
"861303369", "浙江省绍兴市",
"861537317", "河北省沧州市",
"86139722", "湖北省襄樊市",
"86159825", "四川省遂宁市",
"861813220", "河北省邯郸市",
"861310965", "陕西省渭南市",
"861350829", "四川省甘孜藏族自治州",
"861390339", "河北省石家庄市",
"861454578", "四川省雅安市",
"861550200", "广东省深圳市",
"861771283", "江苏省镇江市",
"861860727", "湖北省襄樊市",
"86189131", "江苏省苏州市",
"861391452", "江苏省泰州市",
"861550420", "辽宁省鞍山市",
"861589972", "广东省江门市",
"86139740", "湖南省岳阳市",
"861335392", "河南省鹤壁市",
"861813400", "河北省邯郸市",
"861708799", "江苏省淮安市",
"861770709", "江西省南昌市",
"86135908", "广东省中山市",
"861502965", "陕西省渭南市",
"861559337", "甘肃省天水市",
"861859168", "陕西省延安市",
"861315106", "江苏省南京市",
"861572547", "山东省济宁市",
"861318623", "陕西省咸阳市",
"861777116", "湖北省黄石市",
"861526026", "福建省莆田市",
"861566662", "山东省菏泽市",
"861589707", "青海省海西蒙古族藏族自治州",
"861595122", "江苏省常州市",
"861321590", "福建省三明市",
"86177176", "上海市",
"861881533", "山东省淄博市",
"861786468", "山东省威海市",
"861329544", "山东省聊城市",
"861330956", "宁夏石嘴山市",
"86157328", "河北省衡水市",
"86153563", "浙江省台州市",
"861304049", "新疆和田地区",
"86189506", "福建省南平市",
"861345423", "浙江省台州市",
"861458281", "福建省宁德市",
"861335543", "山东省滨州市",
"861535008", "江西省景德镇市",
"861368373", "河南省新乡市",
"861559408", "甘肃省张掖市",
"861551321", "山西省忻州市",
"861395618", "安徽省芜湖市",
"861809758", "新疆石河子市",
"861333144", "吉林省通化市",
"861308258", "江苏省宿迁市",
"861324445", "吉林省通化市",
"86158539", "山东省临沂市",
"861356099", "广东省梅州市",
"861317817", "福建省南平市",
"861801107", "四川省凉山彝族自治州",
"86147304", "河北省石家庄市",
"861558041", "湖南省郴州市",
"861519197", "陕西省西安市",
"86130708", "山东省青岛市",
"861807168", "江苏省宿迁市",
"861858782", "广西河池市",
"861505501", "安徽省滁州市",
"861399785", "湖北省随州市",
"861839939", "新疆阿克苏地区",
"86136085", "贵州省贵阳市",
"861354719", "四川省广元市",
"861805155", "江苏省盐城市",
"861301716", "湖南省衡阳市",
"861323628", "江苏省盐城市",
"861470635", "山东省聊城市",
"861576626", "广东省深圳市",
"861317964", "江苏省苏州市",
"861860858", "贵州省六盘水市",
"861802371", "广东省清远市",
"861308617", "江西省宜春市",
"861800913", "陕西省渭南市",
"861323432", "吉林省吉林市",
"861772996", "安徽省宣城市",
"861893444", "贵州省黔南布依族苗族自治州",
"86130716", "广东省茂名市",
"861365390", "河南省新乡市",
"861308187", "河北省秦皇岛市",
"861346576", "山东省聊城市",
"86155872", "云南省昆明市",
"861318745", "云南省曲靖市",
"86135775", "云南省保山市",
"861808052", "四川省巴中市",
"86150131", "广东省广州市",
"861351702", "江西省九江市",
"861839978", "新疆巴音郭楞蒙古自治州",
"861537506", "安徽省芜湖市",
"861580850", "贵州省贵阳市",
"861521981", "广东省韶关市",
"86180825", "陕西省西安市",
"861300776", "青海省西宁市",
"861870733", "湖南省株洲市",
"861586907", "浙江省衢州市",
"861381332", "江苏省淮安市",
"861504520", "黑龙江省齐齐哈尔市",
"861850390", "河南省焦作市",
"861840476", "内蒙古赤峰市",
"861317929", "吉林省辽源市",
"861821906", "广东省汕尾市",
"86189561", "安徽省淮北市",
"861333654", "广东省深圳市",
"861333991", "湖北省黄石市",
"861869951", "新疆吐鲁番地区",
"861826286", "江苏省盐城市",
"861803275", "河北省石家庄市",
"861391205", "江苏省淮安市",
"861320703", "江西省上饶市",
"861355858", "四川省阿坝藏族羌族自治州",
"861831811", "广东省江门市",
"86189518", "江苏省南京市",
"861534075", "山西省大同市",
"861508853", "浙江省绍兴市",
"86156621", "吉林省吉林市",
"861830871", "云南省昆明市",
"86170898", "广东省珠海市",
"86187302", "河北省保定市",
"861889436", "甘肃省定西市",
"861566012", "河南省新乡市",
"861707967", "浙江省温州市",
"86135916", "辽宁省沈阳市",
"861761442", "吉林省吉林市",
"86132252", "江苏省徐州市",
"861347306", "河北省邢台市",
"861873402", "安徽省宿州市",
"86145321", "浙江省杭州市",
"86157582", "云南省普洱市",
"861834782", "内蒙古包头市",
"861770881", "云南省西双版纳傣族自治州",
"861833343", "河北省沧州市",
"861314362", "广东省惠州市",
"861811378", "四川省宜宾市",
"861338719", "湖北省荆州市",
"861310467", "黑龙江省鸡西市",
"86150378", "河南省开封市",
"861539684", "江苏省徐州市",
"861860359", "山西省运城市",
"861810318", "河北省衡水市",
"861479095", "安徽省阜阳市",
"86133380", "江苏省苏州市",
"861573564", "山西省太原市",
"861477346", "湖南省湘西土家族苗族自治州",
"861832642", "安徽省宣城市",
"861337894", "湖南省衡阳市",
"861500587", "浙江省温州市",
"861339434", "吉林省四平市",
"861362690", "福建省莆田市",
"861584949", "内蒙古包头市",
"861326375", "广西玉林市",
"861830845", "四川省绵阳市",
"861776301", "湖北省武汉市",
"861829017", "广西钦州市",
"861816567", "广东省清远市",
"861325270", "辽宁省沈阳市",
"861802345", "广东省广州市",
"861327505", "福建省泉州市",
"861700464", "上海市",
"861478456", "黑龙江省黑河市",
"861773487", "河南省许昌市",
"86189231", "广东省佛山市",
"861592973", "陕西省西安市",
"861313298", "广西河池市",
"861323640", "江苏省南京市",
"861555172", "安徽省芜湖市",
"86158605", "福建省泉州市",
"861318771", "云南省玉溪市",
"861332167", "广西贵港市",
"861453474", "黑龙江省鸡西市",
"861772283", "广东省深圳市",
"861590311", "河北省石家庄市",
"861334535", "新疆阿克苏地区",
"861770743", "湖南省湘西土家族苗族自治州",
"861528898", "山东省青岛市",
"86158798", "江西省抚州市",
"861459160", "广西南宁市",
"861346825", "山东省莱芜市",
"861370276", "广东省珠海市",
"86153233", "广东省广州市",
"861350415", "辽宁省丹东市",
"861306570", "浙江省杭州市",
"86187875", "云南省保山市",
"861817424", "湖南省怀化市",
"861332087", "四川省德阳市",
"861813092", "新疆和田地区",
"861316552", "河北省承德市",
"86189459", "黑龙江省大庆市",
"861353930", "广东省佛山市",
"861367563", "安徽省宣城市",
"861814980", "新疆乌鲁木齐市",
"861397290", "湖北省荆门市",
"861389730", "青海省海北藏族自治州",
"861368447", "四川省巴中市",
"861561047", "山东省青岛市",
"861332736", "湖南省常德市",
"861595569", "安徽省安庆市",
"861340770", "广西南宁市",
"861320749", "湖南省长沙市",
"861347094", "安徽省宿州市",
"86134300", "广东省揭阳市",
"861452557", "山东省青岛市",
"861351475", "内蒙古通辽市",
"861893263", "河北省张家口市",
"861333542", "陕西省咸阳市",
"861339550", "安徽省滁州市",
"861534446", "湖南省永州市",
"861375191", "广东省汕尾市",
"861511776", "贵州省安顺市",
"861875882", "浙江省宁波市",
"861811339", "四川省达州市",
"861520955", "宁夏中卫市",
"861884868", "贵州省六盘水市",
"861518677", "贵州省黔东南苗族侗族自治州",
"861803722", "河南省洛阳市",
"861810452", "黑龙江省齐齐哈尔市",
"86155305", "河北省唐山市",
"861879187", "陕西省宝鸡市",
"861321266", "湖南省永州市",
"86136162", "江苏省苏州市",
"861568238", "四川省资阳市",
"861473673", "云南省普洱市",
"861814357", "贵州省毕节地区",
"86159386", "河南省周口市",
"861352977", "云南省玉溪市",
"861800470", "内蒙古呼伦贝尔市",
"861880954", "宁夏固原市",
"861364469", "黑龙江省大庆市",
"861700672", "浙江省温州市",
"861336025", "广东省肇庆市",
"861776788", "吉林省白城市",
"861888230", "四川省南充市",
"861878865", "贵州省安顺市",
"86150083", "四川省德阳市",
"86131137", "广东省佛山市",
"861880691", "云南省西双版纳傣族自治州",
"861329142", "浙江省杭州市",
"861801410", "江苏省盐城市",
"861503999", "河南省安阳市",
"861373040", "河北省邯郸市",
"861334326", "河北省廊坊市",
"861367357", "河南省周口市",
"861773731", "河南省郑州市",
"86156693", "浙江省嘉兴市",
"861325847", "四川省德阳市",
"861380812", "四川省广元市",
"86137925", "山东省烟台市",
"861596382", "山东省日照市",
"861367831", "四川省宜宾市",
"861587754", "陕西省榆林市",
"861500146", "新疆喀什地区",
"861470948", "甘肃省兰州市",
"861303013", "广东省韶关市",
"861871443", "黑龙江省牡丹江市",
"861800598", "福建省三明市",
"861555780", "浙江省丽水市",
"861452686", "陕西省汉中市",
"861786276", "山东省枣庄市",
"861769139", "陕西省西安市",
"861865487", "山东省潍坊市",
"861879115", "陕西省商洛市",
"861510035", "河北省秦皇岛市",
"861818890", "湖南省邵阳市",
"861538917", "陕西省宝鸡市",
"861527263", "湖北省荆州市",
"861346989", "湖北省黄冈市",
"86134026", "江苏省苏州市",
"861376284", "湖南省娄底市",
"861843856", "河南省洛阳市",
"86187781", "广西南宁市",
"861317773", "江西省九江市",
"86187158", "四川省泸州市",
"861889269", "浙江省衢州市",
"861479783", "江西省上饶市",
"861356838", "四川省广安市",
"86138557", "安徽省宿州市",
"861509009", "河南省新乡市",
"861816441", "安徽省芜湖市",
"861454746", "浙江省台州市",
"861364916", "陕西省汉中市",
"861331549", "河北省石家庄市",
"861705766", "上海市",
"86153614", "广东省深圳市",
"861760732", "湖南省湘潭市",
"861520310", "河北省邯郸市",
"861354382", "广东省中山市",
"861590802", "山东省潍坊市",
"861350487", "黑龙江省鹤岗市",
"861802980", "广东省肇庆市",
"861529405", "甘肃省平凉市",
"861828887", "云南省丽江市",
"861332015", "江西省宜春市",
"86182786", "广西百色市",
"861580722", "湖北省武汉市",
"861821934", "广东省佛山市",
"861858319", "四川省绵阳市",
"861819902", "新疆哈密地区",
"861529225", "湖南省湘潭市",
"861589164", "陕西省延安市",
"861306498", "江苏省扬州市",
"861389943", "新疆博尔塔拉蒙古自治州",
"861310826", "四川省广安市",
"861778573", "贵州省贵阳市",
"86137092", "陕西省西安市",
"861561566", "山东省潍坊市",
"861863478", "山西省吕梁市",
"861889404", "甘肃省兰州市",
"86188383", "河南省周口市",
"861550637", "山东省济宁市",
"861503691", "河南省驻马店市",
"861880999", "新疆伊犁哈萨克自治州",
"861501992", "广东省珠海市",
"861328538", "山东省泰安市",
"861802563", "广东省汕头市",
"861534895", "西藏昌都地区",
"861830857", "贵州省毕节地区",
"861310541", "山东省济南市",
"861596448", "山东省淄博市",
"861380788", "广西南宁市",
"861776812", "江苏省南京市",
"861831280", "广东省湛江市",
"86151315", "河北省唐山市",
"861554328", "吉林省长春市",
"861378842", "广西柳州市",
"861582781", "湖北省鄂州市",
"861816046", "新疆喀什地区",
"861569463", "云南省临沧市",
"861812196", "四川省成都市",
"861882042", "广东省广州市",
"861500656", "山东省潍坊市",
"861315134", "江苏省淮安市",
"861834818", "河南省驻马店市",
"86182853", "贵州省安顺市",
"861520947", "甘肃省酒泉市",
"861589084", "河南省驻马店市",
"861367345", "河南省信阳市",
"861330862", "湖北省武汉市",
"861773415", "河北省沧州市",
"861860394", "河南省周口市",
"86137571", "浙江省杭州市",
"861325855", "黑龙江省双鸭山市",
"861805979", "福建省龙岩市",
"861338420", "辽宁省铁岭市",
"861537450", "湖北省鄂州市",
"861584641", "黑龙江省七台河市",
"861348540", "山西省忻州市",
"861815873", "浙江省绍兴市",
"861336596", "福建省泉州市",
"861328579", "浙江省金华市",
"861538829", "四川省自贡市",
"861337859", "贵州省黔西南布依族苗族自治州",
"861770930", "甘肃省临夏回族自治州",
"861476560", "湖北省武汉市",
"861371588", "广东省汕头市",
"86185683", "河南省洛阳市",
"861505050", "江苏省泰州市",
"861840891", "西藏拉萨市",
"861807690", "西藏拉萨市",
"861839700", "青海省海北藏族自治州",
"86189632", "山东省枣庄市",
"86153665", "江苏省盐城市",
"861342815", "广东省茂名市",
"861368561", "安徽省淮北市",
"861303797", "宁夏银川市",
"861350731", "湖南省长沙市",
"861390633", "山东省日照市",
"861340612", "山东省东营市",
"861377818", "四川省南充市",
"86151527", "江苏省扬州市",
"861313533", "湖南省株洲市",
"861303663", "四川省达州市",
"861452545", "山东省青岛市",
"861879546", "江苏省南京市",
"861871837", "广东省茂名市",
"861356879", "四川省阿坝藏族羌族自治州",
"861567205", "湖北省恩施土家族苗族自治州",
"861809489", "新疆和田地区",
"861533774", "江苏省南京市",
"86150967", "云南省玉溪市",
"861368455", "黑龙江省哈尔滨市",
"861590483", "内蒙古阿拉善盟",
"86137850", "河北省邯郸市",
"861816702", "浙江省金华市",
"86151364", "河南省郑州市",
"861353625", "广东省惠州市",
"861571522", "江苏省徐州市",
"861524988", "安徽省马鞍山市",
"861538340", "山西省太原市",
"861558895", "山东省莱芜市",
"861335365", "河南省安阳市",
"861858170", "四川省南充市",
"861599181", "陕西省咸阳市",
"861775266", "湖南省邵阳市",
"861320352", "山西省大同市",
"861528039", "福建省龙岩市",
"861898658", "湖北省黄石市",
"861351567", "安徽省阜阳市",
"861337358", "河北省承德市",
"86188337", "河北省沧州市",
"861538328", "河北省衡水市",
"861321439", "吉林省白山市",
"861360636", "山东省潍坊市",
"861327369", "河北省邢台市",
"861599611", "江苏省连云港市",
"86156595", "福建省莆田市",
"861863807", "河南省周口市",
"861364236", "广东省深圳市",
"861805147", "江苏省苏州市",
"861783502", "山西省忻州市",
"861841969", "甘肃省陇南市",
"861380494", "辽宁省大连市",
"861803850", "广东省河源市",
"86137656", "贵州省铜仁地区",
"861809842", "安徽省淮北市",
"861332704", "内蒙古通辽市",
"861452571", "福建省福州市",
"861572186", "云南省大理白族自治州",
"861847133", "湖北省黄冈市",
"861383339", "河北省石家庄市",
"861560486", "黑龙江省大庆市",
"861338448", "吉林省长春市",
"861522666", "河北省廊坊市",
"861319262", "广东省云浮市",
"861317621", "山东省菏泽市",
"86156222", "广东省广州市",
"861309508", "新疆伊犁哈萨克自治州",
"861782032", "广东省清远市",
"861819188", "陕西省西安市",
"86156240", "山东省济南市",
"861572555", "山东省聊城市",
"86132651", "广东省广州市",
"861478077", "四川省广元市",
"861814371", "甘肃省天水市",
"86150819", "河北省唐山市",
"861352951", "云南省楚雄彝族自治州",
"861857842", "广东省佛山市",
"861581215", "云南省西双版纳傣族自治州",
"861841924", "甘肃省定西市",
"861301035", "江苏省徐州市",
"861315532", "安徽省芜湖市",
"86187046", "黑龙江省哈尔滨市",
"861305662", "四川省乐山市",
"86138129", "江苏省苏州市",
"861572461", "辽宁省鞍山市",
"861774060", "湖北省荆门市",
"861367371", "河南省郑州市",
"861351353", "山西省阳泉市",
"861530384", "河南省郑州市",
"861588492", "四川省广安市",
"861899106", "陕西省榆林市",
"86151159", "湖南省邵阳市",
"861330790", "江西省新余市",
"861860742", "湖南省常德市",
"861889391", "甘肃省兰州市",
"861838583", "贵州省黔东南苗族侗族自治州",
"861708754", "江西省抚州市",
"861311515", "江苏省连云港市",
"86158503", "江苏省苏州市",
"861771270", "江苏省泰州市",
"861554340", "吉林省长春市",
"861450854", "江苏省扬州市",
"861356339", "山东省东营市",
"861370468", "黑龙江省鸡西市",
"861308821", "四川省巴中市",
"861507851", "广西柳州市",
"861898148", "四川省达州市",
"861339406", "福建省厦门市",
"861820553", "安徽省芜湖市",
"861805657", "安徽省合肥市",
"861870317", "河北省沧州市",
"861777557", "四川省成都市",
"861819068", "四川省成都市",
"861569244", "广东省深圳市",
"86137435", "吉林省通化市",
"861308546", "湖南省湘西土家族苗族自治州",
"86184852", "贵州省遵义市",
"861550958", "宁夏银川市",
"86183844", "四川省凉山彝族自治州",
"861454968", "黑龙江省黑河市",
"861309984", "云南省大理白族自治州",
"86185637", "山东省济南市",
"861571089", "广东省广州市",
"861310575", "浙江省绍兴市",
"861378489", "河北省邢台市",
"861519695", "四川省宜宾市",
"861864885", "广西柳州市",
"861572066", "江苏省苏州市",
"861815333", "湖南省长沙市",
"861535497", "内蒙古包头市",
"861559097", "黑龙江省鹤岗市",
"861518141", "四川省泸州市",
"861831627", "广东省阳江市",
"861824462", "河北省保定市",
"861869149", "陕西省西安市",
"861874074", "陕西省商洛市",
"861321478", "内蒙古巴彦淖尔市",
"861528078", "福建省南平市",
"861356054", "广东省湛江市",
"861554829", "内蒙古巴彦淖尔市",
"86185750", "广东省江门市",
"861847696", "广东省中山市",
"861355742", "广西柳州市",
"861537132", "江苏省扬州市",
"86139865", "湖北省黄冈市",
"86183735", "湖南省郴州市",
"861816475", "云南省保山市",
"861831302", "云南省大理白族自治州",
"861394913", "河南省郑州市",
"861318757", "云南省德宏傣族景颇族自治州",
"861559851", "内蒙古兴安盟",
"861320418", "辽宁省阜新市",
"861458431", "河南省许昌市",
"86157343", "吉林省白城市",
"861589026", "河南省三门峡市",
"861313734", "河南省濮阳市",
"861579804", "江西省抚州市",
"861317253", "广东省汕头市",
"861518223", "四川省眉山市",
"86188124", "河南省新乡市",
"86189819", "四川省成都市",
"861534956", "宁夏石嘴山市",
"861386544", "安徽省六安市",
"861827275", "河南省南阳市",
"861860653", "浙江省杭州市",
"861518403", "辽宁省大连市",
"861866618", "广东省中山市",
"861533573", "湖北省宜昌市",
"861899043", "四川省阿坝藏族羌族自治州",
"861323823", "辽宁省盘锦市",
"861809466", "浙江省绍兴市",
"861370990", "新疆克拉玛依市",
"861833649", "河南省周口市",
"861864253", "辽宁省朝阳市",
"861390099", "北京市",
"86137368", "浙江省嘉兴市",
"861509106", "陕西省咸阳市",
"861586610", "山东省菏泽市",
"861479908", "新疆巴音郭楞蒙古自治州",
"861454490", "湖北省孝感市",
"86137311", "河北省石家庄市",
"861878760", "云南省文山壮族苗族自治州",
"861586180", "江苏省南京市",
"861319501", "宁夏银川市",
"861389835", "辽宁省锦州市",
"861550719", "湖北省黄冈市",
"861368380", "河南省郑州市",
"861826031", "江苏省盐城市",
"86158741", "湖南省长沙市",
"86156485", "内蒙古通辽市",
"861773917", "河南省焦作市",
"86132316", "河北省廊坊市",
"861881706", "湖南省郴州市",
"86176815", "浙江省嘉兴市",
"861380903", "江苏省南京市",
"861507682", "河北省衡水市",
"861595147", "江苏省淮安市",
"861887138", "湖北省武汉市",
"86158838", "四川省德阳市",
"861700887", "广东省深圳市",
"861367410", "辽宁省铁岭市",
"861384850", "内蒙古呼伦贝尔市",
"861773340", "河北省秦皇岛市",
"861376226", "湖南省株洲市",
"861300520", "广东省汕头市",
"861508217", "四川省绵阳市",
"861802764", "广东省江门市",
"861561589", "山东省临沂市",
"861318828", "辽宁省抚顺市",
"861458787", "湖南省衡阳市",
"861761427", "辽宁省盘锦市",
"861812099", "福建省莆田市",
"861816149", "四川省阿坝藏族羌族自治州",
"861860143", "江苏省苏州市",
"861551738", "河南省许昌市",
"861320536", "山东省潍坊市",
"86187258", "重庆市",
"861388786", "云南省德宏傣族景颇族自治州",
"861345832", "四川省绵阳市",
"861452624", "江苏省南通市",
"861332549", "陕西省西安市",
"861809061", "四川省成都市",
"861589201", "福建省漳州市",
"86132308", "河北省唐山市",
"861896390", "湖北省恩施土家族苗族自治州",
"861350985", "广东省韶关市",
"86180762", "贵州省遵义市",
"861581308", "广东省阳江市",
"86177552", "安徽省蚌埠市",
"861529907", "新疆乌鲁木齐市",
"861568794", "云南省临沧市",
"861347646", "湖北省鄂州市",
"861570581", "浙江省杭州市",
"861567130", "湖北省襄樊市",
"861855792", "浙江省绍兴市",
"861323282", "广东省清远市",
"861315356", "山东省东营市",
"861346966", "宁夏石嘴山市",
"861537733", "湖南省株洲市",
"861508148", "河北省衡水市",
"861533254", "陕西省汉中市",
"861586060", "福建省漳州市",
"861876631", "山东省威海市",
"86133849", "陕西省西安市",
"861806420", "湖北省咸宁市",
"861317574", "浙江省衢州市",
"861776675", "四川省凉山彝族自治州",
"861538415", "浙江省绍兴市",
"861830740", "湖南省怀化市",
"86136661", "四川省成都市",
"861375454", "河北省唐山市",
"861452669", "江西省赣州市",
"86151575", "浙江省绍兴市",
"861360792", "江西省九江市",
"861566695", "山东省聊城市",
"86159950", "江苏省常州市",
"861865985", "福建省三明市",
"861829559", "宁夏银川市",
"861839568", "河北省保定市",
"861864574", "黑龙江省大兴安岭地区",
"861381248", "江苏省泰州市",
"861340335", "河北省唐山市",
"861780550", "安徽省滁州市",
"861520076", "湖南省湘西土家族苗族自治州",
"86478", "内蒙古巴彦淖尔市",
"861810591", "福建省福州市",
"861882298", "广东省东莞市",
"861830728", "湖北省武汉市",
"86151259", "云南省楚雄彝族自治州",
"861592980", "陕西省西安市",
"861816977", "广西北海市",
"861804838", "内蒙古鄂尔多斯市",
"861588577", "贵州省铜仁地区",
"861479182", "陕西省西安市",
"86186863", "吉林省长春市",
"861393812", "河南省三门峡市",
"861317172", "河北省秦皇岛市",
"861572089", "江苏省苏州市",
"861527999", "江西省景德镇市",
"861328416", "辽宁省锦州市",
"861868008", "广东省东莞市",
"861850816", "四川省绵阳市",
"861893954", "河南省漯河市",
"861535995", "福建省南平市",
"861318329", "河南省商丘市",
"861329930", "甘肃省临夏回族自治州",
"861820754", "广东省汕头市",
"861353142", "广东省佛山市",
"861591764", "广东省清远市",
"861525670", "安徽省合肥市",
"861359150", "辽宁省丹东市",
"861773237", "河北省承德市",
"861530535", "山东省烟台市",
"861346748", "湖南省永州市",
"861879900", "新疆塔城地区",
"861890146", "江苏省南通市",
"861316491", "浙江省温州市",
"861768073", "湖南省娄底市",
"861772433", "广东省东莞市",
"861833603", "河南省商丘市",
"861322478", "内蒙古巴彦淖尔市",
"861869441", "陕西省宝鸡市",
"861386652", "安徽省滁州市",
"861880263", "广东省河源市",
"861470789", "广西北海市",
"861328661", "广东省江门市",
"861365816", "四川省德阳市",
"861573974", "新疆伊犁哈萨克自治州",
"861580755", "广东省深圳市",
"861708553", "安徽省芜湖市",
"861517034", "江西省萍乡市",
"861309760", "山西省阳泉市",
"861318364", "四川省眉山市",
"86152905", "河南省洛阳市",
"861318840", "辽宁省铁岭市",
"861322439", "吉林省白山市",
"861570676", "浙江省温州市",
"861352567", "河南省南阳市",
"861813185", "河北省邢台市",
"861379596", "四川省达州市",
"861501884", "广东省江门市",
"861330446", "吉林省延边朝鲜族自治州",
"861780434", "吉林省四平市",
"861329127", "江苏省南京市",
"861508937", "广东省揭阳市",
"861450511", "吉林省四平市",
"861524749", "内蒙古锡林郭勒盟",
"861303505", "安徽省合肥市",
"86150632", "山东省枣庄市",
"861560424", "辽宁省本溪市",
"861855860", "福建省福州市",
"861535572", "浙江省湖州市",
"861597690", "广东省汕头市",
"861800483", "内蒙古阿拉善盟",
"861473680", "云南省楚雄彝族自治州",
"861845254", "江苏省南京市",
"861599489", "广东省江门市",
"861331704", "江西省吉安市",
"861583311", "河北省石家庄市",
"861886667", "山东省东营市",
"86182247", "贵州省安顺市",
"861760696", "云南省昆明市",
"861473110", "河北省石家庄市",
"861520471", "内蒙古呼和浩特市",
"861571616", "江苏省无锡市",
"861772847", "广东省潮州市",
"861803747", "河南省郑州市",
"86184674", "青海省西宁市",
"861571555", "安徽省马鞍山市",
"861827241", "湖北省荆门市",
"861360860", "河南省开封市",
"86156140", "河北省邯郸市",
"861841986", "甘肃省武威市",
"86170841", "辽宁省大连市",
"861368422", "四川省达州市",
"861360344", "河南省焦作市",
"861351951", "宁夏银川市",
"861846426", "山东省滨州市",
"861787658", "广东省河源市",
"86147926", "安徽省阜阳市",
"861536198", "广东省梅州市",
"861333527", "山东省泰安市",
"86130483", "重庆市",
"861869046", "陕西省榆林市",
"861846206", "山东省淄博市",
"861332503", "山东省东营市",
"861836546", "江西省上饶市",
"861342243", "广东省惠州市",
"861560469", "黑龙江省双鸭山市",
"861530326", "河北省邯郸市",
"86152778", "广西河池市",
"861368638", "山东省烟台市",
"861528767", "云南省普洱市",
"86156122", "河北省保定市",
"861572169", "山西省运城市",
"861705801", "北京市",
"861523877", "河南省周口市",
"861813556", "山西省太原市",
"86147553", "安徽省芜湖市",
"861571461", "黑龙江省大庆市",
"861528693", "河南省濮阳市",
"86151431", "吉林省长春市",
"861386142", "江苏省连云港市",
"861853017", "河南省焦作市",
"861872409", "江苏省扬州市",
"861568488", "新疆昌吉回族自治州",
"861459073", "广东省河源市",
"861361088", "辽宁省沈阳市",
"861302035", "辽宁省丹东市",
"861595979", "福建省三明市",
"86138229", "广东省揭阳市",
"86159649", "山东省青岛市",
"861804879", "四川省遂宁市",
"861327386", "河南省许昌市",
"861559514", "宁夏吴忠市",
"861820556", "安徽省安庆市",
"861478375", "河南省平顶山市",
"861339403", "福建省漳州市",
"861566448", "山东省潍坊市",
"861888268", "四川省广安市",
"861570098", "新疆石河子市",
"861535711", "安徽省滁州市",
"861309321", "湖北省荆门市",
"861301408", "安徽省阜阳市",
"861308543", "湖南省永州市",
"861893478", "广西桂林市",
"861708872", "广东省江门市",
"861532982", "贵州省遵义市",
"86150863", "贵州省毕节地区",
"861870665", "山东省东营市",
"86151856", "贵州省黔东南苗族侗族自治州",
"861868120", "四川省攀枝花市",
"861564838", "内蒙古呼伦贝尔市",
"861365271", "广东省江门市",
"86158447", "吉林省辽源市",
"861899977", "新疆博尔塔拉蒙古自治州",
"861588128", "四川省攀枝花市",
"861874265", "新疆阿勒泰地区",
"861838586", "贵州省铜仁地区",
"861333810", "江苏省无锡市",
"861304359", "福建省龙岩市",
"861882749", "湖北省襄樊市",
"86188696", "云南省楚雄彝族自治州",
"861332928", "安徽省淮南市",
"861831990", "广东省梅州市",
"861533419", "湖北省咸宁市",
"861361942", "云南省大理白族自治州",
"861768138", "安徽省六安市",
"861879509", "宁夏银川市",
"861301337", "云南省玉溪市",
"861839944", "新疆喀什地区",
"861838155", "四川省资阳市",
"861472798", "陕西省西安市",
"861459179", "内蒙古鄂尔多斯市",
"86184878", "云南省文山壮族苗族自治州",
"861329539", "山东省临沂市",
"861394916", "河南省信阳市",
"861335067", "四川省自贡市",
"861573458", "黑龙江省伊春市",
"861366328", "河北省衡水市",
"861816009", "四川省自贡市",
"861509441", "河北省沧州市",
"861580614", "江苏省常州市",
"861304034", "吉林省松原市",
"861380540", "山东省济南市",
"861572063", "江苏省常州市",
"861558351", "四川省雅安市",
"861780959", "宁夏固原市",
"861399491", "山西省朔州市",
"861859318", "云南省曲靖市",
"861820615", "江苏省无锡市",
"861847693", "广东省湛江市",
"861892300", "广东省梅州市",
"861894773", "内蒙古包头市",
"861389768", "青海省海东地区",
"861335258", "黑龙江省伊春市",
"861895487", "山东省泰安市",
"861325269", "吉林省白山市",
"86182957", "山西省运城市",
"861347752", "湖北省武汉市",
"861364233", "广东省广州市",
"86134170", "广东省汕头市",
"861520698", "山东省潍坊市",
"86183525", "江苏省无锡市",
"86185396", "河南省驻马店市",
"861510240", "辽宁省沈阳市",
"861329578", "浙江省丽水市",
"861537692", "山东省临沂市",
"861509702", "甘肃省金昌市",
"861559395", "甘肃省白银市",
"861820065", "广东省中山市",
"861572183", "云南省红河哈尼族彝族自治州",
"861511929", "广东省茂名市",
"861459138", "广西贵港市",
"861853440", "山西省忻州市",
"861847136", "湖北省咸宁市",
"86181667", "贵州省贵阳市",
"86135931", "山西省太原市",
"861560483", "黑龙江省牡丹江市",
"861859452", "福建省宁德市",
"861398455", "贵州省毕节地区",
"861335187", "黑龙江省鸡西市",
"861800424", "辽宁省本溪市",
"86186632", "山东省枣庄市",
"861775263", "湖南省湘西土家族苗族自治州",
"861867514", "广东省韶关市",
"861760354", "山西省晋中市",
"861811792", "四川省达州市",
"861862541", "河南省洛阳市",
"861360633", "山东省日照市",
"861339882", "云南省德宏傣族景颇族自治州",
"861348788", "湖南省郴州市",
"86151783", "安徽省蚌埠市",
"861890394", "河南省周口市",
"861310300", "河北省邯郸市",
"861808488", "四川省绵阳市",
"861529854", "江苏省泰州市",
"86150116", "广东省佛山市",
"861371740", "广东省东莞市",
"861319415", "辽宁省丹东市",
"861333178", "吉林省松原市",
"861311143", "河北省秦皇岛市",
"861351356", "山西省晋城市",
"861576757", "广东省广州市",
"861364470", "内蒙古呼伦贝尔市",
"86183292", "陕西省榆林市",
"861454709", "浙江省绍兴市",
"861889855", "广东省河源市",
"861522663", "河北省沧州市",
"86180122", "江苏省南通市",
"861779027", "四川省成都市",
"861372091", "山西省吕梁市",
"861800469", "黑龙江省双鸭山市",
"861855633", "安徽省芜湖市",
"86155175", "河南省郑州市",
"86130731", "河北省石家庄市",
"861306524", "辽宁省铁岭市",
"86138826", "四川省广安市",
"861557702", "广西柳州市",
"861387287", "湖北省随州市",
"86139347", "山西省大同市",
"86189216", "江苏省南通市",
"861534351", "山西省太原市",
"861303411", "甘肃省天水市",
"861459310", "四川省达州市",
"861815876", "浙江省嘉兴市",
"861336593", "福建省莆田市",
"861332317", "河北省沧州市",
"861388908", "西藏拉萨市",
"861571782", "湖北省荆门市",
"861821151", "广东省湛江市",
"86138642", "山东省青岛市",
"861773262", "河北省廊坊市",
"86893", "西藏山南地区",
"861371728", "广东省江门市",
"861822459", "河南省新乡市",
"86159222", "天津市",
"861569466", "云南省昆明市",
"861832468", "黑龙江省伊春市",
"861816043", "新疆乌鲁木齐市",
"861812193", "四川省南充市",
"861525557", "安徽省宿州市",
"861506618", "山东省青岛市",
"861539329", "甘肃省陇南市",
"861503131", "河北省承德市",
"86138198", "浙江省宁波市",
"861500653", "山东省淄博市",
"86152960", "广西河池市",
"86177306", "陕西省西安市",
"861554501", "黑龙江省哈尔滨市",
"861872790", "湖北省鄂州市",
"861303666", "四川省成都市",
"861313536", "湖南省常德市",
"861867682", "广东省广州市",
"861879543", "江苏省徐州市",
"861510337", "河北省沧州市",
"861301877", "广东省梅州市",
"86131008", "黑龙江省哈尔滨市",
"861514628", "黑龙江省哈尔滨市",
"861867112", "湖北省鄂州市",
"861590486", "内蒙古赤峰市",
"861859927", "新疆阿克苏地区",
"861780677", "广东省阳江市",
"861862575", "河南省鹤壁市",
"861366917", "陕西省宝鸡市",
"861582521", "云南省红河哈尼族彝族自治州",
"861533852", "贵州省遵义市",
"861818189", "四川省泸州市",
"861564378", "吉林省辽源市",
"861853208", "河北省邯郸市",
"861768947", "福建省泉州市",
"86180485", "四川省成都市",
"86187948", "甘肃省兰州市",
"861308509", "安徽省六安市",
"86159595", "福建省泉州市",
"861837905", "江西省宜春市",
"861339449", "吉林省长春市",
"861390636", "山东省潍坊市",
"861868658", "吉林省吉林市",
"861510408", "辽宁省大连市",
"861355049", "四川省巴中市",
"861811344", "四川省乐山市",
"861304858", "贵州省遵义市",
"861807130", "湖北省宜昌市",
"86135342", "广东省深圳市",
"861527266", "湖北省咸宁市",
"861808794", "云南省昆明市",
"861870704", "江西省抚州市",
"86136865", "广东省佛山市",
"861843853", "河南省安阳市",
"861453382", "内蒙古兴安盟",
"861380528", "江苏省镇江市",
"861312401", "福建省福州市",
"861479786", "江西省吉安市",
"861536561", "江苏省泰州市",
"861317776", "江西省赣州市",
"861850245", "辽宁省铁岭市",
"861821641", "湖南省长沙市",
"861569061", "河南省安阳市",
"861829950", "新疆昌吉回族自治州",
"861364913", "陕西省渭南市",
"861454743", "浙江省温州市",
"86135320", "广东省中山市",
"861705763", "新疆乌鲁木齐市",
"861840355", "山西省长治市",
"861871446", "黑龙江省双鸭山市",
"861303016", "广东省湛江市",
"861452683", "陕西省渭南市",
"861786273", "山东省日照市",
"861536455", "山西省长治市",
"861580582", "浙江省湖州市",
"861479037", "安徽省合肥市",
"861475558", "安徽省宣城市",
"861366864", "山东省淄博市",
"86151737", "湖南省益阳市",
"861768310", "四川省宜宾市",
"861366340", "山西省朔州市",
"861579422", "江苏省无锡市",
"861810088", "云南省昆明市",
"861886632", "山东省枣庄市",
"861332940", "黑龙江省哈尔滨市",
"861561563", "山东省淄博市",
"86177318", "河北省保定市",
"861504574", "黑龙江省双鸭山市",
"861325391", "河南省漯河市",
"861802566", "广东省中山市",
"861591290", "云南省楚雄彝族自治州",
"861588140", "四川省泸州市",
"861506068", "福建省福州市",
"861365245", "广东省东莞市",
"861369717", "湖北省荆州市",
"861818024", "四川省遂宁市",
"86187172", "陕西省咸阳市",
"861478341", "河南省安阳市",
"86151650", "山东省济南市",
"861894885", "广东省中山市",
"86177361", "河北省邯郸市",
"861313325", "山西省长治市",
"861539277", "湖北省襄樊市",
"861315951", "吉林省长春市",
"861881988", "广东省阳江市",
"861346361", "河北省廊坊市",
"861814047", "四川省资阳市",
"861300929", "辽宁省葫芦岛市",
"861458699", "山东省莱芜市",
"861453448", "辽宁省葫芦岛市",
"861561980", "陕西省汉中市",
"861320734", "湖南省衡阳市",
"861566420", "河南省许昌市",
"861373350", "湖北省孝感市",
"861555520", "安徽省宣城市",
"86188890", "西藏拉萨市",
"861363675", "陕西省宝鸡市",
"861890742", "湖南省常德市",
"861379342", "山东省日照市",
"861352532", "河南省驻马店市",
"861334597", "浙江省宁波市",
"861856727", "河南省南阳市",
"861529079", "河南省平顶山市",
"861310823", "四川省乐山市",
"861389946", "新疆和田地区",
"861508962", "广东省茂名市",
"861348494", "陕西省榆林市",
"861552865", "四川省雅安市",
"861356765", "浙江省舟山市",
"861569842", "山西省晋中市",
"861550662", "山东省菏泽市",
"861454652", "云南省玉溪市",
"861760693", "云南省西双版纳傣族自治州",
"861870549", "山东省临沂市",
"861830904", "新疆伊犁哈萨克自治州",
"861478909", "西藏拉萨市",
"861571613", "江苏省苏州市",
"861843285", "河北省唐山市",
"861565147", "江苏省淮安市",
"861839499", "甘肃省白银市",
"861363459", "黑龙江省大庆市",
"86134270", "广东省中山市",
"861313418", "辽宁省阜新市",
"86180595", "福建省莆田市",
"861570673", "浙江省嘉兴市",
"861861541", "山东省济南市",
"861379593", "四川省巴中市",
"86159485", "吉林省吉林市",
"861365751", "新疆喀什地区",
"861760767", "广东省深圳市",
"861330443", "吉林省延边朝鲜族自治州",
"86155406", "内蒙古赤峰市",
"861333787", "江苏省连云港市",
"861837110", "湖北省鄂州市",
"861319917", "黑龙江省鸡西市",
"861883858", "河南省商丘市",
"86152752", "山东省青岛市",
"86183648", "山东省泰安市",
"861528696", "河南省安阳市",
"861594765", "内蒙古鄂尔多斯市",
"861360099", "福建省龙岩市",
"861813553", "山西省太原市",
"861536679", "江苏省徐州市",
"861335778", "江苏省泰州市",
"861772031", "湖北省咸宁市",
"861389500", "宁夏银川市",
"861512964", "陕西省安康市",
"861521797", "广东省深圳市",
"861867713", "广西崇左市",
"861515259", "江苏省淮安市",
"861533825", "广东省中山市",
"861459076", "广东省揭阳市",
"861868435", "吉林省通化市",
"861323575", "浙江省绍兴市",
"861370280", "广东省阳江市",
"861327383", "河南省商丘市",
"861348177", "广西柳州市",
"861576840", "广东省深圳市",
"861779734", "青海省海西蒙古族藏族自治州",
"861841983", "甘肃省平凉市",
"86139606", "福建省南平市",
"861846423", "山东省青岛市",
"86180240", "广东省广州市",
"861332506", "山东省东营市",
"861846203", "山东省青岛市",
"861705082", "山东省青岛市",
"861869043", "陕西省汉中市",
"86180222", "广东省佛山市",
"861342246", "广东省珠海市",
"861836543", "江西省赣州市",
"861890653", "浙江省杭州市",
"861530323", "河北省石家庄市",
"861850751", "广东省韶关市",
"86187487", "贵州省六盘水市",
"861893131", "河北省张家口市",
"861896618", "浙江省杭州市",
"861454142", "吉林省吉林市",
"861596695", "山东省淄博市",
"861470529", "江苏省镇江市",
"86153600", "广东省广州市",
"861705162", "江苏省南京市",
"861550474", "内蒙古乌兰察布市",
"861871862", "广东省揭阳市",
"861536422", "湖南省长沙市",
"861390792", "江西省九江市",
"86139661", "安徽省淮北市",
"861834547", "黑龙江省佳木斯市",
"861533681", "浙江省舟山市",
"861314851", "广东省中山市",
"861894574", "黑龙江省黑河市",
"861328413", "辽宁省抚顺市",
"861850813", "四川省自贡市",
"8618500", "北京市",
"861557149", "湖北省咸宁市",
"861335739", "湖南省邵阳市",
"861302408", "安徽省蚌埠市",
"861840322", "河北省保定市",
"861533111", "黑龙江省哈尔滨市",
"86139618", "江苏省无锡市",
"86178546", "山东省东营市",
"861867851", "山东省聊城市",
"861832990", "陕西省延安市",
"861452712", "湖北省孝感市",
"861520073", "湖南省衡阳市",
"861359965", "福建省漳州市",
"861319829", "四川省德阳市",
"861334705", "内蒙古通辽市",
"861336488", "新疆喀什地区",
"86183577", "浙江省温州市",
"861502282", "新疆阿勒泰地区",
"861500742", "湖南省湘西土家族苗族自治州",
"861561605", "湖南省怀化市",
"861358014", "广东省韶关市",
"861880266", "广东省惠州市",
"861516061", "福建省三明市",
"86138385", "河南省郑州市",
"861837878", "广西玉林市",
"861365813", "四川省绵阳市",
"86155127", "河北省邯郸市",
"86155461", "黑龙江省哈尔滨市",
"861708556", "安徽省安庆市",
"861470564", "安徽省六安市",
"861838569", "贵州省黔东南苗族侗族自治州",
"861776934", "湖南省衡阳市",
"861305958", "广东省清远市",
"861597130", "湖北省孝感市",
"861471798", "山西省忻州市",
"861358472", "江苏省南通市",
"86155418", "辽宁省葫芦岛市",
"861899475", "江苏省常州市",
"861336342", "山西省大同市",
"861598794", "云南省丽江市",
"861311394", "广东省中山市",
"861319864", "四川省南充市",
"861459471", "陕西省安康市",
"861304727", "湖南省益阳市",
"861891300", "江苏省南京市",
"861308744", "云南省怒江傈僳族自治州",
"861821812", "广东省河源市",
"861319340", "河南省商丘市",
"861830588", "浙江省丽水市",
"861509149", "陕西省榆林市",
"861768076", "湖南省怀化市",
"861772436", "广东省广州市",
"861890143", "江苏省泰州市",
"861321954", "四川省宜宾市",
"861833606", "河南省新乡市",
"861323992", "新疆伊犁哈萨克自治州",
"86155021", "上海市",
"861320533", "山东省淄博市",
"861822641", "安徽省蚌埠市",
"861880590", "福建省福州市",
"861330264", "广东省东莞市",
"861315567", "安徽省亳州市",
"861388783", "云南省保山市",
"861770578", "浙江省丽水市",
"86187433", "吉林省延边朝鲜族自治州",
"861869009", "陕西省商洛市",
"861876944", "山东省烟台市",
"861536380", "广东省佛山市",
"861826270", "江苏省淮安市",
"86158988", "山东省青岛市",
"861812344", "四川省甘孜藏族自治州",
"861347643", "湖北省襄樊市",
"861840480", "内蒙古呼伦贝尔市",
"861802589", "广东省汕头市",
"861364311", "河北省石家庄市",
"861376223", "湖南省湘潭市",
"861505487", "山东省济宁市",
"86152424", "辽宁省沈阳市",
"861334664", "河南省安阳市",
"861587615", "广东省汕头市",
"861479724", "山西省大同市",
"861705529", "陕西省西安市",
"861845825", "浙江省湖州市",
"861560598", "福建省三明市",
"861524042", "江苏省苏州市",
"861369678", "安徽省合肥市",
"861860146", "江苏省无锡市",
"86189863", "湖北省襄樊市",
"861363812", "贵州省铜仁地区",
"86187272", "湖北省宜昌市",
"86153806", "江苏省淮安市",
"861537087", "江苏省无锡市",
"861565938", "福建省福州市",
"861882988", "陕西省西安市",
"861331940", "江西省南昌市",
"861519448", "河南省信阳市",
"861330409", "辽宁省大连市",
"861373485", "内蒙古赤峰市",
"861818737", "云南省红河哈尼族彝族自治州",
"861570721", "湖北省襄樊市",
"861503478", "内蒙古呼和浩特市",
"861339994", "新疆昌吉回族自治州",
"861346963", "宁夏吴忠市",
"861315353", "山东省烟台市",
"861537736", "湖南省常德市",
"861527289", "湖北省随州市",
"861561729", "河南省濮阳市",
"861458527", "河南省鹤壁市",
"861705564", "辽宁省沈阳市",
"861781739", "广东省佛山市",
"861535285", "内蒙古呼和浩特市",
"861479769", "青海省海南藏族自治州",
"861891282", "江苏省镇江市",
"861454544", "新疆喀什地区",
"861351532", "山东省青岛市",
"861334629", "山东省滨州市",
"861872041", "江西省南昌市",
"861331317", "河北省沧州市",
"861323541", "湖北省黄冈市",
"861509103", "陕西省渭南市",
"861575911", "福建省漳州市",
"861500394", "河南省周口市",
"86156649", "陕西省西安市",
"861471484", "广东省广州市",
"861837227", "湖北省襄樊市",
"861522505", "河南省郑州市",
"861877014", "江西省宜春市",
"86153861", "湖南省常德市",
"861390344", "山西省晋中市",
"861879744", "湖南省湘西土家族苗族自治州",
"861350050", "安徽省合肥市",
"861854569", "黑龙江省黑河市",
"861824437", "四川省泸州市",
"861781778", "广东省梅州市",
"861589023", "河南省漯河市",
"861820332", "河北省保定市",
"86159140", "广东省深圳市",
"861518226", "四川省乐山市",
"861317256", "广东省潮州市",
"861390860", "湖北省宜昌市",
"861303689", "广西北海市",
"861338695", "福建省漳州市",
"86153818", "浙江省台州市",
"861860656", "浙江省金华市",
"861821459", "云南省昆明市",
"86159122", "云南省大理白族自治州",
"861537167", "江苏省连云港市",
"861576828", "广东省梅州市",
"861534953", "宁夏吴忠市",
"861533576", "湖北省孝感市",
"861809463", "浙江省嘉兴市",
"861323826", "辽宁省营口市",
"861899046", "四川省甘孜藏族自治州",
"861330377", "河南省南阳市",
"861590469", "黑龙江省双鸭山市",
"86138298", "广东省阳江市",
"861881703", "湖南省岳阳市",
"861885127", "江苏省镇江市",
"861860515", "江苏省盐城市",
"861899702", "青海省海东地区",
"861308392", "浙江省湖州市",
"861370302", "广东省佛山市",
"861807425", "浙江省湖州市",
"861569489", "河北省石家庄市",
"86186967", "重庆市",
"861311742", "湖南省湘潭市",
"861362591", "福建省漳州市",
"861380906", "江苏省苏州市",
"861857463", "湖南省娄底市",
"861334014", "江西省吉安市",
"861883034", "河北省张家口市",
"86147028", "四川省成都市",
"861770539", "山东省临沂市",
"861302877", "甘肃省临夏回族自治州",
"861369639", "山东省临沂市",
"861858547", "贵州省毕节地区",
"861370627", "江苏省南通市",
"861590424", "辽宁省大连市",
"861598342", "四川省凉山彝族自治州",
"861336794", "江西省抚州市",
"86147411", "辽宁省大连市",
"86181932", "甘肃省定西市",
"861567690", "广西来宾市",
"861353490", "广东省汕头市",
"861523035", "河北省秦皇岛市",
"861827064", "江西省宜春市",
"86185773", "广西桂林市",
"861310150", "黑龙江省哈尔滨市",
"861501432", "广东省汕头市",
"861880439", "吉林省白山市",
"861308032", "山西省大同市",
"861894780", "内蒙古巴彦淖尔市",
"861871956", "甘肃省陇南市",
"861575189", "江苏省南通市",
"861300172", "山东省济南市",
"861860587", "浙江省温州市",
"86188730", "湖南省岳阳市",
"86130823", "河北省保定市",
"861883394", "河北省保定市",
"861500359", "山西省运城市",
"861881352", "广东省惠州市",
"86134789", "辽宁省大连市",
"861572818", "广东省广州市",
"86138141", "江苏省南京市",
"861805498", "福建省龙岩市",
"861536945", "河北省沧州市",
"86158801", "福建省福州市",
"86186378", "河南省开封市",
"861335900", "安徽省滁州市",
"86182996", "新疆喀什地区",
"861867877", "山东省济南市",
"86745", "湖南省怀化市",
"861301682", "江苏省镇江市",
"861898856", "广东省中山市",
"861787572", "广东省茂名市",
"861775691", "安徽省宿州市",
"86181185", "江苏省徐州市",
"86132331", "山西省大同市",
"86837", "四川省阿坝藏族羌族自治州",
"861472914", "陕西省西安市",
"861306938", "河南省新乡市",
"861362425", "辽宁省大连市",
"861808279", "云南省普洱市",
"861331385", "福建省厦门市",
"86187991", "新疆乌鲁木齐市",
"861317548", "浙江省台州市",
"861859591", "河南省郑州市",
"861309779", "广西北海市",
"861771286", "江苏省南京市",
"86151897", "江苏省常州市",
"861313749", "河南省三门峡市",
"861366487", "内蒙古包头市",
"86137336", "河南省许昌市",
"861457031", "广东省广州市",
"86135267", "河南省郑州市",
"861361927", "陕西省宝鸡市",
"861522291", "安徽省合肥市",
"861459457", "陕西省宝鸡市",
"861590916", "陕西省汉中市",
"861772404", "广东省广州市",
"861820092", "广东省云浮市",
"861786627", "湖北省咸宁市",
"861537665", "山东省枣庄市",
"861369931", "新疆和田地区",
"861551892", "河南省信阳市",
"861315441", "四川省甘孜藏族自治州",
"86188657", "山东省德州市",
"861532859", "四川省广元市",
"861336759", "广西北海市",
"86182029", "陕西省西安市",
"861582997", "陕西省商洛市",
"861326768", "广东省江门市",
"861899567", "湖北省襄樊市",
"861566637", "山东省枣庄市",
"861525669", "安徽省滁州市",
"861522868", "四川省遂宁市",
"861772224", "广东省肇庆市",
"861333004", "江西省上饶市",
"861372213", "内蒙古包头市",
"861830936", "甘肃省白银市",
"861773050", "河北省唐山市",
"86139532", "山东省青岛市",
"861822949", "湖南省长沙市",
"86182676", "浙江省台州市",
"861310640", "浙江省金华市",
"861779042", "四川省成都市",
"861767347", "湖南省岳阳市",
"861337292", "辽宁省朝阳市",
"861320861", "吉林省松原市",
"861867240", "湖北省荆门市",
"861331733", "湖南省株洲市",
"86184579", "浙江省金华市",
"861309738", "江西省上饶市",
"861474791", "内蒙古锡林郭勒盟",
"861373417", "山西省朔州市",
"861558101", "湖南省长沙市",
"861365777", "广西钦州市",
"861477194", "湖北省荆州市",
"861364483", "内蒙古包头市",
"861587248", "湖北省宜昌市",
"861535217", "甘肃省嘉峪关市",
"861539745", "浙江省绍兴市",
"861892150", "江苏省无锡市",
"861560233", "广东省广州市",
"861379918", "福建省三明市",
"861585806", "浙江省舟山市",
"861314240", "内蒙古包头市",
"861476011", "福建省莆田市",
"861361819", "四川省眉山市",
"861562831", "内蒙古呼和浩特市",
"861315046", "新疆乌鲁木齐市",
"861311858", "贵州省六盘水市",
"86180693", "浙江省台州市",
"861804860", "四川省绵阳市",
"861808327", "贵州省黔西南布依族苗族自治州",
"86185357", "山西省临汾市",
"861458393", "福建省三明市",
"861381367", "江苏省常州市",
"861329968", "广西玉林市",
"861782821", "四川省成都市",
"861387437", "湖南省永州市",
"861339959", "安徽省黄山市",
"861863999", "河南省漯河市",
"86159544", "山东省潍坊市",
"861874292", "新疆石河子市",
"861766040", "山东省济南市",
"861880478", "内蒙古巴彦淖尔市",
"861560470", "内蒙古呼伦贝尔市",
"861332534", "陕西省商洛市",
"861808238", "江苏省连云港市",
"861306979", "黑龙江省牡丹江市",
"861572170", "贵州省黔南布依族苗族自治州",
"86187671", "浙江省杭州市",
"861881418", "广东省江门市",
"861870692", "甘肃省甘南藏族自治州",
"861334921", "安徽省芜湖市",
"861357738", "云南省曲靖市",
"861814589", "广东省东莞市",
"861835596", "安徽省黄山市",
"861779706", "青海省海东地区",
"861370811", "四川省绵阳市",
"861360879", "云南省普洱市",
"861535148", "四川省遂宁市",
"86158866", "湖南省常德市",
"861323467", "黑龙江省鸡西市",
"861850777", "广西钦州市",
"861893289", "河北省承德市",
"861533989", "甘肃省白银市",
"861569758", "广东省肇庆市",
"861768922", "福建省福州市",
"861519719", "湖南省湘潭市",
"861570905", "新疆吐鲁番地区",
"861318684", "浙江省温州市",
"86182551", "安徽省合肥市",
"861535120", "四川省成都市",
"86176084", "湖南省长沙市",
"861866030", "山东省日照市",
"861318114", "山东省威海市",
"861332132", "甘肃省定西市",
"861354197", "四川省广元市",
"86139262", "广东省广州市",
"861532412", "河北省唐山市",
"861556486", "山东省青岛市",
"861306218", "福建省宁德市",
"861373100", "河北省邯郸市",
"861835260", "江苏省无锡市",
"861583081", "河北省沧州市",
"861398945", "浙江省杭州市",
"861859942", "新疆伊犁哈萨克自治州",
"86132920", "河北省邯郸市",
"861766028", "山东省淄博市",
"861312727", "山东省泰安市",
"861313703", "河南省商丘市",
"861452888", "云南省丽江市",
"861330351", "山西省太原市",
"861565155", "江苏省盐城市",
"861380934", "甘肃省庆阳市",
"861504817", "内蒙古包头市",
"861551760", "河南省信阳市",
"86182870", "云南省昭通市",
"861399154", "陕西省渭南市",
"861314408", "广东省揭阳市",
"861598759", "云南省迪庆藏族自治州",
"861302851", "陕西省西安市",
"861360378", "河南省开封市",
"86187923", "陕西省渭南市",
"861329746", "湖南省永州市",
"861539771", "四川省资阳市",
"861310628", "浙江省丽水市",
"861565723", "浙江省丽水市",
"861803126", "河北省石家庄市",
"861311359", "内蒙古兴安盟",
"861361318", "河北省衡水市",
"86134314", "广东省东莞市",
"861302097", "浙江省台州市",
"861310432", "吉林省吉林市",
"86187556", "安徽省安庆市",
"86170766", "广东省广州市",
"86152934", "甘肃省庆阳市",
"861511172", "青海省海东地区",
"86151408", "辽宁省鞍山市",
"861360339", "河北省石家庄市",
"861864520", "黑龙江省齐齐哈尔市",
"861890727", "湖北省襄樊市",
"86151416", "辽宁省锦州市",
"861839454", "甘肃省武威市",
"86181062", "江苏省苏州市",
"861363494", "辽宁省锦州市",
"861760502", "福建省福州市",
"86136740", "广东省佛山市",
"86170701", "北京市",
"861556081", "内蒙古呼和浩特市",
"861340397", "河南省信阳市",
"861895340", "山东省莱芜市",
"86186131", "广东省广州市",
"861843148", "河北省石家庄市",
"861453637", "江苏省无锡市",
"861478601", "贵州省铜仁地区",
"861361452", "黑龙江省齐齐哈尔市",
"861856742", "河南省安阳市",
"86155360", "山西省太原市",
"861315475", "内蒙古通辽市",
"86181422", "天津市",
"861567088", "河南省焦作市",
"861771993", "河南省许昌市",
"86189352", "山西省大同市",
"861806474", "浙江省绍兴市",
"861560913", "陕西省渭南市",
"861764538", "黑龙江省鹤岗市",
"861518550", "贵州省黔南布依族苗族自治州",
"861831276", "广东省中山市",
"861535937", "福建省泉州市",
"861317520", "浙江省湖州市",
"861377461", "福建省福州市",
"861814022", "四川省成都市",
"861500858", "贵州省六盘水市",
"861815199", "江苏省常州市",
"86181440", "福建省福州市",
"861892432", "广东省广州市",
"861301514", "内蒙古通辽市",
"861322444", "吉林省四平市",
"861885709", "浙江省舟山市",
"861360054", "浙江省杭州市",
"861514823", "内蒙古包头市",
"861536971", "河北省秦皇岛市",
"861333396", "河南省驻马店市",
"861869356", "甘肃省金昌市",
"861532358", "广东省肇庆市",
"861327411", "辽宁省大连市",
"861346774", "湖南省衡阳市",
"861530597", "福建省龙岩市",
"861515294", "江苏省镇江市",
"861709426", "广东省江门市",
"861339677", "浙江省温州市",
"861868853", "广东省梅州市",
"861347901", "江西省上饶市",
"861854305", "吉林省通化市",
"861527131", "湖北省随州市",
"86135537", "广东省潮州市",
"861573948", "新疆喀什地区",
"861834461", "江苏省无锡市",
"861333715", "内蒙古赤峰市",
"861599510", "江苏省扬州市",
"861778720", "云南省大理白族自治州",
"861776528", "广东省深圳市",
"861332733", "湖南省株洲市",
"861595784", "浙江省丽水市",
"861350262", "广东省潮州市",
"861325031", "广东省广州市",
"86184319", "河北省邢台市",
"861802047", "江苏省泰州市",
"861806197", "江苏省无锡市",
"861841970", "甘肃省兰州市",
"861534443", "湖南省湘西土家族苗族自治州",
"861821949", "广东省茂名市",
"861894817", "广东省深圳市",
"861370273", "广东省湛江市",
"861474040", "辽宁省沈阳市",
"861327370", "河南省商丘市",
"861347349", "河北省邢台市",
"861840910", "陕西省西安市",
"861876530", "山东省菏泽市",
"861367566", "安徽省六安市",
"861844701", "内蒙古呼伦贝尔市",
"861768955", "西藏昌都地区",
"861354662", "山西省晋城市",
"861477808", "广东省中山市",
"861304401", "山东省泰安市",
"861774079", "西藏拉萨市",
"86186506", "福建省南平市",
"861334323", "河北省石家庄市",
"861303735", "湖南省郴州市",
"861898995", "西藏昌都地区",
"861576771", "广东省汕头市",
"861365618", "江苏省无锡市",
"861362819", "四川省乐山市",
"861359992", "福建省厦门市",
"86176397", "河南省周口市",
"861454930", "江苏省常州市",
"861570680", "浙江省丽水市",
"861511773", "贵州省铜仁地区",
"861569827", "山东省临沂市",
"861533748", "湖北省荆门市",
"861373915", "江苏省南通市",
"861570839", "四川省广元市",
"86157399", "新疆喀什地区",
"861300621", "江西省南昌市",
"86183623", "江苏省无锡市",
"861871895", "广东省梅州市",
"861331534", "河北省张家口市",
"861370430", "吉林省吉林市",
"861321263", "湖南省长沙市",
"861525545", "安徽省合肥市",
"861565122", "江苏省常州市",
"861473676", "云南省西双版纳傣族自治州",
"861836032", "江苏省扬州市",
"861894929", "安徽省亳州市",
"861502628", "新疆阿克苏地区",
"861816356", "湖北省襄樊市",
"861781115", "宁夏中卫市",
"861882352", "广东省潮州市",
"861571818", "广东省佛山市",
"861304742", "山东省枣庄市",
"86138241", "广东省珠海市",
"861470974", "青海省海南藏族自治州",
"861305420", "黑龙江省大庆市",
"861477343", "湖南省衡阳市",
"861530705", "江西省宜春市",
"861781685", "浙江省杭州市",
"86181285", "广东省东莞市",
"86186561", "安徽省淮北市",
"861876454", "山东省滨州市",
"861568025", "四川省泸州市",
"861899951", "新疆克拉玛依市",
"861319600", "吉林省长春市",
"861367055", "广东省揭阳市",
"861361425", "辽宁省丹东市",
"86186518", "江苏省南京市",
"861833346", "河北省邢台市",
"861874020", "辽宁省辽阳市",
"86177020", "广东省广州市",
"86170829", "陕西省西安市",
"861365068", "广东省河源市",
"861570878", "云南省楚雄彝族自治州",
"861510851", "贵州省贵阳市",
"861592976", "陕西省咸阳市",
"861857510", "广东省韶关市",
"861478453", "黑龙江省牡丹江市",
"861850257", "江苏省常州市",
"861554295", "辽宁省辽阳市",
"861812765", "广东省韶关市",
"861505864", "浙江省台州市",
"86135421", "广东省江门市",
"861894964", "安徽省马鞍山市",
"861500727", "湖北省襄樊市",
"861770746", "湖南省永州市",
"861772286", "广东省广州市",
"861315149", "江苏省苏州市",
"861890858", "贵州省六盘水市",
"861536447", "湖南省永州市",
"861834522", "黑龙江省鸡西市",
"861458144", "浙江省温州市",
"861581997", "广东省中山市",
"861454127", "河北省沧州市",
"861771224", "江苏省连云港市",
"861376677", "黑龙江省大庆市",
"86135018", "上海市",
"861863444", "山西省晋中市",
"861550695", "福建省泉州市",
"861854657", "黑龙江省黑河市",
"861815304", "河南省驻马店市",
"861771404", "江苏省徐州市",
"861898572", "贵州省安顺市",
"861786599", "山东省潍坊市",
"861343198", "广东省清远市",
"861596474", "山东省济宁市",
"861370554", "安徽省淮南市",
"861356792", "浙江省宁波市",
"86150352", "山西省大同市",
"861552892", "四川省巴中市",
"861534837", "湖南省益阳市",
"861519958", "新疆石河子市",
"861331450", "黑龙江省哈尔滨市",
"861370152", "江苏省无锡市",
"861889270", "四川省广安市",
"861319487", "四川省成都市",
"861362452", "黑龙江省齐齐哈尔市",
"861537503", "安徽省阜阳市",
"861815491", "新疆乌鲁木齐市",
"861570379", "河南省洛阳市",
"861560311", "河北省石家庄市",
"861838147", "四川省宜宾市",
"861300773", "青海省海东地区",
"861771391", "四川省广元市",
"86132024", "广东省佛山市",
"861850902", "新疆哈密地区",
"86132278", "陕西省西安市",
"8613911", "北京市",
"861870736", "湖南省常德市",
"861458542", "河南省驻马店市",
"861881325", "广东省梅州市",
"861760399", "河南省洛阳市",
"861817598", "湖南省长沙市",
"861301713", "湖南省株洲市",
"861583424", "山西省吕梁市",
"861885652", "安徽省芜湖市",
"861571319", "河北省邢台市",
"861372331", "宁夏银川市",
"861313988", "新疆乌鲁木齐市",
"861576623", "广东省梅州市",
"861509567", "甘肃省酒泉市",
"86132464", "广东省广州市",
"861387215", "湖北省咸宁市",
"86176980", "河南省郑州市",
"861800916", "陕西省汉中市",
"861316931", "广东省中山市",
"861772993", "安徽省宣城市",
"861569278", "贵州省六盘水市",
"861308365", "河南省洛阳市",
"861346573", "山东省潍坊市",
"86159973", "湖北省黄冈市",
"86158729", "湖北省荆门市",
"86155858", "贵州省六盘水市",
"861454210", "河南省商丘市",
"861365902", "四川省绵阳市",
"861530629", "江苏省南通市",
"861595498", "山东省烟台市",
"861379759", "湖北省襄樊市",
"861890359", "山西省运城市",
"861891432", "江苏省常州市",
"86152030", "海南省海口市",
"861524027", "江苏省镇江市",
"861770968", "安徽省阜阳市",
"861535435", "河北省唐山市",
"861889433", "甘肃省兰州市",
"861329490", "云南省昭通市",
"861327830", "吉林省松原市",
"861321444", "吉林省四平市",
"861539251", "山西省太原市",
"861315977", "吉林省长春市",
"861528044", "福建省福州市",
"861347303", "河北省邯郸市",
"861840473", "内蒙古乌海市",
"861821903", "广东省河源市",
"861450180", "山西省吕梁市",
"86153519", "江苏省常州市",
"861534409", "内蒙古阿拉善盟",
"861335115", "黑龙江省绥化市",
"861327689", "浙江省金华市",
"86183691", "山东省菏泽市",
"861826283", "江苏省连云港市",
"861320706", "江西省吉安市",
"861383344", "河北省廊坊市",
"861709484", "浙江省宁波市",
"861335685", "山东省青岛市",
"861508856", "浙江省温州市",
"861327119", "河南省许昌市",
"861328560", "安徽省合肥市",
"86170070", "江西省南昌市",
"861576745", "广东省惠州市",
"861330953", "宁夏吴忠市",
"861530472", "内蒙古包头市",
"861476579", "西藏拉萨市",
"861824287", "辽宁省阜新市",
"861534377", "河南省南阳市",
"861345426", "浙江省湖州市",
"861370642", "山东省青岛市",
"86180544", "山东省青岛市",
"861399525", "宁夏吴忠市",
"861884981", "云南省保山市",
"861335546", "山东省东营市",
"86145880", "广东省东莞市",
"861831756", "河南省新乡市",
"861319731", "湖北省宜昌市",
"861573801", "河南省濮阳市",
"861368376", "河南省信阳市",
"861598327", "四川省内江市",
"861397357", "湖南省邵阳市",
"861304394", "河南省周口市",
"86133821", "江苏省苏州市",
"861315103", "江苏省无锡市",
"861311727", "湖北省宜昌市",
"861777113", "湖北省襄樊市",
"861503289", "河北省邯郸市",
"86137404", "辽宁省沈阳市",
"861885142", "江苏省南通市",
"861318626", "陕西省咸阳市",
"861538295", "广东省清远市",
"861526023", "福建省厦门市",
"861531412", "山东省济南市",
"861881536", "山东省潍坊市",
"861363949", "山东省德州市",
"861598602", "广东省河源市",
"861511885", "广东省江门市",
"861862467", "辽宁省阜新市",
"861398447", "贵州省毕节地区",
"861803184", "河北省石家庄市",
"861526537", "山东省济宁市",
"861301851", "广东省阳江市",
"861556469", "山东省枣庄市",
"861313504", "湖南省衡阳市",
"86131759", "浙江省宁波市",
"861338474", "内蒙古兴安盟",
"86135493", "广东省东莞市",
"86181398", "甘肃省张掖市",
"861356860", "四川省南充市",
"861780994", "新疆昌吉回族自治州",
"86183704", "江西省赣州市",
"861569239", "山东省临沂市",
"861780651", "广东省惠州市",
"861477309", "湖南省邵阳市",
"861533966", "安徽省池州市",
"861822788", "四川省乐山市",
"861344000", "四川省绵阳市",
"861847502", "广东省云浮市",
"861362318", "河北省衡水市",
"86134574", "广西梧州市",
"861312359", "广西北海市",
"86186459", "黑龙江省大庆市",
"861301097", "黑龙江省齐齐哈尔市",
"861303136", "新疆伊犁哈萨克自治州",
"861317677", "山东省济宁市",
"861800568", "安徽省阜阳市",
"861810638", "山东省烟台市",
"861380243", "广东省广州市",
"861369461", "黑龙江省哈尔滨市",
"86139777", "广西钦州市",
"86136165", "浙江省杭州市",
"861814327", "西藏那曲地区",
"861772852", "广东省惠州市",
"861803752", "河南省濮阳市",
"861760370", "河南省商丘市",
"861770655", "浙江省绍兴市",
"861810422", "辽宁省鞍山市",
"861705315", "重庆市",
"861809740", "青海省西宁市",
"86155302", "河北省保定市",
"861860277", "湖北省襄樊市",
"861595554", "安徽省马鞍山市",
"861807010", "江西省赣州市",
"86158453", "黑龙江省鸡西市",
"861356231", "山东省滨州市",
"861334356", "湖北省襄樊市",
"86178695", "云南省昆明市",
"861336055", "广东省广州市",
"861570390", "河南省漯河市",
"861369555", "安徽省蚌埠市",
"861774255", "湖南省郴州市",
"861521732", "广东省广州市",
"86137940", "广东省佛山市",
"861893538", "山西省临汾市",
"861318109", "山东省聊城市",
"86176452", "黑龙江省齐齐哈尔市",
"861367327", "河北省沧州市",
"861889299", "新疆石河子市",
"861878446", "四川省内江市",
"86182789", "广西北海市",
"86182943", "甘肃省天水市",
"861316522", "山东省枣庄市",
"86189263", "广东省阳江市",
"86187872", "云南省大理白族自治州",
"861811024", "安徽省蚌埠市",
"861386157", "江苏省淮安市",
"861590631", "山东省威海市",
"861550733", "湖南省株洲市",
"861830061", "河南省焦作市",
"861598290", "四川省德阳市",
"861369616", "四川省乐山市",
"861771576", "四川省成都市",
"861568563", "贵州省六盘水市",
"861532262", "广东省汕头市",
"861812737", "广东省韶关市",
"86188628", "江苏省南通市",
"861392679", "广东省汕头市",
"861802593", "广东省东莞市",
"861364454", "黑龙江省佳木斯市",
"861880969", "宁夏银川市",
"861353647", "广东省汕尾市",
"861503661", "河南省新乡市",
"861806317", "山东省滨州市",
"861561596", "山东省潍坊市",
"861329479", "内蒙古锡林郭勒盟",
"86188190", "广东省深圳市",
"861886082", "江苏省盐城市",
"861339520", "江苏省淮安市",
"861857740", "广西梧州市",
"861453503", "山东省聊城市",
"861516588", "山东省枣庄市",
"861381584", "江苏省扬州市",
"861452527", "山东省东营市",
"861390481", "黑龙江省哈尔滨市",
"861357075", "广东省韶关市",
"861395680", "安徽省阜阳市",
"861831671", "广东省揭阳市",
"861569493", "河北省张家口市",
"861529118", "陕西省西安市",
"86150497", "内蒙古呼伦贝尔市",
"861395110", "江苏省苏州市",
"86189587", "浙江省温州市",
"86150610", "江苏省泰州市",
"861770145", "江苏省扬州市",
"861580848", "四川省泸州市",
"861529688", "广西河池市",
"861323937", "甘肃省酒泉市",
"86136114", "广东省广州市",
"861843467", "山西省忻州市",
"861860364", "黑龙江省佳木斯市",
"861875253", "江苏省扬州市",
"86180646", "广东省佛山市",
"861478426", "河南省周口市",
"861330892", "西藏日喀则地区",
"861859660", "福建省厦门市",
"861860840", "湖南省长沙市",
"861586402", "山东省济南市",
"861476590", "重庆市",
"861329438", "吉林省松原市",
"861830611", "江苏省常州市",
"861392202", "广东省阳江市",
"861806940", "浙江省杭州市",
"86138898", "辽宁省沈阳市",
"861512406", "辽宁省朝阳市",
"861336566", "安徽省池州市",
"861781716", "广东省惠州市",
"86139353", "山西省阳泉市",
"861386647", "安徽省池州市",
"861807660", "广西南宁市",
"861840861", "宁夏银川市",
"86157585", "云南省楚雄彝族自治州",
"86131423", "湖南省衡阳市",
"861390086", "湖北省荆门市",
"861812481", "广东省佛山市",
"861866673", "广东省湛江市",
"86134676", "湖南省长沙市",
"861342949", "浙江省绍兴市",
"861370784", "广西梧州市",
"861840298", "陕西省渭南市",
"861322970", "广东省梅州市",
"861372244", "河北省石家庄市",
"861368591", "福建省泉州市",
"861581650", "广东省韶关市",
"861593643", "河南省南阳市",
"861537719", "湖北省咸宁市",
"861879408", "甘肃省陇南市",
"86186723", "湖北省武汉市",
"861539049", "四川省南充市",
"861510543", "山东省滨州市",
"861897778", "广西南宁市",
"861310008", "山西省吕梁市",
"861775983", "福建省莆田市",
"861830466", "黑龙江省七台河市",
"861566549", "安徽省宿州市",
"861700459", "黑龙江省大庆市",
"861555449", "山东省威海市",
"861364530", "山东省菏泽市",
"861860329", "河北省石家庄市",
"861816323", "广东省珠海市",
"861471835", "广东省肇庆市",
"861303693", "广西桂林市",
"861390737", "湖南省益阳市",
"861893579", "新疆和田地区",
"861301509", "内蒙古乌海市",
"861873907", "河南省洛阳市",
"861858931", "云南省昆明市",
"861355840", "广西防城港市",
"861780776", "广西百色市",
"86131063", "浙江省绍兴市",
"861355364", "广东省韶关市",
"861835973", "福建省厦门市",
"861589975", "广东省深圳市",
"861333624", "山东省威海市",
"861391455", "江苏省镇江市",
"861869921", "新疆伊犁哈萨克自治州",
"861317959", "江苏省连云港市",
"861335395", "河南省漯河市",
"861769712", "青海省海东地区",
"861529330", "甘肃省平凉市",
"861523900", "河南省焦作市",
"861310962", "陕西省咸阳市",
"861327399", "河南省驻马店市",
"861355828", "广西河池市",
"861351597", "福建省厦门市",
"861864959", "山西省运城市",
"861814918", "陕西省西安市",
"861841999", "甘肃省定西市",
"861829974", "新疆乌鲁木齐市",
"86931", "甘肃省兰州市",
"861559617", "陕西省西安市",
"861576515", "黑龙江省双鸭山市",
"861575604", "安徽省铜陵市",
"86182314", "河北省承德市",
"861320105", "新疆喀什地区",
"86137659", "贵州省遵义市",
"861801342", "江苏省无锡市",
"861580349", "山西省朔州市",
"86187305", "河北省唐山市",
"861847016", "江西省上饶市",
"861576656", "广东省惠州市",
"861571199", "广东省深圳市",
"861860828", "四川省宜宾市",
"861597836", "河南省信阳市",
"861599496", "广东省潮州市",
"861772419", "广东省珠海市",
"861778031", "四川省宜宾市",
"86134551", "山东省济南市",
"861767706", "广西百色市",
"861318143", "山东省枣庄市",
"861801488", "江苏省苏州市",
"861831645", "广东省云浮市",
"861378740", "湖南省怀化市",
"861342177", "广东省云浮市",
"861373374", "河南省许昌市",
"861839483", "甘肃省定西市",
"861862435", "辽宁省大连市",
"861806928", "浙江省舟山市",
"861590700", "江西省南昌市",
"86138126", "江苏省苏州市",
"861379589", "四川省广元市",
"86180840", "重庆市",
"86187049", "内蒙古巴彦淖尔市",
"86159307", "河北省保定市",
"86155875", "湖北省恩施土家族苗族自治州",
"86135772", "云南省大理白族自治州",
"861808022", "四川省内江市",
"861760830", "四川省泸州市",
"861380429", "辽宁省葫芦岛市",
"861593272", "河北省沧州市",
"861594911", "江苏省盐城市",
"861580820", "四川省自贡市",
"861313476", "内蒙古赤峰市",
"86180822", "陕西省西安市",
"861572491", "浙江省金华市",
"861359853", "河南省焦作市",
"861323217", "广东省茂名市",
"861470796", "江西省吉安市",
"86138407", "辽宁省营口市",
"861308228", "辽宁省抚顺市",
"86151156", "湖南省常德市",
"861847411", "湖南省益阳市",
"861881891", "广东省广州市",
"861507258", "湖北省孝感市",
"861518817", "云南省玉溪市",
"861359711", "广西南宁市",
"861370498", "辽宁省阜新市",
"861308408", "安徽省蚌埠市",
"861301543", "山西省晋中市",
"861810380", "河南省商丘市",
"861339548", "山东省泰安市",
"861322413", "辽宁省抚顺市",
"861380672", "浙江省嘉兴市",
"861308337", "安徽省阜阳市",
"861887207", "湖北省孝感市",
"861561260", "河北省廊坊市",
"861333019", "江西省宜春市",
"861470315", "河北省唐山市",
"861368942", "甘肃省天水市",
"861508282", "四川省广元市",
"861805125", "江苏省连云港市",
"86182365", "河南省开封市",
"861700812", "江苏省盐城市",
"861827901", "江西省宜春市",
"861822558", "安徽省阜阳市",
"861824492", "广东省湛江市",
"861820397", "河南省郑州市",
"861559067", "吉林省长春市",
"861527986", "江西省宜春市",
"861531501", "山东省青岛市",
"861535467", "吉林省辽源市",
"861373058", "河北省沧州市",
"861572096", "江西省九江市",
"861377931", "新疆巴音郭楞蒙古自治州",
"86184178", "陕西省西安市",
"861459668", "新疆巴音郭楞蒙古自治州",
"861847666", "广东省湛江市",
"861595152", "江苏省宿迁市",
"861810957", "宁夏银川市",
"86189533", "山东省淄博市",
"861302744", "湖南省湘潭市",
"861848708", "云南省昆明市",
"861300284", "四川省遂宁市",
"86185582", "浙江省嘉兴市",
"861809728", "青海省玉树藏族自治州",
"861560944", "甘肃省天水市",
"861831723", "河南省南阳市",
"861551351", "山西省太原市",
"861835107", "江苏省苏州市",
"86186791", "江西省南昌市",
"861897187", "湖北省恩施土家族苗族自治州",
"861566015", "河南省南阳市",
"86181771", "广西南宁市",
"861510744", "湖南省张家界市",
"86186355", "山西省长治市",
"861873405", "安徽省亳州市",
"86136609", "广东省肇庆市",
"86136214", "广东省佛山市",
"861830489", "内蒙古赤峰市",
"861761445", "吉林省通化市",
"861571304", "河北省承德市",
"861370960", "广东省佛山市",
"861338317", "河北省沧州市",
"861809496", "新疆喀什地区",
"861832671", "安徽省铜陵市",
"861836240", "江苏省南通市",
"861377873", "四川省遂宁市",
"861303039", "河南省鹤壁市",
"861846500", "宁夏银川市",
"861803272", "河北省沧州市",
"861391202", "江苏省徐州市",
"861390069", "福建省福州市",
"861860757", "广东省佛山市",
"86139725", "湖北省宜昌市",
"861534072", "山西省大同市",
"861804911", "陕西省延安市",
"861350859", "贵州省黔西南布依族苗族自治州",
"86180307", "四川省成都市",
"861511226", "广东省深圳市",
"861370583", "浙江省嘉兴市",
"861800700", "江西省南昌市",
"86181904", "四川省德阳市",
"86182438", "吉林省松原市",
"861550450", "黑龙江省哈尔滨市",
"861454460", "陕西省西安市",
"861898823", "云南省德宏傣族景颇族自治州",
"861340400", "四川省绵阳市",
"861341949", "四川省内江市",
"861321970", "四川省乐山市",
"861379290", "山东省青岛市",
"861700151", "江苏省无锡市",
"861381335", "江苏省南京市",
"861337731", "广西桂林市",
"861506676", "山东省烟台市",
"861808055", "四川省成都市",
"861336589", "湖南省邵阳市",
"861816921", "湖南省郴州市",
"861369089", "广东省梅州市",
"861318742", "云南省昆明市",
"86132319", "河北省邢台市",
"861303354", "江苏省徐州市",
"861340220", "山东省济南市",
"861301392", "江苏省宿迁市",
"861351705", "江西省宜春市",
"861811481", "江苏省镇江市",
"861871923", "广东省阳江市",
"861812189", "四川省绵阳市",
"861470428", "辽宁省葫芦岛市",
"861323435", "吉林省通化市",
"861390024", "广东省广州市",
"861324701", "江西省鹰潭市",
"861370726", "湖北省荆门市",
"861320910", "陕西省咸阳市",
"861334134", "湖南省衡阳市",
"861554982", "湖北省孝感市",
"861470632", "山东省枣庄市",
"861355757", "广西南宁市",
"861768531", "贵州省贵阳市",
"861517251", "湖北省武汉市",
"86136265", "浙江省温州市",
"861815170", "江苏省无锡市",
"861805152", "江苏省苏州市",
"861874487", "贵州省铜仁地区",
"861809857", "安徽省黄山市",
"861858785", "广西南宁市",
"861399782", "湖北省十堰市",
"861333571", "浙江省杭州市",
"861863413", "河北省邯郸市",
"861778518", "贵州省六盘水市",
"861324442", "吉林省长春市",
"861809091", "四川省达州市",
"861458683", "湖南省常德市",
"861576003", "四川省成都市",
"861320347", "山西省临汾市",
"86188545", "山东省烟台市",
"861305087", "辽宁省盘锦市",
"861556219", "山东省临沂市",
"861550534", "山东省德州市",
"861458113", "安徽省宿州市",
"86150533", "山东省淄博市",
"861325720", "湖北省咸宁市",
"861563874", "河南省洛阳市",
"861896360", "江苏省南京市",
"861779105", "陕西省渭南市",
"861390619", "江苏省无锡市",
"861555994", "云南省保山市",
"861303078", "辽宁省铁岭市",
"861700641", "浙江省杭州市",
"861586090", "福建省泉州市",
"861555651", "安徽省合肥市",
"861319048", "辽宁省本溪市",
"861338940", "甘肃省兰州市",
"861531262", "江苏省南通市",
"861346996", "湖北省武汉市",
"861857091", "湖南省衡阳市",
"861780256", "江苏省宿迁市",
"861459531", "西藏拉萨市",
"861864718", "内蒙古鄂尔多斯市",
"861325966", "宁夏吴忠市",
"861381526", "江苏省苏州市",
"861595125", "江苏省连云港市",
"86188290", "陕西省西安市",
"861566665", "山东省聊城市",
"861360762", "河南省平顶山市",
"861452699", "陕西省铜川市",
"861398168", "四川省巴中市",
"861537637", "山东省枣庄市",
"861801593", "江苏省南通市",
"861568729", "云南省迪庆藏族自治州",
"861317718", "湖北省随州市",
"861502962", "陕西省榆林市",
"861803609", "江苏省苏州市",
"861471943", "甘肃省兰州市",
"861367759", "新疆哈密地区",
"861363558", "安徽省阜阳市",
"861520427", "辽宁省盘锦市",
"861775708", "浙江省衢州市",
"861580901", "新疆塔城地区",
"861313519", "湖南省邵阳市",
"861539146", "云南省昭通市",
"861857857", "广东省汕尾市",
"861559739", "青海省西宁市",
"861810561", "安徽省淮北市",
"86133622", "浙江省湖州市",
"861800631", "山东省威海市",
"861853697", "山西省忻州市",
"86158089", "海南省海口市",
"861770307", "广东省清远市",
"861708397", "河南省信阳市",
"861380815", "四川省自贡市",
"861321413", "辽宁省抚顺市",
"861847830", "湖南省岳阳市",
"861878862", "贵州省遵义市",
"861329145", "浙江省绍兴市",
"861700675", "浙江省宁波市",
"861336022", "广东省江门市",
"861870420", "辽宁省锦州市",
"861538982", "内蒙古呼和浩特市",
"861358134", "湖北省荆门市",
"861882891", "四川省雅安市",
"86133640", "重庆市",
"86170951", "江苏省苏州市",
"86151256", "云南省普洱市",
"861803725", "河南省周口市",
"861319020", "辽宁省丹东市",
"861537958", "宁夏中卫市",
"861514497", "内蒙古通辽市",
"861810455", "黑龙江省绥化市",
"861510392", "甘肃省张掖市",
"861569588", "浙江省杭州市",
"861804231", "浙江省杭州市",
"86130248", "福建省泉州市",
"861847689", "广东省广州市",
"861521133", "湖南省常德市",
"861770438", "吉林省松原市",
"861889963", "新疆克拉玛依市",
"861394978", "河南省三门峡市",
"861341903", "四川省德阳市",
"861562260", "广东省清远市",
"861875885", "浙江省杭州市",
"861596317", "山东省聊城市",
"861320473", "内蒙古乌海市",
"861520952", "宁夏石嘴山市",
"861577919", "江西省吉安市",
"861351472", "内蒙古包头市",
"861551953", "贵州省六盘水市",
"861591794", "广东省梅州市",
"86184024", "辽宁省沈阳市",
"861330984", "辽宁省大连市",
"861333545", "陕西省汉中市",
"861526649", "山东省临沂市",
"861325748", "湖南省长沙市",
"861324630", "广东省佛山市",
"861884693", "黑龙江省哈尔滨市",
"8615654", "海南省海口市",
"861590568", "安徽省阜阳市",
"861300406", "安徽省芜湖市",
"861378496", "河北省保定市",
"861825021", "福建省漳州市",
"861513668", "河南省南阳市",
"861328691", "广东省中山市",
"861893416", "广东省汕头市",
"861507739", "广西百色市",
"861328954", "宁夏固原市",
"861320230", "广东省惠州市",
"861475641", "河北省石家庄市",
"861304626", "广东省茂名市",
"861556978", "甘肃省酒泉市",
"861301744", "贵州省安顺市",
"861524480", "四川省眉山市",
"861506581", "山东省泰安市",
"861350412", "辽宁省鞍山市",
"861554108", "辽宁省葫芦岛市",
"861777654", "广西南宁市",
"861316555", "河北省衡水市",
"861318394", "四川省资阳市",
"861813095", "新疆伊犁哈萨克自治州",
"861309790", "广西防城港市",
"861337600", "江苏省泰州市",
"861350358", "山西省吕梁市",
"861346822", "山东省莱芜市",
"861533436", "云南省红河哈尼族彝族自治州",
"861803643", "江苏省南通市",
"861471909", "甘肃省张掖市",
"861334532", "新疆巴音郭楞蒙古自治州",
"861855890", "福建省龙岩市",
"861886763", "浙江省宁波市",
"861476289", "江苏省南京市",
"861555175", "安徽省马鞍山市",
"861514856", "内蒙古呼伦贝尔市",
"861333686", "浙江省宁波市",
"861327502", "福建省厦门市",
"861805273", "江苏省常州市",
"861802342", "广东省中山市",
"861519549", "江苏省徐州市",
"861330508", "福建省泉州市",
"861340248", "河北省石家庄市",
"86135446", "广东省东莞市",
"861869323", "甘肃省定西市",
"861868541", "贵州省贵阳市",
"861525281", "江苏省连云港市",
"861760666", "广东省佛山市",
"861826254", "江苏省常州市",
"86147929", "安徽省亳州市",
"861802488", "广东省河源市",
"86189610", "江苏省泰州市",
"861351664", "广东省佛山市",
"86150587", "浙江省温州市",
"861832645", "安徽省六安市",
"861705632", "云南省昆明市",
"86189497", "安徽省滁州市",
"861326372", "广西柳州市",
"861830842", "四川省德阳市",
"861360890", "山东省临沂市",
"861705208", "北京市",
"861479092", "安徽省宿州市",
"861572199", "陕西省铜川市",
"861306990", "黑龙江省双鸭山市",
"861576049", "四川省南充市",
"861344287", "云南省昭通市",
"861569904", "新疆昌吉回族自治州",
"861707846", "云南省德宏傣族景颇族自治州",
"861815319", "贵州省黔西南布依族苗族自治州",
"861521696", "广东省潮州市",
"861560499", "辽宁省辽阳市",
"861559778", "贵州省黔南布依族苗族自治州",
"861771419", "江苏省南京市",
"861761471", "内蒙古呼和浩特市",
"861516493", "内蒙古通辽市",
"861340687", "山东省德州市",
"861314365", "广东省广州市",
"861760411", "辽宁省大连市",
"861770479", "内蒙古锡林郭勒盟",
"861571491", "新疆克孜勒苏柯尔克孜自治州",
"861528663", "贵州省黔东南苗族侗族自治州",
"861300001", "江苏省常州市",
"861863970", "河南省信阳市",
"86159646", "山东省菏泽市",
"861834785", "内蒙古巴彦淖尔市",
"86138226", "广东省肇庆市",
"861589477", "新疆昌吉回族自治州",
"861391957", "甘肃省陇南市",
"861368452", "黑龙江省齐齐哈尔市",
"861471601", "广东省深圳市",
"86186831", "四川省宜宾市",
"861568973", "山东省济南市",
"861351921", "宁夏银川市",
"861892174", "江苏省泰州市",
"861846456", "山东省威海市",
"861787628", "广东省韶关市",
"861771966", "陕西省西安市",
"861517277", "湖北省随州市",
"861571525", "江苏省扬州市",
"861453736", "湖南省怀化市",
"861500512", "江苏省连云港市",
"861816705", "浙江省台州市",
"861580643", "山东省淄博市",
"861353622", "广东省江门市",
"861365581", "浙江省杭州市",
"861530356", "山西省晋城市",
"861809871", "安徽省宿州市",
"861327767", "湖北省武汉市",
"861452542", "山东省青岛市",
"86156125", "河北省唐山市",
"86132878", "山东省威海市",
"861813841", "广东省深圳市",
"861333557", "安徽省宿州市",
"861869597", "河南省南阳市",
"861567202", "湖北省黄石市",
"861556631", "辽宁省抚顺市",
"861845269", "江苏省淮安市",
"861894226", "江西省赣州市",
"861342812", "广东省湛江市",
"861321708", "江西省新余市",
"861327693", "福建省龙岩市",
"861340615", "山东省滨州市",
"861887630", "福建省漳州市",
"861352323", "河南省新乡市",
"861316547", "山东省济宁市",
"861453087", "安徽省铜陵市",
"86170713", "上海市",
"861359937", "福建省福州市",
"861778993", "西藏山南地区",
"861826299", "江苏省常州市",
"86133075", "海南省海口市",
"861773074", "陕西省汉中市",
"861880579", "浙江省金华市",
"861329157", "浙江省金华市",
"861339776", "广西百色市",
"861527011", "江西省鹰潭市",
"86188643", "河南省周口市",
"861367342", "河南省周口市",
"861330865", "湖北省武汉市",
"861818604", "湖北省黄冈市",
"86150635", "山东省聊城市",
"861850581", "浙江省杭州市",
"861390231", "广东省深圳市",
"861560454", "黑龙江省佳木斯市",
"861522044", "广东省汕头市",
"861398690", "湖北省十堰市",
"861800978", "青海省西宁市",
"861325852", "黑龙江省鸡西市",
"861307937", "甘肃省武威市",
"861773412", "河北省邯郸市",
"861340556", "江苏省扬州市",
"86996", "新疆巴音郭楞蒙古自治州",
"861308514", "湖北省武汉市",
"861788900", "西藏拉萨市",
"86138599", "福建省厦门市",
"861354733", "四川省巴中市",
"861760383", "河南省新乡市",
"861839913", "新疆和田地区",
"86182928", "陕西省西安市",
"861810447", "吉林省吉林市",
"861502856", "河北省秦皇岛市",
"861882045", "广东省茂名市",
"861857871", "广东省汕尾市",
"861772989", "四川省德阳市",
"861359120", "辽宁省鞍山市",
"861776815", "江苏省宿迁市",
"861311114", "山西省晋城市",
"861322560", "安徽省合肥市",
"861378845", "广西玉林市",
"861581932", "广东省肇庆市",
"861800939", "甘肃省陇南市",
"86177279", "广东省深圳市",
"861599933", "新疆哈密地区",
"861820724", "湖北省咸宁市",
"861593303", "河北省张家口市",
"861832657", "安徽省马鞍山市",
"861311684", "浙江省衢州市",
"861577466", "黑龙江省鹤岗市",
"861775970", "福建省龙岩市",
"86145280", "四川省成都市",
"861501995", "广东省东莞市",
"861571336", "河北省廊坊市",
"8615791", "北京市",
"861534892", "西藏日喀则地区",
"861362376", "河南省信阳市",
"861819905", "新疆喀什地区",
"861860771", "广西南宁市",
"861384848", "内蒙古巴彦淖尔市",
"861529222", "湖南省株洲市",
"861580725", "湖北省黄冈市",
"861709341", "广东省广州市",
"861565990", "福建省南平市",
"861322983", "广东省清远市",
"861866680", "广东省茂名市",
"861760735", "湖南省郴州市",
"861592602", "湖北省鄂州市",
"861357956", "新疆克孜勒苏柯尔克孜自治州",
"861354385", "广东省珠海市",
"861310174", "河南省南阳市",
"86152902", "河南省信阳市",
"86136687", "云南省昆明市",
"861821246", "贵州省铜仁地区",
"86156277", "广东省佛山市",
"861529402", "甘肃省张掖市",
"86137173", "广东省东莞市",
"861318034", "河北省廊坊市",
"861332012", "江西省九江市",
"861590805", "山东省潍坊市",
"861820769", "广东省东莞市",
"861392447", "广东省梅州市",
"861387000", "江西省鹰潭市",
"861830758", "广东省肇庆市",
"861329647", "山东省东营市",
"861591759", "广东省湛江市",
"86186748", "湖南省长沙市",
"861572644", "山东省济南市",
"861314543", "山东省滨州市",
"861553870", "河南省郑州市",
"861526941", "山东省济宁市",
"861309956", "宁夏石嘴山市",
"861594737", "内蒙古鄂尔多斯市",
"861577181", "陕西省延安市",
"861560530", "山东省菏泽市",
"861332474", "广西贺州市",
"861328999", "新疆伊犁哈萨克自治州",
"861880538", "山东省泰安市",
"861823010", "河北省邯郸市",
"861336976", "青海省西宁市",
"861879112", "陕西省延安市",
"861510032", "河北省保定市",
"861318359", "四川省达州市",
"861596385", "山东省莱芜市",
"86151023", "重庆市",
"861533391", "河南省焦作市",
"861893924", "河南省郑州市",
"861355771", "广西南宁市",
"861533224", "陕西省渭南市",
"861338733", "湖南省株洲市",
"861855507", "安徽省宿州市",
"861816472", "云南省红河哈尼族彝族自治州",
"861879514", "宁夏固原市",
"861533404", "湖北省宜昌市",
"861882476", "广东省汕头市",
"86153749", "内蒙古鄂尔多斯市",
"861887701", "广西防城港市",
"861806450", "福建省厦门市",
"861839470", "甘肃省酒泉市",
"861780548", "山东省泰安市",
"861855070", "江苏省扬州市",
"861537135", "江苏省宿迁市",
"861375424", "浙江省湖州市",
"861359217", "河南省平顶山市",
"86151572", "浙江省湖州市",
"861355745", "广西玉林市",
"861345909", "福建省莆田市",
"861597198", "湖北省武汉市",
"861365676", "浙江省台州市",
"861829529", "宁夏固原市",
"861595627", "安徽省宣城市",
"861824465", "河北省秦皇岛市",
"861566167", "内蒙古通辽市",
"86139504", "福建省福州市",
"861804069", "湖北省武汉市",
"861569936", "新疆阿克苏地区",
"86138738", "湖南省娄底市",
"861700949", "重庆市",
"861519692", "四川省遂宁市",
"861322296", "江苏省苏州市",
"861864882", "广西来宾市",
"861390911", "陕西省延安市",
"861310572", "浙江省湖州市",
"861858717", "云南省普洱市",
"861318858", "辽宁省盘锦市",
"861378871", "广西南宁市",
"861761457", "黑龙江省大兴安岭地区",
"861515446", "山东省潍坊市",
"861452654", "江西省抚州市",
"861375469", "山东省滨州市",
"86158166", "广东省汕头市",
"861817191", "湖北省宜昌市",
"861839233", "陕西省渭南市",
"861860745", "湖南省怀化市",
"861829564", "宁夏固原市",
"86150509", "江苏省宿迁市",
"861816014", "四川省内江市",
"861311512", "江苏省苏州市",
"861391971", "甘肃省定西市",
"861536690", "江苏省扬州市",
"86177555", "安徽省马鞍山市",
"86180765", "广西南宁市",
"861801238", "江苏省无锡市",
"861367794", "江西省抚州市",
"861395721", "浙江省舟山市",
"86138841", "甘肃省庆阳市",
"86156482", "内蒙古兴安盟",
"86178644", "山东省潍坊市",
"861588495", "四川省巴中市",
"861358106", "山东省临沂市",
"86130123", "重庆市",
"861889774", "广西柳州市",
"861508628", "贵州省铜仁地区",
"861584672", "黑龙江省鸡西市",
"861581212", "云南省昆明市",
"86147439", "吉林省长春市",
"86185914", "陕西省西安市",
"861315535", "安徽省马鞍山市",
"861305665", "四川省宜宾市",
"861553330", "河北省邯郸市",
"861308112", "河北省石家庄市",
"861572552", "山东省烟台市",
"861592918", "陕西省榆林市",
"861350894", "山东省淄博市",
"861882071", "广东省东莞市",
"861857845", "广东省东莞市",
"861319265", "广东省佛山市",
"861534760", "广东省河源市",
"861782035", "广东省肇庆市",
"861840734", "湖南省衡阳市",
"861393429", "山西省长治市",
"861809845", "安徽省宣城市",
"861368927", "陕西省宝鸡市",
"861364944", "广西梧州市",
"861566087", "河南省焦作市",
"861598976", "广东省珠海市",
"861454714", "浙江省宁波市",
"861539587", "浙江省绍兴市",
"861323853", "贵州省六盘水市",
"861775413", "安徽省宿州市",
"861317403", "江苏省盐城市",
"861783505", "山西省临汾市",
"861303399", "河南省濮阳市",
"861570816", "四川省绵阳市",
"861816629", "湖南省益阳市",
"861500684", "山东省东营市",
"861810373", "河南省新乡市",
"861571876", "云南省昆明市",
"861787640", "广东省江门市",
"861452144", "河北省石家庄市",
"861347126", "广西桂林市",
"86180714", "湖北省武汉市",
"861864403", "黑龙江省牡丹江市",
"861558892", "山东省莱芜市",
"861335362", "河南省商丘市",
"861457111", "湖北省武汉市",
"861473068", "河北省石家庄市",
"861320355", "山西省长治市",
"861831657", "广东省佛山市",
"861327078", "江苏省泰州市",
"861312684", "内蒙古巴彦淖尔市",
"861872779", "湖北省咸宁市",
"861559546", "宁夏中卫市",
"861361376", "河南省信阳市",
"861317141", "内蒙古呼和浩特市",
"861815063", "福建省福州市",
"86133027", "广东省汕头市",
"861360795", "江西省宜春市",
"861865982", "福建省泉州市",
"861709943", "浙江省丽水市",
"861321560", "安徽省合肥市",
"86156071", "湖北省武汉市",
"861867744", "广西梧州市",
"861566692", "山东省济宁市",
"86189509", "福建省三明市",
"86137273", "广东省佛山市",
"86139862", "湖北省武汉市",
"861820786", "广西百色市",
"86183732", "湖南省湘潭市",
"861591238", "云南省玉溪市",
"86156177", "河南省郑州市",
"86159765", "广东省茂名市",
"861538412", "浙江省湖州市",
"861593901", "河南省郑州市",
"861776672", "四川省绵阳市",
"861827609", "广西梧州市",
"86133121", "天津市",
"861321983", "四川省宜宾市",
"861360316", "河北省廊坊市",
"861318727", "湖南省郴州市",
"861876233", "江苏省泰州市",
"861524910", "陕西省西安市",
"861533993", "山东省聊城市",
"861350982", "广东省东莞市",
"861571644", "河南省洛阳市",
"86182270", "四川省绵阳市",
"861323285", "广东省江门市",
"861370570", "浙江省衢州市",
"861538074", "江苏省泰州市",
"861855795", "浙江省宁波市",
"861331474", "内蒙古兴安盟",
"861391447", "江苏省南京市",
"861345835", "四川省自贡市",
"861507821", "广西百色市",
"86158536", "山东省潍坊市",
"861377639", "江苏省常州市",
"861520701", "江西省鹰潭市",
"86137432", "吉林省吉林市",
"861807198", "湖北省武汉市",
"861370007", "辽宁省盘锦市",
"861308097", "陕西省榆林市",
"86184855", "贵州省黔东南苗族侗族自治州",
"861501497", "广东省惠州市",
"861507546", "河北省廊坊市",
"861820523", "江苏省淮安市",
"861777527", "安徽省芜湖市",
"861353171", "广东省惠州市",
"861339256", "广东省惠州市",
"861811231", "江苏省常州市",
"86187767", "广西南宁市",
"861813908", "新疆巴音郭楞蒙古自治州",
"861330414", "辽宁省本溪市",
"861550928", "陕西省安康市",
"861317651", "山东省青岛市",
"861894284", "四川省成都市",
"861377678", "江苏省徐州市",
"861317994", "新疆昌吉回族自治州",
"861325576", "浙江省台州市",
"86131390", "青海省西宁市",
"861810945", "甘肃省武威市",
"861537448", "甘肃省天水市",
"861869629", "湖北省黄石市",
"861870637", "山东省临沂市",
"861507685", "河北省衡水市",
"861700301", "广东省东莞市",
"861528324", "四川省资阳市",
"861378933", "湖南省湘西土家族苗族自治州",
"861365360", "山西省太原市",
"86130719", "浙江省宁波市",
"861348558", "安徽省阜阳市",
"86131933", "陕西省西安市",
"861524347", "河北省秦皇岛市",
"86159714", "湖北省武汉市",
"861385137", "江苏省宿迁市",
"861864994", "福建省泉州市",
"861841954", "甘肃省陇南市",
"861857213", "湖北省鄂州市",
"86150981", "山东省威海市",
"861890684", "浙江省宁波市",
"861526808", "浙江省衢州市",
"86178059", "福建省福州市",
"861389832", "辽宁省抚顺市",
"861308713", "内蒙古兴安盟",
"861351323", "河北省张家口市",
"861803349", "广东省东莞市",
"861333961", "贵州省贵阳市",
"861320322", "湖南省湘潭市",
"86155781", "广西南宁市",
"861596534", "山东省德州市",
"861831218", "广东省茂名市",
"861324427", "吉林省长春市",
"861848413", "贵州省贵阳市",
"861839311", "甘肃省白银市",
"861872738", "湖北省荆州市",
"861337328", "河北省秦皇岛市",
"861458670", "湖南省娄底市",
"861538358", "山西省吕梁市",
"86155158", "河南省郑州市",
"861327039", "江苏省常州市",
"861305503", "湖南省常德市",
"861827272", "河南省焦作市",
"861501856", "广东省湛江市",
"861862853", "陕西省渭南市",
"861337237", "浙江省台州市",
"86182707", "江西省赣州市",
"861591279", "云南省西双版纳傣族自治州",
"861772720", "广东省汕尾市",
"861707997", "浙江省丽水市",
"861334009", "江西省宜春市",
"861828903", "西藏山南地区",
"86188594", "福建省泉州市",
"861346433", "辽宁省鞍山市",
"861590978", "青海省西宁市",
"86189635", "山东省聊城市",
"86153662", "江苏省苏州市",
"861302032", "辽宁省沈阳市",
"861310497", "广东省肇庆市",
"861526309", "山东省泰安市",
"861819878", "广东省阳江市",
"861865108", "江苏省南通市",
"86130223", "重庆市",
"861826580", "山东省菏泽市",
"861454513", "湖南省衡阳市",
"861879097", "河南省濮阳市",
"861571552", "安徽省蚌埠市",
"861337340", "河北省邯郸市",
"861898640", "湖北省鄂州市",
"861874829", "内蒙古赤峰市",
"86184430", "吉林省长春市",
"861368425", "四川省攀枝花市",
"861337864", "广东省佛山市",
"861830919", "陕西省铜川市",
"861320480", "内蒙古呼和浩特市",
"861599871", "山东省聊城市",
"861313057", "辽宁省营口市",
"861575193", "甘肃省白银市",
"861770647", "浙江省宁波市",
"861550317", "河北省沧州市",
"86135867", "浙江省宁波市",
"861810971", "青海省西宁市",
"861471453", "广东省广州市",
"861870958", "宁夏银川市",
"861890512", "江苏省连云港市",
"861840533", "山东省淄博市",
"86157637", "山东省济宁市",
"861589649", "江苏省无锡市",
"861338450", "黑龙江省哈尔滨市",
"861313268", "广西河池市",
"861537420", "江西省九江市",
"861535575", "浙江省绍兴市",
"861520630", "山东省潍坊市",
"861303502", "安徽省蚌埠市",
"861700494", "北京市",
"861813182", "河北省衡水市",
"861538859", "山西省运城市",
"861337829", "四川省内江市",
"8618822", "天津市",
"861369547", "山东省济宁市",
"861774247", "陕西省安康市",
"861551377", "山西省晋中市",
"861572876", "广东省广州市",
"861527579", "山东省临沂市",
"861534984", "安徽省安庆市",
"861336047", "广东省东莞市",
"86715", "湖北省咸宁市",
"86155046", "黑龙江省哈尔滨市",
"861334043", "福建省厦门市",
"861587769", "陕西省宝鸡市",
"861534508", "福建省龙岩市",
"861583568", "山西省晋城市",
"861881476", "黑龙江省大庆市",
"861804737", "内蒙古鄂尔多斯市",
"861551229", "河北省衡水市",
"861397260", "湖北省宜昌市",
"861829763", "安徽省宿州市",
"861310856", "云南省大理白族自治州",
"861458389", "福建省龙岩市",
"861550940", "甘肃省张掖市",
"86181326", "河北省石家庄市",
"861386655", "安徽省宿州市",
"861551409", "河南省开封市",
"861580752", "广东省惠州市",
"861475788", "浙江省金华市",
"86189456", "黑龙江省哈尔滨市",
"861305549", "福建省南平市",
"861527538", "山东省泰安市",
"861533286", "内蒙古鄂尔多斯市",
"861829697", "江西省抚州市",
"861804086", "新疆吐鲁番地区",
"861857933", "江西省上饶市",
"861889254", "贵州省安顺市",
"861893293", "河北省石家庄市",
"861530532", "山东省青岛市",
"861880416", "辽宁省锦州市",
"86151312", "河北省保定市",
"861353145", "广东省韶关市",
"861325681", "山东省威海市",
"861770157", "江苏省苏州市",
"861551264", "河北省廊坊市",
"861819839", "贵州省六盘水市",
"861817499", "广西百色市",
"861884898", "河南省洛阳市",
"861803303", "广东省东莞市",
"861388754", "云南省文山壮族苗族自治州",
"861568831", "新疆吐鲁番地区",
"861535992", "福建省龙岩市",
"861375161", "广东省阳江市",
"861877043", "江西省上饶市",
"861589159", "陕西省咸阳市",
"861768190", "浙江省金华市",
"86159389", "河南省平顶山市",
"861831938", "广东省深圳市",
"861321296", "黑龙江省齐齐哈尔市",
"861452393", "西藏山南地区",
"861809933", "新疆阿克苏地区",
"861479185", "陕西省榆林市",
"861317175", "河北省邢台市",
"861346847", "山东省潍坊市",
"861338534", "山东省德州市",
"861880661", "广东省汕头市",
"861819110", "陕西省西安市",
"861570030", "四川省广安市",
"86136510", "北京市",
"861337917", "陕西省宝鸡市",
"861364499", "辽宁省沈阳市",
"861385948", "福建省南平市",
"86158266", "湖北省荆州市",
"861390313", "河北省张家口市",
"861340332", "河北省保定市",
"861835729", "浙江省湖州市",
"861819680", "新疆喀什地区",
"861513863", "河南省南阳市",
"861341934", "四川省雅安市",
"861336410", "辽宁省铁岭市",
"861885157", "江苏省无锡市",
"861572211", "贵州省贵阳市",
"861557705", "广西来宾市",
"861364631", "山东省威海市",
"861883840", "河南省安阳市",
"86134786", "辽宁省大连市",
"861889852", "广东省湛江市",
"86187021", "上海市",
"861332719", "内蒙古包头市",
"86187461", "黑龙江省哈尔滨市",
"86187127", "河北省秦皇岛市",
"861817631", "广西桂林市",
"861505108", "江苏省盐城市",
"86138528", "江苏省泰州市",
"861358103", "山东省淄博市",
"861539727", "浙江省嘉兴市",
"861370657", "浙江省台州市",
"861305317", "安徽省淮南市",
"86187418", "辽宁省阜新市",
"86999", "新疆伊犁哈萨克自治州",
"861848538", "贵州省黔南布依族苗族自治州",
"861821464", "云南省昆明市",
"861590454", "黑龙江省佳木斯市",
"86181935", "甘肃省武威市",
"861319412", "辽宁省鞍山市",
"861376574", "贵州省六盘水市",
"861772299", "广东省河源市",
"861810376", "河南省信阳市",
"861339885", "云南省昆明市",
"861571873", "云南省红河哈尼族彝族自治州",
"861510739", "湖南省邵阳市",
"861347123", "广西柳州市",
"861303044", "内蒙古兴安盟",
"861830510", "江苏省盐城市",
"861811795", "四川省泸州市",
"861477084", "江西省宜春市",
"86159700", "江西省赣州市",
"861870474", "内蒙古乌兰察布市",
"861593094", "河北省邢台市",
"861509705", "甘肃省平凉市",
"861537695", "山东省烟台市",
"861559392", "甘肃省陇南市",
"861820062", "广东省汕头市",
"861345768", "广西桂林市",
"861859455", "福建省莆田市",
"861398452", "贵州省遵义市",
"86133761", "江苏省镇江市",
"861598973", "广东省汕头市",
"861350020", "广东省韶关市",
"861899597", "湖北省随州市",
"861323856", "贵州省铜仁地区",
"861326798", "广东省珠海市",
"861826989", "安徽省滁州市",
"861347755", "湖北省荆门市",
"86182026", "天津市",
"861775416", "安徽省阜阳市",
"86159125", "云南省昆明市",
"861576858", "广东省中山市",
"861317406", "江苏省无锡市",
"86133718", "上海市",
"861570813", "四川省自贡市",
"861820612", "江苏省常州市",
"86182679", "浙江省金华市",
"861330259", "广东省中山市",
"861320268", "广东省东莞市",
"86187275", "湖北省孝感市",
"861837188", "湖北省随州市",
"861338087", "广东省中山市",
"861531487", "浙江省丽水市",
"861570751", "广东省湛江市",
"861510778", "广西河池市",
"861339621", "山东省菏泽市",
"861365673", "浙江省嘉兴市",
"86184576", "浙江省台州市",
"86155487", "内蒙古呼和浩特市",
"861313480", "内蒙古巴彦淖尔市",
"861370147", "江苏省南京市",
"86189748", "湖南省长沙市",
"861898467", "贵州省铜仁地区",
"86182401", "辽宁省沈阳市",
"861328289", "浙江省金华市",
"861597679", "广东省汕尾市",
"861362447", "吉林省长春市",
"861338736", "湖南省常德市",
"861334659", "广东省云浮市",
"861838152", "四川省乐山市",
"861513889", "河南省安阳市",
"861590530", "山东省菏泽市",
"861458557", "山东省日照市",
"861882473", "广东省中山市",
"861361945", "云南省保山市",
"861595990", "福建省南平市",
"86134853", "山西省太原市",
"861804890", "四川省绵阳市",
"861890771", "广西南宁市",
"861379371", "山东省枣庄市",
"86177094", "甘肃省兰州市",
"861319358", "河南省濮阳市",
"861317001", "安徽省合肥市",
"86151558", "安徽省阜阳市",
"86139687", "浙江省温州市",
"861839236", "陕西省西安市",
"861311251", "广东省潮州市",
"86159277", "湖北省荆州市",
"861874262", "新疆阿克苏地区",
"861358977", "山东省烟台市",
"861829789", "安徽省六安市",
"861770460", "福建省福州市",
"861870662", "山东省滨州市",
"86130546", "山东省东营市",
"861894449", "江苏省扬州市",
"861708875", "广东省茂名市",
"861569933", "新疆石河子市",
"861532985", "贵州省黔东南苗族侗族自治州",
"861472897", "西藏日喀则地区",
"861322293", "江苏省无锡市",
"861323497", "黑龙江省哈尔滨市",
"861478372", "河南省安阳市",
"861808831", "云南省昆明市",
"86158869", "新疆伊犁哈萨克自治州",
"861515443", "山东省青岛市",
"861550549", "山东省临沂市",
"861705559", "北京市",
"861873899", "河南省开封市",
"861508965", "广东省肇庆市",
"861454479", "陕西省铜川市",
"861322986", "河北省邢台市",
"86138382", "河南省郑州市",
"861390070", "江西省南昌市",
"861361971", "青海省西宁市",
"861354167", "四川省自贡市",
"861357953", "新疆克拉玛依市",
"861572931", "河南省周口市",
"86139370", "河南省商丘市",
"861890745", "湖南省怀化市",
"861379345", "山东省德州市",
"861352535", "河南省平顶山市",
"861526634", "山东省莱芜市",
"861509014", "河南省南阳市",
"861363672", "陕西省延安市",
"86180071", "湖北省武汉市",
"861894882", "广东省韶关市",
"861313322", "山西省大同市",
"861598410", "四川省宜宾市",
"8617743", "吉林省长春市",
"861452281", "山西省太原市",
"861370979", "青海省海西蒙古族藏族自治州",
"861780780", "广西南宁市",
"86136504", "广东省东莞市",
"861599936", "新疆昌吉回族自治州",
"861882347", "广东省佛山市",
"861593306", "河北省廊坊市",
"861326484", "湖北省孝感市",
"861708841", "江西省萍乡市",
"861886635", "山东省聊城市",
"861390507", "福建省泉州市",
"861577463", "黑龙江省牡丹江市",
"861301739", "湖南省长沙市",
"861365242", "广东省深圳市",
"861362373", "河南省新乡市",
"861321924", "四川省广安市",
"861571333", "河北省张家口市",
"861364700", "江西省南昌市",
"861336973", "青海省黄南藏族自治州",
"861536452", "山西省大同市",
"861893381", "广东省湛江市",
"861580585", "浙江省绍兴市",
"861815089", "福建省厦门市",
"861579425", "江苏省苏州市",
"861470559", "安徽省黄山市",
"861889419", "甘肃省陇南市",
"861841439", "内蒙古兴安盟",
"861358149", "湖北省宜昌市",
"861840352", "山西省大同市",
"86134041", "江苏省南京市",
"861856828", "河南省信阳市",
"861861497", "河南省郑州市",
"86158917", "陕西省西安市",
"861567198", "湖北省鄂州市",
"86134147", "广东省惠州市",
"861369818", "四川省德阳市",
"861302067", "山东省济宁市",
"861850242", "辽宁省盘锦市",
"861867821", "山东省淄博市",
"861556191", "黑龙江省伊春市",
"861777178", "湖北省武汉市",
"861820584", "浙江省宁波市",
"861552041", "四川省南充市",
"861321969", "四川省乐山市",
"86152184", "广东省肇庆市",
"861557014", "江西省南昌市",
"861314546", "山东省东营市",
"861309953", "宁夏吴忠市",
"861453385", "内蒙古通辽市",
"86187559", "安徽省黄山市",
"86170769", "广东省深圳市",
"861808371", "江苏省泰州市",
"861515409", "山东省莱芜市",
"861550503", "安徽省六安市",
"861771580", "江苏省无锡市",
"861350048", "辽宁省阜新市",
"861894223", "江西省南昌市",
"861812507", "广东省珠海市",
"861896379", "安徽省合肥市",
"861327696", "福建省厦门市",
"861813523", "山西省临汾市",
"861837902", "江西省新余市",
"861352326", "河南省平顶山市",
"861778996", "西藏那曲地区",
"86186981", "天津市",
"861862572", "河南省周口市",
"861302187", "河北省保定市",
"861820908", "新疆克孜勒苏柯尔克孜自治州",
"861782877", "四川省南充市",
"861340367", "山西省忻州市",
"861533855", "贵州省黔南布依族苗族自治州",
"861363464", "黑龙江省双鸭山市",
"861812070", "福建省泉州市",
"861867115", "湖北省咸宁市",
"861846453", "山东省烟台市",
"861394944", "河南省开封市",
"861596087", "福建省漳州市",
"861840418", "辽宁省阜新市",
"861771963", "陕西省榆林市",
"861580646", "山东省潍坊市",
"861398927", "四川省绵阳市",
"861802052", "江苏省无锡市",
"861453733", "湖南省株洲市",
"861597957", "江西省抚州市",
"861530353", "山西省阳泉市",
"861850721", "湖北省荆州市",
"861351384", "河南省洛阳市",
"861377491", "山东省日照市",
"86180225", "广东省揭阳市",
"861334977", "湖北省宜昌市",
"861354736", "四川省泸州市",
"861760386", "河南省郑州市",
"861583191", "河北省邢台市",
"861363209", "广东省江门市",
"861839916", "新疆和田地区",
"861512959", "陕西省延安市",
"861829801", "安徽省合肥市",
"861773265", "河北省保定市",
"861530567", "安徽省亳州市",
"861502853", "河北省承德市",
"861454438", "江苏省淮安市",
"861865048", "福建省福州市",
"861585040", "江苏省宿迁市",
"86155433", "吉林省松原市",
"861301778", "浙江省嘉兴市",
"861454307", "黑龙江省哈尔滨市",
"86180592", "福建省厦门市",
"861897509", "湖南省怀化市",
"861571785", "湖北省襄樊市",
"861339773", "广西桂林市",
"86159482", "吉林省长春市",
"86152755", "山东省烟台市",
"86132852", "江苏省泰州市",
"861882910", "陕西省西安市",
"861346518", "山东省德州市",
"861340553", "江苏省泰州市",
"861580874", "云南省曲靖市",
"86184316", "河北省廊坊市",
"86152391", "河南省焦作市",
"861533283", "内蒙古兴安盟",
"861323995", "新疆吐鲁番地区",
"861804083", "新疆石河子市",
"861503381", "河北省保定市",
"861514148", "辽宁省铁岭市",
"861524071", "广西南宁市",
"861893296", "河北省邢台市",
"86137554", "江西省吉安市",
"861880413", "辽宁省抚顺市",
"861821815", "广东省湛江市",
"861374777", "内蒙古鄂尔多斯市",
"861373320", "河北省邯郸市",
"861700540", "山东省青岛市",
"861334046", "福建省泉州市",
"861300959", "内蒙古乌海市",
"861881473", "黑龙江省牡丹江市",
"861336345", "山西省长治市",
"861587584", "广东省肇庆市",
"861358475", "江苏省盐城市",
"861899472", "江苏省泰州市",
"861858199", "四川省成都市",
"861829766", "安徽省宿州市",
"861332637", "山东省枣庄市",
"861310853", "云南省昆明市",
"861366859", "贵州省黔西南布依族苗族自治州",
"861316818", "广东省阳江市",
"861361447", "吉林省长春市",
"86136862", "广东省东莞市",
"861306642", "广东省江门市",
"861372278", "河北省石家庄市",
"861380558", "安徽省阜阳市",
"861561602", "湖南省长沙市",
"86186509", "福建省三明市",
"861304828", "广东省梅州市",
"861502285", "新疆克拉玛依市",
"861500745", "湖南省怀化市",
"861818339", "四川省泸州市",
"861452715", "湖北省咸宁市",
"861390316", "河北省廊坊市",
"861569331", "甘肃省兰州市",
"861593517", "山西省吕梁市",
"861345500", "山东省日照市",
"861334702", "内蒙古呼伦贝尔市",
"861359962", "福建省龙岩市",
"861513866", "河南省郑州市",
"861510617", "江苏省无锡市",
"861458961", "广东省阳江市",
"861330738", "湖南省娄底市",
"861803306", "广东省深圳市",
"861840325", "河北省唐山市",
"861877046", "江西省吉安市",
"86183388", "河南省洛阳市",
"861892711", "广东省潮州市",
"861705165", "山东省青岛市",
"861345077", "广东省佛山市",
"861454145", "吉林省通化市",
"861596692", "山东省青岛市",
"86159071", "湖北省武汉市",
"861881230", "云南省普洱市",
"861809936", "新疆昌吉回族自治州",
"861536425", "湖南省衡阳市",
"861452396", "西藏那曲地区",
"861390795", "江西省宜春市",
"861471897", "西藏拉萨市",
"861321293", "黑龙江省哈尔滨市",
"861333670", "浙江省绍兴市",
"861871865", "广东省韶关市",
"861818378", "云南省楚雄彝族自治州",
"861454516", "湖南省娄底市",
"861859957", "福建省莆田市",
"861372239", "河北省邯郸市",
"861333888", "江苏省泰州市",
"861768630", "山东省威海市",
"861346436", "辽宁省鞍山市",
"861533822", "广东省汕头市",
"861868432", "吉林省吉林市",
"861768889", "广东省深圳市",
"861539034", "四川省宜宾市",
"861582551", "浙江省杭州市",
"861323572", "浙江省湖州市",
"861868628", "内蒙古通辽市",
"86187227", "贵州省安顺市",
"86147941", "广东省广州市",
"861594762", "内蒙古包头市",
"86170826", "湖北省荆门市",
"86180482", "内蒙古兴安盟",
"861330779", "广西北海市",
"861853458", "山西省长治市",
"86159592", "福建省厦门市",
"861534321", "湖南省长沙市",
"861872414", "江苏省徐州市",
"861314900", "广东省阳江市",
"861317284", "广东省揭阳市",
"861306152", "山东省聊城市",
"86156714", "湖北省荆州市",
"861598371", "四川省阿坝藏族羌族自治州",
"861821121", "广东省潮州市",
"861572873", "广东省广州市",
"861860684", "浙江省嘉兴市",
"861877441", "湖南省益阳市",
"861310711", "湖南省长沙市",
"861521898", "广东省汕头市",
"861812316", "四川省内江市",
"861539359", "甘肃省白银市",
"861843282", "河北省保定市",
"861529368", "甘肃省平凉市",
"86138645", "山东省烟台市",
"861575196", "甘肃省张掖市",
"861311771", "广西南宁市",
"8613681", "北京市",
"86159225", "重庆市",
"861707648", "山东省临沂市",
"861335877", "辽宁省丹东市",
"861890251", "广东省茂名市",
"861552862", "四川省雅安市",
"861356762", "浙江省丽水市",
"861471456", "广东省深圳市",
"861454655", "云南省德宏傣族景颇族自治州",
"861569845", "山西省晋城市",
"861550665", "山东省烟台市",
"861840536", "山东省潍坊市",
"861364568", "安徽省阜阳市",
"861529824", "四川省南充市",
"861598345", "四川省广安市",
"861810010", "天津市",
"861530694", "福建省南平市",
"861530951", "宁夏银川市",
"861857216", "湖北省武汉市",
"861339574", "浙江省宁波市",
"861459701", "宁夏吴忠市",
"861768388", "湖北省荆门市",
"861399547", "宁夏银川市",
"861304277", "湖北省咸宁市",
"861301617", "湖南省湘潭市",
"86183295", "陕西省安康市",
"861340754", "江苏省徐州市",
"86152323", "河北省秦皇岛市",
"861771361", "四川省成都市",
"86188712", "湖北省孝感市",
"861308716", "内蒙古通辽市",
"861815461", "广西南宁市",
"861351326", "河北省廊坊市",
"861576727", "广东省江门市",
"861813769", "河南省周口市",
"861818879", "广东省惠州市",
"861325573", "浙江省嘉兴市",
"861352384", "河南省新乡市",
"861569871", "辽宁省营口市",
"86180125", "江苏省盐城市",
"861779057", "四川省阿坝藏族羌族自治州",
"86158726", "湖北省宜昌市",
"861860512", "江苏省苏州市",
"861358702", "浙江省衢州市",
"861811070", "安徽省宿州市",
"861378936", "湖南省衡阳市",
"861370305", "广东省阳江市",
"861308395", "浙江省杭州市",
"861333389", "河南省洛阳市",
"86180700", "江西省南昌市",
"861379410", "广东省汕头市",
"861311745", "湖南省怀化市",
"86155172", "河南省安阳市",
"86187334", "河北省秦皇岛市",
"861807422", "浙江省宁波市",
"86183522", "江苏省徐州市",
"861859638", "山东省临沂市",
"861501853", "广东省深圳市",
"861305506", "湖南省衡阳市",
"861862856", "陕西省咸阳市",
"861529869", "江苏省淮安市",
"861880970", "青海省海北藏族自治州",
"861329460", "山西省忻州市",
"861338692", "福建省莆田市",
"86183540", "山东省菏泽市",
"861770998", "新疆喀什地区",
"861820335", "河北省秦皇岛市",
"861828906", "西藏那曲地区",
"861561918", "陕西省宝鸡市",
"861881910", "广东省东莞市",
"86153516", "江苏省徐州市",
"861560978", "青海省西宁市",
"861522502", "河南省平顶山市",
"861848416", "贵州省安顺市",
"861813724", "河南省濮阳市",
"861800454", "黑龙江省佳木斯市",
"86186635", "山东省聊城市",
"861383890", "河南省焦作市",
"861597561", "广东省广州市",
"861580334", "河北省承德市",
"861376885", "广西柳州市",
"861571931", "甘肃省兰州市",
"861506110", "江苏省常州市",
"86139510", "江苏省南京市",
"861891285", "江苏省南通市",
"861351535", "山东省烟台市",
"861820783", "广西桂林市",
"86177876", "云南省文山壮族苗族自治州",
"861535282", "内蒙古兴安盟",
"861328590", "福建省龙岩市",
"861594890", "吉林省白城市",
"86155948", "陕西省西安市",
"861360313", "河北省张家口市",
"861337501", "福建省南平市",
"861859679", "福建省福州市",
"861321986", "四川省德阳市",
"861500771", "广西南宁市",
"861366358", "山西省吕梁市",
"861780929", "陕西省西安市",
"861373482", "内蒙古兴安盟",
"861454171", "浙江省杭州市",
"861302739", "湖南省邵阳市",
"861815066", "福建省莆田市",
"861459388", "贵州省黔西南布依族苗族自治州",
"861768701", "云南省昭通市",
"861559543", "宁夏吴忠市",
"861361373", "河南省新乡市",
"861558321", "四川省内江市",
"861304364", "湖南省娄底市",
"8618876", "海南省海口市",
"86135963", "吉林省吉林市",
"861560939", "甘肃省陇南市",
"861363815", "贵州省毕节地区",
"861709946", "浙江省嘉兴市",
"861881347", "广东省江门市",
"861324531", "山东省济南市",
"861306430", "四川省南充市",
"86155597", "云南省昆明市",
"861507543", "河北省张家口市",
"861309351", "安徽省淮北市",
"861453450", "安徽省合肥市",
"861307008", "新疆和田地区",
"861587612", "广东省佛山市",
"861524045", "江苏省无锡市",
"861820526", "江苏省泰州市",
"861845822", "浙江省杭州市",
"861700528", "江苏省南京市",
"861339253", "广东省珠海市",
"861893560", "青海省海北藏族自治州",
"86131756", "浙江省温州市",
"861301258", "山东省烟台市",
"86130763", "广东省汕头市",
"861800530", "山东省菏泽市",
"861876236", "江苏省泰州市",
"861322969", "广东省汕尾市",
"861884044", "陕西省榆林市",
"86132674", "广东省东莞市",
"86152284", "四川省绵阳市",
"861533996", "山东省济南市",
"861332958", "黑龙江省鹤岗市",
"861301067", "广东省佛山市",
"861807679", "广西桂林市",
"86186456", "黑龙江省黑河市",
"86134247", "广东省东莞市",
"86150748", "湖南省长沙市",
"861367260", "广东省云浮市",
"861818838", "四川省绵阳市",
"861597447", "湖南省常德市",
"861582000", "山东省济南市",
"861326914", "甘肃省临夏回族自治州",
"861570068", "四川省自贡市",
"861888298", "四川省甘孜藏族自治州",
"861571639", "河南省周口市",
"86138543", "山东省滨州市",
"861365878", "云南省楚雄彝族自治州",
"861846943", "云南省普洱市",
"861530149", "江苏省常州市",
"861372611", "广东省中山市",
"861362679", "浙江省金华市",
"861809588", "新疆阿克苏地区",
"861598980", "广东省汕头市",
"861377644", "江苏省宿迁市",
"861360481", "黑龙江省哈尔滨市",
"86151859", "贵州省铜仁地区",
"861870695", "甘肃省陇南市",
"861372181", "河南省南阳市",
"861537474", "内蒙古乌兰察布市",
"86186263", "江苏省无锡市",
"86158568", "安徽省阜阳市",
"861470793", "江西省上饶市",
"861582577", "浙江省金华市",
"86183144", "云南省昆明市",
"861780621", "山东省日照市",
"861874295", "新疆乌鲁木齐市",
"861376929", "云南省楚雄彝族自治州",
"861346404", "辽宁省沈阳市",
"861312329", "福建省莆田市",
"861309837", "湖北省黄冈市",
"861301546", "山西省长治市",
"861322416", "辽宁省锦州市",
"861560631", "山东省威海市",
"861831960", "广东省惠州市",
"861533750", "福建省莆田市",
"861891217", "江苏省连云港市",
"861539742", "浙江省温州市",
"861855481", "山东省烟台市",
"861598357", "四川省攀枝花市",
"861850878", "云南省楚雄彝族自治州",
"861328478", "内蒙古巴彦淖尔市",
"86181477", "内蒙古鄂尔多斯市",
"861831726", "河南省焦作市",
"861376964", "云南省文山壮族苗族自治州",
"861520018", "河北省邢台市",
"861337295", "辽宁省阜新市",
"86134098", "湖北省黄冈市",
"86153721", "浙江省台州市",
"861527983", "江西省吉安市",
"861335851", "福建省莆田市",
"861572093", "江西省上饶市",
"861311757", "湖南省益阳市",
"861763520", "山西省大同市",
"861312840", "广东省潮州市",
"861890277", "广东省河源市",
"861847663", "广东省深圳市",
"861857588", "广东省佛山市",
"861779045", "四川省雅安市",
"861312364", "贵州省黔南布依族苗族自治州",
"861889989", "广东省茂名市",
"861857904", "江西省南昌市",
"861379729", "湖北省荆州市",
"86185399", "河南省郑州市",
"861890329", "河北省邢台市",
"861360737", "湖南省益阳市",
"861863579", "山西省太原市",
"861520668", "山东省淄博市",
"861539401", "甘肃省甘南藏族自治州",
"86135758", "浙江省台州市",
"86189723", "湖北省荆州市",
"861850839", "四川省广元市",
"861596549", "山东省临沂市",
"861340799", "江西省萍乡市",
"861327044", "江苏省南京市",
"8618478", "湖南省长沙市",
"86135181", "四川省成都市",
"861840988", "新疆昌吉回族自治州",
"861502937", "陕西省宝鸡市",
"861820095", "广东省梅州市",
"861847013", "江西省上饶市",
"861537662", "山东省烟台市",
"861531237", "江苏省泰州市",
"861835976", "福建省福州市",
"861397279", "湖北省黄石市",
"861528689", "河南省驻马店市",
"861314778", "吉林省辽源市",
"86136353", "重庆市",
"861572717", "湖北省宜昌市",
"861563643", "黑龙江省大兴安岭地区",
"861376817", "广西钦州市",
"861398591", "贵州省六盘水市",
"861331382", "福建省泉州市",
"861850680", "浙江省舟山市",
"861534259", "湖北省鄂州市",
"861869384", "甘肃省兰州市",
"861362422", "辽宁省鞍山市",
"86150119", "广东省广州市",
"861890840", "湖南省岳阳市",
"861345897", "四川省德阳市",
"861556530", "河南省许昌市",
"86136200", "广东省东莞市",
"861354549", "湖北省黄石市",
"861890364", "黑龙江省佳木斯市",
"861362638", "山东省淄博市",
"861828214", "四川省巴中市",
"861886789", "浙江省宁波市",
"861476263", "江苏省宿迁市",
"861571678", "河南省驻马店市",
"861538048", "江苏省常州市",
"861331448", "贵州省黔南布依族苗族自治州",
"861519940", "新疆阿克苏地区",
"861359856", "河南省信阳市",
"861313473", "内蒙古乌海市",
"861787575", "广东省佛山市",
"861597833", "河南省三门峡市",
"861599493", "广东省汕头市",
"861570618", "江苏省无锡市",
"861800499", "辽宁省辽阳市",
"861881355", "广东省清远市",
"861372061", "陕西省西安市",
"861365680", "浙江省舟山市",
"861536942", "河北省衡水市",
"861809904", "新疆石河子市",
"861767703", "广西桂林市",
"861318146", "山东省济宁市",
"861501435", "广东省汕尾市",
"861308035", "山西省长治市",
"861345051", "广东省阳江市",
"861803334", "广东省湛江市",
"86138829", "四川省资阳市",
"861844947", "新疆克拉玛依市",
"861848924", "西藏林芝地区",
"861470017", "江苏省徐州市",
"861300175", "山东省聊城市",
"861562488", "内蒙古兴安盟",
"861839486", "甘肃省庆阳市",
"86181910", "陕西省西安市",
"86186587", "浙江省温州市",
"861769624", "山西省运城市",
"86182153", "甘肃省平凉市",
"861875256", "江苏省扬州市",
"86189604", "福建省泉州市",
"861362957", "宁夏银川市",
"861560700", "江西省赣州市",
"861478423", "河南省郑州市",
"86156307", "河北省沧州市",
"861333712", "内蒙古呼和浩特市",
"861787541", "广东省阳江市",
"861564911", "河南省郑州市",
"861589634", "江苏省宿迁市",
"861576109", "贵州省遵义市",
"861850407", "辽宁省营口市",
"861302900", "吉林省长春市",
"861854302", "吉林省通化市",
"861336563", "安徽省宣城市",
"861513427", "辽宁省盘锦市",
"861804795", "内蒙古呼和浩特市",
"861500757", "广东省佛山市",
"861512403", "辽宁省锦州市",
"861771254", "江苏省盐城市",
"861812163", "江苏省连云港市",
"861890828", "四川省广安市",
"861357377", "山东省济南市",
"861341540", "广东省中山市",
"861569496", "河北省唐山市",
"861832498", "安徽省安庆市",
"861300141", "河北省唐山市",
"861315014", "甘肃省张掖市",
"861880708", "江西省南昌市",
"861892435", "广东省东莞市",
"861370524", "江苏省宿迁市",
"861538020", "江苏省镇江市",
"86150355", "山西省长治市",
"861858644", "贵州省铜仁地区",
"861331420", "辽宁省沈阳市",
"861336980", "新疆昌吉回族自治州",
"861510546", "山东省东营市",
"861814025", "四川省内江市",
"861830463", "黑龙江省哈尔滨市",
"861313347", "山西省临汾市",
"861361561", "安徽省淮北市",
"861705017", "山东省青岛市",
"861303696", "广西百色市",
"861365227", "广东省佛山市",
"861780773", "广西桂林市",
"86152617", "江苏省淮安市",
"861315472", "内蒙古包头市",
"861891937", "甘肃省酒泉市",
"861781713", "广东省汕尾市",
"861760505", "福建省厦门市",
"861882607", "广东省广州市",
"86181282", "广东省江门市",
"861856745", "河南省信阳市",
"861539394", "云南省大理白族自治州",
"86137150", "广东省深圳市",
"861390083", "重庆市",
"861361455", "黑龙江省绥化市",
"861866676", "广东省云浮市",
"861593646", "河南省安阳市",
"861365338", "河北省石家庄市",
"861370569", "安徽省合肥市",
"861874050", "陕西省西安市",
"861336357", "山西省临汾市",
"861310435", "吉林省通化市",
"861811890", "江苏省无锡市",
"861334353", "湖北省宜昌市",
"861530977", "青海省海西蒙古族藏族自治州",
"86186533", "山东省淄博市",
"861511175", "青海省海东地区",
"861772774", "广东省东莞市",
"861313910", "青海省海北藏族自治州",
"861880381", "河南省许昌市",
"86189791", "江西省南昌市",
"861339780", "广西南宁市",
"861569091", "内蒙古呼和浩特市",
"861450247", "河北省石家庄市",
"861763548", "山西省吕梁市",
"861452787", "新疆阿克苏地区",
"861878443", "四川省眉山市",
"861536591", "江苏省淮安市",
"861338549", "山东省临沂市",
"861300994", "黑龙江省黑河市",
"861303133", "新疆石河子市",
"861458624", "湖北省黄冈市",
"861300651", "山东省青岛市",
"861365379", "河南省洛阳市",
"861569857", "山西省太原市",
"86187858", "贵州省六盘水市",
"861705667", "天津市",
"861309409", "新疆和田地区",
"861380246", "广东省佛山市",
"861454647", "云南省曲靖市",
"861554048", "内蒙古呼伦贝尔市",
"861565152", "江苏省宿迁市",
"861509800", "湖北省黄冈市",
"861562794", "广东省揭阳市",
"861531917", "陕西省宝鸡市",
"86138070", "江西省南昌市",
"861896721", "浙江省舟山市",
"861802596", "广东省佛山市",
"861398942", "浙江省金华市",
"861357409", "湖南省湘潭市",
"861859945", "新疆乌鲁木齐市",
"861561593", "山东省淄博市",
"861808729", "云南省大理白族自治州",
"861770513", "江苏省连云港市",
"861346391", "河北省邢台市",
"861550087", "宁夏中卫市",
"861557800", "广西南宁市",
"861821887", "广东省湛江市",
"861532415", "河北省唐山市",
"861886801", "浙江省舟山市",
"861453506", "山东省济南市",
"861558259", "山西省晋城市",
"861334567", "安徽省亳州市",
"861504718", "内蒙古锡林郭勒盟",
"861528370", "四川省阿坝藏族羌族自治州",
"861838280", "四川省遂宁市",
"861332135", "甘肃省武威市",
"861458669", "湖南省郴州市",
"861550736", "湖南省常德市",
"861348464", "陕西省延安市",
"861768925", "福建省福州市",
"861570902", "新疆哈密地区",
"861392198", "江苏省苏州市",
"861850379", "河南省洛阳市",
"861454288", "辽宁省盘锦市",
"861369613", "四川省乐山市",
"861771573", "四川省泸州市",
"86152580", "浙江省温州市",
"861898575", "贵州省黔南布依族苗族自治州",
"861550692", "福建省厦门市",
"861514853", "内蒙古锡林郭勒盟",
"861333683", "浙江省湖州市",
"86135281", "广东省中山市",
"86155671", "吉林省长春市",
"861356795", "浙江省湖州市",
"861379980", "福建省宁德市",
"861552895", "四川省宜宾市",
"861306302", "福建省漳州市",
"861805276", "江苏省镇江市",
"861501937", "广东省茂名市",
"861855069", "江苏省连云港市",
"861570777", "广西钦州市",
"861839469", "甘肃省天水市",
"861528411", "四川省广元市",
"861869326", "甘肃省兰州市",
"861504959", "内蒙古鄂尔多斯市",
"861760663", "广东省揭阳市",
"86155409", "内蒙古呼和浩特市",
"861539109", "内蒙古兴安盟",
"861328131", "四川省乐山市",
"861819676", "安徽省马鞍山市",
"861760797", "江西省赣州市",
"861310148", "福建省宁德市",
"861533433", "云南省大理白族自治州",
"86134362", "重庆市",
"861803646", "江苏省常州市",
"861812762", "广东省梅州市",
"861554292", "辽宁省葫芦岛市",
"861778750", "云南省保山市",
"861384874", "内蒙古巴彦淖尔市",
"86157357", "山西省临汾市",
"861886766", "浙江省嘉兴市",
"861509921", "新疆伊犁哈萨克自治州",
"861338704", "江西省吉安市",
"861458571", "山东省济宁市",
"86156822", "四川省宜宾市",
"861572678", "西藏拉萨市",
"861521767", "广东省佛山市",
"861361638", "山东省聊城市",
"86139471", "内蒙古呼和浩特市",
"86136725", "广东省云浮市",
"861512994", "陕西省宝鸡市",
"861332448", "吉林省延边朝鲜族自治州",
"861316063", "广东省潮州市",
"861360069", "浙江省金华市",
"861528666", "贵州省六盘水市",
"861534738", "湖南省娄底市",
"861568022", "四川省自贡市",
"861557921", "江西省九江市",
"861367052", "广东省汕头市",
"861361422", "辽宁省鞍山市",
"861375470", "山东省临沂市",
"861358694", "浙江省宁波市",
"861342528", "广东省肇庆市",
"86156840", "山东省烟台市",
"861839424", "甘肃省定西市",
"86181065", "浙江省杭州市",
"86136100", "广东省广州市",
"861535640", "浙江省温州市",
"8623", "重庆市",
"861783981", "河南省三门峡市",
"86139609", "福建省福州市",
"861317550", "浙江省金华市",
"861453940", "广东省阳江市",
"861781682", "浙江省温州市",
"86186816", "四川省绵阳市",
"861363710", "安徽省马鞍山市",
"86170047", "内蒙古呼和浩特市",
"861530702", "江西省九江市",
"861804070", "新疆阿克苏地区",
"861707843", "云南省保山市",
"861786938", "云南省怒江傈僳族自治州",
"861781112", "宁夏石嘴山市",
"861521693", "广东省河源市",
"861533270", "内蒙古呼伦贝尔市",
"861882355", "广东省揭阳市",
"861523509", "山西省朔州市",
"861304745", "山东省聊城市",
"861879362", "甘肃省武威市",
"861555284", "山东省泰安市",
"861871892", "广东省深圳市",
"861525542", "安徽省淮南市",
"861565125", "江苏省连云港市",
"861388400", "甘肃省临夏回族自治州",
"861373912", "江苏省连云港市",
"861709897", "广东省中山市",
"861302821", "辽宁省阜新市",
"861889966", "新疆昌吉回族自治州",
"861521136", "湖南省衡阳市",
"861892148", "江苏省南通市",
"861341906", "四川省达州市",
"86186808", "重庆市",
"861320476", "内蒙古赤峰市",
"861361679", "浙江省金华市",
"861572639", "山东省青岛市",
"861598729", "云南省玉溪市",
"861314258", "江苏省扬州市",
"86158371", "河南省郑州市",
"861898992", "西藏日喀则地区",
"861572880", "广东省汕尾市",
"861359995", "福建省福州市",
"86155991", "贵州省贵阳市",
"861310658", "广东省佛山市",
"861360619", "江苏省无锡市",
"861370671", "浙江省杭州市",
"861321416", "辽宁省锦州市",
"86178549", "山东省临沂市",
"861314067", "河南省驻马店市",
"861867258", "湖北省孝感市",
"86183244", "浙江省杭州市",
"861303732", "湖南省湘潭市",
"861800944", "甘肃省兰州市",
"86150791", "江西省南昌市",
"861522078", "广东省江门市",
"861533847", "广东省茂名市",
"861893413", "广东省东莞市",
"861354665", "山西省长治市",
"861569728", "湖北省武汉市",
"861768952", "西藏日喀则地区",
"861598764", "云南省大理白族自治州",
"861304623", "广东省湛江市",
"861843628", "河南省商丘市",
"861855189", "江苏省连云港市",
"861311840", "四川省资阳市",
"86139265", "广东省深圳市",
"86157773", "广西桂林市",
"861477707", "广西钦州市",
"861330321", "河北省石家庄市",
"861369782", "山东省东营市",
"861510900", "新疆乌鲁木齐市",
"861889720", "青海省西宁市",
"861855619", "江苏省南京市",
"861300403", "安徽省阜阳市",
"861378493", "河北省邢台市",
"861853920", "河南省鹤壁市",
"861309101", "河北省石家庄市",
"861847505", "广东省梅州市",
"861700934", "甘肃省兰州市",
"861863416", "河北省唐山市",
"861458686", "湖南省湘潭市",
"861315597", "江西省萍乡市",
"861311828", "四川省南充市",
"861576006", "四川省宜宾市",
"861880560", "安徽省合肥市",
"861825249", "江苏省南通市",
"861768207", "安徽省阜阳市",
"861812890", "广东省韶关市",
"861845270", "江苏省南通市",
"861458116", "安徽省阜阳市",
"861501217", "云南省文山壮族苗族自治州",
"861889748", "湖南省怀化市",
"86158138", "广东省深圳市",
"861771774", "河北省唐山市",
"861588437", "四川省乐山市",
"861339929", "陕西省铜川市",
"861569740", "湖南省岳阳市",
"861887018", "江西省鹰潭市",
"861770714", "湖北省黄石市",
"861532917", "贵州省毕节地区",
"861388687", "湖北省随州市",
"861823679", "河南省郑州市",
"861560568", "安徽省阜阳市",
"86152348", "山西省吕梁市",
"861511882", "广东省深圳市",
"861334951", "黑龙江省哈尔滨市",
"861558738", "山东省烟台市",
"861835047", "福建省龙岩市",
"861859447", "福建省泉州市",
"861334694", "河南省郑州市",
"861773020", "安徽省合肥市",
"86139535", "山东省烟台市",
"861531415", "山东省聊城市",
"86138694", "山东省枣庄市",
"861822887", "四川省巴中市",
"86153809", "江苏省南京市",
"86133149", "福建省福州市",
"861598605", "广东省佛山市",
"861339964", "安徽省六安市",
"861471946", "甘肃省武威市",
"861801596", "江苏省镇江市",
"861538292", "广东省汕头市",
"861325580", "浙江省舟山市",
"861364978", "青海省海东地区",
"861885145", "江苏省宿迁市",
"861539143", "云南省曲靖市",
"861322538", "山东省泰安市",
"861388248", "四川省阿坝藏族羌族自治州",
"861786218", "山东省菏泽市",
"861780253", "江苏省泰州市",
"861346993", "湖北省黄冈市",
"8617792", "陕西省西安市",
"861530475", "内蒙古通辽市",
"861479799", "江西省萍乡市",
"86517", "江苏省淮安市",
"861525144", "江苏省无锡市",
"86187360", "河南省郑州市",
"861576742", "广东省深圳市",
"861370645", "山东省烟台市",
"861452178", "吉林省吉林市",
"861399522", "宁夏石嘴山市",
"861325963", "宁夏吴忠市",
"861381523", "江苏省南通市",
"861364939", "甘肃省陇南市",
"861339817", "四川省成都市",
"86147998", "新疆喀什地区",
"861301900", "黑龙江省哈尔滨市",
"861300449", "江苏省盐城市",
"861518548", "贵州省黔南布依族苗族自治州",
"861318003", "河北省邯郸市",
"861520531", "山东省济南市",
"861452810", "四川省成都市",
"861335682", "山东省泰安市",
"861511223", "广东省广州市",
"861370586", "浙江省台州市",
"86182253", "重庆市",
"861361957", "宁夏银川市",
"86155556", "安徽省安庆市",
"861573387", "河北省衡水市",
"86156646", "陕西省西安市",
"861500364", "青海省海东地区",
"861335112", "黑龙江省齐齐哈尔市",
"861535432", "河北省保定市",
"861593334", "河北省邢台市",
"861576221", "山东省烟台市",
"861845847", "浙江省温州市",
"861390890", "西藏拉萨市",
"861452139", "河北省邢台市",
"861332420", "辽宁省大连市",
"861891435", "江苏省南通市",
"86186610", "江苏省无锡市",
"861459427", "云南省楚雄彝族自治州",
"86186497", "福建省福州市",
"861532829", "四川省巴中市",
"861365905", "四川省南充市",
"861590499", "辽宁省辽阳市",
"861336729", "湖北省随州市",
"861780574", "浙江省宁波市",
"86155923", "陕西省渭南市",
"861809493", "新疆塔城地区",
"861886948", "云南省红河哈尼族彝族自治州",
"861377876", "四川省雅安市",
"861599904", "新疆和田地区",
"861322579", "安徽省黄山市",
"861871926", "广东省广州市",
"861387212", "湖北省黄石市",
"861308362", "河南省洛阳市",
"861370723", "湖北省黄石市",
"861898541", "贵州省贵阳市",
"861881322", "广东省广州市",
"86138701", "江西省鹰潭市",
"861500329", "河北省邢台市",
"861501658", "广东省云浮市",
"86150723", "湖北省武汉市",
"861362561", "安徽省淮北市",
"861898826", "云南省红河哈尼族彝族自治州",
"861775924", "福建省福州市",
"86135394", "广东省广州市",
"861585297", "江苏省泰州市",
"86138974", "青海省西宁市",
"861826111", "江苏省宿迁市",
"861823638", "河南省商丘市",
"861593059", "河北省秦皇岛市",
"861850905", "新疆阿勒泰地区",
"861858336", "四川省成都市",
"861506673", "山东省泰安市",
"861458545", "河南省三门峡市",
"861827094", "江西省抚州市",
"861370155", "江苏省苏州市",
"861872984", "陕西省渭南市",
"861820770", "广西防城港市",
"861767102", "湖北省武汉市",
"86181182", "江苏省扬州市",
"861362455", "黑龙江省绥化市",
"861336764", "广西梧州市",
"86137250", "广东省惠州市",
"86136787", "云南省昆明市",
"861387438", "湖南省永州市",
"861381368", "江苏省常州市",
"861329967", "广西玉林市",
"861846981", "云南省玉溪市",
"861867110", "湖北省鄂州市",
"861356956", "河南省平顶山市",
"861880477", "内蒙古鄂尔多斯市",
"861874976", "河南省焦作市",
"861831541", "山东省济南市",
"861311857", "贵州省毕节地区",
"861526661", "山东省潍坊市",
"861372143", "河南省郑州市",
"861572964", "四川省内江市",
"861808328", "贵州省黔西南布依族苗族自治州",
"861322053", "山东省临沂市",
"861360443", "吉林省长春市",
"861535147", "四川省遂宁市",
"861860904", "新疆喀什地区",
"861576466", "黑龙江省大庆市",
"861771585", "江苏省扬州市",
"861831826", "广东省肇庆市",
"861311091", "福建省南平市",
"861357737", "云南省曲靖市",
"861850778", "广西河池市",
"861323468", "黑龙江省鹤岗市",
"86181487", "广东省广州市",
"861869499", "江苏省南京市",
"861867839", "山东省济南市",
"861808237", "江苏省连云港市",
"861533850", "贵州省贵阳市",
"861881417", "广东省河源市",
"861855443", "山东省济南市",
"861380654", "浙江省温州市",
"861585045", "江苏省镇江市",
"861459312", "四川省达州市",
"861810549", "山东省临沂市",
"861839043", "湖南省益阳市",
"861767348", "湖南省岳阳市",
"861380991", "新疆乌鲁木齐市",
"861373418", "山西省朔州市",
"861309737", "江西省上饶市",
"861571780", "湖北省鄂州市",
"861882915", "陕西省安康市",
"861324763", "广东省深圳市",
"86183819", "四川省达州市",
"861572929", "河南省周口市",
"86139956", "湖北省武汉市",
"861780333", "河北省秦皇岛市",
"861337976", "新疆巴音郭楞蒙古自治州",
"861345013", "广东省茂名市",
"861379917", "福建省三明市",
"861535218", "甘肃省嘉峪关市",
"861875154", "江苏省无锡市",
"861825044", "福建省泉州市",
"861773260", "河北省廊坊市",
"86139523", "江苏省淮安市",
"861319593", "甘肃省武威市",
"861576611", "广东省梅州市",
"861365778", "广西河池市",
"861566679", "山东省青岛市",
"86186648", "广东省广州市",
"861522914", "陕西省商洛市",
"861587247", "湖北省宜昌市",
"861301721", "湖南省岳阳市",
"861893649", "江苏省扬州市",
"861475624", "河北省保定市",
"86155935", "甘肃省武威市",
"861598415", "四川省自贡市",
"86186577", "浙江省温州市",
"861366488", "内蒙古呼和浩特市",
"86139849", "贵州省遵义市",
"861508583", "贵州省铜仁地区",
"861780785", "广西玉林市",
"861326693", "广东省东莞市",
"861332942", "黑龙江省齐齐哈尔市",
"861576061", "四川省广元市",
"861886630", "山东省威海市",
"861363431", "吉林省长春市",
"861317547", "浙江省台州市",
"861309166", "黑龙江省大庆市",
"861589293", "四川省泸州市",
"861372653", "广东省汕头市",
"861364705", "江西省宜春市",
"861588142", "四川省绵阳市",
"861591292", "云南省楚雄彝族自治州",
"861318463", "江西省上饶市",
"861899568", "湖北省襄樊市",
"861326767", "广东省江门市",
"861566638", "山东省东营市",
"861365739", "湖南省邵阳市",
"861522867", "四川省遂宁市",
"861582998", "陕西省咸阳市",
"861508960", "广东省茂名市",
"86156600", "河南省南阳市",
"861459458", "陕西省汉中市",
"861561982", "陕西省汉中市",
"861390075", "海南省海口市",
"86153950", "安徽省合肥市",
"861563681", "黑龙江省哈尔滨市",
"861555522", "安徽省宣城市",
"86150844", "重庆市",
"86187341", "山西省太原市",
"861566422", "河南省平顶山市",
"861373352", "湖北省孝感市",
"861352530", "河南省驻马店市",
"861786628", "湖北省孝感市",
"861890740", "湖南省岳阳市",
"861379340", "山东省日照市",
"861856871", "河南省新乡市",
"861580963", "宁夏吴忠市",
"861502599", "甘肃省金昌市",
"861805497", "福建省漳州市",
"861551316", "山西省忻州市",
"861829952", "新疆昌吉回族自治州",
"861572817", "广东省东莞市",
"861380144", "江苏省扬州市",
"861508726", "云南省大理白族自治州",
"861807132", "湖北省宜昌市",
"861860588", "浙江省杭州市",
"86182346", "山西省晋城市",
"861309481", "浙江省杭州市",
"861453380", "内蒙古兴安盟",
"861580580", "浙江省舟山市",
"861880309", "河北省邢台市",
"861306937", "河南省新乡市",
"861768312", "四川省攀枝花市",
"861707544", "福建省莆田市",
"86152310", "河北省邯郸市",
"861366342", "山西省大同市",
"86150735", "湖南省郴州市",
"861527194", "湖北省武汉市",
"861579420", "江苏省南通市",
"86135171", "湖北省恩施土家族苗族自治州",
"861867878", "山东省济南市",
"86188989", "海南省海口市",
"86188743", "湖南省湘西土家族苗族自治州",
"8613594", "重庆市",
"861850739", "湖南省邵阳市",
"861777121", "湖北省孝感市",
"861335813", "江苏省扬州市",
"861550376", "河南省信阳市",
"861893603", "江苏省南京市",
"861532357", "广东省肇庆市",
"861313485", "内蒙古鄂尔多斯市",
"861787583", "广东省湛江市",
"861510721", "湖北省荆州市",
"861339678", "浙江省丽水市",
"861503451", "山西省长治市",
"861889901", "新疆巴音郭楞蒙古自治州",
"861530598", "福建省三明市",
"861590535", "山东省烟台市",
"861334311", "河北省石家庄市",
"86181272", "广东省清远市",
"861855229", "江苏省南通市",
"861300183", "河北省廊坊市",
"861892302", "广东省梅州市",
"861573947", "新疆巴音郭楞蒙古自治州",
"861380542", "山东省青岛市",
"86147934", "甘肃省庆阳市",
"861898784", "云南省楚雄彝族自治州",
"861340398", "河南省三门峡市",
"861532980", "贵州省贵阳市",
"861859534", "河南省周口市",
"861708870", "广东省江门市",
"86180614", "江苏省南京市",
"86180209", "福建省南平市",
"861868122", "四川省成都市",
"861364629", "江苏省南通市",
"861843147", "河北省沧州市",
"861453638", "江苏省无锡市",
"861890728", "湖北省十堰市",
"86145300", "北京市",
"861457094", "江苏省连云港市",
"861770551", "安徽省合肥市",
"861816944", "湖南省衡阳市",
"861804895", "四川省南充市",
"861500857", "贵州省毕节地区",
"861700019", "广东省深圳市",
"861831992", "广东省惠州市",
"861595995", "福建省泉州市",
"861360409", "辽宁省大连市",
"861390041", "辽宁省辽阳市",
"861361940", "云南省德宏傣族景颇族自治州",
"861812446", "广东省肇庆市",
"861369994", "新疆阿勒泰地区",
"861833954", "河南省新乡市",
"86139591", "福建省福州市",
"861369651", "安徽省合肥市",
"861567087", "河南省焦作市",
"861333812", "江苏省扬州市",
"861770465", "福建省泉州市",
"861535938", "福建省泉州市",
"861589986", "广东省深圳市",
"861764537", "黑龙江省鸡西市",
"861564953", "河南省安阳市",
"861590326", "河北省廊坊市",
"861364472", "内蒙古包头市",
"861700669", "浙江省杭州市",
"861896546", "福建省漳州市",
"861550836", "四川省德阳市",
"861360377", "河南省南阳市",
"861318244", "江苏省泰州市",
"861586523", "山东省滨州市",
"86156861", "陕西省咸阳市",
"861310302", "河北省保定市",
"861880343", "山西省阳泉市",
"861314407", "广东省揭阳市",
"861523844", "河南省三门峡市",
"861371742", "广东省东莞市",
"861504818", "内蒙古乌海市",
"86187932", "甘肃省定西市",
"861535979", "福建省莆田市",
"861557700", "广西柳州市",
"861336415", "辽宁省丹东市",
"86158194", "广东省珠海市",
"861883845", "河南省商丘市",
"861310627", "浙江省丽水市",
"86138080", "四川省成都市",
"861302098", "浙江省金华市",
"861361317", "河北省沧州市",
"861537690", "山东省青岛市",
"861509700", "甘肃省金昌市",
"86180665", "陕西省西安市",
"861366794", "江西省抚州市",
"861354198", "四川省广安市",
"861853442", "山西省晋中市",
"861350025", "广东省佛山市",
"86151004", "河北省邯郸市",
"861859450", "福建省宁德市",
"861817014", "江西省赣州市",
"861347750", "湖北省武汉市",
"861569757", "广东省佛山市",
"86132392", "陕西省榆林市",
"861812041", "湖北省武汉市",
"861339639", "山东省青岛市",
"861390446", "吉林省延边朝鲜族自治州",
"861510242", "辽宁省丹东市",
"861452887", "云南省迪庆藏族自治州",
"861766027", "山东省淄博市",
"861312728", "山东省泰安市",
"861332591", "浙江省杭州市",
"861339880", "云南省昆明市",
"86138638", "山东省烟台市",
"861819744", "青海省黄南藏族自治州",
"861772874", "广东省云浮市",
"861781751", "广东省韶关市",
"86183967", "山东省临沂市",
"861803774", "河南省商丘市",
"861377256", "陕西省咸阳市",
"86134321", "广东省中山市",
"861306217", "福建省宁德市",
"861811790", "四川省成都市",
"86145847", "山东省青岛市",
"861331942", "江西省南昌市",
"861573471", "内蒙古呼和浩特市",
"861500728", "湖北省十堰市",
"861890091", "辽宁省沈阳市",
"861357619", "江西省宜春市",
"861850258", "江苏省常州市",
"861363810", "贵州省铜仁地区",
"861771334", "黑龙江省佳木斯市",
"861815434", "湖北省孝感市",
"86186317", "河北省沧州市",
"861856213", "山东省德州市",
"861525246", "江苏省南京市",
"861306435", "四川省内江市",
"86159614", "江苏省常州市",
"861372394", "山东省烟台市",
"861506115", "江苏省盐城市",
"86152851", "贵州省贵阳市",
"861854658", "黑龙江省大庆市",
"861335271", "广东省揭阳市",
"861842026", "广东省梅州市",
"861519957", "新疆石河子市",
"861328595", "福建省泉州市",
"861326354", "黑龙江省哈尔滨市",
"861534838", "湖南省娄底市",
"86130619", "上海市",
"861343197", "广东省清远市",
"861891280", "江苏省镇江市",
"861351530", "山东省菏泽市",
"861475545", "安徽省淮南市",
"861536448", "湖南省永州市",
"861890857", "贵州省毕节地区",
"861594895", "吉林省辽源市",
"861316651", "河北省秦皇岛市",
"861575779", "浙江省温州市",
"861376678", "黑龙江省大庆市",
"861316994", "广东省深圳市",
"861581998", "广东省中山市",
"861454128", "河北省衡水市",
"861777209", "广西梧州市",
"861800535", "山东省烟台市",
"86182607", "江苏省徐州市",
"861840482", "内蒙古乌兰察布市",
"861502627", "新疆阿克苏地区",
"861880592", "福建省厦门市",
"861700571", "浙江省杭州市",
"861571817", "广东省珠海市",
"861536382", "广东省佛山市",
"861893451", "江苏省南通市",
"861826272", "江苏省淮安市",
"861367265", "广东省珠海市",
"861453455", "安徽省合肥市",
"861309619", "四川省达州市",
"861365067", "广东省河源市",
"86188236", "广东省惠州市",
"861570877", "云南省玉溪市",
"861524040", "江苏省苏州市",
"861830003", "广东省河源市",
"861819509", "宁夏银川市",
"861309189", "黑龙江省哈尔滨市",
"861458214", "安徽省铜陵市",
"86152570", "浙江省衢州市",
"86135271", "广东省中山市",
"861514753", "内蒙古鄂尔多斯市",
"861893565", "青海省果洛藏族自治州",
"861831884", "广东省珠海市",
"861869191", "陕西省铜川市",
"861333151", "吉林省延边朝鲜族自治州",
"861365617", "江苏省无锡市",
"861309069", "内蒙古呼和浩特市",
"861832541", "山东省济南市",
"861330633", "山东省日照市",
"861571964", "甘肃省庆阳市",
"861518199", "四川省泸州市",
"861327423", "辽宁省抚顺市",
"861528453", "云南省昭通市",
"86157783", "广西南宁市",
"86183632", "山东省枣庄市",
"861319794", "江西省抚州市",
"86159665", "山东省烟台市",
"861477807", "广东省湛江市",
"861370300", "广东省珠海市",
"861308390", "浙江省湖州市",
"861311740", "湖南省岳阳市",
"861379415", "广东省中山市",
"861598340", "四川省凉山彝族自治州",
"861810015", "浙江省温州市",
"861304331", "吉林省长春市",
"861353492", "广东省汕头市",
"861530483", "黑龙江省牡丹江市",
"861554596", "黑龙江省哈尔滨市",
"861334233", "辽宁省辽阳市",
"861533747", "湖北省荆门市",
"861890496", "辽宁省锦州市",
"861569828", "山东省临沂市",
"861846383", "山东省德州市",
"86186525", "江苏省扬州市",
"861512183", "宁夏吴忠市",
"861571929", "陕西省西安市",
"861358913", "山东省济南市",
"861889349", "甘肃省兰州市",
"861576489", "内蒙古乌兰察布市",
"861894818", "广东省深圳市",
"861309024", "辽宁省沈阳市",
"86187667", "山东省东营市",
"861800326", "河北省廊坊市",
"861776527", "广东省广州市",
"861361506", "福建省漳州市",
"861709663", "浙江省嘉兴市",
"86135465", "山西省临汾市",
"861383895", "河南省南阳市",
"86158381", "河南省郑州市",
"861802048", "江苏省镇江市",
"861806198", "江苏省泰州市",
"861760456", "黑龙江省黑河市",
"861329551", "安徽省合肥市",
"861520974", "青海省海南藏族自治州",
"861506546", "山东省东营市",
"861780931", "甘肃省兰州市",
"861396596", "安徽省滁州市",
"861558339", "四川省德阳市",
"861506821", "浙江省嘉兴市",
"861350052", "安徽省芜湖市",
"861534879", "云南省普洱市",
"861880975", "青海省果洛藏族自治州",
"861380393", "河南省濮阳市",
"861390862", "湖北省武汉市",
"861820330", "河北省沧州市",
"861329465", "山西省吕梁市",
"861856933", "湖南省娄底市",
"861505279", "江苏省泰州市",
"861576842", "广东省茂名市",
"861370282", "广东省佛山市",
"861862468", "辽宁省阜新市",
"861539466", "江苏省盐城市",
"861478044", "四川省成都市",
"86896", "西藏那曲地区\、嘉黎县\、聂荣县\、申扎县\、双湖\、班戈县\、尼玛县",
"861389502", "宁夏石嘴山市",
"861526538", "山东省泰安市",
"86391", "河南省焦作市",
"861398448", "贵州省六盘水市",
"861519679", "四川省南充市",
"861705080", "广东省广州市",
"861590384", "河南省商丘市",
"861310599", "福建省南平市",
"861880941", "甘肃省甘南藏族自治州",
"861878619", "贵州省遵义市",
"861503649", "河南省三门峡市",
"861301098", "黑龙江省哈尔滨市",
"861362317", "河北省沧州市",
"86133814", "北京市",
"861768635", "山东省聊城市",
"861822787", "四川省乐山市",
"861811041", "安徽省合肥市",
"861539611", "福建省福州市",
"861305833", "广东省佛山市",
"861397358", "湖南省邵阳市",
"861598328", "四川省内江市",
"861867905", "江西省南昌市",
"861369449", "吉林省四平市",
"861315939", "福建省三明市",
"861569364", "甘肃省张掖市",
"861539181", "安徽省安庆市",
"861550660", "山东省菏泽市",
"861569840", "山西省太原市",
"861454650", "云南省昆明市",
"861824288", "辽宁省阜新市",
"861534378", "河南省开封市",
"861889848", "广东省中山市",
"861314905", "广东省韶关市",
"861450250", "河北省石家庄市",
"861311728", "湖北省宜昌市",
"861331591", "河北省邢台市",
"861876043", "福建省福州市",
"861860493", "辽宁省沈阳市",
"86181597", "福建省漳州市",
"861534339", "湖南省邵阳市",
"861476537", "内蒙古呼和浩特市",
"861524028", "江苏省镇江市",
"861770967", "安徽省阜阳市",
"861888806", "江苏省镇江市",
"86157650", "黑龙江省齐齐哈尔市",
"861700545", "山东省威海市",
"861336864", "贵州省黔南布依族苗族自治州",
"861373325", "河北省唐山市",
"861840849", "宁夏吴忠市",
"861358470", "江苏省南通市",
"861336340", "山西省大同市",
"861315978", "吉林省四平市",
"861821139", "广东省韶关市",
"86138984", "辽宁省大连市",
"861855101", "江苏省连云港市",
"86132068", "黑龙江省大庆市",
"861898726", "云南省昆明市",
"861595497", "山东省烟台市",
"861539061", "甘肃省临夏回族自治州",
"861566561", "安徽省淮北市",
"861370823", "四川省成都市",
"86132428", "广东省广州市",
"861822431", "四川省内江市",
"861323990", "新疆克拉玛依市",
"861334913", "安徽省宣城市",
"861889303", "甘肃省白银市",
"861891302", "江苏省南京市",
"861821810", "广东省韶关市",
"861347433", "陕西省汉中市",
"86133865", "浙江省台州市",
"86189735", "湖南省郴州市",
"861319342", "河南省商丘市",
"86132117", "云南省昆明市",
"861838148", "四川省达州市",
"861769934", "新疆乌鲁木齐市",
"861840320", "河北省邯郸市",
"86188566", "安徽省池州市",
"861454140", "吉林省长春市",
"861319488", "四川省成都市",
"861705160", "江西省南昌市",
"861871860", "广东省揭阳市",
"861810704", "江西省抚州市",
"861898583", "贵州省黔东南苗族侗族自治州",
"861390790", "江西省新余市",
"861536420", "湖南省长沙市",
"861476023", "福建省漳州市",
"86184457", "黑龙江省哈尔滨市",
"86157737", "湖南省益阳市",
"86151900", "江苏省苏州市",
"86137016", "上海市",
"861500740", "湖南省湘西土家族苗族自治州",
"861569277", "贵州省毕节地区",
"861502280", "新疆塔城地区",
"861555616", "安徽省亳州市",
"861832992", "陕西省西安市",
"861826643", "山东省淄博市",
"861817597", "湖南省长沙市",
"861811446", "江苏省南京市",
"861322606", "广东省中山市",
"861452710", "湖北省襄樊市",
"861313987", "新疆乌鲁木齐市",
"861509568", "甘肃省酒泉市",
"861399406", "山西省忻州市",
"861346614", "云南省保山市",
"861584699", "黑龙江省佳木斯市",
"861345505", "山东省枣庄市",
"86158145", "广东省广州市",
"86158702", "贵州省黔东南苗族侗族自治州",
"861576758", "广东省湛江市",
"861337566", "山东省枣庄市",
"861452464", "黑龙江省七台河市",
"861333177", "吉林省长春市",
"861323756", "江西省新余市",
"86180133", "江苏省南京市",
"861551762", "河南省驻马店市",
"861342669", "江西省萍乡市",
"861808487", "四川省绵阳市",
"861509805", "湖北省孝感市",
"86180746", "湖南省永州市",
"861811895", "江苏省镇江市",
"861310430", "吉林省长春市",
"861880159", "江苏省南京市",
"861511170", "青海省海北藏族自治州",
"861899939", "新疆伊犁哈萨克自治州",
"861387288", "湖北省随州市",
"86150710", "湖北省武汉市",
"861500933", "甘肃省平凉市",
"86152335", "河北省秦皇岛市",
"861571773", "广西桂林市",
"861779028", "四川省成都市",
"861362733", "湖南省株洲市",
"861339785", "广西贵港市",
"861313915", "青海省果洛藏族自治州",
"861301379", "江苏省苏州市",
"861893309", "广东省江门市",
"86151399", "河南省洛阳市",
"861517904", "江西省上饶市",
"861534099", "山西省运城市",
"8614728", "四川省成都市",
"861459137", "广西贵港市",
"861572574", "山东省淄博市",
"86155910", "陕西省咸阳市",
"861361534", "山东省德州市",
"861535122", "四川省成都市",
"861803299", "河北省邢台市",
"861348036", "广东省云浮市",
"861452429", "辽宁省葫芦岛市",
"861332130", "甘肃省平凉市",
"861768920", "福建省厦门市",
"861329577", "浙江省温州市",
"86139548", "山东省泰安市",
"861505593", "安徽省淮南市",
"861859940", "新疆昌吉回族自治州",
"861835262", "江苏省泰州市",
"861332819", "江苏省常州市",
"861520763", "广东省清远市",
"861348787", "湖南省郴州市",
"86134776", "湖北省黄冈市",
"861532410", "河北省邯郸市",
"861310273", "河北省沧州市",
"86183506", "福建省漳州市",
"861584991", "内蒙古锡林郭勒盟",
"86185946", "福建省福州市",
"861335188", "黑龙江省哈尔滨市",
"861557805", "广西百色市",
"861341116", "广东省广州市",
"86159563", "安徽省宣城市",
"861390956", "宁夏石嘴山市",
"861364323", "河北省张家口市",
"861373102", "河北省邯郸市",
"861573457", "黑龙江省大兴安岭地区",
"861366327", "河北省沧州市",
"861335068", "四川省自贡市",
"861815406", "安徽省安庆市",
"861863346", "河北省石家庄市",
"86183518", "江苏省南京市",
"861808731", "云南省红河哈尼族彝族自治州",
"861341545", "广东省佛山市",
"861331425", "辽宁省鞍山市",
"861393991", "河南省洛阳市",
"861892430", "广东省广州市",
"861472797", "陕西省宝鸡市",
"861538025", "江苏省连云港市",
"86183561", "安徽省淮北市",
"861806010", "福建省泉州市",
"861572253", "江苏省连云港市",
"861336985", "新疆巴音郭楞蒙古自治州",
"861815226", "甘肃省庆阳市",
"861580573", "浙江省嘉兴市",
"86178795", "江西省宜春市",
"86185859", "贵州省铜仁地区",
"861472663", "四川省凉山彝族自治州",
"86139677", "浙江省温州市",
"861895488", "山东省泰安市",
"861880649", "山东省滨州市",
"861778722", "云南省大理白族自治州",
"861335257", "黑龙江省大兴安岭地区",
"861560705", "江西省宜春市",
"861599512", "江苏省扬州市",
"861809626", "四川省达州市",
"861302905", "吉林省松原市",
"861890871", "云南省昆明市",
"861700363", "广东省深圳市",
"861587883", "广西河池市",
"861859317", "云南省曲靖市",
"861760500", "福建省福州市",
"861587741", "陕西省延安市",
"861361450", "黑龙江省哈尔滨市",
"861344490", "陕西省西安市",
"861564837", "内蒙古呼伦贝尔市",
"861539919", "陕西省铜川市",
"861856740", "河南省安阳市",
"861864522", "黑龙江省齐齐哈尔市",
"861566447", "山东省泰安市",
"861338836", "四川省内江市",
"861301407", "安徽省阜阳市",
"861893477", "广西桂林市",
"861570097", "新疆石河子市",
"861874055", "陕西省安康市",
"861888267", "四川省广安市",
"861315631", "山东省威海市",
"861768137", "安徽省阜阳市",
"861320791", "江西省南昌市",
"861339333", "河北省张家口市",
"861814020", "四川省成都市",
"861301338", "云南省丽江市",
"861570851", "贵州省贵阳市",
"86155477", "内蒙古鄂尔多斯市",
"86184586", "浙江省宁波市",
"86187285", "四川省遂宁市",
"861816454", "浙江省绍兴市",
"861384963", "河南省驻马店市",
"861899978", "新疆阿勒泰地区",
"861588127", "四川省攀枝花市",
"861332927", "安徽省亳州市",
"861333903", "安徽省芜湖市",
"861317522", "浙江省湖州市",
"861518552", "贵州省黔南布依族苗族自治州",
"861383446", "山西省运城市",
"861564264", "辽宁省葫芦岛市",
"861814048", "四川省资阳市",
"861539278", "湖北省襄樊市",
"861881987", "广东省茂名市",
"861872604", "安徽省马鞍山市",
"861850685", "浙江省杭州市",
"861821281", "贵州省毕节地区",
"86130792", "辽宁省沈阳市",
"861506067", "福建省福州市",
"861369718", "湖北省恩施土家族苗族自治州",
"861319759", "广西北海市",
"861856728", "河南省南阳市",
"861530311", "河北省石家庄市",
"861351499", "安徽省合肥市",
"861321346", "河南省驻马店市",
"861452243", "浙江省宁波市",
"861560664", "浙江省温州市",
"861453447", "辽宁省葫芦岛市",
"861334598", "浙江省宁波市",
"861380033", "河北省秦皇岛市",
"861820090", "广东省韶关市",
"861314721", "湖北省荆州市",
"861551890", "河南省信阳市",
"861532973", "贵州省安顺市",
"861306711", "福建省福州市",
"861599684", "江苏省镇江市",
"861510379", "河南省洛阳市",
"861763336", "河北省秦皇岛市",
"861522484", "河南省平顶山市",
"861564229", "辽宁省朝阳市",
"861810736", "湖南省常德市",
"861893343", "广东省中山市",
"861881350", "广东省惠州市",
"861365685", "浙江省绍兴市",
"861317169", "河北省保定市",
"861310152", "黑龙江省齐齐哈尔市",
"86156519", "江苏省南京市",
"861583326", "河北省承德市",
"861599114", "陕西省安康市",
"861304857", "贵州省遵义市",
"861308030", "山西省忻州市",
"861501430", "广东省汕头市",
"861507844", "广西玉林市",
"861380527", "江苏省扬州市",
"861769906", "新疆阿勒泰地区",
"861894782", "内蒙古兴安盟",
"861311933", "甘肃省平凉市",
"861300170", "山东省济南市",
"861341571", "广东省佛山市",
"861890845", "湖南省长沙市",
"861882485", "广东省惠州市",
"861479038", "安徽省芜湖市",
"861475557", "安徽省宣城市",
"861304091", "湖北省荆州市",
"861322634", "广东省惠州市",
"861552083", "四川省成都市",
"861810087", "重庆市",
"861780639", "山东省临沂市",
"86139380", "河南省周口市",
"86180187", "广东省深圳市",
"861450526", "吉林省辽源市",
"861335902", "安徽省蚌埠市",
"861577146", "内蒙古阿拉善盟",
"86138372", "河南省安阳市",
"861787570", "广东省佛山市",
"861301680", "江苏省镇江市",
"86147960", "广西桂林市",
"86135992", "福建省泉州市",
"861560629", "江苏省南通市",
"861527056", "江西省九江市",
"861373504", "浙江省舟山市",
"861333949", "黑龙江省大庆市",
"86137759", "江苏省徐州市",
"861514627", "黑龙江省哈尔滨市",
"861357911", "新疆阿克苏地区",
"86187398", "河南省三门峡市",
"86170802", "广东省深圳市",
"861874290", "新疆伊犁哈萨克自治州",
"861766042", "山东省济南市",
"861859928", "新疆喀什地区",
"861339873", "云南省红河哈尼族彝族自治州",
"86136821", "天津市",
"861831965", "广东省阳江市",
"861804862", "四川省德阳市",
"861510338", "河北省衡水市",
"861301878", "广东省梅州市",
"861861756", "河北省邯郸市",
"861338376", "河南省信阳市",
"861852403", "辽宁省辽阳市",
"861326399", "江西省萍乡市",
"861365546", "山东省东营市",
"86178810", "新疆喀什地区",
"861582005", "山东省烟台市",
"861829701", "青海省海东地区",
"861306853", "广东省茂名市",
"861868657", "吉林省吉林市",
"861510407", "辽宁省大连市",
"861560472", "内蒙古包头市",
"861598985", "广东省深圳市",
"861535524", "浙江省衢州市",
"861316959", "广东省惠州市",
"861366918", "陕西省西安市",
"861780678", "广东省茂名市",
"861345369", "山西省临汾市",
"861572172", "贵州省黔东南苗族侗族自治州",
"861768948", "福建省泉州市",
"861317089", "江西省抚州市",
"861853207", "河北省邯郸市",
"861325874", "吉林省通化市",
"861870690", "甘肃省张掖市",
"861564377", "吉林省辽源市",
"861354836", "四川省泸州市",
"861533123", "山东省潍坊市",
"861337290", "辽宁省葫芦岛市",
"861867242", "湖北省荆门市",
"861890331", "河北省石家庄市",
"86183459", "黑龙江省大庆市",
"86177325", "河北省唐山市",
"861388907", "西藏阿里地区",
"861328421", "辽宁省朝阳市",
"861332318", "河北省衡水市",
"86135672", "浙江省湖州市",
"861763525", "山西省临汾市",
"86155282", "四川省成都市",
"861539239", "福建省南平市",
"861453833", "四川省德阳市",
"861304496", "江西省吉安市",
"861328201", "浙江省杭州市",
"861773052", "河北省唐山市",
"861779040", "四川省广元市",
"861310642", "浙江省金华市",
"861892152", "江苏省无锡市",
"861561074", "山东省德州市",
"861504063", "辽宁省大连市",
"861368474", "内蒙古呼和浩特市",
"861533755", "福建省泉州市",
"861314242", "内蒙古包头市",
"86186971", "青海省西宁市",
"861832467", "黑龙江省牡丹江市",
"861875096", "福建省南平市",
"861371727", "广东省江门市",
"861850546", "山东省东营市",
"861525558", "安徽省阜阳市",
"861506617", "山东省青岛市",
"861891430", "江苏省常州市",
"86145401", "北京市",
"861471797", "山西省朔州市",
"861390895", "西藏昌都地区",
"861332425", "辽宁省盘锦市",
"861329492", "云南省昭通市",
"861327832", "吉林省松原市",
"861804041", "四川省遂宁市",
"861305957", "广东省清远市",
"861700961", "安徽省合肥市",
"86159081", "四川省成都市",
"861837877", "广西玉林市",
"861454212", "河南省许昌市",
"86181991", "新疆乌鲁木齐市",
"861809684", "新疆巴音郭楞蒙古自治州",
"861325646", "山东省潍坊市",
"86183378", "河南省开封市",
"861365900", "四川省内江市",
"861503343", "河北省石家庄市",
"861301905", "黑龙江省牡丹江市",
"861375441", "河北省石家庄市",
"861535671", "浙江省杭州市",
"861452815", "四川省绵阳市",
"861393393", "河北省廊坊市",
"861304728", "湖南省邵阳市",
"861323276", "广东省河源市",
"86177680", "江苏省苏州市",
"861450182", "山西省吕梁市",
"861830587", "浙江省温州市",
"86159187", "广东省广州市",
"861582513", "云南省玉溪市",
"86189895", "浙江省绍兴市",
"861333301", "河北省石家庄市",
"86188907", "湖南省常德市",
"861458540", "河南省漯河市",
"861303423", "浙江省温州市",
"861850900", "新疆博尔塔拉蒙古自治州",
"861310753", "青海省海东地区",
"861302407", "安徽省蚌埠市",
"861829866", "甘肃省甘南藏族自治州",
"861515619", "安徽省淮北市",
"861562859", "西藏拉萨市",
"861366759", "新疆克孜勒苏柯尔克孜自治州",
"861370150", "江苏省常州市",
"861709291", "陕西省榆林市",
"861820775", "广西玉林市",
"861889272", "四川省广安市",
"861834548", "黑龙江省哈尔滨市",
"861811956", "安徽省宿州市",
"861528909", "西藏拉萨市",
"861339931", "甘肃省兰州市",
"861362450", "黑龙江省哈尔滨市",
"86831", "四川省宜宾市",
"861336487", "新疆阿克苏地区",
"861857114", "湖北省孝感市",
"861885650", "安徽省芜湖市",
"861580774", "广西梧州市",
"86184817", "四川省南充市",
"86177038", "河南省郑州市",
"861459789", "新疆克拉玛依市",
"861520564", "安徽省六安市",
"861530233", "广东省佛山市",
"861569745", "湖南省怀化市",
"861356862", "四川省泸州市",
"861348178", "广西柳州市",
"861880451", "黑龙江省哈尔滨市",
"861500331", "河北省石家庄市",
"861311871", "云南省昆明市",
"86158245", "浙江省宁波市",
"861335777", "江苏省镇江市",
"86134060", "山东省菏泽市",
"86181409", "新疆乌鲁木齐市",
"861325156", "黑龙江省黑河市",
"861521798", "广东省惠州市",
"861361733", "湖南省株洲市",
"861572773", "江西省新余市",
"861376873", "广西桂林市",
"861874589", "黑龙江省伊春市",
"861847500", "广东省江门市",
"861896617", "浙江省杭州市",
"861593361", "河北省石家庄市",
"861880565", "安徽省芜湖市",
"861860936", "甘肃省张掖市",
"861812895", "广东省河源市",
"861534633", "河南省濮阳市",
"86181671", "浙江省杭州市",
"861344002", "四川省攀枝花市",
"861810692", "福建省福州市",
"861330879", "云南省普洱市",
"86180472", "内蒙古包头市",
"861565148", "江苏省盐城市",
"861313417", "辽宁省营口市",
"861520529", "江苏省镇江市",
"86145026", "内蒙古包头市",
"861328562", "安徽省铜陵市",
"86155425", "辽宁省大连市",
"861362534", "山东省德州市",
"861530470", "内蒙古呼伦贝尔市",
"861386551", "安徽省合肥市",
"861370640", "山东省济南市",
"86158590", "福建省福州市",
"861457059", "新疆伊犁哈萨克自治州",
"861369959", "江西省抚州市",
"861570514", "江苏省连云港市",
"861531410", "山东省济南市",
"861883857", "河南省商丘市",
"861319918", "黑龙江省鸡西市",
"86187754", "广西梧州市",
"861333788", "江苏省常州市",
"8613823", "广东省深圳市",
"861337589", "浙江省金华市",
"861598600", "广东省河源市",
"861355936", "福建省泉州市",
"861532831", "四川省泸州市",
"861336731", "湖南省长沙市",
"861331819", "广东省揭阳市",
"861885140", "江苏省镇江市",
"861760768", "广东省潮州市",
"861325585", "浙江省绍兴市",
"861572885", "广东省肇庆市",
"861359990", "福建省厦门市",
"861827254", "河南省鹤壁市",
"861360351", "山西省太原市",
"861454932", "江苏省连云港市",
"861351944", "甘肃省兰州市",
"861302878", "甘肃省临夏回族自治州",
"861535586", "浙江省台州市",
"861785819", "浙江省丽水市",
"861885128", "江苏省镇江市",
"861593299", "江西省抚州市",
"861528943", "陕西省渭南市",
"861370432", "吉林省吉林市",
"86180563", "安徽省宣城市",
"861319279", "广东省清远市",
"86181556", "安徽省安庆市",
"861565120", "江苏省常州市",
"861836030", "江苏省扬州市",
"861370628", "江苏省南通市",
"861858548", "贵州省六盘水市",
"861388405", "甘肃省甘南藏族自治州",
"861311845", "四川省内江市",
"861776144", "四川省成都市",
"86155182", "河南省漯河市",
"861339211", "广东省广州市",
"86159746", "云南省曲靖市",
"861841972", "甘肃省定西市",
"861837228", "湖北省襄樊市",
"86159133", "广东省中山市",
"861309313", "江苏省无锡市",
"861317066", "云南省玉溪市",
"861889725", "青海省果洛藏族自治州",
"861518336", "四川省乐山市",
"861579719", "湖北省荆门市",
"861569771", "广西南宁市",
"861510905", "新疆喀什地区",
"861813869", "广东省梅州市",
"861331318", "河北省衡水市",
"861308816", "四川省遂宁市",
"861845241", "江苏省无锡市",
"861576827", "广东省深圳市",
"861537168", "江苏省连云港市",
"8618701", "北京市",
"86178351", "山西省太原市",
"861330378", "河南省开封市",
"861354660", "山西省忻州市",
"861824438", "四川省绵阳市",
"861781777", "广东省深圳市",
"861327372", "河南省新乡市",
"861474042", "辽宁省沈阳市",
"861760946", "甘肃省金昌市",
"861889153", "陕西省渭南市",
"861459801", "湖北省黄石市",
"861890933", "甘肃省平凉市",
"861509939", "新疆喀什地区",
"861840912", "陕西省榆林市",
"861876532", "山东省青岛市",
"861818738", "云南省红河哈尼族彝族自治州",
"861519447", "河南省信阳市",
"861503477", "内蒙古呼和浩特市",
"861537088", "江苏省无锡市",
"861857512", "广东省茂名市",
"861565937", "福建省福州市",
"86152274", "河北省邯郸市",
"861526969", "山东省泰安市",
"861882987", "陕西省宝鸡市",
"861871604", "河北省秦皇岛市",
"86152028", "四川省成都市",
"861530913", "陕西省渭南市",
"861317186", "河北省邯郸市",
"861458528", "河南省鹤壁市",
"861898570", "贵州省安顺市",
"861869454", "浙江省嘉兴市",
"861331452", "黑龙江省齐齐哈尔市",
"861356790", "浙江省宁波市",
"861379985", "福建省泉州市",
"861552890", "四川省雅安市",
"861330339", "河北省邢台市",
"861317616", "山东省聊城市",
"861778123", "四川省乐山市",
"86152411", "辽宁省大连市",
"86133722", "江苏省常州市",
"86153825", "浙江省温州市",
"86184496", "新疆阿克苏地区",
"861305422", "黑龙江省大庆市",
"861317555", "浙江省嘉兴市",
"86187062", "江苏省苏州市",
"861567704", "广西玉林市",
"86135854", "江苏省常州市",
"86156379", "河南省洛阳市",
"86130500", "辽宁省鞍山市",
"861450584", "辽宁省辽阳市",
"861380699", "福建省龙岩市",
"861363715", "安徽省安庆市",
"861589579", "江苏省连云港市",
"861453945", "广东省江门市",
"861315568", "安徽省亳州市",
"861501811", "广东省肇庆市",
"861804075", "新疆乌鲁木齐市",
"861768801", "广东省汕头市",
"861806376", "福建省龙岩市",
"861558633", "湖北省武汉市",
"861598731", "云南省怒江傈僳族自治州",
"861521484", "新疆乌鲁木齐市",
"861882350", "广东省潮州市",
"861304740", "山东省青岛市",
"861770577", "浙江省温州市",
"861533275", "内蒙古通辽市",
"861363396", "河南省驻马店市",
"86138512", "江苏省连云港市",
"861874022", "辽宁省辽阳市",
"861369677", "安徽省合肥市",
"861527649", "新疆伊犁哈萨克自治州",
"861560597", "福建省龙岩市",
"86187440", "吉林省长春市",
"861375475", "山东省淄博市",
"861782068", "广东省广州市",
"861319602", "吉林省长春市",
"861583384", "河北省衡水市",
"86187422", "辽宁省葫芦岛市",
"861576919", "陕西省商洛市",
"861886925", "云南省文山壮族苗族自治州",
"861505488", "山东省济宁市",
"86180287", "广东省深圳市",
"861861753", "河北省唐山市",
"861852406", "辽宁省锦州市",
"861338373", "河南省新乡市",
"861365543", "山东省滨州市",
"861470310", "河北省邯郸市",
"861778029", "四川省成都市",
"86188211", "上海市",
"861529841", "江苏省无锡市",
"861561265", "河北省承德市",
"861306856", "广东省阳江市",
"861303798", "宁夏银川市",
"861805120", "江苏省常州市",
"861308271", "山东省淄博市",
"861371587", "广东省汕头市",
"86156563", "安徽省宣城市",
"861354833", "四川省内江市",
"86188268", "广东省东莞市",
"861581171", "广东省湛江市",
"861325752", "广东省惠州市",
"861536662", "江苏省淮安市",
"861524987", "安徽省马鞍山市",
"86130235", "江苏省南通市",
"86188474", "内蒙古乌兰察布市",
"861871838", "广东省茂名市",
"861339876", "云南省文山壮族苗族自治州",
"86135658", "新疆乌鲁木齐市",
"861504066", "辽宁省鞍山市",
"861869939", "新疆伊犁哈萨克自治州",
"861834817", "河南省驻马店市",
"861520948", "甘肃省天水市",
"861875093", "福建省厦门市",
"861537942", "甘肃省白银市",
"86145707", "江苏省无锡市",
"861535784", "安徽省阜阳市",
"861771349", "四川省宜宾市",
"861554279", "辽宁省盘锦市",
"861551619", "河南省郑州市",
"861352631", "河南省商丘市",
"861850543", "山东省滨州市",
"861815449", "湖北省神农架林区",
"861533126", "河南省开封市",
"861813741", "河南省洛阳市",
"861809771", "新疆博尔塔拉蒙古自治州",
"861760341", "山西省太原市",
"861886531", "山东省济南市",
"861453836", "四川省广元市",
"861304493", "江西省上饶市",
"86151328", "河北省衡水市",
"861889334", "甘肃省平凉市",
"86134349", "广东省揭阳市",
"861347404", "陕西省咸阳市",
"861452246", "浙江省杭州市",
"861306497", "江苏省连云港市",
"861321343", "河南省驻马店市",
"86552", "安徽省蚌埠市",
"861576510", "黑龙江省牡丹江市",
"861377929", "新疆和田地区",
"86138358", "山西省吕梁市",
"861859704", "青海省海南藏族自治州",
"861828888", "云南省丽江市",
"861380036", "山西省忻州市",
"861532976", "贵州省铜仁地区",
"861350488", "黑龙江省七台河市",
"861320100", "新疆昌吉回族自治州",
"86188799", "江西省萍乡市",
"861383443", "山西省朔州市",
"861558344", "四川省成都市",
"861550422", "辽宁省朝阳市",
"861778614", "湖北省武汉市",
"861391450", "江苏省泰州市",
"861589970", "广东省江门市",
"861536474", "山西省晋中市",
"861529335", "甘肃省陇南市",
"86155000", "吉林省长春市",
"861335390", "河南省洛阳市",
"861554327", "吉林省长春市",
"861376644", "江西省宜春市",
"861813402", "河北省保定市",
"861778184", "四川省广元市",
"861550638", "山东省烟台市",
"861863477", "山西省吕梁市",
"861840374", "河南省许昌市",
"861813222", "河北省保定市",
"861523905", "河南省驻马店市",
"861596447", "山东省淄博市",
"861550202", "广东省深圳市",
"861380787", "广西南宁市",
"861327914", "陕西省渭南市",
"861830858", "贵州省六盘水市",
"861328537", "山东省济宁市",
"861865488", "山东省潍坊市",
"86156287", "山东省潍坊市",
"861569512", "江苏省苏州市",
"861806971", "浙江省湖州市",
"861552086", "四川省南充市",
"861590705", "江西省宜春市",
"861889059", "湖南省娄底市",
"861396602", "安徽省芜湖市",
"861760835", "四川省雅安市",
"861450523", "吉林省白城市",
"86153621", "广东省中山市",
"861800597", "福建省龙岩市",
"861470947", "甘肃省兰州市",
"86134005", "福建省福州市",
"861577143", "内蒙古赤峰市",
"861860871", "云南省昆明市",
"861580825", "四川省遂宁市",
"861527053", "江西省上饶市",
"86145270", "湖北省武汉市",
"86139893", "浙江省宁波市",
"861705179", "广西桂林市",
"861356837", "四川省广元市",
"861763333", "河北省保定市",
"861534792", "江西省九江市",
"861810733", "湖南省长沙市",
"861358204", "河北省石家庄市",
"861884021", "陕西省延安市",
"861871879", "广东省深圳市",
"861893346", "广东省梅州市",
"861867581", "广东省汕尾市",
"861378745", "湖南省怀化市",
"861831640", "广东省惠州市",
"861538918", "陕西省西安市",
"861583323", "河北省张家口市",
"861358424", "江苏省无锡市",
"861350342", "河南省平顶山市",
"861361692", "福建省龙岩市",
"861862430", "辽宁省沈阳市",
"861311936", "甘肃省张掖市",
"861839951", "新疆和田地区",
"861769903", "新疆和田地区",
"861807704", "广西南宁市",
"86180379", "河南省洛阳市",
"861369434", "吉林省四平市",
"861398662", "湖北省咸宁市",
"861860845", "湖南省怀化市",
"861472666", "四川省达州市",
"861772901", "陕西省西安市",
"861559098", "黑龙江省绥化市",
"861809623", "四川省宜宾市",
"861700366", "广东省东莞市",
"861478354", "河南省焦作市",
"861806945", "浙江省湖州市",
"861590629", "江苏省南通市",
"861587886", "广西河池市",
"861535498", "内蒙古鄂尔多斯市",
"861476595", "吉林省长春市",
"861830359", "山西省运城市",
"861528077", "福建省南平市",
"861315944", "福建省莆田市",
"861321477", "内蒙古鄂尔多斯市",
"861479772", "广西柳州市",
"861831628", "广东省东莞市",
"861378771", "湖南省衡阳市",
"861850509", "福建省龙岩市",
"861517728", "广西南宁市",
"861368719", "湖北省恩施土家族苗族自治州",
"861318758", "云南省临沧市",
"861458949", "广东省中山市",
"861324312", "河南省南阳市",
"861537591", "福建省福州市",
"861815403", "安徽省宣城市",
"861863343", "河北省唐山市",
"861320417", "辽宁省营口市",
"86189691", "浙江省杭州市",
"861513529", "山西省吕梁市",
"861770140", "江苏省淮安市",
"861395115", "江苏省泰州市",
"86159519", "江苏省南京市",
"861580576", "浙江省台州市",
"861815223", "甘肃省平凉市",
"86158955", "江苏省苏州市",
"861339336", "河北省廊坊市",
"861323811", "辽宁省阜新市",
"8613311", "北京市",
"861898147", "四川省达州市",
"861471830", "广东省揭阳市",
"861370467", "黑龙江省大庆市",
"861778582", "贵州省贵阳市",
"861303484", "湖南省娄底市",
"861364535", "山东省烟台市",
"861821991", "甘肃省兰州市",
"861355845", "广西玉林市",
"861518211", "四川省内江市",
"86151582", "浙江省绍兴市",
"861333906", "安徽省安庆市",
"86153973", "浙江省温州市",
"861807665", "广西钦州市",
"861454967", "黑龙江省黑河市",
"861550957", "宁夏银川市",
"861356229", "山东省东营市",
"861347391", "河北省唐山市",
"861870318", "河北省衡水市",
"861777558", "四川省内江市",
"861805658", "安徽省芜湖市",
"861322975", "广东省珠海市",
"861338833", "四川省自贡市",
"861773759", "河南省商丘市",
"86189971", "青海省西宁市",
"861870452", "黑龙江省齐齐哈尔市",
"861478078", "四川省广元市",
"861776004", "四川省绵阳市",
"861819187", "陕西省西安市",
"861807015", "江西省南昌市",
"861369550", "安徽省滁州市",
"861774250", "湖南省岳阳市",
"861500936", "甘肃省张掖市",
"861570395", "河南省漯河市",
"861336050", "广东省深圳市",
"861362736", "湖南省常德市",
"861571776", "广西百色市",
"861338447", "吉林省长春市",
"861815882", "安徽省阜阳市",
"861309507", "新疆哈密地区",
"861337563", "山东省泰安市",
"861327234", "湖南省衡阳市",
"861323753", "江西省上饶市",
"861860331", "河北省石家庄市",
"861577109", "湖北省十堰市",
"861897242", "湖北省恩施土家族苗族自治州",
"861454814", "广东省广州市",
"861476972", "山东省济南市",
"86137137", "广东省深圳市",
"86188538", "山东省泰安市",
"861786541", "山东省济南市",
"861809745", "青海省果洛藏族自治州",
"861705310", "四川省成都市",
"861770650", "浙江省杭州市",
"861521249", "安徽省六安市",
"86189704", "江西省抚州市",
"861760375", "河南省平顶山市",
"861840834", "四川省凉山彝族自治州",
"861538327", "河北省沧州市",
"861520766", "广东省云浮市",
"861351568", "安徽省阜阳市",
"861898657", "湖北省黄石市",
"861337357", "河北省唐山市",
"86187329", "河北省邢台市",
"861534344", "山西省晋中市",
"861847909", "江西省抚州市",
"861310276", "河北省衡水市",
"861857745", "广西南宁市",
"86181875", "云南省保山市",
"861877424", "湖南省衡阳市",
"861322592", "福建省厦门市",
"861341113", "广东省韶关市",
"861383409", "山西省运城市",
"861390953", "宁夏吴忠市",
"861364326", "河北省沧州市",
"861590472", "内蒙古包头市",
"861821144", "广东省惠州市",
"861350794", "江西省抚州市",
"861385701", "浙江省衢州市",
"861348033", "广东省揭阳市",
"86152717", "湖北省荆门市",
"861398012", "四川省绵阳市",
"86133162", "广东省广州市",
"861355331", "广东省佛山市",
"861598295", "四川省绵阳市",
"861565962", "福建省三明市",
"861863808", "河南省周口市",
"861505596", "安徽省六安市",
"861827419", "湖南省株洲市",
"861805148", "江苏省苏州市",
"86156472", "内蒙古包头市",
"86139821", "四川省成都市",
"861317183", "河北省廊坊市",
"86151492", "内蒙古呼伦贝尔市",
"86132507", "广东省广州市",
"861800664", "浙江省宁波市",
"861810534", "山东省德州市",
"861778126", "四川省自贡市",
"861317613", "山东省泰安市",
"861325272", "辽宁省沈阳市",
"861508147", "河北省沧州市",
"861839567", "河北省保定市",
"861825039", "福建省龙岩市",
"861520801", "西藏日喀则地区",
"86186895", "海南省海口市",
"861381247", "江苏省泰州市",
"861552069", "四川省遂宁市",
"861459162", "广西崇左市",
"861533064", "吉林省四平市",
"861321941", "四川省达州市",
"861392450", "广东省中山市",
"861893634", "江苏省盐城市",
"861530916", "陕西省汉中市",
"861857251", "湖北省十堰市",
"86182280", "四川省成都市",
"861555170", "安徽省芜湖市",
"861323642", "江苏省徐州市",
"861314360", "广东省惠州市",
"861800629", "江苏省南通市",
"861458788", "湖南省衡阳市",
"861769301", "甘肃省庆阳市",
"861761428", "辽宁省大连市",
"861363393", "河南省濮阳市",
"861318827", "辽宁省抚顺市",
"86138860", "湖北省武汉市",
"861863975", "河南省商丘市",
"861475389", "山东省临沂市",
"86137283", "广东省东莞市",
"861834780", "内蒙古包头市",
"861700888", "广东省深圳市",
"861887137", "湖北省武汉市",
"861508218", "四川省绵阳市",
"861832640", "安徽省宣城市",
"861581307", "广东省阳江市",
"861529908", "新疆乌鲁木齐市",
"861552024", "四川省雅安市",
"861362692", "福建省莆田市",
"86177936", "甘肃省张掖市",
"861360895", "山东省潍坊市",
"861859503", "宁夏吴忠市",
"861306995", "黑龙江省鹤岗市",
"861804229", "浙江省舟山市",
"86150691", "山东省济南市",
"861558636", "湖北省宜昌市",
"861815651", "安徽省合肥市",
"861810450", "黑龙江省哈尔滨市",
"861528946", "陕西省渭南市",
"861803720", "河南省安阳市",
"86155904", "吉林省四平市",
"861319025", "辽宁省朝阳市",
"861773918", "河南省新乡市",
"861399959", "新疆伊犁哈萨克自治州",
"861800472", "内蒙古包头市",
"86137567", "吉林省松原市",
"861862753", "湖南省株洲市",
"861875880", "浙江省宁波市",
"861562265", "广东省云浮市",
"861707539", "山东省临沂市",
"861523379", "河北省沧州市",
"861870205", "广东省清远市",
"861504089", "辽宁省朝阳市",
"86188017", "上海市",
"861595148", "江苏省盐城市",
"861847835", "湖南省湘西土家族苗族自治州",
"861380810", "四川省德阳市",
"861888232", "四川省南充市",
"861535583", "浙江省嘉兴市",
"861700670", "浙江省温州市",
"861329140", "浙江省杭州市",
"861373042", "河北省石家庄市",
"861321194", "云南省怒江傈僳族自治州",
"86130135", "山东省临沂市",
"861801412", "江苏省盐城市",
"861580419", "辽宁省辽阳市",
"861850744", "湖南省张家界市",
"861338971", "青海省西宁市",
"861870425", "辽宁省盘锦市",
"86155771", "广西南宁市",
"861308813", "四川省南充市",
"861866617", "广东省中山市",
"861563361", "河北省唐山市",
"861353932", "广东省佛山市",
"861533184", "黑龙江省齐齐哈尔市",
"86145928", "重庆市",
"861351631", "山东省威海市",
"861320235", "广东省佛山市",
"861814982", "新疆昌吉回族自治州",
"861772349", "四川省成都市",
"861389732", "青海省海东地区",
"861397292", "湖北省武汉市",
"861760943", "甘肃省白银市",
"861524485", "四川省内江市",
"861306572", "浙江省杭州市",
"861533614", "陕西省渭南市",
"861889156", "陕西省渭南市",
"861813090", "新疆乌鲁木齐市",
"861552189", "广东省揭阳市",
"861890936", "甘肃省张掖市",
"861309795", "广西玉林市",
"861337605", "江苏省南京市",
"86139709", "江西省南昌市",
"861316550", "河北省邯郸市",
"861803966", "河南省郑州市",
"86157330", "河北省邯郸市",
"861458301", "江西省鹰潭市",
"86150704", "江西省抚州市",
"861556921", "新疆阿克苏地区",
"861800014", "江苏省宿迁市",
"861333540", "陕西省咸阳市",
"861339552", "安徽省蚌埠市",
"861317063", "云南省昆明市",
"861815141", "江苏省镇江市",
"861309316", "江苏省常州市",
"861518333", "四川省眉山市",
"861479907", "新疆巴音郭楞蒙古自治州",
"861340772", "广西南宁市",
"861705076", "广东省东莞市",
"861324635", "广东省珠海市",
"861572776", "江西省赣州市",
"861376876", "广西玉林市",
"861313791", "河南省焦作市",
"861361736", "湖南省常德市",
"861458494", "山东省淄博市",
"861536197", "广东省梅州市",
"861333528", "山东省泰安市",
"861523878", "河南省周口市",
"861337729", "广西北海市",
"861528768", "云南省普洱市",
"861368637", "山东省济宁市",
"86186710", "湖北省襄樊市",
"861860933", "甘肃省平凉市",
"861845029", "福建省厦门市",
"861816939", "湖南省邵阳市",
"861896365", "江苏省苏州市",
"861592074", "广东省佛山市",
"861787657", "广东省肇庆市",
"861325725", "湖北省恩施土家族苗族自治州",
"861815175", "江苏省镇江市",
"861361087", "辽宁省盘锦市",
"86156746", "湖南省永州市",
"861786884", "陕西省汉中市",
"861568487", "新疆喀什地区",
"86156133", "河北省石家庄市",
"861530236", "广东省广州市",
"86137237", "广东省深圳市",
"861520789", "广西北海市",
"86135366", "广东省佛山市",
"86147905", "安徽省安庆市",
"861853018", "河南省焦作市",
"861325153", "黑龙江省牡丹江市",
"86131410", "北京市",
"861315499", "四川省乐山市",
"861858780", "广西河池市",
"861768529", "贵州省黔西南布依族苗族自治州",
"861566660", "山东省威海市",
"861508938", "广东省揭阳市",
"861595120", "江苏省常州市",
"861337764", "广东省深圳市",
"861321592", "福建省厦门市",
"861323554", "湖北省武汉市",
"861355933", "福建省南平市",
"861827111", "湖北省咸宁市",
"861352568", "河南省南阳市",
"861329128", "江苏省南京市",
"861807549", "安徽省池州市",
"861772848", "广东省中山市",
"861586095", "福建省南平市",
"861477999", "江西省萍乡市",
"861529182", "陕西省榆林市",
"861390351", "山西省太原市",
"861879751", "湖南省张家界市",
"86150623", "江苏省苏州市",
"86138601", "福建省厦门市",
"861338945", "甘肃省金昌市",
"861803748", "河南省郑州市",
"861886668", "山东省东营市",
"86152926", "新疆昌吉回族自治州",
"861322477", "内蒙古鄂尔多斯市",
"861334081", "四川省自贡市",
"861393396", "河北省秦皇岛市",
"861800705", "江西省宜春市",
"861850392", "河南省鹤壁市",
"861596971", "山东省济南市",
"861323273", "广东省湛江市",
"86147778", "广西玉林市",
"861582516", "云南省楚雄彝族自治州",
"861508979", "广东省湛江市",
"861454465", "陕西省咸阳市",
"861346747", "湖南省永州市",
"861773238", "河北省承德市",
"861771901", "河南省商丘市",
"861550455", "黑龙江省绥化市",
"861459529", "云南省文山壮族苗族自治州",
"861818414", "贵州省黔南布依族苗族自治州",
"861339644", "山东省济南市",
"86185256", "辽宁省大连市",
"861894461", "黑龙江省哈尔滨市",
"861566010", "河南省焦作市",
"861761440", "吉林省长春市",
"86182912", "陕西省榆林市",
"86159379", "河南省洛阳市",
"861760909", "新疆博尔塔拉蒙古自治州",
"861597704", "广西玉林市",
"861873400", "安徽省安庆市",
"86152553", "安徽省芜湖市",
"861370965", "广东省佛山市",
"861325643", "山东省菏泽市",
"861503346", "河北省唐山市",
"861819739", "青海省海南藏族自治州",
"861846505", "宁夏中卫市",
"861454551", "新疆石河子市",
"861836245", "江苏省徐州市",
"861384989", "河南省许昌市",
"861550561", "安徽省淮北市",
"861323430", "吉林省长春市",
"861877081", "江西省南昌市",
"861822654", "安徽省芜湖市",
"861816978", "广西北海市",
"861899454", "江苏省连云港市",
"861365392", "河南省鹤壁市",
"861868570", "贵州省黔东南苗族侗族自治州",
"861459564", "陕西省渭南市",
"861320915", "陕西省安康市",
"861830727", "湖北省荆州市",
"861882297", "广东省东莞市",
"861472689", "四川省南充市",
"861321975", "四川省眉山市",
"861580852", "贵州省遵义市",
"861340405", "四川省雅安市",
"861868007", "广东省东莞市",
"861310756", "青海省海西蒙古族藏族自治州",
"86184344", "山西省太原市",
"861829863", "甘肃省陇南市",
"861303426", "浙江省绍兴市",
"861381330", "江苏省淮安市",
"861504522", "黑龙江省齐齐哈尔市",
"861775159", "江苏省常州市",
"861808050", "四川省巴中市",
"86183352", "山西省大同市",
"861588578", "贵州省铜仁地区",
"861811953", "安徽省淮南市",
"861351700", "江西省南昌市",
"861587869", "广西河池市",
"861340225", "山东省菏泽市",
"86138794", "江西省抚州市",
"861453198", "山西省晋城市",
"861312588", "吉林省吉林市",
"861380281", "广东省韶关市",
"861553335", "河北省唐山市",
"861804351", "吉林省通化市",
"861857840", "广东省佛山市",
"861863649", "山西省晋城市",
"861319260", "广东省云浮市",
"861320987", "山西省晋城市",
"861782030", "广东省中山市",
"861534765", "广东省潮州市",
"86136523", "广东省深圳市",
"861596679", "山东省威海市",
"861774062", "湖北省黄冈市",
"861389044", "四川省宜宾市",
"861812837", "广东省茂名市",
"861760601", "福建省泉州市",
"861564956", "河南省驻马店市",
"861590323", "河北省保定市",
"861550833", "四川省乐山市",
"861896543", "福建省宁德市",
"861588490", "四川省广安市",
"861865279", "江苏省扬州市",
"861836188", "江苏省连云港市",
"86133606", "广东省东莞市",
"861586526", "山东省济南市",
"861338957", "宁夏吴忠市",
"861305660", "四川省眉山市",
"861880346", "山西省晋城市",
"86182779", "广西北海市",
"861315530", "安徽省芜湖市",
"861537927", "甘肃省张掖市",
"861571548", "山东省泰安市",
"86185023", "重庆市",
"861899499", "江苏省常州市",
"861890904", "四川省阿坝藏族羌族自治州",
"861822699", "安徽省滁州市",
"861787645", "广东省河源市",
"86151343", "吉林省松原市",
"861377253", "陕西省西安市",
"861320350", "山西省忻州市",
"861858172", "四川省南充市",
"861354679", "山西省朔州市",
"861803852", "广东省河源市",
"861809840", "安徽省滁州市",
"86131311", "河北省石家庄市",
"86139787", "广西南宁市",
"861854008", "辽宁省本溪市",
"861472981", "陕西省延安市",
"861316001", "江苏省淮安市",
"86185463", "黑龙江省牡丹江市",
"861390443", "吉林省延边朝鲜族自治州",
"86131368", "黑龙江省大庆市",
"861324948", "广东省汕头市",
"861338380", "河南省新乡市",
"861783500", "山西省忻州市",
"861829531", "宁夏银川市",
"861303914", "吉林省长春市",
"861300186", "河北省邯郸市",
"861855075", "江苏省宿迁市",
"861538794", "江西省抚州市",
"861839475", "甘肃省酒泉市",
"861355740", "广西桂林市",
"861537130", "江苏省扬州市",
"861824460", "河北省邯郸市",
"861897878", "广西贵港市",
"861350327", "河北省沧州市",
"861810506", "福建省泉州市",
"861362549", "山东省临沂市",
"861787586", "广东省梅州市",
"861893606", "江苏省无锡市",
"861301676", "江苏省南通市",
"861537819", "四川省成都市",
"86134686", "陕西省西安市",
"861308777", "广西钦州市",
"861303867", "云南省曲靖市",
"861840761", "广东省中山市",
"861350238", "广东省汕尾市",
"861890588", "浙江省丽水市",
"861315454", "黑龙江省佳木斯市",
"861831300", "云南省大理白族自治州",
"861857277", "湖北省孝感市",
"861869568", "福建省厦门市",
"861596638", "山东省滨州市",
"861378828", "广西河池市",
"86133618", "上海市",
"861323599", "福建省南平市",
"861812443", "广东省揭阳市",
"861300461", "浙江省绍兴市",
"861771272", "江苏省宿迁市",
"861554342", "吉林省吉林市",
"861827989", "江西省抚州市",
"861330792", "江西省九江市",
"861894547", "黑龙江省七台河市",
"861593681", "河南省安阳市",
"861860740", "湖南省岳阳市",
"86159600", "福建省福州市",
"861589983", "广东省佛山市",
"861813247", "河北省唐山市",
"86156109", "河北省衡水市",
"86136849", "广东省深圳市",
"861476084", "江苏省南京市",
"861510581", "浙江省杭州市",
"861477954", "江西省九江市",
"861580748", "湖南省永州市",
"861865238", "江苏省泰州市",
"86130210", "北京市",
"86189577", "浙江省温州市",
"86181258", "广东省潮州市",
"861815677", "安徽省亳州市",
"861393431", "山西省晋城市",
"861318466", "江西省宜春市",
"861580720", "湖北省宜昌市",
"861359753", "湖北省襄樊市",
"861819900", "新疆昌吉回族自治州",
"861866685", "广东省东莞市",
"861776139", "四川省雅安市",
"861360041", "广东省深圳市",
"861537318", "河北省衡水市",
"861322451", "黑龙江省哈尔滨市",
"861390409", "辽宁省大连市",
"861565995", "福建省龙岩市",
"86135782", "云南省德宏傣族景颇族自治州",
"86155885", "山东省泰安市",
"861520312", "河北省保定市",
"861760730", "湖南省岳阳市",
"861354380", "广东省中山市",
"86139146", "江苏省盐城市",
"861524417", "山东省淄博市",
"861802982", "广东省肇庆市",
"86159806", "福建省福州市",
"861590800", "山东省潍坊市",
"86139733", "湖南省株洲市",
"86183863", "贵州省毕节地区",
"861831282", "广东省茂名市",
"86151914", "陕西省西安市",
"861359125", "辽宁省锦州市",
"861776810", "江苏省南京市",
"86150317", "河北省沧州市",
"861378840", "广西南宁市",
"861508586", "贵州省六盘水市",
"861322565", "安徽省合肥市",
"861321159", "广西桂林市",
"861326696", "广东省深圳市",
"861509944", "新疆伊犁哈萨克自治州",
"861803419", "河北省邢台市",
"861860728", "湖北省十堰市",
"861589296", "四川省达州市",
"861372656", "广东省韶关市",
"861501990", "广东省中山市",
"861309163", "黑龙江省佳木斯市",
"861775975", "福建省南平市",
"861513974", "河南省商丘市",
"861454577", "四川省眉山市",
"861347518", "山东省德州市",
"861823015", "河北省唐山市",
"861351939", "甘肃省陇南市",
"861552911", "陕西省延安市",
"861318181", "山东省泰安市",
"86152655", "山东省聊城市",
"861818892", "湖南省永州市",
"861596380", "山东省日照市",
"861839441", "甘肃省兰州市",
"861390264", "广东省东莞市",
"861555782", "浙江省丽水市",
"861870591", "福建省福州市",
"861550373", "河南省新乡市",
"861335816", "江苏省常州市",
"861557944", "江西省宜春市",
"861580966", "宁夏银川市",
"861556629", "辽宁省抚顺市",
"861355728", "广西河池市",
"861387005", "江西省南昌市",
"861551313", "山西省长治市",
"861508723", "云南省楚雄彝族自治州",
"861861599", "山东省东营市",
"86176257", "江苏省苏州市",
"861889517", "宁夏银川市",
"86130982", "陕西省榆林市",
"861560535", "山东省烟台市",
"861470457", "黑龙江省大兴安岭地区",
"86150525", "江苏省扬州市",
"861576463", "黑龙江省牡丹江市",
"861811101", "四川省南充市",
"861831823", "广东省肇庆市",
"861327484", "内蒙古通辽市",
"861887635", "福建省泉州市",
"861340610", "山东省东营市",
"861361704", "江西省抚州市",
"861302844", "陕西省咸阳市",
"861839702", "青海省海东地区",
"861807692", "西藏日喀则地区",
"861787671", "广东省深圳市",
"861356953", "河南省开封市",
"861816700", "浙江省衢州市",
"861538342", "山西省大同市",
"861530424", "辽宁省抚顺市",
"861350918", "陕西省西安市",
"861571520", "江苏省徐州市",
"861318061", "吉林省白城市",
"861372146", "河南省焦作市",
"861874973", "河南省洛阳市",
"861321649", "浙江省台州市",
"861322056", "山东省济南市",
"861360446", "吉林省吉林市",
"861345016", "广东省肇庆市",
"861331088", "广东省广州市",
"861538488", "内蒙古鄂尔多斯市",
"86183116", "贵州省遵义市",
"86468", "黑龙江省鹤岗市",
"861774908", "陕西省渭南市",
"861866821", "浙江省杭州市",
"86150292", "陕西省西安市",
"86152436", "湖南省长沙市",
"861319596", "甘肃省张掖市",
"861882040", "广东省广州市",
"861855446", "山东省济南市",
"861879777", "湖南省常德市",
"861390377", "河南省南阳市",
"861348542", "山西省吕梁市",
"861530469", "黑龙江省大庆市",
"861520458", "黑龙江省伊春市",
"861839046", "湖南省郴州市",
"861359811", "河南省安阳市",
"86159818", "河南省郑州市",
"86153122", "江苏省无锡市",
"861476562", "湖南省长沙市",
"861770932", "甘肃省定西市",
"861338638", "山东省烟台市",
"861324766", "广东省广州市",
"861398695", "湖北省武汉市",
"861815959", "福建省泉州市",
"861330860", "湖北省宜昌市",
"86133800", "广东省广州市",
"861780336", "河北省廊坊市",
"861788905", "西藏昌都地区",
"861337973", "新疆阿克苏地区",
"861826874", "浙江省舟山市",
"86159861", "广东省佛山市",
"861537452", "湖北省黄石市",
"861338422", "辽宁省鞍山市",
"861330344", "山西省晋中市",
"861787524", "广东省湛江市",
"861355857", "四川省阿坝藏族羌族自治州",
"861879902", "新疆阿勒泰地区",
"861380004", "辽宁省沈阳市",
"861370826", "四川省资阳市",
"861598501", "贵州省贵阳市",
"861334916", "安徽省巢湖市",
"861559379", "甘肃省嘉峪关市",
"861361549", "山东省临沂市",
"86178631", "山东省威海市",
"861889306", "甘肃省天水市",
"861347436", "陕西省西安市",
"861525672", "安徽省淮南市",
"861353140", "广东省佛山市",
"861359152", "辽宁省丹东市",
"861309762", "山西省临汾市",
"861888803", "江苏省无锡市",
"861707968", "浙江省温州市",
"861532589", "浙江省金华市",
"86152304", "河北省保定市",
"861318842", "辽宁省铁岭市",
"861386650", "安徽省铜陵市",
"86131092", "陕西省榆林市",
"861550945", "甘肃省金昌市",
"861863451", "山西省太原市",
"861337831", "四川省资阳市",
"861339491", "新疆乌鲁木齐市",
"861370541", "山东省济南市",
"861898723", "云南省大理白族自治州",
"861476026", "福建省龙岩市",
"86177207", "福建省福州市",
"861308188", "河北省秦皇岛市",
"86158820", "四川省成都市",
"861819115", "陕西省汉中市",
"861570035", "四川省内江市",
"86180806", "四川省乐山市",
"861592982", "陕西省榆林市",
"861787569", "广东省湛江市",
"86138745", "湖南省怀化市",
"861780552", "安徽省蚌埠市",
"861555613", "安徽省淮北市",
"861826646", "山东省潍坊市",
"861350759", "福建省三明市",
"861811443", "江苏省苏州市",
"861323627", "江苏省盐城市",
"861308618", "江西省抚州市",
"861860857", "贵州省毕节地区",
"861819685", "新疆阿克苏地区",
"861399403", "山西省临汾市",
"861899944", "新疆哈密地区",
"861586908", "浙江省衢州市",
"861329932", "甘肃省酒泉市",
"861300169", "山东省青岛市",
"861479610", "广西玉林市",
"861311904", "新疆乌鲁木齐市",
"861593419", "山西省晋城市",
"86156614", "内蒙古包头市",
"861768195", "浙江省杭州市",
"861317170", "河北省沧州市",
"861898586", "贵州省铜仁地区",
"861479180", "陕西省西安市",
"861393810", "河南省三门峡市",
"86189317", "河北省沧州市",
"861839977", "新疆巴音郭楞蒙古自治州",
"861874831", "内蒙古阿拉善盟",
"86130110", "北京市",
"86181781", "广西南宁市",
"86189292", "广东省东莞市",
"861857757", "广西贵港市",
"861863056", "河北省秦皇岛市",
"861367859", "贵州省黔西南布依族苗族自治州",
"861801108", "四川省凉山彝族自治州",
"86157527", "云南省大理白族自治州",
"861317818", "福建省龙岩市",
"861568829", "湖南省怀化市",
"861852434", "辽宁省鞍山市",
"861337345", "河北省唐山市",
"861308257", "江苏省扬州市",
"861898645", "湖北省孝感市",
"861360862", "河南省安阳市",
"861590921", "陕西省延安市",
"861368420", "四川省达州市",
"861478399", "河南省新乡市",
"861830394", "河南省周口市",
"86133347", "云南省普洱市",
"86131850", "浙江省杭州市",
"861856936", "湖南省永州市",
"861539463", "江苏省扬州市",
"861519198", "陕西省榆林市",
"861807167", "江苏省宿迁市",
"86180818", "四川省成都市",
"861386140", "江苏省盐城市",
"861537425", "江西省上饶市",
"861786467", "山东省莱芜市",
"861338455", "黑龙江省绥化市",
"861589708", "青海省西宁市",
"861520635", "山东省聊城市",
"861535570", "浙江省衢州市",
"861597692", "广东省汕头市",
"861855862", "福建省宁德市",
"861572548", "山东省泰安市",
"861859167", "陕西省延安市",
"861559338", "甘肃省天水市",
"86734", "湖南省衡阳市",
"861333214", "辽宁省本溪市",
"861876046", "福建省漳州市",
"86189525", "江苏省扬州市",
"861860496", "辽宁省锦州市",
"861473112", "河北省石家庄市",
"861880634", "山东省莱芜市",
"861338561", "安徽省淮北市",
"861559407", "甘肃省张掖市",
"861535007", "江西省赣州市",
"861320485", "内蒙古鄂尔多斯市",
"861395617", "安徽省芜湖市",
"861809757", "新疆和田地区",
"861473682", "云南省楚雄彝族自治州",
"86131571", "浙江省杭州市",
"861471981", "新疆伊犁哈萨克自治州",
"861879188", "陕西省咸阳市",
"861362704", "江西省赣州市",
"86185312", "河北省保定市",
"86151010", "北京市",
"861352978", "云南省玉溪市",
"861530486", "黑龙江省大庆市",
"861814358", "贵州省六盘水市",
"861568237", "四川省资阳市",
"861554593", "黑龙江省鹤岗市",
"861334236", "辽宁省朝阳市",
"861890493", "辽宁省抚顺市",
"861518678", "贵州省黔东南苗族侗族自治州",
"861368382", "河南省郑州市",
"861884867", "贵州省六盘水市",
"861846386", "山东省聊城市",
"861324789", "江西省赣州市",
"861500904", "新疆和田地区",
"861709411", "广东省深圳市",
"861336501", "福建省漳州市",
"861317319", "山东省济宁市",
"861399449", "山西省阳泉市",
"861330636", "山东省潍坊市",
"861367358", "河南省周口市",
"861507680", "河北省沧州市",
"86153595", "福建省泉州市",
"861811409", "江苏省无锡市",
"86155326", "河北省廊坊市",
"861528456", "云南省迪庆藏族自治州",
"861322649", "广东省珠海市",
"861327426", "辽宁省锦州市",
"861325848", "四川省遂宁市",
"861776787", "吉林省松原市",
"861365365", "山西省太原市",
"861337371", "河南省安阳市",
"861889094", "新疆喀什地区",
"861898671", "湖北省荆州市",
"86150192", "广东省深圳市",
"861560384", "河南省安阳市",
"86150648", "山东省青岛市",
"861396593", "安徽省池州市",
"861370992", "新疆伊犁哈萨克自治州",
"861332088", "四川省绵阳市",
"86132774", "湖北省武汉市",
"861380396", "河南省驻马店市",
"861888849", "广西玉林市",
"861454492", "湖北省恩施土家族苗族自治州",
"861452558", "山东省青岛市",
"861512186", "宁夏石嘴山市",
"861358916", "山东省潍坊市",
"861882791", "江西省南昌市",
"86130663", "广东省广州市",
"861586182", "江苏省南京市",
"861800323", "河北省张家口市",
"861839659", "福建省南平市",
"861561048", "山东省青岛市",
"861368448", "四川省巴中市",
"861709666", "浙江省宁波市",
"861892468", "广东省江门市",
"861506543", "山东省滨州市",
"861760453", "黑龙江省牡丹江市",
"861458675", "湖南省益阳市",
"86153222", "广东省广州市",
"86132966", "湖北省武汉市",
"861803681", "江苏省苏州市",
"861806422", "湖北省荆州市",
"861470955", "宁夏中卫市",
"86186844", "上海市",
"86158626", "江苏省苏州市",
"86139246", "广东省深圳市",
"861842023", "广东省河源市",
"861580989", "辽宁省葫芦岛市",
"861354561", "湖北省咸宁市",
"86180600", "福建省泉州市",
"86145314", "天津市",
"861816568", "广东省清远市",
"861829018", "广西钦州市",
"861586062", "福建省漳州市",
"861528051", "福建省南平市",
"861321451", "黑龙江省哈尔滨市",
"861539244", "福建省泉州市",
"86188612", "江苏省常州市",
"86183208", "广东省深圳市",
"861332168", "广西贵港市",
"861776431", "安徽省阜阳市",
"861528897", "山东省青岛市",
"861830742", "湖南省怀化市",
"861773488", "河南省驻马店市",
"861856216", "山东省烟台市",
"861360790", "江西省新余市",
"861525243", "江苏省宿迁市",
"86150577", "浙江省温州市",
"861321565", "安徽省合肥市",
"861774841", "四川省南充市",
"861313297", "广西桂林市",
"86170720", "广东省广州市",
"861811377", "四川省巴中市",
"861508569", "贵州省黔东南苗族侗族自治州",
"861518639", "贵州省黔西南布依族苗族自治州",
"861333934", "黑龙江省双鸭山市",
"861310468", "黑龙江省鹤岗市",
"861830006", "广东省韶关市",
"861596561", "山东省济南市",
"861339304", "河北省石家庄市",
"861384852", "内蒙古包头市",
"861367412", "辽宁省鞍山市",
"86186735", "湖南省郴州市",
"861300522", "广东省汕头市",
"861773342", "河北省秦皇岛市",
"861514756", "内蒙古通辽市",
"861345119", "湖北省荆门市",
"86182584", "浙江省杭州市",
"86137961", "黑龙江省哈尔滨市",
"861524915", "陕西省安康市",
"861550971", "青海省西宁市",
"861896392", "湖北省恩施土家族苗族自治州",
"861500588", "浙江省丽水市",
"861855790", "浙江省金华市",
"861511089", "山西省阳泉市",
"861370575", "浙江省绍兴市",
"861567132", "湖北省襄樊市",
"861318489", "广东省汕尾市",
"861323280", "广东省清远市",
"86132499", "广东省东莞市",
"861810317", "河北省沧州市",
"861345830", "四川省绵阳市",
"861839149", "陕西省铜川市",
"861862599", "河南省洛阳市",
"861309168", "黑龙江省大庆市",
"861860723", "湖北省黄石市",
"861323061", "河北省保定市",
"861571509", "福建省莆田市",
"861454184", "山西省晋中市",
"861771287", "江苏省南京市",
"861816729", "浙江省温州市",
"86180908", "四川省泸州市",
"861812200", "广东省广州市",
"861586494", "山东省聊城市",
"86147455", "广东省广州市",
"86182613", "江苏省连云港市",
"861337939", "陕西省榆林市",
"861770850", "贵州省贵阳市",
"861366486", "内蒙古赤峰市",
"86130585", "广东省东莞市",
"861572392", "广西柳州市",
"861362984", "河南省郑州市",
"861860155", "江苏省无锡市",
"861786626", "湖北省武汉市",
"861590917", "陕西省安康市",
"861459456", "陕西省宝鸡市",
"861872455", "黑龙江省绥化市",
"86186250", "江苏省苏州市",
"861899566", "湖北省襄樊市",
"861566636", "山东省淄博市",
"861819817", "贵州省毕节地区",
"861582996", "陕西省商洛市",
"861560501", "福建省莆田市",
"86183797", "江西省赣州市",
"861537313", "河北省张家口市",
"861500784", "广西梧州市",
"861815682", "安徽省合肥市",
"861324909", "广东省深圳市",
"861768051", "湖南省张家界市",
"861860586", "浙江省台州市",
"86152157", "浙江省丽水市",
"861871957", "甘肃省张掖市",
"861584772", "内蒙古鄂尔多斯市",
"86186303", "河北省秦皇岛市",
"86738", "湖南省娄底市",
"861551318", "山西省忻州市",
"86145047", "辽宁省大连市",
"861863608", "山西省晋中市",
"861508728", "云南省大理白族自治州",
"861303559", "贵州省黔西南布依族苗族自治州",
"861395621", "安徽省芜湖市",
"861802149", "江苏省镇江市",
"861355723", "广西桂林市",
"86185695", "湖南省长沙市",
"861801441", "江苏省连云港市",
"861534660", "湖北省十堰市",
"861363079", "吉林省白山市",
"861373011", "河北省石家庄市",
"861840634", "山东省莱芜市",
"861898857", "广东省中山市",
"861550378", "河南省开封市",
"861302304", "安徽省芜湖市",
"86152051", "江苏省南京市",
"861355155", "四川省雅安市",
"861320595", "福建省泉州市",
"861347513", "山东省威海市",
"861808326", "贵州省黔西南布依族苗族自治州",
"861569884", "辽宁省沈阳市",
"861340004", "江苏省无锡市",
"861315047", "新疆乌鲁木齐市",
"861874978", "河南省焦作市",
"861352371", "河南省郑州市",
"86147636", "山东省济南市",
"861814951", "福建省厦门市",
"861356958", "河南省平顶山市",
"861350913", "陕西省渭南市",
"861387436", "湖南省永州市",
"86185716", "湖北省武汉市",
"861381366", "江苏省常州市",
"861459051", "广东省深圳市",
"861557022", "江西省九江市",
"861367951", "广东省清远市",
"861332890", "福建省三明市",
"861390420", "辽宁省鞍山市",
"86180775", "广西玉林市",
"86136360", "湖北省黄冈市",
"861862842", "陕西省渭南市",
"86155740", "湖南省岳阳市",
"861819929", "新疆昌吉回族自治州",
"861860645", "山东省潍坊市",
"861339581", "浙江省杭州市",
"861580709", "江西省萍乡市",
"86155722", "湖北省随州市",
"861850776", "广西百色市",
"86135825", "河北省唐山市",
"861323466", "黑龙江省哈尔滨市",
"861524562", "黑龙江省佳木斯市",
"861590829", "四川省宜宾市",
"861452754", "湖南省衡阳市",
"861576468", "黑龙江省鹤岗市",
"86158176", "广东省东莞市",
"861779707", "青海省海西蒙古族藏族自治州",
"861835597", "安徽省黄山市",
"861831828", "广东省惠州市",
"86150940", "陕西省西安市",
"86188395", "河南省漯河市",
"861378300", "河南省鹤壁市",
"861337978", "新疆乌鲁木齐市",
"861830937", "甘肃省白银市",
"861509022", "河南省濮阳市",
"86156537", "山东省济宁市",
"86185975", "福建省福州市",
"861811135", "四川省广元市",
"861373416", "山西省吕梁市",
"861338633", "山东省日照市",
"86150922", "山东省青岛市",
"861520453", "黑龙江省牡丹江市",
"861320972", "青海省海东地区",
"861767346", "湖南省岳阳市",
"861323611", "江苏省盐城市",
"861589102", "陕西省榆林市",
"861819964", "新疆阿勒泰地区",
"861471630", "广东省广州市",
"861774903", "陕西省西安市",
"861365776", "广西百色市",
"861818015", "四川省自贡市",
"861590340", "山西省太原市",
"86180916", "陕西省汉中市",
"861821854", "广东省深圳市",
"861313314", "山西省运城市",
"86151562", "安徽省安庆市",
"861538483", "内蒙古阿拉善盟",
"86177539", "山东省临沂市",
"861585807", "浙江省舟山市",
"861331083", "广东省深圳市",
"861535216", "甘肃省张掖市",
"861376360", "黑龙江省牡丹江市",
"861337219", "江苏省常州市",
"861504816", "内蒙古包头市",
"861836183", "江苏省泰州市",
"861572744", "湖南省衡阳市",
"86182160", "湖南省衡阳市",
"861376844", "广西南宁市",
"861525092", "江苏省徐州市",
"861896548", "福建省泉州市",
"861550838", "四川省德阳市",
"861591659", "广东省佛山市",
"861567779", "广西钦州市",
"86151473", "内蒙古乌海市",
"861831329", "云南省普洱市",
"861820669", "广东省揭阳市",
"861590328", "河北省衡水市",
"86152529", "江苏省镇江市",
"861879782", "江西省九江市",
"861302096", "浙江省台州市",
"8614772", "四川省成都市",
"861824269", "辽宁省营口市",
"861829505", "宁夏中卫市",
"861805034", "福建省福州市",
"861312583", "吉林省四平市",
"861458250", "安徽省合肥市",
"861453193", "山西省晋中市",
"861316035", "江苏省宿迁市",
"861810321", "河北省石家庄市",
"861324943", "广东省深圳市",
"861516541", "山东省济南市",
"86147830", "河南省平顶山市",
"861311784", "江西省上饶市",
"86137808", "山东省潍坊市",
"861390448", "吉林省延边朝鲜族自治州",
"861354196", "四川省广元市",
"861831840", "广东省云浮市",
"86177269", "甘肃省兰州市",
"861361892", "西藏日喀则地区",
"861559931", "贵州省安顺市",
"861363854", "贵州省黔南布依族苗族自治州",
"861317271", "广东省惠州市",
"861862489", "河南省安阳市",
"861479281", "安徽省阜阳市",
"861377258", "陕西省咸阳市",
"861760635", "山东省聊城市",
"861556487", "山东省青岛市",
"861386722", "浙江省舟山市",
"861598384", "四川省德阳市",
"861527761", "广西玉林市",
"861571543", "山东省滨州市",
"861312726", "山东省莱芜市",
"861870619", "江苏省无锡市",
"861860671", "浙江省杭州市",
"861533551", "内蒙古包头市",
"861332762", "青海省海东地区",
"861865470", "山东省潍坊市",
"861536862", "云南省西双版纳傣族自治州",
"861800415", "辽宁省丹东市",
"861350233", "广东省梅州市",
"861890583", "浙江省嘉兴市",
"861575692", "四川省雅安市",
"861818704", "云南省德宏傣族景颇族自治州",
"86187100", "北京市",
"861774949", "河南省商丘市",
"861339676", "浙江省台州市",
"861803930", "河南省南阳市",
"86187725", "湖北省黄冈市",
"861709427", "广东省江门市",
"861302491", "福建省宁德市",
"861530596", "福建省漳州市",
"861591149", "云南省丽江市",
"861869357", "甘肃省兰州市",
"861870069", "陕西省铜川市",
"861333397", "河南省信阳市",
"861897873", "广西玉林市",
"861707361", "河南省郑州市",
"861314525", "内蒙古通辽市",
"86155454", "黑龙江省哈尔滨市",
"861521950", "广东省深圳市",
"861592441", "内蒙古呼和浩特市",
"861890960", "安徽省滁州市",
"861301199", "河北省沧州市",
"861801475", "江苏省无锡市",
"861393405", "山西省长治市",
"861511390", "广东省汕头市",
"861813683", "江苏省泰州市",
"861519860", "云南省临沧市",
"86137816", "河南省商丘市",
"861394731", "内蒙古乌海市",
"86156583", "浙江省宁波市",
"861563539", "山西省太原市",
"861334052", "福建省南平市",
"861890726", "湖北省恩施土家族苗族自治州",
"86132868", "广东省广州市",
"861550879", "云南省普洱市",
"86177798", "江西省景德镇市",
"861783529", "山西省吕梁市",
"861453636", "江苏省无锡市",
"861816605", "江西省赣州市",
"861580743", "湖南省湘西土家族苗族自治州",
"86150659", "山东省临沂市",
"861350470", "吉林省长春市",
"861802977", "广东省阳江市",
"861471701", "甘肃省临夏回族自治州",
"861340396", "河南省驻马店市",
"86132811", "四川省成都市",
"861589988", "广东省深圳市",
"861535936", "福建省泉州市",
"861831277", "广东省中山市",
"86132103", "山东省东营市",
"861558010", "湖南省岳阳市",
"861319424", "辽宁省沈阳市",
"861351410", "辽宁省铁岭市",
"86133065", "浙江省台州市",
"861378823", "广西桂林市",
"861596633", "山东省济南市",
"861869563", "福建省厦门市",
"861891244", "江苏省南通市",
"861812448", "广东省河源市",
"861454582", "甘肃省天水市",
"86183019", "上海市",
"861316362", "黑龙江省牡丹江市",
"861388654", "湖北省咸宁市",
"861587624", "广东省河源市",
"861325843", "四川省绵阳市",
"861475247", "江苏省宿迁市",
"861388991", "广东省深圳市",
"861479715", "山西省太原市",
"861367353", "河南省新乡市",
"861351371", "河南省郑州市",
"861453792", "新疆伊犁哈萨克自治州",
"861303085", "福建省莆田市",
"861531499", "浙江省金华市",
"861384930", "河南省濮阳市",
"861338099", "广东省江门市",
"861350311", "河北省石家庄市",
"861569826", "山东省潍坊市",
"861890498", "辽宁省阜新市",
"861835629", "安徽省铜陵市",
"861331890", "广东省云浮市",
"861814353", "贵州省黔东南苗族侗族自治州",
"861473677", "云南省西双版纳傣族自治州",
"861552452", "辽宁省沈阳市",
"861880761", "广东省惠州市",
"861830435", "吉林省通化市",
"861352973", "云南省红河哈尼族彝族自治州",
"861554598", "黑龙江省哈尔滨市",
"86182530", "山东省菏泽市",
"861339360", "广西来宾市",
"861339844", "四川省广元市",
"86134202", "广东省中山市",
"861806196", "江苏省宿迁市",
"861802046", "江苏省盐城市",
"861760458", "黑龙江省伊春市",
"861506548", "山东省泰安市",
"861800328", "河北省衡水市",
"861368443", "四川省遂宁市",
"861361508", "福建省漳州市",
"861561043", "山东省潍坊市",
"861894816", "广东省深圳市",
"861323489", "内蒙古巴彦淖尔市",
"86137533", "山西省吕梁市",
"861452553", "山东省枣庄市",
"861595034", "江苏省盐城市",
"861325781", "广西柳州市",
"861332083", "四川省达州市",
"861336535", "山东省烟台市",
"861868904", "西藏林芝地区",
"861396598", "安徽省滁州市",
"861322912", "广东省中山市",
"86136858", "浙江省宁波市",
"86792", "江西省九江市",
"861367567", "安徽省阜阳市",
"861869605", "湖北省十堰市",
"861452274", "山西省晋中市",
"861811420", "江苏省南通市",
"86139305", "河北省唐山市",
"861589749", "湖南省永州市",
"86135877", "浙江省温州市",
"86135386", "广东省东莞市",
"861807072", "广西南宁市",
"861525248", "江苏省南京市",
"861773483", "河南省三门峡市",
"861592977", "陕西省西安市",
"861572509", "山东省德州市",
"861532944", "贵州省黔南布依族苗族自治州",
"861772287", "广东省广州市",
"861326471", "湖北省武汉市",
"861304570", "浙江省衢州市",
"861770747", "湖南省益阳市",
"861314552", "安徽省蚌埠市",
"861811200", "江苏省徐州市",
"861871561", "安徽省淮北市",
"86180727", "浙江省杭州市",
"861500726", "湖北省荆门市",
"861332163", "广西桂林市",
"861388144", "四川省自贡市",
"861376676", "黑龙江省绥化市",
"861454126", "河北省廊坊市",
"861581996", "广东省中山市",
"861501244", "广东省广州市",
"861860569", "安徽省芜湖市",
"861523678", "河南省焦作市",
"861536446", "湖南省永州市",
"861816563", "广东省中山市",
"861571392", "河南省鹤壁市",
"861842028", "广东省中山市",
"861534836", "湖南省常德市",
"861588580", "贵州省黔东南苗族侗族自治州",
"861520730", "湖南省岳阳市",
"861760312", "河北省保定市",
"861361984", "河南省郑州市",
"86177354", "山西省晋中市",
"86130032", "上海市",
"861587019", "贵州省铜仁地区",
"86186150", "山东省烟台市",
"861839982", "新疆石河子市",
"861871455", "黑龙江省伊春市",
"861854656", "黑龙江省黑河市",
"861325308", "河南省濮阳市",
"861816357", "湖北省襄樊市",
"861820571", "浙江省杭州市",
"861557290", "湖北省武汉市",
"861590415", "辽宁省丹东市",
"86152257", "河南省周口市",
"861529812", "四川省达州市",
"861899589", "湖北省宜昌市",
"86133282", "福建省福州市",
"861500583", "浙江省嘉兴市",
"861389955", "新疆伊犁哈萨克自治州",
"861301304", "安徽省池州市",
"861893374", "广东省河源市",
"861860524", "江苏省镇江市",
"86150044", "吉林省四平市",
"861898740", "云南省曲靖市",
"861366469", "黑龙江省双鸭山市",
"86185927", "陕西省西安市",
"861833347", "河北省邢台市",
"861500960", "宁夏银川市",
"861872638", "安徽省合肥市",
"861898728", "云南省昆明市",
"861301491", "广西南宁市",
"861458770", "湖南省岳阳市",
"861570001", "浙江省衢州市",
"861508091", "湖南省邵阳市",
"861596099", "福建省南平市",
"861778551", "贵州省黔东南苗族侗族自治州",
"861319161", "河北省邢台市",
"861380610", "江苏省镇江市",
"861847635", "广东省深圳市",
"861834778", "内蒙古通辽市",
"861327594", "福建省莆田市",
"861331762", "广西柳州市",
"861315976", "吉林省白城市",
"861888808", "江苏省泰州市",
"861820545", "山东省烟台市",
"861524026", "江苏省淮安市",
"861869764", "安徽省六安市",
"861568800", "贵州省黔南布依族苗族自治州",
"86188188", "广东省广州市",
"861594719", "内蒙古锡林郭勒盟",
"861567259", "湖北省荆州市",
"86137587", "浙江省温州市",
"861580544", "山东省德州市",
"861560262", "广东省惠州市",
"861508857", "浙江省温州市",
"861522950", "陕西省咸阳市",
"861320707", "江西省赣州市",
"861306049", "陕西省宝鸡市",
"861472701", "浙江省金华市",
"861319486", "四川省成都市",
"86133910", "上海市",
"86464", "黑龙江省七台河市",
"861354099", "四川省阿坝藏族羌族自治州",
"86159908", "浙江省丽水市",
"861869729", "青海省西宁市",
"861586903", "浙江省杭州市",
"861870737", "湖南省益阳市",
"861363511", "广西梧州市",
"861317751", "江西省上饶市",
"861822079", "陕西省汉中市",
"861838146", "四川省宜宾市",
"861842040", "广东省东莞市",
"861308613", "江西省上饶市",
"861509566", "甘肃省酒泉市",
"861399408", "山西省忻州市",
"861314154", "湖南省益阳市",
"861555618", "安徽省蚌埠市",
"861351831", "四川省绵阳市",
"861811448", "江苏省南京市",
"861325809", "山东省潍坊市",
"861890784", "广西贺州市",
"861379384", "山东省泰安市",
"861322608", "广东省中山市",
"861308183", "河北省张家口市",
"861533814", "广东省江门市",
"86132203", "重庆市",
"861337805", "湖南省郴州市",
"861555188", "安徽省阜阳市",
"861800917", "陕西省宝鸡市",
"861526536", "山东省潍坊市",
"861551205", "河北省秦皇岛市",
"861377739", "浙江省杭州市",
"861398446", "贵州省铜仁地区",
"861519193", "陕西省渭南市",
"861862466", "辽宁省阜新市",
"861539468", "江苏省盐城市",
"86189922", "陕西省榆林市",
"861556985", "甘肃省白银市",
"86189940", "江苏省南京市",
"8618640", "辽宁省沈阳市",
"861893834", "广东省揭阳市",
"861376581", "贵州省贵阳市",
"861329850", "湖南省岳阳市",
"861323842", "内蒙古呼和浩特市",
"86151804", "江西省南昌市",
"861571744", "湖南省张家界市",
"86182260", "安徽省亳州市",
"86159916", "陕西省西安市",
"861533967", "安徽省宿州市",
"861800340", "山西省太原市",
"86187777", "广西钦州市",
"861800864", "湖北省武汉市",
"861301096", "新疆乌鲁木齐市",
"861317813", "福建省莆田市",
"861801103", "四川省泸州市",
"861345427", "浙江省湖州市",
"861318302", "河南省许昌市",
"861534376", "河南省信阳市",
"861867644", "广东省中山市",
"861362892", "西藏日喀则地区",
"861359919", "福建省宁德市",
"861566792", "陕西省商洛市",
"861824286", "辽宁省阜新市",
"861536075", "广东省茂名市",
"861889521", "宁夏银川市",
"861360695", "福建省漳州市",
"861834739", "内蒙古通辽市",
"861569575", "浙江省绍兴市",
"86151132", "广东省惠州市",
"861351345", "河北省唐山市",
"861817295", "江西省宜春市",
"861397356", "湖南省邵阳市",
"861394985", "河南省漯河市",
"861785890", "浙江省丽水市",
"86156018", "上海市",
"861598326", "四川省内江市",
"861368377", "河南省南阳市",
"861831757", "河南省新乡市",
"861593210", "河北省邯郸市",
"861310244", "河北省沧州市",
"861335547", "山东省济宁市",
"861815851", "浙江省杭州市",
"861800829", "四川省攀枝花市",
"86184839", "四川省广元市",
"861318627", "陕西省安康市",
"861311726", "湖北省随州市",
"861559333", "甘肃省平凉市",
"861572543", "山东省滨州市",
"861884559", "黑龙江省哈尔滨市",
"86139872", "云南省大理白族自治州",
"861861489", "内蒙古巴彦淖尔市",
"86137263", "广东省佛山市",
"86156421", "辽宁省朝阳市",
"86159775", "广西玉林市",
"861477071", "江西省南昌市",
"861324341", "河南省鹤壁市",
"861881537", "山东省济宁市",
"861319081", "内蒙古鄂尔多斯市",
"861591702", "广东省佛山市",
"861589703", "青海省黄南藏族自治州",
"861779595", "陕西省西安市",
"861866929", "云南省德宏傣族景颇族自治州",
"861835705", "浙江省衢州市",
"861577120", "内蒙古巴彦淖尔市",
"861529494", "河南省驻马店市",
"861815228", "甘肃省庆阳市",
"861328040", "山东省滨州市",
"861520909", "新疆博尔塔拉蒙古自治州",
"861592951", "陕西省安康市",
"861304784", "广西贵港市",
"86151985", "云南省昭通市",
"86189095", "宁夏银川市",
"861780581", "浙江省杭州市",
"86158552", "安徽省六安市",
"861318753", "云南省保山市",
"861335066", "四川省南充市",
"861863348", "河北省石家庄市",
"861815408", "安徽省黄山市",
"86188913", "陕西省渭南市",
"861394917", "河南省信阳市",
"861321849", "江苏省南京市",
"861534804", "甘肃省临夏回族自治州",
"86176926", "河北省廊坊市",
"86137456", "黑龙江省黑河市",
"861831623", "广东省肇庆市",
"861583340", "河北省邯郸市",
"861809628", "四川省凉山彝族自治州",
"861588774", "云南省红河哈尼族彝族自治州",
"861340810", "四川省绵阳市",
"861535493", "内蒙古鄂尔多斯市",
"861889495", "河北省沧州市",
"861895486", "山东省泰安市",
"861809432", "江苏省盐城市",
"861302644", "陕西省宝鸡市",
"861318125", "山东省枣庄市",
"86155814", "湖南省永州市",
"861595401", "山东省日照市",
"861827210", "湖北省孝感市",
"861805653", "安徽省芜湖市",
"861870313", "河北省张家口市",
"861777553", "四川省广安市",
"861338838", "四川省宜宾市",
"861855197", "江苏省南京市",
"861820557", "安徽省宿州市",
"861862919", "陕西省西安市",
"861321320", "河南省郑州市",
"861359181", "辽宁省大连市",
"86159881", "浙江省杭州市",
"86182375", "河南省平顶山市",
"861458182", "浙江省湖州市",
"861838587", "贵州省铜仁地区",
"86183756", "重庆市",
"861899976", "新疆博尔塔拉蒙古自治州",
"861301336", "云南省大理白族自治州",
"861866621", "广东省深圳市",
"861371995", "广东省梅州市",
"861863482", "山西省运城市",
"861458612", "湖北省荆门市",
"861383420", "山西省太原市",
"861380772", "广西柳州市",
"861813389", "河北省张家口市",
"861596054", "福建省莆田市",
"861776610", "江苏省南京市",
"861320562", "安徽省铜陵市",
"861556340", "山东省莱芜市",
"861513500", "山西省忻州市",
"861331070", "贵州省毕节地区",
"861538470", "内蒙古呼伦贝尔市",
"861335555", "安徽省马鞍山市",
"861760789", "广西南宁市",
"861354339", "广东省茂名市",
"861850520", "江苏省常州市",
"861323758", "江西省景德镇市",
"861338879", "云南省普洱市",
"861576756", "广东省清远市",
"861573898", "河南省洛阳市",
"861351357", "山西省临汾市",
"861337568", "山东省临沂市",
"861528529", "贵州省黔东南苗族侗族自治州",
"861327559", "安徽省黄山市",
"86131295", "广东省深圳市",
"86185437", "吉林省辽源市",
"861567294", "湖北省十堰市",
"86156320", "河北省邯郸市",
"861779026", "四川省成都市",
"86155865", "湖北省黄石市",
"861330010", "北京市",
"86147790", "广东省广州市",
"861387286", "湖北省随州市",
"861302154", "山东省潍坊市",
"861800985", "辽宁省盘锦市",
"861478073", "四川省南充市",
"861819574", "青海省海南藏族自治州",
"86183883", "云南省曲靖市",
"86156342", "山东省青岛市",
"86137635", "黑龙江省齐齐哈尔市",
"861867199", "湖北省荆门市",
"861394340", "吉林省通化市",
"861805143", "江苏省扬州市",
"861596339", "山东省德州市",
"86134860", "浙江省宁波市",
"861863803", "河南省郑州市",
"861394864", "内蒙古赤峰市",
"861365520", "江苏省徐州市",
"861874568", "黑龙江省哈尔滨市",
"861528564", "贵州省贵阳市",
"861348038", "广东省汕尾市",
"861847137", "湖北省恩施土家族苗族自治州",
"861769612", "山西省朔州市",
"861333724", "湖南省张家界市",
"861367475", "内蒙古呼和浩特市",
"861370512", "江苏省连云港市",
"861346932", "湖南省怀化市",
"861390958", "宁夏银川市",
"861315022", "新疆塔城地区",
"861301525", "内蒙古包头市",
"861524972", "河南省新乡市",
"861869410", "甘肃省甘南藏族自治州",
"861341118", "广东省广州市",
"861818692", "湖北省武汉市",
"861314199", "江苏省泰州市",
"861335186", "黑龙江省佳木斯市",
"861575704", "浙江省杭州市",
"861318811", "辽宁省锦州市",
"861555245", "山东省烟台市",
"861351563", "安徽省宣城市",
"861537619", "山东省济南市",
"861518905", "江苏省宿迁市",
"861301876", "广东省中山市",
"861510336", "河北省廊坊市",
"861358260", "河北省邯郸市",
"86134666", "北京市",
"861871833", "广东省河源市",
"861370684", "浙江省宁波市",
"861313537", "湖南省益阳市",
"861810779", "广西北海市",
"861367441", "吉林省吉林市",
"861303667", "四川省成都市",
"861859926", "新疆巴音郭楞蒙古自治州",
"861362414", "辽宁省本溪市",
"86182802", "四川省成都市",
"861350802", "四川省德阳市",
"861590487", "内蒙古呼和浩特市",
"86132569", "山东省烟台市",
"861570434", "吉林省四平市",
"861768946", "福建省厦门市",
"861814441", "广东省潮州市",
"861531530", "山东省菏泽市",
"861555271", "山东省滨州市",
"861354838", "四川省阿坝藏族羌族自治州",
"861848912", "西藏日喀则地区",
"861780676", "广东省河源市",
"861366916", "陕西省汉中市",
"861348854", "内蒙古呼和浩特市",
"861573399", "河北省唐山市",
"861303793", "宁夏吴忠市",
"861390637", "山东省枣庄市",
"861338378", "河南省开封市",
"861861758", "河北省邯郸市",
"861377900", "新疆吐鲁番地区",
"861365548", "山东省泰安市",
"861843493", "山西省运城市",
"86182134", "云南省昆明市",
"861312570", "吉林省长春市",
"861819172", "陕西省渭南市",
"861304498", "江西省景德镇市",
"861585289", "江苏省扬州市",
"861356382", "山东省泰安市",
"861332316", "河北省廊坊市",
"861815877", "浙江省温州市",
"861850548", "山东省泰安市",
"861517671", "河北省唐山市",
"861458908", "广东省韶关市",
"861774812", "四川省攀枝花市",
"861525556", "安徽省合肥市",
"861569467", "云南省玉溪市",
"861347460", "陕西省咸阳市",
"861875098", "福建省南平市",
"861830711", "湖北省鄂州市",
"86153271", "湖北省武汉市",
"86133681", "重庆市",
"861362072", "吉林省吉林市",
"861520943", "甘肃省白银市",
"861329722", "湖北省黄石市",
"861536895", "云南省德宏傣族景颇族自治州",
"861332795", "江苏省徐州市",
"861369716", "湖北省荆州市",
"861872945", "陕西省安康市",
"861802567", "广东省中山市",
"861830853", "贵州省安顺市",
"861590731", "湖南省长沙市",
"861550633", "山东省日照市",
"86147815", "四川省内江市",
"861505469", "山东省菏泽市",
"861814046", "四川省眉山市",
"861510525", "江苏省扬州市",
"861384881", "内蒙古呼和浩特市",
"86187862", "贵州省遵义市",
"86189273", "广东省惠州市",
"861539276", "湖北省荆州市",
"861388699", "湖北省武汉市",
"86137509", "浙江省金华市",
"861383448", "山西省运城市",
"861816345", "广东省东莞市",
"861334596", "浙江省宁波市",
"861315589", "江西省抚州市",
"861828883", "云南省迪庆藏族自治州",
"861586641", "山东省临沂市",
"86457", "黑龙江省大兴安岭地区",
"86177086", "广东省佛山市",
"861350483", "黑龙江省牡丹江市",
"86156931", "甘肃省兰州市",
"861369395", "河南省漯河市",
"861474560", "黑龙江省黑河市",
"861570550", "安徽省滁州市",
"861338054", "广东省佛山市",
"861389947", "新疆和田地区",
"861321348", "河南省濮阳市",
"861863849", "河南省信阳市",
"861856726", "河南省南阳市",
"861805109", "江苏省苏州市",
"861769908", "新疆克孜勒苏柯尔克孜自治州",
"861367702", "江西省九江市",
"861770755", "广东省深圳市",
"861809640", "安徽省合肥市",
"861538913", "陕西省渭南市",
"86183837", "四川省阿坝藏族羌族自治州",
"861583328", "河北省衡水市",
"861527267", "湖北省咸宁市",
"86136175", "海南省海口市",
"86152828", "四川省德阳市",
"86186554", "安徽省淮南市",
"861813670", "江苏省常州市",
"861801951", "安徽省芜湖市",
"861810738", "湖南省娄底市",
"861528082", "福建省龙岩市",
"86189432", "吉林省吉林市",
"861321482", "内蒙古兴安盟",
"861856960", "湖南省长沙市",
"861317777", "江西省南昌市",
"861763338", "河北省衡水市",
"861479787", "江西省赣州市",
"861527058", "江西省九江市",
"861529301", "甘肃省临夏回族自治州",
"861338339", "河北省邢台市",
"861303017", "广东省湛江市",
"861815240", "宁夏中卫市",
"861871447", "黑龙江省双鸭山市",
"861787845", "广西南宁市",
"861822899", "四川省泸州市",
"86153025", "广东省揭阳市",
"86134601", "河南省商丘市",
"861577148", "内蒙古巴彦淖尔市",
"861519604", "四川省自贡市",
"861521632", "山东省枣庄市",
"861890570", "浙江省衢州市",
"861450528", "吉林省辽源市",
"861865483", "山东省枣庄市",
"861479036", "安徽省合肥市",
"861521796", "广东省深圳市",
"861325158", "黑龙江省伊春市",
"861853013", "河南省开封市",
"861760920", "陕西省咸阳市",
"861335169", "黑龙江省大庆市",
"861779084", "辽宁省大连市",
"861528697", "河南省安阳市",
"861816107", "四川省宜宾市",
"861348176", "广西柳州市",
"861580930", "甘肃省临夏回族自治州",
"861588254", "四川省遂宁市",
"86134358", "广东省肇庆市",
"861332070", "四川省内江市",
"861459077", "广东省揭阳市",
"861593142", "河北省石家庄市",
"861351764", "广西梧州市",
"86184799", "江西省萍乡市",
"861520375", "河南省平顶山市",
"861832745", "湖北省黄冈市",
"861835800", "浙江省金华市",
"861529949", "新疆乌鲁木齐市",
"861301154", "河北省邯郸市",
"86132139", "河南省濮阳市",
"861860938", "甘肃省天水市",
"861303192", "河北省邢台市",
"861523873", "河南省焦作市",
"86131195", "广东省广州市",
"861528763", "云南省德宏傣族景颇族自治州",
"861880374", "河南省许昌市",
"861342247", "广东省汕头市",
"861317902", "吉林省四平市",
"861333523", "山东省淄博市",
"861332507", "山东省临沂市",
"861886663", "山东省淄博市",
"861380252", "广东省广州市",
"86137981", "广东省广州市",
"861804382", "吉林省吉林市",
"861329755", "湖北省孝感市",
"861561532", "山东省青岛市",
"861823072", "贵州省黔东南苗族侗族自治州",
"861597760", "广西百色市",
"861335124", "黑龙江省七台河市",
"861571365", "河南省驻马店市",
"861352980", "云南省红河哈尼族彝族自治州",
"861308319", "安徽省合肥市",
"861803743", "河南省驻马店市",
"861565146", "江苏省徐州市",
"86182327", "河北省沧州市",
"861772843", "广东省汕头市",
"861329123", "江苏省无锡市",
"861760766", "广东省云浮市",
"861869831", "福建省漳州市",
"861345889", "四川省内江市",
"861352563", "河南省濮阳市",
"861318430", "浙江省宁波市",
"861355938", "福建省莆田市",
"861384652", "黑龙江省黑河市",
"861302525", "广东省汕尾市",
"861319916", "黑龙江省鸡西市",
"86182564", "安徽省六安市",
"861508933", "广东省惠州市",
"86157719", "陕西省西安市",
"861333786", "江苏省连云港市",
"861769875", "河南省信阳市",
"861708557", "安徽省阜阳市",
"861315290", "山西省忻州市",
"861325648", "山东省烟台市",
"861322849", "四川省遂宁市",
"86150432", "吉林省吉林市",
"861880267", "广东省深圳市",
"861820961", "宁夏银川市",
"861522440", "山东省潍坊市",
"861389471", "吉林省吉林市",
"861566604", "山东省聊城市",
"861773233", "河北省唐山市",
"861500570", "浙江省衢州市",
"861304726", "湖南省常德市",
"861323278", "广东省河源市",
"86136559", "福建省泉州市",
"861510552", "安徽省蚌埠市",
"861399514", "宁夏固原市",
"861507639", "河北省保定市",
"861328791", "山东省菏泽市",
"861517569", "河北省廊坊市",
"861833607", "河南省新乡市",
"861772437", "广东省河源市",
"861768077", "湖南省邵阳市",
"861845000", "福建省厦门市",
"861834546", "黑龙江省佳木斯市",
"861811958", "安徽省宿州市",
"86130683", "重庆市",
"86150273", "湖北省武汉市",
"861304960", "广东省河源市",
"861869345", "甘肃省武威市",
"861322320", "河北省保定市",
"861700775", "广东省珠海市",
"861829868", "甘肃省白银市",
"861363899", "西藏拉萨市",
"86136093", "甘肃省兰州市",
"861559639", "陕西省商洛市",
"861453765", "广西河池市",
"861800731", "湖南省长沙市",
"861898871", "广东省东莞市",
"861559880", "内蒙古鄂尔多斯市",
"861893761", "河南省信阳市",
"861875242", "江苏省淮安市",
"861595109", "江苏省宿迁市",
"86159449", "吉林省白山市",
"861806879", "江苏省常州市",
"861773470", "河南省商丘市",
"86151631", "山东省威海市",
"861816973", "广西贵港市",
"861860979", "青海省海西蒙古族藏族自治州",
"861870911", "陕西省延安市",
"86187504", "福建省泉州市",
"861568705", "云南省昆明市",
"861770722", "湖北省随州市",
"861318152", "山东省烟台市",
"861300030", "江苏省南京市",
"861537086", "江苏省无锡市",
"861373969", "河北省邢台市",
"861308170", "辽宁省营口市",
"861871945", "广东省深圳市",
"861805401", "安徽省芜湖市",
"86136406", "广东省广州市",
"861818736", "云南省红河哈尼族彝族自治州",
"861869371", "甘肃省酒泉市",
"861555751", "浙江省绍兴市",
"861537737", "湖南省益阳市",
"861317618", "山东省济宁市",
"861360662", "浙江省杭州市",
"861452799", "新疆伊犁哈萨克自治州",
"861359842", "河南省郑州市",
"86576", "浙江省台州市",
"86184538", "山东省泰安市",
"86181706", "江西省吉安市",
"861458526", "河南省鹤壁市",
"861317188", "河北省石家庄市",
"861479178", "陕西省咸阳市",
"861532454", "安徽省黄山市",
"861806378", "福建省龙岩市",
"861880834", "四川省凉山彝族自治州",
"861322482", "内蒙古兴安盟",
"861315566", "安徽省池州市",
"861529903", "新疆伊犁哈萨克自治州",
"86156685", "辽宁省抚顺市",
"86136275", "海南省海口市",
"861325620", "山东省菏泽市",
"861508213", "四川省资阳市",
"861505486", "山东省济宁市",
"861323919", "陕西省铜川市",
"861828090", "四川省内江市",
"861855662", "黑龙江省佳木斯市",
"861700883", "广东省广州市",
"861860147", "江苏省无锡市",
"861535904", "福建省莆田市",
"861538311", "河北省石家庄市",
"861872447", "黑龙江省齐齐哈尔市",
"861829369", "甘肃省天水市",
"861363398", "河南省三门峡市",
"861821899", "广东省惠州市",
"861761423", "辽宁省抚顺市",
"861458783", "湖南省永州市",
"861568014", "四川省绵阳市",
"861392259", "广东省韶关市",
"861586459", "山东省潍坊市",
"861361414", "辽宁省本溪市",
"861351605", "辽宁省大连市",
"861535588", "浙江省宁波市",
"861885126", "江苏省淮安市",
"861318642", "江苏省南京市",
"861839412", "甘肃省甘南藏族自治州",
"861595143", "江苏省扬州市",
"861569965", "黑龙江省大庆市",
"861337631", "山东省威海市",
"861302876", "甘肃省定西市",
"86185521", "江苏省无锡市",
"861320421", "辽宁省朝阳市",
"861380907", "江苏省常州市",
"861367149", "广东省湛江市",
"861314304", "河北省石家庄市",
"861812719", "广东省云浮市",
"861458335", "江西省赣州市",
"861470732", "湖南省湘潭市",
"861858546", "贵州省黔东南苗族侗族自治州",
"861769841", "河南省南阳市",
"86130637", "江苏省苏州市",
"861360474", "内蒙古呼伦贝尔市",
"861537481", "内蒙古兴安盟",
"86135950", "贵州省贵阳市",
"861816410", "湖北省武汉市",
"861773913", "河南省安阳市",
"86563", "安徽省宣城市",
"861331316", "河北省廊坊市",
"86136021", "天津市",
"86145298", "广东省东莞市",
"861393180", "河北省衡水市",
"861317068", "云南省红河哈尼族彝族自治州",
"861520341", "山西省太原市",
"86181718", "湖北省咸宁市",
"861518338", "四川省乐山市",
"861700402", "广东省广州市",
"86130750", "安徽省阜阳市",
"861303594", "云南省德宏傣族景颇族自治州",
"861311570", "浙江省衢州市",
"861837226", "湖北省襄樊市",
"861505081", "江苏省淮安市",
"861360012", "广东省潮州市",
"861315055", "云南省曲靖市",
"861804200", "浙江省杭州市",
"861301552", "河南省郑州市",
"86170002", "广东省广州市",
"86181761", "广西河池市",
"861510644", "山东省烟台市",
"861874631", "黑龙江省牡丹江市",
"861479139", "陕西省榆林市",
"861590985", "辽宁省大连市",
"86136418", "上海市",
"861847801", "湖南省衡阳市",
"861310510", "山东省日照市",
"861317257", "广东省潮州市",
"861518227", "四川省乐山市",
"861824436", "四川省泸州市",
"861760948", "甘肃省嘉峪关市",
"861331795", "江西省宜春市",
"861866574", "广东省广州市",
"861800600", "福建省厦门市",
"86136127", "广东省东莞市",
"861330376", "河南省信阳市",
"861899047", "四川省甘孜藏族自治州",
"861323827", "辽宁省营口市",
"861308818", "四川省德阳市",
"861533577", "湖北省随州市",
"861537166", "江苏省连云港市",
"861819885", "广东省广州市",
"861564695", "新疆阿克苏地区",
"861860657", "浙江省金华市",
"861828886", "云南省丽江市",
"861380038", "山西省忻州市",
"861334593", "浙江省金华市",
"861350486", "黑龙江省鸡西市",
"861532978", "贵州省六盘水市",
"861840451", "黑龙江省哈尔滨市",
"861471531", "广东省韶关市",
"861872010", "江西省赣州市",
"861808629", "湖北省武汉市",
"861310827", "四川省巴中市",
"861452248", "浙江省金华市",
"861893482", "广西桂林市",
"861575940", "福建省福州市",
"861856723", "河南省鹤壁市",
"861305099", "辽宁省葫芦岛市",
"861896621", "浙江省宁波市",
"86138060", "福建省厦门市",
"86133326", "广东省东莞市",
"861369713", "湖北省孝感市",
"861509371", "河南省焦作市",
"861830856", "贵州省铜仁地区",
"86135595", "福建省泉州市",
"861376905", "云南省保山市",
"861550636", "山东省潍坊市",
"861840565", "安徽省合肥市",
"861561567", "山东省济宁市",
"86138420", "辽宁省沈阳市",
"861513341", "河北省张家口市",
"861556501", "河南省商丘市",
"861595049", "江苏省南京市",
"861333062", "四川省广安市",
"861539273", "湖北省荆州市",
"861814043", "四川省凉山彝族自治州",
"86138442", "吉林省吉林市",
"86156881", "河南省南阳市",
"861458769", "广东省东莞市",
"86176028", "四川省成都市",
"861312305", "福建省三明市",
"86187510", "江苏省宿迁市",
"861523644", "河南省信阳市",
"861874499", "贵州省黔西南布依族苗族自治州",
"861786277", "山东省枣庄市",
"861452687", "陕西省西安市",
"861500147", "新疆喀什地区",
"861339680", "浙江省舟山市",
"86132513", "重庆市",
"861865486", "山东省潍坊市",
"861552088", "四川省南充市",
"861479033", "安徽省六安市",
"861562951", "湖北省十堰市",
"861311938", "甘肃省天水市",
"861843857", "河南省洛阳市",
"861539430", "浙江省宁波市",
"861555030", "山东省淄博市",
"86180685", "江苏省常州市",
"86158434", "吉林省四平市",
"861538916", "陕西省汉中市",
"86152541", "山东省济南市",
"861822060", "陕西省咸阳市",
"861510785", "广西玉林市",
"861705767", "上海市",
"861364917", "陕西省宝鸡市",
"861339839", "四川省绵阳市",
"861893348", "广东省潮州市",
"861454747", "浙江省温州市",
"861761484", "内蒙古乌兰察布市",
"861300751", "河南省郑州市",
"861313421", "辽宁省朝阳市",
"861768943", "福建省福州市",
"861899410", "江苏省南京市",
"86139334", "河北省唐山市",
"861534561", "安徽省淮北市",
"861310919", "陕西省汉中市",
"861822610", "安徽省亳州市",
"861890305", "广东省广州市",
"861780673", "广东省梅州市",
"861366913", "陕西省西安市",
"86181193", "甘肃省兰州市",
"861303796", "宁夏银川市",
"861306858", "广东省河源市",
"861329582", "浙江省湖州市",
"861852408", "辽宁省朝阳市",
"861328235", "浙江省舟山市",
"861534455", "黑龙江省绥化市",
"861301873", "广东省中山市",
"861510333", "河北省张家口市",
"861871836", "广东省肇庆市",
"861879547", "江苏省盐城市",
"861897199", "湖北省鄂州市",
"861339878", "云南省楚雄彝族自治州",
"861364340", "山西省长治市",
"861809965", "新疆和田地区",
"861343862", "四川省广安市",
"86150339", "河北省唐山市",
"861450301", "河北省廊坊市",
"861859923", "新疆石河子市",
"861303315", "安徽省铜陵市",
"861311979", "青海省海西蒙古族藏族自治州",
"86151450", "黑龙江省哈尔滨市",
"861500657", "山东省济宁市",
"861525553", "安徽省马鞍山市",
"861812197", "四川省泸州市",
"861816047", "新疆昌吉回族自治州",
"861589734", "湖南省衡阳市",
"861369851", "贵州省安顺市",
"861520946", "甘肃省金昌市",
"861560600", "福建省厦门市",
"86159342", "山西省大同市",
"861331911", "陕西省延安市",
"861532939", "贵州省黔西南布依族苗族自治州",
"861504068", "辽宁省本溪市",
"861593002", "河北省邯郸市",
"861380079", "江西省新余市",
"861872660", "安徽省阜阳市",
"861865081", "福建省厦门市",
"861588419", "四川省泸州市",
"861582031", "广东省汕尾市",
"861566054", "河南省新乡市",
"861878425", "四川省巴中市",
"861330971", "青海省西宁市",
"861858744", "广西贺州市",
"861453838", "四川省广元市",
"861539554", "安徽省淮南市",
"86188003", "上海市",
"861332313", "河北省张家口市",
"86188817", "四川省南充市",
"861336597", "福建省泉州市",
"861533128", "山东省济南市",
"861339379", "河南省平顶山市",
"861599467", "广西桂林市",
"861362738", "湖南省娄底市",
"861522667", "河北省廊坊市",
"86139227", "广东省广州市",
"861779023", "四川省乐山市",
"861571778", "广西河池市",
"861500938", "甘肃省天水市",
"861387283", "湖北省十堰市",
"861533140", "云南省文山壮族苗族自治州",
"861478076", "四川省广元市",
"861576125", "贵州省黔东南苗族侗族自治州",
"861760564", "安徽省六安市",
"861352589", "河南省三门峡市",
"86183933", "甘肃省天水市",
"861365780", "广西柳州市",
"861899107", "陕西省榆林市",
"86183390", "河南省许昌市",
"861597321", "湖南省湘潭市",
"861576753", "广东省江门市",
"861557831", "广西南宁市",
"861333584", "浙江省宁波市",
"861306359", "江苏省南通市",
"86188496", "云南省大理白族自治州",
"861535091", "辽宁省锦州市",
"861330945", "甘肃省金昌市",
"861364328", "河北省沧州市",
"861775267", "湖南省邵阳市",
"861453339", "浙江省衢州市",
"861529540", "江苏省无锡市",
"861310278", "河北省衡水市",
"861370251", "广东省中山市",
"861335183", "黑龙江省牡丹江市",
"86188969", "江苏省苏州市",
"861450494", "辽宁省丹东市",
"861530759", "广东省湛江市",
"861771521", "江苏省盐城市",
"861360637", "山东省济南市",
"861520768", "广东省潮州市",
"861351566", "安徽省合肥市",
"861505598", "安徽省黄山市",
"861805146", "江苏省徐州市",
"861364237", "广东省东莞市",
"861775058", "福建省厦门市",
"861587670", "广东省梅州市",
"861760529", "江苏省常州市",
"861850780", "广西崇左市",
"861881595", "福建省泉州市",
"861863806", "河南省周口市",
"861560487", "黑龙江省鸡西市",
"861306034", "陕西省咸阳市",
"861572187", "云南省昆明市",
"861580539", "山东省临沂市",
"861344299", "新疆塔城地区",
"861328915", "陕西省安康市",
"861831626", "广东省云浮市",
"861343790", "江西省南昌市",
"86152899", "海南省海口市",
"861559096", "黑龙江省鹤岗市",
"861867639", "广东省深圳市",
"861587888", "广西玉林市",
"861535496", "内蒙古包头市",
"861700368", "广东省东莞市",
"861572067", "江苏省苏州市",
"861316514", "山东省济南市",
"861895483", "山东省青岛市",
"861472668", "四川省达州市",
"861329064", "河北省唐山市",
"861315605", "山东省青岛市",
"861379472", "广东省河源市",
"861853830", "河南省郑州市",
"861847697", "广东省湛江市",
"861893320", "广东省珠海市",
"861860570", "浙江省衢州市",
"861777615", "广西玉林市",
"861818132", "四川省凉山彝族自治州",
"86136767", "浙江省温州市",
"861580578", "浙江省丽水市",
"861309425", "湖北省武汉市",
"86189554", "安徽省淮南市",
"861810072", "湖北省武汉市",
"861478471", "内蒙古呼和浩特市",
"861708389", "河南省濮阳市",
"861516640", "山东省济宁市",
"86155347", "山西省临汾市",
"86186432", "吉林省吉林市",
"861348405", "浙江省金华市",
"861322761", "湖北省十堰市",
"861335063", "四川省南充市",
"861837141", "湖北省黄石市",
"86181027", "广东省广州市",
"861318756", "云南省德宏傣族景颇族自治州",
"861333908", "安徽省蚌埠市",
"861870795", "江西省宜春市",
"861808705", "云南省昆明市",
"861366470", "内蒙古呼伦贝尔市",
"861532219", "广东省湛江市",
"861375982", "陕西省咸阳市",
"861500979", "青海省海西蒙古族藏族自治州",
"86151744", "湖南省张家界市",
"861899973", "新疆石河子市",
"86159931", "河南省南阳市",
"861810414", "辽宁省本溪市",
"861301333", "云南省昆明市",
"861571739", "湖南省邵阳市",
"861576811", "广东省深圳市",
"861566879", "辽宁省葫芦岛市",
"861397046", "江西省吉安市",
"861362779", "广西北海市",
"861329029", "山东省济南市",
"861893849", "广东省云浮市",
"861339338", "河北省沧州市",
"861308547", "湖南省怀化市",
"861560731", "湖南省长沙市",
"861776899", "江苏省连云港市",
"861378965", "内蒙古通辽市",
"86147356", "山西省晋城市",
"861870316", "河北省廊坊市",
"861805656", "安徽省马鞍山市",
"861777556", "四川省成都市",
"861558561", "吉林省松原市",
"861339407", "福建省泉州市",
"861768909", "西藏拉萨市",
"86158578", "浙江省丽水市",
"861811474", "江苏省苏州市",
"861880912", "陕西省榆林市",
"861302931", "辽宁省营口市",
"86181293", "新疆乌鲁木齐市",
"861859321", "广西玉林市",
"861858543", "贵州省贵阳市",
"86145713", "上海市",
"861381545", "江苏省淮安市",
"86132757", "安徽省安庆市",
"861802134", "江苏省苏州市",
"861510931", "甘肃省兰州市",
"861534380", "河南省郑州市",
"861528948", "陕西省西安市",
"86187633", "山东省日照市",
"861773916", "河南省焦作市",
"86133885", "浙江省温州市",
"861576152", "贵州省六盘水市",
"861840649", "山西省运城市",
"861881707", "湖南省常德市",
"861885123", "江苏省常州市",
"861539125", "内蒙古鄂尔多斯市",
"861595146", "江苏省徐州市",
"861366311", "河北省石家庄市",
"861302873", "甘肃省白银市",
"86152624", "江苏省苏州市",
"861558679", "湖北省咸宁市",
"86185848", "四川省成都市",
"861846952", "云南省文山壮族苗族自治州",
"861890938", "甘肃省天水市",
"861300271", "山东省淄博市",
"861531939", "陕西省延安市",
"861589027", "河南省三门峡市",
"861332911", "安徽省淮北市",
"861824433", "四川省乐山市",
"861889158", "陕西省咸阳市",
"861330373", "河南省新乡市",
"861337944", "陕西省渭南市",
"861809467", "浙江省绍兴市",
"861335782", "江苏省南京市",
"861478310", "河南省三门峡市",
"861537163", "江苏省徐州市",
"861584899", "内蒙古赤峰市",
"861830995", "新疆吐鲁番地区",
"86184728", "湖南省长沙市",
"861534957", "宁夏吴忠市",
"861705078", "浙江省宁波市",
"861509107", "陕西省宝鸡市",
"861331313", "河北省张家口市",
"861309318", "江苏省常州市",
"86188586", "浙江省台州市",
"861301211", "河北省邯郸市",
"861569150", "陕西省宝鸡市",
"861388431", "浙江省舟山市",
"861803968", "河南省南阳市",
"86134805", "广东省惠州市",
"861565109", "江苏省宿迁市",
"86130396", "黑龙江省佳木斯市",
"861778128", "四川省南充市",
"861346967", "宁夏中卫市",
"861829981", "新疆巴音郭楞蒙古自治州",
"861364415", "辽宁省丹东市",
"861315357", "山东省威海市",
"861319470", "四川省雅安市",
"861768835", "广东省阳江市",
"86180931", "甘肃省兰州市",
"861374882", "黑龙江省牡丹江市",
"861309452", "四川省巴中市",
"861890979", "青海省海西蒙古族藏族自治州",
"861303440", "湖北省黄石市",
"861459341", "四川省乐山市",
"861458523", "河南省焦作市",
"861530918", "陕西省商洛市",
"861350424", "辽宁省大连市",
"861817415", "广西桂林市",
"861370745", "湖南省怀化市",
"861336472", "新疆阿克苏地区",
"861593490", "内蒙古鄂尔多斯市",
"861537083", "江苏省南通市",
"861311305", "广东省东莞市",
"86187370", "河南省商丘市",
"861576642", "广东省惠州市",
"861847162", "湖北省宜昌市",
"861818733", "云南省红河哈尼族彝族自治州",
"861393899", "河南省南阳市",
"86138915", "陕西省安康市",
"861508216", "四川省绵阳市",
"861336014", "广东省中山市",
"861369514", "广东省揭阳市",
"861376227", "湖南省株洲市",
"861570959", "宁夏银川市",
"861505483", "山东省潍坊市",
"861315980", "黑龙江省哈尔滨市",
"861596604", "山东省泰安市",
"861700886", "广东省深圳市",
"861761426", "辽宁省大连市",
"861458786", "湖南省衡阳市",
"86135122", "天津市",
"861558638", "湖北省襄樊市",
"861334794", "江苏省徐州市",
"86147611", "江苏省常州市",
"861315563", "安徽省宣城市",
"861388787", "云南省德宏傣族景颇族自治州",
"86138776", "广西百色市",
"861320537", "山东省济宁市",
"861350469", "黑龙江省佳木斯市",
"861357452", "湖南省郴州市",
"86150554", "安徽省安庆市",
"86185731", "湖南省长沙市",
"861705354", "福建省厦门市",
"861770614", "江苏省常州市",
"861550344", "山西省太原市",
"861561694", "湖南省娄底市",
"861450177", "山西省晋中市",
"861830572", "浙江省湖州市",
"861347647", "湖北省鄂州市",
"86155800", "湖南省长沙市",
"861529906", "新疆乌鲁木齐市",
"861473001", "河北省邯郸市",
"861582518", "云南省红河哈尼族彝族自治州",
"861825445", "山东省枣庄市",
"861773236", "河北省张家口市",
"861856122", "山东省东营市",
"861567892", "广西南宁市",
"861569432", "吉林省吉林市",
"861847529", "广东省阳江市",
"861304723", "湖南省株洲市",
"861853411", "山西省长治市",
"861354765", "四川省眉山市",
"861339905", "新疆阿克苏地区",
"861837449", "湖南省长沙市",
"861393398", "河北省沧州市",
"861477322", "湖南省湘潭市",
"861515942", "福建省宁德市",
"861345190", "江苏省南京市",
"861890147", "江苏省南通市",
"86181221", "广东省广州市",
"86137748", "福建省泉州市",
"861770582", "浙江省湖州市",
"861514181", "辽宁省阜新市",
"861503348", "河北省唐山市",
"861831684", "广东省河源市",
"861321761", "广东省河源市",
"861365817", "四川省德阳市",
"861889620", "云南省临沧市",
"86159685", "浙江省绍兴市",
"861514611", "黑龙江省哈尔滨市",
"86139275", "广东省茂名市",
"86155606", "内蒙古乌兰察布市",
"861862510", "江苏省苏州市",
"861847564", "广东省茂名市",
"861371711", "广东省深圳市",
"861361779", "广西北海市",
"861598629", "广东省阳江市",
"861376839", "广西南宁市",
"861470354", "山西省晋中市",
"861520077", "湖南省湘西土家族苗族自治州",
"861816976", "广西北海市",
"861332231", "辽宁省营口市",
"861534679", "甘肃省陇南市",
"861882972", "陕西省榆林市",
"86579", "浙江省金华市",
"861390662", "浙江省宁波市",
"861309927", "甘肃省白银市",
"861778140", "四川省德阳市",
"861313562", "湖北省孝感市",
"861834543", "黑龙江省大庆市",
"86187687", "贵州省六盘水市",
"86186173", "广东省广州市",
"86158318", "河北省邯郸市",
"861502919", "陕西省咸阳市",
"861558380", "四川省德阳市",
"861310758", "青海省西宁市",
"861370771", "广西南宁市",
"861303428", "浙江省台州市",
"861565653", "安徽省马鞍山市",
"86135485", "湖南省长沙市",
"861805049", "福建省莆田市",
"861850817", "四川省南充市",
"861894188", "辽宁省葫芦岛市",
"86158361", "河南省新乡市",
"86139406", "辽宁省锦州市",
"861328417", "辽宁省营口市",
"861846427", "山东省滨州市",
"861598472", "四川省阿坝藏族羌族自治州",
"861841987", "甘肃省定西市",
"861560985", "辽宁省大连市",
"86139418", "辽宁省阜新市",
"861358794", "浙江省湖州市",
"86153400", "北京市",
"861523876", "河南省周口市",
"861452092", "安徽省铜陵市",
"861528766", "云南省普洱市",
"861559199", "陕西省渭南市",
"861530327", "河北省沧州市",
"861376878", "广西玉林市",
"861572778", "江西省赣州市",
"861534422", "内蒙古包头市",
"86180320", "河北省石家庄市",
"86139461", "黑龙江省哈尔滨市",
"861361738", "湖南省娄底市",
"86139127", "江苏省苏州市",
"861836547", "江西省宜春市",
"861316851", "广东省江门市",
"86158306", "河北省石家庄市",
"861846207", "山东省淄博市",
"861869047", "陕西省榆林市",
"861333526", "山东省潍坊市",
"861521793", "广东省广州市",
"861853016", "河南省焦作市",
"861304645", "山东省威海市",
"861357819", "云南省普洱市",
"86139021", "天津市",
"861813557", "山西省长治市",
"861333841", "福建省福州市",
"861327387", "河南省许昌市",
"861781782", "广东省广州市",
"861363610", "湖北省黄冈市",
"861348173", "广西防城港市",
"861351589", "浙江省金华市",
"861891239", "江苏省无锡市",
"86152703", "江西省上饶市",
"861530602", "福建省福州市",
"861336705", "江西省宜春市",
"861390012", "北京市",
"861530238", "广东省广州市",
"861519054", "江苏省常州市",
"861329126", "江苏省南京市",
"861309819", "陕西省铜川市",
"861330447", "吉林省延边朝鲜族自治州",
"861760763", "广东省清远市",
"861379597", "四川省泸州市",
"861570677", "浙江省温州市",
"861352566", "河南省南阳市",
"86155618", "黑龙江省哈尔滨市",
"86137831", "河南省洛阳市",
"861390474", "内蒙古乌兰察布市",
"861550792", "江西省九江市",
"861333783", "江苏省南京市",
"86177634", "山东省莱芜市",
"86155661", "辽宁省沈阳市",
"861508936", "广东省揭阳市",
"861886666", "山东省滨州市",
"86189339", "广东省广州市",
"861309130", "河北省廊坊市",
"861380511", "江苏省盐城市",
"861768375", "湖北省鄂州市",
"861362259", "广东省汕头市",
"861365964", "广西梧州市",
"861803746", "河南省郑州市",
"861528920", "陕西省咸阳市",
"861772846", "广东省汕尾市",
"861565143", "江苏省扬州市",
"861571617", "江苏省无锡市",
"861760697", "云南省昆明市",
"861897876", "广西河池市",
"861810508", "福建省泉州市",
"861580002", "广东省广州市",
"861868857", "广东省云浮市",
"861581269", "广东省潮州市",
"861570175", "甘肃省兰州市",
"861367532", "山东省青岛市",
"861300188", "河北省石家庄市",
"861882421", "广东省东莞市",
"861454722", "浙江省杭州市",
"861808800", "云南省丽江市",
"861562475", "内蒙古通辽市",
"861514827", "内蒙古兴安盟",
"861509764", "河北省廊坊市",
"86153366", "浙江省宁波市",
"861317030", "湖南省长沙市",
"861518360", "四川省甘孜藏族自治州",
"861350236", "广东省汕尾市",
"861890586", "浙江省台州市",
"86158460", "黑龙江省哈尔滨市",
"861518844", "河南省漯河市",
"86137119", "广东省东莞市",
"861571685", "河北省沧州市",
"861339673", "浙江省嘉兴市",
"861893232", "江苏省淮安市",
"861530593", "福建省宁德市",
"861804662", "江西省上饶市",
"861308169", "山东省潍坊市",
"861814532", "黑龙江省齐齐哈尔市",
"861323244", "广东省江门市",
"861787588", "广东省茂名市",
"861301678", "江苏省南通市",
"861857992", "广西柳州市",
"861893608", "江苏省苏州市",
"861581224", "云南省丽江市",
"861560917", "陕西省宝鸡市",
"861889935", "新疆喀什地区",
"861535933", "福建省厦门市",
"861841915", "甘肃省兰州市",
"86189250", "广东省广州市",
"861314785", "辽宁省大连市",
"861771997", "河南省商丘市",
"861853735", "河南省南阳市",
"861890155", "江苏省苏州市",
"861539280", "湖北省仙桃市",
"861473550", "山西省忻州市",
"86138034", "山西省太原市",
"861576599", "黑龙江省伊春市",
"861809992", "新疆伊犁哈萨克自治州",
"861452332", "河南省信阳市",
"861479542", "广西梧州市",
"861378826", "广西百色市",
"861869566", "福建省泉州市",
"861596636", "山东省滨州市",
"86131892", "广东省中山市",
"86151795", "江西省宜春市",
"861362294", "广东省梅州市",
"861890723", "湖北省黄石市",
"861529934", "新疆巴音郭楞蒙古自治州",
"861378541", "河北省石家庄市",
"861335319", "吉林省长春市",
"861509729", "甘肃省天水市",
"86155262", "湖南省郴州市",
"861580746", "湖南省永州市",
"861840975", "青海省海南藏族自治州",
"86152739", "湖南省邵阳市",
"861453633", "江苏省南京市",
"861308124", "辽宁省鞍山市",
"861554161", "辽宁省锦州市",
"861865236", "江苏省泰州市",
"861523304", "河北省秦皇岛市",
"861340393", "河南省濮阳市",
"861310842", "四川省广安市",
"861302093", "浙江省温州市",
"861554081", "内蒙古巴彦淖尔市",
"861559644", "陕西省西安市",
"861330455", "黑龙江省绥化市",
"861386582", "安徽省滁州市",
"861560864", "湖北省武汉市",
"861855420", "山东省泰安市",
"861453196", "山西省晋城市",
"86151616", "江苏省无锡市",
"861312586", "吉林省白城市",
"861560340", "山西省太原市",
"861816022", "新疆乌鲁木齐市",
"861880348", "山西省吕梁市",
"86170779", "浙江省宁波市",
"861504813", "内蒙古呼伦贝尔市",
"861836186", "江苏省盐城市",
"86181640", "湖北省武汉市",
"861311524", "江苏省淮安市",
"861586528", "山东省济南市",
"861330561", "安徽省淮北市",
"861328485", "内蒙古鄂尔多斯市",
"861564958", "河南省驻马店市",
"861890645", "山东省烟台市",
"861368862", "山东省济南市",
"861372120", "安徽省芜湖市",
"861879522", "宁夏石嘴山市",
"86178399", "河南省郑州市",
"86153301", "北京市",
"861322834", "四川省巴中市",
"861360420", "辽宁省鞍山市",
"861780839", "四川省广元市",
"861333095", "四川省眉山市",
"861817600", "广西钦州市",
"861869055", "陕西省安康市",
"861705261", "湖北省武汉市",
"86180167", "福建省泉州市",
"861312723", "山东省枣庄市",
"861301880", "浙江省绍兴市",
"861534971", "青海省西宁市",
"861571546", "山东省东营市",
"861313707", "河南省南阳市",
"861560829", "四川省巴中市",
"861804012", "辽宁省大连市",
"86147980", "黑龙江省齐齐哈尔市",
"861502611", "新疆哈密地区",
"861311569", "黑龙江省双鸭山市",
"861324946", "广东省深圳市",
"861364600", "福建省厦门市",
"86180018", "上海市",
"861571821", "广东省江门市",
"861477105", "湖北省荆州市",
"861809575", "青海省果洛藏族自治州",
"86131050", "福建省漳州市",
"861856305", "山东省潍坊市",
"861375412", "内蒙古包头市",
"86187535", "山东省烟台市",
"861813545", "山西省运城市",
"861507644", "河北省保定市",
"861450641", "黑龙江省大庆市",
"861810984", "辽宁省盘锦市",
"861829689", "江西省赣州市",
"861880849", "四川省巴中市",
"861534945", "甘肃省酒泉市",
"861322267", "江苏省扬州市",
"86159267", "湖北省黄冈市",
"861890671", "浙江省杭州市",
"861323463", "黑龙江省齐齐哈尔市",
"861850773", "广西桂林市",
"861300902", "吉林省四平市",
"861378992", "湖北省咸宁市",
"861332069", "四川省内江市",
"861452872", "宁夏石嘴山市",
"861808323", "贵州省铜仁地区",
"861322058", "山东省济南市",
"861360448", "吉林省松原市",
"861893912", "河南省许昌市",
"861813571", "河南省焦作市",
"861372148", "河南省焦作市",
"86158879", "云南省曲靖市",
"861838401", "四川省泸州市",
"861335170", "黑龙江省哈尔滨市",
"861350916", "陕西省汉中市",
"86183581", "浙江省杭州市",
"861387433", "湖南省益阳市",
"861870762", "广东省河源市",
"861827490", "湖南省永州市",
"861381363", "江苏省南通市",
"861458397", "福建省南平市",
"861579409", "广东省深圳市",
"861586540", "山东省滨州市",
"861364487", "内蒙古包头市",
"861774906", "陕西省榆林市",
"86147212", "上海市",
"861360382", "河南省郑州市",
"861339721", "湖北省荆州市",
"861570994", "新疆昌吉回族自治州",
"861880320", "河北省邯郸市",
"861365773", "广西桂林市",
"861319598", "甘肃省酒泉市",
"86184566", "安徽省池州市",
"861311122", "山西省大同市",
"86187265", "安徽省阜阳市",
"861331086", "广东省深圳市",
"861345018", "广东省肇庆市",
"861538486", "内蒙古包头市",
"86151810", "四川省德阳市",
"86182669", "浙江省金华市",
"861889215", "陕西省西安市",
"86152598", "福建省三明市",
"861535213", "甘肃省武威市",
"861560237", "广东省云浮市",
"861780338", "河北省承德市",
"86188457", "黑龙江省哈尔滨市",
"861324768", "广东省广州市",
"861387270", "湖北省恩施土家族苗族自治州",
"86181846", "海南省海口市",
"861372217", "内蒙古鄂尔多斯市",
"861334759", "广西北海市",
"861373413", "山西省临汾市",
"861879169", "陕西省渭南市",
"861338636", "山东省潍坊市",
"861855448", "山东省德州市",
"861331737", "湖南省益阳市",
"861767343", "湖南省湘西土家族苗族自治州",
"861818940", "甘肃省武威市",
"861839048", "湖南省郴州市",
"861520456", "黑龙江省黑河市",
"861315831", "贵州省安顺市",
"861760974", "青海省海南藏族自治州",
"861811695", "新疆吐鲁番地区",
"861517570", "河北省沧州市",
"861786623", "湖北省襄樊市",
"861773424", "河北省邯郸市",
"861308522", "湖北省黄冈市",
"861459453", "陕西省商洛市",
"861566633", "山东省日照市",
"861510639", "山东省临沂市",
"861537316", "河北省廊坊市",
"861881562", "安徽省铜陵市",
"861500569", "安徽省六安市",
"861582993", "陕西省西安市",
"86182476", "内蒙古赤峰市",
"861318468", "江西省宜春市",
"861333250", "湖南省岳阳市",
"861362321", "河北省石家庄市",
"861355960", "福建省宁德市",
"861339242", "广东省深圳市",
"861860726", "湖北省恩施土家族苗族自治州",
"86156727", "湖北省孝感市",
"861589298", "四川省达州市",
"861372658", "广东省韶关市",
"861840941", "甘肃省甘南藏族自治州",
"861326698", "广东省深圳市",
"861510880", "云南省文山壮族苗族自治州",
"861593539", "山西省阳泉市",
"861567072", "河南省洛阳市",
"861361923", "陕西省渭南市",
"86133771", "广西南宁市",
"861322374", "河南省新乡市",
"861575450", "黑龙江省哈尔滨市",
"861508588", "贵州省六盘水市",
"861310489", "广东省广州市",
"861581391", "广东省汕尾市",
"861366483", "内蒙古阿拉善盟",
"861342869", "广东省深圳市",
"86181959", "新疆乌鲁木齐市",
"861860960", "安徽省滁州市",
"861332619", "浙江省温州市",
"861773469", "陕西省渭南市",
"861335818", "江苏省常州市",
"861533932", "甘肃省定西市",
"861764040", "辽宁省大连市",
"861562441", "山东省枣庄市",
"86180493", "陕西省榆林市",
"86182205", "陕西省西安市",
"86186044", "吉林省长春市",
"861539302", "甘肃省临夏回族自治州",
"861806344", "山东省济南市",
"86159583", "浙江省嘉兴市",
"861364731", "湖南省长沙市",
"861588989", "广东省中山市",
"86137355", "浙江省杭州市",
"861500524", "江苏省宿迁市",
"861347516", "山东省德州市",
"861315345", "山东省德州市",
"86187609", "云南省大理白族自治州",
"861860583", "浙江省嘉兴市",
"861336921", "陕西省宝鸡市",
"861368790", "江西省抚州市",
"861816589", "广东省肇庆市",
"861331481", "内蒙古呼伦贝尔市",
"861895470", "山东省烟台市",
"861342824", "广东省汕尾市",
"86187471", "内蒙古赤峰市",
"861580968", "宁夏银川市",
"861572900", "河南省三门峡市",
"861306109", "山东省聊城市",
"861355726", "广西百色市",
"86130773", "湖南省长沙市",
"861328350", "山西省忻州市",
"861552690", "吉林省辽源市",
"861565034", "山东省淄博市",
"86152488", "内蒙古巴彦淖尔市",
"86185823", "四川省成都市",
"861301093", "辽宁省营口市",
"861801106", "四川省德阳市",
"861317816", "福建省漳州市",
"861898904", "西藏林芝地区",
"861863058", "河北省衡水市",
"861526533", "山东省淄博市",
"861853981", "河南省三门峡市",
"861589042", "河南省南阳市",
"861398443", "贵州省安顺市",
"861807779", "广西南宁市",
"861519196", "陕西省宝鸡市",
"861889781", "广西桂林市",
"861314931", "广东省珠海市",
"86137791", "新疆伊犁哈萨克自治州",
"861330380", "河南省新乡市",
"861856938", "湖南省永州市",
"861810760", "广东省中山市",
"861871804", "广东省深圳市",
"861312524", "江西省抚州市",
"861358279", "河北省廊坊市",
"861526027", "福建省莆田市",
"861860498", "辽宁省阜新市",
"861777117", "湖北省黄石市",
"861572546", "山东省东营市",
"861883979", "河南省郑州市",
"861315107", "江苏省南京市",
"861311723", "湖北省襄樊市",
"861559336", "甘肃省白银市",
"861876048", "福建省漳州市",
"86132796", "陕西省渭南市",
"86177866", "湖北省黄冈市",
"861319802", "四川省内江市",
"861535845", "江苏省无锡市",
"861347479", "内蒙古锡林郭勒盟",
"861589706", "青海省玉树藏族自治州",
"861502489", "内蒙古巴彦淖尔市",
"861840309", "河北省邢台市",
"86187082", "四川省资阳市",
"86183491", "四川省成都市",
"861534373", "河南省新乡市",
"861824283", "辽宁省辽阳市",
"86138393", "河南省濮阳市",
"861380899", "山东省青岛市",
"861330957", "宁夏银川市",
"861776854", "江苏省扬州市",
"861312569", "辽宁省辽阳市",
"86184743", "湖南省湘西土家族苗族自治州",
"861504271", "辽宁省营口市",
"861598323", "四川省资阳市",
"861397353", "湖南省郴州市",
"86184136", "浙江省衢州市",
"861572821", "广东省梅州市",
"86138930", "甘肃省白银市",
"861580490", "辽宁省葫芦岛市",
"861347438", "陕西省延安市",
"86180583", "浙江省温州市",
"861338792", "江西省九江市",
"861453099", "山西省长治市",
"86159493", "广西河池市",
"861863374", "河北省沧州市",
"861889308", "甘肃省天水市",
"861881421", "广东省湛江市",
"861821907", "广东省肇庆市",
"861554204", "辽宁省锦州市",
"86177113", "四川省成都市",
"861890524", "江苏省宿迁市",
"861840477", "内蒙古鄂尔多斯市",
"861557980", "江西省上饶市",
"861881201", "河北省石家庄市",
"861370828", "四川省泸州市",
"861334918", "安徽省合肥市",
"861554424", "河南省洛阳市",
"861308461", "浙江省温州市",
"861826287", "江苏省盐城市",
"861572685", "浙江省温州市",
"861830962", "宁夏石嘴山市",
"861570882", "云南省昭通市",
"861569300", "甘肃省临夏回族自治州",
"861347307", "河北省邢台市",
"861315973", "吉林省通化市",
"861813624", "江苏省扬州市",
"861308555", "安徽省马鞍山市",
"861836089", "江苏省淮安市",
"861889437", "甘肃省天水市",
"861524023", "江苏省南京市",
"861550604", "吉林省松原市",
"861560415", "辽宁省丹东市",
"861815395", "甘肃省兰州市",
"861837959", "江西省萍乡市",
"86137604", "广东省深圳市",
"861890569", "安徽省合肥市",
"861308616", "江西省吉安市",
"86135693", "河南省商丘市",
"861509563", "甘肃省金昌市",
"861576627", "广东省湛江市",
"861826648", "山东省青岛市",
"861818506", "贵州省遵义市",
"861521559", "安徽省黄山市",
"861301717", "湖南省衡阳市",
"861842915", "陕西省安康市",
"861530794", "江西省抚州市",
"861346577", "山东省济宁市",
"861308186", "河北省秦皇岛市",
"861537070", "江苏省泰州市",
"86189150", "江苏省常州市",
"861459601", "宁夏石嘴山市",
"861772997", "安徽省六安市",
"86130357", "广东省梅州市",
"861379921", "福建省泉州市",
"861476028", "福建省龙岩市",
"861559525", "宁夏中卫市",
"861358238", "河北省保定市",
"861898588", "贵州省毕节地区",
"86155162", "河南省三门峡市",
"861311645", "贵州省黔东南苗族侗族自治州",
"861509980", "广东省汕尾市",
"86185549", "山东省青岛市",
"861319483", "四川省绵阳市",
"86186659", "广东省深圳市",
"861856979", "湖南省怀化市",
"86136305", "吉林省长春市",
"86183909", "湖南省长沙市",
"861374959", "河南省焦作市",
"861586906", "浙江省衢州市",
"86147084", "四川省成都市",
"861344254", "山东省莱芜市",
"861300777", "青海省西宁市",
"861838143", "四川省眉山市",
"861813669", "江苏省常州市",
"861537507", "安徽省宿州市",
"861535331", "陕西省延安市",
"861839292", "陕西省商洛市",
"861376673", "黑龙江省伊春市",
"861860784", "广西贺州市",
"861882562", "广东省珠海市",
"861454123", "河北省张家口市",
"861581993", "广东省江门市",
"861800501", "福建省福州市",
"861536443", "湖南省怀化市",
"861816566", "广东省江门市",
"861361321", "河北省石家庄市",
"861558373", "四川省内江市",
"861383474", "山西省吕梁市",
"861534833", "湖南省株洲市",
"861812695", "广东省梅州市",
"86150250", "云南省保山市",
"861310181", "江苏省泰州市",
"861500155", "新疆喀什地区",
"861810892", "西藏日喀则地区",
"861854653", "黑龙江省哈尔滨市",
"861894751", "内蒙古通辽市",
"861867211", "湖北省荆州市",
"861877279", "湖北省十堰市",
"861846701", "青海省西宁市",
"861377032", "江苏省南京市",
"861889809", "西藏林芝地区",
"861362923", "陕西省渭南市",
"861826620", "山东省青岛市",
"861568535", "贵州省安顺市",
"861356662", "浙江省宁波市",
"861569282", "四川省南充市",
"861773486", "河南省平顶山市",
"861856218", "山东省烟台市",
"861478457", "黑龙江省大兴安岭地区",
"861303950", "内蒙古呼和浩特市",
"86137723", "陕西省榆林市",
"861843845", "河南省平顶山市",
"861523199", "河北省保定市",
"861370329", "河北省石家庄市",
"86134080", "四川省成都市",
"861332166", "广西南宁市",
"861313972", "新疆巴音郭楞蒙古自治州",
"861788525", "贵州省黔南布依族苗族自治州",
"86153658", "江苏省徐州市",
"861500723", "湖北省黄石市",
"861514758", "内蒙古通辽市",
"861597259", "湖北省十堰市",
"86182742", "湖南省株洲市",
"86187114", "湖南省衡阳市",
"861766011", "山东省济南市",
"861830008", "广东省惠州市",
"861334279", "广东省潮州市",
"861324500", "湖南省常德市",
"861821252", "贵州省铜仁地区",
"861532631", "吉林省长春市",
"861590262", "贵州省遵义市",
"861355784", "广西梧州市",
"861591009", "山东省济南市",
"861357942", "新疆乌鲁木齐市",
"861566099", "河南省南阳市",
"861330679", "浙江省金华市",
"861539599", "福建省南平市",
"861383012", "甘肃省临夏回族自治州",
"861571900", "新疆阿克苏地区",
"86150303", "河北省张家口市",
"86134638", "河北省石家庄市",
"861337530", "山东省菏泽市",
"861303387", "河南省鹤壁市",
"861899764", "新疆喀什地区",
"86138321", "河北省石家庄市",
"861332481", "广西南宁市",
"861500586", "浙江省台州市",
"861477347", "湖南省湘西土家族苗族自治州",
"861846388", "山东省临沂市",
"861334602", "浙江省绍兴市",
"861325521", "江苏省无锡市",
"861452615", "江苏省苏州市",
"861334238", "辽宁省盘锦市",
"861569823", "山东省日照市",
"861511777", "贵州省安顺市",
"861530488", "黑龙江省双鸭山市",
"861352976", "云南省玉溪市",
"861814356", "贵州省遵义市",
"86151351", "山西省太原市",
"861896929", "浙江省湖州市",
"861500645", "山东省烟台市",
"86159421", "辽宁省朝阳市",
"861321267", "湖南省娄底市",
"861452185", "吉林省延边朝鲜族自治州",
"86159167", "广东省东莞市",
"861879186", "陕西省宝鸡市",
"86156775", "广西贵港市",
"861502842", "河北省保定市",
"861313595", "湖北省咸宁市",
"861773081", "河南省安阳市",
"861876020", "福建省宁德市",
"861390695", "福建省漳州市",
"861333770", "江苏省南京市",
"861334327", "河北省沧州市",
"861338860", "浙江省杭州市",
"861327632", "山东省枣庄市",
"861365574", "浙江省宁波市",
"861330422", "辽宁省鞍山市",
"861338344", "山西省晋中市",
"861538469", "陕西省铜川市",
"861340542", "山东省青岛市",
"861331069", "山东省枣庄市",
"861528458", "云南省保山市",
"861325846", "四川省德阳市",
"861327428", "辽宁省葫芦岛市",
"861330638", "山东省烟台市",
"861778932", "甘肃省临夏回族自治州",
"861367356", "河南省周口市",
"86159018", "上海市",
"861877238", "湖北省黄冈市",
"861380398", "河南省三门峡市",
"861819520", "宁夏石嘴山市",
"861705502", "云南省昆明市",
"861332086", "四川省德阳市",
"86156916", "陕西省汉中市",
"861370277", "广东省珠海市",
"86135621", "山东省威海市",
"861879461", "甘肃省平凉市",
"861584511", "黑龙江省哈尔滨市",
"861806193", "江苏省苏州市",
"861802043", "江苏省常州市",
"86186922", "湖南省长沙市",
"861538204", "辽宁省盘锦市",
"861459730", "湖南省岳阳市",
"861332737", "湖南省益阳市",
"861304305", "福建省三明市",
"861561046", "山东省青岛市",
"861846442", "山东省聊城市",
"861709668", "浙江省杭州市",
"861368446", "四川省雅安市",
"861534447", "湖南省郴州市",
"861894813", "广东省河源市",
"861836522", "安徽省淮北市",
"861850574", "浙江省宁波市",
"86180537", "山东省济宁市",
"861777400", "浙江省杭州市",
"861869022", "新疆哈密地区",
"861315410", "辽宁省铁岭市",
"861452556", "山东省青岛市",
"861863834", "河南省洛阳市",
"861822772", "四川省阿坝藏族羌族自治州",
"861530342", "山西省大同市",
"861358918", "山东省潍坊市",
"861512188", "宁夏银川市",
"861309420", "湖北省荆州市",
"861529686", "广西河池市",
"861310742", "湖南省长沙市",
"861877412", "湖南省岳阳市",
"86137735", "江苏省扬州市",
"861880703", "江西省上饶市",
"861516645", "山东省日照市",
"86135662", "浙江省温州市",
"86147690", "云南省临沧市",
"86147417", "四川省成都市",
"861576937", "甘肃省陇南市",
"861580846", "四川省宜宾市",
"861832493", "安徽省宿州市",
"861890823", "四川省成都市",
"861348400", "浙江省杭州市",
"86131208", "上海市",
"861379631", "黑龙江省齐齐哈尔市",
"861771539", "江苏省苏州市",
"86186918", "陕西省西安市",
"861512408", "辽宁省朝阳市",
"861328910", "陕西省咸阳市",
"861336568", "安徽省六安市",
"86188252", "广东省深圳市",
"861760531", "山东省济南市",
"861329436", "吉林省白城市",
"861334074", "四川省泸州市",
"86155193", "贵州省毕节地区",
"861343795", "江西省宜春市",
"861478428", "河南省周口市",
"86186961", "湖北省武汉市",
"86178558", "浙江省宁波市",
"861853835", "河南省洛阳市",
"861315600", "山东省济南市",
"861777610", "广西梧州市",
"861860575", "浙江省绍兴市",
"861398024", "四川省泸州市",
"861580521", "江苏省徐州市",
"861365333", "河北省邢台市",
"861330317", "河北省沧州市",
"861378960", "内蒙古呼伦贝尔市",
"861303179", "山东省淄博市",
"861879406", "甘肃省临夏回族自治州",
"861840296", "陕西省汉中市",
"86183435", "吉林省通化市",
"861883432", "山西省长治市",
"86159462", "黑龙江省齐齐哈尔市",
"86189016", "上海市",
"861390088", "云南省西双版纳傣族自治州",
"861781718", "广东省广州市",
"86152115", "湖南省怀化市",
"86159040", "辽宁省沈阳市",
"861366475", "内蒙古锡林郭勒盟",
"861870790", "江西省新余市",
"861454822", "广东省珠海市",
"861355575", "辽宁省辽阳市",
"861391344", "江苏省镇江市",
"861780778", "广西河池市",
"861597339", "湖南省衡阳市",
"861552197", "广东省梅州市",
"861331377", "福建省福州市",
"86159022", "天津市",
"861820459", "黑龙江省大庆市",
"861310006", "山西省晋城市",
"861830468", "黑龙江省鹤岗市",
"861813934", "新疆哈密地区",
"861557829", "广西南宁市",
"861806892", "江苏省宿迁市",
"861894682", "青海省海东地区",
"861331229", "贵州省黔西南布依族苗族自治州",
"861554043", "内蒙古乌兰察布市",
"86133046", "黑龙江省哈尔滨市",
"861571721", "湖北省荆州市",
"861800566", "安徽省池州市",
"861810636", "山东省潍坊市",
"861816501", "陕西省延安市",
"861365785", "广西玉林市",
"861329031", "山东省东营市",
"861303138", "新疆克拉玛依市",
"861331409", "辽宁省葫芦岛市",
"861860992", "新疆伊犁哈萨克自治州",
"861579737", "湖北省黄冈市",
"861763543", "山西省晋中市",
"861560729", "湖北省孝感市",
"861878448", "四川省内江市",
"861893536", "山西省长治市",
"861327457", "黑龙江省牡丹江市",
"861588901", "西藏拉萨市",
"861528427", "河北省沧州市",
"86138362", "黑龙江省齐齐哈尔市",
"861533145", "云南省红河哈尼族彝族自治州",
"861780739", "湖南省邵阳市",
"861890282", "广东省中山市",
"861350532", "山东省青岛市",
"861302929", "辽宁省葫芦岛市",
"861576120", "贵州省黔南布依族苗族自治州",
"861334358", "湖北省武汉市",
"861355992", "福建省福州市",
"861771578", "四川省自贡市",
"861369618", "四川省广安市",
"861454283", "辽宁省大连市",
"861889544", "安徽省阜阳市",
"861867621", "广东省东莞市",
"861310401", "黑龙江省哈尔滨市",
"861881590", "福建省南平市",
"861850785", "广西贵港市",
"861587675", "广东省汕尾市",
"861331264", "云南省玉溪市",
"861392193", "江苏省扬州市",
"86183656", "山东省潍坊市",
"861583047", "河北省沧州市",
"861846920", "云南省怒江傈僳族自治州",
"861364371", "河南省郑州市",
"861815030", "福建省南平市",
"86170943", "吉林省长春市",
"861504713", "内蒙古鄂尔多斯市",
"86170789", "浙江省温州市",
"861516586", "山东省枣庄市",
"861785837", "浙江省湖州市",
"861582582", "甘肃省定西市",
"861529545", "江苏省徐州市",
"861561598", "山东省滨州市",
"861302964", "新疆乌鲁木齐市",
"861879001", "河南省焦作市",
"861324324", "河南省三门峡市",
"861328347", "河北省秦皇岛市",
"861339546", "山东省东营市",
"861534450", "黑龙江省哈尔滨市",
"861364345", "山西省太原市",
"861598568", "贵州省六盘水市",
"861370496", "辽宁省锦州市",
"861308406", "安徽省亳州市",
"86183850", "贵州省遵义市",
"861569524", "江苏省宿迁市",
"861550072", "青海省黄南藏族自治州",
"861821872", "广东省深圳市",
"861308226", "辽宁省鞍山市",
"861536024", "广东省汕尾市",
"861865134", "江苏省徐州市",
"861334859", "福建省南平市",
"861303310", "安徽省马鞍山市",
"861459411", "云南省西双版纳傣族自治州",
"861470798", "江西省景德镇市",
"861349", "北京市",
"861899415", "江苏省南通市",
"86185835", "四川省绵阳市",
"861310394", "河南省周口市",
"861809583", "新疆巴音郭楞蒙古自治州",
"861590589", "浙江省金华市",
"861890300", "广东省广州市",
"861339821", "四川省宜宾市",
"86155467", "广东省深圳市",
"86155121", "河北省石家庄市",
"861365873", "云南省红河哈尼族彝族自治州",
"861319103", "山西省长治市",
"861570063", "四川省成都市",
"861889142", "陕西省榆林市",
"861320691", "黑龙江省绥化市",
"861313439", "吉林省白山市",
"861328230", "浙江省嘉兴市",
"861888293", "四川省阿坝藏族羌族自治州",
"861320954", "宁夏固原市",
"861857583", "广东省肇庆市",
"861847668", "广东省广州市",
"861829730", "安徽省蚌埠市",
"861870862", "贵州省铜仁地区",
"861530982", "辽宁省大连市",
"861878420", "四川省广安市",
"861471529", "广东省中山市",
"86183571", "浙江省杭州市",
"861459666", "新疆昌吉回族自治州",
"861527988", "江西省宜春市",
"86158889", "浙江省金华市",
"861808631", "湖北省黄石市",
"86134701", "辽宁省铁岭市",
"861572098", "江西省九江市",
"861576148", "贵州省六盘水市",
"861373056", "河北省邢台市",
"861520013", "河北省邯郸市",
"861452772", "广西柳州市",
"861822556", "安徽省安庆市",
"861569569", "安徽省合肥市",
"861896639", "浙江省宁波市",
"861813214", "河北省邯郸市",
"861857960", "江西省吉安市",
"861316777", "安徽省宿州市",
"861850873", "云南省红河哈尼族彝族自治州",
"861528952", "广西百色市",
"861328473", "内蒙古乌海市",
"861894514", "黑龙江省鸡西市",
"86139667", "安徽省合肥市",
"861501742", "广东省佛山市",
"861778622", "湖北省荆门市",
"861550414", "辽宁省本溪市",
"861560605", "福建省漳州市",
"861562802", "贵州省黔南布依族苗族自治州",
"861366702", "江西省九江市",
"861801081", "安徽省宣城市",
"861376900", "云南省丽江市",
"861819491", "新疆伊犁哈萨克自治州",
"86187481", "内蒙古呼和浩特市",
"861520797", "江西省赣州市",
"86183092", "陕西省西安市",
"861355826", "广西百色市",
"861568499", "湖南省邵阳市",
"861361099", "辽宁省辽阳市",
"861370857", "贵州省毕节地区",
"861801161", "四川省绵阳市",
"861534534", "山东省德州市",
"861840560", "安徽省合肥市",
"861587151", "湖北省鄂州市",
"861315487", "内蒙古呼和浩特市",
"861509237", "山东省临沂市",
"861314773", "吉林省吉林市",
"861532921", "贵州省遵义市",
"861312300", "福建省泉州市",
"861847018", "江西省赣州市",
"861501221", "云南省曲靖市",
"86152359", "山西省运城市",
"861840983", "新疆伊犁哈萨克自治州",
"86159573", "浙江省嘉兴市",
"86134766", "湖北省黄冈市",
"861366441", "吉林省长春市",
"861355541", "黑龙江省牡丹江市",
"861814916", "陕西省汉中市",
"861308001", "吉林省长春市",
"861370091", "四川省德阳市",
"861575945", "福建省泉州市",
"861520663", "山东省日照市",
"861555035", "山东省日照市",
"861551662", "河南省新乡市",
"861476057", "宁夏银川市",
"861562483", "内蒙古阿拉善盟",
"861539435", "浙江省金华市",
"861363332", "河北省保定市",
"861836284", "江苏省连云港市",
"86147896", "湖南省岳阳市",
"861822065", "陕西省渭南市",
"861801486", "江苏省苏州市",
"861319977", "新疆博尔塔拉蒙古自治州",
"861535251", "新疆乌鲁木齐市",
"861510780", "广西钦州市",
"86133158", "河北省衡水市",
"861767708", "广西河池市",
"861763509", "山西省晋城市",
"861576658", "广东省清远市",
"861599498", "广东省潮州市",
"861860826", "四川省广安市",
"861597838", "河南省信阳市",
"861563287", "河北省衡水市",
"861871549", "安徽省宣城市",
"861570613", "江苏省苏州市",
"86631", "山东省威海市",
"861331443", "贵州省遵义市",
"861338508", "福建省三明市",
"861538043", "江苏省南京市",
"861313478", "内蒙古巴彦淖尔市",
"861373451", "黑龙江省双鸭山市",
"861571673", "河南省洛阳市",
"861457002", "山东省淄博市",
"861860541", "山东省临沂市",
"861362633", "山东省日照市",
"861339685", "浙江省绍兴市",
"86156254", "广东省佛山市",
"861554009", "内蒙古呼伦贝尔市",
"861476891", "山东省青岛市",
"861558733", "山东省济宁市",
"861572721", "湖北省荆州市",
"861376821", "广西南宁市",
"861304640", "山东省烟台市",
"861506639", "山东省青岛市",
"861560563", "安徽省宣城市",
"8618878", "广西南宁市",
"861380799", "江西省萍乡市",
"86135749", "湖南省邵阳市",
"86135983", "河南省商丘市",
"861776754", "新疆喀什地区",
"86139932", "甘肃省定西市",
"861775042", "福建省福州市",
"861336700", "江西省南昌市",
"861887013", "江西省赣州市",
"861395552", "安徽省池州市",
"861889743", "湖南省湘西土家族苗族自治州",
"861306489", "江苏省扬州市",
"861301929", "吉林省辽源市",
"86177367", "河北省廊坊市",
"861560980", "辽宁省鞍山市",
"861319702", "湖北省黄石市",
"861321734", "湖南省衡阳市",
"861311823", "四川省广安市",
"86152264", "湖南省怀化市",
"86412", "辽宁省鞍山市",
"861452173", "吉林省白城市",
"861325968", "宁夏银川市",
"861864716", "内蒙古赤峰市",
"861335959", "黑龙江省大庆市",
"861381528", "江苏省苏州市",
"861810344", "山西省运城市",
"861818422", "贵州省遵义市",
"861768370", "湖北省宜昌市",
"86151731", "湖南省长沙市",
"86159944", "广西南宁市",
"861470021", "安徽省六安市",
"861309135", "河北省承德市",
"861847531", "广东省汕尾市",
"861889881", "广东省广州市",
"861818202", "湖南省岳阳市",
"861528925", "陕西省安康市",
"861319046", "辽宁省本溪市",
"861346998", "湖北省武汉市",
"861780258", "江苏省宿迁市",
"861303076", "辽宁省盘锦市",
"861818638", "湖北省黄石市",
"861322533", "山东省淄博市",
"861820641", "山东省济南市",
"861332264", "广东省惠州市",
"861388243", "四川省雅安市",
"861775706", "浙江省宁波市",
"861363556", "安徽省安庆市",
"861539148", "云南省昆明市",
"861364973", "青海省海东地区",
"861301964", "辽宁省鞍山市",
"861560357", "山西省临汾市",
"861398166", "四川省巴中市",
"861317716", "湖北省荆门市",
"86131116", "河北省保定市",
"861884947", "河北省沧州市",
"861811088", "安徽省芜湖市",
"861780067", "内蒙古包头市",
"861800589", "浙江省金华市",
"86130783", "广东省阳江市",
"861811168", "四川省甘孜藏族自治州",
"861524999", "安徽省滁州市",
"861517467", "黑龙江省牡丹江市",
"86151848", "云南省保山市",
"861818679", "湖北省宜昌市",
"861314172", "江苏省南通市",
"861378784", "湖南省岳阳市",
"86131108", "福建省泉州市",
"861360591", "福建省龙岩市",
"86147228", "天津市",
"861886943", "云南省昭通市",
"861809498", "新疆伊犁哈萨克自治州",
"86134543", "浙江省丽水市",
"861372302", "河南省南阳市",
"861862515", "江苏省南京市",
"861803997", "河南省郑州市",
"861850931", "甘肃省兰州市",
"861825440", "山东省滨州市",
"86131863", "陕西省汉中市",
"861511228", "广东省深圳市",
"86182596", "福建省漳州市",
"861339900", "新疆克拉玛依市",
"861518543", "贵州省安顺市",
"861301817", "四川省宜宾市",
"861354760", "四川省攀枝花市",
"86188152", "浙江省台州市",
"861779954", "新疆喀什地区",
"861868329", "四川省成都市",
"861345195", "江苏省镇江市",
"86157204", "河北省沧州市",
"86187591", "福建省福州市",
"861823633", "河南省周口市",
"861572242", "江苏省扬州市",
"861506678", "山东省烟台市",
"861558385", "四川省自贡市",
"861319441", "福建省莆田市",
"861551197", "河北省邢台市",
"861707349", "河北省唐山市",
"861332377", "河南省南阳市",
"861386269", "江苏省常州市",
"861459370", "贵州省铜仁地区",
"861303471", "内蒙古呼和浩特市",
"861370728", "湖北省十堰市",
"861880504", "福建省莆田市",
"861529669", "山西省朔州市",
"861868364", "四川省德阳市",
"86180573", "浙江省嘉兴市",
"861470426", "辽宁省盘锦市",
"861365931", "甘肃省兰州市",
"861536481", "山西省太原市",
"861533622", "陕西省榆林市",
"861817410", "广西南宁市",
"861370740", "湖南省岳阳市",
"861372280", "河北省衡水市",
"86130737", "河南省郑州市",
"861899864", "广东省阳江市",
"861311300", "广东省深圳市",
"861593495", "内蒙古鄂尔多斯市",
"861379568", "四川省达州市",
"861840381", "黑龙江省鹤岗市",
"861510964", "宁夏固原市",
"861533438", "云南省红河哈尼族彝族自治州",
"861778171", "四川省遂宁市",
"86180462", "福建省厦门市",
"861310143", "福建省厦门市",
"861350356", "山西省晋城市",
"861802161", "江苏省苏州市",
"861532323", "广东省汕尾市",
"861801469", "江苏省盐城市",
"861580462", "黑龙江省哈尔滨市",
"861533307", "山西省临汾市",
"861760668", "广东省茂名市",
"861807339", "湖南省长沙市",
"861364410", "辽宁省铁岭市",
"861330506", "福建省泉州市",
"86180022", "广东省广州市",
"861319475", "四川省自贡市",
"861866304", "山东省日照市",
"861303445", "湖北省鄂州市",
"86155075", "广东省深圳市",
"861539937", "陕西省安康市",
"86159313", "河北省张家口市",
"861764057", "辽宁省朝阳市",
"861768830", "广东省清远市",
"861514858", "内蒙古呼伦贝尔市",
"861333688", "浙江省宁波市",
"861800022", "江西省九江市",
"861899829", "广东省广州市",
"861521698", "广东省江门市",
"861559776", "贵州省遵义市",
"861373159", "河北省邢台市",
"861786933", "云南省楚雄彝族自治州",
"861707848", "云南省文山壮族苗族自治州",
"861872549", "云南省怒江傈僳族自治州",
"861552662", "吉林省通化市",
"861705206", "湖北省武汉市",
"861802486", "广东省清远市",
"861889709", "青海省海西蒙古族藏族自治州",
"861452252", "浙江省绍兴市",
"86135937", "湖北省十堰市",
"86181661", "湖南省邵阳市",
"861894851", "广东省潮州市",
"861810792", "江西省九江市",
"86130650", "山东省济南市",
"861534733", "湖南省株洲市",
"861315985", "黑龙江省哈尔滨市",
"861588349", "四川省凉山彝族自治州",
"861807054", "江西省抚州市",
"861388464", "山东省烟台市",
"861332443", "吉林省延边朝鲜族自治州",
"86145205", "天津市",
"86181618", "陕西省西安市",
"861801204", "江苏省徐州市",
"861361633", "山东省日照市",
"861572673", "西藏山南地区",
"861860884", "云南省红河哈尼族彝族自治州",
"86181606", "新疆乌鲁木齐市",
"861581184", "广东省深圳市",
"861867253", "湖北省黄冈市",
"861539120", "内蒙古包头市",
"861536737", "湖南省益阳市",
"861332837", "福建省莆田市",
"861354892", "湖南省岳阳市",
"861773043", "安徽省马鞍山市",
"861366659", "浙江省舟山市",
"86132520", "浙江省湖州市",
"861855942", "福建省南平市",
"861575833", "云南省楚雄彝族自治州",
"861459689", "新疆石河子市",
"861389594", "黑龙江省鸡西市",
"861381540", "江苏省南京市",
"861513411", "辽宁省抚顺市",
"861892143", "江苏省南京市",
"861394976", "河南省三门峡市",
"861770436", "吉林省白城市",
"861325002", "广东省江门市",
"861569586", "浙江省宁波市",
"861459119", "广西桂林市",
"861537956", "宁夏石嘴山市",
"861534385", "河南省商丘市",
"861510817", "四川省阿坝藏族羌族自治州",
"8618520", "广东省广州市",
"861836001", "江苏省泰州市",
"861590566", "安徽省池州市",
"861378498", "河北省保定市",
"861300408", "安徽省蚌埠市",
"861766053", "山东省泰安市",
"861818380", "云南省临沧市",
"861809784", "新疆博尔塔拉蒙古自治州",
"861533479", "内蒙古锡林郭勒盟",
"861325746", "湖南省永州市",
"86187523", "江苏省淮安市",
"86183368", "河南省焦作市",
"861569155", "陕西省安康市",
"861504682", "黑龙江省双鸭山市",
"861333870", "江苏省苏州市",
"861395154", "江苏省盐城市",
"86138413", "辽宁省抚顺市",
"86183311", "河北省保定市",
"86187956", "江苏省无锡市",
"86158441", "吉林省长春市",
"861502742", "河北省石家庄市",
"861843623", "河南省焦作市",
"861304628", "广东省茂名市",
"86152534", "山东省德州市",
"861556976", "甘肃省酒泉市",
"861554106", "辽宁省朝阳市",
"861893418", "广东省汕尾市",
"861535771", "安徽省巢湖市",
"861388672", "湖北省宜昌市",
"861569723", "湖北省黄石市",
"861304432", "吉林省吉林市",
"861830990", "新疆克拉玛依市",
"861478315", "河南省郑州市",
"861522073", "广东省惠州市",
"861513666", "河南省南阳市",
"861705021", "海南省海口市",
"861577468", "黑龙江省鹤岗市",
"861571338", "河北省衡水市",
"861300851", "陕西省铜川市",
"861362378", "河南省开封市",
"86155622", "山东省枣庄市",
"861705867", "广东省深圳市",
"861510885", "云南省丽江市",
"861454847", "广东省深圳市",
"861339739", "湖南省邵阳市",
"861575455", "黑龙江省绥化市",
"86156550", "安徽省滁州市",
"861700724", "山东省济南市",
"861538134", "浙江省舟山市",
"861537790", "福建省福州市",
"86180675", "浙江省宁波市",
"861366694", "福建省莆田市",
"861821248", "贵州省铜仁地区",
"86183977", "湖南省衡阳市",
"861517575", "河北省保定市",
"861803674", "江苏省淮安市",
"861783952", "河南省漯河市",
"861357958", "新疆博尔塔拉蒙古自治州",
"861312432", "吉林省吉林市",
"861338414", "辽宁省本溪市",
"86147143", "广东省广州市",
"861514742", "内蒙古乌海市",
"861571407", "辽宁省营口市",
"86147736", "湖南省常德市",
"861300097", "黑龙江省佳木斯市",
"861315829", "贵州省黔西南布依族苗族自治州",
"861384846", "内蒙古赤峰市",
"861355965", "福建省漳州市",
"861333255", "湖南省郴州市",
"861368795", "江西省宜春市",
"861309958", "宁夏银川市",
"861550984", "辽宁省大连市",
"861895475", "山东省菏泽市",
"861373941", "四川省资阳市",
"86139422", "辽宁省鞍山市",
"861338072", "广东省韶关市",
"861531472", "浙江省台州市",
"86156871", "云南省昆明市",
"86139440", "吉林省长春市",
"861777173", "湖北省武汉市",
"8613690", "广东省佛山市",
"861369813", "四川省绵阳市",
"86133827", "江苏省扬州市",
"861700769", "广东省东莞市",
"861572905", "河南省焦作市",
"861830756", "广东省珠海市",
"861332351", "宁夏银川市",
"861567193", "湖北省十堰市",
"861860965", "安徽省合肥市",
"86134645", "辽宁省丹东市",
"861764045", "辽宁省沈阳市",
"861303457", "山东省威海市",
"861310727", "湖南省益阳市",
"861478950", "湖南省岳阳市",
"861315864", "四川省宜宾市",
"861534317", "河北省沧州市",
"861476519", "河北省石家庄市",
"861530412", "辽宁省鞍山市",
"86139062", "江苏省苏州市",
"861315340", "山东省威海市",
"861880536", "山东省潍坊市",
"861336978", "青海省西宁市",
"861327179", "河南省南阳市",
"861554532", "黑龙江省牡丹江市",
"86188316", "河北省廊坊市",
"861388710", "云南省昭通市",
"861530358", "山西省吕梁市",
"86183410", "辽宁省铁岭市",
"861890628", "江苏省南通市",
"861859099", "陕西省铜川市",
"86183697", "山东省济宁市",
"861364729", "湖北省随州市",
"861453738", "湖南省长沙市",
"861335175", "黑龙江省大庆市",
"861846458", "山东省威海市",
"861890432", "吉林省吉林市",
"861840413", "辽宁省沈阳市",
"861771968", "陕西省西安市",
"861787626", "广东省茂名市",
"861336939", "甘肃省陇南市",
"861769824", "河南省新乡市",
"861803462", "甘肃省平凉市",
"861819154", "陕西省渭南市",
"861367486", "内蒙古赤峰市",
"86158322", "河北省保定市",
"861820903", "新疆和田地区",
"861534940", "甘肃省临夏回族自治州",
"86182713", "湖北省宜昌市",
"861813528", "山西省太原市",
"86158340", "山西省太原市",
"861321706", "江西省吉安市",
"861894228", "江西省赣州市",
"861350043", "辽宁省抚顺市",
"861321042", "山东省临沂市",
"861373194", "安徽省六安市",
"861520324", "河北省承德市",
"861528442", "云南省玉溪市",
"861346513", "山东省威海市",
"861340558", "江苏省镇江市",
"861762502", "江苏省无锡市",
"861868251", "四川省遂宁市",
"86181262", "广东省深圳市",
"861800976", "青海省玉树藏族自治州",
"861387275", "湖北省十堰市",
"861826544", "山东省德州市",
"861339778", "广西河池市",
"86132124", "重庆市",
"86185608", "山东省淄博市",
"86185795", "湖南省永州市",
"861362339", "河北省张家口市",
"861818945", "甘肃省武威市",
"861571379", "河南省洛阳市",
"861301773", "浙江省绍兴市",
"861770391", "河南省焦作市",
"861878637", "贵州省黔南布依族苗族自治州",
"861865043", "福建省厦门市",
"861586545", "山东省东营市",
"861337384", "浙江省金华市",
"861898684", "湖北省恩施土家族苗族自治州",
"861514221", "辽宁省鞍山市",
"861807099", "广西玉林市",
"861880325", "河北省唐山市",
"861505659", "安徽省合肥市",
"861570319", "河北省邢台市",
"861560371", "河南省郑州市",
"861454433", "江苏省扬州市",
"861502858", "河北省秦皇岛市",
"86170928", "四川省成都市",
"861889210", "陕西省延安市",
"86155959", "海南省海口市",
"861596414", "山东省济宁市",
"861528889", "山东省德州市",
"861524691", "黑龙江省伊春市",
"861848533", "贵州省安顺市",
"861358108", "山东省临沂市",
"861328480", "内蒙古包头市",
"861313289", "广西贵港市",
"861508626", "贵州省铜仁地区",
"861850880", "云南省昭通市",
"861505103", "江苏省宿迁市",
"861394589", "黑龙江省伊春市",
"861558317", "四川省广元市",
"861387241", "湖北省荆州市",
"861580997", "新疆阿克苏地区",
"861530859", "贵州省黔西南布依族苗族自治州",
"86135118", "贵州省遵义市",
"861850639", "山东省青岛市",
"861855425", "山东省滨州市",
"861822092", "陕西省榆林市",
"861371554", "广东省佛山市",
"861586571", "山东省济宁市",
"861877982", "江西省景德镇市",
"86135427", "广东省惠州市",
"86135161", "天津市",
"861330450", "黑龙江省哈尔滨市",
"861560345", "山西省长治市",
"861537862", "四川省眉山市",
"861592916", "陕西省延安市",
"861318497", "河北省衡水市",
"861576853", "广东省湛江市",
"861335141", "黑龙江省哈尔滨市",
"861570818", "四川省达州市",
"861326793", "广东省惠州市",
"861477100", "湖北省襄樊市",
"861885822", "浙江省宁波市",
"861598978", "广东省珠海市",
"861809570", "青海省海北藏族自治州",
"861302172", "山东省济南市",
"861895702", "浙江省衢州市",
"861862587", "河南省焦作市",
"861782882", "四川省自贡市",
"86139754", "湖南省衡阳市",
"861345763", "广西玉林市",
"861556589", "河南省漯河市",
"86186567", "安徽省亳州市",
"861813540", "山西省晋中市",
"861856300", "山东省滨州市",
"861882439", "广东省深圳市",
"86181532", "山东省青岛市",
"86177705", "江西省宜春市",
"86177142", "江苏省苏州市",
"861473066", "河北省石家庄市",
"861890640", "山东省济南市",
"861372125", "安徽省宿州市",
"861347128", "广西桂林市",
"861770269", "广东省茂名市",
"861333090", "四川省绵阳市",
"861869050", "陕西省安康市",
"861817605", "广西北海市",
"861470914", "陕西省商洛市",
"861360425", "辽宁省大连市",
"86150759", "河北省邢台市",
"861571878", "云南省丽江市",
"86138247", "广东省中山市",
"861365639", "山东省青岛市",
"86159627", "江苏省南通市",
"861777252", "河北省保定市",
"86186324", "河北省承德市",
"861334982", "湖北省黄石市",
"861809007", "四川省成都市",
"861554134", "辽宁省盘锦市",
"86177120", "江苏省徐州市",
"861882478", "广东省湛江市",
"861518365", "四川省德阳市",
"86158588", "浙江省温州市",
"86186283", "四川省成都市",
"861317035", "湖南省郴州市",
"861780821", "四川省泸州市",
"861778157", "四川省巴中市",
"86147857", "贵州省遵义市",
"861571680", "河北省邯郸市",
"861319567", "安徽省亳州市",
"861895441", "山东省淄博市",
"86184712", "湖北省孝感市",
"861865009", "福建省福州市",
"861776799", "吉林省白城市",
"861709529", "江苏省盐城市",
"86176391", "河南省焦作市",
"861348332", "河北省张家口市",
"861475724", "浙江省金华市",
"861510773", "广西桂林市",
"861897548", "湖南省邵阳市",
"861303922", "吉林省长春市",
"861362879", "云南省普洱市",
"861576711", "广东省茂名市",
"861597196", "湖北省荆门市",
"861365678", "浙江省宁波市",
"861571839", "广东省云浮市",
"861570170", "甘肃省庆阳市",
"861324797", "江西省赣州市",
"861872692", "安徽省淮北市",
"861377844", "四川省泸州市",
"861509487", "山东省淄博市",
"861315237", "陕西省渭南市",
"861562470", "内蒙古呼伦贝尔市",
"861888661", "四川省成都市",
"861330534", "山东省德州市",
"861774019", "四川省成都市",
"861470867", "贵州省安顺市",
"861826652", "山东省泰安市",
"861320263", "广东省肇庆市",
"861780546", "山东省东营市",
"861318856", "辽宁省盘锦市",
"861515448", "山东省潍坊市",
"861705234", "内蒙古呼和浩特市",
"861350009", "广东省东莞市",
"861335651", "广东省湛江市",
"861588752", "云南省楚雄彝族自治州",
"861821220", "贵州省遵义市",
"861335994", "黑龙江省黑河市",
"86155846", "吉林省延边朝鲜族自治州",
"861840970", "青海省海北藏族自治州",
"861322298", "江苏省苏州市",
"861820949", "甘肃省陇南市",
"861569938", "新疆伊犁哈萨克自治州",
"861363687", "陕西省延安市",
"86185810", "重庆市",
"861314780", "辽宁省沈阳市",
"861889930", "新疆哈密地区",
"861801236", "江苏省无锡市",
"861841910", "甘肃省定西市",
"861890150", "江苏省常州市",
"861853730", "河南省新乡市",
"861319353", "河南省安阳市",
"861517541", "河北省邯郸市",
"861473555", "山西省长治市",
"86157792", "江西省九江市",
"861338865", "浙江省金华市",
"861367424", "辽宁省大连市",
"861333775", "江苏省镇江市",
"861876025", "福建省三明市",
"861390690", "福建省福州市",
"861866552", "广东省揭阳市",
"861553624", "山西省晋中市",
"861348556", "安徽省安庆市",
"861892359", "广东省汕尾市",
"861537446", "甘肃省张掖市",
"861532629", "辽宁省葫芦岛市",
"86188576", "浙江省台州市",
"86183925", "陕西省西安市",
"86136329", "广东省深圳市",
"861377676", "江苏省徐州市",
"861325578", "浙江省丽水市",
"861818447", "贵州省遵义市",
"861339617", "湖北省随州市",
"861843277", "河北省沧州市",
"861327471", "内蒙古呼和浩特市",
"861335882", "辽宁省葫芦岛市",
"861814424", "四川省绵阳市",
"861526806", "浙江省衢州市",
"861452610", "江苏省无锡市",
"86139398", "河南省三门峡市",
"861500640", "山东省济南市",
"861768383", "湖北省黄冈市",
"861814204", "浙江省宁波市",
"86189759", "湖南省邵阳市",
"861787684", "广东省梅州市",
"861893504", "山西省临汾市",
"861364563", "安徽省宣城市",
"861313590", "湖北省黄冈市",
"861452180", "吉林省吉林市",
"861337326", "河北省廊坊市",
"861459735", "湖南省郴州市",
"861538356", "山西省晋城市",
"86138853", "贵州省安顺市",
"861572379", "广西北海市",
"861361339", "河北省保定市",
"861304300", "福建省厦门市",
"861831216", "广东省湛江市",
"861777405", "浙江省绍兴市",
"861560973", "青海省黄南藏族自治州",
"861360452", "黑龙江省齐齐哈尔市",
"861806414", "湖北省襄樊市",
"86151549", "云南省红河哈尼族彝族自治州",
"861322042", "甘肃省平凉市",
"86181162", "上海市",
"861372152", "贵州省毕节地区",
"861532664", "黑龙江省哈尔滨市",
"861315415", "辽宁省丹东市",
"861364357", "山西省临汾市",
"861508512", "贵州省遵义市",
"861873542", "山西省晋中市",
"861814469", "广东省云浮市",
"861770993", "新疆石河子市",
"86133875", "湖北省武汉市",
"861561913", "陕西省渭南市",
"861819525", "宁夏中卫市",
"86170707", "广西南宁市",
"861323587", "浙江省温州市",
"861899731", "青海省西宁市",
"861370331", "河北省石家庄市",
"861859633", "山东省日照市",
"861887291", "湖北省十堰市",
"861501858", "广东省湛江市",
"861454750", "浙江省台州市",
"861379219", "山东省淄博市",
"861568530", "贵州省贵阳市",
"86138786", "广西南宁市",
"861587949", "江西省景德镇市",
"861843840", "河南省焦作市",
"861559548", "宁夏中卫市",
"861361378", "河南省开封市",
"861303955", "内蒙古包头市",
"861823879", "河南省新乡市",
"861459383", "贵州省六盘水市",
"861788520", "贵州省安顺市",
"861860467", "黑龙江省鸡西市",
"861327076", "江苏省泰州市",
"861305321", "安徽省马鞍山市",
"861310359", "山西省运城市",
"861537041", "江苏省无锡市",
"861360318", "河北省衡水市",
"861366353", "山西省阳泉市",
"861572407", "广东省广州市",
"861586624", "山东省枣庄市",
"86151823", "四川省绵阳市",
"861820788", "广西河池市",
"861812690", "广东省汕头市",
"86132383", "广东省东莞市",
"861500150", "新疆和田地区",
"861818833", "四川省乐山市",
"861366567", "安徽省阜阳市",
"861325539", "山东省临沂市",
"861351501", "福建省福州市",
"861339067", "江苏省盐城市",
"861571905", "新疆和田地区",
"86158498", "内蒙古巴彦淖尔市",
"861896931", "浙江省嘉兴市",
"861877894", "广西梧州市",
"861337535", "山东省烟台市",
"86187380", "河南省商丘市",
"861808939", "甘肃省陇南市",
"861332953", "黑龙江省牡丹江市",
"861532472", "河南省郑州市",
"861550926", "陕西省安康市",
"861318174", "山东省济南市",
"861822687", "安徽省阜阳市",
"861339258", "广东省中山市",
"861310034", "湖南省衡阳市",
"86182557", "安徽省宿州市",
"861813906", "新疆巴音郭楞蒙古自治州",
"861899487", "江苏省扬州市",
"861331351", "山西省太原市",
"861324505", "江苏省苏州市",
"861868771", "云南省昆明市",
"861700523", "江苏省泰州市",
"861807196", "湖北省随州市",
"861307003", "新疆阿克苏地区",
"861507548", "河北省衡水市",
"861368507", "福建省宁德市",
"861475786", "浙江省金华市",
"861572680", "浙江省宁波市",
"861565061", "安徽省宿州市",
"861360819", "四川省成都市",
"861310858", "云南省昭通市",
"861316813", "广东省湛江市",
"861308550", "安徽省滁州市",
"86133302", "重庆市",
"861881478", "黑龙江省伊春市",
"86187677", "浙江省温州市",
"861583566", "山西省忻州市",
"861306919", "吉林省通化市",
"861569305", "甘肃省兰州市",
"861380367", "黑龙江省佳木斯市",
"861560410", "辽宁省铁岭市",
"861815390", "甘肃省酒泉市",
"861318572", "浙江省湖州市",
"861398911", "四川省内江市",
"861534506", "福建省漳州市",
"86157500", "云南省红河哈尼族彝族自治州",
"861880418", "辽宁省阜新市",
"861314964", "黑龙江省七台河市",
"861873991", "河南省郑州市",
"861514143", "辽宁省本溪市",
"861557985", "江西省赣州市",
"86185351", "山西省太原市",
"86130416", "上海市",
"861575202", "云南省昆明市",
"861895149", "江苏省连云港市",
"861804088", "新疆喀什地区",
"861302621", "江西省南昌市",
"861527536", "山东省潍坊市",
"861533288", "内蒙古巴彦淖尔市",
"861572839", "广东省汕头市",
"861361879", "云南省普洱市",
"861321298", "黑龙江省佳木斯市",
"861509985", "广东省珠海市",
"861311640", "贵州省安顺市",
"86139285", "广东省佛山市",
"86159675", "浙江省绍兴市",
"861510574", "浙江省宁波市",
"861831936", "广东省肇庆市",
"861535277", "新疆阿克苏地区",
"861800047", "河北省沧州市",
"861329391", "山西省太原市",
"861884896", "河南省洛阳市",
"861365717", "湖北省宜昌市",
"861321861", "江苏省盐城市",
"861330733", "湖南省株洲市",
"861373477", "内蒙古鄂尔多斯市",
"861305294", "江苏省镇江市",
"861385946", "福建省南平市",
"861533647", "山东省东营市",
"861304823", "广东省肇庆市",
"861537075", "江苏省苏州市",
"861380553", "安徽省芜湖市",
"861855130", "江苏省南通市",
"861307049", "新疆伊犁哈萨克自治州",
"861853453", "山西省晋城市",
"861865106", "江苏省宿迁市",
"861868623", "内蒙古鄂尔多斯市",
"86188651", "山东省聊城市",
"861373309", "安徽省宿州市",
"861360927", "陕西省宝鸡市",
"861590976", "青海省玉树藏族自治州",
"861810765", "广东省茂名市",
"861308434", "四川省遂宁市",
"86152560", "安徽省合肥市",
"86135261", "河南省安阳市",
"861333883", "江苏省南通市",
"861552695", "吉林省白城市",
"861328355", "山西省长治市",
"86182129", "贵州省六盘水市",
"86151891", "江苏省镇江市",
"861818373", "云南省红河哈尼族彝族自治州",
"861535329", "陕西省延安市",
"861309719", "江西省萍乡市",
"861870956", "宁夏中卫市",
"86130408", "广东省深圳市",
"861808219", "江苏省盐城市",
"861301172", "山东省济南市",
"861564942", "河南省开封市",
"861500432", "吉林省吉林市",
"861881439", "广东省中山市",
"86132337", "河南省平顶山市",
"861516147", "江苏省南京市",
"861880352", "山西省大同市",
"861787512", "广东省湛江市",
"861707643", "山东省青岛市",
"861304282", "湖北省襄樊市",
"861521893", "广东省佛山市",
"861529363", "甘肃省张掖市",
"861500628", "江苏省南通市",
"86158807", "福建省泉州市",
"86187548", "山东省泰安市",
"861512851", "河北省秦皇岛市",
"861572878", "广东省湛江市",
"861533157", "云南省曲靖市",
"86159995", "广东省深圳市",
"861335449", "山东省枣庄市",
"86177220", "广东省珠海市",
"861820494", "内蒙古鄂尔多斯市",
"861588272", "四川省巴中市",
"86177242", "广东省广州市",
"861829909", "新疆石河子市",
"86176012", "上海市",
"861313266", "广西贵港市",
"861810339", "河北省邢台市",
"861314520", "江苏省徐州市",
"861521955", "广东省江门市",
"861510776", "广西百色市",
"86181722", "广西柳州市",
"861890965", "安徽省蚌埠市",
"861700182", "上海市",
"861597193", "湖北省随州市",
"86136062", "江苏省苏州市",
"861813494", "山西省太原市",
"861519865", "云南省丽江市",
"861511395", "广东省江门市",
"861801470", "江苏省南京市",
"861393400", "山西省忻州市",
"86131131", "广东省东莞市",
"86182385", "河南省安阳市",
"861780543", "山东省滨州市",
"861700612", "江苏省南京市",
"861320266", "广东省东莞市",
"86151716", "湖北省黄冈市",
"861800410", "辽宁省铁岭市",
"861865475", "山东省德州市",
"86159871", "云南省昆明市",
"861525907", "福建省宁德市",
"86177952", "宁夏石嘴山市",
"861345137", "内蒙古鄂尔多斯市",
"861554694", "广东省潮州市",
"861450961", "新疆博尔塔拉蒙古自治州",
"861347492", "内蒙古包头市",
"861338738", "湖南省娄底市",
"86136440", "辽宁省沈阳市",
"861524131", "辽宁省抚顺市",
"86135809", "广东省东莞市",
"861801233", "江苏省扬州市",
"86155149", "河南省商丘市",
"861787771", "湖南省怀化市",
"861351415", "辽宁省丹东市",
"861810054", "福建省泉州市",
"861558015", "湖南省怀化市",
"861839238", "陕西省西安市",
"86185562", "江苏省扬州市",
"861319356", "河南省濮阳市",
"861534704", "湖北省恩施土家族苗族自治州",
"861318853", "辽宁省葫芦岛市",
"861321749", "湖南省邵阳市",
"861537101", "江苏省南京市",
"861522457", "广西钦州市",
"861816600", "江西省抚州市",
"86151975", "湖南省郴州市",
"86159550", "安徽省滁州市",
"861308959", "黑龙江省伊春市",
"861350475", "吉林省吉林市",
"861786904", "云南省普洱市",
"861343189", "广东省惠州市",
"861590371", "河南省郑州市",
"861453414", "辽宁省大连市",
"861318711", "湖南省永州市",
"861575804", "云南省玉溪市",
"861529389", "甘肃省临夏回族自治州",
"861829500", "宁夏银川市",
"861783531", "山西省阳泉市",
"861316030", "江苏省扬州市",
"86189237", "广东省深圳市",
"861592913", "陕西省渭南市",
"861458255", "安徽省蚌埠市",
"861333824", "福建省三明市",
"861376365", "黑龙江省鸡西市",
"861339032", "辽宁省鞍山市",
"861848536", "贵州省黔南布依族苗族自治州",
"861366532", "山东省青岛市",
"861392339", "广东省珠海市",
"861508623", "贵州省黔东南苗族侗族自治州",
"861505106", "江苏省盐城市",
"86133923", "广东省东莞市",
"861556729", "吉林省松原市",
"861829077", "新疆石河子市",
"861771881", "广东省汕头市",
"861473063", "河北省唐山市",
"86183873", "云南省红河哈尼族彝族自治州",
"861305892", "浙江省湖州市",
"86152639", "山东省临沂市",
"861760630", "山东省威海市",
"861317337", "山东省枣庄市",
"861311467", "黑龙江省鸡西市",
"86151708", "江西省吉安市",
"86760", "广东省中山市",
"86151695", "山东省潍坊市",
"861810378", "河南省开封市",
"861870351", "山西省太原市",
"861399751", "湖北省咸宁市",
"861576856", "广东省深圳市",
"861317408", "江苏省南京市",
"861384809", "内蒙古呼伦贝尔市",
"86188855", "贵州省黔东南苗族侗族自治州",
"861338779", "广西北海市",
"861861359", "山西省运城市",
"861326796", "广东省珠海市",
"861323858", "贵州省毕节地区",
"861775418", "安徽省淮北市",
"861599147", "陕西省咸阳市",
"861860432", "吉林省吉林市",
"861782001", "广东省佛山市",
"861760889", "云南省曲靖市",
"861831845", "广东省韶关市",
"861568219", "四川省南充市",
"861345766", "广西桂林市",
"861332895", "福建省宁德市",
"861390425", "辽宁省丹东市",
"861778998", "西藏山南地区",
"861330692", "福建省福州市",
"861860640", "山东省德州市",
"861539572", "浙江省湖州市",
"861820906", "新疆阿勒泰地区",
"86189324", "湖南省长沙市",
"861327698", "福建省泉州市",
"861352328", "河南省许昌市",
"86156627", "山东省济南市",
"861321703", "江西省景德镇市",
"86181454", "黑龙江省佳木斯市",
"861350046", "辽宁省锦州市",
"861588334", "四川省眉山市",
"861831871", "广东省清远市",
"861879959", "新疆和田地区",
"861506552", "山东省聊城市",
"861768324", "四川省成都市",
"861760442", "吉林省吉林市",
"861580648", "山东省潍坊市",
"861776092", "四川省凉山彝族自治州",
"861840416", "辽宁省锦州市",
"861787623", "广东省河源市",
"861323359", "山西省运城市",
"861865046", "福建省福州市",
"861816731", "浙江省嘉兴市",
"861348754", "湖南省衡阳市",
"861454436", "江苏省镇江市",
"861303893", "陕西省西安市",
"861584687", "黑龙江省黑河市",
"861839918", "新疆哈密地区",
"861590345", "山西省长治市",
"861313999", "新疆伊犁哈萨克自治州",
"86150137", "广东省深圳市",
"861538694", "山西省晋中市",
"861760388", "河南省郑州市",
"86147526", "江苏省南通市",
"861354738", "四川省自贡市",
"861538951", "陕西省安康市",
"861817589", "湖南省长沙市",
"86182298", "湖南省长沙市",
"861300395", "福建省漳州市",
"861378305", "河南省漯河市",
"861346516", "山东省德州市",
"861350702", "江西省九江市",
"861780509", "江苏省淮安市",
"861840661", "广东省广州市",
"861811130", "四川省成都市",
"861322504", "福建省宁德市",
"861381459", "江苏省苏州市",
"861800973", "青海省黄南藏族自治州",
"86157565", "四川省成都市",
"86147953", "广西梧州市",
"861308677", "广西贵港市",
"861364589", "浙江省金华市",
"861802311", "广东省河源市",
"861810879", "云南省普洱市",
"861380332", "河北省唐山市",
"861833417", "贵州省毕节地区",
"861520981", "安徽省安庆市",
"861301776", "浙江省嘉兴市",
"861860150", "江苏省盐城市",
"86184594", "福建省莆田市",
"861872450", "黑龙江省哈尔滨市",
"861310587", "浙江省舟山市",
"861322988", "广东省珠海市",
"861459324", "四川省广安市",
"861814802", "四川省绵阳市",
"861822799", "四川省广安市",
"861384843", "内蒙古乌兰察布市",
"861317877", "广东省汕头市",
"861325930", "陕西省延安市",
"861593308", "河北省保定市",
"861539995", "湖南省怀化市",
"861475612", "河北省石家庄市",
"86185473", "内蒙古乌海市",
"861812205", "广东省深圳市",
"86183336", "河北省廊坊市",
"861772652", "四川省德阳市",
"861599938", "新疆和田地区",
"861770855", "贵州省黔东南苗族侗族自治州",
"86188430", "吉林省长春市",
"861867548", "广东省肇庆市",
"861567196", "湖北省孝感市",
"861508771", "云南省玉溪市",
"86883", "云南省临沧市",
"861387184", "湖北省鄂州市",
"861707874", "云南省红河哈尼族彝族自治州",
"861320590", "福建省福州市",
"861459369", "贵州省黔东南苗族侗族自治州",
"861880533", "山东省淄博市",
"861355150", "四川省内江市",
"86182769", "广西柳州市",
"86189283", "广东省惠州市",
"861819931", "新疆乌鲁木齐市",
"861314548", "山东省莱芜市",
"8618422", "天津市",
"861700584", "浙江省宁波市",
"861590831", "四川省资阳市",
"861777176", "湖北省随州市",
"861369816", "四川省泸州市",
"861830753", "广东省梅州市",
"861760701", "江西省鹰潭市",
"861800345", "山西省长治市",
"861321102", "广东省汕尾市",
"861333886", "江苏省扬州市",
"86137704", "江苏省淮安市",
"861319134", "内蒙古呼伦贝尔市",
"86189137", "江苏省苏州市",
"861556563", "河南省焦作市",
"861454518", "湖南省张家界市",
"861869731", "河南省郑州市",
"861818376", "云南省文山壮族苗族自治州",
"861551200", "河北省唐山市",
"8613714", "广东省深圳市",
"86182826", "四川省广安市",
"861865103", "江苏省无锡市",
"861853456", "山西省太原市",
"861537377", "河北省邯郸市",
"861346622", "云南省昭通市",
"861868626", "内蒙古鄂尔多斯市",
"861351829", "四川省南充市",
"861524478", "黑龙江省佳木斯市",
"861585084", "江苏省苏州市",
"861813949", "新疆和田地区",
"861556980", "甘肃省张掖市",
"861590973", "青海省黄南藏族自治州",
"861390452", "黑龙江省齐齐哈尔市",
"861346438", "辽宁省葫芦岛市",
"86137971", "湖北省孝感市",
"861551420", "河南省商丘市",
"861809979", "新疆博尔塔拉蒙古自治州",
"861329855", "湖南省张家界市",
"861569007", "河北省秦皇岛市",
"86187821", "四川省成都市",
"861312467", "贵州省贵阳市",
"86151927", "山东省青岛市",
"86183404", "辽宁省本溪市",
"861863504", "山西省忻州市",
"861503042", "河北省邯郸市",
"861771544", "江苏省常州市",
"86136398", "河南省三门峡市",
"861779590", "陕西省渭南市",
"861835700", "浙江省杭州市",
"861313263", "广西桂林市",
"861351864", "山东省淄博市",
"861870953", "宁夏吴忠市",
"861471458", "广东省深圳市",
"861805489", "福建省南平市",
"861840538", "山东省泰安市",
"861502587", "甘肃省张掖市",
"861830642", "山东省青岛市",
"861569570", "浙江省衢州市",
"861347577", "山东省济宁市",
"861351340", "河北省保定市",
"861598454", "四川省雅安市",
"861871132", "湖南省湘潭市",
"861536070", "广东省湛江市",
"861360690", "福建省厦门市",
"861575198", "甘肃省平凉市",
"861397204", "湖北省宜昌市",
"861394980", "河南省许昌市",
"86139329", "河北省邢台市",
"861785895", "浙江省宁波市",
"861707646", "山东省潍坊市",
"861812318", "四川省达州市",
"861521896", "广东省汕头市",
"861593215", "河北省唐山市",
"86131459", "广东省深圳市",
"861529366", "甘肃省甘南藏族自治州",
"861893298", "河北省唐山市",
"861770822", "广东省汕头市",
"861350977", "山西省临汾市",
"861869487", "浙江省台州市",
"861568805", "贵州省黔东南苗族侗族自治州",
"861514146", "辽宁省铁岭市",
"861806779", "浙江省温州市",
"861522955", "陕西省安康市",
"861365491", "辽宁省大连市",
"86158429", "湖南省邵阳市",
"86137691", "云南省昆明市",
"861527533", "山东省淄博市",
"861559780", "贵州省安顺市",
"861898771", "云南省玉溪市",
"861893861", "广东省清远市",
"86138957", "黑龙江省哈尔滨市",
"861475783", "浙江省台州市",
"861853897", "河南省南阳市",
"861458775", "湖南省湘西土家族苗族自治州",
"861847630", "广东省湛江市",
"861396567", "安徽省合肥市",
"861829768", "安徽省黄山市",
"861380615", "江苏省无锡市",
"861558549", "吉林省白山市",
"861316816", "广东省云浮市",
"861583563", "山西省大同市",
"861866931", "山东省临沂市",
"861343737", "广东省东莞市",
"861840579", "浙江省金华市",
"861820540", "山东省菏泽市",
"861534503", "福建省宁德市",
"86150283", "河北省张家口市",
"86130673", "福建省福州市",
"861882691", "广东省珠海市",
"861334048", "福建省莆田市",
"86145375", "湖南省长沙市",
"861513868", "河南省郑州市",
"861390318", "河北省衡水市",
"861385943", "福建省三明市",
"861328891", "广东省清远市",
"861850491", "内蒙古呼和浩特市",
"861803437", "河北省沧州市",
"861709920", "浙江省衢州市",
"861338259", "江苏省泰州市",
"861304826", "广东省梅州市",
"861537229", "浙江省丽水市",
"86155249", "辽宁省朝阳市",
"861594591", "黑龙江省大庆市",
"861865977", "福建省龙岩市",
"861362604", "福建省龙岩市",
"861337800", "湖南省岳阳市",
"861380556", "安徽省安庆市",
"861809938", "新疆昌吉回族自治州",
"861452398", "西藏拉萨市",
"86134599", "福建省南平市",
"861304541", "黑龙江省佳木斯市",
"861598530", "贵州省安顺市",
"861831933", "广东省湛江市",
"861507780", "江苏省徐州市",
"861877048", "江西省赣州市",
"861890467", "黑龙江省鸡西市",
"861526849", "浙江省绍兴市",
"861884893", "河南省平顶山市",
"861521457", "黑龙江省佳木斯市",
"861782284", "贵州省黔东南苗族侗族自治州",
"861842045", "广东省深圳市",
"861374124", "广东省广州市",
"861776117", "四川省广元市",
"861330736", "湖南省常德市",
"861803308", "广东省深圳市",
"861350149", "广东省阳江市",
"861321988", "四川省德阳市",
"86134841", "浙江省嘉兴市",
"861848352", "四川省泸州市",
"861366356", "山西省晋城市",
"86158903", "河南省开封市",
"86130921", "江苏省盐城市",
"861705372", "海南省海口市",
"861520735", "湖南省郴州市",
"861357474", "湖南省益阳市",
"861700783", "广东省汕头市",
"861896644", "浙江省舟山市",
"861588585", "贵州省毕节地区",
"861597792", "广西南宁市",
"861589232", "四川省资阳市",
"861871450", "黑龙江省哈尔滨市",
"861830554", "安徽省淮南市",
"861589608", "江苏省宿迁市",
"86156675", "陕西省延安市",
"861709948", "浙江省嘉兴市",
"86131561", "山东省济南市",
"861869600", "湖北省荆门市",
"861811425", "江苏省泰州市",
"861773951", "河南省焦作市",
"861773694", "河北省石家庄市",
"86180550", "安徽省滁州市",
"861304575", "浙江省绍兴市",
"86131518", "江苏省淮安市",
"861858242", "四川省乐山市",
"861815068", "福建省漳州市",
"861459386", "贵州省黔西南布依族苗族自治州",
"861880734", "湖南省衡阳市",
"861811205", "江苏省盐城市",
"861550923", "陕西省榆林市",
"861336454", "吉林省长春市",
"861301256", "山东省烟台市",
"861389950", "新疆石河子市",
"861837522", "贵州省黔南布依族苗族自治州",
"861452899", "云南省昆明市",
"861898745", "云南省昆明市",
"861813903", "新疆昌吉回族自治州",
"861820528", "江苏省镇江市",
"861539497", "云南省昆明市",
"861537837", "四川省阿坝藏族羌族自治州",
"861807193", "湖北省恩施土家族苗族自治州",
"861772709", "广东省清远市",
"861500965", "宁夏中卫市",
"861570547", "山东省济宁市",
"861307006", "新疆克孜勒苏柯尔克孜自治州",
"861865149", "江苏省连云港市",
"861390819", "四川省成都市",
"861818836", "四川省凉山彝族自治州",
"861700841", "贵州省贵阳市",
"861398507", "贵州省黔南布依族苗族自治州",
"861595061", "江苏省宿迁市",
"861313444", "吉林省吉林市",
"861365304", "广东省茂名市",
"86180871", "云南省昆明市",
"86157374", "河南省许昌市",
"861368911", "陕西省延安市",
"861378979", "内蒙古赤峰市",
"861590410", "辽宁省铁岭市",
"861876238", "江苏省盐城市",
"861309474", "浙江省衢州市",
"861332956", "黑龙江省鸡西市",
"861533998", "山东省德州市",
"861308718", "内蒙古鄂尔多斯市",
"861335001", "四川省绵阳市",
"861303080", "福建省三明市",
"861351328", "河北省保定市",
"861538567", "安徽省亳州市",
"86153758", "福建省泉州市",
"86137623", "湖南省株洲市",
"861350659", "浙江省金华市",
"861526803", "浙江省舟山市",
"861323727", "湖北省荆门市",
"861339365", "广西玉林市",
"861357662", "江西省吉安市",
"861830430", "吉林省长春市",
"861857218", "湖北省武汉市",
"861331895", "广东省珠海市",
"861768386", "湖北省武汉市",
"861871534", "安徽省芜湖市",
"861364566", "安徽省池州市",
"86153181", "山东省泰安市",
"86132052", "江苏省无锡市",
"861846974", "云南省红河哈尼族彝族自治州",
"861594942", "内蒙古包头市",
"861805842", "浙江省杭州市",
"861876279", "江苏省扬州市",
"861771142", "四川省泸州市",
"861378938", "湖南省衡阳市",
"861348553", "安徽省芜湖市",
"861537443", "甘肃省平凉市",
"86145802", "江苏省南通市",
"861479710", "山西省朔州市",
"861377673", "江苏省淮安市",
"861458402", "河南省商丘市",
"861770996", "新疆巴音郭楞蒙古自治州",
"861828908", "西藏昌都地区",
"861534549", "山东省聊城市",
"861561916", "陕西省汉中市",
"861348367", "河北省石家庄市",
"861336530", "山东省菏泽市",
"861862858", "陕西省咸阳市",
"861800371", "河南省郑州市",
"861857147", "湖北省武汉市",
"861812819", "广东省阳江市",
"861315262", "广西柳州市",
"861551448", "河南省驻马店市",
"861859636", "山东省济南市",
"861305508", "湖南省岳阳市",
"861858721", "云南省大理白族自治州",
"861538353", "山西省阳泉市",
"861337323", "河北省沧州市",
"861356942", "河南省新乡市",
"86182620", "江苏省苏州市",
"861895106", "江苏省宿迁市",
"861560976", "青海省玉树藏族自治州",
"861831213", "广东省湛江市",
"861508251", "四川省阿坝藏族羌族自治州",
"861848418", "贵州省安顺市",
"861309662", "山西省临汾市",
"861321504", "福建省福州市",
"861319532", "安徽省芜湖市",
"861382459", "广东省梅州市",
"86182642", "山东省枣庄市",
"861804819", "四川省绵阳市",
"861350951", "福建省南平市",
"86178023", "重庆市",
"861570555", "安徽省马鞍山市",
"861839342", "甘肃省定西市",
"86156040", "辽宁省沈阳市",
"861840986", "新疆昌吉回族自治州",
"861369390", "河南省开封市",
"861853077", "河南省商丘市",
"86156022", "广东省广州市",
"861780032", "河北省保定市",
"861814913", "陕西省渭南市",
"86151437", "吉林省辽源市",
"861520666", "山东省济南市",
"861898757", "云南省昆明市",
"861872940", "陕西省西安市",
"861355823", "广西桂林市",
"861804130", "辽宁省抚顺市",
"861570461", "黑龙江省哈尔滨市",
"861773149", "河北省唐山市",
"86184545", "山东省烟台市",
"861816864", "江苏省连云港市",
"861510520", "江苏省徐州市",
"861835978", "福建省福州市",
"86186016", "上海市",
"861816340", "广东省珠海市",
"861553389", "河北省唐山市",
"861314776", "吉林省吉林市",
"861573867", "河南省新乡市",
"861538046", "江苏省常州市",
"861306244", "福建省厦门市",
"861500884", "云南省文山壮族苗族自治州",
"861337597", "福建省三明市",
"861331446", "贵州省铜仁地区",
"861359858", "河南省信阳市",
"861781434", "内蒙古兴安盟",
"861479464", "黑龙江省七台河市",
"861362636", "山东省潍坊市",
"861833987", "河南省三门峡市",
"86189918", "陕西省西安市",
"861787840", "广西梧州市",
"861571676", "河南省周口市",
"861815245", "宁夏中卫市",
"861819717", "青海省海东地区",
"861890575", "浙江省绍兴市",
"861322352", "山西省大同市",
"861583371", "河北省邢台市",
"861561424", "河北省保定市",
"86130575", "江苏省南京市",
"86147199", "新疆阿克苏地区",
"86180154", "江苏省苏州市",
"861809645", "安徽省安庆市",
"861770750", "广东省江门市",
"861839488", "甘肃省陇南市",
"861562486", "内蒙古赤峰市",
"861813675", "江苏省苏州市",
"861341841", "广东省佛山市",
"861330704", "江西省抚州市",
"861817047", "江西省赣州市",
"861318148", "山东省临沂市",
"861768797", "江西省赣州市",
"861382494", "广东省清远市",
"861860823", "四川省达州市",
"861816829", "江苏省扬州市",
"861521471", "浙江省金华市",
"861856965", "湖南省邵阳市",
"861570616", "江苏省常州市",
"861590764", "广东省中山市",
"86181814", "四川省成都市",
"861531535", "山东省烟台市",
"861599122", "陕西省榆林市",
"861809586", "新疆阿勒泰地区",
"861325544", "山东省德州市",
"861808944", "甘肃省天水市",
"86135508", "四川省绵阳市",
"861555337", "山东省滨州市",
"861365876", "云南省文山壮族苗族自治州",
"861570066", "四川省自贡市",
"861888296", "四川省甘孜藏族自治州",
"861760952", "宁夏石嘴山市",
"861879449", "甘肃省庆阳市",
"861586389", "山东省德州市",
"861377905", "新疆阿勒泰地区",
"861322418", "辽宁省阜新市",
"861857723", "广西来宾市",
"861518900", "江苏省连云港市",
"861310049", "广西柳州市",
"861339543", "山东省滨州市",
"861338321", "河北省石家庄市",
"861471789", "山西省晋城市",
"861308403", "安徽省六安市",
"861358265", "河北省唐山市",
"861301548", "山西省太原市",
"861370493", "辽宁省抚顺市",
"86185985", "重庆市",
"861525610", "安徽省淮北市",
"861308223", "辽宁省盘锦市",
"86153963", "福建省泉州市",
"86189906", "四川省乐山市",
"86158186", "广东省深圳市",
"861381949", "浙江省杭州市",
"861452854", "甘肃省武威市",
"861317682", "山东省泰安市",
"86158939", "河南省驻马店市",
"861831728", "河南省焦作市",
"861850876", "云南省文山壮族苗族自治州",
"861336499", "新疆克拉玛依市",
"861590729", "湖北省孝感市",
"861328476", "内蒙古赤峰市",
"861347465", "陕西省西安市",
"861885031", "福建省厦门市",
"861317112", "内蒙古通辽市",
"861459797", "新疆巴音郭楞蒙古自治州",
"861775102", "江苏省南京市",
"861536890", "云南省西双版纳傣族自治州",
"861332790", "江苏省无锡市",
"861862742", "湖南省常德市",
"86180785", "广西玉林市",
"861588517", "贵州省铜仁地区",
"861312575", "吉林省通化市",
"861816917", "宁夏固原市",
"861857586", "广东省佛山市",
"861835939", "福建省宁德市",
"861459663", "新疆喀什地区",
"861569784", "江西省南昌市",
"861331041", "贵州省遵义市",
"861373053", "河北省衡水市",
"861766649", "广东省江门市",
"861890992", "新疆乌鲁木齐市",
"861822553", "安徽省芜湖市",
"861520016", "河北省邢台市",
"861763546", "山西省吕梁市",
"861836141", "江苏省镇江市",
"861814233", "陕西省渭南市",
"861386822", "浙江省舟山市",
"861893533", "山西省长治市",
"861800980", "辽宁省朝阳市",
"861396702", "浙江省衢州市",
"86136667", "浙江省嘉兴市",
"861538475", "内蒙古通辽市",
"861331075", "贵州省黔东南苗族侗族自治州",
"861839794", "江西省抚州市",
"861513505", "山西省运城市",
"86180369", "江苏省宿迁市",
"861776615", "江苏省宿迁市",
"86131632", "湖北省武汉市",
"861556345", "山东省青岛市",
"861317514", "浙江省杭州市",
"861554046", "内蒙古鄂尔多斯市",
"861850525", "江苏省镇江市",
"861335550", "安徽省滁州市",
"861361792", "江西省九江市",
"861312541", "辽宁省沈阳市",
"861810633", "山东省日照市",
"861882999", "广东省广州市",
"861800563", "安徽省宣城市",
"861866639", "广东省佛山市",
"861380248", "广东省佛山市",
"86145260", "江苏省南京市",
"86137292", "广东省汕头市",
"861534692", "甘肃省定西市",
"861340121", "江苏省泰州市",
"86153345", "重庆市",
"861516583", "山东省聊城市",
"861453508", "山东省淄博市",
"861301520", "内蒙古呼和浩特市",
"861560589", "浙江省金华市",
"861580437", "吉林省辽源市",
"861708934", "广东省湛江市",
"861539962", "安徽省安庆市",
"861555240", "山东省东营市",
"861800357", "山西省临汾市",
"861338294", "江苏省连云港市",
"861760427", "辽宁省盘锦市",
"861802598", "广东省佛山市",
"861454286", "辽宁省丹东市",
"861394345", "吉林省白城市",
"861550738", "湖南省娄底市",
"861329847", "河南省焦作市",
"86151483", "内蒙古赤峰市",
"861392196", "江苏省苏州市",
"861571581", "浙江省杭州市",
"86134226", "广东省江门市",
"861508277", "四川省南充市",
"86151644", "吉林省松原市",
"861365525", "江苏省扬州市",
"861572844", "广东省东莞市",
"861367470", "内蒙古呼伦贝尔市",
"861504716", "内蒙古通辽市",
"86188415", "辽宁省丹东市",
"861895134", "江苏省徐州市",
"861890541", "山东省济南市",
"861583345", "河北省唐山市",
"861889490", "河北省秦皇岛市",
"861329433", "吉林省延边朝鲜族自治州",
"861340815", "四川省遂宁市",
"861535684", "浙江省宁波市",
"861342182", "广东省深圳市",
"861318120", "山东省临沂市",
"861875258", "江苏省徐州市",
"861815271", "湖南省怀化市",
"861563997", "河南省平顶山市",
"861335434", "吉林省四平市",
"861887119", "湖北省武汉市",
"861848749", "云南省大理白族自治州",
"861471801", "广东省梅州市",
"861529683", "广西玉林市",
"861880706", "江西省吉安市",
"861580843", "四川省南充市",
"861328045", "山东省聊城市",
"861842057", "广东省阳江市",
"861569498", "河北省邯郸市",
"861832496", "安徽省安庆市",
"861890826", "重庆市",
"86158747", "湖南省衡阳市",
"861593287", "江西省萍乡市",
"861550779", "广西北海市",
"861453984", "广东省肇庆市",
"861514587", "黑龙江省鹤岗市",
"861813641", "江苏省苏州市",
"861399902", "新疆巴音郭楞蒙古自治州",
"861522947", "陕西省宝鸡市",
"86156573", "浙江省嘉兴市",
"861394831", "内蒙古呼和浩特市",
"86137317", "河北省沧州市",
"86188024", "辽宁省沈阳市",
"861508364", "江西省新余市",
"861354321", "广东省梅州市",
"861307034", "新疆吐鲁番地区",
"861383425", "山西省大同市",
"861825017", "福建省福州市",
"861308449", "四川省绵阳市",
"861303698", "广西河池市",
"861371990", "广东省汕头市",
"861339509", "福建省泉州市",
"861310003", "山西省阳泉市",
"861379944", "福建省福州市",
"861510548", "山东省泰安市",
"861580781", "广西南宁市",
"861593648", "河南省安阳市",
"861598499", "四川省凉山彝族自治州",
"861365336", "河北省秦皇岛市",
"861879403", "甘肃省甘南藏族自治州",
"861533513", "江苏省徐州市",
"861866678", "广东省肇庆市",
"861827215", "湖北省黄冈市",
"861359359", "山西省运城市",
"861818804", "贵州省黔南布依族苗族自治州",
"861862394", "河南省周口市",
"861816237", "湖北省襄樊市",
"861536762", "湖南省娄底市",
"861332862", "福建省南平市",
"861321325", "河南省安阳市",
"861830627", "江苏省南通市",
"861341908", "四川省达州市",
"861590357", "山西省临汾市",
"861320478", "内蒙古巴彦淖尔市",
"861857569", "广东省深圳市",
"861829897", "甘肃省嘉峪关市",
"861889968", "新疆巴音郭楞蒙古自治州",
"861394973", "河南省濮阳市",
"861770433", "吉林省延边朝鲜族自治州",
"861892146", "江苏省南通市",
"861458330", "江西省上饶市",
"861521138", "湖南省衡阳市",
"861305414", "湖南省湘潭市",
"861569583", "浙江省嘉兴市",
"861850552", "安徽省蚌埠市",
"861816415", "湖北省黄冈市",
"861325881", "吉林省延边朝鲜族自治州",
"861537953", "宁夏吴忠市",
"861822754", "四川省内江市",
"861351600", "辽宁省沈阳市",
"86156944", "山东省青岛市",
"861505134", "江苏省盐城市",
"861867256", "湖北省荆州市",
"861834407", "广东省惠州市",
"861321418", "辽宁省阜新市",
"861879141", "陕西省延安市",
"861874014", "辽宁省本溪市",
"861569960", "黑龙江省哈尔滨市",
"861472789", "陕西省商洛市",
"861470249", "辽宁省大连市",
"86151593", "福建省宁德市",
"861454391", "贵州省贵阳市",
"861368481", "江西省南昌市",
"861339744", "湖南省张家界市",
"861843626", "河南省周口市",
"861590980", "辽宁省鞍山市",
"861800605", "福建省泉州市",
"861556973", "甘肃省庆阳市",
"861880861", "湖北省荆州市",
"86185631", "山东省威海市",
"861365552", "安徽省蚌埠市",
"861331790", "江西省新余市",
"861773702", "河南省驻马店市",
"861554103", "辽宁省营口市",
"861805239", "江苏省淮安市",
"86131967", "江苏省常州市",
"861861742", "河北省邢台市",
"861812591", "广东省湛江市",
"86138676", "浙江省台州市",
"861824064", "河南省安阳市",
"861569726", "湖北省恩施土家族苗族自治州",
"861874472", "贵州省安顺市",
"861819880", "广东省中山市",
"861564690", "新疆博尔塔拉蒙古自治州",
"861399777", "湖北省恩施土家族苗族自治州",
"861453892", "云南省大理白族自治州",
"861870377", "河南省南阳市",
"861503533", "山西省阳泉市",
"86147711", "广东省广州市",
"861513663", "河南省商丘市",
"861522076", "广东省江门市",
"861332041", "云南省丽江市",
"86130527", "辽宁省大连市",
"861576962", "宁夏石嘴山市",
"861809569", "安徽省宿州市",
"861590563", "安徽省宣城市",
"861568631", "陕西省渭南市",
"861771210", "江苏省镇江市",
"861325743", "湖南省湘西土家族苗族自治州",
"86159369", "河南省周口市",
"861311575", "浙江省绍兴市",
"861305072", "辽宁省阜新市",
"861377227", "陕西省延安市",
"861804205", "浙江省宁波市",
"861315050", "云南省玉溪市",
"86152724", "湖北省荆州市",
"861869328", "甘肃省兰州市",
"861826539", "山东省临沂市",
"861773441", "河北省石家庄市",
"861330503", "福建省宁德市",
"861367311", "河北省石家庄市",
"86157110", "北京市",
"86138469", "黑龙江省双鸭山市",
"861527042", "江西省宜春市",
"861362344", "山西省运城市",
"861805278", "江苏省宿迁市",
"861337664", "广东省汕尾市",
"861886768", "浙江省嘉兴市",
"86187733", "湖南省株洲市",
"86153682", "云南省昆明市",
"86138029", "广东省广州市",
"861814311", "吉林省四平市",
"861308175", "辽宁省辽阳市",
"861840924", "陕西省渭南市",
"86132657", "广东省深圳市",
"861869237", "湖南省常德市",
"861554977", "湖北省随州市",
"861556107", "内蒙古包头市",
"861808499", "四川省达州市",
"861871940", "广东省广州市",
"861803648", "江苏省常州市",
"861380092", "北京市",
"861819678", "安徽省马鞍山市",
"861310146", "福建省泉州市",
"861350353", "山西省阳泉市",
"861897172", "湖北省黄冈市",
"861562424", "山东省潍坊市",
"86182141", "云南省玉溪市",
"861348799", "湖南省娄底市",
"861534736", "湖南省常德市",
"86130315", "河北省唐山市",
"861452511", "山东省淄博市",
"86180254", "广东省深圳市",
"861828095", "四川省广安市",
"861332446", "吉林省长春市",
"861337629", "江苏省常州市",
"861538659", "四川省泸州市",
"861311992", "新疆伊犁哈萨克自治州",
"861528668", "贵州省六盘水市",
"861500541", "山东省济南市",
"861350567", "安徽省阜阳市",
"861572676", "西藏那曲地区",
"861562204", "广东省茂名市",
"861320439", "吉林省白山市",
"861313691", "黑龙江省绥化市",
"861361636", "山东省潍坊市",
"861806321", "山东省枣庄市",
"861313954", "宁夏固原市",
"861390591", "福建省福州市",
"861865353", "山东省临沂市",
"861840969", "宁夏吴忠市",
"861559773", "贵州省遵义市",
"861534087", "山西省晋城市",
"861786936", "云南省临沧市",
"86188331", "河北省石家庄市",
"861522471", "河南省信阳市",
"861705203", "福建省福州市",
"861520689", "山东省滨州市",
"86135376", "广东省深圳市",
"861341584", "广东省茂名市",
"861802483", "广东省惠州市",
"86138996", "新疆昌吉回族自治州",
"861341182", "广东省佛山市",
"861500575", "浙江省绍兴市",
"861326387", "广西来宾市",
"86159154", "广东省深圳市",
"861370588", "浙江省温州市",
"86150961", "湖南省郴州市",
"86152603", "福建省泉州市",
"861351731", "湖南省长沙市",
"861518546", "贵州省黔南布依族苗族自治州",
"861317097", "江西省赣州市",
"861356819", "四川省达州市",
"861890884", "云南省昆明市",
"861325709", "江西省南昌市",
"861882444", "广东省揭阳市",
"861806294", "湖北省黄石市",
"86151521", "江苏省徐州市",
"861518821", "河南省南阳市",
"861377878", "四川省巴中市",
"861317851", "广东省佛山市",
"861837547", "山东省济宁市",
"861869829", "辽宁省葫芦岛市",
"861383927", "河南省濮阳市",
"861323401", "辽宁省沈阳市",
"861886946", "云南省红河哈尼族彝族自治州",
"861315295", "山西省长治市",
"861570522", "江苏省徐州市",
"861554149", "辽宁省葫芦岛市",
"861589482", "内蒙古呼伦贝尔市",
"861365644", "山东省淄博市",
"861897574", "湖南省郴州市",
"861522445", "山东省青岛市",
"861320807", "浙江省宁波市",
"861873431", "山西省阳泉市",
"861858407", "四川省成都市",
"861559885", "内蒙古巴彦淖尔市",
"86137577", "浙江省温州市",
"861773475", "河南省洛阳市",
"86156313", "河北省张家口市",
"861568700", "云南省昭通市",
"861470423", "辽宁省抚顺市",
"861803620", "江苏省南通市",
"861316390", "福建省厦门市",
"861871928", "广东省深圳市",
"861896304", "山东省日照市",
"861861394", "湖南省常德市",
"861888708", "云南省西双版纳傣族自治州",
"861850644", "山东省日照市",
"86177734", "湖南省衡阳市",
"86155761", "湖南省常德市",
"861769247", "河北省沧州市",
"86136341", "浙江省杭州市",
"861700770", "广西南宁市",
"861339392", "河南省周口市",
"861331862", "广东省清远市",
"861322325", "河北省邢台市",
"861823636", "河南省商丘市",
"861858338", "四川省成都市",
"86155718", "湖北省恩施土家族苗族自治州",
"861558167", "湖南省邵阳市",
"861308141", "山东省东营市",
"861898828", "云南省昆明市",
"861453760", "广西南宁市",
"86155706", "湖北省襄樊市",
"861889746", "湖南省永州市",
"861351487", "内蒙古鄂尔多斯市",
"86135833", "山东省淄博市",
"861835805", "浙江省舟山市",
"86159785", "河南省信阳市",
"861454269", "西藏拉萨市",
"86139882", "云南省德宏傣族景颇族自治州",
"861458118", "安徽省阜阳市",
"861776872", "江苏省泰州市",
"86138870", "云南省昭通市",
"861576008", "四川省宜宾市",
"861311826", "四川省南充市",
"86152452", "黑龙江省齐齐哈尔市",
"861813459", "安徽省黄山市",
"861863418", "河北省保定市",
"861800729", "湖北省孝感市",
"861458688", "湖南省湘潭市",
"861820934", "甘肃省庆阳市",
"861500992", "新疆伊犁哈萨克自治州",
"861881999", "广东省惠州市",
"861760925", "陕西省安康市",
"861311541", "黑龙江省哈尔滨市",
"861831857", "广东省广州市",
"861558736", "山东省烟台市",
"861340464", "吉林省四平市",
"86137192", "广东省广州市",
"861560566", "安徽省池州市",
"861551637", "河南省洛阳市",
"861332075", "四川省广元市",
"861365154", "江苏省淮安市",
"861580935", "甘肃省金昌市",
"861832740", "湖北省襄樊市",
"861554659", "黑龙江省鹤岗市",
"861520370", "河南省商丘市",
"861887016", "江西省鹰潭市",
"861362792", "江西省九江市",
"861771127", "四川省乐山市",
"861810099", "新疆乌鲁木齐市",
"861775703", "浙江省宁波市",
"861363553", "安徽省芜湖市",
"861364976", "青海省玉树藏族自治州",
"861398163", "四川省雅安市",
"861471948", "甘肃省酒泉市",
"86138551", "安徽省合肥市",
"861801598", "江苏省镇江市",
"861317713", "湖北省恩施土家族苗族自治州",
"86187787", "广西钦州市",
"861302520", "广东省汕头市",
"861505532", "安徽省芜湖市",
"861800764", "广东省揭阳市",
"861515662", "安徽省淮南市",
"861318435", "浙江省台州市",
"861769870", "河南省焦作市",
"861538977", "内蒙古鄂尔多斯市",
"861454404", "福建省漳州市",
"861329750", "湖北省鄂州市",
"861572581", "山东省淄博市",
"861452176", "吉林省白城市",
"861571844", "广东省广州市",
"861323742", "湖南省长沙市",
"86150906", "河南省商丘市",
"861352985", "云南省曲靖市",
"861340429", "江苏省南通市",
"861571360", "河南省商丘市",
"86188920", "陕西省西安市",
"861597765", "广西南宁市",
"861450624", "黑龙江省齐齐哈尔市",
"861330549", "山东省临沂市",
"861319043", "辽宁省锦州市",
"861308994", "黑龙江省绥化市",
"861507621", "河北省唐山市",
"861308651", "四川省广元市",
"861322536", "山东省潍坊市",
"861303073", "辽宁省本溪市",
"861388246", "四川省凉山彝族自治州",
"861377839", "四川省甘孜藏族自治州",
"86159338", "河北省衡水市",
"861336311", "河北省石家庄市",
"861452883", "云南省临沧市",
"861313708", "河南省南阳市",
"861766023", "山东省青岛市",
"861306213", "福建省莆田市",
"861395124", "江苏省宿迁市",
"861529542", "江苏省无锡市",
"861582585", "甘肃省平凉市",
"861807189", "湖北省荆州市",
"861821841", "广东省深圳市",
"861355995", "福建省福州市",
"861705051", "福建省厦门市",
"861550041", "吉林省四平市",
"861587672", "广东省梅州市",
"861300067", "浙江省温州市",
"86155591", "福建省泉州市",
"86178783", "广西玉林市",
"86132290", "广东省肇庆市",
"861850782", "广西来宾市",
"861569753", "广东省梅州市",
"861350535", "山东省烟台市",
"861890285", "广东省深圳市",
"861533142", "云南省文山壮族苗族自治州",
"861570931", "甘肃省兰州市",
"861454681", "广东省广州市",
"86181633", "湖北省武汉市",
"861361313", "河北省张家口市",
"861700799", "江西省南昌市",
"86187293", "陕西省西安市",
"861320986", "山西省临汾市",
"861454111", "安徽省合肥市",
"861365782", "广西柳州市",
"861360373", "河南省新乡市",
"861860995", "新疆吐鲁番地区",
"861564957", "河南省驻马店市",
"861812836", "广东省茂名市",
"861314403", "广东省中山市",
"861537926", "甘肃省庆阳市",
"861806895", "江苏省南通市",
"861880347", "山西省临汾市",
"861894685", "青海省果洛藏族自治州",
"861338956", "宁夏中卫市",
"861586527", "山东省济南市",
"86180271", "广东省广州市",
"861450281", "内蒙古鄂尔多斯市",
"861506170", "江苏省徐州市",
"861362911", "陕西省延安市",
"861452741", "湖南省长沙市",
"861520399", "河南省信阳市",
"86188319", "河北省邢台市",
"861899859", "广东省肇庆市",
"861500853", "贵州省安顺市",
"861523434", "山西省阳泉市",
"861813246", "河北省唐山市",
"861454825", "广东省湛江市",
"861366472", "内蒙古包头市",
"861771998", "河南省焦作市",
"86152980", "四川省乐山市",
"861355572", "辽宁省辽阳市",
"861510959", "宁夏固原市",
"861764533", "黑龙江省牡丹江市",
"861560918", "陕西省渭南市",
"861375980", "陕西省汉中市",
"861894546", "黑龙江省伊春市",
"861567083", "河南省周口市",
"861843143", "河北省保定市",
"861801454", "江苏省泰州市",
"861807024", "江西省九江市",
"861505921", "福建省漳州市",
"861313381", "江西省南昌市",
"861880910", "陕西省咸阳市",
"861815676", "安徽省亳州市",
"86145202", "北京市",
"861883435", "山西省晋城市",
"861323684", "辽宁省鞍山市",
"861573943", "新疆乌鲁木齐市",
"86150837", "江西省赣州市",
"861379470", "广东省河源市",
"861853832", "河南省郑州市",
"861893322", "广东省广州市",
"861300187", "河北省保定市",
"861860572", "浙江省湖州市",
"86180465", "北京市",
"861770361", "黑龙江省哈尔滨市",
"861810507", "福建省泉州市",
"861579879", "云南省迪庆藏族自治州",
"861569811", "山东省青岛市",
"861364794", "江西省抚州市",
"861350326", "河北省廊坊市",
"861868858", "广东省肇庆市",
"861818819", "贵州省黔西南布依族苗族自治州",
"861343792", "江西省九江市",
"861303866", "云南省玉溪市",
"861308776", "广西百色市",
"86138438", "吉林省松原市",
"86180025", "广东省深圳市",
"861301677", "江苏省南通市",
"861532353", "广东省东莞市",
"861893607", "江苏省无锡市",
"861852721", "湖北省荆门市",
"861787587", "广东省阳江市",
"861587209", "湖北省荆州市",
"86176030", "广东省深圳市",
"861877415", "湖南省湘潭市",
"861310745", "湖南省怀化市",
"861818130", "四川省凉山彝族自治州",
"861857276", "湖北省孝感市",
"861514828", "内蒙古兴安盟",
"861768044", "湖南省岳阳市",
"861810070", "湖北省武汉市",
"86181370", "河南省商丘市",
"861516642", "山东省青岛市",
"86155956", "海南省海口市",
"861314449", "广东省汕尾市",
"861306933", "河南省开封市",
"86147598", "福建省三明市",
"861335817", "江苏省常州市",
"861311711", "湖北省武汉市",
"861457005", "山东省烟台市",
"861339682", "浙江省湖州市",
"861867449", "湖南省长沙市",
"861310771", "浙江省杭州市",
"861805493", "福建省南平市",
"86155523", "山东省菏泽市",
"861572813", "广东省东莞市",
"861778743", "云南省临沧市",
"861598311", "四川省宜宾市",
"861804804", "四川省成都市",
"861580967", "宁夏中卫市",
"861501623", "广东省河源市",
"861470456", "黑龙江省黑河市",
"861539432", "浙江省宁波市",
"861555032", "山东省淄博市",
"861889516", "宁夏固原市",
"861520261", "宁夏银川市",
"861551665", "河南省鹤壁市",
"861363335", "河北省秦皇岛市",
"861822062", "陕西省榆林市",
"861535653", "浙江省温州市",
"861522863", "四川省自贡市",
"861326763", "广东省中山市",
"861837093", "江西省萍乡市",
"861893480", "广西桂林市",
"861575942", "福建省福州市",
"86131748", "天津市",
"861318467", "江西省宜春市",
"861761291", "陕西省咸阳市",
"861774699", "河南省许昌市",
"861560279", "广东省潮州市",
"861524416", "山东省淄博市",
"86183173", "河南省安阳市",
"861872012", "江西省赣州市",
"86150756", "河北省廊坊市",
"861508587", "贵州省六盘水市",
"86151763", "河北省保定市",
"86186448", "吉林省四平市",
"861592454", "内蒙古通辽市",
"861333060", "四川省雅安市",
"861355174", "四川省攀枝花市",
"861454576", "四川省资阳市",
"861331779", "广西北海市",
"861589297", "四川省达州市",
"861372657", "广东省韶关市",
"861317543", "浙江省金华市",
"86138574", "浙江省宁波市",
"861326697", "广东省东莞市",
"861708429", "云南省文山壮族苗族自治州",
"861778625", "湖北省随州市",
"861560602", "福建省福州市",
"861501745", "广东省珠海市",
"861379913", "福建省南平市",
"861560238", "广东省广州市",
"861562805", "贵州省毕节地区",
"861366705", "江西省宜春市",
"861593000", "河北省邯郸市",
"861345017", "广东省肇庆市",
"861776769", "新疆乌鲁木齐市",
"861364488", "内蒙古呼和浩特市",
"861587243", "湖北省武汉市",
"861363841", "湖南省永州市",
"861528955", "广西南宁市",
"861319597", "甘肃省酒泉市",
"861309733", "江西省赣州市",
"861839047", "湖南省郴州市",
"861331738", "湖南省娄底市",
"861452775", "广西玉林市",
"861390376", "河南省信阳市",
"861855447", "山东省济南市",
"86150883", "浙江省湖州市",
"861870865", "贵州省六盘水市",
"861780337", "河北省沧州市",
"861573909", "新疆博尔塔拉蒙古自治州",
"861533544", "山东省德州市",
"861530985", "辽宁省沈阳市",
"861372218", "内蒙古巴彦淖尔市",
"861324767", "广东省广州市",
"861335964", "黑龙江省佳木斯市",
"861322891", "西藏拉萨市",
"861572751", "江西省景德镇市",
"861357733", "云南省红河哈尼族彝族自治州",
"861329580", "浙江省舟山市",
"861376851", "广西南宁市",
"861535143", "四川省阿坝藏族羌族自治州",
"861889145", "陕西省安康市",
"86139935", "甘肃省武威市",
"861899412", "江苏省南京市",
"861881413", "广东省广州市",
"861332259", "西藏拉萨市",
"861822612", "安徽省亳州市",
"861322268", "江苏省扬州市",
"861808233", "江苏省泰州市",
"86155849", "吉林省白山市",
"861821875", "广东省湛江市",
"861301959", "内蒙古赤峰市",
"861880473", "内蒙古乌海市",
"861597481", "云南省昆明市",
"861529144", "陕西省商洛市",
"861524011", "安徽省阜阳市",
"861329963", "广西桂林市",
"861458398", "福建省南平市",
"861322057", "山东省济南市",
"861360447", "吉林省吉林市",
"86152397", "河南省焦作市",
"861311853", "贵州省安顺市",
"861372147", "河南省焦作市",
"861580814", "四川省雅安市",
"861343860", "四川省眉山市",
"861364342", "山西省大同市",
"86188784", "广西梧州市",
"861328749", "山东省菏泽市",
"861772998", "安徽省六安市",
"86153881", "四川省成都市",
"861535221", "甘肃省天水市",
"861477849", "广东省深圳市",
"861569273", "贵州省安顺市",
"861346578", "山东省济宁市",
"861390660", "浙江省宁波市",
"861882970", "陕西省西安市",
"861476027", "福建省龙岩市",
"861344064", "上海市",
"861313983", "新疆阿勒泰地区",
"861576628", "广东省肇庆市",
"861860856", "贵州省铜仁地区",
"86136326", "广东省深圳市",
"861301718", "湖南省长沙市",
"861535401", "河北省石家庄市",
"86188579", "浙江省金华市",
"861826647", "山东省东营市",
"861572245", "江苏省无锡市",
"861558382", "四川省德阳市",
"861533709", "甘肃省白银市",
"861584769", "内蒙古包头市",
"861537508", "安徽省巢湖市",
"861300778", "青海省西宁市",
"861373421", "山西省大同市",
"861313560", "湖北省孝感市",
"861839976", "新疆乌鲁木齐市",
"861898587", "贵州省毕节地区",
"861358237", "河北省保定市",
"86189756", "湖南省常德市",
"861325714", "湖北省黄冈市",
"861344029", "江苏省扬州市",
"861845881", "浙江省温州市",
"861369839", "四川省乐山市",
"861334917", "安徽省亳州市",
"861370827", "四川省南充市",
"861477320", "湖南省湘潭市",
"861515940", "福建省宁德市",
"861345192", "江苏省南京市",
"861826288", "江苏省镇江市",
"861770580", "浙江省舟山市",
"861355856", "四川省巴中市",
"861856120", "山东省东营市",
"861532951", "贵州省遵义市",
"861347437", "陕西省西安市",
"861569430", "吉林省长春市",
"861840478", "内蒙古巴彦淖尔市",
"861823231", "河北省张家口市",
"861587121", "湖北省黄石市",
"86151546", "山东省东营市",
"861821908", "广东省韶关市",
"861889307", "甘肃省天水市",
"861328504", "福建省泉州市",
"861582059", "广东省珠海市",
"861347308", "河北省邢台市",
"861372305", "河南省驻马店市",
"861862512", "江苏省苏州市",
"861476533", "吉林省长春市",
"861889438", "甘肃省平凉市",
"861770963", "安徽省芜湖市",
"861887261", "湖北省武汉市",
"861314175", "甘肃省定西市",
"861595493", "山东省聊城市",
"861316905", "广东省潮州市",
"861808311", "贵州省黔南布依族苗族自治州",
"861471559", "广东省梅州市",
"861855971", "福建省龙岩市",
"861840439", "吉林省白山市",
"861550790", "江西省新余市",
"861786466", "山东省莱芜市",
"861334864", "湖南省衡阳市",
"861777118", "湖北省黄石市",
"861860497", "辽宁省营口市",
"861536339", "广东省潮州市",
"86184730", "湖南省岳阳市",
"861526028", "福建省莆田市",
"861876047", "福建省漳州市",
"861315108", "江苏省南京市",
"861859166", "陕西省延安市",
"86138943", "吉林省延边朝鲜族自治州",
"86138789", "广西北海市",
"861809756", "新疆哈密地区",
"861395616", "安徽省芜湖市",
"861528922", "陕西省榆林市",
"86134047", "吉林省长春市",
"861535006", "江西省吉安市",
"861559406", "甘肃省张掖市",
"86132190", "四川省成都市",
"861564561", "黑龙江省大庆市",
"861807481", "广西南宁市",
"86158968", "河南省安阳市",
"861320969", "宁夏银川市",
"86152084", "四川省成都市",
"861309132", "河北省张家口市",
"861818425", "贵州省黔西南布依族苗族自治州",
"861330958", "宁夏银川市",
"861362313", "河北省张家口市",
"861347781", "湖北省荆州市",
"861452090", "安徽省黄山市",
"861863057", "河北省秦皇岛市",
"861534420", "内蒙古呼伦贝尔市",
"861822783", "四川省眉山市",
"861388641", "湖北省黄冈市",
"861786611", "甘肃省临夏回族自治州",
"861319705", "湖北省黄冈市",
"861346539", "山东省临沂市",
"861370919", "陕西省西安市",
"861569554", "安徽省淮南市",
"861598470", "四川省阿坝藏族羌族自治州",
"861308256", "江苏省扬州市",
"861363612", "湖北省黄冈市",
"861781780", "广东省佛山市",
"861856937", "湖南省永州市",
"861530600", "福建省厦门市",
"861775045", "福建省龙岩市",
"861562939", "湖北省黄石市",
"861361911", "陕西省延安市",
"86185832", "四川省成都市",
"861390010", "北京市",
"861300739", "湖南省邵阳市",
"861807166", "江苏省连云港市",
"861320924", "陕西省汉中市",
"86184657", "江西省南昌市",
"861454419", "福建省莆田市",
"861344184", "广西南宁市",
"861339851", "贵州省贵阳市",
"861863891", "河南省焦作市",
"861303701", "山西省忻州市",
"861335780", "江苏省南京市",
"861388675", "湖北省恩施土家族苗族自治州",
"861478312", "河南省三门峡市",
"86159414", "辽宁省本溪市",
"861319629", "吉林省四平市",
"861565091", "青海省海南藏族自治州",
"861304435", "吉林省通化市",
"861846950", "云南省文山壮族苗族自治州",
"861380397", "河南省商丘市",
"861848519", "贵州省遵义市",
"861502745", "河北省唐山市",
"86186933", "甘肃省平凉市",
"861370278", "广东省中山市",
"861310251", "河北省秦皇岛市",
"861815844", "浙江省杭州市",
"861504685", "黑龙江省七台河市",
"861569152", "陕西省宝鸡市",
"861534448", "湖南省常德市",
"861358917", "山东省潍坊市",
"861512187", "宁夏银川市",
"861897284", "湖北省咸宁市",
"86139681", "浙江省杭州市",
"861551549", "河南省濮阳市",
"861369379", "河南省洛阳市",
"861709667", "浙江省杭州市",
"861776523", "广东省珠海市",
"861305409", "湖南省益阳市",
"861332738", "湖南省娄底市",
"861536838", "云南省曲靖市",
"86130419", "江苏省徐州市",
"861568236", "四川省巴中市",
"861325005", "广东省珠海市",
"861319664", "江苏省盐城市",
"861530487", "黑龙江省鸡西市",
"861534382", "河南省郑州市",
"861321268", "湖南省衡阳市",
"861321891", "江苏省宿迁市",
"86180338", "河北省石家庄市",
"861855945", "福建省龙岩市",
"861884866", "贵州省六盘水市",
"861846387", "山东省临沂市",
"861329361", "山西省忻州市",
"861571751", "湖南省长沙市",
"861582874", "四川省内江市",
"861511778", "贵州省安顺市",
"861334237", "辽宁省盘锦市",
"861327427", "辽宁省盘锦市",
"861528457", "云南省迪庆藏族自治州",
"86138365", "黑龙江省鸡西市",
"861354895", "湖南省长沙市",
"861365613", "江苏省镇江市",
"861305264", "辽宁省朝阳市",
"861330637", "山东省枣庄市",
"861576150", "贵州省六盘水市",
"861302959", "内蒙古乌海市",
"861334328", "河北省秦皇岛市",
"861843401", "山西省忻州市",
"861477803", "广东省汕尾市",
"861776786", "吉林省吉林市",
"861830007", "广东省茂名市",
"861570873", "云南省红河哈尼族彝族自治州",
"86183432", "吉林省吉林市",
"861862684", "浙江省温州市",
"86159465", "黑龙江省佳木斯市",
"861811376", "四川省巴中市",
"861365063", "广东省汕尾市",
"861514757", "内蒙古通辽市",
"861810795", "江西省宜春市",
"86152112", "湖南省常德市",
"861452255", "浙江省金华市",
"861315982", "黑龙江省大庆市",
"86157744", "吉林省四平市",
"861317744", "湖北省咸宁市",
"861870414", "辽宁省本溪市",
"861774033", "河北省邯郸市",
"861357450", "湖南省娄底市",
"861303388", "河南省鹤壁市",
"861552665", "吉林省长春市",
"861477348", "湖南省湘西土家族苗族自治州",
"861871474", "黑龙江省齐齐哈尔市",
"861892251", "广东省东莞市",
"861830570", "浙江省衢州市",
"861306331", "安徽省蚌埠市",
"861820429", "辽宁省葫芦岛市",
"861571813", "广东省东莞市",
"861810316", "河北省廊坊市",
"861502623", "新疆石河子市",
"86182126", "贵州省毕节地区",
"861343193", "广东省珠海市",
"861340934", "河南省平顶山市",
"86135665", "浙江省宁波市",
"861319472", "四川省广元市",
"861519953", "新疆阿勒泰地区",
"861453351", "辽宁省大连市",
"861309450", "四川省达州市",
"861374880", "黑龙江省牡丹江市",
"861800025", "江西省宜春市",
"861303442", "湖北省黄石市",
"86183273", "湖北省武汉市",
"86137732", "江苏省苏州市",
"861530731", "湖南省长沙市",
"861580465", "黑龙江省七台河市",
"861890853", "贵州省安顺市",
"86187467", "黑龙江省鸡西市",
"861536879", "云南省普洱市",
"861332779", "江苏省泰州市",
"861528896", "山东省青岛市",
"86138314", "河北省承德市",
"86187027", "湖北省武汉市",
"861847160", "湖北省随州市",
"86188255", "广东省东莞市",
"861597024", "江西省吉安市",
"861313296", "广西百色市",
"861591454", "广东省广州市",
"861572271", "江苏省苏州市",
"861336470", "新疆克拉玛依市",
"861580551", "安徽省合肥市",
"861533625", "陕西省榆林市",
"861478458", "黑龙江省伊春市",
"861535394", "陕西省渭南市",
"861856217", "山东省烟台市",
"861593492", "内蒙古包头市",
"861576640", "广东省湛江市",
"861820464", "黑龙江省七台河市",
"861311120", "山西省忻州市",
"861887039", "江西省景德镇市",
"861504067", "辽宁省鞍山市",
"861586542", "山东省滨州市",
"861500658", "山东省青岛市",
"861360380", "河南省驻马店市",
"861371723", "广东省肇庆市",
"861812198", "四川省泸州市",
"861880322", "河北省保定市",
"861832463", "黑龙江省牡丹江市",
"861816048", "新疆昌吉回族自治州",
"861388903", "西藏山南地区",
"861372569", "广东省河源市",
"86138707", "江西省赣州市",
"861336598", "福建省泉州市",
"861533127", "山东省济南市",
"861818942", "甘肃省武威市",
"86181082", "四川省成都市",
"861321045", "山东省聊城市",
"861528445", "云南省玉溪市",
"861453837", "四川省广元市",
"861866124", "江苏省常州市",
"861535034", "江西省吉安市",
"861387272", "湖北省恩施土家族苗族自治州",
"861762505", "江苏省宿迁市",
"861345559", "山东省济宁市",
"86155380", "河南省郑州市",
"861510403", "辽宁省沈阳市",
"861868653", "吉林省长春市",
"861322519", "江苏省常州市",
"861306857", "广东省河源市",
"861521531", "山东省济南市",
"861566409", "河南省新乡市",
"861596041", "福建省泉州市",
"861852407", "辽宁省营口市",
"861300900", "吉林省长春市",
"861378990", "湖北省恩施土家族苗族自治州",
"861508049", "福建省福州市",
"861301449", "江西省宜春市",
"86186491", "天津市",
"861304711", "湖北省荆州市",
"861803465", "甘肃省陇南市",
"861371586", "广东省汕头市",
"86189019", "上海市",
"861566229", "吉林省延边朝鲜族自治州",
"861823024", "河北省唐山市",
"861335172", "黑龙江省齐齐哈尔市",
"861827492", "湖南省永州市",
"861870760", "广东省中山市",
"861890435", "吉林省通化市",
"861514623", "黑龙江省齐齐哈尔市",
"861302141", "河北省唐山市",
"861473644", "云南省保山市",
"861452870", "宁夏银川市",
"861554535", "黑龙江省双鸭山市",
"861591499", "广东省清远市",
"861893910", "河南省许昌市",
"861339877", "云南省玉溪市",
"861374931", "河南省濮阳市",
"861879548", "江苏省盐城市",
"86139282", "广东省佛山市",
"861810083", "四川省成都市",
"861539300", "甘肃省临夏回族自治州",
"861319921", "黑龙江省双鸭山市",
"861552087", "四川省南充市",
"861475553", "安徽省池州市",
"861530415", "辽宁省丹东市",
"86137954", "上海市",
"861860962", "安徽省蚌埠市",
"861786278", "山东省日照市",
"861452688", "陕西省西安市",
"86138270", "广东省江门市",
"861533930", "甘肃省临夏回族自治州",
"86158680", "浙江省温州市",
"861500148", "新疆喀什地区",
"861470946", "甘肃省张掖市",
"861800596", "福建省漳州市",
"861764042", "辽宁省大连市",
"861893347", "广东省惠州市",
"861454748", "浙江省丽水市",
"861314959", "黑龙江省大庆市",
"861364918", "陕西省咸阳市",
"861705768", "上海市",
"861572902", "河南省三门峡市",
"861356836", "四川省广元市",
"861318884", "山东省潍坊市",
"861368792", "江西省九江市",
"861380523", "江苏省淮安市",
"861311937", "甘肃省酒泉市",
"861843858", "河南省洛阳市",
"861324399", "辽宁省葫芦岛市",
"861304853", "贵州省黔南布依族苗族自治州",
"861338075", "广东省肇庆市",
"861531475", "浙江省绍兴市",
"861895472", "山东省烟台市",
"861306496", "江苏省连云港市",
"861310828", "陕西省宝鸡市",
"861452247", "浙江省丽水市",
"861881560", "安徽省合肥市",
"861514745", "内蒙古赤峰市",
"861333252", "湖南省湘潭市",
"861592944", "陕西省西安市",
"861339240", "广东省深圳市",
"861355962", "福建省泉州市",
"86170786", "云南省曲靖市",
"86158038", "河南省郑州市",
"861532977", "贵州省毕节地区",
"861380037", "河南省商丘市",
"861770774", "广西梧州市",
"861517572", "河北省沧州市",
"861783955", "河南省南阳市",
"861453443", "辽宁省营口市",
"861308520", "湖北省黄石市",
"86183659", "山东省聊城市",
"861312435", "吉林省通化市",
"861554326", "吉林省松原市",
"861567070", "河南省洛阳市",
"861771714", "河北省廊坊市",
"861873624", "河南省周口市",
"861575452", "黑龙江省齐齐哈尔市",
"861881983", "广东省云浮市",
"861560794", "江西省抚州市",
"86145358", "福建省福州市",
"861328536", "山东省潍坊市",
"861506063", "福建省泉州市",
"861380786", "广西百色市",
"861596446", "山东省淄博市",
"861302994", "黑龙江省黑河市",
"861863476", "山西省吕梁市",
"861561568", "山东省泰安市",
"861510882", "云南省文山壮族苗族自治州",
"861302651", "山东省青岛市",
"861473552", "山西省忻州市",
"861370466", "黑龙江省大庆市",
"861324261", "广东省肇庆市",
"861479540", "广西梧州市",
"861898146", "四川省达州市",
"861452330", "河南省信阳市",
"861809990", "新疆克拉玛依市",
"86156658", "山东省济南市",
"861339337", "河北省沧州市",
"861471594", "广东省中山市",
"86155548", "山东省临沂市",
"86153908", "江西省九江市",
"861768133", "安徽省芜湖市",
"861332923", "安徽省六安市",
"86139910", "陕西省咸阳市",
"861333907", "安徽省宿州市",
"861588123", "四川省雅安市",
"861310364", "河南省濮阳市",
"861564833", "内蒙古兴安盟",
"86135563", "广东省汕头市",
"861550956", "宁夏吴忠市",
"861454966", "黑龙江省齐齐哈尔市",
"861310840", "四川省广元市",
"861888263", "四川省内江市",
"861830784", "广西梧州市",
"861893473", "广西南宁市",
"861320661", "黑龙江省齐齐哈尔市",
"861301403", "安徽省六安市",
"861308548", "湖南省娄底市",
"861570093", "新疆哈密地区",
"861339408", "福建省南平市",
"861331321", "河北省石家庄市",
"861700553", "安徽省芜湖市",
"86150797", "江西省赣州市",
"861588755", "云南省德宏傣族景颇族自治州",
"86134298", "湖北省武汉市",
"861566443", "山东省泰安市",
"861335253", "黑龙江省牡丹江市",
"861472667", "四川省达州市",
"861367530", "山东省菏泽市",
"861454720", "浙江省舟山市",
"86186423", "辽宁省抚顺市",
"861362481", "内蒙古呼和浩特市",
"861847698", "广东省东莞市",
"861569599", "福建省南平市",
"861348335", "河北省秦皇岛市",
"861321476", "内蒙古赤峰市",
"861786919", "云南省文山壮族苗族自治州",
"861370611", "江苏省常州市",
"861360679", "浙江省金华市",
"861528076", "福建省南平市",
"86155997", "新疆阿克苏地区",
"861572068", "江苏省无锡市",
"861587887", "广西玉林市",
"861580000", "广东省广州市",
"861700367", "广东省东莞市",
"86158886", "浙江省台州市",
"86158377", "河南省南阳市",
"861303925", "吉林省吉林市",
"86131723", "广东省佛山市",
"861320416", "辽宁省锦州市",
"861374211", "北京市",
"861893230", "江苏省淮安市",
"861586991", "湖南省怀化市",
"861814530", "黑龙江省牡丹江市",
"861310329", "河北省邢台市",
"861338041", "广东省汕头市",
"861804660", "江西省九江市",
"861857990", "广西柳州市",
"861366323", "河北省张家口市",
"861573453", "黑龙江省牡丹江市",
"861534719", "湖北省襄樊市",
"861317032", "湖南省湘潭市",
"861580577", "浙江省温州市",
"861518362", "四川省甘孜藏族自治州",
"861472793", "陕西省渭南市",
"861348783", "湖南省湘西土家族苗族自治州",
"861361069", "山西省运城市",
"861337356", "河北省廊坊市",
"861360638", "山东省烟台市",
"861520767", "广东省云浮市",
"861538326", "河北省廊坊市",
"861804010", "辽宁省大连市",
"861894739", "内蒙古锡林郭勒盟",
"861775268", "湖南省娄底市",
"861368860", "山东省济南市",
"86136000", "广东省广州市",
"861372122", "安徽省马鞍山市",
"861879520", "宁夏银川市",
"86170041", "辽宁省沈阳市",
"861364327", "河北省沧州市",
"861817602", "广西钦州市",
"861360422", "辽宁省鞍山市",
"861335574", "浙江省宁波市",
"861310277", "河北省衡水市",
"861302175", "山东省聊城市",
"861560488", "黑龙江省鹤岗市",
"861375410", "内蒙古呼伦贝尔市",
"861782885", "四川省达州市",
"861459133", "广西玉林市",
"86153775", "湖北省武汉市",
"861572188", "云南省昆明市",
"861329573", "浙江省嘉兴市",
"861364602", "福建省厦门市",
"861505597", "安徽省六安市",
"861453229", "浙江省衢州市",
"861885825", "浙江省宁波市",
"861364238", "广东省东莞市",
"861802499", "广东省揭阳市",
"86139477", "内蒙古鄂尔多斯市",
"86134769", "湖北省咸宁市",
"861458511", "河南省开封市",
"861386580", "安徽省合肥市",
"861877985", "江西省宜春市",
"861500937", "甘肃省酒泉市",
"86180854", "贵州省黔南布依族苗族自治州",
"86157351", "山西省太原市",
"861855422", "山东省泰安市",
"861822095", "陕西省商洛市",
"86147899", "湖南省长沙市",
"861589791", "湖北省黄冈市",
"861560342", "山西省晋中市",
"861819186", "陕西省西安市",
"861537865", "四川省资阳市",
"861367454", "黑龙江省佳木斯市",
"861597231", "湖北省鄂州市",
"86183922", "陕西省榆林市",
"861309506", "新疆昌吉回族自治州",
"861599468", "广西桂林市",
"861338446", "吉林省白城市",
"861535858", "江苏省镇江市",
"861532659", "黑龙江省大庆市",
"861571777", "广西钦州市",
"861522668", "河北省廊坊市",
"861362737", "湖南省益阳市",
"86132594", "陕西省西安市",
"861321071", "山东省滨州市",
"861899108", "陕西省榆林市",
"861333173", "吉林省四平市",
"861816020", "新疆乌鲁木齐市",
"861348841", "陕西省延安市",
"86155677", "吉林省长春市",
"86135287", "广东省深圳市",
"861335621", "山东省菏泽市",
"861560593", "福建省宁德市",
"861324502", "湖南省常德市",
"861821250", "贵州省铜仁地区",
"861369673", "安徽省马鞍山市",
"861850319", "河北省邢台市",
"861318826", "辽宁省抚顺市",
"861590260", "贵州省贵阳市",
"861357940", "新疆乌鲁木齐市",
"861376228", "湖南省娄底市",
"86135746", "湖南省永州市",
"861337532", "山东省青岛市",
"861450178", "山西省晋中市",
"861532475", "河南省洛阳市",
"861347648", "湖北省鄂州市",
"86157795", "江西省宜春市",
"861770573", "浙江省嘉兴市",
"861558637", "湖北省宜昌市",
"861318541", "浙江省嘉兴市",
"861383010", "甘肃省临夏回族自治州",
"861571902", "新疆克孜勒苏柯尔克孜自治州",
"861320538", "山东省泰安市",
"861388788", "云南省楚雄彝族自治州",
"86157608", "海南省海口市",
"861780851", "贵州省贵阳市",
"861810890", "西藏拉萨市",
"861508146", "河北省廊坊市",
"861332294", "广东省云浮市",
"861380724", "湖北省咸宁市",
"861779011", "四川省德阳市",
"861882560", "广东省阳江市",
"861881381", "广东省湛江市",
"861315358", "山东省滨州市",
"861365319", "河北省邢台市",
"861346968", "宁夏银川市",
"861778127", "四川省南充市",
"86151958", "江苏省南京市",
"861303952", "内蒙古呼和浩特市",
"861381246", "江苏省镇江市",
"861301994", "辽宁省盘锦市",
"861519443", "河南省洛阳市",
"86189797", "江西省赣州市",
"861839566", "河北省保定市",
"861313970", "新疆昌吉回族自治州",
"861475754", "浙江省温州市",
"861772714", "广东省佛山市",
"861377030", "江苏省南京市",
"861882983", "陕西省渭南市",
"861826622", "山东省青岛市",
"861565933", "福建省宁德市",
"861530917", "陕西省宝鸡市",
"861356660", "浙江省宁波市",
"861569280", "四川省达州市",
"86131119", "海南省海口市",
"861809468", "浙江省绍兴市",
"861360561", "安徽省淮北市",
"861576823", "广东省湛江市",
"861534958", "宁夏中卫市",
"861524969", "河南省郑州市",
"861866616", "广东省中山市",
"86132484", "浙江省杭州市",
"861819522", "宁夏银川市",
"86176960", "山西省太原市",
"86159854", "贵州省毕节地区",
"861890937", "甘肃省酒泉市",
"861889157", "陕西省宝鸡市",
"861705500", "广东省深圳市",
"861589028", "河南省三门峡市",
"861781773", "广东省深圳市",
"861836520", "安徽省淮南市",
"86137050", "福建省福州市",
"861777402", "浙江省温州市",
"861869020", "新疆哈密地区",
"861530864", "湖北省武汉市",
"861322045", "甘肃省兰州市",
"861360455", "黑龙江省绥化市",
"861315412", "辽宁省鞍山市",
"86181535", "山东省烟台市",
"86152611", "江苏省常州市",
"861873545", "山西省朔州市",
"861508515", "贵州省黔南布依族苗族自治州",
"86184696", "云南省西双版纳傣族自治州",
"861530340", "山西省忻州市",
"86177702", "江西省九江市",
"861803967", "河南省郑州市",
"861372155", "贵州省安顺市",
"861870984", "安徽省合肥市",
"861822770", "四川省阿坝藏族羌族自治州",
"861509108", "陕西省宝鸡市",
"86138928", "陕西省西安市",
"861705077", "浙江省杭州市",
"861459732", "湖南省湘潭市",
"861479906", "新疆伊犁哈萨克自治州",
"86152668", "山东省聊城市",
"861309317", "江苏省常州市",
"861846440", "山东省聊城市",
"86182599", "福建省南平市",
"861502840", "河北省张家口市",
"86157616", "贵州省贵阳市",
"86188878", "云南省楚雄彝族自治州",
"861528947", "陕西省西安市",
"861804376", "吉林省长春市",
"861315074", "云南省昆明市",
"861334600", "浙江省嘉兴市",
"861591191", "云南省保山市",
"861335885", "辽宁省沈阳市",
"861302449", "江苏省盐城市",
"861340540", "山东省菏泽市",
"861529699", "宁夏中卫市",
"86187622", "江苏省徐州市",
"861301141", "河北省保定市",
"861320579", "浙江省金华市",
"861530829", "四川省巴中市",
"861564971", "河南省濮阳市",
"861770254", "江苏省无锡市",
"861778930", "甘肃省临夏回族自治州",
"861333772", "江苏省南京市",
"861876022", "福建省宁德市",
"86156301", "河北省石家庄市",
"861327630", "山东省威海市",
"861338862", "浙江省嘉兴市",
"861399581", "湖北省鄂州市",
"861859231", "陕西省延安市",
"861866555", "广东省广州市",
"861812804", "广东省东莞市",
"861881708", "湖南省常德市",
"86187640", "山东省济南市",
"861330420", "辽宁省鞍山市",
"86186581", "浙江省杭州市",
"861588275", "四川省凉山彝族自治州",
"861319800", "四川省内江市",
"861520354", "山西省晋中市",
"86150019", "上海市",
"861802191", "江苏省淮安市",
"861806041", "福建省宁德市",
"861330448", "吉林省延边朝鲜族自治州",
"861362069", "山西省运城市",
"861868401", "四川省成都市",
"861570678", "浙江省温州市",
"861510994", "新疆昌吉回族自治州",
"861379598", "四川省宜宾市",
"861787515", "广东省揭阳市",
"861880355", "山西省长治市",
"861313413", "辽宁省抚顺市",
"861505629", "安徽省宣城市",
"861760698", "云南省昆明市",
"861568161", "四川省雅安市",
"861571618", "江苏省无锡市",
"861801499", "江苏省镇江市",
"861538384", "河北省秦皇岛市",
"86145479", "浙江省宁波市",
"861301175", "山东省德州市",
"861500435", "吉林省通化市",
"86187846", "四川省宜宾市",
"861564945", "河南省平顶山市",
"861368636", "山东省潍坊市",
"861530328", "河北省秦皇岛市",
"861896613", "浙江省台州市",
"861856711", "河南省漯河市",
"861869048", "陕西省榆林市",
"861536196", "广东省梅州市",
"861846208", "山东省淄博市",
"861361737", "湖南省益阳市",
"861836548", "江西省宜春市",
"861376877", "广西玉林市",
"861572777", "江西省赣州市",
"861846428", "山东省滨州市",
"861329774", "广西梧州市",
"861787656", "广东省广州市",
"861362024", "广东省河源市",
"861341799", "广东省云浮市",
"861328352", "山西省大同市",
"86182841", "四川省南充市",
"861397219", "湖北省武汉市",
"861552692", "吉林省白山市",
"861841988", "甘肃省甘南藏族自治州",
"861348584", "安徽省宿州市",
"86158325", "河北省唐山市",
"861327388", "河南省平顶山市",
"861530237", "广东省广州市",
"861810762", "广东省河源市",
"861769854", "河南省洛阳市",
"86184890", "海南省海口市",
"86135187", "云南省昆明市",
"861568486", "新疆喀什地区",
"861474314", "吉林省四平市",
"861361086", "辽宁省大连市",
"861589040", "河南省南阳市",
"861894258", "湖南省永州市",
"861322071", "山东省滨州市",
"861817759", "广西贵港市",
"861813558", "山西省长治市",
"861335773", "江苏省南京市",
"86180992", "新疆乌鲁木齐市",
"861388494", "山东省青岛市",
"861369721", "湖北省襄樊市",
"86139425", "辽宁省丹东市",
"861537072", "江苏省泰州市",
"861336483", "新疆塔城地区",
"861309928", "甘肃省白银市",
"86181609", "福建省泉州市",
"86181214", "上海市",
"861882296", "广东省东莞市",
"861830726", "湖北省荆州市",
"861802944", "广东省江门市",
"861520078", "湖南省湘西土家族苗族自治州",
"86134642", "辽宁省朝阳市",
"861831244", "广东省揭阳市",
"861303427", "浙江省嘉兴市",
"861302403", "安徽省阜阳市",
"861310757", "青海省海西蒙古族藏族自治州",
"86181471", "内蒙古呼和浩特市",
"861868006", "广东省东莞市",
"861328418", "辽宁省阜新市",
"861332321", "河北省石家庄市",
"861850818", "四川省达州市",
"861839290", "陕西省商洛市",
"861894187", "辽宁省葫芦岛市",
"8617628", "四川省成都市",
"86139065", "浙江省台州市",
"861509982", "广东省阳江市",
"86134620", "河南省信阳市",
"86155625", "山东省济南市",
"861575205", "云南省西双版纳傣族自治州",
"861393397", "河北省保定市",
"861570639", "山东省青岛市",
"861327701", "湖北省孝感市",
"861322476", "内蒙古通辽市",
"861890148", "江苏省南通市",
"861300821", "辽宁省阜新市",
"86158517", "江苏省淮安市",
"861338790", "江西省新余市",
"861556052", "内蒙古巴彦淖尔市",
"861366921", "陕西省延安市",
"861830583", "浙江省嘉兴市",
"86180672", "浙江省宁波市",
"861346746", "湖南省永州市",
"861582517", "云南省大理白族自治州",
"861700754", "广东省汕头市",
"861557982", "江西省宜春市",
"861337134", "山东省滨州市",
"861361481", "内蒙古呼和浩特市",
"861334731", "湖南省长沙市",
"86183044", "吉林省松原市",
"861569302", "甘肃省甘南藏族自治州",
"861370489", "黑龙江省大庆市",
"861318575", "浙江省绍兴市",
"861471793", "山西省吕梁市",
"86187959", "江苏省南京市",
"861362619", "江苏省苏州市",
"861365818", "四川省乐山市",
"861315859", "四川省内江市",
"861561631", "湖南省衡阳市",
"861830960", "宁夏银川市",
"861503347", "河北省唐山市",
"861532441", "安徽省蚌埠市",
"861570880", "云南省昭通市",
"86184052", "江苏省苏州市",
"861847138", "湖北省恩施土家族苗族自治州",
"861831842", "广东省揭阳市",
"861860435", "吉林省通化市",
"861348037", "广东省云浮市",
"861361890", "西藏拉萨市",
"861874567", "黑龙江省哈尔滨市",
"861369844", "江西省萍乡市",
"861459136", "广西贵港市",
"861770419", "辽宁省辽阳市",
"861808161", "四川省凉山彝族自治州",
"861760471", "内蒙古呼和浩特市",
"861329576", "浙江省台州市",
"861865629", "安徽省亳州市",
"861772171", "江苏省常州市",
"861386720", "浙江省舟山市",
"861761411", "辽宁省大连市",
"861348786", "湖南省郴州市",
"861858751", "广西柳州市",
"861538323", "河北省石家庄市",
"861337353", "河北省沧州市",
"861566041", "山东省济宁市",
"861562191", "内蒙古呼和浩特市",
"861596409", "山东省临沂市",
"861305895", "浙江省金华市",
"861390957", "宁夏银川市",
"86182645", "山东省聊城市",
"861341117", "广东省广州市",
"86150581", "浙江省杭州市",
"861816894", "江苏省常州市",
"861508221", "四川省乐山市",
"86187249", "云南省临沧市",
"861350629", "江苏省南通市",
"861470909", "新疆博尔塔拉蒙古自治州",
"861838904", "西藏林芝地区",
"861323757", "江西省新余市",
"861479494", "内蒙古鄂尔多斯市",
"861333176", "吉林省长春市",
"861477834", "广东省深圳市",
"861351358", "山西省吕梁市",
"861337567", "山东省枣庄市",
"861573897", "河南省信阳市",
"861376362", "黑龙江省牡丹江市",
"861366535", "山东省烟台市",
"861525090", "江苏省徐州市",
"861339035", "辽宁省本溪市",
"861819183", "陕西省渭南市",
"861458252", "安徽省合肥市",
"861390380", "河南省新乡市",
"861354229", "广东省韶关市",
"861879780", "江西省鹰潭市",
"861309503", "新疆乌鲁木齐市",
"861338443", "吉林省延边朝鲜族自治州",
"86145805", "江苏省盐城市",
"861382464", "广东省肇庆市",
"861564836", "内蒙古呼伦贝尔市",
"86183150", "重庆市",
"861350472", "吉林省延边朝鲜族自治州",
"861550953", "宁夏吴忠市",
"861590794", "江西省抚州市",
"861336424", "辽宁省铁岭市",
"861454963", "黑龙江省七台河市",
"861346544", "山东省青岛市",
"861888266", "四川省广安市",
"861570096", "新疆伊犁哈萨克自治州",
"861336204", "浙江省衢州市",
"861893476", "广西来宾市",
"861301406", "安徽省阜阳市",
"861820558", "安徽省阜阳市",
"861334050", "福建省南平市",
"861338837", "四川省内江市",
"861855198", "江苏省南京市",
"861830569", "安徽省亳州市",
"861566446", "山东省泰安市",
"861478564", "贵州省黔南布依族苗族自治州",
"861370463", "黑龙江省牡丹江市",
"861513039", "河北省邢台市",
"861898143", "四川省内江市",
"861562944", "湖北省荆州市",
"861454580", "甘肃省兰州市",
"86155821", "山西省晋中市",
"861768136", "安徽省阜阳市",
"86189909", "四川省宜宾市",
"861332926", "安徽省安庆市",
"861588126", "四川省攀枝花市",
"861300744", "湖南省湘潭市",
"861838588", "贵州省铜仁地区",
"861351412", "辽宁省鞍山市",
"861558012", "湖南省岳阳市",
"861347495", "内蒙古通辽市",
"861803932", "河南省信阳市",
"861320413", "辽宁省抚顺市",
"86158936", "河南省周口市",
"861394918", "河南省信阳市",
"8618580", "重庆市",
"861863347", "河北省石家庄市",
"861815407", "安徽省阜阳市",
"861811561", "江苏省南京市",
"861366326", "河北省廊坊市",
"861573456", "黑龙江省黑河市",
"861478529", "贵州省铜仁地区",
"861830524", "江苏省宿迁市",
"861815227", "甘肃省庆阳市",
"861332760", "青海省海西蒙古族藏族自治州",
"861865472", "山东省潍坊市",
"861536860", "云南省丽江市",
"861575690", "四川省乐山市",
"861472796", "陕西省汉中市",
"861847179", "湖北省黄冈市",
"861536344", "广东省佛山市",
"861773921", "河南省郑州市",
"86170957", "安徽省合肥市",
"861511392", "广东省汕头市",
"861459693", "新疆吐鲁番地区",
"861335256", "黑龙江省黑河市",
"861519862", "云南省文山壮族苗族自治州",
"86136282", "重庆市",
"86156672", "陕西省咸阳市",
"861700615", "江苏省苏州市",
"861350014", "广东省中山市",
"861811455", "江苏省镇江市",
"861340903", "山东省日照市",
"86134713", "广西桂林市",
"861528073", "福建省三明市",
"861321473", "内蒙古乌海市",
"861521952", "广东省清远市",
"861890962", "安徽省蚌埠市",
"861700185", "上海市",
"861523994", "河南省商丘市",
"861809627", "四川省凉山彝族自治州",
"86152790", "江西省新余市",
"861529431", "甘肃省金昌市",
"861338409", "河南省焦作市",
"861810737", "湖南省益阳市",
"861313579", "湖北省荆州市",
"861763337", "河北省张家口市",
"861377751", "浙江省金华市",
"861479788", "江西省景德镇市",
"861356833", "四川省自贡市",
"861317778", "江西省南昌市",
"861309549", "安徽省芜湖市",
"86145372", "湖北省武汉市",
"861380526", "江苏省泰州市",
"861769907", "新疆乌鲁木齐市",
"861304856", "贵州省六盘水市",
"861537259", "浙江省杭州市",
"861584770", "内蒙古鄂尔多斯市",
"861583327", "河北省沧州市",
"861527268", "湖北省咸宁市",
"861450527", "吉林省辽源市",
"86189423", "江西省南昌市",
"861810086", "重庆市",
"86180366", "江苏省连云港市",
"861475556", "安徽省马鞍山市",
"861527057", "江西省九江市",
"861581901", "广东省梅州市",
"861534662", "湖北省鄂州市",
"861577147", "内蒙古巴彦淖尔市",
"861800593", "福建省宁德市",
"861871448", "黑龙江省双鸭山市",
"861329111", "江苏省南通市",
"861882969", "陕西省铜川市",
"861303018", "广东省湛江市",
"861390679", "浙江省金华市",
"8618448", "广西南宁市",
"861470943", "甘肃省平凉市",
"861319384", "河南省南阳市",
"861772655", "四川省巴中市",
"861881986", "广东省茂名市",
"86181200", "江苏省苏州市",
"861770852", "贵州省遵义市",
"861383447", "山西省运城市",
"861815839", "浙江省金华市",
"861802568", "广东省中山市",
"861328533", "山东省淄博市",
"861380783", "广西桂林市",
"861596443", "山东省菏泽市",
"861506066", "福建省福州市",
"861338264", "江苏省盐城市",
"861812202", "广东省广州市",
"861853021", "河南省新乡市",
"861476504", "北京市",
"861863473", "山西省临汾市",
"861475615", "河北省沧州市",
"861814805", "四川省广安市",
"861321347", "河南省濮阳市",
"861389948", "新疆克孜勒苏柯尔克孜自治州",
"861306493", "江苏省淮安市",
"86159658", "山东省菏泽市",
"861357549", "浙江省杭州市",
"861815680", "安徽省六安市",
"861572390", "广西南宁市",
"861453446", "辽宁省葫芦岛市",
"86134229", "广东省惠州市",
"861837154", "湖北省咸宁市",
"861388906", "西藏那曲地区",
"861380335", "河北省秦皇岛市",
"861340949", "河南省平顶山市",
"86474", "内蒙古乌兰察布市",
"861370244", "广东省佛山市",
"86151248", "内蒙古包头市",
"861875851", "浙江省绍兴市",
"861372784", "广东省茂名市",
"861815878", "浙江省丽水市",
"861320970", "青海省海北藏族自治州",
"861576884", "广东省湛江市",
"861378302", "河南省鹤壁市",
"861350705", "江西省宜春市",
"861810481", "内蒙古鄂尔多斯市",
"861509020", "河南省濮阳市",
"861304497", "江西省赣州市",
"86131263", "广东省惠州市",
"861598424", "四川省资阳市",
"861590342", "山西省大同市",
"86155893", "山东省淄博市",
"861506616", "山东省青岛市",
"861589100", "陕西省咸阳市",
"861850547", "山东省济宁市",
"861371726", "广东省江门市",
"861875097", "福建省南平市",
"861569468", "云南省普洱市",
"861832466", "黑龙江省伊春市",
"86132712", "河南省许昌市",
"86153421", "天津市",
"861760445", "吉林省通化市",
"861831489", "浙江省杭州市",
"861508394", "江西省赣州市",
"861316581", "浙江省嘉兴市",
"861590488", "内蒙古呼和浩特市",
"861514626", "黑龙江省哈尔滨市",
"861776095", "四川省乐山市",
"86180301", "福建省厦门市",
"861317739", "湖北省鄂州市",
"861303668", "四川省成都市",
"861313538", "湖南省娄底市",
"861390638", "山东省烟台市",
"861510406", "辽宁省大连市",
"861868656", "吉林省吉林市",
"86153018", "上海市",
"861524560", "黑龙江省哈尔滨市",
"861351859", "贵州省黔西南布依族苗族自治州",
"861365547", "山东省济宁市",
"861338377", "河南省南阳市",
"861861757", "河北省邯郸市",
"861332892", "福建省三明市",
"861564376", "吉林省辽源市",
"861354837", "四川省泸州市",
"861390422", "辽宁省鞍山市",
"861557020", "江西省九江市",
"861862840", "陕西省渭南市",
"861853206", "河北省邯郸市",
"861886021", "河南省商丘市",
"861864739", "内蒙古呼和浩特市",
"861539575", "浙江省绍兴市",
"861371583", "广东省潮州市",
"861330695", "福建省漳州市",
"86186797", "江西省赣州市",
"861530501", "福建省福州市",
"861829867", "甘肃省白银市",
"861302406", "安徽省芜湖市",
"861857599", "广东省东莞市",
"861868003", "广东省佛山市",
"861842042", "广东省梅州市",
"861858271", "四川省广安市",
"861332984", "湖北省十堰市",
"861811957", "安徽省宿州市",
"86183250", "重庆市",
"86184078", "江西省上饶市",
"861595933", "福建省宁德市",
"861336486", "新疆阿勒泰地区",
"861367939", "甘肃省酒泉市",
"861454361", "山东省济南市",
"861313011", "辽宁省本溪市",
"861322230", "江苏省扬州市",
"861830723", "湖北省随州市",
"86180658", "福建省三明市",
"861550351", "山西省太原市",
"861882293", "广东省揭阳市",
"861306904", "吉林省长春市",
"861786510", "山东省滨州市",
"861872420", "黑龙江省哈尔滨市",
"861331760", "广西防城港市",
"861471796", "山西省运城市",
"861458772", "湖南省岳阳市",
"861333079", "四川省甘孜藏族自治州",
"861708558", "安徽省阜阳市",
"861880268", "广东省深圳市",
"861459354", "贵州省遵义市",
"861325647", "山东省东营市",
"861824094", "新疆阿克苏地区",
"86138679", "浙江省金华市",
"861380612", "江苏省常州市",
"861837876", "广西南宁市",
"861560260", "广东省东莞市",
"861833608", "河南省新乡市",
"861322473", "内蒙古乌海市",
"861522952", "陕西省榆林市",
"86130048", "福建省泉州市",
"861809599", "新疆乌鲁木齐市",
"861772438", "广东省梅州市",
"861359771", "湖北省黄石市",
"861768078", "湖南省邵阳市",
"861336161", "江西省南昌市",
"861479949", "新疆喀什地区",
"861770825", "广东省中山市",
"861847471", "湖南省怀化市",
"861346743", "湖南省湘西土家族苗族自治州",
"861830586", "浙江省台州市",
"861888289", "四川省凉山彝族自治州",
"86136182", "重庆市",
"861323277", "广东省河源市",
"861313416", "辽宁省锦州市",
"861594971", "山东省烟台市",
"861785892", "浙江省丽水市",
"861593212", "河北省保定市",
"861570199", "新疆伊犁哈萨克自治州",
"861323329", "山西省晋城市",
"861771171", "湖南省益阳市",
"861337694", "福建省宁德市",
"861309704", "江西省抚州市",
"86133360", "浙江省杭州市",
"861362890", "西藏拉萨市",
"861337951", "陕西省西安市",
"861566790", "陕西省商洛市",
"861318300", "河南省郑州市",
"861336081", "广东省汕头市",
"86159301", "河北省石家庄市",
"861830645", "山东省烟台市",
"861871135", "湖南省株洲市",
"86138466", "黑龙江省伊春市",
"861503045", "河北省廊坊市",
"861355937", "福建省泉州市",
"861373314", "河南省南阳市",
"86157562", "四川省成都市",
"861591700", "广东省佛山市",
"861770681", "浙江省杭州市",
"861883856", "河南省许昌市",
"861768039", "湖南省邵阳市",
"861879964", "新疆哈密地区",
"861380062", "福建省厦门市",
"86147296", "陕西省汉中市",
"861329852", "湖南省湘潭市",
"861343879", "四川省阿坝藏族羌族自治州",
"861361083", "辽宁省沈阳市",
"861348769", "湖南省益阳市",
"861390455", "黑龙江省绥化市",
"861459078", "广东省揭阳市",
"861568483", "新疆伊犁哈萨克自治州",
"861323840", "内蒙古呼和浩特市",
"861325157", "黑龙江省大兴安岭地区",
"861313661", "黑龙江省齐齐哈尔市",
"861303531", "湖北省荆州市",
"861816108", "四川省宜宾市",
"861528698", "河南省安阳市",
"861335776", "江苏省镇江市",
"861874694", "黑龙江省绥化市",
"861346625", "云南省红河哈尼族彝族自治州",
"861874951", "河南省商丘市",
"861368633", "山东省日照市",
"86184383", "河南省商丘市",
"861896616", "浙江省杭州市",
"861332508", "山东省临沂市",
"861840999", "新疆伊犁哈萨克自治州",
"861536193", "广东省湛江市",
"861808204", "江苏省连云港市",
"861390561", "安徽省淮北市",
"861342248", "广东省汕头市",
"861321105", "广东省肇庆市",
"86138999", "新疆乌鲁木齐市",
"861808424", "贵州省黔南布依族苗族自治州",
"861787653", "广东省阳江市",
"861879929", "新疆石河子市",
"86182528", "江苏省南通市",
"861860937", "甘肃省酒泉市",
"861309665", "山西省晋城市",
"861319535", "安徽省宣城市",
"861356945", "河南省许昌市",
"86151692", "山东省淄博市",
"861479903", "新疆吐鲁番地区",
"861870321", "河北省石家庄市",
"861518337", "四川省乐山市",
"86131808", "吉林省长春市",
"861317067", "云南省红河哈尼族彝族自治州",
"861811679", "四川省达州市",
"86151148", "陕西省西安市",
"861861329", "四川省资阳市",
"861323828", "辽宁省铁岭市",
"861899048", "四川省甘孜藏族自治州",
"861378599", "河北省秦皇岛市",
"861860658", "浙江省宁波市",
"861810619", "江苏省无锡市",
"861322910", "广东省中山市",
"861576826", "广东省惠州市",
"861533578", "湖北省随州市",
"86188852", "贵州省遵义市",
"861866613", "广东省珠海市",
"861308817", "四川省泸州市",
"861518228", "四川省乐山市",
"86130156", "福建省漳州市",
"861317258", "广东省潮州市",
"861760947", "甘肃省嘉峪关市",
"861781776", "广东省湛江市",
"861598161", "吉林省通化市",
"861314434", "吉林省四平市",
"861380908", "江苏省南通市",
"861853484", "山西省晋中市",
"861506169", "江苏省淮安市",
"861458405", "河南省郑州市",
"861805845", "浙江省台州市",
"861316360", "黑龙江省牡丹江市",
"86355", "山西省长治市",
"861594945", "内蒙古鄂尔多斯市",
"861771145", "四川省达州市",
"86137244", "广东省东莞市",
"861535587", "浙江省温州市",
"861552450", "辽宁省沈阳市",
"861806229", "湖北省黄石市",
"861331892", "广东省潮州市",
"861339362", "广西来宾市",
"861357665", "江西省赣州市",
"861514684", "黑龙江省哈尔滨市",
"861867434", "湖南省湘西土家族苗族自治州",
"861333854", "福建省南平市",
"86189581", "浙江省杭州市",
"861861364", "山东省日照市",
"86150491", "内蒙古呼和浩特市",
"861556759", "吉林省白山市",
"861384932", "河南省濮阳市",
"861519041", "江苏省扬州市",
"861831611", "广东省肇庆市",
"861470341", "山西省太原市",
"861810024", "广东省东莞市",
"86185565", "安徽省合肥市",
"861454299", "辽宁省朝阳市",
"861529810", "四川省达州市",
"86153583", "江苏省宿迁市",
"86155709", "湖南省衡阳市",
"861770576", "浙江省台州市",
"861806377", "福建省龙岩市",
"861591631", "广东省珠海市",
"861560596", "福建省漳州市",
"861379204", "山东省日照市",
"861860148", "江苏省无锡市",
"861369676", "安徽省合肥市",
"861318823", "辽宁省本溪市",
"861363397", "河南省信阳市",
"861340494", "云南省文山壮族苗族自治州",
"861872448", "黑龙江省齐齐哈尔市",
"861500962", "宁夏石嘴山市",
"861308929", "吉林省通化市",
"861328734", "山东省泰安市",
"86151972", "湖南省湘潭市",
"861837525", "贵州省黔东南苗族侗族自治州",
"861898742", "云南省曲靖市",
"861858245", "四川省成都市",
"86181725", "广西玉林市",
"861381243", "江苏省连云港市",
"861304572", "浙江省湖州市",
"861519446", "河南省信阳市",
"861314550", "安徽省滁州市",
"861811202", "江苏省徐州市",
"861839563", "河北省石家庄市",
"861810069", "江苏省苏州市",
"861811422", "江苏省南通市",
"861882986", "陕西省汉中市",
"861565936", "福建省南平市",
"861800794", "江西省抚州市",
"86181100", "北京市",
"861807070", "广西南宁市",
"861588582", "贵州省黔东南苗族侗族自治州",
"861589235", "四川省广安市",
"861571390", "河南省焦作市",
"86150909", "湖北省宜昌市",
"861705375", "广西南宁市",
"861760310", "河北省邯郸市",
"861520732", "湖南省湘潭市",
"861479177", "陕西省榆林市",
"861317187", "河北省保定市",
"861886484", "山东省泰安市",
"86139771", "广西南宁市",
"861839980", "新疆塔城地区",
"86177955", "宁夏中卫市",
"861379469", "广东省韶关市",
"861848355", "四川省雅安市",
"861508143", "河北省张家口市",
"861533539", "山东省临沂市",
"861355148", "四川省阿坝藏族羌族自治州",
"861317617", "山东省济宁市",
"861537738", "湖南省娄底市",
"861890995", "新疆吐鲁番地区",
"861356380", "山东省泰安市",
"861309736", "江西省上饶市",
"861550264", "辽宁省大连市",
"861390373", "河南省新乡市",
"861337977", "新疆乌鲁木齐市",
"861591939", "广东省惠州市",
"861312572", "吉林省吉林市",
"861819170", "陕西省渭南市",
"861830938", "甘肃省天水市",
"861813464", "安徽省阜阳市",
"861362070", "吉林省延边朝鲜族自治州",
"861340459", "吉林省松原市",
"86150933", "河南省郑州市",
"861862745", "湖南省怀化市",
"861379916", "福建省三明市",
"861329720", "湖北省武汉市",
"861775105", "江苏省徐州市",
"86151719", "湖北省恩施土家族苗族自治州",
"861585808", "浙江省舟山市",
"861317685", "山东省青岛市",
"861587246", "湖北省宜昌市",
"861774810", "四川省泸州市",
"86147051", "江苏省南京市",
"861450654", "黑龙江省黑河市",
"861347462", "陕西省咸阳市",
"861308621", "青海省海西蒙古族藏族自治州",
"861450991", "新疆乌鲁木齐市",
"86159782", "广西柳州市",
"86139885", "云南省大理白族自治州",
"861880476", "内蒙古赤峰市",
"861356957", "河南省平顶山市",
"861329966", "广西玉林市",
"861350800", "四川省德阳市",
"86155733", "湖南省株洲市",
"861813429", "河北省邢台市",
"861800759", "广东省湛江市",
"861559994", "新疆喀什地区",
"861358262", "河北省保定市",
"861837491", "湖南省岳阳市",
"861874977", "河南省焦作市",
"861839831", "四川省达州市",
"861311856", "贵州省铜仁地区",
"861315048", "新疆阿克苏地区",
"86152455", "黑龙江省绥化市",
"861550409", "辽宁省大连市",
"86137195", "广东省汕尾市",
"861357736", "云南省曲靖市",
"861760955", "宁夏中卫市",
"861835598", "安徽省黄山市",
"861779708", "青海省西宁市",
"861831827", "广东省阳江市",
"861377902", "新疆博尔塔拉蒙古自治州",
"861576467", "黑龙江省鸡西市",
"86156338", "河北省石家庄市",
"861535146", "四川省雅安市",
"861531532", "山东省青岛市",
"861599125", "陕西省商洛市",
"861881416", "广东省江门市",
"861396664", "安徽省安庆市",
"861848910", "西藏拉萨市",
"861808236", "江苏省泰州市",
"861508727", "云南省大理白族自治州",
"861863607", "山西省晋中市",
"861572816", "广东省惠州市",
"861397191", "湖北省十堰市",
"861805496", "福建省漳州市",
"861551317", "山西省忻州市",
"861321480", "内蒙古兴安盟",
"861856962", "湖南省长沙市",
"861528080", "福建省龙岩市",
"861504744", "内蒙古乌兰察布市",
"861470453", "黑龙江省牡丹江市",
"861811971", "安徽省蚌埠市",
"861871958", "甘肃省陇南市",
"861367700", "江西省南昌市",
"861889513", "宁夏吴忠市",
"861809642", "安徽省芜湖市",
"86133559", "浙江省宁波市",
"861813672", "江苏省常州市",
"86157631", "山东省威海市",
"861890572", "浙江省湖州市",
"861521630", "山东省威海市",
"861322355", "山西省长治市",
"861810911", "陕西省延安市",
"86135861", "浙江省台州市",
"861306936", "河南省新乡市",
"861550377", "河南省南阳市",
"861898858", "广东省中山市",
"861815242", "宁夏吴忠市",
"86135818", "北京市",
"861830979", "青海省海西蒙古族藏族自治州",
"86152636", "山东省潍坊市",
"861584875", "内蒙古通辽市",
"861864821", "内蒙古兴安盟",
"861771288", "江苏省南京市",
"861454573", "四川省广元市",
"861309167", "黑龙江省大庆市",
"861559141", "陕西省商洛市",
"861317546", "浙江省台州市",
"861333899", "江苏省连云港市",
"861780035", "河北省唐山市",
"861819818", "贵州省毕节地区",
"861522866", "四川省遂宁市",
"861326766", "广东省江门市",
"86170029", "陕西省西安市",
"86177820", "重庆市",
"861824874", "江苏省徐州市",
"861518851", "河南省许昌市",
"861317821", "福建省泉州市",
"861337103", "山东省泰安市",
"861533490", "内蒙古呼伦贝尔市",
"861524413", "山东省泰安市",
"861831919", "广东省东莞市",
"861323251", "广东省珠海市",
"861570552", "安徽省蚌埠市",
"861590918", "陕西省延安市",
"86177842", "重庆市",
"861839345", "甘肃省天水市",
"86152830", "四川省泸州市",
"861843146", "河北省廊坊市",
"86573", "浙江省嘉兴市",
"861778968", "甘肃省天水市",
"861586431", "山东省潍坊市",
"861536765", "湖南省邵阳市",
"861321322", "河南省郑州市",
"86182701", "江西省上饶市",
"861802978", "广东省潮州市",
"861337659", "广东省韶关市",
"861538629", "湖南省永州市",
"861827212", "湖北省黄冈市",
"861863480", "山西省运城市",
"861515549", "安徽省安庆市",
"861383422", "山西省太原市",
"861386681", "安徽省池州市",
"861458610", "湖北省荆门市",
"861812447", "广东省清远市",
"861380770", "广西防城港市",
"86138300", "甘肃省白银市",
"861529281", "新疆和田地区",
"861500856", "贵州省铜仁地区",
"861839371", "甘肃省兰州市",
"861764536", "黑龙江省鸡西市",
"861589987", "广东省深圳市",
"861831278", "广东省梅州市",
"861458180", "浙江省湖州市",
"861477761", "广西玉林市",
"86155787", "广西钦州市",
"861894543", "黑龙江省佳木斯市",
"861567086", "河南省焦作市",
"861303863", "云南省昭通市",
"861709428", "广东省汕头市",
"861565904", "福建省漳州市",
"861308773", "广西桂林市",
"861399905", "新疆和田地区",
"861869358", "甘肃省兰州市",
"861532356", "广东省肇庆市",
"861474129", "辽宁省锦州市",
"861333398", "河南省三门峡市",
"86132824", "浙江省温州市",
"86138253", "广东省河源市",
"86150987", "山东省济南市",
"861898034", "四川省攀枝花市",
"861577122", "内蒙古呼伦贝尔市",
"861857273", "湖北省随州市",
"86147529", "江苏省盐城市",
"861328042", "山东省临沂市",
"86185663", "广东省佛山市",
"861573946", "新疆昌吉回族自治州",
"861840954", "宁夏固原市",
"861342185", "广东省汕头市",
"861840691", "云南省西双版纳傣族自治州",
"861809430", "江苏省盐城市",
"86187706", "江西省吉安市",
"861768399", "湖北省荆州市",
"861350323", "河北省秦皇岛市",
"861583342", "河北省保定市",
"861340812", "四川省攀枝花市",
"861365522", "江苏省徐州市",
"861769610", "山西省太原市",
"861330474", "内蒙古兴安盟",
"86135600", "广东省广州市",
"86187761", "广西南宁市",
"861804561", "黑龙江省黑河市",
"861570644", "山东省济南市",
"861814631", "青海省西宁市",
"861353111", "广东省湛江市",
"861394342", "吉林省白山市",
"861337149", "山东省青岛市",
"861390447", "吉林省延边朝鲜族自治州",
"86182694", "广西玉林市",
"861569756", "广东省珠海市",
"86187718", "湖北省宜昌市",
"861367631", "山东省威海市",
"861539965", "安徽省阜阳市",
"861766026", "山东省泰安市",
"861452886", "云南省怒江傈僳族自治州",
"861331414", "辽宁省本溪市",
"861306216", "福建省宁德市",
"861346930", "湖南省湘潭市",
"861370510", "江苏省盐城市",
"861377257", "陕西省咸阳市",
"861315020", "新疆伊犁哈萨克自治州",
"861524970", "河南省新乡市",
"86183339", "河北省邢台市",
"861556488", "山东省青岛市",
"86134486", "安徽省合肥市",
"861818690", "湖北省武汉市",
"86145080", "江苏省南京市",
"861360376", "河南省信阳市",
"861550837", "四川省德阳市",
"861896547", "福建省漳州市",
"861812833", "广东省揭阳市",
"861534695", "甘肃省武威市",
"861590327", "河北省沧州市",
"861385249", "江苏省淮安市",
"861513502", "山西省忻州市",
"86170870", "广西桂林市",
"861776612", "江苏省淮安市",
"861320560", "安徽省合肥市",
"861556342", "山东省莱芜市",
"861594638", "黑龙江省哈尔滨市",
"861824059", "河南省南阳市",
"86156171", "河南省新乡市",
"861538472", "内蒙古包头市",
"861338953", "宁夏吴忠市",
"861537923", "甘肃省庆阳市",
"861331072", "贵州省遵义市",
"861314406", "广东省潮州市",
"86133418", "上海市",
"861344755", "山东省菏泽市",
"861361795", "江西省宜春市",
"861869074", "贵州省贵阳市",
"861850522", "江苏省扬州市",
"861479641", "江西省吉安市",
"861312174", "内蒙古兴安盟",
"861831239", "广东省云浮市",
"861471950", "甘肃省酒泉市",
"86133021", "天津市",
"861320983", "山西省大同市",
"861361316", "河北省廊坊市",
"86566", "安徽省池州市",
"861386825", "浙江省湖州市",
"861340641", "山东省济南市",
"861508034", "福建省厦门市",
"861326789", "广东省湛江市",
"861327531", "山东省济南市",
"861571816", "广东省汕头市",
"861810313", "河北省张家口市",
"861322480", "内蒙古乌海市",
"861502626", "新疆吐鲁番地区",
"861816358", "湖北省孝感市",
"861311995", "新疆吐鲁番地区",
"861570876", "云南省文山壮族苗族自治州",
"861359329", "山西省长治市",
"861833348", "河北省邢台市",
"86182829", "四川省达州市",
"861365066", "广东省河源市",
"86151191", "广东省中山市",
"861811373", "四川省广元市",
"861897175", "湖北省黄石市",
"861454774", "山东省青岛市",
"861334501", "山东省青岛市",
"861473639", "广西柳州市",
"861828092", "四川省内江市",
"861768104", "安徽省六安市",
"861855660", "黑龙江省佳木斯市",
"861770748", "湖南省娄底市",
"861528893", "山东省淄博市",
"861585941", "福建省福州市",
"861772288", "广东省广州市",
"861380095", "宁夏银川市",
"86130023", "重庆市",
"86158001", "广东省中山市",
"861508359", "江西省赣州市",
"861318150", "山东省烟台市",
"861517120", "湖北省荆州市",
"861313293", "广西桂林市",
"861300032", "江苏省南京市",
"86132979", "湖北省武汉市",
"861882011", "广东省广州市",
"861525247", "江苏省南京市",
"861592978", "陕西省咸阳市",
"861804679", "江西省萍乡市",
"861308172", "辽宁省营口市",
"861801219", "江苏省泰州市",
"86150448", "内蒙古巴彦淖尔市",
"861359840", "河南省郑州市",
"861360660", "浙江省杭州市",
"861343196", "广东省清远市",
"861527045", "江西省吉安市",
"861519956", "新疆哈密地区",
"861842027", "广东省茂名市",
"861359364", "湖北省恩施土家族苗族自治州",
"861351894", "西藏林芝地区",
"861535049", "江西省新余市",
"861890856", "贵州省铜仁地区",
"86139326", "河北省廊坊市",
"861705601", "上海市",
"861877501", "广西梧州市",
"861523677", "河南省焦作市",
"861700400", "广东省深圳市",
"861360010", "广东省惠州市",
"861592939", "陕西省榆林市",
"861311572", "浙江省湖州市",
"861305075", "辽宁省辽阳市",
"861816074", "江西省南昌市",
"861804202", "浙江省杭州市",
"861301550", "河南省郑州市",
"861506547", "山东省济宁市",
"86153320", "天津市",
"861760457", "黑龙江省大兴安岭地区",
"861576965", "宁夏中卫市",
"861361507", "福建省漳州市",
"861776526", "广东省广州市",
"86180400", "辽宁省沈阳市",
"861393182", "河北省衡水市",
"861800327", "河北省沧州市",
"86158426", "辽宁省大连市",
"861459104", "广西防城港市",
"861356561", "新疆昌吉回族自治州",
"861874475", "贵州省黔南布依族苗族自治州",
"861329989", "青海省海东地区",
"861378811", "广西南宁市",
"861368879", "云南省丽江市",
"861396597", "安徽省滁州市",
"861776841", "江苏省苏州市",
"86158066", "山东省济南市",
"861367568", "安徽省阜阳市",
"861453895", "云南省曲靖市",
"861882661", "广东省清远市",
"861390971", "青海省西宁市",
"861774431", "四川省绵阳市",
"86188412", "辽宁省鞍山市",
"861861745", "河北省秦皇岛市",
"861800602", "福建省厦门市",
"861365555", "安徽省合肥市",
"861773705", "河南省商丘市",
"861850461", "黑龙江省哈尔滨市",
"861323771", "广西南宁市",
"861475248", "江苏省宿迁市",
"861365616", "江苏省无锡市",
"861573500", "山西省忻州市",
"86182543", "山东省滨州市",
"861776783", "吉林省延边朝鲜族自治州",
"861477806", "广东省河源市",
"86155246", "辽宁省大连市",
"861839410", "甘肃省临夏回族自治州",
"861318640", "江苏省南京市",
"861568233", "四川省泸州市",
"861554597", "黑龙江省哈尔滨市",
"861850555", "安徽省马鞍山市",
"861473678", "云南省西双版纳傣族自治州",
"861363724", "安徽省淮北市",
"86134596", "福建省漳州市",
"861816412", "湖北省襄樊市",
"86137295", "广东省汕尾市",
"861837199", "湖北省武汉市",
"861884863", "贵州省毕节地区",
"861470730", "湖南省岳阳市",
"861890497", "辽宁省营口市",
"861355711", "广西南宁市",
"861809753", "新疆石河子市",
"861395613", "安徽省六安市",
"861590759", "广东省湛江市",
"861535003", "江西省上饶市",
"861335548", "山东省泰安市",
"861452824", "四川省南充市",
"861559403", "甘肃省陇南市",
"861368378", "河南省开封市",
"861831758", "河南省新乡市",
"861804380", "吉林省松原市",
"861323745", "湖南省怀化市",
"861380250", "广东省广州市",
"861345428", "浙江省湖州市",
"861561530", "山东省菏泽市",
"86180782", "广西柳州市",
"861823070", "贵州省黔东南苗族侗族自治州",
"861597762", "广西百色市",
"861352982", "云南省红河哈尼族彝族自治州",
"861505535", "安徽省宿州市",
"861773664", "广西南宁市",
"861515665", "安徽省宿州市",
"861332414", "辽宁省本溪市",
"861567189", "湖北省恩施土家族苗族自治州",
"861318432", "浙江省宁波市",
"861384650", "黑龙江省黑河市",
"861347521", "山东省枣庄市",
"861881538", "山东省泰安市",
"861786463", "山东省滨州市",
"86151123", "广东省深圳市",
"861318628", "陕西省安康市",
"861859163", "陕西省渭南市",
"861580932", "甘肃省定西市",
"861452869", "青海省海西蒙古族藏族自治州",
"861332072", "四川省攀枝花市",
"86156271", "广东省云浮市",
"86136681", "四川省成都市",
"861824646", "黑龙江省七台河市",
"86176884", "广东省广州市",
"861362795", "江西省宜春市",
"861593140", "河北省承德市",
"861500995", "新疆吐鲁番地区",
"861760922", "陕西省榆林市",
"86133227", "广东省汕头市",
"861807163", "江苏省盐城市",
"861476325", "山东省青岛市",
"861310684", "广东省珠海市",
"861870779", "广西北海市",
"861539467", "江苏省盐城市",
"861362316", "河北省廊坊市",
"861390945", "甘肃省武威市",
"86156414", "辽宁省本溪市",
"861853234", "河北省衡水市",
"861876831", "浙江省嘉兴市",
"861537321", "河北省邢台市",
"861317900", "吉林省长春市",
"861861771", "河北省沧州市",
"861314284", "江苏省南京市",
"861338351", "山西省太原市",
"86189390", "河南省三门峡市",
"861510434", "吉林省四平市",
"861835802", "浙江省金华市",
"861822786", "四川省乐山市",
"86189933", "甘肃省平凉市",
"861776875", "江苏省镇江市",
"861303190", "河北省邢台市",
"861308253", "江苏省连云港市",
"861833849", "河南省濮阳市",
"861870738", "湖南省娄底市",
"861857811", "广东省湛江市",
"86137388", "浙江省宁波市",
"861839973", "新疆克孜勒苏柯尔克孜自治州",
"86153931", "甘肃省兰州市",
"86130572", "江苏省无锡市",
"861331865", "广东省江门市",
"861322322", "河北省保定市",
"861391231", "江苏省常州市",
"861339395", "河南省驻马店市",
"861308574", "广东省潮州市",
"861773472", "河南省许昌市",
"861569276", "贵州省铜仁地区",
"861800918", "陕西省西安市",
"861770720", "湖北省十堰市",
"861555187", "安徽省阜阳市",
"861559882", "内蒙古鄂尔多斯市",
"861860853", "贵州省安顺市",
"861399407", "山西省忻州市",
"861313986", "新疆阿克苏地区",
"861816859", "江苏省镇江市",
"861875240", "江苏省淮安市",
"861322607", "广东省中山市",
"861811447", "江苏省南京市",
"861817596", "湖南省长沙市",
"861555617", "安徽省亳州市",
"861570525", "江苏省扬州市",
"861479459", "黑龙江省大庆市",
"861350921", "广东省东莞市",
"861522442", "山东省青岛市",
"86131509", "内蒙古赤峰市",
"861888807", "江苏省扬州市",
"861770966", "安徽省安庆市",
"861595496", "山东省烟台市",
"861567069", "河南省南阳市",
"861898727", "云南省昆明市",
"861894744", "内蒙古兴安盟",
"861315292", "山西省大同市",
"86138153", "江苏省徐州市",
"86184542", "山东省青岛市",
"861508858", "浙江省温州市",
"861355853", "四川省达州市",
"861320708", "江西省南昌市",
"861845002", "福建省厦门市",
"861809811", "广东省潮州市",
"861341185", "广东省深圳市",
"861500572", "浙江省湖州市",
"86451", "黑龙江省哈尔滨市",
"861337702", "广西柳州市",
"86183554", "安徽省淮南市",
"86184520", "江苏省南京市",
"861510550", "安徽省滁州市",
"861568913", "山东省青岛市",
"861592664", "湖北省荆州市",
"861459798", "新疆乌鲁木齐市",
"861889551", "安徽省阜阳市",
"861818012", "四川省攀枝花市",
"861832034", "广东省茂名市",
"861470411", "辽宁省大连市",
"861588518", "贵州省铜仁地区",
"861529464", "河南省郑州市",
"861891216", "江苏省连云港市",
"861831727", "河南省焦作市",
"861589105", "陕西省延安市",
"861835103", "江苏省苏州市",
"86181821", "湖南省常德市",
"861853039", "河南省鹤壁市",
"861598356", "四川省攀枝花市",
"861311756", "湖南省常德市",
"861535463", "吉林省四平市",
"861380330", "河北省唐山市",
"861820393", "河南省濮阳市",
"861320975", "青海省海西蒙古族藏族自治州",
"861800859", "贵州省黔西南布依族苗族自治州",
"86137459", "黑龙江省大庆市",
"861810953", "宁夏吴忠市",
"861350700", "江西省南昌市",
"861471471", "广东省梅州市",
"861816918", "宁夏固原市",
"86139875", "云南省保山市",
"861890276", "广东省揭阳市",
"861811132", "四川省阿坝藏族羌族自治州",
"86159772", "广西柳州市",
"861509025", "河南省许昌市",
"861555338", "山东省滨州市",
"861529429", "甘肃省定西市",
"86189925", "陕西省安康市",
"861308333", "安徽省滁州市",
"861597446", "湖南省湘潭市",
"861862845", "陕西省咸阳市",
"861557025", "江西省宜春市",
"861330690", "福建省福州市",
"861529209", "湖南省益阳市",
"861338231", "江苏省淮安市",
"861860642", "山东省枣庄市",
"861539570", "浙江省衢州市",
"861760440", "吉林省长春市",
"861843244", "河北省石家庄市",
"861506550", "山东省威海市",
"86183759", "重庆市",
"861508919", "广东省珠海市",
"861582576", "浙江省金华市",
"861776090", "四川省雅安市",
"86131971", "湖北省襄樊市",
"861884564", "黑龙江省哈尔滨市",
"861596911", "云南省曲靖市",
"861323213", "广东省云浮市",
"861322417", "辽宁省营口市",
"861301547", "山西省太原市",
"861309836", "湖北省黄冈市",
"861518813", "云南省曲靖市",
"861345896", "四川省德阳市",
"86145829", "福建省泉州市",
"861355152", "四川省内江市",
"861320592", "福建省厦门市",
"861317721", "湖北省襄樊市",
"861359857", "河南省信阳市",
"86138607", "福建省泉州市",
"861337598", "福建省福州市",
"861573868", "河南省南阳市",
"861819718", "青海省海东地区",
"861869759", "安徽省宿州市",
"861333799", "江苏省盐城市",
"861833988", "河南省三门峡市",
"861555379", "山东省莱芜市",
"861768798", "江西省景德镇市",
"861318147", "山东省济宁市",
"861817048", "江西省赣州市",
"861827171", "湖北省恩施土家族苗族自治州",
"861839487", "甘肃省庆阳市",
"861470016", "江苏省徐州市",
"861584775", "内蒙古呼和浩特市",
"861844946", "新疆克拉玛依市",
"86130492", "广东省揭阳市",
"861342173", "广东省湛江市",
"861886039", "河南省郑州市",
"861559613", "陕西省安康市",
"861394894", "内蒙古乌兰察布市",
"861599711", "湖北省黄石市",
"861814800", "四川省绵阳市",
"861853078", "河南省商丘市",
"861898758", "云南省昆明市",
"861360736", "湖南省常德市",
"861815685", "安徽省阜阳市",
"861867169", "湖北省恩施土家族苗族自治州",
"861860152", "江苏省盐城市",
"861502936", "陕西省汉中市",
"861572395", "广西玉林市",
"861872452", "黑龙江省齐齐哈尔市",
"861815115", "江苏省泰州市",
"861314169", "江苏省南京市",
"861521789", "广东省佛山市",
"861772650", "四川省德阳市",
"86156033", "河北省秦皇岛市",
"861835977", "福建省福州市",
"861531236", "江苏省镇江市",
"861895944", "福建省宁德市",
"861351593", "福建省莆田市",
"861475610", "河北省石家庄市",
"861325932", "陕西省延安市",
"861567409", "湖南省郴州市",
"861376816", "广西百色市",
"861572716", "湖北省荆州市",
"861350631", "山东省威海市",
"861303697", "广西钦州市",
"861390733", "湖南省株洲市",
"861705016", "辽宁省大连市",
"861313346", "山西省晋城市",
"861825018", "福建省福州市",
"86134669", "山西省运城市",
"861454585", "甘肃省金昌市",
"861535244", "甘肃省天水市",
"861510547", "山东省济宁市",
"861807790", "广西玉林市",
"861522948", "陕西省商洛市",
"861891936", "甘肃省张掖市",
"861800074", "江西省宜春市",
"86133285", "福建省泉州市",
"861365226", "广东省佛山市",
"861873903", "河南省南阳市",
"861816602", "江西省宜春市",
"86151374", "河南省许昌市",
"86176652", "广东省深圳市",
"861318979", "河北省石家庄市",
"861816238", "湖北省荆门市",
"861882606", "广东省广州市",
"86150977", "河北省保定市",
"861550481", "内蒙古呼和浩特市",
"861860554", "安徽省淮南市",
"861386643", "安徽省安庆市",
"861336356", "山西省晋城市",
"861887249", "湖北省荆州市",
"861593647", "河南省安阳市",
"86185248", "辽宁省铁岭市",
"861573369", "河北省张家口市",
"861334055", "福建省三明市",
"861866677", "广东省肇庆市",
"861477861", "广东省湛江市",
"861338911", "陕西省延安市",
"861580479", "内蒙古锡林郭勒盟",
"861801472", "江苏省南京市",
"861393402", "山西省大同市",
"861362956", "宁夏石嘴山市",
"861811450", "江苏省无锡市",
"861563998", "河南省平顶山市",
"861875257", "江苏省徐州市",
"86139302", "河北省保定市",
"861843463", "山西省晋城市",
"86182984", "甘肃省兰州市",
"861700610", "江苏省南京市",
"861314522", "江苏省徐州市",
"861500756", "广东省珠海市",
"86188011", "北京市",
"861513426", "辽宁省盘锦市",
"861850406", "辽宁省锦州市",
"861700180", "广东省深圳市",
"861523319", "河北省邢台市",
"861593288", "江西省萍乡市",
"86137518", "广东省广州市",
"861569497", "河北省沧州市",
"861347490", "内蒙古呼伦贝尔市",
"861357376", "山东省济南市",
"861835149", "江苏省连云港市",
"861514588", "黑龙江省双鸭山市",
"861536865", "云南省德宏傣族景颇族自治州",
"86188428", "辽宁省大连市",
"86130035", "江苏省南通市",
"861800412", "辽宁省鞍山市",
"861366454", "黑龙江省佳木斯市",
"861323933", "甘肃省平凉市",
"861508239", "四川省攀枝花市",
"861842058", "广东省清远市",
"861575695", "四川省攀枝花市",
"86150410", "辽宁省铁岭市",
"861800358", "山西省吕梁市",
"861862871", "吉林省松原市",
"861872819", "四川省雅安市",
"86150697", "山东省济宁市",
"861806313", "山东省日照市",
"86134205", "广东省韶关市",
"861353643", "广东省湛江市",
"861802597", "广东省佛山市",
"861760428", "辽宁省大连市",
"861305890", "浙江省湖州市",
"861760208", "广东省东莞市",
"861478531", "贵州省毕节地区",
"861453507", "山东省济南市",
"86137506", "浙江省台州市",
"861452523", "山东省临沂市",
"861388669", "湖北省宜昌市",
"861514904", "内蒙古兴安盟",
"861821886", "广东省湛江市",
"861580438", "吉林省松原市",
"861760632", "山东省枣庄市",
"861550086", "宁夏吴忠市",
"861361895", "西藏昌都地区",
"861386153", "江苏省无锡市",
"861860430", "吉林省长春市",
"861344855", "山东省菏泽市",
"861773939", "河南省周口市",
"861508278", "四川省南充市",
"86170880", "四川省乐山市",
"861334566", "安徽省池州市",
"86156758", "湖南省长沙市",
"86153995", "安徽省宿州市",
"86176403", "辽宁省大连市",
"861329848", "河南省三门峡市",
"861550737", "湖南省益阳市",
"861829502", "宁夏石嘴山市",
"861530976", "青海省玉树藏族自治州",
"861316032", "江苏省扬州市",
"861452786", "新疆巴音郭楞蒙古自治州",
"861367323", "河北省石家庄市",
"861879785", "江西省宜春市",
"861450246", "河北省承德市",
"861587991", "江西省鹰潭市",
"861454646", "云南省红河哈尼族彝族自治州",
"861380247", "广东省惠州市",
"861705666", "北京市",
"861569856", "山西省太原市",
"861835659", "安徽省芜湖市",
"861317673", "山东省潍坊市",
"861521801", "广东省河源市",
"86155200", "重庆市",
"861339030", "辽宁省鞍山市",
"861814323", "西藏山南地区",
"861320941", "甘肃省甘南藏族自治州",
"861525095", "江苏省南京市",
"861366530", "山东省菏泽市",
"86139827", "四川省泸州市",
"861528667", "贵州省六盘水市",
"86138346", "山西省太原市",
"861335199", "黑龙江省大庆市",
"861889814", "河南省开封市",
"861521766", "广东省佛山市",
"861340683", "山东省济宁市",
"861350568", "安徽省阜阳市",
"86770", "广西防城港市",
"86152711", "湖北省武汉市",
"86133422", "辽宁省大连市",
"861391953", "甘肃省平凉市",
"86184796", "江西省吉安市",
"861351794", "江西省抚州市",
"861389952", "新疆石河子市",
"861837520", "贵州省黔南布依族苗族自治州",
"861529815", "四川省宜宾市",
"861590412", "辽宁省鞍山市",
"861806231", "湖北省孝感市",
"861319454", "黑龙江省佳木斯市",
"86133062", "江苏省苏州市",
"86132136", "河南省洛阳市",
"86132989", "西藏拉萨市",
"861344283", "广西柳州市",
"861534088", "山西省晋城市",
"861392351", "广东省潮州市",
"861760315", "河北省唐山市",
"861705370", "陕西省西安市",
"86187740", "湖南省长沙市",
"861589230", "四川省资阳市",
"861805277", "江苏省镇江市",
"861501936", "广东省茂名市",
"861571395", "河南省漯河市",
"861597790", "广西河池市",
"86137131", "广东省东莞市",
"861871452", "黑龙江省齐齐哈尔市",
"861454874", "四川省宜宾市",
"861314461", "黑龙江省哈尔滨市",
"861387299", "湖北省武汉市",
"861870339", "河北省邢台市",
"861399739", "青海省海西蒙古族藏族自治州",
"861869327", "甘肃省兰州市",
"861848350", "四川省泸州市",
"861570776", "广西百色市",
"86187722", "湖北省十堰市",
"861803647", "江苏省常州市",
"861556108", "内蒙古包头市",
"861554978", "湖北省荆门市",
"861858240", "四川省眉山市",
"861760796", "江西省吉安市",
"861819677", "安徽省马鞍山市",
"861314555", "安徽省马鞍山市",
"861522789", "河北省承德市",
"861869602", "湖北省荆门市",
"861886767", "浙江省嘉兴市",
"861807075", "广西钦州市",
"861869238", "湖南省常德市",
"861779941", "新疆昌吉回族自治州",
"861533846", "广东省云浮市",
"86157708", "江西省赣州市",
"861399778", "湖北省恩施土家族苗族自治州",
"861322915", "广东省惠州市",
"86136923", "广东省湛江市",
"861870378", "河南省开封市",
"861810351", "山西省太原市",
"861820991", "新疆乌鲁木齐市",
"861336532", "山东省青岛市",
"861820654", "山东省枣庄市",
"861477706", "广西玉林市",
"861879211", "安徽省六安市",
"861869279", "湖南省邵阳市",
"861838114", "四川省广安市",
"861319530", "安徽省池州市",
"861309660", "山西省朔州市",
"861518271", "四川省攀枝花市",
"861377228", "陕西省延安市",
"861356940", "河南省新乡市",
"861533521", "江苏省无锡市",
"861323871", "云南省昆明市",
"861328761", "山东省泰安市",
"861882053", "广东省肇庆市",
"861357660", "江西省吉安市",
"861552455", "辽宁省大连市",
"861830432", "吉林省吉林市",
"86130328", "四川省成都市",
"861514493", "内蒙古兴安盟",
"861524159", "辽宁省丹东市",
"861776741", "新疆乌鲁木齐市",
"861596313", "山东省济南市",
"86189697", "浙江省温州市",
"861320477", "内蒙古鄂尔多斯市",
"861341907", "四川省达州市",
"861590358", "山西省吕梁市",
"86189410", "辽宁省铁岭市",
"861303082", "福建省莆田市",
"861830628", "江苏省南通市",
"86156394", "河南省周口市",
"861521137", "湖南省衡阳市",
"861889967", "新疆巴音郭楞蒙古自治州",
"861709896", "广东省中山市",
"861829898", "甘肃省嘉峪关市",
"861368779", "广西北海市",
"861479712", "山西省忻州市",
"86159446", "吉林省白城市",
"861321417", "辽宁省营口市",
"861552561", "山西省阳泉市",
"861458400", "河南省商丘市",
"861708393", "河南省濮阳市",
"861770303", "广东省江门市",
"861594940", "内蒙古鄂尔多斯市",
"86186873", "云南省红河哈尼族彝族自治州",
"861316365", "黑龙江省绥化市",
"861805840", "浙江省杭州市",
"861308931", "吉林省延边朝鲜族自治州",
"861834408", "广东省广州市",
"861771140", "四川省绵阳市",
"861314066", "河南省周口市",
"861503040", "河北省邯郸市",
"861373999", "内蒙古通辽市",
"861822886", "四川省巴中市",
"86137083", "重庆市",
"861835702", "浙江省杭州市",
"861779592", "陕西省西安市",
"861538978", "内蒙古巴彦淖尔市",
"86188392", "河南省鹤壁市",
"861591705", "广东省韶关市",
"861871819", "广东省湛江市",
"861857853", "广东省肇庆市",
"86150925", "山东省德州市",
"861520423", "辽宁省朝阳市",
"861771128", "四川省成都市",
"86136409", "广东省深圳市",
"861801597", "江苏省镇江市",
"861471947", "甘肃省武威市",
"861395141", "江苏省南通市",
"861537633", "山东省日照市",
"861394982", "河南省许昌市",
"861870879", "云南省普洱市",
"861860811", "四川省德阳市",
"86182638", "山东省泰安市",
"861318305", "河南省洛阳市",
"861898919", "四川省南充市",
"861362895", "西藏昌都地区",
"861566795", "陕西省铜川市",
"86181709", "江西省南昌市",
"861550024", "吉林省白山市",
"861871130", "湖南省湘潭市",
"861830640", "山东省济南市",
"861351342", "河北省保定市",
"861569572", "浙江省湖州市",
"861454334", "内蒙古阿拉善盟",
"86136671", "湖北省武汉市",
"86156281", "新疆伊犁哈萨克自治州",
"861821824", "广东省湛江市",
"861536072", "广东省湛江市",
"861360692", "福建省厦门市",
"86151565", "安徽省合肥市",
"861452769", "广西南宁市",
"861576007", "四川省宜宾市",
"861315596", "江西省萍乡市",
"861327974", "新疆伊犁哈萨克自治州",
"861334589", "浙江省金华市",
"861320343", "山西省阳泉市",
"861458687", "湖南省湘潭市",
"861840314", "河北省承德市",
"861863417", "河北省唐山市",
"86187454", "黑龙江省佳木斯市",
"861588436", "四川省乐山市",
"861351488", "内蒙古巴彦淖尔市",
"861321100", "广东省东莞市",
"861536414", "湖南省长沙市",
"861501216", "云南省西双版纳傣族自治州",
"861458117", "安徽省阜阳市",
"861778674", "湖北省随州市",
"861768206", "安徽省安庆市",
"861305083", "辽宁省铁岭市",
"861532916", "贵州省铜仁地区",
"86135840", "江苏省南京市",
"861556982", "甘肃省天水市",
"861323845", "内蒙古乌海市",
"861390450", "黑龙江省哈尔滨市",
"86180772", "广西柳州市",
"861452724", "湖北省荆门市",
"861551202", "河北省唐山市",
"861821869", "广东省茂名市",
"861859446", "福建省莆田市",
"861831858", "广东省河源市",
"861835046", "福建省龙岩市",
"861550069", "青海省海东地区",
"86155725", "湖北省孝感市",
"861874483", "贵州省黔东南苗族侗族自治州",
"861551638", "河南省洛阳市",
"861346620", "云南省昭通市",
"861355811", "广西南宁市",
"86135822", "河北省保定市",
"861388686", "湖北省随州市",
"861590859", "贵州省黔西南布依族苗族自治州",
"861337802", "湖南省湘潭市",
"861871927", "广东省深圳市",
"861770349", "山西省朔州市",
"861858408", "四川省成都市",
"861303529", "湖北省十堰市",
"86136991", "北京市",
"861809711", "青海省西宁市",
"861320808", "浙江省宁波市",
"861355753", "广西桂林市",
"861709922", "浙江省衢州市",
"861558168", "湖南省衡阳市",
"861858337", "四川省成都市",
"861894844", "广东省揭阳市",
"861554219", "辽宁省沈阳市",
"861807041", "江西省南昌市",
"861585296", "江苏省泰州市",
"861898827", "云南省昆明市",
"86151514", "江苏省苏州市",
"861769248", "河北省衡水市",
"861317098", "江西省景德镇市",
"861560265", "广东省惠州市",
"861860753", "广东省梅州市",
"861323331", "山西省晋城市",
"861339816", "四川省成都市",
"861581681", "广东省东莞市",
"861816759", "新疆哈密地区",
"861538939", "陕西省汉中市",
"861770820", "广东省汕头市",
"861573386", "河北省衡水市",
"86147452", "广东省广州市",
"861344996", "重庆市",
"861361956", "宁夏石嘴山市",
"861326388", "广西南宁市",
"861370587", "浙江省温州市",
"861588031", "福建省莆田市",
"861331765", "广西玉林市",
"86886", "云南省怒江傈僳族自治州",
"861459426", "云南省楚雄彝族自治州",
"861390534", "山东省德州市",
"861845846", "浙江省温州市",
"861897183", "湖北省荆门市",
"861820542", "山东省青岛市",
"86137378", "广西梧州市",
"86188217", "陕西省西安市",
"861837548", "山东省泰安市",
"861377877", "四川省巴中市",
"861359728", "广西南宁市",
"861847632", "广东省深圳市",
"861338313", "河北省张家口市",
"861383928", "河南省濮阳市",
"861555242", "山东省淄博市",
"861392264", "广东省肇庆市",
"861311468", "黑龙江省鹤岗市",
"861539960", "安徽省安庆市",
"861317338", "山东省泰安市",
"86185291", "广东省广州市",
"861810377", "河南省南阳市",
"86184513", "江苏省盐城市",
"861323091", "河北省秦皇岛市",
"861474131", "辽宁省沈阳市",
"86155504", "山东省济南市",
"861315025", "新疆巴音郭楞蒙古自治州",
"861301522", "内蒙古呼和浩特市",
"861346935", "湖南省怀化市",
"861818695", "湖北省孝感市",
"86157059", "福建省福州市",
"86150850", "贵州省遵义市",
"861550911", "陕西省延安市",
"861524975", "河南省商丘市",
"86137967", "黑龙江省哈尔滨市",
"861539583", "浙江省杭州市",
"861510089", "河北省邢台市",
"861769615", "山西省长治市",
"861566083", "河南省新乡市",
"861367472", "内蒙古包头市",
"861368923", "陕西省渭南市",
"861507818", "广西百色市",
"861477734", "广西桂林市",
"861317407", "江苏省南京市",
"861775417", "安徽省宣城市",
"861599148", "陕西省安康市",
"8618223", "重庆市",
"861899596", "湖北省随州市",
"861323857", "贵州省毕节地区",
"861396700", "浙江省衢州市",
"861581989", "广东省惠州市",
"861800982", "辽宁省朝阳市",
"861885156", "江苏省无锡市",
"86150571", "浙江省杭州市",
"861320451", "黑龙江省哈尔滨市",
"861362041", "广东省广州市",
"861530290", "广东省茂名市",
"861386820", "浙江省舟山市",
"861538631", "湖南省永州市",
"861305316", "安徽省芜湖市",
"861370656", "浙江省台州市",
"861539726", "浙江省嘉兴市",
"861829078", "新疆阿克苏地区",
"861568149", "四川省达州市",
"861534690", "甘肃省临夏回族自治州",
"861338481", "内蒙古赤峰市",
"861320565", "安徽省马鞍山市",
"861335552", "安徽省蚌埠市",
"861361790", "江西省新余市",
"86147639", "山东省青岛市",
"861814664", "江西省宜春市",
"861371992", "广东省汕头市",
"861863485", "山西省晋中市",
"861380775", "广西玉林市",
"86150092", "陕西省西安市",
"861458185", "浙江省丽水市",
"86156682", "山东省菏泽市",
"86136272", "湖北省武汉市",
"861358976", "山东省烟台市",
"861839237", "陕西省西安市",
"861553464", "山西省晋城市",
"861806189", "江苏省徐州市",
"861472896", "西藏那曲地区",
"861831221", "广东省揭阳市",
"861536760", "湖南省娄底市",
"861332860", "福建省南平市",
"86158179", "广东省汕头市",
"861576498", "内蒙古乌兰察布市",
"861761453", "黑龙江省牡丹江市",
"861323496", "黑龙江省哈尔滨市",
"861522458", "广西钦州市",
"861337311", "河北省石家庄市",
"861858713", "云南省文山壮族苗族自治州",
"861300844", "陕西省咸阳市",
"86151110", "湖南省长沙市",
"861531486", "浙江省丽水市",
"861805251", "江苏省常州市",
"861338086", "广东省阳江市",
"861359213", "河南省开封市",
"861342180", "广东省深圳市",
"861507170", "湖北省黄冈市",
"861318122", "山东省临沂市",
"861809435", "江苏省南通市",
"861768914", "西藏林芝地区",
"861595623", "安徽省池州市",
"861889492", "河北省秦皇岛市",
"861366944", "广西梧州市",
"861338737", "湖南省益阳市",
"861473574", "山西省朔州市",
"861855503", "安徽省芜湖市",
"861568659", "陕西省铜川市",
"861810409", "辽宁省大连市",
"861362446", "吉林省长春市",
"861819994", "新疆昌吉回族自治州",
"861898466", "贵州省铜仁地区",
"861399900", "新疆巴音郭楞蒙古自治州",
"861370146", "江苏省南京市",
"861525908", "福建省宁德市",
"86181733", "湖南省长沙市",
"861458556", "山东省日照市",
"86177536", "山东省潍坊市",
"861345138", "内蒙古巴彦淖尔市",
"86180919", "陕西省铜川市",
"861521635", "山东省聊城市",
"861322350", "山西省忻州市",
"86131577", "浙江省温州市",
"861888084", "四川省绵阳市",
"861575474", "内蒙古乌兰察布市",
"861335644", "广东省江门市",
"86152526", "江苏省泰州市",
"861861496", "河南省郑州市",
"861813431", "河北省保定市",
"861867547", "广东省肇庆市",
"861820699", "云南省大理白族自治州",
"861787842", "广西梧州市",
"86139258", "广东省东莞市",
"861839829", "四川省阿坝藏族羌族自治州",
"861868463", "湖南省郴州市",
"861329643", "山东省淄博市",
"861881634", "山东省莱芜市",
"861528085", "福建省泉州市",
"861302066", "山东省临沂市",
"861321485", "内蒙古鄂尔多斯市",
"861380883", "广东省深圳市",
"861392443", "广东省揭阳市",
"861367705", "江西省宜春市",
"861770752", "广东省惠州市",
"861594733", "内蒙古鄂尔多斯市",
"861314547", "山东省济南市",
"86152953", "江苏省盐城市",
"861322987", "广东省珠海市",
"861780030", "河北省邯郸市",
"861524194", "辽宁省本溪市",
"86150435", "吉林省通化市",
"861839864", "四川省乐山市",
"861301089", "广东省深圳市",
"86180867", "江苏省徐州市",
"861310588", "浙江省丽水市",
"861839340", "甘肃省临夏回族自治州",
"86177266", "重庆市",
"861369392", "河南省鹤壁市",
"861380741", "湖南省株洲市",
"861354166", "四川省自贡市",
"861895454", "山东省济南市",
"86188443", "吉林省延边朝鲜族自治州",
"861599937", "新疆和田地区",
"861510522", "江苏省徐州市",
"861816342", "广东省珠海市",
"861459234", "四川省成都市",
"861317878", "广东省汕头市",
"86157521", "云南省曲靖市",
"861396631", "安徽省六安市",
"861872942", "陕西省榆林市",
"861390506", "福建省泉州市",
"861804132", "辽宁省抚顺市",
"861308639", "四川省广安市",
"861593307", "河北省保定市",
"861335154", "吉林省长春市",
"861864839", "内蒙古鄂尔多斯市",
"86189311", "河北省石家庄市",
"861584688", "黑龙江省鹤岗市",
"861839917", "新疆哈密地区",
"861362075", "吉林省吉林市",
"861317110", "内蒙古通辽市",
"861775100", "江苏省南京市",
"861760387", "河南省郑州市",
"861536892", "云南省西双版纳傣族自治州",
"861354737", "四川省泸州市",
"861332792", "江苏省无锡市",
"861329725", "湖北省随州市",
"861862740", "湖南省岳阳市",
"861774815", "四川省绵阳市",
"861317680", "山东省威海市",
"861855549", "安徽省宿州市",
"861530566", "安徽省池州市",
"861866449", "广东省汕头市",
"861302461", "浙江省绍兴市",
"861351759", "广西北海市",
"861810443", "吉林省延边朝鲜族自治州",
"861301169", "山东省潍坊市",
"861310904", "新疆伊犁哈萨克自治州",
"861356385", "山东省菏泽市",
"861890990", "新疆克拉玛依市",
"861308678", "广西河池市",
"861454306", "黑龙江省哈尔滨市",
"861329153", "浙江省嘉兴市",
"861707391", "河南省焦作市",
"861833418", "贵州省毕节地区",
"861319499", "四川省成都市",
"861317839", "福建省龙岩市",
"861819175", "陕西省西安市",
"86130010", "北京市",
"86137819", "河南省新乡市",
"861307933", "甘肃省武威市",
"861803145", "河北省秦皇岛市",
"86177201", "天津市",
"861511360", "广东省湛江市",
"861888129", "四川省广元市",
"861316543", "山东省滨州市",
"861352327", "河南省平顶山市",
"861588404", "四川省甘孜藏族自治州",
"861453083", "安徽省合肥市",
"861360549", "山东省临沂市",
"861327697", "福建省漳州市",
"861812506", "广东省珠海市",
"861768234", "浙江省杭州市",
"861760950", "宁夏银川市",
"861599120", "陕西省榆林市",
"861340366", "山西省晋中市",
"861782876", "四川省南充市",
"86150656", "山东省潍坊市",
"861848915", "西藏昌都地区",
"861302186", "河北省邯郸市",
"861359933", "福建省龙岩市",
"861778997", "西藏那曲地区",
"861597956", "江西省抚州市",
"861580647", "山东省潍坊市",
"861398926", "四川省凉山彝族自治州",
"861525612", "安徽省淮北市",
"861517273", "湖北省咸宁市",
"861596086", "福建省漳州市",
"861350805", "四川省内江市",
"86178637", "山东省枣庄市",
"861518902", "江苏省连云港市",
"861334976", "湖北省宜昌市",
"861869593", "河南省新乡市",
"861576784", "广东省深圳市",
"861333553", "安徽省芜湖市",
"861875751", "浙江省绍兴市",
"86131192", "陕西省延安市",
"861327763", "湖北省荆门市",
"86159867", "广东省深圳市",
"86132728", "重庆市",
"861337913", "陕西省渭南市",
"861568702", "云南省昭通市",
"861824580", "黑龙江省大庆市",
"861770725", "湖北省襄樊市",
"861865978", "福建省龙岩市",
"861346843", "山东省烟台市",
"861513867", "河南省郑州市",
"86189435", "吉林省吉林市",
"861593516", "山西省吕梁市",
"861359871", "河南省新乡市",
"861803438", "河北省衡水市",
"861390317", "河北省沧州市",
"861875245", "江苏省宿迁市",
"861890468", "黑龙江省鹤岗市",
"861877047", "江西省吉安市",
"86153022", "广东省广州市",
"861832401", "新疆乌鲁木齐市",
"86138689", "浙江省金华市",
"861338069", "广东省惠州市",
"861803307", "广东省深圳市",
"861770153", "江苏省无锡市",
"861510616", "江苏省无锡市",
"861453762", "广西南宁市",
"861521458", "黑龙江省伊春市",
"861556074", "内蒙古呼和浩特市",
"861471896", "西藏那曲地区",
"861331344", "山西省晋中市",
"861809937", "新疆昌吉回族自治州",
"861452397", "西藏阿里地区",
"861339390", "河南省周口市",
"861700772", "广西南宁市",
"861705383", "广东省广州市",
"861880791", "江西省南昌市",
"861345076", "广东省佛山市",
"861331860", "广东省清远市",
"861324249", "广东省江门市",
"861829693", "江西省萍乡市",
"861344270", "黑龙江省哈尔滨市",
"861350978", "山西省大同市",
"86151210", "上海市",
"861869488", "浙江省台州市",
"861893297", "河北省邢台市",
"861341180", "广东省佛山市",
"861510555", "安徽省马鞍山市",
"861360704", "江西省南昌市",
"86187865", "贵州省毕节地区",
"861787611", "广东省佛山市",
"86181246", "广东省深圳市",
"861347539", "山东省临沂市",
"86184088", "云南省临沧市",
"861570520", "江苏省徐州市",
"861536984", "河北省沧州市",
"861334047", "福建省宁德市",
"861589480", "内蒙古呼伦贝尔市",
"861853261", "河北省张家口市",
"861343738", "广东省东莞市",
"861835694", "安徽省合肥市",
"861853898", "河南省南阳市",
"861361446", "吉林省白城市",
"861829767", "安徽省宿州市",
"861332636", "山东省潍坊市",
"861396568", "安徽省合肥市",
"861384655", "黑龙江省大兴安岭地区",
"861302522", "广东省汕头市",
"86135389", "广东省广州市",
"861515660", "安徽省池州市",
"861505530", "安徽省芜湖市",
"861769872", "河南省焦作市",
"86189656", "福建省泉州市",
"861312468", "贵州省六盘水市",
"861336043", "广东省江门市",
"861871591", "河北省承德市",
"861774243", "陕西省渭南市",
"861369543", "山东省滨州市",
"861551373", "山西省阳泉市",
"861567351", "湖南省郴州市",
"861340888", "云南省临沧市",
"861569008", "河北省承德市",
"86184373", "河南省新乡市",
"861335876", "辽宁省锦州市",
"861550313", "河北省张家口市",
"861770643", "浙江省杭州市",
"861860599", "福建省南平市",
"861313053", "辽宁省丹东市",
"861575197", "甘肃省天水市",
"861509260", "山东省菏泽市",
"861318671", "浙江省衢州市",
"861812317", "四川省内江市",
"861329752", "湖北省孝感市",
"861840537", "山东省济宁市",
"861561535", "山东省烟台市",
"861323740", "湖南省岳阳市",
"861380255", "广东省深圳市",
"861471457", "广东省深圳市",
"861804385", "吉林省松原市",
"861328374", "河南省许昌市",
"861823075", "贵州省毕节地区",
"861571362", "河南省商丘市",
"861502588", "甘肃省张掖市",
"861347578", "山东省济宁市",
"861454517", "湖南省湘西土家族苗族自治州",
"861879093", "河南省漯河市",
"861361041", "广东省惠州市",
"861539784", "江西省上饶市",
"861317905", "吉林省松原市",
"861819449", "甘肃省定西市",
"86139046", "黑龙江省哈尔滨市",
"861865939", "福建省宁德市",
"861582989", "陕西省铜川市",
"86150311", "河北省石家庄市",
"86187814", "四川省乐山市",
"861303195", "河北省张家口市",
"861776870", "江苏省泰州市",
"861859956", "福建省漳州市",
"86182805", "四川省德阳市",
"861834682", "黑龙江省伊春市",
"861520372", "河南省安阳市",
"861857120", "湖北省襄樊市",
"86130343", "天津市",
"861832742", "湖北省襄樊市",
"861593145", "河北省唐山市",
"861525783", "浙江省丽水市",
"861346437", "辽宁省葫芦岛市",
"861362790", "江西省新余市",
"861500990", "新疆克拉玛依市",
"861537378", "河北省邯郸市",
"861348824", "陕西省延安市",
"86183008", "贵州省贵阳市",
"861366499", "广东省阳江市",
"861310493", "广东省湛江市",
"86136597", "广东省湛江市",
"861551447", "河南省驻马店市",
"861319191", "河北省张家口市",
"861857148", "湖北省武汉市",
"861862857", "陕西省咸阳市",
"861874470", "贵州省安顺市",
"861453890", "云南省大理白族自治州",
"861305507", "湖南省岳阳市",
"861888201", "四川省自贡市",
"861819882", "广东省东莞市",
"861564692", "新疆伊犁哈萨克自治州",
"86189571", "浙江省杭州市",
"861828907", "西藏山南地区",
"861590982", "辽宁省沈阳市",
"861361075", "吉林省吉林市",
"861365550", "安徽省滁州市",
"861773700", "河南省南阳市",
"861331792", "江西省九江市",
"861327564", "安徽省六安市",
"861861740", "河北省邢台市",
"861348368", "河北省石家庄市",
"861337233", "浙江省嘉兴市",
"861324423", "吉林省吉林市",
"861305070", "辽宁省阜新市",
"861848417", "贵州省安顺市",
"861700405", "广东省东莞市",
"86157644", "吉林省长春市",
"861316744", "湖南省株洲市",
"861315052", "云南省玉溪市",
"861301555", "河南省洛阳市",
"861302169", "山东省青岛市",
"861576960", "宁夏银川市",
"861340389", "河南省周口市",
"861857217", "湖北省武汉市",
"861385133", "江苏省盐城市",
"861850550", "安徽省滁州市",
"861394859", "内蒙古乌兰察布市",
"86189850", "贵州省贵阳市",
"861576726", "广东省江门市",
"861538568", "安徽省蚌埠市",
"861351327", "河北省沧州市",
"861308717", "内蒙古通辽市",
"861327529", "江苏省南通市",
"861301616", "湖南省长沙市",
"861304276", "湖北省十堰市",
"861323728", "湖北省荆门市",
"861458332", "江西省上饶市",
"861399546", "宁夏石嘴山市",
"861470735", "湖南省郴州市",
"861779056", "四川省成都市",
"861870633", "山东省日照市",
"861897818", "广西南宁市",
"861569962", "黑龙江省齐齐哈尔市",
"86131292", "广东省中山市",
"861823041", "河北省石家庄市",
"861809148", "陕西省渭南市",
"861530589", "浙江省金华市",
"861351602", "辽宁省鞍山市",
"861524343", "河北省唐山市",
"861346809", "山东省临沂市",
"861389701", "青海省海北藏族自治州",
"86137632", "广东省东莞市",
"861318645", "江苏省盐城市",
"86155862", "湖北省孝感市",
"86135765", "江西省宜春市",
"861473621", "广西梧州市",
"861378937", "湖南省衡阳市",
"861303974", "黑龙江省齐齐哈尔市",
"861777523", "安徽省滁州市",
"861539498", "云南省文山壮族苗族自治州",
"861820527", "江苏省扬州市",
"861537838", "四川省南充市",
"861311990", "新疆克拉玛依市",
"861308093", "陕西省西安市",
"86185123", "重庆市",
"861501493", "广东省珠海市",
"861570548", "山东省泰安市",
"86139158", "江苏省常州市",
"861897170", "湖北省黄冈市",
"86139781", "广西南宁市",
"861365434", "吉林省四平市",
"86131317", "河北省沧州市",
"861579760", "江西省新余市",
"861800894", "西藏林芝地区",
"861354619", "山西省运城市",
"861533997", "山东省临沂市",
"86182372", "河南省安阳市",
"861565114", "江苏省泰州市",
"861876237", "江苏省泰州市",
"861354189", "四川省甘孜藏族自治州",
"861322485", "内蒙古包头市",
"861398508", "贵州省黔南布依族苗族自治州",
"861391443", "江苏省泰州市",
"861301066", "广东省广州市",
"861527040", "江西省宜春市",
"861360665", "浙江省台州市",
"861302089", "河北省承德市",
"86151982", "四川省成都市",
"861359845", "河南省洛阳市",
"861850434", "吉林省四平市",
"861318723", "湖南省衡阳市",
"861321987", "四川省德阳市",
"861853399", "河北省唐山市",
"86189092", "陕西省西安市",
"861770609", "福建省南平市",
"861815067", "福建省漳州市",
"861871942", "广东省湛江市",
"861380090", "新疆塔城地区",
"861336009", "广东省深圳市",
"861873641", "河南省漯河市",
"86184836", "四川省成都市",
"861831653", "广东省中山市",
"861369509", "福建省南平市",
"861881346", "广东省茂名市",
"86153573", "安徽省安庆市",
"861709947", "浙江省嘉兴市",
"861318155", "山东省菏泽市",
"861774429", "四川省遂宁市",
"861581299", "广东省韶关市",
"861780271", "湖北省武汉市",
"861339777", "广西南宁市",
"861329156", "浙江省温州市",
"861452770", "广西南宁市",
"861878638", "贵州省黔南布依族苗族自治州",
"861506141", "江苏省淮安市",
"861454303", "黑龙江省牡丹江市",
"861870860", "贵州省铜仁地区",
"86187800", "四川省成都市",
"861829732", "安徽省蚌埠市",
"861340557", "江苏省扬州市",
"861307936", "甘肃省定西市",
"861870344", "山西省晋中市",
"861878422", "四川省广安市",
"861399744", "青海省海南藏族自治州",
"861530980", "辽宁省大连市",
"86157731", "湖南省长沙市",
"86184451", "黑龙江省哈尔滨市",
"861501740", "广东省佛山市",
"861397014", "江西省赣州市",
"861778620", "湖北省黄冈市",
"861324484", "广东省广州市",
"861518390", "四川省宜宾市",
"861593005", "河北省邢台市",
"861562800", "贵州省贵阳市",
"861366700", "江西省南昌市",
"86153369", "浙江省湖州市",
"861850959", "宁夏固原市",
"861857962", "江西省吉安市",
"861530563", "安徽省宣城市",
"861519069", "江苏省徐州市",
"861502857", "河北省秦皇岛市",
"861810446", "吉林省白城市",
"861528950", "广西百色市",
"861362409", "辽宁省大连市",
"861550070", "青海省海北藏族自治州",
"86132111", "广东省佛山市",
"861398923", "四川省凉山彝族自治州",
"861597953", "江西省宜春市",
"861894338", "吉林省松原市",
"861453737", "湖南省长沙市",
"86176332", "河北省石家庄市",
"86155370", "河南省商丘市",
"861821870", "广东省广州市",
"861517276", "湖北省随州市",
"86181072", "湖北省武汉市",
"86180345", "河北省石家庄市",
"861771967", "陕西省西安市",
"861303312", "安徽省黄山市",
"861846457", "山东省威海市",
"861596083", "福建省厦门市",
"861334973", "湖北省荆州市",
"861534452", "黑龙江省齐齐哈尔市",
"861828079", "四川省绵阳市",
"861316821", "广东省汕尾市",
"861869596", "河南省南阳市",
"861333556", "安徽省安庆市",
"861343865", "四川省内江市",
"861348775", "湖南省株洲市",
"861890627", "江苏省南通市",
"861327766", "湖北省荆门市",
"861530357", "山西省临汾市",
"861453086", "安徽省芜湖市",
"861316546", "山东省东营市",
"861812503", "广东省茂名市",
"861889140", "陕西省咸阳市",
"861894227", "江西省赣州市",
"861329585", "浙江省绍兴市",
"861328232", "浙江省嘉兴市",
"861365959", "西藏林芝地区",
"861340363", "山西省大同市",
"861782873", "四川省成都市",
"86132017", "陕西省西安市",
"861302183", "河北省廊坊市",
"86152736", "湖南省常德市",
"86152143", "上海市",
"861890302", "广东省深圳市",
"86132803", "山东省东营市",
"861359936", "福建省三明市",
"861510782", "广西柳州市",
"861329646", "山东省潍坊市",
"861810041", "辽宁省沈阳市",
"861392446", "广东省肇庆市",
"861302063", "山东省枣庄市",
"861470324", "河北省承德市",
"861551660", "河南省新乡市",
"861594736", "内蒙古鄂尔多斯市",
"861309957", "宁夏银川市",
"86151619", "江苏省盐城市",
"86182860", "贵州省贵阳市",
"861805114", "江苏省泰州市",
"86151204", "甘肃省平凉市",
"861363330", "河北省唐山市",
"861560894", "西藏林芝地区",
"861894379", "吉林省白城市",
"861534318", "河北省衡水市",
"861336977", "青海省海西蒙古族藏族自治州",
"861770874", "云南省曲靖市",
"861379441", "广东省广州市",
"86139433", "吉林省延边朝鲜族自治州",
"861861493", "河南省焦作市",
"861539671", "江苏省盐城市",
"861310728", "湖南省娄底市",
"861303458", "山东省威海市",
"861457000", "山东省菏泽市",
"861330591", "福建省福州市",
"861333065", "四川省宜宾市",
"861335931", "甘肃省兰州市",
"86178396", "河南省驻马店市",
"861312302", "福建省泉州市",
"861453481", "内蒙古包头市",
"861362377", "河南省南阳市",
"861571337", "河北省沧州市",
"861376902", "云南省丽江市",
"861577467", "黑龙江省鸡西市",
"86188507", "福建省福州市",
"861390503", "福建省宁德市",
"861454848", "广东省深圳市",
"861840562", "安徽省铜陵市",
"861519619", "四川省凉山彝族自治州",
"861300098", "黑龙江省哈尔滨市",
"86158670", "浙江省台州市",
"86138280", "广东省江门市",
"861571408", "辽宁省阜新市",
"861591384", "广东省东莞市",
"861893485", "广西玉林市",
"861311599", "福建省泉州市",
"861821247", "贵州省铜仁地区",
"86159682", "浙江省湖州市",
"86137863", "湖南省株洲市",
"86139272", "广东省佛山市",
"861354163", "四川省内江市",
"86170915", "浙江省绍兴市",
"861357957", "新疆克孜勒苏柯尔克孜自治州",
"861322297", "江苏省苏州市",
"861472893", "西藏山南地区",
"861363688", "陕西省榆林市",
"861880915", "陕西省安康市",
"861534819", "四川省成都市",
"861569937", "新疆伊犁哈萨克自治州",
"861570929", "陕西省渭南市",
"861378962", "内蒙古包头市",
"861761456", "黑龙江省黑河市",
"861515447", "山东省潍坊市",
"861521974", "广东省茂名市",
"861366631", "山东省威海市",
"861858716", "云南省玉溪市",
"861883430", "山西省长治市",
"861323493", "黑龙江省齐齐哈尔市",
"861334410", "北京市",
"86158876", "云南省保山市",
"86182794", "江西省抚州市",
"861520914", "陕西省商洛市",
"86187618", "江苏省南京市",
"86158387", "河南省南阳市",
"861374574", "黑龙江省大兴安岭地区",
"861332099", "四川省成都市",
"861336149", "山东省青岛市",
"86187661", "山东省济南市",
"861454820", "广东省东莞市",
"861870792", "江西省九江市",
"861705324", "广东省深圳市",
"861358973", "山东省滨州市",
"861375985", "陕西省咸阳市",
"861855506", "安徽省安庆市",
"861319568", "安徽省亳州市",
"86184569", "安徽省合肥市",
"861348402", "浙江省杭州市",
"861570964", "宁夏固原市",
"861778158", "四川省乐山市",
"861362443", "吉林省延边朝鲜族自治州",
"8617617", "北京市",
"86134802", "广东省广州市",
"861898463", "贵州省黔南布依族苗族自治州",
"861830884", "云南省临沧市",
"861370143", "江苏省泰州市",
"861309422", "湖北省荆州市",
"861877410", "湖南省岳阳市",
"861310740", "湖南省常德市",
"861818135", "四川省成都市",
"861882477", "广东省汕头市",
"861458553", "山东省聊城市",
"86130900", "新疆昌吉回族自治州",
"861810075", "湖南省长沙市",
"861824989", "黑龙江省伊春市",
"861379475", "广东省阳江市",
"861338083", "广东省佛山市",
"861359216", "河南省平顶山市",
"861315602", "山东省枣庄市",
"861324798", "江西省景德镇市",
"861350454", "黑龙江省佳木斯市",
"861777612", "广西玉林市",
"861470868", "贵州省安顺市",
"861315238", "陕西省渭南市",
"861509488", "山东省淄博市",
"861454349", "山东省济宁市",
"861328912", "陕西省榆林市",
"861595626", "安徽省宣城市",
"861705369", "四川省成都市",
"86138912", "陕西省榆林市",
"861365677", "浙江省温州市",
"861879199", "陕西省商洛市",
"861897547", "湖南省邵阳市",
"86135277", "广东省广州市",
"861862588", "河南省焦作市",
"86155687", "吉林省长春市",
"861539586", "浙江省绍兴市",
"861566086", "河南省新乡市",
"861598977", "广东省珠海市",
"861348741", "湖南省湘西土家族苗族自治州",
"861815032", "福建省龙岩市",
"861570817", "四川省南充市",
"861355990", "福建省宁德市",
"861313649", "浙江省台州市",
"861318498", "河北省沧州市",
"86182479", "内蒙古锡林郭勒盟",
"861881592", "福建省南平市",
"861899593", "湖北省十堰市",
"861571877", "云南省玉溪市",
"861809008", "四川省成都市",
"861700511", "江苏省镇江市",
"861589268", "四川省雅安市",
"861852739", "湖北省黄冈市",
"861390549", "山东省临沂市",
"861315279", "山西省运城市",
"861589891", "山东省济南市",
"86182601", "江苏省苏州市",
"861882309", "广东省佛山市",
"861582580", "甘肃省天水市",
"861347127", "广西桂林市",
"861859351", "福建省宁德市",
"861305313", "安徽省合肥市",
"861370653", "浙江省湖州市",
"861373131", "河北省张家口市",
"861358107", "山东省临沂市",
"861558318", "四川省广元市",
"861860990", "新疆克拉玛依市",
"861894680", "青海省玉树藏族自治州",
"861806890", "江苏省泰州市",
"86187606", "福建省漳州市",
"861335211", "辽宁省鞍山市",
"86185763", "广东省东莞市",
"86152857", "贵州省毕节地区",
"861770334", "河北省秦皇岛市",
"8613896", "重庆市",
"861885153", "江苏省宿迁市",
"861890280", "广东省佛山市",
"861350530", "山东省菏泽市",
"861576122", "贵州省黔南布依族苗族自治州",
"86186311", "河北省石家庄市",
"861894839", "广东省云浮市",
"861580998", "新疆喀什地区",
"861839501", "宁夏银川市",
"86186368", "山西省太原市",
"86145841", "河南省郑州市",
"861552660", "吉林省通化市",
"86134327", "广东省汕尾市",
"861357455", "湖南省郴州市",
"86151104", "山西省运城市",
"86183961", "福建省福州市",
"861830575", "浙江省绍兴市",
"861339068", "江苏省盐城市",
"861329059", "河北省邢台市",
"861366568", "安徽省亳州市",
"861379149", "山东省菏泽市",
"861391446", "江苏省南京市",
"86134564", "浙江省台州市",
"861777526", "安徽省芜湖市",
"861304554", "安徽省宣城市",
"861357561", "浙江省舟山市",
"861507547", "河北省沧州市",
"861380824", "四川省达州市",
"861501496", "广东省惠州市",
"861370006", "辽宁省锦州市",
"861843239", "河北省邢台市",
"861308096", "陕西省榆林市",
"861452250", "浙江省绍兴市",
"861822688", "安徽省阜阳市",
"861390704", "江西省抚州市",
"861810790", "江西省新余市",
"861899488", "江苏省扬州市",
"861339257", "广东省中山市",
"861361377", "河南省南阳市",
"861559547", "宁夏中卫市",
"861323904", "新疆伊犁哈萨克自治州",
"86182358", "山西省吕梁市",
"861860468", "黑龙江省鹤岗市",
"861309561", "浙江省嘉兴市",
"861847165", "湖北省襄樊市",
"861319631", "陕西省咸阳市",
"861831656", "广东省中山市",
"861832049", "广东省湛江市",
"861881343", "广东省茂名市",
"861533620", "陕西省汉中市",
"861853044", "河南省濮阳市",
"861336475", "新疆昌吉回族自治州",
"861372282", "河北省衡水市",
"861370742", "湖南省常德市",
"861817412", "广西南宁市",
"86131735", "浙江省温州市",
"861576645", "广东省深圳市",
"86177869", "海南省海口市",
"86170060", "福建省泉州市",
"861311302", "广东省深圳市",
"861519481", "河北省衡水市",
"861820787", "广西钦州市",
"86156867", "陕西省榆林市",
"861768832", "广东省惠州市",
"861453619", "江苏省扬州市",
"861800020", "江西省南昌市",
"861374885", "河南省郑州市",
"861309455", "四川省攀枝花市",
"861572408", "广东省河源市",
"861580460", "黑龙江省哈尔滨市",
"861318726", "湖南省郴州市",
"861360317", "河北省沧州市",
"86184139", "浙江省杭州市",
"861364412", "辽宁省鞍山市",
"86186435", "吉林省通化市",
"861882941", "陕西省延安市",
"861312599", "黑龙江省大庆市",
"861324426", "吉林省长春市",
"861504680", "黑龙江省哈尔滨市",
"861314319", "广东省佛山市",
"861333872", "江苏省苏州市",
"861364358", "山西省吕梁市",
"861585661", "安徽省池州市",
"861530729", "湖北省孝感市",
"861379659", "黑龙江省大庆市",
"86139597", "福建省泉州市",
"861308491", "广西南宁市",
"861335785", "江苏省宿迁市",
"861388670", "湖北省宜昌市",
"861760559", "安徽省黄山市",
"861819001", "四川省绵阳市",
"861501857", "广东省湛江市",
"861830992", "新疆伊犁哈萨克自治州",
"861304430", "吉林省长春市",
"861598441", "四川省绵阳市",
"861361409", "辽宁省大连市",
"86134515", "江苏省苏州市",
"86137216", "河南省洛阳市",
"861502740", "河北省石家庄市",
"861361229", "广东省江门市",
"861707996", "浙江省丽水市",
"86188888", "北京市",
"861323588", "浙江省丽水市",
"861504839", "内蒙古鄂尔多斯市",
"861337236", "浙江省台州市",
"861354890", "湖南省岳阳市",
"861779053", "四川省甘孜藏族自治州",
"861870636", "山东省潍坊市",
"861340961", "湖北省荆门市",
"861325577", "浙江省温州市",
"861890599", "福建省南平市",
"861524346", "河北省秦皇岛市",
"86132211", "浙江省温州市",
"861539122", "内蒙古乌兰察布市",
"861530764", "广东省中山市",
"86183906", "湖南省常德市",
"861325000", "河北省邢台市",
"86186656", "广东省广州市",
"86159963", "江苏省南京市",
"86185546", "山东省东营市",
"861385136", "江苏省宿迁市",
"86152243", "山东省聊城市",
"861334371", "河南省郑州市",
"861576723", "广东省梅州市",
"861855940", "福建省宁德市",
"861843278", "河北省衡水市",
"861306329", "安徽省池州市",
"861820431", "吉林省长春市",
"861813699", "江苏省常州市",
"86132474", "河北省邢台市",
"861818448", "贵州省遵义市",
"861882194", "湖南省衡阳市",
"861339618", "湖北省孝感市",
"861381542", "江苏省南京市",
"861361264", "广东省佛山市",
"861301613", "湖南省益阳市",
"861304273", "湖北省鄂州市",
"861399543", "宁夏吴忠市",
"861550316", "河北省廊坊市",
"861770646", "浙江省宁波市",
"861818200", "湖南省岳阳市",
"861335873", "辽宁省营口市",
"861344031", "江苏省淮安市",
"861369821", "四川省攀枝花市",
"861516148", "江苏省南京市",
"861313056", "辽宁省营口市",
"861767129", "湖北省荆门市",
"861500627", "江苏省南通市",
"861768372", "湖北省荆州市",
"861818420", "贵州省遵义市",
"86159345", "山西省临汾市",
"861587139", "湖北省武汉市",
"861364859", "贵州省黔西南布依族苗族自治州",
"861566024", "湖南省邵阳市",
"861835134", "江苏省徐州市",
"86135071", "湖北省武汉市",
"86186850", "贵州省贵阳市",
"861550795", "江西省宜春市",
"861329874", "黑龙江省牡丹江市",
"861508244", "四川省内江市",
"861533158", "云南省曲靖市",
"861336046", "广东省东莞市",
"861572877", "广东省梅州市",
"861774246", "陕西省汉中市",
"861369546", "山东省东营市",
"861551376", "山西省晋中市",
"861523169", "河北省承德市",
"861530605", "福建省宁德市",
"861781785", "广东省江门市",
"86187347", "山西省临汾市",
"861573689", "河南省开封市",
"861535239", "甘肃省陇南市",
"861390015", "江苏省南京市",
"86145489", "广东省深圳市",
"861336702", "江西省九江市",
"861775040", "福建省福州市",
"861823264", "河北省承德市",
"861808149", "四川省自贡市",
"861304642", "山东省烟台市",
"86177470", "内蒙古呼伦贝尔市",
"861310496", "广东省肇庆市",
"861879096", "河南省濮阳市",
"861452095", "安徽省合肥市",
"861539569", "安徽省马鞍山市",
"86132538", "河南省信阳市",
"861373439", "山东省临沂市",
"861534425", "内蒙古兴安盟",
"861395550", "安徽省池州市",
"861308304", "安徽省池州市",
"861370394", "河南省周口市",
"86186571", "浙江省杭州市",
"861887234", "湖北省武汉市",
"861598475", "四川省达州市",
"861859953", "福建省福州市",
"861319700", "湖北省黄石市",
"861560982", "辽宁省沈阳市",
"861800048", "河北省张家口市",
"861336441", "吉林省吉林市",
"861572240", "江苏省徐州市",
"861399509", "宁夏银川市",
"861522974", "陕西省安康市",
"861576671", "广东省湛江市",
"861566619", "山东省临沂市",
"861365718", "湖北省武汉市",
"86134234", "广东省东莞市",
"861811549", "江苏省苏州市",
"861510613", "江苏省苏州市",
"861770156", "江苏省苏州市",
"861313565", "湖北省武汉市",
"861321297", "黑龙江省鹤岗市",
"861471893", "西藏山南地区",
"861535278", "新疆喀什地区",
"861334831", "福建省莆田市",
"861345073", "广东省梅州市",
"861346521", "山东省威海市",
"861510183", "甘肃省定西市",
"861555844", "浙江省宁波市",
"861337916", "陕西省汉中市",
"861700854", "贵州省黔南布依族苗族自治州",
"861882975", "陕西省安康市",
"861346846", "山东省潍坊市",
"861390665", "浙江省温州市",
"861458754", "广东省汕头市",
"861373478", "内蒙古赤峰市",
"861313451", "黑龙江省哈尔滨市",
"861459372", "贵州省铜仁地区",
"861331099", "陕西省榆林市",
"861533648", "山东省青岛市",
"861538499", "新疆喀什地区",
"861595114", "江苏省泰州市",
"861523089", "河北省承德市",
"86156919", "陕西省西安市",
"861881477", "黑龙江省牡丹江市",
"861380368", "黑龙江省鹤岗市",
"861372300", "河南省南阳市",
"861879491", "甘肃省张掖市",
"861896651", "陕西省宝鸡市",
"861314170", "湖南省郴州市",
"861368508", "福建省宁德市",
"861361443", "吉林省延边朝鲜族自治州",
"861808659", "湖北省黄冈市",
"861840201", "广东省广州市",
"861310857", "云南省大理白族自治州",
"861830541", "山东省济南市",
"861332633", "山东省日照市",
"861339902", "新疆哈密地区",
"861804087", "新疆阿克苏地区",
"861477325", "湖南省永州市",
"861829696", "江西省抚州市",
"861354762", "四川省攀枝花市",
"861533287", "内蒙古鄂尔多斯市",
"861770585", "浙江省绍兴市",
"86135592", "福建省厦门市",
"861773944", "河南省濮阳市",
"861515945", "福建省南平市",
"86147560", "河北省邯郸市",
"861569435", "吉林省通化市",
"861880417", "辽宁省营口市",
"861825442", "山东省临沂市",
"861856125", "山东省威海市",
"86138445", "吉林省通化市",
"86136781", "四川省成都市",
"86180281", "广东省佛山市",
"861583048", "河北省衡水市",
"861386156", "江苏省淮安市",
"86157549", "内蒙古呼和浩特市",
"861452841", "甘肃省甘南藏族自治州",
"861809572", "青海省海东地区",
"861895700", "浙江省衢州市",
"861302170", "山东省济南市",
"861324234", "广东省广州市",
"861782880", "四川省自贡市",
"861334563", "安徽省宣城市",
"861856302", "山东省滨州市",
"861375415", "内蒙古通辽市",
"86177371", "河南省郑州市",
"861813542", "山西省吕梁市",
"861865191", "江苏省盐城市",
"86189404", "辽宁省本溪市",
"861771577", "四川省自贡市",
"861369617", "四川省广安市",
"861477102", "湖北省孝感市",
"861500811", "四川省自贡市",
"861885820", "浙江省湖州市",
"861561597", "山东省济宁市",
"861806316", "山东省临沂市",
"861777250", "河北省保定市",
"861353646", "广东省汕尾市",
"861700899", "海南省海口市",
"861347544", "山东省青岛市",
"861804015", "辽宁省朝阳市",
"861310331", "河北省石家庄市",
"861337204", "江苏省宿迁市",
"86186925", "湖南省怀化市",
"861334980", "湖北省襄樊市",
"861328348", "河北省秦皇岛市",
"86133329", "广东省深圳市",
"861785838", "浙江省湖州市",
"861452526", "山东省滨州市",
"861890642", "山东省青岛市",
"861331054", "湖北省恩施土家族苗族自治州",
"861368865", "山东省烟台市",
"861879525", "宁夏中卫市",
"861538454", "陕西省西安市",
"861821883", "广东省河源市",
"861458799", "湖南省长沙市",
"86170930", "山西省太原市",
"861320634", "山东省莱芜市",
"861333092", "四川省乐山市",
"861869052", "陕西省延安市",
"861550083", "宁夏吴忠市",
"861328482", "内蒙古兴安盟",
"861454643", "云南省西双版纳傣族自治州",
"861569853", "山西省运城市",
"861850882", "云南省大理白族自治州",
"861705663", "湖北省恩施土家族苗族自治州",
"86152690", "山东省菏泽市",
"86134613", "河南省周口市",
"861317676", "山东省济宁市",
"861303137", "新疆伊犁哈萨克自治州",
"861325551", "山东省烟台市",
"86156772", "广西柳州市",
"861808694", "四川省攀枝花市",
"86136875", "海南省海口市",
"86152128", "安徽省六安市",
"86183137", "云南省昆明市",
"861808951", "四川省成都市",
"861816025", "新疆阿克苏地区",
"861814326", "西藏那曲地区",
"861896959", "浙江省丽水市",
"861822090", "陕西省咸阳市",
"861877980", "江西省景德镇市",
"861530973", "青海省黄南藏族自治州",
"861330452", "黑龙江省齐齐哈尔市",
"861537344", "河北省石家庄市",
"861334357", "湖北省襄樊市",
"861537860", "四川省内江市",
"861878447", "四川省内江市",
"861450243", "河北省承德市",
"861452783", "新疆石河子市",
"861367326", "河北省廊坊市",
"861313808", "河北省石家庄市",
"861579738", "湖北省黄冈市",
"861331339", "河北省邢台市",
"861528428", "河北省邢台市",
"861327458", "黑龙江省鸡西市",
"861840972", "青海省海东地区",
"861390087", "云南省昆明市",
"861817894", "江西省宜春市",
"86181380", "广东省江门市",
"86159033", "河北省秦皇岛市",
"861310845", "四川省遂宁市",
"861534591", "福建省三明市",
"861882603", "广东省中山市",
"861386646", "安徽省池州市",
"861781717", "广东省茂名市",
"86182745", "湖南省怀化市",
"861336353", "山西省阳泉市",
"861330318", "河北省衡水市",
"861597409", "湖南省永州市",
"861865944", "福建省龙岩市",
"861588750", "云南省保山市",
"861892331", "广东省中山市",
"861809995", "新疆吐鲁番地区",
"861818719", "云南省临沧市",
"861705013", "湖北省武汉市",
"861390736", "湖南省常德市",
"861452335", "河南省南阳市",
"861479545", "广西北海市",
"861868758", "云南省保山市",
"861331378", "福建省福州市",
"861313343", "山西省阳泉市",
"861552198", "广东省梅州市",
"861364894", "西藏林芝地区",
"861569711", "湖北省鄂州市",
"861830467", "黑龙江省鸡西市",
"861314782", "辽宁省沈阳市",
"861378174", "河南省漯河市",
"861891933", "甘肃省平凉市",
"861889932", "新疆喀什地区",
"861841912", "甘肃省定西市",
"861843611", "河南省商丘市",
"861780777", "广西钦州市",
"861370034", "河北省廊坊市",
"861890152", "江苏省无锡市",
"861339271", "广东省东莞市",
"861853732", "河南省新乡市",
"861365223", "广东省中山市",
"861873906", "河南省洛阳市",
"86150336", "河北省张家口市",
"861893235", "江苏省扬州市",
"861571682", "河北省邯郸市",
"861357373", "山东省威海市",
"861361351", "山西省太原市",
"861857995", "广西玉林市",
"861884801", "内蒙古通辽市",
"861804665", "江西省宜春市",
"86145898", "广东省深圳市",
"861814535", "黑龙江省鹤岗市",
"861323936", "甘肃省张掖市",
"861576938", "甘肃省甘南藏族自治州",
"861319219", "广东省汕头市",
"86182834", "四川省凉山彝族自治州",
"861570172", "甘肃省定西市",
"861367535", "山东省烟台市",
"861478427", "河南省周口市",
"861872690", "安徽省淮北市",
"861454725", "浙江省杭州市",
"861362953", "宁夏中卫市",
"861562472", "内蒙古呼伦贝尔市",
"861785879", "浙江省嘉兴市",
"861843466", "山西省朔州市",
"861826650", "山东省泰安市",
"861899759", "新疆伊犁哈萨克自治州",
"861370359", "山西省运城市",
"861348330", "河北省张家口市",
"861336567", "安徽省亳州市",
"861500753", "广东省梅州市",
"861512407", "辽宁省朝阳市",
"861303920", "吉林省长春市",
"861580005", "广东省佛山市",
"86138584", "浙江省绍兴市",
"861767707", "广西梧州市",
"861340624", "山东省滨州市",
"861563288", "河北省衡水市",
"861599497", "广东省潮州市",
"861597837", "河南省信阳市",
"861476058", "宁夏银川市",
"861470013", "江苏省无锡市",
"861559555", "宁夏中卫市",
"861450429", "辽宁省葫芦岛市",
"861342176", "广东省阳江市",
"861844943", "新疆克孜勒苏柯尔克孜自治州",
"861379694", "黑龙江省鹤岗市",
"861319978", "新疆塔城地区",
"861531470", "浙江省台州市",
"861570574", "浙江省宁波市",
"861338070", "广东省清远市",
"861539305", "甘肃省天水市",
"861345893", "四川省乐山市",
"861530410", "辽宁省铁岭市",
"86155165", "河南省新乡市",
"861760594", "福建省莆田市",
"861315342", "山东省滨州市",
"861535061", "河北省保定市",
"861313477", "内蒙古鄂尔多斯市",
"861338507", "福建省三明市",
"861454609", "青海省海西蒙古族藏族自治州",
"861837964", "江西省抚州市",
"861533935", "甘肃省武威市",
"861330819", "四川省成都市",
"861315488", "内蒙古呼和浩特市",
"861509238", "山东省临沂市",
"861881451", "黑龙江省哈尔滨市",
"86181677", "新疆昌吉回族自治州",
"861567075", "河南省安阳市",
"861890554", "安徽省淮南市",
"861537792", "福建省福州市",
"861521564", "安徽省六安市",
"861531233", "江苏省淮安市",
"86134160", "广东省中山市",
"861351596", "福建省厦门市",
"861520798", "江西省景德镇市",
"861310871", "云南省昆明市",
"861370858", "贵州省六盘水市",
"861376813", "广西桂林市",
"861572713", "湖北省黄冈市",
"861514740", "内蒙古乌海市",
"861881565", "安徽省合肥市",
"861559616", "陕西省西安市",
"861360733", "湖南省株洲市",
"861339245", "广东省广州市",
"861311811", "四川省德阳市",
"861317581", "浙江省舟山市",
"861847017", "江西省抚州市",
"861783950", "河南省漯河市",
"861524053", "江苏省常州市",
"861344269", "黑龙江省佳木斯市",
"86151500", "江苏省徐州市",
"861502933", "陕西省渭南市",
"861813991", "甘肃省定西市",
"861312430", "吉林省吉林市",
"861813654", "江苏省苏州市",
"861308525", "湖北省随州市",
"861572097", "江西省九江市",
"861850449", "吉林省白山市",
"861700398", "河南省三门峡市",
"861311753", "湖南省株洲市",
"861535466", "吉林省通化市",
"861559066", "吉林省长春市",
"861820396", "河南省驻马店市",
"861527987", "江西省宜春市",
"861328849", "广东省广州市",
"86152896", "广西南宁市",
"86188774", "广西梧州市",
"86184811", "四川省成都市",
"861528440", "云南省昆明市",
"861810956", "宁夏中卫市",
"861321040", "山东省滨州市",
"86184868", "贵州省贵阳市",
"861513249", "河北省石家庄市",
"861847667", "广东省湛江市",
"861890273", "广东省汕头市",
"861762500", "江苏省无锡市",
"861594549", "黑龙江省牡丹江市",
"861329094", "河南省郑州市",
"861340019", "河北省邢台市",
"861536259", "广东省汕头市",
"861776824", "江苏省徐州市",
"861311125", "山西省长治市",
"86155114", "河北省石家庄市",
"861889212", "陕西省榆林市",
"861304599", "福建省南平市",
"861891213", "江苏省扬州市",
"861357833", "云南省临沧市",
"861835106", "江苏省宿迁市",
"861572851", "广东省韶关市",
"861316778", "安徽省六安市",
"861335093", "四川省巴中市",
"861322791", "陕西省延安市",
"861598353", "四川省雅安市",
"861360385", "河南省漯河市",
"861582573", "浙江省嘉兴市",
"86159181", "广东省佛山市",
"861890430", "吉林省长春市",
"861470797", "江西省赣州市",
"861870765", "广东省佛山市",
"86150873", "云南省红河哈尼族彝族自治州",
"861323216", "广东省茂名市",
"861554530", "黑龙江省牡丹江市",
"861388712", "云南省昭通市",
"861452875", "宁夏中卫市",
"861309833", "湖北省武汉市",
"86159758", "广东省清远市",
"861365449", "吉林省吉林市",
"861313309", "山西省运城市",
"861518816", "云南省玉溪市",
"861356549", "新疆和田地区",
"861453911", "广东省广州市",
"86180394", "河南省洛阳市",
"86147359", "山西省运城市",
"861300905", "吉林省松原市",
"861308336", "安徽省亳州市",
"861776869", "江苏省南通市",
"861597443", "湖南省张家界市",
"861803460", "甘肃省庆阳市",
"861312554", "辽宁省本溪市",
"861534942", "甘肃省定西市",
"86145407", "上海市",
"861506677", "山东省烟台市",
"861843489", "山西省运城市",
"861594704", "内蒙古乌兰察布市",
"861839295", "陕西省西安市",
"861585293", "江苏省南京市",
"86137352", "浙江省绍兴市",
"861309971", "青海省果洛藏族自治州",
"861500554", "安徽省淮南市",
"86155535", "山东省烟台市",
"861311642", "贵州省黔南布依族苗族自治州",
"861313941", "甘肃省陇南市",
"86182202", "陕西省榆林市",
"861368414", "四川省资阳市",
"86153550", "浙江省杭州市",
"861842912", "陕西省榆林市",
"861336951", "宁夏银川市",
"861332378", "河南省开封市",
"8618721", "上海市",
"861551198", "河北省邢台市",
"861355756", "广西桂林市",
"861788124", "新疆和田地区",
"86147478", "内蒙古巴彦淖尔市",
"861370727", "湖北省襄樊市",
"861308552", "安徽省蚌埠市",
"861479019", "安徽省六安市",
"861459423", "云南省楚雄彝族自治州",
"861845843", "浙江省杭州市",
"861305481", "山东省莱芜市",
"861560412", "辽宁省鞍山市",
"861897186", "湖北省荆门市",
"861318570", "浙江省衢州市",
"861815392", "甘肃省定西市",
"861830965", "宁夏中卫市",
"861517468", "黑龙江省牡丹江市",
"86138494", "河南省周口市",
"861362351", "山西省太原市",
"861572682", "浙江省宁波市",
"861570885", "云南省怒江傈僳族自治州",
"861809497", "新疆喀什地区",
"861338316", "河北省廊坊市",
"861533809", "广东省广州市",
"861505631", "安徽省宣城市",
"86188589", "浙江省金华市",
"861301818", "四川省自贡市",
"8613554", "湖北省武汉市",
"861575200", "云南省昆明市",
"86134530", "山西省忻州市",
"861860756", "广东省珠海市",
"86136827", "广东省揭阳市",
"861339813", "四川省自贡市",
"861803998", "河南省三门峡市",
"861573383", "河北省张家口市",
"861338795", "江西省宜春市",
"861477749", "广西南宁市",
"861361953", "宁夏吴忠市",
"86153871", "湖北省武汉市",
"861357971", "新疆伊犁哈萨克自治州",
"861879644", "江苏省连云港市",
"861511227", "广东省深圳市",
"861780257", "江苏省宿迁市",
"86147215", "四川省成都市",
"861346997", "湖北省武汉市",
"861339751", "湖南省长沙市",
"861304280", "湖北省襄樊市",
"861880350", "山西省忻州市",
"861787510", "广东省韶关市",
"861511379", "广东省云浮市",
"86177568", "安徽省阜阳市",
"861818637", "湖北省黄石市",
"86131710", "内蒙古呼和浩特市",
"861452584", "福建省莆田市",
"861381527", "江苏省苏州市",
"86180181", "江苏省苏州市",
"861301170", "山东省济南市",
"861325967", "宁夏中卫市",
"861340571", "江苏省南通市",
"861564940", "河南省开封市",
"86189873", "云南省红河哈尼族彝族自治州",
"86187262", "安徽省宿州市",
"86177511", "江苏省苏州市",
"861500430", "吉林省长春市",
"861389531", "宁夏银川市",
"861811087", "安徽省芜湖市",
"861884948", "河北省衡水市",
"861588270", "四川省巴中市",
"861479669", "江西省赣州市",
"861319805", "四川省乐山市",
"861334729", "湖南省邵阳市",
"861332054", "云南省昆明市",
"861822883", "四川省广元市",
"861780068", "内蒙古呼和浩特市",
"861857856", "广东省肇庆市",
"86159394", "河南省周口市",
"861539147", "云南省玉溪市",
"861393869", "河南省安阳市",
"861520426", "辽宁省盘锦市",
"861561629", "湖南省湘潭市",
"86186697", "山东省青岛市",
"861510319", "河北省邢台市",
"86186410", "辽宁省铁岭市",
"861865499", "山东省临沂市",
"861537636", "山东省潍坊市",
"861560358", "山西省吕梁市",
"861532913", "贵州省安顺市",
"861846471", "山东省济宁市",
"86139556", "安徽省安庆市",
"861859443", "福建省宁德市",
"861367384", "河南省商丘市",
"861835043", "福建省莆田市",
"861589045", "河南省濮阳市",
"861822741", "四川省资阳市",
"861530371", "河南省郑州市",
"861874486", "贵州省铜仁地区",
"861388683", "湖北省十堰市",
"86138779", "广西北海市",
"861320346", "山西省晋城市",
"86185958", "河南省郑州市",
"86139923", "陕西省渭南市",
"861315593", "江西省上饶市",
"861334764", "广西梧州市",
"861588433", "四川省眉山市",
"861879154", "陕西省榆林市",
"861501213", "云南省西双版纳傣族自治州",
"861561664", "湖南省衡阳市",
"861768203", "安徽省六安市",
"861305086", "辽宁省盘锦市",
"861814384", "西藏山南地区",
"861360450", "黑龙江省哈尔滨市",
"861322040", "甘肃省兰州市",
"861477703", "广西南宁市",
"861598694", "广东省肇庆市",
"861836525", "安徽省滁州市",
"861589071", "河南省驻马店市",
"861372150", "贵州省毕节地区",
"861822775", "四川省自贡市",
"861530345", "山西省长治市",
"861508510", "贵州省遵义市",
"861873540", "山西省晋中市",
"861378497", "河北省保定市",
"861300407", "安徽省蚌埠市",
"86155471", "内蒙古呼和浩特市",
"861560859", "贵州省黔西南布依族苗族自治州",
"861510818", "四川省泸州市",
"861846445", "山东省莱芜市",
"861304302", "河南省洛阳市",
"861571851", "贵州省贵阳市",
"861533843", "广东省佛山市",
"861459249", "四川省攀枝花市",
"861893417", "广东省汕头市",
"861321791", "江西省南昌市",
"861850141", "江苏省徐州市",
"861308644", "四川省泸州市",
"86187532", "山东省青岛市",
"861539979", "湖南省常德市",
"86155214", "广东省广州市",
"86155609", "内蒙古呼和浩特市",
"861705505", "福建省福州市",
"861304627", "广东省茂名市",
"861335639", "山东省青岛市",
"861536738", "湖南省娄底市",
"86150404", "辽宁省大连市",
"861373289", "吉林省通化市",
"861332838", "福建省南平市",
"861340545", "山东省烟台市",
"861708396", "河南省驻马店市",
"861770306", "广东省珠海市",
"861778935", "甘肃省武威市",
"861853696", "山西省忻州市",
"86184350", "山西省忻州市",
"861890811", "四川省绵阳市",
"86183324", "河北省石家庄市",
"861327635", "山东省聊城市",
"861390692", "福建省福州市",
"86139671", "浙江省杭州市",
"861533781", "广东省茂名市",
"861330425", "辽宁省丹东市",
"861868919", "西藏拉萨市",
"861855450", "山东省威海市",
"861314063", "河南省许昌市",
"861866550", "广东省汕头市",
"861580513", "江苏省连云港市",
"861500642", "山东省青岛市",
"861311554", "黑龙江省佳木斯市",
"861514496", "内蒙古通辽市",
"86183567", "安徽省阜阳市",
"861452182", "吉林省吉林市",
"861502845", "河北省邯郸市",
"861313592", "湖北省黄石市",
"861559089", "黑龙江省哈尔滨市",
"861596316", "山东省聊城市",
"86139409", "辽宁省大连市",
"861334605", "浙江省绍兴市",
"861709893", "广东省东莞市",
"861303801", "山西省运城市",
"86181625", "湖北省武汉市",
"861452612", "江苏省无锡市",
"861335880", "辽宁省葫芦岛市",
"861504721", "内蒙古包头市",
"861768249", "浙江省嘉兴市",
"861376271", "湖南省益阳市",
"86145226", "浙江省台州市",
"861360534", "山东省德州市",
"861532470", "河南省洛阳市",
"861587004", "江西省赣州市",
"86158309", "河北省保定市",
"861521697", "广东省潮州市",
"861807264", "浙江省舟山市",
"861707847", "云南省德宏傣族景颇族自治州",
"861332879", "福建省厦门市",
"861577541", "四川省凉山彝族自治州",
"861821255", "贵州省毕节地区",
"861850994", "新疆昌吉回族自治州",
"86147534", "山东省德州市",
"86131895", "广东省茂名市",
"861357945", "新疆石河子市",
"86151792", "江西省九江市",
"861340686", "山东省德州市",
"861590265", "贵州省毕节地区",
"861530831", "四川省绵阳市",
"861391956", "甘肃省陇南市",
"861859229", "陕西省商洛市",
"861589476", "新疆昌吉回族自治州",
"86155265", "吉林省吉林市",
"861308154", "内蒙古包头市",
"861807409", "浙江省嘉兴市",
"861843842", "河南省漯河市",
"86134260", "北京市",
"861533437", "云南省红河哈尼族彝族自治州",
"861379567", "四川省达州市",
"861864844", "内蒙古兴安盟",
"861313975", "新疆喀什地区",
"861301319", "安徽省安庆市",
"861760793", "江西省上饶市",
"861788522", "贵州省安顺市",
"861882451", "广东省中山市",
"861377035", "江苏省淮安市",
"861514091", "辽宁省阜新市",
"861568532", "贵州省遵义市",
"861356665", "浙江省台州市",
"861569285", "四川省眉山市",
"861317844", "广东省韶关市",
"861812692", "广东省汕尾市",
"861810895", "西藏昌都地区",
"861764058", "辽宁省盘锦市",
"861514857", "内蒙古呼伦贝尔市",
"861333687", "浙江省宁波市",
"861311430", "湖北省荆州市",
"861539938", "陕西省商洛市",
"861500152", "新疆和田地区",
"861882565", "广东省揭阳市",
"861760667", "广东省佛山市",
"861507169", "湖北省黄冈市",
"861533308", "山西省临汾市",
"861570773", "广西桂林市",
"86139991", "新疆乌鲁木齐市",
"861365651", "浙江省温州市",
"861373310", "河南省南阳市",
"861478708", "云南省临沧市",
"86183059", "福建省福州市",
"861355089", "四川省泸州市",
"861339489", "内蒙古呼和浩特市",
"861591704", "广东省韶关市",
"861879960", "新疆博尔塔拉蒙古自治州",
"861378406", "河北省秦皇岛市",
"861300496", "福建省南平市",
"861316828", "广东省河源市",
"861818149", "四川省巴中市",
"861865836", "浙江省温州市",
"861582886", "四川省遂宁市",
"861348720", "湖北省孝感市",
"86152392", "河南省鹤壁市",
"861310242", "河北省沧州市",
"861318304", "河南省商丘市",
"861362894", "西藏林芝地区",
"861867642", "广东省中山市",
"861566794", "陕西省商洛市",
"861309700", "江西省新余市",
"861337690", "福建省漳州市",
"861550025", "吉林省白城市",
"861454335", "内蒙古乌兰察布市",
"861821825", "广东省湛江市",
"861880423", "辽宁省鞍山市",
"86177365", "河北省唐山市",
"861780278", "湖北省黄石市",
"861510627", "江苏省南通市",
"861327975", "新疆伊犁哈萨克自治州",
"861806596", "福建省漳州市",
"861840315", "河北省唐山市",
"861808200", "江苏省南通市",
"861878631", "贵州省遵义市",
"861770397", "河南省驻马店市",
"861708307", "河北省石家庄市",
"86158080", "重庆市",
"861506148", "江苏省镇江市",
"861303056", "江西省萍乡市",
"861808420", "贵州省遵义市",
"861335979", "黑龙江省七台河市",
"861897276", "湖北省黄石市",
"861536415", "湖南省长沙市",
"861868257", "四川省内江市",
"861800862", "湖北省武汉市",
"861778675", "湖北省荆门市",
"861893832", "广东省肇庆市",
"861840796", "江西省吉安市",
"86136861", "广东省东莞市",
"861323844", "内蒙古呼和浩特市",
"861571742", "湖南省湘潭市",
"8618430", "安徽省合肥市",
"861390326", "河北省廊坊市",
"861452725", "湖北省武汉市",
"861364953", "宁夏固原市",
"86136818", "上海市",
"861341993", "河南省南阳市",
"861868068", "广东省深圳市",
"861514227", "辽宁省朝阳市",
"861363576", "湖北省恩施土家族苗族自治州",
"861560377", "河南省南阳市",
"86156733", "湖南省株洲市",
"861533812", "广东省江门市",
"861825296", "江苏省镇江市",
"86136806", "广东省阳江市",
"86156146", "山东省济南市",
"86189619", "江苏省盐城市",
"86147920", "陕西省西安市",
"861814736", "内蒙古包头市",
"861335938", "甘肃省天水市",
"861314152", "江苏省连云港市",
"861818659", "湖北省武汉市",
"861560409", "辽宁省大连市",
"86147942", "广东省广州市",
"861453488", "内蒙古呼伦贝尔市",
"861300857", "陕西省延安市",
"861332563", "新疆乌鲁木齐市",
"861306900", "吉林省长春市",
"861890782", "广西来宾市",
"861705861", "广东省广州市",
"861379382", "山东省泰安市",
"861304170", "江苏省常州市",
"86159591", "福建省福州市",
"861708479", "内蒙古包头市",
"861894845", "广东省揭阳市",
"861300091", "吉林省长春市",
"861571401", "辽宁省沈阳市",
"861814087", "新疆博尔塔拉蒙古自治州",
"861872469", "黑龙江省双鸭山市",
"861331729", "湖北省十堰市",
"861454526", "广西百色市",
"861332980", "湖北省宜昌市",
"861580542", "山东省青岛市",
"861560264", "广东省东莞市",
"861500613", "江苏省苏州市",
"861810048", "吉林省长春市",
"861822419", "四川省雅安市",
"861871486", "安徽省淮南市",
"861452643", "江苏省常州市",
"861373947", "四川省成都市",
"861331764", "广西梧州市",
"861327592", "福建省厦门市",
"861534311", "河北省石家庄市",
"861390535", "山东省烟台市",
"861479746", "山西省运城市",
"861869762", "安徽省六安市",
"861454783", "山东省淄博市",
"861501673", "广东省深圳市",
"861332357", "宁夏银川市",
"861379448", "广东省深圳市",
"861330598", "福建省泉州市",
"861824090", "新疆伊犁哈萨克自治州",
"861862676", "吉林省白城市",
"861310721", "湖南省长沙市",
"861539678", "江苏省扬州市",
"861355169", "四川省甘孜藏族自治州",
"861459350", "贵州省遵义市",
"861303451", "山东省淄博市",
"861778151", "四川省凉山彝族自治州",
"861379200", "山东省日照市",
"861592549", "云南省临沧市",
"861319561", "安徽省淮北市",
"861889815", "河南省南阳市",
"861340490", "云南省文山壮族苗族自治州",
"861895447", "山东省聊城市",
"861350376", "河南省信阳市",
"861860522", "江苏省扬州市",
"861351795", "江西省宜春市",
"861301302", "安徽省滁州市",
"861893372", "广东省韶关市",
"86155171", "河南省郑州市",
"86132310", "河北省邯郸市",
"86150832", "河南省濮阳市",
"861780827", "四川省巴中市",
"86130735", "山西省太原市",
"861324791", "江西省南昌市",
"861529814", "四川省达州市",
"861810020", "广东省广州市",
"861319455", "黑龙江省绥化市",
"861888667", "四川省广元市",
"861509481", "山东省泰安市",
"861315231", "陕西省咸阳市",
"861892673", "广东省茂名市",
"861380963", "广东省东莞市",
"861302599", "广西北海市",
"86184874", "云南省曲靖市",
"861308726", "湖南省邵阳市",
"861351316", "河北省廊坊市",
"861576717", "广东省中山市",
"861829473", "甘肃省陇南市",
"861760314", "河北省承德市",
"861361982", "河南省平顶山市",
"861571394", "河南省周口市",
"861886480", "山东省泰安市",
"861363681", "陕西省西安市",
"86130844", "四川省成都市",
"861454875", "四川省德阳市",
"861559756", "青海省黄南藏族自治州",
"861838546", "贵州省黔南布依族苗族自治州",
"861311063", "福建省福州市",
"861518463", "黑龙江省鸡西市",
"861308960", "黑龙江省伊春市",
"861335657", "广东省江门市",
"861373179", "河北省秦皇岛市",
"861501242", "广东省广州市",
"861366638", "山东省聊城市",
"861809406", "福建省泉州市",
"861882789", "江西省萍乡市",
"861511496", "陕西省汉中市",
"861517547", "河北省邢台市",
"86183521", "江苏省连云港市",
"861318096", "吉林省辽源市",
"861532942", "贵州省遵义市",
"86145207", "上海市",
"861815626", "安徽省阜阳市",
"861884649", "黑龙江省大庆市",
"861388142", "四川省自贡市",
"861509166", "陕西省榆林市",
"861572653", "山东省聊城市",
"861314554", "安徽省淮南市",
"86187313", "河北省张家口市",
"861452272", "山西省晋中市",
"861308583", "广东省珠海市",
"861807074", "广西南宁市",
"861800790", "江西省新余市",
"86159523", "江苏省淮安市",
"861376611", "吉林省白城市",
"861780919", "陕西省铜川市",
"861373138", "河北省张家口市",
"861868902", "西藏日喀则地区",
"861859358", "福建省龙岩市",
"861346906", "湖南省长沙市",
"861870566", "安徽省池州市",
"861322914", "广东省江门市",
"861387247", "湖北省宜昌市",
"861595032", "江苏省盐城市",
"861335218", "辽宁省锦州市",
"861509086", "湖北省宜昌市",
"861820655", "山东省滨州市",
"861524697", "黑龙江省黑河市",
"861867273", "湖北省随州市",
"861311183", "四川省雅安市",
"861452609", "江苏省无锡市",
"861838115", "四川省眉山市",
"861580991", "新疆乌鲁木齐市",
"861839508", "宁夏银川市",
"861360323", "河北省秦皇岛市",
"861394956", "河南省驻马店市",
"861304319", "河北省邢台市",
"861552454", "辽宁省沈阳市",
"86177943", "甘肃省白银市",
"861348748", "湖南省永州市",
"861861360", "山东省德州市",
"861339842", "四川省南充市",
"861333850", "福建省莆田市",
"861867430", "湖南省湘西土家族苗族自治州",
"861318491", "河北省唐山市",
"861453794", "新疆阿克苏地区",
"861335147", "黑龙江省大兴安岭地区",
"861523468", "山西省长治市",
"861314430", "吉林省长春市",
"861576093", "陕西省宝鸡市",
"861388652", "湖北省咸宁市",
"861587622", "广东省河源市",
"86874", "云南省曲靖市",
"861700518", "江苏省连云港市",
"861853480", "山西省晋中市",
"861557086", "湖南省长沙市",
"861316364", "黑龙江省绥化市",
"86156787", "广西来宾市",
"861589898", "山东省日照市",
"861556956", "新疆喀什地区",
"861562940", "湖北省恩施土家族苗族自治州",
"86187462", "黑龙江省齐齐哈尔市",
"861331563", "河北省廊坊市",
"861309568", "浙江省绍兴市",
"861599406", "河南省许昌市",
"861891242", "江苏省南通市",
"861454584", "甘肃省庆阳市",
"861319638", "陕西省汉中市",
"861535245", "甘肃省天水市",
"861305327", "安徽省安庆市",
"861860461", "黑龙江省哈尔滨市",
"86137737", "江苏省南通市",
"86131900", "辽宁省沈阳市",
"86156246", "内蒙古乌兰察布市",
"861800075", "江西省宜春市",
"86147415", "辽宁省沈阳市",
"861319422", "辽宁省沈阳市",
"861300740", "湖南省常德市",
"86177574", "浙江省宁波市",
"861519488", "河北省保定市",
"861590790", "江西省新余市",
"861336420", "辽宁省铁岭市",
"861860555", "安徽省马鞍山市",
"861305602", "江苏省淮安市",
"86187040", "辽宁省沈阳市",
"861824883", "江苏省常州市",
"861537047", "江苏省南通市",
"861338596", "福建省漳州市",
"861336200", "浙江省衢州市",
"861572401", "广东省东莞市",
"861346540", "山东省济南市",
"86187022", "天津市",
"861478560", "贵州省贵阳市",
"861871469", "黑龙江省双鸭山市",
"861882948", "陕西省西安市",
"861334054", "福建省三明市",
"861536829", "云南省大理白族自治州",
"861332729", "湖南省邵阳市",
"861896937", "浙江省金华市",
"861872486", "云南省玉溪市",
"861824741", "内蒙古乌兰察布市",
"861317216", "广东省东莞市",
"86185883", "广东省深圳市",
"86153865", "四川省乐山市",
"86152117", "湖南省郴州市",
"861350010", "广东省潮州市",
"861775206", "甘肃省平凉市",
"861366561", "安徽省淮北市",
"861327309", "河南省三门峡市",
"861355461", "湖北省荆州市",
"861303159", "河北省沧州市",
"861472999", "陕西省铜川市",
"861351507", "福建省宁德市",
"861860616", "江苏省徐州市",
"86152428", "辽宁省鞍山市",
"861523990", "河南省商丘市",
"86183437", "吉林省辽源市",
"861534913", "陕西省渭南市",
"861570823", "四川省德阳市",
"861357568", "浙江省金华市",
"861331357", "山西省临汾市",
"86158984", "湖南省益阳市",
"861841909", "甘肃省定西市",
"861820479", "内蒙古锡林郭勒盟",
"86137650", "贵州省贵阳市",
"861536864", "云南省西双版纳傣族自治州",
"861366455", "黑龙江省绥化市",
"861334339", "河北省承德市",
"861830520", "江苏省徐州市",
"861822681", "安徽省滁州市",
"861536340", "广东省佛山市",
"861899481", "江苏省盐城市",
"861575694", "四川省攀枝花市",
"861818702", "云南省昆明市",
"861876508", "山东省滨州市",
"86182402", "辽宁省沈阳市",
"861598382", "四川省德阳市",
"861340968", "湖北省黄冈市",
"86185756", "广东省珠海市",
"861514905", "内蒙古赤峰市",
"861816890", "江苏省无锡市",
"86147024", "辽宁省沈阳市",
"861361894", "西藏林芝地区",
"861344854", "山东省济南市",
"861848798", "云南省临沧市",
"861363852", "贵州省遵义市",
"861334378", "河南省开封市",
"861350660", "浙江省舟山市",
"861369840", "江西省九江市",
"861587516", "广东省阳江市",
"861820438", "吉林省松原市",
"861843271", "河北省石家庄市",
"861339611", "湖北省襄樊市",
"861818441", "贵州省毕节地区",
"861311782", "江西省九江市",
"861327477", "内蒙古鄂尔多斯市",
"86153814", "浙江省温州市",
"861805032", "福建省福州市",
"86138294", "广东省汕头市",
"861585668", "安徽省淮南市",
"861470706", "江西省吉安市",
"861364351", "山西省太原市",
"861510599", "福建省厦门市",
"861879784", "江西省抚州市",
"861382460", "广东省肇庆市",
"861303649", "四川省宜宾市",
"861370408", "辽宁省大连市",
"861308498", "广西南宁市",
"861838900", "西藏拉萨市",
"861342993", "湖北省孝感市",
"861819008", "四川省德阳市",
"861339466", "黑龙江省大庆市",
"861776573", "广东省珠海市",
"861598448", "四川省达州市",
"86157008", "湖南省岳阳市",
"861887297", "湖北省荆州市",
"861370337", "河北省唐山市",
"861479490", "内蒙古赤峰市",
"861477830", "广东省茂名市",
"861899737", "青海省海西蒙古族藏族自治州",
"861454908", "湖北省宜昌市",
"861827991", "江西省吉安市",
"861572742", "湖南省邵阳市",
"861376842", "广西柳州市",
"861525094", "江苏省徐州市",
"86181963", "新疆阿克苏地区",
"861323581", "浙江省杭州市",
"861334879", "湖南省邵阳市",
"861592665", "湖北省随州市",
"861342286", "广东省深圳市",
"861821852", "广东省韶关市",
"861340746", "湖南省永州市",
"861313312", "山西省大同市",
"861598420", "四川省资阳市",
"861869083", "新疆克孜勒苏柯尔克孜自治州",
"861360921", "陕西省咸阳市",
"86182780", "广西梧州市",
"861529465", "河南省安阳市",
"861580393", "河南省濮阳市",
"861590862", "湖北省武汉市",
"861576639", "广东省湛江市",
"861589104", "陕西省渭南市",
"861841943", "甘肃省白银市",
"861819962", "新疆阿勒泰地区",
"86155025", "湖南省娄底市",
"861534470", "海南省海口市",
"861502721", "湖北省恩施土家族苗族自治州",
"861561506", "山东省东营市",
"861365853", "贵州省安顺市",
"86145066", "上海市",
"861372780", "广东省茂名市",
"86184652", "宁夏银川市",
"861576880", "广东省云浮市",
"861320974", "青海省海南藏族自治州",
"861370240", "广东省江门市",
"861327343", "河北省石家庄市",
"861802503", "广东省清远市",
"86138381", "河南省郑州市",
"86183483", "河南省周口市",
"86185837", "四川省成都市",
"86183644", "山东省烟台市",
"861509024", "河南省濮阳市",
"861344038", "辽宁省铁岭市",
"861373076", "四川省内江市",
"861516141", "江苏省扬州市",
"861369828", "四川省南充市",
"861534233", "湖北省武汉市",
"861333747", "湖北省荆门市",
"861452752", "湖南省长沙市",
"861862844", "陕西省渭南市",
"861557024", "江西省九江市",
"861317936", "江苏省泰州市",
"861330483", "黑龙江省牡丹江市",
"861527203", "湖北省黄石市",
"861508390", "江西省赣州市",
"861843245", "河北省唐山市",
"861870589", "浙江省金华市",
"86137949", "广东省东莞市",
"86137783", "四川省达州市",
"86139665", "安徽省阜阳市",
"86134020", "上海市",
"861889429", "甘肃省陇南市",
"861864936", "山西省临汾市",
"861512857", "河北省承德市",
"861530633", "山东省日照市",
"861890063", "江苏省无锡市",
"861533151", "云南省保山市",
"861856818", "河南省濮阳市",
"861705706", "上海市",
"861328453", "黑龙江省牡丹江市",
"861850853", "贵州省安顺市",
"861569882", "辽宁省沈阳市",
"861318199", "山东省东营市",
"861340002", "江苏省无锡市",
"861302302", "安徽省蚌埠市",
"861840428", "辽宁省盘锦市",
"861509189", "陕西省西安市",
"861380361", "黑龙江省齐齐哈尔市",
"861398917", "四川省达州市",
"861890613", "江苏省苏州市",
"861368501", "福建省福州市",
"861879498", "甘肃省定西市",
"861896658", "陕西省延安市",
"861565067", "安徽省宿州市",
"861840632", "山东省枣庄市",
"861319380", "河南省南阳市",
"861830548", "山东省泰安市",
"861370877", "云南省玉溪市",
"861840208", "广东省佛山市",
"861344079", "湖北省武汉市",
"861302627", "江西省宜春市",
"861301599", "福建省莆田市",
"861867753", "广西贵港市",
"861310098", "黑龙江省齐齐哈尔市",
"861352316", "河南省商丘市",
"86184403", "新疆乌鲁木齐市",
"86137856", "河北省廊坊市",
"861584774", "内蒙古呼伦贝尔市",
"861873997", "河南省开封市",
"861569403", "四川省遂宁市",
"861394895", "内蒙古通辽市",
"861800041", "河北省石家庄市",
"861336448", "吉林省长春市",
"861323676", "辽宁省朝阳市",
"86180591", "福建省福州市",
"861329397", "山西省运城市",
"861500782", "广西柳州市",
"86159481", "吉林省长春市",
"861815684", "安徽省阜阳市",
"861576678", "广东省梅州市",
"861365711", "湖北省鄂州市",
"861362982", "河南省三门峡市",
"86132851", "江苏省苏州市",
"861572394", "广西梧州市",
"861837150", "湖北省咸宁市",
"861346528", "山东省东营市",
"861535271", "新疆伊犁哈萨克自治州",
"86150204", "山东省菏泽市",
"861334838", "福建省厦门市",
"86150619", "江苏省常州市",
"86187573", "浙江省嘉兴市",
"861325246", "浙江省台州市",
"86139614", "江苏省常州市",
"861839926", "新疆和田地区",
"861562928", "湖北省武汉市",
"861895945", "福建省龙岩市",
"861373471", "内蒙古呼和浩特市",
"861338260", "江苏省盐城市",
"861313458", "黑龙江省伊春市",
"861869163", "陕西省西安市",
"861454182", "山西省晋中市",
"861834587", "黑龙江省伊春市",
"861533641", "山东省济南市",
"861476500", "北京市",
"861586492", "山东省聊城市",
"861571653", "河南省平顶山市",
"861575103", "江苏省徐州市",
"861571727", "湖北省襄樊市",
"861708647", "江苏省盐城市",
"861816507", "陕西省宝鸡市",
"861325558", "山东省青岛市",
"861329037", "山东省聊城市",
"861868813", "广东省中山市",
"86134361", "重庆市",
"86151404", "辽宁省大连市",
"86183927", "陕西省宝鸡市",
"86152938", "甘肃省天水市",
"861335569", "安徽省合肥市",
"861808958", "四川省攀枝花市",
"861327565", "安徽省合肥市",
"861348576", "安徽省滁州市",
"861866572", "广东省广州市",
"861700404", "广东省东莞市",
"86155672", "吉林省四平市",
"861316745", "江苏省南通市",
"86135282", "广东省中山市",
"861303592", "云南省临沧市",
"861329786", "广西玉林市",
"86139233", "广东省中山市",
"861709999", "广东省广州市",
"861510642", "山东省淄博市",
"861363966", "河南省许昌市",
"861301554", "河南省郑州市",
"861816070", "江西省鹰潭市",
"861579731", "湖北省宜昌市",
"861459100", "广西防城港市",
"861528421", "河北省石家庄市",
"861588907", "西藏拉萨市",
"861327451", "黑龙江省哈尔滨市",
"861452848", "甘肃省天水市",
"861560953", "宁夏吴忠市",
"861360472", "内蒙古包头市",
"861583041", "河北省石家庄市",
"861363720", "安徽省黄山市",
"861554836", "内蒙古呼和浩特市",
"861364377", "河南省南阳市",
"861556446", "山东省淄博市",
"861538376", "河北省廊坊市",
"861314302", "河北省石家庄市",
"861310407", "黑龙江省哈尔滨市",
"861302753", "河南省洛阳市",
"861867627", "广东省中山市",
"861500818", "四川省绵阳市",
"861470734", "湖南省衡阳市",
"86139472", "内蒙古包头市",
"861453279", "山西省阳泉市",
"861539873", "云南省红河哈尼族彝族自治州",
"861879007", "河南省信阳市",
"861310338", "河北省衡水市",
"861329523", "江苏省泰州市",
"861328341", "河北省邯郸市",
"861568012", "四川省绵阳市",
"86184439", "吉林省白山市",
"861361412", "辽宁省鞍山市",
"861700269", "广东省广州市",
"861533949", "甘肃省酒泉市",
"86133386", "江苏省苏州市",
"86157759", "四川省宜宾市",
"861318644", "江苏省盐城市",
"86170705", "江苏省镇江市",
"861303975", "黑龙江省双鸭山市",
"86158372", "河南省安阳市",
"861838778", "云南省玉溪市",
"861361358", "山西省吕梁市",
"861535902", "福建省厦门市",
"861817409", "江西省赣州市",
"861884808", "内蒙古兴安盟",
"86155992", "贵州省遵义市",
"861321426", "辽宁省沈阳市",
"861360629", "江苏省南通市",
"861379637", "黑龙江省双鸭山市",
"861452303", "河南省安阳市",
"861454770", "山东省聊城市",
"86176373", "河南省新乡市",
"861365435", "吉林省通化市",
"86159380", "河南省驻马店市",
"861768100", "安徽省宿州市",
"861774551", "黑龙江省绥化市",
"861576931", "甘肃省天水市",
"861800895", "西藏昌都地区",
"861508030", "福建省厦门市",
"861301430", "河北省保定市",
"86136519", "上海市",
"861364409", "辽宁省大连市",
"861565115", "江苏省泰州市",
"861580527", "江苏省扬州市",
"861366373", "河南省新乡市",
"861880832", "四川省内江市",
"861501839", "广东省汕头市",
"861310379", "河南省洛阳市",
"861760537", "山东省济宁市",
"861322484", "内蒙古通辽市",
"861364229", "广东省揭阳市",
"861360664", "浙江省杭州市",
"861359844", "河南省郑州市",
"861332973", "湖北省武汉市",
"861532452", "安徽省安庆市",
"861850435", "吉林省通化市",
"861534598", "福建省厦门市",
"861359360", "湖北省恩施土家族苗族自治州",
"861330311", "河北省石家庄市",
"861892338", "广东省珠海市",
"86170978", "浙江省温州市",
"861552191", "广东省揭阳市",
"86150792", "江西省九江市",
"861331371", "福建省宁德市",
"861893423", "广东省湛江市",
"861569718", "湖北省武汉市",
"861893203", "贵州省黔南布依族苗族自治州",
"861304613", "广东省汕尾市",
"861301273", "山东省威海市",
"861318154", "山东省烟台市",
"86182555", "安徽省马鞍山市",
"861843618", "河南省南阳市",
"861339278", "广东省佛山市",
"861881458", "黑龙江省伊春市",
"861887028", "江西省新余市",
"861315481", "内蒙古呼和浩特市",
"86187675", "浙江省绍兴市",
"861308570", "广东省清远市",
"861770724", "湖北省荆门市",
"861532927", "贵州省毕节地区",
"861539333", "甘肃省平凉市",
"861819497", "新疆和田地区",
"861520791", "江西省南昌市",
"86135477", "四川省遂宁市",
"861310878", "云南省楚雄彝族自治州",
"861875244", "江苏省宿迁市",
"861801167", "四川省乐山市",
"861370851", "贵州省遵义市",
"861538836", "四川省遂宁市",
"861355547", "黑龙江省鸡西市",
"861366447", "吉林省白城市",
"861361859", "贵州省贵阳市",
"861515631", "安徽省芜湖市",
"861505561", "安徽省蚌埠市",
"861344899", "新疆乌鲁木齐市",
"861311818", "四川省绵阳市",
"861308007", "吉林省松原市",
"861370097", "四川省南充市",
"861556075", "内蒙古通辽市",
"861501227", "云南省昭通市",
"861886473", "河南省安阳市",
"861458126", "安徽省六安市",
"861317588", "浙江省台州市",
"861331345", "山西省长治市",
"861863206", "河北省衡水市",
"861313789", "河南省许昌市",
"861375923", "云南省德宏傣族景颇族自治州",
"861813998", "甘肃省白银市",
"861368050", "广东省江门市",
"861771246", "江苏省无锡市",
"861339919", "陕西省铜川市",
"861315166", "江苏省苏州市",
"861770769", "广东省东莞市",
"861707173", "江西省吉安市",
"861563281", "河北省唐山市",
"861303941", "新疆昌吉回族自治州",
"86177170", "上海市",
"861589767", "湖北省孝感市",
"861566602", "山东省淄博市",
"86186374", "河南省许昌市",
"861476051", "宁夏银川市",
"861510554", "安徽省淮南市",
"861360705", "江西省宜春市",
"861535257", "新疆阿克苏地区",
"861319971", "新疆哈密地区",
"861399512", "宁夏石嘴山市",
"861477981", "江西省景德镇市",
"86139287", "广东省广州市",
"86159677", "浙江省温州市",
"861381513", "江苏省无锡市",
"861536985", "河北省衡水市",
"86189500", "福建省厦门市",
"861557231", "湖北省武汉市",
"861372253", "河北省唐山市",
"861835695", "安徽省合肥市",
"861373457", "黑龙江省大庆市",
"861535068", "河北省廊坊市",
"861860547", "山东省济宁市",
"861827699", "广西河池市",
"861575149", "江苏省淮安市",
"861894740", "内蒙古乌兰察布市",
"86156893", "山东省枣庄市",
"861589136", "陕西省商洛市",
"861384654", "黑龙江省黑河市",
"86139563", "安徽省蚌埠市",
"861821966", "甘肃省张掖市",
"861332410", "辽宁省铁岭市",
"861773660", "广西南宁市",
"861893249", "湖南省永州市",
"861459417", "云南省迪庆藏族自治州",
"861590956", "宁夏中卫市",
"861336719", "湖北省十堰市",
"861853473", "山西省忻州市",
"861532819", "四川省成都市",
"861769126", "陕西省汉中市",
"861818353", "云南省迪庆藏族自治州",
"861339827", "四川省泸州市",
"861453918", "广东省珠海市",
"861320697", "黑龙江省佳木斯市",
"861367549", "山东省临沂市",
"86187995", "新疆喀什地区",
"861452820", "四川省宜宾市",
"861895679", "安徽省亳州市",
"86159548", "山东省青岛市",
"861305593", "福建省宁德市",
"861766080", "山东省德州市",
"86135910", "辽宁省铁岭市",
"861561534", "山东省德州市",
"861315086", "内蒙古鄂尔多斯市",
"861380254", "广东省广州市",
"861334099", "四川省成都市",
"8614767", "广东省广州市",
"861328375", "河南省平顶山市",
"861335122", "黑龙江省齐齐哈尔市",
"861823074", "贵州省黔东南苗族侗族自治州",
"861853230", "河北省廊坊市",
"861880372", "河南省安阳市",
"861898816", "云南省昆明市",
"861310839", "四川省广元市",
"861818567", "贵州省黔西南布依族苗族自治州",
"86181758", "湖南省衡阳市",
"861885783", "浙江省温州市",
"861366833", "四川省绵阳市",
"861808637", "湖北省宜昌市",
"861539785", "江西省宜春市",
"861314280", "江苏省南京市",
"861317904", "吉林省长春市",
"861301152", "河北省唐山市",
"861870976", "青海省玉树藏族自治州",
"861510430", "吉林省长春市",
"861587288", "湖北省荆门市",
"86130710", "河南省郑州市",
"861300933", "辽宁省锦州市",
"86181181", "江苏省苏州市",
"861303194", "河北省张家口市",
"861364443", "吉林省延边朝鲜族自治州",
"861871916", "广东省湛江市",
"861588252", "四川省遂宁市",
"861801087", "安徽省合肥市",
"861452349", "河南省漯河市",
"861593144", "河北省石家庄市",
"861351762", "广西柳州市",
"861533177", "云南省西双版纳傣族自治州",
"86159997", "广东省东莞市",
"861817443", "湖南省长沙市",
"861572858", "广东省韶关市",
"861500319", "河北省邢台市",
"86138702", "江西省九江市",
"86158805", "福建省漳州市",
"861316771", "安徽省安庆市",
"861537566", "安徽省池州市",
"861779082", "辽宁省沈阳市",
"861348825", "陕西省延安市",
"861310680", "广东省珠海市",
"861322798", "陕西省延安市",
"861877099", "江西省萍乡市",
"861519602", "四川省自贡市",
"861558483", "吉林省通化市",
"861521634", "山东省莱芜市",
"861778949", "甘肃省天水市",
"861888085", "四川省德阳市",
"861575475", "内蒙古通辽市",
"861826243", "江苏省扬州市",
"861305488", "山东省淄博市",
"861340539", "山东省临沂市",
"861335645", "广东省东莞市",
"86158512", "江苏省南通市",
"861511331", "广东省惠州市",
"861362358", "山西省吕梁市",
"861312319", "福建省福州市",
"86188953", "安徽省芜湖市",
"861322426", "辽宁省沈阳市",
"861327649", "山东省济南市",
"861360597", "福建省三明市",
"861326924", "甘肃省临夏回族自治州",
"861505638", "安徽省蚌埠市",
"861301811", "四川省攀枝花市",
"861504740", "内蒙古包头市",
"861881635", "山东省聊城市",
"86137416", "辽宁省锦州市",
"861528084", "福建省龙岩市",
"861321484", "内蒙古鄂尔多斯市",
"861803991", "河南省许昌市",
"861850937", "甘肃省酒泉市",
"861367704", "江西省上饶市",
"86183975", "湖南省益阳市",
"86136379", "重庆市",
"86188526", "江苏省泰州市",
"86150500", "江苏省徐州市",
"861512933", "陕西省渭南市",
"861357978", "新疆塔城地区",
"861580699", "山东省菏泽市",
"861530339", "河北省邢台市",
"861777153", "湖北省咸宁市",
"861855597", "安徽省宣城市",
"861524195", "辽宁省辽阳市",
"861830776", "广西百色市",
"86153722", "浙江省湖州市",
"861824870", "江苏省扬州市",
"861839865", "四川省成都市",
"86153740", "广东省广州市",
"861846439", "山东省滨州市",
"86132468", "广东省广州市",
"861331973", "新疆伊犁哈萨克自治州",
"861338052", "广东省佛山市",
"861313948", "甘肃省酒泉市",
"861895455", "山东省烟台市",
"861302273", "山东省烟台市",
"86183716", "湖北省荆州市",
"861336958", "宁夏银川市",
"861365937", "甘肃省酒泉市",
"86132274", "湖北省恩施土家族苗族自治州",
"861459235", "四川省资阳市",
"86132028", "广东省佛山市",
"861330913", "陕西省渭南市",
"861319447", "福建省福州市",
"861332371", "河南省郑州市",
"86152443", "山东省临沂市",
"861303477", "内蒙古鄂尔多斯市",
"86134647", "辽宁省营口市",
"861335155", "吉林省松原市",
"86151873", "云南省红河哈尼族彝族自治州",
"861362074", "吉林省吉林市",
"861309939", "甘肃省嘉峪关市",
"861846478", "山东省枣庄市",
"861329724", "湖北省黄石市",
"86134578", "广西南宁市",
"861376827", "广西南宁市",
"861774814", "四川省绵阳市",
"861572727", "湖北省襄樊市",
"861319833", "四川省宜宾市",
"861508816", "广东省潮州市",
"861873846", "河南省驻马店市",
"861303309", "安徽省合肥市",
"86183708", "江西省赣州市",
"861528129", "四川省雅安市",
"861327159", "河南省郑州市",
"86183695", "山东省临沂市",
"861450650", "黑龙江省黑河市",
"861822748", "四川省甘孜藏族自治州",
"861591736", "广东省广州市",
"861530378", "河南省洛阳市",
"861318336", "河南省信阳市",
"861890319", "河北省邢台市",
"861310905", "新疆伊犁哈萨克自治州",
"861356384", "山东省泰安市",
"861335723", "湖南省湘西土家族苗族自治州",
"861517066", "江西省吉安市",
"861550260", "辽宁省沈阳市",
"861819174", "陕西省渭南市",
"861470533", "山东省淄博市",
"861813460", "安徽省宿州市",
"861803144", "河北省石家庄市",
"86139133", "江苏省南京市",
"861776963", "浙江省嘉兴市",
"86139746", "湖南省永州市",
"861329769", "湖北省鄂州市",
"861889887", "广东省肇庆市",
"861588405", "四川省甘孜藏族自治州",
"861348852", "内蒙古包头市",
"861570628", "江苏省南通市",
"861339758", "湖南省娄底市",
"861820647", "山东省潍坊市",
"861867599", "广东省湛江市",
"861301753", "河南省新乡市",
"861768235", "浙江省宁波市",
"861571359", "山西省运城市",
"86185797", "江西省赣州市",
"861777643", "广西玉林市",
"861340578", "江苏省无锡市",
"861328943", "陕西省宝鸡市",
"861570432", "吉林省吉林市",
"861848914", "西藏林芝地区",
"861470027", "安徽省宿州市",
"861800956", "宁夏中卫市",
"861847537", "广东省汕头市",
"861396660", "安徽省安庆市",
"861503249", "河北省保定市",
"86137408", "辽宁省大连市",
"86147430", "四川省成都市",
"861362412", "辽宁省鞍山市",
"861357939", "新疆阿克苏地区",
"861335586", "浙江省台州市",
"861389538", "宁夏银川市",
"861884941", "河北省石家庄市",
"861780061", "内蒙古兴安盟",
"861350804", "四川省资阳市",
"861576785", "广东省广州市",
"861559990", "新疆阿克苏地区",
"861351163", "江苏省苏州市",
"861370682", "浙江省湖州市",
"861505679", "安徽省阜阳市",
"861560351", "山西省太原市",
"861551944", "贵州省遵义市",
"861502878", "河北省衡水市",
"861332831", "福建省厦门市",
"861536731", "湖南省长沙市",
"861392265", "广东省云浮市",
"861531819", "山东省济宁市",
"861890818", "四川省成都市",
"861705533", "江西省南昌市",
"861315024", "新疆巴音郭楞蒙古自治州",
"861533788", "广东省广州市",
"8615823", "重庆市",
"861804326", "吉林省吉林市",
"861569959", "吉林省吉林市",
"861346934", "湖南省怀化市",
"861331410", "辽宁省铁岭市",
"86135065", "浙江省温州市",
"861555936", "新疆石河子市",
"861818694", "湖北省孝感市",
"861575702", "浙江省杭州市",
"861524974", "河南省新乡市",
"86135425", "广东省佛山市",
"861330470", "内蒙古呼伦贝尔市",
"861769614", "山西省临汾市",
"861528562", "贵州省贵阳市",
"861570640", "山东省菏泽市",
"861478413", "河南省商丘市",
"86138590", "福建省福州市",
"861333722", "湖南省湘潭市",
"861477735", "广西桂林市",
"861530879", "云南省普洱市",
"861513417", "辽宁省锦州市",
"861394862", "内蒙古兴安盟",
"861303808", "山西省太原市",
"86156709", "河南省焦作市",
"861589078", "河南省安阳市",
"861302152", "山东省滨州市",
"861781723", "广东省深圳市",
"861334633", "山东省日照市",
"86186565", "安徽省合肥市",
"861819572", "青海省海东地区",
"861567292", "湖北省十堰市",
"861347389", "河北省唐山市",
"861510811", "四川省遂宁市",
"861869507", "湖北省宜昌市",
"861576873", "广东省惠州市",
"861315069", "云南省昭通市",
"861535777", "安徽省合肥市",
"861327603", "福建省宁德市",
"861571858", "贵州省六盘水市",
"861850148", "江苏省盐城市",
"861821989", "甘肃省陇南市",
"861550596", "福建省漳州市",
"861705027", "吉林省长春市",
"861816316", "湖北省孝感市",
"861321798", "江西省景德镇市",
"861330233", "广东省广州市",
"861872916", "陕西省汉中市",
"861596052", "福建省莆田市",
"861320564", "安徽省六安市",
"861894496", "湖南省永州市",
"861778903", "西藏山南地区",
"861802087", "福建省福州市",
"861869070", "贵州省黔南布依族苗族自治州",
"861840387", "黑龙江省大兴安岭地区",
"86147855", "贵州省贵阳市",
"861814665", "江西省宜春市",
"861778177", "四川省攀枝花市",
"861863484", "山西省晋中市",
"861380774", "广西梧州市",
"861802167", "江苏省南通市",
"861458184", "浙江省湖州市",
"861536487", "山西省临汾市",
"861882458", "广东省深圳市",
"86851", "贵州省贵阳市\、遵义市\、安顺市",
"86356", "山西省晋城市",
"86182179", "海南省海口市",
"861883063", "河北省廊坊市",
"861503203", "河北省邯郸市",
"861553465", "山西省长治市",
"861764051", "辽宁省阜新市",
"861539931", "陕西省渭南市",
"861328909", "新疆博尔塔拉蒙古自治州",
"861770786", "广西百色市",
"861533301", "山西省太原市",
"861777609", "广西桂林市",
"86189792", "江西省九江市",
"861362859", "贵州省黔西南布依族苗族自治州",
"861503423", "山西省大同市",
"861510753", "广东省梅州市",
"861300845", "陕西省汉中市",
"86177270", "广东省江门市",
"861504728", "内蒙古巴彦淖尔市",
"861840950", "宁夏吴忠市",
"861833386", "河北省唐山市",
"861809434", "江苏省盐城市",
"861302642", "陕西省汉中市",
"86180380", "广东省深圳市",
"861313766", "河南省周口市",
"861768915", "西藏昌都地区",
"861534802", "甘肃省定西市",
"861318876", "山东省烟台市",
"861369623", "四川省南充市",
"861366945", "广西玉林市",
"861588772", "云南省红河哈尼族彝族自治州",
"861525646", "安徽省阜阳市",
"861565900", "福建省龙岩市",
"861850658", "浙江省杭州市",
"861577548", "四川省南充市",
"861319373", "河南省驻马店市",
"861819995", "新疆昌吉回族自治州",
"861530838", "四川省资阳市",
"861770523", "江苏省淮安市",
"861303343", "山西省晋中市",
"861529492", "河南省驻马店市",
"861898030", "四川省南充市",
"861894857", "广东省惠州市",
"86151336", "河北省廊坊市",
"861532425", "河北省唐山市",
"861304782", "广西柳州市",
"861592692", "湖北省咸宁市",
"861365962", "广西柳州市",
"861818356", "云南省曲靖市",
"861555331", "山东省淄博市",
"861305596", "福建省漳州市",
"861770908", "四川省德阳市",
"86183549", "山东省临沂市",
"861315083", "内蒙古乌兰察布市",
"86152036", "海南省海口市",
"86189135", "江苏省苏州市",
"86132717", "河南省驻马店市",
"861821963", "甘肃省平凉市",
"861589133", "陕西省渭南市",
"861566025", "湖南省邵阳市",
"861835135", "江苏省徐州市",
"86181772", "广西柳州市",
"861550794", "江西省抚州市",
"861596918", "云南省西双版纳傣族自治州",
"861809959", "新疆巴音郭楞蒙古自治州",
"861329875", "黑龙江省绥化市",
"861590953", "宁夏吴忠市",
"861583409", "山西省忻州市",
"861390472", "内蒙古包头市",
"861338327", "河北省秦皇岛市",
"861508245", "四川省宜宾市",
"861853476", "山西省吕梁市",
"861769123", "陕西省西安市",
"861827139", "湖北省武汉市",
"861334860", "湖南省岳阳市",
"861871913", "广东省广州市",
"861470418", "辽宁省阜新市",
"861530604", "福建省龙岩市",
"861459791", "新疆喀什地区",
"861781784", "广东省惠州市",
"861889558", "安徽省马鞍山市",
"861885037", "福建省福州市",
"861519052", "江苏省常州市",
"861588511", "贵州省黔东南苗族侗族自治州",
"861320920", "陕西省宝鸡市",
"861823265", "河北省廊坊市",
"861537563", "安徽省宣城市",
"86151925", "山东省青岛市",
"861331047", "贵州省毕节地区",
"861452094", "安徽省六安市",
"861885786", "浙江省杭州市",
"861366836", "四川省乐山市",
"861862379", "河南省洛阳市",
"861534424", "内蒙古兴安盟",
"8618980", "四川省成都市",
"861816911", "宁夏银川市",
"86176986", "河南省郑州市",
"861471478", "广东省潮州市",
"861870973", "青海省黄南藏族自治州",
"86150565", "安徽省滁州市",
"861537980", "甘肃省酒泉市",
"861300936", "辽宁省鞍山市",
"861308305", "安徽省合肥市",
"861887235", "湖北省武汉市",
"861358792", "浙江省湖州市",
"861598474", "四川省甘孜藏族自治州",
"861364446", "吉林省延边朝鲜族自治州",
"861569550", "安徽省滁州市",
"861853071", "河南省新乡市",
"861538833", "四川省宜宾市",
"861778528", "贵州省黔南布依族苗族自治州",
"861522975", "陕西省延安市",
"861599718", "湖北省襄樊市",
"861556409", "山东省滨州市",
"861898751", "云南省保山市",
"861350957", "福建省宁德市",
"861556229", "山东省济宁市",
"861313564", "湖北省孝感市",
"861886476", "河南省焦作市",
"861458123", "安徽省安庆市",
"861325710", "湖北省襄樊市",
"861375926", "云南省西双版纳傣族自治州",
"861771243", "江苏省徐州市",
"861555845", "浙江省丽水市",
"861700855", "贵州省黔东南苗族侗族自治州",
"861344060", "上海市",
"861882974", "陕西省商洛市",
"861390664", "浙江省温州市",
"861840559", "安徽省黄山市",
"861847562", "广东省深圳市",
"861458755", "广东省深圳市",
"8615311", "北京市",
"861539336", "甘肃省酒泉市",
"861470352", "山西省大同市",
"86138955", "宁夏吴忠市",
"861570467", "黑龙江省鸡西市",
"861583377", "河北省沧州市",
"861595115", "江苏省泰州市",
"861328500", "福建省福州市",
"861338279", "江苏省南京市",
"861372256", "河北省秦皇岛市",
"86139519", "江苏省南京市",
"86145377", "广西南宁市",
"861337591", "福建省福州市",
"861573861", "河南省周口市",
"861317728", "湖北省孝感市",
"861831682", "广东省云浮市",
"861350380", "河南省新乡市",
"861520417", "辽宁省营口市",
"861833981", "河南省郑州市",
"861313529", "湖南省邵阳市",
"861819711", "青海省西宁市",
"861817041", "江西省南昌市",
"861315163", "江苏省苏州市",
"861390629", "江苏省南通市",
"861477324", "湖南省湘潭市",
"861768791", "江西省南昌市",
"861517782", "广西南宁市",
"86183823", "四川省成都市",
"861827178", "湖北省襄樊市",
"861883089", "河北省邯郸市",
"861770584", "浙江省宁波市",
"861707176", "江西省鹰潭市",
"861773945", "河南省周口市",
"861515944", "福建省宁德市",
"861521477", "浙江省台州市",
"861569434", "吉林省四平市",
"86156380", "河南省周口市",
"861532690", "内蒙古包头市",
"861856124", "山东省东营市",
"86150514", "江苏省苏州市",
"861341847", "广东省深圳市",
"861381516", "江苏省镇江市",
"861561692", "湖南省怀化市",
"861847129", "湖北省荆门市",
"861357454", "湖南省郴州市",
"861705352", "福建省厦门市",
"861770612", "江苏省常州市",
"861477868", "广东省茂名市",
"861550342", "山西省运城市",
"861338918", "陕西省西安市",
"861865422", "安徽省蚌埠市",
"861830574", "浙江省宁波市",
"861563991", "河南省郑州市",
"861815277", "湖南省郴州市",
"861871470", "黑龙江省哈尔滨市",
"861366376", "河南省信阳市",
"861334792", "江苏省无锡市",
"861890547", "山东省济宁市",
"86159893", "广东省深圳市",
"861582688", "湖北省武汉市",
"861862680", "浙江省温州市",
"86133621", "浙江省杭州市",
"861304555", "安徽省马鞍山市",
"861593281", "江西省宜春市",
"861813647", "江苏省扬州市",
"861514581", "黑龙江省伊春市",
"861321423", "辽宁省沈阳市",
"861380825", "四川省内江市",
"861584748", "内蒙古通辽市",
"861369512", "广东省揭阳市",
"861471807", "广东省茂名市",
"861452306", "河南省安阳市",
"861390705", "江西省宜春市",
"861336012", "广东省湛江市",
"86156677", "陕西省榆林市",
"861870410", "辽宁省铁岭市",
"861317740", "湖北省咸宁市",
"86189374", "河南省许昌市",
"861842051", "广东省汕尾市",
"86170952", "江苏省无锡市",
"861773971", "河南省三门峡市",
"861596602", "山东省泰安市",
"861825011", "福建省龙岩市",
"861323905", "新疆伊犁哈萨克自治州",
"861350638", "山东省济宁市",
"861893426", "广东省茂名市",
"861558469", "吉林省通化市",
"861847164", "湖北省襄樊市",
"861580787", "广西钦州市",
"861893206", "贵州省铜仁地区",
"861304616", "广东省清远市",
"861301276", "山东省德州市",
"861853045", "河南省焦作市",
"861336474", "新疆喀什地区",
"861350422", "辽宁省葫芦岛市",
"861394837", "内蒙古鄂尔多斯市",
"861597020", "江西省吉安市",
"861591450", "广东省广州市",
"861522941", "陕西省延安市",
"861820460", "黑龙江省哈尔滨市",
"86771", "广西南宁市",
"861354327", "广东省深圳市",
"861576644", "广东省深圳市",
"86145038", "辽宁省沈阳市",
"861535390", "陕西省商洛市",
"86158358", "山西省吕梁市",
"861378959", "内蒙古赤峰市",
"86532", "山东省青岛市",
"861340930", "河南省平顶山市",
"861332976", "湖北省荆州市",
"861550488", "内蒙古巴彦淖尔市",
"861374884", "黑龙江省牡丹江市",
"861309454", "四川省凉山彝族自治州",
"86147576", "浙江省台州市",
"861894588", "黑龙江省伊春市",
"86139458", "黑龙江省鸡西市",
"861363963", "河南省新乡市",
"861329783", "广西桂林市",
"861897280", "湖北省黄石市",
"861836147", "江苏省淮安市",
"86156997", "北京市",
"861350679", "浙江省金华市",
"861587998", "江西省景德镇市",
"861335784", "江苏省宿迁市",
"861575106", "江苏省宿迁市",
"861312547", "辽宁省大连市",
"861337942", "陕西省榆林市",
"861868816", "广东省珠海市",
"861363580", "湖北省襄樊市",
"861876259", "江苏省宿迁市",
"861348573", "安徽省合肥市",
"861320948", "甘肃省嘉峪关市",
"861815840", "浙江省杭州市",
"861539876", "云南省文山壮族苗族自治州",
"861862878", "吉林省四平市",
"861800351", "山西省太原市",
"861760421", "辽宁省朝阳市",
"861329526", "江苏省泰州市",
"861305260", "辽宁省朝阳市",
"861478538", "贵州省黔西南布依族苗族自治州",
"861340127", "江苏省徐州市",
"8618427", "湖北省武汉市",
"861530765", "广东省佛山市",
"861580431", "吉林省长春市",
"861802132", "江苏省扬州市",
"861508271", "四川省巴中市",
"861319660", "江苏省苏州市",
"861571587", "浙江省湖州市",
"861560956", "宁夏吴忠市",
"861554833", "内蒙古呼和浩特市",
"86177026", "广东省东莞市",
"861556443", "山东省德州市",
"861882195", "湖南省常德市",
"861538373", "河北省石家庄市",
"86183891", "山东省威海市",
"861329841", "河南省郑州市",
"861361265", "广东省东莞市",
"861302756", "河南省平顶山市",
"861582870", "四川省内江市",
"861801450", "江苏省泰州市",
"861807020", "江西省九江市",
"861883066", "河北省石家庄市",
"861880914", "陕西省商洛市",
"861314468", "黑龙江省鹤岗市",
"86182876", "云南省文山壮族苗族自治州",
"861811472", "江苏省南京市",
"861770783", "广西桂林市",
"861773447", "河北省沧州市",
"861567108", "湖北省荆门市",
"861521975", "广东省茂名市",
"86176451", "黑龙江省哈尔滨市",
"861367317", "河北省沧州市",
"861323680", "辽宁省鞍山市",
"861510756", "广东省珠海市",
"861503426", "山西省吕梁市",
"8615321", "北京市",
"861520915", "陕西省安康市",
"861554971", "湖北省黄石市",
"861504588", "黑龙江省大庆市",
"861556101", "内蒙古呼和浩特市",
"86132099", "新疆乌鲁木齐市",
"861814317", "吉林省辽源市",
"86187550", "安徽省滁州市",
"86170760", "山东省济南市",
"861523430", "山西省阳泉市",
"861869231", "湖南省湘潭市",
"861705325", "广东省广州市",
"861810412", "辽宁省鞍山市",
"861779948", "新疆喀什地区",
"86155301", "河北省石家庄市",
"861375984", "陕西省咸阳市",
"861570965", "宁夏中卫市",
"861500547", "山东省济宁市",
"861319376", "河南省开封市",
"861806327", "山东省潍坊市",
"861830885", "云南省保山市",
"861313697", "黑龙江省佳木斯市",
"861350561", "安徽省合肥市",
"861303346", "山西省长治市",
"861770526", "江苏省泰州市",
"861818134", "四川省成都市",
"861452517", "山东省潍坊市",
"861346151", "河南省信阳市",
"861810074", "湖南省长沙市",
"86139379", "河南省洛阳市",
"861768040", "湖南省衡阳市",
"861379474", "广东省河源市",
"861806238", "湖北省宜昌市",
"86151977", "湖南省益阳市",
"861316512", "山东省济南市",
"861329062", "河北省保定市",
"861833383", "河北省衡水市",
"861350455", "黑龙江省绥化市",
"861806602", "江苏省扬州市",
"86187871", "云南省昆明市",
"861373160", "河北省廊坊市",
"86150374", "河南省许昌市",
"861308979", "黑龙江省鸡西市",
"861390597", "福建省泉州市",
"861313763", "河南省信阳市",
"861318873", "山东省临沂市",
"861364790", "江西省抚州市",
"86132926", "河北省廊坊市",
"861534081", "山西省晋中市",
"861369626", "四川省绵阳市",
"861392358", "广东省汕尾市",
"861522477", "河南省商丘市",
"861770841", "湖南省郴州市",
"86158666", "山东省济南市",
"861306032", "陕西省渭南市",
"861829268", "陕西省西安市",
"861478416", "河南省信阳市",
"861325887", "吉林省白城市",
"861590351", "山西省太原市",
"86130623", "重庆市",
"861822580", "安徽省滁州市",
"861776748", "新疆哈密地区",
"861355319", "山东省济南市",
"86158601", "福建省龙岩市",
"861829891", "甘肃省白银市",
"861879147", "陕西省宝鸡市",
"861450492", "辽宁省丹东市",
"861454397", "贵州省毕节地区",
"861308938", "吉林省白山市",
"861395120", "江苏省常州市",
"861555933", "新疆昌吉回族自治州",
"86158479", "内蒙古锡林郭勒盟",
"861834401", "广东省深圳市",
"861327606", "福建省漳州市",
"861812597", "广东省揭阳市",
"861860319", "河北省邢台市",
"861870371", "河南省郑州市",
"86151410", "辽宁省铁岭市",
"861399771", "湖北省宜昌市",
"861810358", "山西省吕梁市",
"861816313", "湖北省荆州市",
"86151697", "山东省菏泽市",
"861550593", "福建省宁德市",
"861333582", "浙江省湖州市",
"861330236", "广东省肇庆市",
"861872913", "陕西省渭南市",
"861894493", "湖南省怀化市",
"86136746", "黑龙江省哈尔滨市",
"861368487", "江西省赣州市",
"861760562", "安徽省铜陵市",
"861322249", "江苏省南通市",
"861880867", "湖北省襄樊市",
"861320789", "广西贵港市",
"861770335", "河北省秦皇岛市",
"861778906", "西藏那曲地区",
"86155366", "山西省太原市",
"861820998", "新疆喀什地区",
"861781726", "广东省韶关市",
"861334636", "山东省潍坊市",
"861879218", "安徽省合肥市",
"86145325", "上海市",
"861518278", "四川省巴中市",
"861377221", "陕西省汉中市",
"86188857", "贵州省毕节地区",
"861533528", "江苏省苏州市",
"861332047", "云南省普洱市",
"861576876", "广东省深圳市",
"86181446", "广东省惠州市",
"861328768", "山东省潍坊市",
"861323878", "云南省楚雄彝族自治州",
"8618862", "江苏省苏州市",
"861537729", "湖北省随州市",
"861861379", "河南省洛阳市",
"861318333", "河南省平顶山市",
"861335726", "湖南省永州市",
"861517063", "江西省赣州市",
"86137993", "福建省福州市",
"861559627", "陕西省商洛市",
"86156625", "山东省潍坊市",
"861351481", "内蒙古呼和浩特市",
"86147308", "四川省成都市",
"861870345", "山西省长治市",
"861776966", "浙江省湖州市",
"861399745", "青海省果洛藏族自治州",
"861858742", "广西贺州市",
"861470536", "山东省潍坊市",
"861539552", "安徽省蚌埠市",
"86130704", "新疆乌鲁木齐市",
"861566052", "河南省周口市",
"861533540", "山东省菏泽市",
"86189565", "安徽省巢湖市",
"861397015", "江西省鹰潭市",
"861879979", "新疆伊犁哈萨克自治州",
"861324485", "广东省深圳市",
"861593004", "河北省保定市",
"86159709", "江西省赣州市",
"861568958", "山东省临沂市",
"861831851", "广东省广州市",
"861319836", "四川省眉山市",
"861311547", "黑龙江省鸡西市",
"861508813", "广东省江门市",
"861873843", "河南省洛阳市",
"861589732", "湖南省湘潭市",
"861551631", "河南省三门峡市",
"861355818", "广西南宁市",
"861591733", "广东省江门市",
"861529140", "陕西省西安市",
"861335583", "浙江省嘉兴市",
"861538971", "内蒙古呼和浩特市",
"86135771", "云南省昆明市",
"8618417", "海南省海口市",
"86598", "福建省三明市",
"86150135", "广东省深圳市",
"861380419", "辽宁省辽阳市",
"86188736", "湖南省常德市",
"861771121", "四川省宜宾市",
"861323379", "河南省洛阳市",
"861351166", "江苏省常州市",
"861580810", "四川省攀枝花市",
"861343864", "四川省内江市",
"86157324", "河北省承德市",
"861348774", "湖南省株洲市",
"861395148", "江苏省盐城市",
"861810859", "贵州省黔西南布依族苗族自治州",
"861860818", "四川省达州市",
"861335960", "黑龙江省大庆市",
"861308657", "四川省资阳市",
"861507627", "河北省保定市",
"861301756", "河南省平顶山市",
"861329584", "浙江省宁波市",
"861777646", "广西桂林市",
"86134552", "山东省青岛市",
"861572587", "山东省东营市",
"861328946", "陕西省延安市",
"86135904", "广东省深圳市",
"86182333", "河北省保定市",
"861381479", "江苏省常州市",
"86157567", "四川省乐山市",
"861800953", "宁夏吴忠市",
"86170894", "广东省珠海市",
"861317091", "江西省南昌市",
"861351737", "湖南省益阳市",
"861581688", "广东省深圳市",
"861761482", "内蒙古包头市",
"861804800", "四川省阿坝藏族羌族自治州",
"861470325", "河北省唐山市",
"861354759", "四川省南充市",
"861805115", "江苏省泰州市",
"861326381", "广西南宁市",
"861560895", "西藏昌都地区",
"861700822", "贵州省贵阳市",
"861512936", "陕西省西安市",
"861558486", "吉林省白城市",
"861588038", "福建省龙岩市",
"861826246", "江苏省徐州市",
"86137673", "江西省上饶市",
"861308218", "河北省沧州市",
"861770875", "云南省保山市",
"861837541", "山东省济南市",
"861317857", "广东省湛江市",
"861768028", "湖南省衡阳市",
"861518827", "河南省信阳市",
"861323407", "辽宁省大连市",
"861383921", "河南省鹤壁市",
"861322423", "辽宁省沈阳市",
"86158860", "吉林省四平市",
"861302276", "山东省莱芜市",
"861333064", "四川省遂宁市",
"861592450", "内蒙古鄂尔多斯市",
"86182670", "浙江省金华市",
"861355170", "四川省资阳市",
"861523642", "河南省信阳市",
"861330916", "陕西省汉中市",
"86185581", "浙江省杭州市",
"861809718", "青海省西宁市",
"861395658", "安徽省宣城市",
"861320801", "浙江省杭州市",
"861858401", "四川省内江市",
"861873437", "山西省忻州市",
"86186792", "江西省九江市",
"861777156", "湖北省荆门市",
"861591385", "广东省惠州市",
"861830773", "广西桂林市",
"861308147", "山东省泰安市",
"861807048", "江西省赣州市",
"861893484", "广西梧州市",
"86359", "山西省运城市",
"86131492", "陕西省西安市",
"861331976", "新疆阿勒泰地区",
"861769241", "河北省石家庄市",
"86152507", "江苏省宿迁市",
"861311186", "四川省成都市",
"861850572", "浙江省湖州市",
"86153800", "江苏省常州市",
"861869024", "新疆哈密地区",
"861530860", "湖北省宜昌市",
"861598695", "广东省惠州市",
"861836524", "安徽省淮北市",
"86183731", "湖南省长沙市",
"861870980", "安徽省宿州市",
"861863832", "河南省新乡市",
"86139861", "湖北省武汉市",
"861822774", "四川省自贡市",
"861530344", "山西省晋中市",
"861538202", "辽宁省葫芦岛市",
"861362048", "广东省惠州市",
"861320458", "黑龙江省伊春市",
"861590377", "河南省南阳市",
"861330469", "黑龙江省大庆市",
"86139818", "四川省成都市",
"861846444", "山东省聊城市",
"86133122", "贵州省贵阳市",
"861360326", "河北省廊坊市",
"861394953", "河南省安阳市",
"861538638", "湖南省永州市",
"861318717", "湖南省邵阳市",
"86132436", "湖南省永州市",
"861346903", "湖南省株洲市",
"861819148", "陕西省宝鸡市",
"861870563", "安徽省宣城市",
"861829071", "新疆伊犁哈萨克自治州",
"861308645", "四川省乐山市",
"861338488", "内蒙古呼和浩特市",
"861509083", "湖北省荆州市",
"861867276", "湖北省武汉市",
"861705504", "广东省佛山市",
"861479709", "青海省海西蒙古族藏族自治州",
"86187369", "河南省开封市",
"861890089", "广东省清远市",
"861576096", "陕西省汉中市",
"861317331", "山东省威海市",
"86137431", "吉林省长春市",
"861340544", "山东省德州市",
"861311461", "黑龙江省哈尔滨市",
"861521649", "山东省滨州市",
"861323098", "河北省邢台市",
"861522056", "广东省惠州市",
"861778934", "甘肃省武威市",
"861820513", "江苏省连云港市",
"861474138", "辽宁省阜新市",
"861770250", "江苏省南京市",
"861869069", "新疆巴音郭楞蒙古自治州",
"861399757", "湖北省荆州市",
"861870357", "山西省临汾市",
"861327634", "山东省莱芜市",
"861771887", "广东省江门市",
"861557083", "湖南省娄底市",
"86131965", "江苏省无锡市",
"861550918", "陕西省西安市",
"861330424", "辽宁省本溪市",
"861338342", "山西省大同市",
"861365572", "浙江省湖州市",
"861812800", "广东省东莞市",
"861556953", "新疆伊犁哈萨克自治州",
"861311555", "黑龙江省哈尔滨市",
"861782007", "广东省梅州市",
"861315070", "云南省昆明市",
"861502844", "河北省保定市",
"861334604", "浙江省绍兴市",
"861599141", "陕西省延安市",
"861899762", "新疆巴音郭楞蒙古自治州",
"861805258", "江苏省扬州市",
"86150982", "山东省枣庄市",
"861360535", "山东省烟台市",
"861587005", "江西省景德镇市",
"861380966", "广东省惠州市",
"861503234", "河北省石家庄市",
"861892676", "广东省深圳市",
"861807265", "浙江省舟山市",
"861308723", "湖南省湘潭市",
"861829476", "甘肃省甘南藏族自治州",
"861351313", "河北省张家口市",
"861450967", "新疆克孜勒苏柯尔克孜自治州",
"861821254", "贵州省铜仁地区",
"861850995", "新疆吐鲁番地区",
"861785589", "浙江省金华市",
"861350373", "河南省新乡市",
"861357944", "新疆哈密地区",
"861590264", "贵州省安顺市",
"861355782", "广西柳州市",
"861551939", "贵州省黔西南布依族苗族自治州",
"86137259", "广东省江门市",
"861525901", "福建省龙岩市",
"86182309", "贵州省毕节地区",
"861345131", "内蒙古呼和浩特市",
"86132655", "广东省深圳市",
"861308155", "内蒙古鄂尔多斯市",
"861318093", "吉林省延边朝鲜族自治州",
"861831337", "云南省普洱市",
"861511493", "陕西省渭南市",
"861538679", "山西省运城市",
"861818106", "四川省南充市",
"86183848", "四川省达州市",
"861815623", "安徽省宿州市",
"861313974", "新疆阿克苏地区",
"861864845", "内蒙古兴安盟",
"861475750", "浙江省温州市",
"861378449", "河北省秦皇岛市",
"861301990", "辽宁省辽阳市",
"861572656", "山东省烟台市",
"861509163", "陕西省西安市",
"861571049", "陕西省西安市",
"861524137", "辽宁省锦州市",
"861787777", "湖南省湘西土家族苗族自治州",
"861377034", "江苏省南京市",
"861772710", "广东省佛山市",
"86131914", "内蒙古包头市",
"861308586", "广东省中山市",
"861569284", "四川省宜宾市",
"861356664", "浙江省宁波市",
"861854509", "黑龙江省佳木斯市",
"86186619", "山东省青岛市",
"861317845", "广东省清远市",
"86135885", "浙江省绍兴市",
"861810894", "西藏林芝地区",
"861831228", "广东省佛山市",
"86159733", "湖南省株洲市",
"86159146", "广东省中山市",
"861882564", "广东省珠海市",
"861860782", "广西来宾市",
"861803139", "河北省张家口市",
"861831408", "云南省临沧市",
"861518466", "黑龙江省双鸭山市",
"86156591", "福建省福州市",
"861537107", "江苏省无锡市",
"861380720", "湖北省宜昌市",
"861311066", "福建省漳州市",
"861332290", "广东省中山市",
"861337318", "河北省衡水市",
"861383472", "山西省运城市",
"861809403", "福建省龙岩市",
"861831240", "广东省广州市",
"861594705", "内蒙古通辽市",
"861839294", "陕西省渭南市",
"861593431", "山西省忻州市",
"861454523", "广西桂林市",
"86136109", "辽宁省大连市",
"861500555", "安徽省安庆市",
"86134405", "上海市",
"861864871", "内蒙古呼和浩特市",
"861380748", "湖南省长沙市",
"861310581", "浙江省杭州市",
"861368415", "四川省宜宾市",
"861825293", "江苏省镇江市",
"86177847", "重庆市",
"86176203", "广东省深圳市",
"861530792", "江西省九江市",
"86153661", "江苏省南京市",
"86180246", "广东省东莞市",
"861814733", "内蒙古乌海市",
"86139600", "福建省漳州市",
"861332566", "新疆石河子市",
"861317871", "广东省梅州市",
"861788125", "新疆石河子市",
"86153618", "广东省深圳市",
"86158202", "广东省广州市",
"861802940", "广东省江门市",
"861813622", "江苏省扬州市",
"86137575", "浙江省绍兴市",
"861479743", "山西省吕梁市",
"86152589", "浙江省金华市",
"861331589", "河北省承德市",
"861811921", "新疆伊犁哈萨克自治州",
"861454786", "山东省潍坊市",
"861550602", "吉林省吉林市",
"861813438", "河北省邢台市",
"861830964", "宁夏固原市",
"861337819", "四川省达州市",
"861501676", "广东省东莞市",
"861570884", "云南省怒江傈僳族自治州",
"861862673", "吉林省吉林市",
"861508777", "云南省昭通市",
"86134276", "广东省广州市",
"861346949", "湖南省娄底市",
"861554422", "河南省洛阳市",
"861590837", "四川省南充市",
"861457209", "四川省南充市",
"861500616", "江苏省无锡市",
"861760707", "江西省赣州市",
"861539199", "安徽省马鞍山市",
"861871483", "安徽省蚌埠市",
"861338794", "江西省抚州市",
"861554202", "辽宁省锦州市",
"861824869", "浙江省台州市",
"861452646", "江苏省泰州市",
"861890522", "江苏省徐州市",
"861337130