package Bundle::Parrot::Smoke;

use warnings;
use strict;

=head1 NAME

Bundle::Parrot::Smoke - A bundle for installing all the modules needed to smoke Parrot

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

  perl -MCPAN -e 'install Bundle::Parrot::Smoke'

=head1 CONTENTS

Test::More
Test::Harness
MIME::Base64
URI
Scalar::Util 1.07
MKDoc::XML 0.72
Digest::MD5
Petal
Date::Format 0.01
Petal::Utils
Method::Alias
Test::TAP::Model
Test::TAP::HTMLMatrix
IO::Uncompress::Base
IO::Compress::Base
Compress::Raw::Zlib
IO::Uncompress::Gunzip
IO::Compress::Gzip
IO::Compress::Gzip::Constants
IO::Compress::Base::Common
Compress::Zlib
HTML::Tagset 3
HTML::Parser
LWP

=head1 AUTHOR

Steve Peters, C<< <steve at fisharerojo.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-bundle-parrot-smoke at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Bundle-Parrot-Smoke>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Bundle::Parrot::Smoke

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Bundle-Parrot-Smoke>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Bundle-Parrot-Smoke>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Bundle-Parrot-Smoke>

=item * Search CPAN

L<http://search.cpan.org/dist/Bundle-Parrot-Smoke>

=back

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright 2007 Steve Peters, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Bundle::Parrot::Smoke
