# 6B-cmp_published.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checking that the module outputs values equivalent to those published here and there
use strict;
use warnings;

use Test::More tests => 4;
use constant EPS => 1e-2;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $expected, $observed) = ();

# There are 5018 cues in the norms - can we get exactly this number?
$observed = $usf->list_words(cues_only => 1);
ok(is_equal($observed, 5018), "Number of cues: 5018 expected; $observed observed");

# Check against values published by Nelson et al. (1997)
($word1, $word2) = (qw/sore pain/);
$expected = .278;
$observed = $usf->net_strength($word1, $word2);
ok( about_equal($observed, $expected), "NSG calculated for Nelson data = $observed, should be $expected" );

($word1, $word2) = (qw/continent country/);
$expected = .154;
$observed = $usf->net_strength($word1, $word2);
ok( about_equal($observed, $expected), "NSG calculated for Nelson data = $observed, should be $expected" );

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
