use v6;
use Test;

use Gnome::N::X;

#-------------------------------------------------------------------------------
subtest 'debugging', {

  is $Gnome::N::x-debug, False, '0 debugging off';
  Gnome::N::debug(:on);
  is $Gnome::N::x-debug, True, '1 debugging on';
  Gnome::N::debug(:off);
  is $Gnome::N::x-debug, False, '2 debugging off';

  Gnome::N::debug(:!off);
  is $Gnome::N::x-debug, True, '3 debugging on';
  Gnome::N::debug(:!on);
  is $Gnome::N::x-debug, False, '4 debugging off';

  Gnome::N::debug( :on, :off);
  is $Gnome::N::x-debug, True, '5 debugging on';
  Gnome::N::debug( :!on, :!off);
  is $Gnome::N::x-debug, False, '6 debugging off';

  Gnome::N::debug( :on, :off);
  is $Gnome::N::x-debug, True, '7 debugging on';
  Gnome::N::debug;
  is $Gnome::N::x-debug, False, '8 debugging off';
}

#-------------------------------------------------------------------------------
subtest 'X exception', {
  throws-like(
    { die X::Gnome.new(:message('die pour rien')) },
    X::Gnome, 'Test exception',
    :message('die pour rien')
  );
}

#-------------------------------------------------------------------------------
subtest 'test catch', {
  throws-like(
    { my X::Gnome $x .= new(:message('die pour rien'));
      test-catch-exception( $x, 'some-native-sub-name');
    },
    X::Gnome,
    :message("Could not find native sub 'some-native-sub-name(...)'")
  );
}

#-------------------------------------------------------------------------------
done-testing;
