package Locales::DB::Language::cs;

# Auto generated from CLDR

$Locales::DB::Language::cs::VERSION = '0.08';

$Locales::DB::Language::cs::cldr_version = '2.0';

%Locales::DB::Language::cs::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Jazyk\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ a\ \{1\}",
            'end'    => "\{0\}\ a\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '‘',
        'alternate_quotation_start' => '‚',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'other'
        ],
        'category_rules' => {
            'few' => "n\ in\ 2\.\.4",
            'one' => "n\ is\ 1"
        },
        'category_rules_compiled' => {
            'few' => "sub\ \{\ return\ \'few\'\ if\ \(\ \(\(\ int\(\$_\[0\]\)\ \=\=\ \$_\[0\]\ \&\&\ \$_\[0\]\ \>\=\ 2\ \&\&\ \$_\[0\]\ \<\=\ 4\ \)\)\)\;\ return\;\}\;",
            'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;"
        }
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "ano\:a"
    },
);

%Locales::DB::Language::cs::code_to_name = (
    'aa'    => 'afarština',
    'ab'    => 'abcházština',
    'ace'   => 'acehština',
    'ach'   => 'ačoli',
    'ada'   => 'adangme',
    'ady'   => 'adygejština',
    'ae'    => 'avestánština',
    'af'    => 'afrikánština',
    'afa'   => "afroasijské\ jazyky",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainština',
    'ak'    => 'akanština',
    'akk'   => 'akkadština',
    'ale'   => 'aleutština',
    'alg'   => "algonkinské\ jazyky",
    'alt'   => "Southern\ Altai",
    'am'    => 'amharština',
    'an'    => 'aragonština',
    'ang'   => 'staroangličtina',
    'anp'   => 'angika',
    'apa'   => "apačské\ jazyky",
    'ar'    => 'arabština',
    'arc'   => 'aramejština',
    'arn'   => 'araukánština',
    'arp'   => 'arapažština',
    'art'   => "umělé\ jazyky",
    'arw'   => "arawacké\ jazyky",
    'as'    => 'asámština',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "athapaskánské\ jazyky",
    'aus'   => "australské\ jazyky",
    'av'    => 'avarština',
    'awa'   => 'awadhština',
    'ay'    => 'aymárština',
    'az'    => 'ázerbájdžánština',
    'ba'    => 'baškirština',
    'bad'   => 'banda',
    'bai'   => 'bamilek',
    'bal'   => 'balúčština',
    'ban'   => 'balijština',
    'bas'   => 'basa',
    'bat'   => "baltské\ jazyky",
    'be'    => 'běloruština',
    'bej'   => 'bedža',
    'bem'   => 'bembština',
    'ber'   => "berberské\ jazyky",
    'bez'   => 'Bena',
    'bg'    => 'bulharština',
    'bh'    => 'biharština',
    'bho'   => 'bhojpurština',
    'bi'    => 'bislámština',
    'bik'   => 'bikolština',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambarština',
    'bn'    => 'bengálština',
    'bnt'   => "bantuské\ jazyky",
    'bo'    => 'tibetština',
    'br'    => 'bretaňština',
    'bra'   => 'bradžština',
    'brx'   => 'Bodo',
    'bs'    => 'bosenština',
    'btk'   => 'batačtina',
    'bua'   => 'burjatština',
    'bug'   => 'bugiština',
    'byn'   => 'Blin',
    'ca'    => 'katalánština',
    'cad'   => 'caddo',
    'cai'   => "středoamerické\ indiánské\ jazyky",
    'car'   => 'karibština',
    'cau'   => "kavkazské\ jazyky",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'čečenština',
    'ceb'   => 'cebuánština',
    'cel'   => "keltské\ jazyky",
    'cgg'   => 'Chiga',
    'ch'    => 'čamoro',
    'chb'   => 'čibča',
    'chg'   => 'čagatajština',
    'chk'   => 'čukština',
    'chm'   => 'marijština',
    'chn'   => "činuk\ pidžin",
    'cho'   => 'čoktština',
    'chp'   => 'čipevajština',
    'chr'   => 'čerokézština',
    'chy'   => 'čejenština',
    'cmc'   => 'čamština',
    'co'    => 'korsičtina',
    'cop'   => 'koptština',
    'cpe'   => "anglická\ kreolština\ či\ pidgin",
    'cpf'   => "francouzská\ kreolština\ či\ pidgin",
    'cpp'   => "portugalská\ kreolština\ či\ pidgin",
    'cr'    => 'kríjština',
    'crh'   => "krymská\ turečtina",
    'crp'   => "kreolština\ či\ pidgin",
    'cs'    => 'čeština',
    'csb'   => 'Kashubian',
    'cu'    => 'staroslověnština',
    'cus'   => "kúšitské\ jazyky",
    'cv'    => 'čuvaština',
    'cy'    => 'velština',
    'da'    => 'dánština',
    'dak'   => 'dakotština',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'dajáčtina',
    'de'    => 'němčina',
    'de_at' => "Austrian\ German",
    'de_ch' => "švýcarská\ standardní\ němčina",
    'del'   => 'delawarština',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinkština',
    'dje'   => 'Zarma',
    'doi'   => 'dórgí',
    'dra'   => "drávidské\ jazyky",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'dualština',
    'dum'   => 'středoholandština',
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'djula',
    'dz'    => 'bhútánština',
    'ebu'   => 'embu',
    'ee'    => 'eweština',
    'efi'   => 'efikština',
    'egy'   => "egyptština\ stará",
    'eka'   => 'ekajuk',
    'el'    => 'řečtina',
    'elx'   => 'elamitština',
    'en'    => 'angličtina',
    'en_au' => "australská\ angličtina",
    'en_ca' => "anglicky\ \(Kanada\)",
    'en_gb' => "britská\ angličtina",
    'en_us' => "americká\ angličtina",
    'enm'   => 'středoangličtina',
    'eo'    => 'esperanto',
    'es'    => 'španělština',
    'es_es' => "iberská\ španělština",
    'et'    => 'estonština',
    'eu'    => 'baskičtina',
    'ewo'   => 'ewondo',
    'fa'    => 'perština',
    'fan'   => 'fang',
    'fat'   => 'fantština',
    'ff'    => 'fulahština',
    'fi'    => 'finština',
    'fil'   => 'filipínština',
    'fiu'   => "ugrofinské\ jazyky",
    'fj'    => 'fidžijština',
    'fo'    => 'faerština',
    'fon'   => 'Fon',
    'fr'    => 'francouzština',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "švýcarská\ francouzština",
    'frm'   => 'středofrancouzština',
    'fro'   => 'starofrancouzština',
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'furlandština',
    'fy'    => 'fríština',
    'ga'    => 'irština',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaja',
    'gd'    => "skotská\ galština",
    'gem'   => "germánské\ jazyky",
    'gez'   => 'geez',
    'gil'   => 'kiribatština',
    'gl'    => 'galicijština',
    'gmh'   => "hornoněmčina\ \(středověká\)",
    'gn'    => 'guaranština',
    'goh'   => "hornoněmčina\ \(stará\)",
    'gon'   => 'góndština',
    'gor'   => 'gorontalo',
    'got'   => 'gótština',
    'grb'   => 'grebo',
    'grc'   => 'starořečtina',
    'gsw'   => "němčina\ \(Švýcarsko\)",
    'gu'    => 'gudžarátština',
    'guz'   => 'Gusii',
    'gv'    => 'manština',
    'gwi'   => 'gwichʼin',
    'ha'    => 'hauština',
    'hai'   => 'haidština',
    'haw'   => 'havajština',
    'he'    => 'hebrejština',
    'hi'    => 'hindština',
    'hil'   => 'hiligaynonština',
    'him'   => 'himáčalština',
    'hit'   => 'chetitština',
    'hmn'   => 'hmongština',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorvatština',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'haitština',
    'hu'    => 'maďarština',
    'hup'   => 'hupa',
    'hy'    => 'arménština',
    'hz'    => 'hererština',
    'ia'    => 'interlingua',
    'iba'   => 'ibanština',
    'id'    => 'indonéština',
    'ie'    => 'interlingue',
    'ig'    => 'igboština',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'idžo',
    'ik'    => 'inupiakština',
    'ilo'   => 'ilokánština',
    'inc'   => "indické\ jazyky",
    'ine'   => "indoevropské\ jazyky",
    'inh'   => 'inguština',
    'io'    => 'Ido',
    'ira'   => "íránské\ jazyky",
    'iro'   => "irokézské\ jazyky",
    'is'    => 'islandština',
    'it'    => 'italština',
    'iu'    => 'inuktitutština',
    'ja'    => 'japonština',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'javánština',
    'ka'    => 'gruzínština',
    'kaa'   => 'karakalpačtina',
    'kab'   => 'kabylština',
    'kac'   => 'kačijština',
    'kaj'   => 'Jju',
    'kam'   => 'kambština',
    'kar'   => 'karenština',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardinština',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'kapverdština',
    'kfo'   => 'Koro',
    'kg'    => 'konžština',
    'kha'   => 'khásí',
    'khi'   => "kojsanské\ jazyky",
    'kho'   => 'chotánština',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikujština',
    'kj'    => 'kuaňamština',
    'kk'    => 'kazachština',
    'kl'    => 'grónština',
    'kln'   => 'Kalenjin',
    'km'    => 'kambodžština',
    'kmb'   => 'kimbundština',
    'kn'    => 'kannadština',
    'ko'    => 'korejština',
    'kok'   => 'konkánština',
    'kos'   => 'kosrajština',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'kru',
    'kru'   => 'kuruchština',
    'ks'    => 'kašmírština',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdština',
    'kum'   => 'kumykština',
    'kut'   => 'kutenai',
    'kv'    => 'komijština',
    'kw'    => 'kornština',
    'ky'    => 'kirgizština',
    'la'    => 'latina',
    'lad'   => 'ladinština',
    'lag'   => 'Langi',
    'lah'   => 'lahndština',
    'lam'   => 'lambština',
    'lb'    => 'Lucemburština',
    'lez'   => 'lezginština',
    'lg'    => 'ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingalština',
    'lo'    => 'laoština',
    'lol'   => 'mongština',
    'loz'   => 'lozština',
    'lt'    => 'litevština',
    'lu'    => "lubu\-katanžština",
    'lua'   => "luba\-luluaština",
    'lui'   => 'luiseňo',
    'lun'   => 'lundština',
    'luo'   => 'luoština',
    'lus'   => 'lišáí',
    'luy'   => 'luhja',
    'lv'    => 'lotyština',
    'mad'   => 'madurština',
    'mag'   => 'magadhiština',
    'mai'   => 'maithiliština',
    'mak'   => 'makasarština',
    'man'   => 'mandingština',
    'map'   => "austronéské\ jazyky",
    'mas'   => 'masajština',
    'mdf'   => 'Moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaština',
    'mga'   => 'středoirština',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'maršálština',
    'mi'    => 'maorština',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "různé\ jazyky",
    'mk'    => 'makedonština',
    'mkh'   => "mon\-khmerské\ jazyky",
    'ml'    => 'malabarština',
    'mn'    => 'mongolština',
    'mnc'   => 'mandžuština',
    'mni'   => 'manipurština',
    'mno'   => "manobo\ jazyky",
    'mo'    => 'moldavština',
    'moh'   => 'mohawk',
    'mos'   => 'mosi',
    'mr'    => 'maráthština',
    'ms'    => 'malajština',
    'mt'    => 'maltština',
    'mua'   => 'Mundang',
    'mul'   => "složené\ \(víceřádkové\)\ jazyky",
    'mun'   => "mundské\ jazyky",
    'mus'   => "muskogee\ \(creek\)",
    'mwl'   => 'Mirandese',
    'mwr'   => 'márvárština',
    'my'    => 'barmština',
    'myn'   => "mayské\ jazyky",
    'myv'   => 'Erzya',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "severoamerické\ indiánské\ jazyky",
    'nap'   => 'neapolština',
    'naq'   => 'Nama',
    'nb'    => "norština\ \(bokmål\)",
    'nd'    => "ndebele\ \(Zimbabwe\)",
    'nds'   => 'dolnoněmčina',
    'ne'    => 'nepálština',
    'new'   => 'névárština',
    'ng'    => 'ndondština',
    'nia'   => 'nias',
    'nic'   => "nigero\-kordofánské\ jazyky",
    'niu'   => 'niueština',
    'nl'    => 'nizozemština',
    'nl_be' => 'vlámština',
    'nmg'   => 'Kwasio',
    'nn'    => "norština\ \(nynorsk\)",
    'no'    => 'norština',
    'nog'   => 'Nogai',
    'non'   => "norština\ historická",
    'nqo'   => "N\â\\Ko",
    'nr'    => "ndebele\ \(Jižní\ Afrika\)",
    'nso'   => "severní\ sotština",
    'nub'   => "núbijské\ jazyky",
    'nus'   => 'Nuer',
    'nv'    => 'navažština',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'ňandžština',
    'nym'   => 'ňamwežština',
    'nyn'   => 'nyakolština',
    'nyo'   => 'nyorština',
    'nzi'   => 'nzima',
    'oc'    => 'occitan',
    'oj'    => 'odžibvejština',
    'om'    => "oromština\ \(Afan\)",
    'or'    => 'oriya',
    'os'    => 'osetština',
    'osa'   => 'osage',
    'ota'   => "osmanská\ turečtina",
    'oto'   => "otomijské\ jazyky",
    'pa'    => 'paňdžábština',
    'paa'   => "papuánské\ jazyky",
    'pag'   => 'pangasinanština',
    'pal'   => 'pahlaví',
    'pam'   => 'papangau',
    'pap'   => 'papiamento',
    'pau'   => 'palauština',
    'peo'   => 'staroperština',
    'phi'   => "filipínské\ jazyky",
    'phn'   => 'féničtina',
    'pi'    => 'pálí',
    'pl'    => 'polština',
    'pon'   => 'pohnpeiština',
    'pra'   => "prákrtské\ jazyky",
    'pro'   => 'provensálština',
    'ps'    => 'pašto',
    'pt'    => 'portugalština',
    'pt_br' => "brazilská\ portugalština",
    'pt_pt' => "iberská\ portugalština",
    'qu'    => 'kečuánština',
    'raj'   => 'rádžastánština',
    'rap'   => 'rapanuiština',
    'rar'   => 'rarotongaština',
    'rm'    => 'rétorománština',
    'rn'    => 'kirundi',
    'ro'    => 'rumunština',
    'roa'   => "románské\ jazyky",
    'rof'   => 'rombo',
    'rom'   => 'romština',
    'ru'    => 'ruština',
    'rup'   => 'Aromanian',
    'rw'    => 'kinyarwandština',
    'rwk'   => 'rwa',
    'sa'    => 'sanskrt',
    'sad'   => 'sandawština',
    'sah'   => 'jakutština',
    'sai'   => "jihoamerické\ indiánské\ jazyky",
    'sal'   => "sališské\ jazyky",
    'sam'   => 'samarština',
    'saq'   => 'Samburu',
    'sas'   => 'sasakština',
    'sat'   => 'santálština',
    'sbp'   => 'Sangu',
    'sc'    => 'sardština',
    'scn'   => 'Sicilian',
    'sco'   => 'skotština',
    'sd'    => 'sindhi',
    'se'    => "severní\ sámština",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkupština',
    'sem'   => "semitské\ jazyky",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sangho',
    'sga'   => 'staroirština',
    'sgn'   => "znakové\ jazyky",
    'sh'    => 'srbochorvatština',
    'shi'   => 'Tachelhit',
    'shn'   => 'šanština',
    'si'    => 'sinhálština',
    'sid'   => 'sidamo',
    'sio'   => "siouxské\ jazyky",
    'sit'   => "tibetočínské\ jazyky",
    'sk'    => 'slovenština',
    'sl'    => 'slovinština',
    'sla'   => "slovanský\ jazyk",
    'sm'    => 'samoyština',
    'sma'   => "Southern\ Sami",
    'smi'   => "sámské\ jazyky",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'shona',
    'snk'   => 'sonikština',
    'so'    => 'somálština',
    'sog'   => 'sogdština',
    'son'   => 'songhajština',
    'sq'    => 'albánština',
    'sr'    => 'srbština',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'sererština',
    'ss'    => 'siswatština',
    'ssa'   => "nilosaharské\ jazyky",
    'ssy'   => 'Saho',
    'st'    => 'sesotho',
    'su'    => 'sundanština',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerština',
    'sv'    => 'švédština',
    'sw'    => 'svahilština',
    'swb'   => 'komorština',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'syrština',
    'ta'    => 'tamilština',
    'tai'   => "thajské\ jazyky",
    'te'    => 'telugština',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetumština',
    'tg'    => 'tádžičtina',
    'th'    => 'thajština',
    'ti'    => 'tigrinijština',
    'tig'   => 'tigrejština',
    'tiv'   => 'tivština',
    'tk'    => 'turkmenština',
    'tkl'   => 'tokelauština',
    'tl'    => 'tagalog',
    'tlh'   => 'klingonština',
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'setswanština',
    'to'    => 'tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turečtina',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => "tsimšijské\ jazyky",
    'tt'    => 'tatarština',
    'tum'   => 'tumbukština',
    'tup'   => "Tupi\ Language",
    'tut'   => "altajské\ jazyky",
    'tvl'   => 'tuvalština',
    'tw'    => 'twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitština',
    'tyv'   => 'tuvinština',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtština',
    'ug'    => 'ujgurština',
    'uga'   => 'ugaritština',
    'uk'    => 'ukrajinština',
    'umb'   => 'umbundu',
    'und'   => "neznámý\ nebo\ neplatný\ jazyk",
    'ur'    => 'urdština',
    'uz'    => 'uzbečtina',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamština',
    'vo'    => 'volapuk',
    'vot'   => 'votiatština',
    'vun'   => 'Vunjo',
    'wa'    => 'valonština',
    'wae'   => "němčina\ \(walser\)",
    'wak'   => "wakašské\ jazyky",
    'wal'   => 'walamština',
    'war'   => 'waray',
    'was'   => 'waština',
    'wen'   => "lužickosrbské\ jazyky",
    'wo'    => 'wolof',
    'xal'   => 'kalmyčtina',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'jaoština',
    'yap'   => 'yapese',
    'yav'   => 'Yangben',
    'yi'    => 'jidiš',
    'yo'    => 'yoruba',
    'ypk'   => 'yupik',
    'yue'   => 'kantonština',
    'za'    => 'zhuang',
    'zap'   => 'zapotéčtina',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'čínština',
    'znd'   => 'zandština',
    'zu'    => 'zulu',
    'zun'   => 'zunijština',
    'zxx'   => "žádný\ jazykový\ obsah",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::cs::name_to_code = (
    'abcházština'                     => 'ab',
    'acehština'                        => 'ace',
    'adangme'                           => 'ada',
    'adygejština'                      => 'ady',
    'afarština'                        => 'aa',
    'afrihili'                          => 'afh',
    'afrikánština'                    => 'af',
    'afroasijskéjazyky'                => 'afa',
    'aghem'                             => 'agq',
    'ainština'                         => 'ain',
    'akanština'                        => 'ak',
    'akkadština'                       => 'akk',
    'albánština'                      => 'sq',
    'aleutština'                       => 'ale',
    'algonkinskéjazyky'                => 'alg',
    'altajskéjazyky'                   => 'tut',
    'americkáangličtina'              => 'en_us',
    'amharština'                       => 'am',
    'angika'                            => 'anp',
    'anglickykanada'                    => 'en_ca',
    'anglickákreolštinačipidgin'     => 'cpe',
    'angličtina'                       => 'en',
    'apačskéjazyky'                   => 'apa',
    'arabština'                        => 'ar',
    'aragonština'                      => 'an',
    'aramejština'                      => 'arc',
    'arapažština'                     => 'arp',
    'araukánština'                    => 'arn',
    'arawackéjazyky'                   => 'arw',
    'arménština'                      => 'hy',
    'aromanian'                         => 'rup',
    'asturian'                          => 'ast',
    'asu'                               => 'asa',
    'asámština'                       => 'as',
    'athapaskánskéjazyky'             => 'ath',
    'atsam'                             => 'cch',
    'australskáangličtina'            => 'en_au',
    'australskéjazyky'                 => 'aus',
    'austriangerman'                    => 'de_at',
    'austronéskéjazyky'               => 'map',
    'avarština'                        => 'av',
    'avestánština'                    => 'ae',
    'awadhština'                       => 'awa',
    'aymárština'                      => 'ay',
    'ačoli'                            => 'ach',
    'bafia'                             => 'ksf',
    'balijština'                       => 'ban',
    'baltskéjazyky'                    => 'bat',
    'balúčština'                     => 'bal',
    'bambarština'                      => 'bm',
    'bamilek'                           => 'bai',
    'banda'                             => 'bad',
    'bantuskéjazyky'                   => 'bnt',
    'barmština'                        => 'my',
    'basa'                              => 'bas',
    'baskičtina'                       => 'eu',
    'batačtina'                        => 'btk',
    'baškirština'                     => 'ba',
    'bedža'                            => 'bej',
    'bembština'                        => 'bem',
    'bena'                              => 'bez',
    'bengálština'                     => 'bn',
    'berberskéjazyky'                  => 'ber',
    'bhojpurština'                     => 'bho',
    'bhútánština'                    => 'dz',
    'biharština'                       => 'bh',
    'bikolština'                       => 'bik',
    'bini'                              => 'bin',
    'bislámština'                     => 'bi',
    'blin'                              => 'byn',
    'blissymbols'                       => 'zbl',
    'bodo'                              => 'brx',
    'bosenština'                       => 'bs',
    'bradžština'                      => 'bra',
    'brazilskáportugalština'          => 'pt_br',
    'bretaňština'                     => 'br',
    'britskáangličtina'               => 'en_gb',
    'bugiština'                        => 'bug',
    'bulharština'                      => 'bg',
    'burjatština'                      => 'bua',
    'běloruština'                     => 'be',
    'caddo'                             => 'cad',
    'canadianfrench'                    => 'fr_ca',
    'cayuga'                            => 'cay',
    'cebuánština'                     => 'ceb',
    'centralmoroccotamazight'           => 'tzm',
    'chetitština'                      => 'hit',
    'chiga'                             => 'cgg',
    'chorvatština'                     => 'hr',
    'chotánština'                     => 'kho',
    'classicalnewari'                   => 'nwc',
    'classicalsyriac'                   => 'syc',
    'colognian'                         => 'ksh',
    'congoswahili'                      => 'swc',
    'dajáčtina'                       => 'day',
    'dakotština'                       => 'dak',
    'dargwa'                            => 'dar',
    'delawarština'                     => 'del',
    'dinkština'                        => 'din',
    'divehi'                            => 'dv',
    'djula'                             => 'dyu',
    'dogrib'                            => 'dgr',
    'dolnoněmčina'                    => 'nds',
    'drávidskéjazyky'                 => 'dra',
    'dualština'                        => 'dua',
    'dánština'                        => 'da',
    'dórgí'                           => 'doi',
    'easternfrisian'                    => 'frs',
    'efikština'                        => 'efi',
    'egyptštinastará'                 => 'egy',
    'ekajuk'                            => 'eka',
    'elamitština'                      => 'elx',
    'embu'                              => 'ebu',
    'erzya'                             => 'myv',
    'esperanto'                         => 'eo',
    'estonština'                       => 'et',
    'eweština'                         => 'ee',
    'ewondo'                            => 'ewo',
    'faerština'                        => 'fo',
    'fang'                              => 'fan',
    'fantština'                        => 'fat',
    'fidžijština'                     => 'fj',
    'filipínskéjazyky'                => 'phi',
    'filipínština'                    => 'fil',
    'finština'                         => 'fi',
    'fon'                               => 'fon',
    'francouzskákreolštinačipidgin'  => 'cpf',
    'francouzština'                    => 'fr',
    'fríština'                        => 'fy',
    'fulahština'                       => 'ff',
    'furlandština'                     => 'fur',
    'féničtina'                       => 'phn',
    'ga'                                => 'gaa',
    'galicijština'                     => 'gl',
    'ganda'                             => 'lg',
    'gayo'                              => 'gay',
    'gbaja'                             => 'gba',
    'geez'                              => 'gez',
    'germánskéjazyky'                 => 'gem',
    'gorontalo'                         => 'gor',
    'grebo'                             => 'grb',
    'gruzínština'                     => 'ka',
    'grónština'                       => 'kl',
    'guaranština'                      => 'gn',
    'gudžarátština'                  => 'gu',
    'gusii'                             => 'guz',
    'gwichʼin'                         => 'gwi',
    'góndština'                       => 'gon',
    'gótština'                        => 'got',
    'haidština'                        => 'hai',
    'haitština'                        => 'ht',
    'hauština'                         => 'ha',
    'havajština'                       => 'haw',
    'hebrejština'                      => 'he',
    'hererština'                       => 'hz',
    'hiligaynonština'                  => 'hil',
    'himáčalština'                   => 'him',
    'hindština'                        => 'hi',
    'hirimotu'                          => 'ho',
    'hmongština'                       => 'hmn',
    'hornoněmčinastará'              => 'goh',
    'hornoněmčinastředověká'       => 'gmh',
    'hupa'                              => 'hup',
    'ibanština'                        => 'iba',
    'iberskáportugalština'            => 'pt_pt',
    'iberskášpanělština'            => 'es_es',
    'ido'                               => 'io',
    'idžo'                             => 'ijo',
    'igboština'                        => 'ig',
    'ilokánština'                     => 'ilo',
    'inarisami'                         => 'smn',
    'indickéjazyky'                    => 'inc',
    'indoevropskéjazyky'               => 'ine',
    'indonéština'                     => 'id',
    'inguština'                        => 'inh',
    'interlingua'                       => 'ia',
    'interlingue'                       => 'ie',
    'inuktitutština'                   => 'iu',
    'inupiakština'                     => 'ik',
    'irokézskéjazyky'                 => 'iro',
    'irština'                          => 'ga',
    'islandština'                      => 'is',
    'italština'                        => 'it',
    'jakutština'                       => 'sah',
    'jaoština'                         => 'yao',
    'japonština'                       => 'ja',
    'javánština'                      => 'jv',
    'jidiš'                            => 'yi',
    'jihoamerickéindiánskéjazyky'    => 'sai',
    'jju'                               => 'kaj',
    'jolafonyi'                         => 'dyo',
    'judeoarabic'                       => 'jrb',
    'judeopersian'                      => 'jpr',
    'kabardinština'                    => 'kbd',
    'kabylština'                       => 'kab',
    'kalenjin'                          => 'kln',
    'kalmyčtina'                       => 'xal',
    'kambodžština'                    => 'km',
    'kambština'                        => 'kam',
    'kannadština'                      => 'kn',
    'kantonština'                      => 'yue',
    'kanuri'                            => 'kr',
    'kapverdština'                     => 'kea',
    'karachaybalkar'                    => 'krc',
    'karakalpačtina'                   => 'kaa',
    'karelian'                          => 'krl',
    'karenština'                       => 'kar',
    'karibština'                       => 'car',
    'kashubian'                         => 'csb',
    'katalánština'                    => 'ca',
    'kavkazskéjazyky'                  => 'cau',
    'kawi'                              => 'kaw',
    'kazachština'                      => 'kk',
    'kačijština'                      => 'kac',
    'kašmírština'                    => 'ks',
    'keltskéjazyky'                    => 'cel',
    'kečuánština'                    => 'qu',
    'khásí'                           => 'kha',
    'kikujština'                       => 'ki',
    'kimbundština'                     => 'kmb',
    'kinyarwandština'                  => 'rw',
    'kirgizština'                      => 'ky',
    'kiribatština'                     => 'gil',
    'kirundi'                           => 'rn',
    'klingonština'                     => 'tlh',
    'kojsanskéjazyky'                  => 'khi',
    'komijština'                       => 'kv',
    'komorština'                       => 'swb',
    'konkánština'                     => 'kok',
    'konžština'                       => 'kg',
    'koptština'                        => 'cop',
    'korejština'                       => 'ko',
    'kornština'                        => 'kw',
    'koro'                              => 'kfo',
    'korsičtina'                       => 'co',
    'kosrajština'                      => 'kos',
    'koyraborosenni'                    => 'ses',
    'koyrachiini'                       => 'khq',
    'kpelle'                            => 'kpe',
    'kreolštinačipidgin'              => 'crp',
    'kru'                               => 'kro',
    'krymskáturečtina'                => 'crh',
    'kríjština'                       => 'cr',
    'kuaňamština'                     => 'kj',
    'kumykština'                       => 'kum',
    'kurdština'                        => 'ku',
    'kuruchština'                      => 'kru',
    'kutenai'                           => 'kut',
    'kwasio'                            => 'nmg',
    'kúšitskéjazyky'                 => 'cus',
    'ladinština'                       => 'lad',
    'lahndština'                       => 'lah',
    'lambština'                        => 'lam',
    'langi'                             => 'lag',
    'laoština'                         => 'lo',
    'latina'                            => 'la',
    'lezginština'                      => 'lez',
    'limburgish'                        => 'li',
    'lingalština'                      => 'ln',
    'litevština'                       => 'lt',
    'lišáí'                          => 'lus',
    'lojban'                            => 'jbo',
    'lotyština'                        => 'lv',
    'lowersorbian'                      => 'dsb',
    'lozština'                         => 'loz',
    'lubaluluaština'                   => 'lua',
    'lubukatanžština'                 => 'lu',
    'lucemburština'                    => 'lb',
    'luhja'                             => 'luy',
    'luiseňo'                          => 'lui',
    'lulesami'                          => 'smj',
    'lundština'                        => 'lun',
    'luoština'                         => 'luo',
    'lužickosrbskéjazyky'             => 'wen',
    'machame'                           => 'jmc',
    'madurština'                       => 'mad',
    'magadhiština'                     => 'mag',
    'maithiliština'                    => 'mai',
    'makasarština'                     => 'mak',
    'makedonština'                     => 'mk',
    'makhuwameetto'                     => 'mgh',
    'makonde'                           => 'kde',
    'malabarština'                     => 'ml',
    'malajština'                       => 'ms',
    'malgaština'                       => 'mg',
    'maltština'                        => 'mt',
    'mandar'                            => 'mdr',
    'mandingština'                     => 'man',
    'mandžuština'                     => 'mnc',
    'manipurština'                     => 'mni',
    'manobojazyky'                      => 'mno',
    'manština'                         => 'gv',
    'maorština'                        => 'mi',
    'marijština'                       => 'chm',
    'maráthština'                     => 'mr',
    'maršálština'                    => 'mh',
    'masajština'                       => 'mas',
    'mayskéjazyky'                     => 'myn',
    'maďarština'                      => 'hu',
    'mende'                             => 'men',
    'meru'                              => 'mer',
    'micmac'                            => 'mic',
    'minangkabau'                       => 'min',
    'mirandese'                         => 'mwl',
    'mohawk'                            => 'moh',
    'moksha'                            => 'mdf',
    'moldavština'                      => 'mo',
    'mongolština'                      => 'mn',
    'mongština'                        => 'lol',
    'monkhmerskéjazyky'                => 'mkh',
    'morisyen'                          => 'mfe',
    'mosi'                              => 'mos',
    'mundang'                           => 'mua',
    'mundskéjazyky'                    => 'mun',
    'muskogeecreek'                     => 'mus',
    'márvárština'                    => 'mwr',
    'nahuatl'                           => 'nah',
    'nama'                              => 'naq',
    'nauru'                             => 'na',
    'navažština'                      => 'nv',
    'ndebelejižníafrika'              => 'nr',
    'ndebelezimbabwe'                   => 'nd',
    'ndondština'                       => 'ng',
    'neapolština'                      => 'nap',
    'nepálština'                      => 'ne',
    'neznámýneboneplatnýjazyk'       => 'und',
    'nias'                              => 'nia',
    'nigerokordofánskéjazyky'         => 'nic',
    'nilosaharskéjazyky'               => 'ssa',
    'niueština'                        => 'niu',
    'nizozemština'                     => 'nl',
    'nogai'                             => 'nog',
    'northernfrisian'                   => 'frr',
    'norština'                         => 'no',
    'norštinabokmål'                  => 'nb',
    'norštinahistorická'              => 'non',
    'norštinanynorsk'                  => 'nn',
    'nuer'                              => 'nus',
    'nyakolština'                      => 'nyn',
    'nyasatonga'                        => 'tog',
    'nyorština'                        => 'nyo',
    'nzima'                             => 'nzi',
    "n\â\\ko"                      => 'nqo',
    'névárština'                     => 'new',
    'núbijskéjazyky'                  => 'nub',
    'němčina'                         => 'de',
    'němčinawalser'                   => 'wae',
    'němčinaŠvýcarsko'              => 'gsw',
    'occitan'                           => 'oc',
    'odžibvejština'                   => 'oj',
    'oriya'                             => 'or',
    'oromštinaafan'                    => 'om',
    'osage'                             => 'osa',
    'osetština'                        => 'os',
    'osmanskáturečtina'               => 'ota',
    'otomijskéjazyky'                  => 'oto',
    'pahlaví'                          => 'pal',
    'palauština'                       => 'pau',
    'pangasinanština'                  => 'pag',
    'papangau'                          => 'pam',
    'papiamento'                        => 'pap',
    'papuánskéjazyky'                 => 'paa',
    'paňdžábština'                  => 'pa',
    'pašto'                            => 'ps',
    'perština'                         => 'fa',
    'pohnpeiština'                     => 'pon',
    'polština'                         => 'pl',
    'portugalskákreolštinačipidgin'  => 'cpp',
    'portugalština'                    => 'pt',
    'provensálština'                  => 'pro',
    'prákrtskéjazyky'                 => 'pra',
    'pálí'                            => 'pi',
    'rapanuiština'                     => 'rap',
    'rarotongaština'                   => 'rar',
    'rombo'                             => 'rof',
    'románskéjazyky'                  => 'roa',
    'romština'                         => 'rom',
    'rumunština'                       => 'ro',
    'ruština'                          => 'ru',
    'rwa'                               => 'rwk',
    'rádžastánština'                => 'raj',
    'rétorománština'                 => 'rm',
    'různéjazyky'                     => 'mis',
    'saho'                              => 'ssy',
    'sališskéjazyky'                  => 'sal',
    'samarština'                       => 'sam',
    'samburu'                           => 'saq',
    'samoyština'                       => 'sm',
    'sandawština'                      => 'sad',
    'sangho'                            => 'sg',
    'sangu'                             => 'sbp',
    'sanskrt'                           => 'sa',
    'santálština'                     => 'sat',
    'sardština'                        => 'sc',
    'sasakština'                       => 'sas',
    'selkupština'                      => 'sel',
    'semitskéjazyky'                   => 'sem',
    'sena'                              => 'seh',
    'seneca'                            => 'see',
    'sererština'                       => 'srr',
    'sesotho'                           => 'st',
    'setswanština'                     => 'tn',
    'severnísotština'                 => 'nso',
    'severnísámština'                => 'se',
    'severoamerickéindiánskéjazyky'  => 'nai',
    'shambala'                          => 'ksb',
    'shona'                             => 'sn',
    'sichuanyi'                         => 'ii',
    'sicilian'                          => 'scn',
    'sidamo'                            => 'sid',
    'siksika'                           => 'bla',
    'sindhi'                            => 'sd',
    'sinhálština'                     => 'si',
    'siouxskéjazyky'                   => 'sio',
    'siswatština'                      => 'ss',
    'skoltsami'                         => 'sms',
    'skotskágalština'                 => 'gd',
    'skotština'                        => 'sco',
    'slave'                             => 'den',
    'slovanskýjazyk'                   => 'sla',
    'slovenština'                      => 'sk',
    'slovinština'                      => 'sl',
    'složenévíceřádkovéjazyky'    => 'mul',
    'soga'                              => 'xog',
    'sogdština'                        => 'sog',
    'somálština'                      => 'so',
    'songhajština'                     => 'son',
    'sonikština'                       => 'snk',
    'southernaltai'                     => 'alt',
    'southernsami'                      => 'sma',
    'sranantongo'                       => 'srn',
    'srbochorvatština'                 => 'sh',
    'srbština'                         => 'sr',
    'staroangličtina'                  => 'ang',
    'starofrancouzština'               => 'fro',
    'staroirština'                     => 'sga',
    'staroperština'                    => 'peo',
    'staroslověnština'                => 'cu',
    'starořečtina'                    => 'grc',
    'středoamerickéindiánskéjazyky' => 'cai',
    'středoangličtina'                => 'enm',
    'středofrancouzština'             => 'frm',
    'středoholandština'               => 'dum',
    'středoirština'                   => 'mga',
    'sukuma'                            => 'suk',
    'sumerština'                       => 'sux',
    'sundanština'                      => 'su',
    'susu'                              => 'sus',
    'svahilština'                      => 'sw',
    'syrština'                         => 'syr',
    'sámskéjazyky'                    => 'smi',
    'tachelhit'                         => 'shi',
    'tagalog'                           => 'tl',
    'tahitština'                       => 'ty',
    'taita'                             => 'dav',
    'tamašek'                          => 'tmh',
    'tamilština'                       => 'ta',
    'taroko'                            => 'trv',
    'tasawaq'                           => 'twq',
    'tatarština'                       => 'tt',
    'telugština'                       => 'te',
    'temne'                             => 'tem',
    'tereno'                            => 'ter',
    'teso'                              => 'teo',
    'tetumština'                       => 'tet',
    'thajskéjazyky'                    => 'tai',
    'thajština'                        => 'th',
    'tibetočínskéjazyky'             => 'sit',
    'tibetština'                       => 'bo',
    'tigrejština'                      => 'tig',
    'tigrinijština'                    => 'ti',
    'tivština'                         => 'tiv',
    'tlingit'                           => 'tli',
    'tokelauština'                     => 'tkl',
    'tokpisin'                          => 'tpi',
    'tonga'                             => 'to',
    'tsimšijskéjazyky'                => 'tsi',
    'tsonga'                            => 'ts',
    'tumbukština'                      => 'tum',
    'tupilanguage'                      => 'tup',
    'turečtina'                        => 'tr',
    'turkmenština'                     => 'tk',
    'tuvalština'                       => 'tvl',
    'tuvinština'                       => 'tyv',
    'twi'                               => 'tw',
    'tyap'                              => 'kcg',
    'tádžičtina'                     => 'tg',
    'udmurtština'                      => 'udm',
    'ugaritština'                      => 'uga',
    'ugrofinskéjazyky'                 => 'fiu',
    'ujgurština'                       => 'ug',
    'ukrajinština'                     => 'uk',
    'umbundu'                           => 'umb',
    'uměléjazyky'                     => 'art',
    'uppersorbian'                      => 'hsb',
    'urdština'                         => 'ur',
    'uzbečtina'                        => 'uz',
    'vai'                               => 'vai',
    'valonština'                       => 'wa',
    'velština'                         => 'cy',
    'venda'                             => 've',
    'vietnamština'                     => 'vi',
    'vlámština'                       => 'nl_be',
    'volapuk'                           => 'vo',
    'votiatština'                      => 'vot',
    'vunjo'                             => 'vun',
    'wakašskéjazyky'                  => 'wak',
    'walamština'                       => 'wal',
    'waray'                             => 'war',
    'waština'                          => 'was',
    'wolof'                             => 'wo',
    'xhosa'                             => 'xh',
    'yangben'                           => 'yav',
    'yapese'                            => 'yap',
    'yoruba'                            => 'yo',
    'yupik'                             => 'ypk',
    'zandština'                        => 'znd',
    'zapotéčtina'                     => 'zap',
    'zarma'                             => 'dje',
    'zaza'                              => 'zza',
    'zenaga'                            => 'zen',
    'zhuang'                            => 'za',
    'znakovéjazyky'                    => 'sgn',
    'zulu'                              => 'zu',
    'zunijština'                       => 'zun',
    'ázerbájdžánština'             => 'az',
    'íránskéjazyky'                  => 'ira',
    'čagatajština'                    => 'chg',
    'čamoro'                           => 'ch',
    'čamština'                        => 'cmc',
    'čejenština'                      => 'chy',
    'čerokézština'                   => 'chr',
    'čečenština'                     => 'ce',
    'čeština'                         => 'cs',
    'čibča'                           => 'chb',
    'činukpidžin'                     => 'chn',
    'čipevajština'                    => 'chp',
    'čoktština'                       => 'cho',
    'čukština'                        => 'chk',
    'čuvaština'                       => 'cv',
    'čínština'                       => 'zh',
    'ňamwežština'                    => 'nym',
    'ňandžština'                     => 'ny',
    'řečtina'                         => 'el',
    'šanština'                        => 'shn',
    'španělština'                    => 'es',
    'švédština'                      => 'sv',
    'švýcarskáfrancouzština'        => 'fr_ch',
    'švýcarskástandardníněmčina'  => 'de_ch',
    'žádnýjazykovýobsah'            => 'zxx',
);

1;
