package Locales::DB::Language::ne;

# Auto generated from CLDR

$Locales::DB::Language::ne::VERSION = '0.07';

$Locales::DB::Language::ne::cldr_version = '2.0';

%Locales::DB::Language::ne::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::ne::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'अफ्रिकाली',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'अम्हारिक',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'अरबी',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'आसामी',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'अजरबैजानी',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'बेलारुसियाली',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'बुल्गेरियाली',
    'bh'    => 'बिहारी',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'बंगाली',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'बोस्नियाली',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'क्याटालन',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'चेकोस्लोभाकियाली',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'वेल्श',
    'da'    => 'ड्यानिश',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'जर्मन',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ग्रीक',
    'elx'   => 'Elamite',
    'en'    => 'अँग्रेजी',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'एस्पेरान्तो',
    'es'    => 'स्प्यानिश',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'इस्टोनियाली',
    'eu'    => 'बास्क',
    'ewo'   => 'Ewondo',
    'fa'    => 'फारसी',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'फिनिश',
    'fil'   => 'फिलिपिनी',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'फारोइज',
    'fon'   => 'Fon',
    'fr'    => 'फ्रांसेली',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'फ्रिजीयन',
    'ga'    => 'आइरिश',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "स्कट्स\ गाएलिक",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'गलिसियाली',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'गुजराती',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'हिब्रु',
    'hi'    => 'हिन्दी',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'क्रोएसियाली',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'हंग्रीयाली',
    'hup'   => 'Hupa',
    'hy'    => 'Armenian',
    'hz'    => 'Herero',
    'ia'    => 'इन्टर्लिङ्गुआ',
    'iba'   => 'Iban',
    'id'    => 'इन्डोनेसियाली',
    'ie'    => 'अन्तरभाषी',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'आइसल्यान्डिक',
    'it'    => 'इटालियन',
    'iu'    => 'Inuktitut',
    'ja'    => 'जापानी',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'जाभानिज',
    'ka'    => 'जोरजियन',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'कम्बोडीयाली',
    'kmb'   => 'Kimbundu',
    'kn'    => 'कन्नाडा',
    'ko'    => 'कोरियाली',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'कुर्दिश',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => 'ल्याटिन',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'लिंगाला',
    'lo'    => 'लाओ',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'लिथुआनियाली',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'लात्भियाली',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'म्याकेडोनियन',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'मलयालम',
    'mn'    => 'मंगोल',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'मराठी',
    'ms'    => 'मलाया',
    'mt'    => 'माल्टिज',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'नेपाली',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'डच',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'नर्वेजियाली',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'अक्सिटन',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'ओरिया',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'पंजाबी',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'पोलिश',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'पाश्तो',
    'pt'    => 'पोर्तुगाली',
    'pt_br' => "पर्तुगाली\ \(ब्राजिल्याली\)",
    'pt_pt' => "आइबेरी\,\ पर्तुगाली",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'Romansh',
    'rn'    => 'Rundi',
    'ro'    => 'रोमानियाली',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'रसियाली',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'संस्कृत',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croatian",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'सिन्हाली',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'स्लोभाकियाली',
    'sl'    => 'स्लोभेनियाली',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'सोमाली',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'अल्बेनियन',
    'sr'    => 'सर्बियाली',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Southern\ Sotho",
    'su'    => 'सुडानी',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'स्विडिश',
    'sw'    => 'स्वाहिली',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'तामिल',
    'tai'   => "Tai\ Language",
    'te'    => 'तेलुगु',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'थाई',
    'ti'    => 'तिग्रीन्या',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'क्लिङ्गन',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'टर्की',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'युक्रेनी',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ Language",
    'ur'    => 'उर्दु',
    'uz'    => 'उज़्बेक',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'भियतनामी',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'झोसा',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'यिद्दिस',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'चिनियाँ',
    'znd'   => 'Zande',
    'zu'    => 'जुलू',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ne::name_to_code = (
    'abkhazian'                                                       => 'ab',
    'achinese'                                                        => 'ace',
    'acoli'                                                           => 'ach',
    'adangme'                                                         => 'ada',
    'adyghe'                                                          => 'ady',
    'afar'                                                            => 'aa',
    'afrihili'                                                        => 'afh',
    'afroasiaticlanguage'                                             => 'afa',
    'aghem'                                                           => 'agq',
    'ainu'                                                            => 'ain',
    'akan'                                                            => 'ak',
    'akkadian'                                                        => 'akk',
    'aleut'                                                           => 'ale',
    'algonquianlanguage'                                              => 'alg',
    'altaiclanguage'                                                  => 'tut',
    'ancientegyptian'                                                 => 'egy',
    'ancientgreek'                                                    => 'grc',
    'angika'                                                          => 'anp',
    'apachelanguage'                                                  => 'apa',
    'aragonese'                                                       => 'an',
    'aramaic'                                                         => 'arc',
    'arapaho'                                                         => 'arp',
    'araucanian'                                                      => 'arn',
    'arawak'                                                          => 'arw',
    'armenian'                                                        => 'hy',
    'aromanian'                                                       => 'rup',
    'artificiallanguage'                                              => 'art',
    'asturian'                                                        => 'ast',
    'asu'                                                             => 'asa',
    'athapascanlanguage'                                              => 'ath',
    'atsam'                                                           => 'cch',
    'australianenglish'                                               => 'en_au',
    'australianlanguage'                                              => 'aus',
    'austriangerman'                                                  => 'de_at',
    'austronesianlanguage'                                            => 'map',
    'avaric'                                                          => 'av',
    'avestan'                                                         => 'ae',
    'awadhi'                                                          => 'awa',
    'aymara'                                                          => 'ay',
    'bafia'                                                           => 'ksf',
    'balinese'                                                        => 'ban',
    'balticlanguage'                                                  => 'bat',
    'baluchi'                                                         => 'bal',
    'bambara'                                                         => 'bm',
    'bamilekelanguage'                                                => 'bai',
    'banda'                                                           => 'bad',
    'bantu'                                                           => 'bnt',
    'basaa'                                                           => 'bas',
    'bashkir'                                                         => 'ba',
    'batak'                                                           => 'btk',
    'beja'                                                            => 'bej',
    'bemba'                                                           => 'bem',
    'bena'                                                            => 'bez',
    'berber'                                                          => 'ber',
    'bhojpuri'                                                        => 'bho',
    'bikol'                                                           => 'bik',
    'bini'                                                            => 'bin',
    'bislama'                                                         => 'bi',
    'blin'                                                            => 'byn',
    'blissymbols'                                                     => 'zbl',
    'bodo'                                                            => 'brx',
    'braj'                                                            => 'bra',
    'breton'                                                          => 'br',
    'britishenglish'                                                  => 'en_gb',
    'buginese'                                                        => 'bug',
    'buriat'                                                          => 'bua',
    'burmese'                                                         => 'my',
    'caddo'                                                           => 'cad',
    'canadianenglish'                                                 => 'en_ca',
    'canadianfrench'                                                  => 'fr_ca',
    'cantonese'                                                       => 'yue',
    'carib'                                                           => 'car',
    'caucasianlanguage'                                               => 'cau',
    'cayuga'                                                          => 'cay',
    'cebuano'                                                         => 'ceb',
    'celticlanguage'                                                  => 'cel',
    'centralamericanindianlanguage'                                   => 'cai',
    'centralmoroccotamazight'                                         => 'tzm',
    'chagatai'                                                        => 'chg',
    'chamiclanguage'                                                  => 'cmc',
    'chamorro'                                                        => 'ch',
    'chechen'                                                         => 'ce',
    'cherokee'                                                        => 'chr',
    'cheyenne'                                                        => 'chy',
    'chibcha'                                                         => 'chb',
    'chiga'                                                           => 'cgg',
    'chinookjargon'                                                   => 'chn',
    'chipewyan'                                                       => 'chp',
    'choctaw'                                                         => 'cho',
    'churchslavic'                                                    => 'cu',
    'chuukese'                                                        => 'chk',
    'chuvash'                                                         => 'cv',
    'classicalnewari'                                                 => 'nwc',
    'classicalsyriac'                                                 => 'syc',
    'colognian'                                                       => 'ksh',
    'comorian'                                                        => 'swb',
    'congoswahili'                                                    => 'swc',
    'coptic'                                                          => 'cop',
    'cornish'                                                         => 'kw',
    'corsican'                                                        => 'co',
    'cree'                                                            => 'cr',
    'creek'                                                           => 'mus',
    'creoleorpidgin'                                                  => 'crp',
    'crimeanturkish'                                                  => 'crh',
    'cushiticlanguage'                                                => 'cus',
    'dakota'                                                          => 'dak',
    'dargwa'                                                          => 'dar',
    'dayak'                                                           => 'day',
    'delaware'                                                        => 'del',
    'dinka'                                                           => 'din',
    'divehi'                                                          => 'dv',
    'dogri'                                                           => 'doi',
    'dogrib'                                                          => 'dgr',
    'dravidianlanguage'                                               => 'dra',
    'duala'                                                           => 'dua',
    'dyula'                                                           => 'dyu',
    'dzongkha'                                                        => 'dz',
    'easternfrisian'                                                  => 'frs',
    'efik'                                                            => 'efi',
    'ekajuk'                                                          => 'eka',
    'elamite'                                                         => 'elx',
    'embu'                                                            => 'ebu',
    'englishbasedcreoleorpidgin'                                      => 'cpe',
    'erzya'                                                           => 'myv',
    'ewe'                                                             => 'ee',
    'ewondo'                                                          => 'ewo',
    'fang'                                                            => 'fan',
    'fanti'                                                           => 'fat',
    'fijian'                                                          => 'fj',
    'finnougrianlanguage'                                             => 'fiu',
    'flemish'                                                         => 'nl_be',
    'fon'                                                             => 'fon',
    'frenchbasedcreoleorpidgin'                                       => 'cpf',
    'friulian'                                                        => 'fur',
    'fulah'                                                           => 'ff',
    'ga'                                                              => 'gaa',
    'ganda'                                                           => 'lg',
    'gayo'                                                            => 'gay',
    'gbaya'                                                           => 'gba',
    'geez'                                                            => 'gez',
    'germaniclanguage'                                                => 'gem',
    'gilbertese'                                                      => 'gil',
    'gondi'                                                           => 'gon',
    'gorontalo'                                                       => 'gor',
    'gothic'                                                          => 'got',
    'grebo'                                                           => 'grb',
    'guarani'                                                         => 'gn',
    'gusii'                                                           => 'guz',
    "gwich\Ê\¼in"                                                   => 'gwi',
    'haida'                                                           => 'hai',
    'haitian'                                                         => 'ht',
    'hausa'                                                           => 'ha',
    'hawaiian'                                                        => 'haw',
    'herero'                                                          => 'hz',
    'hiligaynon'                                                      => 'hil',
    'himachali'                                                       => 'him',
    'hirimotu'                                                        => 'ho',
    'hittite'                                                         => 'hit',
    'hmong'                                                           => 'hmn',
    'hupa'                                                            => 'hup',
    'iban'                                                            => 'iba',
    'iberianspanish'                                                  => 'es_es',
    'ido'                                                             => 'io',
    'igbo'                                                            => 'ig',
    'ijo'                                                             => 'ijo',
    'iloko'                                                           => 'ilo',
    'inarisami'                                                       => 'smn',
    'indiclanguage'                                                   => 'inc',
    'indoeuropeanlanguage'                                            => 'ine',
    'ingush'                                                          => 'inh',
    'inuktitut'                                                       => 'iu',
    'inupiaq'                                                         => 'ik',
    'iranianlanguage'                                                 => 'ira',
    'iroquoianlanguage'                                               => 'iro',
    'jju'                                                             => 'kaj',
    'jolafonyi'                                                       => 'dyo',
    'judeoarabic'                                                     => 'jrb',
    'judeopersian'                                                    => 'jpr',
    'kabardian'                                                       => 'kbd',
    'kabuverdianu'                                                    => 'kea',
    'kabyle'                                                          => 'kab',
    'kachin'                                                          => 'kac',
    'kalaallisut'                                                     => 'kl',
    'kalenjin'                                                        => 'kln',
    'kalmyk'                                                          => 'xal',
    'kamba'                                                           => 'kam',
    'kanuri'                                                          => 'kr',
    'karachaybalkar'                                                  => 'krc',
    'karakalpak'                                                      => 'kaa',
    'karelian'                                                        => 'krl',
    'karen'                                                           => 'kar',
    'kashmiri'                                                        => 'ks',
    'kashubian'                                                       => 'csb',
    'kawi'                                                            => 'kaw',
    'kazakh'                                                          => 'kk',
    'khasi'                                                           => 'kha',
    'khoisanlanguage'                                                 => 'khi',
    'khotanese'                                                       => 'kho',
    'kikuyu'                                                          => 'ki',
    'kimbundu'                                                        => 'kmb',
    'kinyarwanda'                                                     => 'rw',
    'kirghiz'                                                         => 'ky',
    'komi'                                                            => 'kv',
    'kongo'                                                           => 'kg',
    'konkani'                                                         => 'kok',
    'koro'                                                            => 'kfo',
    'kosraean'                                                        => 'kos',
    'koyraborosenni'                                                  => 'ses',
    'koyrachiini'                                                     => 'khq',
    'kpelle'                                                          => 'kpe',
    'kru'                                                             => 'kro',
    'kuanyama'                                                        => 'kj',
    'kumyk'                                                           => 'kum',
    'kurukh'                                                          => 'kru',
    'kutenai'                                                         => 'kut',
    'kwasio'                                                          => 'nmg',
    'ladino'                                                          => 'lad',
    'lahnda'                                                          => 'lah',
    'lamba'                                                           => 'lam',
    'langi'                                                           => 'lag',
    'lezghian'                                                        => 'lez',
    'limburgish'                                                      => 'li',
    'lojban'                                                          => 'jbo',
    'lowersorbian'                                                    => 'dsb',
    'lowgerman'                                                       => 'nds',
    'lozi'                                                            => 'loz',
    'lubakatanga'                                                     => 'lu',
    'lubalulua'                                                       => 'lua',
    'luiseno'                                                         => 'lui',
    'lulesami'                                                        => 'smj',
    'lunda'                                                           => 'lun',
    'luo'                                                             => 'luo',
    'lushai'                                                          => 'lus',
    'luxembourgish'                                                   => 'lb',
    'luyia'                                                           => 'luy',
    'machame'                                                         => 'jmc',
    'madurese'                                                        => 'mad',
    'magahi'                                                          => 'mag',
    'maithili'                                                        => 'mai',
    'makasar'                                                         => 'mak',
    'makhuwameetto'                                                   => 'mgh',
    'makonde'                                                         => 'kde',
    'malagasy'                                                        => 'mg',
    'manchu'                                                          => 'mnc',
    'mandar'                                                          => 'mdr',
    'mandingo'                                                        => 'man',
    'manipuri'                                                        => 'mni',
    'manobolanguage'                                                  => 'mno',
    'manx'                                                            => 'gv',
    'maori'                                                           => 'mi',
    'mari'                                                            => 'chm',
    'marshallese'                                                     => 'mh',
    'marwari'                                                         => 'mwr',
    'masai'                                                           => 'mas',
    'mayanlanguage'                                                   => 'myn',
    'mende'                                                           => 'men',
    'meru'                                                            => 'mer',
    'micmac'                                                          => 'mic',
    'middledutch'                                                     => 'dum',
    'middleenglish'                                                   => 'enm',
    'middlefrench'                                                    => 'frm',
    'middlehighgerman'                                                => 'gmh',
    'middleirish'                                                     => 'mga',
    'minangkabau'                                                     => 'min',
    'mirandese'                                                       => 'mwl',
    'miscellaneouslanguage'                                           => 'mis',
    'mohawk'                                                          => 'moh',
    'moksha'                                                          => 'mdf',
    'moldavian'                                                       => 'mo',
    'mongo'                                                           => 'lol',
    'monkhmerlanguage'                                                => 'mkh',
    'morisyen'                                                        => 'mfe',
    'mossi'                                                           => 'mos',
    'multiplelanguages'                                               => 'mul',
    'mundalanguage'                                                   => 'mun',
    'mundang'                                                         => 'mua',
    'nahuatl'                                                         => 'nah',
    'nama'                                                            => 'naq',
    'nauru'                                                           => 'na',
    'navajo'                                                          => 'nv',
    'ndonga'                                                          => 'ng',
    'neapolitan'                                                      => 'nap',
    'newari'                                                          => 'new',
    'nias'                                                            => 'nia',
    'nigerkordofanianlanguage'                                        => 'nic',
    'nilosaharanlanguage'                                             => 'ssa',
    'niuean'                                                          => 'niu',
    'nogai'                                                           => 'nog',
    'nolinguisticcontent'                                             => 'zxx',
    'northamericanindianlanguage'                                     => 'nai',
    'northernfrisian'                                                 => 'frr',
    'northernsami'                                                    => 'se',
    'northernsotho'                                                   => 'nso',
    'northndebele'                                                    => 'nd',
    "norwegianbokm\Ã\¥l"                                            => 'nb',
    'norwegiannynorsk'                                                => 'nn',
    'nubianlanguage'                                                  => 'nub',
    'nuer'                                                            => 'nus',
    'nyamwezi'                                                        => 'nym',
    'nyanja'                                                          => 'ny',
    'nyankole'                                                        => 'nyn',
    'nyasatonga'                                                      => 'tog',
    'nyoro'                                                           => 'nyo',
    'nzima'                                                           => 'nzi',
    "n\â\\ko"                                                    => 'nqo',
    'ojibwa'                                                          => 'oj',
    'oldenglish'                                                      => 'ang',
    'oldfrench'                                                       => 'fro',
    'oldhighgerman'                                                   => 'goh',
    'oldirish'                                                        => 'sga',
    'oldnorse'                                                        => 'non',
    'oldpersian'                                                      => 'peo',
    "oldproven\Ã\§al"                                               => 'pro',
    'oromo'                                                           => 'om',
    'osage'                                                           => 'osa',
    'ossetic'                                                         => 'os',
    'otomianlanguage'                                                 => 'oto',
    'ottomanturkish'                                                  => 'ota',
    'pahlavi'                                                         => 'pal',
    'palauan'                                                         => 'pau',
    'pali'                                                            => 'pi',
    'pampanga'                                                        => 'pam',
    'pangasinan'                                                      => 'pag',
    'papiamento'                                                      => 'pap',
    'papuanlanguage'                                                  => 'paa',
    'philippinelanguage'                                              => 'phi',
    'phoenician'                                                      => 'phn',
    'pohnpeian'                                                       => 'pon',
    'portuguesebasedcreoleorpidgin'                                   => 'cpp',
    'prakritlanguage'                                                 => 'pra',
    'quechua'                                                         => 'qu',
    'rajasthani'                                                      => 'raj',
    'rapanui'                                                         => 'rap',
    'rarotongan'                                                      => 'rar',
    'romancelanguage'                                                 => 'roa',
    'romansh'                                                         => 'rm',
    'romany'                                                          => 'rom',
    'rombo'                                                           => 'rof',
    'rundi'                                                           => 'rn',
    'rwa'                                                             => 'rwk',
    'saho'                                                            => 'ssy',
    'sakha'                                                           => 'sah',
    'salishanlanguage'                                                => 'sal',
    'samaritanaramaic'                                                => 'sam',
    'samburu'                                                         => 'saq',
    'samilanguage'                                                    => 'smi',
    'samoan'                                                          => 'sm',
    'sandawe'                                                         => 'sad',
    'sango'                                                           => 'sg',
    'sangu'                                                           => 'sbp',
    'santali'                                                         => 'sat',
    'sardinian'                                                       => 'sc',
    'sasak'                                                           => 'sas',
    'scots'                                                           => 'sco',
    'selkup'                                                          => 'sel',
    'semiticlanguage'                                                 => 'sem',
    'sena'                                                            => 'seh',
    'seneca'                                                          => 'see',
    'serbocroatian'                                                   => 'sh',
    'serer'                                                           => 'srr',
    'shambala'                                                        => 'ksb',
    'shan'                                                            => 'shn',
    'shona'                                                           => 'sn',
    'sichuanyi'                                                       => 'ii',
    'sicilian'                                                        => 'scn',
    'sidamo'                                                          => 'sid',
    'signlanguage'                                                    => 'sgn',
    'siksika'                                                         => 'bla',
    'sindhi'                                                          => 'sd',
    'sinotibetanlanguage'                                             => 'sit',
    'siouanlanguage'                                                  => 'sio',
    'skoltsami'                                                       => 'sms',
    'slave'                                                           => 'den',
    'slaviclanguage'                                                  => 'sla',
    'soga'                                                            => 'xog',
    'sogdien'                                                         => 'sog',
    'songhai'                                                         => 'son',
    'soninke'                                                         => 'snk',
    'sorbianlanguage'                                                 => 'wen',
    'southamericanindianlanguage'                                     => 'sai',
    'southernaltai'                                                   => 'alt',
    'southernsami'                                                    => 'sma',
    'southernsotho'                                                   => 'st',
    'southndebele'                                                    => 'nr',
    'sranantongo'                                                     => 'srn',
    'sukuma'                                                          => 'suk',
    'sumerian'                                                        => 'sux',
    'susu'                                                            => 'sus',
    'swati'                                                           => 'ss',
    'swissfrench'                                                     => 'fr_ch',
    'swissgerman'                                                     => 'gsw',
    'swisshighgerman'                                                 => 'de_ch',
    'syriac'                                                          => 'syr',
    'tachelhit'                                                       => 'shi',
    'tagalog'                                                         => 'tl',
    'tahitian'                                                        => 'ty',
    'tailanguage'                                                     => 'tai',
    'taita'                                                           => 'dav',
    'tajik'                                                           => 'tg',
    'tamashek'                                                        => 'tmh',
    'taroko'                                                          => 'trv',
    'tasawaq'                                                         => 'twq',
    'tatar'                                                           => 'tt',
    'tereno'                                                          => 'ter',
    'teso'                                                            => 'teo',
    'tetum'                                                           => 'tet',
    'tibetan'                                                         => 'bo',
    'tigre'                                                           => 'tig',
    'timne'                                                           => 'tem',
    'tiv'                                                             => 'tiv',
    'tlingit'                                                         => 'tli',
    'tokelau'                                                         => 'tkl',
    'tokpisin'                                                        => 'tpi',
    'tonga'                                                           => 'to',
    'tsimshian'                                                       => 'tsi',
    'tsonga'                                                          => 'ts',
    'tswana'                                                          => 'tn',
    'tumbuka'                                                         => 'tum',
    'tupilanguage'                                                    => 'tup',
    'turkmen'                                                         => 'tk',
    'tuvalu'                                                          => 'tvl',
    'tuvinian'                                                        => 'tyv',
    'twi'                                                             => 'tw',
    'tyap'                                                            => 'kcg',
    "u\.s\.english"                                                   => 'en_us',
    'udmurt'                                                          => 'udm',
    'ugaritic'                                                        => 'uga',
    'umbundu'                                                         => 'umb',
    'unknownlanguage'                                                 => 'und',
    'uppersorbian'                                                    => 'hsb',
    'uyghur'                                                          => 'ug',
    'vai'                                                             => 'vai',
    'venda'                                                           => 've',
    "volap\Ã\¼k"                                                    => 'vo',
    'votic'                                                           => 'vot',
    'vunjo'                                                           => 'vun',
    'wakashanlanguage'                                                => 'wak',
    'walamo'                                                          => 'wal',
    'walloon'                                                         => 'wa',
    'walser'                                                          => 'wae',
    'waray'                                                           => 'war',
    'washo'                                                           => 'was',
    'wolof'                                                           => 'wo',
    'yangben'                                                         => 'yav',
    'yao'                                                             => 'yao',
    'yapese'                                                          => 'yap',
    'yoruba'                                                          => 'yo',
    'yupiklanguage'                                                   => 'ypk',
    'zande'                                                           => 'znd',
    'zapotec'                                                         => 'zap',
    'zarma'                                                           => 'dje',
    'zaza'                                                            => 'zza',
    'zenaga'                                                          => 'zen',
    'zhuang'                                                          => 'za',
    'zuni'                                                            => 'zun',
    'अँग्रेजी'                                        => 'en',
    'अक्सिटन'                                           => 'oc',
    'अजरबैजानी'                                     => 'az',
    'अन्तरभाषी'                                     => 'ie',
    'अफ्रिकाली'                                     => 'af',
    'अम्हारिक'                                        => 'am',
    'अरबी'                                                    => 'ar',
    'अल्बेनियन'                                     => 'sq',
    "आइबेरी\,पर्तुगाली"                 => 'pt_pt',
    'आइरिश'                                                 => 'ga',
    'आइसल्यान्डिक'                            => 'is',
    'आसामी'                                                 => 'as',
    'इटालियन'                                           => 'it',
    'इन्टर्लिङ्गुआ'                         => 'ia',
    'इन्डोनेसियाली'                         => 'id',
    'इस्टोनियाली'                               => 'et',
    'उज़्बेक'                                           => 'uz',
    'उर्दु'                                                 => 'ur',
    'एस्पेरान्तो'                               => 'eo',
    'ओरिया'                                                 => 'or',
    'कन्नाडा'                                           => 'kn',
    'कम्बोडीयाली'                               => 'km',
    'कुर्दिश'                                           => 'ku',
    'कोरियाली'                                        => 'ko',
    'क्याटालन'                                        => 'ca',
    'क्रोएसियाली'                               => 'hr',
    'क्लिङ्गन'                                        => 'tlh',
    'गलिसियाली'                                     => 'gl',
    'गुजराती'                                           => 'gu',
    'ग्रीक'                                                 => 'el',
    'चिनियाँ'                                           => 'zh',
    'चेकोस्लोभाकियाली'                => 'cs',
    'जर्मन'                                                 => 'de',
    'जापानी'                                              => 'ja',
    'जाभानिज'                                           => 'jv',
    'जुलू'                                                    => 'zu',
    'जोरजियन'                                           => 'ka',
    'झोसा'                                                    => 'xh',
    'टर्की'                                                 => 'tr',
    'डच'                                                          => 'nl',
    'ड्यानिश'                                           => 'da',
    'तामिल'                                                 => 'ta',
    'तिग्रीन्या'                                  => 'ti',
    'तेलुगु'                                              => 'te',
    'थाई'                                                       => 'th',
    'नर्वेजियाली'                               => 'no',
    'नेपाली'                                              => 'ne',
    'पंजाबी'                                              => 'pa',
    'पर्तुगालीब्राजिल्याली' => 'pt_br',
    'पाश्तो'                                              => 'ps',
    'पोर्तुगाली'                                  => 'pt',
    'पोलिश'                                                 => 'pl',
    'फारसी'                                                 => 'fa',
    'फारोइज'                                              => 'fo',
    'फिनिश'                                                 => 'fi',
    'फिलिपिनी'                                        => 'fil',
    'फ्रांसेली'                                     => 'fr',
    'फ्रिजीयन'                                        => 'fy',
    'बंगाली'                                              => 'bn',
    'बास्क'                                                 => 'eu',
    'बिहारी'                                              => 'bh',
    'बुल्गेरियाली'                            => 'bg',
    'बेलारुसियाली'                            => 'be',
    'बोस्नियाली'                                  => 'bs',
    'भियतनामी'                                        => 'vi',
    'मंगोल'                                                 => 'mn',
    'मराठी'                                                 => 'mr',
    'मलयालम'                                              => 'ml',
    'मलाया'                                                 => 'ms',
    'माल्टिज'                                           => 'mt',
    'म्याकेडोनियन'                            => 'mk',
    'यिद्दिस'                                           => 'yi',
    'युक्रेनी'                                        => 'uk',
    'रसियाली'                                           => 'ru',
    'रोमानियाली'                                  => 'ro',
    'लाओ'                                                       => 'lo',
    'लात्भियाली'                                  => 'lv',
    'लिंगाला'                                           => 'ln',
    'लिथुआनियाली'                               => 'lt',
    'ल्याटिन'                                           => 'la',
    'वेल्श'                                                 => 'cy',
    'संस्कृत'                                           => 'sa',
    'सर्बियाली'                                     => 'sr',
    'सिन्हाली'                                        => 'si',
    'सुडानी'                                              => 'su',
    'सोमाली'                                              => 'so',
    'स्कट्सगाएलिक'                            => 'gd',
    'स्प्यानिश'                                     => 'es',
    'स्लोभाकियाली'                            => 'sk',
    'स्लोभेनियाली'                            => 'sl',
    'स्वाहिली'                                        => 'sw',
    'स्विडिश'                                           => 'sv',
    'हंग्रीयाली'                                  => 'hu',
    'हिन्दी'                                              => 'hi',
    'हिब्रु'                                              => 'he',
);

1;
