package Locales::DB::Language::is;

# Auto generated from CLDR

$Locales::DB::Language::is::VERSION = '0.07';

$Locales::DB::Language::is::cldr_version = '2.0';

%Locales::DB::Language::is::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "tungumál\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ og\ \{1\}",
            'end'    => "\{0\}\ og\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "svæði\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '‘',
        'alternate_quotation_start' => '‚',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => ["nn\ sv\ nb\ da\ en"],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr' => {
            'content' => "nei\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "já\:j",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::is::code_to_name = (
    'aa'    => 'afár',
    'ab'    => 'abkasíska',
    'ace'   => 'akkíska',
    'ach'   => 'akólí',
    'ada'   => 'adangme',
    'ady'   => 'adýge',
    'ae'    => 'avestíska',
    'af'    => 'afríkanska',
    'afa'   => "afróasísk\ mál\ \(önnur\)",
    'afh'   => 'afríhílí',
    'agq'   => 'Aghem',
    'ain'   => "aínu\ \(Japan\)",
    'ak'    => 'akan',
    'akk'   => 'akkadíska',
    'ale'   => 'aleúska',
    'alg'   => "algonkvínsk\ mál",
    'alt'   => 'suðuraltaíska',
    'am'    => 'amharíska',
    'an'    => 'aragonska',
    'ang'   => "fornenska\ \(um\ 450\-1100\)",
    'anp'   => 'angíka',
    'apa'   => 'apatsjamál',
    'ar'    => 'arabíska',
    'arc'   => 'arameíska',
    'arn'   => 'arákaníska',
    'arp'   => 'arapahó',
    'art'   => "alþjóðamál\ \(önnur\)",
    'arw'   => 'aravakska',
    'as'    => 'assamska',
    'asa'   => "asu\ \(Tanzania\)",
    'ast'   => 'astúríska',
    'ath'   => "atapaskísk\ mál",
    'aus'   => "áströlsk\ mál",
    'av'    => 'avaríska',
    'awa'   => 'avadí',
    'ay'    => 'aímara',
    'az'    => 'azeri',
    'ba'    => 'baskír',
    'bad'   => 'banda',
    'bai'   => 'bamílekemál',
    'bal'   => 'balúkí',
    'ban'   => 'balíska',
    'bas'   => 'basa',
    'bat'   => "baltnesk\ mál\ \(önnur\)",
    'be'    => 'hvítrússneska',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berbamál',
    'bez'   => "bena\ \(Tanzania\)",
    'bg'    => 'búlgarska',
    'bh'    => 'bíharí',
    'bho'   => 'bojpúrí',
    'bi'    => 'bíslama',
    'bik'   => 'bíkol',
    'bin'   => 'bíní',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalska',
    'bnt'   => 'bantúmál',
    'bo'    => 'tíbeska',
    'br'    => 'bretónska',
    'bra'   => 'braí',
    'brx'   => 'Bodo',
    'bs'    => 'bosníska',
    'btk'   => 'batak',
    'bua'   => 'búríat',
    'bug'   => 'búgíska',
    'byn'   => 'blín',
    'ca'    => 'katalónska',
    'cad'   => 'kaddó',
    'cai'   => "indíánamál\ mið\-ameríku\ \(önnur\)",
    'car'   => 'karíbamál',
    'cau'   => "kákasusmál\ \(önnur\)",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'tsjetsjenska',
    'ceb'   => 'kebúanó',
    'cel'   => "keltnesk\ \(önnur\)",
    'cgg'   => 'Chiga',
    'ch'    => 'kamorró',
    'chb'   => 'síbsja',
    'chg'   => 'sjagataí',
    'chk'   => 'sjúkíska',
    'chm'   => 'marí',
    'chn'   => 'sínúk',
    'cho'   => 'sjoktá',
    'chp'   => 'sípevíska',
    'chr'   => 'sjerókí',
    'chy'   => 'sjeyen',
    'cmc'   => "kamísk\ mál",
    'co'    => 'korsíska',
    'cop'   => 'koptíska',
    'cpe'   => "kreól\-\ og\ pidginmál\ á\ enskum\ grunni",
    'cpf'   => "kreól\-\ og\ pidginmál\ á\ frönskum\ grunni",
    'cpp'   => "kreól\-\ og\ pidginmál\ á\ portúgölskum\ grunni",
    'cr'    => 'krí',
    'crh'   => 'krímtyrkneska',
    'crp'   => "kreól\-\ og\ pidginmál\ \(önnur\)",
    'cs'    => 'tékkneska',
    'csb'   => 'kasúbíska',
    'cu'    => 'kirkjuslavneska',
    'cus'   => "kúsitísk\ mál\ \(önnur\)",
    'cv'    => 'sjúvas',
    'cy'    => 'velska',
    'da'    => 'danska',
    'dak'   => 'dakóta',
    'dar'   => 'dargva',
    'dav'   => 'Taita',
    'day'   => 'dajak',
    'de'    => 'þýska',
    'de_at' => "austurrísk\ þýska",
    'de_ch' => "svissnesk\ háþýska",
    'del'   => 'delaver',
    'den'   => 'slavneska',
    'dgr'   => 'dogríb',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogrí',
    'dra'   => "dravidísk\ mál\ \(önnur\)",
    'dsb'   => 'lágsorbneska',
    'dua'   => 'dúala',
    'dum'   => "miðhollenska\ \(um\ 1050\-1350\)",
    'dv'    => 'dívehí',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'djúla',
    'dz'    => 'dsongka',
    'ebu'   => 'Embu',
    'ee'    => 'eve',
    'efi'   => 'efík',
    'egy'   => 'fornegypska',
    'eka'   => 'ekajúk',
    'el'    => "nýgríska\ \(1453\-\)",
    'elx'   => 'elamít',
    'en'    => 'enska',
    'en_au' => "áströlsk\ enska",
    'en_ca' => "kanadísk\ enska",
    'en_gb' => "bresk\ enska",
    'en_us' => "bandarísk\ enska",
    'enm'   => "miðenska\ \(1100\-1500\)",
    'eo'    => 'esperantó',
    'es'    => 'spænska',
    'es_es' => "íberísk\ spænska",
    'et'    => 'eistneska',
    'eu'    => 'baskneska',
    'ewo'   => 'evondó',
    'fa'    => 'persneska',
    'fan'   => 'fang',
    'fat'   => 'fantí',
    'ff'    => 'fúla',
    'fi'    => 'finnska',
    'fil'   => 'filipínska',
    'fiu'   => "finnskúgrísk\ mál\ \(önnur\)",
    'fj'    => 'fídjeyska',
    'fo'    => 'færeyska',
    'fon'   => 'fón',
    'fr'    => 'franska',
    'fr_ca' => "kanadísk\ franska",
    'fr_ch' => "svissnesk\ franska",
    'frm'   => "miðfranska\ \(um\ 1400\-1600\)",
    'fro'   => "fornfranska\ \(842\ \-\ um\ 1400\)",
    'frr'   => 'norðurfrísneska',
    'frs'   => 'austurfrísneska',
    'fur'   => 'fríúlska',
    'fy'    => 'frísneska',
    'ga'    => 'írska',
    'gaa'   => 'ga',
    'gay'   => 'gajó',
    'gba'   => 'gbaja',
    'gd'    => "skosk\ gelíska",
    'gem'   => "germönsk\ mál\ \(önnur\)",
    'gez'   => 'gís',
    'gil'   => 'gilberska',
    'gl'    => 'gallegska',
    'gmh'   => "miðháþýska\ \(um\ 1050\-1500",
    'gn'    => 'gvaraní',
    'goh'   => "fornháþýska\ \(um\ 750\-1050\)",
    'gon'   => 'gondí',
    'gor'   => 'gorontaló',
    'got'   => 'gotneska',
    'grb'   => 'gerbó',
    'grc'   => "forngríska\ \(til\ 1453\)",
    'gsw'   => "svissnesk\ þýska",
    'gu'    => 'gújaratí',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => 'gvísín',
    'ha'    => 'hása',
    'hai'   => 'haída',
    'haw'   => 'havaíska',
    'he'    => 'hebreska',
    'hi'    => 'hindí',
    'hil'   => 'híligaínon',
    'him'   => 'hímasjalí',
    'hit'   => 'hettitíska',
    'hmn'   => 'hmong',
    'ho'    => 'hírímótú',
    'hr'    => 'króatíska',
    'hsb'   => 'hásorbneska',
    'ht'    => 'haítíska',
    'hu'    => 'ungverska',
    'hup'   => 'húpa',
    'hy'    => 'armenska',
    'hz'    => 'hereró',
    'ia'    => 'interlingva',
    'iba'   => 'íban',
    'id'    => 'indónesíska',
    'ie'    => 'interlingve',
    'ig'    => 'ígbó',
    'ii'    => 'sísúanjí',
    'ijo'   => 'íjó',
    'ik'    => 'ínúpíak',
    'ilo'   => 'ílokó',
    'inc'   => "indversk\ mál\ \(önnur\)",
    'ine'   => "indóevrópsk\ mál\ \(önnur\)",
    'inh'   => 'ingús',
    'io'    => 'ídó',
    'ira'   => 'íranska',
    'iro'   => "írókesk\ mál",
    'is'    => 'íslenska',
    'it'    => 'ítalska',
    'iu'    => 'inúktitút',
    'ja'    => 'japanska',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => 'gyðingapersneska',
    'jrb'   => 'gyðingaarabíska',
    'jv'    => 'javanska',
    'ka'    => 'georgíska',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabíle',
    'kac'   => 'kasín',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kaví',
    'kbd'   => 'kabardíska',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongó',
    'kha'   => 'kasí',
    'khi'   => "koímál\ \(önnur\)",
    'kho'   => 'kotaska',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kíkújú',
    'kj'    => 'kúanjama',
    'kk'    => 'kasakska',
    'kl'    => 'grænlenska',
    'kln'   => 'Kalenjin',
    'km'    => 'kmer',
    'kmb'   => 'kimbúndú',
    'kn'    => 'kannada',
    'ko'    => 'kóreska',
    'kok'   => 'konkaní',
    'kos'   => 'kosraska',
    'kpe'   => 'kpelle',
    'kr'    => 'kanúrí',
    'krc'   => 'karasaíbalkar',
    'krl'   => 'karélska',
    'kro'   => 'krú',
    'kru'   => 'kúrúk',
    'ks'    => 'kasmírska',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kúrdneska',
    'kum'   => 'kúmík',
    'kut'   => 'kútenaí',
    'kv'    => 'komíska',
    'kw'    => 'korníska',
    'ky'    => 'kirgiska',
    'la'    => 'latína',
    'lad'   => 'ladínska',
    'lag'   => 'Langi',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'lúxemborgíska',
    'lez'   => 'lesgíska',
    'lg'    => 'ganda',
    'li'    => 'limbúrgíska',
    'ln'    => 'lingala',
    'lo'    => 'laó',
    'lol'   => 'mongó',
    'loz'   => 'losí',
    'lt'    => 'litháíska',
    'lu'    => 'lúbakatanga',
    'lua'   => 'lúbalúlúa',
    'lui'   => 'lúisenó',
    'lun'   => 'lúnda',
    'luo'   => 'lúó',
    'lus'   => 'lúsaí',
    'luy'   => 'olulujía',
    'lv'    => 'lettneska',
    'mad'   => 'madúrska',
    'mag'   => 'magahí',
    'mai'   => 'maítílí',
    'mak'   => 'makasar',
    'man'   => 'mandingó',
    'map'   => 'ástrónesíska',
    'mas'   => 'masaí',
    'mdf'   => 'moksa',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasíska',
    'mga'   => "miðírska\ \(900\-1200\)",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'marshallska',
    'mi'    => 'maórí',
    'mic'   => 'mikmak',
    'min'   => 'mínangkabá',
    'mis'   => "ýmis\ mál",
    'mk'    => 'makedónska',
    'mkh'   => "monkmermál\ \(önnur\)",
    'ml'    => 'malajalam',
    'mn'    => 'mongólska',
    'mnc'   => 'mansjú',
    'mni'   => 'manípúrí',
    'mno'   => 'manóbómál',
    'mo'    => 'moldóvska',
    'moh'   => 'móhíska',
    'mos'   => 'mossí',
    'mr'    => 'maratí',
    'ms'    => 'malaíska',
    'mt'    => 'maltneska',
    'mua'   => 'Mundang',
    'mul'   => "margvísleg\ mál",
    'mun'   => 'múndamál',
    'mus'   => 'krík',
    'mwl'   => 'mirandesíska',
    'mwr'   => 'marvarí',
    'my'    => 'burmneska',
    'myn'   => 'majamál',
    'myv'   => 'ersja',
    'na'    => 'nárúska',
    'nah'   => 'nahúatl',
    'nai'   => "indíánamál\ norður\-ameríku\ \(önnur\)",
    'nap'   => 'napólíska',
    'naq'   => 'Nama',
    'nb'    => "norskt\ bókmál",
    'nd'    => 'norðurndebele',
    'nds'   => "lágþýska\;\ lágsaxneska",
    'ne'    => 'nepalska',
    'new'   => 'nevarí',
    'ng'    => 'ndonga',
    'nia'   => 'nías',
    'nic'   => "nígerkordófanmál\ \(önnur\)",
    'niu'   => 'níveska',
    'nl'    => 'hollenska',
    'nl_be' => 'flæmska',
    'nmg'   => 'Kwasio',
    'nn'    => 'nýnorska',
    'no'    => 'norska',
    'nog'   => 'nógaí',
    'non'   => 'norræna',
    'nqo'   => 'n’ko',
    'nr'    => 'suðurndebele',
    'nso'   => 'norðursótó',
    'nub'   => "núbísk\ mál",
    'nus'   => 'Nuer',
    'nv'    => 'navahó',
    'nwc'   => "klassísk\ nevaríska",
    'ny'    => "njanja\;\ sísjeva\;\ sjeva",
    'nym'   => 'njamvesí',
    'nyn'   => 'njankóle',
    'nyo'   => 'njóró',
    'nzi'   => 'nsíma',
    'oc'    => "okkitíska\ \(eftir\ 1500\)\;\ próvensalska",
    'oj'    => 'ojibva',
    'om'    => 'órómó',
    'or'    => 'óría',
    'os'    => 'ossetíska',
    'osa'   => 'ósage',
    'ota'   => "tyrkneska\,\ ottóman\ \(1500\-1928\)",
    'oto'   => 'ótommál',
    'pa'    => 'púnjabí',
    'paa'   => "papúsk\ mál\ \(önnur\)",
    'pag'   => 'pangasínmál',
    'pal'   => 'palaví',
    'pam'   => 'pampanga',
    'pap'   => 'papíamentó',
    'pau'   => 'paláska',
    'peo'   => 'fornpersneska',
    'phi'   => "filippseysk\ mál\ \(önnur\)",
    'phn'   => 'fönikíska',
    'pi'    => 'palí',
    'pl'    => 'pólska',
    'pon'   => 'ponpeiska',
    'pra'   => 'prakrítmál',
    'pro'   => "fornpróvensalska\ \(til\ 1500\)",
    'ps'    => 'pushto',
    'pt'    => 'portúgalska',
    'pt_br' => "brasílísk\ portúgalska",
    'pt_pt' => "íberísk\ portúgalska",
    'qu'    => 'kvesjúa',
    'raj'   => 'rajastaní',
    'rap'   => 'rapanúí',
    'rar'   => 'rarótongska',
    'rm'    => 'retórómanska',
    'rn'    => 'rúndí',
    'ro'    => 'rúmenska',
    'roa'   => "rómönsk\ mál\ \(önnur\)",
    'rof'   => 'Rombo',
    'rom'   => 'romaní',
    'ru'    => 'rússneska',
    'rup'   => 'arúmenska',
    'rw'    => 'kínjarvanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskrít',
    'sad'   => 'sandave',
    'sah'   => 'jakút',
    'sai'   => "indíánamál\ suður\-ameríku\ \(önnur\)",
    'sal'   => 'salísmál',
    'sam'   => "samversk\ arameíska",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santalí',
    'sbp'   => 'Sangu',
    'sc'    => 'sardínska',
    'scn'   => 'sikileyska',
    'sco'   => 'skoska',
    'sd'    => 'sindí',
    'se'    => 'norðursamíska',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkúp',
    'sem'   => "semísk\ mál\ \(önnur\)",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sangó',
    'sga'   => "fornírska\ \(til\ 900\)",
    'sgn'   => 'táknmál',
    'sh'    => 'serbókróatíska',
    'shi'   => 'Tachelhit',
    'shn'   => 'sjan',
    'si'    => 'singalesíska',
    'sid'   => 'sídamó',
    'sio'   => 'síúmál',
    'sit'   => "sínótíbesk\ mál",
    'sk'    => 'slóvakíska',
    'sl'    => 'slóvenska',
    'sla'   => "slavnesk\ mál\ \(önnur\)",
    'sm'    => 'samóska',
    'sma'   => 'suðursamíska',
    'smi'   => "samísk\ mál\ \(önnur\)",
    'smj'   => 'lúlesamíska',
    'smn'   => 'enaresamíska',
    'sms'   => 'skoltesamíska',
    'sn'    => 'shóna',
    'snk'   => 'sóninke',
    'so'    => 'sómalska',
    'sog'   => 'sogdíen',
    'son'   => 'songhaí',
    'sq'    => 'albanska',
    'sr'    => 'serbneska',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'svatí',
    'ssa'   => "nílósaharamál\ \(önnur\)",
    'ssy'   => 'Saho',
    'st'    => 'suðursótó',
    'su'    => 'súndanska',
    'suk'   => 'súkúma',
    'sus'   => 'súsú',
    'sux'   => 'súmerska',
    'sv'    => 'sænska',
    'sw'    => 'svahílí',
    'swb'   => 'shimaoríska',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klassísk\ sýrlenska",
    'syr'   => 'sýrlenska',
    'ta'    => 'tamílska',
    'tai'   => "taímál\ \(önnur\)",
    'te'    => 'telúgú',
    'tem'   => 'tímne',
    'teo'   => 'Teso',
    'ter'   => 'terenó',
    'tet'   => 'tetúm',
    'tg'    => 'tadsjikska',
    'th'    => 'taílenska',
    'ti'    => 'tígrinja',
    'tig'   => 'tígre',
    'tiv'   => 'tív',
    'tk'    => 'túrkmenska',
    'tkl'   => 'tókeláska',
    'tl'    => 'tagalog',
    'tlh'   => 'klingónska',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasjek',
    'tn'    => 'tsúana',
    'to'    => "tongverska\ \(tongaeyjar\)",
    'tog'   => "tongverska\ \(nyasa\)",
    'tpi'   => 'tokpisin',
    'tr'    => 'tyrkneska',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimsíska',
    'tt'    => 'tatarska',
    'tum'   => 'túmbúka',
    'tup'   => 'túpímál',
    'tut'   => "altaísk\ mál\ \(önnur\)",
    'tvl'   => 'túvalúska',
    'tw'    => 'tví',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahítíska',
    'tyv'   => 'túvínska',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'údmúrt',
    'ug'    => 'uyghur',
    'uga'   => 'úgarítíska',
    'uk'    => 'úkraínska',
    'umb'   => 'úmbúndú',
    'und'   => "óþekkt\ eða\ ógilt\ tungumál",
    'ur'    => 'úrdú',
    'uz'    => 'úsbekska',
    'vai'   => 'vaí',
    've'    => 'venda',
    'vi'    => 'víetnamska',
    'vo'    => 'volapyk',
    'vot'   => 'votíska',
    'vun'   => 'Vunjo',
    'wa'    => 'vallónska',
    'wae'   => 'Walser',
    'wak'   => 'vakasmál',
    'wal'   => 'valamó',
    'war'   => 'varaí',
    'was'   => 'vasjó',
    'wen'   => "sorbnesk\ mál",
    'wo'    => 'volof',
    'xal'   => 'kalmúkska',
    'xh'    => 'sósa',
    'xog'   => 'Soga',
    'yao'   => 'jaó',
    'yap'   => 'japíska',
    'yav'   => 'Yangben',
    'yi'    => 'jiddíska',
    'yo'    => 'jórúba',
    'ypk'   => "júpísk\ mál",
    'yue'   => 'kantoneska',
    'za'    => 'súang',
    'zap'   => 'sapótek',
    'zbl'   => 'blisstákn',
    'zen'   => 'senaga',
    'zh'    => 'kínverska',
    'znd'   => 'sande',
    'zu'    => 'súlú',
    'zun'   => 'súní',
    'zxx'   => "ekkert\ tungutengt\ efni",
    'zza'   => 'zázáíska',
);

%Locales::DB::Language::is::name_to_code = (
    'abkasíska'                               => 'ab',
    'adangme'                                  => 'ada',
    'adýge'                                   => 'ady',
    'afríhílí'                              => 'afh',
    'afríkanska'                              => 'af',
    'afróasískmálönnur'                    => 'afa',
    'afár'                                    => 'aa',
    'aghem'                                    => 'agq',
    'akan'                                     => 'ak',
    'akkadíska'                               => 'akk',
    'akkíska'                                 => 'ace',
    'akólí'                                  => 'ach',
    'albanska'                                 => 'sq',
    'aleúska'                                 => 'ale',
    'algonkvínskmál'                         => 'alg',
    'altaískmálönnur'                       => 'tut',
    'alþjóðamálönnur'                     => 'art',
    'amharíska'                               => 'am',
    'angíka'                                  => 'anp',
    'apatsjamál'                              => 'apa',
    'arabíska'                                => 'ar',
    'aragonska'                                => 'an',
    'arameíska'                               => 'arc',
    'arapahó'                                 => 'arp',
    'aravakska'                                => 'arw',
    'armenska'                                 => 'hy',
    'arákaníska'                             => 'arn',
    'arúmenska'                               => 'rup',
    'assamska'                                 => 'as',
    'astúríska'                              => 'ast',
    'asutanzania'                              => 'asa',
    'atapaskískmál'                          => 'ath',
    'atsam'                                    => 'cch',
    'austurfrísneska'                         => 'frs',
    'austurrískþýska'                       => 'de_at',
    'avadí'                                   => 'awa',
    'avaríska'                                => 'av',
    'avestíska'                               => 'ae',
    'azeri'                                    => 'az',
    'aímara'                                  => 'ay',
    'aínujapan'                               => 'ain',
    'bafia'                                    => 'ksf',
    'baltneskmálönnur'                       => 'bat',
    'balíska'                                 => 'ban',
    'balúkí'                                 => 'bal',
    'bambara'                                  => 'bm',
    'bamílekemál'                            => 'bai',
    'banda'                                    => 'bad',
    'bandarískenska'                          => 'en_us',
    'bantúmál'                               => 'bnt',
    'basa'                                     => 'bas',
    'baskneska'                                => 'eu',
    'baskír'                                  => 'ba',
    'batak'                                    => 'btk',
    'beja'                                     => 'bej',
    'bemba'                                    => 'bem',
    'benatanzania'                             => 'bez',
    'bengalska'                                => 'bn',
    'berbamál'                                => 'ber',
    'blisstákn'                               => 'zbl',
    'blín'                                    => 'byn',
    'bodo'                                     => 'brx',
    'bojpúrí'                                => 'bho',
    'bosníska'                                => 'bs',
    'brasílískportúgalska'                  => 'pt_br',
    'braí'                                    => 'bra',
    'breskenska'                               => 'en_gb',
    'bretónska'                               => 'br',
    'burmneska'                                => 'my',
    'bíharí'                                 => 'bh',
    'bíkol'                                   => 'bik',
    'bíní'                                   => 'bin',
    'bíslama'                                 => 'bi',
    'búgíska'                                => 'bug',
    'búlgarska'                               => 'bg',
    'búríat'                                 => 'bua',
    'cayuga'                                   => 'cay',
    'centralmoroccotamazight'                  => 'tzm',
    'chiga'                                    => 'cgg',
    'colognian'                                => 'ksh',
    'congoswahili'                             => 'swc',
    'dajak'                                    => 'day',
    'dakóta'                                  => 'dak',
    'danska'                                   => 'da',
    'dargva'                                   => 'dar',
    'delaver'                                  => 'del',
    'dinka'                                    => 'din',
    'djúla'                                   => 'dyu',
    'dogrí'                                   => 'doi',
    'dogríb'                                  => 'dgr',
    'dravidískmálönnur'                     => 'dra',
    'dsongka'                                  => 'dz',
    'dívehí'                                 => 'dv',
    'dúala'                                   => 'dua',
    'efík'                                    => 'efi',
    'eistneska'                                => 'et',
    'ekajúk'                                  => 'eka',
    'ekkerttungutengtefni'                     => 'zxx',
    'elamít'                                  => 'elx',
    'embu'                                     => 'ebu',
    'enaresamíska'                            => 'smn',
    'enska'                                    => 'en',
    'ersja'                                    => 'myv',
    'esperantó'                               => 'eo',
    'eve'                                      => 'ee',
    'evondó'                                  => 'ewo',
    'fang'                                     => 'fan',
    'fantí'                                   => 'fat',
    'filippseyskmálönnur'                    => 'phi',
    'filipínska'                              => 'fil',
    'finnska'                                  => 'fi',
    'finnskúgrískmálönnur'                 => 'fiu',
    'flæmska'                                 => 'nl_be',
    'fornegypska'                              => 'egy',
    'fornenskaum4501100'                       => 'ang',
    'fornfranska842um1400'                     => 'fro',
    'forngrískatil1453'                       => 'grc',
    'fornháþýskaum7501050'                  => 'goh',
    'fornpersneska'                            => 'peo',
    'fornpróvensalskatil1500'                 => 'pro',
    'fornírskatil900'                         => 'sga',
    'franska'                                  => 'fr',
    'frísneska'                               => 'fy',
    'fríúlska'                               => 'fur',
    'færeyska'                                => 'fo',
    'fídjeyska'                               => 'fj',
    'fón'                                     => 'fon',
    'fönikíska'                              => 'phn',
    'fúla'                                    => 'ff',
    'ga'                                       => 'gaa',
    'gajó'                                    => 'gay',
    'gallegska'                                => 'gl',
    'ganda'                                    => 'lg',
    'gbaja'                                    => 'gba',
    'georgíska'                               => 'ka',
    'gerbó'                                   => 'grb',
    'germönskmálönnur'                      => 'gem',
    'gilberska'                                => 'gil',
    'gondí'                                   => 'gon',
    'gorontaló'                               => 'gor',
    'gotneska'                                 => 'got',
    'grænlenska'                              => 'kl',
    'gusii'                                    => 'guz',
    'gvaraní'                                 => 'gn',
    'gvísín'                                 => 'gwi',
    'gyðingaarabíska'                        => 'jrb',
    'gyðingapersneska'                        => 'jpr',
    'gís'                                     => 'gez',
    'gújaratí'                               => 'gu',
    'havaíska'                                => 'haw',
    'haída'                                   => 'hai',
    'haítíska'                               => 'ht',
    'hebreska'                                 => 'he',
    'hereró'                                  => 'hz',
    'hettitíska'                              => 'hit',
    'hindí'                                   => 'hi',
    'hmong'                                    => 'hmn',
    'hollenska'                                => 'nl',
    'hvítrússneska'                          => 'be',
    'hása'                                    => 'ha',
    'hásorbneska'                             => 'hsb',
    'híligaínon'                             => 'hil',
    'hímasjalí'                              => 'him',
    'hírímótú'                             => 'ho',
    'húpa'                                    => 'hup',
    'indverskmálönnur'                       => 'inc',
    'indíánamálmiðameríkuönnur'          => 'cai',
    'indíánamálnorðurameríkuönnur'       => 'nai',
    'indíánamálsuðurameríkuönnur'        => 'sai',
    'indóevrópskmálönnur'                  => 'ine',
    'indónesíska'                            => 'id',
    'ingús'                                   => 'inh',
    'interlingva'                              => 'ia',
    'interlingve'                              => 'ie',
    'inúktitút'                              => 'iu',
    'jakút'                                   => 'sah',
    'japanska'                                 => 'ja',
    'japíska'                                 => 'yap',
    'javanska'                                 => 'jv',
    'jaó'                                     => 'yao',
    'jiddíska'                                => 'yi',
    'jju'                                      => 'kaj',
    'jolafonyi'                                => 'dyo',
    'jórúba'                                 => 'yo',
    'júpískmál'                             => 'ypk',
    'kabardíska'                              => 'kbd',
    'kabuverdianu'                             => 'kea',
    'kabíle'                                  => 'kab',
    'kaddó'                                   => 'cad',
    'kalenjin'                                 => 'kln',
    'kalmúkska'                               => 'xal',
    'kamba'                                    => 'kam',
    'kamorró'                                 => 'ch',
    'kamískmál'                              => 'cmc',
    'kanadískenska'                           => 'en_ca',
    'kanadískfranska'                         => 'fr_ca',
    'kannada'                                  => 'kn',
    'kantoneska'                               => 'yue',
    'kanúrí'                                 => 'kr',
    'karakalpak'                               => 'kaa',
    'karasaíbalkar'                           => 'krc',
    'karen'                                    => 'kar',
    'karélska'                                => 'krl',
    'karíbamál'                              => 'car',
    'kasakska'                                 => 'kk',
    'kasmírska'                               => 'ks',
    'kasí'                                    => 'kha',
    'kasín'                                   => 'kac',
    'kasúbíska'                              => 'csb',
    'katalónska'                              => 'ca',
    'kaví'                                    => 'kaw',
    'kebúanó'                                => 'ceb',
    'keltneskönnur'                           => 'cel',
    'kimbúndú'                               => 'kmb',
    'kirgiska'                                 => 'ky',
    'kirkjuslavneska'                          => 'cu',
    'klassísknevaríska'                      => 'nwc',
    'klassísksýrlenska'                      => 'syc',
    'klingónska'                              => 'tlh',
    'kmer'                                     => 'km',
    'komíska'                                 => 'kv',
    'kongó'                                   => 'kg',
    'konkaní'                                 => 'kok',
    'koptíska'                                => 'cop',
    'korníska'                                => 'kw',
    'koro'                                     => 'kfo',
    'korsíska'                                => 'co',
    'kosraska'                                 => 'kos',
    'kotaska'                                  => 'kho',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'koímálönnur'                           => 'khi',
    'kpelle'                                   => 'kpe',
    'kreólogpidginmáláenskumgrunni'         => 'cpe',
    'kreólogpidginmáláfrönskumgrunni'      => 'cpf',
    'kreólogpidginmáláportúgölskumgrunni' => 'cpp',
    'kreólogpidginmálönnur'                 => 'crp',
    'krí'                                     => 'cr',
    'krík'                                    => 'mus',
    'krímtyrkneska'                           => 'crh',
    'króatíska'                              => 'hr',
    'krú'                                     => 'kro',
    'kvesjúa'                                 => 'qu',
    'kwasio'                                   => 'nmg',
    'kákasusmálönnur'                       => 'cau',
    'kíkújú'                                => 'ki',
    'kínjarvanda'                             => 'rw',
    'kínverska'                               => 'zh',
    'kóreska'                                 => 'ko',
    'kúanjama'                                => 'kj',
    'kúmík'                                  => 'kum',
    'kúrdneska'                               => 'ku',
    'kúrúk'                                  => 'kru',
    'kúsitískmálönnur'                     => 'cus',
    'kútenaí'                                => 'kut',
    'ladínska'                                => 'lad',
    'lamba'                                    => 'lam',
    'landa'                                    => 'lah',
    'langi'                                    => 'lag',
    'latína'                                  => 'la',
    'laó'                                     => 'lo',
    'lesgíska'                                => 'lez',
    'lettneska'                                => 'lv',
    'limbúrgíska'                            => 'li',
    'lingala'                                  => 'ln',
    'litháíska'                              => 'lt',
    'lojban'                                   => 'jbo',
    'losí'                                    => 'loz',
    'lágsorbneska'                            => 'dsb',
    "lágþýska\;lágsaxneska"                => 'nds',
    'lúbakatanga'                             => 'lu',
    'lúbalúlúa'                             => 'lua',
    'lúisenó'                                => 'lui',
    'lúlesamíska'                            => 'smj',
    'lúnda'                                   => 'lun',
    'lúsaí'                                  => 'lus',
    'lúxemborgíska'                          => 'lb',
    'lúó'                                    => 'luo',
    'machame'                                  => 'jmc',
    'madúrska'                                => 'mad',
    'magahí'                                  => 'mag',
    'majamál'                                 => 'myn',
    'makasar'                                  => 'mak',
    'makedónska'                              => 'mk',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malagasíska'                             => 'mg',
    'malajalam'                                => 'ml',
    'malaíska'                                => 'ms',
    'maltneska'                                => 'mt',
    'mandar'                                   => 'mdr',
    'mandingó'                                => 'man',
    'mansjú'                                  => 'mnc',
    'manx'                                     => 'gv',
    'manípúrí'                              => 'mni',
    'manóbómál'                             => 'mno',
    'maratí'                                  => 'mr',
    'margvíslegmál'                          => 'mul',
    'marshallska'                              => 'mh',
    'marvarí'                                 => 'mwr',
    'marí'                                    => 'chm',
    'masaí'                                   => 'mas',
    'maítílí'                               => 'mai',
    'maórí'                                  => 'mi',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'mikmak'                                   => 'mic',
    'mirandesíska'                            => 'mwl',
    'miðenska11001500'                        => 'enm',
    'miðfranskaum14001600'                    => 'frm',
    'miðhollenskaum10501350'                  => 'dum',
    'miðháþýskaum10501500'                 => 'gmh',
    'miðírska9001200'                        => 'mga',
    'moksa'                                    => 'mdf',
    'moldóvska'                               => 'mo',
    'mongó'                                   => 'lol',
    'mongólska'                               => 'mn',
    'monkmermálönnur'                        => 'mkh',
    'morisyen'                                 => 'mfe',
    'mossí'                                   => 'mos',
    'mundang'                                  => 'mua',
    'mínangkabá'                             => 'min',
    'móhíska'                                => 'moh',
    'múndamál'                               => 'mun',
    'nahúatl'                                 => 'nah',
    'nama'                                     => 'naq',
    'napólíska'                              => 'nap',
    'navahó'                                  => 'nv',
    'ndonga'                                   => 'ng',
    'nepalska'                                 => 'ne',
    'nevarí'                                  => 'new',
    'njamvesí'                                => 'nym',
    "njanja\;sísjeva\;sjeva"                  => 'ny',
    'njankóle'                                => 'nyn',
    'njóró'                                  => 'nyo',
    'norræna'                                 => 'non',
    'norska'                                   => 'no',
    'norsktbókmál'                           => 'nb',
    'norðurfrísneska'                        => 'frr',
    'norðurndebele'                           => 'nd',
    'norðursamíska'                          => 'se',
    'norðursótó'                            => 'nso',
    'nsíma'                                   => 'nzi',
    'nuer'                                     => 'nus',
    'nárúska'                                => 'na',
    'nías'                                    => 'nia',
    'nígerkordófanmálönnur'                => 'nic',
    'nílósaharamálönnur'                   => 'ssa',
    'níveska'                                 => 'niu',
    'nógaí'                                  => 'nog',
    'núbískmál'                             => 'nub',
    'nýgríska1453'                           => 'el',
    'nýnorska'                                => 'nn',
    'n’ko'                                   => 'nqo',
    'ojibva'                                   => 'oj',
    "okkitískaeftir1500\;próvensalska"       => 'oc',
    'olulujía'                                => 'luy',
    'ossetíska'                               => 'os',
    'palaví'                                  => 'pal',
    'paláska'                                 => 'pau',
    'palí'                                    => 'pi',
    'pampanga'                                 => 'pam',
    'pangasínmál'                            => 'pag',
    'papíamentó'                             => 'pap',
    'papúskmálönnur'                        => 'paa',
    'persneska'                                => 'fa',
    'ponpeiska'                                => 'pon',
    'portúgalska'                             => 'pt',
    'prakrítmál'                             => 'pra',
    'pushto'                                   => 'ps',
    'pólska'                                  => 'pl',
    'púnjabí'                                => 'pa',
    'rajastaní'                               => 'raj',
    'rapanúí'                                => 'rap',
    'rarótongska'                             => 'rar',
    'retórómanska'                           => 'rm',
    'romaní'                                  => 'rom',
    'rombo'                                    => 'rof',
    'rwa'                                      => 'rwk',
    'rómönskmálönnur'                      => 'roa',
    'rúmenska'                                => 'ro',
    'rúndí'                                  => 'rn',
    'rússneska'                               => 'ru',
    'saho'                                     => 'ssy',
    'salísmál'                               => 'sal',
    'samburu'                                  => 'saq',
    'samverskarameíska'                       => 'sam',
    'samískmálönnur'                        => 'smi',
    'samóska'                                 => 'sm',
    'sandave'                                  => 'sad',
    'sande'                                    => 'znd',
    'sangu'                                    => 'sbp',
    'sangó'                                   => 'sg',
    'sanskrít'                                => 'sa',
    'santalí'                                 => 'sat',
    'sapótek'                                 => 'zap',
    'sardínska'                               => 'sc',
    'sasak'                                    => 'sas',
    'selkúp'                                  => 'sel',
    'semískmálönnur'                        => 'sem',
    'sena'                                     => 'seh',
    'senaga'                                   => 'zen',
    'seneca'                                   => 'see',
    'serbneska'                                => 'sr',
    'serbókróatíska'                        => 'sh',
    'serer'                                    => 'srr',
    'shambala'                                 => 'ksb',
    'shimaoríska'                             => 'swb',
    'shóna'                                   => 'sn',
    'sikileyska'                               => 'scn',
    'siksika'                                  => 'bla',
    'sindí'                                   => 'sd',
    'singalesíska'                            => 'si',
    'sjagataí'                                => 'chg',
    'sjan'                                     => 'shn',
    'sjerókí'                                => 'chr',
    'sjeyen'                                   => 'chy',
    'sjoktá'                                  => 'cho',
    'sjúkíska'                               => 'chk',
    'sjúvas'                                  => 'cv',
    'skoltesamíska'                           => 'sms',
    'skoska'                                   => 'sco',
    'skoskgelíska'                            => 'gd',
    'slavneska'                                => 'den',
    'slavneskmálönnur'                       => 'sla',
    'slóvakíska'                             => 'sk',
    'slóvenska'                               => 'sl',
    'soga'                                     => 'xog',
    'sogdíen'                                 => 'sog',
    'songhaí'                                 => 'son',
    'sorbneskmál'                             => 'wen',
    'spænska'                                 => 'es',
    'sranantongo'                              => 'srn',
    'suðuraltaíska'                          => 'alt',
    'suðurndebele'                            => 'nr',
    'suðursamíska'                           => 'sma',
    'suðursótó'                             => 'st',
    'svahílí'                                => 'sw',
    'svatí'                                   => 'ss',
    'svissneskfranska'                         => 'fr_ch',
    'svissneskháþýska'                      => 'de_ch',
    'svissneskþýska'                         => 'gsw',
    'sænska'                                  => 'sv',
    'síbsja'                                  => 'chb',
    'sídamó'                                 => 'sid',
    'sínótíbeskmál'                        => 'sit',
    'sínúk'                                  => 'chn',
    'sípevíska'                              => 'chp',
    'sísúanjí'                              => 'ii',
    'síúmál'                                => 'sio',
    'sómalska'                                => 'so',
    'sóninke'                                 => 'snk',
    'sósa'                                    => 'xh',
    'súang'                                   => 'za',
    'súkúma'                                 => 'suk',
    'súlú'                                   => 'zu',
    'súmerska'                                => 'sux',
    'súndanska'                               => 'su',
    'súní'                                   => 'zun',
    'súsú'                                   => 'sus',
    'sýrlenska'                               => 'syr',
    'tachelhit'                                => 'shi',
    'tadsjikska'                               => 'tg',
    'tagalog'                                  => 'tl',
    'tahítíska'                              => 'ty',
    'taita'                                    => 'dav',
    'tamasjek'                                 => 'tmh',
    'tamílska'                                => 'ta',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'tatarska'                                 => 'tt',
    'taílenska'                               => 'th',
    'taímálönnur'                           => 'tai',
    'telúgú'                                 => 'te',
    'terenó'                                  => 'ter',
    'teso'                                     => 'teo',
    'tetúm'                                   => 'tet',
    'tlingit'                                  => 'tli',
    'tokpisin'                                 => 'tpi',
    'tongverskanyasa'                          => 'tog',
    'tongverskatongaeyjar'                     => 'to',
    'tsimsíska'                               => 'tsi',
    'tsjetsjenska'                             => 'ce',
    'tsonga'                                   => 'ts',
    'tsúana'                                  => 'tn',
    'tví'                                     => 'tw',
    'tyap'                                     => 'kcg',
    'tyrkneska'                                => 'tr',
    "tyrkneska\,ottóman15001928"              => 'ota',
    'táknmál'                                => 'sgn',
    'tékkneska'                               => 'cs',
    'tíbeska'                                 => 'bo',
    'tígre'                                   => 'tig',
    'tígrinja'                                => 'ti',
    'tímne'                                   => 'tem',
    'tív'                                     => 'tiv',
    'tókeláska'                              => 'tkl',
    'túmbúka'                                => 'tum',
    'túpímál'                               => 'tup',
    'túrkmenska'                              => 'tk',
    'túvalúska'                              => 'tvl',
    'túvínska'                               => 'tyv',
    'ungverska'                                => 'hu',
    'uyghur'                                   => 'ug',
    'vakasmál'                                => 'wak',
    'valamó'                                  => 'wal',
    'vallónska'                               => 'wa',
    'varaí'                                   => 'war',
    'vasjó'                                   => 'was',
    'vaí'                                     => 'vai',
    'velska'                                   => 'cy',
    'venda'                                    => 've',
    'volapyk'                                  => 'vo',
    'volof'                                    => 'wo',
    'votíska'                                 => 'vot',
    'vunjo'                                    => 'vun',
    'víetnamska'                              => 'vi',
    'walser'                                   => 'wae',
    'yangben'                                  => 'yav',
    'zarma'                                    => 'dje',
    'zázáíska'                              => 'zza',
    'ástrónesíska'                          => 'map',
    'áströlskenska'                          => 'en_au',
    'áströlskmál'                           => 'aus',
    'íban'                                    => 'iba',
    'íberískportúgalska'                    => 'pt_pt',
    'íberískspænska'                        => 'es_es',
    'ídó'                                    => 'io',
    'ígbó'                                   => 'ig',
    'íjó'                                    => 'ijo',
    'ílokó'                                  => 'ilo',
    'ínúpíak'                               => 'ik',
    'íranska'                                 => 'ira',
    'írska'                                   => 'ga',
    'írókeskmál'                            => 'iro',
    'íslenska'                                => 'is',
    'ítalska'                                 => 'it',
    'óría'                                   => 'or',
    'órómó'                                 => 'om',
    'ósage'                                   => 'osa',
    'ótommál'                                => 'oto',
    'óþekkteðaógilttungumál'              => 'und',
    'údmúrt'                                 => 'udm',
    'úgarítíska'                            => 'uga',
    'úkraínska'                              => 'uk',
    'úmbúndú'                               => 'umb',
    'úrdú'                                   => 'ur',
    'úsbekska'                                => 'uz',
    'ýmismál'                                => 'mis',
    'þýska'                                  => 'de',
);

1;
