#!/usr/bin/env perl
use warnings;
use strict;

use File::Spec;
use Test::More;
use English qw(-no_match_vars);

if ( not $ENV{RELEASE_TESTING} ) {
    my $msg = 'Author test.  Set $ENV{RELEASE_TESTING} to a true value to run.';
    plan( skip_all => $msg );
}

my $rcfile = File::Spec->catfile( 't', 'perlcriticrc' );
unless ( -f $rcfile ) {
    my $msg = 'Author test.  File $rcfile required for testing.';
    plan( skip_all => $msg );
}

eval { require Test::Perl::Critic; };

if ( $EVAL_ERROR ) {
   my $msg = 'Test::Perl::Critic required to criticise code';
   plan( skip_all => $msg );
}

Test::Perl::Critic->import( -profile => $rcfile );
all_critic_ok();
