/* ************************************************************************
*   File: utils.h                                       Part of CircleMUD *
*  Usage: header file: utility macros and prototypes of utility funcs     *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */


/* external declarations and prototypes **********************************/

extern struct weather_data weather_info;

/* public functions in utils.c */
char	*str_dup(const char *source);
int	str_cmp(char *arg1, char *arg2);
int	strn_cmp(char *arg1, char *arg2, int n);
void	log(char *str);
int	touch(char *path);
void	mudlog(char *str, char type, sbyte level, byte file);
void	log_death_trap(struct char_data *ch);
int	number(int from, int to);
int	dice(int number, int size);
void	sprintbit(long vektor, char *names[], char *result);
void	sprinttype(int type, char *names[], char *result);
char *  sprintbitascii(long vektor, char *result);
int	get_line(FILE *fl, char *buf);
int 	get_line2(FILE * fl, char *buf);
int	get_filename(char *orig_name, char *filename, int mode);
struct time_info_data age(struct char_data *ch);
int	GET_REINCARN(struct char_data *ch);
void	ADD_REINCARN(struct char_data *ch);
bool	CAN_DAMAGE(struct char_data *ch, struct char_data *vic);
bool	CAN_MURDER(struct char_data *ch, struct char_data *victim);
int	get_alignment_type(int temp);

/* undefine MAX and MIN so that our functions are used instead */
#ifdef MAX
#undef MAX
#endif

#ifdef MIN
#undef MIN
#endif

int MAX(int a, int b);
int MIN(int a, int b);

/* in magic.c */
bool	circle_follow(struct char_data *ch, struct char_data * victim);

/* in act.informative.c */
void	look_at_room(struct char_data *ch, int mode);

/* in act.movmement.c */
int	do_simple_move(struct char_data *ch, int dir, int following);
int	perform_move(struct char_data *ch, int dir, int following);

/* in limits.c */
int	mana_limit(struct char_data *ch);
int	hit_limit(struct char_data *ch);
int	move_limit(struct char_data *ch);
int	mana_gain(struct char_data *ch);
int	hit_gain(struct char_data *ch);
int	move_gain(struct char_data *ch);
void	advance_level(struct char_data *ch);
void	set_title(struct char_data *ch, char *title);
void	gain_exp(struct char_data *ch, int gain);
void	gain_exp_regardless(struct char_data *ch, int gain);
void	gain_condition(struct char_data *ch, int condition, int value);
void	check_idling(struct char_data *ch);
void	point_update(void);
void	update_pos(struct char_data *victim);


/* various constants *****************************************************/


/* defines for mudlog() */
#define OFF	0
#define BRF	1
#define NRM	2
#define CMP	3

/* get_filename() */
#define CRASH_FILE	0
#define ETEXT_FILE	1
#define ALIAS_FILE	2
#define QUEST_FILE	3

/* breadth-first searching */
#define BFS_ERROR		-1
#define BFS_ALREADY_THERE	-2
#define BFS_NO_PATH		-3

/* mud-life time */
#define SECS_PER_MUD_HOUR	75
#define SECS_PER_MUD_DAY	(24*SECS_PER_MUD_HOUR)
#define SECS_PER_MUD_MONTH	(35*SECS_PER_MUD_DAY)
#define SECS_PER_MUD_YEAR	(17*SECS_PER_MUD_MONTH)

/* real-life time (remember Real Life?) */
#define SECS_PER_REAL_MIN	60
#define SECS_PER_REAL_HOUR	(60*SECS_PER_REAL_MIN)
#define SECS_PER_REAL_DAY	(24*SECS_PER_REAL_HOUR)
#define SECS_PER_REAL_YEAR	(365*SECS_PER_REAL_DAY)


/* string utils **********************************************************/


#define YESNO(a) ((a) ? "YES" : "NO")
#define ONOFF(a) ((a) ? "ON" : "OFF")

#define LOWER(c)   (((c)>='A'  && (c) <= 'Z') ? ((c)+('a'-'A')) : (c))
#define UPPER(c)   (((c)>='a'  && (c) <= 'z') ? ((c)+('A'-'a')) : (c) )

#define ISNEWL(ch) ((ch) == '\n' || (ch) == '\r') 
#define IF_STR(st) ((st) ? (st) : "\0")
#define CAP(st)  (*(st) = UPPER(*(st)), st)

#define AN(string) (strchr("aeiouAEIOU", *string) ? "an" : "a")


/* memory utils **********************************************************/


#define CREATE(result, type, number)  do {\
	if (!((result) = (type *) calloc ((number), sizeof(type))))\
		{ perror("malloc failure"); abort(); } } while(0)

#define RECREATE(result,type,number) do {\
  if (!((result) = (type *) realloc ((result), sizeof(type) * (number))))\
		{ perror("realloc failure"); abort(); } } while(0)

/*
 * the source previously used the same code in many places to remove an item
 * from a list: if it's the list head, change the head, else traverse the
 * list looking for the item before the one to be removed.  Now, we have a
 * macro to do this.  To use, just make sure that there is a variable 'temp'
 * declared as the same type as the list to be manipulated.  BTW, this is
 * a great application for C++ templates but, alas, this is not C++.  Maybe
 * CircleMUD 4.0 will be...
 */
#define REMOVE_FROM_LIST(item, head, next)	\
   if ((item) == (head))		\
      head = (item)->next;		\
   else {				\
      temp = head;			\
      while (temp && (temp->next != (item))) \
	 temp = temp->next;		\
      if (temp)				\
         temp->next = (item)->next;	\
   }					\


/* basic bitvector utils *************************************************/


#define IS_SET(flag,bit)  ((flag) & (bit))
#define SET_BIT(var,bit)  ((var) |= (bit))
#define REMOVE_BIT(var,bit)  ((var) &= ~(bit))
#define TOGGLE_BIT(var,bit) ((var) = (var) ^ (bit))
#define SET_OR_REMOVE(flagset, flags) { \
        if (on) SET_BIT(flagset, flags); \
        else if (off) REMOVE_BIT(flagset, flags); }

#define MOB_FLAGS(ch) ((ch)->char_specials.saved.act)
#define MOB2_FLAGS(ch) ((ch)->char_specials.saved.act2)
#define MOB3_FLAGS(ch) ((ch)->char_specials.saved.act3)
#define PLR_FLAGS(ch) ((ch)->char_specials.saved.act)
#define PLR2_FLAGS(ch) ((ch)->char_specials.saved.act2)
#define PLR3_FLAGS(ch) ((ch)->char_specials.saved.act3)
#define PRF_FLAGS(ch) ((ch)->player_specials->saved.pref)
#define PRF2_FLAGS(ch) ((ch)->player_specials->saved.pref2)
#define AFF_FLAGS(ch) ((ch)->char_specials.saved.affected_by)
#define AFF2_FLAGS(ch) ((ch)->char_specials.saved.affected_by2)
#define AFF3_FLAGS(ch) ((ch)->char_specials.saved.affected_by3)
#define ROOM_FLAGS(loc) (world[(loc)].room_flags)

#define IS_NPC(ch)  (IS_SET(MOB_FLAGS(ch), MOB_ISNPC))
#define IS_MOB(ch)  (IS_NPC(ch) && ((ch)->nr >-1))

#define MOB_FLAGGED(ch, flag) (IS_NPC(ch) && IS_SET(MOB_FLAGS(ch), (flag)))
#define MOB2_FLAGGED(ch, flag) (IS_NPC(ch) && IS_SET(MOB2_FLAGS(ch), (flag)))
#define MOB3_FLAGGED(ch, flag) (IS_NPC(ch) && IS_SET(MOB3_FLAGS(ch), (flag)))
#define PLR_FLAGGED(ch, flag) (!IS_NPC(ch) && IS_SET(PLR_FLAGS(ch), (flag)))
#define PLR2_FLAGGED(ch, flag) (!IS_NPC(ch) && IS_SET(PLR2_FLAGS(ch), (flag)))
#define PLR3_FLAGGED(ch, flag) (!IS_NPC(ch) && IS_SET(PLR3_FLAGS(ch), (flag)))
#define AFF_FLAGGED(ch, flag) (IS_SET(AFF_FLAGS(ch), (flag)))
#define AFF2_FLAGGED(ch, flag) (IS_SET(AFF2_FLAGS(ch), (flag)))
#define AFF3_FLAGGED(ch, flag) (IS_SET(AFF3_FLAGS(ch), (flag)))
#define PRF_FLAGGED(ch, flag) (IS_SET(PRF_FLAGS(ch), (flag)))
#define PRF2_FLAGGED(ch, flag) (IS_SET(PRF2_FLAGS(ch), (flag)))
#define ROOM_FLAGGED(loc, flag) (IS_SET(ROOM_FLAGS(loc), (flag)))

/* IS_AFFECTED for backwards compatibility */
#define IS_AFFECTED(ch, skill) (AFF_FLAGGED((ch), (skill)))

#define PLR_TOG_CHK(ch,flag) ((TOGGLE_BIT(PLR_FLAGS(ch), (flag))) & (flag))
#define PLR2_TOG_CHK(ch,flag) ((TOGGLE_BIT(PLR2_FLAGS(ch), (flag))) & (flag))
#define PLR3_TOG_CHK(ch,flag) ((TOGGLE_BIT(PLR3_FLAGS(ch), (flag))) & (flag))
#define PRF_TOG_CHK(ch,flag) ((TOGGLE_BIT(PRF_FLAGS(ch), (flag))) & (flag))
#define PRF2_TOG_CHK(ch,flag) ((TOGGLE_BIT(PRF2_FLAGS(ch), (flag))) & (flag))

/* room utils ************************************************************/


#define SECT(room)	(world[(room)].sector_type)

#define IS_DARK(room)  ( !world[room].light && \
                         (ROOM_FLAGGED(room, ROOM_DARK) || \
                          ( ( SECT(room) != SECT_INSIDE && \
                              SECT(room) != SECT_CITY ) && \
                            (weather_info.sunlight == SUN_SET || \
			     weather_info.sunlight == SUN_DARK)) ) )

#define IS_MURKY(room) (ROOM_FLAGGED(room, ROOM_MURKY))
#define IS_LIGHT(room)  (!IS_DARK(room))

#define GET_ROOM_SPEC(room) ((room) >= 0 ? world[(room)].func : NULL)

/* char utils ************************************************************/

/* color utils */
#define STATUS_COLOR(i, colorbuf, ch, C_TRAP)	\
   if (i > 75)					\
      sprintf(colorbuf, CCGRN(ch, C_TRAP));	\
   else if (i > 50)				\
      sprintf(colorbuf, CCBLU(ch, C_TRAP));	\
   else if (i > 25)				\
      sprintf(colorbuf, CCYEL(ch, C_TRAP));	\
   else						\
      sprintf(colorbuf, CCRED(ch, C_TRAP))	\


#define IN_ROOM(ch)	((ch)->in_room)
#define GET_WAS_IN(ch)	((ch)->was_in_room)
#define GET_AGE(ch)     (age(ch).year)

#define GET_NAME(ch)    (IS_NPC(ch) ? \
			 (ch)->player.short_descr : (ch)->player.name)
#define GET_TITLE(ch)   ((ch)->player.title)
#define GET_NUM_OF_CLASS(ch)	(IS_DUALCLASS(ch) ? 2 : (IS_TRIPLECLASS(ch) ? 3 : 1))
						

#define GET_LEVEL(ch)   ((ch)->player.level)
#define GET_PASSWD(ch)	((ch)->player.passwd)
#define GET_PFILEPOS(ch)((ch)->pfilepos)

/*
 * I wonder if this definition of GET_REAL_LEVEL should be the definition
 * of GET_LEVEL?  JE
 */
#define GET_REAL_LEVEL(ch) \
   (ch->desc && ch->desc->original ? GET_LEVEL(ch->desc->original) : \
    GET_LEVEL(ch))

#define GET_CLASS(ch)   ((ch)->player.class)
#define GET_RACE(ch)	((ch)->player.race)
#define GET_HOME(ch)	((ch)->player.hometown)
#define GET_HEIGHT(ch)	((ch)->player.height)
#define GET_WEIGHT(ch)	((ch)->player.weight)
#define GET_SEX(ch)	((ch)->player.sex)

#define GET_STR(ch)     ((ch)->aff_abils.str)
#define GET_ADD(ch)     ((ch)->aff_abils.str_add)
#define GET_DEX(ch)     ((ch)->aff_abils.dex)
#define GET_INT(ch)     ((ch)->aff_abils.intel)
#define GET_WIS(ch)     ((ch)->aff_abils.wis)
#define GET_CON(ch)     ((ch)->aff_abils.con)
#define GET_CHA(ch)     ((ch)->aff_abils.cha)

#define GET_EXP(ch)	  ((ch)->points.exp)
#define GET_AC(ch)        ((ch)->points.armor)
#define GET_HIT(ch)	  ((ch)->points.hit)
#define GET_MAX_HIT(ch)	  ((ch)->points.max_hit)
#define GET_MOVE(ch)	  ((ch)->points.move)
#define GET_MAX_MOVE(ch)  ((ch)->points.max_move)
#define GET_MANA(ch)	  ((ch)->points.mana)
#define GET_MAX_MANA(ch)  ((ch)->points.max_mana)
#define GET_GOLD(ch)	  ((ch)->points.gold)
#define GET_BANK_GOLD(ch) ((ch)->points.bank_gold)
#define GET_HITROLL(ch)	  ((ch)->points.hitroll)
#define GET_DAMROLL(ch)   ((ch)->points.damroll)

#define GET_POS(ch)	  ((ch)->char_specials.position)
#define GET_IDNUM(ch)	  ((ch)->char_specials.saved.idnum)
#define IS_CARRYING_W(ch) ((ch)->char_specials.carry_weight)
#define IS_CARRYING_N(ch) ((ch)->char_specials.carry_items)
#define FIGHTING(ch)	  ((ch)->char_specials.fighting)
#define HUNTING(ch)	  ((ch)->char_specials.hunting)
#define GET_SAVE(ch, i)	  ((ch)->char_specials.saved.apply_saving_throw[i])
#define GET_ALIGNMENT(ch) ((ch)->char_specials.saved.alignment)
#define GET_HONOR(ch) 	  ((ch)->player_specials->saved.honor)
#define GET_CHANNEL(ch)	  ((ch)->player_specials->saved.channel)
#define GET_CLAN(ch)	  ((ch)->player_specials->saved.clan)

#define GET_COND(ch, i)		((ch)->player_specials->saved.conditions[(i)])
#define GET_LOADROOM(ch)	((ch)->player_specials->saved.load_room)
#define GET_PRACTICES(ch)	((ch)->player_specials->saved.spells_to_learn)
#define GET_INVIS_LEV(ch)	((ch)->player_specials->saved.invis_level)
#define GET_WIMP_LEV(ch)	((ch)->player_specials->saved.wimp_level)
#define GET_FREEZE_LEV(ch)	((ch)->player_specials->saved.freeze_level)
#define GET_BAD_PWS(ch)		((ch)->player_specials->saved.bad_pws)
#define GET_TALK(ch, i)		((ch)->player_specials->saved.talks[i])
#define POOFIN(ch)		((ch)->player_specials->poofin)
#define POOFOUT(ch)		((ch)->player_specials->poofout)
#define GET_LAST_OLC_TARG(ch)	((ch)->player_specials->last_olc_targ)
#define GET_LAST_OLC_MODE(ch)	((ch)->player_specials->last_olc_mode)
#define GET_ALIASES(ch)		((ch)->player_specials->aliases)
#define GET_QUESTS(ch)		((ch)->player_specials->quests)
#define GET_LAST_TELL(ch)	((ch)->player_specials->last_tell)

#define GET_SKILL(ch, i)	((ch)->player_specials->saved.skills[i])
#define SET_SKILL(ch, i, pct)	{ (ch)->player_specials->saved.skills[i] = pct; }

#define GET_EQ(ch, i)		((ch)->equipment[i])

#define GET_MOB_SPEC(ch) (IS_MOB(ch) ? (mob_index[(ch->nr)].func) : NULL)
#define GET_MOB_RNUM(mob)	((mob)->nr)
#define GET_MOB_VNUM(mob)	(IS_MOB(mob) ? \
				 mob_index[GET_MOB_RNUM(mob)].virtual : -1)

#define GET_MOB_WAIT(ch)	((ch)->mob_specials.wait_state)
#define GET_DEFAULT_POS(ch)	((ch)->mob_specials.default_pos)
#define MEMORY(ch)		((ch)->mob_specials.memory)

#define STRENGTH_APPLY_INDEX(ch) \
        ( ((GET_ADD(ch)==0) || (GET_STR(ch) != 18)) ? GET_STR(ch) :\
          (GET_ADD(ch) <= 50) ? 36 :( \
          (GET_ADD(ch) <= 75) ? 37 :( \
          (GET_ADD(ch) <= 90) ? 38 :( \
          (GET_ADD(ch) <= 99) ? 39 :  40 ) ) )                   \
        )

#define CAN_CARRY_W(ch) (str_app[STRENGTH_APPLY_INDEX(ch)].carry_w)
#define CAN_CARRY_N(ch) (5 + (GET_DEX(ch) >> 1) + (GET_LEVEL(ch) >> 1))
#define AWAKE(ch) (GET_POS(ch) > POS_SLEEPING)
#define CAN_SEE_IN_DARK(ch) \
   (AFF_FLAGGED(ch, AFF_INFRAVISION) || PRF_FLAGGED(ch, PRF_HOLYLIGHT) \
	|| IS_ELF(ch) || IS_GNOME(ch) || IS_HEMNOV(ch) || IS_DWARF(ch))

#define CAN_SEE_HIDDEN(ch) \
   (AFF_FLAGGED(ch, AFF_SENSE_LIFE) || IS_IMMORT(ch) || IS_HEMNOV(ch) || IS_HALFLING(ch))

#define CAN_SEE_MAGIC(ch) \
   (IS_IMMORT(ch) || AFF_FLAGGED(ch, AFF_DETECT_MAGIC) || IS_ELF(ch) || IS_HEMNOV(ch))

#define IS_GOOD(ch)    (GET_ALIGNMENT(ch) >= 1500)
#define IS_EVIL(ch)    (GET_ALIGNMENT(ch) <= -1500)
#define IS_NEUTRAL(ch) (!IS_GOOD(ch) && !IS_EVIL(ch))


/* descriptor-based utils ************************************************/


#define WAIT_STATE(ch, cycle) { \
	if ((ch)->desc) (ch)->desc->wait = (cycle); \
	else if (IS_NPC(ch)) GET_MOB_WAIT(ch) = (cycle); }

#define CHECK_WAIT(ch)	(((ch)->desc) ? ((ch)->desc->wait > 1) : 0)
#define STATE(d)	((d)->connected)


/* object utils **********************************************************/


#define GET_OBJ_TYPE(obj)	((obj)->obj_flags.type_flag)
#define GET_OBJ_COST(obj)	((obj)->obj_flags.cost)
#define GET_OBJ_RENT(obj)	((obj)->obj_flags.cost_per_day)
#define GET_OBJ_EXTRA(obj)	((obj)->obj_flags.extra_flags)
#define GET_OBJ_EXTRA2(obj)	((obj)->obj_flags.extra_flags2)
#define GET_OBJ_WEAR(obj)	((obj)->obj_flags.wear_flags)
#define GET_OBJ_BIT(obj)	((obj)->obj_flags.bitvector)
#define GET_OBJ_BIT2(obj)	((obj)->obj_flags.bitvector2)
#define GET_OBJ_BIT3(obj)	((obj)->obj_flags.bitvector3)
#define GET_OBJ_VAL(obj, val)	((obj)->obj_flags.value[(val)])
#define GET_OBJ_WEIGHT(obj)	((obj)->obj_flags.weight)
#define GET_OBJ_TIMER(obj)	((obj)->obj_flags.timer)
#define GET_OBJ_RNUM(obj)	((obj)->item_number)
#define GET_OBJ_VNUM(obj)	(GET_OBJ_RNUM(obj) >= 0 ? \
				 obj_index[GET_OBJ_RNUM(obj)].virtual : -1)
#define IS_OBJ_STAT(obj,stat)	(IS_SET((obj)->obj_flags.extra_flags,stat))
#define IS_OBJ_STAT2(obj,stat)	(IS_SET((obj)->obj_flags.extra_flags2,stat))

#define GET_OBJ_SPEC(obj) ((obj)->item_number >= 0 ? \
	(obj_index[(obj)->item_number].func) : NULL)

#define CAN_WEAR(obj, part) (IS_SET((obj)->obj_flags.wear_flags, (part)))


/* CLASS/RACE macros */
#define IS_IMPL(ch)		(GET_LEVEL(ch) >= LVL_IMPL)
#define IS_GRGOD(ch)		(GET_LEVEL(ch) >= LVL_GRGOD)
#define IS_GOD(ch)		(GET_LEVEL(ch) >= LVL_GOD)
#define IS_IMMORT(ch)		(GET_LEVEL(ch) >= LVL_IMMORT)

#define CLASS_ABBR(ch)  (IS_NPC(ch) ? "---" : \
			(IS_IMPL(ch) ? "IMP" : \
			(IS_GRGOD(ch) ? "GRG" : \
			(IS_GOD(ch) ? "Dei" : \
			(IS_IMMORT(ch) ? "Imm" : \
			(IS_TRIPLECLASS(ch) ? "Tri" : \
			(IS_DUALCLASS(ch) ? "Dua" : class_abbrevs[(int)GET_CLASS_NUM(ch)])))))))

#define RACE_ABBR(ch)	(IS_NPC(ch) ? "NPC" : race_abbrevs[(int)GET_RACE(ch)])

#define IS_MAGIC_USER(ch)	(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_MAGIC_USER)))
#define IS_CLERIC(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_CLERIC)))
#define IS_THIEF(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_THIEF)))
#define IS_WARRIOR(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_WARRIOR)))
#define IS_BARBARIAN(ch)	(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_BARBARIAN)))
#define IS_SAMURAI(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_SAMURAI)))
#define IS_DRUID(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_DRUID)))
#define IS_WIZARD(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_WIZARD)))
#define IS_MONK(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_MONK)))
#define IS_AVATAR(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_AVATAR)))
#define IS_NINJA(ch)		(!IS_NPC(ch) && \
				(IS_SET(GET_CLASS(ch), CLASS_NINJA)))



#define GET_CLASS_NUM(ch)	( \
				IS_NINJA(ch) ?       10  : ( \
				IS_AVATAR(ch) ?       9  : ( \
 				IS_MONK(ch) ?         8  : ( \
				IS_WARRIOR(ch) ?      3  : ( \
 				IS_BARBARIAN(ch) ?    4  : ( \
				IS_SAMURAI(ch) ?      5  : ( \
				IS_DRUID(ch) ?        6  : ( \
				IS_CLERIC(ch) ?       1  : ( \
				IS_MAGIC_USER(ch) ?   0  : ( \
				IS_WIZARD(ch) ?       7  : ( \
 				IS_THIEF(ch) ?        2  : -1 ) ) ) ) ) ) ) ) ) ) )

#define GET_CLASS_NUM_FULL(ch)	( \
				IS_TRIPLECLASS(ch) ? 12  : ( \
				IS_DUALCLASS(ch) ?   11  : ( \
				IS_NINJA(ch) ?       10  : ( \
				IS_AVATAR(ch) ?       9  : ( \
 				IS_MONK(ch) ?         8  : ( \
				IS_WIZARD(ch) ?       7  : ( \
				IS_DRUID(ch) ?        6  : ( \
				IS_SAMURAI(ch) ?      5  : ( \
 				IS_BARBARIAN(ch) ?    4  : ( \
				IS_WARRIOR(ch) ?      3  : ( \
				IS_THIEF(ch) ?        2  : ( \
				IS_CLERIC(ch) ?       1  : ( \
				IS_MAGIC_USER(ch) ?   0  : -1  ) ) ) ) ) ) ) ) ) ) ) ) ) 

#define IS_DUALCLASS(ch)	(IS_SET(GET_CLASS(ch), CLASS_DUAL))
#define IS_TRIPLECLASS(ch)	(IS_SET(GET_CLASS(ch), CLASS_TRIPLE))

#define IS_HUMAN(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_HUMAN))
#define IS_ELF(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_ELF))
#define IS_HALFELF(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_HALFELF))
#define IS_DWARF(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_DWARF))
#define IS_HALFLING(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_HALFLING))
#define IS_GNOME(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_GNOME))
#define IS_HEMNOV(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_HEMNOV))
#define IS_LLYRA(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_LLYRA))
#define IS_MINOTAUR(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_MINOTAUR))
#define IS_PIXIE(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_PIXIE))

#define IS_WEREFORM(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_WEREFORM))

#define IS_DRAGON(ch)		(!IS_NPC(ch) && \
				(GET_RACE(ch) == RACE_DRAGON))

#define IS_DARKGNOME(ch)	(IS_GNOME(ch) && PRF2_FLAGGED(ch, PRF2_WAR_DRUHARI))

#define IS_GOODGNOME(ch)	(IS_GNOME(ch) && !PRF2_FLAGGED(ch, PRF2_WAR_DRUHARI))

/* compound utilities and other macros **********************************/


#define HSHR(ch) (GET_SEX(ch) ? (GET_SEX(ch)==SEX_MALE ? "his":"her") :"its")
#define HSSH(ch) (GET_SEX(ch) ? (GET_SEX(ch)==SEX_MALE ? "he" :"she") : "it")
#define HMHR(ch) (GET_SEX(ch) ? (GET_SEX(ch)==SEX_MALE ? "him":"her") : "it")

#define ANA(obj) (strchr("aeiouyAEIOUY", *(obj)->name) ? "An" : "A")
#define SANA(obj) (strchr("aeiouyAEIOUY", *(obj)->name) ? "an" : "a")


/* Various macros building up to CAN_SEE */

#define LIGHT_OK(sub)	(!IS_AFFECTED(sub, AFF_BLIND) && \
   (IS_LIGHT((sub)->in_room) || IS_AFFECTED((sub), AFF_INFRAVISION)))

#define INVIS_OK(sub, obj) \
 ((!IS_AFFECTED((obj),AFF_INVISIBLE) || IS_AFFECTED(sub,AFF_DETECT_INVIS)) && \
 (!IS_AFFECTED((obj), AFF_HIDE) || CAN_SEE_HIDDEN(sub)))

#define MORT_CAN_SEE(sub, obj) (LIGHT_OK(sub) && INVIS_OK(sub, obj))

#define IMM_CAN_SEE(sub, obj) \
   (MORT_CAN_SEE(sub, obj) || PRF_FLAGGED(sub, PRF_HOLYLIGHT))

#define SELF(sub, obj)  ((sub) == (obj))

/* Can subject see character "obj"? */
#define CAN_SEE(sub, obj) (SELF(sub, obj) || \
   ((GET_REAL_LEVEL(sub) >= GET_INVIS_LEV(obj)) && IMM_CAN_SEE(sub, obj)))

/* End of CAN_SEE */


#define INVIS_OK_OBJ(sub, obj) \
  (!IS_OBJ_STAT((obj), ITEM_INVISIBLE) || IS_AFFECTED((sub), AFF_DETECT_INVIS) || IS_IMMORT(sub))

#define MORT_CAN_SEE_OBJ(sub, obj) (LIGHT_OK(sub) && INVIS_OK_OBJ(sub, obj))

#define CAN_SEE_OBJ(sub, obj) \
   (MORT_CAN_SEE_OBJ(sub, obj) || PRF_FLAGGED((sub), PRF_HOLYLIGHT))

#define CAN_CARRY_OBJ(ch,obj)  \
   (((IS_CARRYING_W(ch) + GET_OBJ_WEIGHT(obj)) <= CAN_CARRY_W(ch)) &&   \
    ((IS_CARRYING_N(ch) + 1) <= CAN_CARRY_N(ch)))

#define CAN_GET_OBJ(ch, obj)   \
   (CAN_WEAR((obj), ITEM_WEAR_TAKE) && CAN_CARRY_OBJ((ch),(obj)) && \
    CAN_SEE_OBJ((ch),(obj)))

#define PERS(ch, vict)   (CAN_SEE(vict, ch) ? GET_NAME(ch) : "someone")

#define OBJS(obj, vict) (CAN_SEE_OBJ((vict), (obj)) ? \
	(obj)->short_description  : "something")

#define OBJN(obj, vict) (CAN_SEE_OBJ((vict), (obj)) ? \
	fname((obj)->name) : "something")


#define EXIT(ch, door)  (world[(ch)->in_room].dir_option[door])
#define EXITN(room, door)               (world[room].dir_option[door])
#define _2ND_EXIT(ch, door) (world[EXIT(ch, door)->to_room].dir_option[door])
#define _3RD_EXIT(ch, door) (world[_2ND_EXIT(ch, door)->to_room].dir_option[door])

#define CAN_GO(ch, door) (EXIT(ch,door) && \
			 (EXIT(ch,door)->to_room != NOWHERE) && \
			 !IS_SET(EXIT(ch, door)->exit_info, EX_CLOSED))

#define OUTSIDE(ch) (!ROOM_FLAGGED((ch)->in_room, ROOM_INDOORS))

#define lvD2(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 2)))
#define lvD3(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 3)))
#define lvD4(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 4)))
#define lvD5(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 5)))
#define lvD6(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 6)))
#define lvD8(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 8)))
#define lvD10(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 10)))
#define lvD12(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 12)))
#define lvD15(ch) ( MAX(1, (int) (GET_LEVEL(ch) / 15)))



/* OS compatibility ******************************************************/


/* there could be some strange OS which doesn't have NULL... */
#ifndef NULL
#define NULL (void *)0
#endif

#if !defined(FALSE)
#define FALSE 0
#endif

#if !defined(TRUE)
#define TRUE  (!FALSE)
#endif

/* defines for fseek */
#ifndef SEEK_SET
#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2
#endif

/*
 * Some systems such as Sun's don't have prototyping in their header files.
 * Thus, we try to compensate for them.
 *
 * Much of this is from Merc 2.2, used with permission.
 */

#if defined(_AIX)
char	*crypt(const char *key, const char *salt);
#endif

#if defined(apollo)
int	atoi (const char *string);
void	*calloc( unsigned nelem, size_t size);
char	*crypt( const char *key, const char *salt);
#endif

#if defined(hpux)
char	*crypt(char *key, const char *salt);
#endif

#if defined(linux)
char	*crypt( const char *key, const char *salt);
#endif

#if defined(MIPS_OS)
char	*crypt(const char *key, const char *salt);
#endif

#if defined(NeXT)
char	*crypt(const char *key, const char *salt);
int	unlink(const char *path);
int	getpid(void);
#endif

/*
 * The proto for [NeXT's] getpid() is defined in the man pages are returning
 * pid_t but the compiler pukes on it (cc). Since pid_t is just
 * normally a typedef for int, I just use int instead.
 * So far I have had no other problems but if I find more I will pass
 * them along...
 * -reni
 */

#if defined(sequent)
char	*crypt(const char *key, const char *salt);
int	fclose(FILE *stream);
int	fprintf(FILE *stream, const char *format, ... );
int	fread(void *ptr, int size, int n, FILE *stream);
int	fseek(FILE *stream, long offset, int ptrname);
void	perror(const char *s);
int	ungetc(int c, FILE *stream);
#endif

#if defined(sun)
#include <memory.h>
void	bzero(char *b, int length);
char	*crypt(const char *key, const char *salt);
int	fclose(FILE *stream);
int	fflush(FILE *stream);
void	rewind(FILE *stream);
int	sscanf(const char *s, const char *format, ... );
int	fprintf(FILE *stream, const char *format, ... );
int	fscanf(FILE *stream, const char *format, ... );
int	fseek(FILE *stream, long offset, int ptrname);
size_t	fread(void *ptr, size_t size, size_t n, FILE *stream);
size_t	fwrite(const void *ptr, size_t size, size_t n, FILE *stream);
void	perror(const char *s);
int	ungetc(int c, FILE *stream);
time_t	time(time_t *tloc);
int	system(const char *string);
#endif

#if defined(ultrix)
char	*crypt(const char *key, const char *salt);
#endif

#if defined(DGUX_TARGET)
#ifndef NOCRYPT
#include <crypt.h>
#endif
#define bzero(a, b) memset((a), 0, (b))
#endif

#if defined(sgi)
#include <bstring.h>
#ifndef NOCRYPT
#include <crypt.h>
#endif
#endif


/*
 * The crypt(3) function is not available on some operating systems.
 * In particular, the U.S. Government prohibits its export from the
 *   United States to foreign countries.
 * Turn on NOCRYPT to keep passwords in plain text.
 */
#ifdef NOCRYPT
#define CRYPT(a,b) (a)
#else
#define CRYPT(a,b) ((char *) crypt((a),(b)))
#endif
