/***[exec.c]******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <parse.h>
#include <ctype.h>

extern int PrintHeader;
extern int HeaderPrinted;

/*
 * If type==0, only last line of output is returned
 * If type==1, all lines will be printed and last lined returned
 * If type==2, all lines will be saved to array var on stack
 */
void Exec(unsigned char *name, int type) {
	FILE *fp;
	Stack *s;
	char buf[4096];
	int t,l;

	s = Pop();
	if(!s) {
		Error("Stack error in exec");
		return;
	}	
	fp = popen(s->strval,"r");
	if(!fp) {
		Error("Unable to fork [%s]",s->strval);
		return;
	}
	buf[0]='\0';	
	if(type==1) {
		if(PrintHeader && !HeaderPrinted) {
			fputs("Content-type: text/html\n\n",stdout);
			fflush(stdout);
			HeaderPrinted = 1;
		}
	}		
	while(fgets(buf,4095,fp)) {
		if(type==1) fputs(buf,stdout);
		else if(type==2) {
			l = strlen(buf);
			t = l;
			while(isspace(buf[--l])); 
			if(l<t) buf[l+1]='\0';	
			Push(AddSlashes(buf,0),STRING);
			SetVar(name,1,0);	
		}
	}
	l = strlen(buf);
	t = l;
	while(l && isspace(buf[--l])); 
	if(l<t) buf[l+1]='\0';	
	Push(AddSlashes(buf,0),STRING);
	pclose(fp);
}
