/***[conf.c]******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
#if HAVE_CRYPT_H
#include <crypt.h>
#endif

extern int PrintHeader;
extern int HeaderPrinted;

#if ACCESS_CONTROL
/*
 * Configuration
 *
 * If path was provided, check ownership and open appropriate config file
 *
 */
void Configuration(int argc, char **argv) {
	int ret,i,rule;
	char *path, *s, *key, *sn=NULL, *pi=NULL,*defRule=NULL;
	char temp[1024];
	struct stat sb;
	struct passwd *pw;
	VarTree *var;
	AccessInfo *actop, *ac;

	path = getenv("PATH_TRANSLATED");
	if(path) {
		if(stat(path,&sb)==-1) {
			Error("Unable to find: %s",path);
			return;
		}	
		sprintf(temp,"%s/%ld-cfg",ACCESS_DIR,(long)sb.st_uid);
	} else sprintf(temp,"%s/0-cfg",ACCESS_DIR);

	ErrorPrintState(0);		
	ret = _dbmOpen(temp,"r");
	ErrorPrintState(1);		
	if(ret > 0) {
		ret = _dbmOpen(temp,"n");
#if DEBUG
		Debug("Creating new configuration file [%s]\n",temp);
#endif
		if(ret) exit(-1);
		_dbmInsert(temp,"cfg-file",temp);
		pw = getpwuid(sb.st_uid);
#if HAVE_CRYPT
#if BROKEN_CONFIG_PW
		_dbmInsert(temp,"cfg-passwd",(char *)crypt("php","xy"));
#else
		if(pw && pw->pw_name)
			_dbmInsert(temp,"cfg-passwd",(char *)crypt(pw->pw_name,"xy"));
		else
			_dbmInsert(temp,"cfg-passwd",(char *)crypt("php","xy"));
#endif
#else
#if BROKEN_CONFIG_PW
		_dbmInsert(temp,"cfg-passwd","php");
#else
		if(pw && pw->pw_name)
			_dbmInsert(temp,"cfg-passwd",pw->pw_name);
		else
			_dbmInsert(temp,"cfg-passwd","php");
#endif
#endif
		_dbmInsert(temp,"cfg-user",pw->pw_name);
		_dbmInsert(temp,"cfg-accessALL","pub\033L\033dom.*");
		_dbmInsert(temp,"cfg-email-URL"," ");
		_dbmInsert(temp,"cfg-ban-URL"," ");
		_dbmInsert(temp,"cfg-passwd-URL"," ");
		_dbmClose(temp);
		ret = _dbmOpen(temp,"r");
		if(ret) exit(-1);
	}

	if(PrintHeader && !HeaderPrinted) {
		fputs("Content-type: text/html\n\n",stdout);
		HeaderPrinted = 1;
	}
	var = GetVar("cfg-passwd",NULL,0);
#if HAVE_CRYPT
	if(!var || (var && strcmp((char *)crypt(var->strval,"xy"),_dbmFetch(temp,"cfg-passwd")))) {
#else
	if(!var || (var && strcmp(var->strval,_dbmFetch(temp,"cfg-passwd")))) {
#endif
		if(var) {
			fputs("<html><head><title>Incorrect Configuration Password</title></head>\n",stdout);
			fputs("<body><center><h1>Incorrect Configuration Password</h1></center>\n",stdout);
			fputs("Please re-enter your configuration password:\n",stdout);
		} else {
			fputs("<html><head><title>PHP/FI Configuration Password</title></head>\n",stdout);
			fputs("<body><center><h1>PHP/FI Configuration Password</h1></center>\n",stdout);
			fputs("Please enter your configuration password:\n",stdout);
		}
#ifdef VIRTUAL_PATH
		sn = VIRTUAL_PATH;
#else
		sn = getenv("SCRIPT_NAME");
#endif
		pi = getenv("PATH_INFO");
		printf("<form action=\"%s%s?config\" method=\"POST\">\n",sn?sn:argv[0],pi?pi:"");
		fputs("<input type=\"password\" name=\"cfg-passwd\"><input type=\"submit\" value=\" Ok \"></form>",stdout);
		fputs("</body></html>\n",stdout);
		fflush(stdout);
		_dbmClose(temp);
		return;
	}
	if(path) AddFile(temp, path);
	ChkPostVars(temp);
	var = GetVar("cfg-passwd",NULL,0);
	AddRule(temp);
	PostToAccessStr(temp);
#ifdef VIRTUAL_PATH
	sn = VIRTUAL_PATH;
#else
	sn = getenv("SCRIPT_NAME");
#endif
	pi = getenv("PATH_INFO");
	fputs("<html><head><title>PHP/FI Configuration Screen</title></head>\n",stdout);
	fputs("<body><center><h1>PHP/FI Configuration Screen</h1></center>\n",stdout);
	fflush(stdout);
	printf("<b>Configuration file:</b> <i>%s</i><br>\n",_dbmFetch(temp,"cfg-file"));
	printf("<b>User:</b> <i>%s</i><br>\n",_dbmFetch(temp,"cfg-user"));
	printf("<center><form action=\"%s%s?config\" method=\"POST\">\n",sn?sn:argv[0],pi?pi:"");
	printf("<input type=\"password\" name=\"chg-passwd\" value=\"%s\">\n",var->strval);
	printf("<input type=\"hidden\" name=\"cfg-passwd\" value=\"%s\">\n",var->strval);
	fputs("<input type=\"submit\" value=\"Change Password\"></form></center><hr>\n",stdout);
	fflush(stdout);
	s = _dbmFetch(temp,"cfg-accessALL");
	if(s) defRule = (char *)estrdup(s);
	actop = StrtoAccess(s);
	i=0;
	key=NULL;
	while(i==0 || (key && *key)) {
		if(i==0 || (key && !strncmp(key,"cfg-access-",11))) {
			ac = actop;
			fputs("<table border=1 cellpadding=2>\n",stdout);
			printf("<form action=\"%s%s?config\" method=\"POST\">\n",sn?sn:argv[0],pi?pi:"");
			printf("<input type=\"hidden\" name=\"cfg-passwd\" value=\"%s\">\n",var->strval);
			if(i>0) {
				printf("<tr><th colspan=3>%s</th>",&key[11]);
				printf("<input type=\"hidden\" name=\"file\" value=\"%s\">\n",&key[11]);
				s = _dbmFetch(temp,key);
				actop = StrtoAccess(s);
				ac= actop;
				if(ac->def) fputs("<td colspan=2 align=\"center\"><select name=\"def\"><option SELECTED>public\n<option>private\n</select></td></tr>",stdout);
				else fputs("<td align=\"center\"><select name=\"def\"><option SELECTED>private\n<option>public\n</select></td></tr>",stdout);
			} else {
				fputs("<tr><th colspan=3>Default</th>",stdout);
				fputs("<input type=\"hidden\" name=\"file\" value=\"Default\">\n",stdout);
				if(ac->def) fputs("<td colspan=2 align=\"center\"><b>Access:</b> <select name=\"def\"><option SELECTED>public\n<option>private\n</select></td></tr>",stdout);
				else fputs("<td colspan=2 align=\"center\"><b>Access:</b> <select name=\"def\"><option SELECTED>private\n<option>public\n</select></td></tr>",stdout);
				fputs("<tr><th>Function</th><th>Password</th><th>Type</th><th>Pattern</th><th>del</th></tr>\n",stdout);
			}
			fflush(stdout);
			rule=0;
			while(ac) {	
				fputs("<tr>",stdout);
				if(ac->mode & 1) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>E-mail Req.\n<option>Allow\n<option>Ban\n<option>Password\n<option>No Logging\n<option>Logging\n<option>Show Info\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 2) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>Allow\n<option>E-Mail Req.\n<option>Ban\n<option>Password\n<option>No Logging\n<option>Logging\n<option>Show Info\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 4) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>Ban\n<option>E-Mail Req.\n<option>Allow\n<option>Password\n<option>No Logging\n<option>Logging\n<option>Show Info\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 8) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>Password\n<option>E-Mail Req.\n<option>Allow\n<option>Ban\n<option>No Logging\n<option>Logging\n<option>Show Info\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 16) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>No Logging\n<option>E-Mail Req.\n<option>Allow\n<option>Ban\n<option>Password\n<option>Logging\n<option>Show Info\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 32) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>Logging\n<option>E-Mail Req.\n<option>Allow\n<option>Ban\n<option>Password\n<option>No Logging\n<option>Show Info\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 64) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>Show Info\n<option>E-mail Req.\n<option>Allow\n<option>Ban\n<option>Password\n<option>Logging\n<option>No Logging\n<option>Hide Info\n</select></td> ",rule);
				if(ac->mode & 128) printf("<td align=\"center\"><select name=\"mode[%d]\"><option SELECTED>Hide Info\n<option>E-mail Req.\n<option>Allow\n<option>Ban\n<option>Password\n<option>Logging\n<option>No Logging\n<option>Show Info\n</select></td> ",rule);
				if(ac->password) {
					if(!strcmp(ac->password," "))
						printf("<td align=\"center\"><input type=\"text\" name=\"password[%d]\" value=\"\"></td>\n",rule);
					else
						printf("<td align=\"center\"><input type=\"text\" name=\"password[%d]\" value=\"%s\"></td>\n",rule,ac->password);
				} else
						printf("<td align=\"center\"><input type=\"text\" name=\"password[%d]\" value=\"\"></td>\n",rule);

				if(ac->type==0) printf("<td align=\"center\"><select name=\"type[%d]\"><option SELECTED>Domain\n<option>E-Mail\n<option>RefDoc\n<option>Browser\n</select></td>",rule);
				if(ac->type==1) printf("<td align=\"center\"><select name=\"type[%d]\"><option SELECTED>E-Mail\n<option>Domain\n<option>RefDoc\n<option>Browser\n</select></td>",rule);
				if(ac->type==2) printf("<td align=\"center\"><select name=\"type[%d]\"><option SELECTED>RefDoc\n<option>Domain\n<option>E-Mail\n<option>Browser\n</select></td>",rule);
				if(ac->type==3) printf("<td align=\"center\"><select name=\"type[%d]\"><option SELECTED>Browser\n<option>Domain\n<option>E-Mail\n<option>RefDoc\n</select></td>",rule);
				printf("<td align=\"center\"><input type=\"text\" name=\"patt[%d]\" value=\"%s\"></td>\n",rule,ac->patt);
				if(!(i==0 && rule==0)) printf("<td align=\"center\"><input type=\"checkbox\" name=\"del%d\"></td></tr>\n\n",rule);
				fflush(stdout);
				ac = ac->next;
				rule++;
			}	
			fputs("<tr><td colspan=3 align=\"center\"><input type=\"submit\" value=\"Submit Changes\"></td></form>\n",stdout);
			printf("<form action=\"%s%s?config\" method=\"POST\">\n",sn?sn:argv[0],pi?pi:"");
			printf("<input type=\"hidden\" name=\"cfg-passwd\" value=\"%s\">\n",var->strval);
			printf("<input type=\"hidden\" name=\"addrule\" value=\"%s\">\n",(i>0)?&key[11]:"Default");
			fputs("<td colspan=2 align=\"center\"><input type=\"submit\" value=\"Add Rule\"></td></tr></form></table>\n",stdout);
			fflush(stdout);
		}
		if(i==0) key = _dbmFirstKey(temp);
		else {
			key = _dbmNextKey(temp,key);
		}
		i++;
	}	

	fputs("<hr><i>Below you may configure URL's to be displayed whenever the stated condition occurs.  If left blank, a built-in PHP/FI screen will be used.</i><p>\n",stdout);
	printf("<form action=\"%s%s?config\" method=\"POST\">\n",sn?sn:argv[0],pi?pi:"");
	printf("<input type=\"hidden\" name=\"cfg-passwd\" value=\"%s\">\n",var->strval);

	s = _dbmFetch(temp,"cfg-email-URL");
	if(!s || (s && strlen(s)<2))
		fputs("E-Mail Address request form: <input type=\"text\" name=\"cfg-email-URL\" value=\"\" size=60 maxlength=512><br>\n",stdout);
	else if(s) 
		printf("E-Mail Address request form: <input type=\"text\" name=\"cfg-email-URL\" value=\"%s\" size=60 maxlength=512><br>\n",s);

	s = _dbmFetch(temp,"cfg-passwd-URL");
	if(!s || (s && strlen(s)<2))
		fputs("Password request form: <input type=\"text\" name=\"cfg-passwd-URL\" value=\"\" size=60 maxlength=512><br>\n",stdout);
	else if(s) 
		printf("Password request form: <input type=\"text\" name=\"cfg-passwd-URL\" value=\"%s\" size=60 maxlength=512><br>\n",s);

	s = _dbmFetch(temp,"cfg-ban-URL");
	if(!s || (s && strlen(s)<2))
		fputs("Page to show a banned user: <input type=\"text\" name=\"cfg-ban-URL\" value=\"\" size=60 maxlength=512><br>\n",stdout);
	else if(s) 
		printf("Page to show a banned user: <input type=\"text\" name=\"cfg-ban-URL\" value=\"%s\" size=60 maxlength=512><br>\n",s);

	fputs("<input type=\"submit\" value=\"Submit Changes\">\n",stdout);
	fputs("<hr><font size=-2><i>PHP/FI</i></font></body></html>\n",stdout);
	fflush(stdout);
	efree(defRule);
	_dbmClose(temp);
}

#endif /* ACCESS_CONTROL */

