# This file is the source file of the scatter.pdf
# source page: https://matplotlib.org/gallery/shapes_and_collections/scatter.html
import numpy as np
import matplotlib.pyplot as plt

# Fixing random state for reproducibility
np.random.seed(19680801)


N = 50
x = np.random.rand(N)
y = np.random.rand(N)
colors = np.random.rand(N)
area = (30 * np.random.rand(N))**2  # 0 to 15 point radii

ax = plt.subplot(111)
ax.scatter(x, y, s=area, c=colors, alpha=0.5)

# Hide the right and top spines
ax.spines['right'].set_visible(False)
ax.spines['top'].set_visible(False)

# Only show ticks on the left and bottom spines
ax.yaxis.set_ticks_position('left')
ax.xaxis.set_ticks_position('bottom')

plt.savefig('scatter.pdf', transparent=True)
