/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLSignatureFactoryTest
extends TestCase {
    XMLSignatureFactory factory;

    public XMLSignatureFactoryTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.factory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testgetInstance() {
        try {
            XMLSignatureFactory.getInstance("non-existent");
            XMLSignatureFactoryTest.fail((String)"Should throw NoSuchMechanismException if no impl found");
        }
        catch (NoSuchMechanismException noSuchMechanismException) {
            // empty catch block
        }
        try {
            XMLSignatureFactory.getInstance(null);
            XMLSignatureFactoryTest.fail((String)"Should raise a NPE for null mechanismType");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            XMLSignatureFactory.getInstance("DOM", "non-existent");
            XMLSignatureFactoryTest.fail((String)"Should throw NoSuchProviderException if specified provider is not found");
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchMechanismException noSuchMechanismException) {
            XMLSignatureFactoryTest.fail((String)("Should raise a NoSuchProviderException instead of " + noSuchMechanismException + " if specified provider is not found"));
        }
        try {
            XMLSignatureFactory.getInstance(null);
            XMLSignatureFactoryTest.fail((String)"Should raise a NPE for null mechanismType");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            XMLSignatureFactory.getInstance("DOM", (Provider)null);
            XMLSignatureFactoryTest.fail((String)"Should raise a NPE for null provider");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testgetMechanismType() {
        XMLSignatureFactoryTest.assertNotNull((Object)this.factory);
        XMLSignatureFactoryTest.assertEquals((String)"DOM", (String)this.factory.getMechanismType());
    }

    public void testisFeatureSupported() {
        try {
            this.factory.isFeatureSupported(null);
            XMLSignatureFactoryTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        XMLSignatureFactoryTest.assertTrue((!this.factory.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }

    public void testgetKeyInfoFactory() throws Exception {
        KeyInfoFactory keyInfoFactory = this.factory.getKeyInfoFactory();
        XMLSignatureFactoryTest.assertEquals((String)keyInfoFactory.getMechanismType(), (String)this.factory.getMechanismType());
        XMLSignatureFactoryTest.assertEquals((Object)keyInfoFactory.getProvider(), (Object)this.factory.getProvider());
    }

    public void testunmarshalXMLSignature() throws Exception {
        XMLSignature xMLSignature;
        try {
            xMLSignature = this.factory.unmarshalXMLSignature((XMLValidateContext)null);
            XMLSignatureFactoryTest.fail((String)"Should raise an NPE for null inputs");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            XMLSignatureFactoryTest.fail((String)("Should throw an NPE instead of " + exception + " for null inputs"));
        }
        try {
            xMLSignature = this.factory.unmarshalXMLSignature(new XMLValidateContext(){

                public Object getProperty(String string) {
                    return null;
                }

                public Object setProperty(String string, Object object) {
                    return null;
                }

                public String getBaseURI() {
                    return null;
                }

                public void setBaseURI(String string) {
                }

                public KeySelector getKeySelector() {
                    return null;
                }

                public void setKeySelector(KeySelector keySelector) {
                }

                public URIDereferencer getURIDereferencer() {
                    return null;
                }

                public void setURIDereferencer(URIDereferencer uRIDereferencer) {
                }

                public Object get(Object object) {
                    return null;
                }

                public Object put(Object object, Object object2) {
                    return null;
                }

                public void setDefaultNamespacePrefix(String string) {
                }

                public String getDefaultNamespacePrefix() {
                    return null;
                }

                public String putNamespacePrefix(String string, String string2) {
                    return null;
                }

                public String getNamespacePrefix(String string, String string2) {
                    return null;
                }
            });
            XMLSignatureFactoryTest.fail((String)"Should throw a CCE for input of wrong type");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            XMLSignatureFactoryTest.fail((String)("Should raise a CCE instead of " + exception + " for wrong inputs"));
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        File file = new File(string2 + string + "data" + string + "ie" + string + "baltimore" + string + "merlin-examples", "merlin-xmldsig-twenty-three");
        Document document = documentBuilder.parse(new File(file, "signature.xml"));
        NodeList nodeList = document.getElementsByTagName("KeyInfo");
        try {
            xMLSignature = this.factory.unmarshalXMLSignature(new DOMValidateContext(TestUtils.getPublicKey("RSA"), nodeList.item(0)));
            XMLSignatureFactoryTest.fail((String)"Should throw a MarshalException for non-XMLSignature inputs");
        }
        catch (MarshalException marshalException) {
            // empty catch block
        }
        nodeList = document.getElementsByTagName("Signature");
        try {
            xMLSignature = this.factory.unmarshalXMLSignature(new DOMValidateContext(TestUtils.getPublicKey("DSA"), nodeList.item(0)));
            XMLSignatureFactoryTest.assertNotNull((Object)xMLSignature);
        }
        catch (MarshalException marshalException) {
            XMLSignatureFactoryTest.fail((String)("Unmarshal failed: " + marshalException.getMessage()));
            marshalException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLSignatureFactoryTest xMLSignatureFactoryTest = new XMLSignatureFactoryTest("XMLSignatureFactoryTest");
        xMLSignatureFactoryTest.setUp();
        xMLSignatureFactoryTest.testunmarshalXMLSignature();
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

