/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_PhysicalPackageAccess.h"

const string creationClassName = "OpenDRIM_PhysicalPackage";

int PhysicalAsset_OpenDRIM_PhysicalPackage_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalPackage>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;

	OpenDRIM_PhysicalPackage instance;
	string computerSystemTag;

	CF_assert(CF_getComputerSystemPhysicalPackageTag(computerSystemTag,errorMessage));

	instance.setCreationClassName(creationClassName);
	instance.setTag(computerSystemTag);

	if(discriminant=="ei")
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackage_populate(instance,errorMessage));
	result.push_back(instance);

	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalPackage& instance, const char** properties, string& errorMessage) {
	_E_;

	string tag;

	CF_assert(CF_getComputerSystemPhysicalPackageTag(tag,errorMessage));

	if(	instance.CreationClassName==creationClassName &&
		instance.Tag==tag)
	{
		CF_assert(PhysicalAsset_OpenDRIM_PhysicalPackage_populate(instance,errorMessage));
	}
	else
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackage& newInstance, const OpenDRIM_PhysicalPackage& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackage& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackage& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_IsCompatible(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackage& instance, unsigned int& returnValue, const OpenDRIM_PhysicalPackage_IsCompatible_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PhysicalAsset_OpenDRIM_PhysicalPackage_populate(OpenDRIM_PhysicalPackage& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] Tag					[KEY]
	 * [X] CreationClassName	[KEY]
	 * [X] PackageType
	 * [X] ElementName
	 * + Conditional:
	 * [X] Manufacturer
	 * [-] Model
	 * [X] SerialNumber
	 * [-] PartNumber
	 * [X] SKU
	 * + Optional:
	 * [-] VendorCompatibilityStrings
	 * [-] CanBeFRUed
	 * [-] Version
	 * [-] Name
	 * + Others:
	 * [-] OtherPackageType
	 */

	system_information system_info;
	vector<string> dmi_strings;
	string computerSystemTag;

	CF_assert(CF_getComputerSystemPhysicalPackageTag(computerSystemTag,errorMessage));

	if(instance.Tag==computerSystemTag)
	{
		instance.setPackageType(PT_CONTAINER_FRAME_SLOT);
		instance.setElementName("Computer System Physical Package");
	}

	if(SMBIOS_getSystemInformation(system_info,dmi_strings,errorMessage)!=OK)
		return FAILED;

	if(system_info.length>=0x08)
	{

		instance.setManufacturer(dmi_strings[system_info.manufacturer]);
		instance.setSerialNumber(dmi_strings[system_info.serial_number]);

		if(system_info.length>=0x1B)
		{
			instance.setSKU(dmi_strings[system_info.sku_number]);
		}
	}
	_L_;
	return OK;
}

