/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_disable_rules.h
 * @brief implementation of the disable_rules function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_DISABLE_RULES_H
#define PG_DISABLE_RULES_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"


/**
 * Disable (delete/drop) customization rule schema from a deployment.
 *
 * @param cls closure
 * @param schema name of the schema with customization rules to remove
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_disable_rules (
  void *cls,
  const char *schema);

#endif
