/*
  This file is part of TALER
  Copyright (C) 2023 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-exchange-httpd_reveal-withdraw.h
 * @brief Handle /reveal-withdraw/$ACH requests
 * @author Özgür Kesim
 */
#ifndef TALER_EXCHANGE_HTTPD_REVEAL_WITHDRAW_H
#define TALER_EXCHANGE_HTTPD_REVEAL_WITHDRAW_H

#include <microhttpd.h>
#include "taler-exchange-httpd.h"


/**
 * Handle a "/reveal-withdraw" request.
 *
 * The client got a noreveal_index in response to a previous request
 * /withdraw.  It now has to reveal all n*(kappa-1)
 * coin's private keys (except for the noreveal_index), from which all other
 * coin-relevant data (blinding, age restriction, nonce) is derived from.
 *
 * The exchange computes those values, ensures that the maximum age is
 * correctly applied, calculates the hash of the blinded envelopes, and -
 * together with the non-disclosed blinded envelopes - compares the hash of
 * the calculated withdraw commitment against the original.
 *
 * If all those checks and the used denominations turn out to be correct, the
 * exchange signs all blinded envelopes with their appropriate denomination
 * keys.
 *
 * @param rc request context
 * @param root uploaded JSON data
 * @param args not used
 * @return MHD result code
 */
MHD_RESULT
TEH_handler_reveal_withdraw (
  struct TEH_RequestContext *rc,
  const json_t *root,
  const char *const args[0]);

#endif
