/*
 *  DO NOT EDIT THIS FILE   (agdirect.h)
 *  
 *  It has been autogen-ed  Friday November  5, 1999 at 01:42:06 PM PST
 *  From the definitions    stdin
 *  and the template file   agdirect.tpl
 *
 *  copyright 1992-1999 Bruce Korb
 *
 *  AutoGen is free software.
 *  
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *  
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */
#ifndef AUTOGEN_DIRECT_H
#define AUTOGEN_DIRECT_H

typedef char* (tDirProc)( char* pzArg, char* pzScan );

typedef struct dir_table tDirTable;
struct dir_table {
    size_t      nameSize;
    tCC*        pzDirName;
    tDirProc*   pDirProc;
    int         unused;
};

/*
 *  Declare the procedures that will handle the directives
 */
static tDirProc doDir_IGNORE;
static tDirProc doDir_define;
static tDirProc doDir_else;
static tDirProc doDir_endif;
static tDirProc doDir_endshell;
static tDirProc doDir_error;
static tDirProc doDir_if;
static tDirProc doDir_ifdef;
static tDirProc doDir_ifndef;
static tDirProc doDir_include;
static tDirProc doDir_line;
static tDirProc doDir_shell;
static tDirProc doDir_undef;

/*
 *  Define the constant string names for each directive
 */
static const char zAssert[]     = "assert";
static const char zDefine[]     = "define";
static const char zElse[]       = "else";
static const char zEndif[]      = "endif";
static const char zEndshell[]   = "endshell";
static const char zError[]      = "error";
static const char zIdent[]      = "ident";
static const char zIf[]         = "if";
static const char zIfdef[]      = "ifdef";
static const char zIfndef[]     = "ifndef";
static const char zInclude[]    = "include";
static const char zLine[]       = "line";
static const char zPragma[]     = "pragma";
static const char zShell[]      = "shell";
static const char zUndef[]      = "undef";

/*
 *  Enumerate the directives
 */
typedef enum {
    DIR_ASSERT,
    DIR_DEFINE,
    DIR_ELSE,
    DIR_ENDIF,
    DIR_ENDSHELL,
    DIR_ERROR,
    DIR_IDENT,
    DIR_IF,
    DIR_IFDEF,
    DIR_IFNDEF,
    DIR_INCLUDE,
    DIR_LINE,
    DIR_PRAGMA,
    DIR_SHELL,
    DIR_UNDEF
} teDirectives;

#define DIRECTIVE_CT  15
static tDirTable dirTable[ DIRECTIVE_CT ] = {
    { sizeof( zAssert )-1,   zAssert,   doDir_IGNORE,   0 },
    { sizeof( zDefine )-1,   zDefine,   doDir_define,   0 },
    { sizeof( zElse )-1,     zElse,     doDir_else,     0 },
    { sizeof( zEndif )-1,    zEndif,    doDir_endif,    0 },
    { sizeof( zEndshell )-1, zEndshell, doDir_endshell, 0 },
    { sizeof( zError )-1,    zError,    doDir_error,    0 },
    { sizeof( zIdent )-1,    zIdent,    doDir_IGNORE,   0 },
    { sizeof( zIf )-1,       zIf,       doDir_if,       0 },
    { sizeof( zIfdef )-1,    zIfdef,    doDir_ifdef,    0 },
    { sizeof( zIfndef )-1,   zIfndef,   doDir_ifndef,   0 },
    { sizeof( zInclude )-1,  zInclude,  doDir_include,  0 },
    { sizeof( zLine )-1,     zLine,     doDir_line,     0 },
    { sizeof( zPragma )-1,   zPragma,   doDir_IGNORE,   0 },
    { sizeof( zShell )-1,    zShell,    doDir_shell,    0 },
    { sizeof( zUndef )-1,    zUndef,    doDir_undef,    0 } };

#endif /* AUTOGEN_DIRECT_H */
