% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_pfam_isotypes.R
\name{analyse_pfam_isotypes}
\alias{analyse_pfam_isotypes}
\title{Determine domain isotype}
\usage{
analyse_pfam_isotypes(pfamRes, fracCutoff = 0.1)
}
\arguments{
\item{pfamRes}{A data frame with pfam augmneted with indel and truncation info (as produced by \code{augment_pfam}).}

\item{fracCutoff}{The fraction of a protein domain that must be affected before classifying it a truncation or indel.}
}
\value{
The data.frame with the Pfam results now augmented with info about domain domain isotype
}
\description{
Determine domain isotype
}
\examples{
### Load pfam data
pfamResultFile <- system.file("extdata/pfam_results.txt", package = "pfamAnalyzeR")
pfamRes <- read_pfam(pfamResultFile)

### Augment the pfam data
pfamRes <- augment_pfam(pfamRes)

### Predict domain isotype
pfamRes <- analyse_pfam_isotypes(pfamRes)
}
