# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kusto import KustoManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKustoManagementClusterPrincipalAssignmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KustoManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cluster_principal_assignments_check_name_availability(self, resource_group):
        response = self.client.cluster_principal_assignments.check_name_availability(
            resource_group_name=resource_group.name,
            cluster_name="str",
            principal_assignment_name={"name": "str", "type": "Microsoft.Kusto/clusters/principalAssignments"},
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cluster_principal_assignments_get(self, resource_group):
        response = self.client.cluster_principal_assignments.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            principal_assignment_name="str",
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cluster_principal_assignments_begin_create_or_update(self, resource_group):
        response = self.client.cluster_principal_assignments.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            principal_assignment_name="str",
            parameters={
                "aadObjectId": "str",
                "id": "str",
                "name": "str",
                "principalId": "str",
                "principalName": "str",
                "principalType": "str",
                "provisioningState": "str",
                "role": "str",
                "tenantId": "str",
                "tenantName": "str",
                "type": "str",
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cluster_principal_assignments_begin_delete(self, resource_group):
        response = self.client.cluster_principal_assignments.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            principal_assignment_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cluster_principal_assignments_list(self, resource_group):
        response = self.client.cluster_principal_assignments.list(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
