// Copyright 2019 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.lib.starlarkbuildapi.stubs;

import com.google.devtools.build.lib.starlarkbuildapi.StarlarkAspectApi;
import com.google.devtools.build.lib.syntax.Printer;

/**
 * Stub implementation of {@link StarlarkAspectApi}. Should only be used for experimental,
 * unimplemented code paths.
 */
public final class StarlarkAspectStub implements StarlarkAspectApi {
  @Override
  public void repr(Printer printer) {
    printer.append("<unimplemented aspect>");
  }
}
