/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_global.h - declarations for global variables

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/

/* 
 * 	adapter configuartion 
 */
extern ADAPTER_CONFIG	gAdapterConfig[MAX_ADAPTER_NUM];	
extern U32 ATABaseAddr[MAX_ATA_MODULE];
extern U32 XORBaseAddr[MAX_ADAPTER_NUM];
extern U32 HostBaseAddr[MAX_ADAPTER_NUM];
/*
 *	ATA channel configuration
 */
extern CHNL_CONFIG		gChnlConfig[MAX_ATA_MODULE];
/*
 *	device configuration
 */
 
extern DEV_CONFIG	gDrvConfig[MAX_ATA_MODULE][2];
extern CAM_IDENTIFY_DATA	gIdentify_Data[MAX_ATA_MODULE][2];
extern ENCLOSURE_TYPE	gBOXConfig[MAX_ATA_MODULE];
extern ENCLOSURE_STATUS gBOXStatus[MAX_ATA_MODULE];
extern ATA_TASK	boxATATask[MAX_ATA_MODULE];
extern ATA_TASK	boxLEDATATask[MAX_ATA_MODULE];
extern ATA_TASK	InternalATATask[MAX_ATA_MODULE][2];

/*
 *	Memory management 
 */
extern PCAM_ATA_PACKET ATAPacketQueue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
extern PCAM_XOR_PACKET XORPacketQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
extern U16 ATAPacketCurrent[MAX_ADAPTER_NUM];
extern U16 XORPacketCurrent[MAX_ADAPTER_NUM];

/* sg queue */
extern PCAM_ATA_SG PCAM_ATA_SG_Queue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
extern PCAM_XOR_SG PCAM_XOR_SG_Queue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
extern U16 CAM_ATA_SG_Current[MAX_ADAPTER_NUM];
extern U16 CAM_XOR_SG_Current[MAX_ADAPTER_NUM];

/* 
 * 	packets and queues 
 */
extern U32	ATAPacketQHead[MAX_ADAPTER_NUM][MAX_ATA_CHNL];  
extern U32	ATAPacketQTail[MAX_ADAPTER_NUM][MAX_ATA_CHNL];  	
extern U8	ATAPacketQCount[MAX_ADAPTER_NUM][MAX_ATA_CHNL];  	
extern MODULE_PACKET_COUNT PacketQueueCount[MAX_ADAPTER_NUM];
extern MODULE_TIMEOUT CAMTimeoutTimes[MAX_ADAPTER_NUM];
/* 
 *	Sequences 
 */
extern SEQ_INFO	gSEQ_INFO[MAX_ADAPTER_NUM][MAX_SEQ_ID];
extern U8 SEQIDPool[MAX_ADAPTER_NUM][MAX_SEQ_ID];
extern U8 SEQIDCurrent[MAX_ADAPTER_NUM];



/* for push queued module */

/* for XOR */
extern U8	XORModuleNeedPush[MAX_ADAPTER_NUM];
extern U16 XORQueueHead[MAX_ADAPTER_NUM],XORQueueTail[MAX_ADAPTER_NUM];
extern XOR_QUEUE XorQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC+1];
extern U32 XORModuleBusy[MAX_ADAPTER_NUM];
extern U8 XORModuleSEQID[MAX_ADAPTER_NUM];
extern U32 XOR_Timeout_TimerID[MAX_ADAPTER_NUM*MAX_XOR_MODULE];
extern U8 XORModuleReceiveTask[MAX_ADAPTER_NUM];

/* for ATA */
extern U8 	ATAModuleNeedPush[MAX_ATA_MODULE];
extern U16 ATAQueueHead[MAX_ATA_MODULE];
extern U16 ATAQueueTail[MAX_ATA_MODULE];
extern ATA_QUEUE ATAQueue[MAX_ATA_MODULE][MAX_ATA_PAC+1];
extern U32 ATAModuleBusy[MAX_ATA_MODULE];
extern U8 ATAModuleSEQID[MAX_ATA_MODULE];
extern U32 ATA_Timeout_TimerID[MAX_ATA_MODULE];
extern U32 BOX_Timeout_TimerID[MAX_ATA_MODULE];
extern U8 ATAModuleReceiveTask[MAX_ATA_MODULE];

#ifdef	_MMIO_
/* for flash memory */
extern FLASH_CONFIG	gFlashConfig[MAX_ADAPTER_NUM];
extern U8 flash_model1[];
extern U8 flash_model2[];
extern U8 flash_model3[];
extern U8 flash_model4[];
extern U8 flash_model5[];
extern U8 flash_model6[];
#endif
